/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.uml.refactor;

import java.awt.GridLayout;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.acm.seguin.summary.MethodSummary;
import org.acm.seguin.summary.ParameterSummary;
import org.acm.seguin.uml.refactor.ParameterRadioButton;

class ParameterPanel
extends JPanel {
    private MethodSummary methodSummary;
    private LinkedList children;

    public ParameterPanel(MethodSummary methodSummary) {
        this.methodSummary = methodSummary;
        this.children = new LinkedList();
        ButtonGroup buttonGroup = new ButtonGroup();
        Iterator iterator = this.methodSummary.getParameters();
        int n = 0;
        while (iterator.hasNext()) {
            ParameterSummary parameterSummary = (ParameterSummary)iterator.next();
            ParameterRadioButton parameterRadioButton = new ParameterRadioButton(parameterSummary);
            this.children.add(parameterRadioButton);
            buttonGroup.add(parameterRadioButton);
            parameterRadioButton.setSelected(n == 0);
            ++n;
        }
        int n2 = n / 10 + 1;
        this.setLayout(new GridLayout(n / n2 + 1, n2));
        iterator = this.children.iterator();
        while (iterator.hasNext()) {
            this.add((JComponent)iterator.next());
        }
    }

    public ParameterSummary get() {
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            ParameterRadioButton parameterRadioButton = (ParameterRadioButton)iterator.next();
            if (!parameterRadioButton.isSelected()) continue;
            return parameterRadioButton.getParameterSummary();
        }
        return null;
    }
}

