/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.uml.refactor;

import javax.swing.JComboBox;
import javax.swing.JDialog;
import org.acm.seguin.awt.CenterDialog;
import org.acm.seguin.refactor.Refactoring;
import org.acm.seguin.refactor.RefactoringFactory;
import org.acm.seguin.refactor.type.ExtractInterfaceRefactoring;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.summary.query.GetPackageSummary;
import org.acm.seguin.uml.UMLPackage;
import org.acm.seguin.uml.refactor.ClassNameDialog;
import org.acm.seguin.uml.refactor.PackageList;

public class ExtractInterfaceDialog
extends ClassNameDialog {
    private TypeSummary[] typeArray;
    private JComboBox packageNameBox;

    public ExtractInterfaceDialog(UMLPackage uMLPackage, TypeSummary[] typeSummaryArray) {
        super(uMLPackage, 2);
        this.typeArray = typeSummaryArray;
        PackageList packageList = new PackageList();
        this.packageNameBox = packageList.add(this);
        String string = uMLPackage == null ? GetPackageSummary.query(typeSummaryArray[0]).getName() : uMLPackage.getSummary().getName();
        this.packageNameBox.setSelectedItem(string);
        this.pack();
        CenterDialog.center((JDialog)this, uMLPackage);
    }

    public String getWindowTitle() {
        return "Extract Interface";
    }

    public String getLabelText() {
        return "Interface:";
    }

    protected Refactoring createRefactoring() {
        ExtractInterfaceRefactoring extractInterfaceRefactoring = RefactoringFactory.get().extractInterface();
        String string = this.getClassName();
        if (string.indexOf(".") > 0) {
            extractInterfaceRefactoring.setInterfaceName(string);
        } else {
            String string2 = (String)this.packageNameBox.getSelectedItem();
            if (string2.indexOf("<") == -1) {
                extractInterfaceRefactoring.setInterfaceName(string2 + "." + string);
            } else {
                extractInterfaceRefactoring.setInterfaceName(string);
            }
        }
        int n = 0;
        while (n < this.typeArray.length) {
            extractInterfaceRefactoring.addImplementingClass(this.typeArray[n]);
            ++n;
        }
        return extractInterfaceRefactoring;
    }
}

