/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.uml.line;

import java.awt.LayoutManager;
import java.awt.Point;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JPanel;
import org.acm.seguin.uml.line.EndPointPanel;
import org.acm.seguin.uml.line.ScalablePanel;
import org.acm.seguin.uml.line.SegmentedLine;

public abstract class LinedPanel
extends JPanel {
    private LinkedList endPoints = new LinkedList();
    private LinkedList lineList = new LinkedList();

    public LinedPanel() {
    }

    public LinedPanel(boolean bl) {
        super(bl);
    }

    public LinedPanel(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public LinedPanel(LayoutManager layoutManager, boolean bl) {
        super(layoutManager, bl);
    }

    public abstract void hit(Point var1);

    public abstract void drag(Point var1);

    public abstract void drop();

    public void add(EndPointPanel endPointPanel) {
        this.endPoints.add(endPointPanel);
        super.add(endPointPanel);
    }

    public void add(SegmentedLine segmentedLine) {
        this.lineList.add(segmentedLine);
    }

    public void scale(double d) {
        Iterator iterator = this.endPoints.iterator();
        while (iterator.hasNext()) {
            ((EndPointPanel)iterator.next()).scale(d);
        }
        iterator = this.lineList.iterator();
        while (iterator.hasNext()) {
            ((SegmentedLine)iterator.next()).scale(d);
        }
    }

    public void shift(int n, int n2) {
        Object object;
        Iterator iterator = this.endPoints.iterator();
        while (iterator.hasNext()) {
            object = (EndPointPanel)iterator.next();
            if (!((EndPointPanel)object).isSelected()) continue;
            ((ScalablePanel)object).shift(n, n2);
        }
        iterator = this.lineList.iterator();
        while (iterator.hasNext()) {
            object = (SegmentedLine)iterator.next();
            if (!((SegmentedLine)object).isBothEndsSelected()) continue;
            ((SegmentedLine)object).shift(n, n2);
        }
        this.repaint();
    }

    public void clear() {
        this.endPoints.clear();
        this.lineList.clear();
    }

    public void deselectAll() {
        Iterator iterator = this.getEndPoints();
        while (iterator.hasNext()) {
            ((EndPointPanel)iterator.next()).setSelected(false);
        }
    }

    protected Iterator getLines() {
        return this.lineList.iterator();
    }

    protected Iterator getEndPoints() {
        return this.endPoints.iterator();
    }
}

