/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.uml;

import java.awt.Color;
import org.acm.seguin.pretty.ModifierHolder;
import org.acm.seguin.summary.FieldSummary;
import org.acm.seguin.summary.Summary;
import org.acm.seguin.summary.TypeDeclSummary;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.summary.query.GetTypeSummary;
import org.acm.seguin.uml.ISourceful;
import org.acm.seguin.uml.UMLLine;
import org.acm.seguin.uml.UMLMouseAdapter;
import org.acm.seguin.uml.UMLPackage;
import org.acm.seguin.uml.UMLType;
import org.acm.seguin.uml.line.DragPanelAdapter;

public class UMLField
extends UMLLine
implements ISourceful {
    private FieldSummary summary;
    private UMLPackage current;
    private boolean association;
    private DragPanelAdapter parentDragAdapter;
    private DragPanelAdapter fieldDragAdapter;

    public UMLField(UMLPackage uMLPackage, UMLType uMLType, FieldSummary fieldSummary, DragPanelAdapter dragPanelAdapter) {
        super(uMLType, dragPanelAdapter);
        this.summary = fieldSummary;
        this.current = uMLPackage;
        this.association = false;
        ModifierHolder modifierHolder = this.summary.getModifiers();
        this.setProtection(UMLLine.getProtectionCode(modifierHolder));
        this.setLabelText(this.summary.toString());
        this.setLabelFont(UMLLine.getProtectionFont(false, modifierHolder));
        this.setSize(this.getPreferredSize());
        this.parentDragAdapter = dragPanelAdapter;
        this.fieldDragAdapter = new DragPanelAdapter(this, uMLPackage);
        this.addMouseListener(new UMLMouseAdapter(this.current, uMLType, this));
    }

    public void setAssociation(boolean bl) {
        this.association = bl;
        if (this.association) {
            this.setLabelText(this.summary.getName());
            this.addMouseListener(this.fieldDragAdapter);
            this.addMouseMotionListener(this.fieldDragAdapter);
            this.removeMouseListener(this.parentDragAdapter);
            this.removeMouseMotionListener(this.parentDragAdapter);
            this.label.addMouseListener(this.fieldDragAdapter);
            this.label.addMouseMotionListener(this.fieldDragAdapter);
            this.label.removeMouseListener(this.parentDragAdapter);
            this.label.removeMouseMotionListener(this.parentDragAdapter);
        } else {
            this.setLabelText(this.summary.toString());
            this.addMouseListener(this.parentDragAdapter);
            this.addMouseMotionListener(this.parentDragAdapter);
            this.removeMouseListener(this.fieldDragAdapter);
            this.removeMouseMotionListener(this.fieldDragAdapter);
            this.label.addMouseListener(this.parentDragAdapter);
            this.label.addMouseMotionListener(this.parentDragAdapter);
            this.label.removeMouseListener(this.fieldDragAdapter);
            this.label.removeMouseMotionListener(this.fieldDragAdapter);
        }
        this.setSize(this.getPreferredSize());
    }

    public FieldSummary getSummary() {
        return this.summary;
    }

    public boolean isAssociation() {
        return this.association;
    }

    public boolean isConvertable() {
        TypeDeclSummary typeDeclSummary = this.summary.getTypeDecl();
        if (typeDeclSummary.isPrimitive()) {
            return false;
        }
        TypeSummary typeSummary = GetTypeSummary.query(typeDeclSummary);
        return typeSummary != null;
    }

    public TypeSummary getType() {
        TypeDeclSummary typeDeclSummary = this.summary.getTypeDecl();
        return GetTypeSummary.query(typeDeclSummary);
    }

    protected Color getDefaultBackground() {
        if (this.association) {
            return Color.lightGray;
        }
        return super.getDefaultBackground();
    }

    public Summary getSourceSummary() {
        return this.summary;
    }
}

