/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.uml;

import java.awt.Dimension;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.acm.seguin.awt.ExceptionPrinter;
import org.acm.seguin.ide.common.SummaryLoaderThread;
import org.acm.seguin.summary.FileSummary;
import org.acm.seguin.summary.PackageSummary;
import org.acm.seguin.summary.TypeDeclSummary;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.summary.query.GetTypeSummary;
import org.acm.seguin.uml.UMLField;
import org.acm.seguin.uml.UMLPackage;
import org.acm.seguin.uml.UMLType;
import org.acm.seguin.uml.line.AssociationRelationship;
import org.acm.seguin.uml.line.ImplementsRelationship;
import org.acm.seguin.uml.line.InheretenceRelationship;
import org.acm.seguin.uml.line.SegmentedLine;

class PackageLoader
extends Thread {
    private UMLPackage packagePanel;
    private int defaultX;
    private int defaultY;
    private boolean loaded;
    private String filename;
    private PackageSummary loadSummary;
    private File loadFile;
    private InputStream loadStream;
    static /* synthetic */ Class class$org$acm$seguin$uml$PackageLoader;

    public PackageLoader(UMLPackage uMLPackage) {
        this.packagePanel = uMLPackage;
        this.defaultX = 20;
        this.defaultY = 20;
        this.loaded = false;
    }

    public void run() {
        SummaryLoaderThread.waitForLoading();
        Class clazz = class$org$acm$seguin$uml$PackageLoader == null ? (class$org$acm$seguin$uml$PackageLoader = PackageLoader.class$("org.acm.seguin.uml.PackageLoader")) : class$org$acm$seguin$uml$PackageLoader;
        synchronized (clazz) {
            this.packagePanel.setLoading(true);
            this.packagePanel.clear();
            if (this.loadSummary != null) {
                this.load(this.loadSummary);
            }
            if (this.loadFile != null) {
                this.load(this.loadFile);
            }
            if (this.loadStream != null) {
                this.load(this.loadStream);
            }
            this.packagePanel.updateClassListPanel();
            this.packagePanel.setLoading(false);
            this.packagePanel.repaint();
        }
    }

    public void start(PackageSummary packageSummary) {
        this.loadSummary = packageSummary;
        this.loadStream = null;
        this.loadFile = null;
        super.start();
    }

    public void start(String string) {
        this.loadSummary = null;
        this.loadStream = null;
        this.loadFile = new File(string);
        super.start();
    }

    public void start(InputStream inputStream) {
        this.loadSummary = null;
        this.loadStream = inputStream;
        this.loadFile = null;
        super.start();
    }

    File getFile() {
        File file;
        PackageSummary packageSummary = this.packagePanel.getSummary();
        File file2 = packageSummary.getDirectory();
        if (file2 == null) {
            file2 = new File(System.getProperty("user.home") + File.separator + ".Refactory" + File.separator + "UML");
            file2.mkdirs();
            file = new File(file2, packageSummary.getName() + ".uml");
        } else {
            file = new File(packageSummary.getDirectory(), "package.uml");
        }
        return file;
    }

    private UMLType getUMLType(TypeDeclSummary typeDeclSummary) {
        TypeSummary typeSummary;
        if (typeDeclSummary != null && (typeSummary = GetTypeSummary.query(typeDeclSummary)) != null) {
            UMLType uMLType = this.packagePanel.findType(typeSummary);
            if (uMLType == null) {
                uMLType = this.addType(typeSummary, true);
            }
            return uMLType;
        }
        return null;
    }

    private Point getLocation(UMLType uMLType, TypeSummary typeSummary) {
        Dimension dimension = uMLType.getPreferredSize();
        Point point = new Point(this.defaultX, this.defaultY);
        this.defaultX += 20 + dimension.width;
        return point;
    }

    private void load(PackageSummary packageSummary) {
        if (packageSummary != null) {
            this.defaultPositions(packageSummary);
        }
        this.loadPositions(this.getFile());
    }

    private void load(File file) {
        this.loadPositions(file);
    }

    private void load(InputStream inputStream) {
        this.loadPositions(inputStream);
    }

    private void defaultPositions(PackageSummary packageSummary) {
        Iterator iterator = packageSummary.getFileSummaries();
        if (iterator != null) {
            while (iterator.hasNext()) {
                this.addFile((FileSummary)iterator.next());
            }
        }
        this.loadInheretence();
        this.loadImplements();
        this.loaded = true;
    }

    private void addFile(FileSummary fileSummary) {
        Iterator iterator = fileSummary.getTypes();
        if (iterator != null) {
            while (iterator.hasNext()) {
                this.addType((TypeSummary)iterator.next(), false);
            }
        }
    }

    private UMLType addType(TypeSummary typeSummary, boolean bl) {
        UMLType uMLType = new UMLType(this.packagePanel, typeSummary, bl);
        this.packagePanel.add(uMLType);
        uMLType.setLocation(this.getLocation(uMLType, typeSummary));
        return uMLType;
    }

    private void loadInheretence() {
        UMLType[] uMLTypeArray = this.packagePanel.getTypes();
        int n = 0;
        while (n < uMLTypeArray.length) {
            TypeSummary typeSummary = uMLTypeArray[n].getSummary();
            TypeDeclSummary typeDeclSummary = typeSummary.getParentClass();
            UMLType uMLType = this.getUMLType(typeDeclSummary);
            if (uMLType != null) {
                this.packagePanel.add(new InheretenceRelationship(uMLTypeArray[n], uMLType));
            }
            ++n;
        }
    }

    private void loadImplements() {
        UMLType[] uMLTypeArray = this.packagePanel.getTypes();
        int n = 0;
        while (n < uMLTypeArray.length) {
            TypeSummary typeSummary;
            Iterator iterator;
            if (!uMLTypeArray[n].isForeign() && (iterator = (typeSummary = uMLTypeArray[n].getSummary()).getImplementedInterfaces()) != null) {
                while (iterator.hasNext()) {
                    TypeDeclSummary typeDeclSummary = (TypeDeclSummary)iterator.next();
                    UMLType uMLType = this.getUMLType(typeDeclSummary);
                    if (uMLType == null) continue;
                    SegmentedLine segmentedLine = typeSummary.isInterface() ? new InheretenceRelationship(uMLTypeArray[n], uMLType) : new ImplementsRelationship(uMLTypeArray[n], uMLType);
                    this.packagePanel.add(segmentedLine);
                }
            }
            ++n;
        }
    }

    private void loadPositions(File file) {
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            this.loadPositions(bufferedReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            ExceptionPrinter.print(iOException, false);
        }
    }

    private void loadPositions(InputStream inputStream) {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            this.loadPositions(bufferedReader);
            bufferedReader.close();
            inputStreamReader.close();
        }
        catch (IOException iOException) {
            ExceptionPrinter.print(iOException, false);
        }
    }

    private void loadPositions(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        while (string != null) {
            char c = string.charAt(0);
            if (c == 'P') {
                this.positionPanel(string);
            } else if (c == 'S') {
                this.positionLine(string);
            } else if (c == 'A') {
                this.positionAttribute(string);
            } else if (c == 'V') {
                this.loadVersion(string);
            }
            string = bufferedReader.readLine();
        }
    }

    private void positionPanel(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "[]{},\n");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        UMLType uMLType = this.packagePanel.find(string3);
        if (uMLType == null) {
            return;
        }
        Point point = uMLType.getLocation();
        int n = point.x;
        int n2 = point.y;
        try {
            n = Integer.parseInt(string4);
            n2 = Integer.parseInt(string5);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        uMLType.setLocation(n, n2);
    }

    private void positionLine(String string) {
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "[]{}\n");
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        stringTokenizer = new StringTokenizer(string4, ",");
        String string6 = stringTokenizer.nextToken();
        SegmentedLine segmentedLine = this.packagePanel.find(string6, string2 = stringTokenizer.nextToken());
        if (segmentedLine != null) {
            segmentedLine.load(string5);
        }
    }

    private void positionAttribute(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "[]{}\n");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        stringTokenizer = new StringTokenizer(string3, ",");
        String string6 = stringTokenizer.nextToken();
        String string7 = stringTokenizer.nextToken();
        UMLType uMLType = this.packagePanel.find(string6);
        if (uMLType == null) {
            return;
        }
        UMLField uMLField = uMLType.getField(string7);
        if (uMLField == null) {
            return;
        }
        uMLField.setAssociation(true);
        AssociationRelationship associationRelationship = uMLType.convertToAssociation(this.packagePanel, uMLField);
        associationRelationship.load(string4);
        stringTokenizer = new StringTokenizer(string5, ",");
        String string8 = stringTokenizer.nextToken();
        String string9 = stringTokenizer.nextToken();
        try {
            uMLField.setLocation(Integer.parseInt(string8), Integer.parseInt(string9));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void loadVersion(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "[]:\n");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        String string4 = "";
        if (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
        }
        System.out.println("Loading:  " + string4 + " from a file with version " + string3);
        if (!this.loaded) {
            PackageSummary packageSummary = PackageSummary.getPackageSummary(string4);
            this.packagePanel.setSummary(packageSummary);
            this.defaultPositions(packageSummary);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

