/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.tools.install;

import java.awt.Font;
import java.awt.GridLayout;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.acm.seguin.util.FileSettings;
import org.acm.seguin.util.MissingSettingsException;

public abstract class SettingPanel
extends JPanel {
    private LinkedList descriptions = new LinkedList();
    private GridLayout gridLayout = new GridLayout(1, 1);
    private int items;
    protected static FileSettings bundle = null;
    protected static Font teletype = null;

    public SettingPanel() {
        this.setLayout(this.gridLayout);
        this.items = 0;
    }

    public abstract String getKey();

    public String getValue() {
        return this.getDefaultValue();
    }

    public String getDefaultValue() {
        if (bundle == null) {
            SettingPanel.init();
        }
        try {
            return bundle.getString(this.getKey());
        }
        catch (MissingSettingsException missingSettingsException) {
            return this.getInitialValue();
        }
    }

    public void addDescription(String string) {
        this.addDescription(string, true);
    }

    public void addCodeDescription(String string) {
        this.addCodeDescription(string, true);
    }

    public void generateSetting(PrintWriter printWriter) {
        this.printDescription(printWriter);
        printWriter.println(this.getKey() + "=" + this.getValue());
        printWriter.println("");
    }

    protected abstract String getInitialValue();

    protected void addDescription(String string, boolean bl) {
        this.descriptions.add(string);
        if (bl) {
            this.addLabel(string);
        }
    }

    protected void addCodeDescription(String string, boolean bl) {
        this.descriptions.add(string);
        if (bl) {
            this.addCodeLabel(string);
        }
    }

    protected void incrItems() {
        ++this.items;
        this.gridLayout.setRows(this.items);
    }

    protected void printDescription(PrintWriter printWriter) {
        Iterator iterator = this.descriptions.iterator();
        while (iterator.hasNext()) {
            printWriter.println("# " + iterator.next());
        }
    }

    protected void addLabel(String string) {
        ++this.items;
        this.gridLayout.setColumns(this.items);
        this.add(new JLabel(string));
    }

    protected void addCodeLabel(String string) {
        ++this.items;
        this.gridLayout.setColumns(this.items);
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(teletype);
        this.add(jLabel);
    }

    private static synchronized void init() {
        if (bundle == null) {
            bundle = FileSettings.getSettings("Refactory", "pretty");
            teletype = new Font("monospaced", 0, 12);
        }
    }

    public abstract void reload();
}

