/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.tools.build;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.LinkedList;
import org.acm.seguin.io.DirectoryTreeTraversal;

public class CleanClassFiles
extends DirectoryTreeTraversal {
    private LinkedList directoryList = new LinkedList();
    private PrintWriter output;

    public CleanClassFiles(String string, PrintWriter printWriter) {
        super(string);
        this.output = printWriter;
    }

    protected boolean isTarget(File file) {
        return file.getName().endsWith(".java");
    }

    protected void visit(File file) {
        String string = file.getParent();
        if (!this.directoryList.contains(string)) {
            this.directoryList.add(string);
            this.output.println("del " + string + File.separator + "*.class");
        }
    }

    public static void main(String[] stringArray) {
        String string = System.getProperty("user.dir");
        PrintWriter printWriter = null;
        try {
            printWriter = stringArray.length > 0 ? new PrintWriter(new FileWriter(stringArray[0])) : new PrintWriter(new OutputStreamWriter(System.out));
        }
        catch (IOException iOException) {
            System.out.println("Unable to create the output file:  " + stringArray[0]);
            return;
        }
        if (stringArray.length > 1) {
            string = stringArray[1];
        }
        new CleanClassFiles(string, printWriter).go();
        printWriter.flush();
        printWriter.close();
    }
}

