/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.summary.query;

import java.util.Iterator;
import org.acm.seguin.pretty.ModifierHolder;
import org.acm.seguin.summary.MethodSummary;
import org.acm.seguin.summary.TypeDeclSummary;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.summary.query.GetTypeSummary;

public class MethodQuery {
    public static final int PRIVATE = 1;
    public static final int DEFAULT = 2;
    public static final int PROTECTED = 3;
    public static final int PUBLIC = 4;

    public static MethodSummary find(TypeSummary typeSummary, String string) {
        MethodSummary methodSummary = MethodQuery.query(typeSummary, string, 1);
        if (methodSummary == null) {
            methodSummary = MethodQuery.queryAncestors(typeSummary, string, 3);
        }
        return methodSummary;
    }

    public static MethodSummary query(TypeSummary typeSummary, String string, int n) {
        Iterator iterator = typeSummary.getMethods();
        if (iterator != null) {
            while (iterator.hasNext()) {
                MethodSummary methodSummary = (MethodSummary)iterator.next();
                if (!MethodQuery.appropriate(methodSummary, string, n)) continue;
                return methodSummary;
            }
        }
        return null;
    }

    public static MethodSummary queryAncestors(TypeSummary typeSummary, String string, int n) {
        TypeDeclSummary typeDeclSummary = typeSummary.getParentClass();
        TypeSummary typeSummary2 = GetTypeSummary.query(typeDeclSummary);
        while (typeSummary2 != null) {
            MethodSummary methodSummary = MethodQuery.query(typeSummary2, string, n);
            if (methodSummary != null) {
                return methodSummary;
            }
            typeDeclSummary = typeSummary2.getParentClass();
            typeSummary2 = GetTypeSummary.query(typeDeclSummary);
        }
        return null;
    }

    private static boolean appropriate(MethodSummary methodSummary, String string, int n) {
        if (methodSummary.getName().equals(string)) {
            ModifierHolder modifierHolder = methodSummary.getModifiers();
            if (n == 1) {
                return true;
            }
            if (n == 2 && !modifierHolder.isPrivate()) {
                return true;
            }
            if (n == 3 && (modifierHolder.isPublic() || modifierHolder.isProtected())) {
                return true;
            }
            if (n == 4 && modifierHolder.isPublic()) {
                return true;
            }
        }
        return false;
    }
}

