/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.summary;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.acm.seguin.io.DirectoryTreeTraversal;
import org.acm.seguin.summary.FileSummary;
import org.acm.seguin.summary.FrameworkFileSummaryLoader;
import org.acm.seguin.summary.FrameworkLoader;
import org.acm.seguin.summary.PackageSummary;
import org.acm.seguin.summary.PrintVisitor;
import org.acm.seguin.summary.load.LoadStatus;
import org.acm.seguin.summary.load.SwingLoadStatus;
import org.acm.seguin.util.FileSettings;
import org.acm.seguin.util.MissingSettingsException;

public class SummaryTraversal
extends DirectoryTreeTraversal {
    private String root;
    private String blockDirectories;
    private LoadStatus status;
    private static FrameworkLoader framework = null;
    private boolean useFramework;

    public SummaryTraversal(String string) {
        this(string, new SwingLoadStatus());
    }

    public SummaryTraversal(String string, LoadStatus loadStatus) {
        this(string, loadStatus, true);
    }

    public SummaryTraversal(String string, LoadStatus loadStatus, boolean bl) {
        super(string);
        this.root = string;
        this.status = loadStatus;
        this.useFramework = bl;
        if (bl && framework == null) {
            framework = new FrameworkFileSummaryLoader(this.status);
        }
        try {
            FileSettings fileSettings = FileSettings.getSettings("Refactory", "uml");
            fileSettings.setContinuallyReload(true);
            this.blockDirectories = fileSettings.getString("skip.dir");
            if (this.blockDirectories == null) {
                this.blockDirectories = "";
            } else {
                this.blockDirectories = this.blockDirectories.trim();
                if (this.blockDirectories == null) {
                    this.blockDirectories = "";
                }
            }
        }
        catch (MissingSettingsException missingSettingsException) {
            this.blockDirectories = "";
        }
    }

    public void go() {
        if (this.useFramework) {
            framework.run();
        }
        File file = new File(this.root);
        String string = null;
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = file.getPath();
        }
        this.status.setRoot(string);
        FileSummary.removeDeletedSummaries();
        super.go();
        this.status.done();
    }

    protected boolean isTarget(File file) {
        int n;
        String string = file.getName();
        int n2 = string.indexOf(".");
        return n2 == (n = string.indexOf(".java")) && string.endsWith(".java");
    }

    protected boolean isAllowed(File file) {
        if (this.blockDirectories == null || this.blockDirectories.length() == 0) {
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.blockDirectories, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (file.getName().indexOf(string) < 0) continue;
            return false;
        }
        return true;
    }

    protected void visit(File file) {
        try {
            this.status.setCurrentFile(file.getPath());
            FileSummary.getFileSummary(file);
            Thread.currentThread();
            Thread.yield();
        }
        catch (Throwable throwable) {
            System.out.println("\nError loading:  " + file.getName());
            throwable.printStackTrace(System.out);
        }
    }

    public static void setFrameworkLoader(FrameworkLoader frameworkLoader) {
        framework = frameworkLoader;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            new SummaryTraversal(System.getProperty("user.dir")).go();
        } else {
            new SummaryTraversal(stringArray[0]).go();
        }
        SummaryTraversal.debug();
        System.exit(0);
    }

    public static void debug() {
        PrintVisitor printVisitor = new PrintVisitor();
        Iterator iterator = PackageSummary.getAllPackages();
        while (iterator.hasNext()) {
            PackageSummary packageSummary = (PackageSummary)iterator.next();
            packageSummary.accept(printVisitor, "");
        }
    }
}

