/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.summary;

import java.io.File;
import java.util.Stack;
import org.acm.seguin.summary.FileSummary;
import org.acm.seguin.summary.PackageSummary;
import org.acm.seguin.summary.Summary;

public class SummaryLoaderState {
    private Stack stack = new Stack();
    private File file = null;
    private int code = 0;
    public static final int INITIALIZE = 0;
    public static final int LOAD_FILE = 1;
    public static final int LOAD_TYPE = 2;
    public static final int LOAD_CLASSBODY = 3;
    public static final int LOAD_INTERFACE_LIST = 4;
    public static final int LOAD_EXCEPTIONS = 5;
    public static final int LOAD_PARAMETERS = 6;
    public static final int LOAD_METHODBODY = 7;
    public static final int IGNORE = 100;

    public void setFile(File file) {
        this.file = file;
    }

    public void setCode(int n) {
        this.code = n;
    }

    public Summary getCurrentSummary() {
        if (this.code == 0) {
            PackageSummary packageSummary = PackageSummary.getPackageSummary("");
            this.startSummary(new FileSummary(packageSummary, this.getFile()));
            this.code = 1;
        }
        return (Summary)this.stack.peek();
    }

    public File getFile() {
        return this.file;
    }

    public int getCode() {
        return this.code;
    }

    public void startSummary(Summary summary) {
        this.stack.push(summary);
    }

    public void finishSummary() {
        this.stack.pop();
    }
}

