/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor.type;

import java.io.File;
import org.acm.seguin.parser.ast.ASTName;
import org.acm.seguin.refactor.AddImportTransform;
import org.acm.seguin.refactor.ComplexTransform;
import org.acm.seguin.refactor.type.RenameClassVisitor;
import org.acm.seguin.refactor.type.RenameTypeTransform;
import org.acm.seguin.summary.FileSummary;
import org.acm.seguin.summary.PackageSummary;
import org.acm.seguin.summary.Summary;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.summary.query.GetTypeSummary;

public class RemoveClassVisitor
extends RenameClassVisitor {
    private String parentPackage;
    private String oldPackage;

    public RemoveClassVisitor(String string, String string2, String string3, String string4, File file, ComplexTransform complexTransform) {
        super(string, string2, string4, file, complexTransform);
        this.parentPackage = string3;
        this.oldPackage = string;
    }

    protected AddImportTransform getNewImports(FileSummary fileSummary, String string) {
        if (this.newClassName.equals("Object")) {
            return null;
        }
        if (GetTypeSummary.query(fileSummary, this.newClassName) == null) {
            return new AddImportTransform(this.parentPackage, this.newClassName);
        }
        return null;
    }

    protected ASTName getNewName() {
        if (this.newClassName.equals("Object")) {
            ASTName aSTName = new ASTName(0);
            aSTName.addNamePart(this.newClassName);
            return aSTName;
        }
        if (this.oldPackage.equals(this.parentPackage)) {
            return super.getNewName();
        }
        ASTName aSTName = new ASTName(0);
        aSTName.fromString(this.parentPackage);
        aSTName.addNamePart(this.newClassName);
        return aSTName;
    }

    protected void alreadyImportsType(ComplexTransform complexTransform, ASTName aSTName, FileSummary fileSummary, TypeSummary typeSummary) {
        if (this.isSamePackage(fileSummary, typeSummary) || this.isParent(typeSummary)) {
            ASTName aSTName2 = new ASTName(0);
            aSTName2.addNamePart(this.newClassName);
            complexTransform.add(new RenameTypeTransform(aSTName, aSTName2, null));
        } else {
            complexTransform.add(new RenameTypeTransform(aSTName, this.getNewName(), null));
        }
    }

    private boolean isSamePackage(FileSummary fileSummary, TypeSummary typeSummary) {
        Summary summary = fileSummary;
        Summary summary2 = typeSummary;
        while (!(summary instanceof PackageSummary)) {
            summary = summary.getParent();
        }
        while (!(summary2 instanceof PackageSummary)) {
            summary2 = summary2.getParent();
        }
        return summary.equals(summary2);
    }

    private boolean isParent(TypeSummary typeSummary) {
        Summary summary = typeSummary;
        while (!(summary instanceof PackageSummary)) {
            summary = summary.getParent();
        }
        PackageSummary packageSummary = (PackageSummary)summary;
        String string = packageSummary.getName();
        return string.equals(this.parentPackage);
    }
}

