/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor.method;

import java.util.Iterator;
import org.acm.seguin.parser.ast.ASTArgumentList;
import org.acm.seguin.parser.ast.ASTArguments;
import org.acm.seguin.parser.ast.ASTClassBodyDeclaration;
import org.acm.seguin.parser.ast.ASTClassDeclaration;
import org.acm.seguin.parser.ast.ASTConstructorDeclaration;
import org.acm.seguin.parser.ast.ASTExplicitConstructorInvocation;
import org.acm.seguin.parser.ast.ASTFormalParameter;
import org.acm.seguin.parser.ast.ASTFormalParameters;
import org.acm.seguin.parser.ast.ASTName;
import org.acm.seguin.parser.ast.ASTNameList;
import org.acm.seguin.parser.ast.ASTPrimitiveType;
import org.acm.seguin.parser.ast.ASTResultType;
import org.acm.seguin.parser.ast.ASTType;
import org.acm.seguin.parser.ast.ASTTypeDeclaration;
import org.acm.seguin.parser.ast.ASTVariableDeclaratorId;
import org.acm.seguin.parser.ast.SimpleNode;
import org.acm.seguin.parser.build.BuildExpression;
import org.acm.seguin.pretty.ModifierHolder;
import org.acm.seguin.refactor.TransformAST;
import org.acm.seguin.summary.MethodSummary;
import org.acm.seguin.summary.ParameterSummary;
import org.acm.seguin.summary.TypeDeclSummary;

public class AddConstructor
extends TransformAST {
    protected MethodSummary methodSummary;
    private String typeName;

    public AddConstructor(MethodSummary methodSummary, String string) {
        this.methodSummary = methodSummary;
        this.typeName = string;
    }

    public void update(SimpleNode simpleNode) {
        int n = simpleNode.jjtGetNumChildren();
        int n2 = 0;
        while (n2 < n) {
            if (simpleNode.jjtGetChild(n2) instanceof ASTTypeDeclaration) {
                this.drillIntoType((SimpleNode)simpleNode.jjtGetChild(n2));
                return;
            }
            ++n2;
        }
    }

    protected void setupModifiers(ModifierHolder modifierHolder, ModifierHolder modifierHolder2) {
        modifierHolder2.copy(modifierHolder);
    }

    protected boolean isAbstract() {
        return this.methodSummary.getModifiers().isAbstract();
    }

    protected void addReturn(SimpleNode simpleNode, int n) {
        ASTResultType aSTResultType = new ASTResultType(0);
        TypeDeclSummary typeDeclSummary = this.methodSummary.getReturnType();
        if (typeDeclSummary != null && !typeDeclSummary.getType().equals("void")) {
            ASTType aSTType = this.buildType(typeDeclSummary);
            aSTResultType.jjtAddChild(aSTType, 0);
        }
        simpleNode.jjtAddChild(aSTResultType, n);
    }

    protected ASTFormalParameters createParameters() {
        ASTFormalParameters aSTFormalParameters = new ASTFormalParameters(0);
        Iterator iterator = this.methodSummary.getParameters();
        if (iterator != null) {
            int n = 0;
            while (iterator.hasNext()) {
                ParameterSummary parameterSummary = (ParameterSummary)iterator.next();
                ASTFormalParameter aSTFormalParameter = new ASTFormalParameter(0);
                ASTType aSTType = this.buildType(parameterSummary.getTypeDecl());
                aSTFormalParameter.jjtAddChild(aSTType, 0);
                ASTVariableDeclaratorId aSTVariableDeclaratorId = new ASTVariableDeclaratorId(0);
                aSTVariableDeclaratorId.setName(parameterSummary.getName());
                aSTFormalParameter.jjtAddChild(aSTVariableDeclaratorId, 1);
                aSTFormalParameters.jjtAddChild(aSTFormalParameter, n);
                ++n;
            }
        }
        return aSTFormalParameters;
    }

    protected ASTNameList createExceptions(Iterator iterator) {
        ASTNameList aSTNameList = new ASTNameList(0);
        int n = 0;
        while (iterator.hasNext()) {
            TypeDeclSummary typeDeclSummary = (TypeDeclSummary)iterator.next();
            aSTNameList.jjtAddChild(this.buildName(typeDeclSummary), n);
            ++n;
        }
        return aSTNameList;
    }

    protected int addExceptions(SimpleNode simpleNode, int n) {
        Iterator iterator = this.methodSummary.getExceptions();
        if (iterator != null) {
            ASTNameList aSTNameList = this.createExceptions(iterator);
            simpleNode.jjtAddChild(aSTNameList, n);
            ++n;
        }
        return n;
    }

    protected void addBody(SimpleNode simpleNode, int n) {
        ASTExplicitConstructorInvocation aSTExplicitConstructorInvocation = new ASTExplicitConstructorInvocation(0);
        aSTExplicitConstructorInvocation.setName("super");
        ASTArguments aSTArguments = new ASTArguments(0);
        aSTExplicitConstructorInvocation.jjtAddChild(aSTArguments, 0);
        ASTArgumentList aSTArgumentList = new ASTArgumentList(0);
        aSTArguments.jjtAddChild(aSTArgumentList, 0);
        Iterator iterator = this.methodSummary.getParameters();
        int n2 = 0;
        if (iterator != null) {
            BuildExpression buildExpression = new BuildExpression();
            while (iterator.hasNext()) {
                ParameterSummary parameterSummary = (ParameterSummary)iterator.next();
                aSTArgumentList.jjtAddChild(buildExpression.buildName(parameterSummary.getName()), n2);
                ++n2;
            }
        }
        simpleNode.jjtAddChild(aSTExplicitConstructorInvocation, n);
    }

    private void drillIntoType(SimpleNode simpleNode) {
        ASTClassDeclaration aSTClassDeclaration = (ASTClassDeclaration)simpleNode.jjtGetChild(0);
        if (this.isAbstract()) {
            aSTClassDeclaration.addModifier("abstract");
        }
        SimpleNode simpleNode2 = (SimpleNode)aSTClassDeclaration.jjtGetChild(0);
        SimpleNode simpleNode3 = (SimpleNode)simpleNode2.jjtGetChild(simpleNode2.jjtGetNumChildren() - 1);
        ASTClassBodyDeclaration aSTClassBodyDeclaration = new ASTClassBodyDeclaration(0);
        aSTClassBodyDeclaration.jjtAddChild(this.build(), 0);
        simpleNode3.jjtAddChild(aSTClassBodyDeclaration, simpleNode3.jjtGetNumChildren());
    }

    private ASTConstructorDeclaration build() {
        ASTConstructorDeclaration aSTConstructorDeclaration = new ASTConstructorDeclaration(0);
        this.setupModifiers(this.methodSummary.getModifiers(), aSTConstructorDeclaration.getModifiers());
        aSTConstructorDeclaration.setName(this.typeName);
        ASTFormalParameters aSTFormalParameters = this.createParameters();
        aSTConstructorDeclaration.jjtAddChild(aSTFormalParameters, 0);
        int n = 1;
        n = this.addExceptions(aSTConstructorDeclaration, n);
        this.addBody(aSTConstructorDeclaration, n);
        return aSTConstructorDeclaration;
    }

    private ASTType buildType(TypeDeclSummary typeDeclSummary) {
        ASTType aSTType = new ASTType(0);
        if (typeDeclSummary.isPrimitive()) {
            ASTPrimitiveType aSTPrimitiveType = new ASTPrimitiveType(0);
            aSTPrimitiveType.setName(typeDeclSummary.getLongName());
            aSTType.jjtAddChild(aSTPrimitiveType, 0);
        } else {
            ASTName aSTName = this.buildName(typeDeclSummary);
            aSTType.jjtAddChild(aSTName, 0);
        }
        aSTType.setArrayCount(typeDeclSummary.getArrayCount());
        return aSTType;
    }

    private ASTName buildName(TypeDeclSummary typeDeclSummary) {
        ASTName aSTName = new ASTName(0);
        aSTName.fromString(typeDeclSummary.getLongName());
        return aSTName;
    }
}

