/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.refactor.field;

import org.acm.seguin.refactor.ComplexTransform;
import org.acm.seguin.summary.FieldSummary;
import org.acm.seguin.summary.PackageSummary;
import org.acm.seguin.summary.Summary;
import org.acm.seguin.summary.TypeSummary;
import org.acm.seguin.summary.query.Ancestor;

class RenameFieldData {
    private String oldName;
    private String newName;
    private boolean thisRequired;
    private Summary current;
    private boolean mustInsertThis;
    private TypeSummary typeSummary;
    private boolean canBeFirst;
    private boolean canBeThis;
    private FieldSummary oldField;
    private ComplexTransform transform;
    private String fullName;
    private String importedName;

    public RenameFieldData(FieldSummary fieldSummary, String string) {
        this.oldName = fieldSummary.getName();
        this.newName = string;
        this.oldField = fieldSummary;
        this.thisRequired = false;
        this.canBeFirst = false;
        this.canBeThis = false;
        this.mustInsertThis = false;
        this.current = null;
        this.typeSummary = (TypeSummary)fieldSummary.getParent();
        this.initNames(fieldSummary);
    }

    public RenameFieldData(FieldSummary fieldSummary, String string, ComplexTransform complexTransform) {
        this.newName = string;
        this.oldField = fieldSummary;
        this.transform = complexTransform;
        this.oldName = fieldSummary.getName();
        this.typeSummary = (TypeSummary)fieldSummary.getParent();
    }

    public void setThisRequired(boolean bl) {
        this.thisRequired = bl;
    }

    public void setCurrentSummary(Summary summary) {
        this.current = summary;
        if (this.current instanceof TypeSummary) {
            this.check((TypeSummary)this.current);
        }
    }

    public void setMustInsertThis(boolean bl) {
        this.mustInsertThis = bl;
    }

    public String getOldName() {
        return this.oldName;
    }

    public String getNewName() {
        return this.newName;
    }

    public boolean isThisRequired() {
        return this.thisRequired;
    }

    public Summary getCurrentSummary() {
        return this.current;
    }

    public boolean isMustInsertThis() {
        return this.mustInsertThis;
    }

    public TypeSummary getTypeSummary() {
        return this.typeSummary;
    }

    public boolean isAllowedToChangeFirst() {
        return this.canBeFirst;
    }

    public boolean isAllowedToChangeThis() {
        return this.canBeThis;
    }

    public FieldSummary getOldField() {
        return this.oldField;
    }

    public ComplexTransform getComplexTransform() {
        return this.transform;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getImportedName() {
        return this.importedName;
    }

    private void check(TypeSummary typeSummary) {
        if (typeSummary == this.typeSummary || Ancestor.query(typeSummary, this.typeSummary)) {
            this.canBeFirst = true;
            this.canBeThis = true;
            return;
        }
        Summary summary = typeSummary;
        while (summary != null) {
            if (summary == this.typeSummary) {
                this.canBeThis = false;
                this.canBeFirst = true;
                return;
            }
            summary = summary.getParent();
        }
        this.canBeThis = false;
        this.canBeFirst = false;
    }

    private void initNames(FieldSummary fieldSummary) {
        StringBuffer stringBuffer = new StringBuffer(fieldSummary.getName());
        Summary summary = fieldSummary;
        while (summary != null) {
            if (summary instanceof TypeSummary) {
                stringBuffer.insert(0, ".");
                stringBuffer.insert(0, summary.getName());
            }
            if (summary instanceof PackageSummary) {
                this.importedName = stringBuffer.toString();
                stringBuffer.insert(0, ".");
                stringBuffer.insert(0, summary.getName());
                this.fullName = stringBuffer.toString();
                return;
            }
            summary = summary.getParent();
        }
        this.importedName = stringBuffer.toString();
        this.fullName = stringBuffer.toString();
    }
}

