/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.print.xml;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public abstract class State {
    protected Font font = null;
    protected Color color = Color.black;
    private Graphics g;
    private int x;
    private int y;
    private int fontSize = -1;

    public void setFontSize(int n) {
        if (n != this.fontSize) {
            this.fontSize = n;
            this.font = null;
        }
    }

    public void setGraphics(Graphics graphics) {
        this.g = graphics;
    }

    public void setX(int n) {
        this.x = n;
    }

    public void setY(int n) {
        this.y = n;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public abstract Font getFont();

    public Graphics getGraphics() {
        return this.g;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public State processLine(String string) {
        return this.processLine(string, 0, new StringBuffer());
    }

    protected abstract State processLine(String var1, int var2, StringBuffer var3);

    protected void initState(State state) {
        state.setGraphics(this.getGraphics());
        state.setX(this.getX());
        state.setY(this.getY());
        state.setFontSize(this.getFontSize());
    }

    protected void print(StringBuffer stringBuffer) {
        String string = stringBuffer.toString();
        if (string.length() == 0) {
            return;
        }
        this.g.setFont(this.getFont());
        this.g.setColor(this.color);
        this.g.drawString(string, this.x, this.y);
        FontMetrics fontMetrics = this.g.getFontMetrics();
        this.x += fontMetrics.stringWidth(string);
    }
}

