/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.pretty;

import org.acm.seguin.parser.Token;
import org.acm.seguin.pretty.JavadocTokenizer;
import org.acm.seguin.pretty.PrintData;

public class JavadocDescriptionPrinter {
    private PrintData printData;
    private StringBuffer buffer;
    private int indent;
    private int mode;
    private boolean newline;
    private int owedLines;
    private static int NORMAL = 0;
    private static int PARA = 1;
    private static int LIST = 2;
    private static int END_LIST = 3;
    private static int TABLE = 4;
    private static int END_TAG = 5;
    private static int LINE_BREAK = 6;
    private static int PREFORMATTED = 7;

    public JavadocDescriptionPrinter(PrintData printData, String string) {
        this.printData = printData;
        this.buffer = new StringBuffer(string);
        this.indent = this.printData.getJavadocIndent();
        this.newline = false;
        this.mode = NORMAL;
    }

    public JavadocDescriptionPrinter(PrintData printData, String string, int n) {
        this.printData = printData;
        this.buffer = new StringBuffer(string);
        this.indent = n;
    }

    public void run() {
        if (this.printData.isReformatComments()) {
            int n = this.printData.getJavadocWordWrapMinimum();
            int n2 = this.printData.getJavadocWordWrapMaximum();
            JavadocTokenizer javadocTokenizer = new JavadocTokenizer(this.buffer.toString());
            this.mode = NORMAL;
            boolean bl = true;
            while (javadocTokenizer.hasNext()) {
                Token token = javadocTokenizer.next();
                bl = this.printToken(token, n, n2, bl);
            }
        } else {
            this.maintainCurrentFormat();
        }
    }

    protected void indent() {
        if (this.printData.isCurrentSingle()) {
            return;
        }
        this.newline = true;
        this.printData.indent();
        this.printData.appendComment(" *", 1);
        if (this.printData.isReformatComments() && this.mode != PREFORMATTED) {
            int n = 0;
            while (n < this.indent) {
                this.printData.space();
                ++n;
            }
        }
    }

    protected boolean startMode(String string) {
        if (this.startsWith(string, "<PRE") || this.startsWith(string, "<CODE")) {
            this.mode = PREFORMATTED;
        } else if (this.startsWith(string, "</PRE") || this.startsWith(string, "</CODE")) {
            this.mode = NORMAL;
        } else if (this.startsWith(string, "<P")) {
            this.mode = PARA;
        } else if (this.startsWith(string, "<BR")) {
            this.mode = LINE_BREAK;
        } else {
            if (this.startsWith(string, "<UL")) {
                this.mode = LIST;
                this.indent();
                this.indent += 2;
                return true;
            }
            if (this.startsWith(string, "<OL")) {
                this.mode = LIST;
                this.indent();
                this.indent += 2;
                return true;
            }
            if (this.startsWith(string, "<DL")) {
                this.mode = LIST;
                this.indent();
                this.indent += 2;
                return true;
            }
            if (this.startsWith(string, "</UL")) {
                this.mode = END_LIST;
                this.indent -= 2;
                this.indent();
                return true;
            }
            if (this.startsWith(string, "</OL")) {
                this.mode = END_LIST;
                this.indent -= 2;
                this.indent();
                return true;
            }
            if (this.startsWith(string, "</DL")) {
                this.mode = END_LIST;
                this.indent -= 2;
                this.indent();
                return true;
            }
            if (this.startsWith(string, "<LI")) {
                this.indent();
                this.mode = END_TAG;
                return true;
            }
            if (this.startsWith(string, "<DD")) {
                this.indent();
                this.mode = END_TAG;
                return true;
            }
            if (this.startsWith(string, "<DT")) {
                this.indent();
                this.mode = END_TAG;
                return true;
            }
            if (this.startsWith(string, "<TABLE")) {
                this.mode = TABLE;
                this.indent();
                this.indent += 2;
                return true;
            }
            if (this.startsWith(string, "<TR")) {
                this.mode = TABLE;
                this.indent();
                this.indent += 2;
                return true;
            }
            if (this.startsWith(string, "<TD")) {
                this.mode = TABLE;
                this.indent();
                this.indent += 2;
                return true;
            }
            if (this.startsWith(string, "<TH")) {
                this.mode = TABLE;
                this.indent();
                this.indent += 2;
                return true;
            }
            if (this.startsWith(string, "</TABLE")) {
                this.mode = TABLE;
                this.indent -= 2;
                this.indent();
                return true;
            }
            if (this.startsWith(string, "</TR")) {
                this.mode = TABLE;
                this.indent -= 2;
                this.indent();
                return true;
            }
            if (this.startsWith(string, "</TD")) {
                this.mode = TABLE;
                this.indent -= 2;
                this.indent();
                return true;
            }
            if (this.startsWith(string, "</TH")) {
                this.mode = TABLE;
                this.indent -= 2;
                this.indent();
                return true;
            }
            if (this.startsWith(string, "</") && !this.newline) {
                this.mode = END_TAG;
            }
        }
        return false;
    }

    protected boolean endMode(String string) {
        if (this.mode == END_TAG) {
            this.mode = NORMAL;
            this.printData.space();
            return true;
        }
        if (this.mode == PARA) {
            this.mode = NORMAL;
            this.indent();
            this.indent();
            return true;
        }
        if (this.mode == LINE_BREAK) {
            this.mode = NORMAL;
            this.indent();
            return true;
        }
        if (this.mode == LIST) {
            this.mode = NORMAL;
        }
        if (this.mode == END_LIST) {
            this.mode = NORMAL;
            this.indent();
            return true;
        }
        if (this.mode == TABLE) {
            this.mode = NORMAL;
            this.indent();
            return true;
        }
        return false;
    }

    protected boolean startsWith(String string, String string2) {
        return string.toUpperCase().startsWith(string2);
    }

    private boolean printToken(Token token, int n, int n2, boolean bl) {
        if (token.kind == 2) {
            this.newline = false;
            int n3 = token.image.length();
            if (this.printData.getLineLength() > n && this.printData.getLineLength() + n3 > n2 && this.mode != PREFORMATTED) {
                this.indent();
                this.newline = true;
            }
            this.newline = token.image.charAt(0) == '<' ? this.startMode(token.image.toUpperCase()) : false;
            this.printData.appendComment(token.image, 1);
            if (token.image.charAt(token.image.length() - 1) == '>') {
                this.newline = this.endMode(token.image) || this.newline;
            }
            return this.newline;
        }
        if (this.mode != PREFORMATTED) {
            if (!bl) {
                this.printData.space();
                return true;
            }
        } else if (token.kind == 0) {
            this.printData.appendComment(token.image, 1);
        } else {
            this.indent();
        }
        return bl;
    }

    private void maintainCurrentFormat() {
        JavadocTokenizer javadocTokenizer = new JavadocTokenizer(this.buffer.toString());
        this.owedLines = 0;
        Token token = null;
        Token token2 = javadocTokenizer.next();
        while (token2.kind != 2) {
            token = token2;
            if (!javadocTokenizer.hasNext()) {
                return;
            }
            token2 = javadocTokenizer.next();
        }
        if (token != null && token.kind != 1) {
            this.mcfOutputToken(token, this.printData);
        }
        this.mcfOutputToken(token2, this.printData);
        while (javadocTokenizer.hasNext()) {
            Token token3 = javadocTokenizer.next();
            this.mcfOutputToken(token3, this.printData);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void mcfOutputToken(Token var1_1, PrintData var2_2) {
        block1: {
            if (var1_1.kind != 1) ** GOTO lbl6
            ++this.owedLines;
            break block1;
lbl-1000:
            // 1 sources

            {
                this.indent();
                --this.owedLines;
lbl6:
                // 2 sources

                ** while (this.owedLines > 0)
            }
lbl7:
            // 1 sources

            var2_2.appendComment(var1_1.image, 1);
        }
    }
}

