/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.pretty;

import java.util.StringTokenizer;
import java.util.Vector;
import org.acm.seguin.pretty.JavaDocComponent;
import org.acm.seguin.pretty.JavaDocable;
import org.acm.seguin.pretty.JavadocTokenizer;
import org.acm.seguin.pretty.NamedJavaDocComponent;
import org.acm.seguin.pretty.PrintData;
import org.acm.seguin.util.FileSettings;
import org.acm.seguin.util.MissingSettingsException;

public class JavaDocableImpl
implements JavaDocable {
    private Vector docs = new Vector();
    private boolean printed = false;

    public boolean isRequired() {
        return !this.printed;
    }

    public boolean isPrinted() {
        return this.printed;
    }

    public void addJavaDocComponent(JavaDocComponent javaDocComponent) {
        if (javaDocComponent != null) {
            this.docs.addElement(javaDocComponent);
        }
    }

    public void printJavaDocComponents(PrintData printData) {
        this.printJavaDocComponents(printData, "");
    }

    public void printJavaDocComponents(PrintData printData, String string) {
        this.printed = true;
        if (this.docs.size() == 0) {
            return;
        }
        this.setLongest(this.getLongest());
        if (!printData.isLineIndented()) {
            printData.indent();
        }
        int n = printData.getJavadocStarCount() - 2;
        printData.appendComment("/**", 1);
        int n2 = 0;
        while (n2 < n) {
            printData.appendComment("*", 1);
            ++n2;
        }
        boolean bl = this.isOnSingleLine(printData);
        if (!bl) {
            printData.newline();
        }
        this.print(printData, string, bl);
        if (!bl) {
            printData.indent();
        }
        printData.appendComment(" ", 1);
        int n3 = 0;
        while (n3 < n) {
            printData.appendComment("*", 1);
            ++n3;
        }
        printData.appendComment("*/", 1);
        printData.newline();
        this.docs = new Vector();
    }

    public void finish() {
    }

    public boolean contains(String string) {
        int n = this.docs.size();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            JavaDocComponent javaDocComponent = (JavaDocComponent)this.docs.elementAt(n2);
            String string2 = javaDocComponent.getType();
            if (string2.equalsIgnoreCase(string)) {
                javaDocComponent.setRequired(true);
                bl = true;
                if (string2.equals("param") || string2.equals("return") || string2.equals("exception") || string2.equals("throws") || string2.equals("")) {
                    return true;
                }
            }
            ++n2;
        }
        return bl;
    }

    public boolean contains(String string, String string2) {
        int n = this.docs.size();
        int n2 = 0;
        while (n2 < n) {
            NamedJavaDocComponent namedJavaDocComponent;
            Object e = this.docs.elementAt(n2);
            if (e instanceof NamedJavaDocComponent && (namedJavaDocComponent = (NamedJavaDocComponent)e).getType().equalsIgnoreCase(string) && namedJavaDocComponent.getID().equals(string2)) {
                namedJavaDocComponent.setRequired(true);
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void require(String string, String string2) {
        if (!this.contains(string)) {
            JavaDocComponent javaDocComponent = new JavaDocComponent();
            javaDocComponent.setType(string);
            javaDocComponent.setDescription(string2);
            this.addJavaDocComponent(javaDocComponent);
            javaDocComponent.setRequired(true);
        }
    }

    public void require(String string, String string2, String string3) {
        if (!this.contains(string, string2)) {
            NamedJavaDocComponent namedJavaDocComponent = new NamedJavaDocComponent();
            namedJavaDocComponent.setType(string);
            namedJavaDocComponent.setID(string2);
            namedJavaDocComponent.setDescription(string3);
            this.addJavaDocComponent(namedJavaDocComponent);
            namedJavaDocComponent.setRequired(true);
        }
    }

    private void setLongest(int n) {
        int n2 = this.docs.size();
        int n3 = 0;
        while (n3 < n2) {
            ((JavaDocComponent)this.docs.elementAt(n3)).setLongestLength(n);
            ++n3;
        }
    }

    private int getLongest() {
        int n = 0;
        int n2 = this.docs.size();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = ((JavaDocComponent)this.docs.elementAt(n3)).getLongestLength();
            n = Math.max(n4, n);
            ++n3;
        }
        return n;
    }

    private boolean isDescription(JavaDocComponent javaDocComponent) {
        return javaDocComponent.getType().length() == 0;
    }

    private boolean isTagRequired(String string) {
        try {
            FileSettings fileSettings = FileSettings.getSettings("Refactory", "pretty");
            fileSettings.getString(string + ".descr");
            return true;
        }
        catch (MissingSettingsException missingSettingsException) {
            return false;
        }
    }

    private boolean isOnSingleLine(PrintData printData) {
        if (!printData.isAllowSingleLineJavadoc()) {
            return false;
        }
        if (this.docs.size() > 1) {
            return false;
        }
        JavaDocComponent javaDocComponent = (JavaDocComponent)this.docs.elementAt(0);
        if (!javaDocComponent.isDescription()) {
            return false;
        }
        String string = javaDocComponent.getDescription();
        if (string.length() > printData.getJavadocWordWrapMaximum()) {
            return false;
        }
        return (string = string.toUpperCase()).indexOf("<P>") < 0 && string.indexOf("<BR") < 0 && string.indexOf("<DL") < 0 && string.indexOf("<OL") < 0 && string.indexOf("<UL") < 0;
    }

    private void print(PrintData printData, String string, boolean bl) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", \t\r\n");
        this.printDescription(printData, bl);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            boolean bl2 = this.isTagRequired(string2);
            this.tagPass("@" + string2, printData, bl2);
        }
        this.finalPass(printData);
    }

    private void tagPass(String string, PrintData printData, boolean bl) {
        int n = this.docs.size();
        int n2 = 0;
        while (n2 < n) {
            boolean bl2;
            JavaDocComponent javaDocComponent = (JavaDocComponent)this.docs.elementAt(n2);
            boolean bl3 = string.equals(javaDocComponent.getType());
            boolean bl4 = bl2 = !bl || javaDocComponent.isRequired();
            if (bl3) {
                if (bl2) {
                    this.printCurrentTag(javaDocComponent, printData, false, false);
                } else if (printData.isKeepErroneousJavadocTags()) {
                    javaDocComponent.setType(javaDocComponent.getType() + "-error");
                } else {
                    javaDocComponent.setPrinted(true);
                }
            }
            ++n2;
        }
    }

    private void printDescription(PrintData printData, boolean bl) {
        int n = this.docs.size();
        int n2 = 0;
        while (n2 < n) {
            JavaDocComponent javaDocComponent = (JavaDocComponent)this.docs.elementAt(n2);
            if (javaDocComponent.getType().equals("")) {
                String string = javaDocComponent.getDescription();
                if (JavadocTokenizer.hasContent(string)) {
                    this.printCurrentTag(javaDocComponent, printData, n == 1, bl);
                }
                javaDocComponent.setPrinted(true);
            }
            ++n2;
        }
    }

    private void finalPass(PrintData printData) {
        int n = this.docs.size();
        int n2 = 0;
        while (n2 < n) {
            JavaDocComponent javaDocComponent = (JavaDocComponent)this.docs.elementAt(n2);
            if (!javaDocComponent.isPrinted()) {
                this.printCurrentTag(javaDocComponent, printData, false, false);
            }
            ++n2;
        }
    }

    private void printCurrentTag(JavaDocComponent javaDocComponent, PrintData printData, boolean bl, boolean bl2) {
        printData.setCurrentIsSingle(bl2);
        javaDocComponent.print(printData);
        printData.setCurrentIsSingle(false);
        if (!bl && this.isDescription(javaDocComponent)) {
            this.printSpaceAfterDescription(printData);
        }
    }

    private void printSpaceAfterDescription(PrintData printData) {
        printData.indent();
        printData.appendComment(" *", 1);
        printData.newline();
    }
}

