/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.parser.ast;

import java.util.Vector;
import org.acm.seguin.parser.JavaParser;
import org.acm.seguin.parser.JavaParserTreeConstants;
import org.acm.seguin.parser.JavaParserVisitor;
import org.acm.seguin.parser.NamedToken;
import org.acm.seguin.parser.Node;
import org.acm.seguin.parser.Token;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected JavaParser parser;
    protected Vector specials;

    public SimpleNode(int n) {
        this.id = n;
        this.specials = null;
    }

    public SimpleNode(JavaParser javaParser, int n) {
        this(n);
        this.parser = javaParser;
    }

    public int getID() {
        return this.id;
    }

    public Token getSpecial(String string) {
        if (this.specials == null || string == null) {
            return null;
        }
        int n = this.specials.size();
        int n2 = 0;
        while (n2 < n) {
            NamedToken namedToken = (NamedToken)this.specials.elementAt(n2);
            if (namedToken.check(string)) {
                return namedToken.getToken();
            }
            ++n2;
        }
        return null;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
        node.jjtSetParent(this);
    }

    public void jjtInsertChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else {
            Node[] nodeArray = new Node[Math.max(this.children.length + 1, n + 1)];
            System.arraycopy(this.children, 0, nodeArray, 0, n);
            System.arraycopy(this.children, n, nodeArray, n + 1, this.children.length - n);
            this.children = nodeArray;
        }
        this.children[n] = node;
        node.jjtSetParent(this);
    }

    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public boolean hasAnyChildren() {
        return this.children != null && this.children.length > 0;
    }

    public void jjtDeleteChild(int n) {
        if (this.children == null || this.children.length < n || n < 0) {
            System.out.println("Skipping this delete operation");
        } else {
            Node[] nodeArray = new Node[this.children.length - 1];
            System.arraycopy(this.children, 0, nodeArray, 0, n);
            System.arraycopy(this.children, n + 1, nodeArray, n, this.children.length - n - 1);
            this.children = nodeArray;
        }
    }

    public void addSpecial(String string, Token token) {
        if (token == null) {
            return;
        }
        if (this.specials == null) {
            this.init();
        }
        this.specials.addElement(new NamedToken(string, token));
    }

    public void removeSpecial(String string) {
        if (this.specials == null || string == null) {
            return;
        }
        int n = this.specials.size();
        int n2 = 0;
        while (n2 < n) {
            NamedToken namedToken = (NamedToken)this.specials.elementAt(n2);
            if (namedToken.check(string)) {
                this.specials.removeElementAt(n2);
                return;
            }
            ++n2;
        }
    }

    public Object jjtAccept(JavaParserVisitor javaParserVisitor, Object object) {
        return javaParserVisitor.visit(this, object);
    }

    public Object childrenAccept(JavaParserVisitor javaParserVisitor, Object object) {
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                this.children[n].jjtAccept(javaParserVisitor, object);
                ++n;
            }
        }
        return object;
    }

    public String toString() {
        return JavaParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String string) {
        return string + this.toString();
    }

    public void dump(String string) {
        System.out.println(string + this.getClass().getName());
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                SimpleNode simpleNode = (SimpleNode)this.children[n];
                if (simpleNode != null) {
                    simpleNode.dump(string + " ");
                }
                ++n;
            }
        }
    }

    protected void init() {
        if (this.specials == null) {
            this.specials = new Vector();
        }
    }

    public boolean isRequired() {
        return false;
    }
}

