/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.ide.jbuilder;

import com.borland.primetime.ide.Browser;
import com.borland.primetime.node.Node;
import com.borland.primetime.node.TextFileNode;
import com.borland.primetime.vfs.Buffer;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.Action;
import org.acm.seguin.ide.common.TextPrinter;
import org.acm.seguin.ide.jbuilder.UMLNode;
import org.acm.seguin.uml.print.PrintingThread;

public class PrintAction
extends TextPrinter
implements Action {
    private boolean enabled = true;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private HashMap values = new HashMap();

    public PrintAction() {
        this.putValue("Name", "Print");
        this.putValue("ShortDescription", "Print");
        this.putValue("LongDescription", "Prints the current file");
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    private Node getActiveNode() {
        Browser browser = Browser.getActiveBrowser();
        return browser.getActiveNode();
    }

    protected String getFilenameFromIDE() {
        Node node = this.getActiveNode();
        if (node instanceof TextFileNode) {
            TextFileNode textFileNode = (TextFileNode)node;
            return textFileNode.getDisplayName();
        }
        return "Unknown filename";
    }

    protected String getStringFromIDE() {
        Node node = this.getActiveNode();
        if (node instanceof TextFileNode) {
            TextFileNode textFileNode = (TextFileNode)node;
            try {
                Buffer buffer = textFileNode.getBuffer();
                byte[] byArray = buffer.getContent();
                return new String(byArray);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return null;
    }

    public Object getValue(String string) {
        return this.values.get(string);
    }

    public boolean isEnabled() {
        if (!this.enabled) {
            return false;
        }
        Node node = this.getActiveNode();
        return node instanceof TextFileNode || node instanceof UMLNode;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Node node = this.getActiveNode();
        if (node instanceof TextFileNode) {
            String string = this.getStringFromIDE();
            String string2 = this.getFilenameFromIDE();
            this.print(string2, string);
        } else if (node instanceof UMLNode) {
            UMLNode uMLNode = (UMLNode)node;
            new PrintingThread(uMLNode.getDiagram()).start();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void putValue(String string, Object object) {
        Object object2 = this.getValue(string);
        Object object3 = object;
        this.support.firePropertyChange(string, object2, object3);
        this.values.put(string, object);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }
}

