/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.ide.elixir;

import com.elixirtech.fx.DocManager;
import com.elixirtech.fx.FrameManager;
import com.elixirtech.fx.ViewManager;
import com.elixirtech.ui.ActionEx;
import java.awt.Container;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import org.acm.seguin.ide.common.PackageNameLoader;
import org.acm.seguin.ide.common.PackageSelectorDialog;
import org.acm.seguin.ide.common.SummaryLoaderThread;
import org.acm.seguin.ide.elixir.UMLDocManager;
import org.acm.seguin.summary.PackageSummary;
import org.acm.seguin.uml.UMLPackage;

public class UMLViewManager
implements ViewManager {
    private UMLDocManager docManager;
    private String filename;
    private String packageName;
    private UMLPackage packagePanel;
    private JScrollPane pane;
    private PackageSummary summary;

    public UMLViewManager(UMLDocManager uMLDocManager, String string, String string2) {
        Container container;
        SummaryLoaderThread.waitForLoading();
        this.docManager = uMLDocManager;
        if (string != null) {
            this.filename = string;
            this.packagePanel = new UMLPackage(this.filename);
        } else {
            container = new PackageSelectorDialog(FrameManager.current().getFrame());
            container.setVisible(true);
            this.summary = ((PackageSelectorDialog)container).getSummary();
            this.filename = null;
            this.packagePanel = new UMLPackage(this.summary);
        }
        uMLDocManager.getReloader().add(this.packagePanel);
        this.pane = new JScrollPane(this.packagePanel, 22, 32);
        container = this.pane.getHorizontalScrollBar();
        ((JScrollBar)container).setUnitIncrement(400);
        JScrollBar jScrollBar = this.pane.getVerticalScrollBar();
        jScrollBar.setUnitIncrement(400);
        this.loadPackageName();
    }

    public ActionEx[] getActions() {
        return new ActionEx[0];
    }

    public UMLPackage getDiagram() {
        return this.packagePanel;
    }

    public DocManager getDocManager() {
        return this.docManager;
    }

    public String getTitle() {
        if (this.packageName.length() > 0) {
            return this.packageName;
        }
        return "<Top Level Package>";
    }

    public JComponent getView() {
        return this.pane;
    }

    public void closed() {
        this.save();
    }

    public void closing() {
    }

    private void loadPackageName() {
        if (this.filename == null) {
            this.packageName = this.summary.getName();
            return;
        }
        PackageNameLoader packageNameLoader = new PackageNameLoader();
        this.packageName = packageNameLoader.load(this.filename);
    }

    public boolean okToClose() {
        return true;
    }

    public boolean reload() {
        this.packagePanel.reload();
        return true;
    }

    public boolean save() {
        try {
            this.packagePanel.save();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }
}

