/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.ide.elixir;

import com.elixirtech.fx.FrameManager;
import com.elixirtech.tree.TModel;
import com.elixirtech.tree.TNode;
import com.elixirtech.tree.TParent;
import com.elixirtech.util.SortUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.acm.seguin.ide.common.UMLIcon;
import org.acm.seguin.ide.elixir.UMLDocManager;

class UMLLeaf
implements TNode {
    private UMLDocManager docManager;
    private File file;
    private String packageName;
    private TNode parent;

    public UMLLeaf(TNode tNode, File file, UMLDocManager uMLDocManager) {
        this.parent = tNode;
        this.file = file;
        this.docManager = uMLDocManager;
        this.loadPackageName();
    }

    public void setName(String string) {
        this.file = new File(string);
    }

    public void setParent(TParent tParent) {
        this.parent = tParent;
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public TreeNode getChildAt(int n) {
        return null;
    }

    public int getChildCount() {
        return 0;
    }

    public String getFullName() {
        try {
            return this.file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return this.file.getPath();
        }
    }

    public Icon getIcon(boolean bl) {
        return new UMLIcon();
    }

    public int getIndex(TreeNode treeNode) {
        return -1;
    }

    public String getName() {
        return this.packageName + " Class Diagram";
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public JPopupMenu getPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Open");
        jMenuItem.addActionListener(new OpenFileAdapter(this.getFullName()));
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    public String getToolTipText() {
        if (this.packageName.length() > 0) {
            return "The class diagram for the package " + this.packageName;
        }
        return "The class diagram for the top level package";
    }

    public TModel getTreeModel() {
        return this.parent.getTreeModel();
    }

    public TreePath getTreePath() {
        return this.parent.getTreePath().pathByAddingChild(this);
    }

    public boolean isLeaf() {
        return true;
    }

    public Enumeration children() {
        Vector vector = new Vector();
        return vector.elements();
    }

    public void doDoubleClick() {
        FrameManager.current().open(this.getFullName());
    }

    public void fireChanged() {
    }

    private void loadPackageName() {
        try {
            StringTokenizer stringTokenizer;
            this.packageName = "Unknown";
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.file));
            String string = bufferedReader.readLine();
            if (string.charAt(0) == 'V' && (stringTokenizer = new StringTokenizer(string, "[:]")).hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (stringTokenizer.hasMoreTokens()) {
                        this.packageName = stringTokenizer.nextToken();
                    }
                }
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void sortChildren(SortUtil.Comparator comparator) {
    }

    public String toString() {
        return this.getName();
    }

    private class OpenFileAdapter
    implements ActionListener {
        private String name;

        public OpenFileAdapter(String string) {
            this.name = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FrameManager.current().open(this.name);
        }
    }
}

