/*
 * Decompiled with CFR 0.152.
 */
package org.acm.seguin.ide.common.action;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.acm.seguin.ide.common.EditorOperations;
import org.acm.seguin.ide.common.MultipleDirClassDiagramReloader;
import org.acm.seguin.summary.FieldSummary;
import org.acm.seguin.summary.FileSummary;
import org.acm.seguin.summary.MethodSummary;
import org.acm.seguin.summary.Summary;
import org.acm.seguin.summary.TypeSummary;

public abstract class CurrentSummary
implements DocumentListener {
    private FileSummary fileSummary = null;
    private static CurrentSummary singleton = null;
    private Summary summary = null;
    protected boolean upToDate = false;

    protected CurrentSummary() {
    }

    public static CurrentSummary get() {
        return singleton;
    }

    protected File getActiveFile() {
        return EditorOperations.get().getFile();
    }

    public Summary getCurrentSummary() {
        if (this.summary == null || this.upToDate || !this.isSameFile() || !this.isInSameSummary()) {
            this.lockAccess();
        }
        System.out.println("Summary is:  " + this.summary + " from " + this.getLineNumber());
        return this.summary;
    }

    /*
     * Unable to fully structure code
     */
    private Summary getInType(FileSummary var1_1, int var2_2) {
        var3_3 = var1_1.getTypes();
        if (var3_3 != null) ** GOTO lbl7
        return null;
lbl-1000:
        // 1 sources

        {
            var4_4 = (TypeSummary)var3_3.next();
            if (var4_4.getStartLine() > var2_2 || var4_4.getEndLine() < var2_2) continue;
            return this.findSummaryInType(var4_4, var2_2);
lbl7:
            // 2 sources

            ** while (var3_3.hasNext())
        }
lbl8:
        // 1 sources

        return null;
    }

    protected int getLineNumber() {
        return EditorOperations.get().getLineNumber();
    }

    protected abstract MultipleDirClassDiagramReloader getMetadataReloader();

    /*
     * Unable to fully structure code
     */
    private Summary isInField(TypeSummary var1_1, int var2_2) {
        var3_3 = var1_1.getFields();
        if (var3_3 != null) ** GOTO lbl7
        return null;
lbl-1000:
        // 1 sources

        {
            var4_4 = (FieldSummary)var3_3.next();
            if (var4_4.getStartLine() > var2_2 || var4_4.getEndLine() < var2_2) continue;
            return var4_4;
lbl7:
            // 2 sources

            ** while (var3_3.hasNext())
        }
lbl8:
        // 1 sources

        return null;
    }

    /*
     * Unable to fully structure code
     */
    private Summary isInMethod(TypeSummary var1_1, int var2_2) {
        var3_3 = var1_1.getMethods();
        if (var3_3 != null) ** GOTO lbl7
        return null;
lbl-1000:
        // 1 sources

        {
            var4_4 = (MethodSummary)var3_3.next();
            if (var4_4.getStartLine() > var2_2 || var4_4.getEndLine() < var2_2) continue;
            return var4_4;
lbl7:
            // 2 sources

            ** while (var3_3.hasNext())
        }
lbl8:
        // 1 sources

        return null;
    }

    /*
     * Unable to fully structure code
     */
    private Summary isInNestedClass(TypeSummary var1_1, int var2_2) {
        var3_3 = var1_1.getTypes();
        if (var3_3 != null) ** GOTO lbl7
        return null;
lbl-1000:
        // 1 sources

        {
            var4_4 = (TypeSummary)var3_3.next();
            if (var4_4.getStartLine() > var2_2 || var4_4.getEndLine() < var2_2) continue;
            return this.findSummaryInType(var4_4, var2_2);
lbl7:
            // 2 sources

            ** while (var3_3.hasNext())
        }
lbl8:
        // 1 sources

        return null;
    }

    private boolean isInSameSummary() {
        int n = this.getLineNumber();
        return this.summary.getStartLine() <= n && this.summary.getEndLine() >= n;
    }

    private boolean isSameFile() {
        if (this.fileSummary == null) {
            return false;
        }
        boolean bl = this.fileSummary.getFile() == this.getActiveFile();
        return bl;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.upToDate = false;
    }

    private Summary find() {
        try {
            this.registerWithCurrentDocument();
            int n = this.getLineNumber();
            if (n == -1) {
                return null;
            }
            if (!this.upToDate || this.fileSummary == null) {
                this.fileSummary = this.reloadNode();
            }
            if (this.fileSummary == null) {
                return null;
            }
            Summary summary = this.getInType(this.fileSummary, n);
            if (summary != null) {
                return summary;
            }
            return this.fileSummary;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private Summary findSummaryInType(TypeSummary typeSummary, int n) {
        Summary summary = this.isInMethod(typeSummary, n);
        if (summary != null) {
            return summary;
        }
        summary = this.isInField(typeSummary, n);
        if (summary != null) {
            return summary;
        }
        summary = this.isInNestedClass(typeSummary, n);
        if (summary != null) {
            return summary;
        }
        return typeSummary;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.upToDate = false;
    }

    private synchronized void lockAccess() {
        if (!(this.summary != null && this.upToDate && this.isSameFile() && this.isInSameSummary())) {
            this.summary = this.find();
            this.upToDate = true;
        }
    }

    public static void register(CurrentSummary currentSummary) {
        singleton = currentSummary;
    }

    protected abstract void registerWithCurrentDocument();

    private FileSummary reloadNode() throws IOException {
        if (EditorOperations.get().isJavaFile()) {
            String string = EditorOperations.get().getStringFromIDE();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            return FileSummary.reloadFromBuffer(EditorOperations.get().getFile(), byteArrayInputStream);
        }
        return null;
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.upToDate = false;
    }

    public void reset() {
        this.upToDate = false;
    }

    public void updateMetaData() {
        MultipleDirClassDiagramReloader multipleDirClassDiagramReloader = this.getMetadataReloader();
        multipleDirClassDiagramReloader.setNecessary(true);
        multipleDirClassDiagramReloader.reload();
    }
}

