/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import javax.swing.JFileChooser;
import org.acm.seguin.awt.ExceptionPrinter;
import org.acm.seguin.awt.TextExceptionPrinter;
import org.acm.seguin.io.AllFileFilter;
import org.acm.seguin.io.DirectoryTreeTraversal;
import org.acm.seguin.io.ExtensionFileFilter;
import org.acm.seguin.io.FileCopy;
import org.acm.seguin.pretty.PrettyPrintFile;
import org.acm.seguin.tools.install.RefactoryInstaller;
import org.acm.seguin.util.FileSettings;
import org.acm.seguin.util.MissingSettingsException;

public class PrettyPrinter
extends DirectoryTreeTraversal {
    private PrettyPrintFile ppf;

    public PrettyPrinter(String string, boolean bl) {
        super(string);
        if (string == null) {
            return;
        }
        this.ppf = new PrettyPrintFile();
        this.ppf.setAsk(!bl && new File(string).isDirectory());
    }

    protected boolean isTarget(File file) {
        return file.getName().endsWith(".java");
    }

    protected void visit(File file) {
        if (this.ppf.isApplicable(file)) {
            System.out.println("Applying the Pretty Printer:  " + file.getPath());
            this.makeBackup(file);
            this.ppf.apply(file);
        }
    }

    private void makeBackup(File file) {
        String string;
        try {
            string = FileSettings.getSettings("Refactory", "pretty").getString("pretty.printer.backup.ext");
            string = string == null ? "" : string.trim();
        }
        catch (MissingSettingsException missingSettingsException) {
            string = "";
        }
        if (string != null && string.length() > 0) {
            File file2 = file.getParentFile();
            String string2 = file.getName();
            File file3 = new File(file2, string2 + string);
            new FileCopy(file, file3, false).run();
        }
    }

    public static void main(String[] stringArray) {
        try {
            new RefactoryInstaller(false).run();
            int n = -1;
            boolean bl = false;
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2].equals("-quiet") || stringArray[n2].equals("-u")) {
                    bl = true;
                    n = n2;
                    ExceptionPrinter.register(new TextExceptionPrinter());
                } else if (stringArray[n2].equals("-?") || stringArray[n2].equalsIgnoreCase("-h") || stringArray[n2].equalsIgnoreCase("-help")) {
                    PrettyPrinter.printHelpMessage();
                    return;
                }
                ++n2;
            }
            if (n + 1 >= stringArray.length) {
                if (bl) {
                    PrettyPrinter.prettyPrinter(bl);
                } else {
                    PrettyPrinter.prettyPrinter(System.getProperty("user.dir"), bl);
                }
            } else {
                int n3 = n + 1;
                while (n3 < stringArray.length) {
                    PrettyPrinter.prettyPrinter(stringArray[n3], bl);
                    ++n3;
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.out);
            System.exit(1);
        }
        System.exit(ExceptionPrinter.getExceptionsPrinted());
    }

    public static void prettyPrinter(String string, boolean bl) {
        new PrettyPrinter(string, bl).go();
    }

    public static void prettyPrinter(boolean bl) {
        JFileChooser jFileChooser = new JFileChooser();
        ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter();
        extensionFileFilter.addExtension(".java");
        extensionFileFilter.setDescription("Java Source Files (.java)");
        jFileChooser.setFileFilter(extensionFileFilter);
        AllFileFilter allFileFilter = new AllFileFilter();
        jFileChooser.addChoosableFileFilter(allFileFilter);
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        int n = jFileChooser.showOpenDialog(null);
        if (n == 0) {
            new PrettyPrinter(jFileChooser.getSelectedFile().getAbsolutePath(), bl).go();
        }
    }

    private static void printHelpMessage() {
        System.out.println("Syntax:  java PrettyPrinter file   //  means refactor this file");
        System.out.println("   OR    java PrettyPrinter [-quiet|-u] dir   //  means refactor this directory");
        System.out.println("   OR    java PrettyPrinter [-quiet|-u]   //  means refactor the current directory");
        System.out.println("  the -quiet or the -u flag tells the pretty printer not to prompt the user");
    }
}

