/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles.definition;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import org.apache.struts.tiles.ComponentDefinition;
import org.apache.struts.tiles.ComponentDefinitionsFactory;
import org.apache.struts.tiles.DefinitionsFactory;
import org.apache.struts.tiles.DefinitionsFactoryConfig;
import org.apache.struts.tiles.DefinitionsFactoryException;
import org.apache.struts.tiles.NoSuchDefinitionException;

public class ComponentDefinitionsFactoryWrapper
implements DefinitionsFactory {
    private ComponentDefinitionsFactory factory;
    private DefinitionsFactoryConfig config;

    public ComponentDefinitionsFactoryWrapper(ComponentDefinitionsFactory factory) {
        this.factory = factory;
    }

    public ComponentDefinitionsFactoryWrapper() {
    }

    public ComponentDefinition getDefinition(String name, ServletRequest request, ServletContext servletContext) throws NoSuchDefinitionException, DefinitionsFactoryException {
        return this.factory.getDefinition(name, request, servletContext);
    }

    public void init(DefinitionsFactoryConfig config, ServletContext servletContext) throws DefinitionsFactoryException {
        this.config = config;
        if (this.factory == null) {
            this.factory = this.createFactoryInstance(config.getFactoryClassname());
        }
        this.factory.initFactory(servletContext, ComponentDefinitionsFactoryWrapper.createConfigMap(config));
    }

    public void destroy() {
        this.factory = null;
    }

    public void setConfig(DefinitionsFactoryConfig config, ServletContext servletContext) throws DefinitionsFactoryException {
        ComponentDefinitionsFactory newFactory = this.createFactoryInstance(config.getFactoryClassname());
        newFactory.initFactory(servletContext, ComponentDefinitionsFactoryWrapper.createConfigMap(config));
        this.factory = newFactory;
    }

    public DefinitionsFactoryConfig getConfig() {
        return this.config;
    }

    public ComponentDefinitionsFactory getInternalFactory() {
        return this.factory;
    }

    protected ComponentDefinitionsFactory createFactoryInstance(String classname) throws DefinitionsFactoryException {
        try {
            Class<?> factoryClass = Class.forName(classname);
            Object factory = factoryClass.newInstance();
            return (ComponentDefinitionsFactory)factory;
        }
        catch (ClassCastException ex) {
            throw new DefinitionsFactoryException("Error - createDefinitionsFactory : Factory class '" + classname + " must implements 'TilesDefinitionsFactory'.", ex);
        }
        catch (ClassNotFoundException ex) {
            throw new DefinitionsFactoryException("Error - createDefinitionsFactory : Bad class name '" + classname + "'.", ex);
        }
        catch (InstantiationException ex) {
            throw new DefinitionsFactoryException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new DefinitionsFactoryException(ex);
        }
    }

    public String toString() {
        return this.getInternalFactory().toString();
    }

    public static Map createConfigMap(DefinitionsFactoryConfig config) {
        HashMap<String, String> map = new HashMap<String, String>(config.getAttributes());
        map.put("definitions-config", config.getDefinitionConfigFiles());
        map.put("definitions-debug", Integer.toString(config.getDebugLevel()));
        map.put("definitions-parser-details", Integer.toString(config.getParserDebugLevel()));
        map.put("definitions-parser-validate", new Boolean(config.getParserValidate()).toString());
        if (!"org.apache.struts.tiles.xmlDefinition.I18nFactorySet".equals(config.getFactoryClassname())) {
            map.put("definitions-factory-class", config.getFactoryClassname());
        }
        return map;
    }
}

