/*
 * Decompiled with CFR 0.152.
 */
package webwork.config;

import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import webwork.config.Configuration;

public class PropertiesConfiguration
extends Configuration {
    Properties settings = new Properties();

    public PropertiesConfiguration(String aName) {
        URL settingsUrl = Thread.currentThread().getContextClassLoader().getResource(String.valueOf(aName) + ".properties");
        if (settingsUrl == null) {
            throw new IllegalStateException(String.valueOf(aName) + ".properties missing");
        }
        try {
            this.settings.load(settingsUrl.openStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load " + aName + ".properties:" + e);
        }
    }

    public Object getImpl(String aName) throws IllegalArgumentException {
        Object setting = ((Hashtable)this.settings).get(aName);
        if (setting == null) {
            throw new IllegalArgumentException("No such setting:" + aName);
        }
        return setting;
    }

    public Iterator listImpl() {
        return ((Hashtable)this.settings).keySet().iterator();
    }

    public void setImpl(String aName, Object aValue) {
        ((Hashtable)this.settings).put(aName, aValue);
    }
}

