/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects.dynamic;

import com.mockobjects.dynamic.And;
import com.mockobjects.dynamic.IsAnything;
import com.mockobjects.dynamic.IsEqual;
import com.mockobjects.dynamic.IsGreaterThan;
import com.mockobjects.dynamic.IsInstanceOf;
import com.mockobjects.dynamic.IsLessThan;
import com.mockobjects.dynamic.IsNot;
import com.mockobjects.dynamic.IsNull;
import com.mockobjects.dynamic.IsSame;
import com.mockobjects.dynamic.Mock;
import com.mockobjects.dynamic.Or;
import com.mockobjects.dynamic.Predicate;

public abstract class P {
    public static final IsAnything IS_ANYTHING = new IsAnything();
    public static final IsNull IS_NULL = new IsNull();
    public static final Predicate IS_NOT_NULL = P.not(IS_NULL);
    public static final Predicate IS_TRUE = new IsEqual(new Boolean(true));
    public static final Predicate IS_FALSE = P.eq(new Boolean(false));
    public static final Predicate IS_ZERO = P.eq(new Integer(0));
    public static final Predicate IS_NOT_ZERO = P.not(IS_ZERO);

    public static Predicate same(Object o) {
        return new IsSame(o);
    }

    public static Predicate eq(Object o) {
        return new IsEqual(o);
    }

    public static Predicate eq(int n) {
        return new IsEqual(new Integer(n));
    }

    public static Predicate eq(long l) {
        return new IsEqual(new Long(l));
    }

    public static Predicate eq(double d) {
        return new IsEqual(new Double(d));
    }

    public static Predicate gt(int n) {
        return new IsGreaterThan(new Integer(n));
    }

    public static Predicate gt(long l) {
        return new IsGreaterThan(new Long(l));
    }

    public static Predicate gt(double d) {
        return new IsGreaterThan(new Double(d));
    }

    public static Predicate gt(char c) {
        return new IsGreaterThan(new Character(c));
    }

    public static Predicate lt(int n) {
        return new IsLessThan(new Integer(n));
    }

    public static Predicate lt(long l) {
        return new IsLessThan(new Long(l));
    }

    public static Predicate lt(double d) {
        return new IsLessThan(new Double(d));
    }

    public static Predicate lt(char c) {
        return new IsLessThan(new Character(c));
    }

    public static Predicate not(Predicate p) {
        return new IsNot(p);
    }

    public static Predicate and(Predicate p1, Predicate p2) {
        return new And(p1, p2);
    }

    public static Predicate or(Predicate p1, Predicate p2) {
        return new Or(p1, p2);
    }

    public static Predicate isA(Class c) {
        return new IsInstanceOf(c);
    }

    public static Predicate[] args() {
        return Mock.NO_ARGS;
    }

    public static Predicate[] args(Predicate p) {
        return new Predicate[]{p};
    }

    public static Predicate[] args(Predicate p1, Predicate p2) {
        return new Predicate[]{p1, p2};
    }

    public static Predicate[] args(Predicate p1, Predicate p2, Predicate p3) {
        return new Predicate[]{p1, p2, p3};
    }
}

