/*
 * qt5_parallel_queue.cpp
 *
 * Copyright (c) 2011 - 2022 Marius Zwicker
 * All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "qt5_backend_internal.h"
#include "qt5_threadpool.h"
#include "../naive/naive_threadpool.h"

__XDISPATCH_BEGIN_NAMESPACE
namespace qt5 {

queue
create_parallel_queue(const std::string& label,
                      QThreadPool* pool,
                      queue_priority priority)
{
    XDISPATCH_ASSERT(pool);
    return naive::create_parallel_queue(label,
                                        std::make_shared<ThreadPoolProxy>(pool),
                                        priority,
                                        backend_type::qt5);
}

} // namespace qt5
__XDISPATCH_END_NAMESPACE
