/** @file languages/sbl-dispatch.h
 *  @brief Map string to language code
 */
/* Warning: This file is generated by ./languages/collate-sbl - do not modify directly! */
/* Copyright (C) 2007,2012,2013,2015 Olly Betts
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#ifndef XAPIAN_INCLUDED_SBL_DISPATCH_H
#define XAPIAN_INCLUDED_SBL_DISPATCH_H

enum sbl_code {
    NONE = 0,
    ARABIC = 1,
    ARMENIAN = 2,
    BASQUE = 3,
    CATALAN = 4,
    DANISH = 5,
    DUTCH = 6,
    EARLYENGLISH = 7,
    ENGLISH = 8,
    FINNISH = 9,
    FRENCH = 10,
    GERMAN = 11,
    GERMAN2 = 12,
    HUNGARIAN = 13,
    INDONESIAN = 14,
    ITALIAN = 15,
    KRAAIJ_POHLMANN = 16,
    LOVINS = 17,
    NORWEGIAN = 18,
    PORTER = 19,
    PORTUGUESE = 20,
    ROMANIAN = 21,
    RUSSIAN = 22,
    SPANISH = 23,
    SWEDISH = 24,
    TURKISH = 25
};

static const unsigned char tab[] = {
    15,

      1, 157,   1,   0,   6, 107, 224,  44,
     63,  84,   1,  13,   1,   1,  27,

    (1 - 1),
    NONE, 'n','o','n','e',

    (1 - 1),
    DUTCH, 'd','u','t','c','h',

    (1 - 1),
    EARLYENGLISH, 'e','a','r','l','y','e','n','g','l','i','s','h',

    (1 - 1),
    KRAAIJ_POHLMANN, 'k','r','a','a','i','j','_','p','o','h','l','m','a','n','n',

    (2 - 1),
    ARMENIAN, 'a','r','m','e','n','i','a','n',
    ROMANIAN, 'r','o','m','a','n','i','a','n',

    (2 - 1),
    HUNGARIAN, 'h','u','n','g','a','r','i','a','n',
    NORWEGIAN, 'n','o','r','w','e','g','i','a','n',

    (2 - 1),
    INDONESIAN, 'i','n','d','o','n','e','s','i','a','n',
    PORTUGUESE, 'p','o','r','t','u','g','u','e','s','e',

    (7 - 1),
    ARABIC, 'a','r','a','b','i','c',
    BASQUE, 'b','a','s','q','u','e',
    DANISH, 'd','a','n','i','s','h',
    FRENCH, 'f','r','e','n','c','h',
    GERMAN, 'g','e','r','m','a','n',
    LOVINS, 'l','o','v','i','n','s',
    PORTER, 'p','o','r','t','e','r',

    (22 - 1),
    ARABIC, 'a','r',
    CATALAN, 'c','a',
    DANISH, 'd','a',
    GERMAN, 'd','e',
    ENGLISH, 'e','n',
    SPANISH, 'e','s',
    BASQUE, 'e','u',
    FINNISH, 'f','i',
    FRENCH, 'f','r',
    HUNGARIAN, 'h','u',
    ARMENIAN, 'h','y',
    INDONESIAN, 'i','d',
    ITALIAN, 'i','t',
    NORWEGIAN, 'n','b',
    DUTCH, 'n','l',
    NORWEGIAN, 'n','n',
    NORWEGIAN, 'n','o',
    PORTUGUESE, 'p','t',
    ROMANIAN, 'r','o',
    RUSSIAN, 'r','u',
    SWEDISH, 's','v',
    TURKISH, 't','r',

    (9 - 1),
    CATALAN, 'c','a','t','a','l','a','n',
    ENGLISH, 'e','n','g','l','i','s','h',
    FINNISH, 'f','i','n','n','i','s','h',
    GERMAN2, 'g','e','r','m','a','n','2',
    ITALIAN, 'i','t','a','l','i','a','n',
    RUSSIAN, 'r','u','s','s','i','a','n',
    SPANISH, 's','p','a','n','i','s','h',
    SWEDISH, 's','w','e','d','i','s','h',
    TURKISH, 't','u','r','k','i','s','h'
};

#define LANGSTRING "arabic armenian basque catalan danish dutch earlyenglish english finnish french german german2 hungarian indonesian italian kraaij_pohlmann lovins norwegian porter portuguese romanian russian spanish swedish turkish"

#endif
