<?php
//
//  File:       preload_http_services.php
//
//  Purpose:    Preload config items from the SQLite3 database.
//

    // Open the database:
    $dbID = SqliteDBOpen();

    // Get the version number:
    $filestr = GetConfigPrefix() . "/wview/wview-version";
    $wview_version = file_get_contents($filestr);

    // Station:
    $stationType = SqliteDBGetValue($dbID, 'STATION_TYPE');
    if ($stationType == "VantagePro")
    {
        $field_Station_Type = "Davis Vantage Pro";
    }
    else if ($stationType == "WXT510")
    {
        $field_Station_Type = "Viasala WXT510";
    }
    else if ($stationType == "TWI")
    {
        $field_Station_Type = "Texas Weather Instruments";
    }
    else if ($stationType == "WS-2300")
    {
        $field_Station_Type = "La Crosse WS-23XX";
    }
    else if ($stationType == "WMR918")
    {
        $field_Station_Type = "Oregon Scientific WMR9XX";
    }
    else if ($stationType == "WMRUSB")
    {
        $field_Station_Type = "Oregon Scientific WMRUSB";
    }
    else if ($stationType == "WH1080")
    {
        $field_Station_Type = "Fine Offset WH1080";
    }
    else if ($stationType == "TE923")
    {
        $field_Station_Type = "Honeywell TE923";
    }
    else if ($stationType == "Simulator")
    {
        $field_Station_Type = "Simulator";
    }
    else if ($stationType == "Virtual")
    {
        $field_Station_Type = "Virtual";
    }

    // HTTP:
    $field_HTTP_Wunderground_ID             = SqliteDBGetValue($dbID, 'HTTP_WUSTATIONID');
    $field_HTTP_Wunderground_Password       = SqliteDBGetValue($dbID, 'HTTP_WUPASSWD');
    $field_HTTP_Weatherforyou_ID            = SqliteDBGetValue($dbID, 'HTTP_YOUSTATIONID');
    $field_HTTP_Weatherforyou_Password      = SqliteDBGetValue($dbID, 'HTTP_YOUPASSWD');
    

    // Close the database connection:
    SqliteDBClose($dbID);

?>
