/* wconfig.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2009 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef WCONFIG_H
#define WCONFIG_H

#include "wdefines.h"
#include <aguix/aguix.h>
#include <aguix/awindow.h>
#include <aguix/stringgadget.h>
#include <aguix/bevelbox.h>
#include <aguix/fieldlistview.h>
#include <aguix/solidbutton.h>
#include <aguix/choosebutton.h>
#include <aguix/cyclebutton.h>
#include "worker_locale.h"
#include "functionproto.h"
#include "datei.h"
#include "worker_types.h"
#include <vector>
#include <list>
#include "flattypelist.hh"
#include "wckey.hh"
#include "layoutsettings.hh"

class Worker;
class WCPath;
class WCHotkey;
class WCButton;
class WCFiletype;
class WC_Color;
class WCDoubleShortkey;

class WConfig
{
public:
  typedef enum {CLOCKBAR_MODE_TIMERAM=0,CLOCKBAR_MODE_TIME,CLOCKBAR_MODE_VERSION,CLOCKBAR_MODE_EXTERN} clockbar_mode_t;

  WConfig(Worker *);
  ~WConfig();
  WConfig( const WConfig &other );
  WConfig &operator=( const WConfig &other );

  WConfig *duplicate();
  void setLang( const char* );
  void setTerminalBin(const char*);
  void setRows(unsigned int);
  void setColumns(unsigned int);
  void setCacheSize(unsigned int);
  void setHBarTop(int,bool);
  void setVBarLeft(int,bool);
  void setHBarHeight(int,unsigned int);
  void setVBarWidth(int,unsigned int);
  void setVisCols( int side, const std::vector<WorkerTypes::listcol_t> *nv );
  char *getLang();
  char *getTerminalBin();
  unsigned int getRows();
  unsigned int getColumns();
  unsigned int getCacheSize();
  bool getHBarTop(int);
  bool getVBarLeft(int);
  unsigned int getHBarHeight(int);
  unsigned int getVBarWidth(int);
  const std::vector<WorkerTypes::listcol_t> *getVisCols( int side ) const;
  void setStatusbar(int,int);
  void setSelLVB(int,int);
  void setUnselLVB(int,int);
  void setSelDir(int,int);
  void setUnselDir(int,int);
  void setSelFile(int,int);
  void setUnselFile(int,int);
  void setSelDirAct(int,int);
  void setUnselDirAct(int,int);
  void setSelFileAct(int,int);
  void setUnselFileAct(int,int);
  void setClockbar(int,int);
  void setRequest(int,int);
  void setLVHeader( int, int );
  int getStatusbar(int) const;
  int getSelLVB(int) const;
  int getUnselLVB(int) const;
  int getSelDir(int) const;
  int getUnselDir(int) const;
  int getSelFile(int) const;
  int getUnselFile(int) const;
  int getSelDirAct(int) const;
  int getUnselDirAct(int) const;
  int getSelFileAct(int) const;
  int getUnselFileAct(int) const;
  int getClockbar(int) const;
  int getRequest(int) const;
  int getLVHeader( int ) const;
  void setStartDir(int,const char*);
  char *getStartDir(int);
  void setFont(int,const char*);
  char *getFont(int);
  void setPaths(List*);
  List *getPaths();
  void setFiletypes(List*);
  List *getFiletypes();
  void setHotkeys(List*);
  List *getHotkeys();
  void setButtons(List*);
  List *getButtons();
  void setColors(List*);
  List *getColors();
  void setColor( int nr, int red, int green, int blue );
  void resetColors();
  void cleanUpPaths();
  void cleanUpButtons();
  void setOwnerstringtype(int);
  int getOwnerstringtype();
  void setClockbarMode(clockbar_mode_t);
  clockbar_mode_t getClockbarMode();
  void setClockbarUpdatetime(int);
  int getClockbarUpdatetime();
  void setClockbarCommand(const char *);
  const char *getClockbarCommand();
  void setDontCheckDirs(List*);
  List *getDontCheckDirs();
  void setDontCheckVirtual( bool );
  bool getDontCheckVirtual() const;
  void setShowStringForDirSize(bool nv);
  bool getShowStringForDirSize();
  void setStringForDirSize(const char *nv);
  const char *getStringForDirSize();

  void applyColorList(List *);

  bool configure();

  int palette();
  int palette(int);
  bool save();
  bool saveas(char*);
  bool load();
  bool loadfrom(char*);
  
  const char *getHome();
  WCFiletype *getnotyettype();
  WCFiletype *getdirtype();
  WCFiletype *getvoidtype();
  WCFiletype *getunknowntype();
  void applyLanguage();
  
  int savesize(int w,int h);
  int loadsize(int *w,int *h);
  
  const char *getTerminalStr();
  void setListerBG(int);
  int getListerBG();
  int getStringForDirSizeLen();

  void setDateFormat( int nv );
  int getDateFormat();
  void setDateFormatString( const char *nv );
  const char *getDateFormatString();
  void setDateSubst( bool nv );
  bool getDateSubst();
  void setTimeFormat( int nv );
  int getTimeFormat();
  void setTimeFormatString( const char *nv );
  const char *getTimeFormatString();
  void setDateBeforeTime( bool nv );
  bool getDateBeforeTime();
  
  void setShowHeader( int side, bool nv );
  bool getShowHeader( int side ) const;

  int getDatelen( const struct tm *timeptr );
  int writeDateToString( char *buf, int maxlen, struct tm *timeptr );
  
  bool checkForNewerConfig();
  time_t getFileConfigMod();
  
  void clearVisCols( int side );
  void addListCol( int side, WorkerTypes::listcol_t nv );
  
    void setLayoutOrders( const std::list< LayoutSettings::layoutID_t > &nl );
    const std::list< LayoutSettings::layoutID_t > &getLayoutOrders() const;
    void setLayoutButtonVert( bool nv );
    bool getLayoutButtonVert() const;
    void setLayoutListviewVert( bool nv );
    bool getLayoutListviewVert() const;
    void clearLayoutOrders();
    void layoutAddEntry( LayoutSettings::layoutID_t nv );
    void setLayoutListViewWeight( int nv );
    int getLayoutListViewWeight() const;

  FlatTypeList *getFlatTypeList();
  typedef enum { MOUSECONF_NORMAL_MODE,
		 MOUSECONF_ALT_MODE } mouseconf_method_t;
  void setMouseSelectButton( int nv );
  void setMouseActivateButton( int nv );
  void setMouseScrollButton( int nv );
  void setMouseContextButton( int nv );
  void setMouseSelectMethod( mouseconf_method_t nv );
  int getMouseSelectButton() const;
  int getMouseActivateButton() const;
  int getMouseScrollButton() const;
  int getMouseContextButton() const;
  mouseconf_method_t getMouseSelectMethod() const;
  void setMouseActivateMod( int nv );
  void setMouseScrollMod( int nv );
  void setMouseContextMod( int nv );
  int getMouseActivateMod() const;
  int getMouseScrollMod() const;
  int getMouseContextMod() const;

  bool configureButtonIndex( int index );
  bool configurePathIndex( int index );
  bool configureHotkeyIndex( int index );
  bool configureFiletype(WCFiletype*);

  static bool isCorrectTerminalBin(const char*);
  int loadImportConfig( const char *filename, bool &import_buttons, bool &import_hotkeys, bool &import_filetypes, WConfig **return_config );
  int cfg_export( const char *filename );

  int addButtons( List *bl );
  int addHotkeys( List *hl );
  int addFiletypes( List *fl );

  static bool getAlwaysKeepOldKey();
  static void setAlwaysKeepOldKey( bool nv );
  static int fixDoubleKeys( List *bl, List *pl, List *hl, WCButton *im_b1, WCHotkey *im_h1 );
  static int fixDoubleKeys( List *bl, List *pl, List *hl, List *button_check, List *hotkey_check );

  static int getNrOfPreDates();
  static int getNrOfPreTimes();
  static const char *getPreDate( int pos );
  static const char *getPreTime( int pos );

  class ColorDef
  {
  public:
      ColorDef();
      ~ColorDef();
      ColorDef &operator=( const ColorDef &other );

      void setTextViewTextColor( int col );
      int getTextViewTextColor() const;

      void setTextViewBackground( int col );
      int getTextViewBackground() const;

      void setTextViewHighlightedFG( int col );
      int getTextViewHighlightedFG() const;

      void setTextViewHighlightedBG( int col );
      int getTextViewHighlightedBG() const;

      void setTextViewSelectionFG( int col );
      int getTextViewSelectionFG() const;

      void setTextViewSelectionBG( int col );
      int getTextViewSelectionBG() const;

      typedef struct _label_colors_t {
          _label_colors_t() : normal_fg( 1 ),
                              normal_bg( 0 ),
                              active_fg( 1 ),
                              active_bg( 0 ) {}
          
          int normal_fg, normal_bg;
          int active_fg, active_bg;
      } label_colors_t;

      void setLabelColors( const std::map<std::string, label_colors_t> &cols );
      const std::map<std::string, label_colors_t> &getLabelColors() const;
      const label_colors_t &getLabelColor( const std::string &label ) const;
      void addLabelColor( const std::string &label,
                          const label_colors_t &col );
      void removeLabelColor( const std::string &label );
  private:
      struct {
          int textcolor, background;
          int highlightedfg, highlightedbg;
          int selectionfg, selectionbg;
      } _textview_colors;

      std::map<std::string, label_colors_t> m_label_colors;
  };

  void setColorDefs( const ColorDef &cols );
  const ColorDef &getColorDefs() const;

  int getAllCustomNames( std::vector<std::string> &custom_names );

  void setSaveWorkerStateOnExit( bool nv );
  bool getSaveWorkerStateOnExit() const;

  typedef enum {
      FONT_X11_GLOBAL,
      FONT_X11_BUTTONS,
      FONT_X11_LEFT,
      FONT_X11_RIGHT,
      FONT_XFT_GLOBAL,
      FONT_XFT_BUTTONS,
      FONT_XFT_LEFT,
      FONT_XFT_RIGHT
  } font_type_t;

  void setFontName( font_type_t fonttype, const std::string &name );
  std::string getFontName( font_type_t fonttype );
protected:
  char *lang;
  unsigned int rows,columns;
  unsigned int cachesize;
  List *colors;
  bool hbar_top[2];
  bool vbar_left[2];
  unsigned int hbar_height[2];
  unsigned int vbar_width[2];
  std::vector<WorkerTypes::listcol_t> viscols[2];
  int statusbar[2];
  int sel_lvb[2];
  int unsel_lvb[2];
  int sel_dir[2];
  int unsel_dir[2];
  int sel_file[2];
  int unsel_file[2];
  int sel_dir_act[2];
  int unsel_dir_act[2];
  int sel_file_act[2];
  int unsel_file_act[2];
  int clockbar[2];
  int request[2];
  int lvheader[2];
  char *dir[2];  // left=0, right=1
  char *fonts[4];  // global, buttons, left lister, right lister
  List *paths;  // Elemente sind WCPath
  List *filetypes; // Elemente sind WCFiletype
  List *hotkeys; // Elemente sind WCHotkey
  List *buttons; // Elemente sind WCButton
  clockbar_mode_t clockbar_mode;
  int clockbar_updatetime;
  char *clockbar_command;
  List *dontcheckdirs;
  bool dontcheckvirtual;
  
    LayoutSettings m_layout_conf;

  struct {
    int select_button, activate_button, scroll_button, context_button;
    mouseconf_method_t select_method;
    int activate_mod, scroll_mod, context_mod;
  } mouseConf;
  
  char *terminalbin;
  
  int ownerstringtype;
  
  bool showStringForDirSize;
  char *stringForDirSize;
  int stringForDirSizeLen;
  bool showHeader[2];
  
  WCFiletype *notyettype; // Nur zum schnelleren Auslesen, muss nicht abgespeichert werden
  WCFiletype *dirtype; // Nur zum schnelleren Auslesen, muss nicht abgespeichert werden
  WCFiletype *voidtype; // Nur zum schnelleren Auslesen, muss nicht abgespeichert werden
  WCFiletype *unknowntype; // Nur zum schnelleren Auslesen, muss nicht abgespeichert werden
  
  char *home;
  Worker *worker;

  bool changeTypes( bool allowRemoveUnique );
  bool changeHotkeys();
  bool changeButtons();
  bool changeDisplaySets(int);
  
  bool configurePath(WCPath*);
  int grabKey( const char *title, const char *text, KeySym *return_key, unsigned int *return_mod );
  int getDoubleShortkey( bool doublek,
                         const WCButton *ignore_b,
                         const WCHotkey *ignore_h,
                         const WCPath *ignore_p,
                         WCDoubleShortkey **return_dk);
  static int findDoubleShortkey( WCDoubleShortkey *dk,
                                 List *button_list,
                                 List *path_list,
                                 List *hotkey_list,
                                 WCButton **return_button,
                                 WCPath **return_path,
                                 WCHotkey **return_hotkey );
  int addButton( List *bl, WCButton *b );
  int addHotkey( List *hl, WCHotkey *h );
  int addFiletype( List *fl, WCFiletype *f );

  static bool always_keep_old_key;

  bool configureHotkey(WCHotkey*);
  FunctionProto *requestCommand();
  static int requestCommand_sf(void*,void*);

  bool configureButton(WCButton*);
  //bool configureFiletype(WCFiletype*);
  void showFTActions( const char*, WCFiletype*, FieldListView*, List** );
  bool changeFiledesc(WCFiletype*);
  char *getStr4Char(int,short);
  int WCEditByte(int ch);
  bool FTautocreate(WCFiletype *);
  void initFixTypes();
  void setDefaultConfig();

  int listerbg;
  
  int export2file( bool export_buttons,
                   bool export_hotkeys,
                   bool export_types,
                   const char *filename );
  int configureForImport( int nrb, bool &import_buttons, bool &import_hotkeys, bool &import_filetypes );
  
  int date_format;  // -1 = user-defined
                    // >=0 any of the predefined
  char *date_formatstring;
  bool date_subst;
  
  int time_format; // as above
  char *time_formatstring;
  
  bool date_before_time;
  
  int configureButtonSize[2];
  int changeTypesSize[2];
  int changeHotkeysSize[2];
  int configureFiletypeSize[2];
  int configureHotkeySize[2];
  char *lastRequestCommand;
  time_t currentConfigTime;
  
  bool loadBinConfig( const char * );
  int loadBinColor( Datei *fh, WC_Color *col );
  int loadBinPath( Datei *fh, WCPath *p1 );
  int loadBinFiletype( Datei *fh, WCFiletype *f1 );
  int loadBinHotkey( Datei *fh, WCHotkey *h1 );
  int loadBinButton( Datei *fh, WCButton *b1 );
  int loadBinShortkey( Datei *fh, WCDoubleShortkey *key );
  int loadBinDoubleShortkey( Datei *fh, WCDoubleShortkey *dk );
  int loadBinGlobalFlags( Datei *fh );
  List *loadBinFunction( Datei *fh );

  ColorDef _color_defs;
  
  std::string queryNewActionName();

  bool m_save_worker_state_on_exit;

  std::map< font_type_t, std::string > m_font_names;
  void setFontNames( const std::map< font_type_t, std::string > &font_names );
  std::map< font_type_t, std::string > getFontNames() const;
};

extern WConfig *wconfig;

#endif

/* Local Variables: */
/* mode:c++ */
/* End: */
