/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.wstream;

import java.io.IOException;
import java.io.StringWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.stax.test.wstream.BaseWriterTest;

public class TestRepairingWriter
extends BaseWriterTest {
    public void testElements() throws IOException, XMLStreamException {
        StringWriter strw = new StringWriter();
        XMLStreamWriter w = this.getRepairingWriter(strw);
        String URL_P1 = "http://p1.org";
        String URL_P2 = "http://ns.p2.net/yeehaw.html";
        String URL_DEF = "urn:default";
        String TEXT = "  some text\n";
        w.writeStartDocument();
        w.setPrefix("p1", "http://p1.org");
        w.writeStartElement("http://p1.org", "test");
        w.writeStartElement("p2", "branch", "http://ns.p2.net/yeehaw.html");
        w.writeStartElement("urn:default", "leaf");
        w.writeCharacters("  some text\n");
        w.writeEndElement();
        w.writeEmptyElement("http://p1.org", "leaf");
        w.writeStartElement("", "third");
        w.writeEndElement();
        w.writeEndElement();
        w.writeEndElement();
        w.writeEndDocument();
        w.close();
        XMLStreamReader sr = this.constructNsStreamReader(strw.toString());
        TestRepairingWriter.assertTokenType(7, sr.getEventType(), sr);
        TestRepairingWriter.assertTokenType(1, sr.next(), sr);
        TestRepairingWriter.assertEquals((String)"test", (String)sr.getLocalName());
        TestRepairingWriter.assertEquals((String)"http://p1.org", (String)sr.getNamespaceURI());
        TestRepairingWriter.assertTokenType(1, sr.next(), sr);
        TestRepairingWriter.assertEquals((String)"branch", (String)sr.getLocalName());
        TestRepairingWriter.assertEquals((String)"http://ns.p2.net/yeehaw.html", (String)sr.getNamespaceURI());
        TestRepairingWriter.assertTokenType(1, sr.next(), sr);
        TestRepairingWriter.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestRepairingWriter.assertEquals((String)"urn:default", (String)sr.getNamespaceURI());
        TestRepairingWriter.assertTokenType(4, sr.next(), sr);
        TestRepairingWriter.assertEquals((String)"  some text\n", (String)TestRepairingWriter.getAllText(sr));
        TestRepairingWriter.assertTokenType(2, sr.getEventType(), sr);
        TestRepairingWriter.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestRepairingWriter.assertEquals((String)"urn:default", (String)sr.getNamespaceURI());
        TestRepairingWriter.assertTokenType(1, sr.next(), sr);
        TestRepairingWriter.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestRepairingWriter.assertEquals((String)"http://p1.org", (String)sr.getNamespaceURI());
        TestRepairingWriter.assertTokenType(2, sr.next(), sr);
        TestRepairingWriter.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestRepairingWriter.assertEquals((String)"http://p1.org", (String)sr.getNamespaceURI());
        TestRepairingWriter.assertTokenType(1, sr.next(), sr);
        TestRepairingWriter.assertEquals((String)"third", (String)sr.getLocalName());
        TestRepairingWriter.assertNoNsURI(sr);
        TestRepairingWriter.assertTokenType(2, sr.next(), sr);
        TestRepairingWriter.assertEquals((String)"third", (String)sr.getLocalName());
        TestRepairingWriter.assertNoNsURI(sr);
        TestRepairingWriter.assertTokenType(2, sr.next(), sr);
        TestRepairingWriter.assertEquals((String)"branch", (String)sr.getLocalName());
        TestRepairingWriter.assertEquals((String)"http://ns.p2.net/yeehaw.html", (String)sr.getNamespaceURI());
        TestRepairingWriter.assertTokenType(2, sr.next(), sr);
        TestRepairingWriter.assertEquals((String)"test", (String)sr.getLocalName());
        TestRepairingWriter.assertEquals((String)"http://p1.org", (String)sr.getNamespaceURI());
        TestRepairingWriter.assertTokenType(8, sr.next(), sr);
    }

    public void testAttributeSimple() throws IOException, XMLStreamException {
        StringWriter strw = new StringWriter();
        XMLStreamWriter w = this.getRepairingWriter(strw);
        String URL_P1 = "http://p1.org";
        String ATTR_VALUE = "'value'&\"another\"";
        w.writeStartDocument();
        w.writeStartElement("", "test");
        w.writeAttribute("http://p1.org", "attr", "'value'&\"another\"");
        w.writeEndElement();
        w.writeEndDocument();
        w.close();
        XMLStreamReader sr = this.constructNsStreamReader(strw.toString());
        TestRepairingWriter.assertTokenType(7, sr.getEventType(), sr);
        TestRepairingWriter.assertTokenType(1, sr.next(), sr);
        TestRepairingWriter.assertEquals((String)"test", (String)sr.getLocalName());
        TestRepairingWriter.assertNoNsURI(sr);
        TestRepairingWriter.assertEquals((int)1, (int)sr.getAttributeCount());
        TestRepairingWriter.assertEquals((String)"attr", (String)sr.getAttributeLocalName(0));
        TestRepairingWriter.assertEquals((String)"http://p1.org", (String)sr.getAttributeNamespace(0));
        TestRepairingWriter.assertEquals((String)"'value'&\"another\"", (String)sr.getAttributeValue(0));
        TestRepairingWriter.assertTokenType(2, sr.next(), sr);
        TestRepairingWriter.assertEquals((String)"test", (String)sr.getLocalName());
        TestRepairingWriter.assertNoNsURI(sr);
        TestRepairingWriter.assertTokenType(8, sr.next(), sr);
    }

    public void testAttributes() throws IOException, XMLStreamException {
        StringWriter strw = new StringWriter();
        XMLStreamWriter w = this.getRepairingWriter(strw);
        String URL_P1 = "http://p1.org";
        String URL_DEF = "urn:default";
        String ATTR_VALUE = "'value\"";
        String ATTR_VALUE2 = "<tag>";
        w.writeStartDocument();
        w.setDefaultNamespace("urn:default");
        w.writeStartElement("urn:default", "test");
        w.writeStartElement("", "leaf", "urn:default");
        w.writeAttribute("urn:default", "attr", "'value\"");
        w.writeEndElement();
        w.writeEmptyElement("", "leaf");
        w.writeStartElement("urn:default", "leaf");
        w.writeAttribute("", "attr2", "<tag>");
        w.writeEndElement();
        w.writeEndElement();
        w.writeEndDocument();
        w.close();
        XMLStreamReader sr = this.constructNsStreamReader(strw.toString());
        TestRepairingWriter.assertTokenType(7, sr.getEventType(), sr);
        TestRepairingWriter.assertTokenType(1, sr.next(), sr);
        TestRepairingWriter.assertEquals((String)"test", (String)sr.getLocalName());
        TestRepairingWriter.assertEquals((String)"urn:default", (String)sr.getNamespaceURI());
        TestRepairingWriter.assertTokenType(1, sr.next(), sr);
        TestRepairingWriter.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestRepairingWriter.assertEquals((String)"urn:default", (String)sr.getNamespaceURI());
        TestRepairingWriter.assertEquals((int)1, (int)sr.getAttributeCount());
        TestRepairingWriter.assertEquals((String)"attr", (String)sr.getAttributeLocalName(0));
        String uri = sr.getAttributeNamespace(0);
        if (!"urn:default".equals(uri)) {
            TestRepairingWriter.fail((String)("Expected attribute 'attr' to have NS 'urn:default', was " + TestRepairingWriter.valueDesc(uri) + "; input = '" + strw + "'"));
        }
        TestRepairingWriter.assertEquals((String)"'value\"", (String)sr.getAttributeValue(0));
        TestRepairingWriter.assertTokenType(2, sr.next(), sr);
        TestRepairingWriter.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestRepairingWriter.assertEquals((String)"urn:default", (String)sr.getNamespaceURI());
        TestRepairingWriter.assertTokenType(1, sr.next(), sr);
        TestRepairingWriter.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestRepairingWriter.assertNull((String)"Element <leaf/> should not be in a namespace", (Object)sr.getNamespaceURI());
        TestRepairingWriter.assertTokenType(2, sr.next(), sr);
        TestRepairingWriter.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestRepairingWriter.assertNull((Object)sr.getNamespaceURI());
        TestRepairingWriter.assertTokenType(1, sr.next(), sr);
        TestRepairingWriter.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestRepairingWriter.assertEquals((String)"urn:default", (String)sr.getNamespaceURI());
        TestRepairingWriter.assertEquals((int)1, (int)sr.getAttributeCount());
        TestRepairingWriter.assertEquals((String)"attr2", (String)sr.getAttributeLocalName(0));
        String nsURI = sr.getAttributeNamespace(0);
        if (nsURI != null) {
            TestRepairingWriter.fail((String)("Attribute 'attr2' should not belong to a namespace; reported to belong to '" + nsURI + "'"));
        }
        TestRepairingWriter.assertEquals((String)"<tag>", (String)sr.getAttributeValue(0));
        TestRepairingWriter.assertTokenType(2, sr.next(), sr);
        TestRepairingWriter.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestRepairingWriter.assertEquals((String)"urn:default", (String)sr.getNamespaceURI());
        TestRepairingWriter.assertTokenType(2, sr.next(), sr);
        TestRepairingWriter.assertEquals((String)"test", (String)sr.getLocalName());
        TestRepairingWriter.assertEquals((String)"urn:default", (String)sr.getNamespaceURI());
        TestRepairingWriter.assertTokenType(8, sr.next(), sr);
    }

    public void testSiblingNsBinding() throws IOException, XMLStreamException {
        StringWriter strw = new StringWriter();
        XMLStreamWriter w = this.getRepairingWriter(strw);
        String URL_P1 = "http://p1.org";
        w.writeStartDocument();
        w.writeStartElement("root");
        w.writeStartElement("leaf1");
        w.writeAttribute("http://p1.org", "attr1", "1");
        w.writeEndElement();
        w.writeStartElement("leaf2");
        w.writeAttribute("http://p1.org", "attr2", "2");
        w.writeEndElement();
        w.writeEndDocument();
        w.close();
        XMLStreamReader sr = this.constructNsStreamReader(strw.toString());
        TestRepairingWriter.assertTokenType(1, sr.next(), sr);
        TestRepairingWriter.assertEquals((String)"root", (String)sr.getLocalName());
        TestRepairingWriter.assertTokenType(1, sr.next(), sr);
        TestRepairingWriter.assertEquals((String)"leaf1", (String)sr.getLocalName());
        TestRepairingWriter.assertEquals((int)1, (int)sr.getAttributeCount());
        TestRepairingWriter.assertEquals((String)"attr1", (String)sr.getAttributeLocalName(0));
        TestRepairingWriter.assertEquals((String)"1", (String)sr.getAttributeValue(0));
        TestRepairingWriter.assertEquals((String)"http://p1.org", (String)sr.getAttributeNamespace(0));
        TestRepairingWriter.assertEquals((int)1, (int)sr.getNamespaceCount());
        TestRepairingWriter.assertTokenType(2, sr.next(), sr);
        TestRepairingWriter.assertEquals((String)"http://p1.org", (String)sr.getNamespaceURI(0));
        TestRepairingWriter.assertTokenType(1, sr.next(), sr);
        TestRepairingWriter.assertEquals((String)"leaf2", (String)sr.getLocalName());
        TestRepairingWriter.assertEquals((int)1, (int)sr.getAttributeCount());
        TestRepairingWriter.assertEquals((String)"attr2", (String)sr.getAttributeLocalName(0));
        TestRepairingWriter.assertEquals((String)"2", (String)sr.getAttributeValue(0));
        TestRepairingWriter.assertEquals((String)"http://p1.org", (String)sr.getAttributeNamespace(0));
        TestRepairingWriter.assertEquals((int)1, (int)sr.getNamespaceCount());
        TestRepairingWriter.assertTokenType(2, sr.next(), sr);
        TestRepairingWriter.assertEquals((String)"http://p1.org", (String)sr.getNamespaceURI(0));
        TestRepairingWriter.assertTokenType(2, sr.next(), sr);
        TestRepairingWriter.assertTokenType(8, sr.next(), sr);
    }

    public void testOptimalDefaultNsDecls() throws IOException, XMLStreamException {
        StringWriter strw = new StringWriter();
        XMLStreamWriter w = this.getRepairingWriter(strw);
        String URL_P1 = "http://p1.org";
        w.writeStartDocument();
        w.writeStartElement("", "test", "http://p1.org");
        w.writeStartElement("", "leaf", "http://p1.org");
        w.writeEndElement();
        w.writeEndElement();
        w.writeEndDocument();
        w.close();
        XMLStreamReader sr = this.constructNsStreamReader(strw.toString());
        TestRepairingWriter.assertTokenType(7, sr.getEventType(), sr);
        TestRepairingWriter.assertTokenType(1, sr.next(), sr);
        TestRepairingWriter.assertEquals((String)"test", (String)sr.getLocalName());
        TestRepairingWriter.assertEquals((String)"http://p1.org", (String)sr.getNamespaceURI());
        TestRepairingWriter.assertEquals((int)1, (int)sr.getNamespaceCount());
        TestRepairingWriter.assertEquals((String)"http://p1.org", (String)sr.getNamespaceURI(0));
        TestRepairingWriter.assertTokenType(1, sr.next(), sr);
        TestRepairingWriter.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestRepairingWriter.assertEquals((String)"http://p1.org", (String)sr.getNamespaceURI());
        TestRepairingWriter.assertEquals((int)0, (int)sr.getNamespaceCount());
        sr.close();
    }

    public void testOptimalNonDefaultNsDecls() throws IOException, XMLStreamException {
        StringWriter strw = new StringWriter();
        XMLStreamWriter w = this.getRepairingWriter(strw);
        String URL_P1 = "http://p1.org";
        w.writeStartDocument();
        w.writeStartElement("http://p1.org", "test");
        w.writeStartElement("http://p1.org", "leaf");
        w.writeEndElement();
        w.writeEndElement();
        w.writeEndDocument();
        w.close();
        XMLStreamReader sr = this.constructNsStreamReader(strw.toString());
        TestRepairingWriter.assertTokenType(7, sr.getEventType(), sr);
        TestRepairingWriter.assertTokenType(1, sr.next(), sr);
        TestRepairingWriter.assertEquals((String)"test", (String)sr.getLocalName());
        TestRepairingWriter.assertEquals((String)"http://p1.org", (String)sr.getNamespaceURI());
        TestRepairingWriter.assertEquals((int)1, (int)sr.getNamespaceCount());
        TestRepairingWriter.assertEquals((String)"http://p1.org", (String)sr.getNamespaceURI(0));
        TestRepairingWriter.assertTokenType(1, sr.next(), sr);
        TestRepairingWriter.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestRepairingWriter.assertEquals((String)"http://p1.org", (String)sr.getNamespaceURI());
        TestRepairingWriter.assertEquals((int)0, (int)sr.getNamespaceCount());
        sr.close();
    }
}

