/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.vstream;

import java.io.StringReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax.test.SimpleResolver;
import org.codehaus.stax.test.vstream.BaseVStreamTest;

public class TestIncludes
extends BaseVStreamTest {
    public void testSimpleInclude() throws XMLStreamException {
        String XML = "<!DOCTYPE root SYSTEM 'foobar'><root>&myent;</root>";
        String EXT_DTD = "<!ELEMENT root (#PCDATA)>\n<![INCLUDE[  <!ENTITY myent 'value'>]]>\n";
        XMLInputFactory f = this.getValidatingFactory(true);
        TestIncludes.setResolver(f, new SimpleResolver("<!ELEMENT root (#PCDATA)>\n<![INCLUDE[  <!ENTITY myent 'value'>]]>\n"));
        XMLStreamReader sr = f.createXMLStreamReader(new StringReader("<!DOCTYPE root SYSTEM 'foobar'><root>&myent;</root>"));
        TestIncludes.assertTokenType(11, sr.next());
        TestIncludes.assertTokenType(1, sr.next());
        TestIncludes.assertTokenType(4, sr.next());
        TestIncludes.assertEquals((String)"value", (String)TestIncludes.getAndVerifyText(sr));
        TestIncludes.assertTokenType(2, sr.next());
    }

    public void testSimpleIgnore() throws XMLStreamException {
        String XML = "<!DOCTYPE root SYSTEM 'foobar'><root>&myent;</root>";
        String EXT_DTD = "<!ELEMENT root (#PCDATA)>\n<![IGNORE[  <!FOOBAR> <!-- nonsense, but ignored! -->]]>\n<!ENTITY myent 'value'>";
        XMLInputFactory f = this.getValidatingFactory(true);
        TestIncludes.setResolver(f, new SimpleResolver("<!ELEMENT root (#PCDATA)>\n<![IGNORE[  <!FOOBAR> <!-- nonsense, but ignored! -->]]>\n<!ENTITY myent 'value'>"));
        XMLStreamReader sr = f.createXMLStreamReader(new StringReader("<!DOCTYPE root SYSTEM 'foobar'><root>&myent;</root>"));
        TestIncludes.assertTokenType(11, sr.next());
        TestIncludes.assertTokenType(1, sr.next());
        TestIncludes.assertTokenType(4, sr.next());
        TestIncludes.assertEquals((String)"value", (String)TestIncludes.getAndVerifyText(sr));
        TestIncludes.assertTokenType(2, sr.next());
    }

    public void testFailingInIntSubset() throws XMLStreamException {
        String XML = "<!DOCTYPE root [\n<![INCLUDE[  <!ENTITY myent 'value'>]]>]>\n<root />";
        this.streamThroughFailing(this.getValidatingReader(XML), "Condition INCLUDE not allowed in internal DTD subset");
        XML = "<!DOCTYPE root [\n<![IGNORE[  <!ENTITY myent 'value'>]]>  <!ENTITY myent2 'value'>]>\n<root />";
        this.streamThroughFailing(this.getValidatingReader(XML), "Condition INCLUDE not allowed in internal DTD subset");
    }

    public void testPEIncludeAndIgnore() throws XMLStreamException {
        String XML = "<!DOCTYPE root SYSTEM 'foobar'><root>&myent;</root>";
        String EXT_DTD = "<!ENTITY % yup 'INCLUDE' >\n<!ENTITY % nope 'IGNORE' >\n<![%nope;[\n<!ENTITY myent 'ignore'>\n]]>\n<![%yup;[\n<!ENTITY myent 'include'>\n]]>\n<!ELEMENT root (#PCDATA)>\n";
        XMLInputFactory f = this.getValidatingFactory(true);
        TestIncludes.setResolver(f, new SimpleResolver("<!ENTITY % yup 'INCLUDE' >\n<!ENTITY % nope 'IGNORE' >\n<![%nope;[\n<!ENTITY myent 'ignore'>\n]]>\n<![%yup;[\n<!ENTITY myent 'include'>\n]]>\n<!ELEMENT root (#PCDATA)>\n"));
        XMLStreamReader sr = f.createXMLStreamReader(new StringReader("<!DOCTYPE root SYSTEM 'foobar'><root>&myent;</root>"));
        TestIncludes.assertTokenType(11, sr.next());
        TestIncludes.assertTokenType(1, sr.next());
        TestIncludes.assertTokenType(4, sr.next());
        String text = TestIncludes.getAndVerifyText(sr);
        if (!text.equals("include")) {
            TestIncludes.fail((String)("Expected 'myent' to expand to 'include', not '" + text + "'"));
        }
        TestIncludes.assertTokenType(2, sr.next());
    }
}

