/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.stream;

import java.util.NoSuchElementException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax.test.stream.BaseStreamTest;

public class TestMisc
extends BaseStreamTest {
    public TestMisc(String name) {
        super(name);
    }

    public void testRequire() throws XMLStreamException {
        String XML = "<root><!-- comment --><?proc instr?><tag>Text</tag><tag><![CDATA[xx]]></tag><a:empty xmlns:a='http://foo' /></root>";
        XMLStreamReader sr = this.getReader(XML, true, true);
        sr.require(7, null, null);
        TestMisc.assertTokenType(1, sr.next());
        TestMisc.assertTokenType(5, sr.next());
        sr.require(5, null, null);
        try {
            sr.require(5, null, "tag");
            TestMisc.fail((String)"Should have thrown an exception when checking local name of a COMMENT");
        }
        catch (XMLStreamException e) {
            // empty catch block
        }
        TestMisc.assertTokenType(3, sr.next());
        sr.require(3, null, null);
        TestMisc.assertTokenType(1, sr.next());
        sr.require(1, null, "tag");
        sr.require(1, "", "tag");
        try {
            sr.require(1, "http://foo", "tag");
            TestMisc.fail((String)"Should have thrown an exception for incorrect NS URI");
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
        TestMisc.assertTokenType(4, sr.next());
        sr.require(4, null, null);
        TestMisc.assertTokenType(2, sr.next());
        sr.require(2, null, "tag");
        sr.require(2, "", "tag");
        TestMisc.assertTokenType(1, sr.next());
        TestMisc.assertTokenType(4, sr.next());
        sr.require(4, null, null);
        TestMisc.assertTokenType(2, sr.next());
        TestMisc.assertTokenType(1, sr.next());
        sr.require(1, "http://foo", "empty");
        TestMisc.assertTokenType(2, sr.next());
        sr.require(2, "http://foo", "empty");
        sr.require(2, "http://foo", null);
        sr.require(2, null, "empty");
        TestMisc.assertTokenType(2, sr.next());
        sr.require(2, "", "root");
        TestMisc.assertTokenType(8, sr.next());
        sr.require(8, null, null);
    }

    public void testGetElementText() throws XMLStreamException {
        String XML = "<root><tag>Got some <!-- comment --> text &apos;n stuff!</tag><tag><?proc instr?>more <![CDATA[stuff]]> </tag><tag><empty /></tag></root>";
        XMLStreamReader sr = this.getReader(XML, true, false);
        TestMisc.assertTokenType(1, sr.next());
        TestMisc.assertTokenType(1, sr.next());
        TestMisc.assertEquals((String)"Got some  text 'n stuff!", (String)sr.getElementText());
        TestMisc.assertTokenType(2, sr.getEventType());
        TestMisc.assertTokenType(1, sr.next());
        TestMisc.assertEquals((String)"more stuff ", (String)sr.getElementText());
        TestMisc.assertTokenType(2, sr.getEventType());
        TestMisc.assertTokenType(1, sr.next());
        try {
            String str = sr.getElementText();
            TestMisc.fail((String)"Expected an exception for nested start element");
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    public void testNextTag() throws XMLStreamException {
        String XML = "<root>   <tag>   </tag><tag><leaf />   </tag><tag>text</tag>";
        XMLStreamReader sr = this.getReader(XML, true, false);
        TestMisc.assertTokenType(1, sr.nextTag());
        TestMisc.assertEquals((String)"root", (String)sr.getLocalName());
        TestMisc.assertTokenType(1, sr.nextTag());
        TestMisc.assertTokenType(2, sr.nextTag());
        TestMisc.assertEquals((String)"tag", (String)sr.getLocalName());
        TestMisc.assertTokenType(1, sr.nextTag());
        TestMisc.assertEquals((String)"tag", (String)sr.getLocalName());
        TestMisc.assertTokenType(1, sr.nextTag());
        TestMisc.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestMisc.assertTokenType(2, sr.nextTag());
        TestMisc.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestMisc.assertTokenType(2, sr.nextTag());
        TestMisc.assertEquals((String)"tag", (String)sr.getLocalName());
        TestMisc.assertTokenType(1, sr.nextTag());
        TestMisc.assertEquals((String)"tag", (String)sr.getLocalName());
        try {
            int type = sr.nextTag();
            TestMisc.fail((String)"Expected an exception for non-whitespace text");
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    public void testNextTagWithCommentsAndPIs() throws XMLStreamException {
        String XML = "<root>   <!-- comment -->   <leaf />\n<leaf><?target data.. ?></leaf>\n<leaf><!-- comment --><!-- comment --> <!--comment--></leaf>\n<leaf><?target data.. ?><!--comment  --><?target?></leaf>\n</root>";
        XMLStreamReader sr = this.getReader(XML, true, false);
        TestMisc.assertTokenType(1, sr.nextTag());
        TestMisc.assertEquals((String)"root", (String)sr.getLocalName());
        TestMisc.assertTokenType(1, sr.nextTag());
        TestMisc.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestMisc.assertTokenType(2, sr.nextTag());
        TestMisc.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestMisc.assertTokenType(1, sr.nextTag());
        TestMisc.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestMisc.assertTokenType(2, sr.nextTag());
        TestMisc.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestMisc.assertTokenType(1, sr.nextTag());
        TestMisc.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestMisc.assertTokenType(2, sr.nextTag());
        TestMisc.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestMisc.assertTokenType(1, sr.nextTag());
        TestMisc.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestMisc.assertTokenType(2, sr.nextTag());
        TestMisc.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestMisc.assertTokenType(2, sr.nextTag());
        TestMisc.assertEquals((String)"root", (String)sr.getLocalName());
    }

    public void testEndOfStream() throws XMLStreamException {
        String XML = "<root>x</root>";
        XMLStreamReader sr = this.getReader(XML, true, true);
        TestMisc.assertTokenType(7, sr.getEventType());
        TestMisc.assertTokenType(1, sr.next());
        TestMisc.assertTokenType(4, sr.next());
        TestMisc.assertTokenType(2, sr.next());
        TestMisc.assertTokenType(8, sr.next());
        TestMisc.assertFalse((boolean)sr.hasNext());
        try {
            int type = sr.next();
            TestMisc.fail((String)("Expected NoSuchElementException when trying to access events after END_DOCUMENT returned (but received event " + TestMisc.tokenTypeDesc(type) + ")"));
        }
        catch (NoSuchElementException ne) {
        }
        catch (XMLStreamException e) {
            TestMisc.fail((String)("Expected NoSuchElementException; received (type " + e.getClass() + "): " + e));
        }
    }

    private XMLStreamReader getReader(String contents, boolean nsAware, boolean coalescing) throws XMLStreamException {
        XMLInputFactory f = this.getInputFactory();
        TestMisc.setNamespaceAware(f, nsAware);
        TestMisc.setSupportDTD(f, true);
        TestMisc.setCoalescing(f, coalescing);
        TestMisc.setReplaceEntities(f, true);
        TestMisc.setValidating(f, false);
        return TestMisc.constructStreamReader(f, contents);
    }
}

