/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.stream;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax.test.stream.BaseStreamTest;

public class TestCommentRead
extends BaseStreamTest {
    public TestCommentRead(String name) {
        super(name);
    }

    public void testValidComments() throws XMLStreamException {
        String XML = "<!-- <comment> --><root />  ";
        this.streamThrough(this.getReader(XML, true));
        this.streamThrough(this.getReader(XML, false));
        XML = "  <root>  </root>  <!-- hee&haw - - -->";
        this.streamThrough(this.getReader(XML, true));
        this.streamThrough(this.getReader(XML, false));
    }

    public void testCommentProperties() throws XMLStreamException {
        this.doTestProperties(true, true);
        this.doTestProperties(true, false);
        this.doTestProperties(false, true);
        this.doTestProperties(false, false);
    }

    public void testInvalidComment() throws XMLStreamException {
        String XML = "<!-- Can not have '--' in here! -->  <root />";
        String XML2 = "<root><!  -- no spaces either--></root>";
        String XML3 = "<root><!- - no spaces either--></root>";
        for (int i = 0; i < 1; ++i) {
            boolean ns = i & true;
            this.streamThroughFailing(this.getReader(XML, ns), "invalid comment content (embedded \"--\")");
            this.streamThroughFailing(this.getReader(XML2, ns), "malformed comment (extra space)");
            this.streamThroughFailing(this.getReader(XML3, ns), "malformed comment (extra space)");
        }
    }

    public void testUnfinishedComment() throws XMLStreamException {
        String XML = "<root><!-- Comment that won't end </root>";
        for (int i = 0; i < 1; ++i) {
            boolean ns = i & true;
            this.streamThroughFailing(this.getReader(XML, ns), "invalid comment (unfinished)");
        }
    }

    public void testRunawayComment() throws XMLStreamException {
        String XML = "<!DOCTYPE root [\n<!ENTITY comm '<!-- start'>\n]><root>&comm;   --></root>";
        XMLStreamReader sr = this.getReader(XML, true);
        try {
            TestCommentRead.assertTokenType(11, sr.next());
            TestCommentRead.assertTokenType(1, sr.next());
            int type = sr.next();
            if (type != 5) {
                this.reportNADueToEntityExpansion("testRunawayComment", type);
                return;
            }
            type = sr.next();
            TestCommentRead.fail((String)("Expected an exception for split/runaway comment (instead got event " + TestCommentRead.tokenTypeDesc(type) + ")"));
        }
        catch (XMLStreamException sex) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testLongComments() throws XMLStreamException {
        String COMMENT1 = "Some longish comment to see if the input buffer size restrictions might apply here: the reference\nimplementation had problems beyond 256 characters\n so let's add at least that much, and preferably quite a bit more\ntoo... Blah blah yadda yadda: also, unquoted '&' and '<' are kosher here\nwithout any specific problems or issues. Is this long enough now? :-)";
        String XML = "<?xml version='1.0'?><!--Some longish comment to see if the input buffer size restrictions might apply here: the reference\nimplementation had problems beyond 256 characters\n so let's add at least that much, and preferably quite a bit more\ntoo... Blah blah yadda yadda: also, unquoted '&' and '<' are kosher here\nwithout any specific problems or issues. Is this long enough now? :-)--><?xml-stylesheet href='xmlconformance.xsl' type='text/xsl'?><!DOCTYPE root [\n <!-- comments in DTD --> <?proc instr too?>\n]><root><!--Some longish comment to see if the input buffer size restrictions might apply here: the reference\nimplementation had problems beyond 256 characters\n so let's add at least that much, and preferably quite a bit more\ntoo... Blah blah yadda yadda: also, unquoted '&' and '<' are kosher here\nwithout any specific problems or issues. Is this long enough now? :-)--></root>";
        XMLStreamReader sr = this.getReader(XML, true);
        TestCommentRead.assertTokenType(5, sr.next());
        TestCommentRead.assertEquals((String)"Some longish comment to see if the input buffer size restrictions might apply here: the reference\nimplementation had problems beyond 256 characters\n so let's add at least that much, and preferably quite a bit more\ntoo... Blah blah yadda yadda: also, unquoted '&' and '<' are kosher here\nwithout any specific problems or issues. Is this long enough now? :-)", (String)TestCommentRead.getAndVerifyText(sr));
        TestCommentRead.assertTokenType(3, sr.next());
        TestCommentRead.assertTokenType(11, sr.next());
        TestCommentRead.assertTokenType(1, sr.next());
        TestCommentRead.assertEquals((String)"root", (String)sr.getLocalName());
        TestCommentRead.assertTokenType(5, sr.next());
        TestCommentRead.assertEquals((String)"Some longish comment to see if the input buffer size restrictions might apply here: the reference\nimplementation had problems beyond 256 characters\n so let's add at least that much, and preferably quite a bit more\ntoo... Blah blah yadda yadda: also, unquoted '&' and '<' are kosher here\nwithout any specific problems or issues. Is this long enough now? :-)", (String)TestCommentRead.getAndVerifyText(sr));
        TestCommentRead.assertTokenType(2, sr.next());
    }

    private void doTestProperties(boolean nsAware, boolean dtd) throws XMLStreamException {
        XMLStreamReader sr = this.getReader("<!--comment & <content>--><root/>", nsAware);
        TestCommentRead.assertEquals((int)5, (int)sr.next());
        TestCommentRead.assertEquals((boolean)false, (boolean)sr.isStartElement());
        TestCommentRead.assertEquals((boolean)false, (boolean)sr.isEndElement());
        TestCommentRead.assertEquals((boolean)false, (boolean)sr.isCharacters());
        TestCommentRead.assertEquals((boolean)false, (boolean)sr.isWhiteSpace());
        TestCommentRead.assertEquals((boolean)false, (boolean)sr.hasName());
        TestCommentRead.assertEquals((boolean)true, (boolean)sr.hasText());
        TestCommentRead.assertNotNull((Object)sr.getLocation());
        if (nsAware) {
            TestCommentRead.assertNotNull((Object)sr.getNamespaceContext());
        }
        for (int i = 0; i < 8; ++i) {
            String method = "";
            try {
                Object result = null;
                switch (i) {
                    case 0: {
                        method = "getName";
                        result = sr.getName();
                        break;
                    }
                    case 1: {
                        method = "getPrefix";
                        result = sr.getPrefix();
                        break;
                    }
                    case 2: {
                        method = "getLocalName";
                        result = sr.getLocalName();
                        break;
                    }
                    case 3: {
                        method = "getNamespaceURI";
                        result = sr.getNamespaceURI();
                        break;
                    }
                    case 4: {
                        method = "getNamespaceCount";
                        result = new Integer(sr.getNamespaceCount());
                        break;
                    }
                    case 5: {
                        method = "getAttributeCount";
                        result = new Integer(sr.getAttributeCount());
                        break;
                    }
                    case 6: {
                        method = "getPITarget";
                        result = sr.getPITarget();
                        break;
                    }
                    case 7: {
                        method = "getPIData";
                        result = sr.getPIData();
                    }
                }
                TestCommentRead.fail((String)("Expected IllegalStateException, when calling " + method + "() for COMMENT"));
                continue;
            }
            catch (IllegalStateException iae) {
                // empty catch block
            }
        }
        String content = TestCommentRead.getAndVerifyText(sr);
        TestCommentRead.assertEquals((String)"comment & <content>", (String)content);
    }

    private XMLStreamReader getReader(String contents, boolean nsAware) throws XMLStreamException {
        XMLInputFactory f = this.getInputFactory();
        TestCommentRead.setCoalescing(f, false);
        TestCommentRead.setNamespaceAware(f, nsAware);
        TestCommentRead.setValidating(f, false);
        return TestCommentRead.constructStreamReader(f, contents);
    }
}

