/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.evt;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.codehaus.stax.test.evt.BaseEventTest;

public class TestEventWriter
extends BaseEventTest {
    public void testNonRepairingNsWrite() throws XMLStreamException {
        XMLOutputFactory f = this.getOutputFactory();
        StringWriter strw = new StringWriter();
        XMLEventWriter w = f.createXMLEventWriter(strw);
        XMLEventFactory evtf = this.getEventFactory();
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        attrs.add(evtf.createAttribute("attr", "value"));
        attrs.add(evtf.createAttribute("ns", "uri", "attr2", "value2"));
        ArrayList<Namespace> ns = new ArrayList<Namespace>();
        ns.add(evtf.createNamespace("ns", "uri"));
        StartElement elem = evtf.createStartElement("", "", "root", attrs.iterator(), ns.iterator());
        w.add(elem);
        w.add(evtf.createEndElement("", "", "root"));
        w.close();
        String contents = strw.toString();
        XMLStreamReader sr = this.getReader(contents, true, true);
        TestEventWriter.assertTokenType(7, sr.getEventType());
        TestEventWriter.assertTokenType(1, sr.next());
        TestEventWriter.assertEquals((String)"root", (String)sr.getLocalName());
        TestEventWriter.assertEquals((int)2, (int)sr.getAttributeCount());
        String ln = sr.getAttributeLocalName(0);
        if (ln.equals("attr")) {
            TestEventWriter.assertEquals((String)"attr2", (String)sr.getAttributeLocalName(1));
            TestEventWriter.assertEquals((String)"ns", (String)sr.getAttributePrefix(1));
            TestEventWriter.assertEquals((String)"uri", (String)sr.getAttributeNamespace(1));
        } else if (ln.equals("attr2")) {
            TestEventWriter.assertEquals((String)"attr", (String)sr.getAttributeLocalName(1));
            TestEventWriter.assertEquals((String)"ns", (String)sr.getAttributePrefix(0));
            TestEventWriter.assertEquals((String)"uri", (String)sr.getAttributeNamespace(0));
        } else {
            TestEventWriter.fail((String)("Unexpected attr local name '" + ln + "' for attribute #0; expected 'attr' or 'attr2'"));
        }
        TestEventWriter.assertTokenType(2, sr.next());
    }

    public void testPassThrough() throws XMLStreamException {
        String INPUT = "<?xml version='1.0' encoding='UTF-8' standalone='yes'?><!DOCTYPE root []>\n<!-- the doc...--><root xmlns:ns='urn:foo'>\n  <branch attr='val' ns:foo='bar'>\n    <ns:leaf xmlns='another-uri' />\n    <?proc instr?>\n<leaf><![CDATA[ Haa: <nottag /> ]]></leaf>\n  </branch>\n  <!-- another comment --></root>";
        XMLEventReader er = this.getEventReader("<?xml version='1.0' encoding='UTF-8' standalone='yes'?><!DOCTYPE root []>\n<!-- the doc...--><root xmlns:ns='urn:foo'>\n  <branch attr='val' ns:foo='bar'>\n    <ns:leaf xmlns='another-uri' />\n    <?proc instr?>\n<leaf><![CDATA[ Haa: <nottag /> ]]></leaf>\n  </branch>\n  <!-- another comment --></root>", true, true);
        List list1 = this.collectEvents(er);
        StringWriter strw = new StringWriter();
        XMLOutputFactory f = this.getOutputFactory();
        XMLEventWriter ew = f.createXMLEventWriter(strw);
        Iterator it = list1.iterator();
        while (it.hasNext()) {
            ew.add((XMLEvent)it.next());
        }
        er = this.getEventReader("<?xml version='1.0' encoding='UTF-8' standalone='yes'?><!DOCTYPE root []>\n<!-- the doc...--><root xmlns:ns='urn:foo'>\n  <branch attr='val' ns:foo='bar'>\n    <ns:leaf xmlns='another-uri' />\n    <?proc instr?>\n<leaf><![CDATA[ Haa: <nottag /> ]]></leaf>\n  </branch>\n  <!-- another comment --></root>", true, true);
        List list2 = this.collectEvents(er);
        TestEventWriter.assertEquals((String)"Should have gotten same number of events", (int)list1.size(), (int)list2.size());
        it = list1.iterator();
        Iterator it2 = list2.iterator();
        int ix = 0;
        while (it.hasNext()) {
            XMLEvent evt1 = (XMLEvent)it.next();
            XMLEvent evt2 = (XMLEvent)it2.next();
            if (evt1.getEventType() != evt2.getEventType()) {
                TestEventWriter.fail((String)("Event #" + ix + "; first time got event " + evt1.getEventType() + ", second time " + evt2.getEventType()));
            }
            if (evt1.isStartElement()) {
                StartElement se1 = evt1.asStartElement();
                StartElement se2 = evt2.asStartElement();
                List attrs1 = this.fetchElems(se1.getAttributes());
                List attrs2 = this.fetchElems(se2.getAttributes());
                TestEventWriter.assertEquals((int)attrs1.size(), (int)attrs2.size());
                List ns1 = this.fetchElems(se1.getNamespaces());
                List ns2 = this.fetchElems(se2.getNamespaces());
                TestEventWriter.assertEquals((int)ns1.size(), (int)ns2.size());
            }
            ++ix;
        }
    }

    private List fetchElems(Iterator it) {
        ArrayList l = new ArrayList();
        while (it.hasNext()) {
            l.add(it.next());
        }
        return l;
    }

    private XMLStreamReader getReader(String contents, boolean nsAware, boolean coalesce) throws XMLStreamException {
        XMLInputFactory f = this.getInputFactory();
        TestEventWriter.setNamespaceAware(f, nsAware);
        TestEventWriter.setCoalescing(f, coalesce);
        TestEventWriter.setSupportDTD(f, true);
        TestEventWriter.setValidating(f, false);
        return TestEventWriter.constructStreamReader(f, contents);
    }

    private XMLEventReader getEventReader(String contents, boolean nsAware, boolean coalesce) throws XMLStreamException {
        XMLInputFactory f = this.getInputFactory();
        TestEventWriter.setNamespaceAware(f, nsAware);
        TestEventWriter.setCoalescing(f, coalesce);
        TestEventWriter.setSupportDTD(f, true);
        TestEventWriter.setValidating(f, false);
        XMLStreamReader sr = TestEventWriter.constructStreamReader(f, contents);
        return f.createXMLEventReader(sr);
    }

    private List collectEvents(XMLEventReader er) throws XMLStreamException {
        ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
        while (er.hasNext()) {
            events.add(er.nextEvent());
        }
        return events;
    }
}

