/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.evt;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EntityDeclaration;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.NotationDeclaration;
import javax.xml.stream.events.XMLEvent;
import org.codehaus.stax.test.evt.BaseEventTest;

public class TestEventReader
extends BaseEventTest {
    static /* synthetic */ Class class$javax$xml$stream$events$EntityDeclaration;
    static /* synthetic */ Class class$javax$xml$stream$events$NotationDeclaration;

    public void testSimpleValid() throws XMLStreamException {
        String XML = "<?xml version='1.0' ?><!DOCTYPE root [  ]><root attr='123'><!-- comment -->\n</root>";
        for (int i = 0; i < 4; ++i) {
            boolean ns = (i & 1) != 0;
            boolean coal = (i & 2) != 0;
            XMLEventReader er = this.getReader(XML, ns, coal);
            TestEventReader.assertTokenType(7, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(11, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(1, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(5, er.nextEvent().getEventType());
            XMLEvent evt = (XMLEvent)er.next();
            TestEventReader.assertTokenType(4, evt.getEventType());
            TestEventReader.assertTokenType(2, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(8, er.nextEvent().getEventType());
            TestEventReader.assertFalse((boolean)er.hasNext());
            er.close();
        }
    }

    public void testInvalidUsage() throws XMLStreamException {
        String XML = "<?xml version='1.0' ?><root />";
        for (int i = 0; i < 4; ++i) {
            boolean ns = (i & 1) != 0;
            boolean coal = (i & 2) != 0;
            XMLEventReader er = this.getReader(XML, ns, coal);
            XMLEvent evt = er.nextEvent();
            String msg = null;
            try {
                er.remove();
                msg = "Was expecting UnsupportedOperationException for XMLEventReader.remove()";
            }
            catch (UnsupportedOperationException e) {
            }
            catch (Throwable t) {
                msg = "Was expecting UnsupportedOperationException for XMLEventReader.remove(); instead got: " + t;
            }
            if (msg == null) continue;
            TestEventReader.fail((String)msg);
        }
    }

    public void testNonExpandingEntities() throws XMLStreamException {
        String XML = "<?xml version='1.0' ?><!DOCTYPE root [\n<!ENTITY intEnt 'internal'>\n<!ENTITY extParsedEnt SYSTEM 'url:dummy'>\n<!NOTATION notation PUBLIC 'notation-public-id'>\n<!ENTITY extUnparsedEnt SYSTEM 'url:dummy2' NDATA notation>\n]><root>&intEnt;&extParsedEnt;</root>";
        for (int i = 0; i < 4; ++i) {
            boolean ns = (i & 1) != 0;
            boolean coal = (i & 2) != 0;
            XMLEventReader er = this.getReader(XML, ns, coal, false);
            TestEventReader.assertTokenType(7, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(11, er.nextEvent().getEventType());
            XMLEvent evt = er.nextEvent();
            TestEventReader.assertTrue((boolean)evt.isStartElement());
            evt = er.nextEvent();
            TestEventReader.assertTokenType(9, evt.getEventType());
            EntityReference ref = (EntityReference)evt;
            TestEventReader.assertNotNull((Object)ref);
            TestEventReader.assertTrue((boolean)ref.isEntityReference());
            TestEventReader.assertEquals((String)"intEnt", (String)ref.getName());
            EntityDeclaration ed = ref.getDeclaration();
            TestEventReader.assertNotNull((String)"Declaration of internal entity 'intEnt' should not be null", (Object)ed);
            TestEventReader.assertEquals((String)"intEnt", (String)ed.getName());
            TestEventReader.assertEquals((String)"internal", (String)ed.getReplacementText());
            TestEventReader.assertNullOrEmpty(ed.getNotationName());
            TestEventReader.assertNullOrEmpty(ed.getPublicId());
            TestEventReader.assertNullOrEmpty(ed.getSystemId());
            evt = er.nextEvent();
            TestEventReader.assertTokenType(9, evt.getEventType());
            ref = (EntityReference)evt;
            TestEventReader.assertNotNull((Object)ref);
            TestEventReader.assertTrue((boolean)ref.isEntityReference());
            TestEventReader.assertEquals((String)"extParsedEnt", (String)ref.getName());
            ed = ref.getDeclaration();
            TestEventReader.assertNotNull((String)"Declaration of external entity 'extParsedEnt' should not be null", (Object)ed);
            TestEventReader.assertEquals((String)"extParsedEnt", (String)ed.getName());
            TestEventReader.assertNullOrEmpty(ed.getNotationName());
            TestEventReader.assertNullOrEmpty(ed.getPublicId());
            TestEventReader.assertEquals((String)"url:dummy", (String)ed.getSystemId());
            evt = er.nextEvent();
            TestEventReader.assertTrue((boolean)evt.isEndElement());
            TestEventReader.assertTokenType(8, er.nextEvent().getEventType());
            TestEventReader.assertFalse((boolean)er.hasNext());
        }
    }

    public void testValidDtdEvent() throws XMLStreamException {
        String XML = "<?xml version='1.0' ?><!DOCTYPE root [\n<!ENTITY intEnt 'internal'>\n<!ENTITY extParsedEnt SYSTEM 'url:dummy'>\n<!NOTATION notation PUBLIC 'notation-public-id'>\n<!NOTATION notation2 SYSTEM 'url:dummy'>\n<!ENTITY extUnparsedEnt SYSTEM 'url:dummy2' NDATA notation>\n]><root />";
        for (int i = 0; i < 4; ++i) {
            boolean ns = (i & 1) != 0;
            boolean coal = (i & 2) != 0;
            XMLEventReader er = this.getReader(XML, ns, coal);
            TestEventReader.assertTokenType(7, er.nextEvent().getEventType());
            XMLEvent evt = er.nextEvent();
            TestEventReader.assertTokenType(11, evt.getEventType());
            DTD dtd = (DTD)evt;
            List<EntityDeclaration> entities = dtd.getEntities();
            TestEventReader.assertNotNull((String)"Entity list for a DTD declaration with entities should not be null", entities);
            TestEventReader.assertEquals((int)3, (int)entities.size());
            this.testListElems(entities, class$javax$xml$stream$events$EntityDeclaration == null ? TestEventReader.class$("javax.xml.stream.events.EntityDeclaration") : class$javax$xml$stream$events$EntityDeclaration);
            List<NotationDeclaration> notations = dtd.getNotations();
            this.testListElems(notations, class$javax$xml$stream$events$NotationDeclaration == null ? TestEventReader.class$("javax.xml.stream.events.NotationDeclaration") : class$javax$xml$stream$events$NotationDeclaration);
            TestEventReader.assertNotNull((String)"Notation list for a DTD declaration with notations should not be null", entities);
            TestEventReader.assertNotNull(notations);
            TestEventReader.assertEquals((int)2, (int)notations.size());
        }
    }

    public void testIterationEndException() throws XMLStreamException {
        String XML = "<root />";
        for (int i = 0; i < 4; ++i) {
            boolean coal = (i & 1) != 0;
            boolean checkHasNext = (i & 2) != 0;
            XMLEventReader er = this.getReader(XML, true, coal);
            TestEventReader.assertTokenType(7, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(1, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(2, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(8, er.nextEvent().getEventType());
            if (checkHasNext) {
                TestEventReader.assertFalse((boolean)er.hasNext());
            }
            XMLEvent ev = null;
            try {
                ev = er.nextEvent();
            }
            catch (NoSuchElementException nex) {
                continue;
            }
            catch (Throwable t) {
                TestEventReader.fail((String)("Expected a NoSuchElementException after iterating through the document; got " + t));
            }
            TestEventReader.fail((String)("Expected a NoSuchElementException after iterating through the document; got event: " + ev));
        }
    }

    public void testNextTagOk() throws XMLStreamException {
        String XML = "<root>\n<branch>   <leaf>  </leaf></branch></root>";
        for (int i = 0; i < 4; ++i) {
            boolean ns = (i & 1) != 0;
            boolean coal = (i & 2) != 0;
            XMLEventReader er = this.getReader(XML, ns, coal);
            TestEventReader.assertTokenType(7, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(1, er.nextTag().getEventType());
            TestEventReader.assertTokenType(1, er.nextTag().getEventType());
            TestEventReader.assertTokenType(4, er.peek().getEventType());
            TestEventReader.assertTokenType(1, er.nextTag().getEventType());
            TestEventReader.assertTokenType(2, er.nextTag().getEventType());
            TestEventReader.assertTokenType(2, er.nextTag().getEventType());
            TestEventReader.assertTokenType(2, er.nextTag().getEventType());
            TestEventReader.assertTokenType(8, er.nextEvent().getEventType());
            TestEventReader.assertFalse((boolean)er.hasNext());
        }
    }

    public void testNextTagInvalid() throws XMLStreamException {
        String XML = "<root>   non-empty<leaf /></root>";
        String XML2 = "<root><leaf></leaf>text   </root>";
        for (int i = 0; i < 4; ++i) {
            XMLEvent evt;
            boolean ns = (i & 1) != 0;
            boolean coal = (i & 2) != 0;
            XMLEventReader er = this.getReader(XML, ns, coal);
            TestEventReader.assertTokenType(7, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(1, er.nextEvent().getEventType());
            String msg = null;
            try {
                evt = er.nextTag();
                msg = "Expected a XMLStreamException when trying to call XMLEventReader.nextTag() on non-empty CHARACTERS";
            }
            catch (XMLStreamException sex) {
            }
            catch (Throwable t) {
                msg = "Expected a XMLStreamException when trying to call XMLEventReader.nextTag() on non-empty CHARACTERS; got (" + t.getClass() + "): " + t;
            }
            if (msg != null) {
                TestEventReader.fail((String)msg);
            }
            er.close();
            er = this.getReader(XML2, ns, coal);
            TestEventReader.assertTokenType(7, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(1, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(1, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(2, er.nextEvent().getEventType());
            try {
                evt = er.nextTag();
                msg = "Expected a XMLStreamException when trying to call XMLEventReader.nextTag() on END_ELEMENT and hitting non-ws text; got event " + TestEventReader.tokenTypeDesc(evt);
            }
            catch (XMLStreamException sex) {
                msg = null;
            }
            catch (Throwable t) {
                msg = "Expected a XMLStreamException when trying to call XMLEventReader.nextTag() on END_ELEMENT and hitting non-ws text; got: " + t;
            }
            if (msg != null) {
                TestEventReader.fail((String)msg);
            }
            er.close();
        }
    }

    public void testSkip() throws XMLStreamException {
        String XML = "<?xml version='1.0' ?><!DOCTYPE root><root>\n<branch>   <leaf>  </leaf></branch><!-- comment --></root>";
        for (int i = 0; i < 4; ++i) {
            boolean ns = (i & 1) != 0;
            boolean coal = (i & 2) != 0;
            XMLEventReader er = this.getReader(XML, ns, coal);
            TestEventReader.assertTokenType(7, er.peek().getEventType());
            TestEventReader.assertTokenType(7, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(11, er.peek().getEventType());
            TestEventReader.assertTokenType(11, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(1, er.peek().getEventType());
            TestEventReader.assertTokenType(1, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(4, er.peek().getEventType());
            TestEventReader.assertTokenType(4, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(1, er.peek().getEventType());
            TestEventReader.assertTokenType(1, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(4, er.peek().getEventType());
            TestEventReader.assertTokenType(4, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(1, er.peek().getEventType());
            TestEventReader.assertTokenType(1, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(4, er.peek().getEventType());
            TestEventReader.assertTokenType(4, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(2, er.peek().getEventType());
            TestEventReader.assertTokenType(2, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(2, er.peek().getEventType());
            TestEventReader.assertTokenType(2, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(5, er.peek().getEventType());
            TestEventReader.assertTokenType(5, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(2, er.peek().getEventType());
            TestEventReader.assertTokenType(2, er.nextEvent().getEventType());
            TestEventReader.assertTokenType(8, er.peek().getEventType());
            TestEventReader.assertTokenType(8, er.nextEvent().getEventType());
            TestEventReader.assertFalse((boolean)er.hasNext());
        }
    }

    public void testPeek() throws XMLStreamException {
        String XML = "<root>text</root>";
        for (int i = 0; i < 4; ++i) {
            boolean ns = (i & 1) != 0;
            boolean coal = (i & 2) != 0;
            XMLEventReader er = this.getReader(XML, ns, coal);
            TestEventReader.assertTokenType(7, er.nextEvent().getEventType());
            XMLEvent tag = er.nextTag();
            TestEventReader.assertTokenType(1, tag.getEventType());
            XMLEvent text = er.peek();
            TestEventReader.assertTokenType(4, text.getEventType());
            Characters chars = text.asCharacters();
            TestEventReader.assertNotNull((Object)chars);
            TestEventReader.assertEquals((String)"text", (String)chars.getData());
            text = er.nextEvent();
            TestEventReader.assertTokenType(4, text.getEventType());
            chars = text.asCharacters();
            TestEventReader.assertNotNull((Object)chars);
            TestEventReader.assertEquals((String)"text", (String)chars.getData());
            TestEventReader.assertTokenType(2, er.nextTag().getEventType());
            TestEventReader.assertTokenType(8, er.nextEvent().getEventType());
            TestEventReader.assertNull((Object)er.peek());
        }
    }

    public void testElementText() throws XMLStreamException {
        XMLEvent elem;
        XMLEventReader er;
        boolean coal;
        boolean ns;
        int i;
        String TEXT1 = "some\ntest";
        String TEXT2 = "inside CDATA too!";
        String XML = "<root>" + TEXT1 + "<![CDATA[" + TEXT2 + "]]></root>";
        for (i = 0; i < 4; ++i) {
            ns = (i & 1) != 0;
            coal = (i & 2) != 0;
            er = this.getReader(XML, ns, coal);
            TestEventReader.assertTokenType(7, er.nextEvent().getEventType());
            elem = er.nextEvent();
            TestEventReader.assertTokenType(1, elem.getEventType());
            try {
                TestEventReader.assertEquals((String)(TEXT1 + TEXT2), (String)er.getElementText());
            }
            catch (XMLStreamException sex) {
                TestEventReader.fail((String)("Failed on XMLEventReader.getElementText(): " + sex));
            }
            elem = er.nextEvent();
            if (elem.getEventType() == 8 || elem.getEventType() == 2) continue;
            TestEventReader.fail((String)("Expected END_DOCUMENT or END_ELEMENT, got " + TestEventReader.tokenTypeDesc(elem.getEventType())));
        }
        for (i = 0; i < 4; ++i) {
            ns = (i & 1) != 0;
            coal = (i & 2) != 0;
            er = this.getReader(XML, ns, coal);
            TestEventReader.assertTokenType(7, er.nextEvent().getEventType());
            elem = er.nextEvent();
            TestEventReader.assertTokenType(1, elem.getEventType());
            XMLEvent peeked = er.peek();
            TestEventReader.assertTokenType(4, peeked.getEventType());
            TestEventReader.assertEquals((String)(TEXT1 + TEXT2), (String)er.getElementText());
            elem = er.nextEvent();
            if (elem.getEventType() == 8 || elem.getEventType() == 2) continue;
            TestEventReader.fail((String)("Expected END_DOCUMENT or END_ELEMENT, got " + TestEventReader.tokenTypeDesc(elem.getEventType())));
        }
    }

    private XMLEventReader getReader(String contents, boolean nsAware, boolean coalesce) throws XMLStreamException {
        return this.getReader(contents, nsAware, coalesce, true);
    }

    private XMLEventReader getReader(String contents, boolean nsAware, boolean coalesce, boolean expandEnt) throws XMLStreamException {
        XMLInputFactory f = this.getInputFactory();
        TestEventReader.setNamespaceAware(f, nsAware);
        TestEventReader.setCoalescing(f, coalesce);
        TestEventReader.setSupportDTD(f, true);
        TestEventReader.setValidating(f, false);
        TestEventReader.setReplaceEntities(f, expandEnt);
        return TestEventReader.constructEventReader(f, contents);
    }

    private void testListElems(List l, Class expType) {
        Iterator it = l.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            TestEventReader.assertNotNull(o);
            TestEventReader.assertTrue((boolean)expType.isAssignableFrom(o.getClass()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

