/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.evt;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Iterator;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.codehaus.stax.test.BaseStaxTest;

public class BaseEventTest
extends BaseStaxTest {
    protected BaseEventTest() {
    }

    protected XMLEventFactory getEventFactory() throws FactoryConfigurationError {
        return XMLEventFactory.newInstance();
    }

    protected static XMLEventReader constructEventReader(XMLInputFactory f, String content) throws XMLStreamException {
        return f.createXMLEventReader(new StringReader(content));
    }

    protected static XMLEventReader constructEventReaderForFile(XMLInputFactory f, String filename) throws IOException, XMLStreamException {
        File inf = new File(filename);
        XMLEventReader er = f.createXMLEventReader(inf.toURL().toString(), new FileReader(inf));
        return er;
    }

    protected int streamThrough(XMLEventReader er) throws XMLStreamException {
        int result = 0;
        while (er.hasNext()) {
            XMLEvent evt = er.nextEvent();
            int type = evt.getEventType();
            result += type;
            if (!evt.isCharacters()) continue;
            result += evt.asCharacters().getData().hashCode();
        }
        return result;
    }

    protected int calcAttrCount(StartElement elem) throws XMLStreamException {
        int count = 0;
        Iterator<Attribute> it = elem.getAttributes();
        if (it != null) {
            while (it.hasNext()) {
                Attribute attr = it.next();
                ++count;
            }
        }
        return count;
    }

    public static void checkEventIsMethods(int type, XMLEvent evt) {
        int actualType = evt.getEventType();
        if (actualType != type && (type != 4 || actualType != 6 && actualType != 12)) {
            BaseEventTest.assertTokenType(type, actualType);
        }
        if (type == 13) {
            boolean bl = evt.isAttribute();
        } else {
            BaseEventTest.assertEquals((type == 10 ? 1 : 0) != 0, (boolean)evt.isAttribute());
        }
        BaseEventTest.assertEquals((type == 4 ? 1 : 0) != 0, (boolean)evt.isCharacters());
        BaseEventTest.assertEquals((type == 7 ? 1 : 0) != 0, (boolean)evt.isStartDocument());
        BaseEventTest.assertEquals((type == 8 ? 1 : 0) != 0, (boolean)evt.isEndDocument());
        BaseEventTest.assertEquals((type == 1 ? 1 : 0) != 0, (boolean)evt.isStartElement());
        BaseEventTest.assertEquals((type == 2 ? 1 : 0) != 0, (boolean)evt.isEndElement());
        BaseEventTest.assertEquals((type == 9 ? 1 : 0) != 0, (boolean)evt.isEntityReference());
        BaseEventTest.assertEquals((type == 13 ? 1 : 0) != 0, (boolean)evt.isNamespace());
        BaseEventTest.assertEquals((type == 3 ? 1 : 0) != 0, (boolean)evt.isProcessingInstruction());
    }

    public void testEventWritability(XMLEvent evt) throws XMLStreamException {
        StringWriter sw = new StringWriter();
        evt.writeAsEncodedUnicode(sw);
        switch (evt.getEventType()) {
            case 8: {
                return;
            }
        }
        BaseEventTest.assertTrue((sw.toString().length() > 0 ? 1 : 0) != 0);
    }
}

