/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.XMLEvent;
import junit.framework.TestCase;

public class BaseStaxTest
extends TestCase
implements XMLStreamConstants {
    static final String PROP_REPORT_CDATA = "http://java.sun.com/xml/stream/properties/report-cdata-event";
    static final HashMap mTokenTypes = new HashMap();
    protected final String DEFAULT_URI_NON_NS;
    protected final String DEFAULT_URI_NS = "";
    XMLInputFactory mInputFactory;
    XMLOutputFactory mOutputFactory;
    XMLEventFactory mEventFactory;
    static final int MAX_DESC_TEXT_CHARS = 8;

    protected BaseStaxTest(String name) {
        super(name);
        this.DEFAULT_URI_NON_NS = null;
    }

    protected BaseStaxTest() {
        this.DEFAULT_URI_NON_NS = null;
    }

    protected XMLInputFactory getInputFactory() {
        if (this.mInputFactory == null) {
            this.mInputFactory = BaseStaxTest.getNewInputFactory();
        }
        return this.mInputFactory;
    }

    protected static XMLInputFactory getNewInputFactory() {
        return XMLInputFactory.newInstance();
    }

    protected XMLOutputFactory getOutputFactory() {
        if (this.mOutputFactory == null) {
            this.mOutputFactory = BaseStaxTest.getNewOutputFactory();
        }
        return this.mOutputFactory;
    }

    protected static XMLOutputFactory getNewOutputFactory() {
        return XMLOutputFactory.newInstance();
    }

    protected XMLEventFactory getEventFactory() {
        if (this.mEventFactory == null) {
            this.mEventFactory = XMLEventFactory.newInstance();
        }
        return this.mEventFactory;
    }

    protected static XMLStreamReader constructStreamReader(XMLInputFactory f, String content) throws XMLStreamException {
        try {
            byte[] data = content.getBytes("UTF-8");
            return BaseStaxTest.constructStreamReader(f, data);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected static XMLStreamReader constructStreamReader(XMLInputFactory f, byte[] b) throws XMLStreamException {
        return f.createXMLStreamReader(new ByteArrayInputStream(b));
    }

    protected static XMLStreamReader constructStreamReaderForFile(XMLInputFactory f, String filename) throws IOException, XMLStreamException {
        File inf = new File(filename);
        XMLStreamReader sr = f.createXMLStreamReader(inf.toURL().toString(), new FileReader(inf));
        BaseStaxTest.assertEquals((int)7, (int)sr.getEventType());
        return sr;
    }

    protected XMLStreamReader constructNsStreamReader(String content) throws XMLStreamException {
        XMLInputFactory f = this.getInputFactory();
        BaseStaxTest.setNamespaceAware(f, true);
        return f.createXMLStreamReader(new StringReader(content));
    }

    protected XMLStreamReader constructNsStreamReader(String content, boolean coal) throws XMLStreamException {
        XMLInputFactory f = this.getInputFactory();
        BaseStaxTest.setNamespaceAware(f, true);
        BaseStaxTest.setCoalescing(f, coal);
        return f.createXMLStreamReader(new StringReader(content));
    }

    protected static boolean isCoalescing(XMLInputFactory f) throws XMLStreamException {
        return (Boolean)f.getProperty("javax.xml.stream.isCoalescing");
    }

    protected static void setCoalescing(XMLInputFactory f, boolean state) throws XMLStreamException {
        Boolean b = state ? Boolean.TRUE : Boolean.FALSE;
        f.setProperty("javax.xml.stream.isCoalescing", b);
        BaseStaxTest.assertEquals((boolean)state, (boolean)BaseStaxTest.isCoalescing(f));
    }

    protected static boolean isValidating(XMLInputFactory f) throws XMLStreamException {
        return (Boolean)f.getProperty("javax.xml.stream.isValidating");
    }

    protected static void setValidating(XMLInputFactory f, boolean state) throws XMLStreamException {
        try {
            Boolean b = state ? Boolean.TRUE : Boolean.FALSE;
            f.setProperty("javax.xml.stream.isValidating", b);
        }
        catch (IllegalArgumentException iae) {
            BaseStaxTest.fail((String)("Could not set DTD validating mode to " + state + ": " + iae));
        }
        BaseStaxTest.assertEquals((boolean)state, (boolean)BaseStaxTest.isValidating(f));
    }

    protected static boolean isNamespaceAware(XMLInputFactory f) throws XMLStreamException {
        return (Boolean)f.getProperty("javax.xml.stream.isNamespaceAware");
    }

    protected static boolean setNamespaceAware(XMLInputFactory f, boolean state) throws XMLStreamException {
        try {
            f.setProperty("javax.xml.stream.isNamespaceAware", state ? Boolean.TRUE : Boolean.FALSE);
            return BaseStaxTest.isNamespaceAware(f) == state;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    protected static void setReplaceEntities(XMLInputFactory f, boolean state) throws XMLStreamException {
        Boolean b = state ? Boolean.TRUE : Boolean.FALSE;
        f.setProperty("javax.xml.stream.isReplacingEntityReferences", b);
        BaseStaxTest.assertEquals((Object)b, (Object)f.getProperty("javax.xml.stream.isReplacingEntityReferences"));
    }

    protected static void setSupportDTD(XMLInputFactory f, boolean state) throws XMLStreamException {
        Boolean b = state ? Boolean.TRUE : Boolean.FALSE;
        f.setProperty("javax.xml.stream.supportDTD", b);
        BaseStaxTest.assertEquals((Object)b, (Object)f.getProperty("javax.xml.stream.supportDTD"));
    }

    protected static boolean setSupportExternalEntities(XMLInputFactory f, boolean state) throws XMLStreamException {
        Boolean b = state ? Boolean.TRUE : Boolean.FALSE;
        try {
            f.setProperty("javax.xml.stream.isSupportingExternalEntities", b);
            Object act = f.getProperty("javax.xml.stream.isSupportingExternalEntities");
            return act instanceof Boolean && (Boolean)act == state;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    protected static void setResolver(XMLInputFactory f, XMLResolver resolver) throws XMLStreamException {
        f.setProperty("javax.xml.stream.resolver", resolver);
    }

    protected static boolean setReportCData(XMLInputFactory f, boolean state) throws XMLStreamException {
        Boolean b;
        Boolean bl = b = state ? Boolean.TRUE : Boolean.FALSE;
        if (f.isPropertySupported(PROP_REPORT_CDATA)) {
            f.setProperty(PROP_REPORT_CDATA, b);
            return true;
        }
        return false;
    }

    protected static String getAndVerifyText(XMLStreamReader sr) throws XMLStreamException {
        String text = sr.getText();
        int type = sr.getEventType();
        if (type != 9 && type != 11) {
            BaseStaxTest.assertNotNull((String)"getText() should never return null.", (Object)text);
            int expLen = sr.getTextLength();
            if (sr.getEventType() == 4) {
                BaseStaxTest.assertTrue((String)"Stream reader should never return empty Strings.", (expLen > 0 ? 1 : 0) != 0);
            }
            BaseStaxTest.assertEquals((String)("Expected text length of " + expLen + ", got " + text.length()), (int)expLen, (int)text.length());
            char[] textChars = sr.getTextCharacters();
            int start = sr.getTextStart();
            String text2 = new String(textChars, start, expLen);
            BaseStaxTest.assertEquals((String)("Expected getText() and getTextCharacters() to return same value for event of type (" + BaseStaxTest.tokenTypeDesc(sr.getEventType()) + ")"), (String)text, (String)text2);
        } else if (text == null) {
            text = "";
        }
        return text;
    }

    protected static String getAllText(XMLStreamReader sr) throws XMLStreamException {
        int tt;
        StringBuffer sb = new StringBuffer();
        while ((tt = sr.getEventType()) == 4 || tt == 6) {
            sb.append(BaseStaxTest.getAndVerifyText(sr));
            sr.next();
        }
        return sb.toString();
    }

    protected static String getAllCData(XMLStreamReader sr) throws XMLStreamException {
        int tt;
        StringBuffer sb = new StringBuffer();
        while ((tt = sr.getEventType()) == 4 || tt == 12) {
            sb.append(BaseStaxTest.getAndVerifyText(sr));
            sr.next();
        }
        return sb.toString();
    }

    protected static void assertTokenType(int expType, int actType) {
        if (expType == actType) {
            return;
        }
        BaseStaxTest.fail((String)("Expected token " + BaseStaxTest.tokenTypeDesc(expType) + "; got " + BaseStaxTest.tokenTypeDesc(actType) + "."));
    }

    protected static void assertTokenType(int expType, int actType, XMLStreamReader sr) {
        if (expType == actType) {
            return;
        }
        BaseStaxTest.fail((String)("Expected token " + BaseStaxTest.tokenTypeDesc(expType) + "; got " + BaseStaxTest.tokenTypeDesc(actType, sr) + "."));
    }

    protected static void assertTextualTokenType(int actType) {
        if (actType != 4 && actType != 6 && actType != 12) {
            BaseStaxTest.fail((String)("Expected textual token (CHARACTERS, SPACE or CDATA); got " + BaseStaxTest.tokenTypeDesc(actType) + "."));
        }
    }

    protected static void failStrings(String msg, String exp, String act) {
        BaseStaxTest.fail((String)(msg + ": expected " + BaseStaxTest.quotedPrintable(exp) + ", got " + BaseStaxTest.quotedPrintable(act)));
    }

    protected static void assertNoPrefix(XMLStreamReader sr) throws XMLStreamException {
        String prefix = sr.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            BaseStaxTest.fail((String)("Excepted no (or empty) prefix: got '" + prefix + "'"));
        }
    }

    protected static void assertNoNsURI(XMLStreamReader sr) throws XMLStreamException {
        String uri = sr.getNamespaceURI();
        if (uri != null) {
            if (uri.length() == 0) {
                BaseStaxTest.fail((String)"Excepted no (null) namespace URI: got empty string; non-conformant");
            }
            BaseStaxTest.fail((String)("Excepted no (null) namespace URI: got '" + uri + "'"));
        }
    }

    protected static void assertNoPrefixOrNs(XMLStreamReader sr) throws XMLStreamException {
        BaseStaxTest.assertNoPrefix(sr);
        BaseStaxTest.assertNoNsURI(sr);
    }

    protected static void assertNullOrEmpty(String str) {
        if (str != null && str.length() > 0) {
            BaseStaxTest.fail((String)("Expected String to be empty or null; was '" + str + "' (length " + str.length() + ")"));
        }
    }

    protected static String tokenTypeDesc(int tt) {
        String desc = (String)mTokenTypes.get(new Integer(tt));
        if (desc == null) {
            return "[" + tt + "]";
        }
        return desc;
    }

    protected static String tokenTypeDesc(XMLEvent evt) {
        return BaseStaxTest.tokenTypeDesc(evt.getEventType());
    }

    protected static String tokenTypeDesc(int tt, XMLStreamReader sr) {
        String desc = BaseStaxTest.tokenTypeDesc(tt);
        if (tt == 4 || tt == 6 || tt == 12) {
            String str = sr.getText();
            desc = str.length() > 8 ? "\"" + str.substring(0, 8) + "\"[...]" : "\"" + desc + "\"";
            desc = " (" + desc + ")";
        }
        return desc;
    }

    protected static String valueDesc(String value) {
        if (value == null) {
            return "[NULL]";
        }
        return "\"" + value + "\"";
    }

    protected static String printable(char ch) {
        if (ch == '\n') {
            return "\\n";
        }
        if (ch == '\r') {
            return "\\r";
        }
        if (ch == '\t') {
            return "\\t";
        }
        if (ch == ' ') {
            return "_";
        }
        if (ch > '\u007f' || ch < ' ') {
            StringBuffer sb = new StringBuffer(6);
            sb.append("\\u");
            String hex = Integer.toHexString(ch);
            int len = 4 - hex.length();
            for (int i = 0; i < len; ++i) {
                sb.append('0');
            }
            sb.append(hex);
            return sb.toString();
        }
        return null;
    }

    protected static String printable(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        int len = str.length();
        StringBuffer sb = new StringBuffer(len + 64);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            String res = BaseStaxTest.printable(c);
            if (res == null) {
                sb.append(c);
                continue;
            }
            sb.append(res);
        }
        return sb.toString();
    }

    protected static String quotedPrintable(String str) {
        if (str == null || str.length() == 0) {
            return "[0]''";
        }
        return "[len: " + str.length() + "] '" + BaseStaxTest.printable(str) + "'";
    }

    protected void reportNADueToProperty(String method, String prop) {
        String clsName = this.getClass().getName();
        System.err.println("Skipping " + clsName + "#" + method + ": property '" + prop + "' (or one of its values) not supported.");
    }

    protected void reportNADueToNS(String method) {
        this.reportNADueToProperty(method, "IS_NAMESPACE_AWARE");
    }

    protected void reportNADueToExtEnt(String method) {
        this.reportNADueToProperty(method, "IS_SUPPORTING_EXTERNAL_ENTITIES");
    }

    protected void reportNADueToEntityExpansion(String method, int type) {
        String clsName = this.getClass().getName();
        String msg = type > 0 ? " (next event: " + BaseStaxTest.tokenTypeDesc(type) + ")" : "";
        System.err.println("Skipping " + clsName + "#" + method + ": entity expansion does not seem to be functioning properly" + msg + ".");
    }

    static {
        mTokenTypes.put(new Integer(1), "START_ELEMENT");
        mTokenTypes.put(new Integer(2), "END_ELEMENT");
        mTokenTypes.put(new Integer(7), "START_DOCUMENT");
        mTokenTypes.put(new Integer(8), "END_DOCUMENT");
        mTokenTypes.put(new Integer(4), "CHARACTERS");
        mTokenTypes.put(new Integer(12), "CDATA");
        mTokenTypes.put(new Integer(5), "COMMENT");
        mTokenTypes.put(new Integer(3), "PROCESSING_INSTRUCTION");
        mTokenTypes.put(new Integer(11), "DTD");
        mTokenTypes.put(new Integer(6), "SPACE");
        mTokenTypes.put(new Integer(9), "ENTITY_REFERENCE");
        mTokenTypes.put(new Integer(13), "NAMESPACE_DECLARATION");
        mTokenTypes.put(new Integer(14), "NOTATION_DECLARATION");
        mTokenTypes.put(new Integer(15), "ENTITY_DECLARATION");
    }
}

