/* Do not modify this file. Changes will be overwritten.                      */
/* Generated automatically by the ASN.1 to Wireshark dissector compiler       */
/* packet-lte-rrc.c                                                           */
/* asn2wrs.py -q -L -p lte-rrc -c ./lte-rrc.cnf -s ./packet-lte-rrc-template -D . -O ../.. EUTRA-InterNodeDefinitions.asn EUTRA-RRC-Definitions.asn PC5-RRC-Definitions.asn NBIOT-InterNodeDefinitions.asn NBIOT-RRC-Definitions.asn */

/* packet-lte-rrc-template.c
 * Routines for Evolved Universal Terrestrial Radio Access (E-UTRA);
 * Radio Resource Control (RRC) protocol specification
 * (3GPP TS 36.331 V18.2.0 Release 18) packet dissection
 * Copyright 2008, Vincent Helfre
 * Copyright 2009-2024, Pascal Quantin
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include "config.h"

#include <stdlib.h>

#include <epan/packet.h>
#include <epan/prefs.h>
#include <epan/to_str.h>
#include <epan/asn1.h>
#include <epan/expert.h>
#include <epan/reassemble.h>
#include <epan/exceptions.h>
#include <epan/show_exception.h>
#include <epan/proto_data.h>
#include <epan/tfs.h>
#include <epan/unit_strings.h>

#include <wsutil/str_util.h>
#include <wsutil/epochs.h>
#include <wsutil/array.h>

#include "packet-per.h"
#include "packet-rrc.h"
#include "packet-gsm_a_common.h"
#include "packet-lpp.h"
#include "packet-gsm_map.h"
#include "packet-cell_broadcast.h"
#include "packet-mac-lte.h"
#include "packet-rlc-lte.h"
#include "packet-pdcp-lte.h"
#include "packet-nr-rrc.h"
#include "packet-lte-rrc.h"

#define PNAME  "LTE Radio Resource Control (RRC) protocol"
#define PSNAME "LTE RRC"
#define PFNAME "lte_rrc"

void proto_register_lte_rrc(void);
void proto_reg_handoff_lte_rrc(void);

static dissector_handle_t nas_eps_handle;
static dissector_handle_t nas_5gs_handle;
static dissector_handle_t rrc_irat_ho_to_utran_cmd_handle;
static dissector_handle_t rrc_sys_info_cont_handle;
static dissector_handle_t gsm_a_dtap_handle;
static dissector_handle_t gsm_rlcmac_dl_handle;
static dissector_handle_t nr_rrc_reconf_handle;
static dissector_handle_t lte_rrc_conn_reconf_handle;
static dissector_handle_t lte_rrc_dl_ccch_handle;

static wmem_map_t *lte_rrc_etws_cmas_dcs_hash;

/* Keep track of where/how the System Info value has changed */
static wmem_map_t *lte_rrc_system_info_value_changed_hash;
static uint8_t    system_info_value_current;
static bool       system_info_value_current_set;

static wmem_map_t *lte_rrc_dcch_segment_ueid_count_hash;
static wmem_tree_t *lte_rrc_dcch_segment_id_tree;

static bool lte_rrc_nas_in_root_tree;
static bool lte_rrc_reassemble_dcch_segments;

extern int proto_mac_lte;
extern int proto_rlc_lte;
extern int proto_pdcp_lte;


/* Include constants */
#define maxReestabInfo                 32
#define maxAccessCat_1_r15             63
#define maxACDC_Cat_r13                16
#define maxAvailNarrowBands_r13        16
#define maxAvailNarrowBands_1_r16      15
#define maxBandComb_r10                128
#define maxBandComb_r11                256
#define maxBandComb_r13                384
#define maxBandCombSidelinkNR_r16      512
#define maxBands                       64
#define maxBandsNR_r15                 1024
#define maxBandsENDC_r16               10
#define maxBandwidthClass_r10          16
#define maxBandwidthCombSet_r10        32
#define maxBarringInfoSet_r15          8
#define maxBT_IdReport_r15             32
#define maxBT_Name_r15                 4
#define maxCBR_Level_r14               16
#define maxCBR_Level_1_r14             15
#define maxCBR_Report_r14              72
#define maxCDMA_BandClass              32
#define maxCE_Level_r13                4
#define maxExcludedCell                16
#define maxCellHistory_r12             16
#define maxCellInfoGERAN_r9            32
#define maxCellInfoUTRA_r9             16
#define maxCellMeasIdle_r15            8
#define maxCellNR_r17                  8
#define maxCombIDC_r11                 128
#define maxCSI_IM_r11                  3
#define maxCSI_IM_r12                  4
#define minCSI_IM_r13                  5
#define maxCSI_IM_r13                  24
#define maxCSI_IM_v1310                20
#define maxCSI_Proc_r11                4
#define maxCSI_RS_NZP_r11              3
#define minCSI_RS_NZP_r13              4
#define maxCSI_RS_NZP_r13              24
#define maxCSI_RS_NZP_v1310            21
#define maxCSI_RS_ZP_r11               4
#define maxCQI_ProcExt_r11             3
#define maxFreqUTRA_TDD_r10            6
#define maxCellInter                   16
#define maxCellIntra                   16
#define maxCellListGERAN               3
#define maxCellMeas                    32
#define maxCellRAReportNR_r18          8
#define maxCellReport                  8
#define maxCellSFTD                    3
#define maxCellAllowedNR_r16           16
#define maxCondConfig_r16              8
#define maxConfigSPS_r14               8
#define maxConfigSPS_r15               6
#define maxCSI_RS_Meas_r12             96
#define maxDRB                         11
#define maxDRBExt_r15                  4
#define maxDRB_r15                     15
#define maxDS_Duration_r12             5
#define maxDS_ZTP_CSI_RS_r12           5
#define maxEARFCN                      65535
#define maxEARFCN_Plus1                65536
#define maxEARFCN2                     262143
#define maxEPDCCH_Set_r11              2
#define maxFBI                         64
#define maxFBI_NR_r15                  1024
#define maxFBI_Plus1                   65
#define maxFBI2                        256
#define maxFeatureSets_r15             256
#define maxPerCC_FeatureSets_r15       32
#define maxFreq                        8
#define maxFreq_1_r16                  7
#define maxFreqIDC_r11                 32
#define maxFreqIdle_r15                8
#define maxFreqMBMS_r11                5
#define maxFreqNBIOT_r16               8
#define maxFreqNR_r15                  5
#define maxFreqSL_NR_r16               8
#define maxFreqV2X_r14                 8
#define maxFreqV2X_1_r14               7
#define maxGERAN_SI                    10
#define maxGNFG                        16
#define maxGWUS_Groups_1_r16           31
#define maxGWUS_Resources_r16          4
#define maxGWUS_ProbThresholds_r16     3
#define maxIdleMeasCarriers_r15        3
#define maxIdleMeasCarriersExt_r16     5
#define maxIdleMeasCarriers_r16        8
#define maxLCG_r13                     4
#define maxLogMeasReport_r10           520
#define maxLowerMSD_r18                256
#define maxLowerMSD_Info_r18           64
#define maxMBSFN_Allocations           8
#define maxMBSFN_Area                  8
#define maxMBSFN_Area_1                7
#define maxMBMS_ServiceListPerUE_r13   15
#define maxMeasId                      32
#define maxMeasId_Plus1                33
#define maxMeasId_r12                  64
#define maxMultiBands                  8
#define maxMultiBandsNR_r15            32
#define maxMultiBandsNR_1_r15          31
#define maxNS_Pmax_r10                 8
#define maxNAICS_Entries_r12           8
#define maxNeighCell_r12               8
#define maxNeighCell_SCPTM_r13         8
#define maxNrofPCI_PerSMTC_r16         64
#define maxNrofS_NSSAI_r15             8
#define maxObjectId                    32
#define maxObjectId_Plus1_r13          33
#define maxObjectId_r13                64
#define maxP_a_PerNeighCell_r12        3
#define maxPageRec                     16
#define maxPhysCellIdRange_r9          4
#define maxPLMN_r11                    6
#define maxPLMN_1_r14                  5
#define maxPLMN_r15                    8
#define maxPLMN_NR_r15                 12
#define maxPNOffset                    511
#define maxPMCH_PerMBSFN               15
#define maxPSSCH_TxConfig_r14          16
#define maxQuantSetsNR_r15             2
#define maxQCI_r13                     6
#define maxRAT_Capabilities            8
#define maxRE_MapQCL_r11               4
#define maxReportConfigId              32
#define maxReservationPeriod_r14       16
#define maxRS_Index_r15                64
#define maxRS_Index_1_r15              63
#define maxRS_IndexCellQual_r15        16
#define maxRS_IndexReport_r15          32
#define maxRSTD_Freq_r10               3
#define maxSAI_MBMS_r11                64
#define maxSat_r17                     4
#define maxSCell_r10                   4
#define maxSCell_r13                   31
#define maxSCellGroups_r15             4
#define maxSC_MTCH_r13                 1023
#define maxSC_MTCH_BR_r14              128
#define maxSL_CommRxPoolNFreq_r13      32
#define maxSL_CommRxPoolPreconf_v1310  12
#define maxSL_TxPool_r12Plus1_r13      5
#define maxSL_TxPool_v1310             4
#define maxSL_TxPool_r13               8
#define maxSL_CommTxPoolPreconf_v1310  7
#define maxSL_Dest_r12                 16
#define maxSL_DiscCells_r13            16
#define maxSL_DiscPowerClass_r12       3
#define maxSL_DiscRxPoolPreconf_r13    16
#define maxSL_DiscSysInfoReportFreq_r13 8
#define maxSL_DiscTxPoolPreconf_r13    4
#define maxSL_GP_r13                   8
#define maxSL_PoolToMeasure_r14        72
#define maxSL_Prio_r13                 8
#define maxSL_RxPool_r12               16
#define maxSL_Reliability_r15          8
#define maxSL_SyncConfig_r12           16
#define maxSL_TF_IndexPair_r12         64
#define maxSL_TxPool_r12               4
#define maxSL_V2X_RxPool_r14           16
#define maxSL_V2X_RxPoolPreconf_r14    16
#define maxSL_V2X_TxPool_r14           8
#define maxSL_V2X_TxPoolPreconf_r14    8
#define maxSL_V2X_SyncConfig_r14       16
#define maxSL_V2X_CBRConfig_r14        4
#define maxSL_V2X_CBRConfig_1_r14      3
#define maxSL_V2X_TxConfig_r14         64
#define maxSL_V2X_TxConfig_1_r14       63
#define maxSL_V2X_CBRConfig2_r14       8
#define maxSL_V2X_CBRConfig2_1_r14     7
#define maxSL_V2X_TxConfig2_r14        128
#define maxSL_V2X_TxConfig2_1_r14      127
#define maxSTAG_r11                    3
#define maxServCell_r10                5
#define maxServCell_r13                32
#define maxServCellNR_r15              16
#define maxServiceCount                16
#define maxServiceCount_1              15
#define maxSessionPerPMCH              29
#define maxSessionPerPMCH_1            28
#define maxSIB                         32
#define maxSIB_1                       31
#define maxSI_Message                  32
#define maxSimultaneousBands_r10       64
#define maxSubframePatternIDC_r11      8
#define maxTAC_r17                     12
#define maxTrafficPattern_r14          8
#define maxUTRA_FDD_Carrier            16
#define maxUTRA_TDD_Carrier            16
#define maxWayPoint_r15                20
#define maxWLAN_Id_r12                 16
#define maxWLAN_Bands_r13              8
#define maxWLAN_Id_r13                 32
#define maxWLAN_Channels_r13           16
#define maxWLAN_CarrierInfo_r13        8
#define maxWLAN_Id_Report_r14          32
#define maxWLAN_Name_r15               4
#define maxFreqANR_NB_r16              2
#define maxFreqEUTRA_NB_r16            8
#define maxFreqsGERAN_NB_r16           8
#define maxGWUS_Groups_1_NB_r16        15
#define maxGWUS_Resources_NB_r16       2
#define maxGWUS_ProbThresholds_NB_r16  3
#define maxNPRACH_Resources_NB_r13     3
#define maxNonAnchorCarriers_NB_r14    15
#define maxDRB_NB_r13                  2
#define maxNeighCell_SCPTM_NB_r14      8
#define maxNS_Pmax_NB_r13              4
#define maxSC_MTCH_NB_r14              64
#define maxSI_Message_NB_r13           8
#define maxTAC_NB_r17                  12

typedef enum _RAT_Type_enum {
  RAT_Type_eutra =   0,
  RAT_Type_utra =   1,
  RAT_Type_geran_cs =   2,
  RAT_Type_geran_ps =   3,
  RAT_Type_cdma2000_1XRTT =   4,
  RAT_Type_nr  =   5,
  RAT_Type_eutra_nr =   6,
  RAT_Type_spare1 =   7
} RAT_Type_enum;

typedef enum _T_targetRAT_Type_enum {
  T_targetRAT_Type_utra =   0,
  T_targetRAT_Type_geran =   1,
  T_targetRAT_Type_cdma2000_1XRTT =   2,
  T_targetRAT_Type_cdma2000_HRPD =   3,
  T_targetRAT_Type_nr =   4,
  T_targetRAT_Type_eutra =   5,
  T_targetRAT_Type_spare2 =   6,
  T_targetRAT_Type_spare1 =   7
} T_targetRAT_Type_enum;

typedef enum _SI_OrPSI_GERAN_enum {
  SI_OrPSI_GERAN_si =   0,
  SI_OrPSI_GERAN_psi =   1
} SI_OrPSI_GERAN_enum;

/* Initialize the protocol and registered fields */
static int proto_lte_rrc;

static int hf_lte_rrc_lte_rrc_HandoverCommand_PDU;  /* HandoverCommand */
static int hf_lte_rrc_lte_rrc_HandoverPreparationInformation_PDU;  /* HandoverPreparationInformation */
static int hf_lte_rrc_lte_rrc_SCG_Config_r12_PDU;  /* SCG_Config_r12 */
static int hf_lte_rrc_lte_rrc_SCG_ConfigInfo_r12_PDU;  /* SCG_ConfigInfo_r12 */
static int hf_lte_rrc_lte_rrc_UEPagingCoverageInformation_PDU;  /* UEPagingCoverageInformation */
static int hf_lte_rrc_lte_rrc_UERadioAccessCapabilityInformation_PDU;  /* UERadioAccessCapabilityInformation */
static int hf_lte_rrc_lte_rrc_UERadioPagingInformation_PDU;  /* UERadioPagingInformation */
static int hf_lte_rrc_BCCH_BCH_Message_PDU;       /* BCCH_BCH_Message */
static int hf_lte_rrc_BCCH_BCH_Message_MBMS_PDU;  /* BCCH_BCH_Message_MBMS */
static int hf_lte_rrc_BCCH_DL_SCH_Message_PDU;    /* BCCH_DL_SCH_Message */
static int hf_lte_rrc_BCCH_DL_SCH_Message_BR_PDU;  /* BCCH_DL_SCH_Message_BR */
static int hf_lte_rrc_BCCH_DL_SCH_Message_MBMS_PDU;  /* BCCH_DL_SCH_Message_MBMS */
static int hf_lte_rrc_MCCH_Message_PDU;           /* MCCH_Message */
static int hf_lte_rrc_PCCH_Message_PDU;           /* PCCH_Message */
static int hf_lte_rrc_DL_CCCH_Message_PDU;        /* DL_CCCH_Message */
static int hf_lte_rrc_lte_rrc_DL_DCCH_Message_PDU;  /* DL_DCCH_Message */
static int hf_lte_rrc_UL_CCCH_Message_PDU;        /* UL_CCCH_Message */
static int hf_lte_rrc_lte_rrc_UL_DCCH_Message_PDU;  /* UL_DCCH_Message */
static int hf_lte_rrc_SC_MCCH_Message_r13_PDU;    /* SC_MCCH_Message_r13 */
static int hf_lte_rrc_lte_rrc_MeasurementReport_PDU;  /* MeasurementReport */
static int hf_lte_rrc_RRCConnectionReconfiguration_PDU;  /* RRCConnectionReconfiguration */
static int hf_lte_rrc_lte_rrc_RRCConnectionReconfigurationComplete_PDU;  /* RRCConnectionReconfigurationComplete */
static int hf_lte_rrc_lte_rrc_SidelinkUEInformation_r12_PDU;  /* SidelinkUEInformation_r12 */
static int hf_lte_rrc_lte_rrc_UEAssistanceInformation_r11_PDU;  /* UEAssistanceInformation_r11 */
static int hf_lte_rrc_lte_rrc_UECapabilityEnquiry_PDU;  /* UECapabilityEnquiry */
static int hf_lte_rrc_UECapabilityInformation_PDU;  /* UECapabilityInformation */
static int hf_lte_rrc_lte_rrc_CellIdListNR_r18_PDU;  /* CellIdListNR_r18 */
static int hf_lte_rrc_lte_rrc_RLF_Report_r9_PDU;  /* RLF_Report_r9 */
static int hf_lte_rrc_lte_rrc_RLF_Report_v9e0_PDU;  /* RLF_Report_v9e0 */
static int hf_lte_rrc_lte_rrc_SystemInformationBlockType21_r14_PDU;  /* SystemInformationBlockType21_r14 */
static int hf_lte_rrc_lte_rrc_TDD_Config_PDU;     /* TDD_Config */
static int hf_lte_rrc_lte_rrc_ThresholdListNR_r15_PDU;  /* ThresholdListNR_r15 */
static int hf_lte_rrc_lte_rrc_CellsToAddModListNR_r15_PDU;  /* CellsToAddModListNR_r15 */
static int hf_lte_rrc_lte_rrc_MeasResultSCG_FailureMRDC_r15_PDU;  /* MeasResultSCG_FailureMRDC_r15 */
static int hf_lte_rrc_lte_rrc_MeasResultList3EUTRA_r15_PDU;  /* MeasResultList3EUTRA_r15 */
static int hf_lte_rrc_lte_rrc_MTC_SSB_NR_r15_PDU;  /* MTC_SSB_NR_r15 */
static int hf_lte_rrc_lte_rrc_QuantityConfigNR_r15_PDU;  /* QuantityConfigNR_r15 */
static int hf_lte_rrc_lte_rrc_SS_RSSI_Measurement_r15_PDU;  /* SS_RSSI_Measurement_r15 */
static int hf_lte_rrc_lte_rrc_SSB_ToMeasure_r15_PDU;  /* SSB_ToMeasure_r15 */
static int hf_lte_rrc_lte_rrc_UE_EUTRA_Capability_PDU;  /* UE_EUTRA_Capability */
static int hf_lte_rrc_lte_rrc_V2X_BandParameters_r14_PDU;  /* V2X_BandParameters_r14 */
static int hf_lte_rrc_lte_rrc_V2X_BandParameters_v1530_PDU;  /* V2X_BandParameters_v1530 */
static int hf_lte_rrc_lte_rrc_SL_Parameters_v1430_PDU;  /* SL_Parameters_v1430 */
static int hf_lte_rrc_lte_rrc_SL_Parameters_v1530_PDU;  /* SL_Parameters_v1530 */
static int hf_lte_rrc_lte_rrc_SL_Parameters_v1540_PDU;  /* SL_Parameters_v1540 */
static int hf_lte_rrc_lte_rrc_VisitedCellInfoList_r12_PDU;  /* VisitedCellInfoList_r12 */
static int hf_lte_rrc_lte_rrc_VisitedCellInfo_r12_PDU;  /* VisitedCellInfo_r12 */
static int hf_lte_rrc_SBCCH_SL_BCH_Message_PDU;   /* SBCCH_SL_BCH_Message */
static int hf_lte_rrc_SBCCH_SL_BCH_Message_V2X_r14_PDU;  /* SBCCH_SL_BCH_Message_V2X_r14 */
static int hf_lte_rrc_lte_rrc_HandoverPreparationInformation_NB_PDU;  /* HandoverPreparationInformation_NB */
static int hf_lte_rrc_lte_rrc_UEPagingCoverageInformation_NB_PDU;  /* UEPagingCoverageInformation_NB */
static int hf_lte_rrc_UERadioAccessCapabilityInformation_NB_PDU;  /* UERadioAccessCapabilityInformation_NB */
static int hf_lte_rrc_UERadioPagingInformation_NB_PDU;  /* UERadioPagingInformation_NB */
static int hf_lte_rrc_BCCH_BCH_Message_NB_PDU;    /* BCCH_BCH_Message_NB */
static int hf_lte_rrc_BCCH_BCH_Message_TDD_NB_PDU;  /* BCCH_BCH_Message_TDD_NB */
static int hf_lte_rrc_BCCH_DL_SCH_Message_NB_PDU;  /* BCCH_DL_SCH_Message_NB */
static int hf_lte_rrc_PCCH_Message_NB_PDU;        /* PCCH_Message_NB */
static int hf_lte_rrc_DL_CCCH_Message_NB_PDU;     /* DL_CCCH_Message_NB */
static int hf_lte_rrc_DL_DCCH_Message_NB_PDU;     /* DL_DCCH_Message_NB */
static int hf_lte_rrc_UL_CCCH_Message_NB_PDU;     /* UL_CCCH_Message_NB */
static int hf_lte_rrc_SC_MCCH_Message_NB_PDU;     /* SC_MCCH_Message_NB */
static int hf_lte_rrc_UL_DCCH_Message_NB_PDU;     /* UL_DCCH_Message_NB */
static int hf_lte_rrc_lte_rrc_RLF_Report_NB_r16_PDU;  /* RLF_Report_NB_r16 */
static int hf_lte_rrc_lte_rrc_UL_ConfigCommonList_NB_r14_PDU;  /* UL_ConfigCommonList_NB_r14 */
static int hf_lte_rrc_lte_rrc_UL_ConfigCommonListTDD_NB_r15_PDU;  /* UL_ConfigCommonListTDD_NB_r15 */
static int hf_lte_rrc_lte_rrc_UL_ConfigCommonList_NB_v1530_PDU;  /* UL_ConfigCommonList_NB_v1530 */
static int hf_lte_rrc_lte_rrc_DL_CarrierConfigCommon_NB_r14_PDU;  /* DL_CarrierConfigCommon_NB_r14 */
static int hf_lte_rrc_lte_rrc_NPRACH_ParametersList_NB_r13_PDU;  /* NPRACH_ParametersList_NB_r13 */
static int hf_lte_rrc_lte_rrc_NPRACH_ParametersList_NB_r14_PDU;  /* NPRACH_ParametersList_NB_r14 */
static int hf_lte_rrc_lte_rrc_NPRACH_ParametersListTDD_NB_r15_PDU;  /* NPRACH_ParametersListTDD_NB_r15 */
static int hf_lte_rrc_lte_rrc_NPRACH_ParametersListFmt2_NB_r15_PDU;  /* NPRACH_ParametersListFmt2_NB_r15 */
static int hf_lte_rrc_HandoverPreparationInformation_v9j0_IEs_PDU;  /* HandoverPreparationInformation_v9j0_IEs */
static int hf_lte_rrc_SCG_Config_v12i0b_IEs_PDU;  /* SCG_Config_v12i0b_IEs */
static int hf_lte_rrc_MBMSInterestIndication_r11_PDU;  /* MBMSInterestIndication_r11 */
static int hf_lte_rrc_UE_RadioPagingInfo_r12_PDU;  /* UE_RadioPagingInfo_r12 */
static int hf_lte_rrc_SystemInformationBlockType1_v890_IEs_PDU;  /* SystemInformationBlockType1_v890_IEs */
static int hf_lte_rrc_InDeviceCoexIndication_r11_PDU;  /* InDeviceCoexIndication_r11 */
static int hf_lte_rrc_WLANConnectionStatusReport_r13_PDU;  /* WLANConnectionStatusReport_r13 */
static int hf_lte_rrc_SystemInformationBlockType1_PDU;  /* SystemInformationBlockType1 */
static int hf_lte_rrc_RRCConnectionReconfiguration_v8m0_IEs_PDU;  /* RRCConnectionReconfiguration_v8m0_IEs */
static int hf_lte_rrc_SystemInformationBlockType2_PDU;  /* SystemInformationBlockType2 */
static int hf_lte_rrc_SystemInformationBlockType31_r17_PDU;  /* SystemInformationBlockType31_r17 */
static int hf_lte_rrc_RRCConnectionRelease_v9e0_IEs_PDU;  /* RRCConnectionRelease_v9e0_IEs */
static int hf_lte_rrc_SCGFailureInformation_v12d0b_IEs_PDU;  /* SCGFailureInformation_v12d0b_IEs */
static int hf_lte_rrc_SystemInformationBlockType1_v8h0_IEs_PDU;  /* SystemInformationBlockType1_v8h0_IEs */
static int hf_lte_rrc_UEInformationResponse_v9e0_IEs_PDU;  /* UEInformationResponse_v9e0_IEs */
static int hf_lte_rrc_SystemInformationBlockType2_v8h0_IEs_PDU;  /* SystemInformationBlockType2_v8h0_IEs */
static int hf_lte_rrc_SystemInformationBlockType2_v10m0_IEs_PDU;  /* SystemInformationBlockType2_v10m0_IEs */
static int hf_lte_rrc_SystemInformationBlockType3_v10j0_IEs_PDU;  /* SystemInformationBlockType3_v10j0_IEs */
static int hf_lte_rrc_SystemInformationBlockType5_v8h0_IEs_PDU;  /* SystemInformationBlockType5_v8h0_IEs */
static int hf_lte_rrc_SystemInformationBlockType6_v8h0_IEs_PDU;  /* SystemInformationBlockType6_v8h0_IEs */
static int hf_lte_rrc_UE_EUTRA_Capability_v10j0_IEs_PDU;  /* UE_EUTRA_Capability_v10j0_IEs */
static int hf_lte_rrc_UE_EUTRA_Capability_v13e0b_IEs_PDU;  /* UE_EUTRA_Capability_v13e0b_IEs */
static int hf_lte_rrc_UE_EUTRA_Capability_v9a0_IEs_PDU;  /* UE_EUTRA_Capability_v9a0_IEs */
static int hf_lte_rrc_UE_Capability_NB_Ext_r14_IEs_PDU;  /* UE_Capability_NB_Ext_r14_IEs */
static int hf_lte_rrc_UE_Capability_NB_r13_PDU;   /* UE_Capability_NB_r13 */
static int hf_lte_rrc_UECapabilityInformation_NB_PDU;  /* UECapabilityInformation_NB */
static int hf_lte_rrc_UE_RadioPagingInfo_NB_r13_PDU;  /* UE_RadioPagingInfo_NB_r13 */
static int hf_lte_rrc_UE_EUTRA_Capability_v16f0_IEs_PDU;  /* UE_EUTRA_Capability_v16f0_IEs */
static int hf_lte_rrc_criticalExtensions;         /* T_criticalExtensions */
static int hf_lte_rrc_c1;                         /* T_c1 */
static int hf_lte_rrc_handoverCommand_r8;         /* HandoverCommand_r8_IEs */
static int hf_lte_rrc_spare7;                     /* NULL */
static int hf_lte_rrc_spare6;                     /* NULL */
static int hf_lte_rrc_spare5;                     /* NULL */
static int hf_lte_rrc_spare4;                     /* NULL */
static int hf_lte_rrc_spare3;                     /* NULL */
static int hf_lte_rrc_spare2;                     /* NULL */
static int hf_lte_rrc_spare1;                     /* NULL */
static int hf_lte_rrc_criticalExtensionsFuture;   /* T_criticalExtensionsFuture */
static int hf_lte_rrc_handoverCommandMessage;     /* T_handoverCommandMessage */
static int hf_lte_rrc_nonCriticalExtension;       /* T_nonCriticalExtension */
static int hf_lte_rrc_criticalExtensions_01;      /* T_criticalExtensions_01 */
static int hf_lte_rrc_c1_01;                      /* T_c1_01 */
static int hf_lte_rrc_handoverPreparationInformation_r8;  /* HandoverPreparationInformation_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_01;  /* T_criticalExtensionsFuture_01 */
static int hf_lte_rrc_ue_RadioAccessCapabilityInfo;  /* UE_CapabilityRAT_ContainerList */
static int hf_lte_rrc_as_Config;                  /* AS_Config */
static int hf_lte_rrc_rrm_Config;                 /* RRM_Config */
static int hf_lte_rrc_as_Context;                 /* AS_Context */
static int hf_lte_rrc_nonCriticalExtension_01;    /* HandoverPreparationInformation_v920_IEs */
static int hf_lte_rrc_ue_ConfigRelease_r9;        /* T_ue_ConfigRelease_r9 */
static int hf_lte_rrc_nonCriticalExtension_02;    /* HandoverPreparationInformation_v9d0_IEs */
static int hf_lte_rrc_lateNonCriticalExtension;   /* T_lateNonCriticalExtension */
static int hf_lte_rrc_nonCriticalExtension_03;    /* HandoverPreparationInformation_v9e0_IEs */
static int hf_lte_rrc_lateNonCriticalExtension_01;  /* OCTET_STRING */
static int hf_lte_rrc_nonCriticalExtension_04;    /* HandoverPreparationInformation_v10j0_IEs */
static int hf_lte_rrc_as_Config_v10j0;            /* AS_Config_v10j0 */
static int hf_lte_rrc_nonCriticalExtension_05;    /* HandoverPreparationInformation_v10x0_IEs */
static int hf_lte_rrc_nonCriticalExtension_06;    /* HandoverPreparationInformation_v13c0_IEs */
static int hf_lte_rrc_as_Config_v13c0;            /* AS_Config_v13c0 */
static int hf_lte_rrc_nonCriticalExtension_07;    /* T_nonCriticalExtension_01 */
static int hf_lte_rrc_as_Config_v9e0;             /* AS_Config_v9e0 */
static int hf_lte_rrc_nonCriticalExtension_08;    /* HandoverPreparationInformation_v1130_IEs */
static int hf_lte_rrc_as_Context_v1130;           /* AS_Context_v1130 */
static int hf_lte_rrc_nonCriticalExtension_09;    /* HandoverPreparationInformation_v1250_IEs */
static int hf_lte_rrc_ue_SupportedEARFCN_r12;     /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_as_Config_v1250;            /* AS_Config_v1250 */
static int hf_lte_rrc_nonCriticalExtension_10;    /* HandoverPreparationInformation_v1320_IEs */
static int hf_lte_rrc_as_Config_v1320;            /* AS_Config_v1320 */
static int hf_lte_rrc_as_Context_v1320;           /* AS_Context_v1320 */
static int hf_lte_rrc_nonCriticalExtension_11;    /* HandoverPreparationInformation_v1430_IEs */
static int hf_lte_rrc_as_Config_v1430;            /* AS_Config_v1430 */
static int hf_lte_rrc_makeBeforeBreakReq_r14;     /* T_makeBeforeBreakReq_r14 */
static int hf_lte_rrc_nonCriticalExtension_12;    /* HandoverPreparationInformation_v1530_IEs */
static int hf_lte_rrc_ran_NotificationAreaInfo_r15;  /* RAN_NotificationAreaInfo_r15 */
static int hf_lte_rrc_nonCriticalExtension_13;    /* HandoverPreparationInformation_v1540_IEs */
static int hf_lte_rrc_sourceRB_ConfigIntra5GC_r15;  /* T_sourceRB_ConfigIntra5GC_r15 */
static int hf_lte_rrc_nonCriticalExtension_14;    /* HandoverPreparationInformation_v1610_IEs */
static int hf_lte_rrc_as_Context_v1610;           /* AS_Context_v1610 */
static int hf_lte_rrc_nonCriticalExtension_15;    /* HandoverPreparationInformation_v1620_IEs */
static int hf_lte_rrc_as_Context_v1620;           /* AS_Context_v1620 */
static int hf_lte_rrc_nonCriticalExtension_16;    /* HandoverPreparationInformation_v1630_IEs */
static int hf_lte_rrc_as_Context_v1630;           /* AS_Context_v1630 */
static int hf_lte_rrc_nonCriticalExtension_17;    /* HandoverPreparationInformation_v1700_IEs */
static int hf_lte_rrc_as_Config_v1700;            /* AS_Config_v1700 */
static int hf_lte_rrc_nonCriticalExtension_18;    /* T_nonCriticalExtension_02 */
static int hf_lte_rrc_criticalExtensions_02;      /* T_criticalExtensions_02 */
static int hf_lte_rrc_c1_02;                      /* T_c1_02 */
static int hf_lte_rrc_scg_Config_r12;             /* SCG_Config_r12_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_02;  /* T_criticalExtensionsFuture_02 */
static int hf_lte_rrc_scg_RadioConfig_r12;        /* SCG_ConfigPartSCG_r12 */
static int hf_lte_rrc_nonCriticalExtension_19;    /* SCG_Config_v12i0a_IEs */
static int hf_lte_rrc_lateNonCriticalExtension_02;  /* T_lateNonCriticalExtension_01 */
static int hf_lte_rrc_nonCriticalExtension_20;    /* SCG_Config_v13c0_IEs */
static int hf_lte_rrc_scg_RadioConfig_v12i0;      /* SCG_ConfigPartSCG_v12f0 */
static int hf_lte_rrc_nonCriticalExtension_21;    /* T_nonCriticalExtension_03 */
static int hf_lte_rrc_scg_RadioConfig_v13c0;      /* SCG_ConfigPartSCG_v13c0 */
static int hf_lte_rrc_nonCriticalExtension_22;    /* T_nonCriticalExtension_04 */
static int hf_lte_rrc_criticalExtensions_03;      /* T_criticalExtensions_03 */
static int hf_lte_rrc_c1_03;                      /* T_c1_03 */
static int hf_lte_rrc_scg_ConfigInfo_r12;         /* SCG_ConfigInfo_r12_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_03;  /* T_criticalExtensionsFuture_03 */
static int hf_lte_rrc_radioResourceConfigDedMCG_r12;  /* RadioResourceConfigDedicated */
static int hf_lte_rrc_sCellToAddModListMCG_r12;   /* SCellToAddModList_r10 */
static int hf_lte_rrc_measGapConfig_r12;          /* MeasGapConfig */
static int hf_lte_rrc_powerCoordinationInfo_r12;  /* PowerCoordinationInfo_r12 */
static int hf_lte_rrc_eutra_CapabilityInfo_r12;   /* T_eutra_CapabilityInfo_r12 */
static int hf_lte_rrc_scg_ConfigRestrictInfo_r12;  /* SCG_ConfigRestrictInfo_r12 */
static int hf_lte_rrc_mbmsInterestIndication_r12;  /* T_mbmsInterestIndication_r12 */
static int hf_lte_rrc_measResultServCellListSCG_r12;  /* MeasResultServCellListSCG_r12 */
static int hf_lte_rrc_drb_ToAddModListSCG_r12;    /* DRB_InfoListSCG_r12 */
static int hf_lte_rrc_drb_ToReleaseListSCG_r12;   /* DRB_ToReleaseList */
static int hf_lte_rrc_sCellToAddModListSCG_r12;   /* SCellToAddModListSCG_r12 */
static int hf_lte_rrc_sCellToReleaseListSCG_r12;  /* SCellToReleaseList_r10 */
static int hf_lte_rrc_p_Max_r12;                  /* P_Max */
static int hf_lte_rrc_nonCriticalExtension_23;    /* SCG_ConfigInfo_v1310_IEs */
static int hf_lte_rrc_measResultSSTD_r13;         /* MeasResultSSTD_r13 */
static int hf_lte_rrc_sCellToAddModListMCG_Ext_r13;  /* SCellToAddModListExt_r13 */
static int hf_lte_rrc_measResultServCellListSCG_Ext_r13;  /* MeasResultServCellListSCG_Ext_r13 */
static int hf_lte_rrc_sCellToAddModListSCG_Ext_r13;  /* SCellToAddModListSCG_Ext_r13 */
static int hf_lte_rrc_sCellToReleaseListSCG_Ext_r13;  /* SCellToReleaseListExt_r13 */
static int hf_lte_rrc_nonCriticalExtension_24;    /* SCG_ConfigInfo_v1330_IEs */
static int hf_lte_rrc_measResultListRSSI_SCG_r13;  /* MeasResultListRSSI_SCG_r13 */
static int hf_lte_rrc_nonCriticalExtension_25;    /* SCG_ConfigInfo_v1430_IEs */
static int hf_lte_rrc_makeBeforeBreakSCG_Req_r14;  /* T_makeBeforeBreakSCG_Req_r14 */
static int hf_lte_rrc_measGapConfigPerCC_List;    /* MeasGapConfigPerCC_List_r14 */
static int hf_lte_rrc_nonCriticalExtension_26;    /* SCG_ConfigInfo_v1530_IEs */
static int hf_lte_rrc_drb_ToAddModListSCG_r15;    /* DRB_InfoListSCG_r15 */
static int hf_lte_rrc_drb_ToReleaseListSCG_r15;   /* DRB_ToReleaseList_r15 */
static int hf_lte_rrc_nonCriticalExtension_27;    /* T_nonCriticalExtension_05 */
static int hf_lte_rrc_DRB_InfoListSCG_r12_item;   /* DRB_InfoSCG_r12 */
static int hf_lte_rrc_DRB_InfoListSCG_r15_item;   /* DRB_InfoSCG_r12 */
static int hf_lte_rrc_eps_BearerIdentity_r12;     /* INTEGER_0_15 */
static int hf_lte_rrc_drb_Identity_r12;           /* DRB_Identity */
static int hf_lte_rrc_drb_Type_r12;               /* T_drb_Type_r12 */
static int hf_lte_rrc_SCellToAddModListSCG_r12_item;  /* Cell_ToAddMod_r12 */
static int hf_lte_rrc_SCellToAddModListSCG_Ext_r13_item;  /* Cell_ToAddMod_r12 */
static int hf_lte_rrc_sCellIndex_r12;             /* SCellIndex_r10 */
static int hf_lte_rrc_cellIdentification_r12;     /* T_cellIdentification_r12 */
static int hf_lte_rrc_physCellId_r12;             /* PhysCellId */
static int hf_lte_rrc_dl_CarrierFreq_r12;         /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_measResultCellToAdd_r12;    /* T_measResultCellToAdd_r12 */
static int hf_lte_rrc_rsrpResult_r12;             /* RSRP_Range */
static int hf_lte_rrc_rsrqResult_r12;             /* RSRQ_Range */
static int hf_lte_rrc_sCellIndex_r13;             /* SCellIndex_r13 */
static int hf_lte_rrc_measResultCellToAdd_v1310;  /* T_measResultCellToAdd_v1310 */
static int hf_lte_rrc_rs_sinr_Result_r13;         /* RS_SINR_Range_r13 */
static int hf_lte_rrc_MeasResultServCellListSCG_r12_item;  /* MeasResultServCellSCG_r12 */
static int hf_lte_rrc_MeasResultServCellListSCG_Ext_r13_item;  /* MeasResultServCellSCG_r12 */
static int hf_lte_rrc_servCellId_r12;             /* ServCellIndex_r10 */
static int hf_lte_rrc_measResultSCell_r12;        /* T_measResultSCell_r12 */
static int hf_lte_rrc_rsrpResultSCell_r12;        /* RSRP_Range */
static int hf_lte_rrc_rsrqResultSCell_r12;        /* RSRQ_Range */
static int hf_lte_rrc_servCellId_r13;             /* ServCellIndex_r13 */
static int hf_lte_rrc_measResultSCell_v1310;      /* T_measResultSCell_v1310 */
static int hf_lte_rrc_rs_sinr_ResultSCell_r13;    /* RS_SINR_Range_r13 */
static int hf_lte_rrc_MeasResultListRSSI_SCG_r13_item;  /* MeasResultRSSI_SCG_r13 */
static int hf_lte_rrc_measResultForRSSI_r13;      /* MeasResultForRSSI_r13 */
static int hf_lte_rrc_maxSCH_TB_BitsDL_r12;       /* INTEGER_1_100 */
static int hf_lte_rrc_maxSCH_TB_BitsUL_r12;       /* INTEGER_1_100 */
static int hf_lte_rrc_criticalExtensions_04;      /* T_criticalExtensions_04 */
static int hf_lte_rrc_c1_04;                      /* T_c1_04 */
static int hf_lte_rrc_uePagingCoverageInformation_r13;  /* UEPagingCoverageInformation_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_04;  /* T_criticalExtensionsFuture_04 */
static int hf_lte_rrc_mpdcch_NumRepetition_r13;   /* INTEGER_1_256 */
static int hf_lte_rrc_nonCriticalExtension_28;    /* T_nonCriticalExtension_06 */
static int hf_lte_rrc_criticalExtensions_05;      /* T_criticalExtensions_05 */
static int hf_lte_rrc_c1_05;                      /* T_c1_05 */
static int hf_lte_rrc_ueRadioAccessCapabilityInformation_r8;  /* UERadioAccessCapabilityInformation_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_05;  /* T_criticalExtensionsFuture_05 */
static int hf_lte_rrc_uERadioAccessCapabilityInformation_r8_IEs_ue_RadioAccessCapabilityInfo;  /* T_uERadioAccessCapabilityInformation_r8_IEs_ue_RadioAccessCapabilityInfo */
static int hf_lte_rrc_nonCriticalExtension_29;    /* T_nonCriticalExtension_07 */
static int hf_lte_rrc_criticalExtensions_06;      /* T_criticalExtensions_06 */
static int hf_lte_rrc_c1_06;                      /* T_c1_06 */
static int hf_lte_rrc_ueRadioPagingInformation_r12;  /* UERadioPagingInformation_r12_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_06;  /* T_criticalExtensionsFuture_06 */
static int hf_lte_rrc_ue_RadioPagingInfo_r12;     /* T_ue_RadioPagingInfo_r12 */
static int hf_lte_rrc_nonCriticalExtension_30;    /* UERadioPagingInformation_v1310_IEs */
static int hf_lte_rrc_supportedBandListEUTRAForPaging_r13;  /* SEQUENCE_SIZE_1_maxBands_OF_FreqBandIndicator_r11 */
static int hf_lte_rrc_supportedBandListEUTRAForPaging_r13_item;  /* FreqBandIndicator_r11 */
static int hf_lte_rrc_nonCriticalExtension_31;    /* UERadioPagingInformation_v1610_IEs */
static int hf_lte_rrc_accessStratumRelease_r16;   /* T_accessStratumRelease_r16 */
static int hf_lte_rrc_nonCriticalExtension_32;    /* T_nonCriticalExtension_08 */
static int hf_lte_rrc_sourceMeasConfig;           /* MeasConfig */
static int hf_lte_rrc_sourceRadioResourceConfig;  /* RadioResourceConfigDedicated */
static int hf_lte_rrc_sourceSecurityAlgorithmConfig;  /* SecurityAlgorithmConfig */
static int hf_lte_rrc_sourceUE_Identity;          /* C_RNTI */
static int hf_lte_rrc_sourceMasterInformationBlock;  /* MasterInformationBlock */
static int hf_lte_rrc_sourceSystemInformationBlockType1;  /* SystemInformationBlockType1 */
static int hf_lte_rrc_sourceSystemInformationBlockType2;  /* SystemInformationBlockType2 */
static int hf_lte_rrc_antennaInfoCommon;          /* AntennaInfoCommon */
static int hf_lte_rrc_sourceDl_CarrierFreq;       /* ARFCN_ValueEUTRA */
static int hf_lte_rrc_sourceSystemInformationBlockType1Ext;  /* T_sourceSystemInformationBlockType1Ext */
static int hf_lte_rrc_sourceOtherConfig_r9;       /* OtherConfig_r9 */
static int hf_lte_rrc_sourceSCellConfigList_r10;  /* SCellToAddModList_r10 */
static int hf_lte_rrc_sourceConfigSCG_r12;        /* SCG_Config_r12 */
static int hf_lte_rrc_as_ConfigNR_r15;            /* AS_ConfigNR_r15 */
static int hf_lte_rrc_as_Config_v1550;            /* AS_Config_v1550 */
static int hf_lte_rrc_as_ConfigNR_v1570;          /* AS_ConfigNR_v1570 */
static int hf_lte_rrc_as_ConfigNR_v1620;          /* AS_ConfigNR_v1620 */
static int hf_lte_rrc_sourceDl_CarrierFreq_v9e0;  /* ARFCN_ValueEUTRA_v9e0 */
static int hf_lte_rrc_antennaInfoDedicatedPCell_v10i0;  /* AntennaInfoDedicated_v10i0 */
static int hf_lte_rrc_sourceWlan_OffloadConfig_r12;  /* WLAN_OffloadConfig_r12 */
static int hf_lte_rrc_sourceSL_CommConfig_r12;    /* SL_CommConfig_r12 */
static int hf_lte_rrc_sourceSL_DiscConfig_r12;    /* SL_DiscConfig_r12 */
static int hf_lte_rrc_sourceSCellConfigList_r13;  /* SCellToAddModListExt_r13 */
static int hf_lte_rrc_sourceRCLWI_Configuration_r13;  /* RCLWI_Configuration_r13 */
static int hf_lte_rrc_radioResourceConfigDedicated_v13c01;  /* RadioResourceConfigDedicated_v1370 */
static int hf_lte_rrc_radioResourceConfigDedicated_v13c02;  /* RadioResourceConfigDedicated_v13c0 */
static int hf_lte_rrc_sCellToAddModList_v13c0;    /* SCellToAddModList_v13c0 */
static int hf_lte_rrc_sCellToAddModListExt_v13c0;  /* SCellToAddModListExt_v13c0 */
static int hf_lte_rrc_sourceSL_V2X_CommConfig_r14;  /* SL_V2X_ConfigDedicated_r14 */
static int hf_lte_rrc_sourceLWA_Config_r14;       /* LWA_Config_r13 */
static int hf_lte_rrc_sourceWLAN_MeasResult_r14;  /* MeasResultListWLAN_r13 */
static int hf_lte_rrc_sourceRB_ConfigNR_r15;      /* T_sourceRB_ConfigNR_r15 */
static int hf_lte_rrc_sourceRB_ConfigSN_NR_r15;   /* T_sourceRB_ConfigSN_NR_r15 */
static int hf_lte_rrc_sourceOtherConfigSN_NR_r15;  /* T_sourceOtherConfigSN_NR_r15 */
static int hf_lte_rrc_sourceSCG_ConfiguredNR_r15;  /* T_sourceSCG_ConfiguredNR_r15 */
static int hf_lte_rrc_tdm_PatternConfig_r15;      /* T_tdm_PatternConfig_r15 */
static int hf_lte_rrc_subframeAssignment_r15;     /* SubframeAssignment_r15 */
static int hf_lte_rrc_harq_Offset_r15;            /* INTEGER_0_9 */
static int hf_lte_rrc_p_MaxEUTRA_r15;             /* P_Max */
static int hf_lte_rrc_tdm_PatternConfig2_r16;     /* TDM_PatternConfig_r15 */
static int hf_lte_rrc_scg_State_r17;              /* T_scg_State_r17 */
static int hf_lte_rrc_reestablishmentInfo;        /* ReestablishmentInfo */
static int hf_lte_rrc_idc_Indication_r11;         /* T_idc_Indication_r11 */
static int hf_lte_rrc_mbmsInterestIndication_r11;  /* T_mbmsInterestIndication_r11 */
static int hf_lte_rrc_ueAssistanceInformation_r11;  /* T_ueAssistanceInformation_r11 */
static int hf_lte_rrc_sidelinkUEInformation_r12;  /* T_sidelinkUEInformation_r12 */
static int hf_lte_rrc_sourceContextEN_DC_r15;     /* T_sourceContextEN_DC_r15 */
static int hf_lte_rrc_selectedbandCombinationInfoEN_DC_v1540;  /* T_selectedbandCombinationInfoEN_DC_v1540 */
static int hf_lte_rrc_wlanConnectionStatusReport_r13;  /* T_wlanConnectionStatusReport_r13 */
static int hf_lte_rrc_sidelinkUEInformationNR_r16;  /* T_sidelinkUEInformationNR_r16 */
static int hf_lte_rrc_ueAssistanceInformationNR_r16;  /* T_ueAssistanceInformationNR_r16 */
static int hf_lte_rrc_configRestrictInfoDAPS_r16;  /* ConfigRestrictInfoDAPS_r16 */
static int hf_lte_rrc_ueAssistanceInformationNR_SCG_r16;  /* T_ueAssistanceInformationNR_SCG_r16 */
static int hf_lte_rrc_configRestrictInfoDAPS_v1630;  /* ConfigRestrictInfoDAPS_v1630 */
static int hf_lte_rrc_maxSCH_TB_BitsDL_r16;       /* INTEGER_1_100 */
static int hf_lte_rrc_maxSCH_TB_BitsUL_r16;       /* INTEGER_1_100 */
static int hf_lte_rrc_daps_PowerCoordinationInfo_r16;  /* DAPS_PowerCoordinationInfo_r16 */
static int hf_lte_rrc_sourcePhysCellId;           /* PhysCellId */
static int hf_lte_rrc_targetCellShortMAC_I;       /* ShortMAC_I */
static int hf_lte_rrc_additionalReestabInfoList;  /* AdditionalReestabInfoList */
static int hf_lte_rrc_AdditionalReestabInfoList_item;  /* AdditionalReestabInfo */
static int hf_lte_rrc_cellIdentity;               /* CellIdentity */
static int hf_lte_rrc_key_eNodeB_Star;            /* Key_eNodeB_Star */
static int hf_lte_rrc_shortMAC_I;                 /* ShortMAC_I */
static int hf_lte_rrc_ue_InactiveTime;            /* T_ue_InactiveTime */
static int hf_lte_rrc_candidateCellInfoList_r10;  /* CandidateCellInfoList_r10 */
static int hf_lte_rrc_candidateCellInfoListNR_r15;  /* MeasResultServFreqListNR_r15 */
static int hf_lte_rrc_CandidateCellInfoList_r10_item;  /* CandidateCellInfo_r10 */
static int hf_lte_rrc_physCellId_r10;             /* PhysCellId */
static int hf_lte_rrc_dl_CarrierFreq_r10;         /* ARFCN_ValueEUTRA */
static int hf_lte_rrc_rsrpResult_r10;             /* RSRP_Range */
static int hf_lte_rrc_rsrqResult_r10;             /* RSRQ_Range */
static int hf_lte_rrc_dl_CarrierFreq_v1090;       /* ARFCN_ValueEUTRA_v9e0 */
static int hf_lte_rrc_rsrqResult_v1250;           /* RSRQ_Range_v1250 */
static int hf_lte_rrc_bCCH_BCH_Message_message;   /* BCCH_BCH_MessageType */
static int hf_lte_rrc_bCCH_BCH_Message_MBMS_message;  /* BCCH_BCH_MessageType_MBMS_r14 */
static int hf_lte_rrc_bCCH_DL_SCH_Message_message;  /* BCCH_DL_SCH_MessageType */
static int hf_lte_rrc_c1_07;                      /* T_c1_07 */
static int hf_lte_rrc_systemInformation;          /* SystemInformation */
static int hf_lte_rrc_systemInformationBlockType1;  /* SystemInformationBlockType1 */
static int hf_lte_rrc_messageClassExtension;      /* T_messageClassExtension */
static int hf_lte_rrc_bCCH_DL_SCH_Message_BR_message;  /* BCCH_DL_SCH_MessageType_BR_r13 */
static int hf_lte_rrc_c1_08;                      /* T_c1_08 */
static int hf_lte_rrc_systemInformation_BR_r13;   /* SystemInformation_BR_r13 */
static int hf_lte_rrc_systemInformationBlockType1_BR_r13;  /* SystemInformationBlockType1_BR_r13 */
static int hf_lte_rrc_messageClassExtension_01;   /* T_messageClassExtension_01 */
static int hf_lte_rrc_bCCH_DL_SCH_Message_MBMS_message;  /* BCCH_DL_SCH_MessageType_MBMS_r14 */
static int hf_lte_rrc_c1_09;                      /* T_c1_09 */
static int hf_lte_rrc_systemInformation_MBMS_r14;  /* SystemInformation_MBMS_r14 */
static int hf_lte_rrc_systemInformationBlockType1_MBMS_r14;  /* SystemInformationBlockType1_MBMS_r14 */
static int hf_lte_rrc_messageClassExtension_02;   /* T_messageClassExtension_02 */
static int hf_lte_rrc_mCCH_Message_message;       /* MCCH_MessageType */
static int hf_lte_rrc_c1_10;                      /* T_c1_10 */
static int hf_lte_rrc_mbsfnAreaConfiguration_r9;  /* MBSFNAreaConfiguration_r9 */
static int hf_lte_rrc_later;                      /* T_later */
static int hf_lte_rrc_c2;                         /* T_c2 */
static int hf_lte_rrc_mbmsCountingRequest_r10;    /* MBMSCountingRequest_r10 */
static int hf_lte_rrc_messageClassExtension_03;   /* T_messageClassExtension_03 */
static int hf_lte_rrc_pCCH_Message_message;       /* PCCH_MessageType */
static int hf_lte_rrc_c1_11;                      /* T_c1_11 */
static int hf_lte_rrc_paging;                     /* Paging */
static int hf_lte_rrc_messageClassExtension_04;   /* T_messageClassExtension_04 */
static int hf_lte_rrc_dL_CCCH_Message_message;    /* DL_CCCH_MessageType */
static int hf_lte_rrc_c1_12;                      /* T_c1_12 */
static int hf_lte_rrc_rrcConnectionReestablishment;  /* RRCConnectionReestablishment */
static int hf_lte_rrc_rrcConnectionReestablishmentReject;  /* RRCConnectionReestablishmentReject */
static int hf_lte_rrc_rrcConnectionReject;        /* RRCConnectionReject */
static int hf_lte_rrc_rrcConnectionSetup;         /* RRCConnectionSetup */
static int hf_lte_rrc_messageClassExtension_05;   /* T_messageClassExtension_05 */
static int hf_lte_rrc_c2_01;                      /* T_c2_01 */
static int hf_lte_rrc_rrcEarlyDataComplete_r15;   /* RRCEarlyDataComplete_r15 */
static int hf_lte_rrc_messageClassExtensionFuture_r15;  /* T_messageClassExtensionFuture_r15 */
static int hf_lte_rrc_dL_DCCH_Message_message;    /* DL_DCCH_MessageType */
static int hf_lte_rrc_c1_13;                      /* T_c1_13 */
static int hf_lte_rrc_csfbParametersResponseCDMA2000;  /* CSFBParametersResponseCDMA2000 */
static int hf_lte_rrc_dlInformationTransfer;      /* DLInformationTransfer */
static int hf_lte_rrc_handoverFromEUTRAPreparationRequest;  /* HandoverFromEUTRAPreparationRequest */
static int hf_lte_rrc_mobilityFromEUTRACommand;   /* MobilityFromEUTRACommand */
static int hf_lte_rrc_rrcConnectionReconfiguration;  /* RRCConnectionReconfiguration */
static int hf_lte_rrc_rrcConnectionRelease;       /* RRCConnectionRelease */
static int hf_lte_rrc_securityModeCommand;        /* SecurityModeCommand */
static int hf_lte_rrc_ueCapabilityEnquiry;        /* UECapabilityEnquiry */
static int hf_lte_rrc_counterCheck;               /* CounterCheck */
static int hf_lte_rrc_ueInformationRequest_r9;    /* UEInformationRequest_r9 */
static int hf_lte_rrc_loggedMeasurementConfiguration_r10;  /* LoggedMeasurementConfiguration_r10 */
static int hf_lte_rrc_rnReconfiguration_r10;      /* RNReconfiguration_r10 */
static int hf_lte_rrc_rrcConnectionResume_r13;    /* RRCConnectionResume_r13 */
static int hf_lte_rrc_dlDedicatedMessageSegment_r16;  /* DLDedicatedMessageSegment_r16 */
static int hf_lte_rrc_messageClassExtension_06;   /* T_messageClassExtension_06 */
static int hf_lte_rrc_uL_CCCH_Message_message;    /* UL_CCCH_MessageType */
static int hf_lte_rrc_c1_14;                      /* T_c1_14 */
static int hf_lte_rrc_rrcConnectionReestablishmentRequest;  /* RRCConnectionReestablishmentRequest */
static int hf_lte_rrc_rrcConnectionRequest;       /* RRCConnectionRequest */
static int hf_lte_rrc_messageClassExtension_07;   /* T_messageClassExtension_07 */
static int hf_lte_rrc_c2_02;                      /* T_c2_02 */
static int hf_lte_rrc_rrcConnectionResumeRequest_r13;  /* RRCConnectionResumeRequest_r13 */
static int hf_lte_rrc_messageClassExtensionFuture_r13;  /* T_messageClassExtensionFuture_r13 */
static int hf_lte_rrc_c3;                         /* T_c3 */
static int hf_lte_rrc_rrcEarlyDataRequest_r15;    /* RRCEarlyDataRequest_r15 */
static int hf_lte_rrc_messageClassExtensionFuture_r15_01;  /* T_messageClassExtensionFuture_r15_01 */
static int hf_lte_rrc_uL_DCCH_Message_message;    /* UL_DCCH_MessageType */
static int hf_lte_rrc_c1_15;                      /* T_c1_15 */
static int hf_lte_rrc_csfbParametersRequestCDMA2000;  /* CSFBParametersRequestCDMA2000 */
static int hf_lte_rrc_measurementReport;          /* MeasurementReport */
static int hf_lte_rrc_rrcConnectionReconfigurationComplete;  /* RRCConnectionReconfigurationComplete */
static int hf_lte_rrc_rrcConnectionReestablishmentComplete;  /* RRCConnectionReestablishmentComplete */
static int hf_lte_rrc_rrcConnectionSetupComplete;  /* RRCConnectionSetupComplete */
static int hf_lte_rrc_securityModeComplete;       /* SecurityModeComplete */
static int hf_lte_rrc_securityModeFailure;        /* SecurityModeFailure */
static int hf_lte_rrc_ueCapabilityInformation;    /* UECapabilityInformation */
static int hf_lte_rrc_ulHandoverPreparationTransfer;  /* ULHandoverPreparationTransfer */
static int hf_lte_rrc_ulInformationTransfer;      /* ULInformationTransfer */
static int hf_lte_rrc_counterCheckResponse;       /* CounterCheckResponse */
static int hf_lte_rrc_ueInformationResponse_r9;   /* UEInformationResponse_r9 */
static int hf_lte_rrc_proximityIndication_r9;     /* ProximityIndication_r9 */
static int hf_lte_rrc_rnReconfigurationComplete_r10;  /* RNReconfigurationComplete_r10 */
static int hf_lte_rrc_mbmsCountingResponse_r10;   /* MBMSCountingResponse_r10 */
static int hf_lte_rrc_interFreqRSTDMeasurementIndication_r10;  /* InterFreqRSTDMeasurementIndication_r10 */
static int hf_lte_rrc_messageClassExtension_08;   /* T_messageClassExtension_08 */
static int hf_lte_rrc_c2_03;                      /* T_c2_03 */
static int hf_lte_rrc_ueAssistanceInformation_r11_01;  /* UEAssistanceInformation_r11 */
static int hf_lte_rrc_inDeviceCoexIndication_r11;  /* InDeviceCoexIndication_r11 */
static int hf_lte_rrc_mbmsInterestIndication_r11_01;  /* MBMSInterestIndication_r11 */
static int hf_lte_rrc_scgFailureInformation_r12;  /* SCGFailureInformation_r12 */
static int hf_lte_rrc_sidelinkUEInformation_r12_01;  /* SidelinkUEInformation_r12 */
static int hf_lte_rrc_wlanConnectionStatusReport_r13_01;  /* WLANConnectionStatusReport_r13 */
static int hf_lte_rrc_rrcConnectionResumeComplete_r13;  /* RRCConnectionResumeComplete_r13 */
static int hf_lte_rrc_ulInformationTransferMRDC_r15;  /* ULInformationTransferMRDC_r15 */
static int hf_lte_rrc_scgFailureInformationNR_r15;  /* SCGFailureInformationNR_r15 */
static int hf_lte_rrc_measReportAppLayer_r15;     /* MeasReportAppLayer_r15 */
static int hf_lte_rrc_failureInformation_r15;     /* FailureInformation_r15 */
static int hf_lte_rrc_ulDedicatedMessageSegment_r16;  /* ULDedicatedMessageSegment_r16 */
static int hf_lte_rrc_purConfigurationRequest_r16;  /* PURConfigurationRequest_r16 */
static int hf_lte_rrc_failureInformation_r16;     /* FailureInformation_r16 */
static int hf_lte_rrc_mcgFailureInformation_r16;  /* MCGFailureInformation_r16 */
static int hf_lte_rrc_ulInformationTransferIRAT_r16;  /* ULInformationTransferIRAT_r16 */
static int hf_lte_rrc_messageClassExtensionFuture_r11;  /* T_messageClassExtensionFuture_r11 */
static int hf_lte_rrc_sC_MCCH_Message_r13_message;  /* SC_MCCH_MessageType_r13 */
static int hf_lte_rrc_c1_16;                      /* T_c1_16 */
static int hf_lte_rrc_scptmConfiguration_r13;     /* SCPTMConfiguration_r13 */
static int hf_lte_rrc_messageClassExtension_09;   /* T_messageClassExtension_09 */
static int hf_lte_rrc_c2_04;                      /* T_c2_04 */
static int hf_lte_rrc_scptmConfiguration_BR_r14;  /* SCPTMConfiguration_BR_r14 */
static int hf_lte_rrc_spare;                      /* NULL */
static int hf_lte_rrc_messageClassExtensionFuture_r14;  /* T_messageClassExtensionFuture_r14 */
static int hf_lte_rrc_rrc_TransactionIdentifier;  /* RRC_TransactionIdentifier */
static int hf_lte_rrc_criticalExtensions_07;      /* T_criticalExtensions_07 */
static int hf_lte_rrc_c1_17;                      /* T_c1_17 */
static int hf_lte_rrc_counterCheck_r8;            /* CounterCheck_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_07;  /* T_criticalExtensionsFuture_07 */
static int hf_lte_rrc_drb_CountMSB_InfoList;      /* DRB_CountMSB_InfoList */
static int hf_lte_rrc_nonCriticalExtension_33;    /* CounterCheck_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_34;    /* CounterCheck_v1530_IEs */
static int hf_lte_rrc_drb_CountMSB_InfoListExt_r15;  /* DRB_CountMSB_InfoListExt_r15 */
static int hf_lte_rrc_nonCriticalExtension_35;    /* T_nonCriticalExtension_09 */
static int hf_lte_rrc_DRB_CountMSB_InfoList_item;  /* DRB_CountMSB_Info */
static int hf_lte_rrc_DRB_CountMSB_InfoListExt_r15_item;  /* DRB_CountMSB_Info */
static int hf_lte_rrc_drb_Identity;               /* DRB_Identity */
static int hf_lte_rrc_countMSB_Uplink;            /* INTEGER_0_33554431 */
static int hf_lte_rrc_countMSB_Downlink;          /* INTEGER_0_33554431 */
static int hf_lte_rrc_criticalExtensions_08;      /* T_criticalExtensions_08 */
static int hf_lte_rrc_counterCheckResponse_r8;    /* CounterCheckResponse_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_08;  /* T_criticalExtensionsFuture_08 */
static int hf_lte_rrc_drb_CountInfoList;          /* DRB_CountInfoList */
static int hf_lte_rrc_nonCriticalExtension_36;    /* CounterCheckResponse_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_37;    /* CounterCheckResponse_v1530_IEs */
static int hf_lte_rrc_drb_CountInfoListExt_r15;   /* DRB_CountInfoListExt_r15 */
static int hf_lte_rrc_nonCriticalExtension_38;    /* T_nonCriticalExtension_10 */
static int hf_lte_rrc_DRB_CountInfoList_item;     /* DRB_CountInfo */
static int hf_lte_rrc_DRB_CountInfoListExt_r15_item;  /* DRB_CountInfo */
static int hf_lte_rrc_count_Uplink;               /* INTEGER_0_4294967295 */
static int hf_lte_rrc_count_Downlink;             /* INTEGER_0_4294967295 */
static int hf_lte_rrc_criticalExtensions_09;      /* T_criticalExtensions_09 */
static int hf_lte_rrc_csfbParametersRequestCDMA2000_r8;  /* CSFBParametersRequestCDMA2000_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_09;  /* T_criticalExtensionsFuture_09 */
static int hf_lte_rrc_nonCriticalExtension_39;    /* CSFBParametersRequestCDMA2000_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_40;    /* T_nonCriticalExtension_11 */
static int hf_lte_rrc_criticalExtensions_10;      /* T_criticalExtensions_10 */
static int hf_lte_rrc_csfbParametersResponseCDMA2000_r8;  /* CSFBParametersResponseCDMA2000_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_10;  /* T_criticalExtensionsFuture_10 */
static int hf_lte_rrc_rand;                       /* RAND_CDMA2000 */
static int hf_lte_rrc_mobilityParameters;         /* MobilityParametersCDMA2000 */
static int hf_lte_rrc_nonCriticalExtension_41;    /* CSFBParametersResponseCDMA2000_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_42;    /* T_nonCriticalExtension_12 */
static int hf_lte_rrc_criticalExtensions_11;      /* T_criticalExtensions_11 */
static int hf_lte_rrc_dlDedicatedMessageSegment_r16_01;  /* DLDedicatedMessageSegment_r16_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_11;  /* T_criticalExtensionsFuture_11 */
static int hf_lte_rrc_segmentNumber_r16;          /* T_segmentNumber_r16 */
static int hf_lte_rrc_rrc_MessageSegmentContainer_r16;  /* T_rrc_MessageSegmentContainer_r16 */
static int hf_lte_rrc_rrc_MessageSegmentType_r16;  /* T_rrc_MessageSegmentType_r16 */
static int hf_lte_rrc_nonCriticalExtension_43;    /* T_nonCriticalExtension_13 */
static int hf_lte_rrc_criticalExtensions_12;      /* T_criticalExtensions_12 */
static int hf_lte_rrc_c1_18;                      /* T_c1_18 */
static int hf_lte_rrc_dlInformationTransfer_r8;   /* DLInformationTransfer_r8_IEs */
static int hf_lte_rrc_dlInformationTransfer_r15;  /* DLInformationTransfer_r15_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_12;  /* T_criticalExtensionsFuture_12 */
static int hf_lte_rrc_dedicatedInfoType;          /* T_dedicatedInfoType */
static int hf_lte_rrc_dedicatedInfoNAS;           /* DedicatedInfoNAS */
static int hf_lte_rrc_dedicatedInfoCDMA2000_1XRTT;  /* DedicatedInfoCDMA2000 */
static int hf_lte_rrc_dedicatedInfoCDMA2000_HRPD;  /* DedicatedInfoCDMA2000 */
static int hf_lte_rrc_nonCriticalExtension_44;    /* DLInformationTransfer_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_45;    /* DLInformationTransfer_v1610_IEs */
static int hf_lte_rrc_dedicatedInfoType_r15;      /* T_dedicatedInfoType_r15 */
static int hf_lte_rrc_timeReferenceInfo_r15;      /* TimeReferenceInfo_r15 */
static int hf_lte_rrc_dedicatedInfoF1c_r16;       /* DedicatedInfoF1c_r16 */
static int hf_lte_rrc_nonCriticalExtension_46;    /* T_nonCriticalExtension_14 */
static int hf_lte_rrc_failedLogicalChannelInfo_r15;  /* FailedLogicalChannelInfo_r15 */
static int hf_lte_rrc_criticalExtensions_13;      /* T_criticalExtensions_13 */
static int hf_lte_rrc_failureInformation_r16_01;  /* FailureInformation_r16_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_13;  /* T_criticalExtensionsFuture_13 */
static int hf_lte_rrc_failedLogicalChannelIdentity_r15;  /* T_failedLogicalChannelIdentity_r15 */
static int hf_lte_rrc_cellGroupIndication_r15;    /* T_cellGroupIndication_r15 */
static int hf_lte_rrc_logicalChannelIdentity_r15;  /* INTEGER_1_10 */
static int hf_lte_rrc_logicalChannelIdentityExt_r15;  /* INTEGER_32_38 */
static int hf_lte_rrc_failureType;                /* T_failureType */
static int hf_lte_rrc_failedLogicalChannelIdentity_r16;  /* FailedLogicalChannelIdentity_r16 */
static int hf_lte_rrc_failureType_r16;            /* T_failureType_r16 */
static int hf_lte_rrc_nonCriticalExtension_47;    /* T_nonCriticalExtension_15 */
static int hf_lte_rrc_cellGroupIndication_r16;    /* T_cellGroupIndication_r16 */
static int hf_lte_rrc_logicalChannelIdentity_r16;  /* INTEGER_1_10 */
static int hf_lte_rrc_logicalChannelIdentityExt_r16;  /* INTEGER_32_38 */
static int hf_lte_rrc_criticalExtensions_14;      /* T_criticalExtensions_14 */
static int hf_lte_rrc_c1_19;                      /* T_c1_19 */
static int hf_lte_rrc_handoverFromEUTRAPreparationRequest_r8;  /* HandoverFromEUTRAPreparationRequest_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_14;  /* T_criticalExtensionsFuture_14 */
static int hf_lte_rrc_cdma2000_Type;              /* CDMA2000_Type */
static int hf_lte_rrc_nonCriticalExtension_48;    /* HandoverFromEUTRAPreparationRequest_v890_IEs */
static int hf_lte_rrc_nonCriticalExtension_49;    /* HandoverFromEUTRAPreparationRequest_v920_IEs */
static int hf_lte_rrc_concurrPrepCDMA2000_HRPD_r9;  /* BOOLEAN */
static int hf_lte_rrc_nonCriticalExtension_50;    /* HandoverFromEUTRAPreparationRequest_v1020_IEs */
static int hf_lte_rrc_dualRxTxRedirectIndicator_r10;  /* T_dualRxTxRedirectIndicator_r10 */
static int hf_lte_rrc_redirectCarrierCDMA2000_1XRTT_r10;  /* CarrierFreqCDMA2000 */
static int hf_lte_rrc_nonCriticalExtension_51;    /* T_nonCriticalExtension_16 */
static int hf_lte_rrc_criticalExtensions_15;      /* T_criticalExtensions_15 */
static int hf_lte_rrc_c1_20;                      /* T_c1_20 */
static int hf_lte_rrc_inDeviceCoexIndication_r11_01;  /* InDeviceCoexIndication_r11_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_15;  /* T_criticalExtensionsFuture_15 */
static int hf_lte_rrc_affectedCarrierFreqList_r11;  /* AffectedCarrierFreqList_r11 */
static int hf_lte_rrc_tdm_AssistanceInfo_r11;     /* TDM_AssistanceInfo_r11 */
static int hf_lte_rrc_nonCriticalExtension_52;    /* InDeviceCoexIndication_v11d0_IEs */
static int hf_lte_rrc_ul_CA_AssistanceInfo_r11;   /* T_ul_CA_AssistanceInfo_r11 */
static int hf_lte_rrc_affectedCarrierFreqCombList_r11;  /* AffectedCarrierFreqCombList_r11 */
static int hf_lte_rrc_victimSystemType_r11;       /* VictimSystemType_r11 */
static int hf_lte_rrc_nonCriticalExtension_53;    /* InDeviceCoexIndication_v1310_IEs */
static int hf_lte_rrc_affectedCarrierFreqList_v1310;  /* AffectedCarrierFreqList_v1310 */
static int hf_lte_rrc_affectedCarrierFreqCombList_r13;  /* AffectedCarrierFreqCombList_r13 */
static int hf_lte_rrc_nonCriticalExtension_54;    /* InDeviceCoexIndication_v1360_IEs */
static int hf_lte_rrc_hardwareSharingProblem_r13;  /* T_hardwareSharingProblem_r13 */
static int hf_lte_rrc_nonCriticalExtension_55;    /* InDeviceCoexIndication_v1530_IEs */
static int hf_lte_rrc_mrdc_AssistanceInfo_r15;    /* MRDC_AssistanceInfo_r15 */
static int hf_lte_rrc_nonCriticalExtension_56;    /* InDeviceCoexIndication_v1610_IEs */
static int hf_lte_rrc_victimSystemType_v1610;     /* VictimSystemType_v1610 */
static int hf_lte_rrc_nonCriticalExtension_57;    /* T_nonCriticalExtension_17 */
static int hf_lte_rrc_AffectedCarrierFreqList_r11_item;  /* AffectedCarrierFreq_r11 */
static int hf_lte_rrc_AffectedCarrierFreqList_v1310_item;  /* AffectedCarrierFreq_v1310 */
static int hf_lte_rrc_carrierFreq_r11;            /* MeasObjectId */
static int hf_lte_rrc_interferenceDirection_r11;  /* T_interferenceDirection_r11 */
static int hf_lte_rrc_carrierFreq_v1310;          /* MeasObjectId_v1310 */
static int hf_lte_rrc_AffectedCarrierFreqCombList_r11_item;  /* AffectedCarrierFreqComb_r11 */
static int hf_lte_rrc_AffectedCarrierFreqCombList_r13_item;  /* AffectedCarrierFreqComb_r13 */
static int hf_lte_rrc_AffectedCarrierFreqComb_r11_item;  /* MeasObjectId */
static int hf_lte_rrc_AffectedCarrierFreqComb_r13_item;  /* MeasObjectId_r13 */
static int hf_lte_rrc_drx_AssistanceInfo_r11;     /* T_drx_AssistanceInfo_r11 */
static int hf_lte_rrc_drx_CycleLength_r11;        /* T_drx_CycleLength_r11 */
static int hf_lte_rrc_drx_Offset_r11;             /* INTEGER_0_255 */
static int hf_lte_rrc_drx_ActiveTime_r11;         /* T_drx_ActiveTime_r11 */
static int hf_lte_rrc_idc_SubframePatternList_r11;  /* IDC_SubframePatternList_r11 */
static int hf_lte_rrc_IDC_SubframePatternList_r11_item;  /* IDC_SubframePattern_r11 */
static int hf_lte_rrc_subframePatternFDD_r11;     /* BIT_STRING_SIZE_4 */
static int hf_lte_rrc_subframePatternTDD_r11;     /* T_subframePatternTDD_r11 */
static int hf_lte_rrc_subframeConfig0_r11;        /* BIT_STRING_SIZE_70 */
static int hf_lte_rrc_subframeConfig1_5_r11;      /* BIT_STRING_SIZE_10 */
static int hf_lte_rrc_subframeConfig6_r11;        /* BIT_STRING_SIZE_60 */
static int hf_lte_rrc_gps_r11;                    /* T_gps_r11 */
static int hf_lte_rrc_glonass_r11;                /* T_glonass_r11 */
static int hf_lte_rrc_bds_r11;                    /* T_bds_r11 */
static int hf_lte_rrc_galileo_r11;                /* T_galileo_r11 */
static int hf_lte_rrc_wlan_r11;                   /* T_wlan_r11 */
static int hf_lte_rrc_bluetooth_r11;              /* T_bluetooth_r11 */
static int hf_lte_rrc_navic_r16;                  /* T_navic_r16 */
static int hf_lte_rrc_affectedCarrierFreqCombInfoListMRDC_r15;  /* SEQUENCE_SIZE_1_maxCombIDC_r11_OF_AffectedCarrierFreqCombInfoMRDC_r15 */
static int hf_lte_rrc_affectedCarrierFreqCombInfoListMRDC_r15_item;  /* AffectedCarrierFreqCombInfoMRDC_r15 */
static int hf_lte_rrc_affectedCarrierFreqCombInfoListMRDC_v1610;  /* SEQUENCE_SIZE_1_maxCombIDC_r11_OF_VictimSystemType_v1610 */
static int hf_lte_rrc_affectedCarrierFreqCombInfoListMRDC_v1610_item;  /* VictimSystemType_v1610 */
static int hf_lte_rrc_victimSystemType_r15;       /* VictimSystemType_r11 */
static int hf_lte_rrc_interferenceDirectionMRDC_r15;  /* T_interferenceDirectionMRDC_r15 */
static int hf_lte_rrc_affectedCarrierFreqCombMRDC_r15;  /* T_affectedCarrierFreqCombMRDC_r15 */
static int hf_lte_rrc_affectedCarrierFreqCombEUTRA_r15;  /* AffectedCarrierFreqComb_r15 */
static int hf_lte_rrc_affectedCarrierFreqCombNR_r15;  /* AffectedCarrierFreqCombNR_r15 */
static int hf_lte_rrc_AffectedCarrierFreqComb_r15_item;  /* MeasObjectId_r13 */
static int hf_lte_rrc_AffectedCarrierFreqCombNR_r15_item;  /* ARFCN_ValueNR_r15 */
static int hf_lte_rrc_criticalExtensions_16;      /* T_criticalExtensions_16 */
static int hf_lte_rrc_c1_21;                      /* T_c1_21 */
static int hf_lte_rrc_interFreqRSTDMeasurementIndication_r10_01;  /* InterFreqRSTDMeasurementIndication_r10_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_16;  /* T_criticalExtensionsFuture_16 */
static int hf_lte_rrc_rstd_InterFreqIndication_r10;  /* T_rstd_InterFreqIndication_r10 */
static int hf_lte_rrc_start;                      /* T_start */
static int hf_lte_rrc_rstd_InterFreqInfoList_r10;  /* RSTD_InterFreqInfoList_r10 */
static int hf_lte_rrc_stop;                       /* NULL */
static int hf_lte_rrc_nonCriticalExtension_58;    /* T_nonCriticalExtension_18 */
static int hf_lte_rrc_RSTD_InterFreqInfoList_r10_item;  /* RSTD_InterFreqInfo_r10 */
static int hf_lte_rrc_carrierFreq_r10;            /* ARFCN_ValueEUTRA */
static int hf_lte_rrc_measPRS_Offset_r10;         /* INTEGER_0_39 */
static int hf_lte_rrc_carrierFreq_v1090;          /* ARFCN_ValueEUTRA_v9e0 */
static int hf_lte_rrc_measPRS_Offset_r15;         /* T_measPRS_Offset_r15 */
static int hf_lte_rrc_rstd0_r15;                  /* INTEGER_0_79 */
static int hf_lte_rrc_rstd1_r15;                  /* INTEGER_0_159 */
static int hf_lte_rrc_rstd2_r15;                  /* INTEGER_0_319 */
static int hf_lte_rrc_rstd3_r15;                  /* INTEGER_0_639 */
static int hf_lte_rrc_rstd4_r15;                  /* INTEGER_0_1279 */
static int hf_lte_rrc_rstd5_r15;                  /* INTEGER_0_159 */
static int hf_lte_rrc_rstd6_r15;                  /* INTEGER_0_319 */
static int hf_lte_rrc_rstd7_r15;                  /* INTEGER_0_639 */
static int hf_lte_rrc_rstd8_r15;                  /* INTEGER_0_1279 */
static int hf_lte_rrc_rstd9_r15;                  /* INTEGER_0_319 */
static int hf_lte_rrc_rstd10_r15;                 /* INTEGER_0_639 */
static int hf_lte_rrc_rstd11_r15;                 /* INTEGER_0_1279 */
static int hf_lte_rrc_rstd12_r15;                 /* INTEGER_0_319 */
static int hf_lte_rrc_rstd13_r15;                 /* INTEGER_0_639 */
static int hf_lte_rrc_rstd14_r15;                 /* INTEGER_0_1279 */
static int hf_lte_rrc_rstd15_r15;                 /* INTEGER_0_639 */
static int hf_lte_rrc_rstd16_r15;                 /* INTEGER_0_1279 */
static int hf_lte_rrc_rstd17_r15;                 /* INTEGER_0_639 */
static int hf_lte_rrc_rstd18_r15;                 /* INTEGER_0_1279 */
static int hf_lte_rrc_rstd19_r15;                 /* INTEGER_0_639 */
static int hf_lte_rrc_rstd20_r15;                 /* INTEGER_0_1279 */
static int hf_lte_rrc_criticalExtensions_17;      /* T_criticalExtensions_17 */
static int hf_lte_rrc_c1_22;                      /* T_c1_22 */
static int hf_lte_rrc_loggedMeasurementConfiguration_r10_01;  /* LoggedMeasurementConfiguration_r10_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_17;  /* T_criticalExtensionsFuture_17 */
static int hf_lte_rrc_traceReference_r10;         /* TraceReference_r10 */
static int hf_lte_rrc_traceRecordingSessionRef_r10;  /* OCTET_STRING_SIZE_2 */
static int hf_lte_rrc_tce_Id_r10;                 /* OCTET_STRING_SIZE_1 */
static int hf_lte_rrc_absoluteTimeInfo_r10;       /* AbsoluteTimeInfo_r10 */
static int hf_lte_rrc_areaConfiguration_r10;      /* AreaConfiguration_r10 */
static int hf_lte_rrc_loggingDuration_r10;        /* LoggingDuration_r10 */
static int hf_lte_rrc_loggingInterval_r10;        /* LoggingInterval_r10 */
static int hf_lte_rrc_nonCriticalExtension_59;    /* LoggedMeasurementConfiguration_v1080_IEs */
static int hf_lte_rrc_lateNonCriticalExtension_r10;  /* OCTET_STRING */
static int hf_lte_rrc_nonCriticalExtension_60;    /* LoggedMeasurementConfiguration_v1130_IEs */
static int hf_lte_rrc_plmn_IdentityList_r11;      /* PLMN_IdentityList3_r11 */
static int hf_lte_rrc_areaConfiguration_v1130;    /* AreaConfiguration_v1130 */
static int hf_lte_rrc_nonCriticalExtension_61;    /* LoggedMeasurementConfiguration_v1250_IEs */
static int hf_lte_rrc_targetMBSFN_AreaList_r12;   /* TargetMBSFN_AreaList_r12 */
static int hf_lte_rrc_nonCriticalExtension_62;    /* LoggedMeasurementConfiguration_v1530_IEs */
static int hf_lte_rrc_bt_NameList_r15;            /* BT_NameList_r15 */
static int hf_lte_rrc_wlan_NameList_r15;          /* WLAN_NameList_r15 */
static int hf_lte_rrc_nonCriticalExtension_63;    /* LoggedMeasurementConfiguration_v1700_IEs */
static int hf_lte_rrc_loggedEventTriggerConfig_r17;  /* LoggedEventTriggerConfig_r17 */
static int hf_lte_rrc_measUncomBarPre_r17;        /* T_measUncomBarPre_r17 */
static int hf_lte_rrc_nonCriticalExtension_64;    /* LoggedMeasurementConfiguration_v1800_IEs */
static int hf_lte_rrc_sigLoggedMeasType_r18;      /* T_sigLoggedMeasType_r18 */
static int hf_lte_rrc_nonCriticalExtension_65;    /* T_nonCriticalExtension_19 */
static int hf_lte_rrc_TargetMBSFN_AreaList_r12_item;  /* TargetMBSFN_Area_r12 */
static int hf_lte_rrc_mbsfn_AreaId_r12;           /* MBSFN_AreaId_r12 */
static int hf_lte_rrc_carrierFreq_r12;            /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_eventType_r17;              /* EventType_r17 */
static int hf_lte_rrc_outOfCoverage;              /* NULL */
static int hf_lte_rrc_eventL1;                    /* T_eventL1 */
static int hf_lte_rrc_l1_Threshold_r17;           /* ThresholdEUTRA */
static int hf_lte_rrc_hysteresis_r17;             /* Hysteresis */
static int hf_lte_rrc_timeToTrigger_r17;          /* TimeToTrigger */
static int hf_lte_rrc_dl_Bandwidth;               /* T_dl_Bandwidth */
static int hf_lte_rrc_phich_Config;               /* PHICH_Config */
static int hf_lte_rrc_systemFrameNumber;          /* T_systemFrameNumber */
static int hf_lte_rrc_schedulingInfoSIB1_BR_r13;  /* INTEGER_0_31 */
static int hf_lte_rrc_systemInfoUnchanged_BR_r15;  /* BOOLEAN */
static int hf_lte_rrc_partEARFCN_r17;             /* T_partEARFCN_r17 */
static int hf_lte_rrc_spare_01;                   /* BIT_STRING_SIZE_2 */
static int hf_lte_rrc_earfcn_LSB;                 /* BIT_STRING_SIZE_2 */
static int hf_lte_rrc_spare_02;                   /* BIT_STRING_SIZE_1 */
static int hf_lte_rrc_dl_Bandwidth_MBMS_r14;      /* T_dl_Bandwidth_MBMS_r14 */
static int hf_lte_rrc_systemFrameNumber_r14;      /* BIT_STRING_SIZE_6 */
static int hf_lte_rrc_additionalNonMBSFNSubframes_r14;  /* INTEGER_0_3 */
static int hf_lte_rrc_semiStaticCFI_MBMS_r16;     /* INTEGER_0_3 */
static int hf_lte_rrc_spare_03;                   /* BIT_STRING_SIZE_11 */
static int hf_lte_rrc_countingRequestList_r10;    /* CountingRequestList_r10 */
static int hf_lte_rrc_nonCriticalExtension_66;    /* T_nonCriticalExtension_20 */
static int hf_lte_rrc_CountingRequestList_r10_item;  /* CountingRequestInfo_r10 */
static int hf_lte_rrc_tmgi_r10;                   /* TMGI_r9 */
static int hf_lte_rrc_criticalExtensions_18;      /* T_criticalExtensions_18 */
static int hf_lte_rrc_c1_23;                      /* T_c1_23 */
static int hf_lte_rrc_countingResponse_r10;       /* MBMSCountingResponse_r10_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_18;  /* T_criticalExtensionsFuture_18 */
static int hf_lte_rrc_mbsfn_AreaIndex_r10;        /* INTEGER_0_maxMBSFN_Area_1 */
static int hf_lte_rrc_countingResponseList_r10;   /* CountingResponseList_r10 */
static int hf_lte_rrc_nonCriticalExtension_67;    /* T_nonCriticalExtension_21 */
static int hf_lte_rrc_CountingResponseList_r10_item;  /* CountingResponseInfo_r10 */
static int hf_lte_rrc_countingResponseService_r10;  /* INTEGER_0_maxServiceCount_1 */
static int hf_lte_rrc_criticalExtensions_19;      /* T_criticalExtensions_19 */
static int hf_lte_rrc_c1_24;                      /* T_c1_24 */
static int hf_lte_rrc_interestIndication_r11;     /* MBMSInterestIndication_r11_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_19;  /* T_criticalExtensionsFuture_19 */
static int hf_lte_rrc_mbms_FreqList_r11;          /* CarrierFreqListMBMS_r11 */
static int hf_lte_rrc_mbms_Priority_r11;          /* T_mbms_Priority_r11 */
static int hf_lte_rrc_nonCriticalExtension_68;    /* MBMSInterestIndication_v1310_IEs */
static int hf_lte_rrc_mbms_Services_r13;          /* MBMS_ServiceList_r13 */
static int hf_lte_rrc_nonCriticalExtension_69;    /* MBMSInterestIndication_v1540_IEs */
static int hf_lte_rrc_mbms_ROM_InfoList_r15;      /* SEQUENCE_SIZE_1_maxMBMS_ServiceListPerUE_r13_OF_MBMS_ROM_Info_r15 */
static int hf_lte_rrc_mbms_ROM_InfoList_r15_item;  /* MBMS_ROM_Info_r15 */
static int hf_lte_rrc_nonCriticalExtension_70;    /* MBMSInterestIndication_v1610_IEs */
static int hf_lte_rrc_mbms_ROM_InfoList_r16;      /* SEQUENCE_SIZE_1_maxMBMS_ServiceListPerUE_r13_OF_MBMS_ROM_Info_r16 */
static int hf_lte_rrc_mbms_ROM_InfoList_r16_item;  /* MBMS_ROM_Info_r16 */
static int hf_lte_rrc_nonCriticalExtension_71;    /* T_nonCriticalExtension_22 */
static int hf_lte_rrc_mbms_ROM_Freq_r15;          /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_mbms_ROM_SubcarrierSpacing_r15;  /* T_mbms_ROM_SubcarrierSpacing_r15 */
static int hf_lte_rrc_mbms_Bandwidth_r15;         /* T_mbms_Bandwidth_r15 */
static int hf_lte_rrc_mbms_ROM_Freq_r16;          /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_mbms_ROM_SubcarrierSpacing_r16;  /* T_mbms_ROM_SubcarrierSpacing_r16 */
static int hf_lte_rrc_mbms_Bandwidth_r16;         /* T_mbms_Bandwidth_r16 */
static int hf_lte_rrc_commonSF_Alloc_r9;          /* CommonSF_AllocPatternList_r9 */
static int hf_lte_rrc_commonSF_AllocPeriod_r9;    /* T_commonSF_AllocPeriod_r9 */
static int hf_lte_rrc_pmch_InfoList_r9;           /* PMCH_InfoList_r9 */
static int hf_lte_rrc_nonCriticalExtension_72;    /* MBSFNAreaConfiguration_v930_IEs */
static int hf_lte_rrc_nonCriticalExtension_73;    /* MBSFNAreaConfiguration_v1250_IEs */
static int hf_lte_rrc_pmch_InfoListExt_r12;       /* PMCH_InfoListExt_r12 */
static int hf_lte_rrc_nonCriticalExtension_74;    /* MBSFNAreaConfiguration_v1430_IEs */
static int hf_lte_rrc_commonSF_Alloc_v1430;       /* CommonSF_AllocPatternList_v1430 */
static int hf_lte_rrc_nonCriticalExtension_75;    /* MBSFNAreaConfiguration_v1610_IEs */
static int hf_lte_rrc_commonSF_Alloc_v1610;       /* CommonSF_AllocPatternList_v1610 */
static int hf_lte_rrc_nonCriticalExtension_76;    /* T_nonCriticalExtension_23 */
static int hf_lte_rrc_CommonSF_AllocPatternList_r9_item;  /* MBSFN_SubframeConfig */
static int hf_lte_rrc_CommonSF_AllocPatternList_v1430_item;  /* MBSFN_SubframeConfig_v1430 */
static int hf_lte_rrc_CommonSF_AllocPatternList_v1610_item;  /* MBSFN_SubframeConfig_v1610 */
static int hf_lte_rrc_criticalExtensions_20;      /* T_criticalExtensions_20 */
static int hf_lte_rrc_mcgFailureInformation;      /* MCGFailureInformation_r16_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_20;  /* T_criticalExtensionsFuture_20 */
static int hf_lte_rrc_failureReportMCG_r16;       /* FailureReportMCG_r16 */
static int hf_lte_rrc_nonCriticalExtension_77;    /* T_nonCriticalExtension_24 */
static int hf_lte_rrc_failureType_r16_01;         /* T_failureType_r16_01 */
static int hf_lte_rrc_measResultFreqListEUTRA_r16;  /* MeasResultList3EUTRA_r15 */
static int hf_lte_rrc_measResultFreqListNR_r16;   /* MeasResultFreqListFailNR_r15 */
static int hf_lte_rrc_measResultFreqListGERAN_r16;  /* MeasResultList2GERAN_r10 */
static int hf_lte_rrc_measResultFreqListUTRA_r16;  /* MeasResultList2UTRA_r9 */
static int hf_lte_rrc_measResultSCG_r16;          /* T_measResultSCG_r16 */
static int hf_lte_rrc_criticalExtensions_21;      /* T_criticalExtensions_21 */
static int hf_lte_rrc_measReportAppLayer_r15_01;  /* MeasReportAppLayer_r15_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_21;  /* T_criticalExtensionsFuture_21 */
static int hf_lte_rrc_measReportAppLayerContainer_r15;  /* OCTET_STRING_SIZE_1_8000 */
static int hf_lte_rrc_serviceType_r15;            /* T_serviceType_r15 */
static int hf_lte_rrc_nonCriticalExtension_78;    /* MeasReportAppLayer_v1590_IEs */
static int hf_lte_rrc_nonCriticalExtension_79;    /* T_nonCriticalExtension_25 */
static int hf_lte_rrc_criticalExtensions_22;      /* T_criticalExtensions_22 */
static int hf_lte_rrc_c1_25;                      /* T_c1_25 */
static int hf_lte_rrc_measurementReport_r8;       /* MeasurementReport_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_22;  /* T_criticalExtensionsFuture_22 */
static int hf_lte_rrc_measResults;                /* MeasResults */
static int hf_lte_rrc_nonCriticalExtension_80;    /* MeasurementReport_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_81;    /* T_nonCriticalExtension_26 */
static int hf_lte_rrc_criticalExtensions_23;      /* T_criticalExtensions_23 */
static int hf_lte_rrc_c1_26;                      /* T_c1_26 */
static int hf_lte_rrc_mobilityFromEUTRACommand_r8;  /* MobilityFromEUTRACommand_r8_IEs */
static int hf_lte_rrc_mobilityFromEUTRACommand_r9;  /* MobilityFromEUTRACommand_r9_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_23;  /* T_criticalExtensionsFuture_23 */
static int hf_lte_rrc_cs_FallbackIndicator;       /* BOOLEAN */
static int hf_lte_rrc_purpose;                    /* T_purpose */
static int hf_lte_rrc_handover;                   /* Handover */
static int hf_lte_rrc_cellChangeOrder;            /* CellChangeOrder */
static int hf_lte_rrc_nonCriticalExtension_82;    /* MobilityFromEUTRACommand_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_83;    /* MobilityFromEUTRACommand_v8d0_IEs */
static int hf_lte_rrc_bandIndicator;              /* BandIndicatorGERAN */
static int hf_lte_rrc_nonCriticalExtension_84;    /* T_nonCriticalExtension_27 */
static int hf_lte_rrc_purpose_01;                 /* T_purpose_01 */
static int hf_lte_rrc_e_CSFB_r9;                  /* E_CSFB_r9 */
static int hf_lte_rrc_nonCriticalExtension_85;    /* MobilityFromEUTRACommand_v930_IEs */
static int hf_lte_rrc_nonCriticalExtension_86;    /* MobilityFromEUTRACommand_v960_IEs */
static int hf_lte_rrc_nonCriticalExtension_87;    /* MobilityFromEUTRACommand_v1530_IEs */
static int hf_lte_rrc_smtc_r15;                   /* MTC_SSB_NR_r15 */
static int hf_lte_rrc_nonCriticalExtension_88;    /* T_nonCriticalExtension_28 */
static int hf_lte_rrc_targetRAT_Type;             /* T_targetRAT_Type */
static int hf_lte_rrc_targetRAT_MessageContainer;  /* T_targetRAT_MessageContainer */
static int hf_lte_rrc_nas_SecurityParamFromEUTRA;  /* T_nas_SecurityParamFromEUTRA */
static int hf_lte_rrc_systemInformation_01;       /* SI_OrPSI_GERAN */
static int hf_lte_rrc_t304;                       /* T_t304 */
static int hf_lte_rrc_targetRAT_Type_01;          /* T_targetRAT_Type_01 */
static int hf_lte_rrc_geran;                      /* T_geran */
static int hf_lte_rrc_physCellId;                 /* PhysCellIdGERAN */
static int hf_lte_rrc_carrierFreq;                /* CarrierFreqGERAN */
static int hf_lte_rrc_networkControlOrder;        /* BIT_STRING_SIZE_2 */
static int hf_lte_rrc_si;                         /* T_si */
static int hf_lte_rrc_psi;                        /* T_psi */
static int hf_lte_rrc_messageContCDMA2000_1XRTT_r9;  /* OCTET_STRING */
static int hf_lte_rrc_mobilityCDMA2000_HRPD_r9;   /* T_mobilityCDMA2000_HRPD_r9 */
static int hf_lte_rrc_messageContCDMA2000_HRPD_r9;  /* OCTET_STRING */
static int hf_lte_rrc_redirectCarrierCDMA2000_HRPD_r9;  /* CarrierFreqCDMA2000 */
static int hf_lte_rrc_pagingRecordList;           /* T_pagingRecordList */
static int hf_lte_rrc_systemInfoModification;     /* T_systemInfoModification */
static int hf_lte_rrc_etws_Indication;            /* T_etws_Indication */
static int hf_lte_rrc_nonCriticalExtension_89;    /* Paging_v890_IEs */
static int hf_lte_rrc_nonCriticalExtension_90;    /* Paging_v920_IEs */
static int hf_lte_rrc_cmas_Indication_r9;         /* T_cmas_Indication_r9 */
static int hf_lte_rrc_nonCriticalExtension_91;    /* Paging_v1130_IEs */
static int hf_lte_rrc_eab_ParamModification_r11;  /* T_eab_ParamModification_r11 */
static int hf_lte_rrc_nonCriticalExtension_92;    /* Paging_v1310_IEs */
static int hf_lte_rrc_redistributionIndication_r13;  /* T_redistributionIndication_r13 */
static int hf_lte_rrc_systemInfoModification_eDRX_r13;  /* T_systemInfoModification_eDRX_r13 */
static int hf_lte_rrc_nonCriticalExtension_93;    /* Paging_v1530_IEs */
static int hf_lte_rrc_accessType;                 /* T_accessType */
static int hf_lte_rrc_nonCriticalExtension_94;    /* Paging_v1610_IEs */
static int hf_lte_rrc_pagingRecordList_v1610;     /* PagingRecordList_v1610 */
static int hf_lte_rrc_uac_ParamModification_r16;  /* T_uac_ParamModification_r16 */
static int hf_lte_rrc_nonCriticalExtension_95;    /* Paging_v1700_IEs */
static int hf_lte_rrc_pagingRecordList_v1700;     /* PagingRecordList_v1700 */
static int hf_lte_rrc_nonCriticalExtension_96;    /* T_nonCriticalExtension_29 */
static int hf_lte_rrc_PagingRecordList_item;      /* PagingRecord */
static int hf_lte_rrc_PagingRecordList_v1610_item;  /* PagingRecord_v1610 */
static int hf_lte_rrc_PagingRecordList_v1700_item;  /* PagingRecord_v1700 */
static int hf_lte_rrc_ue_Identity;                /* PagingUE_Identity */
static int hf_lte_rrc_cn_Domain;                  /* T_cn_Domain */
static int hf_lte_rrc_accessType_r16;             /* T_accessType_r16 */
static int hf_lte_rrc_mt_EDT_r16;                 /* T_mt_EDT_r16 */
static int hf_lte_rrc_pagingCause_r17;            /* T_pagingCause_r17 */
static int hf_lte_rrc_s_TMSI;                     /* S_TMSI */
static int hf_lte_rrc_imsi;                       /* IMSI */
static int hf_lte_rrc_ng_5G_S_TMSI_r15;           /* NG_5G_S_TMSI_r15 */
static int hf_lte_rrc_fullI_RNTI_r15;             /* I_RNTI_r15 */
static int hf_lte_rrc_IMSI_item;                  /* IMSI_Digit */
static int hf_lte_rrc_criticalExtensions_24;      /* T_criticalExtensions_24 */
static int hf_lte_rrc_c1_27;                      /* T_c1_27 */
static int hf_lte_rrc_proximityIndication_r9_01;  /* ProximityIndication_r9_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_24;  /* T_criticalExtensionsFuture_24 */
static int hf_lte_rrc_type_r9;                    /* T_type_r9 */
static int hf_lte_rrc_carrierFreq_r9;             /* T_carrierFreq_r9 */
static int hf_lte_rrc_eutra_r9;                   /* ARFCN_ValueEUTRA */
static int hf_lte_rrc_utra_r9;                    /* ARFCN_ValueUTRA */
static int hf_lte_rrc_eutra2_v9e0;                /* ARFCN_ValueEUTRA_v9e0 */
static int hf_lte_rrc_nonCriticalExtension_97;    /* ProximityIndication_v930_IEs */
static int hf_lte_rrc_nonCriticalExtension_98;    /* T_nonCriticalExtension_30 */
static int hf_lte_rrc_criticalExtensions_25;      /* T_criticalExtensions_25 */
static int hf_lte_rrc_purConfigurationRequest;    /* PURConfigurationRequest_r16_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_25;  /* T_criticalExtensionsFuture_25 */
static int hf_lte_rrc_pur_ConfigRequest_r16;      /* T_pur_ConfigRequest_r16 */
static int hf_lte_rrc_pur_ReleaseRequest;         /* NULL */
static int hf_lte_rrc_pur_SetupRequest;           /* T_pur_SetupRequest */
static int hf_lte_rrc_requestedNumOccasions_r16;  /* T_requestedNumOccasions_r16 */
static int hf_lte_rrc_requestedPeriodicityAndOffset_r16;  /* PUR_PeriodicityAndOffset_r16 */
static int hf_lte_rrc_requestedTBS_r16;           /* T_requestedTBS_r16 */
static int hf_lte_rrc_rrc_ACK_r16;                /* T_rrc_ACK_r16 */
static int hf_lte_rrc_nonCriticalExtension_99;    /* T_nonCriticalExtension_31 */
static int hf_lte_rrc_criticalExtensions_26;      /* T_criticalExtensions_26 */
static int hf_lte_rrc_c1_28;                      /* T_c1_28 */
static int hf_lte_rrc_rnReconfiguration_r10_01;   /* RNReconfiguration_r10_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_26;  /* T_criticalExtensionsFuture_26 */
static int hf_lte_rrc_rn_SystemInfo_r10;          /* RN_SystemInfo_r10 */
static int hf_lte_rrc_rn_SubframeConfig_r10;      /* RN_SubframeConfig_r10 */
static int hf_lte_rrc_nonCriticalExtension_100;   /* T_nonCriticalExtension_32 */
static int hf_lte_rrc_systemInformationBlockType1_r10;  /* T_systemInformationBlockType1_r10 */
static int hf_lte_rrc_systemInformationBlockType2_r10;  /* SystemInformationBlockType2 */
static int hf_lte_rrc_criticalExtensions_27;      /* T_criticalExtensions_27 */
static int hf_lte_rrc_c1_29;                      /* T_c1_29 */
static int hf_lte_rrc_rnReconfigurationComplete_r10_01;  /* RNReconfigurationComplete_r10_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_27;  /* T_criticalExtensionsFuture_27 */
static int hf_lte_rrc_nonCriticalExtension_101;   /* T_nonCriticalExtension_33 */
static int hf_lte_rrc_criticalExtensions_28;      /* T_criticalExtensions_28 */
static int hf_lte_rrc_c1_30;                      /* T_c1_30 */
static int hf_lte_rrc_rrcConnectionReconfiguration_r8;  /* RRCConnectionReconfiguration_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_28;  /* T_criticalExtensionsFuture_28 */
static int hf_lte_rrc_measConfig;                 /* MeasConfig */
static int hf_lte_rrc_mobilityControlInfo;        /* MobilityControlInfo */
static int hf_lte_rrc_dedicatedInfoNASList;       /* SEQUENCE_SIZE_1_maxDRB_OF_DedicatedInfoNAS */
static int hf_lte_rrc_dedicatedInfoNASList_item;  /* DedicatedInfoNAS */
static int hf_lte_rrc_radioResourceConfigDedicated;  /* RadioResourceConfigDedicated */
static int hf_lte_rrc_securityConfigHO;           /* SecurityConfigHO */
static int hf_lte_rrc_nonCriticalExtension_102;   /* RRCConnectionReconfiguration_v890_IEs */
static int hf_lte_rrc_lateNonCriticalExtension_03;  /* T_lateNonCriticalExtension_02 */
static int hf_lte_rrc_nonCriticalExtension_103;   /* RRCConnectionReconfiguration_v920_IEs */
static int hf_lte_rrc_nonCriticalExtension_104;   /* RRCConnectionReconfiguration_v10i0_IEs */
static int hf_lte_rrc_nonCriticalExtension_105;   /* RRCConnectionReconfiguration_v10l0_IEs */
static int hf_lte_rrc_mobilityControlInfo_v10l0;  /* MobilityControlInfo_v10l0 */
static int hf_lte_rrc_sCellToAddModList_v10l0;    /* SCellToAddModList_v10l0 */
static int hf_lte_rrc_nonCriticalExtension_106;   /* RRCConnectionReconfiguration_v12f0_IEs */
static int hf_lte_rrc_scg_Configuration_v12f0;    /* SCG_Configuration_v12f0 */
static int hf_lte_rrc_nonCriticalExtension_107;   /* RRCConnectionReconfiguration_v1370_IEs */
static int hf_lte_rrc_radioResourceConfigDedicated_v1370;  /* RadioResourceConfigDedicated_v1370 */
static int hf_lte_rrc_sCellToAddModListExt_v1370;  /* SCellToAddModListExt_v1370 */
static int hf_lte_rrc_nonCriticalExtension_108;   /* RRCConnectionReconfiguration_v13c0_IEs */
static int hf_lte_rrc_radioResourceConfigDedicated_v13c0;  /* RadioResourceConfigDedicated_v13c0 */
static int hf_lte_rrc_scg_Configuration_v13c0;    /* SCG_Configuration_v13c0 */
static int hf_lte_rrc_nonCriticalExtension_109;   /* T_nonCriticalExtension_34 */
static int hf_lte_rrc_otherConfig_r9;             /* OtherConfig_r9 */
static int hf_lte_rrc_fullConfig_r9;              /* T_fullConfig_r9 */
static int hf_lte_rrc_nonCriticalExtension_110;   /* RRCConnectionReconfiguration_v1020_IEs */
static int hf_lte_rrc_sCellToReleaseList_r10;     /* SCellToReleaseList_r10 */
static int hf_lte_rrc_sCellToAddModList_r10;      /* SCellToAddModList_r10 */
static int hf_lte_rrc_nonCriticalExtension_111;   /* RRCConnectionReconfiguration_v1130_IEs */
static int hf_lte_rrc_systemInformationBlockType1Dedicated_r11;  /* T_systemInformationBlockType1Dedicated_r11 */
static int hf_lte_rrc_nonCriticalExtension_112;   /* RRCConnectionReconfiguration_v1250_IEs */
static int hf_lte_rrc_wlan_OffloadInfo_r12;       /* T_wlan_OffloadInfo_r12 */
static int hf_lte_rrc_release;                    /* NULL */
static int hf_lte_rrc_rRCConnectionReconfiguration_v1250_IEs_wlan_OffloadInfo_r12_setup;  /* T_rRCConnectionReconfiguration_v1250_IEs_wlan_OffloadInfo_r12_setup */
static int hf_lte_rrc_wlan_OffloadConfigDedicated_r12;  /* WLAN_OffloadConfig_r12 */
static int hf_lte_rrc_t350_r12;                   /* T_t350_r12 */
static int hf_lte_rrc_scg_Configuration_r12;      /* SCG_Configuration_r12 */
static int hf_lte_rrc_sl_SyncTxControl_r12;       /* SL_SyncTxControl_r12 */
static int hf_lte_rrc_sl_DiscConfig_r12;          /* SL_DiscConfig_r12 */
static int hf_lte_rrc_sl_CommConfig_r12;          /* SL_CommConfig_r12 */
static int hf_lte_rrc_nonCriticalExtension_113;   /* RRCConnectionReconfiguration_v1310_IEs */
static int hf_lte_rrc_sCellToReleaseListExt_r13;  /* SCellToReleaseListExt_r13 */
static int hf_lte_rrc_sCellToAddModListExt_r13;   /* SCellToAddModListExt_r13 */
static int hf_lte_rrc_lwa_Configuration_r13;      /* LWA_Configuration_r13 */
static int hf_lte_rrc_lwip_Configuration_r13;     /* LWIP_Configuration_r13 */
static int hf_lte_rrc_rclwi_Configuration_r13;    /* RCLWI_Configuration_r13 */
static int hf_lte_rrc_nonCriticalExtension_114;   /* RRCConnectionReconfiguration_v1430_IEs */
static int hf_lte_rrc_sl_V2X_ConfigDedicated_r14;  /* SL_V2X_ConfigDedicated_r14 */
static int hf_lte_rrc_sCellToAddModListExt_v1430;  /* SCellToAddModListExt_v1430 */
static int hf_lte_rrc_perCC_GapIndicationRequest_r14;  /* T_perCC_GapIndicationRequest_r14 */
static int hf_lte_rrc_systemInformationBlockType2Dedicated_r14;  /* T_systemInformationBlockType2Dedicated_r14 */
static int hf_lte_rrc_nonCriticalExtension_115;   /* RRCConnectionReconfiguration_v1510_IEs */
static int hf_lte_rrc_nr_Config_r15;              /* T_nr_Config_r15 */
static int hf_lte_rrc_rRCConnectionReconfiguration_v1510_IEs_nr_Config_r15_setup;  /* T_rRCConnectionReconfiguration_v1510_IEs_nr_Config_r15_setup */
static int hf_lte_rrc_endc_ReleaseAndAdd_r15;     /* BOOLEAN */
static int hf_lte_rrc_nr_SecondaryCellGroupConfig_r15;  /* T_nr_SecondaryCellGroupConfig_r15 */
static int hf_lte_rrc_sk_Counter_r15;             /* INTEGER_0_65535 */
static int hf_lte_rrc_nr_RadioBearerConfig1_r15;  /* T_nr_RadioBearerConfig1_r15 */
static int hf_lte_rrc_nr_RadioBearerConfig2_r15;  /* T_nr_RadioBearerConfig2_r15 */
static int hf_lte_rrc_tdm_PatternConfig_r15_01;   /* TDM_PatternConfig_r15 */
static int hf_lte_rrc_nonCriticalExtension_116;   /* RRCConnectionReconfiguration_v1530_IEs */
static int hf_lte_rrc_securityConfigHO_v1530;     /* SecurityConfigHO_v1530 */
static int hf_lte_rrc_sCellGroupToReleaseList_r15;  /* SCellGroupToReleaseList_r15 */
static int hf_lte_rrc_sCellGroupToAddModList_r15;  /* SCellGroupToAddModList_r15 */
static int hf_lte_rrc_dedicatedInfoNASList_r15;   /* SEQUENCE_SIZE_1_maxDRB_r15_OF_DedicatedInfoNAS */
static int hf_lte_rrc_dedicatedInfoNASList_r15_item;  /* DedicatedInfoNAS */
static int hf_lte_rrc_p_MaxUE_FR1_r15;            /* P_Max */
static int hf_lte_rrc_nonCriticalExtension_117;   /* RRCConnectionReconfiguration_v1610_IEs */
static int hf_lte_rrc_conditionalReconfiguration_r16;  /* ConditionalReconfiguration_r16 */
static int hf_lte_rrc_daps_SourceRelease_r16;     /* T_daps_SourceRelease_r16 */
static int hf_lte_rrc_sl_ConfigDedicatedForNR_r16;  /* T_sl_ConfigDedicatedForNR_r16 */
static int hf_lte_rrc_sl_SSB_PriorityEUTRA_r16;   /* INTEGER_1_8 */
static int hf_lte_rrc_nonCriticalExtension_118;   /* RRCConnectionReconfiguration_v1700_IEs */
static int hf_lte_rrc_systemInformationBlockType31Dedicated_r17;  /* T_systemInformationBlockType31Dedicated_r17 */
static int hf_lte_rrc_scg_State_r17_01;           /* T_scg_State_r17_01 */
static int hf_lte_rrc_nonCriticalExtension_119;   /* T_nonCriticalExtension_35 */
static int hf_lte_rrc_networkControlledSyncTx_r12;  /* T_networkControlledSyncTx_r12 */
static int hf_lte_rrc_cellIdentification_r12_01;  /* T_cellIdentification_r12_01 */
static int hf_lte_rrc_radioResourceConfigCommonPSCell_r12;  /* RadioResourceConfigCommonPSCell_r12 */
static int hf_lte_rrc_radioResourceConfigDedicatedPSCell_r12;  /* RadioResourceConfigDedicatedPSCell_r12 */
static int hf_lte_rrc_antennaInfoDedicatedPSCell_v1280;  /* AntennaInfoDedicated_v10i0 */
static int hf_lte_rrc_radioResourceConfigDedicatedPSCell_v1370;  /* RadioResourceConfigDedicatedPSCell_v1370 */
static int hf_lte_rrc_radioResourceConfigDedicatedPSCell_v13c0;  /* RadioResourceConfigDedicatedPSCell_v13c0 */
static int hf_lte_rrc_radioResourceConfigCommonPSCell_r12_01;  /* RadioResourceConfigCommonPSCell_v12f0 */
static int hf_lte_rrc_radioResourceConfigCommonPSCell_r14;  /* RadioResourceConfigCommonPSCell_v1440 */
static int hf_lte_rrc_p_MeNB_r12;                 /* INTEGER_1_16 */
static int hf_lte_rrc_p_SeNB_r12;                 /* INTEGER_1_16 */
static int hf_lte_rrc_powerControlMode_r12;       /* INTEGER_1_2 */
static int hf_lte_rrc_SCellToAddModList_r10_item;  /* SCellToAddMod_r10 */
static int hf_lte_rrc_SCellToAddModList_v10l0_item;  /* SCellToAddMod_v10l0 */
static int hf_lte_rrc_SCellToAddModList_v13c0_item;  /* SCellToAddMod_v13c0 */
static int hf_lte_rrc_SCellToAddModList_r16_item;  /* SCellToAddMod_r16 */
static int hf_lte_rrc_SCellToAddModListExt_r13_item;  /* SCellToAddModExt_r13 */
static int hf_lte_rrc_SCellToAddModListExt_v1370_item;  /* SCellToAddModExt_v1370 */
static int hf_lte_rrc_SCellToAddModListExt_v13c0_item;  /* SCellToAddMod_v13c0 */
static int hf_lte_rrc_SCellToAddModListExt_v1430_item;  /* SCellToAddModExt_v1430 */
static int hf_lte_rrc_SCellGroupToAddModList_r15_item;  /* SCellGroupToAddMod_r15 */
static int hf_lte_rrc_sCellIndex_r10;             /* SCellIndex_r10 */
static int hf_lte_rrc_cellIdentification_r10;     /* T_cellIdentification_r10 */
static int hf_lte_rrc_radioResourceConfigCommonSCell_r10;  /* RadioResourceConfigCommonSCell_r10 */
static int hf_lte_rrc_radioResourceConfigDedicatedSCell_r10;  /* RadioResourceConfigDedicatedSCell_r10 */
static int hf_lte_rrc_antennaInfoDedicatedSCell_v10i0;  /* AntennaInfoDedicated_v10i0 */
static int hf_lte_rrc_srs_SwitchFromServCellIndex_r14;  /* INTEGER_0_31 */
static int hf_lte_rrc_sCellState_r15;             /* T_sCellState_r15 */
static int hf_lte_rrc_radioResourceConfigCommonSCell_v10l0;  /* RadioResourceConfigCommonSCell_v10l0 */
static int hf_lte_rrc_radioResourceConfigDedicatedSCell_v13c0;  /* RadioResourceConfigDedicatedSCell_v13c0 */
static int hf_lte_rrc_sCellIndex_r16;             /* SCellIndex_r13 */
static int hf_lte_rrc_cellIdentification_r16;     /* T_cellIdentification_r16 */
static int hf_lte_rrc_physCellId_r16;             /* PhysCellId */
static int hf_lte_rrc_dl_CarrierFreq_r16;         /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_radioResourceConfigCommonSCell_r16;  /* RadioResourceConfigCommonSCell_r10 */
static int hf_lte_rrc_radioResourceConfigDedicatedSCell_r16;  /* RadioResourceConfigDedicatedSCell_r10 */
static int hf_lte_rrc_antennaInfoDedicatedSCell_r16;  /* AntennaInfoDedicated_v10i0 */
static int hf_lte_rrc_srs_SwitchFromServCellIndex_r16;  /* INTEGER_0_31 */
static int hf_lte_rrc_sCellState_r16;             /* T_sCellState_r16 */
static int hf_lte_rrc_cellIdentification_r13;     /* T_cellIdentification_r13 */
static int hf_lte_rrc_physCellId_r13;             /* PhysCellId */
static int hf_lte_rrc_dl_CarrierFreq_r13;         /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_radioResourceConfigCommonSCell_r13;  /* RadioResourceConfigCommonSCell_r10 */
static int hf_lte_rrc_radioResourceConfigDedicatedSCell_r13;  /* RadioResourceConfigDedicatedSCell_r10 */
static int hf_lte_rrc_antennaInfoDedicatedSCell_r13;  /* AntennaInfoDedicated_v10i0 */
static int hf_lte_rrc_radioResourceConfigCommonSCell_v1370;  /* RadioResourceConfigCommonSCell_v10l0 */
static int hf_lte_rrc_sCellState_r15_01;          /* T_sCellState_r15_01 */
static int hf_lte_rrc_sCellGroupIndex_r15;        /* SCellGroupIndex_r15 */
static int hf_lte_rrc_sCellConfigCommon_r15;      /* SCellConfigCommon_r15 */
static int hf_lte_rrc_sCellToReleaseList_r15;     /* SCellToReleaseListExt_r13 */
static int hf_lte_rrc_sCellToAddModList_r15;      /* SCellToAddModListExt_r13 */
static int hf_lte_rrc_SCellToReleaseList_r10_item;  /* SCellIndex_r10 */
static int hf_lte_rrc_SCellToReleaseListExt_r13_item;  /* SCellIndex_r13 */
static int hf_lte_rrc_SCellGroupToReleaseList_r15_item;  /* SCellGroupIndex_r15 */
static int hf_lte_rrc_radioResourceConfigCommonSCell_r15;  /* RadioResourceConfigCommonSCell_r10 */
static int hf_lte_rrc_radioResourceConfigDedicatedSCell_r15;  /* RadioResourceConfigDedicatedSCell_r10 */
static int hf_lte_rrc_antennaInfoDedicatedSCell_r15;  /* AntennaInfoDedicated_v10i0 */
static int hf_lte_rrc_sCG_Configuration_r12_setup;  /* T_sCG_Configuration_r12_setup */
static int hf_lte_rrc_scg_ConfigPartMCG_r12;      /* T_scg_ConfigPartMCG_r12 */
static int hf_lte_rrc_scg_Counter_r12;            /* INTEGER_0_65535 */
static int hf_lte_rrc_scg_ConfigPartSCG_r12;      /* SCG_ConfigPartSCG_r12 */
static int hf_lte_rrc_sCG_Configuration_v12f0_setup;  /* T_sCG_Configuration_v12f0_setup */
static int hf_lte_rrc_scg_ConfigPartSCG_v12f0;    /* SCG_ConfigPartSCG_v12f0 */
static int hf_lte_rrc_sCG_Configuration_v13c0_setup;  /* T_sCG_Configuration_v13c0_setup */
static int hf_lte_rrc_scg_ConfigPartSCG_v13c0;    /* SCG_ConfigPartSCG_v13c0 */
static int hf_lte_rrc_radioResourceConfigDedicatedSCG_r12;  /* RadioResourceConfigDedicatedSCG_r12 */
static int hf_lte_rrc_pSCellToAddMod_r12;         /* PSCellToAddMod_r12 */
static int hf_lte_rrc_sCellToAddModListSCG_r12_01;  /* SCellToAddModList_r10 */
static int hf_lte_rrc_mobilityControlInfoSCG_r12;  /* MobilityControlInfoSCG_r12 */
static int hf_lte_rrc_sCellToAddModListSCG_Ext_r13_01;  /* SCellToAddModListExt_r13 */
static int hf_lte_rrc_sCellToAddModListSCG_Ext_v1370;  /* SCellToAddModListExt_v1370 */
static int hf_lte_rrc_pSCellToAddMod_v1440;       /* PSCellToAddMod_v1440 */
static int hf_lte_rrc_sCellGroupToReleaseListSCG_r15;  /* SCellGroupToReleaseList_r15 */
static int hf_lte_rrc_sCellGroupToAddModListSCG_r15;  /* SCellGroupToAddModList_r15 */
static int hf_lte_rrc_measConfigSN_r15;           /* MeasConfig */
static int hf_lte_rrc_tdm_PatternConfigNE_DC_r15;  /* TDM_PatternConfig_r15 */
static int hf_lte_rrc_pSCellToAddMod_v12f0;       /* PSCellToAddMod_v12f0 */
static int hf_lte_rrc_sCellToAddModListSCG_v12f0;  /* SCellToAddModList_v10l0 */
static int hf_lte_rrc_sCellToAddModListSCG_v13c0;  /* SCellToAddModList_v13c0 */
static int hf_lte_rrc_sCellToAddModListSCG_Ext_v13c0;  /* SCellToAddModListExt_v13c0 */
static int hf_lte_rrc_handoverType;               /* T_handoverType */
static int hf_lte_rrc_intraLTE;                   /* T_intraLTE */
static int hf_lte_rrc_securityAlgorithmConfig;    /* SecurityAlgorithmConfig */
static int hf_lte_rrc_keyChangeIndicator;         /* BOOLEAN */
static int hf_lte_rrc_nextHopChainingCount;       /* NextHopChainingCount */
static int hf_lte_rrc_interRAT;                   /* T_interRAT */
static int hf_lte_rrc_nas_SecurityParamToEUTRA;   /* T_nas_SecurityParamToEUTRA */
static int hf_lte_rrc_handoverType_v1530;         /* T_handoverType_v1530 */
static int hf_lte_rrc_intra5GC;                   /* T_intra5GC */
static int hf_lte_rrc_securityAlgorithmConfig_r15;  /* SecurityAlgorithmConfig */
static int hf_lte_rrc_keyChangeIndicator_r15;     /* BOOLEAN */
static int hf_lte_rrc_nextHopChainingCount_r15;   /* NextHopChainingCount */
static int hf_lte_rrc_nas_Container_r15;          /* T_nas_Container_r15 */
static int hf_lte_rrc_fivegc_ToEPC;               /* T_fivegc_ToEPC */
static int hf_lte_rrc_epc_To5GC;                  /* T_epc_To5GC */
static int hf_lte_rrc_nas_Container_r15_01;       /* T_nas_Container_r15_01 */
static int hf_lte_rrc_criticalExtensions_29;      /* T_criticalExtensions_29 */
static int hf_lte_rrc_rrcConnectionReconfigurationComplete_r8;  /* RRCConnectionReconfigurationComplete_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_29;  /* T_criticalExtensionsFuture_29 */
static int hf_lte_rrc_nonCriticalExtension_120;   /* RRCConnectionReconfigurationComplete_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_121;   /* RRCConnectionReconfigurationComplete_v1020_IEs */
static int hf_lte_rrc_rlf_InfoAvailable_r10;      /* T_rlf_InfoAvailable_r10 */
static int hf_lte_rrc_logMeasAvailable_r10;       /* T_logMeasAvailable_r10 */
static int hf_lte_rrc_nonCriticalExtension_122;   /* RRCConnectionReconfigurationComplete_v1130_IEs */
static int hf_lte_rrc_connEstFailInfoAvailable_r11;  /* T_connEstFailInfoAvailable_r11 */
static int hf_lte_rrc_nonCriticalExtension_123;   /* RRCConnectionReconfigurationComplete_v1250_IEs */
static int hf_lte_rrc_logMeasAvailableMBSFN_r12;  /* T_logMeasAvailableMBSFN_r12 */
static int hf_lte_rrc_nonCriticalExtension_124;   /* RRCConnectionReconfigurationComplete_v1430_IEs */
static int hf_lte_rrc_perCC_GapIndicationList_r14;  /* PerCC_GapIndicationList_r14 */
static int hf_lte_rrc_numFreqEffective_r14;       /* INTEGER_1_12 */
static int hf_lte_rrc_numFreqEffectiveReduced_r14;  /* INTEGER_1_12 */
static int hf_lte_rrc_nonCriticalExtension_125;   /* RRCConnectionReconfigurationComplete_v1510_IEs */
static int hf_lte_rrc_scg_ConfigResponseNR_r15;   /* T_scg_ConfigResponseNR_r15 */
static int hf_lte_rrc_nonCriticalExtension_126;   /* RRCConnectionReconfigurationComplete_v1530_IEs */
static int hf_lte_rrc_logMeasAvailableBT_r15;     /* T_logMeasAvailableBT_r15 */
static int hf_lte_rrc_logMeasAvailableWLAN_r15;   /* T_logMeasAvailableWLAN_r15 */
static int hf_lte_rrc_flightPathInfoAvailable_r15;  /* T_flightPathInfoAvailable_r15 */
static int hf_lte_rrc_nonCriticalExtension_127;   /* RRCConnectionReconfigurationComplete_v1700_IEs */
static int hf_lte_rrc_selectedCondReconfigurationToApply_r17;  /* CondReconfigurationId_r16 */
static int hf_lte_rrc_nonCriticalExtension_128;   /* RRCConnectionReconfigurationComplete_v1710_IEs */
static int hf_lte_rrc_gnss_ValidityDuration_r17;  /* GNSS_ValidityDuration_r17 */
static int hf_lte_rrc_nonCriticalExtension_129;   /* RRCConnectionReconfigurationComplete_v1800_IEs */
static int hf_lte_rrc_gnss_PositionFixDuration_r18;  /* GNSS_PositionFixDuration_r18 */
static int hf_lte_rrc_nonCriticalExtension_130;   /* T_nonCriticalExtension_36 */
static int hf_lte_rrc_criticalExtensions_30;      /* T_criticalExtensions_30 */
static int hf_lte_rrc_c1_31;                      /* T_c1_31 */
static int hf_lte_rrc_rrcConnectionReestablishment_r8;  /* RRCConnectionReestablishment_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_30;  /* T_criticalExtensionsFuture_30 */
static int hf_lte_rrc_nonCriticalExtension_131;   /* RRCConnectionReestablishment_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_132;   /* T_nonCriticalExtension_37 */
static int hf_lte_rrc_criticalExtensions_31;      /* T_criticalExtensions_31 */
static int hf_lte_rrc_rrcConnectionReestablishmentComplete_r8;  /* RRCConnectionReestablishmentComplete_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_31;  /* T_criticalExtensionsFuture_31 */
static int hf_lte_rrc_nonCriticalExtension_133;   /* RRCConnectionReestablishmentComplete_v920_IEs */
static int hf_lte_rrc_rlf_InfoAvailable_r9;       /* T_rlf_InfoAvailable_r9 */
static int hf_lte_rrc_nonCriticalExtension_134;   /* RRCConnectionReestablishmentComplete_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_135;   /* RRCConnectionReestablishmentComplete_v1020_IEs */
static int hf_lte_rrc_logMeasAvailable_r10_01;    /* T_logMeasAvailable_r10_01 */
static int hf_lte_rrc_nonCriticalExtension_136;   /* RRCConnectionReestablishmentComplete_v1130_IEs */
static int hf_lte_rrc_connEstFailInfoAvailable_r11_01;  /* T_connEstFailInfoAvailable_r11_01 */
static int hf_lte_rrc_nonCriticalExtension_137;   /* RRCConnectionReestablishmentComplete_v1250_IEs */
static int hf_lte_rrc_logMeasAvailableMBSFN_r12_01;  /* T_logMeasAvailableMBSFN_r12_01 */
static int hf_lte_rrc_nonCriticalExtension_138;   /* RRCConnectionReestablishmentComplete_v1530_IEs */
static int hf_lte_rrc_logMeasAvailableBT_r15_01;  /* T_logMeasAvailableBT_r15_01 */
static int hf_lte_rrc_logMeasAvailableWLAN_r15_01;  /* T_logMeasAvailableWLAN_r15_01 */
static int hf_lte_rrc_flightPathInfoAvailable_r15_01;  /* T_flightPathInfoAvailable_r15_01 */
static int hf_lte_rrc_nonCriticalExtension_139;   /* RRCConnectionReestablishmentComplete_v1710_IEs */
static int hf_lte_rrc_nonCriticalExtension_140;   /* RRCConnectionReestablishmentComplete_v1800_IEs */
static int hf_lte_rrc_nonCriticalExtension_141;   /* T_nonCriticalExtension_38 */
static int hf_lte_rrc_criticalExtensions_32;      /* T_criticalExtensions_32 */
static int hf_lte_rrc_rrcConnectionReestablishmentReject_r8;  /* RRCConnectionReestablishmentReject_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_32;  /* T_criticalExtensionsFuture_32 */
static int hf_lte_rrc_nonCriticalExtension_142;   /* RRCConnectionReestablishmentReject_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_143;   /* T_nonCriticalExtension_39 */
static int hf_lte_rrc_criticalExtensions_33;      /* T_criticalExtensions_33 */
static int hf_lte_rrc_rrcConnectionReestablishmentRequest_r8;  /* RRCConnectionReestablishmentRequest_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_33;  /* T_criticalExtensionsFuture_33 */
static int hf_lte_rrc_ue_Identity_01;             /* ReestabUE_Identity */
static int hf_lte_rrc_reestablishmentCause;       /* ReestablishmentCause */
static int hf_lte_rrc_c_RNTI;                     /* C_RNTI */
static int hf_lte_rrc_physCellId_01;              /* PhysCellId */
static int hf_lte_rrc_criticalExtensions_34;      /* T_criticalExtensions_34 */
static int hf_lte_rrc_c1_32;                      /* T_c1_32 */
static int hf_lte_rrc_rrcConnectionReject_r8;     /* RRCConnectionReject_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_34;  /* T_criticalExtensionsFuture_34 */
static int hf_lte_rrc_waitTime;                   /* INTEGER_1_16 */
static int hf_lte_rrc_nonCriticalExtension_144;   /* RRCConnectionReject_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_145;   /* RRCConnectionReject_v1020_IEs */
static int hf_lte_rrc_extendedWaitTime_r10;       /* INTEGER_1_1800 */
static int hf_lte_rrc_nonCriticalExtension_146;   /* RRCConnectionReject_v1130_IEs */
static int hf_lte_rrc_deprioritisationReq_r11;    /* T_deprioritisationReq_r11 */
static int hf_lte_rrc_deprioritisationType_r11;   /* T_deprioritisationType_r11 */
static int hf_lte_rrc_deprioritisationTimer_r11;  /* T_deprioritisationTimer_r11 */
static int hf_lte_rrc_nonCriticalExtension_147;   /* RRCConnectionReject_v1320_IEs */
static int hf_lte_rrc_rrc_SuspendIndication_r13;  /* T_rrc_SuspendIndication_r13 */
static int hf_lte_rrc_nonCriticalExtension_148;   /* T_nonCriticalExtension_40 */
static int hf_lte_rrc_criticalExtensions_35;      /* T_criticalExtensions_35 */
static int hf_lte_rrc_c1_33;                      /* T_c1_33 */
static int hf_lte_rrc_rrcConnectionRelease_r8;    /* RRCConnectionRelease_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_35;  /* T_criticalExtensionsFuture_35 */
static int hf_lte_rrc_releaseCause;               /* ReleaseCause */
static int hf_lte_rrc_redirectedCarrierInfo;      /* RedirectedCarrierInfo */
static int hf_lte_rrc_idleModeMobilityControlInfo;  /* IdleModeMobilityControlInfo */
static int hf_lte_rrc_nonCriticalExtension_149;   /* RRCConnectionRelease_v890_IEs */
static int hf_lte_rrc_lateNonCriticalExtension_04;  /* T_lateNonCriticalExtension_03 */
static int hf_lte_rrc_nonCriticalExtension_150;   /* RRCConnectionRelease_v920_IEs */
static int hf_lte_rrc_redirectedCarrierInfo_v9e0;  /* RedirectedCarrierInfo_v9e0 */
static int hf_lte_rrc_idleModeMobilityControlInfo_v9e0;  /* IdleModeMobilityControlInfo_v9e0 */
static int hf_lte_rrc_nonCriticalExtension_151;   /* T_nonCriticalExtension_41 */
static int hf_lte_rrc_cellInfoList_r9;            /* T_cellInfoList_r9 */
static int hf_lte_rrc_geran_r9;                   /* CellInfoListGERAN_r9 */
static int hf_lte_rrc_utra_FDD_r9;                /* CellInfoListUTRA_FDD_r9 */
static int hf_lte_rrc_utra_TDD_r9;                /* CellInfoListUTRA_TDD_r9 */
static int hf_lte_rrc_utra_TDD_r10;               /* CellInfoListUTRA_TDD_r10 */
static int hf_lte_rrc_nonCriticalExtension_152;   /* RRCConnectionRelease_v1020_IEs */
static int hf_lte_rrc_nonCriticalExtension_153;   /* RRCConnectionRelease_v1320_IEs */
static int hf_lte_rrc_resumeIdentity_r13;         /* ResumeIdentity_r13 */
static int hf_lte_rrc_nonCriticalExtension_154;   /* RRCConnectionRelease_v1530_IEs */
static int hf_lte_rrc_drb_ContinueROHC_r15;       /* T_drb_ContinueROHC_r15 */
static int hf_lte_rrc_measIdleConfig_r15;         /* MeasIdleConfigDedicated_r15 */
static int hf_lte_rrc_rrc_InactiveConfig_r15;     /* RRC_InactiveConfig_r15 */
static int hf_lte_rrc_cn_Type_r15;                /* T_cn_Type_r15 */
static int hf_lte_rrc_nonCriticalExtension_155;   /* RRCConnectionRelease_v1540_IEs */
static int hf_lte_rrc_nonCriticalExtension_156;   /* RRCConnectionRelease_v15b0_IEs */
static int hf_lte_rrc_noLastCellUpdate_r15;       /* T_noLastCellUpdate_r15 */
static int hf_lte_rrc_nonCriticalExtension_157;   /* RRCConnectionRelease_v1610_IEs */
static int hf_lte_rrc_fullI_RNTI_r16;             /* I_RNTI_r15 */
static int hf_lte_rrc_shortI_RNTI_r16;            /* ShortI_RNTI_r15 */
static int hf_lte_rrc_pur_Config_r16;             /* T_pur_Config_r16 */
static int hf_lte_rrc_rRCConnectionRelease_v1610_IEs_pur_Config_r16_setup;  /* PUR_Config_r16 */
static int hf_lte_rrc_rrc_InactiveConfig_v1610;   /* RRC_InactiveConfig_v1610 */
static int hf_lte_rrc_releaseIdleMeasConfig_r16;  /* T_releaseIdleMeasConfig_r16 */
static int hf_lte_rrc_altFreqPriorities_r16;      /* T_altFreqPriorities_r16 */
static int hf_lte_rrc_t323_r16;                   /* T_t323_r16 */
static int hf_lte_rrc_nonCriticalExtension_158;   /* RRCConnectionRelease_v1650_IEs */
static int hf_lte_rrc_mpsPriorityIndication_r16;  /* T_mpsPriorityIndication_r16 */
static int hf_lte_rrc_nonCriticalExtension_159;   /* T_nonCriticalExtension_42 */
static int hf_lte_rrc_eutra;                      /* ARFCN_ValueEUTRA */
static int hf_lte_rrc_geran_01;                   /* CarrierFreqsGERAN */
static int hf_lte_rrc_utra_FDD;                   /* ARFCN_ValueUTRA */
static int hf_lte_rrc_utra_TDD;                   /* ARFCN_ValueUTRA */
static int hf_lte_rrc_cdma2000_HRPD;              /* CarrierFreqCDMA2000 */
static int hf_lte_rrc_cdma2000_1xRTT;             /* CarrierFreqCDMA2000 */
static int hf_lte_rrc_utra_TDD_r10_01;            /* CarrierFreqListUTRA_TDD_r10 */
static int hf_lte_rrc_nr_r15;                     /* CarrierInfoNR_r15 */
static int hf_lte_rrc_nr_r17;                     /* CarrierInfoNR_r17 */
static int hf_lte_rrc_eutra_v9e0;                 /* ARFCN_ValueEUTRA_v9e0 */
static int hf_lte_rrc_shortI_RNTI_r15;            /* ShortI_RNTI_r15 */
static int hf_lte_rrc_ran_PagingCycle_r15;        /* T_ran_PagingCycle_r15 */
static int hf_lte_rrc_periodic_RNAU_timer_r15;    /* T_periodic_RNAU_timer_r15 */
static int hf_lte_rrc_rRC_InactiveConfig_r15_dummy;  /* T_rRC_InactiveConfig_r15_dummy */
static int hf_lte_rrc_ran_PagingCycle_v1610;      /* T_ran_PagingCycle_v1610 */
static int hf_lte_rrc_cellList;                   /* PLMN_RAN_AreaCellList_r15 */
static int hf_lte_rrc_ran_AreaConfigList;         /* PLMN_RAN_AreaConfigList_r15 */
static int hf_lte_rrc_PLMN_RAN_AreaCellList_r15_item;  /* PLMN_RAN_AreaCell_r15 */
static int hf_lte_rrc_plmn_Identity_r15;          /* PLMN_Identity */
static int hf_lte_rrc_ran_AreaCells_r15;          /* SEQUENCE_SIZE_1_32_OF_CellIdentity */
static int hf_lte_rrc_ran_AreaCells_r15_item;     /* CellIdentity */
static int hf_lte_rrc_PLMN_RAN_AreaConfigList_r15_item;  /* PLMN_RAN_AreaConfig_r15 */
static int hf_lte_rrc_ran_Area_r15;               /* SEQUENCE_SIZE_1_16_OF_RAN_AreaConfig_r15 */
static int hf_lte_rrc_ran_Area_r15_item;          /* RAN_AreaConfig_r15 */
static int hf_lte_rrc_trackingAreaCode_5GC_r15;   /* TrackingAreaCode_5GC_r15 */
static int hf_lte_rrc_ran_AreaCodeList_r15;       /* SEQUENCE_SIZE_1_32_OF_RAN_AreaCode_r15 */
static int hf_lte_rrc_ran_AreaCodeList_r15_item;  /* RAN_AreaCode_r15 */
static int hf_lte_rrc_CarrierFreqListUTRA_TDD_r10_item;  /* ARFCN_ValueUTRA */
static int hf_lte_rrc_freqPriorityListEUTRA;      /* FreqPriorityListEUTRA */
static int hf_lte_rrc_freqPriorityListGERAN;      /* FreqsPriorityListGERAN */
static int hf_lte_rrc_freqPriorityListUTRA_FDD;   /* FreqPriorityListUTRA_FDD */
static int hf_lte_rrc_freqPriorityListUTRA_TDD;   /* FreqPriorityListUTRA_TDD */
static int hf_lte_rrc_bandClassPriorityListHRPD;  /* BandClassPriorityListHRPD */
static int hf_lte_rrc_bandClassPriorityList1XRTT;  /* BandClassPriorityList1XRTT */
static int hf_lte_rrc_t320;                       /* T_t320 */
static int hf_lte_rrc_freqPriorityListExtEUTRA_r12;  /* FreqPriorityListExtEUTRA_r12 */
static int hf_lte_rrc_freqPriorityListEUTRA_v1310;  /* FreqPriorityListEUTRA_v1310 */
static int hf_lte_rrc_freqPriorityListExtEUTRA_v1310;  /* FreqPriorityListExtEUTRA_v1310 */
static int hf_lte_rrc_freqPriorityListNR_r15;     /* FreqPriorityListNR_r15 */
static int hf_lte_rrc_freqPriorityListEUTRA_v9e0;  /* SEQUENCE_SIZE_1_maxFreq_OF_FreqPriorityEUTRA_v9e0 */
static int hf_lte_rrc_freqPriorityListEUTRA_v9e0_item;  /* FreqPriorityEUTRA_v9e0 */
static int hf_lte_rrc_FreqPriorityListEUTRA_item;  /* FreqPriorityEUTRA */
static int hf_lte_rrc_FreqPriorityListExtEUTRA_r12_item;  /* FreqPriorityEUTRA_r12 */
static int hf_lte_rrc_FreqPriorityListEUTRA_v1310_item;  /* FreqPriorityEUTRA_v1310 */
static int hf_lte_rrc_FreqPriorityListExtEUTRA_v1310_item;  /* FreqPriorityEUTRA_v1310 */
static int hf_lte_rrc_carrierFreq_01;             /* ARFCN_ValueEUTRA */
static int hf_lte_rrc_cellReselectionPriority;    /* CellReselectionPriority */
static int hf_lte_rrc_carrierFreq_v9e0;           /* ARFCN_ValueEUTRA_v9e0 */
static int hf_lte_rrc_cellReselectionPriority_r12;  /* CellReselectionPriority */
static int hf_lte_rrc_cellReselectionSubPriority_r13;  /* CellReselectionSubPriority_r13 */
static int hf_lte_rrc_FreqPriorityListNR_r15_item;  /* FreqPriorityNR_r15 */
static int hf_lte_rrc_carrierFreq_r15;            /* ARFCN_ValueNR_r15 */
static int hf_lte_rrc_cellReselectionPriority_r15;  /* CellReselectionPriority */
static int hf_lte_rrc_cellReselectionSubPriority_r15;  /* CellReselectionSubPriority_r13 */
static int hf_lte_rrc_FreqsPriorityListGERAN_item;  /* FreqsPriorityGERAN */
static int hf_lte_rrc_carrierFreqs;               /* CarrierFreqsGERAN */
static int hf_lte_rrc_FreqPriorityListUTRA_FDD_item;  /* FreqPriorityUTRA_FDD */
static int hf_lte_rrc_carrierFreq_02;             /* ARFCN_ValueUTRA */
static int hf_lte_rrc_FreqPriorityListUTRA_TDD_item;  /* FreqPriorityUTRA_TDD */
static int hf_lte_rrc_BandClassPriorityListHRPD_item;  /* BandClassPriorityHRPD */
static int hf_lte_rrc_bandClass;                  /* BandclassCDMA2000 */
static int hf_lte_rrc_BandClassPriorityList1XRTT_item;  /* BandClassPriority1XRTT */
static int hf_lte_rrc_CellInfoListGERAN_r9_item;  /* CellInfoGERAN_r9 */
static int hf_lte_rrc_physCellId_r9;              /* PhysCellIdGERAN */
static int hf_lte_rrc_carrierFreq_r9_01;          /* CarrierFreqGERAN */
static int hf_lte_rrc_systemInformation_r9;       /* T_systemInformation_r9 */
static int hf_lte_rrc_subcarrierSpacingSSB_r15;   /* T_subcarrierSpacingSSB_r15 */
static int hf_lte_rrc_carrierFreq_r17;            /* ARFCN_ValueNR_r15 */
static int hf_lte_rrc_subcarrierSpacingSSB_r17;   /* T_subcarrierSpacingSSB_r17 */
static int hf_lte_rrc_smtc_r17;                   /* MTC_SSB_NR_r15 */
static int hf_lte_rrc_CellInfoListUTRA_FDD_r9_item;  /* CellInfoUTRA_FDD_r9 */
static int hf_lte_rrc_physCellId_r9_01;           /* PhysCellIdUTRA_FDD */
static int hf_lte_rrc_utra_BCCH_Container_r9;     /* T_utra_BCCH_Container_r9 */
static int hf_lte_rrc_CellInfoListUTRA_TDD_r9_item;  /* CellInfoUTRA_TDD_r9 */
static int hf_lte_rrc_physCellId_r9_02;           /* PhysCellIdUTRA_TDD */
static int hf_lte_rrc_utra_BCCH_Container_r9_01;  /* T_utra_BCCH_Container_r9_01 */
static int hf_lte_rrc_CellInfoListUTRA_TDD_r10_item;  /* CellInfoUTRA_TDD_r10 */
static int hf_lte_rrc_physCellId_r10_01;          /* PhysCellIdUTRA_TDD */
static int hf_lte_rrc_carrierFreq_r10_01;         /* ARFCN_ValueUTRA */
static int hf_lte_rrc_utra_BCCH_Container_r10;    /* T_utra_BCCH_Container_r10 */
static int hf_lte_rrc_criticalExtensions_36;      /* T_criticalExtensions_36 */
static int hf_lte_rrc_rrcConnectionRequest_r8;    /* RRCConnectionRequest_r8_IEs */
static int hf_lte_rrc_rrcConnectionRequest_r15;   /* RRCConnectionRequest_5GC_r15_IEs */
static int hf_lte_rrc_ue_Identity_02;             /* InitialUE_Identity */
static int hf_lte_rrc_establishmentCause;         /* EstablishmentCause */
static int hf_lte_rrc_ue_Identity_r15;            /* InitialUE_Identity_5GC_r15 */
static int hf_lte_rrc_establishmentCause_r15;     /* EstablishmentCause_5GC_r15 */
static int hf_lte_rrc_randomValue;                /* BIT_STRING_SIZE_40 */
static int hf_lte_rrc_ng_5G_S_TMSI_Part1;         /* BIT_STRING_SIZE_40 */
static int hf_lte_rrc_criticalExtensions_37;      /* T_criticalExtensions_37 */
static int hf_lte_rrc_c1_34;                      /* T_c1_34 */
static int hf_lte_rrc_rrcConnectionResume_r13_01;  /* RRCConnectionResume_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_36;  /* T_criticalExtensionsFuture_36 */
static int hf_lte_rrc_radioResourceConfigDedicated_r13;  /* RadioResourceConfigDedicated */
static int hf_lte_rrc_nextHopChainingCount_r13;   /* NextHopChainingCount */
static int hf_lte_rrc_measConfig_r13;             /* MeasConfig */
static int hf_lte_rrc_antennaInfoDedicatedPCell_r13;  /* AntennaInfoDedicated_v10i0 */
static int hf_lte_rrc_drb_ContinueROHC_r13;       /* T_drb_ContinueROHC_r13 */
static int hf_lte_rrc_nonCriticalExtension_160;   /* RRCConnectionResume_v1430_IEs */
static int hf_lte_rrc_otherConfig_r14;            /* OtherConfig_r9 */
static int hf_lte_rrc_nonCriticalExtension_161;   /* RRCConnectionResume_v1510_IEs */
static int hf_lte_rrc_nr_RadioBearerConfig1_r15_01;  /* T_nr_RadioBearerConfig1_r15_01 */
static int hf_lte_rrc_nr_RadioBearerConfig2_r15_01;  /* T_nr_RadioBearerConfig2_r15_01 */
static int hf_lte_rrc_nonCriticalExtension_162;   /* RRCConnectionResume_v1530_IEs */
static int hf_lte_rrc_fullConfig_r15;             /* T_fullConfig_r15 */
static int hf_lte_rrc_nonCriticalExtension_163;   /* RRCConnectionResume_v1610_IEs */
static int hf_lte_rrc_idleModeMeasurementReq_r16;  /* T_idleModeMeasurementReq_r16 */
static int hf_lte_rrc_restoreMCG_SCells_r16;      /* T_restoreMCG_SCells_r16 */
static int hf_lte_rrc_restoreSCG_r16;             /* T_restoreSCG_r16 */
static int hf_lte_rrc_sCellToAddModList_r16;      /* SCellToAddModList_r16 */
static int hf_lte_rrc_sCellToReleaseList_r16;     /* SCellToReleaseListExt_r13 */
static int hf_lte_rrc_sCellGroupToReleaseList_r16;  /* SCellGroupToReleaseList_r15 */
static int hf_lte_rrc_sCellGroupToAddModList_r16;  /* SCellGroupToAddModList_r15 */
static int hf_lte_rrc_nr_SecondaryCellGroupConfig_r16;  /* T_nr_SecondaryCellGroupConfig_r16 */
static int hf_lte_rrc_p_MaxEUTRA_r16;             /* P_Max */
static int hf_lte_rrc_p_MaxUE_FR1_r16;            /* P_Max */
static int hf_lte_rrc_tdm_PatternConfig_r16;      /* TDM_PatternConfig_r15 */
static int hf_lte_rrc_nonCriticalExtension_164;   /* RRCConnectionResume_v1700_IEs */
static int hf_lte_rrc_scg_State_r17_02;           /* T_scg_State_r17_02 */
static int hf_lte_rrc_nonCriticalExtension_165;   /* T_nonCriticalExtension_43 */
static int hf_lte_rrc_criticalExtensions_38;      /* T_criticalExtensions_38 */
static int hf_lte_rrc_rrcConnectionResumeComplete_r13_01;  /* RRCConnectionResumeComplete_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_37;  /* T_criticalExtensionsFuture_37 */
static int hf_lte_rrc_selectedPLMN_Identity_r13;  /* INTEGER_1_maxPLMN_r11 */
static int hf_lte_rrc_dedicatedInfoNAS_r13;       /* DedicatedInfoNAS */
static int hf_lte_rrc_rlf_InfoAvailable_r13;      /* T_rlf_InfoAvailable_r13 */
static int hf_lte_rrc_logMeasAvailable_r13;       /* T_logMeasAvailable_r13 */
static int hf_lte_rrc_connEstFailInfoAvailable_r13;  /* T_connEstFailInfoAvailable_r13 */
static int hf_lte_rrc_mobilityState_r13;          /* T_mobilityState_r13 */
static int hf_lte_rrc_mobilityHistoryAvail_r13;   /* T_mobilityHistoryAvail_r13 */
static int hf_lte_rrc_logMeasAvailableMBSFN_r13;  /* T_logMeasAvailableMBSFN_r13 */
static int hf_lte_rrc_nonCriticalExtension_166;   /* RRCConnectionResumeComplete_v1530_IEs */
static int hf_lte_rrc_logMeasAvailableBT_r15_02;  /* T_logMeasAvailableBT_r15_02 */
static int hf_lte_rrc_logMeasAvailableWLAN_r15_02;  /* T_logMeasAvailableWLAN_r15_02 */
static int hf_lte_rrc_idleMeasAvailable_r15;      /* T_idleMeasAvailable_r15 */
static int hf_lte_rrc_flightPathInfoAvailable_r15_02;  /* T_flightPathInfoAvailable_r15_02 */
static int hf_lte_rrc_nonCriticalExtension_167;   /* RRCConnectionResumeComplete_v1610_IEs */
static int hf_lte_rrc_measResultListIdle_r16;     /* MeasResultListIdle_r15 */
static int hf_lte_rrc_measResultListExtIdle_r16;  /* MeasResultListExtIdle_r16 */
static int hf_lte_rrc_measResultListIdleNR_r16;   /* MeasResultListIdleNR_r16 */
static int hf_lte_rrc_scg_ConfigResponseNR_r16;   /* T_scg_ConfigResponseNR_r16 */
static int hf_lte_rrc_nonCriticalExtension_168;   /* RRCConnectionResumeComplete_v1710_IEs */
static int hf_lte_rrc_nonCriticalExtension_169;   /* RRCConnectionResumeComplete_v1800_IEs */
static int hf_lte_rrc_nonCriticalExtension_170;   /* T_nonCriticalExtension_44 */
static int hf_lte_rrc_criticalExtensions_39;      /* T_criticalExtensions_39 */
static int hf_lte_rrc_rrcConnectionResumeRequest_r13_01;  /* RRCConnectionResumeRequest_r13_IEs */
static int hf_lte_rrc_rrcConnectionResumeRequest_r15;  /* RRCConnectionResumeRequest_5GC_r15_IEs */
static int hf_lte_rrc_rRCConnectionResumeRequest_r13_IEs_resumeIdentity_r13;  /* T_rRCConnectionResumeRequest_r13_IEs_resumeIdentity_r13 */
static int hf_lte_rrc_resumeID_r13;               /* ResumeIdentity_r13 */
static int hf_lte_rrc_truncatedResumeID_r13;      /* BIT_STRING_SIZE_24 */
static int hf_lte_rrc_shortResumeMAC_I_r13;       /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_resumeCause_r13;            /* ResumeCause */
static int hf_lte_rrc_resumeIdentity_r15;         /* T_resumeIdentity_r15 */
static int hf_lte_rrc_shortResumeMAC_I_r15;       /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_resumeCause_r15;            /* ResumeCause_r15 */
static int hf_lte_rrc_criticalExtensions_40;      /* T_criticalExtensions_40 */
static int hf_lte_rrc_c1_35;                      /* T_c1_35 */
static int hf_lte_rrc_rrcConnectionSetup_r8;      /* RRCConnectionSetup_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_38;  /* T_criticalExtensionsFuture_38 */
static int hf_lte_rrc_nonCriticalExtension_171;   /* RRCConnectionSetup_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_172;   /* RRCConnectionSetup_v1610_IEs */
static int hf_lte_rrc_dedicatedInfoNAS_r16;       /* DedicatedInfoNAS */
static int hf_lte_rrc_nonCriticalExtension_173;   /* T_nonCriticalExtension_45 */
static int hf_lte_rrc_criticalExtensions_41;      /* T_criticalExtensions_41 */
static int hf_lte_rrc_c1_36;                      /* T_c1_36 */
static int hf_lte_rrc_rrcConnectionSetupComplete_r8;  /* RRCConnectionSetupComplete_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_39;  /* T_criticalExtensionsFuture_39 */
static int hf_lte_rrc_selectedPLMN_Identity;      /* INTEGER_1_maxPLMN_r11 */
static int hf_lte_rrc_registeredMME;              /* RegisteredMME */
static int hf_lte_rrc_nonCriticalExtension_174;   /* RRCConnectionSetupComplete_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_175;   /* RRCConnectionSetupComplete_v1020_IEs */
static int hf_lte_rrc_gummei_Type_r10;            /* T_gummei_Type_r10 */
static int hf_lte_rrc_rlf_InfoAvailable_r10_01;   /* T_rlf_InfoAvailable_r10_01 */
static int hf_lte_rrc_logMeasAvailable_r10_02;    /* T_logMeasAvailable_r10_02 */
static int hf_lte_rrc_rn_SubframeConfigReq_r10;   /* T_rn_SubframeConfigReq_r10 */
static int hf_lte_rrc_nonCriticalExtension_176;   /* RRCConnectionSetupComplete_v1130_IEs */
static int hf_lte_rrc_connEstFailInfoAvailable_r11_02;  /* T_connEstFailInfoAvailable_r11_02 */
static int hf_lte_rrc_nonCriticalExtension_177;   /* RRCConnectionSetupComplete_v1250_IEs */
static int hf_lte_rrc_mobilityState_r12;          /* T_mobilityState_r12 */
static int hf_lte_rrc_mobilityHistoryAvail_r12;   /* T_mobilityHistoryAvail_r12 */
static int hf_lte_rrc_logMeasAvailableMBSFN_r12_02;  /* T_logMeasAvailableMBSFN_r12_02 */
static int hf_lte_rrc_nonCriticalExtension_178;   /* RRCConnectionSetupComplete_v1320_IEs */
static int hf_lte_rrc_ce_ModeB_r13;               /* T_ce_ModeB_r13 */
static int hf_lte_rrc_s_TMSI_r13;                 /* S_TMSI */
static int hf_lte_rrc_attachWithoutPDN_Connectivity_r13;  /* T_attachWithoutPDN_Connectivity_r13 */
static int hf_lte_rrc_up_CIoT_EPS_Optimisation_r13;  /* T_up_CIoT_EPS_Optimisation_r13 */
static int hf_lte_rrc_cp_CIoT_EPS_Optimisation_r13;  /* T_cp_CIoT_EPS_Optimisation_r13 */
static int hf_lte_rrc_nonCriticalExtension_179;   /* RRCConnectionSetupComplete_v1330_IEs */
static int hf_lte_rrc_ue_CE_NeedULGaps_r13;       /* T_ue_CE_NeedULGaps_r13 */
static int hf_lte_rrc_nonCriticalExtension_180;   /* RRCConnectionSetupComplete_v1430_IEs */
static int hf_lte_rrc_dcn_ID_r14;                 /* INTEGER_0_65535 */
static int hf_lte_rrc_nonCriticalExtension_181;   /* RRCConnectionSetupComplete_v1530_IEs */
static int hf_lte_rrc_logMeasAvailableBT_r15_03;  /* T_logMeasAvailableBT_r15_03 */
static int hf_lte_rrc_logMeasAvailableWLAN_r15_03;  /* T_logMeasAvailableWLAN_r15_03 */
static int hf_lte_rrc_idleMeasAvailable_r15_01;   /* T_idleMeasAvailable_r15_01 */
static int hf_lte_rrc_flightPathInfoAvailable_r15_03;  /* T_flightPathInfoAvailable_r15_03 */
static int hf_lte_rrc_connectTo5GC_r15;           /* T_connectTo5GC_r15 */
static int hf_lte_rrc_registeredAMF_r15;          /* RegisteredAMF_r15 */
static int hf_lte_rrc_s_NSSAI_list_r15;           /* SEQUENCE_SIZE_1_maxNrofS_NSSAI_r15_OF_S_NSSAI_r15 */
static int hf_lte_rrc_s_NSSAI_list_r15_item;      /* S_NSSAI_r15 */
static int hf_lte_rrc_ng_5G_S_TMSI_Bits_r15;      /* T_ng_5G_S_TMSI_Bits_r15 */
static int hf_lte_rrc_ng_5G_S_TMSI_Part2_r15;     /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_nonCriticalExtension_182;   /* RRCConnectionSetupComplete_v1540_IEs */
static int hf_lte_rrc_gummei_Type_v1540;          /* T_gummei_Type_v1540 */
static int hf_lte_rrc_guami_Type_r15;             /* T_guami_Type_r15 */
static int hf_lte_rrc_nonCriticalExtension_183;   /* RRCConnectionSetupComplete_v1610_IEs */
static int hf_lte_rrc_rlos_Request_r16;           /* T_rlos_Request_r16 */
static int hf_lte_rrc_cp_CIoT_5GS_Optimisation_r16;  /* T_cp_CIoT_5GS_Optimisation_r16 */
static int hf_lte_rrc_up_CIoT_5GS_Optimisation_r16;  /* T_up_CIoT_5GS_Optimisation_r16 */
static int hf_lte_rrc_pur_ConfigID_r16;           /* PUR_ConfigID_r16 */
static int hf_lte_rrc_lte_M_r16;                  /* T_lte_M_r16 */
static int hf_lte_rrc_iab_NodeIndication_r16;     /* T_iab_NodeIndication_r16 */
static int hf_lte_rrc_nonCriticalExtension_184;   /* RRCConnectionSetupComplete_v1690_IEs */
static int hf_lte_rrc_ul_RRC_Segmentation_r16;    /* T_ul_RRC_Segmentation_r16 */
static int hf_lte_rrc_nonCriticalExtension_185;   /* RRCConnectionSetupComplete_v1710_IEs */
static int hf_lte_rrc_nonCriticalExtension_186;   /* RRCConnectionSetupComplete_v1800_IEs */
static int hf_lte_rrc_nonCriticalExtension_187;   /* T_nonCriticalExtension_46 */
static int hf_lte_rrc_plmn_Identity;              /* PLMN_Identity */
static int hf_lte_rrc_mmegi;                      /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_mmec;                       /* MMEC */
static int hf_lte_rrc_amf_Identifier_r15;         /* AMF_Identifier_r15 */
static int hf_lte_rrc_criticalExtensions_42;      /* T_criticalExtensions_42 */
static int hf_lte_rrc_rrcEarlyDataComplete_r15_01;  /* RRCEarlyDataComplete_r15_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_40;  /* T_criticalExtensionsFuture_40 */
static int hf_lte_rrc_dedicatedInfoNAS_r15;       /* DedicatedInfoNAS */
static int hf_lte_rrc_extendedWaitTime_r15;       /* INTEGER_1_1800 */
static int hf_lte_rrc_idleModeMobilityControlInfo_r15;  /* IdleModeMobilityControlInfo */
static int hf_lte_rrc_idleModeMobilityControlInfoExt_r15;  /* IdleModeMobilityControlInfo_v9e0 */
static int hf_lte_rrc_redirectedCarrierInfo_r15;  /* RedirectedCarrierInfo_r15_IEs */
static int hf_lte_rrc_nonCriticalExtension_188;   /* RRCEarlyDataComplete_v1590_IEs */
static int hf_lte_rrc_nonCriticalExtension_189;   /* T_nonCriticalExtension_47 */
static int hf_lte_rrc_eutra_01;                   /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_utra_TDD_01;                /* CarrierFreqListUTRA_TDD_r10 */
static int hf_lte_rrc_criticalExtensions_43;      /* T_criticalExtensions_43 */
static int hf_lte_rrc_rrcEarlyDataRequest_r15_01;  /* RRCEarlyDataRequest_r15_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_41;  /* T_criticalExtensionsFuture_41 */
static int hf_lte_rrc_rrcEarlyDataRequest_5GC_r16;  /* RRCEarlyDataRequest_5GC_r16_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_r16;  /* T_criticalExtensionsFuture_r16 */
static int hf_lte_rrc_s_TMSI_r15;                 /* S_TMSI */
static int hf_lte_rrc_establishmentCause_r15_01;  /* T_establishmentCause_r15 */
static int hf_lte_rrc_nonCriticalExtension_190;   /* RRCEarlyDataRequest_v1590_IEs */
static int hf_lte_rrc_nonCriticalExtension_191;   /* RRCEarlyDataRequest_v1610_IEs */
static int hf_lte_rrc_establishmentCause_v1610;   /* T_establishmentCause_v1610 */
static int hf_lte_rrc_nonCriticalExtension_192;   /* T_nonCriticalExtension_48 */
static int hf_lte_rrc_ng_5G_S_TMSI_r16;           /* NG_5G_S_TMSI_r15 */
static int hf_lte_rrc_establishmentCause_r16;     /* T_establishmentCause_r16 */
static int hf_lte_rrc_nonCriticalExtension_193;   /* T_nonCriticalExtension_49 */
static int hf_lte_rrc_criticalExtensions_44;      /* T_criticalExtensions_44 */
static int hf_lte_rrc_c1_37;                      /* T_c1_37 */
static int hf_lte_rrc_scgFailureInformation_r12_01;  /* SCGFailureInformation_r12_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_42;  /* T_criticalExtensionsFuture_42 */
static int hf_lte_rrc_failureReportSCG_r12;       /* FailureReportSCG_r12 */
static int hf_lte_rrc_nonCriticalExtension_194;   /* SCGFailureInformation_v12d0a_IEs */
static int hf_lte_rrc_lateNonCriticalExtension_05;  /* T_lateNonCriticalExtension_04 */
static int hf_lte_rrc_nonCriticalExtension_195;   /* T_nonCriticalExtension_50 */
static int hf_lte_rrc_failureReportSCG_v12d0;     /* FailureReportSCG_v12d0 */
static int hf_lte_rrc_nonCriticalExtension_196;   /* T_nonCriticalExtension_51 */
static int hf_lte_rrc_failureType_r12;            /* T_failureType_r12 */
static int hf_lte_rrc_measResultServFreqList_r12;  /* MeasResultServFreqList_r10 */
static int hf_lte_rrc_measResultNeighCells_r12;   /* MeasResultList2EUTRA_r9 */
static int hf_lte_rrc_failureType_v1290;          /* T_failureType_v1290 */
static int hf_lte_rrc_measResultServFreqListExt_r13;  /* MeasResultServFreqListExt_r13 */
static int hf_lte_rrc_measResultNeighCells_v12d0;  /* MeasResultList2EUTRA_v9e0 */
static int hf_lte_rrc_criticalExtensions_45;      /* T_criticalExtensions_45 */
static int hf_lte_rrc_c1_38;                      /* T_c1_38 */
static int hf_lte_rrc_scgFailureInformationNR_r15_01;  /* SCGFailureInformationNR_r15_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_43;  /* T_criticalExtensionsFuture_43 */
static int hf_lte_rrc_failureReportSCG_NR_r15;    /* FailureReportSCG_NR_r15 */
static int hf_lte_rrc_nonCriticalExtension_197;   /* SCGFailureInformationNR_v1590_IEs */
static int hf_lte_rrc_nonCriticalExtension_198;   /* T_nonCriticalExtension_52 */
static int hf_lte_rrc_failureType_r15;            /* T_failureType_r15 */
static int hf_lte_rrc_measResultFreqListNR_r15;   /* MeasResultFreqListFailNR_r15 */
static int hf_lte_rrc_measResultSCG_r15;          /* T_measResultSCG_r15 */
static int hf_lte_rrc_locationInfo_r16;           /* LocationInfo_r10 */
static int hf_lte_rrc_logMeasResultListBT_r16;    /* LogMeasResultListBT_r15 */
static int hf_lte_rrc_logMeasResultListWLAN_r16;  /* LogMeasResultListWLAN_r15 */
static int hf_lte_rrc_failureType_v1610;          /* T_failureType_v1610 */
static int hf_lte_rrc_MeasResultFreqListFailNR_r15_item;  /* MeasResultFreqFailNR_r15 */
static int hf_lte_rrc_measResultCellList_r15;     /* MeasResultCellListNR_r15 */
static int hf_lte_rrc_sc_mtch_InfoList_r13;       /* SC_MTCH_InfoList_r13 */
static int hf_lte_rrc_scptm_NeighbourCellList_r13;  /* SCPTM_NeighbourCellList_r13 */
static int hf_lte_rrc_nonCriticalExtension_199;   /* SCPTMConfiguration_v1340 */
static int hf_lte_rrc_p_b_r13;                    /* INTEGER_0_3 */
static int hf_lte_rrc_nonCriticalExtension_200;   /* T_nonCriticalExtension_53 */
static int hf_lte_rrc_sc_mtch_InfoList_r14;       /* SC_MTCH_InfoList_BR_r14 */
static int hf_lte_rrc_scptm_NeighbourCellList_r14;  /* SCPTM_NeighbourCellList_r13 */
static int hf_lte_rrc_p_b_r14;                    /* INTEGER_0_3 */
static int hf_lte_rrc_nonCriticalExtension_201;   /* SCPTMConfiguration_BR_v1610 */
static int hf_lte_rrc_sc_MTCH_InfoList_MultiTB_r16;  /* SC_MTCH_InfoList_BR_r14 */
static int hf_lte_rrc_multiTB_Gap_r16;            /* T_multiTB_Gap_r16 */
static int hf_lte_rrc_nonCriticalExtension_202;   /* T_nonCriticalExtension_54 */
static int hf_lte_rrc_criticalExtensions_46;      /* T_criticalExtensions_46 */
static int hf_lte_rrc_c1_39;                      /* T_c1_39 */
static int hf_lte_rrc_securityModeCommand_r8;     /* SecurityModeCommand_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_44;  /* T_criticalExtensionsFuture_44 */
static int hf_lte_rrc_securityConfigSMC;          /* SecurityConfigSMC */
static int hf_lte_rrc_nonCriticalExtension_203;   /* SecurityModeCommand_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_204;   /* T_nonCriticalExtension_55 */
static int hf_lte_rrc_criticalExtensions_47;      /* T_criticalExtensions_47 */
static int hf_lte_rrc_securityModeComplete_r8;    /* SecurityModeComplete_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_45;  /* T_criticalExtensionsFuture_45 */
static int hf_lte_rrc_nonCriticalExtension_205;   /* SecurityModeComplete_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_206;   /* T_nonCriticalExtension_56 */
static int hf_lte_rrc_criticalExtensions_48;      /* T_criticalExtensions_48 */
static int hf_lte_rrc_securityModeFailure_r8;     /* SecurityModeFailure_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_46;  /* T_criticalExtensionsFuture_46 */
static int hf_lte_rrc_nonCriticalExtension_207;   /* SecurityModeFailure_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_208;   /* T_nonCriticalExtension_57 */
static int hf_lte_rrc_criticalExtensions_49;      /* T_criticalExtensions_49 */
static int hf_lte_rrc_c1_40;                      /* T_c1_40 */
static int hf_lte_rrc_sidelinkUEInformation_r12_02;  /* SidelinkUEInformation_r12_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_47;  /* T_criticalExtensionsFuture_47 */
static int hf_lte_rrc_commRxInterestedFreq_r12;   /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_commTxResourceReq_r12;      /* SL_CommTxResourceReq_r12 */
static int hf_lte_rrc_discRxInterest_r12;         /* T_discRxInterest_r12 */
static int hf_lte_rrc_discTxResourceReq_r12;      /* INTEGER_1_63 */
static int hf_lte_rrc_nonCriticalExtension_209;   /* SidelinkUEInformation_v1310_IEs */
static int hf_lte_rrc_commTxResourceReqUC_r13;    /* SL_CommTxResourceReq_r12 */
static int hf_lte_rrc_commTxResourceInfoReqRelay_r13;  /* T_commTxResourceInfoReqRelay_r13 */
static int hf_lte_rrc_commTxResourceReqRelay_r13;  /* SL_CommTxResourceReq_r12 */
static int hf_lte_rrc_commTxResourceReqRelayUC_r13;  /* SL_CommTxResourceReq_r12 */
static int hf_lte_rrc_ue_Type_r13;                /* T_ue_Type_r13 */
static int hf_lte_rrc_discTxResourceReq_v1310;    /* T_discTxResourceReq_v1310 */
static int hf_lte_rrc_carrierFreqDiscTx_r13;      /* INTEGER_1_maxFreq */
static int hf_lte_rrc_discTxResourceReqAddFreq_r13;  /* SL_DiscTxResourceReqPerFreqList_r13 */
static int hf_lte_rrc_discTxResourceReqPS_r13;    /* SL_DiscTxResourceReq_r13 */
static int hf_lte_rrc_discRxGapReq_r13;           /* SL_GapRequest_r13 */
static int hf_lte_rrc_discTxGapReq_r13;           /* SL_GapRequest_r13 */
static int hf_lte_rrc_discSysInfoReportFreqList_r13;  /* SL_DiscSysInfoReportFreqList_r13 */
static int hf_lte_rrc_nonCriticalExtension_210;   /* SidelinkUEInformation_v1430_IEs */
static int hf_lte_rrc_v2x_CommRxInterestedFreqList_r14;  /* SL_V2X_CommFreqList_r14 */
static int hf_lte_rrc_p2x_CommTxType_r14;         /* T_p2x_CommTxType_r14 */
static int hf_lte_rrc_v2x_CommTxResourceReq_r14;  /* SL_V2X_CommTxFreqList_r14 */
static int hf_lte_rrc_nonCriticalExtension_211;   /* SidelinkUEInformation_v1530_IEs */
static int hf_lte_rrc_reliabilityInfoListSL_r15;  /* SL_ReliabilityList_r15 */
static int hf_lte_rrc_nonCriticalExtension_212;   /* T_nonCriticalExtension_58 */
static int hf_lte_rrc_destinationInfoList_r12;    /* SL_DestinationInfoList_r12 */
static int hf_lte_rrc_SL_DiscTxResourceReqPerFreqList_r13_item;  /* SL_DiscTxResourceReq_r13 */
static int hf_lte_rrc_discTxResourceReq_r13;      /* INTEGER_1_63 */
static int hf_lte_rrc_SL_DestinationInfoList_r12_item;  /* SL_DestinationIdentity_r12 */
static int hf_lte_rrc_SL_DiscSysInfoReportFreqList_r13_item;  /* SL_DiscSysInfoReport_r13 */
static int hf_lte_rrc_SL_V2X_CommFreqList_r14_item;  /* INTEGER_0_maxFreqV2X_1_r14 */
static int hf_lte_rrc_SL_V2X_CommTxFreqList_r14_item;  /* SL_V2X_CommTxResourceReq_r14 */
static int hf_lte_rrc_carrierFreqCommTx_r14;      /* INTEGER_0_maxFreqV2X_1_r14 */
static int hf_lte_rrc_v2x_TypeTxSync_r14;         /* SL_TypeTxSync_r14 */
static int hf_lte_rrc_v2x_DestinationInfoList_r14;  /* SL_DestinationInfoList_r12 */
static int hf_lte_rrc_criticalExtensions_50;      /* T_criticalExtensions_50 */
static int hf_lte_rrc_systemInformation_r8;       /* SystemInformation_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_r15;  /* T_criticalExtensionsFuture_r15 */
static int hf_lte_rrc_posSystemInformation_r15;   /* PosSystemInformation_r15_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_48;  /* T_criticalExtensionsFuture_48 */
static int hf_lte_rrc_sib_TypeAndInfo;            /* T_sib_TypeAndInfo */
static int hf_lte_rrc_sib_TypeAndInfo_item;       /* T_sib_TypeAndInfo_item */
static int hf_lte_rrc_sib2;                       /* SystemInformationBlockType2 */
static int hf_lte_rrc_sib3;                       /* SystemInformationBlockType3 */
static int hf_lte_rrc_sib4;                       /* SystemInformationBlockType4 */
static int hf_lte_rrc_sib5;                       /* SystemInformationBlockType5 */
static int hf_lte_rrc_sib6;                       /* SystemInformationBlockType6 */
static int hf_lte_rrc_sib7;                       /* SystemInformationBlockType7 */
static int hf_lte_rrc_sib8;                       /* SystemInformationBlockType8 */
static int hf_lte_rrc_sib9;                       /* SystemInformationBlockType9 */
static int hf_lte_rrc_sib10;                      /* SystemInformationBlockType10 */
static int hf_lte_rrc_sib11;                      /* SystemInformationBlockType11 */
static int hf_lte_rrc_sib12_v920;                 /* SystemInformationBlockType12_r9 */
static int hf_lte_rrc_sib13_v920;                 /* SystemInformationBlockType13_r9 */
static int hf_lte_rrc_sib14_v1130;                /* SystemInformationBlockType14_r11 */
static int hf_lte_rrc_sib15_v1130;                /* SystemInformationBlockType15_r11 */
static int hf_lte_rrc_sib16_v1130;                /* SystemInformationBlockType16_r11 */
static int hf_lte_rrc_sib17_v1250;                /* SystemInformationBlockType17_r12 */
static int hf_lte_rrc_sib18_v1250;                /* SystemInformationBlockType18_r12 */
static int hf_lte_rrc_sib19_v1250;                /* SystemInformationBlockType19_r12 */
static int hf_lte_rrc_sib20_v1310;                /* SystemInformationBlockType20_r13 */
static int hf_lte_rrc_sib21_v1430;                /* SystemInformationBlockType21_r14 */
static int hf_lte_rrc_sib24_v1530;                /* SystemInformationBlockType24_r15 */
static int hf_lte_rrc_sib25_v1530;                /* SystemInformationBlockType25_r15 */
static int hf_lte_rrc_sib26_v1530;                /* SystemInformationBlockType26_r15 */
static int hf_lte_rrc_sib26a_v1610;               /* SystemInformationBlockType26a_r16 */
static int hf_lte_rrc_sib27_v1610;                /* SystemInformationBlockType27_r16 */
static int hf_lte_rrc_sib28_v1610;                /* SystemInformationBlockType28_r16 */
static int hf_lte_rrc_sib29_v1610;                /* SystemInformationBlockType29_r16 */
static int hf_lte_rrc_sib30_v1700;                /* SystemInformationBlockType30_r17 */
static int hf_lte_rrc_sib31_v1700;                /* SystemInformationBlockType31_r17 */
static int hf_lte_rrc_sib32_v1700;                /* SystemInformationBlockType32_r17 */
static int hf_lte_rrc_sib33_v1800;                /* SystemInformationBlockType33_r18 */
static int hf_lte_rrc_nonCriticalExtension_213;   /* SystemInformation_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_214;   /* T_nonCriticalExtension_59 */
static int hf_lte_rrc_posSIB_TypeAndInfo_r15;     /* T_posSIB_TypeAndInfo_r15 */
static int hf_lte_rrc_posSIB_TypeAndInfo_r15_item;  /* T_posSIB_TypeAndInfo_r15_item */
static int hf_lte_rrc_posSib1_1_r15;              /* T_posSib1_1_r15 */
static int hf_lte_rrc_posSib1_2_r15;              /* T_posSib1_2_r15 */
static int hf_lte_rrc_posSib1_3_r15;              /* T_posSib1_3_r15 */
static int hf_lte_rrc_posSib1_4_r15;              /* T_posSib1_4_r15 */
static int hf_lte_rrc_posSib1_5_r15;              /* T_posSib1_5_r15 */
static int hf_lte_rrc_posSib1_6_r15;              /* T_posSib1_6_r15 */
static int hf_lte_rrc_posSib1_7_r15;              /* T_posSib1_7_r15 */
static int hf_lte_rrc_posSib2_1_r15;              /* T_posSib2_1_r15 */
static int hf_lte_rrc_posSib2_2_r15;              /* T_posSib2_2_r15 */
static int hf_lte_rrc_posSib2_3_r15;              /* T_posSib2_3_r15 */
static int hf_lte_rrc_posSib2_4_r15;              /* T_posSib2_4_r15 */
static int hf_lte_rrc_posSib2_5_r15;              /* T_posSib2_5_r15 */
static int hf_lte_rrc_posSib2_6_r15;              /* T_posSib2_6_r15 */
static int hf_lte_rrc_posSib2_7_r15;              /* T_posSib2_7_r15 */
static int hf_lte_rrc_posSib2_8_r15;              /* T_posSib2_8_r15 */
static int hf_lte_rrc_posSib2_9_r15;              /* T_posSib2_9_r15 */
static int hf_lte_rrc_posSib2_10_r15;             /* T_posSib2_10_r15 */
static int hf_lte_rrc_posSib2_11_r15;             /* T_posSib2_11_r15 */
static int hf_lte_rrc_posSib2_12_r15;             /* T_posSib2_12_r15 */
static int hf_lte_rrc_posSib2_13_r15;             /* T_posSib2_13_r15 */
static int hf_lte_rrc_posSib2_14_r15;             /* T_posSib2_14_r15 */
static int hf_lte_rrc_posSib2_15_r15;             /* T_posSib2_15_r15 */
static int hf_lte_rrc_posSib2_16_r15;             /* T_posSib2_16_r15 */
static int hf_lte_rrc_posSib2_17_r15;             /* T_posSib2_17_r15 */
static int hf_lte_rrc_posSib2_18_r15;             /* T_posSib2_18_r15 */
static int hf_lte_rrc_posSib2_19_r15;             /* T_posSib2_19_r15 */
static int hf_lte_rrc_posSib3_1_r15;              /* T_posSib3_1_r15 */
static int hf_lte_rrc_posSib1_8_v1610;            /* T_posSib1_8_v1610 */
static int hf_lte_rrc_posSib2_20_v1610;           /* T_posSib2_20_v1610 */
static int hf_lte_rrc_posSib2_21_v1610;           /* T_posSib2_21_v1610 */
static int hf_lte_rrc_posSib2_22_v1610;           /* T_posSib2_22_v1610 */
static int hf_lte_rrc_posSib2_23_v1610;           /* T_posSib2_23_v1610 */
static int hf_lte_rrc_posSib2_24_v1610;           /* T_posSib2_24_v1610 */
static int hf_lte_rrc_posSib2_25_v1610;           /* T_posSib2_25_v1610 */
static int hf_lte_rrc_posSib4_1_v1610;            /* T_posSib4_1_v1610 */
static int hf_lte_rrc_posSib5_1_v1610;            /* T_posSib5_1_v1610 */
static int hf_lte_rrc_posSib1_9_v1700;            /* T_posSib1_9_v1700 */
static int hf_lte_rrc_posSib1_10_v1700;           /* T_posSib1_10_v1700 */
static int hf_lte_rrc_posSib2_17a_v1770;          /* T_posSib2_17a_v1770 */
static int hf_lte_rrc_posSib2_18a_v1770;          /* T_posSib2_18a_v1770 */
static int hf_lte_rrc_posSib2_20a_v1770;          /* T_posSib2_20a_v1770 */
static int hf_lte_rrc_posSib1_11_v1800;           /* T_posSib1_11_v1800 */
static int hf_lte_rrc_posSib1_12_v1800;           /* T_posSib1_12_v1800 */
static int hf_lte_rrc_posSib2_26_v1800;           /* T_posSib2_26_v1800 */
static int hf_lte_rrc_posSib2_27_v1800;           /* T_posSib2_27_v1800 */
static int hf_lte_rrc_nonCriticalExtension_215;   /* T_nonCriticalExtension_60 */
static int hf_lte_rrc_cellAccessRelatedInfo;      /* T_cellAccessRelatedInfo */
static int hf_lte_rrc_plmn_IdentityList;          /* PLMN_IdentityList */
static int hf_lte_rrc_trackingAreaCode;           /* TrackingAreaCode */
static int hf_lte_rrc_cellBarred;                 /* T_cellBarred */
static int hf_lte_rrc_intraFreqReselection;       /* T_intraFreqReselection */
static int hf_lte_rrc_csg_Indication;             /* BOOLEAN */
static int hf_lte_rrc_csg_Identity;               /* CSG_Identity */
static int hf_lte_rrc_cellSelectionInfo;          /* T_cellSelectionInfo */
static int hf_lte_rrc_q_RxLevMin;                 /* Q_RxLevMin */
static int hf_lte_rrc_q_RxLevMinOffset;           /* INTEGER_1_8 */
static int hf_lte_rrc_p_Max;                      /* P_Max */
static int hf_lte_rrc_freqBandIndicator;          /* FreqBandIndicator */
static int hf_lte_rrc_schedulingInfoList;         /* SchedulingInfoList */
static int hf_lte_rrc_tdd_Config;                 /* TDD_Config */
static int hf_lte_rrc_si_WindowLength;            /* T_si_WindowLength */
static int hf_lte_rrc_systemInfoValueTag;         /* T_systemInfoValueTag */
static int hf_lte_rrc_nonCriticalExtension_216;   /* SystemInformationBlockType1_v890_IEs */
static int hf_lte_rrc_lateNonCriticalExtension_06;  /* T_lateNonCriticalExtension_05 */
static int hf_lte_rrc_nonCriticalExtension_217;   /* SystemInformationBlockType1_v920_IEs */
static int hf_lte_rrc_multiBandInfoList;          /* MultiBandInfoList */
static int hf_lte_rrc_nonCriticalExtension_218;   /* SystemInformationBlockType1_v9e0_IEs */
static int hf_lte_rrc_freqBandIndicator_v9e0;     /* FreqBandIndicator_v9e0 */
static int hf_lte_rrc_multiBandInfoList_v9e0;     /* MultiBandInfoList_v9e0 */
static int hf_lte_rrc_nonCriticalExtension_219;   /* SystemInformationBlockType1_v10j0_IEs */
static int hf_lte_rrc_freqBandInfo_r10;           /* NS_PmaxList_r10 */
static int hf_lte_rrc_multiBandInfoList_v10j0;    /* MultiBandInfoList_v10j0 */
static int hf_lte_rrc_nonCriticalExtension_220;   /* SystemInformationBlockType1_v10l0_IEs */
static int hf_lte_rrc_freqBandInfo_v10l0;         /* NS_PmaxList_v10l0 */
static int hf_lte_rrc_multiBandInfoList_v10l0;    /* MultiBandInfoList_v10l0 */
static int hf_lte_rrc_nonCriticalExtension_221;   /* SystemInformationBlockType1_v10x0_IEs */
static int hf_lte_rrc_nonCriticalExtension_222;   /* SystemInformationBlockType1_v12j0_IEs */
static int hf_lte_rrc_schedulingInfoList_v12j0;   /* SchedulingInfoList_v12j0 */
static int hf_lte_rrc_schedulingInfoListExt_r12;  /* SchedulingInfoListExt_r12 */
static int hf_lte_rrc_nonCriticalExtension_223;   /* SystemInformationBlockType1_v15g0_IEs */
static int hf_lte_rrc_bandwidthReducedAccessRelatedInfo_v15g0;  /* T_bandwidthReducedAccessRelatedInfo_v15g0 */
static int hf_lte_rrc_posSchedulingInfoList_BR_r15;  /* SchedulingInfoList_BR_r13 */
static int hf_lte_rrc_nonCriticalExtension_224;   /* T_nonCriticalExtension_61 */
static int hf_lte_rrc_ims_EmergencySupport_r9;    /* T_ims_EmergencySupport_r9 */
static int hf_lte_rrc_cellSelectionInfo_v920;     /* CellSelectionInfo_v920 */
static int hf_lte_rrc_nonCriticalExtension_225;   /* SystemInformationBlockType1_v1130_IEs */
static int hf_lte_rrc_tdd_Config_v1130;           /* TDD_Config_v1130 */
static int hf_lte_rrc_cellSelectionInfo_v1130;    /* CellSelectionInfo_v1130 */
static int hf_lte_rrc_nonCriticalExtension_226;   /* SystemInformationBlockType1_v1250_IEs */
static int hf_lte_rrc_cellAccessRelatedInfo_v1250;  /* T_cellAccessRelatedInfo_v1250 */
static int hf_lte_rrc_category0Allowed_r12;       /* T_category0Allowed_r12 */
static int hf_lte_rrc_cellSelectionInfo_v1250;    /* CellSelectionInfo_v1250 */
static int hf_lte_rrc_freqBandIndicatorPriority_r12;  /* T_freqBandIndicatorPriority_r12 */
static int hf_lte_rrc_nonCriticalExtension_227;   /* SystemInformationBlockType1_v1310_IEs */
static int hf_lte_rrc_hyperSFN_r13;               /* BIT_STRING_SIZE_10 */
static int hf_lte_rrc_eDRX_Allowed_r13;           /* T_eDRX_Allowed_r13 */
static int hf_lte_rrc_cellSelectionInfoCE_r13;    /* CellSelectionInfoCE_r13 */
static int hf_lte_rrc_bandwidthReducedAccessRelatedInfo_r13;  /* T_bandwidthReducedAccessRelatedInfo_r13 */
static int hf_lte_rrc_si_WindowLength_BR_r13;     /* T_si_WindowLength_BR_r13 */
static int hf_lte_rrc_si_RepetitionPattern_r13;   /* T_si_RepetitionPattern_r13 */
static int hf_lte_rrc_schedulingInfoList_BR_r13;  /* SchedulingInfoList_BR_r13 */
static int hf_lte_rrc_fdd_DownlinkOrTddSubframeBitmapBR_r13;  /* T_fdd_DownlinkOrTddSubframeBitmapBR_r13 */
static int hf_lte_rrc_subframePattern10_r13;      /* BIT_STRING_SIZE_10 */
static int hf_lte_rrc_subframePattern40_r13;      /* BIT_STRING_SIZE_40 */
static int hf_lte_rrc_fdd_UplinkSubframeBitmapBR_r13;  /* BIT_STRING_SIZE_10 */
static int hf_lte_rrc_startSymbolBR_r13;          /* INTEGER_1_4 */
static int hf_lte_rrc_si_HoppingConfigCommon_r13;  /* T_si_HoppingConfigCommon_r13 */
static int hf_lte_rrc_si_ValidityTime_r13;        /* T_si_ValidityTime_r13 */
static int hf_lte_rrc_systemInfoValueTagList_r13;  /* SystemInfoValueTagList_r13 */
static int hf_lte_rrc_nonCriticalExtension_228;   /* SystemInformationBlockType1_v1320_IEs */
static int hf_lte_rrc_freqHoppingParametersDL_r13;  /* T_freqHoppingParametersDL_r13 */
static int hf_lte_rrc_mpdcch_pdsch_HoppingNB_r13;  /* T_mpdcch_pdsch_HoppingNB_r13 */
static int hf_lte_rrc_interval_DLHoppingConfigCommonModeA_r13;  /* T_interval_DLHoppingConfigCommonModeA_r13 */
static int hf_lte_rrc_interval_FDD_r13;           /* T_interval_FDD_r13 */
static int hf_lte_rrc_interval_TDD_r13;           /* T_interval_TDD_r13 */
static int hf_lte_rrc_interval_DLHoppingConfigCommonModeB_r13;  /* T_interval_DLHoppingConfigCommonModeB_r13 */
static int hf_lte_rrc_interval_FDD_r13_01;        /* T_interval_FDD_r13_01 */
static int hf_lte_rrc_interval_TDD_r13_01;        /* T_interval_TDD_r13_01 */
static int hf_lte_rrc_mpdcch_pdsch_HoppingOffset_r13;  /* INTEGER_1_maxAvailNarrowBands_r13 */
static int hf_lte_rrc_nonCriticalExtension_229;   /* SystemInformationBlockType1_v1350_IEs */
static int hf_lte_rrc_cellSelectionInfoCE1_r13;   /* CellSelectionInfoCE1_r13 */
static int hf_lte_rrc_nonCriticalExtension_230;   /* SystemInformationBlockType1_v1360_IEs */
static int hf_lte_rrc_cellSelectionInfoCE1_v1360;  /* CellSelectionInfoCE1_v1360 */
static int hf_lte_rrc_nonCriticalExtension_231;   /* SystemInformationBlockType1_v1430_IEs */
static int hf_lte_rrc_eCallOverIMS_Support_r14;   /* T_eCallOverIMS_Support_r14 */
static int hf_lte_rrc_tdd_Config_v1430;           /* TDD_Config_v1430 */
static int hf_lte_rrc_cellAccessRelatedInfoList_r14;  /* SEQUENCE_SIZE_1_maxPLMN_1_r14_OF_CellAccessRelatedInfo_r14 */
static int hf_lte_rrc_cellAccessRelatedInfoList_r14_item;  /* CellAccessRelatedInfo_r14 */
static int hf_lte_rrc_nonCriticalExtension_232;   /* SystemInformationBlockType1_v1450_IEs */
static int hf_lte_rrc_tdd_Config_v1450;           /* TDD_Config_v1450 */
static int hf_lte_rrc_nonCriticalExtension_233;   /* SystemInformationBlockType1_v1530_IEs */
static int hf_lte_rrc_hsdn_Cell_r15;              /* T_hsdn_Cell_r15 */
static int hf_lte_rrc_cellSelectionInfoCE_v1530;  /* CellSelectionInfoCE_v1530 */
static int hf_lte_rrc_crs_IntfMitigConfig_r15;    /* T_crs_IntfMitigConfig_r15 */
static int hf_lte_rrc_crs_IntfMitigEnabled;       /* NULL */
static int hf_lte_rrc_crs_IntfMitigNumPRBs;       /* T_crs_IntfMitigNumPRBs */
static int hf_lte_rrc_cellBarred_CRS_r15;         /* T_cellBarred_CRS_r15 */
static int hf_lte_rrc_plmn_IdentityList_v1530;    /* PLMN_IdentityList_v1530 */
static int hf_lte_rrc_posSchedulingInfoList_r15;  /* PosSchedulingInfoList_r15 */
static int hf_lte_rrc_cellAccessRelatedInfo_5GC_r15;  /* T_cellAccessRelatedInfo_5GC_r15 */
static int hf_lte_rrc_cellBarred_5GC_r15;         /* T_cellBarred_5GC_r15 */
static int hf_lte_rrc_cellBarred_5GC_CRS_r15;     /* T_cellBarred_5GC_CRS_r15 */
static int hf_lte_rrc_cellAccessRelatedInfoList_5GC_r15;  /* SEQUENCE_SIZE_1_maxPLMN_r11_OF_CellAccessRelatedInfo_5GC_r15 */
static int hf_lte_rrc_cellAccessRelatedInfoList_5GC_r15_item;  /* CellAccessRelatedInfo_5GC_r15 */
static int hf_lte_rrc_ims_EmergencySupport5GC_r15;  /* T_ims_EmergencySupport5GC_r15 */
static int hf_lte_rrc_eCallOverIMS_Support5GC_r15;  /* T_eCallOverIMS_Support5GC_r15 */
static int hf_lte_rrc_nonCriticalExtension_234;   /* SystemInformationBlockType1_v1540_IEs */
static int hf_lte_rrc_si_posOffset_r15;           /* T_si_posOffset_r15 */
static int hf_lte_rrc_nonCriticalExtension_235;   /* SystemInformationBlockType1_v1610_IEs */
static int hf_lte_rrc_eDRX_Allowed_5GC_r16;       /* T_eDRX_Allowed_5GC_r16 */
static int hf_lte_rrc_transmissionInControlChRegion_r16;  /* T_transmissionInControlChRegion_r16 */
static int hf_lte_rrc_campingAllowedInCE_r16;     /* T_campingAllowedInCE_r16 */
static int hf_lte_rrc_plmn_IdentityList_v1610;    /* PLMN_IdentityList_v1610 */
static int hf_lte_rrc_nonCriticalExtension_236;   /* SystemInformationBlockType1_v1700_IEs */
static int hf_lte_rrc_cellAccessRelatedInfo_NTN_r17;  /* T_cellAccessRelatedInfo_NTN_r17 */
static int hf_lte_rrc_cellBarred_NTN_r17;         /* T_cellBarred_NTN_r17 */
static int hf_lte_rrc_plmn_IdentityList_v1700;    /* PLMN_IdentityList_v1700 */
static int hf_lte_rrc_nonCriticalExtension_237;   /* SystemInformationBlockType1_v1800_IEs */
static int hf_lte_rrc_freqBandIndicatorAerial_r18;  /* FreqBandIndicator_r11 */
static int hf_lte_rrc_freqBandInfoAerial_r18;     /* NS_PmaxListAerial_r18 */
static int hf_lte_rrc_multiBandInfoListAerial_r18;  /* MultiBandInfoListAerial_r18 */
static int hf_lte_rrc_nonCriticalExtension_238;   /* T_nonCriticalExtension_62 */
static int hf_lte_rrc_PLMN_IdentityList_item;     /* PLMN_IdentityInfo */
static int hf_lte_rrc_cellReservedForOperatorUse;  /* T_cellReservedForOperatorUse */
static int hf_lte_rrc_PLMN_IdentityList_v1530_item;  /* PLMN_IdentityInfo_v1530 */
static int hf_lte_rrc_cellReservedForOperatorUse_CRS_r15;  /* T_cellReservedForOperatorUse_CRS_r15 */
static int hf_lte_rrc_PLMN_IdentityList_r15_item;  /* PLMN_IdentityInfo_r15 */
static int hf_lte_rrc_PLMN_IdentityList_v1610_item;  /* PLMN_IdentityInfo_v1610 */
static int hf_lte_rrc_PLMN_IdentityList_v1700_item;  /* PLMN_IdentityInfo_v1700 */
static int hf_lte_rrc_plmn_Identity_5GC_r15;      /* T_plmn_Identity_5GC_r15 */
static int hf_lte_rrc_plmn_Index_r15;             /* INTEGER_1_maxPLMN_r11 */
static int hf_lte_rrc_cellReservedForOperatorUse_r15;  /* T_cellReservedForOperatorUse_r15 */
static int hf_lte_rrc_cellReservedForOperatorUse_CRS_r15_01;  /* T_cellReservedForOperatorUse_CRS_r15_01 */
static int hf_lte_rrc_cp_CIoT_5GS_Optimisation_r16_01;  /* T_cp_CIoT_5GS_Optimisation_r16_01 */
static int hf_lte_rrc_up_CIoT_5GS_Optimisation_r16_01;  /* T_up_CIoT_5GS_Optimisation_r16_01 */
static int hf_lte_rrc_iab_Support_r16;            /* T_iab_Support_r16 */
static int hf_lte_rrc_trackingAreaList_r17;       /* TrackingAreaList_r17 */
static int hf_lte_rrc_SchedulingInfoList_item;    /* SchedulingInfo */
static int hf_lte_rrc_SchedulingInfoList_v12j0_item;  /* SchedulingInfo_v12j0 */
static int hf_lte_rrc_SchedulingInfoListExt_r12_item;  /* SchedulingInfoExt_r12 */
static int hf_lte_rrc_si_Periodicity;             /* SI_Periodicity_r12 */
static int hf_lte_rrc_sib_MappingInfo;            /* SIB_MappingInfo */
static int hf_lte_rrc_sib_MappingInfo_v12j0;      /* SIB_MappingInfo_v12j0 */
static int hf_lte_rrc_si_Periodicity_r12;         /* SI_Periodicity_r12 */
static int hf_lte_rrc_sib_MappingInfo_r12;        /* SIB_MappingInfo_v12j0 */
static int hf_lte_rrc_SchedulingInfoList_BR_r13_item;  /* SchedulingInfo_BR_r13 */
static int hf_lte_rrc_si_Narrowband_r13;          /* INTEGER_1_maxAvailNarrowBands_r13 */
static int hf_lte_rrc_si_TBS_r13;                 /* T_si_TBS_r13 */
static int hf_lte_rrc_SIB_MappingInfo_item;       /* SIB_Type */
static int hf_lte_rrc_SIB_MappingInfo_v12j0_item;  /* SIB_Type_v12j0 */
static int hf_lte_rrc_SystemInfoValueTagList_r13_item;  /* SystemInfoValueTagSI_r13 */
static int hf_lte_rrc_q_QualMin_r9;               /* Q_QualMin_r9 */
static int hf_lte_rrc_q_QualMinOffset_r9;         /* INTEGER_1_8 */
static int hf_lte_rrc_q_QualMinWB_r11;            /* Q_QualMin_r9 */
static int hf_lte_rrc_q_QualMinRSRQ_OnAllSymbols_r12;  /* Q_QualMin_r9 */
static int hf_lte_rrc_plmn_IdentityList_r14;      /* PLMN_IdentityList */
static int hf_lte_rrc_trackingAreaCode_r14;       /* TrackingAreaCode */
static int hf_lte_rrc_cellIdentity_r14;           /* CellIdentity */
static int hf_lte_rrc_plmn_IdentityList_r15;      /* PLMN_IdentityList_r15 */
static int hf_lte_rrc_ran_AreaCode_r15;           /* RAN_AreaCode_r15 */
static int hf_lte_rrc_cellIdentity_5GC_r15;       /* CellIdentity_5GC_r15 */
static int hf_lte_rrc_cellIdentity_r15;           /* CellIdentity */
static int hf_lte_rrc_cellId_Index_r15;           /* INTEGER_1_maxPLMN_r11 */
static int hf_lte_rrc_TrackingAreaList_r17_item;  /* TrackingAreaCode */
static int hf_lte_rrc_PosSchedulingInfoList_r15_item;  /* PosSchedulingInfo_r15 */
static int hf_lte_rrc_posSI_Periodicity_r15;      /* T_posSI_Periodicity_r15 */
static int hf_lte_rrc_posSIB_MappingInfo_r15;     /* PosSIB_MappingInfo_r15 */
static int hf_lte_rrc_PosSIB_MappingInfo_r15_item;  /* PosSIB_Type_r15 */
static int hf_lte_rrc_encrypted_r15;              /* T_encrypted_r15 */
static int hf_lte_rrc_gnss_id_r15;                /* GNSS_ID_r15 */
static int hf_lte_rrc_sbas_id_r15;                /* SBAS_ID_r15 */
static int hf_lte_rrc_posSibType_r15;             /* T_posSibType_r15 */
static int hf_lte_rrc_cellAccessRelatedInfo_r14;  /* T_cellAccessRelatedInfo_r14 */
static int hf_lte_rrc_plmn_IdentityList_r14_01;   /* PLMN_IdentityList_MBMS_r14 */
static int hf_lte_rrc_freqBandIndicator_r14;      /* FreqBandIndicator_r11 */
static int hf_lte_rrc_multiBandInfoList_r14;      /* MultiBandInfoList_r11 */
static int hf_lte_rrc_schedulingInfoList_MBMS_r14;  /* SchedulingInfoList_MBMS_r14 */
static int hf_lte_rrc_si_WindowLength_r14;        /* T_si_WindowLength_r14 */
static int hf_lte_rrc_systemInfoValueTag_r14;     /* INTEGER_0_31 */
static int hf_lte_rrc_nonMBSFN_SubframeConfig_r14;  /* NonMBSFN_SubframeConfig_r14 */
static int hf_lte_rrc_pdsch_ConfigCommon_r14;     /* PDSCH_ConfigCommon */
static int hf_lte_rrc_systemInformationBlockType13_r14;  /* SystemInformationBlockType13_r9 */
static int hf_lte_rrc_nonCriticalExtension_239;   /* T_nonCriticalExtension_63 */
static int hf_lte_rrc_PLMN_IdentityList_MBMS_r14_item;  /* PLMN_Identity */
static int hf_lte_rrc_SchedulingInfoList_MBMS_r14_item;  /* SchedulingInfo_MBMS_r14 */
static int hf_lte_rrc_si_Periodicity_r14;         /* T_si_Periodicity_r14 */
static int hf_lte_rrc_sib_MappingInfo_r14;        /* SIB_MappingInfo_MBMS_r14 */
static int hf_lte_rrc_SIB_MappingInfo_MBMS_r14_item;  /* SIB_Type_MBMS_r14 */
static int hf_lte_rrc_radioFrameAllocationPeriod_r14;  /* T_radioFrameAllocationPeriod_r14 */
static int hf_lte_rrc_radioFrameAllocationOffset_r14;  /* INTEGER_0_7 */
static int hf_lte_rrc_subframeAllocation_r14;     /* BIT_STRING_SIZE_9 */
static int hf_lte_rrc_criticalExtensions_51;      /* T_criticalExtensions_51 */
static int hf_lte_rrc_c1_41;                      /* T_c1_41 */
static int hf_lte_rrc_ueAssistanceInformation_r11_02;  /* UEAssistanceInformation_r11_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_49;  /* T_criticalExtensionsFuture_49 */
static int hf_lte_rrc_uEAssistanceInformation_r11_IEs_powerPrefIndication_r11;  /* T_uEAssistanceInformation_r11_IEs_powerPrefIndication_r11 */
static int hf_lte_rrc_nonCriticalExtension_240;   /* UEAssistanceInformation_v1430_IEs */
static int hf_lte_rrc_bw_Preference_r14;          /* BW_Preference_r14 */
static int hf_lte_rrc_sps_AssistanceInformation_r14;  /* T_sps_AssistanceInformation_r14 */
static int hf_lte_rrc_trafficPatternInfoListSL_r14;  /* TrafficPatternInfoList_r14 */
static int hf_lte_rrc_trafficPatternInfoListUL_r14;  /* TrafficPatternInfoList_r14 */
static int hf_lte_rrc_rlm_Report_r14;             /* T_rlm_Report_r14 */
static int hf_lte_rrc_rlm_Event_r14;              /* T_rlm_Event_r14 */
static int hf_lte_rrc_excessRep_MPDCCH_r14;       /* T_excessRep_MPDCCH_r14 */
static int hf_lte_rrc_delayBudgetReport_r14;      /* DelayBudgetReport_r14 */
static int hf_lte_rrc_nonCriticalExtension_241;   /* UEAssistanceInformation_v1450_IEs */
static int hf_lte_rrc_overheatingAssistance_r14;  /* OverheatingAssistance_r14 */
static int hf_lte_rrc_nonCriticalExtension_242;   /* UEAssistanceInformation_v1530_IEs */
static int hf_lte_rrc_sps_AssistanceInformation_v1530;  /* T_sps_AssistanceInformation_v1530 */
static int hf_lte_rrc_trafficPatternInfoListSL_v1530;  /* TrafficPatternInfoList_v1530 */
static int hf_lte_rrc_nonCriticalExtension_243;   /* UEAssistanceInformation_v1610_IEs */
static int hf_lte_rrc_overheatingAssistance_v1610;  /* OverheatingAssistance_v1610 */
static int hf_lte_rrc_nonCriticalExtension_244;   /* UEAssistanceInformation_v1700_IEs */
static int hf_lte_rrc_uplinkData_r17;             /* T_uplinkData_r17 */
static int hf_lte_rrc_scg_DeactivationPreference_r17;  /* T_scg_DeactivationPreference_r17 */
static int hf_lte_rrc_nonCriticalExtension_245;   /* UEAssistanceInformation_v1710_IEs */
static int hf_lte_rrc_overheatingAssistance_v1710;  /* OverheatingAssistance_v1710 */
static int hf_lte_rrc_nonCriticalExtension_246;   /* T_nonCriticalExtension_64 */
static int hf_lte_rrc_dl_Preference_r14;          /* T_dl_Preference_r14 */
static int hf_lte_rrc_ul_Preference_r14;          /* T_ul_Preference_r14 */
static int hf_lte_rrc_TrafficPatternInfoList_r14_item;  /* TrafficPatternInfo_r14 */
static int hf_lte_rrc_trafficPeriodicity_r14;     /* T_trafficPeriodicity_r14 */
static int hf_lte_rrc_timingOffset_r14;           /* INTEGER_0_10239 */
static int hf_lte_rrc_priorityInfoSL_r14;         /* SL_Priority_r13 */
static int hf_lte_rrc_logicalChannelIdentityUL_r14;  /* INTEGER_3_10 */
static int hf_lte_rrc_messageSize_r14;            /* T_messageSize_r14 */
static int hf_lte_rrc_TrafficPatternInfoList_v1530_item;  /* TrafficPatternInfo_v1530 */
static int hf_lte_rrc_trafficDestination_r15;     /* SL_DestinationIdentity_r12 */
static int hf_lte_rrc_reliabilityInfoSL_r15;      /* SL_Reliability_r15 */
static int hf_lte_rrc_type1;                      /* T_type1 */
static int hf_lte_rrc_type2;                      /* T_type2 */
static int hf_lte_rrc_reducedUE_Category;         /* T_reducedUE_Category */
static int hf_lte_rrc_reducedUE_CategoryDL;       /* INTEGER_0_19 */
static int hf_lte_rrc_reducedUE_CategoryUL;       /* INTEGER_0_21 */
static int hf_lte_rrc_reducedMaxCCs;              /* T_reducedMaxCCs */
static int hf_lte_rrc_reducedCCsDL;               /* INTEGER_0_31 */
static int hf_lte_rrc_reducedCCsUL;               /* INTEGER_0_31 */
static int hf_lte_rrc_overheatingAssistanceForSCG_r16;  /* T_overheatingAssistanceForSCG_r16 */
static int hf_lte_rrc_overheatingAssistanceForSCG_FR2_2_r17;  /* T_overheatingAssistanceForSCG_FR2_2_r17 */
static int hf_lte_rrc_criticalExtensions_52;      /* T_criticalExtensions_52 */
static int hf_lte_rrc_c1_42;                      /* T_c1_42 */
static int hf_lte_rrc_ueCapabilityEnquiry_r8;     /* UECapabilityEnquiry_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_50;  /* T_criticalExtensionsFuture_50 */
static int hf_lte_rrc_ue_CapabilityRequest;       /* UE_CapabilityRequest */
static int hf_lte_rrc_nonCriticalExtension_247;   /* UECapabilityEnquiry_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_248;   /* UECapabilityEnquiry_v1180_IEs */
static int hf_lte_rrc_requestedFrequencyBands_r11;  /* SEQUENCE_SIZE_1_16_OF_FreqBandIndicator_r11 */
static int hf_lte_rrc_requestedFrequencyBands_r11_item;  /* FreqBandIndicator_r11 */
static int hf_lte_rrc_nonCriticalExtension_249;   /* UECapabilityEnquiry_v1310_IEs */
static int hf_lte_rrc_requestReducedFormat_r13;   /* T_requestReducedFormat_r13 */
static int hf_lte_rrc_requestSkipFallbackComb_r13;  /* T_requestSkipFallbackComb_r13 */
static int hf_lte_rrc_requestedMaxCCsDL_r13;      /* INTEGER_2_32 */
static int hf_lte_rrc_requestedMaxCCsUL_r13;      /* INTEGER_2_32 */
static int hf_lte_rrc_requestReducedIntNonContComb_r13;  /* T_requestReducedIntNonContComb_r13 */
static int hf_lte_rrc_nonCriticalExtension_250;   /* UECapabilityEnquiry_v1430_IEs */
static int hf_lte_rrc_requestDiffFallbackCombList_r14;  /* BandCombinationList_r14 */
static int hf_lte_rrc_nonCriticalExtension_251;   /* UECapabilityEnquiry_v1510_IEs */
static int hf_lte_rrc_requestedFreqBandsNR_MRDC_r15;  /* T_requestedFreqBandsNR_MRDC_r15 */
static int hf_lte_rrc_nonCriticalExtension_252;   /* UECapabilityEnquiry_v1530_IEs */
static int hf_lte_rrc_requestSTTI_SPT_Capability_r15;  /* T_requestSTTI_SPT_Capability_r15 */
static int hf_lte_rrc_eutra_nr_only_r15;          /* T_eutra_nr_only_r15 */
static int hf_lte_rrc_nonCriticalExtension_253;   /* UECapabilityEnquiry_v1550_IEs */
static int hf_lte_rrc_requestedCapabilityNR_r15;  /* T_requestedCapabilityNR_r15 */
static int hf_lte_rrc_nonCriticalExtension_254;   /* UECapabilityEnquiry_v1560_IEs */
static int hf_lte_rrc_requestedCapabilityCommon_r15;  /* T_requestedCapabilityCommon_r15 */
static int hf_lte_rrc_nonCriticalExtension_255;   /* UECapabilityEnquiry_v1610_IEs */
static int hf_lte_rrc_rrc_SegAllowed_r16;         /* T_rrc_SegAllowed_r16 */
static int hf_lte_rrc_nonCriticalExtension_256;   /* UECapabilityEnquiry_v1710_IEs */
static int hf_lte_rrc_sidelinkRequest_r17;        /* T_sidelinkRequest_r17 */
static int hf_lte_rrc_nonCriticalExtension_257;   /* T_nonCriticalExtension_65 */
static int hf_lte_rrc_UE_CapabilityRequest_item;  /* RAT_Type */
static int hf_lte_rrc_criticalExtensions_53;      /* T_criticalExtensions_53 */
static int hf_lte_rrc_c1_43;                      /* T_c1_43 */
static int hf_lte_rrc_ueCapabilityInformation_r8;  /* UECapabilityInformation_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_51;  /* T_criticalExtensionsFuture_51 */
static int hf_lte_rrc_ue_CapabilityRAT_ContainerList;  /* UE_CapabilityRAT_ContainerList */
static int hf_lte_rrc_nonCriticalExtension_258;   /* UECapabilityInformation_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_259;   /* UECapabilityInformation_v1250_IEs */
static int hf_lte_rrc_ue_RadioPagingInfo_r12_01;  /* UE_RadioPagingInfo_r12 */
static int hf_lte_rrc_nonCriticalExtension_260;   /* T_nonCriticalExtension_66 */
static int hf_lte_rrc_criticalExtensions_54;      /* T_criticalExtensions_54 */
static int hf_lte_rrc_ulDedicatedMessageSegment_r16_01;  /* ULDedicatedMessageSegment_r16_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_52;  /* T_criticalExtensionsFuture_52 */
static int hf_lte_rrc_segmentNumber_r16_01;       /* T_segmentNumber_r16_01 */
static int hf_lte_rrc_rrc_MessageSegmentContainer_r16_01;  /* T_rrc_MessageSegmentContainer_r16_01 */
static int hf_lte_rrc_rrc_MessageSegmentType_r16_01;  /* T_rrc_MessageSegmentType_r16_01 */
static int hf_lte_rrc_nonCriticalExtension_261;   /* T_nonCriticalExtension_67 */
static int hf_lte_rrc_criticalExtensions_55;      /* T_criticalExtensions_55 */
static int hf_lte_rrc_c1_44;                      /* T_c1_44 */
static int hf_lte_rrc_ueInformationRequest_r9_01;  /* UEInformationRequest_r9_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_53;  /* T_criticalExtensionsFuture_53 */
static int hf_lte_rrc_rach_ReportReq_r9;          /* BOOLEAN */
static int hf_lte_rrc_rlf_ReportReq_r9;           /* BOOLEAN */
static int hf_lte_rrc_nonCriticalExtension_262;   /* UEInformationRequest_v930_IEs */
static int hf_lte_rrc_nonCriticalExtension_263;   /* UEInformationRequest_v1020_IEs */
static int hf_lte_rrc_logMeasReportReq_r10;       /* T_logMeasReportReq_r10 */
static int hf_lte_rrc_nonCriticalExtension_264;   /* UEInformationRequest_v1130_IEs */
static int hf_lte_rrc_connEstFailReportReq_r11;   /* T_connEstFailReportReq_r11 */
static int hf_lte_rrc_nonCriticalExtension_265;   /* UEInformationRequest_v1250_IEs */
static int hf_lte_rrc_mobilityHistoryReportReq_r12;  /* T_mobilityHistoryReportReq_r12 */
static int hf_lte_rrc_nonCriticalExtension_266;   /* UEInformationRequest_v1530_IEs */
static int hf_lte_rrc_idleModeMeasurementReq_r15;  /* T_idleModeMeasurementReq_r15 */
static int hf_lte_rrc_flightPathInfoReq_r15;      /* FlightPathInfoReportConfig_r15 */
static int hf_lte_rrc_nonCriticalExtension_267;   /* UEInformationRequest_v1710_IEs */
static int hf_lte_rrc_coarseLocationReq_r17;      /* T_coarseLocationReq_r17 */
static int hf_lte_rrc_nonCriticalExtension_268;   /* UEInformationRequest_v1800_IEs */
static int hf_lte_rrc_rach_ReportReqNR_r18;       /* T_rach_ReportReqNR_r18 */
static int hf_lte_rrc_nonCriticalExtension_269;   /* T_nonCriticalExtension_68 */
static int hf_lte_rrc_criticalExtensions_56;      /* T_criticalExtensions_56 */
static int hf_lte_rrc_c1_45;                      /* T_c1_45 */
static int hf_lte_rrc_ueInformationResponse_r9_01;  /* UEInformationResponse_r9_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_54;  /* T_criticalExtensionsFuture_54 */
static int hf_lte_rrc_rach_Report_r9;             /* RACH_Report_r16 */
static int hf_lte_rrc_rlf_Report_r9;              /* RLF_Report_r9 */
static int hf_lte_rrc_nonCriticalExtension_270;   /* UEInformationResponse_v930_IEs */
static int hf_lte_rrc_rlf_Report_v9e0;            /* RLF_Report_v9e0 */
static int hf_lte_rrc_nonCriticalExtension_271;   /* T_nonCriticalExtension_69 */
static int hf_lte_rrc_lateNonCriticalExtension_07;  /* T_lateNonCriticalExtension_06 */
static int hf_lte_rrc_nonCriticalExtension_272;   /* UEInformationResponse_v1020_IEs */
static int hf_lte_rrc_logMeasReport_r10;          /* LogMeasReport_r10 */
static int hf_lte_rrc_nonCriticalExtension_273;   /* UEInformationResponse_v1130_IEs */
static int hf_lte_rrc_connEstFailReport_r11;      /* ConnEstFailReport_r11 */
static int hf_lte_rrc_nonCriticalExtension_274;   /* UEInformationResponse_v1250_IEs */
static int hf_lte_rrc_mobilityHistoryReport_r12;  /* MobilityHistoryReport_r12 */
static int hf_lte_rrc_nonCriticalExtension_275;   /* UEInformationResponse_v1530_IEs */
static int hf_lte_rrc_measResultListIdle_r15;     /* MeasResultListIdle_r15 */
static int hf_lte_rrc_flightPathInfoReport_r15;   /* FlightPathInfoReport_r15 */
static int hf_lte_rrc_nonCriticalExtension_276;   /* UEInformationResponse_v1610_IEs */
static int hf_lte_rrc_rach_Report_v1610;          /* RACH_Report_v1610 */
static int hf_lte_rrc_nonCriticalExtension_277;   /* UEInformationResponse_v1710_IEs */
static int hf_lte_rrc_coarseLocationInfo_r17;     /* T_coarseLocationInfo_r17 */
static int hf_lte_rrc_nonCriticalExtension_278;   /* UEInformationResponse_v1800_IEs */
static int hf_lte_rrc_rach_ReportNR_r18;          /* RACH_ReportNR_r18 */
static int hf_lte_rrc_nonCriticalExtension_279;   /* T_nonCriticalExtension_70 */
static int hf_lte_rrc_numberOfPreamblesSent_r16;  /* NumberOfPreamblesSent_r11 */
static int hf_lte_rrc_contentionDetected_r16;     /* BOOLEAN */
static int hf_lte_rrc_initialCEL_r16;             /* INTEGER_0_3 */
static int hf_lte_rrc_edt_Fallback_r16;           /* BOOLEAN */
static int hf_lte_rrc_rach_ReportListNR_r18;      /* OCTET_STRING */
static int hf_lte_rrc_cellIdListNR_r18;           /* CellIdListNR_r18 */
static int hf_lte_rrc_CellIdListNR_r18_item;      /* CellIdNR_r18 */
static int hf_lte_rrc_cellGlobalId_r18;           /* CellGlobalIdNR_r16 */
static int hf_lte_rrc_pci_arfcn_r18;              /* T_pci_arfcn_r18 */
static int hf_lte_rrc_physCellId_r18;             /* PhysCellIdNR_r15 */
static int hf_lte_rrc_carrierFreq_r18;            /* ARFCN_ValueNR_r15 */
static int hf_lte_rrc_measResultLastServCell_r9;  /* T_measResultLastServCell_r9 */
static int hf_lte_rrc_rsrpResult_r9;              /* RSRP_Range */
static int hf_lte_rrc_rsrqResult_r9;              /* RSRQ_Range */
static int hf_lte_rrc_measResultNeighCells_r9;    /* T_measResultNeighCells_r9 */
static int hf_lte_rrc_measResultListEUTRA_r9;     /* MeasResultList2EUTRA_r9 */
static int hf_lte_rrc_measResultListUTRA_r9;      /* MeasResultList2UTRA_r9 */
static int hf_lte_rrc_measResultListGERAN_r9;     /* MeasResultListGERAN */
static int hf_lte_rrc_measResultsCDMA2000_r9;     /* MeasResultList2CDMA2000_r9 */
static int hf_lte_rrc_locationInfo_r10;           /* LocationInfo_r10 */
static int hf_lte_rrc_failedPCellId_r10;          /* T_failedPCellId_r10 */
static int hf_lte_rrc_cellGlobalId_r10;           /* CellGlobalIdEUTRA */
static int hf_lte_rrc_pci_arfcn_r10;              /* T_pci_arfcn_r10 */
static int hf_lte_rrc_reestablishmentCellId_r10;  /* CellGlobalIdEUTRA */
static int hf_lte_rrc_timeConnFailure_r10;        /* INTEGER_0_1023 */
static int hf_lte_rrc_connectionFailureType_r10;  /* T_connectionFailureType_r10 */
static int hf_lte_rrc_previousPCellId_r10;        /* CellGlobalIdEUTRA */
static int hf_lte_rrc_failedPCellId_v1090;        /* T_failedPCellId_v1090 */
static int hf_lte_rrc_basicFields_r11;            /* T_basicFields_r11 */
static int hf_lte_rrc_c_RNTI_r11;                 /* C_RNTI */
static int hf_lte_rrc_rlf_Cause_r11;              /* T_rlf_Cause_r11 */
static int hf_lte_rrc_timeSinceFailure_r11;       /* TimeSinceFailure_r11 */
static int hf_lte_rrc_previousUTRA_CellId_r11;    /* T_previousUTRA_CellId_r11 */
static int hf_lte_rrc_carrierFreq_r11_01;         /* ARFCN_ValueUTRA */
static int hf_lte_rrc_physCellId_r11;             /* T_physCellId_r11 */
static int hf_lte_rrc_fdd_r11;                    /* PhysCellIdUTRA_FDD */
static int hf_lte_rrc_tdd_r11;                    /* PhysCellIdUTRA_TDD */
static int hf_lte_rrc_cellGlobalId_r11;           /* CellGlobalIdUTRA */
static int hf_lte_rrc_selectedUTRA_CellId_r11;    /* T_selectedUTRA_CellId_r11 */
static int hf_lte_rrc_physCellId_r11_01;          /* T_physCellId_r11_01 */
static int hf_lte_rrc_failedPCellId_v1250;        /* T_failedPCellId_v1250 */
static int hf_lte_rrc_tac_FailedPCell_r12;        /* TrackingAreaCode */
static int hf_lte_rrc_measResultLastServCell_v1250;  /* RSRQ_Range_v1250 */
static int hf_lte_rrc_lastServCellRSRQ_Type_r12;  /* RSRQ_Type_r12 */
static int hf_lte_rrc_measResultListEUTRA_v1250;  /* MeasResultList2EUTRA_v1250 */
static int hf_lte_rrc_drb_EstablishedWithQCI_1_r13;  /* T_drb_EstablishedWithQCI_1_r13 */
static int hf_lte_rrc_measResultLastServCell_v1360;  /* RSRP_Range_v1360 */
static int hf_lte_rrc_logMeasResultListBT_r15;    /* LogMeasResultListBT_r15 */
static int hf_lte_rrc_logMeasResultListWLAN_r15;  /* LogMeasResultListWLAN_r15 */
static int hf_lte_rrc_measResultListNR_r16;       /* MeasResultCellListNR_r15 */
static int hf_lte_rrc_previousNR_PCellId_r16;     /* CellGlobalIdNR_r16 */
static int hf_lte_rrc_failedNR_PCellId_r16;       /* T_failedNR_PCellId_r16 */
static int hf_lte_rrc_cellGlobalId;               /* CellGlobalIdNR_r16 */
static int hf_lte_rrc_pci_arfcn;                  /* T_pci_arfcn */
static int hf_lte_rrc_physCellId_r16_01;          /* PhysCellIdNR_r15 */
static int hf_lte_rrc_carrierFreq_r16;            /* ARFCN_ValueNR_r15 */
static int hf_lte_rrc_reconnectCellId_r16;        /* T_reconnectCellId_r16 */
static int hf_lte_rrc_nrReconnectCellId;          /* CellGlobalIdNR_r16 */
static int hf_lte_rrc_eutraReconnectCellId;       /* T_eutraReconnectCellId */
static int hf_lte_rrc_cellGlobalId_r16;           /* CellGlobalIdEUTRA */
static int hf_lte_rrc_trackingAreaCode_EPC_r16;   /* TrackingAreaCode */
static int hf_lte_rrc_trackingAreaCode_5GC_r16;   /* TrackingAreaCode_5GC_r15 */
static int hf_lte_rrc_timeUntilReconnection_r16;  /* TimeUntilReconnection_r16 */
static int hf_lte_rrc_measResultListNR_v1640;     /* T_measResultListNR_v1640 */
static int hf_lte_rrc_carrierFreqNR_r16;          /* ARFCN_ValueNR_r15 */
static int hf_lte_rrc_measResultListExtNR_r16;    /* MeasResultFreqListNR_r16 */
static int hf_lte_rrc_voiceFallbackHO_r18;        /* T_voiceFallbackHO_r18 */
static int hf_lte_rrc_measResultListEUTRA_v9e0;   /* MeasResultList2EUTRA_v9e0 */
static int hf_lte_rrc_MeasResultList2EUTRA_r9_item;  /* MeasResult2EUTRA_r9 */
static int hf_lte_rrc_MeasResultList2EUTRA_v9e0_item;  /* MeasResult2EUTRA_v9e0 */
static int hf_lte_rrc_MeasResultList2EUTRA_v1250_item;  /* MeasResult2EUTRA_v1250 */
static int hf_lte_rrc_carrierFreq_r9_02;          /* ARFCN_ValueEUTRA */
static int hf_lte_rrc_measResultList_r9;          /* MeasResultListEUTRA */
static int hf_lte_rrc_rsrq_Type_r12;              /* RSRQ_Type_r12 */
static int hf_lte_rrc_MeasResultList2UTRA_r9_item;  /* MeasResult2UTRA_r9 */
static int hf_lte_rrc_carrierFreq_r9_03;          /* ARFCN_ValueUTRA */
static int hf_lte_rrc_measResultList_r9_01;       /* MeasResultListUTRA */
static int hf_lte_rrc_MeasResultList2CDMA2000_r9_item;  /* MeasResult2CDMA2000_r9 */
static int hf_lte_rrc_carrierFreq_r9_04;          /* CarrierFreqCDMA2000 */
static int hf_lte_rrc_measResultList_r9_02;       /* MeasResultsCDMA2000 */
static int hf_lte_rrc_absoluteTimeStamp_r10;      /* AbsoluteTimeInfo_r10 */
static int hf_lte_rrc_logMeasInfoList_r10;        /* LogMeasInfoList_r10 */
static int hf_lte_rrc_logMeasAvailable_r10_03;    /* T_logMeasAvailable_r10_03 */
static int hf_lte_rrc_logMeasAvailableBT_r15_04;  /* T_logMeasAvailableBT_r15_04 */
static int hf_lte_rrc_logMeasAvailableWLAN_r15_04;  /* T_logMeasAvailableWLAN_r15_04 */
static int hf_lte_rrc_LogMeasInfoList_r10_item;   /* LogMeasInfo_r10 */
static int hf_lte_rrc_relativeTimeStamp_r10;      /* INTEGER_0_7200 */
static int hf_lte_rrc_servCellIdentity_r10;       /* CellGlobalIdEUTRA */
static int hf_lte_rrc_measResultServCell_r10;     /* T_measResultServCell_r10 */
static int hf_lte_rrc_measResultNeighCells_r10;   /* T_measResultNeighCells_r10 */
static int hf_lte_rrc_measResultListEUTRA_r10;    /* MeasResultList2EUTRA_r9 */
static int hf_lte_rrc_measResultListUTRA_r10;     /* MeasResultList2UTRA_r9 */
static int hf_lte_rrc_measResultListGERAN_r10;    /* MeasResultList2GERAN_r10 */
static int hf_lte_rrc_measResultListCDMA2000_r10;  /* MeasResultList2CDMA2000_r9 */
static int hf_lte_rrc_measResultListEUTRA_v1090;  /* MeasResultList2EUTRA_v9e0 */
static int hf_lte_rrc_measResultListMBSFN_r12;    /* MeasResultListMBSFN_r12 */
static int hf_lte_rrc_measResultServCell_v1250;   /* RSRQ_Range_v1250 */
static int hf_lte_rrc_servCellRSRQ_Type_r12;      /* RSRQ_Type_r12 */
static int hf_lte_rrc_inDeviceCoexDetected_r13;   /* T_inDeviceCoexDetected_r13 */
static int hf_lte_rrc_measResultServCell_v1360;   /* RSRP_Range_v1360 */
static int hf_lte_rrc_anyCellSelectionDetected_r15;  /* T_anyCellSelectionDetected_r15 */
static int hf_lte_rrc_measResultListNR_v1640_01;  /* T_measResultListNR_v1640_01 */
static int hf_lte_rrc_uncomBarPreMeasResult_r17;  /* T_uncomBarPreMeasResult_r17 */
static int hf_lte_rrc_MeasResultListMBSFN_r12_item;  /* MeasResultMBSFN_r12 */
static int hf_lte_rrc_mbsfn_Area_r12;             /* T_mbsfn_Area_r12 */
static int hf_lte_rrc_rsrpResultMBSFN_r12;        /* RSRP_Range */
static int hf_lte_rrc_rsrqResultMBSFN_r12;        /* MBSFN_RSRQ_Range_r12 */
static int hf_lte_rrc_signallingBLER_Result_r12;  /* BLER_Result_r12 */
static int hf_lte_rrc_dataBLER_MCH_ResultList_r12;  /* DataBLER_MCH_ResultList_r12 */
static int hf_lte_rrc_DataBLER_MCH_ResultList_r12_item;  /* DataBLER_MCH_Result_r12 */
static int hf_lte_rrc_mch_Index_r12;              /* INTEGER_1_maxPMCH_PerMBSFN */
static int hf_lte_rrc_dataBLER_Result_r12;        /* BLER_Result_r12 */
static int hf_lte_rrc_bler_r12;                   /* BLER_Range_r12 */
static int hf_lte_rrc_blocksReceived_r12;         /* T_blocksReceived_r12 */
static int hf_lte_rrc_n_r12;                      /* T_n_r12 */
static int hf_lte_rrc_m_r12;                      /* T_m_r12 */
static int hf_lte_rrc_MeasResultList2GERAN_r10_item;  /* MeasResultListGERAN */
static int hf_lte_rrc_MeasResultFreqListNR_r16_item;  /* MeasResultFreqFailNR_r15 */
static int hf_lte_rrc_failedCellId_r11;           /* CellGlobalIdEUTRA */
static int hf_lte_rrc_locationInfo_r11;           /* LocationInfo_r10 */
static int hf_lte_rrc_measResultFailedCell_r11;   /* T_measResultFailedCell_r11 */
static int hf_lte_rrc_rsrpResult_r11;             /* RSRP_Range */
static int hf_lte_rrc_rsrqResult_r11;             /* RSRQ_Range */
static int hf_lte_rrc_measResultNeighCells_r11;   /* T_measResultNeighCells_r11 */
static int hf_lte_rrc_measResultListEUTRA_r11;    /* MeasResultList2EUTRA_r9 */
static int hf_lte_rrc_measResultListUTRA_r11;     /* MeasResultList2UTRA_r9 */
static int hf_lte_rrc_measResultListGERAN_r11;    /* MeasResultListGERAN */
static int hf_lte_rrc_measResultsCDMA2000_r11;    /* MeasResultList2CDMA2000_r9 */
static int hf_lte_rrc_numberOfPreamblesSent_r11;  /* NumberOfPreamblesSent_r11 */
static int hf_lte_rrc_contentionDetected_r11;     /* BOOLEAN */
static int hf_lte_rrc_maxTxPowerReached_r11;      /* BOOLEAN */
static int hf_lte_rrc_measResultListEUTRA_v1130;  /* MeasResultList2EUTRA_v9e0 */
static int hf_lte_rrc_measResultFailedCell_v1250;  /* RSRQ_Range_v1250 */
static int hf_lte_rrc_failedCellRSRQ_Type_r12;    /* RSRQ_Type_r12 */
static int hf_lte_rrc_measResultFailedCell_v1360;  /* RSRP_Range_v1360 */
static int hf_lte_rrc_measResultListNR_v1640_02;  /* T_measResultListNR_v1640_02 */
static int hf_lte_rrc_flightPath_r15;             /* SEQUENCE_SIZE_1_maxWayPoint_r15_OF_WayPointLocation_r15 */
static int hf_lte_rrc_flightPath_r15_item;        /* WayPointLocation_r15 */
static int hf_lte_rrc_dummy;                      /* T_dummy */
static int hf_lte_rrc_wayPointLocation_r15;       /* LocationInfo_r10 */
static int hf_lte_rrc_timeStamp_r15;              /* AbsoluteTimeInfo_r10 */
static int hf_lte_rrc_criticalExtensions_57;      /* T_criticalExtensions_57 */
static int hf_lte_rrc_c1_46;                      /* T_c1_46 */
static int hf_lte_rrc_ulHandoverPreparationTransfer_r8;  /* ULHandoverPreparationTransfer_r8_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_55;  /* T_criticalExtensionsFuture_55 */
static int hf_lte_rrc_meid;                       /* BIT_STRING_SIZE_56 */
static int hf_lte_rrc_dedicatedInfo;              /* DedicatedInfoCDMA2000 */
static int hf_lte_rrc_nonCriticalExtension_280;   /* ULHandoverPreparationTransfer_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_281;   /* T_nonCriticalExtension_71 */
static int hf_lte_rrc_criticalExtensions_58;      /* T_criticalExtensions_58 */
static int hf_lte_rrc_c1_47;                      /* T_c1_47 */
static int hf_lte_rrc_ulInformationTransfer_r8;   /* ULInformationTransfer_r8_IEs */
static int hf_lte_rrc_ulInformationTransfer_r16;  /* ULInformationTransfer_r16_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_56;  /* T_criticalExtensionsFuture_56 */
static int hf_lte_rrc_dedicatedInfoType_01;       /* T_dedicatedInfoType_01 */
static int hf_lte_rrc_nonCriticalExtension_282;   /* ULInformationTransfer_v8a0_IEs */
static int hf_lte_rrc_nonCriticalExtension_283;   /* T_nonCriticalExtension_72 */
static int hf_lte_rrc_dedicatedInfoType_r16;      /* T_dedicatedInfoType_r16 */
static int hf_lte_rrc_dedicatedInfoCDMA2000_1XRTT_r16;  /* DedicatedInfoCDMA2000 */
static int hf_lte_rrc_dedicatedInfoCDMA2000_HRPD_r16;  /* DedicatedInfoCDMA2000 */
static int hf_lte_rrc_criticalExtensions_59;      /* T_criticalExtensions_59 */
static int hf_lte_rrc_c1_48;                      /* T_c1_48 */
static int hf_lte_rrc_ulInformationTransferIRAT_r16_01;  /* ULInformationTransferIRAT_r16_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_57;  /* T_criticalExtensionsFuture_57 */
static int hf_lte_rrc_ul_DCCH_MessageNR_r16;      /* T_ul_DCCH_MessageNR_r16 */
static int hf_lte_rrc_nonCriticalExtension_284;   /* T_nonCriticalExtension_73 */
static int hf_lte_rrc_criticalExtensions_60;      /* T_criticalExtensions_60 */
static int hf_lte_rrc_c1_49;                      /* T_c1_49 */
static int hf_lte_rrc_ulInformationTransferMRDC_r15_01;  /* ULInformationTransferMRDC_r15_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_58;  /* T_criticalExtensionsFuture_58 */
static int hf_lte_rrc_ul_DCCH_MessageNR_r15;      /* T_ul_DCCH_MessageNR_r15 */
static int hf_lte_rrc_nonCriticalExtension_285;   /* T_nonCriticalExtension_74 */
static int hf_lte_rrc_criticalExtensions_61;      /* T_criticalExtensions_61 */
static int hf_lte_rrc_c1_50;                      /* T_c1_50 */
static int hf_lte_rrc_wlanConnectionStatusReport_r13_02;  /* WLANConnectionStatusReport_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_59;  /* T_criticalExtensionsFuture_59 */
static int hf_lte_rrc_wlan_Status_r13;            /* WLAN_Status_r13 */
static int hf_lte_rrc_nonCriticalExtension_286;   /* WLANConnectionStatusReport_v1430_IEs */
static int hf_lte_rrc_wlan_Status_v1430;          /* WLAN_Status_v1430 */
static int hf_lte_rrc_nonCriticalExtension_287;   /* T_nonCriticalExtension_75 */
static int hf_lte_rrc_assistanceDataSIB_Element_r15;  /* T_assistanceDataSIB_Element_r15 */
static int hf_lte_rrc_ac_BarringInfo;             /* T_ac_BarringInfo */
static int hf_lte_rrc_ac_BarringForEmergency;     /* BOOLEAN */
static int hf_lte_rrc_ac_BarringForMO_Signalling;  /* AC_BarringConfig */
static int hf_lte_rrc_ac_BarringForMO_Data;       /* AC_BarringConfig */
static int hf_lte_rrc_radioResourceConfigCommon;  /* RadioResourceConfigCommonSIB */
static int hf_lte_rrc_ue_TimersAndConstants;      /* UE_TimersAndConstants */
static int hf_lte_rrc_freqInfo;                   /* T_freqInfo */
static int hf_lte_rrc_ul_CarrierFreq;             /* ARFCN_ValueEUTRA */
static int hf_lte_rrc_ul_Bandwidth;               /* T_ul_Bandwidth */
static int hf_lte_rrc_additionalSpectrumEmission;  /* AdditionalSpectrumEmission */
static int hf_lte_rrc_mbsfn_SubframeConfigList;   /* MBSFN_SubframeConfigList */
static int hf_lte_rrc_timeAlignmentTimerCommon;   /* TimeAlignmentTimer */
static int hf_lte_rrc_lateNonCriticalExtension_08;  /* T_lateNonCriticalExtension_07 */
static int hf_lte_rrc_ssac_BarringForMMTEL_Voice_r9;  /* AC_BarringConfig */
static int hf_lte_rrc_ssac_BarringForMMTEL_Video_r9;  /* AC_BarringConfig */
static int hf_lte_rrc_ac_BarringForCSFB_r10;      /* AC_BarringConfig */
static int hf_lte_rrc_ac_BarringSkipForMMTELVoice_r12;  /* T_ac_BarringSkipForMMTELVoice_r12 */
static int hf_lte_rrc_ac_BarringSkipForMMTELVideo_r12;  /* T_ac_BarringSkipForMMTELVideo_r12 */
static int hf_lte_rrc_ac_BarringSkipForSMS_r12;   /* T_ac_BarringSkipForSMS_r12 */
static int hf_lte_rrc_ac_BarringPerPLMN_List_r12;  /* AC_BarringPerPLMN_List_r12 */
static int hf_lte_rrc_voiceServiceCauseIndication_r12;  /* T_voiceServiceCauseIndication_r12 */
static int hf_lte_rrc_acdc_BarringForCommon_r13;  /* ACDC_BarringForCommon_r13 */
static int hf_lte_rrc_acdc_BarringPerPLMN_List_r13;  /* ACDC_BarringPerPLMN_List_r13 */
static int hf_lte_rrc_udt_RestrictingForCommon_r13;  /* UDT_Restricting_r13 */
static int hf_lte_rrc_udt_RestrictingPerPLMN_List_r13;  /* UDT_RestrictingPerPLMN_List_r13 */
static int hf_lte_rrc_cIoT_EPS_OptimisationInfo_r13;  /* CIOT_EPS_OptimisationInfo_r13 */
static int hf_lte_rrc_useFullResumeID_r13;        /* T_useFullResumeID_r13 */
static int hf_lte_rrc_unicastFreqHoppingInd_r13;  /* T_unicastFreqHoppingInd_r13 */
static int hf_lte_rrc_mbsfn_SubframeConfigList_v1430;  /* MBSFN_SubframeConfigList_v1430 */
static int hf_lte_rrc_videoServiceCauseIndication_r14;  /* T_videoServiceCauseIndication_r14 */
static int hf_lte_rrc_plmn_InfoList_r15;          /* PLMN_InfoList_r15 */
static int hf_lte_rrc_cp_EDT_r15;                 /* T_cp_EDT_r15 */
static int hf_lte_rrc_up_EDT_r15;                 /* T_up_EDT_r15 */
static int hf_lte_rrc_idleModeMeasurements_r15;   /* T_idleModeMeasurements_r15 */
static int hf_lte_rrc_reducedCP_LatencyEnabled_r15;  /* T_reducedCP_LatencyEnabled_r15 */
static int hf_lte_rrc_mbms_ROM_ServiceIndication_r15;  /* T_mbms_ROM_ServiceIndication_r15 */
static int hf_lte_rrc_rlos_Enabled_r16;           /* T_rlos_Enabled_r16 */
static int hf_lte_rrc_earlySecurityReactivation_r16;  /* T_earlySecurityReactivation_r16 */
static int hf_lte_rrc_cp_EDT_5GC_r16;             /* T_cp_EDT_5GC_r16 */
static int hf_lte_rrc_up_EDT_5GC_r16;             /* T_up_EDT_5GC_r16 */
static int hf_lte_rrc_cp_PUR_EPC_r16;             /* T_cp_PUR_EPC_r16 */
static int hf_lte_rrc_up_PUR_EPC_r16;             /* T_up_PUR_EPC_r16 */
static int hf_lte_rrc_cp_PUR_5GC_r16;             /* T_cp_PUR_5GC_r16 */
static int hf_lte_rrc_up_PUR_5GC_r16;             /* T_up_PUR_5GC_r16 */
static int hf_lte_rrc_mpdcch_CQI_Reporting_r16;   /* T_mpdcch_CQI_Reporting_r16 */
static int hf_lte_rrc_rai_ActivationEnh_r16;      /* T_rai_ActivationEnh_r16 */
static int hf_lte_rrc_idleModeMeasurementsNR_r16;  /* T_idleModeMeasurementsNR_r16 */
static int hf_lte_rrc_gnss_PositionFixDurationReporting_r18;  /* T_gnss_PositionFixDurationReporting_r18 */
static int hf_lte_rrc_freqInfoAerial_r18;         /* AdditionalSpectrumEmission_r18 */
static int hf_lte_rrc_multiBandInfoListAerial_r18_01;  /* SEQUENCE_SIZE_1_maxMultiBands_OF_AdditionalSpectrumEmission_r18 */
static int hf_lte_rrc_multiBandInfoListAerial_r18_item;  /* AdditionalSpectrumEmission_r18 */
static int hf_lte_rrc_multiBandInfoList_01;       /* SEQUENCE_SIZE_1_maxMultiBands_OF_AdditionalSpectrumEmission */
static int hf_lte_rrc_multiBandInfoList_item;     /* AdditionalSpectrumEmission */
static int hf_lte_rrc_nonCriticalExtension_288;   /* SystemInformationBlockType2_v9e0_IEs */
static int hf_lte_rrc_ul_CarrierFreq_v9e0;        /* ARFCN_ValueEUTRA_v9e0 */
static int hf_lte_rrc_nonCriticalExtension_289;   /* SystemInformationBlockType2_v9i0_IEs */
static int hf_lte_rrc_nonCriticalExtension_290;   /* T_nonCriticalExtension_76 */
static int hf_lte_rrc_systemInformationBlockType2_v9i0_IEs_dummy;  /* T_systemInformationBlockType2_v9i0_IEs_dummy */
static int hf_lte_rrc_freqInfo_v10l0;             /* T_freqInfo_v10l0 */
static int hf_lte_rrc_additionalSpectrumEmission_v10l0;  /* AdditionalSpectrumEmission_v10l0 */
static int hf_lte_rrc_multiBandInfoList_v10l0_01;  /* SEQUENCE_SIZE_1_maxMultiBands_OF_AdditionalSpectrumEmission_v10l0 */
static int hf_lte_rrc_multiBandInfoList_v10l0_item;  /* AdditionalSpectrumEmission_v10l0 */
static int hf_lte_rrc_nonCriticalExtension_291;   /* SystemInformationBlockType2_v10n0_IEs */
static int hf_lte_rrc_nonCriticalExtension_292;   /* SystemInformationBlockType2_v13c0_IEs */
static int hf_lte_rrc_uplinkPowerControlCommon_v13c0;  /* UplinkPowerControlCommon_v1310 */
static int hf_lte_rrc_nonCriticalExtension_293;   /* T_nonCriticalExtension_77 */
static int hf_lte_rrc_ac_BarringFactor;           /* T_ac_BarringFactor */
static int hf_lte_rrc_ac_BarringTime;             /* T_ac_BarringTime */
static int hf_lte_rrc_ac_BarringForSpecialAC;     /* BIT_STRING_SIZE_5 */
static int hf_lte_rrc_MBSFN_SubframeConfigList_item;  /* MBSFN_SubframeConfig */
static int hf_lte_rrc_MBSFN_SubframeConfigList_v1430_item;  /* MBSFN_SubframeConfig_v1430 */
static int hf_lte_rrc_AC_BarringPerPLMN_List_r12_item;  /* AC_BarringPerPLMN_r12 */
static int hf_lte_rrc_plmn_IdentityIndex_r12;     /* INTEGER_1_maxPLMN_r11 */
static int hf_lte_rrc_ac_BarringInfo_r12;         /* T_ac_BarringInfo_r12 */
static int hf_lte_rrc_ac_BarringForEmergency_r12;  /* BOOLEAN */
static int hf_lte_rrc_ac_BarringForMO_Signalling_r12;  /* AC_BarringConfig */
static int hf_lte_rrc_ac_BarringForMO_Data_r12;   /* AC_BarringConfig */
static int hf_lte_rrc_ac_BarringSkipForMMTELVoice_r12_01;  /* T_ac_BarringSkipForMMTELVoice_r12_01 */
static int hf_lte_rrc_ac_BarringSkipForMMTELVideo_r12_01;  /* T_ac_BarringSkipForMMTELVideo_r12_01 */
static int hf_lte_rrc_ac_BarringSkipForSMS_r12_01;  /* T_ac_BarringSkipForSMS_r12_01 */
static int hf_lte_rrc_ac_BarringForCSFB_r12;      /* AC_BarringConfig */
static int hf_lte_rrc_ssac_BarringForMMTEL_Voice_r12;  /* AC_BarringConfig */
static int hf_lte_rrc_ssac_BarringForMMTEL_Video_r12;  /* AC_BarringConfig */
static int hf_lte_rrc_acdc_HPLMNonly_r13;         /* BOOLEAN */
static int hf_lte_rrc_barringPerACDC_CategoryList_r13;  /* BarringPerACDC_CategoryList_r13 */
static int hf_lte_rrc_ACDC_BarringPerPLMN_List_r13_item;  /* ACDC_BarringPerPLMN_r13 */
static int hf_lte_rrc_plmn_IdentityIndex_r13;     /* INTEGER_1_maxPLMN_r11 */
static int hf_lte_rrc_acdc_OnlyForHPLMN_r13;      /* BOOLEAN */
static int hf_lte_rrc_BarringPerACDC_CategoryList_r13_item;  /* BarringPerACDC_Category_r13 */
static int hf_lte_rrc_acdc_Category_r13;          /* INTEGER_1_maxACDC_Cat_r13 */
static int hf_lte_rrc_acdc_BarringConfig_r13;     /* T_acdc_BarringConfig_r13 */
static int hf_lte_rrc_ac_BarringFactor_r13;       /* T_ac_BarringFactor_r13 */
static int hf_lte_rrc_ac_BarringTime_r13;         /* T_ac_BarringTime_r13 */
static int hf_lte_rrc_udt_Restricting_r13;        /* T_udt_Restricting_r13 */
static int hf_lte_rrc_udt_RestrictingTime_r13;    /* T_udt_RestrictingTime_r13 */
static int hf_lte_rrc_UDT_RestrictingPerPLMN_List_r13_item;  /* UDT_RestrictingPerPLMN_r13 */
static int hf_lte_rrc_udt_Restricting_r13_01;     /* UDT_Restricting_r13 */
static int hf_lte_rrc_CIOT_EPS_OptimisationInfo_r13_item;  /* CIOT_OptimisationPLMN_r13 */
static int hf_lte_rrc_up_CIoT_EPS_Optimisation_r13_01;  /* T_up_CIoT_EPS_Optimisation_r13_01 */
static int hf_lte_rrc_cp_CIoT_EPS_Optimisation_r13_01;  /* T_cp_CIoT_EPS_Optimisation_r13_01 */
static int hf_lte_rrc_attachWithoutPDN_Connectivity_r13_01;  /* T_attachWithoutPDN_Connectivity_r13_01 */
static int hf_lte_rrc_PLMN_InfoList_r15_item;     /* PLMN_Info_r15 */
static int hf_lte_rrc_upperLayerIndication_r15;   /* T_upperLayerIndication_r15 */
static int hf_lte_rrc_cellReselectionInfoCommon;  /* T_cellReselectionInfoCommon */
static int hf_lte_rrc_q_Hyst;                     /* T_q_Hyst */
static int hf_lte_rrc_speedStateReselectionPars;  /* T_speedStateReselectionPars */
static int hf_lte_rrc_mobilityStateParameters;    /* MobilityStateParameters */
static int hf_lte_rrc_q_HystSF;                   /* T_q_HystSF */
static int hf_lte_rrc_sf_Medium;                  /* T_sf_Medium */
static int hf_lte_rrc_sf_High;                    /* T_sf_High */
static int hf_lte_rrc_cellReselectionServingFreqInfo;  /* T_cellReselectionServingFreqInfo */
static int hf_lte_rrc_s_NonIntraSearch;           /* ReselectionThreshold */
static int hf_lte_rrc_threshServingLow;           /* ReselectionThreshold */
static int hf_lte_rrc_intraFreqCellReselectionInfo;  /* T_intraFreqCellReselectionInfo */
static int hf_lte_rrc_s_IntraSearch;              /* ReselectionThreshold */
static int hf_lte_rrc_allowedMeasBandwidth;       /* AllowedMeasBandwidth */
static int hf_lte_rrc_presenceAntennaPort1;       /* PresenceAntennaPort1 */
static int hf_lte_rrc_neighCellConfig;            /* NeighCellConfig */
static int hf_lte_rrc_t_ReselectionEUTRA;         /* T_Reselection */
static int hf_lte_rrc_t_ReselectionEUTRA_SF;      /* SpeedStateScaleFactors */
static int hf_lte_rrc_lateNonCriticalExtension_09;  /* T_lateNonCriticalExtension_08 */
static int hf_lte_rrc_s_IntraSearch_v920;         /* T_s_IntraSearch_v920 */
static int hf_lte_rrc_s_IntraSearchP_r9;          /* ReselectionThreshold */
static int hf_lte_rrc_s_IntraSearchQ_r9;          /* ReselectionThresholdQ_r9 */
static int hf_lte_rrc_s_NonIntraSearch_v920;      /* T_s_NonIntraSearch_v920 */
static int hf_lte_rrc_s_NonIntraSearchP_r9;       /* ReselectionThreshold */
static int hf_lte_rrc_s_NonIntraSearchQ_r9;       /* ReselectionThresholdQ_r9 */
static int hf_lte_rrc_threshServingLowQ_r9;       /* ReselectionThresholdQ_r9 */
static int hf_lte_rrc_cellReselectionServingFreqInfo_v1310;  /* CellReselectionServingFreqInfo_v1310 */
static int hf_lte_rrc_redistributionServingInfo_r13;  /* RedistributionServingInfo_r13 */
static int hf_lte_rrc_t_ReselectionEUTRA_CE_r13;  /* T_ReselectionEUTRA_CE_r13 */
static int hf_lte_rrc_cellReselectionInfoCommon_v1460;  /* CellReselectionInfoCommon_v1460 */
static int hf_lte_rrc_cellReselectionInfoHSDN_r15;  /* CellReselectionInfoHSDN_r15 */
static int hf_lte_rrc_crs_IntfMitigNeighCellsCE_r15;  /* T_crs_IntfMitigNeighCellsCE_r15 */
static int hf_lte_rrc_cellReselectionServingFreqInfo_v1610;  /* CellReselectionServingFreqInfo_v1610 */
static int hf_lte_rrc_t_Service_r17;              /* TimeOffsetUTC_r17 */
static int hf_lte_rrc_satelliteAssistanceInfoList_r18;  /* SEQUENCE_SIZE_1_maxSat_r17_OF_SatelliteId_r18 */
static int hf_lte_rrc_satelliteAssistanceInfoList_r18_item;  /* SatelliteId_r18 */
static int hf_lte_rrc_redistributionFactorServing_r13;  /* INTEGER_0_10 */
static int hf_lte_rrc_redistributionFactorCell_r13;  /* T_redistributionFactorCell_r13 */
static int hf_lte_rrc_t360_r13;                   /* T_t360_r13 */
static int hf_lte_rrc_redistrOnPagingOnly_r13;    /* T_redistrOnPagingOnly_r13 */
static int hf_lte_rrc_altCellReselectionPriority_r16;  /* CellReselectionPriority */
static int hf_lte_rrc_altCellReselectionSubPriority_r16;  /* CellReselectionSubPriority_r13 */
static int hf_lte_rrc_nonCriticalExtension_294;   /* SystemInformationBlockType3_v10l0_IEs */
static int hf_lte_rrc_nonCriticalExtension_295;   /* T_nonCriticalExtension_78 */
static int hf_lte_rrc_s_SearchDeltaP_r14;         /* T_s_SearchDeltaP_r14 */
static int hf_lte_rrc_cellEquivalentSize_r15;     /* INTEGER_2_16 */
static int hf_lte_rrc_intraFreqNeighCellList;     /* IntraFreqNeighCellList */
static int hf_lte_rrc_intraFreqExcludedCellList;  /* IntraFreqExcludedCellList */
static int hf_lte_rrc_csg_PhysCellIdRange;        /* PhysCellIdRange */
static int hf_lte_rrc_intraFreqNeighHSDN_CellList_r15;  /* IntraFreqNeighHSDN_CellList_r15 */
static int hf_lte_rrc_rss_ConfigCarrierInfo_r16;  /* RSS_ConfigCarrierInfo_r16 */
static int hf_lte_rrc_intraFreqNeighCellList_v1610;  /* IntraFreqNeighCellList_v1610 */
static int hf_lte_rrc_IntraFreqNeighCellList_item;  /* IntraFreqNeighCellInfo */
static int hf_lte_rrc_IntraFreqNeighCellList_v1610_item;  /* IntraFreqNeighCellInfo_v1610 */
static int hf_lte_rrc_IntraFreqNeighHSDN_CellList_r15_item;  /* PhysCellIdRange */
static int hf_lte_rrc_q_OffsetCell;               /* Q_OffsetRange */
static int hf_lte_rrc_rss_MeasPowerBias_r16;      /* RSS_MeasPowerBias_r16 */
static int hf_lte_rrc_IntraFreqExcludedCellList_item;  /* PhysCellIdRange */
static int hf_lte_rrc_interFreqCarrierFreqList;   /* InterFreqCarrierFreqList */
static int hf_lte_rrc_lateNonCriticalExtension_10;  /* T_lateNonCriticalExtension_09 */
static int hf_lte_rrc_interFreqCarrierFreqList_v1250;  /* InterFreqCarrierFreqList_v1250 */
static int hf_lte_rrc_interFreqCarrierFreqListExt_r12;  /* InterFreqCarrierFreqListExt_r12 */
static int hf_lte_rrc_interFreqCarrierFreqListExt_v1280;  /* InterFreqCarrierFreqListExt_v1280 */
static int hf_lte_rrc_interFreqCarrierFreqList_v1310;  /* InterFreqCarrierFreqList_v1310 */
static int hf_lte_rrc_interFreqCarrierFreqListExt_v1310;  /* InterFreqCarrierFreqListExt_v1310 */
static int hf_lte_rrc_interFreqCarrierFreqList_v1350;  /* InterFreqCarrierFreqList_v1350 */
static int hf_lte_rrc_interFreqCarrierFreqListExt_v1350;  /* InterFreqCarrierFreqListExt_v1350 */
static int hf_lte_rrc_interFreqCarrierFreqListExt_v1360;  /* InterFreqCarrierFreqListExt_v1360 */
static int hf_lte_rrc_scptm_FreqOffset_r14;       /* INTEGER_1_8 */
static int hf_lte_rrc_interFreqCarrierFreqList_v1530;  /* InterFreqCarrierFreqList_v1530 */
static int hf_lte_rrc_interFreqCarrierFreqListExt_v1530;  /* InterFreqCarrierFreqListExt_v1530 */
static int hf_lte_rrc_measIdleConfigSIB_r15;      /* MeasIdleConfigSIB_r15 */
static int hf_lte_rrc_interFreqCarrierFreqList_v1610;  /* InterFreqCarrierFreqList_v1610 */
static int hf_lte_rrc_interFreqCarrierFreqListExt_v1610;  /* InterFreqCarrierFreqListExt_v1610 */
static int hf_lte_rrc_measIdleConfigSIB_NR_r16;   /* MeasIdleConfigSIB_NR_r16 */
static int hf_lte_rrc_interFreqCarrierFreqList_v1800;  /* InterFreqCarrierFreqList_v1800 */
static int hf_lte_rrc_interFreqCarrierFreqListExt_v1800;  /* InterFreqCarrierFreqListExt_v1800 */
static int hf_lte_rrc_interFreqCarrierFreqList_v8h0;  /* SEQUENCE_SIZE_1_maxFreq_OF_InterFreqCarrierFreqInfo_v8h0 */
static int hf_lte_rrc_interFreqCarrierFreqList_v8h0_item;  /* InterFreqCarrierFreqInfo_v8h0 */
static int hf_lte_rrc_nonCriticalExtension_296;   /* SystemInformationBlockType5_v9e0_IEs */
static int hf_lte_rrc_interFreqCarrierFreqList_v9e0;  /* SEQUENCE_SIZE_1_maxFreq_OF_InterFreqCarrierFreqInfo_v9e0 */
static int hf_lte_rrc_interFreqCarrierFreqList_v9e0_item;  /* InterFreqCarrierFreqInfo_v9e0 */
static int hf_lte_rrc_nonCriticalExtension_297;   /* SystemInformationBlockType5_v10j0_IEs */
static int hf_lte_rrc_interFreqCarrierFreqList_v10j0;  /* SEQUENCE_SIZE_1_maxFreq_OF_InterFreqCarrierFreqInfo_v10j0 */
static int hf_lte_rrc_interFreqCarrierFreqList_v10j0_item;  /* InterFreqCarrierFreqInfo_v10j0 */
static int hf_lte_rrc_nonCriticalExtension_298;   /* SystemInformationBlockType5_v10l0_IEs */
static int hf_lte_rrc_interFreqCarrierFreqList_v10l0;  /* SEQUENCE_SIZE_1_maxFreq_OF_InterFreqCarrierFreqInfo_v10l0 */
static int hf_lte_rrc_interFreqCarrierFreqList_v10l0_item;  /* InterFreqCarrierFreqInfo_v10l0 */
static int hf_lte_rrc_nonCriticalExtension_299;   /* SystemInformationBlockType5_v13a0_IEs */
static int hf_lte_rrc_interFreqCarrierFreqList_v13a0;  /* InterFreqCarrierFreqList_v13a0 */
static int hf_lte_rrc_nonCriticalExtension_300;   /* T_nonCriticalExtension_79 */
static int hf_lte_rrc_InterFreqCarrierFreqList_item;  /* InterFreqCarrierFreqInfo */
static int hf_lte_rrc_InterFreqCarrierFreqList_v1250_item;  /* InterFreqCarrierFreqInfo_v1250 */
static int hf_lte_rrc_InterFreqCarrierFreqList_v1310_item;  /* InterFreqCarrierFreqInfo_v1310 */
static int hf_lte_rrc_InterFreqCarrierFreqList_v1350_item;  /* InterFreqCarrierFreqInfo_v1350 */
static int hf_lte_rrc_InterFreqCarrierFreqList_v13a0_item;  /* InterFreqCarrierFreqInfo_v1360 */
static int hf_lte_rrc_InterFreqCarrierFreqList_v1530_item;  /* InterFreqCarrierFreqInfo_v1530 */
static int hf_lte_rrc_InterFreqCarrierFreqList_v1610_item;  /* InterFreqCarrierFreqInfo_v1610 */
static int hf_lte_rrc_InterFreqCarrierFreqList_v1800_item;  /* InterFreqCarrierFreqInfo_v1800 */
static int hf_lte_rrc_InterFreqCarrierFreqListExt_r12_item;  /* InterFreqCarrierFreqInfo_r12 */
static int hf_lte_rrc_InterFreqCarrierFreqListExt_v1280_item;  /* InterFreqCarrierFreqInfo_v10j0 */
static int hf_lte_rrc_InterFreqCarrierFreqListExt_v1310_item;  /* InterFreqCarrierFreqInfo_v1310 */
static int hf_lte_rrc_InterFreqCarrierFreqListExt_v1350_item;  /* InterFreqCarrierFreqInfo_v1350 */
static int hf_lte_rrc_InterFreqCarrierFreqListExt_v1360_item;  /* InterFreqCarrierFreqInfo_v1360 */
static int hf_lte_rrc_InterFreqCarrierFreqListExt_v1530_item;  /* InterFreqCarrierFreqInfo_v1530 */
static int hf_lte_rrc_InterFreqCarrierFreqListExt_v1610_item;  /* InterFreqCarrierFreqInfo_v1610 */
static int hf_lte_rrc_InterFreqCarrierFreqListExt_v1800_item;  /* InterFreqCarrierFreqInfo_v1800 */
static int hf_lte_rrc_dl_CarrierFreq;             /* ARFCN_ValueEUTRA */
static int hf_lte_rrc_threshX_High;               /* ReselectionThreshold */
static int hf_lte_rrc_threshX_Low;                /* ReselectionThreshold */
static int hf_lte_rrc_q_OffsetFreq;               /* Q_OffsetRange */
static int hf_lte_rrc_interFreqNeighCellList;     /* InterFreqNeighCellList */
static int hf_lte_rrc_interFreqExcludedCellList;  /* InterFreqExcludedCellList */
static int hf_lte_rrc_threshX_Q_r9;               /* T_threshX_Q_r9 */
static int hf_lte_rrc_threshX_HighQ_r9;           /* ReselectionThresholdQ_r9 */
static int hf_lte_rrc_threshX_LowQ_r9;            /* ReselectionThresholdQ_r9 */
static int hf_lte_rrc_dl_CarrierFreq_v9e0;        /* ARFCN_ValueEUTRA_v9e0 */
static int hf_lte_rrc_reducedMeasPerformance_r12;  /* T_reducedMeasPerformance_r12 */
static int hf_lte_rrc_q_RxLevMin_r12;             /* Q_RxLevMin */
static int hf_lte_rrc_t_ReselectionEUTRA_r12;     /* T_Reselection */
static int hf_lte_rrc_t_ReselectionEUTRA_SF_r12;  /* SpeedStateScaleFactors */
static int hf_lte_rrc_threshX_High_r12;           /* ReselectionThreshold */
static int hf_lte_rrc_threshX_Low_r12;            /* ReselectionThreshold */
static int hf_lte_rrc_allowedMeasBandwidth_r12;   /* AllowedMeasBandwidth */
static int hf_lte_rrc_presenceAntennaPort1_r12;   /* PresenceAntennaPort1 */
static int hf_lte_rrc_neighCellConfig_r12;        /* NeighCellConfig */
static int hf_lte_rrc_q_OffsetFreq_r12;           /* Q_OffsetRange */
static int hf_lte_rrc_interFreqNeighCellList_r12;  /* InterFreqNeighCellList */
static int hf_lte_rrc_interFreqExcludedCellList_r12;  /* InterFreqExcludedCellList */
static int hf_lte_rrc_q_QualMin_r12;              /* Q_QualMin_r9 */
static int hf_lte_rrc_threshX_Q_r12;              /* T_threshX_Q_r12 */
static int hf_lte_rrc_threshX_HighQ_r12;          /* ReselectionThresholdQ_r9 */
static int hf_lte_rrc_threshX_LowQ_r12;           /* ReselectionThresholdQ_r9 */
static int hf_lte_rrc_q_QualMinWB_r12;            /* Q_QualMin_r9 */
static int hf_lte_rrc_multiBandInfoList_r12;      /* MultiBandInfoList_r11 */
static int hf_lte_rrc_reducedMeasPerformance_r12_01;  /* T_reducedMeasPerformance_r12_01 */
static int hf_lte_rrc_redistributionInterFreqInfo_r13;  /* RedistributionInterFreqInfo_r13 */
static int hf_lte_rrc_hsdn_Indication_r15;        /* BOOLEAN */
static int hf_lte_rrc_interFreqNeighHSDN_CellList_r15;  /* InterFreqNeighHSDN_CellList_r15 */
static int hf_lte_rrc_interFreqNeighCellList_v1610;  /* InterFreqNeighCellList_v1610 */
static int hf_lte_rrc_InterFreqNeighCellList_item;  /* InterFreqNeighCellInfo */
static int hf_lte_rrc_InterFreqNeighCellList_v1610_item;  /* InterFreqNeighCellInfo_v1610 */
static int hf_lte_rrc_InterFreqNeighHSDN_CellList_r15_item;  /* PhysCellIdRange */
static int hf_lte_rrc_InterFreqExcludedCellList_item;  /* PhysCellIdRange */
static int hf_lte_rrc_redistributionFactorFreq_r13;  /* RedistributionFactor_r13 */
static int hf_lte_rrc_redistributionNeighCellList_r13;  /* RedistributionNeighCellList_r13 */
static int hf_lte_rrc_RedistributionNeighCellList_r13_item;  /* RedistributionNeighCell_r13 */
static int hf_lte_rrc_redistributionFactorCell_r13_01;  /* RedistributionFactor_r13 */
static int hf_lte_rrc_carrierFreqListUTRA_FDD;    /* CarrierFreqListUTRA_FDD */
static int hf_lte_rrc_carrierFreqListUTRA_TDD;    /* CarrierFreqListUTRA_TDD */
static int hf_lte_rrc_t_ReselectionUTRA;          /* T_Reselection */
static int hf_lte_rrc_t_ReselectionUTRA_SF;       /* SpeedStateScaleFactors */
static int hf_lte_rrc_lateNonCriticalExtension_11;  /* T_lateNonCriticalExtension_10 */
static int hf_lte_rrc_carrierFreqListUTRA_FDD_v1250;  /* SEQUENCE_SIZE_1_maxUTRA_FDD_Carrier_OF_CarrierFreqInfoUTRA_v1250 */
static int hf_lte_rrc_carrierFreqListUTRA_FDD_v1250_item;  /* CarrierFreqInfoUTRA_v1250 */
static int hf_lte_rrc_carrierFreqListUTRA_TDD_v1250;  /* SEQUENCE_SIZE_1_maxUTRA_TDD_Carrier_OF_CarrierFreqInfoUTRA_v1250 */
static int hf_lte_rrc_carrierFreqListUTRA_TDD_v1250_item;  /* CarrierFreqInfoUTRA_v1250 */
static int hf_lte_rrc_carrierFreqListUTRA_FDD_Ext_r12;  /* CarrierFreqListUTRA_FDD_Ext_r12 */
static int hf_lte_rrc_carrierFreqListUTRA_TDD_Ext_r12;  /* CarrierFreqListUTRA_TDD_Ext_r12 */
static int hf_lte_rrc_carrierFreqListUTRA_FDD_v8h0;  /* SEQUENCE_SIZE_1_maxUTRA_FDD_Carrier_OF_CarrierFreqInfoUTRA_FDD_v8h0 */
static int hf_lte_rrc_carrierFreqListUTRA_FDD_v8h0_item;  /* CarrierFreqInfoUTRA_FDD_v8h0 */
static int hf_lte_rrc_nonCriticalExtension_301;   /* T_nonCriticalExtension_80 */
static int hf_lte_rrc_carrierFreqInfoUTRA_v1250_reducedMeasPerformance_r12;  /* T_carrierFreqInfoUTRA_v1250_reducedMeasPerformance_r12 */
static int hf_lte_rrc_CarrierFreqListUTRA_FDD_item;  /* CarrierFreqUTRA_FDD */
static int hf_lte_rrc_q_RxLevMin_01;              /* INTEGER_M60_M13 */
static int hf_lte_rrc_p_MaxUTRA;                  /* INTEGER_M50_33 */
static int hf_lte_rrc_q_QualMin;                  /* INTEGER_M24_0 */
static int hf_lte_rrc_threshX_Q_r9_01;            /* T_threshX_Q_r9_01 */
static int hf_lte_rrc_multiBandInfoList_02;       /* SEQUENCE_SIZE_1_maxMultiBands_OF_FreqBandIndicator_UTRA_FDD */
static int hf_lte_rrc_multiBandInfoList_item_01;  /* FreqBandIndicator_UTRA_FDD */
static int hf_lte_rrc_CarrierFreqListUTRA_FDD_Ext_r12_item;  /* CarrierFreqUTRA_FDD_Ext_r12 */
static int hf_lte_rrc_carrierFreq_r12_01;         /* ARFCN_ValueUTRA */
static int hf_lte_rrc_q_RxLevMin_r12_01;          /* INTEGER_M60_M13 */
static int hf_lte_rrc_p_MaxUTRA_r12;              /* INTEGER_M50_33 */
static int hf_lte_rrc_q_QualMin_r12_01;           /* INTEGER_M24_0 */
static int hf_lte_rrc_threshX_Q_r12_01;           /* T_threshX_Q_r12_01 */
static int hf_lte_rrc_multiBandInfoList_r12_01;   /* FreqBandIndicator_UTRA_FDD_r12 */
static int hf_lte_rrc_multiBandInfoList_r12_item;  /* FreqBandIndicator_UTRA_FDD */
static int hf_lte_rrc_carrierFreqUTRA_FDD_Ext_r12_reducedMeasPerformance_r12;  /* T_carrierFreqUTRA_FDD_Ext_r12_reducedMeasPerformance_r12 */
static int hf_lte_rrc_CarrierFreqListUTRA_TDD_item;  /* CarrierFreqUTRA_TDD */
static int hf_lte_rrc_CarrierFreqListUTRA_TDD_Ext_r12_item;  /* CarrierFreqUTRA_TDD_r12 */
static int hf_lte_rrc_carrierFreqUTRA_TDD_r12_reducedMeasPerformance_r12;  /* T_carrierFreqUTRA_TDD_r12_reducedMeasPerformance_r12 */
static int hf_lte_rrc_t_ReselectionGERAN;         /* T_Reselection */
static int hf_lte_rrc_t_ReselectionGERAN_SF;      /* SpeedStateScaleFactors */
static int hf_lte_rrc_carrierFreqsInfoList;       /* CarrierFreqsInfoListGERAN */
static int hf_lte_rrc_CarrierFreqsInfoListGERAN_item;  /* CarrierFreqsInfoGERAN */
static int hf_lte_rrc_commonInfo;                 /* T_commonInfo */
static int hf_lte_rrc_ncc_Permitted;              /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_q_RxLevMin_02;              /* INTEGER_0_45 */
static int hf_lte_rrc_p_MaxGERAN;                 /* INTEGER_0_39 */
static int hf_lte_rrc_systemTimeInfo;             /* SystemTimeInfoCDMA2000 */
static int hf_lte_rrc_searchWindowSize;           /* INTEGER_0_15 */
static int hf_lte_rrc_parametersHRPD;             /* T_parametersHRPD */
static int hf_lte_rrc_preRegistrationInfoHRPD;    /* PreRegistrationInfoHRPD */
static int hf_lte_rrc_cellReselectionParametersHRPD;  /* CellReselectionParametersCDMA2000 */
static int hf_lte_rrc_parameters1XRTT;            /* T_parameters1XRTT */
static int hf_lte_rrc_csfb_RegistrationParam1XRTT;  /* CSFB_RegistrationParam1XRTT */
static int hf_lte_rrc_longCodeState1XRTT;         /* BIT_STRING_SIZE_42 */
static int hf_lte_rrc_cellReselectionParameters1XRTT;  /* CellReselectionParametersCDMA2000 */
static int hf_lte_rrc_csfb_SupportForDualRxUEs_r9;  /* BOOLEAN */
static int hf_lte_rrc_cellReselectionParametersHRPD_v920;  /* CellReselectionParametersCDMA2000_v920 */
static int hf_lte_rrc_cellReselectionParameters1XRTT_v920;  /* CellReselectionParametersCDMA2000_v920 */
static int hf_lte_rrc_csfb_RegistrationParam1XRTT_v920;  /* CSFB_RegistrationParam1XRTT_v920 */
static int hf_lte_rrc_ac_BarringConfig1XRTT_r9;   /* AC_BarringConfig1XRTT_r9 */
static int hf_lte_rrc_csfb_DualRxTxSupport_r10;   /* T_csfb_DualRxTxSupport_r10 */
static int hf_lte_rrc_sib8_PerPLMN_List_r11;      /* SIB8_PerPLMN_List_r11 */
static int hf_lte_rrc_bandClassList;              /* BandClassListCDMA2000 */
static int hf_lte_rrc_neighCellList;              /* NeighCellListCDMA2000 */
static int hf_lte_rrc_t_ReselectionCDMA2000;      /* T_Reselection */
static int hf_lte_rrc_t_ReselectionCDMA2000_SF;   /* SpeedStateScaleFactors */
static int hf_lte_rrc_neighCellList_r11;          /* SEQUENCE_SIZE_1_16_OF_NeighCellCDMA2000_r11 */
static int hf_lte_rrc_neighCellList_r11_item;     /* NeighCellCDMA2000_r11 */
static int hf_lte_rrc_neighCellList_v920;         /* NeighCellListCDMA2000_v920 */
static int hf_lte_rrc_NeighCellListCDMA2000_item;  /* NeighCellCDMA2000 */
static int hf_lte_rrc_neighCellsPerFreqList;      /* NeighCellsPerBandclassListCDMA2000 */
static int hf_lte_rrc_neighFreqInfoList_r11;      /* SEQUENCE_SIZE_1_16_OF_NeighCellsPerBandclassCDMA2000_r11 */
static int hf_lte_rrc_neighFreqInfoList_r11_item;  /* NeighCellsPerBandclassCDMA2000_r11 */
static int hf_lte_rrc_NeighCellsPerBandclassListCDMA2000_item;  /* NeighCellsPerBandclassCDMA2000 */
static int hf_lte_rrc_arfcn;                      /* ARFCN_ValueCDMA2000 */
static int hf_lte_rrc_physCellIdList;             /* PhysCellIdListCDMA2000 */
static int hf_lte_rrc_physCellIdList_r11;         /* SEQUENCE_SIZE_1_40_OF_PhysCellIdCDMA2000 */
static int hf_lte_rrc_physCellIdList_r11_item;    /* PhysCellIdCDMA2000 */
static int hf_lte_rrc_NeighCellListCDMA2000_v920_item;  /* NeighCellCDMA2000_v920 */
static int hf_lte_rrc_neighCellsPerFreqList_v920;  /* NeighCellsPerBandclassListCDMA2000_v920 */
static int hf_lte_rrc_NeighCellsPerBandclassListCDMA2000_v920_item;  /* NeighCellsPerBandclassCDMA2000_v920 */
static int hf_lte_rrc_physCellIdList_v920;        /* PhysCellIdListCDMA2000_v920 */
static int hf_lte_rrc_PhysCellIdListCDMA2000_item;  /* PhysCellIdCDMA2000 */
static int hf_lte_rrc_PhysCellIdListCDMA2000_v920_item;  /* PhysCellIdCDMA2000 */
static int hf_lte_rrc_BandClassListCDMA2000_item;  /* BandClassInfoCDMA2000 */
static int hf_lte_rrc_threshX_High_01;            /* INTEGER_0_63 */
static int hf_lte_rrc_threshX_Low_01;             /* INTEGER_0_63 */
static int hf_lte_rrc_ac_Barring0to9_r9;          /* INTEGER_0_63 */
static int hf_lte_rrc_ac_Barring10_r9;            /* INTEGER_0_7 */
static int hf_lte_rrc_ac_Barring11_r9;            /* INTEGER_0_7 */
static int hf_lte_rrc_ac_Barring12_r9;            /* INTEGER_0_7 */
static int hf_lte_rrc_ac_Barring13_r9;            /* INTEGER_0_7 */
static int hf_lte_rrc_ac_Barring14_r9;            /* INTEGER_0_7 */
static int hf_lte_rrc_ac_Barring15_r9;            /* INTEGER_0_7 */
static int hf_lte_rrc_ac_BarringMsg_r9;           /* INTEGER_0_7 */
static int hf_lte_rrc_ac_BarringReg_r9;           /* INTEGER_0_7 */
static int hf_lte_rrc_ac_BarringEmg_r9;           /* INTEGER_0_7 */
static int hf_lte_rrc_SIB8_PerPLMN_List_r11_item;  /* SIB8_PerPLMN_r11 */
static int hf_lte_rrc_plmn_Identity_r11;          /* INTEGER_1_maxPLMN_r11 */
static int hf_lte_rrc_parametersCDMA2000_r11;     /* T_parametersCDMA2000_r11 */
static int hf_lte_rrc_explicitValue;              /* ParametersCDMA2000_r11 */
static int hf_lte_rrc_defaultValue;               /* NULL */
static int hf_lte_rrc_systemTimeInfo_r11;         /* T_systemTimeInfo_r11 */
static int hf_lte_rrc_explicitValue_01;           /* SystemTimeInfoCDMA2000 */
static int hf_lte_rrc_searchWindowSize_r11;       /* INTEGER_0_15 */
static int hf_lte_rrc_parametersHRPD_r11;         /* T_parametersHRPD_r11 */
static int hf_lte_rrc_preRegistrationInfoHRPD_r11;  /* PreRegistrationInfoHRPD */
static int hf_lte_rrc_cellReselectionParametersHRPD_r11;  /* CellReselectionParametersCDMA2000_r11 */
static int hf_lte_rrc_parameters1XRTT_r11;        /* T_parameters1XRTT_r11 */
static int hf_lte_rrc_csfb_RegistrationParam1XRTT_r11;  /* CSFB_RegistrationParam1XRTT */
static int hf_lte_rrc_csfb_RegistrationParam1XRTT_Ext_r11;  /* CSFB_RegistrationParam1XRTT_v920 */
static int hf_lte_rrc_longCodeState1XRTT_r11;     /* BIT_STRING_SIZE_42 */
static int hf_lte_rrc_cellReselectionParameters1XRTT_r11;  /* CellReselectionParametersCDMA2000_r11 */
static int hf_lte_rrc_ac_BarringConfig1XRTT_r11;  /* AC_BarringConfig1XRTT_r9 */
static int hf_lte_rrc_csfb_SupportForDualRxUEs_r11;  /* BOOLEAN */
static int hf_lte_rrc_csfb_DualRxTxSupport_r11;   /* T_csfb_DualRxTxSupport_r11 */
static int hf_lte_rrc_hnb_Name;                   /* T_hnb_Name */
static int hf_lte_rrc_messageIdentifier;          /* T_messageIdentifier */
static int hf_lte_rrc_serialNumber;               /* T_serialNumber */
static int hf_lte_rrc_warningType;                /* T_warningType */
static int hf_lte_rrc_systemInformationBlockType10_dummy;  /* OCTET_STRING_SIZE_50 */
static int hf_lte_rrc_messageIdentifier_01;       /* T_messageIdentifier_01 */
static int hf_lte_rrc_serialNumber_01;            /* T_serialNumber_01 */
static int hf_lte_rrc_warningMessageSegmentType;  /* T_warningMessageSegmentType */
static int hf_lte_rrc_warningMessageSegmentNumber;  /* T_warningMessageSegmentNumber */
static int hf_lte_rrc_warningMessageSegment;      /* T_warningMessageSegment */
static int hf_lte_rrc_dataCodingScheme;           /* T_dataCodingScheme */
static int hf_lte_rrc_messageIdentifier_r9;       /* T_messageIdentifier_r9 */
static int hf_lte_rrc_serialNumber_r9;            /* T_serialNumber_r9 */
static int hf_lte_rrc_warningMessageSegmentType_r9;  /* T_warningMessageSegmentType_r9 */
static int hf_lte_rrc_warningMessageSegmentNumber_r9;  /* T_warningMessageSegmentNumber_r9 */
static int hf_lte_rrc_warningMessageSegment_r9;   /* T_warningMessageSegment_r9 */
static int hf_lte_rrc_dataCodingScheme_r9;        /* T_dataCodingScheme_r9 */
static int hf_lte_rrc_warningAreaCoordinatesSegment_r15;  /* OCTET_STRING */
static int hf_lte_rrc_mbsfn_AreaInfoList_r9;      /* MBSFN_AreaInfoList_r9 */
static int hf_lte_rrc_notificationConfig_r9;      /* MBMS_NotificationConfig_r9 */
static int hf_lte_rrc_notificationConfig_v1430;   /* MBMS_NotificationConfig_v1430 */
static int hf_lte_rrc_mbsfn_AreaInfoList_r16;     /* MBSFN_AreaInfoList_r16 */
static int hf_lte_rrc_mbsfn_AreaInfoList_r17;     /* MBSFN_AreaInfoList_r17 */
static int hf_lte_rrc_eab_Param_r11;              /* T_eab_Param_r11 */
static int hf_lte_rrc_eab_Common_r11;             /* EAB_Config_r11 */
static int hf_lte_rrc_eab_PerPLMN_List_r11;       /* SEQUENCE_SIZE_1_maxPLMN_r11_OF_EAB_ConfigPLMN_r11 */
static int hf_lte_rrc_eab_PerPLMN_List_r11_item;  /* EAB_ConfigPLMN_r11 */
static int hf_lte_rrc_eab_PerRSRP_r15;            /* T_eab_PerRSRP_r15 */
static int hf_lte_rrc_eab_Config_r11;             /* EAB_Config_r11 */
static int hf_lte_rrc_eab_Category_r11;           /* T_eab_Category_r11 */
static int hf_lte_rrc_eab_BarringBitmap_r11;      /* BIT_STRING_SIZE_10 */
static int hf_lte_rrc_mbms_SAI_IntraFreq_r11;     /* MBMS_SAI_List_r11 */
static int hf_lte_rrc_mbms_SAI_InterFreqList_r11;  /* MBMS_SAI_InterFreqList_r11 */
static int hf_lte_rrc_mbms_SAI_InterFreqList_v1140;  /* MBMS_SAI_InterFreqList_v1140 */
static int hf_lte_rrc_mbms_IntraFreqCarrierType_r14;  /* MBMS_CarrierType_r14 */
static int hf_lte_rrc_mbms_InterFreqCarrierTypeList_r14;  /* MBMS_InterFreqCarrierTypeList_r14 */
static int hf_lte_rrc_MBMS_SAI_List_r11_item;     /* MBMS_SAI_r11 */
static int hf_lte_rrc_MBMS_SAI_InterFreqList_r11_item;  /* MBMS_SAI_InterFreq_r11 */
static int hf_lte_rrc_MBMS_SAI_InterFreqList_v1140_item;  /* MBMS_SAI_InterFreq_v1140 */
static int hf_lte_rrc_dl_CarrierFreq_r11;         /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_mbms_SAI_List_r11;          /* MBMS_SAI_List_r11 */
static int hf_lte_rrc_multiBandInfoList_r11;      /* MultiBandInfoList_r11 */
static int hf_lte_rrc_MBMS_InterFreqCarrierTypeList_r14_item;  /* MBMS_CarrierType_r14 */
static int hf_lte_rrc_carrierType_r14;            /* T_carrierType_r14 */
static int hf_lte_rrc_frameOffset_r14;            /* INTEGER_0_3 */
static int hf_lte_rrc_timeInfo_r11;               /* T_timeInfo_r11 */
static int hf_lte_rrc_timeInfoUTC_r11;            /* T_timeInfoUTC_r11 */
static int hf_lte_rrc_dayLightSavingTime_r11;     /* T_dayLightSavingTime_r11 */
static int hf_lte_rrc_leapSeconds_r11;            /* INTEGER_M127_128 */
static int hf_lte_rrc_localTimeOffset_r11;        /* INTEGER_M63_64 */
static int hf_lte_rrc_wlan_OffloadInfoPerPLMN_List_r12;  /* SEQUENCE_SIZE_1_maxPLMN_r11_OF_WLAN_OffloadInfoPerPLMN_r12 */
static int hf_lte_rrc_wlan_OffloadInfoPerPLMN_List_r12_item;  /* WLAN_OffloadInfoPerPLMN_r12 */
static int hf_lte_rrc_wlan_OffloadConfigCommon_r12;  /* WLAN_OffloadConfig_r12 */
static int hf_lte_rrc_wlan_Id_List_r12;           /* WLAN_Id_List_r12 */
static int hf_lte_rrc_WLAN_Id_List_r12_item;      /* WLAN_Identifiers_r12 */
static int hf_lte_rrc_ssid_r12;                   /* T_ssid_r12 */
static int hf_lte_rrc_bssid_r12;                  /* OCTET_STRING_SIZE_6 */
static int hf_lte_rrc_hessid_r12;                 /* OCTET_STRING_SIZE_6 */
static int hf_lte_rrc_commConfig_r12;             /* T_commConfig_r12 */
static int hf_lte_rrc_commRxPool_r12;             /* SL_CommRxPoolList_r12 */
static int hf_lte_rrc_commTxPoolNormalCommon_r12;  /* SL_CommTxPoolList_r12 */
static int hf_lte_rrc_commTxPoolExceptional_r12;  /* SL_CommTxPoolList_r12 */
static int hf_lte_rrc_commSyncConfig_r12;         /* SL_SyncConfigList_r12 */
static int hf_lte_rrc_commTxPoolNormalCommonExt_r13;  /* SL_CommTxPoolListExt_r13 */
static int hf_lte_rrc_commTxResourceUC_ReqAllowed_r13;  /* T_commTxResourceUC_ReqAllowed_r13 */
static int hf_lte_rrc_commTxAllowRelayCommon_r13;  /* T_commTxAllowRelayCommon_r13 */
static int hf_lte_rrc_discConfig_r12;             /* T_discConfig_r12 */
static int hf_lte_rrc_discRxPool_r12;             /* SL_DiscRxPoolList_r12 */
static int hf_lte_rrc_discTxPoolCommon_r12;       /* SL_DiscTxPoolList_r12 */
static int hf_lte_rrc_discTxPowerInfo_r12;        /* SL_DiscTxPowerInfoList_r12 */
static int hf_lte_rrc_discSyncConfig_r12;         /* SL_SyncConfigList_r12 */
static int hf_lte_rrc_discInterFreqList_r12;      /* SL_CarrierFreqInfoList_r12 */
static int hf_lte_rrc_discConfig_v1310;           /* T_discConfig_v1310 */
static int hf_lte_rrc_discInterFreqList_v1310;    /* SL_CarrierFreqInfoList_v1310 */
static int hf_lte_rrc_gapRequestsAllowedCommon;   /* T_gapRequestsAllowedCommon */
static int hf_lte_rrc_discConfigRelay_r13;        /* T_discConfigRelay_r13 */
static int hf_lte_rrc_relayUE_Config_r13;         /* SL_DiscConfigRelayUE_r13 */
static int hf_lte_rrc_remoteUE_Config_r13;        /* SL_DiscConfigRemoteUE_r13 */
static int hf_lte_rrc_discConfigPS_13;            /* T_discConfigPS_13 */
static int hf_lte_rrc_discRxPoolPS_r13;           /* SL_DiscRxPoolList_r12 */
static int hf_lte_rrc_discTxPoolPS_Common_r13;    /* SL_DiscTxPoolList_r12 */
static int hf_lte_rrc_SL_CarrierFreqInfoList_r12_item;  /* SL_CarrierFreqInfo_r12 */
static int hf_lte_rrc_SL_CarrierFreqInfoList_v1310_item;  /* SL_CarrierFreqInfo_v1310 */
static int hf_lte_rrc_plmn_IdentityList_r12;      /* PLMN_IdentityList4_r12 */
static int hf_lte_rrc_threshHigh_r13;             /* RSRP_RangeSL4_r13 */
static int hf_lte_rrc_threshLow_r13;              /* RSRP_RangeSL4_r13 */
static int hf_lte_rrc_hystMax_r13;                /* T_hystMax_r13 */
static int hf_lte_rrc_hystMin_r13;                /* T_hystMin_r13 */
static int hf_lte_rrc_hystMax_r13_01;             /* T_hystMax_r13_01 */
static int hf_lte_rrc_reselectionInfoIC_r13;      /* ReselectionInfoRelay_r13 */
static int hf_lte_rrc_q_RxLevMin_r13;             /* Q_RxLevMin */
static int hf_lte_rrc_filterCoefficient_r13;      /* FilterCoefficient */
static int hf_lte_rrc_minHyst_r13;                /* T_minHyst_r13 */
static int hf_lte_rrc_discResourcesNonPS_r13;     /* SL_ResourcesInterFreq_r13 */
static int hf_lte_rrc_discResourcesPS_r13;        /* SL_ResourcesInterFreq_r13 */
static int hf_lte_rrc_discConfigOther_r13;        /* SL_DiscConfigOtherInterFreq_r13 */
static int hf_lte_rrc_PLMN_IdentityList4_r12_item;  /* PLMN_IdentityInfo2_r12 */
static int hf_lte_rrc_plmn_Index_r12;             /* INTEGER_1_maxPLMN_r11 */
static int hf_lte_rrc_plmnIdentity_r12;           /* PLMN_Identity */
static int hf_lte_rrc_acquireSI_FromCarrier_r13;  /* NULL */
static int hf_lte_rrc_discTxPoolCommon_r13;       /* SL_DiscTxPoolList_r12 */
static int hf_lte_rrc_requestDedicated_r13;       /* NULL */
static int hf_lte_rrc_noTxOnCarrier_r13;          /* NULL */
static int hf_lte_rrc_txPowerInfo_r13;            /* SL_DiscTxPowerInfoList_r12 */
static int hf_lte_rrc_refCarrierCommon_r13;       /* T_refCarrierCommon_r13 */
static int hf_lte_rrc_discSyncConfig_r13;         /* SL_SyncConfigListNFreq_r13 */
static int hf_lte_rrc_discCellSelectionInfo_r13;  /* CellSelectionInfoNFreq_r13 */
static int hf_lte_rrc_discRxResourcesInterFreq_r13;  /* SL_DiscRxPoolList_r12 */
static int hf_lte_rrc_discTxResourcesInterFreq_r13;  /* SL_DiscTxResourcesInterFreq_r13 */
static int hf_lte_rrc_sc_mcch_RepetitionPeriod_r13;  /* T_sc_mcch_RepetitionPeriod_r13 */
static int hf_lte_rrc_sc_mcch_Offset_r13;         /* INTEGER_0_10 */
static int hf_lte_rrc_sc_mcch_FirstSubframe_r13;  /* INTEGER_0_9 */
static int hf_lte_rrc_sc_mcch_duration_r13;       /* INTEGER_2_9 */
static int hf_lte_rrc_sc_mcch_ModificationPeriod_r13;  /* T_sc_mcch_ModificationPeriod_r13 */
static int hf_lte_rrc_br_BCCH_Config_r14;         /* T_br_BCCH_Config_r14 */
static int hf_lte_rrc_systemInformationBlockType20_r13_eag_1_br_BCCH_Config_r14_dummy;  /* T_systemInformationBlockType20_r13_eag_1_br_BCCH_Config_r14_dummy */
static int hf_lte_rrc_dummy2;                     /* T_dummy2 */
static int hf_lte_rrc_mpdcch_Narrowband_SC_MCCH_r14;  /* INTEGER_1_maxAvailNarrowBands_r13 */
static int hf_lte_rrc_mpdcch_NumRepetition_SC_MCCH_r14;  /* T_mpdcch_NumRepetition_SC_MCCH_r14 */
static int hf_lte_rrc_mpdcch_StartSF_SC_MCCH_r14;  /* T_mpdcch_StartSF_SC_MCCH_r14 */
static int hf_lte_rrc_fdd_r14;                    /* T_fdd_r14 */
static int hf_lte_rrc_tdd_r14;                    /* T_tdd_r14 */
static int hf_lte_rrc_mpdcch_PDSCH_HoppingConfig_SC_MCCH_r14;  /* T_mpdcch_PDSCH_HoppingConfig_SC_MCCH_r14 */
static int hf_lte_rrc_sc_mcch_CarrierFreq_r14;    /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_sc_mcch_Offset_BR_r14;      /* INTEGER_0_10 */
static int hf_lte_rrc_sc_mcch_RepetitionPeriod_BR_r14;  /* T_sc_mcch_RepetitionPeriod_BR_r14 */
static int hf_lte_rrc_sc_mcch_ModificationPeriod_BR_r14;  /* T_sc_mcch_ModificationPeriod_BR_r14 */
static int hf_lte_rrc_sc_mcch_SchedulingInfo_r14;  /* SC_MCCH_SchedulingInfo_r14 */
static int hf_lte_rrc_pdsch_maxNumRepetitionCEmodeA_SC_MTCH_r14;  /* T_pdsch_maxNumRepetitionCEmodeA_SC_MTCH_r14 */
static int hf_lte_rrc_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14;  /* T_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14 */
static int hf_lte_rrc_sc_mcch_RepetitionPeriod_v1470;  /* T_sc_mcch_RepetitionPeriod_v1470 */
static int hf_lte_rrc_sc_mcch_ModificationPeriod_v1470;  /* T_sc_mcch_ModificationPeriod_v1470 */
static int hf_lte_rrc_onDurationTimerSCPTM_r14;   /* T_onDurationTimerSCPTM_r14 */
static int hf_lte_rrc_drx_InactivityTimerSCPTM_r14;  /* T_drx_InactivityTimerSCPTM_r14 */
static int hf_lte_rrc_schedulingPeriodStartOffsetSCPTM_r14;  /* T_schedulingPeriodStartOffsetSCPTM_r14 */
static int hf_lte_rrc_sf10;                       /* INTEGER_0_9 */
static int hf_lte_rrc_sf20;                       /* INTEGER_0_19 */
static int hf_lte_rrc_sf32;                       /* INTEGER_0_31 */
static int hf_lte_rrc_sf40;                       /* INTEGER_0_39 */
static int hf_lte_rrc_sf64;                       /* INTEGER_0_63 */
static int hf_lte_rrc_sf80;                       /* INTEGER_0_79 */
static int hf_lte_rrc_sf128;                      /* INTEGER_0_127 */
static int hf_lte_rrc_sf160;                      /* INTEGER_0_159 */
static int hf_lte_rrc_sf256;                      /* INTEGER_0_255 */
static int hf_lte_rrc_sf320;                      /* INTEGER_0_319 */
static int hf_lte_rrc_sf512;                      /* INTEGER_0_511 */
static int hf_lte_rrc_sf640;                      /* INTEGER_0_639 */
static int hf_lte_rrc_sf1024;                     /* INTEGER_0_1023 */
static int hf_lte_rrc_sf2048;                     /* INTEGER_0_2047 */
static int hf_lte_rrc_sf4096;                     /* INTEGER_0_4095 */
static int hf_lte_rrc_sf8192;                     /* INTEGER_0_8191 */
static int hf_lte_rrc_sl_V2X_ConfigCommon_r14;    /* SL_V2X_ConfigCommon_r14 */
static int hf_lte_rrc_anchorCarrierFreqListNR_r16;  /* SL_NR_AnchorCarrierFreqList_r16 */
static int hf_lte_rrc_sl_A2X_ConfigCommon_r18;    /* SL_A2X_ConfigCommon_r18 */
static int hf_lte_rrc_v2x_CommRxPool_r14;         /* SL_CommRxPoolListV2X_r14 */
static int hf_lte_rrc_v2x_CommTxPoolNormalCommon_r14;  /* SL_CommTxPoolListV2X_r14 */
static int hf_lte_rrc_p2x_CommTxPoolNormalCommon_r14;  /* SL_CommTxPoolListV2X_r14 */
static int hf_lte_rrc_v2x_CommTxPoolExceptional_r14;  /* SL_CommResourcePoolV2X_r14 */
static int hf_lte_rrc_v2x_SyncConfig_r14;         /* SL_SyncConfigListV2X_r14 */
static int hf_lte_rrc_v2x_InterFreqInfoList_r14;  /* SL_InterFreqInfoListV2X_r14 */
static int hf_lte_rrc_v2x_ResourceSelectionConfig_r14;  /* SL_CommTxPoolSensingConfig_r14 */
static int hf_lte_rrc_zoneConfig_r14;             /* SL_ZoneConfig_r14 */
static int hf_lte_rrc_typeTxSync_r14;             /* SL_TypeTxSync_r14 */
static int hf_lte_rrc_thresSL_TxPrioritization_r14;  /* SL_Priority_r13 */
static int hf_lte_rrc_anchorCarrierFreqList_r14;  /* SL_AnchorCarrierFreqList_V2X_r14 */
static int hf_lte_rrc_offsetDFN_r14;              /* INTEGER_0_1000 */
static int hf_lte_rrc_cbr_CommonTxConfigList_r14;  /* SL_CBR_CommonTxConfigList_r14 */
static int hf_lte_rrc_a2x_CommRxPool_r18;         /* SL_CommRxPoolListV2X_r14 */
static int hf_lte_rrc_a2x_commTxPool_r18;         /* SL_CommTxPoolListV2X_r14 */
static int hf_lte_rrc_carrierFreqListNR_r15;      /* CarrierFreqListNR_r15 */
static int hf_lte_rrc_t_ReselectionNR_r15;        /* T_Reselection */
static int hf_lte_rrc_t_ReselectionNR_SF_r15;     /* SpeedStateScaleFactors */
static int hf_lte_rrc_carrierFreqListNR_v1610;    /* CarrierFreqListNR_v1610 */
static int hf_lte_rrc_carrierFreqListNR_v1700;    /* CarrierFreqListNR_v1700 */
static int hf_lte_rrc_carrierFreqListNR_v1720;    /* CarrierFreqListNR_v1720 */
static int hf_lte_rrc_carrierFreqListNR_v1810;    /* CarrierFreqListNR_v1810 */
static int hf_lte_rrc_CarrierFreqListNR_r15_item;  /* CarrierFreqNR_r15 */
static int hf_lte_rrc_CarrierFreqListNR_v1610_item;  /* CarrierFreqNR_v1610 */
static int hf_lte_rrc_CarrierFreqListNR_v1700_item;  /* CarrierFreqNR_v1700 */
static int hf_lte_rrc_CarrierFreqListNR_v1720_item;  /* CarrierFreqNR_v1720 */
static int hf_lte_rrc_CarrierFreqListNR_v1810_item;  /* CarrierFreqNR_v1810 */
static int hf_lte_rrc_multiBandInfoList_r15;      /* MultiFrequencyBandListNR_r15 */
static int hf_lte_rrc_multiBandInfoListSUL_r15;   /* MultiFrequencyBandListNR_r15 */
static int hf_lte_rrc_measTimingConfig_r15;       /* MTC_SSB_NR_r15 */
static int hf_lte_rrc_subcarrierSpacingSSB_r15_01;  /* T_subcarrierSpacingSSB_r15_01 */
static int hf_lte_rrc_ss_RSSI_Measurement_r15;    /* SS_RSSI_Measurement_r15 */
static int hf_lte_rrc_threshX_High_r15;           /* ReselectionThreshold */
static int hf_lte_rrc_threshX_Low_r15;            /* ReselectionThreshold */
static int hf_lte_rrc_threshX_Q_r15;              /* T_threshX_Q_r15 */
static int hf_lte_rrc_threshX_HighQ_r15;          /* ReselectionThresholdQ_r9 */
static int hf_lte_rrc_threshX_LowQ_r15;           /* ReselectionThresholdQ_r9 */
static int hf_lte_rrc_q_RxLevMin_r15;             /* INTEGER_M70_M22 */
static int hf_lte_rrc_q_RxLevMinSUL_r15;          /* INTEGER_M70_M22 */
static int hf_lte_rrc_p_MaxNR_r15;                /* P_MaxNR_r15 */
static int hf_lte_rrc_ns_PmaxListNR_r15;          /* NS_PmaxListNR_r15 */
static int hf_lte_rrc_q_QualMin_r15;              /* INTEGER_M43_M12 */
static int hf_lte_rrc_deriveSSB_IndexFromCell_r15;  /* BOOLEAN */
static int hf_lte_rrc_maxRS_IndexCellQual_r15;    /* MaxRS_IndexCellQualNR_r15 */
static int hf_lte_rrc_threshRS_Index_r15;         /* ThresholdListNR_r15 */
static int hf_lte_rrc_multiBandNsPmaxListNR_v1550;  /* MultiBandNsPmaxListNR_1_v1550 */
static int hf_lte_rrc_multiBandNsPmaxListNR_SUL_v1550;  /* MultiBandNsPmaxListNR_v1550 */
static int hf_lte_rrc_ssb_ToMeasure_r15;          /* SSB_ToMeasure_r15 */
static int hf_lte_rrc_ns_PmaxListNR_v1760;        /* NS_PmaxListNR_v1760 */
static int hf_lte_rrc_multiBandNsPmaxListNR_v1760;  /* MultiBandNsPmaxListNR_1_v1760 */
static int hf_lte_rrc_multiBandNsPmaxListNR_SUL_v1760;  /* MultiBandNsPmaxListNR_v1760 */
static int hf_lte_rrc_smtc2_LP_r16;               /* MTC_SSB2_LP_NR_r16 */
static int hf_lte_rrc_ssb_PositionQCL_CommonNR_r16;  /* SSB_PositionQCL_RelationNR_r16 */
static int hf_lte_rrc_allowedCellListNR_r16;      /* AllowedCellListNR_r16 */
static int hf_lte_rrc_highSpeedCarrierNR_r16;     /* T_highSpeedCarrierNR_r16 */
static int hf_lte_rrc_nr_FreqNeighHSDN_CellList_r17;  /* NR_FreqNeighHSDN_CellList_r17 */
static int hf_lte_rrc_subcarrierSpacingSSB_r17_01;  /* T_subcarrierSpacingSSB_r17_01 */
static int hf_lte_rrc_ssb_PositionQCL_CommonNR_r17;  /* SSB_PositionQCL_RelationNR_r17 */
static int hf_lte_rrc_multiBandInfoList_r18;      /* MultiFrequencyBandListNR_r15 */
static int hf_lte_rrc_multiBandInfoListAerial_r18_02;  /* MultiFrequencyBandListNR_r15 */
static int hf_lte_rrc_ns_PmaxListNR_Aerial_r18;   /* NS_PmaxListNR_Aerial_r18 */
static int hf_lte_rrc_multiBandNsPmaxListNR_Aerial_r18;  /* MultiBandNsPmaxListNR_Aerial_1_r18 */
static int hf_lte_rrc_mobileIAB_CellList_r18;     /* PhysCellIdRangeNR_r16 */
static int hf_lte_rrc_mobileIAB_Freq_r18;         /* T_mobileIAB_Freq_r18 */
static int hf_lte_rrc_MultiBandNsPmaxListNR_1_v1550_item;  /* NS_PmaxListNR_r15 */
static int hf_lte_rrc_MultiBandNsPmaxListNR_v1550_item;  /* NS_PmaxListNR_r15 */
static int hf_lte_rrc_MultiBandNsPmaxListNR_1_v1760_item;  /* NS_PmaxListNR_v1760 */
static int hf_lte_rrc_MultiBandNsPmaxListNR_v1760_item;  /* NS_PmaxListNR_v1760 */
static int hf_lte_rrc_MultiBandNsPmaxListNR_Aerial_1_r18_item;  /* NS_PmaxListNR_Aerial_r18 */
static int hf_lte_rrc_AllowedCellListNR_r16_item;  /* PhysCellIdNR_r15 */
static int hf_lte_rrc_NR_FreqNeighHSDN_CellList_r17_item;  /* PhysCellIdRangeNR_r16 */
static int hf_lte_rrc_uac_BarringForCommon_r15;   /* UAC_BarringPerCatList_r15 */
static int hf_lte_rrc_uac_BarringPerPLMN_List_r15;  /* UAC_BarringPerPLMN_List_r15 */
static int hf_lte_rrc_uac_BarringInfoSetList_r15;  /* UAC_BarringInfoSetList_r15 */
static int hf_lte_rrc_uac_AC1_SelectAssistInfo_r15;  /* T_uac_AC1_SelectAssistInfo_r15 */
static int hf_lte_rrc_plmnCommon_r15;             /* UAC_AC1_SelectAssistInfo_r15 */
static int hf_lte_rrc_individualPLMNList_r15;     /* SEQUENCE_SIZE_2_maxPLMN_r11_OF_UAC_AC1_SelectAssistInfo_r15 */
static int hf_lte_rrc_individualPLMNList_r15_item;  /* UAC_AC1_SelectAssistInfo_r15 */
static int hf_lte_rrc_ab_PerRSRP_r16;             /* T_ab_PerRSRP_r16 */
static int hf_lte_rrc_uac_AC1_SelectAssistInfo_r16;  /* SEQUENCE_SIZE_2_maxPLMN_r11_OF_UAC_AC1_SelectAssistInfo_r16 */
static int hf_lte_rrc_uac_AC1_SelectAssistInfo_r16_item;  /* UAC_AC1_SelectAssistInfo_r16 */
static int hf_lte_rrc_uac_BarringInfoSetList_v1700;  /* UAC_BarringInfoSetList_v1700 */
static int hf_lte_rrc_UAC_BarringPerPLMN_List_r15_item;  /* UAC_BarringPerPLMN_r15 */
static int hf_lte_rrc_plmn_IdentityIndex_r15;     /* INTEGER_1_maxPLMN_r11 */
static int hf_lte_rrc_uac_AC_BarringListType_r15;  /* T_uac_AC_BarringListType_r15 */
static int hf_lte_rrc_uac_ImplicitAC_BarringList_r15;  /* SEQUENCE_SIZE_maxAccessCat_1_r15_OF_UAC_BarringInfoSetIndex_r15 */
static int hf_lte_rrc_uac_ImplicitAC_BarringList_r15_item;  /* UAC_BarringInfoSetIndex_r15 */
static int hf_lte_rrc_uac_ExplicitAC_BarringList_r15;  /* UAC_BarringPerCatList_r15 */
static int hf_lte_rrc_UAC_BarringPerCatList_r15_item;  /* UAC_BarringPerCat_r15 */
static int hf_lte_rrc_accessCategory_r15;         /* INTEGER_1_maxAccessCat_1_r15 */
static int hf_lte_rrc_uac_barringInfoSetIndex_r15;  /* UAC_BarringInfoSetIndex_r15 */
static int hf_lte_rrc_UAC_BarringInfoSetList_r15_item;  /* UAC_BarringInfoSet_r15 */
static int hf_lte_rrc_UAC_BarringInfoSetList_v1700_item;  /* UAC_BarringInfoSet_v1700 */
static int hf_lte_rrc_uac_BarringFactor_r15;      /* T_uac_BarringFactor_r15 */
static int hf_lte_rrc_uac_BarringTime_r15;        /* T_uac_BarringTime_r15 */
static int hf_lte_rrc_uac_BarringForAccessIdentity_r15;  /* BIT_STRING_SIZE_7 */
static int hf_lte_rrc_uac_BarringFactorForAI3_r17;  /* T_uac_BarringFactorForAI3_r17 */
static int hf_lte_rrc_v2x_InterFreqInfoList_r15;  /* SL_InterFreqInfoListV2X_r14 */
static int hf_lte_rrc_cbr_pssch_TxConfigList_r15;  /* SL_CBR_PPPP_TxConfigList_r15 */
static int hf_lte_rrc_v2x_PacketDuplicationConfig_r15;  /* SL_V2X_PacketDuplicationConfig_r15 */
static int hf_lte_rrc_syncFreqList_r15;           /* SL_V2X_SyncFreqList_r15 */
static int hf_lte_rrc_slss_TxMultiFreq_r15;       /* T_slss_TxMultiFreq_r15 */
static int hf_lte_rrc_v2x_FreqSelectionConfigList_r15;  /* SL_V2X_FreqSelectionConfigList_r15 */
static int hf_lte_rrc_threshS_RSSI_CBR_r15;       /* INTEGER_0_45 */
static int hf_lte_rrc_plmn_InfoList_r16;          /* PLMN_InfoList_r16 */
static int hf_lte_rrc_bandListENDC_r16;           /* BandListENDC_r16 */
static int hf_lte_rrc_BandListENDC_r16_item;      /* FreqBandIndicatorNR_r15 */
static int hf_lte_rrc_PLMN_InfoList_r16_item;     /* PLMN_Info_r16 */
static int hf_lte_rrc_nr_BandList_r16;            /* BIT_STRING_SIZE_maxBandsENDC_r16 */
static int hf_lte_rrc_carrierFreqListNBIOT_r16;   /* CarrierFreqListNBIOT_r16 */
static int hf_lte_rrc_CarrierFreqListNBIOT_r16_item;  /* CarrierFreqNBIOT_r16 */
static int hf_lte_rrc_carrierFreq_r16_01;         /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_carrierFreqOffset_r16;      /* T_carrierFreqOffset_r16 */
static int hf_lte_rrc_segmentNumber_r16_02;       /* INTEGER_0_63 */
static int hf_lte_rrc_segmentType_r16;            /* T_segmentType_r16 */
static int hf_lte_rrc_segmentContainer_r16;       /* OCTET_STRING */
static int hf_lte_rrc_resourceReservationConfigCommonDL_r16;  /* ResourceReservationConfigDL_r16 */
static int hf_lte_rrc_resourceReservationConfigCommonUL_r16;  /* ResourceReservationConfigUL_r16 */
static int hf_lte_rrc_commonPLMNsWithDisasterCondition_r17;  /* SEQUENCE_SIZE_1_maxPLMN_r11_OF_PLMN_Identity */
static int hf_lte_rrc_commonPLMNsWithDisasterCondition_r17_item;  /* PLMN_Identity */
static int hf_lte_rrc_applicableDisasterInfoList_r17;  /* SEQUENCE_SIZE_1_maxPLMN_r11_OF_ApplicableDisasterInfo_r17 */
static int hf_lte_rrc_applicableDisasterInfoList_r17_item;  /* ApplicableDisasterInfo_r17 */
static int hf_lte_rrc_noDisasterRoaming_r17;      /* NULL */
static int hf_lte_rrc_disasterRelatedIndication_r17;  /* NULL */
static int hf_lte_rrc_commonPLMNs_r17;            /* NULL */
static int hf_lte_rrc_dedicatedPLMNs_r17;         /* SEQUENCE_SIZE_1_maxPLMN_r11_OF_PLMN_Identity */
static int hf_lte_rrc_dedicatedPLMNs_r17_item;    /* PLMN_Identity */
static int hf_lte_rrc_servingSatelliteInfo_r17;   /* ServingSatelliteInfo_r17 */
static int hf_lte_rrc_servingSatelliteInfo_v1820;  /* ServingSatelliteInfo_v1820 */
static int hf_lte_rrc_ephemerisInfo_r17;          /* T_ephemerisInfo_r17 */
static int hf_lte_rrc_stateVectors;               /* EphemerisStateVectors_r17 */
static int hf_lte_rrc_orbitalParameters;          /* EphemerisOrbitalParameters_r17 */
static int hf_lte_rrc_nta_CommonParameters_r17;   /* T_nta_CommonParameters_r17 */
static int hf_lte_rrc_nta_Common_r17;             /* INTEGER_0_8316827 */
static int hf_lte_rrc_nta_CommonDrift_r17;        /* INTEGER_M261935_261935 */
static int hf_lte_rrc_nta_CommonDriftVariation_r17;  /* INTEGER_0_29479 */
static int hf_lte_rrc_ul_SyncValidityDuration_r17;  /* T_ul_SyncValidityDuration_r17 */
static int hf_lte_rrc_epochTime_r17;              /* T_epochTime_r17 */
static int hf_lte_rrc_startSFN_r17;               /* INTEGER_0_1023 */
static int hf_lte_rrc_startSubFrame_r17;          /* INTEGER_0_9 */
static int hf_lte_rrc_k_Offset_r17;               /* INTEGER_0_1023 */
static int hf_lte_rrc_k_Mac_r17;                  /* INTEGER_1_512 */
static int hf_lte_rrc_satelliteId_r18;            /* SatelliteId_r18 */
static int hf_lte_rrc_referenceLocation_r18;      /* T_referenceLocation_r18 */
static int hf_lte_rrc_fixedReferenceLocation_r18;  /* ReferenceLocation_r18 */
static int hf_lte_rrc_movingReferenceLocation_r18;  /* ReferenceLocation_r18 */
static int hf_lte_rrc_distanceThresh_r18;         /* INTEGER_0_65535 */
static int hf_lte_rrc_satelliteInfoList_r17;      /* SatelliteInfoList_r17 */
static int hf_lte_rrc_satelliteInfoList_v1800;    /* SatelliteInfoList_v1800 */
static int hf_lte_rrc_SatelliteInfoList_r17_item;  /* SatelliteInfo_r17 */
static int hf_lte_rrc_SatelliteInfoList_v1800_item;  /* CarrierFreqList_v1800 */
static int hf_lte_rrc_satelliteId_r17;            /* INTEGER_0_255 */
static int hf_lte_rrc_serviceInfo_r17;            /* T_serviceInfo_r17 */
static int hf_lte_rrc_tle_EphemerisParameters_r17;  /* TLE_EphemerisParameters_r17 */
static int hf_lte_rrc_t_ServiceStart_r17;         /* TimeOffsetUTC_r17 */
static int hf_lte_rrc_footprintInfo_r17;          /* T_footprintInfo_r17 */
static int hf_lte_rrc_referencePoint_r17;         /* T_referencePoint_r17 */
static int hf_lte_rrc_longitude_r17;              /* INTEGER_M131072_131071 */
static int hf_lte_rrc_latitude_r17;               /* INTEGER_M131072_131071 */
static int hf_lte_rrc_elevationAngles_r17;        /* T_elevationAngles_r17 */
static int hf_lte_rrc_elevationAngleRight_r17;    /* INTEGER_M14_14 */
static int hf_lte_rrc_elevationAngleLeft_r17;     /* INTEGER_M14_14 */
static int hf_lte_rrc_radius_r17;                 /* INTEGER_1_256 */
static int hf_lte_rrc_CarrierFreqList_v1800_item;  /* ARFCN_ValueEUTRA */
static int hf_lte_rrc_neighSatelliteInfoList_r18;  /* NeighSatelliteInfoList_r18 */
static int hf_lte_rrc_neighValidityDuration_r18;  /* T_neighValidityDuration_r18 */
static int hf_lte_rrc_NeighSatelliteInfoList_r18_item;  /* NeighSatelliteInfo_r18 */
static int hf_lte_rrc_ephemerisInfo_r18;          /* T_ephemerisInfo_r18 */
static int hf_lte_rrc_stateVectors_r18;           /* EphemerisStateVectors_r17 */
static int hf_lte_rrc_orbitalParameters_r18;      /* EphemerisOrbitalParameters_r17 */
static int hf_lte_rrc_nta_CommonParameters_r18;   /* T_nta_CommonParameters_r18 */
static int hf_lte_rrc_nta_Common_r18;             /* INTEGER_0_8316827 */
static int hf_lte_rrc_nta_CommonDrift_r18;        /* INTEGER_M261935_261935 */
static int hf_lte_rrc_nta_CommonDriftVariation_r18;  /* INTEGER_0_29479 */
static int hf_lte_rrc_epochTime_r18;              /* T_epochTime_r18 */
static int hf_lte_rrc_startSFN_r18;               /* INTEGER_0_1023 */
static int hf_lte_rrc_startSubFrame_r18;          /* INTEGER_0_9 */
static int hf_lte_rrc_k_Mac_r18;                  /* INTEGER_1_512 */
static int hf_lte_rrc_t_ServiceStartNeigh_r18;    /* TimeOffsetUTC_r17 */
static int hf_lte_rrc_antennaPortsCount;          /* T_antennaPortsCount */
static int hf_lte_rrc_transmissionMode;           /* T_transmissionMode */
static int hf_lte_rrc_codebookSubsetRestriction;  /* T_codebookSubsetRestriction */
static int hf_lte_rrc_n2TxAntenna_tm3;            /* BIT_STRING_SIZE_2 */
static int hf_lte_rrc_n4TxAntenna_tm3;            /* BIT_STRING_SIZE_4 */
static int hf_lte_rrc_n2TxAntenna_tm4;            /* BIT_STRING_SIZE_6 */
static int hf_lte_rrc_n4TxAntenna_tm4;            /* BIT_STRING_SIZE_64 */
static int hf_lte_rrc_n2TxAntenna_tm5;            /* BIT_STRING_SIZE_4 */
static int hf_lte_rrc_n4TxAntenna_tm5;            /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_n2TxAntenna_tm6;            /* BIT_STRING_SIZE_4 */
static int hf_lte_rrc_n4TxAntenna_tm6;            /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_ue_TransmitAntennaSelection;  /* T_ue_TransmitAntennaSelection */
static int hf_lte_rrc_antennaInfoDedicated_ue_TransmitAntennaSelection_setup;  /* T_antennaInfoDedicated_ue_TransmitAntennaSelection_setup */
static int hf_lte_rrc_codebookSubsetRestriction_v920;  /* T_codebookSubsetRestriction_v920 */
static int hf_lte_rrc_n2TxAntenna_tm8_r9;         /* BIT_STRING_SIZE_6 */
static int hf_lte_rrc_n4TxAntenna_tm8_r9;         /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_transmissionMode_r10;       /* T_transmissionMode_r10 */
static int hf_lte_rrc_codebookSubsetRestriction_r10;  /* BIT_STRING */
static int hf_lte_rrc_ue_TransmitAntennaSelection_01;  /* T_ue_TransmitAntennaSelection_01 */
static int hf_lte_rrc_antennaInfoDedicated_r10_ue_TransmitAntennaSelection_setup;  /* T_antennaInfoDedicated_r10_ue_TransmitAntennaSelection_setup */
static int hf_lte_rrc_maxLayersMIMO_r10;          /* T_maxLayersMIMO_r10 */
static int hf_lte_rrc_alternativeCodebookEnabledFor4TX_r12;  /* BOOLEAN */
static int hf_lte_rrc_ce_UE_TxAntennaSelection_config_r14;  /* T_ce_UE_TxAntennaSelection_config_r14 */
static int hf_lte_rrc_antennaInfoDedicatedSTTI_r15_setup;  /* T_antennaInfoDedicatedSTTI_r15_setup */
static int hf_lte_rrc_transmissionModeDL_MBSFN_r15;  /* T_transmissionModeDL_MBSFN_r15 */
static int hf_lte_rrc_transmissionModeDL_nonMBSFN_r15;  /* T_transmissionModeDL_nonMBSFN_r15 */
static int hf_lte_rrc_codebookSubsetRestriction_01;  /* T_codebookSubsetRestriction_01 */
static int hf_lte_rrc_n2TxAntenna_tm3_r15;        /* BIT_STRING_SIZE_2 */
static int hf_lte_rrc_n4TxAntenna_tm3_r15;        /* BIT_STRING_SIZE_4 */
static int hf_lte_rrc_n2TxAntenna_tm4_r15;        /* BIT_STRING_SIZE_6 */
static int hf_lte_rrc_n4TxAntenna_tm4_r15;        /* BIT_STRING_SIZE_64 */
static int hf_lte_rrc_n2TxAntenna_tm5_r15;        /* BIT_STRING_SIZE_4 */
static int hf_lte_rrc_n4TxAntenna_tm5_r15;        /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_n2TxAntenna_tm6_r15;        /* BIT_STRING_SIZE_4 */
static int hf_lte_rrc_n4TxAntenna_tm6_r15;        /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_n2TxAntenna_tm8_r15;        /* BIT_STRING_SIZE_6 */
static int hf_lte_rrc_n4TxAntenna_tm8_r15;        /* BIT_STRING_SIZE_64 */
static int hf_lte_rrc_n2TxAntenna_tm9and10_r15;   /* BIT_STRING_SIZE_6 */
static int hf_lte_rrc_n4TxAntenna_tm9and10_r15;   /* BIT_STRING_SIZE_96 */
static int hf_lte_rrc_n8TxAntenna_tm9and10_r15;   /* BIT_STRING_SIZE_109 */
static int hf_lte_rrc_maxLayersMIMO_STTI_r15;     /* T_maxLayersMIMO_STTI_r15 */
static int hf_lte_rrc_slotSubslotPDSCH_TxDiv_2Layer_r15;  /* BOOLEAN */
static int hf_lte_rrc_slotSubslotPDSCH_TxDiv_4Layer_r15;  /* BOOLEAN */
static int hf_lte_rrc_antennaInfoDedicated_v1530_setup;  /* T_antennaInfoDedicated_v1530_setup */
static int hf_lte_rrc_ue_TxAntennaSelection_SRS_1T4R_Config_r15;  /* NULL */
static int hf_lte_rrc_ue_TxAntennaSelection_SRS_2T4R_NrOfPairs_r15;  /* T_ue_TxAntennaSelection_SRS_2T4R_NrOfPairs_r15 */
static int hf_lte_rrc_transmissionModeUL_r10;     /* T_transmissionModeUL_r10 */
static int hf_lte_rrc_fourAntennaPortActivated_r10;  /* T_fourAntennaPortActivated_r10 */
static int hf_lte_rrc_transmissionModeUL_STTI_r15;  /* T_transmissionModeUL_STTI_r15 */
static int hf_lte_rrc_aUL_Config_r15_setup;       /* T_aUL_Config_r15_setup */
static int hf_lte_rrc_aul_CRNTI_r15;              /* C_RNTI */
static int hf_lte_rrc_aul_Subframes_r15;          /* BIT_STRING_SIZE_40 */
static int hf_lte_rrc_aul_HARQ_Processes_r15;     /* INTEGER_1_16 */
static int hf_lte_rrc_transmissionModeUL_AUL_r15;  /* T_transmissionModeUL_AUL_r15 */
static int hf_lte_rrc_aul_StartingFullBW_InsideMCOT_r15;  /* BIT_STRING_SIZE_5 */
static int hf_lte_rrc_aul_StartingFullBW_OutsideMCOT_r15;  /* BIT_STRING_SIZE_7 */
static int hf_lte_rrc_aul_StartingPartialBW_InsideMCOT_r15;  /* T_aul_StartingPartialBW_InsideMCOT_r15 */
static int hf_lte_rrc_aul_StartingPartialBW_OutsideMCOT_r15;  /* T_aul_StartingPartialBW_OutsideMCOT_r15 */
static int hf_lte_rrc_aul_RetransmissionTimer_r15;  /* T_aul_RetransmissionTimer_r15 */
static int hf_lte_rrc_endingSymbolAUL_r15;        /* INTEGER_12_13 */
static int hf_lte_rrc_subframeOffsetCOT_Sharing_r15;  /* INTEGER_2_4 */
static int hf_lte_rrc_contentionWindowSizeTimer_r15;  /* T_contentionWindowSizeTimer_r15 */
static int hf_lte_rrc_cQI_ReportAperiodic_r10_setup;  /* T_cQI_ReportAperiodic_r10_setup */
static int hf_lte_rrc_cqi_ReportModeAperiodic_r10;  /* CQI_ReportModeAperiodic */
static int hf_lte_rrc_aperiodicCSI_Trigger_r10;   /* T_aperiodicCSI_Trigger_r10 */
static int hf_lte_rrc_trigger1_r10;               /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_trigger2_r10;               /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_cQI_ReportAperiodic_v1250_setup;  /* T_cQI_ReportAperiodic_v1250_setup */
static int hf_lte_rrc_aperiodicCSI_Trigger_v1250;  /* T_aperiodicCSI_Trigger_v1250 */
static int hf_lte_rrc_trigger_SubframeSetIndicator_r12;  /* T_trigger_SubframeSetIndicator_r12 */
static int hf_lte_rrc_trigger1_SubframeSetIndicator_r12;  /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_trigger2_SubframeSetIndicator_r12;  /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_cQI_ReportAperiodic_v1310_setup;  /* T_cQI_ReportAperiodic_v1310_setup */
static int hf_lte_rrc_aperiodicCSI_Trigger_v1310;  /* T_aperiodicCSI_Trigger_v1310 */
static int hf_lte_rrc_trigger1_r13;               /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_trigger2_r13;               /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_trigger3_r13;               /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_trigger4_r13;               /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_trigger5_r13;               /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_trigger6_r13;               /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_aperiodicCSI_Trigger2_r13;  /* T_aperiodicCSI_Trigger2_r13 */
static int hf_lte_rrc_cQI_ReportAperiodic_v1310_setup_aperiodicCSI_Trigger2_r13_setup;  /* T_cQI_ReportAperiodic_v1310_setup_aperiodicCSI_Trigger2_r13_setup */
static int hf_lte_rrc_trigger1_SubframeSetIndicator_r13;  /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_trigger2_SubframeSetIndicator_r13;  /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_trigger3_SubframeSetIndicator_r13;  /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_trigger4_SubframeSetIndicator_r13;  /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_trigger5_SubframeSetIndicator_r13;  /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_trigger6_SubframeSetIndicator_r13;  /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_cqi_ReportModeAperiodic_r11;  /* CQI_ReportModeAperiodic */
static int hf_lte_rrc_trigger01_r11;              /* BOOLEAN */
static int hf_lte_rrc_trigger10_r11;              /* BOOLEAN */
static int hf_lte_rrc_trigger11_r11;              /* BOOLEAN */
static int hf_lte_rrc_trigger001_r13;             /* BOOLEAN */
static int hf_lte_rrc_trigger010_r13;             /* BOOLEAN */
static int hf_lte_rrc_trigger011_r13;             /* BOOLEAN */
static int hf_lte_rrc_trigger100_r13;             /* BOOLEAN */
static int hf_lte_rrc_trigger101_r13;             /* BOOLEAN */
static int hf_lte_rrc_trigger110_r13;             /* BOOLEAN */
static int hf_lte_rrc_trigger111_r13;             /* BOOLEAN */
static int hf_lte_rrc_triggers_r14;               /* T_triggers_r14 */
static int hf_lte_rrc_oneBit_r14;                 /* T_oneBit_r14 */
static int hf_lte_rrc_trigger1_Indicator_r14;     /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_twoBit_r14;                 /* T_twoBit_r14 */
static int hf_lte_rrc_trigger01_Indicator_r14;    /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_trigger10_Indicator_r14;    /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_trigger11_Indicator_r14;    /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_threeBit_r14;               /* T_threeBit_r14 */
static int hf_lte_rrc_trigger001_Indicator_r14;   /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_trigger010_Indicator_r14;   /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_trigger011_Indicator_r14;   /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_trigger100_Indicator_r14;   /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_trigger101_Indicator_r14;   /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_trigger110_Indicator_r14;   /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_trigger111_Indicator_r14;   /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_csi_IM_ConfigToReleaseList_r11;  /* CSI_IM_ConfigToReleaseList_r11 */
static int hf_lte_rrc_csi_IM_ConfigToAddModList_r11;  /* CSI_IM_ConfigToAddModList_r11 */
static int hf_lte_rrc_csi_ProcessToReleaseList_r11;  /* CSI_ProcessToReleaseList_r11 */
static int hf_lte_rrc_csi_ProcessToAddModList_r11;  /* CSI_ProcessToAddModList_r11 */
static int hf_lte_rrc_csi_IM_ConfigToReleaseListExt_r12;  /* CSI_IM_ConfigId_v1250 */
static int hf_lte_rrc_csi_IM_ConfigToAddModListExt_r12;  /* CSI_IM_ConfigExt_r12 */
static int hf_lte_rrc_csi_IM_ConfigToReleaseListExt_r13;  /* CSI_IM_ConfigToReleaseListExt_r13 */
static int hf_lte_rrc_csi_IM_ConfigToAddModListExt_r13;  /* CSI_IM_ConfigToAddModListExt_r13 */
static int hf_lte_rrc_CSI_IM_ConfigToAddModList_r11_item;  /* CSI_IM_Config_r11 */
static int hf_lte_rrc_CSI_IM_ConfigToAddModListExt_r13_item;  /* CSI_IM_ConfigExt_r12 */
static int hf_lte_rrc_CSI_IM_ConfigToReleaseList_r11_item;  /* CSI_IM_ConfigId_r11 */
static int hf_lte_rrc_CSI_IM_ConfigToReleaseListExt_r13_item;  /* CSI_IM_ConfigId_v1310 */
static int hf_lte_rrc_CSI_ProcessToAddModList_r11_item;  /* CSI_Process_r11 */
static int hf_lte_rrc_CSI_ProcessToReleaseList_r11_item;  /* CSI_ProcessId_r11 */
static int hf_lte_rrc_ri_Ref_CSI_ProcessId_r11;   /* CSI_ProcessId_r11 */
static int hf_lte_rrc_pmi_RI_Report_r11;          /* T_pmi_RI_Report_r11 */
static int hf_lte_rrc_cqi_ReportModeAperiodic;    /* CQI_ReportModeAperiodic */
static int hf_lte_rrc_nomPDSCH_RS_EPRE_Offset;    /* INTEGER_M1_6 */
static int hf_lte_rrc_cqi_ReportPeriodic;         /* CQI_ReportPeriodic */
static int hf_lte_rrc_cqi_Mask_r9;                /* T_cqi_Mask_r9 */
static int hf_lte_rrc_pmi_RI_Report_r9;           /* T_pmi_RI_Report_r9 */
static int hf_lte_rrc_cqi_ReportAperiodic_r10;    /* CQI_ReportAperiodic_r10 */
static int hf_lte_rrc_cqi_ReportPeriodic_r10;     /* CQI_ReportPeriodic_r10 */
static int hf_lte_rrc_pmi_RI_Report_r9_01;        /* T_pmi_RI_Report_r9_01 */
static int hf_lte_rrc_csi_SubframePatternConfig_r10;  /* T_csi_SubframePatternConfig_r10 */
static int hf_lte_rrc_cQI_ReportConfig_r10_csi_SubframePatternConfig_r10_setup;  /* T_cQI_ReportConfig_r10_csi_SubframePatternConfig_r10_setup */
static int hf_lte_rrc_csi_MeasSubframeSet1_r10;   /* MeasSubframePattern_r10 */
static int hf_lte_rrc_csi_MeasSubframeSet2_r10;   /* MeasSubframePattern_r10 */
static int hf_lte_rrc_cqi_ReportPeriodic_v1130;   /* CQI_ReportPeriodic_v1130 */
static int hf_lte_rrc_cqi_ReportBoth_r11;         /* CQI_ReportBoth_r11 */
static int hf_lte_rrc_csi_SubframePatternConfig_r12;  /* T_csi_SubframePatternConfig_r12 */
static int hf_lte_rrc_cQI_ReportConfig_v1250_csi_SubframePatternConfig_r12_setup;  /* T_cQI_ReportConfig_v1250_csi_SubframePatternConfig_r12_setup */
static int hf_lte_rrc_csi_MeasSubframeSets_r12;   /* BIT_STRING_SIZE_10 */
static int hf_lte_rrc_cqi_ReportBoth_v1250;       /* CQI_ReportBoth_v1250 */
static int hf_lte_rrc_cqi_ReportAperiodic_v1250;  /* CQI_ReportAperiodic_v1250 */
static int hf_lte_rrc_altCQI_Table_r12;           /* T_altCQI_Table_r12 */
static int hf_lte_rrc_cqi_ReportBoth_v1310;       /* CQI_ReportBoth_v1310 */
static int hf_lte_rrc_cqi_ReportAperiodic_v1310;  /* CQI_ReportAperiodic_v1310 */
static int hf_lte_rrc_cqi_ReportPeriodic_v1310;   /* CQI_ReportPeriodic_v1310 */
static int hf_lte_rrc_cqi_ReportPeriodic_v1320;   /* CQI_ReportPeriodic_v1320 */
static int hf_lte_rrc_cqi_ReportAperiodicHybrid_r14;  /* CQI_ReportAperiodicHybrid_r14 */
static int hf_lte_rrc_altCQI_Table_1024QAM_r15;   /* T_altCQI_Table_1024QAM_r15 */
static int hf_lte_rrc_cQI_ReportConfig_r15_setup;  /* T_cQI_ReportConfig_r15_setup */
static int hf_lte_rrc_cqi_ReportConfig_r10;       /* CQI_ReportConfig_r10 */
static int hf_lte_rrc_cqi_ReportConfig_v1130;     /* CQI_ReportConfig_v1130 */
static int hf_lte_rrc_cqi_ReportConfigPCell_v1250;  /* CQI_ReportConfig_v1250 */
static int hf_lte_rrc_cqi_ReportConfig_v1310;     /* CQI_ReportConfig_v1310 */
static int hf_lte_rrc_cqi_ReportConfig_v1320;     /* CQI_ReportConfig_v1320 */
static int hf_lte_rrc_cqi_ReportConfig_v1430;     /* CQI_ReportConfig_v1430 */
static int hf_lte_rrc_altCQI_Table_1024QAM_r15_01;  /* T_altCQI_Table_1024QAM_r15_01 */
static int hf_lte_rrc_nomPDSCH_RS_EPRE_Offset_r10;  /* INTEGER_M1_6 */
static int hf_lte_rrc_cqi_ReportPeriodicSCell_r10;  /* CQI_ReportPeriodic_r10 */
static int hf_lte_rrc_pmi_RI_Report_r10;          /* T_pmi_RI_Report_r10 */
static int hf_lte_rrc_cqi_ReportPeriodicSCell_r15;  /* CQI_ReportPeriodicSCell_r15 */
static int hf_lte_rrc_altCQI_Table_1024QAM_r15_02;  /* T_altCQI_Table_1024QAM_r15_02 */
static int hf_lte_rrc_cQI_ReportPeriodic_setup;   /* T_cQI_ReportPeriodic_setup */
static int hf_lte_rrc_cqi_PUCCH_ResourceIndex;    /* INTEGER_0_1185 */
static int hf_lte_rrc_cqi_pmi_ConfigIndex;        /* INTEGER_0_1023 */
static int hf_lte_rrc_cqi_FormatIndicatorPeriodic;  /* T_cqi_FormatIndicatorPeriodic */
static int hf_lte_rrc_widebandCQI;                /* NULL */
static int hf_lte_rrc_subbandCQI;                 /* T_subbandCQI */
static int hf_lte_rrc_k;                          /* INTEGER_1_4 */
static int hf_lte_rrc_ri_ConfigIndex;             /* INTEGER_0_1023 */
static int hf_lte_rrc_simultaneousAckNackAndCQI;  /* BOOLEAN */
static int hf_lte_rrc_cQI_ReportPeriodic_r10_setup;  /* T_cQI_ReportPeriodic_r10_setup */
static int hf_lte_rrc_cqi_PUCCH_ResourceIndex_r10;  /* INTEGER_0_1184 */
static int hf_lte_rrc_cqi_PUCCH_ResourceIndexP1_r10;  /* INTEGER_0_1184 */
static int hf_lte_rrc_cqi_FormatIndicatorPeriodic_r10;  /* T_cqi_FormatIndicatorPeriodic_r10 */
static int hf_lte_rrc_widebandCQI_r10;            /* T_widebandCQI_r10 */
static int hf_lte_rrc_csi_ReportMode_r10;         /* T_csi_ReportMode_r10 */
static int hf_lte_rrc_subbandCQI_r10;             /* T_subbandCQI_r10 */
static int hf_lte_rrc_periodicityFactor_r10;      /* T_periodicityFactor_r10 */
static int hf_lte_rrc_cqi_Mask_r9_01;             /* T_cqi_Mask_r9_01 */
static int hf_lte_rrc_csi_ConfigIndex_r10;        /* T_csi_ConfigIndex_r10 */
static int hf_lte_rrc_cQI_ReportPeriodic_r10_setup_csi_ConfigIndex_r10_setup;  /* T_cQI_ReportPeriodic_r10_setup_csi_ConfigIndex_r10_setup */
static int hf_lte_rrc_cqi_pmi_ConfigIndex2_r10;   /* INTEGER_0_1023 */
static int hf_lte_rrc_ri_ConfigIndex2_r10;        /* INTEGER_0_1023 */
static int hf_lte_rrc_simultaneousAckNackAndCQI_Format3_r11;  /* T_simultaneousAckNackAndCQI_Format3_r11 */
static int hf_lte_rrc_cqi_ReportPeriodicProcExtToReleaseList_r11;  /* CQI_ReportPeriodicProcExtToReleaseList_r11 */
static int hf_lte_rrc_cqi_ReportPeriodicProcExtToAddModList_r11;  /* CQI_ReportPeriodicProcExtToAddModList_r11 */
static int hf_lte_rrc_cri_ReportConfig_r13;       /* CRI_ReportConfig_r13 */
static int hf_lte_rrc_simultaneousAckNackAndCQI_Format4_Format5_r13;  /* T_simultaneousAckNackAndCQI_Format4_Format5_r13 */
static int hf_lte_rrc_periodicityFactorWB_r13;    /* T_periodicityFactorWB_r13 */
static int hf_lte_rrc_cQI_ReportPeriodicSCell_r15_setup;  /* T_cQI_ReportPeriodicSCell_r15_setup */
static int hf_lte_rrc_cqi_pmi_ConfigIndexDormant_r15;  /* INTEGER_0_1023 */
static int hf_lte_rrc_ri_ConfigIndexDormant_r15;  /* INTEGER_0_1023 */
static int hf_lte_rrc_csi_SubframePatternDormant_r15;  /* T_csi_SubframePatternDormant_r15 */
static int hf_lte_rrc_cQI_ReportPeriodicSCell_r15_setup_csi_SubframePatternDormant_r15_setup;  /* T_cQI_ReportPeriodicSCell_r15_setup_csi_SubframePatternDormant_r15_setup */
static int hf_lte_rrc_csi_MeasSubframeSet1_r15;   /* MeasSubframePattern_r10 */
static int hf_lte_rrc_csi_MeasSubframeSet2_r15;   /* MeasSubframePattern_r10 */
static int hf_lte_rrc_cqi_FormatIndicatorDormant_r15;  /* T_cqi_FormatIndicatorDormant_r15 */
static int hf_lte_rrc_widebandCQI_r15;            /* T_widebandCQI_r15 */
static int hf_lte_rrc_csi_ReportMode_r15;         /* T_csi_ReportMode_r15 */
static int hf_lte_rrc_subbandCQI_r15;             /* T_subbandCQI_r15 */
static int hf_lte_rrc_k_r15;                      /* INTEGER_1_4 */
static int hf_lte_rrc_periodicityFactor_r15;      /* T_periodicityFactor_r15 */
static int hf_lte_rrc_CQI_ReportPeriodicProcExtToAddModList_r11_item;  /* CQI_ReportPeriodicProcExt_r11 */
static int hf_lte_rrc_CQI_ReportPeriodicProcExtToReleaseList_r11_item;  /* CQI_ReportPeriodicProcExtId_r11 */
static int hf_lte_rrc_cqi_ReportPeriodicProcExtId_r11;  /* CQI_ReportPeriodicProcExtId_r11 */
static int hf_lte_rrc_cqi_pmi_ConfigIndex_r11;    /* INTEGER_0_1023 */
static int hf_lte_rrc_cqi_FormatIndicatorPeriodic_r11;  /* T_cqi_FormatIndicatorPeriodic_r11 */
static int hf_lte_rrc_widebandCQI_r11;            /* T_widebandCQI_r11 */
static int hf_lte_rrc_csi_ReportMode_r11;         /* T_csi_ReportMode_r11 */
static int hf_lte_rrc_subbandCQI_r11;             /* T_subbandCQI_r11 */
static int hf_lte_rrc_periodicityFactor_r11;      /* T_periodicityFactor_r11 */
static int hf_lte_rrc_ri_ConfigIndex_r11;         /* INTEGER_0_1023 */
static int hf_lte_rrc_csi_ConfigIndex_r11;        /* T_csi_ConfigIndex_r11 */
static int hf_lte_rrc_cQI_ReportPeriodicProcExt_r11_csi_ConfigIndex_r11_setup;  /* T_cQI_ReportPeriodicProcExt_r11_csi_ConfigIndex_r11_setup */
static int hf_lte_rrc_cqi_pmi_ConfigIndex2_r11;   /* INTEGER_0_1023 */
static int hf_lte_rrc_ri_ConfigIndex2_r11;        /* INTEGER_0_1023 */
static int hf_lte_rrc_periodicityFactorWB_r13_01;  /* T_periodicityFactorWB_r13_01 */
static int hf_lte_rrc_cQI_ShortConfigSCell_r15_setup;  /* T_cQI_ShortConfigSCell_r15_setup */
static int hf_lte_rrc_cqi_pmi_ConfigIndexShort_r15;  /* INTEGER_0_1023 */
static int hf_lte_rrc_ri_ConfigIndexShort_r15;    /* INTEGER_0_1023 */
static int hf_lte_rrc_cqi_FormatIndicatorShort_r15;  /* T_cqi_FormatIndicatorShort_r15 */
static int hf_lte_rrc_widebandCQI_Short_r15;      /* T_widebandCQI_Short_r15 */
static int hf_lte_rrc_csi_ReportModeShort_r15;    /* T_csi_ReportModeShort_r15 */
static int hf_lte_rrc_subbandCQI_Short_r15;       /* T_subbandCQI_Short_r15 */
static int hf_lte_rrc_periodicityFactor_r15_01;   /* T_periodicityFactor_r15_01 */
static int hf_lte_rrc_cqi_pmi_ConfigIndex2Dormant_r17;  /* INTEGER_0_1023 */
static int hf_lte_rrc_ri_ConfigIndex2Dormant_r17;  /* INTEGER_0_1023 */
static int hf_lte_rrc_cRI_ReportConfig_r13_setup;  /* T_cRI_ReportConfig_r13_setup */
static int hf_lte_rrc_cri_ConfigIndex_r13;        /* CRI_ConfigIndex_r13 */
static int hf_lte_rrc_cri_ConfigIndex2_r13;       /* CRI_ConfigIndex_r13 */
static int hf_lte_rrc_schedulingCellInfo_r10;     /* T_schedulingCellInfo_r10 */
static int hf_lte_rrc_own_r10;                    /* T_own_r10 */
static int hf_lte_rrc_cif_Presence_r10;           /* BOOLEAN */
static int hf_lte_rrc_other_r10;                  /* T_other_r10 */
static int hf_lte_rrc_schedulingCellId_r10;       /* ServCellIndex_r10 */
static int hf_lte_rrc_pdsch_Start_r10;            /* INTEGER_1_4 */
static int hf_lte_rrc_schedulingCellInfo_r13;     /* T_schedulingCellInfo_r13 */
static int hf_lte_rrc_own_r13;                    /* T_own_r13 */
static int hf_lte_rrc_cif_Presence_r13;           /* BOOLEAN */
static int hf_lte_rrc_other_r13;                  /* T_other_r13 */
static int hf_lte_rrc_schedulingCellId_r13;       /* ServCellIndex_r13 */
static int hf_lte_rrc_pdsch_Start_r13;            /* INTEGER_1_4 */
static int hf_lte_rrc_cif_InSchedulingCell_r13;   /* INTEGER_1_7 */
static int hf_lte_rrc_schedulingCellId_r14;       /* ServCellIndex_r13 */
static int hf_lte_rrc_cif_InSchedulingCell_r14;   /* INTEGER_1_7 */
static int hf_lte_rrc_powerRatio_r16;             /* T_powerRatio_r16 */
static int hf_lte_rrc_powerRatio_r16_01;          /* T_powerRatio_r16_01 */
static int hf_lte_rrc_localizedMappingType_r16;   /* T_localizedMappingType_r16 */
static int hf_lte_rrc_csi_IM_ConfigId_r11;        /* CSI_IM_ConfigId_r11 */
static int hf_lte_rrc_resourceConfig_r11;         /* INTEGER_0_31 */
static int hf_lte_rrc_subframeConfig_r11;         /* INTEGER_0_154 */
static int hf_lte_rrc_cSI_IM_Config_r11_eag_1_interferenceMeasRestriction_r13;  /* BOOLEAN */
static int hf_lte_rrc_csi_IM_ConfigId_v1250;      /* CSI_IM_ConfigId_v1250 */
static int hf_lte_rrc_resourceConfig_r12;         /* INTEGER_0_31 */
static int hf_lte_rrc_subframeConfig_r12;         /* INTEGER_0_154 */
static int hf_lte_rrc_cSI_IM_ConfigExt_r12_eag_1_interferenceMeasRestriction_r13;  /* BOOLEAN */
static int hf_lte_rrc_csi_IM_ConfigId_v1310;      /* CSI_IM_ConfigId_v1310 */
static int hf_lte_rrc_csi_ProcessId_r11;          /* CSI_ProcessId_r11 */
static int hf_lte_rrc_csi_RS_ConfigNZPId_r11;     /* CSI_RS_ConfigNZPId_r11 */
static int hf_lte_rrc_p_C_AndCBSRList_r11;        /* P_C_AndCBSR_Pair_r13a */
static int hf_lte_rrc_cqi_ReportBothProc_r11;     /* CQI_ReportBothProc_r11 */
static int hf_lte_rrc_cqi_ReportPeriodicProcId_r11;  /* INTEGER_0_maxCQI_ProcExt_r11 */
static int hf_lte_rrc_cqi_ReportAperiodicProc_r11;  /* CQI_ReportAperiodicProc_r11 */
static int hf_lte_rrc_alternativeCodebookEnabledFor4TXProc_r12;  /* T_alternativeCodebookEnabledFor4TXProc_r12 */
static int hf_lte_rrc_csi_IM_ConfigIdList_r12;    /* T_csi_IM_ConfigIdList_r12 */
static int hf_lte_rrc_cSI_Process_r11_eag_1_csi_IM_ConfigIdList_r12_setup;  /* SEQUENCE_SIZE_1_2_OF_CSI_IM_ConfigId_r12 */
static int hf_lte_rrc_csi_IM_ConfigIdList_r12_setup_item;  /* CSI_IM_ConfigId_r12 */
static int hf_lte_rrc_cqi_ReportAperiodicProc2_r12;  /* T_cqi_ReportAperiodicProc2_r12 */
static int hf_lte_rrc_cSI_Process_r11_eag_1_cqi_ReportAperiodicProc2_r12_setup;  /* CQI_ReportAperiodicProc_r11 */
static int hf_lte_rrc_cqi_ReportAperiodicProc_v1310;  /* T_cqi_ReportAperiodicProc_v1310 */
static int hf_lte_rrc_setup;                      /* CQI_ReportAperiodicProc_v1310 */
static int hf_lte_rrc_cqi_ReportAperiodicProc2_v1310;  /* T_cqi_ReportAperiodicProc2_v1310 */
static int hf_lte_rrc_cSI_Process_r11_eag_2_cqi_ReportAperiodicProc2_v1310_setup;  /* CQI_ReportAperiodicProc_v1310 */
static int hf_lte_rrc_eMIMO_Type_r13;             /* CSI_RS_ConfigEMIMO_r13 */
static int hf_lte_rrc_cSI_Process_r11_eag_3_dummy;  /* CSI_RS_ConfigEMIMO_v1430 */
static int hf_lte_rrc_eMIMO_Hybrid_r14;           /* CSI_RS_ConfigEMIMO_Hybrid_r14 */
static int hf_lte_rrc_advancedCodebookEnabled_r14;  /* BOOLEAN */
static int hf_lte_rrc_eMIMO_Type_v1480;           /* CSI_RS_ConfigEMIMO_v1480 */
static int hf_lte_rrc_feCOMP_CSI_Enabled_v1530;   /* BOOLEAN */
static int hf_lte_rrc_eMIMO_Type_v1530;           /* CSI_RS_ConfigEMIMO_v1530 */
static int hf_lte_rrc_csi_RS_r10;                 /* T_csi_RS_r10 */
static int hf_lte_rrc_cSI_RS_Config_r10_csi_RS_r10_setup;  /* T_cSI_RS_Config_r10_csi_RS_r10_setup */
static int hf_lte_rrc_antennaPortsCount_r10;      /* T_antennaPortsCount_r10 */
static int hf_lte_rrc_resourceConfig_r10;         /* INTEGER_0_31 */
static int hf_lte_rrc_subframeConfig_r10;         /* INTEGER_0_154 */
static int hf_lte_rrc_p_C_r10;                    /* INTEGER_M8_15 */
static int hf_lte_rrc_zeroTxPowerCSI_RS_r10;      /* ZeroTxPowerCSI_RS_Conf_r12 */
static int hf_lte_rrc_zeroTxPowerCSI_RS2_r12;     /* ZeroTxPowerCSI_RS_Conf_r12 */
static int hf_lte_rrc_ds_ZeroTxPowerCSI_RS_r12;   /* T_ds_ZeroTxPowerCSI_RS_r12 */
static int hf_lte_rrc_cSI_RS_Config_v1250_ds_ZeroTxPowerCSI_RS_r12_setup;  /* T_cSI_RS_Config_v1250_ds_ZeroTxPowerCSI_RS_r12_setup */
static int hf_lte_rrc_zeroTxPowerCSI_RS_List_r12;  /* SEQUENCE_SIZE_1_maxDS_ZTP_CSI_RS_r12_OF_ZeroTxPowerCSI_RS_r12 */
static int hf_lte_rrc_zeroTxPowerCSI_RS_List_r12_item;  /* ZeroTxPowerCSI_RS_r12 */
static int hf_lte_rrc_cSI_RS_Config_v1430_dummy;  /* CSI_RS_ConfigEMIMO_v1430 */
static int hf_lte_rrc_cSI_RS_Config_r15_setup;    /* T_cSI_RS_Config_r15_setup */
static int hf_lte_rrc_csi_RS_Config_r10;          /* CSI_RS_Config_r10 */
static int hf_lte_rrc_csi_RS_Config_v1250;        /* CSI_RS_Config_v1250 */
static int hf_lte_rrc_csi_RS_Config_v1310;        /* CSI_RS_Config_v1310 */
static int hf_lte_rrc_csi_RS_Config_v1430;        /* CSI_RS_Config_v1430 */
static int hf_lte_rrc_zeroTxPowerCSI_RS_Conf_r12_setup;  /* ZeroTxPowerCSI_RS_r12 */
static int hf_lte_rrc_zeroTxPowerResourceConfigList_r12;  /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_zeroTxPowerSubframeConfig_r12;  /* INTEGER_0_154 */
static int hf_lte_rrc_csi_RS_ConfigNZPIdListExt_r13;  /* SEQUENCE_SIZE_1_7_OF_CSI_RS_ConfigNZPId_r13 */
static int hf_lte_rrc_csi_RS_ConfigNZPIdListExt_r13_item;  /* CSI_RS_ConfigNZPId_r13 */
static int hf_lte_rrc_csi_IM_ConfigIdList_r13;    /* SEQUENCE_SIZE_1_8_OF_CSI_IM_ConfigId_r13 */
static int hf_lte_rrc_csi_IM_ConfigIdList_r13_item;  /* CSI_IM_ConfigId_r13 */
static int hf_lte_rrc_p_C_AndCBSR_PerResourceConfigList_r13;  /* SEQUENCE_SIZE_1_8_OF_P_C_AndCBSR_Pair_r13 */
static int hf_lte_rrc_p_C_AndCBSR_PerResourceConfigList_r13_item;  /* P_C_AndCBSR_Pair_r13 */
static int hf_lte_rrc_ace_For4Tx_PerResourceConfigList_r13;  /* T_ace_For4Tx_PerResourceConfigList_r13 */
static int hf_lte_rrc_ace_For4Tx_PerResourceConfigList_r13_item;  /* BOOLEAN */
static int hf_lte_rrc_alternativeCodebookEnabledBeamformed_r13;  /* T_alternativeCodebookEnabledBeamformed_r13 */
static int hf_lte_rrc_channelMeasRestriction_r13;  /* T_channelMeasRestriction_r13 */
static int hf_lte_rrc_csi_RS_ConfigNZPIdListExt_r14;  /* SEQUENCE_SIZE_1_7_OF_CSI_RS_ConfigNZPId_r13 */
static int hf_lte_rrc_csi_RS_ConfigNZPIdListExt_r14_item;  /* CSI_RS_ConfigNZPId_r13 */
static int hf_lte_rrc_csi_IM_ConfigIdList_r14;    /* SEQUENCE_SIZE_1_8_OF_CSI_IM_ConfigId_r13 */
static int hf_lte_rrc_csi_IM_ConfigIdList_r14_item;  /* CSI_IM_ConfigId_r13 */
static int hf_lte_rrc_p_C_AndCBSR_PerResourceConfigList_r14;  /* SEQUENCE_SIZE_1_8_OF_P_C_AndCBSR_Pair_r13 */
static int hf_lte_rrc_p_C_AndCBSR_PerResourceConfigList_r14_item;  /* P_C_AndCBSR_Pair_r13 */
static int hf_lte_rrc_ace_For4Tx_PerResourceConfigList_r14;  /* T_ace_For4Tx_PerResourceConfigList_r14 */
static int hf_lte_rrc_ace_For4Tx_PerResourceConfigList_r14_item;  /* BOOLEAN */
static int hf_lte_rrc_alternativeCodebookEnabledBeamformed_r14;  /* T_alternativeCodebookEnabledBeamformed_r14 */
static int hf_lte_rrc_channelMeasRestriction_r14;  /* T_channelMeasRestriction_r14 */
static int hf_lte_rrc_csi_RS_ConfigNZP_ApList_r14;  /* SEQUENCE_SIZE_1_8_OF_CSI_RS_ConfigNZP_r11 */
static int hf_lte_rrc_csi_RS_ConfigNZP_ApList_r14_item;  /* CSI_RS_ConfigNZP_r11 */
static int hf_lte_rrc_nzp_ResourceConfigOriginal_v1430;  /* CSI_RS_Config_NZP_v1430 */
static int hf_lte_rrc_csi_RS_NZP_Activation_r14;  /* CSI_RS_ConfigNZP_Activation_r14 */
static int hf_lte_rrc_transmissionComb_r14;       /* NZP_TransmissionComb_r14 */
static int hf_lte_rrc_frequencyDensity_r14;       /* NZP_FrequencyDensity_r14 */
static int hf_lte_rrc_csi_RS_NZP_mode_r14;        /* T_csi_RS_NZP_mode_r14 */
static int hf_lte_rrc_activatedResources_r14;     /* INTEGER_0_4 */
static int hf_lte_rrc_cSI_RS_ConfigEMIMO_r13_setup;  /* T_cSI_RS_ConfigEMIMO_r13_setup */
static int hf_lte_rrc_nonPrecoded_r13;            /* CSI_RS_ConfigNonPrecoded_r13 */
static int hf_lte_rrc_beamformed_r13;             /* CSI_RS_ConfigBeamformed_r13 */
static int hf_lte_rrc_cSI_RS_ConfigEMIMO_v1430_setup;  /* T_cSI_RS_ConfigEMIMO_v1430_setup */
static int hf_lte_rrc_nonPrecoded_v1430;          /* CSI_RS_ConfigNonPrecoded_v1430 */
static int hf_lte_rrc_beamformed_v1430;           /* CSI_RS_ConfigBeamformed_v1430 */
static int hf_lte_rrc_cSI_RS_ConfigEMIMO_v1480_setup;  /* T_cSI_RS_ConfigEMIMO_v1480_setup */
static int hf_lte_rrc_nonPrecoded_v1480;          /* CSI_RS_ConfigNonPrecoded_v1480 */
static int hf_lte_rrc_beamformed_v1480;           /* CSI_RS_ConfigBeamformed_v1430 */
static int hf_lte_rrc_cSI_RS_ConfigEMIMO_v1530_setup;  /* T_cSI_RS_ConfigEMIMO_v1530_setup */
static int hf_lte_rrc_nonPrecoded_v1530;          /* CSI_RS_ConfigNonPrecoded_v1530 */
static int hf_lte_rrc_cSI_RS_ConfigEMIMO2_r14_setup;  /* CSI_RS_ConfigBeamformed_r14 */
static int hf_lte_rrc_cSI_RS_ConfigEMIMO_Hybrid_r14_setup;  /* T_cSI_RS_ConfigEMIMO_Hybrid_r14_setup */
static int hf_lte_rrc_periodicityOffsetIndex_r14;  /* INTEGER_0_1023 */
static int hf_lte_rrc_eMIMO_Type2_r14;            /* CSI_RS_ConfigEMIMO2_r14 */
static int hf_lte_rrc_p_C_AndCBSRList_r13;        /* P_C_AndCBSR_Pair_r13 */
static int hf_lte_rrc_codebookConfigN1_r13;       /* T_codebookConfigN1_r13 */
static int hf_lte_rrc_codebookConfigN2_r13;       /* T_codebookConfigN2_r13 */
static int hf_lte_rrc_codebookOverSamplingRateConfig_O1_r13;  /* T_codebookOverSamplingRateConfig_O1_r13 */
static int hf_lte_rrc_codebookOverSamplingRateConfig_O2_r13;  /* T_codebookOverSamplingRateConfig_O2_r13 */
static int hf_lte_rrc_codebookConfig_r13;         /* INTEGER_1_4 */
static int hf_lte_rrc_csi_IM_ConfigIdList_r13_01;  /* SEQUENCE_SIZE_1_2_OF_CSI_IM_ConfigId_r13 */
static int hf_lte_rrc_csi_RS_ConfigNZP_EMIMO_r13;  /* CSI_RS_ConfigNZP_EMIMO_r13 */
static int hf_lte_rrc_csi_RS_ConfigNZP_EMIMO_v1430;  /* CSI_RS_ConfigNZP_EMIMO_v1430 */
static int hf_lte_rrc_codebookConfigN1_v1430;     /* T_codebookConfigN1_v1430 */
static int hf_lte_rrc_codebookConfigN2_v1430;     /* T_codebookConfigN2_v1430 */
static int hf_lte_rrc_nzp_ResourceConfigTM9_Original_v1430;  /* CSI_RS_Config_NZP_v1430 */
static int hf_lte_rrc_csi_RS_ConfigNZP_EMIMO_v1480;  /* CSI_RS_ConfigNZP_EMIMO_v1430 */
static int hf_lte_rrc_codebookConfigN1_v1480;     /* T_codebookConfigN1_v1480 */
static int hf_lte_rrc_codebookConfigN2_r1480;     /* T_codebookConfigN2_r1480 */
static int hf_lte_rrc_nzp_ResourceConfigTM9_Original_v1480;  /* CSI_RS_Config_NZP_v1430 */
static int hf_lte_rrc_p_C_AndCBSRList_r15;        /* P_C_AndCBSR_Pair_r15 */
static int hf_lte_rrc_antennaPortsCount_r11;      /* T_antennaPortsCount_r11 */
static int hf_lte_rrc_scramblingIdentity_r11;     /* INTEGER_0_503 */
static int hf_lte_rrc_qcl_CRS_Info_r11;           /* T_qcl_CRS_Info_r11 */
static int hf_lte_rrc_qcl_ScramblingIdentity_r11;  /* INTEGER_0_503 */
static int hf_lte_rrc_crs_PortsCount_r11;         /* T_crs_PortsCount_r11 */
static int hf_lte_rrc_mbsfn_SubframeConfigList_r11;  /* T_mbsfn_SubframeConfigList_r11 */
static int hf_lte_rrc_cSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_setup;  /* T_cSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_setup */
static int hf_lte_rrc_subframeConfigList;         /* MBSFN_SubframeConfigList */
static int hf_lte_rrc_csi_RS_ConfigNZPId_v1310;   /* CSI_RS_ConfigNZPId_v1310 */
static int hf_lte_rrc_mbsfn_SubframeConfigList_v1430_01;  /* T_mbsfn_SubframeConfigList_v1430 */
static int hf_lte_rrc_cSI_RS_ConfigNZP_r11_eag_3_mbsfn_SubframeConfigList_v1430_setup;  /* T_cSI_RS_ConfigNZP_r11_eag_3_mbsfn_SubframeConfigList_v1430_setup */
static int hf_lte_rrc_subframeConfigList_v1430;   /* MBSFN_SubframeConfigList_v1430 */
static int hf_lte_rrc_cSI_RS_ConfigNZP_EMIMO_r13_setup;  /* T_cSI_RS_ConfigNZP_EMIMO_r13_setup */
static int hf_lte_rrc_nzp_resourceConfigList_r13;  /* SEQUENCE_SIZE_1_2_OF_NZP_ResourceConfig_r13 */
static int hf_lte_rrc_nzp_resourceConfigList_r13_item;  /* NZP_ResourceConfig_r13 */
static int hf_lte_rrc_cdmType_r13;                /* T_cdmType_r13 */
static int hf_lte_rrc_nzp_resourceConfigListExt_r14;  /* SEQUENCE_SIZE_0_4_OF_NZP_ResourceConfig_r13 */
static int hf_lte_rrc_nzp_resourceConfigListExt_r14_item;  /* NZP_ResourceConfig_r13 */
static int hf_lte_rrc_cdmType_v1430;              /* T_cdmType_v1430 */
static int hf_lte_rrc_resourceConfig_r13;         /* ResourceConfig_r13 */
static int hf_lte_rrc_csi_RS_ConfigZPId_r11;      /* CSI_RS_ConfigZPId_r11 */
static int hf_lte_rrc_resourceConfigList_r11;     /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_cSI_RS_ConfigZP_ApList_r14_setup;  /* SEQUENCE_SIZE_1_maxCSI_RS_ZP_r11_OF_CSI_RS_ConfigZP_r11 */
static int hf_lte_rrc_cSI_RS_ConfigZP_ApList_r14_setup_item;  /* CSI_RS_ConfigZP_r11 */
static int hf_lte_rrc_dMRS_Config_r11_setup;      /* T_dMRS_Config_r11_setup */
static int hf_lte_rrc_scramblingIdentity2_r11;    /* INTEGER_0_503 */
static int hf_lte_rrc_dmrs_tableAlt_r13;          /* T_dmrs_tableAlt_r13 */
static int hf_lte_rrc_config_r11;                 /* T_config_r11 */
static int hf_lte_rrc_ePDCCH_Config_r11_config_r11_setup;  /* T_ePDCCH_Config_r11_config_r11_setup */
static int hf_lte_rrc_subframePatternConfig_r11;  /* T_subframePatternConfig_r11 */
static int hf_lte_rrc_ePDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_setup;  /* T_ePDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_setup */
static int hf_lte_rrc_subframePattern_r11;        /* MeasSubframePattern_r10 */
static int hf_lte_rrc_startSymbol_r11;            /* INTEGER_1_4 */
static int hf_lte_rrc_setConfigToReleaseList_r11;  /* EPDCCH_SetConfigToReleaseList_r11 */
static int hf_lte_rrc_setConfigToAddModList_r11;  /* EPDCCH_SetConfigToAddModList_r11 */
static int hf_lte_rrc_EPDCCH_SetConfigToAddModList_r11_item;  /* EPDCCH_SetConfig_r11 */
static int hf_lte_rrc_EPDCCH_SetConfigToReleaseList_r11_item;  /* EPDCCH_SetConfigId_r11 */
static int hf_lte_rrc_setConfigId_r11;            /* EPDCCH_SetConfigId_r11 */
static int hf_lte_rrc_transmissionType_r11;       /* T_transmissionType_r11 */
static int hf_lte_rrc_resourceBlockAssignment_r11;  /* T_resourceBlockAssignment_r11 */
static int hf_lte_rrc_numberPRB_Pairs_r11;        /* T_numberPRB_Pairs_r11 */
static int hf_lte_rrc_resourceBlockAssignment_r11_01;  /* BIT_STRING_SIZE_4_38 */
static int hf_lte_rrc_dmrs_ScramblingSequenceInt_r11;  /* INTEGER_0_503 */
static int hf_lte_rrc_pucch_ResourceStartOffset_r11;  /* INTEGER_0_2047 */
static int hf_lte_rrc_re_MappingQCL_ConfigId_r11;  /* PDSCH_RE_MappingQCL_ConfigId_r11 */
static int hf_lte_rrc_csi_RS_ConfigZPId2_r12;     /* T_csi_RS_ConfigZPId2_r12 */
static int hf_lte_rrc_ePDCCH_SetConfig_r11_eag_1_csi_RS_ConfigZPId2_r12_setup;  /* CSI_RS_ConfigZPId_r11 */
static int hf_lte_rrc_numberPRB_Pairs_v1310;      /* T_numberPRB_Pairs_v1310 */
static int hf_lte_rrc_ePDCCH_SetConfig_r11_eag_2_numberPRB_Pairs_v1310_setup;  /* T_ePDCCH_SetConfig_r11_eag_2_numberPRB_Pairs_v1310_setup */
static int hf_lte_rrc_mpdcch_config_r13;          /* T_mpdcch_config_r13 */
static int hf_lte_rrc_ePDCCH_SetConfig_r11_eag_2_mpdcch_config_r13_setup;  /* T_ePDCCH_SetConfig_r11_eag_2_mpdcch_config_r13_setup */
static int hf_lte_rrc_csi_NumRepetitionCE_r13;    /* T_csi_NumRepetitionCE_r13 */
static int hf_lte_rrc_mpdcch_pdsch_HoppingConfig_r13;  /* T_mpdcch_pdsch_HoppingConfig_r13 */
static int hf_lte_rrc_mpdcch_StartSF_UESS_r13;    /* T_mpdcch_StartSF_UESS_r13 */
static int hf_lte_rrc_fdd_r13;                    /* T_fdd_r13 */
static int hf_lte_rrc_tdd_r13;                    /* T_tdd_r13 */
static int hf_lte_rrc_mpdcch_NumRepetition_r13_01;  /* T_mpdcch_NumRepetition_r13 */
static int hf_lte_rrc_mpdcch_Narrowband_r13;      /* INTEGER_1_maxAvailNarrowBands_r13 */
static int hf_lte_rrc_eIMTA_MainConfig_r12_setup;  /* T_eIMTA_MainConfig_r12_setup */
static int hf_lte_rrc_eimta_RNTI_r12;             /* C_RNTI */
static int hf_lte_rrc_eimta_CommandPeriodicity_r12;  /* T_eimta_CommandPeriodicity_r12 */
static int hf_lte_rrc_eimta_CommandSubframeSet_r12;  /* BIT_STRING_SIZE_10 */
static int hf_lte_rrc_eIMTA_MainConfigServCell_r12_setup;  /* T_eIMTA_MainConfigServCell_r12_setup */
static int hf_lte_rrc_eimta_UL_DL_ConfigIndex_r12;  /* INTEGER_1_5 */
static int hf_lte_rrc_eimta_HARQ_ReferenceConfig_r12;  /* T_eimta_HARQ_ReferenceConfig_r12 */
static int hf_lte_rrc_mbsfn_SubframeConfigList_v1250;  /* T_mbsfn_SubframeConfigList_v1250 */
static int hf_lte_rrc_eIMTA_MainConfigServCell_r12_setup_mbsfn_SubframeConfigList_v1250_setup;  /* T_eIMTA_MainConfigServCell_r12_setup_mbsfn_SubframeConfigList_v1250_setup */
static int hf_lte_rrc_subframeConfigList_r12;     /* MBSFN_SubframeConfigList */
static int hf_lte_rrc_groupAlternation_r16;       /* T_groupAlternation_r16 */
static int hf_lte_rrc_commonSequence_r16;         /* T_commonSequence_r16 */
static int hf_lte_rrc_timeParameters_r16;         /* GWUS_TimeParameters_r16 */
static int hf_lte_rrc_resourceConfigDRX_r16;      /* GWUS_ResourceConfig_r16 */
static int hf_lte_rrc_resourceConfig_eDRX_Short_r16;  /* GWUS_ResourceConfig_r16 */
static int hf_lte_rrc_resourceConfig_eDRX_Long_r16;  /* GWUS_ResourceConfig_r16 */
static int hf_lte_rrc_probThreshList_r16;         /* GWUS_ProbThreshList_r16 */
static int hf_lte_rrc_groupNarrowBandList_r16;    /* GWUS_GroupNarrowBandList_r16 */
static int hf_lte_rrc_maxDurationFactor_r16;      /* T_maxDurationFactor_r16 */
static int hf_lte_rrc_numPOs_r16;                 /* T_numPOs_r16 */
static int hf_lte_rrc_timeOffsetDRX_r16;          /* T_timeOffsetDRX_r16 */
static int hf_lte_rrc_timeOffset_eDRX_Short_r16;  /* T_timeOffset_eDRX_Short_r16 */
static int hf_lte_rrc_timeOffset_eDRX_Long_r16;   /* T_timeOffset_eDRX_Long_r16 */
static int hf_lte_rrc_numDRX_CyclesRelaxed_r16;   /* T_numDRX_CyclesRelaxed_r16 */
static int hf_lte_rrc_powerBoost_r16;             /* T_powerBoost_r16 */
static int hf_lte_rrc_resourceMappingPattern_r16;  /* T_resourceMappingPattern_r16 */
static int hf_lte_rrc_resourceLocationWithWUS;    /* T_resourceLocationWithWUS */
static int hf_lte_rrc_resourceLocationWithoutWUS;  /* T_resourceLocationWithoutWUS */
static int hf_lte_rrc_numGroupsList_r16;          /* GWUS_NumGroupsList_r16 */
static int hf_lte_rrc_groupsForServiceList_r16;   /* GWUS_GroupsForServiceList_r16 */
static int hf_lte_rrc_GWUS_GroupsForServiceList_r16_item;  /* INTEGER_1_maxGWUS_Groups_1_r16 */
static int hf_lte_rrc_GWUS_GroupNarrowBandList_r16_item;  /* BOOLEAN */
static int hf_lte_rrc_GWUS_NumGroupsList_r16_item;  /* GWUS_NumGroups_r16 */
static int hf_lte_rrc_GWUS_ProbThreshList_r16_item;  /* GWUS_PagingProbThresh_r16 */
static int hf_lte_rrc_ul_SpecificParameters;      /* T_ul_SpecificParameters */
static int hf_lte_rrc_priority;                   /* T_priority */
static int hf_lte_rrc_prioritisedBitRate;         /* T_prioritisedBitRate */
static int hf_lte_rrc_bucketSizeDuration;         /* T_bucketSizeDuration */
static int hf_lte_rrc_logicalChannelGroup;        /* INTEGER_0_3 */
static int hf_lte_rrc_logicalChannelSR_Mask_r9;   /* T_logicalChannelSR_Mask_r9 */
static int hf_lte_rrc_logicalChannelSR_Prohibit_r12;  /* BOOLEAN */
static int hf_lte_rrc_laa_UL_Allowed_r14;         /* BOOLEAN */
static int hf_lte_rrc_bitRateQueryProhibitTimer_r14;  /* T_bitRateQueryProhibitTimer_r14 */
static int hf_lte_rrc_allowedTTI_Lengths_r15;     /* T_allowedTTI_Lengths_r15 */
static int hf_lte_rrc_logicalChannelConfig_eag_4_allowedTTI_Lengths_r15_setup;  /* T_logicalChannelConfig_eag_4_allowedTTI_Lengths_r15_setup */
static int hf_lte_rrc_shortTTI_r15;               /* BOOLEAN */
static int hf_lte_rrc_subframeTTI_r15;            /* BOOLEAN */
static int hf_lte_rrc_logicalChannelSR_Restriction_r15;  /* T_logicalChannelSR_Restriction_r15 */
static int hf_lte_rrc_logicalChannelConfig_eag_4_logicalChannelSR_Restriction_r15_setup;  /* T_logicalChannelConfig_eag_4_logicalChannelSR_Restriction_r15_setup */
static int hf_lte_rrc_channelAccessPriority_r15;  /* T_channelAccessPriority_r15 */
static int hf_lte_rrc_logicalChannelConfig_eag_4_channelAccessPriority_r15_setup;  /* INTEGER_1_4 */
static int hf_lte_rrc_lch_CellRestriction_r15;    /* BIT_STRING_SIZE_maxServCell_r13 */
static int hf_lte_rrc_bitRateMultiplier_r16;      /* T_bitRateMultiplier_r16 */
static int hf_lte_rrc_allowedHARQ_Mode_r18;       /* T_allowedHARQ_Mode_r18 */
static int hf_lte_rrc_lWA_Configuration_r13_setup;  /* T_lWA_Configuration_r13_setup */
static int hf_lte_rrc_lwa_Config_r13;             /* LWA_Config_r13 */
static int hf_lte_rrc_lwa_MobilityConfig_r13;     /* WLAN_MobilityConfig_r13 */
static int hf_lte_rrc_lwa_WT_Counter_r13;         /* INTEGER_0_65535 */
static int hf_lte_rrc_wt_MAC_Address_r14;         /* OCTET_STRING_SIZE_6 */
static int hf_lte_rrc_lWIP_Configuration_r13_setup;  /* T_lWIP_Configuration_r13_setup */
static int hf_lte_rrc_lwip_Config_r13;            /* LWIP_Config_r13 */
static int hf_lte_rrc_lwip_MobilityConfig_r13;    /* WLAN_MobilityConfig_r13 */
static int hf_lte_rrc_tunnelConfigLWIP_r13;       /* TunnelConfigLWIP_r13 */
static int hf_lte_rrc_ul_SCH_Config;              /* T_ul_SCH_Config */
static int hf_lte_rrc_maxHARQ_Tx;                 /* T_maxHARQ_Tx */
static int hf_lte_rrc_periodicBSR_Timer;          /* PeriodicBSR_Timer_r12 */
static int hf_lte_rrc_retxBSR_Timer;              /* RetxBSR_Timer_r12 */
static int hf_lte_rrc_ttiBundling;                /* BOOLEAN */
static int hf_lte_rrc_drx_Config;                 /* DRX_Config */
static int hf_lte_rrc_timeAlignmentTimerDedicated;  /* TimeAlignmentTimer */
static int hf_lte_rrc_phr_Config;                 /* T_phr_Config */
static int hf_lte_rrc_mAC_MainConfig_phr_Config_setup;  /* T_mAC_MainConfig_phr_Config_setup */
static int hf_lte_rrc_periodicPHR_Timer;          /* T_periodicPHR_Timer */
static int hf_lte_rrc_prohibitPHR_Timer;          /* T_prohibitPHR_Timer */
static int hf_lte_rrc_dl_PathlossChange;          /* T_dl_PathlossChange */
static int hf_lte_rrc_sr_ProhibitTimer_r9;        /* T_sr_ProhibitTimer_r9 */
static int hf_lte_rrc_mac_MainConfig_v1020;       /* T_mac_MainConfig_v1020 */
static int hf_lte_rrc_sCellDeactivationTimer_r10;  /* T_sCellDeactivationTimer_r10 */
static int hf_lte_rrc_extendedBSR_Sizes_r10;      /* T_extendedBSR_Sizes_r10 */
static int hf_lte_rrc_extendedPHR_r10;            /* T_extendedPHR_r10 */
static int hf_lte_rrc_stag_ToReleaseList_r11;     /* STAG_ToReleaseList_r11 */
static int hf_lte_rrc_stag_ToAddModList_r11;      /* STAG_ToAddModList_r11 */
static int hf_lte_rrc_drx_Config_v1130;           /* DRX_Config_v1130 */
static int hf_lte_rrc_e_HARQ_Pattern_r12;         /* BOOLEAN */
static int hf_lte_rrc_dualConnectivityPHR;        /* T_dualConnectivityPHR */
static int hf_lte_rrc_mAC_MainConfig_eag_4_dualConnectivityPHR_setup;  /* T_mAC_MainConfig_eag_4_dualConnectivityPHR_setup */
static int hf_lte_rrc_phr_ModeOtherCG_r12;        /* T_phr_ModeOtherCG_r12 */
static int hf_lte_rrc_logicalChannelSR_Config_r12;  /* T_logicalChannelSR_Config_r12 */
static int hf_lte_rrc_mAC_MainConfig_eag_4_logicalChannelSR_Config_r12_setup;  /* T_mAC_MainConfig_eag_4_logicalChannelSR_Config_r12_setup */
static int hf_lte_rrc_logicalChannelSR_ProhibitTimer_r12;  /* T_logicalChannelSR_ProhibitTimer_r12 */
static int hf_lte_rrc_drx_Config_v1310;           /* DRX_Config_v1310 */
static int hf_lte_rrc_extendedPHR2_r13;           /* BOOLEAN */
static int hf_lte_rrc_eDRX_Config_CycleStartOffset_r13;  /* T_eDRX_Config_CycleStartOffset_r13 */
static int hf_lte_rrc_mAC_MainConfig_eag_5_eDRX_Config_CycleStartOffset_r13_setup;  /* T_mAC_MainConfig_eag_5_eDRX_Config_CycleStartOffset_r13_setup */
static int hf_lte_rrc_sf5120;                     /* INTEGER_0_1 */
static int hf_lte_rrc_sf10240;                    /* INTEGER_0_3 */
static int hf_lte_rrc_drx_Config_r13;             /* T_drx_Config_r13 */
static int hf_lte_rrc_mainConfig_eag_6_drx_Config_r13_setup;  /* DRX_Config_r13 */
static int hf_lte_rrc_skipUplinkTx_r14;           /* T_skipUplinkTx_r14 */
static int hf_lte_rrc_mAC_MainConfig_eag_7_skipUplinkTx_r14_setup;  /* T_mAC_MainConfig_eag_7_skipUplinkTx_r14_setup */
static int hf_lte_rrc_skipUplinkTxSPS_r14;        /* T_skipUplinkTxSPS_r14 */
static int hf_lte_rrc_skipUplinkTxDynamic_r14;    /* T_skipUplinkTxDynamic_r14 */
static int hf_lte_rrc_dataInactivityTimerConfig_r14;  /* T_dataInactivityTimerConfig_r14 */
static int hf_lte_rrc_mAC_MainConfig_eag_7_dataInactivityTimerConfig_r14_setup;  /* T_mAC_MainConfig_eag_7_dataInactivityTimerConfig_r14_setup */
static int hf_lte_rrc_dataInactivityTimer_r14;    /* DataInactivityTimer_r14 */
static int hf_lte_rrc_rai_Activation_r14;         /* T_rai_Activation_r14 */
static int hf_lte_rrc_shortTTI_AndSPT_r15;        /* T_shortTTI_AndSPT_r15 */
static int hf_lte_rrc_mAC_MainConfig_eag_9_shortTTI_AndSPT_r15_setup;  /* T_mAC_MainConfig_eag_9_shortTTI_AndSPT_r15_setup */
static int hf_lte_rrc_drx_Config_r15;             /* DRX_Config_r15 */
static int hf_lte_rrc_periodicBSR_Timer_r15;      /* T_periodicBSR_Timer_r15 */
static int hf_lte_rrc_proc_Timeline_r15;          /* T_proc_Timeline_r15 */
static int hf_lte_rrc_ssr_ProhibitTimer_r15;      /* INTEGER_0_7 */
static int hf_lte_rrc_mpdcch_UL_HARQ_ACK_FeedbackConfig_r15;  /* BOOLEAN */
static int hf_lte_rrc_dormantStateTimers_r15;     /* T_dormantStateTimers_r15 */
static int hf_lte_rrc_mAC_MainConfig_eag_9_dormantStateTimers_r15_setup;  /* T_mAC_MainConfig_eag_9_dormantStateTimers_r15_setup */
static int hf_lte_rrc_sCellHibernationTimer_r15;  /* T_sCellHibernationTimer_r15 */
static int hf_lte_rrc_dormantSCellDeactivationTimer_r15;  /* T_dormantSCellDeactivationTimer_r15 */
static int hf_lte_rrc_ce_ETWS_CMAS_RxInConn_r16;  /* T_ce_ETWS_CMAS_RxInConn_r16 */
static int hf_lte_rrc_offsetThresholdTA_r17;      /* T_offsetThresholdTA_r17 */
static int hf_lte_rrc_setup_01;                   /* OffsetThresholdTA_r17 */
static int hf_lte_rrc_sr_ProhibitTimerOffset_r17;  /* T_sr_ProhibitTimerOffset_r17 */
static int hf_lte_rrc_setup_02;                   /* SR_ProhibitTimerOffset_r17 */
static int hf_lte_rrc_stag_Id_r11;                /* STAG_Id_r11 */
static int hf_lte_rrc_dRX_Config_release;         /* T_dRX_Config_release */
static int hf_lte_rrc_dRX_Config_setup;           /* T_dRX_Config_setup */
static int hf_lte_rrc_onDurationTimer;            /* T_onDurationTimer */
static int hf_lte_rrc_drx_InactivityTimer;        /* T_drx_InactivityTimer */
static int hf_lte_rrc_drx_RetransmissionTimer;    /* T_drx_RetransmissionTimer */
static int hf_lte_rrc_longDRX_CycleStartOffset;   /* T_longDRX_CycleStartOffset */
static int hf_lte_rrc_sf10_01;                    /* T_sf10 */
static int hf_lte_rrc_sf20_01;                    /* T_sf20 */
static int hf_lte_rrc_sf32_01;                    /* T_sf32 */
static int hf_lte_rrc_sf40_01;                    /* T_sf40 */
static int hf_lte_rrc_sf64_01;                    /* T_sf64 */
static int hf_lte_rrc_sf80_01;                    /* T_sf80 */
static int hf_lte_rrc_sf128_01;                   /* T_sf128 */
static int hf_lte_rrc_sf160_01;                   /* T_sf160 */
static int hf_lte_rrc_sf256_01;                   /* T_sf256 */
static int hf_lte_rrc_sf320_01;                   /* T_sf320 */
static int hf_lte_rrc_sf512_01;                   /* T_sf512 */
static int hf_lte_rrc_sf640_01;                   /* T_sf640 */
static int hf_lte_rrc_sf1024_01;                  /* T_sf1024 */
static int hf_lte_rrc_sf1280;                     /* T_sf1280 */
static int hf_lte_rrc_sf2048_01;                  /* T_sf2048 */
static int hf_lte_rrc_sf2560;                     /* T_sf2560 */
static int hf_lte_rrc_shortDRX;                   /* T_shortDRX */
static int hf_lte_rrc_shortDRX_Cycle;             /* T_shortDRX_Cycle */
static int hf_lte_rrc_drxShortCycleTimer;         /* T_drxShortCycleTimer */
static int hf_lte_rrc_drx_RetransmissionTimer_v1130;  /* T_drx_RetransmissionTimer_v1130 */
static int hf_lte_rrc_longDRX_CycleStartOffset_v1130;  /* T_longDRX_CycleStartOffset_v1130 */
static int hf_lte_rrc_sf60_v1130;                 /* T_sf60_v1130 */
static int hf_lte_rrc_sf70_v1130;                 /* T_sf70_v1130 */
static int hf_lte_rrc_shortDRX_Cycle_v1130;       /* T_shortDRX_Cycle_v1130 */
static int hf_lte_rrc_longDRX_CycleStartOffset_v1310;  /* T_longDRX_CycleStartOffset_v1310 */
static int hf_lte_rrc_sf60_v1310;                 /* T_sf60_v1310 */
static int hf_lte_rrc_onDurationTimer_v1310;      /* T_onDurationTimer_v1310 */
static int hf_lte_rrc_drx_RetransmissionTimer_v1310;  /* T_drx_RetransmissionTimer_v1310 */
static int hf_lte_rrc_drx_ULRetransmissionTimer_r13;  /* T_drx_ULRetransmissionTimer_r13 */
static int hf_lte_rrc_drx_RetransmissionTimerShortTTI_r15;  /* T_drx_RetransmissionTimerShortTTI_r15 */
static int hf_lte_rrc_drx_UL_RetransmissionTimerShortTTI_r15;  /* T_drx_UL_RetransmissionTimerShortTTI_r15 */
static int hf_lte_rrc_STAG_ToReleaseList_r11_item;  /* STAG_Id_r11 */
static int hf_lte_rrc_STAG_ToAddModList_r11_item;  /* STAG_ToAddMod_r11 */
static int hf_lte_rrc_timeAlignmentTimerSTAG_r11;  /* TimeAlignmentTimer */
static int hf_lte_rrc_p_C_r11;                    /* INTEGER_M8_15 */
static int hf_lte_rrc_codebookSubsetRestriction_r11;  /* BIT_STRING */
static int hf_lte_rrc_p_C_r13;                    /* INTEGER_M8_15 */
static int hf_lte_rrc_cbsr_Selection_r13;         /* T_cbsr_Selection_r13 */
static int hf_lte_rrc_nonPrecoded_r13_01;         /* T_nonPrecoded_r13 */
static int hf_lte_rrc_codebookSubsetRestriction1_r13;  /* BIT_STRING */
static int hf_lte_rrc_codebookSubsetRestriction2_r13;  /* BIT_STRING */
static int hf_lte_rrc_beamformedK1a_r13;          /* T_beamformedK1a_r13 */
static int hf_lte_rrc_codebookSubsetRestriction3_r13;  /* BIT_STRING */
static int hf_lte_rrc_beamformedKN_r13;           /* T_beamformedKN_r13 */
static int hf_lte_rrc_codebookSubsetRestriction_r13;  /* BIT_STRING */
static int hf_lte_rrc_p_C_r15;                    /* INTEGER_M8_15 */
static int hf_lte_rrc_codebookSubsetRestriction4_r15;  /* BIT_STRING */
static int hf_lte_rrc_P_C_AndCBSR_Pair_r13a_item;  /* P_C_AndCBSR_r11 */
static int hf_lte_rrc_P_C_AndCBSR_Pair_r13_item;  /* P_C_AndCBSR_r13 */
static int hf_lte_rrc_P_C_AndCBSR_Pair_r15_item;  /* P_C_AndCBSR_r15 */
static int hf_lte_rrc_skipMonitoringDCI_format0_1A_r13;  /* T_skipMonitoringDCI_format0_1A_r13 */
static int hf_lte_rrc_maxNumberOfSchedSubframes_Format0B_r14;  /* T_maxNumberOfSchedSubframes_Format0B_r14 */
static int hf_lte_rrc_maxNumberOfSchedSubframes_Format4B_r14;  /* T_maxNumberOfSchedSubframes_Format4B_r14 */
static int hf_lte_rrc_skipMonitoringDCI_Format0A_r14;  /* T_skipMonitoringDCI_Format0A_r14 */
static int hf_lte_rrc_skipMonitoringDCI_Format4A_r14;  /* T_skipMonitoringDCI_Format4A_r14 */
static int hf_lte_rrc_pdcch_CandidateReductions_Format0A_r14;  /* PDCCH_CandidateReductions_r13 */
static int hf_lte_rrc_pdcch_CandidateReductions_Format4A_r14;  /* PDCCH_CandidateReductionsLAA_UL_r14 */
static int hf_lte_rrc_pdcch_CandidateReductions_Format0B_r14;  /* PDCCH_CandidateReductionsLAA_UL_r14 */
static int hf_lte_rrc_pdcch_CandidateReductions_Format4B_r14;  /* PDCCH_CandidateReductionsLAA_UL_r14 */
static int hf_lte_rrc_pDCCH_CandidateReductions_r13_setup;  /* T_pDCCH_CandidateReductions_r13_setup */
static int hf_lte_rrc_pdcch_candidateReductionAL1_r13;  /* PDCCH_CandidateReductionValue_r13 */
static int hf_lte_rrc_pdcch_candidateReductionAL2_r13;  /* PDCCH_CandidateReductionValue_r13 */
static int hf_lte_rrc_pdcch_candidateReductionAL3_r13;  /* PDCCH_CandidateReductionValue_r13 */
static int hf_lte_rrc_pdcch_candidateReductionAL4_r13;  /* PDCCH_CandidateReductionValue_r13 */
static int hf_lte_rrc_pdcch_candidateReductionAL5_r13;  /* PDCCH_CandidateReductionValue_r13 */
static int hf_lte_rrc_pDCCH_CandidateReductionsLAA_UL_r14_setup;  /* T_pDCCH_CandidateReductionsLAA_UL_r14_setup */
static int hf_lte_rrc_pdcch_candidateReductionAL1_r14;  /* PDCCH_CandidateReductionValue_r13 */
static int hf_lte_rrc_pdcch_candidateReductionAL2_r14;  /* PDCCH_CandidateReductionValue_r13 */
static int hf_lte_rrc_pdcch_candidateReductionAL3_r14;  /* PDCCH_CandidateReductionValue_r14 */
static int hf_lte_rrc_pdcch_candidateReductionAL4_r14;  /* PDCCH_CandidateReductionValue_r14 */
static int hf_lte_rrc_pdcch_candidateReductionAL5_r14;  /* PDCCH_CandidateReductionValue_r14 */
static int hf_lte_rrc_discardTimer;               /* T_discardTimer */
static int hf_lte_rrc_rlc_AM;                     /* T_rlc_AM */
static int hf_lte_rrc_statusReportRequired;       /* BOOLEAN */
static int hf_lte_rrc_rlc_UM;                     /* T_rlc_UM */
static int hf_lte_rrc_pdcp_SN_Size;               /* T_pdcp_SN_Size */
static int hf_lte_rrc_headerCompression;          /* T_headerCompression */
static int hf_lte_rrc_notUsed;                    /* NULL */
static int hf_lte_rrc_rohc;                       /* T_rohc */
static int hf_lte_rrc_maxCID;                     /* INTEGER_1_16383 */
static int hf_lte_rrc_profiles;                   /* T_profiles */
static int hf_lte_rrc_profile0x0001;              /* BOOLEAN */
static int hf_lte_rrc_profile0x0002;              /* BOOLEAN */
static int hf_lte_rrc_profile0x0003;              /* BOOLEAN */
static int hf_lte_rrc_profile0x0004;              /* BOOLEAN */
static int hf_lte_rrc_profile0x0006;              /* BOOLEAN */
static int hf_lte_rrc_profile0x0101;              /* BOOLEAN */
static int hf_lte_rrc_profile0x0102;              /* BOOLEAN */
static int hf_lte_rrc_profile0x0103;              /* BOOLEAN */
static int hf_lte_rrc_profile0x0104;              /* BOOLEAN */
static int hf_lte_rrc_rn_IntegrityProtection_r10;  /* T_rn_IntegrityProtection_r10 */
static int hf_lte_rrc_pdcp_SN_Size_v1130;         /* T_pdcp_SN_Size_v1130 */
static int hf_lte_rrc_ul_DataSplitDRB_ViaSCG_r12;  /* BOOLEAN */
static int hf_lte_rrc_t_Reordering_r12;           /* T_t_Reordering_r12 */
static int hf_lte_rrc_ul_DataSplitThreshold_r13;  /* T_ul_DataSplitThreshold_r13 */
static int hf_lte_rrc_pDCP_Config_eag_4_ul_DataSplitThreshold_r13_setup;  /* T_pDCP_Config_eag_4_ul_DataSplitThreshold_r13_setup */
static int hf_lte_rrc_pdcp_SN_Size_v1310;         /* T_pdcp_SN_Size_v1310 */
static int hf_lte_rrc_statusFeedback_r13;         /* T_statusFeedback_r13 */
static int hf_lte_rrc_pDCP_Config_eag_4_statusFeedback_r13_setup;  /* T_pDCP_Config_eag_4_statusFeedback_r13_setup */
static int hf_lte_rrc_statusPDU_TypeForPolling_r13;  /* T_statusPDU_TypeForPolling_r13 */
static int hf_lte_rrc_statusPDU_Periodicity_Type1_r13;  /* T_statusPDU_Periodicity_Type1_r13 */
static int hf_lte_rrc_statusPDU_Periodicity_Type2_r13;  /* T_statusPDU_Periodicity_Type2_r13 */
static int hf_lte_rrc_statusPDU_Periodicity_Offset_r13;  /* T_statusPDU_Periodicity_Offset_r13 */
static int hf_lte_rrc_ul_LWA_Config_r14;          /* T_ul_LWA_Config_r14 */
static int hf_lte_rrc_pDCP_Config_eag_5_ul_LWA_Config_r14_setup;  /* T_pDCP_Config_eag_5_ul_LWA_Config_r14_setup */
static int hf_lte_rrc_ul_LWA_DRB_ViaWLAN_r14;     /* BOOLEAN */
static int hf_lte_rrc_ul_LWA_DataSplitThreshold_r14;  /* T_ul_LWA_DataSplitThreshold_r14 */
static int hf_lte_rrc_uplinkOnlyHeaderCompression_r14;  /* T_uplinkOnlyHeaderCompression_r14 */
static int hf_lte_rrc_notUsed_r14;                /* NULL */
static int hf_lte_rrc_rohc_r14;                   /* T_rohc_r14 */
static int hf_lte_rrc_maxCID_r14;                 /* INTEGER_1_16383 */
static int hf_lte_rrc_profiles_r14;               /* T_profiles_r14 */
static int hf_lte_rrc_profile0x0006_r14;          /* BOOLEAN */
static int hf_lte_rrc_uplinkDataCompression_r15;  /* T_uplinkDataCompression_r15 */
static int hf_lte_rrc_bufferSize_r15;             /* T_bufferSize_r15 */
static int hf_lte_rrc_dictionary_r15;             /* T_dictionary_r15 */
static int hf_lte_rrc_pdcp_DuplicationConfig_r15;  /* T_pdcp_DuplicationConfig_r15 */
static int hf_lte_rrc_pDCP_Config_eag_6_pdcp_DuplicationConfig_r15_setup;  /* T_pDCP_Config_eag_6_pdcp_DuplicationConfig_r15_setup */
static int hf_lte_rrc_pdcp_Duplication_r15;       /* T_pdcp_Duplication_r15 */
static int hf_lte_rrc_ethernetHeaderCompression_r16;  /* T_ethernetHeaderCompression_r16 */
static int hf_lte_rrc_pDCP_Config_eag_7_ethernetHeaderCompression_r16_setup;  /* EthernetHeaderCompression_r16 */
static int hf_lte_rrc_discardTimerExt_r17;        /* T_discardTimerExt_r17 */
static int hf_lte_rrc_setup_03;                   /* DiscardTimerExt_r17 */
static int hf_lte_rrc_ehc_Common_r16;             /* T_ehc_Common_r16 */
static int hf_lte_rrc_ehc_CID_Length_r16;         /* T_ehc_CID_Length_r16 */
static int hf_lte_rrc_ehc_Downlink_r16;           /* T_ehc_Downlink_r16 */
static int hf_lte_rrc_drb_ContinueEHC_DL_r16;     /* T_drb_ContinueEHC_DL_r16 */
static int hf_lte_rrc_ehc_Uplink_r16;             /* T_ehc_Uplink_r16 */
static int hf_lte_rrc_maxCID_EHC_UL_r16;          /* INTEGER_1_32767 */
static int hf_lte_rrc_drb_ContinueEHC_UL_r16;     /* T_drb_ContinueEHC_UL_r16 */
static int hf_lte_rrc_referenceSignalPower;       /* INTEGER_M60_50 */
static int hf_lte_rrc_p_b;                        /* INTEGER_0_3 */
static int hf_lte_rrc_pdsch_maxNumRepetitionCEmodeA_r13;  /* T_pdsch_maxNumRepetitionCEmodeA_r13 */
static int hf_lte_rrc_pdsch_maxNumRepetitionCEmodeB_r13;  /* T_pdsch_maxNumRepetitionCEmodeB_r13 */
static int hf_lte_rrc_p_a;                        /* T_p_a */
static int hf_lte_rrc_dmrs_ConfigPDSCH_r11;       /* DMRS_Config_r11 */
static int hf_lte_rrc_qcl_Operation;              /* T_qcl_Operation */
static int hf_lte_rrc_re_MappingQCLConfigToReleaseList_r11;  /* RE_MappingQCLConfigToReleaseList_r11 */
static int hf_lte_rrc_re_MappingQCLConfigToAddModList_r11;  /* RE_MappingQCLConfigToAddModList_r11 */
static int hf_lte_rrc_tbsIndexAlt_r12;            /* T_tbsIndexAlt_r12 */
static int hf_lte_rrc_dmrs_ConfigPDSCH_v1310;     /* DMRS_Config_v1310 */
static int hf_lte_rrc_ce_PDSCH_MaxBandwidth_r14;  /* T_ce_PDSCH_MaxBandwidth_r14 */
static int hf_lte_rrc_ce_PDSCH_TenProcesses_r14;  /* T_ce_PDSCH_TenProcesses_r14 */
static int hf_lte_rrc_ce_HARQ_AckBundling_r14;    /* T_ce_HARQ_AckBundling_r14 */
static int hf_lte_rrc_ce_SchedulingEnhancement_r14;  /* T_ce_SchedulingEnhancement_r14 */
static int hf_lte_rrc_tbsIndexAlt2_r14;           /* T_tbsIndexAlt2_r14 */
static int hf_lte_rrc_qcl_Operation_v1530;        /* T_qcl_Operation_v1530 */
static int hf_lte_rrc_tbs_IndexAlt3_r15;          /* T_tbs_IndexAlt3_r15 */
static int hf_lte_rrc_ce_CQI_AlternativeTableConfig_r15;  /* T_ce_CQI_AlternativeTableConfig_r15 */
static int hf_lte_rrc_ce_PDSCH_64QAM_Config_r15;  /* T_ce_PDSCH_64QAM_Config_r15 */
static int hf_lte_rrc_ce_PDSCH_FlexibleStartPRB_AllocConfig_r15;  /* T_ce_PDSCH_FlexibleStartPRB_AllocConfig_r15 */
static int hf_lte_rrc_altMCS_TableScalingConfig_r15;  /* T_altMCS_TableScalingConfig_r15 */
static int hf_lte_rrc_ce_PDSCH_MultiTB_Config_r16;  /* T_ce_PDSCH_MultiTB_Config_r16 */
static int hf_lte_rrc_pDSCH_ConfigDedicated_v1610_ce_PDSCH_MultiTB_Config_r16_setup;  /* CE_PDSCH_MultiTB_Config_r16 */
static int hf_lte_rrc_ce_PDSCH_14HARQ_Config_r17;  /* T_ce_PDSCH_14HARQ_Config_r17 */
static int hf_lte_rrc_setup_04;                   /* CE_PDSCH_14HARQ_Config_r17 */
static int hf_lte_rrc_ce_PDSCH_maxTBS_r17;        /* T_ce_PDSCH_maxTBS_r17 */
static int hf_lte_rrc_downlinkHARQ_FeedbackDisabledBitmap_r18;  /* T_downlinkHARQ_FeedbackDisabledBitmap_r18 */
static int hf_lte_rrc_setup_05;                   /* DownlinkHARQ_FeedbackDisabledBitmap_r18 */
static int hf_lte_rrc_downlinkHARQ_FeedbackDisabledDCI_r18;  /* T_downlinkHARQ_FeedbackDisabledDCI_r18 */
static int hf_lte_rrc_tbsIndexAlt2_r14_01;        /* T_tbsIndexAlt2_r14_01 */
static int hf_lte_rrc_interleaving_r16;           /* T_interleaving_r16 */
static int hf_lte_rrc_harq_AckBundling_r16;       /* T_harq_AckBundling_r16 */
static int hf_lte_rrc_ce_HARQ_AckDelay_r17;       /* T_ce_HARQ_AckDelay_r17 */
static int hf_lte_rrc_RE_MappingQCLConfigToAddModList_r11_item;  /* PDSCH_RE_MappingQCL_Config_r11 */
static int hf_lte_rrc_RE_MappingQCLConfigToReleaseList_r11_item;  /* PDSCH_RE_MappingQCL_ConfigId_r11 */
static int hf_lte_rrc_pdsch_RE_MappingQCL_ConfigId_r11;  /* PDSCH_RE_MappingQCL_ConfigId_r11 */
static int hf_lte_rrc_optionalSetOfFields_r11;    /* T_optionalSetOfFields_r11 */
static int hf_lte_rrc_crs_PortsCount_r11_01;      /* T_crs_PortsCount_r11_01 */
static int hf_lte_rrc_crs_FreqShift_r11;          /* INTEGER_0_5 */
static int hf_lte_rrc_mbsfn_SubframeConfigList_r11_01;  /* T_mbsfn_SubframeConfigList_r11_01 */
static int hf_lte_rrc_pDSCH_RE_MappingQCL_Config_r11_optionalSetOfFields_r11_mbsfn_SubframeConfigList_r11_setup;  /* T_pDSCH_RE_MappingQCL_Config_r11_optionalSetOfFields_r11_mbsfn_SubframeConfigList_r11_setup */
static int hf_lte_rrc_pdsch_Start_r11;            /* T_pdsch_Start_r11 */
static int hf_lte_rrc_qcl_CSI_RS_ConfigNZPId_r11;  /* CSI_RS_ConfigNZPId_r11 */
static int hf_lte_rrc_mbsfn_SubframeConfigList_v1430_02;  /* T_mbsfn_SubframeConfigList_v1430_01 */
static int hf_lte_rrc_pDSCH_RE_MappingQCL_Config_r11_eag_1_mbsfn_SubframeConfigList_v1430_setup;  /* T_pDSCH_RE_MappingQCL_Config_r11_eag_1_mbsfn_SubframeConfigList_v1430_setup */
static int hf_lte_rrc_codewordOneConfig_v1530;    /* T_codewordOneConfig_v1530 */
static int hf_lte_rrc_pDSCH_RE_MappingQCL_Config_r11_eag_2_codewordOneConfig_v1530_setup;  /* T_pDSCH_RE_MappingQCL_Config_r11_eag_2_codewordOneConfig_v1530_setup */
static int hf_lte_rrc_crs_PortsCount_v1530;       /* T_crs_PortsCount_v1530 */
static int hf_lte_rrc_crs_FreqShift_v1530;        /* INTEGER_0_5 */
static int hf_lte_rrc_mbsfn_SubframeConfigList_v1530;  /* MBSFN_SubframeConfigList */
static int hf_lte_rrc_mbsfn_SubframeConfigListExt_v1530;  /* MBSFN_SubframeConfigList_v1430 */
static int hf_lte_rrc_pdsch_Start_v1530;          /* T_pdsch_Start_v1530 */
static int hf_lte_rrc_csi_RS_ConfigZPId_v1530;    /* CSI_RS_ConfigZPId_r11 */
static int hf_lte_rrc_qcl_CSI_RS_ConfigNZPId_v1530;  /* CSI_RS_ConfigNZPId_r11 */
static int hf_lte_rrc_PerCC_GapIndicationList_r14_item;  /* PerCC_GapIndication_r14 */
static int hf_lte_rrc_servCellId_r14;             /* ServCellIndex_r13 */
static int hf_lte_rrc_gapIndication_r14;          /* T_gapIndication_r14 */
static int hf_lte_rrc_phich_Duration;             /* T_phich_Duration */
static int hf_lte_rrc_phich_Resource;             /* T_phich_Resource */
static int hf_lte_rrc_pdsch_ConfigDedicated;      /* PDSCH_ConfigDedicated */
static int hf_lte_rrc_pucch_ConfigDedicated;      /* PUCCH_ConfigDedicated */
static int hf_lte_rrc_pusch_ConfigDedicated;      /* PUSCH_ConfigDedicated */
static int hf_lte_rrc_uplinkPowerControlDedicated;  /* UplinkPowerControlDedicated */
static int hf_lte_rrc_tpc_PDCCH_ConfigPUCCH;      /* TPC_PDCCH_Config */
static int hf_lte_rrc_tpc_PDCCH_ConfigPUSCH;      /* TPC_PDCCH_Config */
static int hf_lte_rrc_cqi_ReportConfig;           /* CQI_ReportConfig */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicated;  /* SoundingRS_UL_ConfigDedicated */
static int hf_lte_rrc_antennaInfo;                /* T_antennaInfo */
static int hf_lte_rrc_explicitValue_02;           /* AntennaInfoDedicated */
static int hf_lte_rrc_schedulingRequestConfig;    /* SchedulingRequestConfig */
static int hf_lte_rrc_cqi_ReportConfig_v920;      /* CQI_ReportConfig_v920 */
static int hf_lte_rrc_antennaInfo_v920;           /* AntennaInfoDedicated_v920 */
static int hf_lte_rrc_antennaInfo_r10;            /* T_antennaInfo_r10 */
static int hf_lte_rrc_explicitValue_r10;          /* AntennaInfoDedicated_r10 */
static int hf_lte_rrc_antennaInfoUL_r10;          /* AntennaInfoUL_r10 */
static int hf_lte_rrc_pucch_ConfigDedicated_v1020;  /* PUCCH_ConfigDedicated_v1020 */
static int hf_lte_rrc_pusch_ConfigDedicated_v1020;  /* PUSCH_ConfigDedicated_v1020 */
static int hf_lte_rrc_schedulingRequestConfig_v1020;  /* SchedulingRequestConfig_v1020 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicated_v1020;  /* SoundingRS_UL_ConfigDedicated_v1020 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicatedAperiodic_r10;  /* SoundingRS_UL_ConfigDedicatedAperiodic_r10 */
static int hf_lte_rrc_uplinkPowerControlDedicated_v1020;  /* UplinkPowerControlDedicated_v1020 */
static int hf_lte_rrc_additionalSpectrumEmissionCA_r10;  /* T_additionalSpectrumEmissionCA_r10 */
static int hf_lte_rrc_physicalConfigDedicated_eag_3_additionalSpectrumEmissionCA_r10_setup;  /* T_physicalConfigDedicated_eag_3_additionalSpectrumEmissionCA_r10_setup */
static int hf_lte_rrc_additionalSpectrumEmissionPCell_r10;  /* AdditionalSpectrumEmission */
static int hf_lte_rrc_csi_RS_ConfigNZPToReleaseList_r11;  /* CSI_RS_ConfigNZPToReleaseList_r11 */
static int hf_lte_rrc_csi_RS_ConfigNZPToAddModList_r11;  /* CSI_RS_ConfigNZPToAddModList_r11 */
static int hf_lte_rrc_csi_RS_ConfigZPToReleaseList_r11;  /* CSI_RS_ConfigZPToReleaseList_r11 */
static int hf_lte_rrc_csi_RS_ConfigZPToAddModList_r11;  /* CSI_RS_ConfigZPToAddModList_r11 */
static int hf_lte_rrc_epdcch_Config_r11;          /* EPDCCH_Config_r11 */
static int hf_lte_rrc_pdsch_ConfigDedicated_v1130;  /* PDSCH_ConfigDedicated_v1130 */
static int hf_lte_rrc_pucch_ConfigDedicated_v1130;  /* PUCCH_ConfigDedicated_v1130 */
static int hf_lte_rrc_pusch_ConfigDedicated_v1130;  /* PUSCH_ConfigDedicated_v1130 */
static int hf_lte_rrc_uplinkPowerControlDedicated_v1130;  /* UplinkPowerControlDedicated_v1130 */
static int hf_lte_rrc_antennaInfo_v1250;          /* AntennaInfoDedicated_v1250 */
static int hf_lte_rrc_eimta_MainConfig_r12;       /* EIMTA_MainConfig_r12 */
static int hf_lte_rrc_eimta_MainConfigPCell_r12;  /* EIMTA_MainConfigServCell_r12 */
static int hf_lte_rrc_pucch_ConfigDedicated_v1250;  /* PUCCH_ConfigDedicated_v1250 */
static int hf_lte_rrc_uplinkPowerControlDedicated_v1250;  /* UplinkPowerControlDedicated_v1250 */
static int hf_lte_rrc_pusch_ConfigDedicated_v1250;  /* PUSCH_ConfigDedicated_v1250 */
static int hf_lte_rrc_pdsch_ConfigDedicated_v1280;  /* PDSCH_ConfigDedicated_v1280 */
static int hf_lte_rrc_pdsch_ConfigDedicated_v1310;  /* PDSCH_ConfigDedicated_v1310 */
static int hf_lte_rrc_pucch_ConfigDedicated_r13;  /* PUCCH_ConfigDedicated_r13 */
static int hf_lte_rrc_pusch_ConfigDedicated_r13;  /* PUSCH_ConfigDedicated_r13 */
static int hf_lte_rrc_pdcch_CandidateReductions_r13;  /* PDCCH_CandidateReductions_r13 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicated_v1310;  /* SoundingRS_UL_ConfigDedicated_v1310 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicatedUpPTsExt_r13;  /* SoundingRS_UL_ConfigDedicatedUpPTsExt_r13 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicatedAperiodic_v1310;  /* SoundingRS_UL_ConfigDedicatedAperiodic_v1310 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicatedAperiodicUpPTsExt_r13;  /* SoundingRS_UL_ConfigDedicatedAperiodicUpPTsExt_r13 */
static int hf_lte_rrc_ce_Mode_r13;                /* T_ce_Mode_r13 */
static int hf_lte_rrc_physicalConfigDedicated_eag_7_ce_Mode_r13_setup;  /* T_physicalConfigDedicated_eag_7_ce_Mode_r13_setup */
static int hf_lte_rrc_csi_RS_ConfigNZPToAddModListExt_r13;  /* CSI_RS_ConfigNZPToAddModListExt_r13 */
static int hf_lte_rrc_csi_RS_ConfigNZPToReleaseListExt_r13;  /* CSI_RS_ConfigNZPToReleaseListExt_r13 */
static int hf_lte_rrc_typeA_SRS_TPC_PDCCH_Group_r14;  /* T_typeA_SRS_TPC_PDCCH_Group_r14 */
static int hf_lte_rrc_physicalConfigDedicated_eag_7_ce_Mode_r13_setup_01;  /* SEQUENCE_SIZE_1_32_OF_SRS_TPC_PDCCH_Config_r14 */
static int hf_lte_rrc_typeA_SRS_TPC_PDCCH_Group_r14_setup_item;  /* SRS_TPC_PDCCH_Config_r14 */
static int hf_lte_rrc_must_Config_r14;            /* T_must_Config_r14 */
static int hf_lte_rrc_physicalConfigDedicated_eag_9_must_Config_r14_setup;  /* T_physicalConfigDedicated_eag_9_must_Config_r14_setup */
static int hf_lte_rrc_k_max_r14;                  /* T_k_max_r14 */
static int hf_lte_rrc_p_a_must_r14;               /* T_p_a_must_r14 */
static int hf_lte_rrc_pusch_EnhancementsConfig_r14;  /* PUSCH_EnhancementsConfig_r14 */
static int hf_lte_rrc_ce_pdsch_pusch_EnhancementConfig_r14;  /* T_ce_pdsch_pusch_EnhancementConfig_r14 */
static int hf_lte_rrc_antennaInfo_v1430;          /* AntennaInfoDedicated_v1430 */
static int hf_lte_rrc_pucch_ConfigDedicated_v1430;  /* PUCCH_ConfigDedicated_v1430 */
static int hf_lte_rrc_pdsch_ConfigDedicated_v1430;  /* PDSCH_ConfigDedicated_v1430 */
static int hf_lte_rrc_pusch_ConfigDedicated_v1430;  /* PUSCH_ConfigDedicated_v1430 */
static int hf_lte_rrc_soundingRS_UL_PeriodicConfigDedicatedList_r14;  /* SEQUENCE_SIZE_1_2_OF_SoundingRS_UL_ConfigDedicated */
static int hf_lte_rrc_soundingRS_UL_PeriodicConfigDedicatedList_r14_item;  /* SoundingRS_UL_ConfigDedicated */
static int hf_lte_rrc_soundingRS_UL_PeriodicConfigDedicatedUpPTsExtList_r14;  /* SEQUENCE_SIZE_1_4_OF_SoundingRS_UL_ConfigDedicatedUpPTsExt_r13 */
static int hf_lte_rrc_soundingRS_UL_PeriodicConfigDedicatedUpPTsExtList_r14_item;  /* SoundingRS_UL_ConfigDedicatedUpPTsExt_r13 */
static int hf_lte_rrc_soundingRS_UL_AperiodicConfigDedicatedList_r14;  /* SEQUENCE_SIZE_1_2_OF_SoundingRS_UL_ConfigDedicatedAperiodic_r10 */
static int hf_lte_rrc_soundingRS_UL_AperiodicConfigDedicatedList_r14_item;  /* SoundingRS_UL_ConfigDedicatedAperiodic_r10 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicatedApUpPTsExtList_r14;  /* SEQUENCE_SIZE_1_4_OF_SoundingRS_UL_ConfigDedicatedAperiodicUpPTsExt_r13 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicatedApUpPTsExtList_r14_item;  /* SoundingRS_UL_ConfigDedicatedAperiodicUpPTsExt_r13 */
static int hf_lte_rrc_csi_RS_ConfigZP_ApList_r14;  /* CSI_RS_ConfigZP_ApList_r14 */
static int hf_lte_rrc_semiOpenLoop_r14;           /* BOOLEAN */
static int hf_lte_rrc_csi_RS_Config_v1480;        /* CSI_RS_Config_v1480 */
static int hf_lte_rrc_physicalConfigDedicatedSTTI_r15;  /* PhysicalConfigDedicatedSTTI_r15 */
static int hf_lte_rrc_pdsch_ConfigDedicated_v1530;  /* PDSCH_ConfigDedicated_v1530 */
static int hf_lte_rrc_pusch_ConfigDedicated_v1530;  /* PUSCH_ConfigDedicated_v1530 */
static int hf_lte_rrc_cqi_ReportConfig_v1530;     /* CQI_ReportConfig_v1530 */
static int hf_lte_rrc_antennaInfo_v1530;          /* AntennaInfoDedicated_v1530 */
static int hf_lte_rrc_csi_RS_Config_v1530;        /* CSI_RS_Config_v1530 */
static int hf_lte_rrc_uplinkPowerControlDedicated_v1530;  /* UplinkPowerControlDedicated_v1530 */
static int hf_lte_rrc_semiStaticCFI_Config_r15;   /* T_semiStaticCFI_Config_r15 */
static int hf_lte_rrc_physicalConfigDedicated_eag_11_semiStaticCFI_Config_r15_setup;  /* T_physicalConfigDedicated_eag_11_semiStaticCFI_Config_r15_setup */
static int hf_lte_rrc_cfi_Config_r15;             /* CFI_Config_r15 */
static int hf_lte_rrc_cfi_PatternConfig_r15;      /* CFI_PatternConfig_r15 */
static int hf_lte_rrc_blindPDSCH_Repetition_Config_r15;  /* T_blindPDSCH_Repetition_Config_r15 */
static int hf_lte_rrc_physicalConfigDedicated_eag_11_blindPDSCH_Repetition_Config_r15_setup;  /* T_physicalConfigDedicated_eag_11_blindPDSCH_Repetition_Config_r15_setup */
static int hf_lte_rrc_blindSubframePDSCH_Repetitions_r15;  /* BOOLEAN */
static int hf_lte_rrc_blindSlotSubslotPDSCH_Repetitions_r15;  /* BOOLEAN */
static int hf_lte_rrc_maxNumber_SubframePDSCH_Repetitions_r15;  /* T_maxNumber_SubframePDSCH_Repetitions_r15 */
static int hf_lte_rrc_maxNumber_SlotSubslotPDSCH_Repetitions_r15;  /* T_maxNumber_SlotSubslotPDSCH_Repetitions_r15 */
static int hf_lte_rrc_rv_SubframePDSCH_Repetitions_r15;  /* T_rv_SubframePDSCH_Repetitions_r15 */
static int hf_lte_rrc_rv_SlotsublotPDSCH_Repetitions_r15;  /* T_rv_SlotsublotPDSCH_Repetitions_r15 */
static int hf_lte_rrc_numberOfProcesses_SubframePDSCH_Repetitions_r15;  /* INTEGER_1_16 */
static int hf_lte_rrc_numberOfProcesses_SlotSubslotPDSCH_Repetitions_r15;  /* INTEGER_1_16 */
static int hf_lte_rrc_mcs_restrictionSubframePDSCH_Repetitions_r15;  /* T_mcs_restrictionSubframePDSCH_Repetitions_r15 */
static int hf_lte_rrc_mcs_restrictionSlotSubslotPDSCH_Repetitions_r15;  /* T_mcs_restrictionSlotSubslotPDSCH_Repetitions_r15 */
static int hf_lte_rrc_spucch_Config_v1550;        /* SPUCCH_Config_v1550 */
static int hf_lte_rrc_pdsch_ConfigDedicated_v1610;  /* PDSCH_ConfigDedicated_v1610 */
static int hf_lte_rrc_pusch_ConfigDedicated_v1610;  /* PUSCH_ConfigDedicated_v1610 */
static int hf_lte_rrc_ce_CSI_RS_Feedback_r16;     /* T_ce_CSI_RS_Feedback_r16 */
static int hf_lte_rrc_resourceReservationConfigDedicatedDL_r16;  /* T_resourceReservationConfigDedicatedDL_r16 */
static int hf_lte_rrc_physicalConfigDedicated_eag_13_resourceReservationConfigDedicatedDL_r16_setup;  /* ResourceReservationConfigDedicatedDL_r16 */
static int hf_lte_rrc_resourceReservationConfigDedicatedUL_r16;  /* T_resourceReservationConfigDedicatedUL_r16 */
static int hf_lte_rrc_physicalConfigDedicated_eag_13_resourceReservationConfigDedicatedUL_r16_setup;  /* ResourceReservationConfigDedicatedUL_r16 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicatedAdd_r16;  /* T_soundingRS_UL_ConfigDedicatedAdd_r16 */
static int hf_lte_rrc_physicalConfigDedicated_eag_13_soundingRS_UL_ConfigDedicatedAdd_r16_setup;  /* SoundingRS_UL_ConfigDedicatedAdd_r16 */
static int hf_lte_rrc_uplinkPowerControlAddSRS_r16;  /* T_uplinkPowerControlAddSRS_r16 */
static int hf_lte_rrc_physicalConfigDedicated_eag_13_uplinkPowerControlAddSRS_r16_setup;  /* UplinkPowerControlAddSRS_r16 */
static int hf_lte_rrc_soundingRS_VirtualCellID_r16;  /* T_soundingRS_VirtualCellID_r16 */
static int hf_lte_rrc_physicalConfigDedicated_eag_13_soundingRS_VirtualCellID_r16_setup;  /* SoundingRS_VirtualCellID_r16 */
static int hf_lte_rrc_widebandPRG_r16;            /* T_widebandPRG_r16 */
static int hf_lte_rrc_physicalConfigDedicated_eag_13_widebandPRG_r16_setup;  /* WidebandPRG_r16 */
static int hf_lte_rrc_pdsch_ConfigDedicated_v1700;  /* PDSCH_ConfigDedicated_v1700 */
static int hf_lte_rrc_ntn_ConfigDedicated_r17;    /* T_ntn_ConfigDedicated_r17 */
static int hf_lte_rrc_pucch_TxDuration_r17;       /* T_pucch_TxDuration_r17 */
static int hf_lte_rrc_setup_06;                   /* PUCCH_TxDuration_r17 */
static int hf_lte_rrc_pusch_TxDuration_r17;       /* T_pusch_TxDuration_r17 */
static int hf_lte_rrc_setup_07;                   /* PUSCH_TxDuration_r17 */
static int hf_lte_rrc_uplinkSegmentedPrecompensationGap_r17;  /* T_uplinkSegmentedPrecompensationGap_r17 */
static int hf_lte_rrc_pdsch_ConfigDedicated_v1800;  /* PDSCH_ConfigDedicated_v1800 */
static int hf_lte_rrc_pusch_ConfigDedicated_v1800;  /* PUSCH_ConfigDedicated_v1800 */
static int hf_lte_rrc_pucch_ConfigDedicated_v1370;  /* PUCCH_ConfigDedicated_v1370 */
static int hf_lte_rrc_pucch_ConfigDedicated_v13c0;  /* PUCCH_ConfigDedicated_v13c0 */
static int hf_lte_rrc_nonUL_Configuration_r10;    /* T_nonUL_Configuration_r10 */
static int hf_lte_rrc_antennaInfo_r10_01;         /* AntennaInfoDedicated_r10 */
static int hf_lte_rrc_crossCarrierSchedulingConfig_r10;  /* CrossCarrierSchedulingConfig_r10 */
static int hf_lte_rrc_pdsch_ConfigDedicated_r10;  /* PDSCH_ConfigDedicated */
static int hf_lte_rrc_ul_Configuration_r10;       /* T_ul_Configuration_r10 */
static int hf_lte_rrc_pusch_ConfigDedicatedSCell_r10;  /* PUSCH_ConfigDedicatedSCell_r10 */
static int hf_lte_rrc_uplinkPowerControlDedicatedSCell_r10;  /* UplinkPowerControlDedicatedSCell_r10 */
static int hf_lte_rrc_cqi_ReportConfigSCell_r10;  /* CQI_ReportConfigSCell_r10 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicated_r10;  /* SoundingRS_UL_ConfigDedicated */
static int hf_lte_rrc_uplinkPowerControlDedicatedSCell_v1130;  /* UplinkPowerControlDedicated_v1130 */
static int hf_lte_rrc_eimta_MainConfigSCell_r12;  /* EIMTA_MainConfigServCell_r12 */
static int hf_lte_rrc_cqi_ReportConfigSCell_v1250;  /* CQI_ReportConfig_v1250 */
static int hf_lte_rrc_uplinkPowerControlDedicatedSCell_v1250;  /* UplinkPowerControlDedicated_v1250 */
static int hf_lte_rrc_pucch_Cell_r13;             /* T_pucch_Cell_r13 */
static int hf_lte_rrc_pucch_SCell;                /* T_pucch_SCell */
static int hf_lte_rrc_physicalConfigDedicatedSCell_r10_eag_4_pucch_SCell_setup;  /* T_physicalConfigDedicatedSCell_r10_eag_4_pucch_SCell_setup */
static int hf_lte_rrc_schedulingRequestConfig_r13;  /* SchedulingRequestConfigSCell_r13 */
static int hf_lte_rrc_tpc_PDCCH_ConfigPUCCH_SCell_r13;  /* TPC_PDCCH_ConfigSCell_r13 */
static int hf_lte_rrc_uplinkPowerControlDedicated_r13;  /* UplinkPowerControlDedicatedSCell_v1310 */
static int hf_lte_rrc_crossCarrierSchedulingConfig_r13;  /* CrossCarrierSchedulingConfig_r13 */
static int hf_lte_rrc_pdcch_ConfigSCell_r13;      /* PDCCH_ConfigSCell_r13 */
static int hf_lte_rrc_laa_SCellConfiguration_r13;  /* LAA_SCellConfiguration_r13 */
static int hf_lte_rrc_laa_SCellConfiguration_v1430;  /* LAA_SCellConfiguration_v1430 */
static int hf_lte_rrc_typeB_SRS_TPC_PDCCH_Config_r14;  /* SRS_TPC_PDCCH_Config_r14 */
static int hf_lte_rrc_uplinkPUSCH_LessPowerControlDedicated_v1430;  /* UplinkPUSCH_LessPowerControlDedicated_v1430 */
static int hf_lte_rrc_soundingRS_UL_AperiodicConfigDedicatedList_r14_01;  /* SEQUENCE_SIZE_1_2_OF_SoundingRS_AperiodicSet_r14 */
static int hf_lte_rrc_soundingRS_UL_AperiodicConfigDedicatedList_r14_item_01;  /* SoundingRS_AperiodicSet_r14 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicatedApUpPTsExtList_r14_01;  /* SEQUENCE_SIZE_1_4_OF_SoundingRS_AperiodicSetUpPTsExt_r14 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicatedApUpPTsExtList_r14_item_01;  /* SoundingRS_AperiodicSetUpPTsExt_r14 */
static int hf_lte_rrc_must_Config_r14_01;         /* T_must_Config_r14_01 */
static int hf_lte_rrc_physicalConfigDedicatedSCell_r10_eag_6_must_Config_r14_setup;  /* T_physicalConfigDedicatedSCell_r10_eag_6_must_Config_r14_setup */
static int hf_lte_rrc_k_max_r14_01;               /* T_k_max_r14_01 */
static int hf_lte_rrc_p_a_must_r14_01;            /* T_p_a_must_r14_01 */
static int hf_lte_rrc_pusch_ConfigDedicated_v1430_01;  /* PUSCH_ConfigDedicatedSCell_v1430 */
static int hf_lte_rrc_pdsch_ConfigDedicatedSCell_v1430;  /* PDSCH_ConfigDedicatedSCell_v1430 */
static int hf_lte_rrc_dummy_01;                   /* CQI_ReportConfig_v1530 */
static int hf_lte_rrc_cqi_ReportConfigSCell_r15;  /* CQI_ReportConfigSCell_r15 */
static int hf_lte_rrc_cqi_ShortConfigSCell_r15;   /* CQI_ShortConfigSCell_r15 */
static int hf_lte_rrc_uplinkPowerControlDedicatedSCell_v1530;  /* UplinkPowerControlDedicated_v1530 */
static int hf_lte_rrc_laa_SCellConfiguration_v1530;  /* LAA_SCellConfiguration_v1530 */
static int hf_lte_rrc_pusch_ConfigDedicated_v1530_01;  /* PUSCH_ConfigDedicatedScell_v1530 */
static int hf_lte_rrc_semiStaticCFI_Config_r15_01;  /* T_semiStaticCFI_Config_r15_01 */
static int hf_lte_rrc_physicalConfigDedicatedSCell_r10_eag_8_semiStaticCFI_Config_r15_setup;  /* T_physicalConfigDedicatedSCell_r10_eag_8_semiStaticCFI_Config_r15_setup */
static int hf_lte_rrc_blindPDSCH_Repetition_Config_r15_01;  /* T_blindPDSCH_Repetition_Config_r15_01 */
static int hf_lte_rrc_physicalConfigDedicatedSCell_r10_eag_8_blindPDSCH_Repetition_Config_r15_setup;  /* T_physicalConfigDedicatedSCell_r10_eag_8_blindPDSCH_Repetition_Config_r15_setup */
static int hf_lte_rrc_maxNumber_SubframePDSCH_Repetitions_r15_01;  /* T_maxNumber_SubframePDSCH_Repetitions_r15_01 */
static int hf_lte_rrc_maxNumber_SlotSubslotPDSCH_Repetitions_r15_01;  /* T_maxNumber_SlotSubslotPDSCH_Repetitions_r15_01 */
static int hf_lte_rrc_rv_SubframePDSCH_Repetitions_r15_01;  /* T_rv_SubframePDSCH_Repetitions_r15_01 */
static int hf_lte_rrc_rv_SlotsublotPDSCH_Repetitions_r15_01;  /* T_rv_SlotsublotPDSCH_Repetitions_r15_01 */
static int hf_lte_rrc_mcs_restrictionSubframePDSCH_Repetitions_r15_01;  /* T_mcs_restrictionSubframePDSCH_Repetitions_r15_01 */
static int hf_lte_rrc_mcs_restrictionSlotSubslotPDSCH_Repetitions_r15_01;  /* T_mcs_restrictionSlotSubslotPDSCH_Repetitions_r15_01 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicatedAdd_r16_01;  /* T_soundingRS_UL_ConfigDedicatedAdd_r16_01 */
static int hf_lte_rrc_physicalConfigDedicatedSCell_r10_eag_10_soundingRS_UL_ConfigDedicatedAdd_r16_setup;  /* SoundingRS_UL_ConfigDedicatedAdd_r16 */
static int hf_lte_rrc_uplinkPowerControlAddSRS_r16_01;  /* T_uplinkPowerControlAddSRS_r16_01 */
static int hf_lte_rrc_physicalConfigDedicatedSCell_r10_eag_10_uplinkPowerControlAddSRS_r16_setup;  /* UplinkPowerControlAddSRS_r16 */
static int hf_lte_rrc_soundingRS_VirtualCellID_r16_01;  /* T_soundingRS_VirtualCellID_r16_01 */
static int hf_lte_rrc_physicalConfigDedicatedSCell_r10_eag_10_soundingRS_VirtualCellID_r16_setup;  /* SoundingRS_VirtualCellID_r16 */
static int hf_lte_rrc_widebandPRG_r16_01;         /* T_widebandPRG_r16_01 */
static int hf_lte_rrc_physicalConfigDedicatedSCell_r10_eag_10_widebandPRG_r16_setup;  /* WidebandPRG_r16 */
static int hf_lte_rrc_pucch_SCell_v1370;          /* T_pucch_SCell_v1370 */
static int hf_lte_rrc_physicalConfigDedicatedSCell_v1370_pucch_SCell_v1370_setup;  /* T_physicalConfigDedicatedSCell_v1370_pucch_SCell_v1370_setup */
static int hf_lte_rrc_pucch_SCell_v13c0;          /* T_pucch_SCell_v13c0 */
static int hf_lte_rrc_physicalConfigDedicatedSCell_v13c0_pucch_SCell_v13c0_setup;  /* T_physicalConfigDedicatedSCell_v13c0_pucch_SCell_v13c0_setup */
static int hf_lte_rrc_cqi_ReportPeriodicSCell_v1730;  /* T_cqi_ReportPeriodicSCell_v1730 */
static int hf_lte_rrc_setup_08;                   /* CQI_ReportPeriodicSCell_v1730 */
static int hf_lte_rrc_cfi_SubframeNonMBSFN_r15;   /* INTEGER_1_4 */
static int hf_lte_rrc_cfi_SlotSubslotNonMBSFN_r15;  /* INTEGER_1_3 */
static int hf_lte_rrc_cfi_SubframeMBSFN_r15;      /* INTEGER_1_2 */
static int hf_lte_rrc_cfi_SlotSubslotMBSFN_r15;   /* INTEGER_1_2 */
static int hf_lte_rrc_cfi_PatternSubframe_r15;    /* T_cfi_PatternSubframe_r15 */
static int hf_lte_rrc_cfi_PatternSubframe_r15_item;  /* INTEGER_1_4 */
static int hf_lte_rrc_cfi_PatternSlotSubslot_r15;  /* T_cfi_PatternSlotSubslot_r15 */
static int hf_lte_rrc_cfi_PatternSlotSubslot_r15_item;  /* INTEGER_1_3 */
static int hf_lte_rrc_subframeStartPosition_r13;  /* T_subframeStartPosition_r13 */
static int hf_lte_rrc_laa_SCellSubframeConfig_r13;  /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_crossCarrierSchedulingConfig_UL_r14;  /* T_crossCarrierSchedulingConfig_UL_r14 */
static int hf_lte_rrc_lAA_SCellConfiguration_v1430_crossCarrierSchedulingConfig_UL_r14_setup;  /* T_lAA_SCellConfiguration_v1430_crossCarrierSchedulingConfig_UL_r14_setup */
static int hf_lte_rrc_crossCarrierSchedulingConfigLAA_UL_r14;  /* CrossCarrierSchedulingConfigLAA_UL_r14 */
static int hf_lte_rrc_lbt_Config_r14;             /* LBT_Config_r14 */
static int hf_lte_rrc_pdcch_ConfigLAA_r14;        /* PDCCH_ConfigLAA_r14 */
static int hf_lte_rrc_absenceOfAnyOtherTechnology_r14;  /* T_absenceOfAnyOtherTechnology_r14 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicatedAperiodic_v1430;  /* SoundingRS_UL_ConfigDedicatedAperiodic_v1430 */
static int hf_lte_rrc_aul_Config_r15;             /* AUL_Config_r15 */
static int hf_lte_rrc_pusch_ModeConfigLAA_r15;    /* PUSCH_ModeConfigLAA_r15 */
static int hf_lte_rrc_laa_PUSCH_Mode1;            /* BOOLEAN */
static int hf_lte_rrc_laa_PUSCH_Mode2;            /* BOOLEAN */
static int hf_lte_rrc_laa_PUSCH_Mode3;            /* BOOLEAN */
static int hf_lte_rrc_maxEnergyDetectionThreshold_r14;  /* INTEGER_M85_M52 */
static int hf_lte_rrc_energyDetectionThresholdOffset_r14;  /* INTEGER_M13_20 */
static int hf_lte_rrc_CSI_RS_ConfigNZPToAddModList_r11_item;  /* CSI_RS_ConfigNZP_r11 */
static int hf_lte_rrc_CSI_RS_ConfigNZPToAddModListExt_r13_item;  /* CSI_RS_ConfigNZP_r11 */
static int hf_lte_rrc_CSI_RS_ConfigNZPToAddModList_r15_item;  /* CSI_RS_ConfigNZP_r11 */
static int hf_lte_rrc_CSI_RS_ConfigNZPToReleaseList_r11_item;  /* CSI_RS_ConfigNZPId_r11 */
static int hf_lte_rrc_CSI_RS_ConfigNZPToReleaseListExt_r13_item;  /* CSI_RS_ConfigNZPId_v1310 */
static int hf_lte_rrc_CSI_RS_ConfigNZPToReleaseList_r15_item;  /* CSI_RS_ConfigNZPId_r13 */
static int hf_lte_rrc_CSI_RS_ConfigZPToAddModList_r11_item;  /* CSI_RS_ConfigZP_r11 */
static int hf_lte_rrc_CSI_RS_ConfigZPToReleaseList_r11_item;  /* CSI_RS_ConfigZPId_r11 */
static int hf_lte_rrc_physicalConfigDedicatedSTTI_r15_setup;  /* T_physicalConfigDedicatedSTTI_r15_setup */
static int hf_lte_rrc_antennaInfoDedicatedSTTI_r15;  /* AntennaInfoDedicatedSTTI_r15 */
static int hf_lte_rrc_antennaInfoUL_STTI_r15;     /* AntennaInfoUL_STTI_r15 */
static int hf_lte_rrc_pucch_ConfigDedicated_v1530;  /* PUCCH_ConfigDedicated_v1530 */
static int hf_lte_rrc_schedulingRequestConfig_v1530;  /* SchedulingRequestConfig_v1530 */
static int hf_lte_rrc_uplinkPowerControlDedicatedSTTI_r15;  /* UplinkPowerControlDedicatedSTTI_r15 */
static int hf_lte_rrc_cqi_ReportConfig_r15;       /* CQI_ReportConfig_r15 */
static int hf_lte_rrc_csi_RS_Config_r15;          /* CSI_RS_Config_r15 */
static int hf_lte_rrc_csi_RS_ConfigNZPToReleaseList_r15;  /* CSI_RS_ConfigNZPToReleaseList_r15 */
static int hf_lte_rrc_csi_RS_ConfigNZPToAddModList_r15;  /* CSI_RS_ConfigNZPToAddModList_r15 */
static int hf_lte_rrc_csi_RS_ConfigZPToReleaseList_r15;  /* CSI_RS_ConfigZPToReleaseList_r11 */
static int hf_lte_rrc_csi_RS_ConfigZP_ApList_r15;  /* CSI_RS_ConfigZP_ApList_r14 */
static int hf_lte_rrc_eimta_MainConfigServCell_r15;  /* EIMTA_MainConfigServCell_r12 */
static int hf_lte_rrc_semiOpenLoopSTTI_r15;       /* BOOLEAN */
static int hf_lte_rrc_slotOrSubslotPDSCH_Config_r15;  /* SlotOrSubslotPDSCH_Config_r15 */
static int hf_lte_rrc_slotOrSubslotPUSCH_Config_r15;  /* SlotOrSubslotPUSCH_Config_r15 */
static int hf_lte_rrc_spdcch_Config_r15;          /* SPDCCH_Config_r15 */
static int hf_lte_rrc_spucch_Config_r15;          /* SPUCCH_Config_r15 */
static int hf_lte_rrc_srs_DCI7_TriggeringConfig_r15;  /* BOOLEAN */
static int hf_lte_rrc_shortProcessingTime_r15;    /* BOOLEAN */
static int hf_lte_rrc_shortTTI_r15_01;            /* ShortTTI_r15 */
static int hf_lte_rrc_srs_CC_SetIndexList_r14;    /* SEQUENCE_SIZE_1_4_OF_SRS_CC_SetIndex_r14 */
static int hf_lte_rrc_srs_CC_SetIndexList_r14_item;  /* SRS_CC_SetIndex_r14 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicatedAperiodic_r14;  /* SoundingRS_UL_ConfigDedicatedAperiodic_r10 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicatedAperiodicUpPTsExt_r14;  /* SoundingRS_UL_ConfigDedicatedAperiodicUpPTsExt_r13 */
static int hf_lte_rrc_dl_STTI_Length_r15;         /* ShortTTI_Length_r15 */
static int hf_lte_rrc_ul_STTI_Length_r15;         /* ShortTTI_Length_r15 */
static int hf_lte_rrc_srs_VirtualCellID_r16;      /* INTEGER_0_503 */
static int hf_lte_rrc_srs_VirtualCellID_AllSRS_r16;  /* BOOLEAN */
static int hf_lte_rrc_widebandPRG_r16_widebandPRG_Subframe_r16;  /* BOOLEAN */
static int hf_lte_rrc_widebandPRG_SlotSubslot_r16;  /* BOOLEAN */
static int hf_lte_rrc_resourceReservationDedicatedDL_r16;  /* ResourceReservationConfigDL_r16 */
static int hf_lte_rrc_resourceReservationDedicatedUL_r16;  /* ResourceReservationConfigUL_r16 */
static int hf_lte_rrc_rootSequenceIndex;          /* INTEGER_0_837 */
static int hf_lte_rrc_prach_ConfigInfo;           /* PRACH_ConfigInfo */
static int hf_lte_rrc_rsrp_ThresholdsPrachInfoList_r13;  /* RSRP_ThresholdsPrachInfoList_r13 */
static int hf_lte_rrc_mpdcch_startSF_CSS_RA_r13;  /* T_mpdcch_startSF_CSS_RA_r13 */
static int hf_lte_rrc_fdd_r13_01;                 /* T_fdd_r13_01 */
static int hf_lte_rrc_tdd_r13_01;                 /* T_tdd_r13_01 */
static int hf_lte_rrc_prach_HoppingOffset_r13;    /* INTEGER_0_94 */
static int hf_lte_rrc_prach_ParametersListCE_r13;  /* PRACH_ParametersListCE_r13 */
static int hf_lte_rrc_edt_PRACH_ParametersListCE_r15;  /* SEQUENCE_SIZE_1_maxCE_Level_r13_OF_EDT_PRACH_ParametersCE_r15 */
static int hf_lte_rrc_edt_PRACH_ParametersListCE_r15_item;  /* EDT_PRACH_ParametersCE_r15 */
static int hf_lte_rrc_mpdcch_startSF_CSS_RA_r13_01;  /* T_mpdcch_startSF_CSS_RA_r13_01 */
static int hf_lte_rrc_fdd_r13_02;                 /* T_fdd_r13_02 */
static int hf_lte_rrc_tdd_r13_02;                 /* T_tdd_r13_02 */
static int hf_lte_rrc_initial_CE_level_r13;       /* INTEGER_0_3 */
static int hf_lte_rrc_rootSequenceIndexHighSpeed_r14;  /* INTEGER_0_837 */
static int hf_lte_rrc_zeroCorrelationZoneConfigHighSpeed_r14;  /* INTEGER_0_12 */
static int hf_lte_rrc_prach_ConfigIndexHighSpeed_r14;  /* INTEGER_0_63 */
static int hf_lte_rrc_prach_FreqOffsetHighSpeed_r14;  /* INTEGER_0_94 */
static int hf_lte_rrc_prach_ConfigIndex_r10;      /* INTEGER_0_63 */
static int hf_lte_rrc_prach_ConfigIndex;          /* INTEGER_0_63 */
static int hf_lte_rrc_highSpeedFlag;              /* BOOLEAN */
static int hf_lte_rrc_zeroCorrelationZoneConfig;  /* INTEGER_0_15 */
static int hf_lte_rrc_prach_FreqOffset;           /* INTEGER_0_94 */
static int hf_lte_rrc_PRACH_ParametersListCE_r13_item;  /* PRACH_ParametersCE_r13 */
static int hf_lte_rrc_prach_ConfigIndex_r13;      /* INTEGER_0_63 */
static int hf_lte_rrc_prach_FreqOffset_r13;       /* INTEGER_0_94 */
static int hf_lte_rrc_prach_StartingSubframe_r13;  /* T_prach_StartingSubframe_r13 */
static int hf_lte_rrc_maxNumPreambleAttemptCE_r13;  /* T_maxNumPreambleAttemptCE_r13 */
static int hf_lte_rrc_numRepetitionPerPreambleAttempt_r13;  /* T_numRepetitionPerPreambleAttempt_r13 */
static int hf_lte_rrc_mpdcch_NarrowbandsToMonitor_r13;  /* T_mpdcch_NarrowbandsToMonitor_r13 */
static int hf_lte_rrc_mpdcch_NarrowbandsToMonitor_r13_item;  /* INTEGER_1_maxAvailNarrowBands_r13 */
static int hf_lte_rrc_mpdcch_NumRepetition_RA_r13;  /* T_mpdcch_NumRepetition_RA_r13 */
static int hf_lte_rrc_prach_HoppingConfig_r13;    /* T_prach_HoppingConfig_r13 */
static int hf_lte_rrc_edt_PRACH_ParametersCE_r15;  /* T_edt_PRACH_ParametersCE_r15 */
static int hf_lte_rrc_prach_ConfigIndex_r15;      /* INTEGER_0_63 */
static int hf_lte_rrc_prach_FreqOffset_r15;       /* INTEGER_0_94 */
static int hf_lte_rrc_prach_StartingSubframe_r15;  /* T_prach_StartingSubframe_r15 */
static int hf_lte_rrc_mpdcch_NarrowbandsToMonitor_r15;  /* T_mpdcch_NarrowbandsToMonitor_r15 */
static int hf_lte_rrc_mpdcch_NarrowbandsToMonitor_r15_item;  /* INTEGER_1_maxAvailNarrowBands_r13 */
static int hf_lte_rrc_RSRP_ThresholdsPrachInfoList_r13_item;  /* RSRP_Range */
static int hf_lte_rrc_prach_TxDuration_r17;       /* T_prach_TxDuration_r17 */
static int hf_lte_rrc_deltaPUCCH_Shift;           /* T_deltaPUCCH_Shift */
static int hf_lte_rrc_nRB_CQI;                    /* INTEGER_0_98 */
static int hf_lte_rrc_nCS_AN;                     /* INTEGER_0_7 */
static int hf_lte_rrc_n1PUCCH_AN;                 /* INTEGER_0_2047 */
static int hf_lte_rrc_n1PUCCH_AN_InfoList_r13;    /* N1PUCCH_AN_InfoList_r13 */
static int hf_lte_rrc_pucch_NumRepetitionCE_Msg4_Level0_r13;  /* T_pucch_NumRepetitionCE_Msg4_Level0_r13 */
static int hf_lte_rrc_pucch_NumRepetitionCE_Msg4_Level1_r13;  /* T_pucch_NumRepetitionCE_Msg4_Level1_r13 */
static int hf_lte_rrc_pucch_NumRepetitionCE_Msg4_Level2_r13;  /* T_pucch_NumRepetitionCE_Msg4_Level2_r13 */
static int hf_lte_rrc_pucch_NumRepetitionCE_Msg4_Level3_r13;  /* T_pucch_NumRepetitionCE_Msg4_Level3_r13 */
static int hf_lte_rrc_pucch_NumRepetitionCE_Msg4_Level3_r14;  /* T_pucch_NumRepetitionCE_Msg4_Level3_r14 */
static int hf_lte_rrc_ackNackRepetition;          /* T_ackNackRepetition */
static int hf_lte_rrc_pUCCH_ConfigDedicated_ackNackRepetition_setup;  /* T_pUCCH_ConfigDedicated_ackNackRepetition_setup */
static int hf_lte_rrc_repetitionFactor;           /* T_repetitionFactor */
static int hf_lte_rrc_n1PUCCH_AN_Rep;             /* INTEGER_0_2047 */
static int hf_lte_rrc_tdd_AckNackFeedbackMode;    /* T_tdd_AckNackFeedbackMode */
static int hf_lte_rrc_pucch_Format_r10;           /* T_pucch_Format_r10 */
static int hf_lte_rrc_format3_r10;                /* PUCCH_Format3_Conf_r13 */
static int hf_lte_rrc_channelSelection_r10;       /* T_channelSelection_r10 */
static int hf_lte_rrc_n1PUCCH_AN_CS_r10;          /* T_n1PUCCH_AN_CS_r10 */
static int hf_lte_rrc_pUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10_n1PUCCH_AN_CS_r10_setup;  /* T_pUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10_n1PUCCH_AN_CS_r10_setup */
static int hf_lte_rrc_n1PUCCH_AN_CS_List_r10;     /* SEQUENCE_SIZE_1_2_OF_N1PUCCH_AN_CS_r10 */
static int hf_lte_rrc_n1PUCCH_AN_CS_List_r10_item;  /* N1PUCCH_AN_CS_r10 */
static int hf_lte_rrc_twoAntennaPortActivatedPUCCH_Format1a1b_r10;  /* T_twoAntennaPortActivatedPUCCH_Format1a1b_r10 */
static int hf_lte_rrc_simultaneousPUCCH_PUSCH_r10;  /* T_simultaneousPUCCH_PUSCH_r10 */
static int hf_lte_rrc_n1PUCCH_AN_RepP1_r10;       /* INTEGER_0_2047 */
static int hf_lte_rrc_n1PUCCH_AN_CS_v1130;        /* T_n1PUCCH_AN_CS_v1130 */
static int hf_lte_rrc_pUCCH_ConfigDedicated_v1130_n1PUCCH_AN_CS_v1130_setup;  /* T_pUCCH_ConfigDedicated_v1130_n1PUCCH_AN_CS_v1130_setup */
static int hf_lte_rrc_n1PUCCH_AN_CS_ListP1_r11;   /* T_n1PUCCH_AN_CS_ListP1_r11 */
static int hf_lte_rrc_n1PUCCH_AN_CS_ListP1_r11_item;  /* INTEGER_0_2047 */
static int hf_lte_rrc_nPUCCH_Param_r11;           /* T_nPUCCH_Param_r11 */
static int hf_lte_rrc_pUCCH_ConfigDedicated_v1130_nPUCCH_Param_r11_setup;  /* T_pUCCH_ConfigDedicated_v1130_nPUCCH_Param_r11_setup */
static int hf_lte_rrc_nPUCCH_Identity_r11;        /* INTEGER_0_503 */
static int hf_lte_rrc_n1PUCCH_AN_r11;             /* INTEGER_0_2047 */
static int hf_lte_rrc_nkaPUCCH_Param_r12;         /* T_nkaPUCCH_Param_r12 */
static int hf_lte_rrc_pUCCH_ConfigDedicated_v1250_nkaPUCCH_Param_r12_setup;  /* T_pUCCH_ConfigDedicated_v1250_nkaPUCCH_Param_r12_setup */
static int hf_lte_rrc_nkaPUCCH_AN_r12;            /* INTEGER_0_2047 */
static int hf_lte_rrc_ackNackRepetition_r13;      /* T_ackNackRepetition_r13 */
static int hf_lte_rrc_pUCCH_ConfigDedicated_r13_ackNackRepetition_r13_setup;  /* T_pUCCH_ConfigDedicated_r13_ackNackRepetition_r13_setup */
static int hf_lte_rrc_repetitionFactor_r13;       /* T_repetitionFactor_r13 */
static int hf_lte_rrc_n1PUCCH_AN_Rep_r13;         /* INTEGER_0_2047 */
static int hf_lte_rrc_tdd_AckNackFeedbackMode_r13;  /* T_tdd_AckNackFeedbackMode_r13 */
static int hf_lte_rrc_pucch_Format_r13;           /* T_pucch_Format_r13 */
static int hf_lte_rrc_format3_r13;                /* T_format3_r13 */
static int hf_lte_rrc_n3PUCCH_AN_List_r13;        /* T_n3PUCCH_AN_List_r13 */
static int hf_lte_rrc_n3PUCCH_AN_List_r13_item;   /* INTEGER_0_549 */
static int hf_lte_rrc_twoAntennaPortActivatedPUCCH_Format3_r13;  /* T_twoAntennaPortActivatedPUCCH_Format3_r13 */
static int hf_lte_rrc_pUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_setup;  /* T_pUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_setup */
static int hf_lte_rrc_n3PUCCH_AN_ListP1_r13;      /* T_n3PUCCH_AN_ListP1_r13 */
static int hf_lte_rrc_n3PUCCH_AN_ListP1_r13_item;  /* INTEGER_0_549 */
static int hf_lte_rrc_channelSelection_r13;       /* T_channelSelection_r13 */
static int hf_lte_rrc_n1PUCCH_AN_CS_r13;          /* T_n1PUCCH_AN_CS_r13 */
static int hf_lte_rrc_pUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13_n1PUCCH_AN_CS_r13_setup;  /* T_pUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13_n1PUCCH_AN_CS_r13_setup */
static int hf_lte_rrc_n1PUCCH_AN_CS_List_r13;     /* N1PUCCH_AN_CS_List_r13 */
static int hf_lte_rrc_n1PUCCH_AN_CS_List_r13_item;  /* N1PUCCH_AN_CS_r10 */
static int hf_lte_rrc_dummy1;                     /* T_dummy1 */
static int hf_lte_rrc_dummy1_item;                /* INTEGER_0_2047 */
static int hf_lte_rrc_format4_r13;                /* T_format4_r13 */
static int hf_lte_rrc_format4_resourceConfiguration_r13;  /* SEQUENCE_SIZE_4_OF_Format4_resource_r13 */
static int hf_lte_rrc_format4_resourceConfiguration_r13_item;  /* Format4_resource_r13 */
static int hf_lte_rrc_format4_MultiCSI_resourceConfiguration_r13;  /* SEQUENCE_SIZE_1_2_OF_Format4_resource_r13 */
static int hf_lte_rrc_format4_MultiCSI_resourceConfiguration_r13_item;  /* Format4_resource_r13 */
static int hf_lte_rrc_format5_r13;                /* T_format5_r13 */
static int hf_lte_rrc_format5_resourceConfiguration_r13;  /* SEQUENCE_SIZE_4_OF_Format5_resource_r13 */
static int hf_lte_rrc_format5_resourceConfiguration_r13_item;  /* Format5_resource_r13 */
static int hf_lte_rrc_format5_MultiCSI_resourceConfiguration_r13;  /* Format5_resource_r13 */
static int hf_lte_rrc_twoAntennaPortActivatedPUCCH_Format1a1b_r13;  /* T_twoAntennaPortActivatedPUCCH_Format1a1b_r13 */
static int hf_lte_rrc_simultaneousPUCCH_PUSCH_r13;  /* T_simultaneousPUCCH_PUSCH_r13 */
static int hf_lte_rrc_n1PUCCH_AN_RepP1_r13;       /* INTEGER_0_2047 */
static int hf_lte_rrc_nPUCCH_Param_r13;           /* T_nPUCCH_Param_r13 */
static int hf_lte_rrc_pUCCH_ConfigDedicated_r13_nPUCCH_Param_r13_setup;  /* T_pUCCH_ConfigDedicated_r13_nPUCCH_Param_r13_setup */
static int hf_lte_rrc_nPUCCH_Identity_r13;        /* INTEGER_0_503 */
static int hf_lte_rrc_n1PUCCH_AN_r13;             /* INTEGER_0_2047 */
static int hf_lte_rrc_nkaPUCCH_Param_r13;         /* T_nkaPUCCH_Param_r13 */
static int hf_lte_rrc_pUCCH_ConfigDedicated_r13_nkaPUCCH_Param_r13_setup;  /* T_pUCCH_ConfigDedicated_r13_nkaPUCCH_Param_r13_setup */
static int hf_lte_rrc_nkaPUCCH_AN_r13;            /* INTEGER_0_2047 */
static int hf_lte_rrc_spatialBundlingPUCCH_r13;   /* BOOLEAN */
static int hf_lte_rrc_spatialBundlingPUSCH_r13;   /* BOOLEAN */
static int hf_lte_rrc_harq_TimingTDD_r13;         /* BOOLEAN */
static int hf_lte_rrc_codebooksizeDetermination_r13;  /* T_codebooksizeDetermination_r13 */
static int hf_lte_rrc_maximumPayloadCoderate_r13;  /* INTEGER_0_7 */
static int hf_lte_rrc_pucch_NumRepetitionCE_r13;  /* T_pucch_NumRepetitionCE_r13 */
static int hf_lte_rrc_pUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup;  /* T_pUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup */
static int hf_lte_rrc_modeA;                      /* T_modeA */
static int hf_lte_rrc_pucch_NumRepetitionCE_format1_r13;  /* T_pucch_NumRepetitionCE_format1_r13 */
static int hf_lte_rrc_pucch_NumRepetitionCE_format2_r13;  /* T_pucch_NumRepetitionCE_format2_r13 */
static int hf_lte_rrc_modeB;                      /* T_modeB */
static int hf_lte_rrc_pucch_NumRepetitionCE_format1_r13_01;  /* T_pucch_NumRepetitionCE_format1_r13_01 */
static int hf_lte_rrc_pucch_NumRepetitionCE_format2_r13_01;  /* T_pucch_NumRepetitionCE_format2_r13_01 */
static int hf_lte_rrc_pucch_Format_v1370;         /* T_pucch_Format_v1370 */
static int hf_lte_rrc_pUCCH_ConfigDedicated_v1370_pucch_Format_v1370_setup;  /* PUCCH_Format3_Conf_r13 */
static int hf_lte_rrc_channelSelection_v13c0;     /* T_channelSelection_v13c0 */
static int hf_lte_rrc_n1PUCCH_AN_CS_v13c0;        /* T_n1PUCCH_AN_CS_v13c0 */
static int hf_lte_rrc_pUCCH_ConfigDedicated_v13c0_channelSelection_v13c0_n1PUCCH_AN_CS_v13c0_setup;  /* T_pUCCH_ConfigDedicated_v13c0_channelSelection_v13c0_n1PUCCH_AN_CS_v13c0_setup */
static int hf_lte_rrc_n1PUCCH_AN_CS_ListP1_v13c0;  /* T_n1PUCCH_AN_CS_ListP1_v13c0 */
static int hf_lte_rrc_n1PUCCH_AN_CS_ListP1_v13c0_item;  /* INTEGER_0_2047 */
static int hf_lte_rrc_n3PUCCH_AN_List_r13_01;     /* T_n3PUCCH_AN_List_r13_01 */
static int hf_lte_rrc_twoAntennaPortActivatedPUCCH_Format3_r13_01;  /* T_twoAntennaPortActivatedPUCCH_Format3_r13_01 */
static int hf_lte_rrc_pUCCH_Format3_Conf_r13_twoAntennaPortActivatedPUCCH_Format3_r13_setup;  /* T_pUCCH_Format3_Conf_r13_twoAntennaPortActivatedPUCCH_Format3_r13_setup */
static int hf_lte_rrc_n3PUCCH_AN_ListP1_r13_01;   /* T_n3PUCCH_AN_ListP1_r13_01 */
static int hf_lte_rrc_pucch_NumRepetitionCE_format1_r14;  /* T_pucch_NumRepetitionCE_format1_r14 */
static int hf_lte_rrc_n1PUCCH_AN_SPT_r15;         /* INTEGER_0_2047 */
static int hf_lte_rrc_codebooksizeDeterminationSTTI_r15;  /* T_codebooksizeDeterminationSTTI_r15 */
static int hf_lte_rrc_startingPRB_format4_r13;    /* INTEGER_0_109 */
static int hf_lte_rrc_numberOfPRB_format4_r13;    /* INTEGER_0_7 */
static int hf_lte_rrc_startingPRB_format5_r13;    /* INTEGER_0_109 */
static int hf_lte_rrc_cdm_index_format5_r13;      /* INTEGER_0_1 */
static int hf_lte_rrc_N1PUCCH_AN_CS_r10_item;     /* INTEGER_0_2047 */
static int hf_lte_rrc_N1PUCCH_AN_InfoList_r13_item;  /* INTEGER_0_2047 */
static int hf_lte_rrc_pucch_TxDuration_r17_01;    /* T_pucch_TxDuration_r17_01 */
static int hf_lte_rrc_pur_ImplicitReleaseAfter_r16;  /* T_pur_ImplicitReleaseAfter_r16 */
static int hf_lte_rrc_pur_StartTimeParameters_r16;  /* T_pur_StartTimeParameters_r16 */
static int hf_lte_rrc_periodicityAndOffset_r16;   /* PUR_PeriodicityAndOffset_r16 */
static int hf_lte_rrc_startSFN_r16;               /* INTEGER_0_1023 */
static int hf_lte_rrc_startSubFrame_r16;          /* INTEGER_0_9 */
static int hf_lte_rrc_hsfn_LSB_Info_r16;          /* BIT_STRING_SIZE_1 */
static int hf_lte_rrc_pur_NumOccasions_r16;       /* T_pur_NumOccasions_r16 */
static int hf_lte_rrc_pur_RNTI_r16;               /* C_RNTI */
static int hf_lte_rrc_pur_TimeAlignmentTimer_r16;  /* INTEGER_1_8 */
static int hf_lte_rrc_pur_RSRP_ChangeThreshold_r16;  /* T_pur_RSRP_ChangeThreshold_r16 */
static int hf_lte_rrc_pUR_Config_r16_pur_RSRP_ChangeThreshold_r16_setup;  /* PUR_RSRP_ChangeThreshold_r16 */
static int hf_lte_rrc_pur_ResponseWindowTimer_r16;  /* T_pur_ResponseWindowTimer_r16 */
static int hf_lte_rrc_pur_MPDCCH_Config_r16;      /* PUR_MPDCCH_Config_r16 */
static int hf_lte_rrc_pur_PDSCH_FreqHopping_r16;  /* BOOLEAN */
static int hf_lte_rrc_pur_PUCCH_Config_r16;       /* PUR_PUCCH_Config_r16 */
static int hf_lte_rrc_pur_PUSCH_Config_r16;       /* PUR_PUSCH_Config_r16 */
static int hf_lte_rrc_pur_PDSCH_maxTBS_r17;       /* BOOLEAN */
static int hf_lte_rrc_mpdcch_FreqHopping_r16;     /* BOOLEAN */
static int hf_lte_rrc_mpdcch_Narrowband_r16;      /* INTEGER_1_maxAvailNarrowBands_r13 */
static int hf_lte_rrc_mpdcch_PRB_PairsConfig_r16;  /* T_mpdcch_PRB_PairsConfig_r16 */
static int hf_lte_rrc_numberPRB_Pairs_r16;        /* T_numberPRB_Pairs_r16 */
static int hf_lte_rrc_resourceBlockAssignment_r16;  /* BIT_STRING_SIZE_4 */
static int hf_lte_rrc_mpdcch_NumRepetition_r16;   /* T_mpdcch_NumRepetition_r16 */
static int hf_lte_rrc_mpdcch_StartSF_UESS_r16;    /* T_mpdcch_StartSF_UESS_r16 */
static int hf_lte_rrc_fdd;                        /* T_fdd */
static int hf_lte_rrc_tdd;                        /* T_tdd */
static int hf_lte_rrc_mpdcch_Offset_PUR_SS_r16;   /* T_mpdcch_Offset_PUR_SS_r16 */
static int hf_lte_rrc_n1PUCCH_AN_r16;             /* INTEGER_0_2047 */
static int hf_lte_rrc_pucch_NumRepetitionCE_Format1_r16;  /* T_pucch_NumRepetitionCE_Format1_r16 */
static int hf_lte_rrc_pur_GrantInfo_r16;          /* T_pur_GrantInfo_r16 */
static int hf_lte_rrc_ce_ModeA;                   /* T_ce_ModeA */
static int hf_lte_rrc_pUR_PUSCH_Config_r16_pur_GrantInfo_r16_ce_ModeA_numRUs_r16;  /* BIT_STRING_SIZE_2 */
static int hf_lte_rrc_prb_AllocationInfo_r16;     /* BIT_STRING_SIZE_10 */
static int hf_lte_rrc_mcs_r16;                    /* BIT_STRING_SIZE_4 */
static int hf_lte_rrc_numRepetitions_r16;         /* BIT_STRING_SIZE_3 */
static int hf_lte_rrc_ce_ModeB;                   /* T_ce_ModeB */
static int hf_lte_rrc_subPRB_Allocation_r16;      /* BOOLEAN */
static int hf_lte_rrc_numRUs_r16;                 /* BOOLEAN */
static int hf_lte_rrc_prb_AllocationInfo_r16_01;  /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_pur_PUSCH_FreqHopping_r16;  /* BOOLEAN */
static int hf_lte_rrc_p0_UE_PUSCH_r16;            /* INTEGER_M8_7 */
static int hf_lte_rrc_alpha_r16;                  /* Alpha_r12 */
static int hf_lte_rrc_pusch_CyclicShift_r16;      /* T_pusch_CyclicShift_r16 */
static int hf_lte_rrc_pusch_NB_MaxTBS_r16;        /* BOOLEAN */
static int hf_lte_rrc_locationCE_ModeB_r16;       /* INTEGER_0_5 */
static int hf_lte_rrc_increaseThresh_r16;         /* RSRP_ChangeThresh_r16 */
static int hf_lte_rrc_decreaseThresh_r16;         /* RSRP_ChangeThresh_r16 */
static int hf_lte_rrc_periodicity8;               /* INTEGER_1_7 */
static int hf_lte_rrc_periodicity16;              /* INTEGER_1_15 */
static int hf_lte_rrc_periodicity32;              /* INTEGER_1_31 */
static int hf_lte_rrc_periodicity64;              /* INTEGER_1_63 */
static int hf_lte_rrc_periodicity128;             /* INTEGER_1_127 */
static int hf_lte_rrc_periodicity256;             /* INTEGER_1_255 */
static int hf_lte_rrc_periodicity512;             /* INTEGER_1_511 */
static int hf_lte_rrc_periodicity1024;            /* INTEGER_1_1023 */
static int hf_lte_rrc_periodicity2048;            /* INTEGER_1_2047 */
static int hf_lte_rrc_periodicity4096;            /* INTEGER_1_4095 */
static int hf_lte_rrc_periodicity8192;            /* INTEGER_1_8191 */
static int hf_lte_rrc_pusch_ConfigBasic;          /* T_pusch_ConfigBasic */
static int hf_lte_rrc_n_SB;                       /* INTEGER_1_4 */
static int hf_lte_rrc_hoppingMode;                /* T_hoppingMode */
static int hf_lte_rrc_pusch_HoppingOffset;        /* INTEGER_0_98 */
static int hf_lte_rrc_enable64QAM;                /* BOOLEAN */
static int hf_lte_rrc_ul_ReferenceSignalsPUSCH;   /* UL_ReferenceSignalsPUSCH */
static int hf_lte_rrc_enable64QAM_v1270;          /* T_enable64QAM_v1270 */
static int hf_lte_rrc_pusch_maxNumRepetitionCEmodeA_r13;  /* T_pusch_maxNumRepetitionCEmodeA_r13 */
static int hf_lte_rrc_pusch_maxNumRepetitionCEmodeB_r13;  /* T_pusch_maxNumRepetitionCEmodeB_r13 */
static int hf_lte_rrc_pusch_HoppingOffset_v1310;  /* INTEGER_1_maxAvailNarrowBands_r13 */
static int hf_lte_rrc_betaOffset_ACK_Index;       /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_RI_Index;        /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_CQI_Index;       /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffsetMC_r10;           /* T_betaOffsetMC_r10 */
static int hf_lte_rrc_betaOffset_ACK_Index_MC_r10;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_RI_Index_MC_r10;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_CQI_Index_MC_r10;  /* INTEGER_0_15 */
static int hf_lte_rrc_groupHoppingDisabled_r10;   /* T_groupHoppingDisabled_r10 */
static int hf_lte_rrc_dmrs_WithOCC_Activated_r10;  /* T_dmrs_WithOCC_Activated_r10 */
static int hf_lte_rrc_pusch_DMRS_r11;             /* T_pusch_DMRS_r11 */
static int hf_lte_rrc_pUSCH_ConfigDedicated_v1130_pusch_DMRS_r11_setup;  /* T_pUSCH_ConfigDedicated_v1130_pusch_DMRS_r11_setup */
static int hf_lte_rrc_nPUSCH_Identity_r11;        /* INTEGER_0_509 */
static int hf_lte_rrc_nDMRS_CSH_Identity_r11;     /* INTEGER_0_509 */
static int hf_lte_rrc_uciOnPUSCH;                 /* T_uciOnPUSCH */
static int hf_lte_rrc_pUSCH_ConfigDedicated_v1250_uciOnPUSCH_setup;  /* T_pUSCH_ConfigDedicated_v1250_uciOnPUSCH_setup */
static int hf_lte_rrc_betaOffset_ACK_Index_SubframeSet2_r12;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_RI_Index_SubframeSet2_r12;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_CQI_Index_SubframeSet2_r12;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffsetMC_r12;           /* T_betaOffsetMC_r12 */
static int hf_lte_rrc_betaOffset_ACK_Index_MC_SubframeSet2_r12;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_RI_Index_MC_SubframeSet2_r12;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_CQI_Index_MC_SubframeSet2_r12;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_ACK_Index_r13;   /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset2_ACK_Index_r13;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_RI_Index_r13;    /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_CQI_Index_r13;   /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffsetMC_r13;           /* T_betaOffsetMC_r13 */
static int hf_lte_rrc_betaOffset_ACK_Index_MC_r13;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset2_ACK_Index_MC_r13;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_RI_Index_MC_r13;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_CQI_Index_MC_r13;  /* INTEGER_0_15 */
static int hf_lte_rrc_groupHoppingDisabled_r13;   /* T_groupHoppingDisabled_r13 */
static int hf_lte_rrc_dmrs_WithOCC_Activated_r13;  /* T_dmrs_WithOCC_Activated_r13 */
static int hf_lte_rrc_pusch_DMRS_r11_01;          /* T_pusch_DMRS_r11_01 */
static int hf_lte_rrc_pUSCH_ConfigDedicated_r13_pusch_DMRS_r11_setup;  /* T_pUSCH_ConfigDedicated_r13_pusch_DMRS_r11_setup */
static int hf_lte_rrc_nPUSCH_Identity_r13;        /* INTEGER_0_509 */
static int hf_lte_rrc_nDMRS_CSH_Identity_r13;     /* INTEGER_0_509 */
static int hf_lte_rrc_uciOnPUSCH_01;              /* T_uciOnPUSCH_01 */
static int hf_lte_rrc_pUSCH_ConfigDedicated_r13_uciOnPUSCH_setup;  /* T_pUSCH_ConfigDedicated_r13_uciOnPUSCH_setup */
static int hf_lte_rrc_betaOffset_ACK_Index_SubframeSet2_r13;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset2_ACK_Index_SubframeSet2_r13;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_RI_Index_SubframeSet2_r13;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_CQI_Index_SubframeSet2_r13;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffsetMC_r12_01;        /* T_betaOffsetMC_r12_01 */
static int hf_lte_rrc_betaOffset_ACK_Index_MC_SubframeSet2_r13;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset2_ACK_Index_MC_SubframeSet2_r13;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_RI_Index_MC_SubframeSet2_r13;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset_CQI_Index_MC_SubframeSet2_r13;  /* INTEGER_0_15 */
static int hf_lte_rrc_pusch_HoppingConfig_r13;    /* T_pusch_HoppingConfig_r13 */
static int hf_lte_rrc_ce_PUSCH_NB_MaxTBS_r14;     /* T_ce_PUSCH_NB_MaxTBS_r14 */
static int hf_lte_rrc_ce_PUSCH_MaxBandwidth_r14;  /* T_ce_PUSCH_MaxBandwidth_r14 */
static int hf_lte_rrc_tdd_PUSCH_UpPTS_r14;        /* TDD_PUSCH_UpPTS_r14 */
static int hf_lte_rrc_ul_DMRS_IFDMA_r14;          /* BOOLEAN */
static int hf_lte_rrc_enable256QAM_r14;           /* Enable256QAM_r14 */
static int hf_lte_rrc_ce_PUSCH_FlexibleStartPRB_AllocConfig_r15;  /* T_ce_PUSCH_FlexibleStartPRB_AllocConfig_r15 */
static int hf_lte_rrc_pUSCH_ConfigDedicated_v1530_ce_PUSCH_FlexibleStartPRB_AllocConfig_r15_setup;  /* T_pUSCH_ConfigDedicated_v1530_ce_PUSCH_FlexibleStartPRB_AllocConfig_r15_setup */
static int hf_lte_rrc_offsetCE_ModeB_r15;         /* INTEGER_M1_3 */
static int hf_lte_rrc_ce_PUSCH_SubPRB_Config_r15;  /* T_ce_PUSCH_SubPRB_Config_r15 */
static int hf_lte_rrc_pUSCH_ConfigDedicated_v1530_ce_PUSCH_SubPRB_Config_r15_setup;  /* T_pUSCH_ConfigDedicated_v1530_ce_PUSCH_SubPRB_Config_r15_setup */
static int hf_lte_rrc_locationCE_ModeB_r15;       /* INTEGER_0_5 */
static int hf_lte_rrc_sixToneCyclicShift_r15;     /* INTEGER_0_3 */
static int hf_lte_rrc_threeToneCyclicShift_r15;   /* INTEGER_0_2 */
static int hf_lte_rrc_ce_PUSCH_MultiTB_Config_r16;  /* T_ce_PUSCH_MultiTB_Config_r16 */
static int hf_lte_rrc_pUSCH_ConfigDedicated_v1610_ce_PUSCH_MultiTB_Config_r16_setup;  /* CE_PUSCH_MultiTB_Config_r16 */
static int hf_lte_rrc_uplinkHARQ_Mode_r18;        /* T_uplinkHARQ_Mode_r18 */
static int hf_lte_rrc_setup_09;                   /* UplinkHARQ_Mode_r18 */
static int hf_lte_rrc_groupHoppingDisabled_r10_01;  /* T_groupHoppingDisabled_r10_01 */
static int hf_lte_rrc_dmrs_WithOCC_Activated_r10_01;  /* T_dmrs_WithOCC_Activated_r10_01 */
static int hf_lte_rrc_uci_OnPUSCH_r15;            /* T_uci_OnPUSCH_r15 */
static int hf_lte_rrc_pUSCH_ConfigDedicatedScell_v1530_uci_OnPUSCH_r15_setup;  /* T_pUSCH_ConfigDedicatedScell_v1530_uci_OnPUSCH_r15_setup */
static int hf_lte_rrc_betaOffsetAUL_r15;          /* INTEGER_0_15 */
static int hf_lte_rrc_tDD_PUSCH_UpPTS_r14_setup;  /* T_tDD_PUSCH_UpPTS_r14_setup */
static int hf_lte_rrc_symPUSCH_UpPTS_r14;         /* T_symPUSCH_UpPTS_r14 */
static int hf_lte_rrc_dmrs_LessUpPTS_Config_r14;  /* T_dmrs_LessUpPTS_Config_r14 */
static int hf_lte_rrc_interleaving_r16_01;        /* T_interleaving_r16_01 */
static int hf_lte_rrc_pusch_TxDuration_r17_01;    /* T_pusch_TxDuration_r17_01 */
static int hf_lte_rrc_enable256QAM_r14_setup;     /* T_enable256QAM_r14_setup */
static int hf_lte_rrc_tpc_SubframeSet_Configured_r14;  /* T_tpc_SubframeSet_Configured_r14 */
static int hf_lte_rrc_subframeSet1_DCI_Format0_r14;  /* BOOLEAN */
static int hf_lte_rrc_subframeSet1_DCI_Format4_r14;  /* BOOLEAN */
static int hf_lte_rrc_subframeSet2_DCI_Format0_r14;  /* BOOLEAN */
static int hf_lte_rrc_subframeSet2_DCI_Format4_r14;  /* BOOLEAN */
static int hf_lte_rrc_tpc_SubframeSet_NotConfigured_r14;  /* T_tpc_SubframeSet_NotConfigured_r14 */
static int hf_lte_rrc_dci_Format0_r14;            /* BOOLEAN */
static int hf_lte_rrc_dci_Format4_r14;            /* BOOLEAN */
static int hf_lte_rrc_pUSCH_EnhancementsConfig_r14_setup;  /* T_pUSCH_EnhancementsConfig_r14_setup */
static int hf_lte_rrc_pusch_HoppingOffsetPUSCH_Enh_r14;  /* INTEGER_1_100 */
static int hf_lte_rrc_interval_ULHoppingPUSCH_Enh_r14;  /* T_interval_ULHoppingPUSCH_Enh_r14 */
static int hf_lte_rrc_interval_FDD_PUSCH_Enh_r14;  /* T_interval_FDD_PUSCH_Enh_r14 */
static int hf_lte_rrc_interval_TDD_PUSCH_Enh_r14;  /* T_interval_TDD_PUSCH_Enh_r14 */
static int hf_lte_rrc_groupHoppingEnabled;        /* BOOLEAN */
static int hf_lte_rrc_groupAssignmentPUSCH;       /* INTEGER_0_29 */
static int hf_lte_rrc_sequenceHoppingEnabled;     /* BOOLEAN */
static int hf_lte_rrc_cyclicShift;                /* INTEGER_0_7 */
static int hf_lte_rrc_preambleInfo;               /* T_preambleInfo */
static int hf_lte_rrc_numberOfRA_Preambles;       /* T_numberOfRA_Preambles */
static int hf_lte_rrc_preamblesGroupAConfig;      /* T_preamblesGroupAConfig */
static int hf_lte_rrc_sizeOfRA_PreamblesGroupA;   /* T_sizeOfRA_PreamblesGroupA */
static int hf_lte_rrc_messageSizeGroupA;          /* T_messageSizeGroupA */
static int hf_lte_rrc_messagePowerOffsetGroupB;   /* T_messagePowerOffsetGroupB */
static int hf_lte_rrc_powerRampingParameters;     /* PowerRampingParameters */
static int hf_lte_rrc_ra_SupervisionInfo;         /* T_ra_SupervisionInfo */
static int hf_lte_rrc_preambleTransMax;           /* PreambleTransMax */
static int hf_lte_rrc_ra_ResponseWindowSize;      /* T_ra_ResponseWindowSize */
static int hf_lte_rrc_mac_ContentionResolutionTimer;  /* T_mac_ContentionResolutionTimer */
static int hf_lte_rrc_maxHARQ_Msg3Tx;             /* INTEGER_1_8 */
static int hf_lte_rrc_preambleTransMax_CE_r13;    /* PreambleTransMax */
static int hf_lte_rrc_rach_CE_LevelInfoList_r13;  /* RACH_CE_LevelInfoList_r13 */
static int hf_lte_rrc_edt_SmallTBS_Subset_r15;    /* T_edt_SmallTBS_Subset_r15 */
static int hf_lte_rrc_txFailParams_r12;           /* T_txFailParams_r12 */
static int hf_lte_rrc_connEstFailCount_r12;       /* T_connEstFailCount_r12 */
static int hf_lte_rrc_connEstFailOffsetValidity_r12;  /* T_connEstFailOffsetValidity_r12 */
static int hf_lte_rrc_connEstFailOffset_r12;      /* INTEGER_0_15 */
static int hf_lte_rrc_powerRampingParameters_r11;  /* PowerRampingParameters */
static int hf_lte_rrc_ra_SupervisionInfo_r11;     /* T_ra_SupervisionInfo_r11 */
static int hf_lte_rrc_preambleTransMax_r11;       /* PreambleTransMax */
static int hf_lte_rrc_RACH_CE_LevelInfoList_r13_item;  /* RACH_CE_LevelInfo_r13 */
static int hf_lte_rrc_preambleMappingInfo_r13;    /* T_preambleMappingInfo_r13 */
static int hf_lte_rrc_firstPreamble_r13;          /* INTEGER_0_63 */
static int hf_lte_rrc_lastPreamble_r13;           /* INTEGER_0_63 */
static int hf_lte_rrc_ra_ResponseWindowSize_r13;  /* T_ra_ResponseWindowSize_r13 */
static int hf_lte_rrc_mac_ContentionResolutionTimer_r13;  /* T_mac_ContentionResolutionTimer_r13 */
static int hf_lte_rrc_rar_HoppingConfig_r13;      /* T_rar_HoppingConfig_r13 */
static int hf_lte_rrc_edt_Parameters_r15;         /* T_edt_Parameters_r15 */
static int hf_lte_rrc_edt_LastPreamble_r15;       /* INTEGER_0_63 */
static int hf_lte_rrc_edt_SmallTBS_Enabled_r15;   /* BOOLEAN */
static int hf_lte_rrc_edt_TBS_r15;                /* T_edt_TBS_r15 */
static int hf_lte_rrc_mac_ContentionResolutionTimer_r15;  /* T_mac_ContentionResolutionTimer_r15 */
static int hf_lte_rrc_powerRampingStep;           /* T_powerRampingStep */
static int hf_lte_rrc_preambleInitialReceivedTargetPower;  /* T_preambleInitialReceivedTargetPower */
static int hf_lte_rrc_ra_PreambleIndex;           /* INTEGER_0_63 */
static int hf_lte_rrc_ra_PRACH_MaskIndex;         /* INTEGER_0_15 */
static int hf_lte_rrc_rach_ConfigCommon;          /* RACH_ConfigCommon */
static int hf_lte_rrc_bcch_Config;                /* BCCH_Config */
static int hf_lte_rrc_pcch_Config;                /* PCCH_Config */
static int hf_lte_rrc_prach_Config;               /* PRACH_ConfigSIB */
static int hf_lte_rrc_pdsch_ConfigCommon;         /* PDSCH_ConfigCommon */
static int hf_lte_rrc_pusch_ConfigCommon;         /* PUSCH_ConfigCommon */
static int hf_lte_rrc_pucch_ConfigCommon;         /* PUCCH_ConfigCommon */
static int hf_lte_rrc_soundingRS_UL_ConfigCommon;  /* SoundingRS_UL_ConfigCommon */
static int hf_lte_rrc_uplinkPowerControlCommon;   /* UplinkPowerControlCommon */
static int hf_lte_rrc_ul_CyclicPrefixLength;      /* UL_CyclicPrefixLength */
static int hf_lte_rrc_uplinkPowerControlCommon_v1020;  /* UplinkPowerControlCommon_v1020 */
static int hf_lte_rrc_rach_ConfigCommon_v1250;    /* RACH_ConfigCommon_v1250 */
static int hf_lte_rrc_pusch_ConfigCommon_v1270;   /* PUSCH_ConfigCommon_v1270 */
static int hf_lte_rrc_bcch_Config_v1310;          /* BCCH_Config_v1310 */
static int hf_lte_rrc_pcch_Config_v1310;          /* PCCH_Config_v1310 */
static int hf_lte_rrc_freqHoppingParameters_r13;  /* FreqHoppingParameters_r13 */
static int hf_lte_rrc_pdsch_ConfigCommon_v1310;   /* PDSCH_ConfigCommon_v1310 */
static int hf_lte_rrc_pusch_ConfigCommon_v1310;   /* PUSCH_ConfigCommon_v1310 */
static int hf_lte_rrc_prach_ConfigCommon_v1310;   /* PRACH_ConfigSIB_v1310 */
static int hf_lte_rrc_pucch_ConfigCommon_v1310;   /* PUCCH_ConfigCommon_v1310 */
static int hf_lte_rrc_highSpeedConfig_r14;        /* HighSpeedConfig_r14 */
static int hf_lte_rrc_prach_Config_v1430;         /* PRACH_Config_v1430 */
static int hf_lte_rrc_pucch_ConfigCommon_v1430;   /* PUCCH_ConfigCommon_v1430 */
static int hf_lte_rrc_prach_Config_v1530;         /* PRACH_ConfigSIB_v1530 */
static int hf_lte_rrc_ce_RSS_Config_r15;          /* RSS_Config_r15 */
static int hf_lte_rrc_wus_Config_r15;             /* WUS_Config_r15 */
static int hf_lte_rrc_highSpeedConfig_v1530;      /* HighSpeedConfig_v1530 */
static int hf_lte_rrc_uplinkPowerControlCommon_v1540;  /* UplinkPowerControlCommon_v1530 */
static int hf_lte_rrc_wus_Config_v1560;           /* WUS_Config_v1560 */
static int hf_lte_rrc_wus_Config_v1610;           /* WUS_Config_v1610 */
static int hf_lte_rrc_highSpeedConfig_v1610;      /* HighSpeedConfig_v1610 */
static int hf_lte_rrc_crs_ChEstMPDCCH_ConfigCommon_r16;  /* CRS_ChEstMPDCCH_ConfigCommon_r16 */
static int hf_lte_rrc_gwus_Config_r16;            /* GWUS_Config_r16 */
static int hf_lte_rrc_uplinkPowerControlCommon_v1610;  /* UplinkPowerControlCommon_v1610 */
static int hf_lte_rrc_rss_MeasConfig_r16;         /* T_rss_MeasConfig_r16 */
static int hf_lte_rrc_rss_MeasNonNCL_r16;         /* T_rss_MeasNonNCL_r16 */
static int hf_lte_rrc_puncturedSubcarriersDL_r16;  /* BIT_STRING_SIZE_2 */
static int hf_lte_rrc_highSpeedInterRAT_NR_r16;   /* BOOLEAN */
static int hf_lte_rrc_pcch_Config_v1700;          /* PCCH_Config_v1700 */
static int hf_lte_rrc_ntn_ConfigCommon_r17;       /* T_ntn_ConfigCommon_r17 */
static int hf_lte_rrc_ta_Report_r17;              /* T_ta_Report_r17 */
static int hf_lte_rrc_t318_r17;                   /* T_t318_r17 */
static int hf_lte_rrc_prach_TxDuration_r17_01;    /* PRACH_TxDuration_r17 */
static int hf_lte_rrc_pucch_TxDuration_r17_02;    /* PUCCH_TxDuration_r17 */
static int hf_lte_rrc_pusch_TxDuration_r17_02;    /* PUSCH_TxDuration_r17 */
static int hf_lte_rrc_prach_Config_01;            /* PRACH_Config */
static int hf_lte_rrc_prach_Config_v1310;         /* PRACH_Config_v1310 */
static int hf_lte_rrc_uplinkPowerControlCommon_v1310;  /* UplinkPowerControlCommon_v1310 */
static int hf_lte_rrc_uplinkPowerControlCommon_v1530;  /* UplinkPowerControlCommon_v1530 */
static int hf_lte_rrc_ntn_ConfigCommon_r17_01;    /* T_ntn_ConfigCommon_r17_01 */
static int hf_lte_rrc_ta_Report_r17_01;           /* T_ta_Report_r17_01 */
static int hf_lte_rrc_t318_r17_01;                /* T_t318_r17_01 */
static int hf_lte_rrc_basicFields_r12;            /* RadioResourceConfigCommonSCell_r10 */
static int hf_lte_rrc_pucch_ConfigCommon_r12;     /* PUCCH_ConfigCommon */
static int hf_lte_rrc_rach_ConfigCommon_r12;      /* RACH_ConfigCommon */
static int hf_lte_rrc_uplinkPowerControlCommonPSCell_r12;  /* UplinkPowerControlCommonPSCell_r12 */
static int hf_lte_rrc_uplinkPowerControlCommonPSCell_v1310;  /* UplinkPowerControlCommon_v1310 */
static int hf_lte_rrc_uplinkPowerControlCommonPSCell_v1530;  /* UplinkPowerControlCommon_v1530 */
static int hf_lte_rrc_basicFields_v12f0;          /* RadioResourceConfigCommonSCell_v10l0 */
static int hf_lte_rrc_basicFields_v1440;          /* RadioResourceConfigCommonSCell_v1440 */
static int hf_lte_rrc_nonUL_Configuration_r10_01;  /* T_nonUL_Configuration_r10_01 */
static int hf_lte_rrc_dl_Bandwidth_r10;           /* T_dl_Bandwidth_r10 */
static int hf_lte_rrc_antennaInfoCommon_r10;      /* AntennaInfoCommon */
static int hf_lte_rrc_mbsfn_SubframeConfigList_r10;  /* MBSFN_SubframeConfigList */
static int hf_lte_rrc_phich_Config_r10;           /* PHICH_Config */
static int hf_lte_rrc_pdsch_ConfigCommon_r10;     /* PDSCH_ConfigCommon */
static int hf_lte_rrc_tdd_Config_r10;             /* TDD_Config */
static int hf_lte_rrc_ul_Configuration_r10_01;    /* T_ul_Configuration_r10_01 */
static int hf_lte_rrc_ul_FreqInfo_r10;            /* T_ul_FreqInfo_r10 */
static int hf_lte_rrc_ul_CarrierFreq_r10;         /* ARFCN_ValueEUTRA */
static int hf_lte_rrc_ul_Bandwidth_r10;           /* T_ul_Bandwidth_r10 */
static int hf_lte_rrc_additionalSpectrumEmissionSCell_r10;  /* AdditionalSpectrumEmission */
static int hf_lte_rrc_p_Max_r10;                  /* P_Max */
static int hf_lte_rrc_uplinkPowerControlCommonSCell_r10;  /* UplinkPowerControlCommonSCell_r10 */
static int hf_lte_rrc_soundingRS_UL_ConfigCommon_r10;  /* SoundingRS_UL_ConfigCommon */
static int hf_lte_rrc_ul_CyclicPrefixLength_r10;  /* UL_CyclicPrefixLength */
static int hf_lte_rrc_prach_ConfigSCell_r10;      /* PRACH_ConfigSCell_r10 */
static int hf_lte_rrc_pusch_ConfigCommon_r10;     /* PUSCH_ConfigCommon */
static int hf_lte_rrc_ul_CarrierFreq_v1090;       /* ARFCN_ValueEUTRA_v9e0 */
static int hf_lte_rrc_rach_ConfigCommonSCell_r11;  /* RACH_ConfigCommonSCell_r11 */
static int hf_lte_rrc_prach_ConfigSCell_r11;      /* PRACH_Config */
static int hf_lte_rrc_uplinkPowerControlCommonSCell_v1130;  /* UplinkPowerControlCommonSCell_v1130 */
static int hf_lte_rrc_pucch_ConfigCommon_r13;     /* PUCCH_ConfigCommon */
static int hf_lte_rrc_uplinkPowerControlCommonSCell_v1310;  /* UplinkPowerControlCommonSCell_v1310 */
static int hf_lte_rrc_highSpeedConfigSCell_r14;   /* HighSpeedConfigSCell_r14 */
static int hf_lte_rrc_ul_Configuration_r14;       /* T_ul_Configuration_r14 */
static int hf_lte_rrc_ul_FreqInfo_r14;            /* T_ul_FreqInfo_r14 */
static int hf_lte_rrc_ul_CarrierFreq_r14;         /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_ul_Bandwidth_r14;           /* T_ul_Bandwidth_r14 */
static int hf_lte_rrc_additionalSpectrumEmissionSCell_r14;  /* AdditionalSpectrumEmission */
static int hf_lte_rrc_p_Max_r14;                  /* P_Max */
static int hf_lte_rrc_soundingRS_UL_ConfigCommon_r14;  /* SoundingRS_UL_ConfigCommon */
static int hf_lte_rrc_ul_CyclicPrefixLength_r14;  /* UL_CyclicPrefixLength */
static int hf_lte_rrc_prach_ConfigSCell_r14;      /* PRACH_ConfigSCell_r10 */
static int hf_lte_rrc_uplinkPowerControlCommonPUSCH_LessCell_v1430;  /* UplinkPowerControlCommonPUSCH_LessCell_v1430 */
static int hf_lte_rrc_harq_ReferenceConfig_r14;   /* T_harq_ReferenceConfig_r14 */
static int hf_lte_rrc_soundingRS_FlexibleTiming_r14;  /* T_soundingRS_FlexibleTiming_r14 */
static int hf_lte_rrc_uplinkPowerControlCommonSCell_v1530;  /* UplinkPowerControlCommon_v1530 */
static int hf_lte_rrc_highSpeedEnhMeasFlagSCell_r16;  /* BOOLEAN */
static int hf_lte_rrc_ul_Configuration_v10l0;     /* T_ul_Configuration_v10l0 */
static int hf_lte_rrc_additionalSpectrumEmissionSCell_v10l0;  /* AdditionalSpectrumEmission_v10l0 */
static int hf_lte_rrc_ul_Configuration_v1440;     /* T_ul_Configuration_v1440 */
static int hf_lte_rrc_ul_FreqInfo_v1440;          /* T_ul_FreqInfo_v1440 */
static int hf_lte_rrc_additionalSpectrumEmissionSCell_v1440;  /* AdditionalSpectrumEmission_v10l0 */
static int hf_lte_rrc_modificationPeriodCoeff;    /* T_modificationPeriodCoeff */
static int hf_lte_rrc_modificationPeriodCoeff_v1310;  /* T_modificationPeriodCoeff_v1310 */
static int hf_lte_rrc_freqHoppingParameters_r13_dummy;  /* T_freqHoppingParameters_r13_dummy */
static int hf_lte_rrc_dummy2_01;                  /* T_dummy2_01 */
static int hf_lte_rrc_interval_FDD_r13_02;        /* T_interval_FDD_r13_02 */
static int hf_lte_rrc_interval_TDD_r13_02;        /* T_interval_TDD_r13_02 */
static int hf_lte_rrc_dummy3;                     /* T_dummy3 */
static int hf_lte_rrc_interval_FDD_r13_03;        /* T_interval_FDD_r13_03 */
static int hf_lte_rrc_interval_TDD_r13_03;        /* T_interval_TDD_r13_03 */
static int hf_lte_rrc_interval_ULHoppingConfigCommonModeA_r13;  /* T_interval_ULHoppingConfigCommonModeA_r13 */
static int hf_lte_rrc_interval_FDD_r13_04;        /* T_interval_FDD_r13_04 */
static int hf_lte_rrc_interval_TDD_r13_04;        /* T_interval_TDD_r13_04 */
static int hf_lte_rrc_interval_ULHoppingConfigCommonModeB_r13;  /* T_interval_ULHoppingConfigCommonModeB_r13 */
static int hf_lte_rrc_interval_FDD_r13_05;        /* T_interval_FDD_r13_05 */
static int hf_lte_rrc_interval_TDD_r13_05;        /* T_interval_TDD_r13_05 */
static int hf_lte_rrc_dummy4;                     /* INTEGER_1_maxAvailNarrowBands_r13 */
static int hf_lte_rrc_defaultPagingCycle;         /* T_defaultPagingCycle */
static int hf_lte_rrc_nB;                         /* T_nB */
static int hf_lte_rrc_paging_narrowBands_r13;     /* INTEGER_1_maxAvailNarrowBands_r13 */
static int hf_lte_rrc_mpdcch_NumRepetition_Paging_r13;  /* T_mpdcch_NumRepetition_Paging_r13 */
static int hf_lte_rrc_nB_v1310;                   /* T_nB_v1310 */
static int hf_lte_rrc_ranPagingInIdlePO_r17;      /* T_ranPagingInIdlePO_r17 */
static int hf_lte_rrc_highSpeedEnhancedMeasFlag_r14;  /* T_highSpeedEnhancedMeasFlag_r14 */
static int hf_lte_rrc_highSpeedEnhancedDemodulationFlag_r14;  /* T_highSpeedEnhancedDemodulationFlag_r14 */
static int hf_lte_rrc_highSpeedMeasGapCE_ModeA_r15;  /* T_highSpeedMeasGapCE_ModeA_r15 */
static int hf_lte_rrc_highSpeedEnhancedDemodulationFlag_r14_01;  /* T_highSpeedEnhancedDemodulationFlag_r14_01 */
static int hf_lte_rrc_highSpeedEnhMeasFlag2_r16;  /* T_highSpeedEnhMeasFlag2_r16 */
static int hf_lte_rrc_highSpeedEnhDemodFlag2_r16;  /* T_highSpeedEnhDemodFlag2_r16 */
static int hf_lte_rrc_srb_ToAddModList;           /* SRB_ToAddModList */
static int hf_lte_rrc_drb_ToAddModList;           /* DRB_ToAddModList */
static int hf_lte_rrc_drb_ToReleaseList;          /* DRB_ToReleaseList */
static int hf_lte_rrc_mac_MainConfig;             /* T_mac_MainConfig */
static int hf_lte_rrc_explicitValue_03;           /* MAC_MainConfig */
static int hf_lte_rrc_sps_Config;                 /* SPS_Config */
static int hf_lte_rrc_physicalConfigDedicated;    /* PhysicalConfigDedicated */
static int hf_lte_rrc_rlf_TimersAndConstants_r9;  /* RLF_TimersAndConstants_r9 */
static int hf_lte_rrc_measSubframePatternPCell_r10;  /* MeasSubframePatternPCell_r10 */
static int hf_lte_rrc_neighCellsCRS_Info_r11;     /* NeighCellsCRS_Info_r11 */
static int hf_lte_rrc_naics_Info_r12;             /* NAICS_AssistanceInfo_r12 */
static int hf_lte_rrc_neighCellsCRS_Info_r13;     /* NeighCellsCRS_Info_r13 */
static int hf_lte_rrc_rlf_TimersAndConstants_r13;  /* RLF_TimersAndConstants_r13 */
static int hf_lte_rrc_sps_Config_v1430;           /* SPS_Config_v1430 */
static int hf_lte_rrc_srb_ToAddModListExt_r15;    /* SRB_ToAddModListExt_r15 */
static int hf_lte_rrc_srb_ToReleaseListExt_r15;   /* INTEGER_4 */
static int hf_lte_rrc_sps_Config_v1530;           /* SPS_Config_v1530 */
static int hf_lte_rrc_crs_IntfMitigConfig_r15_01;  /* T_crs_IntfMitigConfig_r15_01 */
static int hf_lte_rrc_radioResourceConfigDedicated_eag_7_crs_IntfMitigConfig_r15_setup;  /* T_radioResourceConfigDedicated_eag_7_crs_IntfMitigConfig_r15_setup */
static int hf_lte_rrc_crs_IntfMitigNumPRBs_01;    /* T_crs_IntfMitigNumPRBs_01 */
static int hf_lte_rrc_neighCellsCRS_Info_r15;     /* NeighCellsCRS_Info_r15 */
static int hf_lte_rrc_drb_ToAddModList_r15;       /* DRB_ToAddModList_r15 */
static int hf_lte_rrc_drb_ToReleaseList_r15;      /* DRB_ToReleaseList_r15 */
static int hf_lte_rrc_radioResourceConfigDedicated_eag_7_dummy;  /* T_radioResourceConfigDedicated_eag_7_dummy */
static int hf_lte_rrc_radioResourceConfigDedicated_eag_7_dummy_item;  /* INTEGER_1_2 */
static int hf_lte_rrc_sps_Config_v1540;           /* SPS_Config_v1540 */
static int hf_lte_rrc_rlf_TimersAndConstantsMCG_Failure_r16;  /* RLF_TimersAndConstantsMCG_Failure_r16 */
static int hf_lte_rrc_crs_ChEstMPDCCH_ConfigDedicated_r16;  /* T_crs_ChEstMPDCCH_ConfigDedicated_r16 */
static int hf_lte_rrc_radioResourceConfigDedicated_eag_9_crs_ChEstMPDCCH_ConfigDedicated_r16_setup;  /* CRS_ChEstMPDCCH_ConfigDedicated_r16 */
static int hf_lte_rrc_newUE_Identity_r16;         /* C_RNTI */
static int hf_lte_rrc_harq_FeedbackEnablingforSPSactive_r18;  /* T_harq_FeedbackEnablingforSPSactive_r18 */
static int hf_lte_rrc_gnss_AutonomousEnabled_r18;  /* T_gnss_AutonomousEnabled_r18 */
static int hf_lte_rrc_ul_TransmissionExtensionEnabled_r18;  /* T_ul_TransmissionExtensionEnabled_r18 */
static int hf_lte_rrc_ul_TransmissionExtensionValue_r18;  /* T_ul_TransmissionExtensionValue_r18 */
static int hf_lte_rrc_physicalConfigDedicated_v1370;  /* PhysicalConfigDedicated_v1370 */
static int hf_lte_rrc_physicalConfigDedicated_v13c0;  /* PhysicalConfigDedicated_v13c0 */
static int hf_lte_rrc_physicalConfigDedicatedPSCell_r12;  /* PhysicalConfigDedicated */
static int hf_lte_rrc_sps_Config_r12;             /* SPS_Config */
static int hf_lte_rrc_neighCellsCRS_InfoPSCell_r13;  /* NeighCellsCRS_Info_r13 */
static int hf_lte_rrc_eag_3_crs_IntfMitigEnabled_r15;  /* BOOLEAN */
static int hf_lte_rrc_physicalConfigDedicatedPSCell_v1370;  /* PhysicalConfigDedicated_v1370 */
static int hf_lte_rrc_physicalConfigDedicatedPSCell_v13c0;  /* PhysicalConfigDedicated_v13c0 */
static int hf_lte_rrc_drb_ToAddModListSCG_r12_01;  /* DRB_ToAddModListSCG_r12 */
static int hf_lte_rrc_mac_MainConfigSCG_r12;      /* MAC_MainConfig */
static int hf_lte_rrc_rlf_TimersAndConstantsSCG_r12;  /* RLF_TimersAndConstantsSCG_r12 */
static int hf_lte_rrc_drb_ToAddModListSCG_r15_01;  /* DRB_ToAddModListSCG_r15 */
static int hf_lte_rrc_srb_ToAddModListSCG_r15;    /* SRB_ToAddModList */
static int hf_lte_rrc_srb_ToReleaseListSCG_r15;   /* SRB_ToReleaseList_r15 */
static int hf_lte_rrc_physicalConfigDedicatedSCell_r10;  /* PhysicalConfigDedicatedSCell_r10 */
static int hf_lte_rrc_mac_MainConfigSCell_r11;    /* MAC_MainConfigSCell_r11 */
static int hf_lte_rrc_neighCellsCRS_InfoSCell_r13;  /* NeighCellsCRS_Info_r13 */
static int hf_lte_rrc_physicalConfigDedicatedSCell_v1370;  /* PhysicalConfigDedicatedSCell_v1370 */
static int hf_lte_rrc_eag_5_crs_IntfMitigEnabled_r15;  /* BOOLEAN */
static int hf_lte_rrc_physicalConfigDedicatedSCell_v1730;  /* PhysicalConfigDedicatedSCell_v1730 */
static int hf_lte_rrc_physicalConfigDedicatedSCell_v13c0;  /* PhysicalConfigDedicatedSCell_v13c0 */
static int hf_lte_rrc_SRB_ToAddModList_item;      /* SRB_ToAddMod */
static int hf_lte_rrc_SRB_ToAddModListExt_r15_item;  /* SRB_ToAddMod */
static int hf_lte_rrc_srb_Identity;               /* INTEGER_1_2 */
static int hf_lte_rrc_rlc_Config;                 /* T_rlc_Config */
static int hf_lte_rrc_explicitValue_04;           /* RLC_Config */
static int hf_lte_rrc_logicalChannelConfig;       /* T_logicalChannelConfig */
static int hf_lte_rrc_explicitValue_05;           /* LogicalChannelConfig */
static int hf_lte_rrc_pdcp_verChange_r15;         /* T_pdcp_verChange_r15 */
static int hf_lte_rrc_rlc_Config_v1530;           /* RLC_Config_v1530 */
static int hf_lte_rrc_rlc_BearerConfigSecondary_r15;  /* RLC_BearerConfig_r15 */
static int hf_lte_rrc_srb_Identity_v1530;         /* INTEGER_4 */
static int hf_lte_rrc_rlc_Config_v1560;           /* RLC_Config_v1510 */
static int hf_lte_rrc_rlc_Config_v1700;           /* RLC_Config_v1700 */
static int hf_lte_rrc_DRB_ToAddModList_item;      /* DRB_ToAddMod */
static int hf_lte_rrc_DRB_ToAddModList_r15_item;  /* DRB_ToAddMod */
static int hf_lte_rrc_DRB_ToAddModListSCG_r12_item;  /* DRB_ToAddModSCG_r12 */
static int hf_lte_rrc_DRB_ToAddModListSCG_r15_item;  /* DRB_ToAddModSCG_r12 */
static int hf_lte_rrc_eps_BearerIdentity;         /* INTEGER_0_15 */
static int hf_lte_rrc_pdcp_Config;                /* PDCP_Config */
static int hf_lte_rrc_rlc_Config_01;              /* RLC_Config */
static int hf_lte_rrc_logicalChannelIdentity;     /* T_logicalChannelIdentity */
static int hf_lte_rrc_logicalChannelConfig_01;    /* LogicalChannelConfig */
static int hf_lte_rrc_drb_TypeChange_r12;         /* T_drb_TypeChange_r12 */
static int hf_lte_rrc_rlc_Config_v1250;           /* RLC_Config_v1250 */
static int hf_lte_rrc_rlc_Config_v1310;           /* RLC_Config_v1310 */
static int hf_lte_rrc_drb_TypeLWA_r13;            /* BOOLEAN */
static int hf_lte_rrc_drb_TypeLWIP_r13;           /* T_drb_TypeLWIP_r13 */
static int hf_lte_rrc_rlc_Config_v1430;           /* RLC_Config_v1430 */
static int hf_lte_rrc_lwip_UL_Aggregation_r14;    /* BOOLEAN */
static int hf_lte_rrc_lwip_DL_Aggregation_r14;    /* BOOLEAN */
static int hf_lte_rrc_lwa_WLAN_AC_r14;            /* T_lwa_WLAN_AC_r14 */
static int hf_lte_rrc_rlc_Config_v1510;           /* RLC_Config_v1510 */
static int hf_lte_rrc_logicalChannelIdentity_r15_01;  /* T_logicalChannelIdentity_r15 */
static int hf_lte_rrc_daps_HO_r16;                /* T_daps_HO_r16 */
static int hf_lte_rrc_drb_Type_r12_01;            /* T_drb_Type_r12_01 */
static int hf_lte_rrc_split_r12;                  /* NULL */
static int hf_lte_rrc_scg_r12;                    /* T_scg_r12 */
static int hf_lte_rrc_pdcp_Config_r12;            /* PDCP_Config */
static int hf_lte_rrc_rlc_ConfigSCG_r12;          /* RLC_Config */
static int hf_lte_rrc_logicalChannelIdentitySCG_r12;  /* INTEGER_3_10 */
static int hf_lte_rrc_logicalChannelConfigSCG_r12;  /* LogicalChannelConfig */
static int hf_lte_rrc_logicalChannelIdentitySCG_r15;  /* INTEGER_32_38 */
static int hf_lte_rrc_DRB_ToReleaseList_item;     /* DRB_Identity */
static int hf_lte_rrc_DRB_ToReleaseList_r15_item;  /* DRB_Identity */
static int hf_lte_rrc_SRB_ToReleaseList_r15_item;  /* INTEGER_1_2 */
static int hf_lte_rrc_measSubframePatternPCell_r10_setup;  /* MeasSubframePattern_r10 */
static int hf_lte_rrc_neighCellsCRS_Info_r11_setup;  /* CRS_AssistanceInfoList_r11 */
static int hf_lte_rrc_CRS_AssistanceInfoList_r11_item;  /* CRS_AssistanceInfo_r11 */
static int hf_lte_rrc_physCellId_r11_02;          /* PhysCellId */
static int hf_lte_rrc_antennaPortsCount_r11_01;   /* T_antennaPortsCount_r11_01 */
static int hf_lte_rrc_mbsfn_SubframeConfigList_r11_02;  /* MBSFN_SubframeConfigList */
static int hf_lte_rrc_neighCellsCRS_Info_r13_setup;  /* CRS_AssistanceInfoList_r13 */
static int hf_lte_rrc_CRS_AssistanceInfoList_r13_item;  /* CRS_AssistanceInfo_r13 */
static int hf_lte_rrc_antennaPortsCount_r13;      /* T_antennaPortsCount_r13 */
static int hf_lte_rrc_mbsfn_SubframeConfigList_r13;  /* MBSFN_SubframeConfigList */
static int hf_lte_rrc_neighCellsCRS_Info_r15_setup;  /* CRS_AssistanceInfoList_r15 */
static int hf_lte_rrc_CRS_AssistanceInfoList_r15_item;  /* CRS_AssistanceInfo_r15 */
static int hf_lte_rrc_physCellId_r15;             /* PhysCellId */
static int hf_lte_rrc_cRS_AssistanceInfo_r15_crs_IntfMitigEnabled_r15;  /* T_cRS_AssistanceInfo_r15_crs_IntfMitigEnabled_r15 */
static int hf_lte_rrc_nAICS_AssistanceInfo_r12_setup;  /* T_nAICS_AssistanceInfo_r12_setup */
static int hf_lte_rrc_neighCellsToReleaseList_r12;  /* NeighCellsToReleaseList_r12 */
static int hf_lte_rrc_neighCellsToAddModList_r12;  /* NeighCellsToAddModList_r12 */
static int hf_lte_rrc_servCellp_a_r12;            /* P_a */
static int hf_lte_rrc_NeighCellsToReleaseList_r12_item;  /* PhysCellId */
static int hf_lte_rrc_NeighCellsToAddModList_r12_item;  /* NeighCellsInfo_r12 */
static int hf_lte_rrc_p_b_r12;                    /* INTEGER_0_3 */
static int hf_lte_rrc_crs_PortsCount_r12;         /* T_crs_PortsCount_r12 */
static int hf_lte_rrc_mbsfn_SubframeConfig_r12;   /* MBSFN_SubframeConfigList */
static int hf_lte_rrc_p_aList_r12;                /* SEQUENCE_SIZE_1_maxP_a_PerNeighCell_r12_OF_P_a */
static int hf_lte_rrc_p_aList_r12_item;           /* P_a */
static int hf_lte_rrc_transmissionModeList_r12;   /* T_transmissionModeList_r12 */
static int hf_lte_rrc_resAllocGranularity_r12;    /* INTEGER_1_4 */
static int hf_lte_rrc_rLC_BearerConfig_r15_setup;  /* T_rLC_BearerConfig_r15_setup */
static int hf_lte_rrc_rlc_Config_r15;             /* RLC_Config_r15 */
static int hf_lte_rrc_logicalChannelIdentityConfig_r15;  /* T_logicalChannelIdentityConfig_r15 */
static int hf_lte_rrc_logicalChannelConfig_r15;   /* LogicalChannelConfig */
static int hf_lte_rrc_rCLWI_Configuration_r13_setup;  /* T_rCLWI_Configuration_r13_setup */
static int hf_lte_rrc_rclwi_Config_r13;           /* RCLWI_Config_r13 */
static int hf_lte_rrc_command;                    /* T_command */
static int hf_lte_rrc_steerToWLAN_r13;            /* T_steerToWLAN_r13 */
static int hf_lte_rrc_mobilityConfig_r13;         /* WLAN_Id_List_r12 */
static int hf_lte_rrc_steerToLTE_r13;             /* NULL */
static int hf_lte_rrc_periodicityStartPos_r16;    /* PeriodicityStartPos_r16 */
static int hf_lte_rrc_resourceReservationFreq_r16;  /* T_resourceReservationFreq_r16 */
static int hf_lte_rrc_rbg_Bitmap1dot4;            /* BIT_STRING_SIZE_6 */
static int hf_lte_rrc_rbg_Bitmap3;                /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_rbg_Bitmap5;                /* BIT_STRING_SIZE_13 */
static int hf_lte_rrc_rbg_Bitmap10;               /* BIT_STRING_SIZE_17 */
static int hf_lte_rrc_rbg_Bitmap15;               /* BIT_STRING_SIZE_19 */
static int hf_lte_rrc_rbg_Bitmap20;               /* BIT_STRING_SIZE_25 */
static int hf_lte_rrc_slotBitmap_r16;             /* T_slotBitmap_r16 */
static int hf_lte_rrc_slotPattern10ms;            /* BIT_STRING_SIZE_20 */
static int hf_lte_rrc_slotPattern40ms;            /* BIT_STRING_SIZE_80 */
static int hf_lte_rrc_symbolBitmap1_r16;          /* BIT_STRING_SIZE_7 */
static int hf_lte_rrc_symbolBitmap2_r16;          /* BIT_STRING_SIZE_7 */
static int hf_lte_rrc_slotBitmap_r16_01;          /* T_slotBitmap_r16_01 */
static int hf_lte_rrc_periodicity10ms;            /* NULL */
static int hf_lte_rrc_periodicity20ms;            /* INTEGER_0_1 */
static int hf_lte_rrc_periodicity40ms;            /* INTEGER_0_3 */
static int hf_lte_rrc_periodicity80ms;            /* INTEGER_0_7 */
static int hf_lte_rrc_periodicity160ms;           /* INTEGER_0_15 */
static int hf_lte_rrc_am;                         /* T_am */
static int hf_lte_rrc_ul_AM_RLC;                  /* UL_AM_RLC */
static int hf_lte_rrc_dl_AM_RLC;                  /* DL_AM_RLC */
static int hf_lte_rrc_um_Bi_Directional;          /* T_um_Bi_Directional */
static int hf_lte_rrc_ul_UM_RLC;                  /* UL_UM_RLC */
static int hf_lte_rrc_dl_UM_RLC;                  /* DL_UM_RLC */
static int hf_lte_rrc_um_Uni_Directional_UL;      /* T_um_Uni_Directional_UL */
static int hf_lte_rrc_um_Uni_Directional_DL;      /* T_um_Uni_Directional_DL */
static int hf_lte_rrc_ul_extended_RLC_LI_Field_r12;  /* T_ul_extended_RLC_LI_Field_r12 */
static int hf_lte_rrc_dl_extended_RLC_LI_Field_r12;  /* T_dl_extended_RLC_LI_Field_r12 */
static int hf_lte_rrc_ul_extended_RLC_AM_SN_r13;  /* T_ul_extended_RLC_AM_SN_r13 */
static int hf_lte_rrc_dl_extended_RLC_AM_SN_r13;  /* T_dl_extended_RLC_AM_SN_r13 */
static int hf_lte_rrc_pollPDU_v1310;              /* PollPDU_v1310 */
static int hf_lte_rrc_rLC_Config_v1430_setup;     /* T_rLC_Config_v1430_setup */
static int hf_lte_rrc_pollByte_r14;               /* PollByte_r14 */
static int hf_lte_rrc_reestablishRLC_r15;         /* T_reestablishRLC_r15 */
static int hf_lte_rrc_rLC_Config_v1530_setup;     /* T_rLC_Config_v1530_setup */
static int hf_lte_rrc_rlc_OutOfOrderDelivery_r15;  /* T_rlc_OutOfOrderDelivery_r15 */
static int hf_lte_rrc_t_ReorderingExt_r17;        /* T_t_ReorderingExt_r17 */
static int hf_lte_rrc_setup_10;                   /* T_ReorderingExt_r17 */
static int hf_lte_rrc_mode_r15;                   /* T_mode_r15 */
static int hf_lte_rrc_am_r15;                     /* T_am_r15 */
static int hf_lte_rrc_ul_AM_RLC_r15;              /* UL_AM_RLC_r15 */
static int hf_lte_rrc_dl_AM_RLC_r15;              /* DL_AM_RLC_r15 */
static int hf_lte_rrc_um_Bi_Directional_r15;      /* T_um_Bi_Directional_r15 */
static int hf_lte_rrc_ul_UM_RLC_r15;              /* UL_UM_RLC */
static int hf_lte_rrc_dl_UM_RLC_r15;              /* DL_UM_RLC_r15 */
static int hf_lte_rrc_um_Uni_Directional_UL_r15;  /* T_um_Uni_Directional_UL_r15 */
static int hf_lte_rrc_um_Uni_Directional_DL_r15;  /* T_um_Uni_Directional_DL_r15 */
static int hf_lte_rrc_reestablishRLC_r15_01;      /* T_reestablishRLC_r15_01 */
static int hf_lte_rrc_rlc_OutOfOrderDelivery_r15_01;  /* T_rlc_OutOfOrderDelivery_r15_01 */
static int hf_lte_rrc_t_PollRetransmit;           /* T_PollRetransmit */
static int hf_lte_rrc_pollPDU;                    /* PollPDU */
static int hf_lte_rrc_pollByte;                   /* PollByte */
static int hf_lte_rrc_maxRetxThreshold;           /* T_maxRetxThreshold */
static int hf_lte_rrc_t_PollRetransmit_r15;       /* T_PollRetransmit */
static int hf_lte_rrc_pollPDU_r15;                /* PollPDU_r15 */
static int hf_lte_rrc_pollByte_r15;               /* PollByte_r14 */
static int hf_lte_rrc_maxRetxThreshold_r15;       /* T_maxRetxThreshold_r15 */
static int hf_lte_rrc_extended_RLC_LI_Field_r15;  /* BOOLEAN */
static int hf_lte_rrc_t_Reordering;               /* T_Reordering */
static int hf_lte_rrc_t_StatusProhibit;           /* T_StatusProhibit */
static int hf_lte_rrc_t_Reordering_r15;           /* T_Reordering */
static int hf_lte_rrc_t_StatusProhibit_r15;       /* T_StatusProhibit */
static int hf_lte_rrc_sn_FieldLength;             /* SN_FieldLength */
static int hf_lte_rrc_sn_FieldLength_r15;         /* SN_FieldLength_r15 */
static int hf_lte_rrc_rLF_TimersAndConstants_r9_setup;  /* T_rLF_TimersAndConstants_r9_setup */
static int hf_lte_rrc_t301_r9;                    /* T_t301_r9 */
static int hf_lte_rrc_t310_r9;                    /* T_t310_r9 */
static int hf_lte_rrc_n310_r9;                    /* T_n310_r9 */
static int hf_lte_rrc_t311_r9;                    /* T_t311_r9 */
static int hf_lte_rrc_n311_r9;                    /* T_n311_r9 */
static int hf_lte_rrc_rLF_TimersAndConstants_r13_setup;  /* T_rLF_TimersAndConstants_r13_setup */
static int hf_lte_rrc_t301_v1310;                 /* T_t301_v1310 */
static int hf_lte_rrc_t310_v1330;                 /* T_t310_v1330 */
static int hf_lte_rrc_rLF_TimersAndConstantsSCG_r12_setup;  /* T_rLF_TimersAndConstantsSCG_r12_setup */
static int hf_lte_rrc_t313_r12;                   /* T_t313_r12 */
static int hf_lte_rrc_n313_r12;                   /* T_n313_r12 */
static int hf_lte_rrc_n314_r12;                   /* T_n314_r12 */
static int hf_lte_rrc_rLF_TimersAndConstantsMCG_Failure_r16_setup;  /* T_rLF_TimersAndConstantsMCG_Failure_r16_setup */
static int hf_lte_rrc_t316_r16;                   /* T_t316_r16 */
static int hf_lte_rrc_subframeConfigPattern_r10;  /* T_subframeConfigPattern_r10 */
static int hf_lte_rrc_subframeConfigPatternFDD_r10;  /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_subframeConfigPatternTDD_r10;  /* INTEGER_0_31 */
static int hf_lte_rrc_rpdcch_Config_r10;          /* T_rpdcch_Config_r10 */
static int hf_lte_rrc_resourceAllocationType_r10;  /* T_resourceAllocationType_r10 */
static int hf_lte_rrc_resourceBlockAssignment_r10;  /* T_resourceBlockAssignment_r10 */
static int hf_lte_rrc_type01_r10;                 /* T_type01_r10 */
static int hf_lte_rrc_nrb6_r10;                   /* BIT_STRING_SIZE_6 */
static int hf_lte_rrc_nrb15_r10;                  /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_nrb25_r10;                  /* BIT_STRING_SIZE_13 */
static int hf_lte_rrc_nrb50_r10;                  /* BIT_STRING_SIZE_17 */
static int hf_lte_rrc_nrb75_r10;                  /* BIT_STRING_SIZE_19 */
static int hf_lte_rrc_nrb100_r10;                 /* BIT_STRING_SIZE_25 */
static int hf_lte_rrc_type2_r10;                  /* T_type2_r10 */
static int hf_lte_rrc_nrb6_r10_01;                /* BIT_STRING_SIZE_5 */
static int hf_lte_rrc_nrb15_r10_01;               /* BIT_STRING_SIZE_7 */
static int hf_lte_rrc_nrb25_r10_01;               /* BIT_STRING_SIZE_9 */
static int hf_lte_rrc_nrb50_r10_01;               /* BIT_STRING_SIZE_11 */
static int hf_lte_rrc_nrb75_r10_01;               /* BIT_STRING_SIZE_12 */
static int hf_lte_rrc_nrb100_r10_01;              /* BIT_STRING_SIZE_13 */
static int hf_lte_rrc_demodulationRS_r10;         /* T_demodulationRS_r10 */
static int hf_lte_rrc_interleaving_r10;           /* T_interleaving_r10 */
static int hf_lte_rrc_noInterleaving_r10;         /* T_noInterleaving_r10 */
static int hf_lte_rrc_pdsch_Start_r10_01;         /* INTEGER_1_3 */
static int hf_lte_rrc_pucch_Config_r10;           /* T_pucch_Config_r10 */
static int hf_lte_rrc_tdd_01;                     /* T_tdd_01 */
static int hf_lte_rrc_channelSelectionMultiplexingBundling;  /* T_channelSelectionMultiplexingBundling */
static int hf_lte_rrc_n1PUCCH_AN_List_r10;        /* T_n1PUCCH_AN_List_r10 */
static int hf_lte_rrc_n1PUCCH_AN_List_r10_item;   /* INTEGER_0_2047 */
static int hf_lte_rrc_fallbackForFormat3;         /* T_fallbackForFormat3 */
static int hf_lte_rrc_n1PUCCH_AN_P0_r10;          /* INTEGER_0_2047 */
static int hf_lte_rrc_n1PUCCH_AN_P1_r10;          /* INTEGER_0_2047 */
static int hf_lte_rrc_fdd_01;                     /* T_fdd_01 */
static int hf_lte_rrc_duration_r15;               /* T_duration_r15 */
static int hf_lte_rrc_freqLocation_r15;           /* INTEGER_0_98 */
static int hf_lte_rrc_periodicity_r15;            /* T_periodicity_r15 */
static int hf_lte_rrc_powerBoost_r15;             /* T_powerBoost_r15 */
static int hf_lte_rrc_timeOffset_r15;             /* INTEGER_0_31 */
static int hf_lte_rrc_schedulingRequestConfig_setup;  /* T_schedulingRequestConfig_setup */
static int hf_lte_rrc_sr_PUCCH_ResourceIndex;     /* INTEGER_0_2047 */
static int hf_lte_rrc_sr_ConfigIndex;             /* T_sr_ConfigIndex */
static int hf_lte_rrc_dsr_TransMax;               /* T_dsr_TransMax */
static int hf_lte_rrc_sr_PUCCH_ResourceIndexP1_r10;  /* INTEGER_0_2047 */
static int hf_lte_rrc_schedulingRequestConfigSCell_r13_setup;  /* T_schedulingRequestConfigSCell_r13_setup */
static int hf_lte_rrc_sr_PUCCH_ResourceIndex_r13;  /* INTEGER_0_2047 */
static int hf_lte_rrc_sr_PUCCH_ResourceIndexP1_r13;  /* INTEGER_0_2047 */
static int hf_lte_rrc_sr_ConfigIndex_r13;         /* T_sr_ConfigIndex_r13 */
static int hf_lte_rrc_dsr_TransMax_r13;           /* T_dsr_TransMax_r13 */
static int hf_lte_rrc_schedulingRequestConfig_v1530_setup;  /* T_schedulingRequestConfig_v1530_setup */
static int hf_lte_rrc_sr_SlotSPUCCH_IndexFH_r15;  /* INTEGER_0_1319 */
static int hf_lte_rrc_sr_SlotSPUCCH_IndexNoFH_r15;  /* INTEGER_0_3959 */
static int hf_lte_rrc_sr_SubslotSPUCCH_ResourceList_r15;  /* SR_SubslotSPUCCH_ResourceList_r15 */
static int hf_lte_rrc_sr_ConfigIndexSlot_r15;     /* INTEGER_0_36 */
static int hf_lte_rrc_sr_ConfigIndexSubslot_r15;  /* INTEGER_0_122 */
static int hf_lte_rrc_dssr_TransMax_r15;          /* T_dssr_TransMax_r15 */
static int hf_lte_rrc_SR_SubslotSPUCCH_ResourceList_r15_item;  /* INTEGER_0_1319 */
static int hf_lte_rrc_slotOrSubslotPDSCH_Config_r15_setup;  /* T_slotOrSubslotPDSCH_Config_r15_setup */
static int hf_lte_rrc_altCQI_TableSTTI_r15;       /* T_altCQI_TableSTTI_r15 */
static int hf_lte_rrc_altCQI_Table1024QAM_STTI_r15;  /* T_altCQI_Table1024QAM_STTI_r15 */
static int hf_lte_rrc_resourceAllocation_r15;     /* T_resourceAllocation_r15 */
static int hf_lte_rrc_tbsIndexAlt_STTI_r15;       /* T_tbsIndexAlt_STTI_r15 */
static int hf_lte_rrc_tbsIndexAlt2_STTI_r15;      /* T_tbsIndexAlt2_STTI_r15 */
static int hf_lte_rrc_tbsIndexAlt3_STTI_r15;      /* T_tbsIndexAlt3_STTI_r15 */
static int hf_lte_rrc_slotOrSubslotPUSCH_Config_r15_setup;  /* T_slotOrSubslotPUSCH_Config_r15_setup */
static int hf_lte_rrc_betaOffsetSlot_ACK_Index_r15;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset2Slot_ACK_Index_r15;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffsetSubslot_ACK_Index_r15;  /* T_betaOffsetSubslot_ACK_Index_r15 */
static int hf_lte_rrc_betaOffsetSubslot_ACK_Index_r15_item;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffset2Subslot_ACK_Index_r15;  /* T_betaOffset2Subslot_ACK_Index_r15 */
static int hf_lte_rrc_betaOffset2Subslot_ACK_Index_r15_item;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffsetSlot_RI_Index_r15;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffsetSubslot_RI_Index_r15;  /* T_betaOffsetSubslot_RI_Index_r15 */
static int hf_lte_rrc_betaOffsetSubslot_RI_Index_r15_item;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffsetSlot_CQI_Index_r15;  /* INTEGER_0_15 */
static int hf_lte_rrc_betaOffsetSubslot_CQI_Index_r15;  /* INTEGER_0_15 */
static int hf_lte_rrc_enable256QAM_SlotOrSubslot_r15;  /* Enable256QAM_r14 */
static int hf_lte_rrc_resourceAllocationOffset_r15;  /* INTEGER_1_2 */
static int hf_lte_rrc_ul_DMRS_IFDMA_SlotOrSubslot_r15;  /* BOOLEAN */
static int hf_lte_rrc_soundingRS_UL_ConfigCommon_setup;  /* T_soundingRS_UL_ConfigCommon_setup */
static int hf_lte_rrc_srs_BandwidthConfig;        /* T_srs_BandwidthConfig */
static int hf_lte_rrc_srs_SubframeConfig;         /* T_srs_SubframeConfig */
static int hf_lte_rrc_ackNackSRS_SimultaneousTransmission;  /* BOOLEAN */
static int hf_lte_rrc_srs_MaxUpPts;               /* T_srs_MaxUpPts */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicated_setup;  /* T_soundingRS_UL_ConfigDedicated_setup */
static int hf_lte_rrc_srs_Bandwidth;              /* T_srs_Bandwidth */
static int hf_lte_rrc_srs_HoppingBandwidth;       /* T_srs_HoppingBandwidth */
static int hf_lte_rrc_freqDomainPosition;         /* INTEGER_0_23 */
static int hf_lte_rrc_duration;                   /* T_duration */
static int hf_lte_rrc_srs_ConfigIndex;            /* INTEGER_0_1023 */
static int hf_lte_rrc_transmissionComb;           /* INTEGER_0_1 */
static int hf_lte_rrc_cyclicShift_01;             /* T_cyclicShift */
static int hf_lte_rrc_srs_AntennaPort_r10;        /* SRS_AntennaPort */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicated_v1310_setup;  /* T_soundingRS_UL_ConfigDedicated_v1310_setup */
static int hf_lte_rrc_transmissionComb_v1310;     /* INTEGER_2_3 */
static int hf_lte_rrc_cyclicShift_v1310;          /* T_cyclicShift_v1310 */
static int hf_lte_rrc_transmissionCombNum_r13;    /* T_transmissionCombNum_r13 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicatedUpPTsExt_r13_setup;  /* T_soundingRS_UL_ConfigDedicatedUpPTsExt_r13_setup */
static int hf_lte_rrc_srs_UpPtsAdd_r13;           /* T_srs_UpPtsAdd_r13 */
static int hf_lte_rrc_srs_Bandwidth_r13;          /* T_srs_Bandwidth_r13 */
static int hf_lte_rrc_srs_HoppingBandwidth_r13;   /* T_srs_HoppingBandwidth_r13 */
static int hf_lte_rrc_freqDomainPosition_r13;     /* INTEGER_0_23 */
static int hf_lte_rrc_duration_r13;               /* BOOLEAN */
static int hf_lte_rrc_srs_ConfigIndex_r13;        /* INTEGER_0_1023 */
static int hf_lte_rrc_transmissionComb_r13;       /* INTEGER_0_3 */
static int hf_lte_rrc_cyclicShift_r13;            /* T_cyclicShift_r13 */
static int hf_lte_rrc_srs_AntennaPort_r13;        /* SRS_AntennaPort */
static int hf_lte_rrc_transmissionCombNum_r13_01;  /* T_transmissionCombNum_r13_01 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicatedAperiodic_r10_setup;  /* T_soundingRS_UL_ConfigDedicatedAperiodic_r10_setup */
static int hf_lte_rrc_srs_ConfigIndexAp_r10;      /* INTEGER_0_31 */
static int hf_lte_rrc_srs_ConfigApDCI_Format4_r10;  /* SEQUENCE_SIZE_1_3_OF_SRS_ConfigAp_r10 */
static int hf_lte_rrc_srs_ConfigApDCI_Format4_r10_item;  /* SRS_ConfigAp_r10 */
static int hf_lte_rrc_srs_ActivateAp_r10;         /* T_srs_ActivateAp_r10 */
static int hf_lte_rrc_setup_11;                   /* T_setup */
static int hf_lte_rrc_srs_ConfigApDCI_Format0_r10;  /* SRS_ConfigAp_r10 */
static int hf_lte_rrc_srs_ConfigApDCI_Format1a2b2c_r10;  /* SRS_ConfigAp_r10 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicatedAperiodic_v1310_setup;  /* T_soundingRS_UL_ConfigDedicatedAperiodic_v1310_setup */
static int hf_lte_rrc_srs_ConfigApDCI_Format4_v1310;  /* SEQUENCE_SIZE_1_3_OF_SRS_ConfigAp_v1310 */
static int hf_lte_rrc_srs_ConfigApDCI_Format4_v1310_item;  /* SRS_ConfigAp_v1310 */
static int hf_lte_rrc_srs_ActivateAp_v1310;       /* T_srs_ActivateAp_v1310 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicatedAperiodic_v1310_setup_srs_ActivateAp_v1310_setup;  /* T_soundingRS_UL_ConfigDedicatedAperiodic_v1310_setup_srs_ActivateAp_v1310_setup */
static int hf_lte_rrc_srs_ConfigApDCI_Format0_v1310;  /* SRS_ConfigAp_v1310 */
static int hf_lte_rrc_srs_ConfigApDCI_Format1a2b2c_v1310;  /* SRS_ConfigAp_v1310 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicatedAperiodicUpPTsExt_r13_setup;  /* T_soundingRS_UL_ConfigDedicatedAperiodicUpPTsExt_r13_setup */
static int hf_lte_rrc_srs_UpPtsAdd_r13_01;        /* T_srs_UpPtsAdd_r13_01 */
static int hf_lte_rrc_srs_ConfigIndexAp_r13;      /* INTEGER_0_31 */
static int hf_lte_rrc_srs_ConfigApDCI_Format4_r13;  /* SEQUENCE_SIZE_1_3_OF_SRS_ConfigAp_r13 */
static int hf_lte_rrc_srs_ConfigApDCI_Format4_r13_item;  /* SRS_ConfigAp_r13 */
static int hf_lte_rrc_srs_ActivateAp_r13;         /* T_srs_ActivateAp_r13 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicatedAperiodicUpPTsExt_r13_setup_srs_ActivateAp_r13_setup;  /* T_soundingRS_UL_ConfigDedicatedAperiodicUpPTsExt_r13_setup_srs_ActivateAp_r13_setup */
static int hf_lte_rrc_srs_ConfigApDCI_Format0_r13;  /* SRS_ConfigAp_r13 */
static int hf_lte_rrc_srs_ConfigApDCI_Format1a2b2c_r13;  /* SRS_ConfigAp_r13 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicatedAperiodic_v1430_setup;  /* T_soundingRS_UL_ConfigDedicatedAperiodic_v1430_setup */
static int hf_lte_rrc_srs_SubframeIndication_r14;  /* INTEGER_1_4 */
static int hf_lte_rrc_srs_ConfigIndexAp_r16;      /* INTEGER_0_31 */
static int hf_lte_rrc_srs_ConfigApDCI_Format4_r16;  /* SEQUENCE_SIZE_1_3_OF_SRS_ConfigAdd_r16 */
static int hf_lte_rrc_srs_ConfigApDCI_Format4_r16_item;  /* SRS_ConfigAdd_r16 */
static int hf_lte_rrc_srs_ActivateAp_r13_01;      /* T_srs_ActivateAp_r13_01 */
static int hf_lte_rrc_soundingRS_UL_ConfigDedicatedAdd_r16_srs_ActivateAp_r13_setup;  /* T_soundingRS_UL_ConfigDedicatedAdd_r16_srs_ActivateAp_r13_setup */
static int hf_lte_rrc_srs_ConfigApDCI_Format0_r16;  /* SRS_ConfigAdd_r16 */
static int hf_lte_rrc_srs_ConfigApDCI_Format1a2b2c_r16;  /* SRS_ConfigAdd_r16 */
static int hf_lte_rrc_srs_AntennaPortAp_r10;      /* SRS_AntennaPort */
static int hf_lte_rrc_srs_BandwidthAp_r10;        /* T_srs_BandwidthAp_r10 */
static int hf_lte_rrc_freqDomainPositionAp_r10;   /* INTEGER_0_23 */
static int hf_lte_rrc_transmissionCombAp_r10;     /* INTEGER_0_1 */
static int hf_lte_rrc_cyclicShiftAp_r10;          /* T_cyclicShiftAp_r10 */
static int hf_lte_rrc_transmissionCombAp_v1310;   /* INTEGER_2_3 */
static int hf_lte_rrc_cyclicShiftAp_v1310;        /* T_cyclicShiftAp_v1310 */
static int hf_lte_rrc_transmissionCombNum_r13_02;  /* T_transmissionCombNum_r13_02 */
static int hf_lte_rrc_srs_AntennaPortAp_r13;      /* SRS_AntennaPort */
static int hf_lte_rrc_srs_BandwidthAp_r13;        /* T_srs_BandwidthAp_r13 */
static int hf_lte_rrc_freqDomainPositionAp_r13;   /* INTEGER_0_23 */
static int hf_lte_rrc_transmissionCombAp_r13;     /* INTEGER_0_3 */
static int hf_lte_rrc_cyclicShiftAp_r13;          /* T_cyclicShiftAp_r13 */
static int hf_lte_rrc_transmissionCombNum_r13_03;  /* T_transmissionCombNum_r13_03 */
static int hf_lte_rrc_srs_RepNumAdd_r16;          /* T_srs_RepNumAdd_r16 */
static int hf_lte_rrc_srs_BandwidthAdd_r16;       /* T_srs_BandwidthAdd_r16 */
static int hf_lte_rrc_srs_HoppingBandwidthAdd_r16;  /* T_srs_HoppingBandwidthAdd_r16 */
static int hf_lte_rrc_srs_FreqDomainPosAdd_r16;   /* INTEGER_0_23 */
static int hf_lte_rrc_srs_AntennaPortAdd_r16;     /* SRS_AntennaPort */
static int hf_lte_rrc_srs_CyclicShiftAdd_r16;     /* T_srs_CyclicShiftAdd_r16 */
static int hf_lte_rrc_srs_TransmissionCombNumAdd_r16;  /* T_srs_TransmissionCombNumAdd_r16 */
static int hf_lte_rrc_srs_TransmissionCombAdd_r16;  /* INTEGER_0_3 */
static int hf_lte_rrc_srs_StartPosAdd_r16;        /* INTEGER_1_13 */
static int hf_lte_rrc_srs_DurationAdd_r16;        /* INTEGER_1_13 */
static int hf_lte_rrc_srs_GuardSymbolAS_Add_r16;  /* T_srs_GuardSymbolAS_Add_r16 */
static int hf_lte_rrc_srs_GuardSymbolFH_Add_r16;  /* T_srs_GuardSymbolFH_Add_r16 */
static int hf_lte_rrc_sPDCCH_Config_r15_setup;    /* T_sPDCCH_Config_r15_setup */
static int hf_lte_rrc_spdcch_L1_ReuseIndication_r15;  /* T_spdcch_L1_ReuseIndication_r15 */
static int hf_lte_rrc_spdcch_SetConfig_r15;       /* SPDCCH_Set_r15 */
static int hf_lte_rrc_SPDCCH_Set_r15_item;        /* SPDCCH_Elements_r15 */
static int hf_lte_rrc_sPDCCH_Elements_r15_setup;  /* T_sPDCCH_Elements_r15_setup */
static int hf_lte_rrc_spdcch_SetConfigId_r15;     /* INTEGER_0_3 */
static int hf_lte_rrc_spdcch_SetReferenceSig_r15;  /* T_spdcch_SetReferenceSig_r15 */
static int hf_lte_rrc_transmissionType_r15;       /* T_transmissionType_r15 */
static int hf_lte_rrc_spdcch_NoOfSymbols_r15;     /* INTEGER_1_2 */
static int hf_lte_rrc_dmrs_ScramblingSequenceInt_r15;  /* INTEGER_0_503 */
static int hf_lte_rrc_dci7_CandidatesPerAL_PDCCH_r15;  /* SEQUENCE_SIZE_1_4_OF_DCI7_Candidates_r15 */
static int hf_lte_rrc_dci7_CandidatesPerAL_PDCCH_r15_item;  /* DCI7_Candidates_r15 */
static int hf_lte_rrc_dci7_CandidateSetsPerAL_SPDCCH_r15;  /* SEQUENCE_SIZE_1_2_OF_DCI7_CandidatesPerAL_SPDCCH_r15 */
static int hf_lte_rrc_dci7_CandidateSetsPerAL_SPDCCH_r15_item;  /* DCI7_CandidatesPerAL_SPDCCH_r15 */
static int hf_lte_rrc_resourceBlockAssignment_r15;  /* T_resourceBlockAssignment_r15 */
static int hf_lte_rrc_numberRB_InFreq_domain_r15;  /* INTEGER_2_100 */
static int hf_lte_rrc_resourceBlockAssignment_r15_01;  /* BIT_STRING_SIZE_98 */
static int hf_lte_rrc_subslotApplicability_r15;   /* BIT_STRING_SIZE_5 */
static int hf_lte_rrc_al_StartingPointSPDCCH_r15;  /* T_al_StartingPointSPDCCH_r15 */
static int hf_lte_rrc_al_StartingPointSPDCCH_r15_item;  /* INTEGER_0_49 */
static int hf_lte_rrc_subframeType_r15;           /* T_subframeType_r15 */
static int hf_lte_rrc_rateMatchingMode_r15;       /* T_rateMatchingMode_r15 */
static int hf_lte_rrc_DCI7_CandidatesPerAL_SPDCCH_r15_item;  /* DCI7_Candidates_r15 */
static int hf_lte_rrc_semiPersistSchedC_RNTI;     /* C_RNTI */
static int hf_lte_rrc_sps_ConfigDL;               /* SPS_ConfigDL */
static int hf_lte_rrc_sps_ConfigUL;               /* SPS_ConfigUL */
static int hf_lte_rrc_ul_SPS_V_RNTI_r14;          /* C_RNTI */
static int hf_lte_rrc_sl_SPS_V_RNTI_r14;          /* C_RNTI */
static int hf_lte_rrc_sps_ConfigUL_ToAddModList_r14;  /* SPS_ConfigUL_ToAddModList_r14 */
static int hf_lte_rrc_sps_ConfigUL_ToReleaseList_r14;  /* SPS_ConfigUL_ToReleaseList_r14 */
static int hf_lte_rrc_sps_ConfigSL_ToAddModList_r14;  /* SPS_ConfigSL_ToAddModList_r14 */
static int hf_lte_rrc_sps_ConfigSL_ToReleaseList_r14;  /* SPS_ConfigSL_ToReleaseList_r14 */
static int hf_lte_rrc_SPS_ConfigUL_ToAddModList_r14_item;  /* SPS_ConfigUL */
static int hf_lte_rrc_SPS_ConfigUL_ToReleaseList_r14_item;  /* SPS_ConfigIndex_r14 */
static int hf_lte_rrc_SPS_ConfigSL_ToAddModList_r14_item;  /* SPS_ConfigSL_r14 */
static int hf_lte_rrc_SPS_ConfigSL_ToReleaseList_r14_item;  /* SPS_ConfigIndex_r14 */
static int hf_lte_rrc_semiPersistSchedC_RNTI_r15;  /* C_RNTI */
static int hf_lte_rrc_sps_ConfigDL_r15;           /* SPS_ConfigDL */
static int hf_lte_rrc_sps_ConfigUL_STTI_ToAddModList_r15;  /* SPS_ConfigUL_STTI_ToAddModList_r15 */
static int hf_lte_rrc_sps_ConfigUL_STTI_ToReleaseList_r15;  /* SPS_ConfigUL_STTI_ToReleaseList_r15 */
static int hf_lte_rrc_sps_ConfigUL_ToAddModList_r15;  /* SPS_ConfigUL_ToAddModList_r15 */
static int hf_lte_rrc_sps_ConfigUL_ToReleaseList_r15;  /* SPS_ConfigUL_ToReleaseList_r15 */
static int hf_lte_rrc_sps_ConfigDL_STTI_r15;      /* SPS_ConfigDL_STTI_r15 */
static int hf_lte_rrc_SPS_ConfigUL_STTI_ToAddModList_r15_item;  /* SPS_ConfigUL_STTI_r15 */
static int hf_lte_rrc_SPS_ConfigUL_STTI_ToReleaseList_r15_item;  /* SPS_ConfigIndex_r15 */
static int hf_lte_rrc_SPS_ConfigUL_ToAddModList_r15_item;  /* SPS_ConfigUL */
static int hf_lte_rrc_SPS_ConfigUL_ToReleaseList_r15_item;  /* SPS_ConfigIndex_r15 */
static int hf_lte_rrc_sPS_ConfigDL_setup;         /* T_sPS_ConfigDL_setup */
static int hf_lte_rrc_semiPersistSchedIntervalDL;  /* T_semiPersistSchedIntervalDL */
static int hf_lte_rrc_numberOfConfSPS_Processes;  /* INTEGER_1_8 */
static int hf_lte_rrc_n1PUCCH_AN_PersistentList;  /* N1PUCCH_AN_PersistentList */
static int hf_lte_rrc_twoAntennaPortActivated_r10;  /* T_twoAntennaPortActivated_r10 */
static int hf_lte_rrc_sPS_ConfigDL_setup_eag_1_twoAntennaPortActivated_r10_setup;  /* T_sPS_ConfigDL_setup_eag_1_twoAntennaPortActivated_r10_setup */
static int hf_lte_rrc_n1PUCCH_AN_PersistentListP1_r10;  /* N1PUCCH_AN_PersistentList */
static int hf_lte_rrc_sPS_ConfigUL_setup;         /* T_sPS_ConfigUL_setup */
static int hf_lte_rrc_semiPersistSchedIntervalUL;  /* T_semiPersistSchedIntervalUL */
static int hf_lte_rrc_implicitReleaseAfter;       /* T_implicitReleaseAfter */
static int hf_lte_rrc_p0_Persistent;              /* T_p0_Persistent */
static int hf_lte_rrc_p0_NominalPUSCH_Persistent;  /* INTEGER_M126_24 */
static int hf_lte_rrc_p0_UE_PUSCH_Persistent;     /* INTEGER_M8_7 */
static int hf_lte_rrc_twoIntervalsConfig;         /* T_twoIntervalsConfig */
static int hf_lte_rrc_p0_PersistentSubframeSet2_r12;  /* T_p0_PersistentSubframeSet2_r12 */
static int hf_lte_rrc_sPS_ConfigUL_setup_eag_1_p0_PersistentSubframeSet2_r12_setup;  /* T_sPS_ConfigUL_setup_eag_1_p0_PersistentSubframeSet2_r12_setup */
static int hf_lte_rrc_p0_NominalPUSCH_PersistentSubframeSet2_r12;  /* INTEGER_M126_24 */
static int hf_lte_rrc_p0_UE_PUSCH_PersistentSubframeSet2_r12;  /* INTEGER_M8_7 */
static int hf_lte_rrc_numberOfConfUlSPS_Processes_r13;  /* INTEGER_1_8 */
static int hf_lte_rrc_fixedRV_NonAdaptive_r14;    /* T_fixedRV_NonAdaptive_r14 */
static int hf_lte_rrc_sps_ConfigIndex_r14;        /* SPS_ConfigIndex_r14 */
static int hf_lte_rrc_semiPersistSchedIntervalUL_v1430;  /* T_semiPersistSchedIntervalUL_v1430 */
static int hf_lte_rrc_cyclicShiftSPS_r15;         /* T_cyclicShiftSPS_r15 */
static int hf_lte_rrc_harq_ProcID_Offset_r15;     /* INTEGER_0_7 */
static int hf_lte_rrc_rv_SPS_UL_Repetitions_r15;  /* T_rv_SPS_UL_Repetitions_r15 */
static int hf_lte_rrc_tpc_PDCCH_ConfigPUSCH_SPS_r15;  /* TPC_PDCCH_Config */
static int hf_lte_rrc_totalNumberPUSCH_SPS_UL_Repetitions_r15;  /* T_totalNumberPUSCH_SPS_UL_Repetitions_r15 */
static int hf_lte_rrc_sps_ConfigIndex_r15;        /* SPS_ConfigIndex_r15 */
static int hf_lte_rrc_semiPersistSchedIntervalSL_r14;  /* T_semiPersistSchedIntervalSL_r14 */
static int hf_lte_rrc_N1PUCCH_AN_PersistentList_item;  /* INTEGER_0_2047 */
static int hf_lte_rrc_N1SPUCCH_AN_PersistentList_r15_item;  /* INTEGER_0_2047 */
static int hf_lte_rrc_sPS_ConfigDL_STTI_r15_setup;  /* T_sPS_ConfigDL_STTI_r15_setup */
static int hf_lte_rrc_semiPersistSchedIntervalDL_STTI_r15;  /* T_semiPersistSchedIntervalDL_STTI_r15 */
static int hf_lte_rrc_numberOfConfSPS_Processes_STTI_r15;  /* INTEGER_1_12 */
static int hf_lte_rrc_twoAntennaPortActivated_r15;  /* T_twoAntennaPortActivated_r15 */
static int hf_lte_rrc_sPS_ConfigDL_STTI_r15_setup_twoAntennaPortActivated_r15_setup;  /* T_sPS_ConfigDL_STTI_r15_setup_twoAntennaPortActivated_r15_setup */
static int hf_lte_rrc_n1SPUCCH_AN_PersistentListP1_r15;  /* N1SPUCCH_AN_PersistentList_r15 */
static int hf_lte_rrc_sTTI_StartTimeDL_r15;       /* INTEGER_0_5 */
static int hf_lte_rrc_tpc_PDCCH_ConfigPUCCH_SPS_r15;  /* TPC_PDCCH_Config */
static int hf_lte_rrc_sPS_ConfigUL_STTI_r15_setup;  /* T_sPS_ConfigUL_STTI_r15_setup */
static int hf_lte_rrc_semiPersistSchedIntervalUL_STTI_r15;  /* T_semiPersistSchedIntervalUL_STTI_r15 */
static int hf_lte_rrc_implicitReleaseAfter_01;    /* T_implicitReleaseAfter_01 */
static int hf_lte_rrc_p0_Persistent_r15;          /* T_p0_Persistent_r15 */
static int hf_lte_rrc_p0_NominalSPUSCH_Persistent_r15;  /* INTEGER_M126_24 */
static int hf_lte_rrc_p0_UE_SPUSCH_Persistent_r15;  /* INTEGER_M8_7 */
static int hf_lte_rrc_twoIntervalsConfig_r15;     /* T_twoIntervalsConfig_r15 */
static int hf_lte_rrc_p0_PersistentSubframeSet2_r15;  /* T_p0_PersistentSubframeSet2_r15 */
static int hf_lte_rrc_sPS_ConfigUL_STTI_r15_setup_p0_PersistentSubframeSet2_r15_setup;  /* T_sPS_ConfigUL_STTI_r15_setup_p0_PersistentSubframeSet2_r15_setup */
static int hf_lte_rrc_p0_NominalSPUSCH_PersistentSubframeSet2_r15;  /* INTEGER_M126_24 */
static int hf_lte_rrc_p0_UE_SPUSCH_PersistentSubframeSet2_r15;  /* INTEGER_M8_7 */
static int hf_lte_rrc_numberOfConfUL_SPS_Processes_STTI_r15;  /* INTEGER_1_12 */
static int hf_lte_rrc_sTTI_StartTimeUL_r15;       /* INTEGER_0_5 */
static int hf_lte_rrc_cyclicShiftSPS_sTTI_r15;    /* T_cyclicShiftSPS_sTTI_r15 */
static int hf_lte_rrc_ifdma_Config_SPS_r15;       /* BOOLEAN */
static int hf_lte_rrc_harq_ProcID_offset_r15;     /* INTEGER_0_15 */
static int hf_lte_rrc_rv_SPS_STTI_UL_Repetitions_r15;  /* T_rv_SPS_STTI_UL_Repetitions_r15 */
static int hf_lte_rrc_tbs_scalingFactorSubslotSPS_UL_Repetitions_r15;  /* T_tbs_scalingFactorSubslotSPS_UL_Repetitions_r15 */
static int hf_lte_rrc_totalNumberPUSCH_SPS_STTI_UL_Repetitions_r15;  /* T_totalNumberPUSCH_SPS_STTI_UL_Repetitions_r15 */
static int hf_lte_rrc_sPUCCH_Config_r15_setup;    /* T_sPUCCH_Config_r15_setup */
static int hf_lte_rrc_spucch_Set_r15;             /* SPUCCH_Set_r15 */
static int hf_lte_rrc_twoAntennaPortActivatedSPUCCH_Format1a1b_r15;  /* T_twoAntennaPortActivatedSPUCCH_Format1a1b_r15 */
static int hf_lte_rrc_sPUCCH_Config_r15_setup_dummy;  /* T_sPUCCH_Config_r15_setup_dummy */
static int hf_lte_rrc_n3SPUCCH_AN_List_r15;       /* T_n3SPUCCH_AN_List_r15 */
static int hf_lte_rrc_n3SPUCCH_AN_List_r15_item;  /* INTEGER_0_549 */
static int hf_lte_rrc_sPUCCH_Config_v1550_setup;  /* T_sPUCCH_Config_v1550_setup */
static int hf_lte_rrc_twoAntennaPortActivatedSPUCCH_Format3_v1550;  /* T_twoAntennaPortActivatedSPUCCH_Format3_v1550 */
static int hf_lte_rrc_n3SPUCCH_AN_List_v1550;     /* T_n3SPUCCH_AN_List_v1550 */
static int hf_lte_rrc_n3SPUCCH_AN_List_v1550_item;  /* INTEGER_0_549 */
static int hf_lte_rrc_SPUCCH_Set_r15_item;        /* SPUCCH_Elements_r15 */
static int hf_lte_rrc_sPUCCH_Elements_r15_setup;  /* T_sPUCCH_Elements_r15_setup */
static int hf_lte_rrc_n1SubslotSPUCCH_AN_List_r15;  /* T_n1SubslotSPUCCH_AN_List_r15 */
static int hf_lte_rrc_n1SubslotSPUCCH_AN_List_r15_item;  /* INTEGER_0_1319 */
static int hf_lte_rrc_n1SlotSPUCCH_FH_AN_List_r15;  /* INTEGER_0_1319 */
static int hf_lte_rrc_n1SlotSPUCCH_NoFH_AN_List_r15;  /* INTEGER_0_3959 */
static int hf_lte_rrc_n3SPUCCH_AN_List_r15_01;    /* INTEGER_0_549 */
static int hf_lte_rrc_n4SPUCCHSlot_Resource_r15;  /* SEQUENCE_SIZE_1_2_OF_N4SPUCCH_Resource_r15 */
static int hf_lte_rrc_n4SPUCCHSlot_Resource_r15_item;  /* N4SPUCCH_Resource_r15 */
static int hf_lte_rrc_n4SPUCCHSubslot_Resource_r15;  /* SEQUENCE_SIZE_1_2_OF_N4SPUCCH_Resource_r15 */
static int hf_lte_rrc_n4SPUCCHSubslot_Resource_r15_item;  /* N4SPUCCH_Resource_r15 */
static int hf_lte_rrc_n4maxCoderateSlotPUCCH_r15;  /* INTEGER_0_7 */
static int hf_lte_rrc_n4maxCoderateSubslotPUCCH_r15;  /* INTEGER_0_7 */
static int hf_lte_rrc_n4maxCoderateMultiResourceSlotPUCCH_r15;  /* INTEGER_0_7 */
static int hf_lte_rrc_n4maxCoderateMultiResourceSubslotPUCCH_r15;  /* INTEGER_0_7 */
static int hf_lte_rrc_n4startingPRB_r15;          /* INTEGER_0_109 */
static int hf_lte_rrc_n4numberOfPRB_r15;          /* INTEGER_0_7 */
static int hf_lte_rrc_sRS_TPC_PDCCH_Config_r14_setup;  /* T_sRS_TPC_PDCCH_Config_r14_setup */
static int hf_lte_rrc_srs_TPC_RNTI_r14;           /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_startingBitOfFormat3B_r14;  /* INTEGER_0_31 */
static int hf_lte_rrc_fieldTypeFormat3B_r14;      /* INTEGER_1_4 */
static int hf_lte_rrc_srs_CC_SetIndexlist_r14;    /* SEQUENCE_SIZE_1_4_OF_SRS_CC_SetIndex_r14 */
static int hf_lte_rrc_srs_CC_SetIndexlist_r14_item;  /* SRS_CC_SetIndex_r14 */
static int hf_lte_rrc_cc_SetIndex_r14;            /* INTEGER_0_3 */
static int hf_lte_rrc_cc_IndexInOneCC_Set_r14;    /* INTEGER_0_7 */
static int hf_lte_rrc_subframeAssignment;         /* T_subframeAssignment */
static int hf_lte_rrc_specialSubframePatterns;    /* T_specialSubframePatterns */
static int hf_lte_rrc_specialSubframePatterns_v1130;  /* T_specialSubframePatterns_v1130 */
static int hf_lte_rrc_specialSubframePatterns_v1430;  /* T_specialSubframePatterns_v1430 */
static int hf_lte_rrc_specialSubframePatterns_v1450;  /* T_specialSubframePatterns_v1450 */
static int hf_lte_rrc_subframeAssignmentSL_r12;   /* T_subframeAssignmentSL_r12 */
static int hf_lte_rrc_tDM_PatternConfig_r15_setup;  /* T_tDM_PatternConfig_r15_setup */
static int hf_lte_rrc_time_r15;                   /* ReferenceTime_r15 */
static int hf_lte_rrc_uncertainty_r15;            /* INTEGER_0_12 */
static int hf_lte_rrc_timeInfoType_r15;           /* T_timeInfoType_r15 */
static int hf_lte_rrc_referenceSFN_r15;           /* INTEGER_0_1023 */
static int hf_lte_rrc_refDays_r15;                /* INTEGER_0_72999 */
static int hf_lte_rrc_refSeconds_r15;             /* INTEGER_0_86399 */
static int hf_lte_rrc_refMilliSeconds_r15;        /* INTEGER_0_999 */
static int hf_lte_rrc_refQuarterMicroSeconds_r15;  /* INTEGER_0_3999 */
static int hf_lte_rrc_tPC_PDCCH_Config_setup;     /* T_tPC_PDCCH_Config_setup */
static int hf_lte_rrc_tpc_RNTI;                   /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_tpc_Index;                  /* TPC_Index */
static int hf_lte_rrc_tPC_PDCCH_ConfigSCell_r13_setup;  /* T_tPC_PDCCH_ConfigSCell_r13_setup */
static int hf_lte_rrc_tpc_Index_PUCCH_SCell_r13;  /* TPC_Index */
static int hf_lte_rrc_indexOfFormat3;             /* INTEGER_1_15 */
static int hf_lte_rrc_indexOfFormat3A;            /* INTEGER_1_31 */
static int hf_lte_rrc_ip_Address_r13;             /* IP_Address_r13 */
static int hf_lte_rrc_ike_Identity_r13;           /* IKE_Identity_r13 */
static int hf_lte_rrc_lwip_Counter_r13;           /* INTEGER_0_65535 */
static int hf_lte_rrc_idI_r13;                    /* OCTET_STRING */
static int hf_lte_rrc_ipv4_r13;                   /* T_ipv4_r13 */
static int hf_lte_rrc_ipv6_r13;                   /* T_ipv6_r13 */
static int hf_lte_rrc_p0_NominalPUSCH;            /* INTEGER_M126_24 */
static int hf_lte_rrc_alpha;                      /* Alpha_r12 */
static int hf_lte_rrc_p0_NominalPUCCH;            /* INTEGER_M127_M96 */
static int hf_lte_rrc_deltaFList_PUCCH;           /* DeltaFList_PUCCH */
static int hf_lte_rrc_deltaPreambleMsg3;          /* INTEGER_M1_6 */
static int hf_lte_rrc_deltaF_PUCCH_Format3_r10;   /* T_deltaF_PUCCH_Format3_r10 */
static int hf_lte_rrc_deltaF_PUCCH_Format1bCS_r10;  /* T_deltaF_PUCCH_Format1bCS_r10 */
static int hf_lte_rrc_deltaF_PUCCH_Format4_r13;   /* T_deltaF_PUCCH_Format4_r13 */
static int hf_lte_rrc_deltaF_PUCCH_Format5_13;    /* T_deltaF_PUCCH_Format5_13 */
static int hf_lte_rrc_deltaFList_SPUCCH_r15;      /* DeltaFList_SPUCCH_r15 */
static int hf_lte_rrc_alphaSRS_Add_r16;           /* Alpha_r12 */
static int hf_lte_rrc_p0_NominalSRS_Add_r16;      /* INTEGER_M126_24 */
static int hf_lte_rrc_deltaF_PUCCH_Format3_r12;   /* T_deltaF_PUCCH_Format3_r12 */
static int hf_lte_rrc_deltaF_PUCCH_Format1bCS_r12;  /* T_deltaF_PUCCH_Format1bCS_r12 */
static int hf_lte_rrc_p0_NominalPUCCH_r12;        /* INTEGER_M127_M96 */
static int hf_lte_rrc_deltaFList_PUCCH_r12;       /* DeltaFList_PUCCH */
static int hf_lte_rrc_p0_NominalPUSCH_r10;        /* INTEGER_M126_24 */
static int hf_lte_rrc_alpha_r10;                  /* Alpha_r12 */
static int hf_lte_rrc_deltaPreambleMsg3_r11;      /* INTEGER_M1_6 */
static int hf_lte_rrc_deltaF_PUCCH_Format3_r12_01;  /* T_deltaF_PUCCH_Format3_r12_01 */
static int hf_lte_rrc_deltaF_PUCCH_Format1bCS_r12_01;  /* T_deltaF_PUCCH_Format1bCS_r12_01 */
static int hf_lte_rrc_deltaF_PUCCH_Format4_r13_01;  /* T_deltaF_PUCCH_Format4_r13_01 */
static int hf_lte_rrc_deltaF_PUCCH_Format5_13_01;  /* T_deltaF_PUCCH_Format5_13_01 */
static int hf_lte_rrc_p0_Nominal_PeriodicSRS_r14;  /* INTEGER_M126_24 */
static int hf_lte_rrc_p0_Nominal_AperiodicSRS_r14;  /* INTEGER_M126_24 */
static int hf_lte_rrc_alpha_SRS_r14;              /* Alpha_r12 */
static int hf_lte_rrc_p0_UE_PUSCH;                /* INTEGER_M8_7 */
static int hf_lte_rrc_deltaMCS_Enabled;           /* T_deltaMCS_Enabled */
static int hf_lte_rrc_accumulationEnabled;        /* BOOLEAN */
static int hf_lte_rrc_p0_UE_PUCCH;                /* INTEGER_M8_7 */
static int hf_lte_rrc_pSRS_Offset;                /* INTEGER_0_15 */
static int hf_lte_rrc_filterCoefficient;          /* FilterCoefficient */
static int hf_lte_rrc_deltaTxD_OffsetListPUCCH_r10;  /* DeltaTxD_OffsetListPUCCH_r10 */
static int hf_lte_rrc_pSRS_OffsetAp_r10;          /* INTEGER_0_15 */
static int hf_lte_rrc_pSRS_Offset_v1130;          /* INTEGER_16_31 */
static int hf_lte_rrc_pSRS_OffsetAp_v1130;        /* INTEGER_16_31 */
static int hf_lte_rrc_deltaTxD_OffsetListPUCCH_v1130;  /* DeltaTxD_OffsetListPUCCH_v1130 */
static int hf_lte_rrc_set2PowerControlParameter;  /* T_set2PowerControlParameter */
static int hf_lte_rrc_uplinkPowerControlDedicated_v1250_set2PowerControlParameter_setup;  /* T_uplinkPowerControlDedicated_v1250_set2PowerControlParameter_setup */
static int hf_lte_rrc_tpc_SubframeSet_r12;        /* BIT_STRING_SIZE_10 */
static int hf_lte_rrc_p0_NominalPUSCH_SubframeSet2_r12;  /* INTEGER_M126_24 */
static int hf_lte_rrc_alpha_SubframeSet2_r12;     /* Alpha_r12 */
static int hf_lte_rrc_p0_UE_PUSCH_SubframeSet2_r12;  /* INTEGER_M8_7 */
static int hf_lte_rrc_alpha_UE_r15;               /* Alpha_r12 */
static int hf_lte_rrc_p0_UE_PUSCH_r15;            /* INTEGER_M16_15 */
static int hf_lte_rrc_accumulationEnabledSTTI_r15;  /* BOOLEAN */
static int hf_lte_rrc_deltaTxD_OffsetListSPUCCH_r15;  /* DeltaTxD_OffsetListSPUCCH_r15 */
static int hf_lte_rrc_uplinkPower_CSIPayload;     /* BOOLEAN */
static int hf_lte_rrc_p0_UE_PeriodicSRS_r14;      /* INTEGER_M8_7 */
static int hf_lte_rrc_p0_UE_AperiodicSRS_r14;     /* INTEGER_M8_7 */
static int hf_lte_rrc_accumulationEnabled_r14;    /* BOOLEAN */
static int hf_lte_rrc_tpc_IndexSRS_Add_r16;       /* TPC_Index */
static int hf_lte_rrc_startingBitOfFormat3B_SRS_Add_r16;  /* INTEGER_0_31 */
static int hf_lte_rrc_fieldTypeFormat3B_SRS_Add_r16;  /* INTEGER_1_2 */
static int hf_lte_rrc_p0_UE_SRS_Add_r16;          /* INTEGER_M16_15 */
static int hf_lte_rrc_accumulationEnabledSRS_Add_r16;  /* BOOLEAN */
static int hf_lte_rrc_p0_UE_PUSCH_r10;            /* INTEGER_M8_7 */
static int hf_lte_rrc_deltaMCS_Enabled_r10;       /* T_deltaMCS_Enabled_r10 */
static int hf_lte_rrc_accumulationEnabled_r10;    /* BOOLEAN */
static int hf_lte_rrc_pSRS_Offset_r10;            /* INTEGER_0_15 */
static int hf_lte_rrc_filterCoefficient_r10;      /* FilterCoefficient */
static int hf_lte_rrc_pathlossReferenceLinking_r10;  /* T_pathlossReferenceLinking_r10 */
static int hf_lte_rrc_deltaF_PUCCH_Format1;       /* T_deltaF_PUCCH_Format1 */
static int hf_lte_rrc_deltaF_PUCCH_Format1b;      /* T_deltaF_PUCCH_Format1b */
static int hf_lte_rrc_deltaF_PUCCH_Format2;       /* T_deltaF_PUCCH_Format2 */
static int hf_lte_rrc_deltaF_PUCCH_Format2a;      /* T_deltaF_PUCCH_Format2a */
static int hf_lte_rrc_deltaF_PUCCH_Format2b;      /* T_deltaF_PUCCH_Format2b */
static int hf_lte_rrc_deltaFList_SPUCCH_r15_setup;  /* T_deltaFList_SPUCCH_r15_setup */
static int hf_lte_rrc_deltaF_slotSPUCCH_Format1_r15;  /* T_deltaF_slotSPUCCH_Format1_r15 */
static int hf_lte_rrc_deltaF_slotSPUCCH_Format1a_r15;  /* T_deltaF_slotSPUCCH_Format1a_r15 */
static int hf_lte_rrc_deltaF_slotSPUCCH_Format1b_r15;  /* T_deltaF_slotSPUCCH_Format1b_r15 */
static int hf_lte_rrc_deltaF_slotSPUCCH_Format3_r15;  /* T_deltaF_slotSPUCCH_Format3_r15 */
static int hf_lte_rrc_deltaF_slotSPUCCH_RM_Format4_r15;  /* T_deltaF_slotSPUCCH_RM_Format4_r15 */
static int hf_lte_rrc_deltaF_slotSPUCCH_TBCC_Format4_r15;  /* T_deltaF_slotSPUCCH_TBCC_Format4_r15 */
static int hf_lte_rrc_deltaF_subslotSPUCCH_Format1and1a_r15;  /* T_deltaF_subslotSPUCCH_Format1and1a_r15 */
static int hf_lte_rrc_deltaF_subslotSPUCCH_Format1b_r15;  /* T_deltaF_subslotSPUCCH_Format1b_r15 */
static int hf_lte_rrc_deltaF_subslotSPUCCH_RM_Format4_r15;  /* T_deltaF_subslotSPUCCH_RM_Format4_r15 */
static int hf_lte_rrc_deltaF_subslotSPUCCH_TBCC_Format4_r15;  /* T_deltaF_subslotSPUCCH_TBCC_Format4_r15 */
static int hf_lte_rrc_deltaTxD_OffsetPUCCH_Format1_r10;  /* T_deltaTxD_OffsetPUCCH_Format1_r10 */
static int hf_lte_rrc_deltaTxD_OffsetPUCCH_Format1a1b_r10;  /* T_deltaTxD_OffsetPUCCH_Format1a1b_r10 */
static int hf_lte_rrc_deltaTxD_OffsetPUCCH_Format22a2b_r10;  /* T_deltaTxD_OffsetPUCCH_Format22a2b_r10 */
static int hf_lte_rrc_deltaTxD_OffsetPUCCH_Format3_r10;  /* T_deltaTxD_OffsetPUCCH_Format3_r10 */
static int hf_lte_rrc_deltaTxD_OffsetPUCCH_Format1bCS_r11;  /* T_deltaTxD_OffsetPUCCH_Format1bCS_r11 */
static int hf_lte_rrc_deltaTxD_OffsetSPUCCH_Format1_r15;  /* T_deltaTxD_OffsetSPUCCH_Format1_r15 */
static int hf_lte_rrc_deltaTxD_OffsetSPUCCH_Format1a_r15;  /* T_deltaTxD_OffsetSPUCCH_Format1a_r15 */
static int hf_lte_rrc_deltaTxD_OffsetSPUCCH_Format1b_r15;  /* T_deltaTxD_OffsetSPUCCH_Format1b_r15 */
static int hf_lte_rrc_deltaTxD_OffsetSPUCCH_Format3_r15;  /* T_deltaTxD_OffsetSPUCCH_Format3_r15 */
static int hf_lte_rrc_WLAN_Id_List_r13_item;      /* WLAN_Identifiers_r12 */
static int hf_lte_rrc_wlan_ToReleaseList_r13;     /* WLAN_Id_List_r13 */
static int hf_lte_rrc_wlan_ToAddList_r13;         /* WLAN_Id_List_r13 */
static int hf_lte_rrc_associationTimer_r13;       /* T_associationTimer_r13 */
static int hf_lte_rrc_successReportRequested_r13;  /* T_successReportRequested_r13 */
static int hf_lte_rrc_wlan_SuspendConfig_r14;     /* WLAN_SuspendConfig_r14 */
static int hf_lte_rrc_maxDurationFactor_r15;      /* T_maxDurationFactor_r15 */
static int hf_lte_rrc_numPOs_r15;                 /* T_numPOs_r15 */
static int hf_lte_rrc_freqLocation_r15_01;        /* T_freqLocation_r15 */
static int hf_lte_rrc_timeOffsetDRX_r15;          /* T_timeOffsetDRX_r15 */
static int hf_lte_rrc_timeOffset_eDRX_Short_r15;  /* T_timeOffset_eDRX_Short_r15 */
static int hf_lte_rrc_timeOffset_eDRX_Long_r15;   /* T_timeOffset_eDRX_Long_r15 */
static int hf_lte_rrc_powerBoost_r15_01;          /* T_powerBoost_r15_01 */
static int hf_lte_rrc_numDRX_CyclesRelaxed_r16_01;  /* T_numDRX_CyclesRelaxed_r16_01 */
static int hf_lte_rrc_cipheringAlgorithm;         /* CipheringAlgorithm_r12 */
static int hf_lte_rrc_integrityProtAlgorithm;     /* T_integrityProtAlgorithm */
static int hf_lte_rrc_arfcn_01;                   /* ARFCN_ValueGERAN */
static int hf_lte_rrc_startingARFCN;              /* ARFCN_ValueGERAN */
static int hf_lte_rrc_followingARFCNs;            /* T_followingARFCNs */
static int hf_lte_rrc_explicitListOfARFCNs;       /* ExplicitListOfARFCNs */
static int hf_lte_rrc_equallySpacedARFCNs;        /* T_equallySpacedARFCNs */
static int hf_lte_rrc_arfcn_Spacing;              /* INTEGER_1_8 */
static int hf_lte_rrc_numberOfFollowingARFCNs;    /* INTEGER_0_31 */
static int hf_lte_rrc_variableBitMapOfARFCNs;     /* OCTET_STRING_SIZE_1_16 */
static int hf_lte_rrc_ExplicitListOfARFCNs_item;  /* ARFCN_ValueGERAN */
static int hf_lte_rrc_CarrierFreqListMBMS_r11_item;  /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_plmn_Identity_r16;          /* PLMN_Identity */
static int hf_lte_rrc_cellIdentity_r16;           /* CellIdentityNR_r15 */
static int hf_lte_rrc_trackingAreaCode_r16;       /* TrackingAreaCodeNR_r15 */
static int hf_lte_rrc_CellIndexList_item;         /* CellIndex */
static int hf_lte_rrc_q_RxLevMinCE_r13;           /* Q_RxLevMin */
static int hf_lte_rrc_q_QualMinRSRQ_CE_r13;       /* Q_QualMin_r9 */
static int hf_lte_rrc_powerClass14dBm_Offset_r15;  /* T_powerClass14dBm_Offset_r15 */
static int hf_lte_rrc_q_RxLevMinCE1_r13;          /* Q_RxLevMin */
static int hf_lte_rrc_q_QualMinRSRQ_CE1_r13;      /* Q_QualMin_r9 */
static int hf_lte_rrc_delta_RxLevMinCE1_v1360;    /* INTEGER_M8_M1 */
static int hf_lte_rrc_sid;                        /* BIT_STRING_SIZE_15 */
static int hf_lte_rrc_nid;                        /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_multipleSID;                /* BOOLEAN */
static int hf_lte_rrc_multipleNID;                /* BOOLEAN */
static int hf_lte_rrc_homeReg;                    /* BOOLEAN */
static int hf_lte_rrc_foreignSIDReg;              /* BOOLEAN */
static int hf_lte_rrc_foreignNIDReg;              /* BOOLEAN */
static int hf_lte_rrc_parameterReg;               /* BOOLEAN */
static int hf_lte_rrc_powerUpReg;                 /* BOOLEAN */
static int hf_lte_rrc_registrationPeriod;         /* BIT_STRING_SIZE_7 */
static int hf_lte_rrc_registrationZone;           /* BIT_STRING_SIZE_12 */
static int hf_lte_rrc_totalZone;                  /* BIT_STRING_SIZE_3 */
static int hf_lte_rrc_zoneTimer;                  /* BIT_STRING_SIZE_3 */
static int hf_lte_rrc_powerDownReg_r9;            /* T_powerDownReg_r9 */
static int hf_lte_rrc_cellIdentity_01;            /* BIT_STRING_SIZE_28 */
static int hf_lte_rrc_locationAreaCode;           /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_cellIdentity_02;            /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_cellGlobalId1XRTT;          /* BIT_STRING_SIZE_47 */
static int hf_lte_rrc_cellGlobalIdHRPD;           /* BIT_STRING_SIZE_128 */
static int hf_lte_rrc_q_Hyst_r13;                 /* T_q_Hyst_r13 */
static int hf_lte_rrc_q_RxLevMinReselection_r13;  /* Q_RxLevMin */
static int hf_lte_rrc_t_ReselectionEUTRA_r13;     /* T_Reselection */
static int hf_lte_rrc_condReconfigurationToAddModList_r16;  /* CondReconfigurationToAddModList_r16 */
static int hf_lte_rrc_condReconfigurationToRemoveList_r16;  /* CondReconfigurationToRemoveList_r16 */
static int hf_lte_rrc_attemptCondReconf_r16;      /* T_attemptCondReconf_r16 */
static int hf_lte_rrc_CondReconfigurationToRemoveList_r16_item;  /* CondReconfigurationId_r16 */
static int hf_lte_rrc_CondReconfigurationToAddModList_r16_item;  /* CondReconfigurationAddMod_r16 */
static int hf_lte_rrc_condReconfigurationId_r16;  /* CondReconfigurationId_r16 */
static int hf_lte_rrc_triggerCondition_r16;       /* SEQUENCE_SIZE_1_2_OF_MeasId */
static int hf_lte_rrc_triggerCondition_r16_item;  /* MeasId */
static int hf_lte_rrc_condReconfigurationToApply_r16;  /* T_condReconfigurationToApply_r16 */
static int hf_lte_rrc_triggerConditionSN_r17;     /* T_triggerConditionSN_r17 */
static int hf_lte_rrc_semiMajorAxis_r17;          /* INTEGER_0_8589934591 */
static int hf_lte_rrc_eccentricity_r17;           /* INTEGER_0_1048575 */
static int hf_lte_rrc_periapsis_r17;              /* INTEGER_0_268435455 */
static int hf_lte_rrc_longitude_r17_01;           /* INTEGER_0_268435455 */
static int hf_lte_rrc_inclination_r17;            /* INTEGER_M67108864_67108863 */
static int hf_lte_rrc_anomaly_r17;                /* INTEGER_0_268435455 */
static int hf_lte_rrc_positionX_r17;              /* PositionStateVector_r17 */
static int hf_lte_rrc_positionY_r17;              /* PositionStateVector_r17 */
static int hf_lte_rrc_positionZ_r17;              /* PositionStateVector_r17 */
static int hf_lte_rrc_velocityVX_r17;             /* VelocityStateVector_r17 */
static int hf_lte_rrc_velocityVY_r17;             /* VelocityStateVector_r17 */
static int hf_lte_rrc_velocityVZ_r17;             /* VelocityStateVector_r17 */
static int hf_lte_rrc_targetPhysCellId;           /* PhysCellId */
static int hf_lte_rrc_carrierFreq_03;             /* CarrierFreqEUTRA */
static int hf_lte_rrc_carrierBandwidth;           /* CarrierBandwidthEUTRA */
static int hf_lte_rrc_t304_01;                    /* T_t304_01 */
static int hf_lte_rrc_newUE_Identity;             /* C_RNTI */
static int hf_lte_rrc_radioResourceConfigCommon_01;  /* RadioResourceConfigCommon */
static int hf_lte_rrc_rach_ConfigDedicated;       /* RACH_ConfigDedicated */
static int hf_lte_rrc_carrierFreq_v9e0_01;        /* CarrierFreqEUTRA_v9e0 */
static int hf_lte_rrc_drb_ContinueROHC_r11;       /* T_drb_ContinueROHC_r11 */
static int hf_lte_rrc_mobilityControlInfoV2X_r14;  /* MobilityControlInfoV2X_r14 */
static int hf_lte_rrc_handoverWithoutWT_Change_r14;  /* T_handoverWithoutWT_Change_r14 */
static int hf_lte_rrc_makeBeforeBreak_r14;        /* T_makeBeforeBreak_r14 */
static int hf_lte_rrc_rach_Skip_r14;              /* RACH_Skip_r14 */
static int hf_lte_rrc_sameSFN_Indication_r14;     /* T_sameSFN_Indication_r14 */
static int hf_lte_rrc_mib_RepetitionStatus_r14;   /* BOOLEAN */
static int hf_lte_rrc_schedulingInfoSIB1_BR_r14;  /* INTEGER_0_31 */
static int hf_lte_rrc_daps_Config_r16;            /* DAPS_Config_r16 */
static int hf_lte_rrc_gnss_PositionFixDurationReporting_r18_01;  /* T_gnss_PositionFixDurationReporting_r18_01 */
static int hf_lte_rrc_t307_r12;                   /* T_t307_r12 */
static int hf_lte_rrc_ue_IdentitySCG_r12;         /* C_RNTI */
static int hf_lte_rrc_rach_ConfigDedicated_r12;   /* RACH_ConfigDedicated */
static int hf_lte_rrc_cipheringAlgorithmSCG_r12;  /* CipheringAlgorithm_r12 */
static int hf_lte_rrc_makeBeforeBreakSCG_r14;     /* T_makeBeforeBreakSCG_r14 */
static int hf_lte_rrc_rach_SkipSCG_r14;           /* RACH_Skip_r14 */
static int hf_lte_rrc_v2x_CommSyncConfig_r14;     /* SL_SyncConfigListV2X_r14 */
static int hf_lte_rrc_cbr_MobilityTxConfigList_r14;  /* SL_CBR_CommonTxConfigList_r14 */
static int hf_lte_rrc_dl_Bandwidth_01;            /* T_dl_Bandwidth_01 */
static int hf_lte_rrc_ul_Bandwidth_01;            /* T_ul_Bandwidth_01 */
static int hf_lte_rrc_dl_CarrierFreq_v9e0_01;     /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_ul_CarrierFreq_v9e0_01;     /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_p_DAPS_Source_r16;          /* INTEGER_1_16 */
static int hf_lte_rrc_p_DAPS_Target_r16;          /* INTEGER_1_16 */
static int hf_lte_rrc_powerControlMode_r16;       /* INTEGER_1_2 */
static int hf_lte_rrc_targetTA_r14;               /* T_targetTA_r14 */
static int hf_lte_rrc_ta0_r14;                    /* NULL */
static int hf_lte_rrc_mcg_PTAG_r14;               /* NULL */
static int hf_lte_rrc_scg_PTAG_r14;               /* NULL */
static int hf_lte_rrc_mcg_STAG_r14;               /* STAG_Id_r11 */
static int hf_lte_rrc_scg_STAG_r14;               /* STAG_Id_r11 */
static int hf_lte_rrc_ul_ConfigInfo_r14;          /* T_ul_ConfigInfo_r14 */
static int hf_lte_rrc_numberOfConfUL_Processes_r14;  /* INTEGER_1_8 */
static int hf_lte_rrc_ul_SchedInterval_r14;       /* T_ul_SchedInterval_r14 */
static int hf_lte_rrc_ul_StartSubframe_r14;       /* INTEGER_0_9 */
static int hf_lte_rrc_ul_Grant_r14;               /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_t_Evaluation;               /* T_t_Evaluation */
static int hf_lte_rrc_t_HystNormal;               /* T_t_HystNormal */
static int hf_lte_rrc_n_CellChangeMedium;         /* INTEGER_1_16 */
static int hf_lte_rrc_n_CellChangeHigh;           /* INTEGER_1_16 */
static int hf_lte_rrc_MultiBandInfoList_item;     /* FreqBandIndicator */
static int hf_lte_rrc_MultiBandInfoList_v9e0_item;  /* MultiBandInfo_v9e0 */
static int hf_lte_rrc_MultiBandInfoList_v10j0_item;  /* NS_PmaxList_r10 */
static int hf_lte_rrc_MultiBandInfoList_v10l0_item;  /* NS_PmaxList_v10l0 */
static int hf_lte_rrc_MultiBandInfoList_r11_item;  /* FreqBandIndicator_r11 */
static int hf_lte_rrc_MultiBandInfoListAerial_r18_item;  /* MultiBandInfoAerial_r18 */
static int hf_lte_rrc_ns_PmaxListAerial_r18;      /* NS_PmaxListAerial_r18 */
static int hf_lte_rrc_MultiFrequencyBandListNR_r15_item;  /* FreqBandIndicatorNR_r15 */
static int hf_lte_rrc_NS_PmaxList_r10_item;       /* NS_PmaxValue_r10 */
static int hf_lte_rrc_NS_PmaxList_v10l0_item;     /* NS_PmaxValue_v10l0 */
static int hf_lte_rrc_NS_PmaxListAerial_r18_item;  /* NS_PmaxValueAerial_r18 */
static int hf_lte_rrc_additionalPmax_r10;         /* P_Max */
static int hf_lte_rrc_additionalPmax_r18;         /* P_Max */
static int hf_lte_rrc_additionalSpectrumEmission_r18;  /* AdditionalSpectrumEmission_r18 */
static int hf_lte_rrc_NS_PmaxListNR_r15_item;     /* NS_PmaxValueNR_r15 */
static int hf_lte_rrc_additionalPmaxNR_r15;       /* P_MaxNR_r15 */
static int hf_lte_rrc_additionalSpectrumEmissionNR_r15;  /* AdditionalSpectrumEmissionNR_r15 */
static int hf_lte_rrc_NS_PmaxListNR_v1760_item;   /* NS_PmaxValueNR_v1760 */
static int hf_lte_rrc_additionalSpectrumEmissionNR_v1760;  /* AdditionalSpectrumEmissionNR_v1760 */
static int hf_lte_rrc_NS_PmaxListNR_Aerial_r18_item;  /* NS_PmaxValueNR_Aerial_r18 */
static int hf_lte_rrc_additionalPmaxNR_r18;       /* P_MaxNR_r15 */
static int hf_lte_rrc_additionalSpectrumEmissionNR_r18;  /* AdditionalSpectrumEmissionNR_r18 */
static int hf_lte_rrc_networkColourCode;          /* BIT_STRING_SIZE_3 */
static int hf_lte_rrc_baseStationColourCode;      /* BIT_STRING_SIZE_3 */
static int hf_lte_rrc_start_01;                   /* PhysCellId */
static int hf_lte_rrc_range;                      /* T_range */
static int hf_lte_rrc_start_02;                   /* PhysCellIdNR_r15 */
static int hf_lte_rrc_range_01;                   /* T_range_01 */
static int hf_lte_rrc_PhysCellIdRangeUTRA_FDDList_r9_item;  /* PhysCellIdRangeUTRA_FDD_r9 */
static int hf_lte_rrc_start_r9;                   /* PhysCellIdUTRA_FDD */
static int hf_lte_rrc_range_r9;                   /* INTEGER_2_512 */
static int hf_lte_rrc_mcc;                        /* MCC */
static int hf_lte_rrc_mnc;                        /* MNC */
static int hf_lte_rrc_MCC_item;                   /* MCC_MNC_Digit */
static int hf_lte_rrc_MNC_item;                   /* MCC_MNC_Digit */
static int hf_lte_rrc_PLMN_IdentityList3_r11_item;  /* PLMN_Identity */
static int hf_lte_rrc_preRegistrationAllowed;     /* BOOLEAN */
static int hf_lte_rrc_preRegistrationZoneId;      /* PreRegistrationZoneIdHRPD */
static int hf_lte_rrc_secondaryPreRegistrationZoneIdList;  /* SecondaryPreRegistrationZoneIdListHRPD */
static int hf_lte_rrc_SecondaryPreRegistrationZoneIdListHRPD_item;  /* PreRegistrationZoneIdHRPD */
static int hf_lte_rrc_narrowbandIndex_r16;        /* BIT_STRING_SIZE_1_maxAvailNarrowBands_1_r16 */
static int hf_lte_rrc_timeOffsetGranularity_r16;  /* T_timeOffsetGranularity_r16 */
static int hf_lte_rrc_sf_Medium_01;               /* T_sf_Medium_01 */
static int hf_lte_rrc_sf_High_01;                 /* T_sf_High_01 */
static int hf_lte_rrc_SystemInfoListGERAN_item;   /* SystemInfoListGERAN_item */
static int hf_lte_rrc_cdma_EUTRA_Synchronisation;  /* BOOLEAN */
static int hf_lte_rrc_cdma_SystemTime;            /* T_cdma_SystemTime */
static int hf_lte_rrc_synchronousSystemTime;      /* T_synchronousSystemTime */
static int hf_lte_rrc_asynchronousSystemTime;     /* T_asynchronousSystemTime */
static int hf_lte_rrc_nr_RSRP_r15;                /* RSRP_RangeNR_r15 */
static int hf_lte_rrc_nr_RSRQ_r15;                /* RSRQ_RangeNR_r15 */
static int hf_lte_rrc_nr_SINR_r15;                /* RS_SINR_RangeNR_r15 */
static int hf_lte_rrc_inclination_r17_01;         /* INTEGER_0_2097151 */
static int hf_lte_rrc_argumentPerigee_r17;        /* INTEGER_0_4194303 */
static int hf_lte_rrc_rightAscension_r17;         /* INTEGER_0_4194303 */
static int hf_lte_rrc_meanAnomaly_r17;            /* INTEGER_0_4194303 */
static int hf_lte_rrc_eccentricity_r17_01;        /* INTEGER_0_16777215 */
static int hf_lte_rrc_meanMotion_r17;             /* INTEGER_0_17179869183 */
static int hf_lte_rrc_bStarDecimal_r17;           /* INTEGER_M99999_99999 */
static int hf_lte_rrc_bStarExponent_r17;          /* INTEGER_M9_9 */
static int hf_lte_rrc_epochStar_r17;              /* INTEGER_M1048575_1048575 */
static int hf_lte_rrc_bT_NameListConfig_r15_setup;  /* BT_NameList_r15 */
static int hf_lte_rrc_BT_NameList_r15_item;       /* BT_Name_r15 */
static int hf_lte_rrc_locationCoordinates_r10;    /* T_locationCoordinates_r10 */
static int hf_lte_rrc_ellipsoid_Point_r10;        /* T_ellipsoid_Point_r10 */
static int hf_lte_rrc_ellipsoidPointWithAltitude_r10;  /* T_ellipsoidPointWithAltitude_r10 */
static int hf_lte_rrc_ellipsoidPointWithUncertaintyCircle_r11;  /* T_ellipsoidPointWithUncertaintyCircle_r11 */
static int hf_lte_rrc_ellipsoidPointWithUncertaintyEllipse_r11;  /* T_ellipsoidPointWithUncertaintyEllipse_r11 */
static int hf_lte_rrc_ellipsoidPointWithAltitudeAndUncertaintyEllipsoid_r11;  /* T_ellipsoidPointWithAltitudeAndUncertaintyEllipsoid_r11 */
static int hf_lte_rrc_ellipsoidArc_r11;           /* T_ellipsoidArc_r11 */
static int hf_lte_rrc_polygon_r11;                /* T_polygon_r11 */
static int hf_lte_rrc_horizontalVelocity_r10;     /* T_horizontalVelocity_r10 */
static int hf_lte_rrc_gnss_TOD_msec_r10;          /* T_gnss_TOD_msec_r10 */
static int hf_lte_rrc_verticalVelocityInfo_r15;   /* T_verticalVelocityInfo_r15 */
static int hf_lte_rrc_verticalVelocity_r15;       /* T_verticalVelocity_r15 */
static int hf_lte_rrc_verticalVelocityAndUncertainty_r15;  /* T_verticalVelocityAndUncertainty_r15 */
static int hf_lte_rrc_LogMeasResultListBT_r15_item;  /* LogMeasResultBT_r15 */
static int hf_lte_rrc_bt_Addr_r15;                /* T_bt_Addr_r15 */
static int hf_lte_rrc_rssi_BT_r15;                /* INTEGER_M128_127 */
static int hf_lte_rrc_LogMeasResultListWLAN_r15_item;  /* LogMeasResultWLAN_r15 */
static int hf_lte_rrc_wlan_Identifiers_r15;       /* WLAN_Identifiers_r12 */
static int hf_lte_rrc_rssiWLAN_r15;               /* WLAN_RSSI_Range_r13 */
static int hf_lte_rrc_rtt_WLAN_r15;               /* WLAN_RTT_r15 */
static int hf_lte_rrc_measObjectToRemoveList;     /* MeasObjectToRemoveList */
static int hf_lte_rrc_measObjectToAddModList;     /* MeasObjectToAddModList */
static int hf_lte_rrc_reportConfigToRemoveList;   /* ReportConfigToRemoveList */
static int hf_lte_rrc_reportConfigToAddModList;   /* ReportConfigToAddModList */
static int hf_lte_rrc_measIdToRemoveList;         /* MeasIdToRemoveList */
static int hf_lte_rrc_measIdToAddModList;         /* MeasIdToAddModList */
static int hf_lte_rrc_quantityConfig;             /* QuantityConfig */
static int hf_lte_rrc_measGapConfig;              /* MeasGapConfig */
static int hf_lte_rrc_s_Measure;                  /* S_Measure */
static int hf_lte_rrc_speedStatePars;             /* T_speedStatePars */
static int hf_lte_rrc_measConfig_speedStatePars_setup;  /* T_measConfig_speedStatePars_setup */
static int hf_lte_rrc_timeToTrigger_SF;           /* SpeedStateScaleFactors */
static int hf_lte_rrc_measObjectToAddModList_v9e0;  /* MeasObjectToAddModList_v9e0 */
static int hf_lte_rrc_allowInterruptions_r11;     /* BOOLEAN */
static int hf_lte_rrc_measScaleFactor_r12;        /* T_measScaleFactor_r12 */
static int hf_lte_rrc_measConfig_eag_3_measScaleFactor_r12_setup;  /* MeasScaleFactor_r12 */
static int hf_lte_rrc_measIdToRemoveListExt_r12;  /* MeasIdToRemoveListExt_r12 */
static int hf_lte_rrc_measIdToAddModListExt_r12;  /* MeasIdToAddModListExt_r12 */
static int hf_lte_rrc_measRSRQ_OnAllSymbols_r12;  /* BOOLEAN */
static int hf_lte_rrc_measObjectToRemoveListExt_r13;  /* MeasObjectToRemoveListExt_r13 */
static int hf_lte_rrc_measObjectToAddModListExt_r13;  /* MeasObjectToAddModListExt_r13 */
static int hf_lte_rrc_measIdToAddModList_v1310;   /* MeasIdToAddModList_v1310 */
static int hf_lte_rrc_measIdToAddModListExt_v1310;  /* MeasIdToAddModListExt_v1310 */
static int hf_lte_rrc_measGapConfigPerCC_List_r14;  /* MeasGapConfigPerCC_List_r14 */
static int hf_lte_rrc_measGapSharingConfig_r14;   /* MeasGapSharingConfig_r14 */
static int hf_lte_rrc_fr1_Gap_r15;                /* BOOLEAN */
static int hf_lte_rrc_mgta_r15;                   /* BOOLEAN */
static int hf_lte_rrc_measGapConfigDensePRS_r15;  /* MeasGapConfigDensePRS_r15 */
static int hf_lte_rrc_heightThreshRef_r15;        /* T_heightThreshRef_r15 */
static int hf_lte_rrc_measConfig_eag_7_heightThreshRef_r15_setup;  /* INTEGER_0_31 */
static int hf_lte_rrc_timeMeasConfig_r18;         /* T_timeMeasConfig_r18 */
static int hf_lte_rrc_locationMeasConfig_r18;     /* T_locationMeasConfig_r18 */
static int hf_lte_rrc_MeasIdToRemoveList_item;    /* MeasId */
static int hf_lte_rrc_MeasIdToRemoveListExt_r12_item;  /* MeasId_v1250 */
static int hf_lte_rrc_MeasObjectToRemoveList_item;  /* MeasObjectId */
static int hf_lte_rrc_MeasObjectToRemoveListExt_r13_item;  /* MeasObjectId_v1310 */
static int hf_lte_rrc_ReportConfigToRemoveList_item;  /* ReportConfigId */
static int hf_lte_rrc_measDS_Config_r12_setup;    /* T_measDS_Config_r12_setup */
static int hf_lte_rrc_dmtc_PeriodOffset_r12;      /* T_dmtc_PeriodOffset_r12 */
static int hf_lte_rrc_ms40_r12;                   /* INTEGER_0_39 */
static int hf_lte_rrc_ms80_r12;                   /* INTEGER_0_79 */
static int hf_lte_rrc_ms160_r12;                  /* INTEGER_0_159 */
static int hf_lte_rrc_ds_OccasionDuration_r12;    /* T_ds_OccasionDuration_r12 */
static int hf_lte_rrc_durationFDD_r12;            /* INTEGER_1_maxDS_Duration_r12 */
static int hf_lte_rrc_durationTDD_r12;            /* INTEGER_2_maxDS_Duration_r12 */
static int hf_lte_rrc_measCSI_RS_ToRemoveList_r12;  /* MeasCSI_RS_ToRemoveList_r12 */
static int hf_lte_rrc_measCSI_RS_ToAddModList_r12;  /* MeasCSI_RS_ToAddModList_r12 */
static int hf_lte_rrc_MeasCSI_RS_ToRemoveList_r12_item;  /* MeasCSI_RS_Id_r12 */
static int hf_lte_rrc_MeasCSI_RS_ToAddModList_r12_item;  /* MeasCSI_RS_Config_r12 */
static int hf_lte_rrc_measCSI_RS_Id_r12;          /* MeasCSI_RS_Id_r12 */
static int hf_lte_rrc_physCellId_r12_01;          /* INTEGER_0_503 */
static int hf_lte_rrc_scramblingIdentity_r12;     /* INTEGER_0_503 */
static int hf_lte_rrc_subframeOffset_r12;         /* INTEGER_0_4 */
static int hf_lte_rrc_csi_RS_IndividualOffset_r12;  /* Q_OffsetRange */
static int hf_lte_rrc_measGapConfig_setup;        /* T_measGapConfig_setup */
static int hf_lte_rrc_gapOffset;                  /* T_gapOffset */
static int hf_lte_rrc_gp0;                        /* INTEGER_0_39 */
static int hf_lte_rrc_gp1;                        /* INTEGER_0_79 */
static int hf_lte_rrc_gp2_r14;                    /* INTEGER_0_39 */
static int hf_lte_rrc_gp3_r14;                    /* INTEGER_0_79 */
static int hf_lte_rrc_gp_ncsg0_r14;               /* INTEGER_0_39 */
static int hf_lte_rrc_gp_ncsg1_r14;               /* INTEGER_0_79 */
static int hf_lte_rrc_gp_ncsg2_r14;               /* INTEGER_0_39 */
static int hf_lte_rrc_gp_ncsg3_r14;               /* INTEGER_0_79 */
static int hf_lte_rrc_gp_nonUniform1_r14;         /* INTEGER_0_1279 */
static int hf_lte_rrc_gp_nonUniform2_r14;         /* INTEGER_0_2559 */
static int hf_lte_rrc_gp_nonUniform3_r14;         /* INTEGER_0_5119 */
static int hf_lte_rrc_gp_nonUniform4_r14;         /* INTEGER_0_10239 */
static int hf_lte_rrc_gp4_r15;                    /* INTEGER_0_19 */
static int hf_lte_rrc_gp5_r15;                    /* INTEGER_0_159 */
static int hf_lte_rrc_gp6_r15;                    /* INTEGER_0_19 */
static int hf_lte_rrc_gp7_r15;                    /* INTEGER_0_39 */
static int hf_lte_rrc_gp8_r15;                    /* INTEGER_0_79 */
static int hf_lte_rrc_gp9_r15;                    /* INTEGER_0_159 */
static int hf_lte_rrc_gp10_r15;                   /* INTEGER_0_19 */
static int hf_lte_rrc_gp11_r15;                   /* INTEGER_0_159 */
static int hf_lte_rrc_measGapConfigDensePRS_r15_setup;  /* T_measGapConfigDensePRS_r15_setup */
static int hf_lte_rrc_gapOffsetDensePRS_r15;      /* T_gapOffsetDensePRS_r15 */
static int hf_lte_rrc_measGapConfigPerCC_List_r14_setup;  /* T_measGapConfigPerCC_List_r14_setup */
static int hf_lte_rrc_measGapConfigToRemoveList_r14;  /* MeasGapConfigToRemoveList_r14 */
static int hf_lte_rrc_measGapConfigToAddModList_r14;  /* MeasGapConfigToAddModList_r14 */
static int hf_lte_rrc_MeasGapConfigToRemoveList_r14_item;  /* ServCellIndex_r13 */
static int hf_lte_rrc_MeasGapConfigToAddModList_r14_item;  /* MeasGapConfigPerCC_r14 */
static int hf_lte_rrc_measGapConfigCC_r14;        /* MeasGapConfig */
static int hf_lte_rrc_measGapSharingConfig_r14_setup;  /* T_measGapSharingConfig_r14_setup */
static int hf_lte_rrc_measGapSharingScheme_r14;   /* T_measGapSharingScheme_r14 */
static int hf_lte_rrc_measIdleCarrierListEUTRA_r15;  /* EUTRA_CarrierList_r15 */
static int hf_lte_rrc_measIdleCarrierListNR_r16;  /* NR_CarrierList_r16 */
static int hf_lte_rrc_measIdleDuration_r15;       /* T_measIdleDuration_r15 */
static int hf_lte_rrc_validityAreaList_r16;       /* ValidityAreaList_r16 */
static int hf_lte_rrc_EUTRA_CarrierList_r15_item;  /* MeasIdleCarrierEUTRA_r15 */
static int hf_lte_rrc_NR_CarrierList_r16_item;    /* MeasIdleCarrierNR_r16 */
static int hf_lte_rrc_carrierFreq_r15_01;         /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_allowedMeasBandwidth_r15;   /* AllowedMeasBandwidth */
static int hf_lte_rrc_validityArea_r15;           /* CellList_r15 */
static int hf_lte_rrc_measCellList_r15;           /* CellList_r15 */
static int hf_lte_rrc_reportQuantities;           /* T_reportQuantities */
static int hf_lte_rrc_qualityThreshold_r15;       /* T_qualityThreshold_r15 */
static int hf_lte_rrc_idleRSRP_Threshold_r15;     /* RSRP_Range */
static int hf_lte_rrc_idleRSRQ_Threshold_r15;     /* RSRQ_Range_r13 */
static int hf_lte_rrc_ValidityAreaList_r16_item;  /* ValidityArea_r16 */
static int hf_lte_rrc_validityCellList_r16;       /* ValidityCellList_r16 */
static int hf_lte_rrc_ValidityCellList_r16_item;  /* PhysCellIdRange */
static int hf_lte_rrc_subcarrierSpacingSSB_r16;   /* T_subcarrierSpacingSSB_r16 */
static int hf_lte_rrc_frequencyBandList;          /* MultiFrequencyBandListNR_r15 */
static int hf_lte_rrc_measCellListNR_r16;         /* CellListNR_r16 */
static int hf_lte_rrc_reportQuantitiesNR_r16;     /* T_reportQuantitiesNR_r16 */
static int hf_lte_rrc_qualityThresholdNR_r16;     /* T_qualityThresholdNR_r16 */
static int hf_lte_rrc_idleRSRP_ThresholdNR_r16;   /* RSRP_RangeNR_r15 */
static int hf_lte_rrc_idleRSRQ_ThresholdNR_r16;   /* RSRQ_RangeNR_r15 */
static int hf_lte_rrc_ssb_MeasConfig_r16;         /* T_ssb_MeasConfig_r16 */
static int hf_lte_rrc_maxRS_IndexCellQual_r16;    /* MaxRS_IndexCellQualNR_r15 */
static int hf_lte_rrc_threshRS_Index_r16;         /* ThresholdListNR_r15 */
static int hf_lte_rrc_measTimingConfig_r16;       /* MTC_SSB_NR_r15 */
static int hf_lte_rrc_ssb_ToMeasure_r16;          /* SSB_ToMeasure_r15 */
static int hf_lte_rrc_deriveSSB_IndexFromCell_r16;  /* BOOLEAN */
static int hf_lte_rrc_ss_RSSI_Measurement_r16;    /* SS_RSSI_Measurement_r15 */
static int hf_lte_rrc_beamMeasConfigIdle_r16;     /* BeamMeasConfigIdleNR_r16 */
static int hf_lte_rrc_subcarrierSpacingSSB_r17_02;  /* T_subcarrierSpacingSSB_r17_02 */
static int hf_lte_rrc_CellList_r15_item;          /* PhysCellIdRange */
static int hf_lte_rrc_CellListNR_r16_item;        /* PhysCellIdRangeNR_r16 */
static int hf_lte_rrc_reportQuantityRS_IndexNR_r16;  /* T_reportQuantityRS_IndexNR_r16 */
static int hf_lte_rrc_maxReportRS_Index_r16;      /* INTEGER_0_maxRS_IndexReport_r15 */
static int hf_lte_rrc_reportRS_IndexResultsNR_r16;  /* BOOLEAN */
static int hf_lte_rrc_MeasIdToAddModList_item;    /* MeasIdToAddMod */
static int hf_lte_rrc_MeasIdToAddModList_v1310_item;  /* MeasIdToAddMod_v1310 */
static int hf_lte_rrc_MeasIdToAddModListExt_r12_item;  /* MeasIdToAddModExt_r12 */
static int hf_lte_rrc_MeasIdToAddModListExt_v1310_item;  /* MeasIdToAddMod_v1310 */
static int hf_lte_rrc_measId;                     /* MeasId */
static int hf_lte_rrc_measObjectId;               /* MeasObjectId */
static int hf_lte_rrc_reportConfigId;             /* ReportConfigId */
static int hf_lte_rrc_measId_v1250;               /* MeasId_v1250 */
static int hf_lte_rrc_measObjectId_r12;           /* MeasObjectId */
static int hf_lte_rrc_reportConfigId_r12;         /* ReportConfigId */
static int hf_lte_rrc_measObjectId_v1310;         /* MeasObjectId_v1310 */
static int hf_lte_rrc_carrierFreq_04;             /* CarrierFreqCDMA2000 */
static int hf_lte_rrc_offsetFreq;                 /* Q_OffsetRangeInterRAT */
static int hf_lte_rrc_cellsToRemoveList;          /* CellIndexList */
static int hf_lte_rrc_cellsToAddModList;          /* CellsToAddModListCDMA2000 */
static int hf_lte_rrc_cellForWhichToReportCGI;    /* PhysCellIdCDMA2000 */
static int hf_lte_rrc_CellsToAddModListCDMA2000_item;  /* CellsToAddModCDMA2000 */
static int hf_lte_rrc_cellIndex;                  /* INTEGER_1_maxCellMeas */
static int hf_lte_rrc_physCellId_02;              /* PhysCellIdCDMA2000 */
static int hf_lte_rrc_measObjectEUTRA_offsetFreq;  /* Q_OffsetRange */
static int hf_lte_rrc_cellsToAddModList_01;       /* CellsToAddModList */
static int hf_lte_rrc_excludedCellsToRemoveList;  /* CellIndexList */
static int hf_lte_rrc_excludedCellsToAddModList;  /* ExcludedCellsToAddModList */
static int hf_lte_rrc_cellForWhichToReportCGI_01;  /* PhysCellId */
static int hf_lte_rrc_measCycleSCell_r10;         /* MeasCycleSCell_r10 */
static int hf_lte_rrc_measSubframePatternConfigNeigh_r10;  /* MeasSubframePatternConfigNeigh_r10 */
static int hf_lte_rrc_widebandRSRQ_Meas_r11;      /* BOOLEAN */
static int hf_lte_rrc_altTTT_CellsToRemoveList_r12;  /* CellIndexList */
static int hf_lte_rrc_altTTT_CellsToAddModList_r12;  /* AltTTT_CellsToAddModList_r12 */
static int hf_lte_rrc_t312_r12;                   /* T_t312_r12 */
static int hf_lte_rrc_measObjectEUTRA_eag_3_t312_r12_setup;  /* T_measObjectEUTRA_eag_3_t312_r12_setup */
static int hf_lte_rrc_measObjectEUTRA_eag_3_reducedMeasPerformance_r12;  /* BOOLEAN */
static int hf_lte_rrc_measDS_Config_r12;          /* MeasDS_Config_r12 */
static int hf_lte_rrc_allowedCellsToRemoveList_r13;  /* CellIndexList */
static int hf_lte_rrc_allowedCellsToAddModList_r13;  /* AllowedCellsToAddModList_r13 */
static int hf_lte_rrc_rmtc_Config_r13;            /* RMTC_Config_r13 */
static int hf_lte_rrc_carrierFreq_r13;            /* ARFCN_ValueEUTRA_v9e0 */
static int hf_lte_rrc_tx_ResourcePoolToRemoveList_r14;  /* Tx_ResourcePoolMeasList_r14 */
static int hf_lte_rrc_tx_ResourcePoolToAddList_r14;  /* Tx_ResourcePoolMeasList_r14 */
static int hf_lte_rrc_fembms_MixedCarrier_r14;    /* BOOLEAN */
static int hf_lte_rrc_measSensing_Config_r15;     /* MeasSensing_Config_r15 */
static int hf_lte_rrc_measRSS_DedicatedConfig_r16;  /* T_measRSS_DedicatedConfig_r16 */
static int hf_lte_rrc_measObjectEUTRA_eag_7_measRSS_DedicatedConfig_r16_setup;  /* MeasRSS_DedicatedConfig_r16 */
static int hf_lte_rrc_cellsToAddModList_v1810;    /* CellsToAddModList_v1810 */
static int hf_lte_rrc_cellsToAddModList_v1610;    /* CellsToAddModList_v1610 */
static int hf_lte_rrc_CellsToAddModList_item;     /* CellsToAddMod */
static int hf_lte_rrc_CellsToAddModList_v1610_item;  /* CellsToAddMod_v1610 */
static int hf_lte_rrc_CellsToAddModList_v1810_item;  /* CellsToAddMod_v1810 */
static int hf_lte_rrc_cellIndividualOffset;       /* Q_OffsetRange */
static int hf_lte_rrc_ephemerisInfo_r18_01;       /* T_ephemerisInfo_r18_01 */
static int hf_lte_rrc_epochTime_r18_01;           /* T_epochTime_r18_01 */
static int hf_lte_rrc_referenceLocation_r18_01;   /* ReferenceLocation_r18 */
static int hf_lte_rrc_ExcludedCellsToAddModList_item;  /* ExcludedCellsToAddMod */
static int hf_lte_rrc_physCellIdRange;            /* PhysCellIdRange */
static int hf_lte_rrc_measSubframePatternConfigNeigh_r10_setup;  /* T_measSubframePatternConfigNeigh_r10_setup */
static int hf_lte_rrc_measSubframePatternNeigh_r10;  /* MeasSubframePattern_r10 */
static int hf_lte_rrc_measSubframeCellList_r10;   /* MeasSubframeCellList_r10 */
static int hf_lte_rrc_MeasSubframeCellList_r10_item;  /* PhysCellIdRange */
static int hf_lte_rrc_AltTTT_CellsToAddModList_r12_item;  /* AltTTT_CellsToAddMod_r12 */
static int hf_lte_rrc_cellIndex_r12;              /* INTEGER_1_maxCellMeas */
static int hf_lte_rrc_physCellIdRange_r12;        /* PhysCellIdRange */
static int hf_lte_rrc_AllowedCellsToAddModList_r13_item;  /* AllowedCellsToAddMod_r13 */
static int hf_lte_rrc_cellIndex_r13;              /* INTEGER_1_maxCellMeas */
static int hf_lte_rrc_physCellIdRange_r13;        /* PhysCellIdRange */
static int hf_lte_rrc_rMTC_Config_r13_setup;      /* T_rMTC_Config_r13_setup */
static int hf_lte_rrc_rmtc_Period_r13;            /* T_rmtc_Period_r13 */
static int hf_lte_rrc_rmtc_SubframeOffset_r13;    /* INTEGER_0_639 */
static int hf_lte_rrc_measDuration_r13;           /* T_measDuration_r13 */
static int hf_lte_rrc_Tx_ResourcePoolMeasList_r14_item;  /* SL_V2X_TxPoolReportIdentity_r14 */
static int hf_lte_rrc_cellForWhichToReportCGI_02;  /* PhysCellIdGERAN */
static int hf_lte_rrc_rs_ConfigSSB_r15;           /* RS_ConfigSSB_NR_r15 */
static int hf_lte_rrc_offsetFreq_r15;             /* Q_OffsetRangeInterRAT */
static int hf_lte_rrc_excludedCellsToRemoveList_r15;  /* CellIndexList */
static int hf_lte_rrc_excludedCellsToAddModList_r15;  /* CellsToAddModListNR_r15 */
static int hf_lte_rrc_quantityConfigSet_r15;      /* INTEGER_1_maxQuantSetsNR_r15 */
static int hf_lte_rrc_cellsForWhichToReportSFTD_r15;  /* SEQUENCE_SIZE_1_maxCellSFTD_OF_PhysCellIdNR_r15 */
static int hf_lte_rrc_cellsForWhichToReportSFTD_r15_item;  /* PhysCellIdNR_r15 */
static int hf_lte_rrc_cellForWhichToReportCGI_r15;  /* PhysCellIdNR_r15 */
static int hf_lte_rrc_bandNR_r15;                 /* T_bandNR_r15 */
static int hf_lte_rrc_measObjectNR_r15_eag_1_bandNR_r15_setup;  /* FreqBandIndicatorNR_r15 */
static int hf_lte_rrc_rmtc_ConfigNR_r16;          /* T_rmtc_ConfigNR_r16 */
static int hf_lte_rrc_measObjectNR_r15_eag_2_rmtc_ConfigNR_r16_setup;  /* RMTC_ConfigNR_r16 */
static int hf_lte_rrc_cellsToRemoveList_r16;      /* CellIndexList */
static int hf_lte_rrc_cellsToAddModList_r16;      /* CellsToAddModListNR_r16 */
static int hf_lte_rrc_subcarrierSpacingSSB_r15_02;  /* T_subcarrierSpacingSSB_r15_02 */
static int hf_lte_rrc_ssb_ToMeasure_r15_01;       /* T_ssb_ToMeasure_r15 */
static int hf_lte_rrc_rS_ConfigSSB_NR_r15_eag_1_ssb_ToMeasure_r15_setup;  /* SSB_ToMeasure_r15 */
static int hf_lte_rrc_ssb_PositionQCL_CellsToAddModListNR_r16;  /* SSB_PositionQCL_CellsToAddModListNR_r16 */
static int hf_lte_rrc_ssb_PositionQCL_CellsToRemoveListNR_r16;  /* SEQUENCE_SIZE_1_maxCellMeas_OF_PhysCellIdNR_r15 */
static int hf_lte_rrc_ssb_PositionQCL_CellsToRemoveListNR_r16_item;  /* PhysCellIdNR_r15 */
static int hf_lte_rrc_subcarrierSpacingSSB_r17_03;  /* T_subcarrierSpacingSSB_r17_03 */
static int hf_lte_rrc_ssb_PositionQCL_CellsToAddModListNR_r17;  /* SSB_PositionQCL_CellsToAddModListNR_r17 */
static int hf_lte_rrc_ssb_PositionQCL_CellsToRemoveListNR_r17;  /* SEQUENCE_SIZE_1_maxCellMeas_OF_PhysCellIdNR_r15 */
static int hf_lte_rrc_ssb_PositionQCL_CellsToRemoveListNR_r17_item;  /* PhysCellIdNR_r15 */
static int hf_lte_rrc_CellsToAddModListNR_r15_item;  /* CellsToAddModNR_r15 */
static int hf_lte_rrc_CellsToAddModListNR_r16_item;  /* CellsToAddModNR_r16 */
static int hf_lte_rrc_cellIndex_r15;              /* INTEGER_1_maxCellMeas */
static int hf_lte_rrc_physCellId_r15_01;          /* PhysCellIdNR_r15 */
static int hf_lte_rrc_cellIndex_r16;              /* INTEGER_1_maxCellMeas */
static int hf_lte_rrc_cellIndividualOffset_r16;   /* Q_OffsetRange */
static int hf_lte_rrc_SSB_PositionQCL_CellsToAddModListNR_r16_item;  /* SSB_PositionQCL_CellsToAddNR_r16 */
static int hf_lte_rrc_ssb_PositionQCL_NR_r16;     /* SSB_PositionQCL_RelationNR_r16 */
static int hf_lte_rrc_rmtc_PeriodicityNR_r16;     /* T_rmtc_PeriodicityNR_r16 */
static int hf_lte_rrc_rmtc_SubframeOffsetNR_r16;  /* INTEGER_0_639 */
static int hf_lte_rrc_measDurationNR_r16;         /* T_measDurationNR_r16 */
static int hf_lte_rrc_rmtc_FrequencyNR_r16;       /* ARFCN_ValueNR_r15 */
static int hf_lte_rrc_refSCS_CP_NR_r16;           /* T_refSCS_CP_NR_r16 */
static int hf_lte_rrc_rmtc_BandwidthNR_r17;       /* T_rmtc_BandwidthNR_r17 */
static int hf_lte_rrc_measDurationNR_r17;         /* T_measDurationNR_r17 */
static int hf_lte_rrc_refSCS_CP_NR_r17;           /* T_refSCS_CP_NR_r17 */
static int hf_lte_rrc_SSB_PositionQCL_CellsToAddModListNR_r17_item;  /* SSB_PositionQCL_CellsToAddNR_r17 */
static int hf_lte_rrc_physCellIdNR_r17;           /* PhysCellIdNR_r15 */
static int hf_lte_rrc_ssb_PositionQCL_NR_r17;     /* SSB_PositionQCL_RelationNR_r17 */
static int hf_lte_rrc_MeasObjectToAddModList_item;  /* MeasObjectToAddMod */
static int hf_lte_rrc_MeasObjectToAddModListExt_r13_item;  /* MeasObjectToAddModExt_r13 */
static int hf_lte_rrc_MeasObjectToAddModList_v9e0_item;  /* MeasObjectToAddMod_v9e0 */
static int hf_lte_rrc_measObject;                 /* T_measObject */
static int hf_lte_rrc_measObjectEUTRA;            /* MeasObjectEUTRA */
static int hf_lte_rrc_measObjectUTRA;             /* MeasObjectUTRA */
static int hf_lte_rrc_measObjectGERAN;            /* MeasObjectGERAN */
static int hf_lte_rrc_measObjectCDMA2000;         /* MeasObjectCDMA2000 */
static int hf_lte_rrc_measObjectWLAN_r13;         /* MeasObjectWLAN_r13 */
static int hf_lte_rrc_measObjectNR_r15;           /* MeasObjectNR_r15 */
static int hf_lte_rrc_measObjectId_r13;           /* MeasObjectId_v1310 */
static int hf_lte_rrc_measObject_r13;             /* T_measObject_r13 */
static int hf_lte_rrc_measObjectEUTRA_r13;        /* MeasObjectEUTRA */
static int hf_lte_rrc_measObjectUTRA_r13;         /* MeasObjectUTRA */
static int hf_lte_rrc_measObjectGERAN_r13;        /* MeasObjectGERAN */
static int hf_lte_rrc_measObjectCDMA2000_r13;     /* MeasObjectCDMA2000 */
static int hf_lte_rrc_measObjectWLAN_v1320;       /* MeasObjectWLAN_r13 */
static int hf_lte_rrc_measObjectEUTRA_v9e0;       /* MeasObjectEUTRA_v9e0 */
static int hf_lte_rrc_cellsToAddModList_02;       /* T_cellsToAddModList */
static int hf_lte_rrc_cellsToAddModListUTRA_FDD;  /* CellsToAddModListUTRA_FDD */
static int hf_lte_rrc_cellsToAddModListUTRA_TDD;  /* CellsToAddModListUTRA_TDD */
static int hf_lte_rrc_cellForWhichToReportCGI_03;  /* T_cellForWhichToReportCGI */
static int hf_lte_rrc_utra_FDD_01;                /* PhysCellIdUTRA_FDD */
static int hf_lte_rrc_utra_TDD_02;                /* PhysCellIdUTRA_TDD */
static int hf_lte_rrc_csg_allowedReportingCells_v930;  /* CSG_AllowedReportingCells_r9 */
static int hf_lte_rrc_measObjectUTRA_eag_2_reducedMeasPerformance_r12;  /* BOOLEAN */
static int hf_lte_rrc_CellsToAddModListUTRA_FDD_item;  /* CellsToAddModUTRA_FDD */
static int hf_lte_rrc_physCellId_03;              /* PhysCellIdUTRA_FDD */
static int hf_lte_rrc_CellsToAddModListUTRA_TDD_item;  /* CellsToAddModUTRA_TDD */
static int hf_lte_rrc_physCellId_04;              /* PhysCellIdUTRA_TDD */
static int hf_lte_rrc_physCellIdRangeUTRA_FDDList_r9;  /* PhysCellIdRangeUTRA_FDDList_r9 */
static int hf_lte_rrc_carrierFreq_r13_01;         /* T_carrierFreq_r13 */
static int hf_lte_rrc_bandIndicatorListWLAN_r13;  /* SEQUENCE_SIZE_1_maxWLAN_Bands_r13_OF_WLAN_BandIndicator_r13 */
static int hf_lte_rrc_bandIndicatorListWLAN_r13_item;  /* WLAN_BandIndicator_r13 */
static int hf_lte_rrc_carrierInfoListWLAN_r13;    /* SEQUENCE_SIZE_1_maxWLAN_CarrierInfo_r13_OF_WLAN_CarrierInfo_r13 */
static int hf_lte_rrc_carrierInfoListWLAN_r13_item;  /* WLAN_CarrierInfo_r13 */
static int hf_lte_rrc_wlan_ToAddModList_r13;      /* WLAN_Id_List_r13 */
static int hf_lte_rrc_wlan_ToRemoveList_r13;      /* WLAN_Id_List_r13 */
static int hf_lte_rrc_measResultPCell;            /* T_measResultPCell */
static int hf_lte_rrc_rsrpResult;                 /* RSRP_Range */
static int hf_lte_rrc_rsrqResult;                 /* RSRQ_Range */
static int hf_lte_rrc_measResultNeighCells;       /* T_measResultNeighCells */
static int hf_lte_rrc_measResultListEUTRA;        /* MeasResultListEUTRA */
static int hf_lte_rrc_measResultListUTRA;         /* MeasResultListUTRA */
static int hf_lte_rrc_measResultListGERAN;        /* MeasResultListGERAN */
static int hf_lte_rrc_measResultsCDMA2000;        /* MeasResultsCDMA2000 */
static int hf_lte_rrc_measResultNeighCellListNR_r15;  /* MeasResultCellListNR_r15 */
static int hf_lte_rrc_measResultForECID_r9;       /* MeasResultForECID_r9 */
static int hf_lte_rrc_measResultServFreqList_r10;  /* MeasResultServFreqList_r10 */
static int hf_lte_rrc_measResultPCell_v1250;      /* RSRQ_Range_v1250 */
static int hf_lte_rrc_measResultCSI_RS_List_r12;  /* MeasResultCSI_RS_List_r12 */
static int hf_lte_rrc_measResultPCell_v1310;      /* T_measResultPCell_v1310 */
static int hf_lte_rrc_ul_PDCP_DelayResultList_r13;  /* UL_PDCP_DelayResultList_r13 */
static int hf_lte_rrc_measResultListWLAN_r13;     /* MeasResultListWLAN_r13 */
static int hf_lte_rrc_measResultPCell_v1360;      /* RSRP_Range_v1360 */
static int hf_lte_rrc_measResultListCBR_r14;      /* MeasResultListCBR_r14 */
static int hf_lte_rrc_measResultListWLAN_r14;     /* MeasResultListWLAN_r14 */
static int hf_lte_rrc_measResultServFreqListNR_r15;  /* MeasResultServFreqListNR_r15 */
static int hf_lte_rrc_measResultCellListSFTD_r15;  /* MeasResultCellListSFTD_r15 */
static int hf_lte_rrc_measResultSensing_r15;      /* MeasResultSensing_r15 */
static int hf_lte_rrc_heightUE_r15;               /* INTEGER_M400_8880 */
static int hf_lte_rrc_ul_PDCP_DelayValueResultList_r16;  /* UL_PDCP_DelayValueResultList_r16 */
static int hf_lte_rrc_measResultForRSSI_NR_r16;   /* MeasResultForRSSI_NR_r16 */
static int hf_lte_rrc_uncomBarPreMeasResult_r17_01;  /* T_uncomBarPreMeasResult_r17_01 */
static int hf_lte_rrc_coarseLocationInfo_r17_01;  /* T_coarseLocationInfo_r17_01 */
static int hf_lte_rrc_MeasResultListEUTRA_item;   /* MeasResultEUTRA */
static int hf_lte_rrc_cgi_Info;                   /* T_cgi_Info */
static int hf_lte_rrc_cellGlobalId_01;            /* CellGlobalIdEUTRA */
static int hf_lte_rrc_plmn_IdentityList_01;       /* PLMN_IdentityList2 */
static int hf_lte_rrc_measResult;                 /* T_measResult */
static int hf_lte_rrc_additionalSI_Info_r9;       /* AdditionalSI_Info_r9 */
static int hf_lte_rrc_primaryPLMN_Suitable_r12;   /* T_primaryPLMN_Suitable_r12 */
static int hf_lte_rrc_measResult_v1250;           /* RSRQ_Range_v1250 */
static int hf_lte_rrc_cgi_Info_v1310;             /* T_cgi_Info_v1310 */
static int hf_lte_rrc_freqBandIndicator_r13;      /* FreqBandIndicator_r11 */
static int hf_lte_rrc_multiBandInfoList_r13;      /* MultiBandInfoList_r11 */
static int hf_lte_rrc_freqBandIndicatorPriority_r13;  /* T_freqBandIndicatorPriority_r13 */
static int hf_lte_rrc_measResult_v1360;           /* RSRP_Range_v1360 */
static int hf_lte_rrc_cgi_Info_5GC_r15;           /* SEQUENCE_SIZE_1_maxPLMN_r11_OF_CellAccessRelatedInfo_5GC_r15 */
static int hf_lte_rrc_cgi_Info_5GC_r15_item;      /* CellAccessRelatedInfo_5GC_r15 */
static int hf_lte_rrc_MeasResultListIdle_r15_item;  /* MeasResultIdle_r15 */
static int hf_lte_rrc_measResultServingCell_r15;  /* T_measResultServingCell_r15 */
static int hf_lte_rrc_rsrpResult_r15;             /* RSRP_Range */
static int hf_lte_rrc_rsrqResult_r15;             /* RSRQ_Range_r13 */
static int hf_lte_rrc_measResultNeighCells_r15;   /* T_measResultNeighCells_r15 */
static int hf_lte_rrc_measResultIdleListEUTRA_r15;  /* MeasResultIdleListEUTRA_r15 */
static int hf_lte_rrc_MeasResultIdleListEUTRA_r15_item;  /* MeasResultIdleEUTRA_r15 */
static int hf_lte_rrc_measResult_r15;             /* T_measResult_r15 */
static int hf_lte_rrc_MeasResultListExtIdle_r16_item;  /* MeasResultIdleListEUTRA_r15 */
static int hf_lte_rrc_MeasResultListIdleNR_r16_item;  /* MeasResultIdleNR_r16 */
static int hf_lte_rrc_measResultsPerCellListIdleNR_r16;  /* SEQUENCE_SIZE_1_maxCellMeasIdle_r15_OF_MeasResultsPerCellIdleNR_r16 */
static int hf_lte_rrc_measResultsPerCellListIdleNR_r16_item;  /* MeasResultsPerCellIdleNR_r16 */
static int hf_lte_rrc_physCellIdNR_r16;           /* PhysCellIdNR_r15 */
static int hf_lte_rrc_measIdleResultNR_r16;       /* T_measIdleResultNR_r16 */
static int hf_lte_rrc_rsrpResultNR_r16;           /* RSRP_RangeNR_r15 */
static int hf_lte_rrc_rsrqResultNR_r16;           /* RSRQ_RangeNR_r15 */
static int hf_lte_rrc_resultRS_IndexList_r16;     /* ResultsPerSSB_IndexList_r16 */
static int hf_lte_rrc_ResultsPerSSB_IndexList_r16_item;  /* ResultsPerSSB_IndexIdle_r16 */
static int hf_lte_rrc_ssb_Index_r16;              /* RS_IndexNR_r15 */
static int hf_lte_rrc_ssb_Results_r16;            /* T_ssb_Results_r16 */
static int hf_lte_rrc_ssb_RSRP_Result_r16;        /* RSRP_RangeNR_r15 */
static int hf_lte_rrc_ssb_RSRQ_Result_r16;        /* RSRQ_RangeNR_r15 */
static int hf_lte_rrc_MeasResultServFreqListNR_r15_item;  /* MeasResultServFreqNR_r15 */
static int hf_lte_rrc_measResultSCell_r15;        /* MeasResultCellNR_r15 */
static int hf_lte_rrc_measResultBestNeighCell_r15;  /* MeasResultCellNR_r15 */
static int hf_lte_rrc_MeasResultCellListNR_r15_item;  /* MeasResultCellNR_r15 */
static int hf_lte_rrc_pci_r15;                    /* PhysCellIdNR_r15 */
static int hf_lte_rrc_measResultCell_r15;         /* MeasResultNR_r15 */
static int hf_lte_rrc_measResultRS_IndexList_r15;  /* MeasResultSSB_IndexList_r15 */
static int hf_lte_rrc_cgi_Info_r15;               /* CGI_InfoNR_r15 */
static int hf_lte_rrc_rsrpResult_r15_01;          /* RSRP_RangeNR_r15 */
static int hf_lte_rrc_measResultNR_r15_rsrqResult_r15;  /* RSRQ_RangeNR_r15 */
static int hf_lte_rrc_rs_sinr_Result_r15;         /* RS_SINR_RangeNR_r15 */
static int hf_lte_rrc_MeasResultSSB_IndexList_r15_item;  /* MeasResultSSB_Index_r15 */
static int hf_lte_rrc_ssb_Index_r15;              /* RS_IndexNR_r15 */
static int hf_lte_rrc_measResultSSB_Index_r15;    /* MeasResultNR_r15 */
static int hf_lte_rrc_MeasResultServFreqList_r10_item;  /* MeasResultServFreq_r10 */
static int hf_lte_rrc_MeasResultServFreqListExt_r13_item;  /* MeasResultServFreq_r13 */
static int hf_lte_rrc_servFreqId_r10;             /* ServCellIndex_r10 */
static int hf_lte_rrc_measResultSCell_r10;        /* T_measResultSCell_r10 */
static int hf_lte_rrc_rsrpResultSCell_r10;        /* RSRP_Range */
static int hf_lte_rrc_rsrqResultSCell_r10;        /* RSRQ_Range */
static int hf_lte_rrc_measResultBestNeighCell_r10;  /* T_measResultBestNeighCell_r10 */
static int hf_lte_rrc_rsrpResultNCell_r10;        /* RSRP_Range */
static int hf_lte_rrc_rsrqResultNCell_r10;        /* RSRQ_Range */
static int hf_lte_rrc_measResultSCell_v1250;      /* RSRQ_Range_v1250 */
static int hf_lte_rrc_measResultBestNeighCell_v1250;  /* RSRQ_Range_v1250 */
static int hf_lte_rrc_measResultSCell_v1310_01;   /* T_measResultSCell_v1310_01 */
static int hf_lte_rrc_measResultBestNeighCell_v1310;  /* T_measResultBestNeighCell_v1310 */
static int hf_lte_rrc_servFreqId_r13;             /* ServCellIndex_r13 */
static int hf_lte_rrc_measResultSCell_r13;        /* T_measResultSCell_r13 */
static int hf_lte_rrc_rsrpResultSCell_r13;        /* RSRP_Range */
static int hf_lte_rrc_rsrqResultSCell_r13;        /* RSRQ_Range_r13 */
static int hf_lte_rrc_measResultBestNeighCell_r13;  /* T_measResultBestNeighCell_r13 */
static int hf_lte_rrc_rsrpResultNCell_r13;        /* RSRP_Range */
static int hf_lte_rrc_rsrqResultNCell_r13;        /* RSRQ_Range_r13 */
static int hf_lte_rrc_measResultBestNeighCell_v1360;  /* T_measResultBestNeighCell_v1360 */
static int hf_lte_rrc_rsrpResultNCell_v1360;      /* RSRP_Range_v1360 */
static int hf_lte_rrc_MeasResultCSI_RS_List_r12_item;  /* MeasResultCSI_RS_r12 */
static int hf_lte_rrc_csi_RSRP_Result_r12;        /* CSI_RSRP_Range_r12 */
static int hf_lte_rrc_MeasResultListUTRA_item;    /* MeasResultUTRA */
static int hf_lte_rrc_physCellId_05;              /* T_physCellId */
static int hf_lte_rrc_fdd_02;                     /* PhysCellIdUTRA_FDD */
static int hf_lte_rrc_tdd_02;                     /* PhysCellIdUTRA_TDD */
static int hf_lte_rrc_cgi_Info_01;                /* T_cgi_Info_01 */
static int hf_lte_rrc_cellGlobalId_02;            /* CellGlobalIdUTRA */
static int hf_lte_rrc_routingAreaCode;            /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_measResult_01;              /* T_measResult_01 */
static int hf_lte_rrc_utra_RSCP;                  /* INTEGER_M5_91 */
static int hf_lte_rrc_utra_EcN0;                  /* INTEGER_0_49 */
static int hf_lte_rrc_primaryPLMN_Suitable_r12_01;  /* T_primaryPLMN_Suitable_r12_01 */
static int hf_lte_rrc_MeasResultListGERAN_item;   /* MeasResultGERAN */
static int hf_lte_rrc_cgi_Info_02;                /* T_cgi_Info_02 */
static int hf_lte_rrc_cellGlobalId_03;            /* CellGlobalIdGERAN */
static int hf_lte_rrc_measResult_02;              /* T_measResult_02 */
static int hf_lte_rrc_rssi;                       /* INTEGER_0_63 */
static int hf_lte_rrc_preRegistrationStatusHRPD;  /* BOOLEAN */
static int hf_lte_rrc_measResultListCDMA2000;     /* MeasResultListCDMA2000 */
static int hf_lte_rrc_MeasResultListCDMA2000_item;  /* MeasResultCDMA2000 */
static int hf_lte_rrc_cgi_Info_03;                /* CellGlobalIdCDMA2000 */
static int hf_lte_rrc_measResult_03;              /* T_measResult_03 */
static int hf_lte_rrc_pilotPnPhase;               /* INTEGER_0_32767 */
static int hf_lte_rrc_pilotStrength;              /* INTEGER_0_63 */
static int hf_lte_rrc_MeasResultListWLAN_r13_item;  /* MeasResultWLAN_r13 */
static int hf_lte_rrc_MeasResultListWLAN_r14_item;  /* MeasResultWLAN_r13 */
static int hf_lte_rrc_wlan_Identifiers_r13;       /* WLAN_Identifiers_r12 */
static int hf_lte_rrc_carrierInfoWLAN_r13;        /* WLAN_CarrierInfo_r13 */
static int hf_lte_rrc_bandWLAN_r13;               /* WLAN_BandIndicator_r13 */
static int hf_lte_rrc_rssiWLAN_r13;               /* WLAN_RSSI_Range_r13 */
static int hf_lte_rrc_availableAdmissionCapacityWLAN_r13;  /* INTEGER_0_31250 */
static int hf_lte_rrc_backhaulDL_BandwidthWLAN_r13;  /* WLAN_backhaulRate_r12 */
static int hf_lte_rrc_backhaulUL_BandwidthWLAN_r13;  /* WLAN_backhaulRate_r12 */
static int hf_lte_rrc_channelUtilizationWLAN_r13;  /* INTEGER_0_255 */
static int hf_lte_rrc_stationCountWLAN_r13;       /* INTEGER_0_65535 */
static int hf_lte_rrc_connectedWLAN_r13;          /* T_connectedWLAN_r13 */
static int hf_lte_rrc_MeasResultListCBR_r14_item;  /* MeasResultCBR_r14 */
static int hf_lte_rrc_poolIdentity_r14;           /* SL_V2X_TxPoolReportIdentity_r14 */
static int hf_lte_rrc_cbr_PSSCH_r14;              /* SL_CBR_r14 */
static int hf_lte_rrc_cbr_PSCCH_r14;              /* SL_CBR_r14 */
static int hf_lte_rrc_sl_SubframeRef_r15;         /* INTEGER_0_10239 */
static int hf_lte_rrc_sensingResult_r15;          /* SEQUENCE_SIZE_0_400_OF_SensingResult_r15 */
static int hf_lte_rrc_sensingResult_r15_item;     /* SensingResult_r15 */
static int hf_lte_rrc_resourceIndex_r15;          /* INTEGER_1_2000 */
static int hf_lte_rrc_ue_RxTxTimeDiffResult_r9;   /* INTEGER_0_4095 */
static int hf_lte_rrc_currentSFN_r9;              /* BIT_STRING_SIZE_10 */
static int hf_lte_rrc_PLMN_IdentityList2_item;    /* PLMN_Identity */
static int hf_lte_rrc_csg_MemberStatus_r9;        /* T_csg_MemberStatus_r9 */
static int hf_lte_rrc_csg_Identity_r9;            /* CSG_Identity */
static int hf_lte_rrc_rssi_Result_r13;            /* RSSI_Range_r13 */
static int hf_lte_rrc_channelOccupancy_r13;       /* INTEGER_0_100 */
static int hf_lte_rrc_rssi_ResultNR_r16;          /* RSSI_Range_r13 */
static int hf_lte_rrc_channelOccupancyNR_r16;     /* INTEGER_0_100 */
static int hf_lte_rrc_UL_PDCP_DelayResultList_r13_item;  /* UL_PDCP_DelayResult_r13 */
static int hf_lte_rrc_qci_Id_r13;                 /* T_qci_Id_r13 */
static int hf_lte_rrc_excessDelay_r13;            /* INTEGER_0_31 */
static int hf_lte_rrc_UL_PDCP_DelayValueResultList_r16_item;  /* UL_PDCP_DelayValueResult_r16 */
static int hf_lte_rrc_drb_Id_r16;                 /* DRB_Identity */
static int hf_lte_rrc_averageDelay_r16;           /* INTEGER_0_10000 */
static int hf_lte_rrc_plmn_IdentityInfoList_r15;  /* PLMN_IdentityInfoListNR_r15 */
static int hf_lte_rrc_frequencyBandList_r15;      /* MultiFrequencyBandListNR_r15 */
static int hf_lte_rrc_noSIB1_r15;                 /* T_noSIB1_r15 */
static int hf_lte_rrc_ssb_SubcarrierOffset_r15;   /* INTEGER_0_15 */
static int hf_lte_rrc_pdcch_ConfigSIB1_r15;       /* INTEGER_0_255 */
static int hf_lte_rrc_plmn_IdentityInfoList_v1710;  /* PLMN_IdentityInfoListNR_v1710 */
static int hf_lte_rrc_PLMN_IdentityListNR_r15_item;  /* PLMN_Identity */
static int hf_lte_rrc_PLMN_IdentityInfoListNR_r15_item;  /* PLMN_IdentityInfoNR_r15 */
static int hf_lte_rrc_PLMN_IdentityInfoListNR_v1710_item;  /* PLMN_IdentityInfoNR_v1710 */
static int hf_lte_rrc_plmn_IdentityList_r15_01;   /* PLMN_IdentityListNR_r15 */
static int hf_lte_rrc_trackingAreaCode_r15;       /* TrackingAreaCodeNR_r15 */
static int hf_lte_rrc_cellIdentity_r15_01;        /* CellIdentityNR_r15 */
static int hf_lte_rrc_gNB_ID_Length_r17;          /* INTEGER_22_32 */
static int hf_lte_rrc_MeasResultCellListSFTD_r15_item;  /* MeasResultCellSFTD_r15 */
static int hf_lte_rrc_sfn_OffsetResult_r15;       /* INTEGER_0_1023 */
static int hf_lte_rrc_frameBoundaryOffsetResult_r15;  /* INTEGER_M30720_30719 */
static int hf_lte_rrc_measResultFreqListEUTRA_r15;  /* MeasResultList3EUTRA_r15 */
static int hf_lte_rrc_MeasResultList3EUTRA_r15_item;  /* MeasResult3EUTRA_r15 */
static int hf_lte_rrc_measResultServingCell_r15_01;  /* MeasResultEUTRA */
static int hf_lte_rrc_measResultNeighCellList_r15;  /* MeasResultListEUTRA */
static int hf_lte_rrc_sfn_OffsetResult_r13;       /* INTEGER_0_1023 */
static int hf_lte_rrc_frameBoundaryOffsetResult_r13;  /* INTEGER_M5_4 */
static int hf_lte_rrc_subframeBoundaryOffsetResult_r13;  /* INTEGER_0_127 */
static int hf_lte_rrc_sensingSubchannelNumber_r15;  /* INTEGER_1_20 */
static int hf_lte_rrc_sensingPeriodicity_r15;     /* T_sensingPeriodicity_r15 */
static int hf_lte_rrc_sensingReselectionCounter_r15;  /* INTEGER_5_75 */
static int hf_lte_rrc_sensingPriority_r15;        /* INTEGER_1_8 */
static int hf_lte_rrc_periodicityAndOffset_r15;   /* T_periodicityAndOffset_r15 */
static int hf_lte_rrc_sf5_r15;                    /* INTEGER_0_4 */
static int hf_lte_rrc_sf10_r15;                   /* INTEGER_0_9 */
static int hf_lte_rrc_sf20_r15;                   /* INTEGER_0_19 */
static int hf_lte_rrc_sf40_r15;                   /* INTEGER_0_39 */
static int hf_lte_rrc_sf80_r15;                   /* INTEGER_0_79 */
static int hf_lte_rrc_sf160_r15;                  /* INTEGER_0_159 */
static int hf_lte_rrc_ssb_Duration_r15;           /* T_ssb_Duration_r15 */
static int hf_lte_rrc_pci_List_r16;               /* SEQUENCE_SIZE_1_maxNrofPCI_PerSMTC_r16_OF_PhysCellIdNR_r15 */
static int hf_lte_rrc_pci_List_r16_item;          /* PhysCellIdNR_r15 */
static int hf_lte_rrc_periodicity_r16;            /* T_periodicity_r16 */
static int hf_lte_rrc_quantityConfigEUTRA;        /* QuantityConfigEUTRA */
static int hf_lte_rrc_quantityConfigUTRA;         /* QuantityConfigUTRA */
static int hf_lte_rrc_quantityConfigGERAN;        /* QuantityConfigGERAN */
static int hf_lte_rrc_quantityConfigCDMA2000;     /* QuantityConfigCDMA2000 */
static int hf_lte_rrc_quantityConfigUTRA_v1020;   /* QuantityConfigUTRA_v1020 */
static int hf_lte_rrc_quantityConfigEUTRA_v1250;  /* QuantityConfigEUTRA_v1250 */
static int hf_lte_rrc_quantityConfigEUTRA_v1310;  /* QuantityConfigEUTRA_v1310 */
static int hf_lte_rrc_quantityConfigWLAN_r13;     /* QuantityConfigWLAN_r13 */
static int hf_lte_rrc_quantityConfigNRList_r15;   /* QuantityConfigNRList_r15 */
static int hf_lte_rrc_filterCoefficientRSRP;      /* FilterCoefficient */
static int hf_lte_rrc_filterCoefficientRSRQ;      /* FilterCoefficient */
static int hf_lte_rrc_filterCoefficientCSI_RSRP_r12;  /* FilterCoefficient */
static int hf_lte_rrc_filterCoefficientRS_SINR_r13;  /* FilterCoefficient */
static int hf_lte_rrc_measQuantityUTRA_FDD;       /* T_measQuantityUTRA_FDD */
static int hf_lte_rrc_measQuantityUTRA_TDD;       /* T_measQuantityUTRA_TDD */
static int hf_lte_rrc_filterCoefficient2_FDD_r10;  /* FilterCoefficient */
static int hf_lte_rrc_measQuantityGERAN;          /* T_measQuantityGERAN */
static int hf_lte_rrc_measQuantityCDMA2000;       /* T_measQuantityCDMA2000 */
static int hf_lte_rrc_QuantityConfigNRList_r15_item;  /* QuantityConfigNR_r15 */
static int hf_lte_rrc_measQuantityCellNR_r15;     /* QuantityConfigRS_NR_r15 */
static int hf_lte_rrc_measQuantityRS_IndexNR_r15;  /* QuantityConfigRS_NR_r15 */
static int hf_lte_rrc_filterCoeff_RSRP_r15;       /* FilterCoefficient */
static int hf_lte_rrc_filterCoeff_RSRQ_r15;       /* FilterCoefficient */
static int hf_lte_rrc_filterCoefficient_SINR_r13;  /* FilterCoefficient */
static int hf_lte_rrc_measQuantityWLAN_r13;       /* T_measQuantityWLAN_r13 */
static int hf_lte_rrc_triggerType;                /* T_triggerType */
static int hf_lte_rrc_event;                      /* T_event */
static int hf_lte_rrc_eventId;                    /* T_eventId */
static int hf_lte_rrc_eventA1;                    /* T_eventA1 */
static int hf_lte_rrc_a1_Threshold;               /* ThresholdEUTRA */
static int hf_lte_rrc_eventA2;                    /* T_eventA2 */
static int hf_lte_rrc_a2_Threshold;               /* ThresholdEUTRA */
static int hf_lte_rrc_eventA3;                    /* T_eventA3 */
static int hf_lte_rrc_a3_Offset;                  /* INTEGER_M30_30 */
static int hf_lte_rrc_reportOnLeave;              /* BOOLEAN */
static int hf_lte_rrc_eventA4;                    /* T_eventA4 */
static int hf_lte_rrc_a4_Threshold;               /* ThresholdEUTRA */
static int hf_lte_rrc_eventA5;                    /* T_eventA5 */
static int hf_lte_rrc_a5_Threshold1;              /* ThresholdEUTRA */
static int hf_lte_rrc_a5_Threshold2;              /* ThresholdEUTRA */
static int hf_lte_rrc_eventA6_r10;                /* T_eventA6_r10 */
static int hf_lte_rrc_a6_Offset_r10;              /* INTEGER_M30_30 */
static int hf_lte_rrc_a6_ReportOnLeave_r10;       /* BOOLEAN */
static int hf_lte_rrc_eventC1_r12;                /* T_eventC1_r12 */
static int hf_lte_rrc_c1_Threshold_r12;           /* ThresholdEUTRA_v1250 */
static int hf_lte_rrc_c1_ReportOnLeave_r12;       /* BOOLEAN */
static int hf_lte_rrc_eventC2_r12;                /* T_eventC2_r12 */
static int hf_lte_rrc_c2_RefCSI_RS_r12;           /* MeasCSI_RS_Id_r12 */
static int hf_lte_rrc_c2_Offset_r12;              /* INTEGER_M30_30 */
static int hf_lte_rrc_c2_ReportOnLeave_r12;       /* BOOLEAN */
static int hf_lte_rrc_eventV1_r14;                /* T_eventV1_r14 */
static int hf_lte_rrc_v1_Threshold_r14;           /* SL_CBR_r14 */
static int hf_lte_rrc_eventV2_r14;                /* T_eventV2_r14 */
static int hf_lte_rrc_v2_Threshold_r14;           /* SL_CBR_r14 */
static int hf_lte_rrc_eventH1_r15;                /* T_eventH1_r15 */
static int hf_lte_rrc_h1_ThresholdOffset_r15;     /* INTEGER_0_300 */
static int hf_lte_rrc_h1_Hysteresis_r15;          /* INTEGER_1_16 */
static int hf_lte_rrc_eventH2_r15;                /* T_eventH2_r15 */
static int hf_lte_rrc_h2_ThresholdOffset_r15;     /* INTEGER_0_300 */
static int hf_lte_rrc_h2_Hysteresis_r15;          /* INTEGER_1_16 */
static int hf_lte_rrc_eventD1_r18;                /* T_eventD1_r18 */
static int hf_lte_rrc_distanceThreshFromReference1_r18;  /* INTEGER_0_65535 */
static int hf_lte_rrc_distanceThreshFromReference2_r18;  /* INTEGER_0_65535 */
static int hf_lte_rrc_referenceLocation1_r18;     /* ReferenceLocation_r18 */
static int hf_lte_rrc_referenceLocation2_r18;     /* ReferenceLocation_r18 */
static int hf_lte_rrc_hysteresisLocation_r18;     /* HysteresisLocation_r18 */
static int hf_lte_rrc_reportOnLeave_r18;          /* BOOLEAN */
static int hf_lte_rrc_eventD2_r18;                /* T_eventD2_r18 */
static int hf_lte_rrc_hysteresis;                 /* Hysteresis */
static int hf_lte_rrc_timeToTrigger;              /* TimeToTrigger */
static int hf_lte_rrc_periodical;                 /* T_periodical */
static int hf_lte_rrc_purpose_02;                 /* T_purpose_02 */
static int hf_lte_rrc_triggerQuantity;            /* T_triggerQuantity */
static int hf_lte_rrc_reportQuantity;             /* T_reportQuantity */
static int hf_lte_rrc_maxReportCells;             /* INTEGER_1_maxCellReport */
static int hf_lte_rrc_reportInterval;             /* ReportInterval */
static int hf_lte_rrc_reportAmount;               /* T_reportAmount */
static int hf_lte_rrc_si_RequestForHO_r9;         /* T_si_RequestForHO_r9 */
static int hf_lte_rrc_ue_RxTxTimeDiffPeriodical_r9;  /* T_ue_RxTxTimeDiffPeriodical_r9 */
static int hf_lte_rrc_includeLocationInfo_r10;    /* T_includeLocationInfo_r10 */
static int hf_lte_rrc_reportAddNeighMeas_r10;     /* T_reportAddNeighMeas_r10 */
static int hf_lte_rrc_alternativeTimeToTrigger_r12;  /* T_alternativeTimeToTrigger_r12 */
static int hf_lte_rrc_reportConfigEUTRA_eag_3_alternativeTimeToTrigger_r12_setup;  /* TimeToTrigger */
static int hf_lte_rrc_useT312_r12;                /* BOOLEAN */
static int hf_lte_rrc_usePSCell_r12;              /* BOOLEAN */
static int hf_lte_rrc_aN_Threshold1_v1250;        /* RSRQ_RangeConfig_r12 */
static int hf_lte_rrc_a5_Threshold2_v1250;        /* RSRQ_RangeConfig_r12 */
static int hf_lte_rrc_reportStrongestCSI_RSs_r12;  /* BOOLEAN */
static int hf_lte_rrc_reportCRS_Meas_r12;         /* BOOLEAN */
static int hf_lte_rrc_triggerQuantityCSI_RS_r12;  /* BOOLEAN */
static int hf_lte_rrc_reportSSTD_Meas_r13;        /* BOOLEAN */
static int hf_lte_rrc_rs_sinr_Config_r13;         /* T_rs_sinr_Config_r13 */
static int hf_lte_rrc_reportConfigEUTRA_eag_4_rs_sinr_Config_r13_setup;  /* T_reportConfigEUTRA_eag_4_rs_sinr_Config_r13_setup */
static int hf_lte_rrc_triggerQuantity_v1310;      /* T_triggerQuantity_v1310 */
static int hf_lte_rrc_aN_Threshold1_r13;          /* RS_SINR_Range_r13 */
static int hf_lte_rrc_a5_Threshold2_r13;          /* RS_SINR_Range_r13 */
static int hf_lte_rrc_reportQuantity_v1310;       /* T_reportQuantity_v1310 */
static int hf_lte_rrc_useAllowedCellList_r13;     /* BOOLEAN */
static int hf_lte_rrc_measRSSI_ReportConfig_r13;  /* MeasRSSI_ReportConfig_r13 */
static int hf_lte_rrc_includeMultiBandInfo_r13;   /* T_includeMultiBandInfo_r13 */
static int hf_lte_rrc_ul_DelayConfig_r13;         /* UL_DelayConfig_r13 */
static int hf_lte_rrc_ue_RxTxTimeDiffPeriodicalTDD_r13;  /* BOOLEAN */
static int hf_lte_rrc_purpose_v1430;              /* T_purpose_v1430 */
static int hf_lte_rrc_maxReportRS_Index_r15;      /* INTEGER_0_maxRS_IndexReport_r15 */
static int hf_lte_rrc_includeBT_Meas_r15;         /* BT_NameListConfig_r15 */
static int hf_lte_rrc_includeWLAN_Meas_r15;       /* WLAN_NameListConfig_r15 */
static int hf_lte_rrc_purpose_r15;                /* T_purpose_r15 */
static int hf_lte_rrc_numberOfTriggeringCells_r15;  /* INTEGER_2_maxCellReport */
static int hf_lte_rrc_a4_a5_ReportOnLeave_r15;    /* BOOLEAN */
static int hf_lte_rrc_condReconfigurationTriggerEUTRA_r16;  /* CondReconfigurationTriggerEUTRA_r16 */
static int hf_lte_rrc_ul_DelayValueConfig_r16;    /* UL_DelayValueConfig_r16 */
static int hf_lte_rrc_includeUncomBarPreMeas_r17;  /* BOOLEAN */
static int hf_lte_rrc_coarseLocationReq_r17_01;   /* T_coarseLocationReq_r17_01 */
static int hf_lte_rrc_condEventId_r16;            /* T_condEventId_r16 */
static int hf_lte_rrc_condEventA3_r16;            /* T_condEventA3_r16 */
static int hf_lte_rrc_a3_Offset_r16;              /* INTEGER_M30_30 */
static int hf_lte_rrc_hysteresis_r16;             /* Hysteresis */
static int hf_lte_rrc_timeToTrigger_r16;          /* TimeToTrigger */
static int hf_lte_rrc_condEventA5_r16;            /* T_condEventA5_r16 */
static int hf_lte_rrc_a5_Threshold1_r16;          /* ThresholdEUTRA */
static int hf_lte_rrc_a5_Threshold2_r16;          /* ThresholdEUTRA */
static int hf_lte_rrc_condEventA4_r18;            /* T_condEventA4_r18 */
static int hf_lte_rrc_a4_Threshold_r18;           /* ThresholdEUTRA */
static int hf_lte_rrc_hysteresis_r18;             /* Hysteresis */
static int hf_lte_rrc_timeToTrigger_r18;          /* TimeToTrigger */
static int hf_lte_rrc_condEventD1_r18;            /* T_condEventD1_r18 */
static int hf_lte_rrc_condEventD2_r18;            /* T_condEventD2_r18 */
static int hf_lte_rrc_condEventT1_r18;            /* T_condEventT1_r18 */
static int hf_lte_rrc_t1_Threshold_r18;           /* TimeOffsetUTC_r17 */
static int hf_lte_rrc_duration_r18;               /* INTEGER_1_6000 */
static int hf_lte_rrc_rSRQ_RangeConfig_r12_setup;  /* RSRQ_Range_v1250 */
static int hf_lte_rrc_threshold_RSRP;             /* Threshold_RSRP_Range */
static int hf_lte_rrc_threshold_RSRQ;             /* Threshold_RSRQ_Range */
static int hf_lte_rrc_channelOccupancyThreshold_r13;  /* RSSI_Range_r13 */
static int hf_lte_rrc_triggerType_01;             /* T_triggerType_01 */
static int hf_lte_rrc_event_01;                   /* T_event_01 */
static int hf_lte_rrc_eventId_01;                 /* T_eventId_01 */
static int hf_lte_rrc_eventB1;                    /* T_eventB1 */
static int hf_lte_rrc_b1_Threshold;               /* T_b1_Threshold */
static int hf_lte_rrc_b1_ThresholdUTRA;           /* ThresholdUTRA */
static int hf_lte_rrc_b1_ThresholdGERAN;          /* ThresholdGERAN */
static int hf_lte_rrc_b1_ThresholdCDMA2000;       /* ThresholdCDMA2000 */
static int hf_lte_rrc_eventB2;                    /* T_eventB2 */
static int hf_lte_rrc_b2_Threshold1;              /* ThresholdEUTRA */
static int hf_lte_rrc_b2_Threshold2;              /* T_b2_Threshold2 */
static int hf_lte_rrc_b2_Threshold2UTRA;          /* ThresholdUTRA */
static int hf_lte_rrc_b2_Threshold2GERAN;         /* ThresholdGERAN */
static int hf_lte_rrc_b2_Threshold2CDMA2000;      /* ThresholdCDMA2000 */
static int hf_lte_rrc_eventW1_r13;                /* T_eventW1_r13 */
static int hf_lte_rrc_w1_Threshold_r13;           /* WLAN_RSSI_Range_r13 */
static int hf_lte_rrc_eventW2_r13;                /* T_eventW2_r13 */
static int hf_lte_rrc_w2_Threshold1_r13;          /* WLAN_RSSI_Range_r13 */
static int hf_lte_rrc_w2_Threshold2_r13;          /* WLAN_RSSI_Range_r13 */
static int hf_lte_rrc_eventW3_r13;                /* T_eventW3_r13 */
static int hf_lte_rrc_w3_Threshold_r13;           /* WLAN_RSSI_Range_r13 */
static int hf_lte_rrc_eventB1_NR_r15;             /* T_eventB1_NR_r15 */
static int hf_lte_rrc_b1_ThresholdNR_r15;         /* ThresholdNR_r15 */
static int hf_lte_rrc_reportOnLeave_r15;          /* BOOLEAN */
static int hf_lte_rrc_eventB2_NR_r15;             /* T_eventB2_NR_r15 */
static int hf_lte_rrc_b2_Threshold1_r15;          /* ThresholdEUTRA */
static int hf_lte_rrc_b2_Threshold2NR_r15;        /* ThresholdNR_r15 */
static int hf_lte_rrc_periodical_01;              /* T_periodical_01 */
static int hf_lte_rrc_purpose_03;                 /* T_purpose_03 */
static int hf_lte_rrc_reportAmount_01;            /* T_reportAmount_01 */
static int hf_lte_rrc_si_RequestForHO_r9_01;      /* T_si_RequestForHO_r9_01 */
static int hf_lte_rrc_reportQuantityUTRA_FDD_r10;  /* T_reportQuantityUTRA_FDD_r10 */
static int hf_lte_rrc_includeLocationInfo_r11;    /* BOOLEAN */
static int hf_lte_rrc_b2_Threshold1_v1250;        /* T_b2_Threshold1_v1250 */
static int hf_lte_rrc_reportConfigInterRAT_eag_4_b2_Threshold1_v1250_setup;  /* RSRQ_Range_v1250 */
static int hf_lte_rrc_reportQuantityWLAN_r13;     /* ReportQuantityWLAN_r13 */
static int hf_lte_rrc_reportAnyWLAN_r14;          /* BOOLEAN */
static int hf_lte_rrc_reportQuantityCellNR_r15;   /* ReportQuantityNR_r15 */
static int hf_lte_rrc_reportQuantityRS_IndexNR_r15;  /* ReportQuantityNR_r15 */
static int hf_lte_rrc_reportRS_IndexResultsNR;    /* BOOLEAN */
static int hf_lte_rrc_reportSFTD_Meas_r15;        /* T_reportSFTD_Meas_r15 */
static int hf_lte_rrc_useAutonomousGapsNR_r16;    /* T_useAutonomousGapsNR_r16 */
static int hf_lte_rrc_measRSSI_ReportConfigNR_r16;  /* MeasRSSI_ReportConfig_r13 */
static int hf_lte_rrc_condReconfigurationTriggerNR_r17;  /* CondReconfigurationTriggerNR_r17 */
static int hf_lte_rrc_condEventId_r17;            /* T_condEventId_r17 */
static int hf_lte_rrc_condEventB1_NR_r17;         /* T_condEventB1_NR_r17 */
static int hf_lte_rrc_b1_ThresholdNR_r17;         /* ThresholdNR_r15 */
static int hf_lte_rrc_utra_RSCP_01;               /* Threshold_utra_RSRP */
static int hf_lte_rrc_utra_EcN0_01;               /* Threshold_utra_EcN0 */
static int hf_lte_rrc_ss_rsrp;                    /* BOOLEAN */
static int hf_lte_rrc_ss_rsrq;                    /* BOOLEAN */
static int hf_lte_rrc_ss_sinr;                    /* BOOLEAN */
static int hf_lte_rrc_bandRequestWLAN_r13;        /* T_bandRequestWLAN_r13 */
static int hf_lte_rrc_carrierInfoRequestWLAN_r13;  /* T_carrierInfoRequestWLAN_r13 */
static int hf_lte_rrc_availableAdmissionCapacityRequestWLAN_r13;  /* T_availableAdmissionCapacityRequestWLAN_r13 */
static int hf_lte_rrc_backhaulDL_BandwidthRequestWLAN_r13;  /* T_backhaulDL_BandwidthRequestWLAN_r13 */
static int hf_lte_rrc_backhaulUL_BandwidthRequestWLAN_r13;  /* T_backhaulUL_BandwidthRequestWLAN_r13 */
static int hf_lte_rrc_channelUtilizationRequestWLAN_r13;  /* T_channelUtilizationRequestWLAN_r13 */
static int hf_lte_rrc_stationCountRequestWLAN_r13;  /* T_stationCountRequestWLAN_r13 */
static int hf_lte_rrc_ReportConfigToAddModList_item;  /* ReportConfigToAddMod */
static int hf_lte_rrc_reportConfig;               /* T_reportConfig */
static int hf_lte_rrc_reportConfigEUTRA;          /* ReportConfigEUTRA */
static int hf_lte_rrc_reportConfigInterRAT;       /* ReportConfigInterRAT */
static int hf_lte_rrc_allSymbols_r12;             /* BOOLEAN */
static int hf_lte_rrc_wideBand_r12;               /* BOOLEAN */
static int hf_lte_rrc_measurementSlots_r15;       /* BIT_STRING_SIZE_1_80 */
static int hf_lte_rrc_endSymbol_r15;              /* INTEGER_0_3 */
static int hf_lte_rrc_shortBitmap_r15;            /* BIT_STRING_SIZE_4 */
static int hf_lte_rrc_mediumBitmap_r15;           /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_longBitmap_r15;             /* BIT_STRING_SIZE_64 */
static int hf_lte_rrc_uL_DelayConfig_r13_setup;   /* T_uL_DelayConfig_r13_setup */
static int hf_lte_rrc_delayThreshold_r13;         /* T_delayThreshold_r13 */
static int hf_lte_rrc_uL_DelayValueConfig_r16_setup;  /* T_uL_DelayValueConfig_r16_setup */
static int hf_lte_rrc_delay_DRBlist_r16;          /* SEQUENCE_SIZE_1_maxDRB_OF_DRB_Identity */
static int hf_lte_rrc_delay_DRBlist_r16_item;     /* DRB_Identity */
static int hf_lte_rrc_operatingClass_r13;         /* INTEGER_0_255 */
static int hf_lte_rrc_countryCode_r13;            /* T_countryCode_r13 */
static int hf_lte_rrc_channelNumbers_r13;         /* WLAN_ChannelList_r13 */
static int hf_lte_rrc_WLAN_ChannelList_r13_item;  /* WLAN_Channel_r13 */
static int hf_lte_rrc_wLAN_NameListConfig_r15_setup;  /* WLAN_NameList_r15 */
static int hf_lte_rrc_WLAN_NameList_r15_item;     /* WLAN_Name_r15 */
static int hf_lte_rrc_rttValue_r15;               /* INTEGER_0_16777215 */
static int hf_lte_rrc_rttUnits_r15;               /* T_rttUnits_r15 */
static int hf_lte_rrc_rttAccuracy_r15;            /* INTEGER_0_255 */
static int hf_lte_rrc_wlan_SuspendResumeAllowed_r14;  /* BOOLEAN */
static int hf_lte_rrc_wlan_SuspendTriggersStatusReport_r14;  /* BOOLEAN */
static int hf_lte_rrc_cellGlobalIdList_r10;       /* CellGlobalIdList_r10 */
static int hf_lte_rrc_trackingAreaCodeList_r10;   /* TrackingAreaCodeList_r10 */
static int hf_lte_rrc_trackingAreaCodeList_v1130;  /* TrackingAreaCodeList_v1130 */
static int hf_lte_rrc_CellGlobalIdList_r10_item;  /* CellGlobalIdEUTRA */
static int hf_lte_rrc_TrackingAreaCodeList_r10_item;  /* TrackingAreaCode */
static int hf_lte_rrc_plmn_Identity_perTAC_List_r11;  /* SEQUENCE_SIZE_1_8_OF_PLMN_Identity */
static int hf_lte_rrc_plmn_Identity_perTAC_List_r11_item;  /* PLMN_Identity */
static int hf_lte_rrc_BandCombinationList_r14_item;  /* BandCombination_r14 */
static int hf_lte_rrc_BandCombination_r14_item;   /* BandIndication_r14 */
static int hf_lte_rrc_bandEUTRA_r14;              /* FreqBandIndicator_r11 */
static int hf_lte_rrc_ca_BandwidthClassDL_r14;    /* CA_BandwidthClass_r10 */
static int hf_lte_rrc_ca_BandwidthClassUL_r14;    /* CA_BandwidthClass_r10 */
static int hf_lte_rrc_maxWayPointNumber_r15;      /* INTEGER_1_maxWayPoint_r15 */
static int hf_lte_rrc_includeTimeStamp_r15;       /* T_includeTimeStamp_r15 */
static int hf_lte_rrc_gnss_id_r15_01;             /* T_gnss_id_r15 */
static int hf_lte_rrc_subframePatternFDD_r10;     /* BIT_STRING_SIZE_40 */
static int hf_lte_rrc_subframePatternTDD_r10;     /* T_subframePatternTDD_r10 */
static int hf_lte_rrc_subframeConfig1_5_r10;      /* BIT_STRING_SIZE_20 */
static int hf_lte_rrc_subframeConfig0_r10;        /* BIT_STRING_SIZE_70 */
static int hf_lte_rrc_subframeConfig6_r10;        /* BIT_STRING_SIZE_60 */
static int hf_lte_rrc_reportProximityConfig_r9;   /* ReportProximityConfig_r9 */
static int hf_lte_rrc_idc_Config_r11;             /* IDC_Config_r11 */
static int hf_lte_rrc_powerPrefIndicationConfig_r11;  /* PowerPrefIndicationConfig_r11 */
static int hf_lte_rrc_obtainLocationConfig_r11;   /* ObtainLocationConfig_r11 */
static int hf_lte_rrc_bw_PreferenceIndicationTimer_r14;  /* T_bw_PreferenceIndicationTimer_r14 */
static int hf_lte_rrc_sps_AssistanceInfoReport_r14;  /* BOOLEAN */
static int hf_lte_rrc_delayBudgetReportingConfig_r14;  /* T_delayBudgetReportingConfig_r14 */
static int hf_lte_rrc_otherConfig_r9_eag_2_delayBudgetReportingConfig_r14_setup;  /* T_otherConfig_r9_eag_2_delayBudgetReportingConfig_r14_setup */
static int hf_lte_rrc_delayBudgetReportingProhibitTimer_r14;  /* T_delayBudgetReportingProhibitTimer_r14 */
static int hf_lte_rrc_rlm_ReportConfig_r14;       /* T_rlm_ReportConfig_r14 */
static int hf_lte_rrc_otherConfig_r9_eag_2_rlm_ReportConfig_r14_setup;  /* T_otherConfig_r9_eag_2_rlm_ReportConfig_r14_setup */
static int hf_lte_rrc_rlmReportTimer_r14;         /* T_rlmReportTimer_r14 */
static int hf_lte_rrc_rlmReportRep_MPDCCH_r14;    /* T_rlmReportRep_MPDCCH_r14 */
static int hf_lte_rrc_overheatingAssistanceConfig_r14;  /* T_overheatingAssistanceConfig_r14 */
static int hf_lte_rrc_otherConfig_r9_eag_3_overheatingAssistanceConfig_r14_setup;  /* T_otherConfig_r9_eag_3_overheatingAssistanceConfig_r14_setup */
static int hf_lte_rrc_overheatingIndicationProhibitTimer_r14;  /* T_overheatingIndicationProhibitTimer_r14 */
static int hf_lte_rrc_measConfigAppLayer_r15;     /* T_measConfigAppLayer_r15 */
static int hf_lte_rrc_otherConfig_r9_eag_4_measConfigAppLayer_r15_setup;  /* T_otherConfig_r9_eag_4_measConfigAppLayer_r15_setup */
static int hf_lte_rrc_measConfigAppLayerContainer_r15;  /* OCTET_STRING_SIZE_1_1000 */
static int hf_lte_rrc_serviceType_r15_01;         /* T_serviceType_r15_01 */
static int hf_lte_rrc_ailc_BitConfig_r15;         /* BOOLEAN */
static int hf_lte_rrc_bt_NameListConfig_r15;      /* BT_NameListConfig_r15 */
static int hf_lte_rrc_wlan_NameListConfig_r15;    /* WLAN_NameListConfig_r15 */
static int hf_lte_rrc_overheatingAssistanceConfigForSCG_r16;  /* BOOLEAN */
static int hf_lte_rrc_measUncomBarPre_r17_01;     /* BOOLEAN */
static int hf_lte_rrc_scg_DeactivationPreferenceConfig_r17;  /* T_scg_DeactivationPreferenceConfig_r17 */
static int hf_lte_rrc_setup_12;                   /* SCG_DeactivationPreferenceConfig_r17 */
static int hf_lte_rrc_iDC_Config_r11_idc_Indication_r11;  /* T_iDC_Config_r11_idc_Indication_r11 */
static int hf_lte_rrc_autonomousDenialParameters_r11;  /* T_autonomousDenialParameters_r11 */
static int hf_lte_rrc_autonomousDenialSubframes_r11;  /* T_autonomousDenialSubframes_r11 */
static int hf_lte_rrc_autonomousDenialValidity_r11;  /* T_autonomousDenialValidity_r11 */
static int hf_lte_rrc_idc_Indication_UL_CA_r11;   /* T_idc_Indication_UL_CA_r11 */
static int hf_lte_rrc_idc_HardwareSharingIndication_r13;  /* T_idc_HardwareSharingIndication_r13 */
static int hf_lte_rrc_idc_Indication_MRDC_r15;    /* T_idc_Indication_MRDC_r15 */
static int hf_lte_rrc_iDC_Config_r11_eag_3_idc_Indication_MRDC_r15_setup;  /* CandidateServingFreqListNR_r15 */
static int hf_lte_rrc_obtainLocation_r11;         /* T_obtainLocation_r11 */
static int hf_lte_rrc_powerPrefIndicationConfig_r11_setup;  /* T_powerPrefIndicationConfig_r11_setup */
static int hf_lte_rrc_powerPrefIndicationTimer_r11;  /* T_powerPrefIndicationTimer_r11 */
static int hf_lte_rrc_proximityIndicationEUTRA_r9;  /* T_proximityIndicationEUTRA_r9 */
static int hf_lte_rrc_proximityIndicationUTRA_r9;  /* T_proximityIndicationUTRA_r9 */
static int hf_lte_rrc_CandidateServingFreqListNR_r15_item;  /* ARFCN_ValueNR_r15 */
static int hf_lte_rrc_scg_DeactivationPreferenceProhibitTimer_r17;  /* T_scg_DeactivationPreferenceProhibitTimer_r17 */
static int hf_lte_rrc_sbas_id_r15_01;             /* T_sbas_id_r15 */
static int hf_lte_rrc_sst;                        /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_sst_SD;                     /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_m_TMSI;                     /* BIT_STRING_SIZE_32 */
static int hf_lte_rrc_plmn_Identity_r10;          /* PLMN_Identity */
static int hf_lte_rrc_traceId_r10;                /* OCTET_STRING_SIZE_3 */
static int hf_lte_rrc_UE_CapabilityRAT_ContainerList_item;  /* UE_CapabilityRAT_Container */
static int hf_lte_rrc_rat_Type;                   /* RAT_Type */
static int hf_lte_rrc_ueCapabilityRAT_Container;  /* T_ueCapabilityRAT_Container */
static int hf_lte_rrc_accessStratumRelease;       /* AccessStratumRelease */
static int hf_lte_rrc_ue_Category;                /* INTEGER_1_5 */
static int hf_lte_rrc_pdcp_Parameters;            /* PDCP_Parameters */
static int hf_lte_rrc_phyLayerParameters;         /* PhyLayerParameters */
static int hf_lte_rrc_rf_Parameters;              /* RF_Parameters */
static int hf_lte_rrc_measParameters;             /* T_measParameters */
static int hf_lte_rrc_featureGroupIndicators;     /* T_featureGroupIndicators */
static int hf_lte_rrc_interRAT_Parameters;        /* T_interRAT_Parameters */
static int hf_lte_rrc_utraFDD;                    /* IRAT_ParametersUTRA_FDD */
static int hf_lte_rrc_utraTDD128;                 /* IRAT_ParametersUTRA_TDD128 */
static int hf_lte_rrc_utraTDD384;                 /* IRAT_ParametersUTRA_TDD384 */
static int hf_lte_rrc_utraTDD768;                 /* IRAT_ParametersUTRA_TDD768 */
static int hf_lte_rrc_geran_02;                   /* IRAT_ParametersGERAN */
static int hf_lte_rrc_cdma2000_HRPD_01;           /* IRAT_ParametersCDMA2000_HRPD */
static int hf_lte_rrc_cdma2000_1xRTT_01;          /* IRAT_ParametersCDMA2000_1XRTT */
static int hf_lte_rrc_nonCriticalExtension_302;   /* UE_EUTRA_Capability_v920_IEs */
static int hf_lte_rrc_featureGroupIndRel9Add_r9;  /* T_featureGroupIndRel9Add_r9 */
static int hf_lte_rrc_fdd_Add_UE_EUTRA_Capabilities_r9;  /* UE_EUTRA_CapabilityAddXDD_Mode_r9 */
static int hf_lte_rrc_tdd_Add_UE_EUTRA_Capabilities_r9;  /* UE_EUTRA_CapabilityAddXDD_Mode_r9 */
static int hf_lte_rrc_nonCriticalExtension_303;   /* UE_EUTRA_Capability_v9c0_IEs */
static int hf_lte_rrc_interRAT_ParametersUTRA_v9c0;  /* IRAT_ParametersUTRA_v9c0 */
static int hf_lte_rrc_nonCriticalExtension_304;   /* UE_EUTRA_Capability_v9d0_IEs */
static int hf_lte_rrc_phyLayerParameters_v9d0;    /* PhyLayerParameters_v9d0 */
static int hf_lte_rrc_nonCriticalExtension_305;   /* UE_EUTRA_Capability_v9e0_IEs */
static int hf_lte_rrc_rf_Parameters_v9e0;         /* RF_Parameters_v9e0 */
static int hf_lte_rrc_nonCriticalExtension_306;   /* UE_EUTRA_Capability_v9h0_IEs */
static int hf_lte_rrc_interRAT_ParametersUTRA_v9h0;  /* IRAT_ParametersUTRA_v9h0 */
static int hf_lte_rrc_nonCriticalExtension_307;   /* UE_EUTRA_Capability_v10c0_IEs */
static int hf_lte_rrc_otdoa_PositioningCapabilities_r10;  /* OTDOA_PositioningCapabilities_r10 */
static int hf_lte_rrc_nonCriticalExtension_308;   /* UE_EUTRA_Capability_v10f0_IEs */
static int hf_lte_rrc_rf_Parameters_v10f0;        /* RF_Parameters_v10f0 */
static int hf_lte_rrc_nonCriticalExtension_309;   /* UE_EUTRA_Capability_v10i0_IEs */
static int hf_lte_rrc_rf_Parameters_v10i0;        /* RF_Parameters_v10i0 */
static int hf_lte_rrc_lateNonCriticalExtension_12;  /* T_lateNonCriticalExtension_11 */
static int hf_lte_rrc_nonCriticalExtension_310;   /* UE_EUTRA_Capability_v11d0_IEs */
static int hf_lte_rrc_rf_Parameters_v10j0;        /* RF_Parameters_v10j0 */
static int hf_lte_rrc_nonCriticalExtension_311;   /* T_nonCriticalExtension_81 */
static int hf_lte_rrc_rf_Parameters_v11d0;        /* RF_Parameters_v11d0 */
static int hf_lte_rrc_otherParameters_v11d0;      /* Other_Parameters_v11d0 */
static int hf_lte_rrc_nonCriticalExtension_312;   /* UE_EUTRA_Capability_v11x0_IEs */
static int hf_lte_rrc_nonCriticalExtension_313;   /* UE_EUTRA_Capability_v12b0_IEs */
static int hf_lte_rrc_rf_Parameters_v12b0;        /* RF_Parameters_v12b0 */
static int hf_lte_rrc_nonCriticalExtension_314;   /* UE_EUTRA_Capability_v12x0_IEs */
static int hf_lte_rrc_nonCriticalExtension_315;   /* UE_EUTRA_Capability_v1370_IEs */
static int hf_lte_rrc_ce_Parameters_v1370;        /* CE_Parameters_v1370 */
static int hf_lte_rrc_fdd_Add_UE_EUTRA_Capabilities_v1370;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1370 */
static int hf_lte_rrc_tdd_Add_UE_EUTRA_Capabilities_v1370;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1370 */
static int hf_lte_rrc_nonCriticalExtension_316;   /* UE_EUTRA_Capability_v1380_IEs */
static int hf_lte_rrc_rf_Parameters_v1380;        /* RF_Parameters_v1380 */
static int hf_lte_rrc_ce_Parameters_v1380;        /* CE_Parameters_v1380 */
static int hf_lte_rrc_fdd_Add_UE_EUTRA_Capabilities_v1380;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1380 */
static int hf_lte_rrc_tdd_Add_UE_EUTRA_Capabilities_v1380;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1380 */
static int hf_lte_rrc_nonCriticalExtension_317;   /* UE_EUTRA_Capability_v1390_IEs */
static int hf_lte_rrc_rf_Parameters_v1390;        /* RF_Parameters_v1390 */
static int hf_lte_rrc_nonCriticalExtension_318;   /* UE_EUTRA_Capability_v13e0a_IEs */
static int hf_lte_rrc_lateNonCriticalExtension_13;  /* T_lateNonCriticalExtension_12 */
static int hf_lte_rrc_nonCriticalExtension_319;   /* UE_EUTRA_Capability_v1470_IEs */
static int hf_lte_rrc_phyLayerParameters_v13e0;   /* PhyLayerParameters_v13e0 */
static int hf_lte_rrc_nonCriticalExtension_320;   /* T_nonCriticalExtension_82 */
static int hf_lte_rrc_mbms_Parameters_v1470;      /* MBMS_Parameters_v1470 */
static int hf_lte_rrc_phyLayerParameters_v1470;   /* PhyLayerParameters_v1470 */
static int hf_lte_rrc_rf_Parameters_v1470;        /* RF_Parameters_v1470 */
static int hf_lte_rrc_nonCriticalExtension_321;   /* UE_EUTRA_Capability_v14a0_IEs */
static int hf_lte_rrc_phyLayerParameters_v14a0;   /* PhyLayerParameters_v14a0 */
static int hf_lte_rrc_nonCriticalExtension_322;   /* UE_EUTRA_Capability_v14b0_IEs */
static int hf_lte_rrc_rf_Parameters_v14b0;        /* RF_Parameters_v14b0 */
static int hf_lte_rrc_nonCriticalExtension_323;   /* UE_EUTRA_Capability_v14x0_IEs */
static int hf_lte_rrc_nonCriticalExtension_324;   /* UE_EUTRA_Capability_v15x0_IEs */
static int hf_lte_rrc_nonCriticalExtension_325;   /* UE_EUTRA_Capability_v16c0_IEs */
static int hf_lte_rrc_measParameters_v16c0;       /* MeasParameters_v16c0 */
static int hf_lte_rrc_nonCriticalExtension_326;   /* T_nonCriticalExtension_83 */
static int hf_lte_rrc_phyLayerParameters_v920;    /* PhyLayerParameters_v920 */
static int hf_lte_rrc_interRAT_ParametersGERAN_v920;  /* IRAT_ParametersGERAN_v920 */
static int hf_lte_rrc_interRAT_ParametersUTRA_v920;  /* IRAT_ParametersUTRA_v920 */
static int hf_lte_rrc_interRAT_ParametersCDMA2000_v920;  /* IRAT_ParametersCDMA2000_1XRTT_v920 */
static int hf_lte_rrc_deviceType_r9;              /* T_deviceType_r9 */
static int hf_lte_rrc_csg_ProximityIndicationParameters_r9;  /* CSG_ProximityIndicationParameters_r9 */
static int hf_lte_rrc_neighCellSI_AcquisitionParameters_r9;  /* NeighCellSI_AcquisitionParameters_r9 */
static int hf_lte_rrc_son_Parameters_r9;          /* SON_Parameters_r9 */
static int hf_lte_rrc_nonCriticalExtension_327;   /* UE_EUTRA_Capability_v940_IEs */
static int hf_lte_rrc_lateNonCriticalExtension_14;  /* T_lateNonCriticalExtension_13 */
static int hf_lte_rrc_nonCriticalExtension_328;   /* UE_EUTRA_Capability_v1020_IEs */
static int hf_lte_rrc_ue_Category_v1020;          /* INTEGER_6_8 */
static int hf_lte_rrc_phyLayerParameters_v1020;   /* PhyLayerParameters_v1020 */
static int hf_lte_rrc_rf_Parameters_v1020;        /* RF_Parameters_v1020 */
static int hf_lte_rrc_measParameters_v1020;       /* MeasParameters_v1020 */
static int hf_lte_rrc_featureGroupIndRel10_r10;   /* T_featureGroupIndRel10_r10 */
static int hf_lte_rrc_interRAT_ParametersCDMA2000_v1020;  /* IRAT_ParametersCDMA2000_1XRTT_v1020 */
static int hf_lte_rrc_ue_BasedNetwPerfMeasParameters_r10;  /* UE_BasedNetwPerfMeasParameters_r10 */
static int hf_lte_rrc_interRAT_ParametersUTRA_TDD_v1020;  /* IRAT_ParametersUTRA_TDD_v1020 */
static int hf_lte_rrc_nonCriticalExtension_329;   /* UE_EUTRA_Capability_v1060_IEs */
static int hf_lte_rrc_fdd_Add_UE_EUTRA_Capabilities_v1060;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1060 */
static int hf_lte_rrc_tdd_Add_UE_EUTRA_Capabilities_v1060;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1060 */
static int hf_lte_rrc_rf_Parameters_v1060;        /* RF_Parameters_v1060 */
static int hf_lte_rrc_nonCriticalExtension_330;   /* UE_EUTRA_Capability_v1090_IEs */
static int hf_lte_rrc_rf_Parameters_v1090;        /* RF_Parameters_v1090 */
static int hf_lte_rrc_nonCriticalExtension_331;   /* UE_EUTRA_Capability_v1130_IEs */
static int hf_lte_rrc_pdcp_Parameters_v1130;      /* PDCP_Parameters_v1130 */
static int hf_lte_rrc_phyLayerParameters_v1130;   /* PhyLayerParameters_v1130 */
static int hf_lte_rrc_rf_Parameters_v1130;        /* RF_Parameters_v1130 */
static int hf_lte_rrc_measParameters_v1130;       /* MeasParameters_v1130 */
static int hf_lte_rrc_interRAT_ParametersCDMA2000_v1130;  /* IRAT_ParametersCDMA2000_v1130 */
static int hf_lte_rrc_otherParameters_r11;        /* Other_Parameters_r11 */
static int hf_lte_rrc_fdd_Add_UE_EUTRA_Capabilities_v1130;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1130 */
static int hf_lte_rrc_tdd_Add_UE_EUTRA_Capabilities_v1130;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1130 */
static int hf_lte_rrc_nonCriticalExtension_332;   /* UE_EUTRA_Capability_v1170_IEs */
static int hf_lte_rrc_phyLayerParameters_v1170;   /* PhyLayerParameters_v1170 */
static int hf_lte_rrc_ue_Category_v1170;          /* INTEGER_9_10 */
static int hf_lte_rrc_nonCriticalExtension_333;   /* UE_EUTRA_Capability_v1180_IEs */
static int hf_lte_rrc_rf_Parameters_v1180;        /* RF_Parameters_v1180 */
static int hf_lte_rrc_mbms_Parameters_r11;        /* MBMS_Parameters_r11 */
static int hf_lte_rrc_fdd_Add_UE_EUTRA_Capabilities_v1180;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1180 */
static int hf_lte_rrc_tdd_Add_UE_EUTRA_Capabilities_v1180;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1180 */
static int hf_lte_rrc_nonCriticalExtension_334;   /* UE_EUTRA_Capability_v11a0_IEs */
static int hf_lte_rrc_ue_Category_v11a0;          /* INTEGER_11_12 */
static int hf_lte_rrc_measParameters_v11a0;       /* MeasParameters_v11a0 */
static int hf_lte_rrc_nonCriticalExtension_335;   /* UE_EUTRA_Capability_v1250_IEs */
static int hf_lte_rrc_phyLayerParameters_v1250;   /* PhyLayerParameters_v1250 */
static int hf_lte_rrc_rf_Parameters_v1250;        /* RF_Parameters_v1250 */
static int hf_lte_rrc_rlc_Parameters_r12;         /* RLC_Parameters_r12 */
static int hf_lte_rrc_ue_BasedNetwPerfMeasParameters_v1250;  /* UE_BasedNetwPerfMeasParameters_v1250 */
static int hf_lte_rrc_ue_CategoryDL_r12;          /* INTEGER_0_14 */
static int hf_lte_rrc_ue_CategoryUL_r12;          /* INTEGER_0_13 */
static int hf_lte_rrc_wlan_IW_Parameters_r12;     /* WLAN_IW_Parameters_r12 */
static int hf_lte_rrc_measParameters_v1250;       /* MeasParameters_v1250 */
static int hf_lte_rrc_dc_Parameters_r12;          /* DC_Parameters_r12 */
static int hf_lte_rrc_mbms_Parameters_v1250;      /* MBMS_Parameters_v1250 */
static int hf_lte_rrc_mac_Parameters_r12;         /* MAC_Parameters_r12 */
static int hf_lte_rrc_fdd_Add_UE_EUTRA_Capabilities_v1250;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1250 */
static int hf_lte_rrc_tdd_Add_UE_EUTRA_Capabilities_v1250;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1250 */
static int hf_lte_rrc_sl_Parameters_r12;          /* SL_Parameters_r12 */
static int hf_lte_rrc_nonCriticalExtension_336;   /* UE_EUTRA_Capability_v1260_IEs */
static int hf_lte_rrc_ue_CategoryDL_v1260;        /* INTEGER_15_16 */
static int hf_lte_rrc_nonCriticalExtension_337;   /* UE_EUTRA_Capability_v1270_IEs */
static int hf_lte_rrc_rf_Parameters_v1270;        /* RF_Parameters_v1270 */
static int hf_lte_rrc_nonCriticalExtension_338;   /* UE_EUTRA_Capability_v1280_IEs */
static int hf_lte_rrc_phyLayerParameters_v1280;   /* PhyLayerParameters_v1280 */
static int hf_lte_rrc_nonCriticalExtension_339;   /* UE_EUTRA_Capability_v1310_IEs */
static int hf_lte_rrc_ue_CategoryDL_v1310;        /* T_ue_CategoryDL_v1310 */
static int hf_lte_rrc_ue_CategoryUL_v1310;        /* T_ue_CategoryUL_v1310 */
static int hf_lte_rrc_pdcp_Parameters_v1310;      /* PDCP_Parameters_v1310 */
static int hf_lte_rrc_rlc_Parameters_v1310;       /* RLC_Parameters_v1310 */
static int hf_lte_rrc_mac_Parameters_v1310;       /* MAC_Parameters_v1310 */
static int hf_lte_rrc_phyLayerParameters_v1310;   /* PhyLayerParameters_v1310 */
static int hf_lte_rrc_rf_Parameters_v1310;        /* RF_Parameters_v1310 */
static int hf_lte_rrc_measParameters_v1310;       /* MeasParameters_v1310 */
static int hf_lte_rrc_dc_Parameters_v1310;        /* DC_Parameters_v1310 */
static int hf_lte_rrc_sl_Parameters_v1310;        /* SL_Parameters_v1310 */
static int hf_lte_rrc_scptm_Parameters_r13;       /* SCPTM_Parameters_r13 */
static int hf_lte_rrc_ce_Parameters_r13;          /* CE_Parameters_r13 */
static int hf_lte_rrc_interRAT_ParametersWLAN_r13;  /* IRAT_ParametersWLAN_r13 */
static int hf_lte_rrc_laa_Parameters_r13;         /* LAA_Parameters_r13 */
static int hf_lte_rrc_lwa_Parameters_r13;         /* LWA_Parameters_r13 */
static int hf_lte_rrc_wlan_IW_Parameters_v1310;   /* WLAN_IW_Parameters_v1310 */
static int hf_lte_rrc_lwip_Parameters_r13;        /* LWIP_Parameters_r13 */
static int hf_lte_rrc_fdd_Add_UE_EUTRA_Capabilities_v1310;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1310 */
static int hf_lte_rrc_tdd_Add_UE_EUTRA_Capabilities_v1310;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1310 */
static int hf_lte_rrc_nonCriticalExtension_340;   /* UE_EUTRA_Capability_v1320_IEs */
static int hf_lte_rrc_ce_Parameters_v1320;        /* CE_Parameters_v1320 */
static int hf_lte_rrc_phyLayerParameters_v1320;   /* PhyLayerParameters_v1320 */
static int hf_lte_rrc_rf_Parameters_v1320;        /* RF_Parameters_v1320 */
static int hf_lte_rrc_fdd_Add_UE_EUTRA_Capabilities_v1320;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1320 */
static int hf_lte_rrc_tdd_Add_UE_EUTRA_Capabilities_v1320;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1320 */
static int hf_lte_rrc_nonCriticalExtension_341;   /* UE_EUTRA_Capability_v1330_IEs */
static int hf_lte_rrc_ue_CategoryDL_v1330;        /* INTEGER_18_19 */
static int hf_lte_rrc_phyLayerParameters_v1330;   /* PhyLayerParameters_v1330 */
static int hf_lte_rrc_ue_CE_NeedULGaps_r13_01;    /* T_ue_CE_NeedULGaps_r13_01 */
static int hf_lte_rrc_nonCriticalExtension_342;   /* UE_EUTRA_Capability_v1340_IEs */
static int hf_lte_rrc_ue_CategoryUL_v1340;        /* INTEGER_15 */
static int hf_lte_rrc_nonCriticalExtension_343;   /* UE_EUTRA_Capability_v1350_IEs */
static int hf_lte_rrc_ue_CategoryDL_v1350;        /* T_ue_CategoryDL_v1350 */
static int hf_lte_rrc_ue_CategoryUL_v1350;        /* T_ue_CategoryUL_v1350 */
static int hf_lte_rrc_ce_Parameters_v1350;        /* CE_Parameters_v1350 */
static int hf_lte_rrc_nonCriticalExtension_344;   /* UE_EUTRA_Capability_v1360_IEs */
static int hf_lte_rrc_other_Parameters_v1360;     /* Other_Parameters_v1360 */
static int hf_lte_rrc_nonCriticalExtension_345;   /* UE_EUTRA_Capability_v1430_IEs */
static int hf_lte_rrc_phyLayerParameters_v1430;   /* PhyLayerParameters_v1430 */
static int hf_lte_rrc_ue_CategoryDL_v1430;        /* T_ue_CategoryDL_v1430 */
static int hf_lte_rrc_ue_CategoryUL_v1430;        /* T_ue_CategoryUL_v1430 */
static int hf_lte_rrc_ue_CategoryUL_v1430b;       /* T_ue_CategoryUL_v1430b */
static int hf_lte_rrc_mac_Parameters_v1430;       /* MAC_Parameters_v1430 */
static int hf_lte_rrc_measParameters_v1430;       /* MeasParameters_v1430 */
static int hf_lte_rrc_pdcp_Parameters_v1430;      /* PDCP_Parameters_v1430 */
static int hf_lte_rrc_rlc_Parameters_v1430;       /* RLC_Parameters_v1430 */
static int hf_lte_rrc_rf_Parameters_v1430;        /* RF_Parameters_v1430 */
static int hf_lte_rrc_laa_Parameters_v1430;       /* LAA_Parameters_v1430 */
static int hf_lte_rrc_lwa_Parameters_v1430;       /* LWA_Parameters_v1430 */
static int hf_lte_rrc_lwip_Parameters_v1430;      /* LWIP_Parameters_v1430 */
static int hf_lte_rrc_otherParameters_v1430;      /* Other_Parameters_v1430 */
static int hf_lte_rrc_mmtel_Parameters_r14;       /* MMTEL_Parameters_r14 */
static int hf_lte_rrc_mobilityParameters_r14;     /* MobilityParameters_r14 */
static int hf_lte_rrc_ce_Parameters_v1430;        /* CE_Parameters_v1430 */
static int hf_lte_rrc_fdd_Add_UE_EUTRA_Capabilities_v1430;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1430 */
static int hf_lte_rrc_tdd_Add_UE_EUTRA_Capabilities_v1430;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1430 */
static int hf_lte_rrc_mbms_Parameters_v1430;      /* MBMS_Parameters_v1430 */
static int hf_lte_rrc_sl_Parameters_v1430;        /* SL_Parameters_v1430 */
static int hf_lte_rrc_ue_BasedNetwPerfMeasParameters_v1430;  /* UE_BasedNetwPerfMeasParameters_v1430 */
static int hf_lte_rrc_highSpeedEnhParameters_r14;  /* HighSpeedEnhParameters_r14 */
static int hf_lte_rrc_nonCriticalExtension_346;   /* UE_EUTRA_Capability_v1440_IEs */
static int hf_lte_rrc_lwa_Parameters_v1440;       /* LWA_Parameters_v1440 */
static int hf_lte_rrc_mac_Parameters_v1440;       /* MAC_Parameters_v1440 */
static int hf_lte_rrc_nonCriticalExtension_347;   /* UE_EUTRA_Capability_v1450_IEs */
static int hf_lte_rrc_phyLayerParameters_v1450;   /* PhyLayerParameters_v1450 */
static int hf_lte_rrc_rf_Parameters_v1450;        /* RF_Parameters_v1450 */
static int hf_lte_rrc_otherParameters_v1450;      /* OtherParameters_v1450 */
static int hf_lte_rrc_ue_CategoryDL_v1450;        /* INTEGER_20 */
static int hf_lte_rrc_nonCriticalExtension_348;   /* UE_EUTRA_Capability_v1460_IEs */
static int hf_lte_rrc_ue_CategoryDL_v1460;        /* INTEGER_21 */
static int hf_lte_rrc_otherParameters_v1460;      /* Other_Parameters_v1460 */
static int hf_lte_rrc_nonCriticalExtension_349;   /* UE_EUTRA_Capability_v1510_IEs */
static int hf_lte_rrc_irat_ParametersNR_r15;      /* IRAT_ParametersNR_r15 */
static int hf_lte_rrc_featureSetsEUTRA_r15;       /* FeatureSetsEUTRA_r15 */
static int hf_lte_rrc_pdcp_ParametersNR_r15;      /* PDCP_ParametersNR_r15 */
static int hf_lte_rrc_fdd_Add_UE_EUTRA_Capabilities_v1510;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1510 */
static int hf_lte_rrc_tdd_Add_UE_EUTRA_Capabilities_v1510;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1510 */
static int hf_lte_rrc_nonCriticalExtension_350;   /* UE_EUTRA_Capability_v1520_IEs */
static int hf_lte_rrc_measParameters_v1520;       /* MeasParameters_v1520 */
static int hf_lte_rrc_nonCriticalExtension_351;   /* UE_EUTRA_Capability_v1530_IEs */
static int hf_lte_rrc_measParameters_v1530;       /* MeasParameters_v1530 */
static int hf_lte_rrc_otherParameters_v1530;      /* Other_Parameters_v1530 */
static int hf_lte_rrc_neighCellSI_AcquisitionParameters_v1530;  /* NeighCellSI_AcquisitionParameters_v1530 */
static int hf_lte_rrc_mac_Parameters_v1530;       /* MAC_Parameters_v1530 */
static int hf_lte_rrc_phyLayerParameters_v1530;   /* PhyLayerParameters_v1530 */
static int hf_lte_rrc_rf_Parameters_v1530;        /* RF_Parameters_v1530 */
static int hf_lte_rrc_pdcp_Parameters_v1530;      /* PDCP_Parameters_v1530 */
static int hf_lte_rrc_ue_CategoryDL_v1530;        /* INTEGER_22_26 */
static int hf_lte_rrc_ue_BasedNetwPerfMeasParameters_v1530;  /* UE_BasedNetwPerfMeasParameters_v1530 */
static int hf_lte_rrc_rlc_Parameters_v1530;       /* RLC_Parameters_v1530 */
static int hf_lte_rrc_sl_Parameters_v1530;        /* SL_Parameters_v1530 */
static int hf_lte_rrc_extendedNumberOfDRBs_r15;   /* T_extendedNumberOfDRBs_r15 */
static int hf_lte_rrc_reducedCP_Latency_r15;      /* T_reducedCP_Latency_r15 */
static int hf_lte_rrc_laa_Parameters_v1530;       /* LAA_Parameters_v1530 */
static int hf_lte_rrc_ue_CategoryUL_v1530;        /* INTEGER_22_26 */
static int hf_lte_rrc_fdd_Add_UE_EUTRA_Capabilities_v1530;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1530 */
static int hf_lte_rrc_tdd_Add_UE_EUTRA_Capabilities_v1530;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1530 */
static int hf_lte_rrc_nonCriticalExtension_352;   /* UE_EUTRA_Capability_v1540_IEs */
static int hf_lte_rrc_phyLayerParameters_v1540;   /* PhyLayerParameters_v1540 */
static int hf_lte_rrc_otherParameters_v1540;      /* Other_Parameters_v1540 */
static int hf_lte_rrc_fdd_Add_UE_EUTRA_Capabilities_v1540;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1540 */
static int hf_lte_rrc_tdd_Add_UE_EUTRA_Capabilities_v1540;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1540 */
static int hf_lte_rrc_sl_Parameters_v1540;        /* SL_Parameters_v1540 */
static int hf_lte_rrc_irat_ParametersNR_v1540;    /* IRAT_ParametersNR_v1540 */
static int hf_lte_rrc_nonCriticalExtension_353;   /* UE_EUTRA_Capability_v1550_IEs */
static int hf_lte_rrc_neighCellSI_AcquisitionParameters_v1550;  /* NeighCellSI_AcquisitionParameters_v1550 */
static int hf_lte_rrc_phyLayerParameters_v1550;   /* PhyLayerParameters_v1550 */
static int hf_lte_rrc_mac_Parameters_v1550;       /* MAC_Parameters_v1550 */
static int hf_lte_rrc_fdd_Add_UE_EUTRA_Capabilities_v1550;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1550 */
static int hf_lte_rrc_tdd_Add_UE_EUTRA_Capabilities_v1550;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1550 */
static int hf_lte_rrc_nonCriticalExtension_354;   /* UE_EUTRA_Capability_v1560_IEs */
static int hf_lte_rrc_pdcp_ParametersNR_v1560;    /* PDCP_ParametersNR_v1560 */
static int hf_lte_rrc_irat_ParametersNR_v1560;    /* IRAT_ParametersNR_v1560 */
static int hf_lte_rrc_appliedCapabilityFilterCommon_r15;  /* T_appliedCapabilityFilterCommon_r15 */
static int hf_lte_rrc_fdd_Add_UE_EUTRA_Capabilities_v1560;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1560 */
static int hf_lte_rrc_tdd_Add_UE_EUTRA_Capabilities_v1560;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1560 */
static int hf_lte_rrc_nonCriticalExtension_355;   /* UE_EUTRA_Capability_v1570_IEs */
static int hf_lte_rrc_rf_Parameters_v1570;        /* RF_Parameters_v1570 */
static int hf_lte_rrc_irat_ParametersNR_v1570;    /* IRAT_ParametersNR_v1570 */
static int hf_lte_rrc_nonCriticalExtension_356;   /* UE_EUTRA_Capability_v15a0_IEs */
static int hf_lte_rrc_neighCellSI_AcquisitionParameters_v15a0;  /* NeighCellSI_AcquisitionParameters_v15a0 */
static int hf_lte_rrc_eutra_5GC_Parameters_r15;   /* EUTRA_5GC_Parameters_r15 */
static int hf_lte_rrc_fdd_Add_UE_EUTRA_Capabilities_v15a0;  /* UE_EUTRA_CapabilityAddXDD_Mode_v15a0 */
static int hf_lte_rrc_tdd_Add_UE_EUTRA_Capabilities_v15a0;  /* UE_EUTRA_CapabilityAddXDD_Mode_v15a0 */
static int hf_lte_rrc_nonCriticalExtension_357;   /* UE_EUTRA_Capability_v1610_IEs */
static int hf_lte_rrc_highSpeedEnhParameters_v1610;  /* HighSpeedEnhParameters_v1610 */
static int hf_lte_rrc_neighCellSI_AcquisitionParameters_v1610;  /* NeighCellSI_AcquisitionParameters_v1610 */
static int hf_lte_rrc_mbms_Parameters_v1610;      /* MBMS_Parameters_v1610 */
static int hf_lte_rrc_pdcp_Parameters_v1610;      /* PDCP_Parameters_v1610 */
static int hf_lte_rrc_mac_Parameters_v1610;       /* MAC_Parameters_v1610 */
static int hf_lte_rrc_phyLayerParameters_v1610;   /* PhyLayerParameters_v1610 */
static int hf_lte_rrc_measParameters_v1610;       /* MeasParameters_v1610 */
static int hf_lte_rrc_pur_Parameters_r16;         /* PUR_Parameters_r16 */
static int hf_lte_rrc_eutra_5GC_Parameters_v1610;  /* EUTRA_5GC_Parameters_v1610 */
static int hf_lte_rrc_otherParameters_v1610;      /* Other_Parameters_v1610 */
static int hf_lte_rrc_dl_DedicatedMessageSegmentation_r16;  /* T_dl_DedicatedMessageSegmentation_r16 */
static int hf_lte_rrc_mmtel_Parameters_v1610;     /* MMTEL_Parameters_v1610 */
static int hf_lte_rrc_irat_ParametersNR_v1610;    /* IRAT_ParametersNR_v1610 */
static int hf_lte_rrc_rf_Parameters_v1610;        /* RF_Parameters_v1610 */
static int hf_lte_rrc_mobilityParameters_v1610;   /* MobilityParameters_v1610 */
static int hf_lte_rrc_ue_BasedNetwPerfMeasParameters_v1610;  /* UE_BasedNetwPerfMeasParameters_v1610 */
static int hf_lte_rrc_sl_Parameters_v1610;        /* SL_Parameters_v1610 */
static int hf_lte_rrc_fdd_Add_UE_EUTRA_Capabilities_v1610;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1610 */
static int hf_lte_rrc_tdd_Add_UE_EUTRA_Capabilities_v1610;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1610 */
static int hf_lte_rrc_nonCriticalExtension_358;   /* UE_EUTRA_Capability_v1630_IEs */
static int hf_lte_rrc_rf_Parameters_v1630;        /* RF_Parameters_v1630 */
static int hf_lte_rrc_sl_Parameters_v1630;        /* SL_Parameters_v1630 */
static int hf_lte_rrc_earlySecurityReactivation_r16_01;  /* T_earlySecurityReactivation_r16_01 */
static int hf_lte_rrc_mac_Parameters_v1630;       /* MAC_Parameters_v1630 */
static int hf_lte_rrc_measParameters_v1630;       /* MeasParameters_v1630 */
static int hf_lte_rrc_fdd_Add_UE_EUTRA_Capabilities_v1630;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1630 */
static int hf_lte_rrc_tdd_Add_UE_EUTRA_Capabilities_v1630;  /* UE_EUTRA_CapabilityAddXDD_Mode_v1630 */
static int hf_lte_rrc_nonCriticalExtension_359;   /* UE_EUTRA_Capability_v1650_IEs */
static int hf_lte_rrc_otherParameters_v1650;      /* Other_Parameters_v1650 */
static int hf_lte_rrc_nonCriticalExtension_360;   /* UE_EUTRA_Capability_v1660_IEs */
static int hf_lte_rrc_irat_ParametersNR_v1660;    /* IRAT_ParametersNR_v1660 */
static int hf_lte_rrc_nonCriticalExtension_361;   /* UE_EUTRA_Capability_v1690_IEs */
static int hf_lte_rrc_other_Parameters_v1690;     /* Other_Parameters_v1690 */
static int hf_lte_rrc_nonCriticalExtension_362;   /* UE_EUTRA_Capability_v1700_IEs */
static int hf_lte_rrc_measParameters_v1700;       /* MeasParameters_v1700 */
static int hf_lte_rrc_ue_BasedNetwPerfMeasParameters_v1700;  /* UE_BasedNetwPerfMeasParameters_v1700 */
static int hf_lte_rrc_phyLayerParameters_v1700;   /* PhyLayerParameters_v1700 */
static int hf_lte_rrc_ntn_Parameters_r17;         /* NTN_Parameters_r17 */
static int hf_lte_rrc_irat_ParametersNR_v1700;    /* IRAT_ParametersNR_v1700 */
static int hf_lte_rrc_mbms_Parameters_v1700;      /* MBMS_Parameters_v1700 */
static int hf_lte_rrc_nonCriticalExtension_363;   /* UE_EUTRA_Capability_v1710_IEs */
static int hf_lte_rrc_irat_ParametersNR_v1710;    /* IRAT_ParametersNR_v1710 */
static int hf_lte_rrc_neighCellSI_AcquisitionParameters_v1710;  /* NeighCellSI_AcquisitionParameters_v1710 */
static int hf_lte_rrc_sl_Parameters_v1710;        /* SL_Parameters_v1710 */
static int hf_lte_rrc_sidelinkRequested_r17;      /* T_sidelinkRequested_r17 */
static int hf_lte_rrc_nonCriticalExtension_364;   /* UE_EUTRA_Capability_v1720_IEs */
static int hf_lte_rrc_ntn_Parameters_v1720;       /* NTN_Parameters_v1720 */
static int hf_lte_rrc_nonCriticalExtension_365;   /* UE_EUTRA_Capability_v1730_IEs */
static int hf_lte_rrc_phyLayerParameters_v1730;   /* PhyLayerParameters_v1730 */
static int hf_lte_rrc_nonCriticalExtension_366;   /* UE_EUTRA_Capability_v1770_IEs */
static int hf_lte_rrc_measParameters_v1770;       /* MeasParameters_v1770 */
static int hf_lte_rrc_nonCriticalExtension_367;   /* UE_EUTRA_Capability_v1800_IEs */
static int hf_lte_rrc_measParameters_v1800;       /* MeasParameters_v1800 */
static int hf_lte_rrc_rf_Parameters_v1800;        /* RF_Parameters_v1800 */
static int hf_lte_rrc_ntn_Parameters_v1800;       /* NTN_Parameters_v1800 */
static int hf_lte_rrc_sl_Parameters_v1800;        /* SL_Parameters_v1800 */
static int hf_lte_rrc_son_Parameters_v1800;       /* SON_Parameters_v1800 */
static int hf_lte_rrc_ue_BasedNetwPerfMeasParameters_v1800;  /* UE_BasedNetwPerfMeasParameters_v1800 */
static int hf_lte_rrc_nonCriticalExtension_368;   /* T_nonCriticalExtension_84 */
static int hf_lte_rrc_phyLayerParameters_r9;      /* PhyLayerParameters */
static int hf_lte_rrc_featureGroupIndicators_r9;  /* T_featureGroupIndicators_r9 */
static int hf_lte_rrc_featureGroupIndRel9Add_r9_01;  /* T_featureGroupIndRel9Add_r9_01 */
static int hf_lte_rrc_interRAT_ParametersGERAN_r9;  /* IRAT_ParametersGERAN */
static int hf_lte_rrc_interRAT_ParametersUTRA_r9;  /* IRAT_ParametersUTRA_v920 */
static int hf_lte_rrc_interRAT_ParametersCDMA2000_r9;  /* IRAT_ParametersCDMA2000_1XRTT_v920 */
static int hf_lte_rrc_phyLayerParameters_v1060;   /* PhyLayerParameters_v1020 */
static int hf_lte_rrc_featureGroupIndRel10_v1060;  /* T_featureGroupIndRel10_v1060 */
static int hf_lte_rrc_interRAT_ParametersCDMA2000_v1060;  /* IRAT_ParametersCDMA2000_1XRTT_v1020 */
static int hf_lte_rrc_interRAT_ParametersUTRA_TDD_v1060;  /* IRAT_ParametersUTRA_TDD_v1020 */
static int hf_lte_rrc_reducedCP_Latency_r15_01;   /* T_reducedCP_Latency_r15_01 */
static int hf_lte_rrc_featureSetsDL_r15;          /* SEQUENCE_SIZE_1_maxFeatureSets_r15_OF_FeatureSetDL_r15 */
static int hf_lte_rrc_featureSetsDL_r15_item;     /* FeatureSetDL_r15 */
static int hf_lte_rrc_featureSetsDL_PerCC_r15;    /* SEQUENCE_SIZE_1_maxPerCC_FeatureSets_r15_OF_FeatureSetDL_PerCC_r15 */
static int hf_lte_rrc_featureSetsDL_PerCC_r15_item;  /* FeatureSetDL_PerCC_r15 */
static int hf_lte_rrc_featureSetsUL_r15;          /* SEQUENCE_SIZE_1_maxFeatureSets_r15_OF_FeatureSetUL_r15 */
static int hf_lte_rrc_featureSetsUL_r15_item;     /* FeatureSetUL_r15 */
static int hf_lte_rrc_featureSetsUL_PerCC_r15;    /* SEQUENCE_SIZE_1_maxPerCC_FeatureSets_r15_OF_FeatureSetUL_PerCC_r15 */
static int hf_lte_rrc_featureSetsUL_PerCC_r15_item;  /* FeatureSetUL_PerCC_r15 */
static int hf_lte_rrc_featureSetsDL_v1550;        /* SEQUENCE_SIZE_1_maxFeatureSets_r15_OF_FeatureSetDL_v1550 */
static int hf_lte_rrc_featureSetsDL_v1550_item;   /* FeatureSetDL_v1550 */
static int hf_lte_rrc_makeBeforeBreak_r14_01;     /* T_makeBeforeBreak_r14_01 */
static int hf_lte_rrc_rach_Less_r14;              /* T_rach_Less_r14 */
static int hf_lte_rrc_cho_r16;                    /* T_cho_r16 */
static int hf_lte_rrc_cho_FDD_TDD_r16;            /* T_cho_FDD_TDD_r16 */
static int hf_lte_rrc_cho_Failure_r16;            /* T_cho_Failure_r16 */
static int hf_lte_rrc_cho_TwoTriggerEvents_r16;   /* T_cho_TwoTriggerEvents_r16 */
static int hf_lte_rrc_drb_TypeSplit_r12;          /* T_drb_TypeSplit_r12 */
static int hf_lte_rrc_drb_TypeSCG_r12;            /* T_drb_TypeSCG_r12 */
static int hf_lte_rrc_pdcp_TransferSplitUL_r13;   /* T_pdcp_TransferSplitUL_r13 */
static int hf_lte_rrc_ue_SSTD_Meas_r13;           /* T_ue_SSTD_Meas_r13 */
static int hf_lte_rrc_logicalChannelSR_ProhibitTimer_r12_01;  /* T_logicalChannelSR_ProhibitTimer_r12_01 */
static int hf_lte_rrc_longDRX_Command_r12;        /* T_longDRX_Command_r12 */
static int hf_lte_rrc_extendedMAC_LengthField_r13;  /* T_extendedMAC_LengthField_r13 */
static int hf_lte_rrc_extendedLongDRX_r13;        /* T_extendedLongDRX_r13 */
static int hf_lte_rrc_shortSPS_IntervalFDD_r14;   /* T_shortSPS_IntervalFDD_r14 */
static int hf_lte_rrc_shortSPS_IntervalTDD_r14;   /* T_shortSPS_IntervalTDD_r14 */
static int hf_lte_rrc_skipUplinkDynamic_r14;      /* T_skipUplinkDynamic_r14 */
static int hf_lte_rrc_skipUplinkSPS_r14;          /* T_skipUplinkSPS_r14 */
static int hf_lte_rrc_multipleUplinkSPS_r14;      /* T_multipleUplinkSPS_r14 */
static int hf_lte_rrc_dataInactMon_r14;           /* T_dataInactMon_r14 */
static int hf_lte_rrc_rai_Support_r14;            /* T_rai_Support_r14 */
static int hf_lte_rrc_min_Proc_TimelineSubslot_r15;  /* SEQUENCE_SIZE_1_3_OF_ProcessingTimelineSet_r15 */
static int hf_lte_rrc_min_Proc_TimelineSubslot_r15_item;  /* ProcessingTimelineSet_r15 */
static int hf_lte_rrc_skipSubframeProcessing_r15;  /* SkipSubframeProcessing_r15 */
static int hf_lte_rrc_earlyData_UP_r15;           /* T_earlyData_UP_r15 */
static int hf_lte_rrc_dormantSCellState_r15;      /* T_dormantSCellState_r15 */
static int hf_lte_rrc_directSCellActivation_r15;  /* T_directSCellActivation_r15 */
static int hf_lte_rrc_directSCellHibernation_r15;  /* T_directSCellHibernation_r15 */
static int hf_lte_rrc_extendedLCID_Duplication_r15;  /* T_extendedLCID_Duplication_r15 */
static int hf_lte_rrc_sps_ServingCell_r15;        /* T_sps_ServingCell_r15 */
static int hf_lte_rrc_eLCID_Support_r15;          /* T_eLCID_Support_r15 */
static int hf_lte_rrc_directMCG_SCellActivationResume_r16;  /* T_directMCG_SCellActivationResume_r16 */
static int hf_lte_rrc_directSCG_SCellActivationResume_r16;  /* T_directSCG_SCellActivationResume_r16 */
static int hf_lte_rrc_earlyData_UP_5GC_r16;       /* T_earlyData_UP_5GC_r16 */
static int hf_lte_rrc_rai_SupportEnh_r16;         /* T_rai_SupportEnh_r16 */
static int hf_lte_rrc_directSCG_SCellActivationNEDC_r16;  /* T_directSCG_SCellActivationNEDC_r16 */
static int hf_lte_rrc_ntn_Connectivity_EPC_r17;   /* T_ntn_Connectivity_EPC_r17 */
static int hf_lte_rrc_ntn_TA_Report_r17;          /* T_ntn_TA_Report_r17 */
static int hf_lte_rrc_ntn_PUR_TimerDelay_r17;     /* T_ntn_PUR_TimerDelay_r17 */
static int hf_lte_rrc_ntn_OffsetTimingEnh_r17;    /* T_ntn_OffsetTimingEnh_r17 */
static int hf_lte_rrc_ntn_ScenarioSupport_r17;    /* T_ntn_ScenarioSupport_r17 */
static int hf_lte_rrc_ntn_SegmentedPrecompensationGaps_r17;  /* T_ntn_SegmentedPrecompensationGaps_r17 */
static int hf_lte_rrc_ntn_EventA4BasedCHO_r18;    /* T_ntn_EventA4BasedCHO_r18 */
static int hf_lte_rrc_ntn_LocationBasedCHO_EFC_r18;  /* T_ntn_LocationBasedCHO_EFC_r18 */
static int hf_lte_rrc_ntn_LocationBasedCHO_EMC_r18;  /* T_ntn_LocationBasedCHO_EMC_r18 */
static int hf_lte_rrc_ntn_TimeBasedCHO_r18;       /* T_ntn_TimeBasedCHO_r18 */
static int hf_lte_rrc_eventD1_MeasReportTrigger_r18;  /* T_eventD1_MeasReportTrigger_r18 */
static int hf_lte_rrc_eventD2_MeasReportTrigger_r18;  /* T_eventD2_MeasReportTrigger_r18 */
static int hf_lte_rrc_ntn_LocationBasedMeasTrigger_EFC_r18;  /* T_ntn_LocationBasedMeasTrigger_EFC_r18 */
static int hf_lte_rrc_ntn_LocationBasedMeasTrigger_EMC_r18;  /* T_ntn_LocationBasedMeasTrigger_EMC_r18 */
static int hf_lte_rrc_ntn_TimeBasedMeasTrigger_r18;  /* T_ntn_TimeBasedMeasTrigger_r18 */
static int hf_lte_rrc_ntn_RRC_HarqDisableSingleTB_CE_ModeA_r18;  /* T_ntn_RRC_HarqDisableSingleTB_CE_ModeA_r18 */
static int hf_lte_rrc_ntn_RRC_HarqDisableMultiTB_CE_ModeA_r18;  /* T_ntn_RRC_HarqDisableMultiTB_CE_ModeA_r18 */
static int hf_lte_rrc_ntn_RRC_HarqDisableSingleTB_CE_ModeB_r18;  /* T_ntn_RRC_HarqDisableSingleTB_CE_ModeB_r18 */
static int hf_lte_rrc_ntn_OverriddenHarqDisableSingleTB_CE_ModeB_r18;  /* T_ntn_OverriddenHarqDisableSingleTB_CE_ModeB_r18 */
static int hf_lte_rrc_ntn_DCI_HarqDisableSingleTB_CE_ModeB_r18;  /* T_ntn_DCI_HarqDisableSingleTB_CE_ModeB_r18 */
static int hf_lte_rrc_ntn_RRC_HarqDisableMultiTB_CE_ModeB_r18;  /* T_ntn_RRC_HarqDisableMultiTB_CE_ModeB_r18 */
static int hf_lte_rrc_ntn_OverriddenHarqDisableMultiTB_CE_ModeB_r18;  /* T_ntn_OverriddenHarqDisableMultiTB_CE_ModeB_r18 */
static int hf_lte_rrc_ntn_DCI_HarqDisableMultiTB_CE_ModeB_r18;  /* T_ntn_DCI_HarqDisableMultiTB_CE_ModeB_r18 */
static int hf_lte_rrc_ntn_SemiStaticHarqDisableSPS_r18;  /* T_ntn_SemiStaticHarqDisableSPS_r18 */
static int hf_lte_rrc_ntn_UplinkHarq_ModeB_SingleTB_r18;  /* T_ntn_UplinkHarq_ModeB_SingleTB_r18 */
static int hf_lte_rrc_ntn_UplinkHarq_ModeB_MultiTB_r18;  /* T_ntn_UplinkHarq_ModeB_MultiTB_r18 */
static int hf_lte_rrc_ntn_HarqEnhScenarioSupport_r18;  /* T_ntn_HarqEnhScenarioSupport_r18 */
static int hf_lte_rrc_ntn_Triggered_GNSS_Fix_r18;  /* T_ntn_Triggered_GNSS_Fix_r18 */
static int hf_lte_rrc_ntn_Autonomous_GNSS_Fix_r18;  /* T_ntn_Autonomous_GNSS_Fix_r18 */
static int hf_lte_rrc_ntn_UplinkTxExtension_r18;  /* T_ntn_UplinkTxExtension_r18 */
static int hf_lte_rrc_ntn_GNSS_EnhScenarioSupport_r18;  /* T_ntn_GNSS_EnhScenarioSupport_r18 */
static int hf_lte_rrc_extended_RLC_LI_Field_r12;  /* T_extended_RLC_LI_Field_r12 */
static int hf_lte_rrc_extendedRLC_SN_SO_Field_r13;  /* T_extendedRLC_SN_SO_Field_r13 */
static int hf_lte_rrc_extendedPollByte_r14;       /* T_extendedPollByte_r14 */
static int hf_lte_rrc_flexibleUM_AM_Combinations_r15;  /* T_flexibleUM_AM_Combinations_r15 */
static int hf_lte_rrc_rlc_AM_Ooo_Delivery_r15;    /* T_rlc_AM_Ooo_Delivery_r15 */
static int hf_lte_rrc_rlc_UM_Ooo_Delivery_r15;    /* T_rlc_UM_Ooo_Delivery_r15 */
static int hf_lte_rrc_supportedROHC_Profiles;     /* ROHC_ProfileSupportList_r15 */
static int hf_lte_rrc_maxNumberROHC_ContextSessions;  /* T_maxNumberROHC_ContextSessions */
static int hf_lte_rrc_pdcp_SN_Extension_r11;      /* T_pdcp_SN_Extension_r11 */
static int hf_lte_rrc_supportRohcContextContinue_r11;  /* T_supportRohcContextContinue_r11 */
static int hf_lte_rrc_pdcp_SN_Extension_18bits_r13;  /* T_pdcp_SN_Extension_18bits_r13 */
static int hf_lte_rrc_supportedUplinkOnlyROHC_Profiles_r14;  /* T_supportedUplinkOnlyROHC_Profiles_r14 */
static int hf_lte_rrc_maxNumberROHC_ContextSessions_r14;  /* T_maxNumberROHC_ContextSessions_r14 */
static int hf_lte_rrc_supportedUDC_r15;           /* SupportedUDC_r15 */
static int hf_lte_rrc_pdcp_Duplication_r15_01;    /* T_pdcp_Duplication_r15_01 */
static int hf_lte_rrc_pdcp_VersionChangeWithoutHO_r16;  /* T_pdcp_VersionChangeWithoutHO_r16 */
static int hf_lte_rrc_ehc_r16;                    /* T_ehc_r16 */
static int hf_lte_rrc_continueEHC_Context_r16;    /* T_continueEHC_Context_r16 */
static int hf_lte_rrc_maxNumberEHC_Contexts_r16;  /* T_maxNumberEHC_Contexts_r16 */
static int hf_lte_rrc_jointEHC_ROHC_Config_r16;   /* T_jointEHC_ROHC_Config_r16 */
static int hf_lte_rrc_supportedStandardDic_r15;   /* T_supportedStandardDic_r15 */
static int hf_lte_rrc_supportedOperatorDic_r15;   /* SupportedOperatorDic_r15 */
static int hf_lte_rrc_versionOfDictionary_r15;    /* INTEGER_0_15 */
static int hf_lte_rrc_associatedPLMN_ID_r15;      /* PLMN_Identity */
static int hf_lte_rrc_ue_TxAntennaSelectionSupported;  /* BOOLEAN */
static int hf_lte_rrc_ue_SpecificRefSigsSupported;  /* BOOLEAN */
static int hf_lte_rrc_enhancedDualLayerFDD_r9;    /* T_enhancedDualLayerFDD_r9 */
static int hf_lte_rrc_enhancedDualLayerTDD_r9;    /* T_enhancedDualLayerTDD_r9 */
static int hf_lte_rrc_tm5_FDD_r9;                 /* T_tm5_FDD_r9 */
static int hf_lte_rrc_tm5_TDD_r9;                 /* T_tm5_TDD_r9 */
static int hf_lte_rrc_twoAntennaPortsForPUCCH_r10;  /* T_twoAntennaPortsForPUCCH_r10 */
static int hf_lte_rrc_tm9_With_8Tx_FDD_r10;       /* T_tm9_With_8Tx_FDD_r10 */
static int hf_lte_rrc_pmi_Disabling_r10;          /* T_pmi_Disabling_r10 */
static int hf_lte_rrc_crossCarrierScheduling_r10;  /* T_crossCarrierScheduling_r10 */
static int hf_lte_rrc_simultaneousPUCCH_PUSCH_r10_01;  /* T_simultaneousPUCCH_PUSCH_r10_01 */
static int hf_lte_rrc_multiClusterPUSCH_WithinCC_r10;  /* T_multiClusterPUSCH_WithinCC_r10 */
static int hf_lte_rrc_nonContiguousUL_RA_WithinCC_List_r10;  /* NonContiguousUL_RA_WithinCC_List_r10 */
static int hf_lte_rrc_crs_InterfHandl_r11;        /* T_crs_InterfHandl_r11 */
static int hf_lte_rrc_ePDCCH_r11;                 /* T_ePDCCH_r11 */
static int hf_lte_rrc_multiACK_CSI_Reporting_r11;  /* T_multiACK_CSI_Reporting_r11 */
static int hf_lte_rrc_ss_CCH_InterfHandl_r11;     /* T_ss_CCH_InterfHandl_r11 */
static int hf_lte_rrc_tdd_SpecialSubframe_r11;    /* T_tdd_SpecialSubframe_r11 */
static int hf_lte_rrc_txDiv_PUCCH1b_ChSelect_r11;  /* T_txDiv_PUCCH1b_ChSelect_r11 */
static int hf_lte_rrc_ul_CoMP_r11;                /* T_ul_CoMP_r11 */
static int hf_lte_rrc_interBandTDD_CA_WithDifferentConfig_r11;  /* T_interBandTDD_CA_WithDifferentConfig_r11 */
static int hf_lte_rrc_e_HARQ_Pattern_FDD_r12;     /* T_e_HARQ_Pattern_FDD_r12 */
static int hf_lte_rrc_enhanced_4TxCodebook_r12;   /* T_enhanced_4TxCodebook_r12 */
static int hf_lte_rrc_tdd_FDD_CA_PCellDuplex_r12;  /* T_tdd_FDD_CA_PCellDuplex_r12 */
static int hf_lte_rrc_phy_TDD_ReConfig_TDD_PCell_r12;  /* T_phy_TDD_ReConfig_TDD_PCell_r12 */
static int hf_lte_rrc_phy_TDD_ReConfig_FDD_PCell_r12;  /* T_phy_TDD_ReConfig_FDD_PCell_r12 */
static int hf_lte_rrc_pusch_FeedbackMode_r12;     /* T_pusch_FeedbackMode_r12 */
static int hf_lte_rrc_pusch_SRS_PowerControl_SubframeSet_r12;  /* T_pusch_SRS_PowerControl_SubframeSet_r12 */
static int hf_lte_rrc_csi_SubframeSet_r12;        /* T_csi_SubframeSet_r12 */
static int hf_lte_rrc_noResourceRestrictionForTTIBundling_r12;  /* T_noResourceRestrictionForTTIBundling_r12 */
static int hf_lte_rrc_discoverySignalsInDeactSCell_r12;  /* T_discoverySignalsInDeactSCell_r12 */
static int hf_lte_rrc_naics_Capability_List_r12;  /* NAICS_Capability_List_r12 */
static int hf_lte_rrc_alternativeTBS_Indices_r12;  /* T_alternativeTBS_Indices_r12 */
static int hf_lte_rrc_aperiodicCSI_Reporting_r13;  /* T_aperiodicCSI_Reporting_r13 */
static int hf_lte_rrc_codebook_HARQ_ACK_r13;      /* T_codebook_HARQ_ACK_r13 */
static int hf_lte_rrc_crossCarrierScheduling_B5C_r13;  /* T_crossCarrierScheduling_B5C_r13 */
static int hf_lte_rrc_fdd_HARQ_TimingTDD_r13;     /* T_fdd_HARQ_TimingTDD_r13 */
static int hf_lte_rrc_maxNumberUpdatedCSI_Proc_r13;  /* INTEGER_5_32 */
static int hf_lte_rrc_pucch_Format4_r13;          /* T_pucch_Format4_r13 */
static int hf_lte_rrc_pucch_Format5_r13;          /* T_pucch_Format5_r13 */
static int hf_lte_rrc_pucch_SCell_r13;            /* T_pucch_SCell_r13 */
static int hf_lte_rrc_spatialBundling_HARQ_ACK_r13;  /* T_spatialBundling_HARQ_ACK_r13 */
static int hf_lte_rrc_supportedBlindDecoding_r13;  /* T_supportedBlindDecoding_r13 */
static int hf_lte_rrc_maxNumberDecoding_r13;      /* INTEGER_1_32 */
static int hf_lte_rrc_pdcch_CandidateReductions_r13_01;  /* T_pdcch_CandidateReductions_r13 */
static int hf_lte_rrc_skipMonitoringDCI_Format0_1A_r13;  /* T_skipMonitoringDCI_Format0_1A_r13 */
static int hf_lte_rrc_uci_PUSCH_Ext_r13;          /* T_uci_PUSCH_Ext_r13 */
static int hf_lte_rrc_crs_InterfMitigationTM10_r13;  /* T_crs_InterfMitigationTM10_r13 */
static int hf_lte_rrc_pdsch_CollisionHandling_r13;  /* T_pdsch_CollisionHandling_r13 */
static int hf_lte_rrc_mimo_UE_Parameters_r13;     /* MIMO_UE_Parameters_r13 */
static int hf_lte_rrc_cch_InterfMitigation_RefRecTypeA_r13;  /* T_cch_InterfMitigation_RefRecTypeA_r13 */
static int hf_lte_rrc_cch_InterfMitigation_RefRecTypeB_r13;  /* T_cch_InterfMitigation_RefRecTypeB_r13 */
static int hf_lte_rrc_cch_InterfMitigation_MaxNumCCs_r13;  /* INTEGER_1_maxServCell_r13 */
static int hf_lte_rrc_crs_InterfMitigationTM1toTM9_r13;  /* INTEGER_1_maxServCell_r13 */
static int hf_lte_rrc_mimo_UE_Parameters_v13e0;   /* MIMO_UE_Parameters_v13e0 */
static int hf_lte_rrc_ce_PUSCH_NB_MaxTBS_r14_01;  /* T_ce_PUSCH_NB_MaxTBS_r14_01 */
static int hf_lte_rrc_ce_PDSCH_PUSCH_MaxBandwidth_r14;  /* T_ce_PDSCH_PUSCH_MaxBandwidth_r14 */
static int hf_lte_rrc_ce_HARQ_AckBundling_r14_01;  /* T_ce_HARQ_AckBundling_r14_01 */
static int hf_lte_rrc_ce_PDSCH_TenProcesses_r14_01;  /* T_ce_PDSCH_TenProcesses_r14_01 */
static int hf_lte_rrc_ce_RetuningSymbols_r14;     /* T_ce_RetuningSymbols_r14 */
static int hf_lte_rrc_ce_PDSCH_PUSCH_Enhancement_r14;  /* T_ce_PDSCH_PUSCH_Enhancement_r14 */
static int hf_lte_rrc_ce_SchedulingEnhancement_r14_01;  /* T_ce_SchedulingEnhancement_r14_01 */
static int hf_lte_rrc_ce_SRS_Enhancement_r14;     /* T_ce_SRS_Enhancement_r14 */
static int hf_lte_rrc_ce_PUCCH_Enhancement_r14;   /* T_ce_PUCCH_Enhancement_r14 */
static int hf_lte_rrc_ce_ClosedLoopTxAntennaSelection_r14;  /* T_ce_ClosedLoopTxAntennaSelection_r14 */
static int hf_lte_rrc_tdd_SpecialSubframe_r14;    /* T_tdd_SpecialSubframe_r14 */
static int hf_lte_rrc_tdd_TTI_Bundling_r14;       /* T_tdd_TTI_Bundling_r14 */
static int hf_lte_rrc_dmrs_LessUpPTS_r14;         /* T_dmrs_LessUpPTS_r14 */
static int hf_lte_rrc_mimo_UE_Parameters_v1430;   /* MIMO_UE_Parameters_v1430 */
static int hf_lte_rrc_alternativeTBS_Index_r14;   /* T_alternativeTBS_Index_r14 */
static int hf_lte_rrc_feMBMS_Unicast_Parameters_r14;  /* FeMBMS_Unicast_Parameters_r14 */
static int hf_lte_rrc_ce_SRS_EnhancementWithoutComb4_r14;  /* T_ce_SRS_EnhancementWithoutComb4_r14 */
static int hf_lte_rrc_crs_LessDwPTS_r14;          /* T_crs_LessDwPTS_r14 */
static int hf_lte_rrc_mimo_UE_Parameters_v1470;   /* MIMO_UE_Parameters_v1470 */
static int hf_lte_rrc_srs_UpPTS_6sym_r14;         /* T_srs_UpPTS_6sym_r14 */
static int hf_lte_rrc_ssp10_TDD_Only_r14;         /* T_ssp10_TDD_Only_r14 */
static int hf_lte_rrc_stti_SPT_Capabilities_r15;  /* T_stti_SPT_Capabilities_r15 */
static int hf_lte_rrc_aperiodicCsi_ReportingSTTI_r15;  /* T_aperiodicCsi_ReportingSTTI_r15 */
static int hf_lte_rrc_dmrs_BasedSPDCCH_MBSFN_r15;  /* T_dmrs_BasedSPDCCH_MBSFN_r15 */
static int hf_lte_rrc_dmrs_BasedSPDCCH_nonMBSFN_r15;  /* T_dmrs_BasedSPDCCH_nonMBSFN_r15 */
static int hf_lte_rrc_dmrs_PositionPattern_r15;   /* T_dmrs_PositionPattern_r15 */
static int hf_lte_rrc_dmrs_SharingSubslotPDSCH_r15;  /* T_dmrs_SharingSubslotPDSCH_r15 */
static int hf_lte_rrc_dmrs_RepetitionSubslotPDSCH_r15;  /* T_dmrs_RepetitionSubslotPDSCH_r15 */
static int hf_lte_rrc_epdcch_SPT_differentCells_r15;  /* T_epdcch_SPT_differentCells_r15 */
static int hf_lte_rrc_epdcch_STTI_differentCells_r15;  /* T_epdcch_STTI_differentCells_r15 */
static int hf_lte_rrc_maxLayersSlotOrSubslotPUSCH_r15;  /* T_maxLayersSlotOrSubslotPUSCH_r15 */
static int hf_lte_rrc_maxNumberUpdatedCSI_Proc_SPT_r15;  /* INTEGER_5_32 */
static int hf_lte_rrc_maxNumberUpdatedCSI_Proc_STTI_Comb77_r15;  /* INTEGER_1_32 */
static int hf_lte_rrc_maxNumberUpdatedCSI_Proc_STTI_Comb27_r15;  /* INTEGER_1_32 */
static int hf_lte_rrc_maxNumberUpdatedCSI_Proc_STTI_Comb22_Set1_r15;  /* INTEGER_1_32 */
static int hf_lte_rrc_maxNumberUpdatedCSI_Proc_STTI_Comb22_Set2_r15;  /* INTEGER_1_32 */
static int hf_lte_rrc_mimo_UE_ParametersSTTI_r15;  /* MIMO_UE_Parameters_r13 */
static int hf_lte_rrc_mimo_UE_ParametersSTTI_v1530;  /* MIMO_UE_Parameters_v1430 */
static int hf_lte_rrc_numberOfBlindDecodesUSS_r15;  /* INTEGER_4_32 */
static int hf_lte_rrc_pdsch_SlotSubslotPDSCH_Decoding_r15;  /* T_pdsch_SlotSubslotPDSCH_Decoding_r15 */
static int hf_lte_rrc_powerUCI_SlotPUSCH;         /* T_powerUCI_SlotPUSCH */
static int hf_lte_rrc_powerUCI_SubslotPUSCH;      /* T_powerUCI_SubslotPUSCH */
static int hf_lte_rrc_slotPDSCH_TxDiv_TM9and10;   /* T_slotPDSCH_TxDiv_TM9and10 */
static int hf_lte_rrc_subslotPDSCH_TxDiv_TM9and10;  /* T_subslotPDSCH_TxDiv_TM9and10 */
static int hf_lte_rrc_spdcch_differentRS_types_r15;  /* T_spdcch_differentRS_types_r15 */
static int hf_lte_rrc_srs_DCI7_TriggeringFS2_r15;  /* T_srs_DCI7_TriggeringFS2_r15 */
static int hf_lte_rrc_sps_cyclicShift_r15;        /* T_sps_cyclicShift_r15 */
static int hf_lte_rrc_spdcch_Reuse_r15;           /* T_spdcch_Reuse_r15 */
static int hf_lte_rrc_sps_STTI_r15;               /* T_sps_STTI_r15 */
static int hf_lte_rrc_tm8_slotPDSCH_r15;          /* T_tm8_slotPDSCH_r15 */
static int hf_lte_rrc_tm9_slotSubslot_r15;        /* T_tm9_slotSubslot_r15 */
static int hf_lte_rrc_tm9_slotSubslotMBSFN_r15;   /* T_tm9_slotSubslotMBSFN_r15 */
static int hf_lte_rrc_tm10_slotSubslot_r15;       /* T_tm10_slotSubslot_r15 */
static int hf_lte_rrc_tm10_slotSubslotMBSFN_r15;  /* T_tm10_slotSubslotMBSFN_r15 */
static int hf_lte_rrc_txDiv_SPUCCH_r15;           /* T_txDiv_SPUCCH_r15 */
static int hf_lte_rrc_ul_AsyncHarqSharingDiff_TTI_Lengths_r15;  /* T_ul_AsyncHarqSharingDiff_TTI_Lengths_r15 */
static int hf_lte_rrc_ce_Capabilities_r15;        /* T_ce_Capabilities_r15 */
static int hf_lte_rrc_ce_CRS_IntfMitig_r15;       /* T_ce_CRS_IntfMitig_r15 */
static int hf_lte_rrc_ce_CQI_AlternativeTable_r15;  /* T_ce_CQI_AlternativeTable_r15 */
static int hf_lte_rrc_ce_PDSCH_FlexibleStartPRB_CE_ModeA_r15;  /* T_ce_PDSCH_FlexibleStartPRB_CE_ModeA_r15 */
static int hf_lte_rrc_ce_PDSCH_FlexibleStartPRB_CE_ModeB_r15;  /* T_ce_PDSCH_FlexibleStartPRB_CE_ModeB_r15 */
static int hf_lte_rrc_ce_PDSCH_64QAM_r15;         /* T_ce_PDSCH_64QAM_r15 */
static int hf_lte_rrc_ce_PUSCH_FlexibleStartPRB_CE_ModeA_r15;  /* T_ce_PUSCH_FlexibleStartPRB_CE_ModeA_r15 */
static int hf_lte_rrc_ce_PUSCH_FlexibleStartPRB_CE_ModeB_r15;  /* T_ce_PUSCH_FlexibleStartPRB_CE_ModeB_r15 */
static int hf_lte_rrc_ce_PUSCH_SubPRB_Allocation_r15;  /* T_ce_PUSCH_SubPRB_Allocation_r15 */
static int hf_lte_rrc_ce_UL_HARQ_ACK_Feedback_r15;  /* T_ce_UL_HARQ_ACK_Feedback_r15 */
static int hf_lte_rrc_shortCQI_ForSCellActivation_r15;  /* T_shortCQI_ForSCellActivation_r15 */
static int hf_lte_rrc_mimo_CBSR_AdvancedCSI_r15;  /* T_mimo_CBSR_AdvancedCSI_r15 */
static int hf_lte_rrc_crs_IntfMitig_r15;          /* T_crs_IntfMitig_r15 */
static int hf_lte_rrc_ul_PowerControlEnhancements_r15;  /* T_ul_PowerControlEnhancements_r15 */
static int hf_lte_rrc_urllc_Capabilities_r15;     /* T_urllc_Capabilities_r15 */
static int hf_lte_rrc_pdsch_RepSubframe_r15;      /* T_pdsch_RepSubframe_r15 */
static int hf_lte_rrc_pdsch_RepSlot_r15;          /* T_pdsch_RepSlot_r15 */
static int hf_lte_rrc_pdsch_RepSubslot_r15;       /* T_pdsch_RepSubslot_r15 */
static int hf_lte_rrc_pusch_SPS_MultiConfigSubframe_r15;  /* INTEGER_0_6 */
static int hf_lte_rrc_pusch_SPS_MaxConfigSubframe_r15;  /* INTEGER_0_31 */
static int hf_lte_rrc_pusch_SPS_MultiConfigSlot_r15;  /* INTEGER_0_6 */
static int hf_lte_rrc_pusch_SPS_MaxConfigSlot_r15;  /* INTEGER_0_31 */
static int hf_lte_rrc_pusch_SPS_MultiConfigSubslot_r15;  /* INTEGER_0_6 */
static int hf_lte_rrc_pusch_SPS_MaxConfigSubslot_r15;  /* INTEGER_0_31 */
static int hf_lte_rrc_pusch_SPS_SlotRepPCell_r15;  /* T_pusch_SPS_SlotRepPCell_r15 */
static int hf_lte_rrc_pusch_SPS_SlotRepPSCell_r15;  /* T_pusch_SPS_SlotRepPSCell_r15 */
static int hf_lte_rrc_pusch_SPS_SlotRepSCell_r15;  /* T_pusch_SPS_SlotRepSCell_r15 */
static int hf_lte_rrc_pusch_SPS_SubframeRepPCell_r15;  /* T_pusch_SPS_SubframeRepPCell_r15 */
static int hf_lte_rrc_pusch_SPS_SubframeRepPSCell_r15;  /* T_pusch_SPS_SubframeRepPSCell_r15 */
static int hf_lte_rrc_pusch_SPS_SubframeRepSCell_r15;  /* T_pusch_SPS_SubframeRepSCell_r15 */
static int hf_lte_rrc_pusch_SPS_SubslotRepPCell_r15;  /* T_pusch_SPS_SubslotRepPCell_r15 */
static int hf_lte_rrc_pusch_SPS_SubslotRepPSCell_r15;  /* T_pusch_SPS_SubslotRepPSCell_r15 */
static int hf_lte_rrc_pusch_SPS_SubslotRepSCell_r15;  /* T_pusch_SPS_SubslotRepSCell_r15 */
static int hf_lte_rrc_semiStaticCFI_r15;          /* T_semiStaticCFI_r15 */
static int hf_lte_rrc_semiStaticCFI_Pattern_r15;  /* T_semiStaticCFI_Pattern_r15 */
static int hf_lte_rrc_altMCS_Table_r15;           /* T_altMCS_Table_r15 */
static int hf_lte_rrc_stti_SPT_Capabilities_v1540;  /* T_stti_SPT_Capabilities_v1540 */
static int hf_lte_rrc_slotPDSCH_TxDiv_TM8_r15;    /* T_slotPDSCH_TxDiv_TM8_r15 */
static int hf_lte_rrc_crs_IM_TM1_toTM9_OneRX_Port_v1540;  /* T_crs_IM_TM1_toTM9_OneRX_Port_v1540 */
static int hf_lte_rrc_cch_IM_RefRecTypeA_OneRX_Port_v1540;  /* T_cch_IM_RefRecTypeA_OneRX_Port_v1540 */
static int hf_lte_rrc_dmrs_OverheadReduction_r15;  /* T_dmrs_OverheadReduction_r15 */
static int hf_lte_rrc_ce_Capabilities_v1610;      /* T_ce_Capabilities_v1610 */
static int hf_lte_rrc_ce_CSI_RS_Feedback_r16_01;  /* T_ce_CSI_RS_Feedback_r16_01 */
static int hf_lte_rrc_ce_CSI_RS_FeedbackCodebookRestriction_r16;  /* T_ce_CSI_RS_FeedbackCodebookRestriction_r16 */
static int hf_lte_rrc_crs_ChEstMPDCCH_CE_ModeA_r16;  /* T_crs_ChEstMPDCCH_CE_ModeA_r16 */
static int hf_lte_rrc_crs_ChEstMPDCCH_CE_ModeB_r16;  /* T_crs_ChEstMPDCCH_CE_ModeB_r16 */
static int hf_lte_rrc_crs_ChEstMPDCCH_CSI_r16;    /* T_crs_ChEstMPDCCH_CSI_r16 */
static int hf_lte_rrc_crs_ChEstMPDCCH_ReciprocityTDD_r16;  /* T_crs_ChEstMPDCCH_ReciprocityTDD_r16 */
static int hf_lte_rrc_etws_CMAS_RxInConnCE_ModeA_r16;  /* T_etws_CMAS_RxInConnCE_ModeA_r16 */
static int hf_lte_rrc_etws_CMAS_RxInConnCE_ModeB_r16;  /* T_etws_CMAS_RxInConnCE_ModeB_r16 */
static int hf_lte_rrc_mpdcch_InLteControlRegionCE_ModeA_r16;  /* T_mpdcch_InLteControlRegionCE_ModeA_r16 */
static int hf_lte_rrc_mpdcch_InLteControlRegionCE_ModeB_r16;  /* T_mpdcch_InLteControlRegionCE_ModeB_r16 */
static int hf_lte_rrc_pdsch_InLteControlRegionCE_ModeA_r16;  /* T_pdsch_InLteControlRegionCE_ModeA_r16 */
static int hf_lte_rrc_pdsch_InLteControlRegionCE_ModeB_r16;  /* T_pdsch_InLteControlRegionCE_ModeB_r16 */
static int hf_lte_rrc_multiTB_Parameters_r16;     /* CE_MultiTB_Parameters_r16 */
static int hf_lte_rrc_resourceResvParameters_r16;  /* CE_ResourceResvParameters_r16 */
static int hf_lte_rrc_widebandPRG_Slot_r16;       /* T_widebandPRG_Slot_r16 */
static int hf_lte_rrc_widebandPRG_Subslot_r16;    /* T_widebandPRG_Subslot_r16 */
static int hf_lte_rrc_phyLayerParameters_v1610_widebandPRG_Subframe_r16;  /* T_phyLayerParameters_v1610_widebandPRG_Subframe_r16 */
static int hf_lte_rrc_addSRS_r16;                 /* T_addSRS_r16 */
static int hf_lte_rrc_addSRS_FrequencyHopping_r16;  /* T_addSRS_FrequencyHopping_r16 */
static int hf_lte_rrc_addSRS_AntennaSwitching_r16;  /* T_addSRS_AntennaSwitching_r16 */
static int hf_lte_rrc_addSRS_CarrierSwitching_r16;  /* T_addSRS_CarrierSwitching_r16 */
static int hf_lte_rrc_virtualCellID_BasicSRS_r16;  /* T_virtualCellID_BasicSRS_r16 */
static int hf_lte_rrc_virtualCellID_AddSRS_r16;   /* T_virtualCellID_AddSRS_r16 */
static int hf_lte_rrc_ce_Capabilities_v1700;      /* T_ce_Capabilities_v1700 */
static int hf_lte_rrc_ce_PDSCH_14HARQProcesses_r17;  /* T_ce_PDSCH_14HARQProcesses_r17 */
static int hf_lte_rrc_ce_PDSCH_14HARQProcesses_Alt2_r17;  /* T_ce_PDSCH_14HARQProcesses_Alt2_r17 */
static int hf_lte_rrc_ce_PDSCH_MaxTBS_r17;        /* T_ce_PDSCH_MaxTBS_r17 */
static int hf_lte_rrc_csi_SubframeSet2ForDormantSCell_r17;  /* T_csi_SubframeSet2ForDormantSCell_r17 */
static int hf_lte_rrc_parametersTM9_r13;          /* MIMO_UE_ParametersPerTM_r13 */
static int hf_lte_rrc_parametersTM10_r13;         /* MIMO_UE_ParametersPerTM_r13 */
static int hf_lte_rrc_srs_EnhancementsTDD_r13;    /* T_srs_EnhancementsTDD_r13 */
static int hf_lte_rrc_srs_Enhancements_r13;       /* T_srs_Enhancements_r13 */
static int hf_lte_rrc_mIMO_UE_Parameters_r13_interferenceMeasRestriction_r13;  /* T_mIMO_UE_Parameters_r13_interferenceMeasRestriction_r13 */
static int hf_lte_rrc_mimo_WeightedLayersCapabilities_r13;  /* MIMO_WeightedLayersCapabilities_r13 */
static int hf_lte_rrc_parametersTM9_v1430;        /* MIMO_UE_ParametersPerTM_v1430 */
static int hf_lte_rrc_parametersTM10_v1430;       /* MIMO_UE_ParametersPerTM_v1430 */
static int hf_lte_rrc_parametersTM9_v1470;        /* MIMO_UE_ParametersPerTM_v1470 */
static int hf_lte_rrc_parametersTM10_v1470;       /* MIMO_UE_ParametersPerTM_v1470 */
static int hf_lte_rrc_nonPrecoded_r13_02;         /* MIMO_NonPrecodedCapabilities_r13 */
static int hf_lte_rrc_beamformed_r13_01;          /* MIMO_UE_BeamformedCapabilities_r13 */
static int hf_lte_rrc_channelMeasRestriction_r13_01;  /* T_channelMeasRestriction_r13_01 */
static int hf_lte_rrc_dmrs_Enhancements_r13;      /* T_dmrs_Enhancements_r13 */
static int hf_lte_rrc_csi_RS_EnhancementsTDD_r13;  /* T_csi_RS_EnhancementsTDD_r13 */
static int hf_lte_rrc_nzp_CSI_RS_AperiodicInfo_r14;  /* T_nzp_CSI_RS_AperiodicInfo_r14 */
static int hf_lte_rrc_nMaxProc_r14;               /* INTEGER_5_32 */
static int hf_lte_rrc_nMaxResource_r14;           /* T_nMaxResource_r14 */
static int hf_lte_rrc_nzp_CSI_RS_PeriodicInfo_r14;  /* T_nzp_CSI_RS_PeriodicInfo_r14 */
static int hf_lte_rrc_nMaxResource_r14_01;        /* T_nMaxResource_r14_01 */
static int hf_lte_rrc_zp_CSI_RS_AperiodicInfo_r14;  /* T_zp_CSI_RS_AperiodicInfo_r14 */
static int hf_lte_rrc_ul_dmrs_Enhancements_r14;   /* T_ul_dmrs_Enhancements_r14 */
static int hf_lte_rrc_densityReductionNP_r14;     /* T_densityReductionNP_r14 */
static int hf_lte_rrc_densityReductionBF_r14;     /* T_densityReductionBF_r14 */
static int hf_lte_rrc_hybridCSI_r14;              /* T_hybridCSI_r14 */
static int hf_lte_rrc_semiOL_r14;                 /* T_semiOL_r14 */
static int hf_lte_rrc_csi_ReportingNP_r14;        /* T_csi_ReportingNP_r14 */
static int hf_lte_rrc_csi_ReportingAdvanced_r14;  /* T_csi_ReportingAdvanced_r14 */
static int hf_lte_rrc_csi_ReportingAdvancedMaxPorts_r14;  /* T_csi_ReportingAdvancedMaxPorts_r14 */
static int hf_lte_rrc_parametersTM9_r13_01;       /* MIMO_CA_ParametersPerBoBCPerTM_r13 */
static int hf_lte_rrc_parametersTM10_r13_01;      /* MIMO_CA_ParametersPerBoBCPerTM_r13 */
static int hf_lte_rrc_parametersTM9_r15;          /* MIMO_CA_ParametersPerBoBCPerTM_r15 */
static int hf_lte_rrc_parametersTM10_r15;         /* MIMO_CA_ParametersPerBoBCPerTM_r15 */
static int hf_lte_rrc_parametersTM9_v1430_01;     /* MIMO_CA_ParametersPerBoBCPerTM_v1430 */
static int hf_lte_rrc_parametersTM10_v1430_01;    /* MIMO_CA_ParametersPerBoBCPerTM_v1430 */
static int hf_lte_rrc_parametersTM9_v1470_01;     /* MIMO_CA_ParametersPerBoBCPerTM_v1470 */
static int hf_lte_rrc_parametersTM10_v1470_01;    /* MIMO_CA_ParametersPerBoBCPerTM_v1470 */
static int hf_lte_rrc_beamformed_r13_02;          /* MIMO_BeamformedCapabilityList_r13 */
static int hf_lte_rrc_dmrs_Enhancements_r13_01;   /* T_dmrs_Enhancements_r13_01 */
static int hf_lte_rrc_csi_ReportingNP_r14_01;     /* T_csi_ReportingNP_r14_01 */
static int hf_lte_rrc_csi_ReportingAdvanced_r14_01;  /* T_csi_ReportingAdvanced_r14_01 */
static int hf_lte_rrc_csi_ReportingAdvancedMaxPorts_r14_01;  /* T_csi_ReportingAdvancedMaxPorts_r14_01 */
static int hf_lte_rrc_dmrs_Enhancements_r13_02;   /* T_dmrs_Enhancements_r13_02 */
static int hf_lte_rrc_csi_ReportingNP_r14_02;     /* T_csi_ReportingNP_r14_02 */
static int hf_lte_rrc_csi_ReportingAdvanced_r14_02;  /* T_csi_ReportingAdvanced_r14_02 */
static int hf_lte_rrc_config1_r13;                /* T_config1_r13 */
static int hf_lte_rrc_config2_r13;                /* T_config2_r13 */
static int hf_lte_rrc_config3_r13;                /* T_config3_r13 */
static int hf_lte_rrc_config4_r13;                /* T_config4_r13 */
static int hf_lte_rrc_altCodebook_r13;            /* T_altCodebook_r13 */
static int hf_lte_rrc_mimo_BeamformedCapabilities_r13;  /* MIMO_BeamformedCapabilityList_r13 */
static int hf_lte_rrc_MIMO_BeamformedCapabilityList_r13_item;  /* MIMO_BeamformedCapabilities_r13 */
static int hf_lte_rrc_k_Max_r13;                  /* INTEGER_1_8 */
static int hf_lte_rrc_n_MaxList_r13;              /* BIT_STRING_SIZE_1_7 */
static int hf_lte_rrc_relWeightTwoLayers_r13;     /* T_relWeightTwoLayers_r13 */
static int hf_lte_rrc_relWeightFourLayers_r13;    /* T_relWeightFourLayers_r13 */
static int hf_lte_rrc_relWeightEightLayers_r13;   /* T_relWeightEightLayers_r13 */
static int hf_lte_rrc_totalWeightedLayers_r13;    /* INTEGER_2_128 */
static int hf_lte_rrc_NonContiguousUL_RA_WithinCC_List_r10_item;  /* NonContiguousUL_RA_WithinCC_r10 */
static int hf_lte_rrc_nonContiguousUL_RA_WithinCC_Info_r10;  /* T_nonContiguousUL_RA_WithinCC_Info_r10 */
static int hf_lte_rrc_supportedBandListEUTRA;     /* SupportedBandListEUTRA */
static int hf_lte_rrc_supportedBandListEUTRA_v9e0;  /* SupportedBandListEUTRA_v9e0 */
static int hf_lte_rrc_supportedBandCombination_r10;  /* SupportedBandCombination_r10 */
static int hf_lte_rrc_supportedBandCombinationExt_r10;  /* SupportedBandCombinationExt_r10 */
static int hf_lte_rrc_supportedBandCombination_v1090;  /* SupportedBandCombination_v1090 */
static int hf_lte_rrc_modifiedMPR_Behavior_r10;   /* T_modifiedMPR_Behavior_r10 */
static int hf_lte_rrc_supportedBandCombination_v10i0;  /* SupportedBandCombination_v10i0 */
static int hf_lte_rrc_multiNS_Pmax_r10;           /* T_multiNS_Pmax_r10 */
static int hf_lte_rrc_supportedBandCombination_v1130;  /* SupportedBandCombination_v1130 */
static int hf_lte_rrc_freqBandRetrieval_r11;      /* T_freqBandRetrieval_r11 */
static int hf_lte_rrc_requestedBands_r11;         /* SEQUENCE_SIZE_1_maxBands_OF_FreqBandIndicator_r11 */
static int hf_lte_rrc_requestedBands_r11_item;    /* FreqBandIndicator_r11 */
static int hf_lte_rrc_supportedBandCombinationAdd_r11;  /* SupportedBandCombinationAdd_r11 */
static int hf_lte_rrc_supportedBandCombinationAdd_v11d0;  /* SupportedBandCombinationAdd_v11d0 */
static int hf_lte_rrc_supportedBandListEUTRA_v1250;  /* SupportedBandListEUTRA_v1250 */
static int hf_lte_rrc_supportedBandCombination_v1250;  /* SupportedBandCombination_v1250 */
static int hf_lte_rrc_supportedBandCombinationAdd_v1250;  /* SupportedBandCombinationAdd_v1250 */
static int hf_lte_rrc_freqBandPriorityAdjustment_r12;  /* T_freqBandPriorityAdjustment_r12 */
static int hf_lte_rrc_supportedBandCombination_v1270;  /* SupportedBandCombination_v1270 */
static int hf_lte_rrc_supportedBandCombinationAdd_v1270;  /* SupportedBandCombinationAdd_v1270 */
static int hf_lte_rrc_eNB_RequestedParameters_r13;  /* T_eNB_RequestedParameters_r13 */
static int hf_lte_rrc_reducedIntNonContCombRequested_r13;  /* T_reducedIntNonContCombRequested_r13 */
static int hf_lte_rrc_requestedCCsDL_r13;         /* INTEGER_2_32 */
static int hf_lte_rrc_requestedCCsUL_r13;         /* INTEGER_2_32 */
static int hf_lte_rrc_skipFallbackCombRequested_r13;  /* T_skipFallbackCombRequested_r13 */
static int hf_lte_rrc_maximumCCsRetrieval_r13;    /* T_maximumCCsRetrieval_r13 */
static int hf_lte_rrc_skipFallbackCombinations_r13;  /* T_skipFallbackCombinations_r13 */
static int hf_lte_rrc_reducedIntNonContComb_r13;  /* T_reducedIntNonContComb_r13 */
static int hf_lte_rrc_supportedBandListEUTRA_v1310;  /* SupportedBandListEUTRA_v1310 */
static int hf_lte_rrc_supportedBandCombinationReduced_r13;  /* SupportedBandCombinationReduced_r13 */
static int hf_lte_rrc_supportedBandListEUTRA_v1320;  /* SupportedBandListEUTRA_v1320 */
static int hf_lte_rrc_supportedBandCombination_v1320;  /* SupportedBandCombination_v1320 */
static int hf_lte_rrc_supportedBandCombinationAdd_v1320;  /* SupportedBandCombinationAdd_v1320 */
static int hf_lte_rrc_supportedBandCombinationReduced_v1320;  /* SupportedBandCombinationReduced_v1320 */
static int hf_lte_rrc_supportedBandCombination_v1380;  /* SupportedBandCombination_v1380 */
static int hf_lte_rrc_supportedBandCombinationAdd_v1380;  /* SupportedBandCombinationAdd_v1380 */
static int hf_lte_rrc_supportedBandCombinationReduced_v1380;  /* SupportedBandCombinationReduced_v1380 */
static int hf_lte_rrc_supportedBandCombination_v1390;  /* SupportedBandCombination_v1390 */
static int hf_lte_rrc_supportedBandCombinationAdd_v1390;  /* SupportedBandCombinationAdd_v1390 */
static int hf_lte_rrc_supportedBandCombinationReduced_v1390;  /* SupportedBandCombinationReduced_v1390 */
static int hf_lte_rrc_maxLayersMIMO_Indication_r12;  /* T_maxLayersMIMO_Indication_r12 */
static int hf_lte_rrc_supportedBandCombination_v1430;  /* SupportedBandCombination_v1430 */
static int hf_lte_rrc_supportedBandCombinationAdd_v1430;  /* SupportedBandCombinationAdd_v1430 */
static int hf_lte_rrc_supportedBandCombinationReduced_v1430;  /* SupportedBandCombinationReduced_v1430 */
static int hf_lte_rrc_eNB_RequestedParameters_v1430;  /* T_eNB_RequestedParameters_v1430 */
static int hf_lte_rrc_requestedDiffFallbackCombList_r14;  /* BandCombinationList_r14 */
static int hf_lte_rrc_diffFallbackCombReport_r14;  /* T_diffFallbackCombReport_r14 */
static int hf_lte_rrc_supportedBandCombination_v1450;  /* SupportedBandCombination_v1450 */
static int hf_lte_rrc_supportedBandCombinationAdd_v1450;  /* SupportedBandCombinationAdd_v1450 */
static int hf_lte_rrc_supportedBandCombinationReduced_v1450;  /* SupportedBandCombinationReduced_v1450 */
static int hf_lte_rrc_supportedBandCombination_v1470;  /* SupportedBandCombination_v1470 */
static int hf_lte_rrc_supportedBandCombinationAdd_v1470;  /* SupportedBandCombinationAdd_v1470 */
static int hf_lte_rrc_supportedBandCombinationReduced_v1470;  /* SupportedBandCombinationReduced_v1470 */
static int hf_lte_rrc_supportedBandCombination_v14b0;  /* SupportedBandCombination_v14b0 */
static int hf_lte_rrc_supportedBandCombinationAdd_v14b0;  /* SupportedBandCombinationAdd_v14b0 */
static int hf_lte_rrc_supportedBandCombinationReduced_v14b0;  /* SupportedBandCombinationReduced_v14b0 */
static int hf_lte_rrc_sTTI_SPT_Supported_r15;     /* T_sTTI_SPT_Supported_r15 */
static int hf_lte_rrc_supportedBandCombination_v1530;  /* SupportedBandCombination_v1530 */
static int hf_lte_rrc_supportedBandCombinationAdd_v1530;  /* SupportedBandCombinationAdd_v1530 */
static int hf_lte_rrc_supportedBandCombinationReduced_v1530;  /* SupportedBandCombinationReduced_v1530 */
static int hf_lte_rrc_powerClass_14dBm_r15;       /* T_powerClass_14dBm_r15 */
static int hf_lte_rrc_dl_1024QAM_ScalingFactor_r15;  /* T_dl_1024QAM_ScalingFactor_r15 */
static int hf_lte_rrc_dl_1024QAM_TotalWeightedLayers_r15;  /* INTEGER_0_10 */
static int hf_lte_rrc_supportedBandCombination_v1610;  /* SupportedBandCombination_v1610 */
static int hf_lte_rrc_supportedBandCombinationAdd_v1610;  /* SupportedBandCombinationAdd_v1610 */
static int hf_lte_rrc_supportedBandCombinationReduced_v1610;  /* SupportedBandCombinationReduced_v1610 */
static int hf_lte_rrc_supportedBandCombination_v1630;  /* SupportedBandCombination_v1630 */
static int hf_lte_rrc_supportedBandCombinationAdd_v1630;  /* SupportedBandCombinationAdd_v1630 */
static int hf_lte_rrc_supportedBandCombinationReduced_v1630;  /* SupportedBandCombinationReduced_v1630 */
static int hf_lte_rrc_multiNS_PmaxAerial_r18;     /* T_multiNS_PmaxAerial_r18 */
static int hf_lte_rrc_supportedBandListEUTRA_v1800;  /* SupportedBandListEUTRA_v1800 */
static int hf_lte_rrc_supportedBandCombination_v1800;  /* SupportedBandCombination_v1800 */
static int hf_lte_rrc_supportedBandCombinationAdd_v1800;  /* SupportedBandCombinationAdd_v1800 */
static int hf_lte_rrc_supportedBandCombinationReduced_v1800;  /* SupportedBandCombinationReduced_v1800 */
static int hf_lte_rrc_skipProcessingDL_Slot_r15;  /* INTEGER_0_3 */
static int hf_lte_rrc_skipProcessingDL_SubSlot_r15;  /* INTEGER_0_3 */
static int hf_lte_rrc_skipProcessingUL_Slot_r15;  /* INTEGER_0_3 */
static int hf_lte_rrc_skipProcessingUL_SubSlot_r15;  /* INTEGER_0_3 */
static int hf_lte_rrc_frameStructureType_SPT_r15;  /* BIT_STRING_SIZE_3 */
static int hf_lte_rrc_maxNumberCCs_SPT_r15;       /* INTEGER_1_32 */
static int hf_lte_rrc_dl_1024QAM_Slot_r15;        /* T_dl_1024QAM_Slot_r15 */
static int hf_lte_rrc_dl_1024QAM_SubslotTA_1_r15;  /* T_dl_1024QAM_SubslotTA_1_r15 */
static int hf_lte_rrc_dl_1024QAM_SubslotTA_2_r15;  /* T_dl_1024QAM_SubslotTA_2_r15 */
static int hf_lte_rrc_simultaneousTx_differentTx_duration_r15;  /* T_simultaneousTx_differentTx_duration_r15 */
static int hf_lte_rrc_sTTI_CA_MIMO_ParametersDL_r15;  /* CA_MIMO_ParametersDL_r15 */
static int hf_lte_rrc_sTTI_CA_MIMO_ParametersUL_r15;  /* CA_MIMO_ParametersUL_r15 */
static int hf_lte_rrc_sTTI_FD_MIMO_Coexistence;   /* T_sTTI_FD_MIMO_Coexistence */
static int hf_lte_rrc_sTTI_MIMO_CA_ParametersPerBoBCs_r15;  /* MIMO_CA_ParametersPerBoBC_r13 */
static int hf_lte_rrc_sTTI_MIMO_CA_ParametersPerBoBCs_v1530;  /* MIMO_CA_ParametersPerBoBC_v1430 */
static int hf_lte_rrc_sTTI_SupportedCombinations_r15;  /* STTI_SupportedCombinations_r15 */
static int hf_lte_rrc_sTTI_SupportedCSI_Proc_r15;  /* T_sTTI_SupportedCSI_Proc_r15 */
static int hf_lte_rrc_ul_256QAM_Slot_r15;         /* T_ul_256QAM_Slot_r15 */
static int hf_lte_rrc_ul_256QAM_Subslot_r15;      /* T_ul_256QAM_Subslot_r15 */
static int hf_lte_rrc_combination_22_r15;         /* DL_UL_CCs_r15 */
static int hf_lte_rrc_combination_77_r15;         /* DL_UL_CCs_r15 */
static int hf_lte_rrc_combination_27_r15;         /* DL_UL_CCs_r15 */
static int hf_lte_rrc_combination_22_27_r15;      /* SEQUENCE_SIZE_1_2_OF_DL_UL_CCs_r15 */
static int hf_lte_rrc_combination_22_27_r15_item;  /* DL_UL_CCs_r15 */
static int hf_lte_rrc_combination_77_22_r15;      /* SEQUENCE_SIZE_1_2_OF_DL_UL_CCs_r15 */
static int hf_lte_rrc_combination_77_22_r15_item;  /* DL_UL_CCs_r15 */
static int hf_lte_rrc_combination_77_27_r15;      /* SEQUENCE_SIZE_1_2_OF_DL_UL_CCs_r15 */
static int hf_lte_rrc_combination_77_27_r15_item;  /* DL_UL_CCs_r15 */
static int hf_lte_rrc_maxNumberDL_CCs_r15;        /* INTEGER_1_32 */
static int hf_lte_rrc_maxNumberUL_CCs_r15;        /* INTEGER_1_32 */
static int hf_lte_rrc_SupportedBandCombination_r10_item;  /* BandCombinationParameters_r10 */
static int hf_lte_rrc_SupportedBandCombinationExt_r10_item;  /* BandCombinationParametersExt_r10 */
static int hf_lte_rrc_SupportedBandCombination_v1090_item;  /* BandCombinationParameters_v1090 */
static int hf_lte_rrc_SupportedBandCombination_v10i0_item;  /* BandCombinationParameters_v10i0 */
static int hf_lte_rrc_SupportedBandCombination_v1130_item;  /* BandCombinationParameters_v1130 */
static int hf_lte_rrc_SupportedBandCombination_v1250_item;  /* BandCombinationParameters_v1250 */
static int hf_lte_rrc_SupportedBandCombination_v1270_item;  /* BandCombinationParameters_v1270 */
static int hf_lte_rrc_SupportedBandCombination_v1320_item;  /* BandCombinationParameters_v1320 */
static int hf_lte_rrc_SupportedBandCombination_v1380_item;  /* BandCombinationParameters_v1380 */
static int hf_lte_rrc_SupportedBandCombination_v1390_item;  /* BandCombinationParameters_v1390 */
static int hf_lte_rrc_SupportedBandCombination_v1430_item;  /* BandCombinationParameters_v1430 */
static int hf_lte_rrc_SupportedBandCombination_v1450_item;  /* BandCombinationParameters_v1450 */
static int hf_lte_rrc_SupportedBandCombination_v1470_item;  /* BandCombinationParameters_v1470 */
static int hf_lte_rrc_SupportedBandCombination_v14b0_item;  /* BandCombinationParameters_v14b0 */
static int hf_lte_rrc_SupportedBandCombination_v1530_item;  /* BandCombinationParameters_v1530 */
static int hf_lte_rrc_SupportedBandCombination_v1610_item;  /* BandCombinationParameters_v1610 */
static int hf_lte_rrc_SupportedBandCombination_v1630_item;  /* BandCombinationParameters_v1630 */
static int hf_lte_rrc_SupportedBandCombination_v1800_item;  /* BandCombinationParameters_v1800 */
static int hf_lte_rrc_SupportedBandCombinationAdd_r11_item;  /* BandCombinationParameters_r11 */
static int hf_lte_rrc_SupportedBandCombinationAdd_v11d0_item;  /* BandCombinationParameters_v10i0 */
static int hf_lte_rrc_SupportedBandCombinationAdd_v1250_item;  /* BandCombinationParameters_v1250 */
static int hf_lte_rrc_SupportedBandCombinationAdd_v1270_item;  /* BandCombinationParameters_v1270 */
static int hf_lte_rrc_SupportedBandCombinationAdd_v1320_item;  /* BandCombinationParameters_v1320 */
static int hf_lte_rrc_SupportedBandCombinationAdd_v1380_item;  /* BandCombinationParameters_v1380 */
static int hf_lte_rrc_SupportedBandCombinationAdd_v1390_item;  /* BandCombinationParameters_v1390 */
static int hf_lte_rrc_SupportedBandCombinationAdd_v1430_item;  /* BandCombinationParameters_v1430 */
static int hf_lte_rrc_SupportedBandCombinationAdd_v1450_item;  /* BandCombinationParameters_v1450 */
static int hf_lte_rrc_SupportedBandCombinationAdd_v1470_item;  /* BandCombinationParameters_v1470 */
static int hf_lte_rrc_SupportedBandCombinationAdd_v14b0_item;  /* BandCombinationParameters_v14b0 */
static int hf_lte_rrc_SupportedBandCombinationAdd_v1530_item;  /* BandCombinationParameters_v1530 */
static int hf_lte_rrc_SupportedBandCombinationAdd_v1610_item;  /* BandCombinationParameters_v1610 */
static int hf_lte_rrc_SupportedBandCombinationAdd_v1630_item;  /* BandCombinationParameters_v1630 */
static int hf_lte_rrc_SupportedBandCombinationAdd_v1800_item;  /* BandCombinationParameters_v1800 */
static int hf_lte_rrc_SupportedBandCombinationReduced_r13_item;  /* BandCombinationParameters_r13 */
static int hf_lte_rrc_SupportedBandCombinationReduced_v1320_item;  /* BandCombinationParameters_v1320 */
static int hf_lte_rrc_SupportedBandCombinationReduced_v1380_item;  /* BandCombinationParameters_v1380 */
static int hf_lte_rrc_SupportedBandCombinationReduced_v1390_item;  /* BandCombinationParameters_v1390 */
static int hf_lte_rrc_SupportedBandCombinationReduced_v1430_item;  /* BandCombinationParameters_v1430 */
static int hf_lte_rrc_SupportedBandCombinationReduced_v1450_item;  /* BandCombinationParameters_v1450 */
static int hf_lte_rrc_SupportedBandCombinationReduced_v1470_item;  /* BandCombinationParameters_v1470 */
static int hf_lte_rrc_SupportedBandCombinationReduced_v14b0_item;  /* BandCombinationParameters_v14b0 */
static int hf_lte_rrc_SupportedBandCombinationReduced_v1530_item;  /* BandCombinationParameters_v1530 */
static int hf_lte_rrc_SupportedBandCombinationReduced_v1610_item;  /* BandCombinationParameters_v1610 */
static int hf_lte_rrc_SupportedBandCombinationReduced_v1630_item;  /* BandCombinationParameters_v1630 */
static int hf_lte_rrc_SupportedBandCombinationReduced_v1800_item;  /* BandCombinationParameters_v1800 */
static int hf_lte_rrc_BandCombinationParameters_r10_item;  /* BandParameters_r10 */
static int hf_lte_rrc_supportedBandwidthCombinationSet_r10;  /* SupportedBandwidthCombinationSet_r10 */
static int hf_lte_rrc_BandCombinationParameters_v1090_item;  /* BandParameters_v1090 */
static int hf_lte_rrc_bandParameterList_v10i0;    /* SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v10i0 */
static int hf_lte_rrc_bandParameterList_v10i0_item;  /* BandParameters_v10i0 */
static int hf_lte_rrc_multipleTimingAdvance_r11;  /* T_multipleTimingAdvance_r11 */
static int hf_lte_rrc_simultaneousRx_Tx_r11;      /* T_simultaneousRx_Tx_r11 */
static int hf_lte_rrc_bandParameterList_r11;      /* SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v1130 */
static int hf_lte_rrc_bandParameterList_r11_item;  /* BandParameters_v1130 */
static int hf_lte_rrc_bandParameterList_r11_01;   /* SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_r11 */
static int hf_lte_rrc_bandParameterList_r11_item_01;  /* BandParameters_r11 */
static int hf_lte_rrc_supportedBandwidthCombinationSet_r11;  /* SupportedBandwidthCombinationSet_r10 */
static int hf_lte_rrc_multipleTimingAdvance_r11_01;  /* T_multipleTimingAdvance_r11_01 */
static int hf_lte_rrc_simultaneousRx_Tx_r11_01;   /* T_simultaneousRx_Tx_r11_01 */
static int hf_lte_rrc_bandInfoEUTRA_r11;          /* BandInfoEUTRA */
static int hf_lte_rrc_dc_Support_r12;             /* T_dc_Support_r12 */
static int hf_lte_rrc_asynchronous_r12;           /* T_asynchronous_r12 */
static int hf_lte_rrc_supportedCellGrouping_r12;  /* T_supportedCellGrouping_r12 */
static int hf_lte_rrc_threeEntries_r12;           /* BIT_STRING_SIZE_3 */
static int hf_lte_rrc_fourEntries_r12;            /* BIT_STRING_SIZE_7 */
static int hf_lte_rrc_fiveEntries_r12;            /* BIT_STRING_SIZE_15 */
static int hf_lte_rrc_supportedNAICS_2CRS_AP_r12;  /* BIT_STRING_SIZE_1_maxNAICS_Entries_r12 */
static int hf_lte_rrc_commSupportedBandsPerBC_r12;  /* BIT_STRING_SIZE_1_maxBands */
static int hf_lte_rrc_bandParameterList_v1270;    /* SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v1270 */
static int hf_lte_rrc_bandParameterList_v1270_item;  /* BandParameters_v1270 */
static int hf_lte_rrc_differentFallbackSupported_r13;  /* T_differentFallbackSupported_r13 */
static int hf_lte_rrc_bandParameterList_r13;      /* SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_r13 */
static int hf_lte_rrc_bandParameterList_r13_item;  /* BandParameters_r13 */
static int hf_lte_rrc_supportedBandwidthCombinationSet_r13;  /* SupportedBandwidthCombinationSet_r10 */
static int hf_lte_rrc_multipleTimingAdvance_r13;  /* T_multipleTimingAdvance_r13 */
static int hf_lte_rrc_simultaneousRx_Tx_r13;      /* T_simultaneousRx_Tx_r13 */
static int hf_lte_rrc_bandInfoEUTRA_r13;          /* BandInfoEUTRA */
static int hf_lte_rrc_dc_Support_r13;             /* T_dc_Support_r13 */
static int hf_lte_rrc_asynchronous_r13;           /* T_asynchronous_r13 */
static int hf_lte_rrc_supportedCellGrouping_r13;  /* T_supportedCellGrouping_r13 */
static int hf_lte_rrc_threeEntries_r13;           /* BIT_STRING_SIZE_3 */
static int hf_lte_rrc_fourEntries_r13;            /* BIT_STRING_SIZE_7 */
static int hf_lte_rrc_fiveEntries_r13;            /* BIT_STRING_SIZE_15 */
static int hf_lte_rrc_supportedNAICS_2CRS_AP_r13;  /* BIT_STRING_SIZE_1_maxNAICS_Entries_r12 */
static int hf_lte_rrc_commSupportedBandsPerBC_r13;  /* BIT_STRING_SIZE_1_maxBands */
static int hf_lte_rrc_bandParameterList_v1320;    /* SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v1320 */
static int hf_lte_rrc_bandParameterList_v1320_item;  /* BandParameters_v1320 */
static int hf_lte_rrc_additionalRx_Tx_PerformanceReq_r13;  /* T_additionalRx_Tx_PerformanceReq_r13 */
static int hf_lte_rrc_bandParameterList_v1380;    /* SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v1380 */
static int hf_lte_rrc_bandParameterList_v1380_item;  /* BandParameters_v1380 */
static int hf_lte_rrc_ue_CA_PowerClass_N_r13;     /* T_ue_CA_PowerClass_N_r13 */
static int hf_lte_rrc_bandParameterList_v1430;    /* SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v1430 */
static int hf_lte_rrc_bandParameterList_v1430_item;  /* BandParameters_v1430 */
static int hf_lte_rrc_v2x_SupportedTxBandCombListPerBC_r14;  /* BIT_STRING_SIZE_1_maxBandComb_r13 */
static int hf_lte_rrc_v2x_SupportedRxBandCombListPerBC_r14;  /* BIT_STRING_SIZE_1_maxBandComb_r13 */
static int hf_lte_rrc_bandParameterList_v1450;    /* SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v1450 */
static int hf_lte_rrc_bandParameterList_v1450_item;  /* BandParameters_v1450 */
static int hf_lte_rrc_bandParameterList_v1470;    /* SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v1470 */
static int hf_lte_rrc_bandParameterList_v1470_item;  /* BandParameters_v1470 */
static int hf_lte_rrc_srs_MaxSimultaneousCCs_r14;  /* INTEGER_1_31 */
static int hf_lte_rrc_bandParameterList_v14b0;    /* SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v14b0 */
static int hf_lte_rrc_bandParameterList_v14b0_item;  /* BandParameters_v14b0 */
static int hf_lte_rrc_bandParameterList_v1530;    /* SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v1530 */
static int hf_lte_rrc_bandParameterList_v1530_item;  /* BandParameters_v1530 */
static int hf_lte_rrc_spt_Parameters_r15;         /* SPT_Parameters_r15 */
static int hf_lte_rrc_measGapInfoNR_r16;          /* MeasGapInfoNR_r16 */
static int hf_lte_rrc_bandParameterList_v1610;    /* SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v1610 */
static int hf_lte_rrc_bandParameterList_v1610_item;  /* BandParameters_v1610 */
static int hf_lte_rrc_interFreqDAPS_r16;          /* T_interFreqDAPS_r16 */
static int hf_lte_rrc_interFreqAsyncDAPS_r16;     /* T_interFreqAsyncDAPS_r16 */
static int hf_lte_rrc_interFreqMultiUL_TransmissionDAPS_r16;  /* T_interFreqMultiUL_TransmissionDAPS_r16 */
static int hf_lte_rrc_v2x_SupportedTxBandCombListPerBC_v1630;  /* BIT_STRING_SIZE_1_maxBandCombSidelinkNR_r16 */
static int hf_lte_rrc_v2x_SupportedRxBandCombListPerBC_v1630;  /* BIT_STRING_SIZE_1_maxBandCombSidelinkNR_r16 */
static int hf_lte_rrc_scalingFactorTxSidelink_r16;  /* SEQUENCE_SIZE_1_maxBandCombSidelinkNR_r16_OF_ScalingFactorSidelink_r16 */
static int hf_lte_rrc_scalingFactorTxSidelink_r16_item;  /* ScalingFactorSidelink_r16 */
static int hf_lte_rrc_scalingFactorRxSidelink_r16;  /* SEQUENCE_SIZE_1_maxBandCombSidelinkNR_r16_OF_ScalingFactorSidelink_r16 */
static int hf_lte_rrc_scalingFactorRxSidelink_r16_item;  /* ScalingFactorSidelink_r16 */
static int hf_lte_rrc_interBandPowerSharingSyncDAPS_r16;  /* T_interBandPowerSharingSyncDAPS_r16 */
static int hf_lte_rrc_interBandPowerSharingAsyncDAPS_r16;  /* T_interBandPowerSharingAsyncDAPS_r16 */
static int hf_lte_rrc_measGapInfoNR_r18;          /* MeasGapInfoNR_r18 */
static int hf_lte_rrc_bandEUTRA_r10;              /* T_bandEUTRA_r10 */
static int hf_lte_rrc_bandParametersUL_r10;       /* BandParametersUL_r10 */
static int hf_lte_rrc_bandParametersDL_r10;       /* BandParametersDL_r10 */
static int hf_lte_rrc_bandEUTRA_v1090;            /* FreqBandIndicator_v9e0 */
static int hf_lte_rrc_bandParametersDL_v10i0;     /* SEQUENCE_SIZE_1_maxBandwidthClass_r10_OF_CA_MIMO_ParametersDL_v10i0 */
static int hf_lte_rrc_bandParametersDL_v10i0_item;  /* CA_MIMO_ParametersDL_v10i0 */
static int hf_lte_rrc_supportedCSI_Proc_r11;      /* T_supportedCSI_Proc_r11 */
static int hf_lte_rrc_bandEUTRA_r11;              /* FreqBandIndicator_r11 */
static int hf_lte_rrc_bandParametersUL_r11;       /* BandParametersUL_r10 */
static int hf_lte_rrc_bandParametersDL_r11;       /* BandParametersDL_r10 */
static int hf_lte_rrc_supportedCSI_Proc_r11_01;   /* T_supportedCSI_Proc_r11_01 */
static int hf_lte_rrc_bandParametersDL_v1270;     /* SEQUENCE_SIZE_1_maxBandwidthClass_r10_OF_CA_MIMO_ParametersDL_v1270 */
static int hf_lte_rrc_bandParametersDL_v1270_item;  /* CA_MIMO_ParametersDL_v1270 */
static int hf_lte_rrc_bandEUTRA_r13;              /* FreqBandIndicator_r11 */
static int hf_lte_rrc_bandParametersUL_r13;       /* BandParametersUL_r13 */
static int hf_lte_rrc_bandParametersDL_r13;       /* BandParametersDL_r13 */
static int hf_lte_rrc_supportedCSI_Proc_r13;      /* T_supportedCSI_Proc_r13 */
static int hf_lte_rrc_bandParametersDL_v1320;     /* MIMO_CA_ParametersPerBoBC_r13 */
static int hf_lte_rrc_txAntennaSwitchDL_r13;      /* INTEGER_1_32 */
static int hf_lte_rrc_txAntennaSwitchUL_r13;      /* INTEGER_1_32 */
static int hf_lte_rrc_bandParametersDL_v1430;     /* MIMO_CA_ParametersPerBoBC_v1430 */
static int hf_lte_rrc_ul_256QAM_r14;              /* T_ul_256QAM_r14 */
static int hf_lte_rrc_ul_256QAM_perCC_InfoList_r14;  /* SEQUENCE_SIZE_2_maxServCell_r13_OF_UL_256QAM_perCC_Info_r14 */
static int hf_lte_rrc_ul_256QAM_perCC_InfoList_r14_item;  /* UL_256QAM_perCC_Info_r14 */
static int hf_lte_rrc_srs_CapabilityPerBandPairList_r14;  /* SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_SRS_CapabilityPerBandPair_r14 */
static int hf_lte_rrc_srs_CapabilityPerBandPairList_r14_item;  /* SRS_CapabilityPerBandPair_r14 */
static int hf_lte_rrc_must_CapabilityPerBand_r14;  /* MUST_Parameters_r14 */
static int hf_lte_rrc_bandParametersDL_v1470;     /* MIMO_CA_ParametersPerBoBC_v1470 */
static int hf_lte_rrc_srs_CapabilityPerBandPairList_v14b0;  /* SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_SRS_CapabilityPerBandPair_v14b0 */
static int hf_lte_rrc_srs_CapabilityPerBandPairList_v14b0_item;  /* SRS_CapabilityPerBandPair_v14b0 */
static int hf_lte_rrc_ue_TxAntennaSelection_SRS_1T4R_r15;  /* T_ue_TxAntennaSelection_SRS_1T4R_r15 */
static int hf_lte_rrc_ue_TxAntennaSelection_SRS_2T4R_2Pairs_r15;  /* T_ue_TxAntennaSelection_SRS_2T4R_2Pairs_r15 */
static int hf_lte_rrc_ue_TxAntennaSelection_SRS_2T4R_3Pairs_r15;  /* T_ue_TxAntennaSelection_SRS_2T4R_3Pairs_r15 */
static int hf_lte_rrc_dl_1024QAM_r15;             /* T_dl_1024QAM_r15 */
static int hf_lte_rrc_qcl_TypeC_Operation_r15;    /* T_qcl_TypeC_Operation_r15 */
static int hf_lte_rrc_qcl_CRI_BasedCSI_Reporting_r15;  /* T_qcl_CRI_BasedCSI_Reporting_r15 */
static int hf_lte_rrc_stti_SPT_BandParameters_r15;  /* STTI_SPT_BandParameters_r15 */
static int hf_lte_rrc_intraFreqDAPS_r16;          /* T_intraFreqDAPS_r16 */
static int hf_lte_rrc_intraFreqAsyncDAPS_r16;     /* T_intraFreqAsyncDAPS_r16 */
static int hf_lte_rrc_dummy_02;                   /* T_dummy_01 */
static int hf_lte_rrc_intraFreqTwoTAGs_DAPS_r16;  /* T_intraFreqTwoTAGs_DAPS_r16 */
static int hf_lte_rrc_addSRS_FrequencyHopping_r16_01;  /* T_addSRS_FrequencyHopping_r16_01 */
static int hf_lte_rrc_addSRS_AntennaSwitching_r16_01;  /* T_addSRS_AntennaSwitching_r16_01 */
static int hf_lte_rrc_addSRS_1T2R_r16;            /* T_addSRS_1T2R_r16 */
static int hf_lte_rrc_addSRS_1T4R_r16;            /* T_addSRS_1T4R_r16 */
static int hf_lte_rrc_addSRS_2T4R_2pairs_r16;     /* T_addSRS_2T4R_2pairs_r16 */
static int hf_lte_rrc_addSRS_2T4R_3pairs_r16;     /* T_addSRS_2T4R_3pairs_r16 */
static int hf_lte_rrc_srs_CapabilityPerBandPairList_v1610;  /* SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_SRS_CapabilityPerBandPair_v1610 */
static int hf_lte_rrc_srs_CapabilityPerBandPairList_v1610_item;  /* SRS_CapabilityPerBandPair_v1610 */
static int hf_lte_rrc_v2x_FreqBandEUTRA_r14;      /* FreqBandIndicator_r11 */
static int hf_lte_rrc_bandParametersTxSL_r14;     /* BandParametersTxSL_r14 */
static int hf_lte_rrc_bandParametersRxSL_r14;     /* BandParametersRxSL_r14 */
static int hf_lte_rrc_v2x_EnhancedHighReception_r15;  /* T_v2x_EnhancedHighReception_r15 */
static int hf_lte_rrc_v2x_BandwidthClassTxSL_r14;  /* V2X_BandwidthClassSL_r14 */
static int hf_lte_rrc_v2x_eNB_Scheduled_r14;      /* T_v2x_eNB_Scheduled_r14 */
static int hf_lte_rrc_v2x_HighPower_r14;          /* T_v2x_HighPower_r14 */
static int hf_lte_rrc_v2x_BandwidthClassRxSL_r14;  /* V2X_BandwidthClassSL_r14 */
static int hf_lte_rrc_v2x_HighReception_r14;      /* T_v2x_HighReception_r14 */
static int hf_lte_rrc_V2X_BandwidthClassSL_r14_item;  /* V2X_BandwidthClass_r14 */
static int hf_lte_rrc_ul_256QAM_perCC_r14;        /* T_ul_256QAM_perCC_r14 */
static int hf_lte_rrc_mimo_CA_ParametersPerBoBC_r15;  /* MIMO_CA_ParametersPerBoBC_r15 */
static int hf_lte_rrc_featureSetPerCC_ListDL_r15;  /* SEQUENCE_SIZE_1_maxServCell_r13_OF_FeatureSetDL_PerCC_Id_r15 */
static int hf_lte_rrc_featureSetPerCC_ListDL_r15_item;  /* FeatureSetDL_PerCC_Id_r15 */
static int hf_lte_rrc_dl_1024QAM_r15_01;          /* T_dl_1024QAM_r15_01 */
static int hf_lte_rrc_fourLayerTM3_TM4_r15;       /* T_fourLayerTM3_TM4_r15 */
static int hf_lte_rrc_supportedMIMO_CapabilityDL_MRDC_r15;  /* MIMO_CapabilityDL_r10 */
static int hf_lte_rrc_supportedCSI_Proc_r15;      /* T_supportedCSI_Proc_r15 */
static int hf_lte_rrc_featureSetPerCC_ListUL_r15;  /* SEQUENCE_SIZE_1_maxServCell_r13_OF_FeatureSetUL_PerCC_Id_r15 */
static int hf_lte_rrc_featureSetPerCC_ListUL_r15_item;  /* FeatureSetUL_PerCC_Id_r15 */
static int hf_lte_rrc_supportedMIMO_CapabilityUL_r15;  /* MIMO_CapabilityUL_r10 */
static int hf_lte_rrc_ul_256QAM_r15;              /* T_ul_256QAM_r15 */
static int hf_lte_rrc_BandParametersUL_r10_item;  /* CA_MIMO_ParametersUL_r10 */
static int hf_lte_rrc_ca_BandwidthClassUL_r10;    /* CA_BandwidthClass_r10 */
static int hf_lte_rrc_supportedMIMO_CapabilityUL_r10;  /* MIMO_CapabilityUL_r10 */
static int hf_lte_rrc_BandParametersDL_r10_item;  /* CA_MIMO_ParametersDL_r10 */
static int hf_lte_rrc_ca_BandwidthClassDL_r10;    /* CA_BandwidthClass_r10 */
static int hf_lte_rrc_supportedMIMO_CapabilityDL_r10;  /* MIMO_CapabilityDL_r10 */
static int hf_lte_rrc_fourLayerTM3_TM4_r10;       /* T_fourLayerTM3_TM4_r10 */
static int hf_lte_rrc_intraBandContiguousCC_InfoList_r12;  /* SEQUENCE_SIZE_1_maxServCell_r10_OF_IntraBandContiguousCC_Info_r12 */
static int hf_lte_rrc_intraBandContiguousCC_InfoList_r12_item;  /* IntraBandContiguousCC_Info_r12 */
static int hf_lte_rrc_ca_BandwidthClassDL_r13;    /* CA_BandwidthClass_r10 */
static int hf_lte_rrc_supportedMIMO_CapabilityDL_r13;  /* MIMO_CapabilityDL_r10 */
static int hf_lte_rrc_fourLayerTM3_TM4_r13;       /* T_fourLayerTM3_TM4_r13 */
static int hf_lte_rrc_intraBandContiguousCC_InfoList_r13;  /* SEQUENCE_SIZE_1_maxServCell_r13_OF_IntraBandContiguousCC_Info_r12 */
static int hf_lte_rrc_intraBandContiguousCC_InfoList_r13_item;  /* IntraBandContiguousCC_Info_r12 */
static int hf_lte_rrc_supportedMIMO_CapabilityDL_r15;  /* MIMO_CapabilityDL_r10 */
static int hf_lte_rrc_fourLayerTM3_TM4_r15_01;    /* T_fourLayerTM3_TM4_r15_01 */
static int hf_lte_rrc_intraBandContiguousCC_InfoList_r15;  /* SEQUENCE_SIZE_1_maxServCell_r13_OF_IntraBandContiguousCC_Info_r12 */
static int hf_lte_rrc_intraBandContiguousCC_InfoList_r15_item;  /* IntraBandContiguousCC_Info_r12 */
static int hf_lte_rrc_fourLayerTM3_TM4_perCC_r12;  /* T_fourLayerTM3_TM4_perCC_r12 */
static int hf_lte_rrc_supportedMIMO_CapabilityDL_r12;  /* MIMO_CapabilityDL_r10 */
static int hf_lte_rrc_supportedCSI_Proc_r12;      /* T_supportedCSI_Proc_r12 */
static int hf_lte_rrc_must_TM234_UpTo2Tx_r14;     /* T_must_TM234_UpTo2Tx_r14 */
static int hf_lte_rrc_must_TM89_UpToOneInterferingLayer_r14;  /* T_must_TM89_UpToOneInterferingLayer_r14 */
static int hf_lte_rrc_must_TM10_UpToOneInterferingLayer_r14;  /* T_must_TM10_UpToOneInterferingLayer_r14 */
static int hf_lte_rrc_must_TM89_UpToThreeInterferingLayers_r14;  /* T_must_TM89_UpToThreeInterferingLayers_r14 */
static int hf_lte_rrc_must_TM10_UpToThreeInterferingLayers_r14;  /* T_must_TM10_UpToThreeInterferingLayers_r14 */
static int hf_lte_rrc_SupportedBandListEUTRA_item;  /* SupportedBandEUTRA */
static int hf_lte_rrc_SupportedBandListEUTRA_v9e0_item;  /* SupportedBandEUTRA_v9e0 */
static int hf_lte_rrc_SupportedBandListEUTRA_v1250_item;  /* SupportedBandEUTRA_v1250 */
static int hf_lte_rrc_SupportedBandListEUTRA_v1310_item;  /* SupportedBandEUTRA_v1310 */
static int hf_lte_rrc_SupportedBandListEUTRA_v1320_item;  /* SupportedBandEUTRA_v1320 */
static int hf_lte_rrc_SupportedBandListEUTRA_v1800_item;  /* SupportedBandEUTRA_v1800 */
static int hf_lte_rrc_bandEUTRA;                  /* FreqBandIndicator */
static int hf_lte_rrc_halfDuplex;                 /* BOOLEAN */
static int hf_lte_rrc_bandEUTRA_v9e0;             /* FreqBandIndicator_v9e0 */
static int hf_lte_rrc_dl_256QAM_r12;              /* T_dl_256QAM_r12 */
static int hf_lte_rrc_ul_64QAM_r12;               /* T_ul_64QAM_r12 */
static int hf_lte_rrc_ue_PowerClass_5_r13;        /* T_ue_PowerClass_5_r13 */
static int hf_lte_rrc_intraFreq_CE_NeedForGaps_r13;  /* T_intraFreq_CE_NeedForGaps_r13 */
static int hf_lte_rrc_ue_PowerClass_N_r13;        /* T_ue_PowerClass_N_r13 */
static int hf_lte_rrc_lowerMSD_MRDC_r18;          /* SEQUENCE_SIZE_1_maxLowerMSD_r18_OF_LowerMSD_MRDC_r18 */
static int hf_lte_rrc_lowerMSD_MRDC_r18_item;     /* LowerMSD_MRDC_r18 */
static int hf_lte_rrc_bandListEUTRA;              /* BandListEUTRA */
static int hf_lte_rrc_bandCombinationListEUTRA_r10;  /* BandCombinationListEUTRA_r10 */
static int hf_lte_rrc_rsrqMeasWideband_r11;       /* T_rsrqMeasWideband_r11 */
static int hf_lte_rrc_benefitsFromInterruption_r11;  /* T_benefitsFromInterruption_r11 */
static int hf_lte_rrc_timerT312_r12;              /* T_timerT312_r12 */
static int hf_lte_rrc_alternativeTimeToTrigger_r12_01;  /* T_alternativeTimeToTrigger_r12_01 */
static int hf_lte_rrc_incMonEUTRA_r12;            /* T_incMonEUTRA_r12 */
static int hf_lte_rrc_incMonUTRA_r12;             /* T_incMonUTRA_r12 */
static int hf_lte_rrc_extendedMaxMeasId_r12;      /* T_extendedMaxMeasId_r12 */
static int hf_lte_rrc_extendedRSRQ_LowerRange_r12;  /* T_extendedRSRQ_LowerRange_r12 */
static int hf_lte_rrc_rsrq_OnAllSymbols_r12;      /* T_rsrq_OnAllSymbols_r12 */
static int hf_lte_rrc_crs_DiscoverySignalsMeas_r12;  /* T_crs_DiscoverySignalsMeas_r12 */
static int hf_lte_rrc_csi_RS_DiscoverySignalsMeas_r12;  /* T_csi_RS_DiscoverySignalsMeas_r12 */
static int hf_lte_rrc_rs_SINR_Meas_r13;           /* T_rs_SINR_Meas_r13 */
static int hf_lte_rrc_allowedCellList_r13;        /* T_allowedCellList_r13 */
static int hf_lte_rrc_extendedMaxObjectId_r13;    /* T_extendedMaxObjectId_r13 */
static int hf_lte_rrc_ul_PDCP_Delay_r13;          /* T_ul_PDCP_Delay_r13 */
static int hf_lte_rrc_extendedFreqPriorities_r13;  /* T_extendedFreqPriorities_r13 */
static int hf_lte_rrc_multiBandInfoReport_r13;    /* T_multiBandInfoReport_r13 */
static int hf_lte_rrc_rssi_AndChannelOccupancyReporting_r13;  /* T_rssi_AndChannelOccupancyReporting_r13 */
static int hf_lte_rrc_ceMeasurements_r14;         /* T_ceMeasurements_r14 */
static int hf_lte_rrc_ncsg_r14;                   /* T_ncsg_r14 */
static int hf_lte_rrc_shortMeasurementGap_r14;    /* T_shortMeasurementGap_r14 */
static int hf_lte_rrc_perServingCellMeasurementGap_r14;  /* T_perServingCellMeasurementGap_r14 */
static int hf_lte_rrc_nonUniformGap_r14;          /* T_nonUniformGap_r14 */
static int hf_lte_rrc_measGapPatterns_r15;        /* T_measGapPatterns_r15 */
static int hf_lte_rrc_qoe_MeasReport_r15;         /* T_qoe_MeasReport_r15 */
static int hf_lte_rrc_qoe_MTSI_MeasReport_r15;    /* T_qoe_MTSI_MeasReport_r15 */
static int hf_lte_rrc_ca_IdleModeMeasurements_r15;  /* T_ca_IdleModeMeasurements_r15 */
static int hf_lte_rrc_ca_IdleModeValidityArea_r15;  /* T_ca_IdleModeValidityArea_r15 */
static int hf_lte_rrc_heightMeas_r15;             /* T_heightMeas_r15 */
static int hf_lte_rrc_multipleCellsMeasExtension_r15;  /* T_multipleCellsMeasExtension_r15 */
static int hf_lte_rrc_bandInfoNR_v1610;           /* SEQUENCE_SIZE_1_maxBands_OF_MeasGapInfoNR_r16 */
static int hf_lte_rrc_bandInfoNR_v1610_item;      /* MeasGapInfoNR_r16 */
static int hf_lte_rrc_altFreqPriority_r16;        /* T_altFreqPriority_r16 */
static int hf_lte_rrc_ce_DL_ChannelQualityReporting_r16;  /* T_ce_DL_ChannelQualityReporting_r16 */
static int hf_lte_rrc_ce_MeasRSS_Dedicated_r16;   /* T_ce_MeasRSS_Dedicated_r16 */
static int hf_lte_rrc_eutra_IdleInactiveMeasurements_r16;  /* T_eutra_IdleInactiveMeasurements_r16 */
static int hf_lte_rrc_nr_IdleInactiveMeasFR1_r16;  /* T_nr_IdleInactiveMeasFR1_r16 */
static int hf_lte_rrc_nr_IdleInactiveMeasFR2_r16;  /* T_nr_IdleInactiveMeasFR2_r16 */
static int hf_lte_rrc_idleInactiveValidityAreaList_r16;  /* T_idleInactiveValidityAreaList_r16 */
static int hf_lte_rrc_measGapPatterns_NRonly_r16;  /* T_measGapPatterns_NRonly_r16 */
static int hf_lte_rrc_measGapPatterns_NRonly_ENDC_r16;  /* T_measGapPatterns_NRonly_ENDC_r16 */
static int hf_lte_rrc_nr_IdleInactiveBeamMeasFR1_r16;  /* T_nr_IdleInactiveBeamMeasFR1_r16 */
static int hf_lte_rrc_nr_IdleInactiveBeamMeasFR2_r16;  /* T_nr_IdleInactiveBeamMeasFR2_r16 */
static int hf_lte_rrc_ce_MeasRSS_DedicatedSameRBs_r16;  /* T_ce_MeasRSS_DedicatedSameRBs_r16 */
static int hf_lte_rrc_nr_CellIndividualOffset_r16;  /* T_nr_CellIndividualOffset_r16 */
static int hf_lte_rrc_sharedSpectrumMeasNR_EN_DC_r17;  /* SEQUENCE_SIZE_1_maxBandsNR_r15_OF_SharedSpectrumMeasNR_r17 */
static int hf_lte_rrc_sharedSpectrumMeasNR_EN_DC_r17_item;  /* SharedSpectrumMeasNR_r17 */
static int hf_lte_rrc_sharedSpectrumMeasNR_SA_r17;  /* SEQUENCE_SIZE_1_maxBandsNR_r15_OF_SharedSpectrumMeasNR_r17 */
static int hf_lte_rrc_sharedSpectrumMeasNR_SA_r17_item;  /* SharedSpectrumMeasNR_r17 */
static int hf_lte_rrc_gaplessMeas_FR2_maxCC_r17;  /* INTEGER_1_32 */
static int hf_lte_rrc_bandInfoNR_v1800;           /* SEQUENCE_SIZE_1_maxBands_OF_MeasGapInfoNR_r18 */
static int hf_lte_rrc_bandInfoNR_v1800_item;      /* MeasGapInfoNR_r18 */
static int hf_lte_rrc_nr_RSSI_ChannelOccupancyReporting_r17;  /* BOOLEAN */
static int hf_lte_rrc_interRAT_BandListNR_EN_DC_r16;  /* InterRAT_BandListNR_r16 */
static int hf_lte_rrc_interRAT_BandListNR_SA_r16;  /* InterRAT_BandListNR_r16 */
static int hf_lte_rrc_interRAT_BandListNR_EN_DC_r18;  /* InterRAT_BandListNR_r18 */
static int hf_lte_rrc_interRAT_BandListNR_SA_r18;  /* InterRAT_BandListNR_r18 */
static int hf_lte_rrc_BandListEUTRA_item;         /* BandInfoEUTRA */
static int hf_lte_rrc_BandCombinationListEUTRA_r10_item;  /* BandInfoEUTRA */
static int hf_lte_rrc_interFreqBandList;          /* InterFreqBandList */
static int hf_lte_rrc_interRAT_BandList;          /* InterRAT_BandList */
static int hf_lte_rrc_InterFreqBandList_item;     /* InterFreqBandInfo */
static int hf_lte_rrc_interFreqNeedForGaps;       /* BOOLEAN */
static int hf_lte_rrc_InterRAT_BandList_item;     /* InterRAT_BandInfo */
static int hf_lte_rrc_InterRAT_BandListNR_r16_item;  /* InterRAT_BandInfoNR_r16 */
static int hf_lte_rrc_InterRAT_BandListNR_r18_item;  /* InterRAT_BandInfoNR_r18 */
static int hf_lte_rrc_interRAT_NeedForGaps;       /* BOOLEAN */
static int hf_lte_rrc_interRAT_NeedForGapsNR_r16;  /* BOOLEAN */
static int hf_lte_rrc_interRAT_NeedForInterruptionNR_r18;  /* T_interRAT_NeedForInterruptionNR_r18 */
static int hf_lte_rrc_en_DC_r15;                  /* T_en_DC_r15 */
static int hf_lte_rrc_eventB2_r15;                /* T_eventB2_r15 */
static int hf_lte_rrc_supportedBandListEN_DC_r15;  /* SupportedBandListNR_r15 */
static int hf_lte_rrc_eutra_5GC_HO_ToNR_FDD_FR1_r15;  /* T_eutra_5GC_HO_ToNR_FDD_FR1_r15 */
static int hf_lte_rrc_eutra_5GC_HO_ToNR_TDD_FR1_r15;  /* T_eutra_5GC_HO_ToNR_TDD_FR1_r15 */
static int hf_lte_rrc_eutra_5GC_HO_ToNR_FDD_FR2_r15;  /* T_eutra_5GC_HO_ToNR_FDD_FR2_r15 */
static int hf_lte_rrc_eutra_5GC_HO_ToNR_TDD_FR2_r15;  /* T_eutra_5GC_HO_ToNR_TDD_FR2_r15 */
static int hf_lte_rrc_eutra_EPC_HO_ToNR_FDD_FR1_r15;  /* T_eutra_EPC_HO_ToNR_FDD_FR1_r15 */
static int hf_lte_rrc_eutra_EPC_HO_ToNR_TDD_FR1_r15;  /* T_eutra_EPC_HO_ToNR_TDD_FR1_r15 */
static int hf_lte_rrc_eutra_EPC_HO_ToNR_FDD_FR2_r15;  /* T_eutra_EPC_HO_ToNR_FDD_FR2_r15 */
static int hf_lte_rrc_eutra_EPC_HO_ToNR_TDD_FR2_r15;  /* T_eutra_EPC_HO_ToNR_TDD_FR2_r15 */
static int hf_lte_rrc_ims_VoiceOverNR_FR1_r15;    /* T_ims_VoiceOverNR_FR1_r15 */
static int hf_lte_rrc_ims_VoiceOverNR_FR2_r15;    /* T_ims_VoiceOverNR_FR2_r15 */
static int hf_lte_rrc_sa_NR_r15;                  /* T_sa_NR_r15 */
static int hf_lte_rrc_supportedBandListNR_SA_r15;  /* SupportedBandListNR_r15 */
static int hf_lte_rrc_ng_EN_DC_r15;               /* T_ng_EN_DC_r15 */
static int hf_lte_rrc_ss_SINR_Meas_NR_FR1_r15;    /* T_ss_SINR_Meas_NR_FR1_r15 */
static int hf_lte_rrc_ss_SINR_Meas_NR_FR2_r15;    /* T_ss_SINR_Meas_NR_FR2_r15 */
static int hf_lte_rrc_nr_HO_ToEN_DC_r16;          /* T_nr_HO_ToEN_DC_r16 */
static int hf_lte_rrc_ce_EUTRA_5GC_HO_ToNR_FDD_FR1_r16;  /* T_ce_EUTRA_5GC_HO_ToNR_FDD_FR1_r16 */
static int hf_lte_rrc_ce_EUTRA_5GC_HO_ToNR_TDD_FR1_r16;  /* T_ce_EUTRA_5GC_HO_ToNR_TDD_FR1_r16 */
static int hf_lte_rrc_ce_EUTRA_5GC_HO_ToNR_FDD_FR2_r16;  /* T_ce_EUTRA_5GC_HO_ToNR_FDD_FR2_r16 */
static int hf_lte_rrc_ce_EUTRA_5GC_HO_ToNR_TDD_FR2_r16;  /* T_ce_EUTRA_5GC_HO_ToNR_TDD_FR2_r16 */
static int hf_lte_rrc_extendedBand_n77_r16;       /* T_extendedBand_n77_r16 */
static int hf_lte_rrc_eutra_5GC_HO_ToNR_TDD_FR2_2_r17;  /* T_eutra_5GC_HO_ToNR_TDD_FR2_2_r17 */
static int hf_lte_rrc_eutra_EPC_HO_ToNR_TDD_FR2_2_r17;  /* T_eutra_EPC_HO_ToNR_TDD_FR2_2_r17 */
static int hf_lte_rrc_ce_EUTRA_5GC_HO_ToNR_TDD_FR2_2_r17;  /* T_ce_EUTRA_5GC_HO_ToNR_TDD_FR2_2_r17 */
static int hf_lte_rrc_ims_VoiceOverNR_FR2_2_r17;  /* T_ims_VoiceOverNR_FR2_2_r17 */
static int hf_lte_rrc_extendedBand_n77_2_r17;     /* T_extendedBand_n77_2_r17 */
static int hf_lte_rrc_aggressorband1_r18;         /* FreqBandIndicatorNR_r15 */
static int hf_lte_rrc_aggressorband2_r18;         /* FreqBandIndicator_r11 */
static int hf_lte_rrc_msd_Information_r18;        /* SEQUENCE_SIZE_1_maxLowerMSD_Info_r18_OF_MSD_Information_r18 */
static int hf_lte_rrc_msd_Information_r18_item;   /* MSD_Information_r18 */
static int hf_lte_rrc_msd_Type_r18;               /* T_msd_Type_r18 */
static int hf_lte_rrc_msd_PowerClass_r18;         /* T_msd_PowerClass_r18 */
static int hf_lte_rrc_msd_Class_r18;              /* T_msd_Class_r18 */
static int hf_lte_rrc_eutra_5GC_r15;              /* T_eutra_5GC_r15 */
static int hf_lte_rrc_eutra_EPC_HO_EUTRA_5GC_r15;  /* T_eutra_EPC_HO_EUTRA_5GC_r15 */
static int hf_lte_rrc_ho_EUTRA_5GC_FDD_TDD_r15;   /* T_ho_EUTRA_5GC_FDD_TDD_r15 */
static int hf_lte_rrc_ho_InterfreqEUTRA_5GC_r15;  /* T_ho_InterfreqEUTRA_5GC_r15 */
static int hf_lte_rrc_ims_VoiceOverMCG_BearerEUTRA_5GC_r15;  /* T_ims_VoiceOverMCG_BearerEUTRA_5GC_r15 */
static int hf_lte_rrc_inactiveState_r15;          /* T_inactiveState_r15 */
static int hf_lte_rrc_reflectiveQoS_r15;          /* T_reflectiveQoS_r15 */
static int hf_lte_rrc_ce_InactiveState_r16;       /* T_ce_InactiveState_r16 */
static int hf_lte_rrc_ce_EUTRA_5GC_r16;           /* T_ce_EUTRA_5GC_r16 */
static int hf_lte_rrc_rohc_Profiles_r15;          /* ROHC_ProfileSupportList_r15 */
static int hf_lte_rrc_rohc_ContextMaxSessions_r15;  /* T_rohc_ContextMaxSessions_r15 */
static int hf_lte_rrc_rohc_ProfilesUL_Only_r15;   /* T_rohc_ProfilesUL_Only_r15 */
static int hf_lte_rrc_profile0x0006_r15;          /* BOOLEAN */
static int hf_lte_rrc_rohc_ContextContinue_r15;   /* T_rohc_ContextContinue_r15 */
static int hf_lte_rrc_outOfOrderDelivery_r15;     /* T_outOfOrderDelivery_r15 */
static int hf_lte_rrc_sn_SizeLo_r15;              /* T_sn_SizeLo_r15 */
static int hf_lte_rrc_ims_VoiceOverNR_PDCP_MCG_Bearer_r15;  /* T_ims_VoiceOverNR_PDCP_MCG_Bearer_r15 */
static int hf_lte_rrc_ims_VoiceOverNR_PDCP_SCG_Bearer_r15;  /* T_ims_VoiceOverNR_PDCP_SCG_Bearer_r15 */
static int hf_lte_rrc_ims_VoNR_PDCP_SCG_NGENDC_r15;  /* T_ims_VoNR_PDCP_SCG_NGENDC_r15 */
static int hf_lte_rrc_profile0x0001_r15;          /* BOOLEAN */
static int hf_lte_rrc_profile0x0002_r15;          /* BOOLEAN */
static int hf_lte_rrc_profile0x0003_r15;          /* BOOLEAN */
static int hf_lte_rrc_profile0x0004_r15;          /* BOOLEAN */
static int hf_lte_rrc_profile0x0101_r15;          /* BOOLEAN */
static int hf_lte_rrc_profile0x0102_r15;          /* BOOLEAN */
static int hf_lte_rrc_profile0x0103_r15;          /* BOOLEAN */
static int hf_lte_rrc_profile0x0104_r15;          /* BOOLEAN */
static int hf_lte_rrc_SupportedBandListNR_r15_item;  /* SupportedBandNR_r15 */
static int hf_lte_rrc_bandNR_r15_01;              /* FreqBandIndicatorNR_r15 */
static int hf_lte_rrc_supportedBandListUTRA_FDD;  /* SupportedBandListUTRA_FDD */
static int hf_lte_rrc_e_RedirectionUTRA_r9;       /* T_e_RedirectionUTRA_r9 */
static int hf_lte_rrc_voiceOverPS_HS_UTRA_FDD_r9;  /* T_voiceOverPS_HS_UTRA_FDD_r9 */
static int hf_lte_rrc_voiceOverPS_HS_UTRA_TDD128_r9;  /* T_voiceOverPS_HS_UTRA_TDD128_r9 */
static int hf_lte_rrc_srvcc_FromUTRA_FDD_ToUTRA_FDD_r9;  /* T_srvcc_FromUTRA_FDD_ToUTRA_FDD_r9 */
static int hf_lte_rrc_srvcc_FromUTRA_FDD_ToGERAN_r9;  /* T_srvcc_FromUTRA_FDD_ToGERAN_r9 */
static int hf_lte_rrc_srvcc_FromUTRA_TDD128_ToUTRA_TDD128_r9;  /* T_srvcc_FromUTRA_TDD128_ToUTRA_TDD128_r9 */
static int hf_lte_rrc_srvcc_FromUTRA_TDD128_ToGERAN_r9;  /* T_srvcc_FromUTRA_TDD128_ToGERAN_r9 */
static int hf_lte_rrc_mfbi_UTRA_r9;               /* T_mfbi_UTRA_r9 */
static int hf_lte_rrc_SupportedBandListUTRA_FDD_item;  /* SupportedBandUTRA_FDD */
static int hf_lte_rrc_supportedBandListUTRA_TDD128;  /* SupportedBandListUTRA_TDD128 */
static int hf_lte_rrc_SupportedBandListUTRA_TDD128_item;  /* SupportedBandUTRA_TDD128 */
static int hf_lte_rrc_supportedBandListUTRA_TDD384;  /* SupportedBandListUTRA_TDD384 */
static int hf_lte_rrc_SupportedBandListUTRA_TDD384_item;  /* SupportedBandUTRA_TDD384 */
static int hf_lte_rrc_supportedBandListUTRA_TDD768;  /* SupportedBandListUTRA_TDD768 */
static int hf_lte_rrc_SupportedBandListUTRA_TDD768_item;  /* SupportedBandUTRA_TDD768 */
static int hf_lte_rrc_e_RedirectionUTRA_TDD_r10;  /* T_e_RedirectionUTRA_TDD_r10 */
static int hf_lte_rrc_supportedBandListGERAN;     /* SupportedBandListGERAN */
static int hf_lte_rrc_interRAT_PS_HO_ToGERAN;     /* BOOLEAN */
static int hf_lte_rrc_dtm_r9;                     /* T_dtm_r9 */
static int hf_lte_rrc_e_RedirectionGERAN_r9;      /* T_e_RedirectionGERAN_r9 */
static int hf_lte_rrc_SupportedBandListGERAN_item;  /* SupportedBandGERAN */
static int hf_lte_rrc_supportedBandListHRPD;      /* SupportedBandListHRPD */
static int hf_lte_rrc_tx_ConfigHRPD;              /* T_tx_ConfigHRPD */
static int hf_lte_rrc_rx_ConfigHRPD;              /* T_rx_ConfigHRPD */
static int hf_lte_rrc_SupportedBandListHRPD_item;  /* BandclassCDMA2000 */
static int hf_lte_rrc_supportedBandList1XRTT;     /* SupportedBandList1XRTT */
static int hf_lte_rrc_tx_Config1XRTT;             /* T_tx_Config1XRTT */
static int hf_lte_rrc_rx_Config1XRTT;             /* T_rx_Config1XRTT */
static int hf_lte_rrc_e_CSFB_1XRTT_r9;            /* T_e_CSFB_1XRTT_r9 */
static int hf_lte_rrc_e_CSFB_ConcPS_Mob1XRTT_r9;  /* T_e_CSFB_ConcPS_Mob1XRTT_r9 */
static int hf_lte_rrc_e_CSFB_dual_1XRTT_r10;      /* T_e_CSFB_dual_1XRTT_r10 */
static int hf_lte_rrc_cdma2000_NW_Sharing_r11;    /* T_cdma2000_NW_Sharing_r11 */
static int hf_lte_rrc_SupportedBandList1XRTT_item;  /* BandclassCDMA2000 */
static int hf_lte_rrc_supportedBandListWLAN_r13;  /* SupportedBandListWLAN_r13 */
static int hf_lte_rrc_supportedBandListWLAN_r13_item;  /* WLAN_BandIndicator_r13 */
static int hf_lte_rrc_intraFreqProximityIndication_r9;  /* T_intraFreqProximityIndication_r9 */
static int hf_lte_rrc_interFreqProximityIndication_r9;  /* T_interFreqProximityIndication_r9 */
static int hf_lte_rrc_utran_ProximityIndication_r9;  /* T_utran_ProximityIndication_r9 */
static int hf_lte_rrc_intraFreqSI_AcquisitionForHO_r9;  /* T_intraFreqSI_AcquisitionForHO_r9 */
static int hf_lte_rrc_interFreqSI_AcquisitionForHO_r9;  /* T_interFreqSI_AcquisitionForHO_r9 */
static int hf_lte_rrc_utran_SI_AcquisitionForHO_r9;  /* T_utran_SI_AcquisitionForHO_r9 */
static int hf_lte_rrc_reportCGI_NR_EN_DC_r15;     /* T_reportCGI_NR_EN_DC_r15 */
static int hf_lte_rrc_reportCGI_NR_NoEN_DC_r15;   /* T_reportCGI_NR_NoEN_DC_r15 */
static int hf_lte_rrc_eutra_CGI_Reporting_ENDC_r15;  /* T_eutra_CGI_Reporting_ENDC_r15 */
static int hf_lte_rrc_utra_GERAN_CGI_Reporting_ENDC_r15;  /* T_utra_GERAN_CGI_Reporting_ENDC_r15 */
static int hf_lte_rrc_eutra_CGI_Reporting_NEDC_r15;  /* T_eutra_CGI_Reporting_NEDC_r15 */
static int hf_lte_rrc_eutra_SI_AcquisitionForHO_ENDC_r16;  /* T_eutra_SI_AcquisitionForHO_ENDC_r16 */
static int hf_lte_rrc_nr_AutonomousGaps_ENDC_FR1_r16;  /* T_nr_AutonomousGaps_ENDC_FR1_r16 */
static int hf_lte_rrc_nr_AutonomousGaps_ENDC_FR2_r16;  /* T_nr_AutonomousGaps_ENDC_FR2_r16 */
static int hf_lte_rrc_nr_AutonomousGaps_FR1_r16;  /* T_nr_AutonomousGaps_FR1_r16 */
static int hf_lte_rrc_nr_AutonomousGaps_FR2_r16;  /* T_nr_AutonomousGaps_FR2_r16 */
static int hf_lte_rrc_gNB_ID_Length_Reporting_NR_EN_DC_r17;  /* T_gNB_ID_Length_Reporting_NR_EN_DC_r17 */
static int hf_lte_rrc_gNB_ID_Length_Reporting_NR_NoEN_DC_r17;  /* T_gNB_ID_Length_Reporting_NR_NoEN_DC_r17 */
static int hf_lte_rrc_rach_Report_r9_01;          /* T_rach_Report_r9 */
static int hf_lte_rrc_rach_ReportForNR_r18;       /* T_rach_ReportForNR_r18 */
static int hf_lte_rrc_pur_CP_5GC_CE_ModeA_r16;    /* T_pur_CP_5GC_CE_ModeA_r16 */
static int hf_lte_rrc_pur_CP_5GC_CE_ModeB_r16;    /* T_pur_CP_5GC_CE_ModeB_r16 */
static int hf_lte_rrc_pur_UP_5GC_CE_ModeA_r16;    /* T_pur_UP_5GC_CE_ModeA_r16 */
static int hf_lte_rrc_pur_UP_5GC_CE_ModeB_r16;    /* T_pur_UP_5GC_CE_ModeB_r16 */
static int hf_lte_rrc_pur_CP_EPC_CE_ModeA_r16;    /* T_pur_CP_EPC_CE_ModeA_r16 */
static int hf_lte_rrc_pur_CP_EPC_CE_ModeB_r16;    /* T_pur_CP_EPC_CE_ModeB_r16 */
static int hf_lte_rrc_pur_UP_EPC_CE_ModeA_r16;    /* T_pur_UP_EPC_CE_ModeA_r16 */
static int hf_lte_rrc_pur_UP_EPC_CE_ModeB_r16;    /* T_pur_UP_EPC_CE_ModeB_r16 */
static int hf_lte_rrc_pur_CP_L1Ack_r16;           /* T_pur_CP_L1Ack_r16 */
static int hf_lte_rrc_pur_FrequencyHopping_r16;   /* T_pur_FrequencyHopping_r16 */
static int hf_lte_rrc_pur_PUSCH_NB_MaxTBS_r16;    /* T_pur_PUSCH_NB_MaxTBS_r16 */
static int hf_lte_rrc_pur_RSRP_Validation_r16;    /* T_pur_RSRP_Validation_r16 */
static int hf_lte_rrc_pur_SubPRB_CE_ModeA_r16;    /* T_pur_SubPRB_CE_ModeA_r16 */
static int hf_lte_rrc_pur_SubPRB_CE_ModeB_r16;    /* T_pur_SubPRB_CE_ModeB_r16 */
static int hf_lte_rrc_loggedMeasurementsIdle_r10;  /* T_loggedMeasurementsIdle_r10 */
static int hf_lte_rrc_standaloneGNSS_Location_r10;  /* T_standaloneGNSS_Location_r10 */
static int hf_lte_rrc_loggedMBSFNMeasurements_r12;  /* T_loggedMBSFNMeasurements_r12 */
static int hf_lte_rrc_locationReport_r14;         /* T_locationReport_r14 */
static int hf_lte_rrc_loggedMeasBT_r15;           /* T_loggedMeasBT_r15 */
static int hf_lte_rrc_loggedMeasWLAN_r15;         /* T_loggedMeasWLAN_r15 */
static int hf_lte_rrc_immMeasBT_r15;              /* T_immMeasBT_r15 */
static int hf_lte_rrc_immMeasWLAN_r15;            /* T_immMeasWLAN_r15 */
static int hf_lte_rrc_ul_PDCP_AvgDelay_r16;       /* T_ul_PDCP_AvgDelay_r16 */
static int hf_lte_rrc_loggedMeasIdleEventL1_r17;  /* T_loggedMeasIdleEventL1_r17 */
static int hf_lte_rrc_loggedMeasIdleEventOutOfCoverage_r17;  /* T_loggedMeasIdleEventOutOfCoverage_r17 */
static int hf_lte_rrc_loggedMeasUncomBarPre_r17;  /* T_loggedMeasUncomBarPre_r17 */
static int hf_lte_rrc_immMeasUncomBarPre_r17;     /* T_immMeasUncomBarPre_r17 */
static int hf_lte_rrc_sigBasedEUTRA_LoggedMeasOverrideProtect_r18;  /* T_sigBasedEUTRA_LoggedMeasOverrideProtect_r18 */
static int hf_lte_rrc_otdoa_UE_Assisted_r10;      /* T_otdoa_UE_Assisted_r10 */
static int hf_lte_rrc_interFreqRSTD_Measurement_r10;  /* T_interFreqRSTD_Measurement_r10 */
static int hf_lte_rrc_inDeviceCoexInd_r11;        /* T_inDeviceCoexInd_r11 */
static int hf_lte_rrc_powerPrefInd_r11;           /* T_powerPrefInd_r11 */
static int hf_lte_rrc_ue_Rx_TxTimeDiffMeasurements_r11;  /* T_ue_Rx_TxTimeDiffMeasurements_r11 */
static int hf_lte_rrc_inDeviceCoexInd_UL_CA_r11;  /* T_inDeviceCoexInd_UL_CA_r11 */
static int hf_lte_rrc_inDeviceCoexInd_HardwareSharingInd_r13;  /* T_inDeviceCoexInd_HardwareSharingInd_r13 */
static int hf_lte_rrc_bwPrefInd_r14;              /* T_bwPrefInd_r14 */
static int hf_lte_rrc_rlm_ReportSupport_r14;      /* T_rlm_ReportSupport_r14 */
static int hf_lte_rrc_overheatingInd_r14;         /* T_overheatingInd_r14 */
static int hf_lte_rrc_nonCSG_SI_Reporting_r14;    /* T_nonCSG_SI_Reporting_r14 */
static int hf_lte_rrc_assistInfoBitForLC_r15;     /* T_assistInfoBitForLC_r15 */
static int hf_lte_rrc_timeReferenceProvision_r15;  /* T_timeReferenceProvision_r15 */
static int hf_lte_rrc_flightPathPlan_r15;         /* T_flightPathPlan_r15 */
static int hf_lte_rrc_inDeviceCoexInd_ENDC_r15;   /* T_inDeviceCoexInd_ENDC_r15 */
static int hf_lte_rrc_resumeWithStoredMCG_SCells_r16;  /* T_resumeWithStoredMCG_SCells_r16 */
static int hf_lte_rrc_resumeWithMCG_SCellConfig_r16;  /* T_resumeWithMCG_SCellConfig_r16 */
static int hf_lte_rrc_resumeWithStoredSCG_r16;    /* T_resumeWithStoredSCG_r16 */
static int hf_lte_rrc_resumeWithSCG_Config_r16;   /* T_resumeWithSCG_Config_r16 */
static int hf_lte_rrc_mcgRLF_RecoveryViaSCG_r16;  /* T_mcgRLF_RecoveryViaSCG_r16 */
static int hf_lte_rrc_overheatingIndForSCG_r16;   /* T_overheatingIndForSCG_r16 */
static int hf_lte_rrc_mpsPriorityIndication_r16_01;  /* T_mpsPriorityIndication_r16_01 */
static int hf_lte_rrc_ul_RRC_Segmentation_r16_01;  /* T_ul_RRC_Segmentation_r16_01 */
static int hf_lte_rrc_mbms_SCell_r11;             /* T_mbms_SCell_r11 */
static int hf_lte_rrc_mbms_NonServingCell_r11;    /* T_mbms_NonServingCell_r11 */
static int hf_lte_rrc_mbms_AsyncDC_r12;           /* T_mbms_AsyncDC_r12 */
static int hf_lte_rrc_fembmsDedicatedCell_r14;    /* T_fembmsDedicatedCell_r14 */
static int hf_lte_rrc_fembmsMixedCell_r14;        /* T_fembmsMixedCell_r14 */
static int hf_lte_rrc_subcarrierSpacingMBMS_khz7dot5_r14;  /* T_subcarrierSpacingMBMS_khz7dot5_r14 */
static int hf_lte_rrc_subcarrierSpacingMBMS_khz1dot25_r14;  /* T_subcarrierSpacingMBMS_khz1dot25_r14 */
static int hf_lte_rrc_mbms_MaxBW_r14;             /* T_mbms_MaxBW_r14 */
static int hf_lte_rrc_implicitValue;              /* NULL */
static int hf_lte_rrc_explicitValue_06;           /* INTEGER_2_20 */
static int hf_lte_rrc_mbms_ScalingFactor1dot25_r14;  /* T_mbms_ScalingFactor1dot25_r14 */
static int hf_lte_rrc_mbms_ScalingFactor7dot5_r14;  /* T_mbms_ScalingFactor7dot5_r14 */
static int hf_lte_rrc_mbms_ScalingFactor2dot5_r16;  /* T_mbms_ScalingFactor2dot5_r16 */
static int hf_lte_rrc_mbms_ScalingFactor0dot37_r16;  /* T_mbms_ScalingFactor0dot37_r16 */
static int hf_lte_rrc_mbms_SupportedBandInfoList_r16;  /* SEQUENCE_SIZE_1_maxBands_OF_MBMS_SupportedBandInfo_r16 */
static int hf_lte_rrc_mbms_SupportedBandInfoList_r16_item;  /* MBMS_SupportedBandInfo_r16 */
static int hf_lte_rrc_mbms_SupportedBandInfoList_v1700;  /* SEQUENCE_SIZE_1_maxBands_OF_MBMS_SupportedBandInfo_v1700 */
static int hf_lte_rrc_mbms_SupportedBandInfoList_v1700_item;  /* MBMS_SupportedBandInfo_v1700 */
static int hf_lte_rrc_subcarrierSpacingMBMS_khz2dot5_r16;  /* T_subcarrierSpacingMBMS_khz2dot5_r16 */
static int hf_lte_rrc_subcarrierSpacingMBMS_khz0dot37_r16;  /* T_subcarrierSpacingMBMS_khz0dot37_r16 */
static int hf_lte_rrc_timeSeparationSlot2_r16;    /* T_timeSeparationSlot2_r16 */
static int hf_lte_rrc_timeSeparationSlot4_r16;    /* T_timeSeparationSlot4_r16 */
static int hf_lte_rrc_pmch_Bandwidth_n40_r17;     /* T_pmch_Bandwidth_n40_r17 */
static int hf_lte_rrc_pmch_Bandwidth_n35_r17;     /* T_pmch_Bandwidth_n35_r17 */
static int hf_lte_rrc_pmch_Bandwidth_n30_r17;     /* T_pmch_Bandwidth_n30_r17 */
static int hf_lte_rrc_unicast_fembmsMixedSCell_r14;  /* T_unicast_fembmsMixedSCell_r14 */
static int hf_lte_rrc_emptyUnicastRegion_r14;     /* T_emptyUnicastRegion_r14 */
static int hf_lte_rrc_scptm_ParallelReception_r13;  /* T_scptm_ParallelReception_r13 */
static int hf_lte_rrc_scptm_SCell_r13;            /* T_scptm_SCell_r13 */
static int hf_lte_rrc_scptm_NonServingCell_r13;   /* T_scptm_NonServingCell_r13 */
static int hf_lte_rrc_scptm_AsyncDC_r13;          /* T_scptm_AsyncDC_r13 */
static int hf_lte_rrc_ce_ModeA_r13;               /* T_ce_ModeA_r13 */
static int hf_lte_rrc_ce_ModeB_r13_01;            /* T_ce_ModeB_r13_01 */
static int hf_lte_rrc_intraFreqA3_CE_ModeA_r13;   /* T_intraFreqA3_CE_ModeA_r13 */
static int hf_lte_rrc_intraFreqA3_CE_ModeB_r13;   /* T_intraFreqA3_CE_ModeB_r13 */
static int hf_lte_rrc_intraFreqHO_CE_ModeA_r13;   /* T_intraFreqHO_CE_ModeA_r13 */
static int hf_lte_rrc_intraFreqHO_CE_ModeB_r13;   /* T_intraFreqHO_CE_ModeB_r13 */
static int hf_lte_rrc_unicastFrequencyHopping_r13;  /* T_unicastFrequencyHopping_r13 */
static int hf_lte_rrc_tm9_CE_ModeA_r13;           /* T_tm9_CE_ModeA_r13 */
static int hf_lte_rrc_tm9_CE_ModeB_r13;           /* T_tm9_CE_ModeB_r13 */
static int hf_lte_rrc_tm6_CE_ModeA_r13;           /* T_tm6_CE_ModeA_r13 */
static int hf_lte_rrc_ce_SwitchWithoutHO_r14;     /* T_ce_SwitchWithoutHO_r14 */
static int hf_lte_rrc_pdsch_MultiTB_CE_ModeA_r16;  /* T_pdsch_MultiTB_CE_ModeA_r16 */
static int hf_lte_rrc_pdsch_MultiTB_CE_ModeB_r16;  /* T_pdsch_MultiTB_CE_ModeB_r16 */
static int hf_lte_rrc_pusch_MultiTB_CE_ModeA_r16;  /* T_pusch_MultiTB_CE_ModeA_r16 */
static int hf_lte_rrc_pusch_MultiTB_CE_ModeB_r16;  /* T_pusch_MultiTB_CE_ModeB_r16 */
static int hf_lte_rrc_ce_MultiTB_64QAM_r16;       /* T_ce_MultiTB_64QAM_r16 */
static int hf_lte_rrc_ce_MultiTB_EarlyTermination_r16;  /* T_ce_MultiTB_EarlyTermination_r16 */
static int hf_lte_rrc_ce_MultiTB_FrequencyHopping_r16;  /* T_ce_MultiTB_FrequencyHopping_r16 */
static int hf_lte_rrc_ce_MultiTB_HARQ_AckBundling_r16;  /* T_ce_MultiTB_HARQ_AckBundling_r16 */
static int hf_lte_rrc_ce_MultiTB_Interleaving_r16;  /* T_ce_MultiTB_Interleaving_r16 */
static int hf_lte_rrc_ce_MultiTB_SubPRB_r16;      /* T_ce_MultiTB_SubPRB_r16 */
static int hf_lte_rrc_subframeResourceResvDL_CE_ModeA_r16;  /* T_subframeResourceResvDL_CE_ModeA_r16 */
static int hf_lte_rrc_subframeResourceResvDL_CE_ModeB_r16;  /* T_subframeResourceResvDL_CE_ModeB_r16 */
static int hf_lte_rrc_subframeResourceResvUL_CE_ModeA_r16;  /* T_subframeResourceResvUL_CE_ModeA_r16 */
static int hf_lte_rrc_subframeResourceResvUL_CE_ModeB_r16;  /* T_subframeResourceResvUL_CE_ModeB_r16 */
static int hf_lte_rrc_slotSymbolResourceResvDL_CE_ModeA_r16;  /* T_slotSymbolResourceResvDL_CE_ModeA_r16 */
static int hf_lte_rrc_slotSymbolResourceResvDL_CE_ModeB_r16;  /* T_slotSymbolResourceResvDL_CE_ModeB_r16 */
static int hf_lte_rrc_slotSymbolResourceResvUL_CE_ModeA_r16;  /* T_slotSymbolResourceResvUL_CE_ModeA_r16 */
static int hf_lte_rrc_slotSymbolResourceResvUL_CE_ModeB_r16;  /* T_slotSymbolResourceResvUL_CE_ModeB_r16 */
static int hf_lte_rrc_subcarrierPuncturingCE_ModeA_r16;  /* T_subcarrierPuncturingCE_ModeA_r16 */
static int hf_lte_rrc_subcarrierPuncturingCE_ModeB_r16;  /* T_subcarrierPuncturingCE_ModeB_r16 */
static int hf_lte_rrc_crossCarrierSchedulingLAA_DL_r13;  /* T_crossCarrierSchedulingLAA_DL_r13 */
static int hf_lte_rrc_csi_RS_DRS_RRM_MeasurementsLAA_r13;  /* T_csi_RS_DRS_RRM_MeasurementsLAA_r13 */
static int hf_lte_rrc_downlinkLAA_r13;            /* T_downlinkLAA_r13 */
static int hf_lte_rrc_endingDwPTS_r13;            /* T_endingDwPTS_r13 */
static int hf_lte_rrc_secondSlotStartingPosition_r13;  /* T_secondSlotStartingPosition_r13 */
static int hf_lte_rrc_tm9_LAA_r13;                /* T_tm9_LAA_r13 */
static int hf_lte_rrc_tm10_LAA_r13;               /* T_tm10_LAA_r13 */
static int hf_lte_rrc_crossCarrierSchedulingLAA_UL_r14;  /* T_crossCarrierSchedulingLAA_UL_r14 */
static int hf_lte_rrc_uplinkLAA_r14;              /* T_uplinkLAA_r14 */
static int hf_lte_rrc_twoStepSchedulingTimingInfo_r14;  /* T_twoStepSchedulingTimingInfo_r14 */
static int hf_lte_rrc_uss_BlindDecodingAdjustment_r14;  /* T_uss_BlindDecodingAdjustment_r14 */
static int hf_lte_rrc_uss_BlindDecodingReduction_r14;  /* T_uss_BlindDecodingReduction_r14 */
static int hf_lte_rrc_outOfSequenceGrantHandling_r14;  /* T_outOfSequenceGrantHandling_r14 */
static int hf_lte_rrc_aul_r15;                    /* T_aul_r15 */
static int hf_lte_rrc_laa_PUSCH_Mode1_r15;        /* T_laa_PUSCH_Mode1_r15 */
static int hf_lte_rrc_laa_PUSCH_Mode2_r15;        /* T_laa_PUSCH_Mode2_r15 */
static int hf_lte_rrc_laa_PUSCH_Mode3_r15;        /* T_laa_PUSCH_Mode3_r15 */
static int hf_lte_rrc_wlan_IW_RAN_Rules_r12;      /* T_wlan_IW_RAN_Rules_r12 */
static int hf_lte_rrc_wlan_IW_ANDSF_Policies_r12;  /* T_wlan_IW_ANDSF_Policies_r12 */
static int hf_lte_rrc_lwa_r13;                    /* T_lwa_r13 */
static int hf_lte_rrc_lwa_SplitBearer_r13;        /* T_lwa_SplitBearer_r13 */
static int hf_lte_rrc_wlan_MAC_Address_r13;       /* OCTET_STRING_SIZE_6 */
static int hf_lte_rrc_lwa_BufferSize_r13;         /* T_lwa_BufferSize_r13 */
static int hf_lte_rrc_lwa_HO_WithoutWT_Change_r14;  /* T_lwa_HO_WithoutWT_Change_r14 */
static int hf_lte_rrc_lwa_UL_r14;                 /* T_lwa_UL_r14 */
static int hf_lte_rrc_wlan_PeriodicMeas_r14;      /* T_wlan_PeriodicMeas_r14 */
static int hf_lte_rrc_wlan_ReportAnyWLAN_r14;     /* T_wlan_ReportAnyWLAN_r14 */
static int hf_lte_rrc_wlan_SupportedDataRate_r14;  /* INTEGER_1_2048 */
static int hf_lte_rrc_lwa_RLC_UM_r14;             /* T_lwa_RLC_UM_r14 */
static int hf_lte_rrc_rclwi_r13;                  /* T_rclwi_r13 */
static int hf_lte_rrc_lwip_r13;                   /* T_lwip_r13 */
static int hf_lte_rrc_lwip_Aggregation_DL_r14;    /* T_lwip_Aggregation_DL_r14 */
static int hf_lte_rrc_lwip_Aggregation_UL_r14;    /* T_lwip_Aggregation_UL_r14 */
static int hf_lte_rrc_NAICS_Capability_List_r12_item;  /* NAICS_Capability_Entry_r12 */
static int hf_lte_rrc_numberOfNAICS_CapableCC_r12;  /* INTEGER_1_5 */
static int hf_lte_rrc_numberOfAggregatedPRB_r12;  /* T_numberOfAggregatedPRB_r12 */
static int hf_lte_rrc_commSimultaneousTx_r12;     /* T_commSimultaneousTx_r12 */
static int hf_lte_rrc_commSupportedBands_r12;     /* FreqBandIndicatorListEUTRA_r12 */
static int hf_lte_rrc_discSupportedBands_r12;     /* SupportedBandInfoList_r12 */
static int hf_lte_rrc_discScheduledResourceAlloc_r12;  /* T_discScheduledResourceAlloc_r12 */
static int hf_lte_rrc_disc_UE_SelectedResourceAlloc_r12;  /* T_disc_UE_SelectedResourceAlloc_r12 */
static int hf_lte_rrc_disc_SLSS_r12;              /* T_disc_SLSS_r12 */
static int hf_lte_rrc_discSupportedProc_r12;      /* T_discSupportedProc_r12 */
static int hf_lte_rrc_discSysInfoReporting_r13;   /* T_discSysInfoReporting_r13 */
static int hf_lte_rrc_commMultipleTx_r13;         /* T_commMultipleTx_r13 */
static int hf_lte_rrc_discInterFreqTx_r13;        /* T_discInterFreqTx_r13 */
static int hf_lte_rrc_discPeriodicSLSS_r13;       /* T_discPeriodicSLSS_r13 */
static int hf_lte_rrc_zoneBasedPoolSelection_r14;  /* T_zoneBasedPoolSelection_r14 */
static int hf_lte_rrc_ue_AutonomousWithFullSensing_r14;  /* T_ue_AutonomousWithFullSensing_r14 */
static int hf_lte_rrc_ue_AutonomousWithPartialSensing_r14;  /* T_ue_AutonomousWithPartialSensing_r14 */
static int hf_lte_rrc_sl_CongestionControl_r14;   /* T_sl_CongestionControl_r14 */
static int hf_lte_rrc_v2x_TxWithShortResvInterval_r14;  /* T_v2x_TxWithShortResvInterval_r14 */
static int hf_lte_rrc_v2x_numberTxRxTiming_r14;   /* INTEGER_1_16 */
static int hf_lte_rrc_v2x_nonAdjacentPSCCH_PSSCH_r14;  /* T_v2x_nonAdjacentPSCCH_PSSCH_r14 */
static int hf_lte_rrc_slss_TxRx_r14;              /* T_slss_TxRx_r14 */
static int hf_lte_rrc_v2x_SupportedBandCombinationList_r14;  /* V2X_SupportedBandCombination_r14 */
static int hf_lte_rrc_slss_SupportedTxFreq_r15;   /* T_slss_SupportedTxFreq_r15 */
static int hf_lte_rrc_sl_64QAM_Tx_r15;            /* T_sl_64QAM_Tx_r15 */
static int hf_lte_rrc_sl_TxDiversity_r15;         /* T_sl_TxDiversity_r15 */
static int hf_lte_rrc_ue_CategorySL_r15;          /* UE_CategorySL_r15 */
static int hf_lte_rrc_v2x_SupportedBandCombinationList_v1530;  /* V2X_SupportedBandCombination_v1530 */
static int hf_lte_rrc_sl_64QAM_Rx_r15;            /* T_sl_64QAM_Rx_r15 */
static int hf_lte_rrc_sl_RateMatchingTBSScaling_r15;  /* T_sl_RateMatchingTBSScaling_r15 */
static int hf_lte_rrc_sl_LowT2min_r15;            /* T_sl_LowT2min_r15 */
static int hf_lte_rrc_v2x_SensingReportingMode3_r15;  /* T_v2x_SensingReportingMode3_r15 */
static int hf_lte_rrc_sl_ParameterNR_r16;         /* T_sl_ParameterNR_r16 */
static int hf_lte_rrc_dummy_03;                   /* V2X_SupportedBandCombinationEUTRA_NR_r16 */
static int hf_lte_rrc_v2x_SupportedBandCombinationListEUTRA_NR_r16;  /* V2X_SupportedBandCombinationEUTRA_NR_v1630 */
static int hf_lte_rrc_v2x_SupportedBandCombinationListEUTRA_NR_v1710;  /* V2X_SupportedBandCombinationEUTRA_NR_v1710 */
static int hf_lte_rrc_sl_A2X_SupportedBandCombinationList_r18;  /* SL_A2X_SupportedBandCombination_r18 */
static int hf_lte_rrc_sl_A2X_Service_r18;         /* T_sl_A2X_Service_r18 */
static int hf_lte_rrc_ue_CategorySL_C_TX_r15;     /* INTEGER_1_5 */
static int hf_lte_rrc_ue_CategorySL_C_RX_r15;     /* INTEGER_1_4 */
static int hf_lte_rrc_V2X_SupportedBandCombination_r14_item;  /* V2X_BandCombinationParameters_r14 */
static int hf_lte_rrc_V2X_SupportedBandCombination_v1530_item;  /* V2X_BandCombinationParameters_v1530 */
static int hf_lte_rrc_V2X_BandCombinationParameters_r14_item;  /* V2X_BandParameters_r14 */
static int hf_lte_rrc_V2X_BandCombinationParameters_v1530_item;  /* V2X_BandParameters_v1530 */
static int hf_lte_rrc_V2X_SupportedBandCombinationEUTRA_NR_r16_item;  /* V2X_BandParametersEUTRA_NR_r16 */
static int hf_lte_rrc_V2X_SupportedBandCombinationEUTRA_NR_v1630_item;  /* V2X_BandCombinationParametersEUTRA_NR_v1630 */
static int hf_lte_rrc_V2X_SupportedBandCombinationEUTRA_NR_v1710_item;  /* V2X_BandCombinationParametersEUTRA_NR_v1710 */
static int hf_lte_rrc_bandListSidelinkEUTRA_NR_r16;  /* SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_V2X_BandParametersEUTRA_NR_r16 */
static int hf_lte_rrc_bandListSidelinkEUTRA_NR_r16_item;  /* V2X_BandParametersEUTRA_NR_r16 */
static int hf_lte_rrc_bandListSidelinkEUTRA_NR_v1630;  /* SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_V2X_BandParametersEUTRA_NR_v1630 */
static int hf_lte_rrc_bandListSidelinkEUTRA_NR_v1630_item;  /* V2X_BandParametersEUTRA_NR_v1630 */
static int hf_lte_rrc_V2X_BandCombinationParametersEUTRA_NR_v1710_item;  /* V2X_BandParametersEUTRA_NR_v1710 */
static int hf_lte_rrc_eutra_02;                   /* T_eutra */
static int hf_lte_rrc_v2x_BandParameters1_r16;    /* V2X_BandParameters_r14 */
static int hf_lte_rrc_v2x_BandParameters2_r16;    /* V2X_BandParameters_v1530 */
static int hf_lte_rrc_nr;                         /* T_nr */
static int hf_lte_rrc_v2x_BandParametersNR_r16;   /* T_v2x_BandParametersNR_r16 */
static int hf_lte_rrc_eutra_03;                   /* NULL */
static int hf_lte_rrc_nr_01;                      /* T_nr_01 */
static int hf_lte_rrc_tx_Sidelink_r16;            /* T_tx_Sidelink_r16 */
static int hf_lte_rrc_rx_Sidelink_r16;            /* T_rx_Sidelink_r16 */
static int hf_lte_rrc_v2x_BandParametersEUTRA_NR_v1710;  /* OCTET_STRING */
static int hf_lte_rrc_SL_A2X_SupportedBandCombination_r18_item;  /* SL_A2X_BandCombinationParameters_r18 */
static int hf_lte_rrc_SL_A2X_BandCombinationParameters_r18_item;  /* SL_A2X_BandParameters_r18 */
static int hf_lte_rrc_a2x_FreqBandEUTRA_r18;      /* FreqBandIndicator_r11 */
static int hf_lte_rrc_a2x_BandParametersTxSL_r18;  /* BandParametersTxA2X_r18 */
static int hf_lte_rrc_a2x_BandParametersRxSL_r18;  /* BandParametersRxA2X_r18 */
static int hf_lte_rrc_a2x_BandwidthClassTxSL_r18;  /* V2X_BandwidthClassSL_r14 */
static int hf_lte_rrc_a2x_BandwidthClassRxSL_r18;  /* V2X_BandwidthClassSL_r14 */
static int hf_lte_rrc_SupportedBandInfoList_r12_item;  /* SupportedBandInfo_r12 */
static int hf_lte_rrc_support_r12;                /* T_support_r12 */
static int hf_lte_rrc_FreqBandIndicatorListEUTRA_r12_item;  /* FreqBandIndicator_r11 */
static int hf_lte_rrc_delayBudgetReporting_r14;   /* T_delayBudgetReporting_r14 */
static int hf_lte_rrc_pusch_Enhancements_r14;     /* T_pusch_Enhancements_r14 */
static int hf_lte_rrc_recommendedBitRate_r14;     /* T_recommendedBitRate_r14 */
static int hf_lte_rrc_recommendedBitRateQuery_r14;  /* T_recommendedBitRateQuery_r14 */
static int hf_lte_rrc_recommendedBitRateMultiplier_r16;  /* T_recommendedBitRateMultiplier_r16 */
static int hf_lte_rrc_retuningInfo;               /* T_retuningInfo */
static int hf_lte_rrc_rf_RetuningTimeDL_r14;      /* T_rf_RetuningTimeDL_r14 */
static int hf_lte_rrc_rf_RetuningTimeUL_r14;      /* T_rf_RetuningTimeUL_r14 */
static int hf_lte_rrc_srs_FlexibleTiming_r14;     /* T_srs_FlexibleTiming_r14 */
static int hf_lte_rrc_srs_HARQ_ReferenceConfig_r14;  /* T_srs_HARQ_ReferenceConfig_r14 */
static int hf_lte_rrc_addSRS_CarrierSwitching_r16_01;  /* T_addSRS_CarrierSwitching_r16_01 */
static int hf_lte_rrc_measurementEnhancements_r14;  /* T_measurementEnhancements_r14 */
static int hf_lte_rrc_demodulationEnhancements_r14;  /* T_demodulationEnhancements_r14 */
static int hf_lte_rrc_prach_Enhancements_r14;     /* T_prach_Enhancements_r14 */
static int hf_lte_rrc_measurementEnhancementsSCell_r16;  /* T_measurementEnhancementsSCell_r16 */
static int hf_lte_rrc_measurementEnhancements2_r16;  /* T_measurementEnhancements2_r16 */
static int hf_lte_rrc_demodulationEnhancements2_r16;  /* T_demodulationEnhancements2_r16 */
static int hf_lte_rrc_interRAT_enhancementNR_r16;  /* T_interRAT_enhancementNR_r16 */
static int hf_lte_rrc_ue_Category_v1250;          /* INTEGER_0 */
static int hf_lte_rrc_ue_CategoryDL_v1310_01;     /* T_ue_CategoryDL_v1310_01 */
static int hf_lte_rrc_ce_ModeA_r13_01;            /* T_ce_ModeA_r13_01 */
static int hf_lte_rrc_ce_ModeB_r13_02;            /* T_ce_ModeB_r13_02 */
static int hf_lte_rrc_wakeUpSignal_r15;           /* T_wakeUpSignal_r15 */
static int hf_lte_rrc_wakeUpSignal_TDD_r15;       /* T_wakeUpSignal_TDD_r15 */
static int hf_lte_rrc_wakeUpSignalMinGap_eDRX_r15;  /* T_wakeUpSignalMinGap_eDRX_r15 */
static int hf_lte_rrc_wakeUpSignalMinGap_eDRX_TDD_r15;  /* T_wakeUpSignalMinGap_eDRX_TDD_r15 */
static int hf_lte_rrc_ue_CategoryDL_v1610;        /* T_ue_CategoryDL_v1610 */
static int hf_lte_rrc_groupWakeUpSignal_r16;      /* T_groupWakeUpSignal_r16 */
static int hf_lte_rrc_groupWakeUpSignalTDD_r16;   /* T_groupWakeUpSignalTDD_r16 */
static int hf_lte_rrc_groupWakeUpSignalAlternation_r16;  /* T_groupWakeUpSignalAlternation_r16 */
static int hf_lte_rrc_groupWakeUpSignalAlternationTDD_r16;  /* T_groupWakeUpSignalAlternationTDD_r16 */
static int hf_lte_rrc_inactiveStatePO_Determination_r17;  /* T_inactiveStatePO_Determination_r17 */
static int hf_lte_rrc_t300;                       /* T_t300 */
static int hf_lte_rrc_t301;                       /* T_t301 */
static int hf_lte_rrc_t310;                       /* T_t310 */
static int hf_lte_rrc_n310;                       /* T_n310 */
static int hf_lte_rrc_t311;                       /* T_t311 */
static int hf_lte_rrc_n311;                       /* T_n311 */
static int hf_lte_rrc_t300_v1310;                 /* T_t300_v1310 */
static int hf_lte_rrc_t301_v1310_01;              /* T_t301_v1310_01 */
static int hf_lte_rrc_t310_v1330_01;              /* T_t310_v1330_01 */
static int hf_lte_rrc_t300_r15;                   /* T_t300_r15 */
static int hf_lte_rrc_VisitedCellInfoList_r12_item;  /* VisitedCellInfo_r12 */
static int hf_lte_rrc_visitedCellId_r12;          /* T_visitedCellId_r12 */
static int hf_lte_rrc_cellGlobalId_r12;           /* CellGlobalIdEUTRA */
static int hf_lte_rrc_pci_arfcn_r12;              /* T_pci_arfcn_r12 */
static int hf_lte_rrc_timeSpent_r12;              /* INTEGER_0_4095 */
static int hf_lte_rrc_thresholdRSRP_r12;          /* T_thresholdRSRP_r12 */
static int hf_lte_rrc_thresholdRSRP_Low_r12;      /* RSRP_Range */
static int hf_lte_rrc_thresholdRSRP_High_r12;     /* RSRP_Range */
static int hf_lte_rrc_thresholdRSRQ_r12;          /* T_thresholdRSRQ_r12 */
static int hf_lte_rrc_thresholdRSRQ_Low_r12;      /* RSRQ_Range */
static int hf_lte_rrc_thresholdRSRQ_High_r12;     /* RSRQ_Range */
static int hf_lte_rrc_thresholdRSRQ_OnAllSymbolsWithWB_r12;  /* T_thresholdRSRQ_OnAllSymbolsWithWB_r12 */
static int hf_lte_rrc_thresholdRSRQ_OnAllSymbolsWithWB_Low_r12;  /* RSRQ_Range */
static int hf_lte_rrc_thresholdRSRQ_OnAllSymbolsWithWB_High_r12;  /* RSRQ_Range */
static int hf_lte_rrc_thresholdRSRQ_OnAllSymbols_r12;  /* T_thresholdRSRQ_OnAllSymbols_r12 */
static int hf_lte_rrc_thresholdRSRQ_OnAllSymbolsLow_r12;  /* RSRQ_Range */
static int hf_lte_rrc_thresholdRSRQ_OnAllSymbolsHigh_r12;  /* RSRQ_Range */
static int hf_lte_rrc_thresholdRSRQ_WB_r12;       /* T_thresholdRSRQ_WB_r12 */
static int hf_lte_rrc_thresholdRSRQ_WB_Low_r12;   /* RSRQ_Range */
static int hf_lte_rrc_thresholdRSRQ_WB_High_r12;  /* RSRQ_Range */
static int hf_lte_rrc_thresholdChannelUtilization_r12;  /* T_thresholdChannelUtilization_r12 */
static int hf_lte_rrc_thresholdChannelUtilizationLow_r12;  /* T_thresholdChannelUtilizationLow_r12 */
static int hf_lte_rrc_thresholdChannelUtilizationHigh_r12;  /* T_thresholdChannelUtilizationHigh_r12 */
static int hf_lte_rrc_thresholdBackhaul_Bandwidth_r12;  /* T_thresholdBackhaul_Bandwidth_r12 */
static int hf_lte_rrc_thresholdBackhaulDL_BandwidthLow_r12;  /* WLAN_backhaulRate_r12 */
static int hf_lte_rrc_thresholdBackhaulDL_BandwidthHigh_r12;  /* WLAN_backhaulRate_r12 */
static int hf_lte_rrc_thresholdBackhaulUL_BandwidthLow_r12;  /* WLAN_backhaulRate_r12 */
static int hf_lte_rrc_thresholdBackhaulUL_BandwidthHigh_r12;  /* WLAN_backhaulRate_r12 */
static int hf_lte_rrc_thresholdWLAN_RSSI_r12;     /* T_thresholdWLAN_RSSI_r12 */
static int hf_lte_rrc_thresholdWLAN_RSSI_Low_r12;  /* INTEGER_0_255 */
static int hf_lte_rrc_thresholdWLAN_RSSI_High_r12;  /* INTEGER_0_255 */
static int hf_lte_rrc_offloadPreferenceIndicator_r12;  /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_t_SteeringWLAN_r12;         /* T_Reselection */
static int hf_lte_rrc_notificationRepetitionCoeff_r9;  /* T_notificationRepetitionCoeff_r9 */
static int hf_lte_rrc_notificationOffset_r9;      /* INTEGER_0_10 */
static int hf_lte_rrc_notificationSF_Index_r9;    /* INTEGER_1_6 */
static int hf_lte_rrc_notificationSF_Index_v1430;  /* INTEGER_7_10 */
static int hf_lte_rrc_MBMS_ServiceList_r13_item;  /* MBMS_ServiceInfo_r13 */
static int hf_lte_rrc_tmgi_r13;                   /* TMGI_r9 */
static int hf_lte_rrc_MBSFN_AreaInfoList_r9_item;  /* MBSFN_AreaInfo_r9 */
static int hf_lte_rrc_mbsfn_AreaId_r9;            /* MBSFN_AreaId_r12 */
static int hf_lte_rrc_non_MBSFNregionLength;      /* T_non_MBSFNregionLength */
static int hf_lte_rrc_notificationIndicator_r9;   /* INTEGER_0_7 */
static int hf_lte_rrc_mcch_Config_r9;             /* T_mcch_Config_r9 */
static int hf_lte_rrc_mcch_RepetitionPeriod_r9;   /* T_mcch_RepetitionPeriod_r9 */
static int hf_lte_rrc_mcch_Offset_r9;             /* INTEGER_0_10 */
static int hf_lte_rrc_mcch_ModificationPeriod_r9;  /* T_mcch_ModificationPeriod_r9 */
static int hf_lte_rrc_sf_AllocInfo_r9;            /* BIT_STRING_SIZE_6 */
static int hf_lte_rrc_signallingMCS_r9;           /* T_signallingMCS_r9 */
static int hf_lte_rrc_mcch_Config_r14;            /* T_mcch_Config_r14 */
static int hf_lte_rrc_mcch_RepetitionPeriod_v1430;  /* T_mcch_RepetitionPeriod_v1430 */
static int hf_lte_rrc_mcch_ModificationPeriod_v1430;  /* T_mcch_ModificationPeriod_v1430 */
static int hf_lte_rrc_subcarrierSpacingMBMS_r14;  /* T_subcarrierSpacingMBMS_r14 */
static int hf_lte_rrc_MBSFN_AreaInfoList_r16_item;  /* MBSFN_AreaInfo_r16 */
static int hf_lte_rrc_mbsfn_AreaId_r16;           /* MBSFN_AreaId_r12 */
static int hf_lte_rrc_notificationIndicator_r16;  /* INTEGER_0_7 */
static int hf_lte_rrc_mcch_Config_r16;            /* T_mcch_Config_r16 */
static int hf_lte_rrc_mcch_RepetitionPeriod_r16;  /* T_mcch_RepetitionPeriod_r16 */
static int hf_lte_rrc_mcch_ModificationPeriod_r16;  /* T_mcch_ModificationPeriod_r16 */
static int hf_lte_rrc_mcch_Offset_r16;            /* INTEGER_0_10 */
static int hf_lte_rrc_sf_AllocInfo_r16;           /* BIT_STRING_SIZE_10 */
static int hf_lte_rrc_signallingMCS_r16;          /* T_signallingMCS_r16 */
static int hf_lte_rrc_subcarrierSpacingMBMS_r16;  /* T_subcarrierSpacingMBMS_r16 */
static int hf_lte_rrc_timeSeparation_r16;         /* T_timeSeparation_r16 */
static int hf_lte_rrc_MBSFN_AreaInfoList_r17_item;  /* MBSFN_AreaInfo_r17 */
static int hf_lte_rrc_mbsfn_AreaInfo_r17;         /* MBSFN_AreaInfo_r16 */
static int hf_lte_rrc_pmch_Bandwidth_r17;         /* T_pmch_Bandwidth_r17 */
static int hf_lte_rrc_radioframeAllocationPeriod;  /* T_radioframeAllocationPeriod */
static int hf_lte_rrc_radioframeAllocationOffset;  /* INTEGER_0_7 */
static int hf_lte_rrc_subframeAllocation;         /* T_subframeAllocation */
static int hf_lte_rrc_oneFrame;                   /* BIT_STRING_SIZE_6 */
static int hf_lte_rrc_fourFrames;                 /* BIT_STRING_SIZE_24 */
static int hf_lte_rrc_subframeAllocation_v1430;   /* T_subframeAllocation_v1430 */
static int hf_lte_rrc_oneFrame_v1430;             /* BIT_STRING_SIZE_2 */
static int hf_lte_rrc_fourFrames_v1430;           /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_subframeAllocation_v1610;   /* T_subframeAllocation_v1610 */
static int hf_lte_rrc_oneFrame_v1610;             /* BIT_STRING_SIZE_2 */
static int hf_lte_rrc_fourFrames_v1610;           /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_PMCH_InfoList_r9_item;      /* PMCH_Info_r9 */
static int hf_lte_rrc_PMCH_InfoListExt_r12_item;  /* PMCH_InfoExt_r12 */
static int hf_lte_rrc_pmch_Config_r9;             /* PMCH_Config_r9 */
static int hf_lte_rrc_mbms_SessionInfoList_r9;    /* MBMS_SessionInfoList_r9 */
static int hf_lte_rrc_pmch_Config_r12;            /* PMCH_Config_r12 */
static int hf_lte_rrc_mbms_SessionInfoList_r12;   /* MBMS_SessionInfoList_r9 */
static int hf_lte_rrc_MBMS_SessionInfoList_r9_item;  /* MBMS_SessionInfo_r9 */
static int hf_lte_rrc_tmgi_r9;                    /* TMGI_r9 */
static int hf_lte_rrc_sessionId_r9;               /* OCTET_STRING_SIZE_1 */
static int hf_lte_rrc_logicalChannelIdentity_r9;  /* INTEGER_0_maxSessionPerPMCH_1 */
static int hf_lte_rrc_sf_AllocEnd_r9;             /* INTEGER_0_1535 */
static int hf_lte_rrc_dataMCS_r9;                 /* INTEGER_0_28 */
static int hf_lte_rrc_mch_SchedulingPeriod_r9;    /* T_mch_SchedulingPeriod_r9 */
static int hf_lte_rrc_sf_AllocEnd_r12;            /* INTEGER_0_1535 */
static int hf_lte_rrc_dataMCS_r12;                /* T_dataMCS_r12 */
static int hf_lte_rrc_normal_r12;                 /* INTEGER_0_28 */
static int hf_lte_rrc_higerOrder_r12;             /* INTEGER_0_27 */
static int hf_lte_rrc_mch_SchedulingPeriod_r12;   /* T_mch_SchedulingPeriod_r12 */
static int hf_lte_rrc_mch_SchedulingPeriod_v1430;  /* T_mch_SchedulingPeriod_v1430 */
static int hf_lte_rrc_plmn_Id_r9;                 /* T_plmn_Id_r9 */
static int hf_lte_rrc_plmn_Index_r9;              /* INTEGER_1_maxPLMN_r11 */
static int hf_lte_rrc_explicitValue_r9;           /* PLMN_Identity */
static int hf_lte_rrc_serviceId_r9;               /* OCTET_STRING_SIZE_3 */
static int hf_lte_rrc_SC_MTCH_InfoList_r13_item;  /* SC_MTCH_Info_r13 */
static int hf_lte_rrc_mbmsSessionInfo_r13;        /* MBMSSessionInfo_r13 */
static int hf_lte_rrc_g_RNTI_r13;                 /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_sc_mtch_schedulingInfo_r13;  /* SC_MTCH_SchedulingInfo_r13 */
static int hf_lte_rrc_sc_mtch_neighbourCell_r13;  /* BIT_STRING_SIZE_maxNeighCell_SCPTM_r13 */
static int hf_lte_rrc_p_a_r13;                    /* T_p_a_r13 */
static int hf_lte_rrc_sessionId_r13;              /* OCTET_STRING_SIZE_1 */
static int hf_lte_rrc_onDurationTimerSCPTM_r13;   /* T_onDurationTimerSCPTM_r13 */
static int hf_lte_rrc_drx_InactivityTimerSCPTM_r13;  /* T_drx_InactivityTimerSCPTM_r13 */
static int hf_lte_rrc_schedulingPeriodStartOffsetSCPTM_r13;  /* T_schedulingPeriodStartOffsetSCPTM_r13 */
static int hf_lte_rrc_sf2048_02;                  /* INTEGER_0_2048 */
static int hf_lte_rrc_sf4096_01;                  /* INTEGER_0_4096 */
static int hf_lte_rrc_sf8192_01;                  /* INTEGER_0_8192 */
static int hf_lte_rrc_SC_MTCH_InfoList_BR_r14_item;  /* SC_MTCH_Info_BR_r14 */
static int hf_lte_rrc_sc_mtch_CarrierFreq_r14;    /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_mbmsSessionInfo_r14;        /* MBMSSessionInfo_r13 */
static int hf_lte_rrc_g_RNTI_r14;                 /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_sc_mtch_schedulingInfo_r14;  /* SC_MTCH_SchedulingInfo_BR_r14 */
static int hf_lte_rrc_sc_mtch_neighbourCell_r14;  /* BIT_STRING_SIZE_maxNeighCell_SCPTM_r13 */
static int hf_lte_rrc_mpdcch_Narrowband_SC_MTCH_r14;  /* INTEGER_1_maxAvailNarrowBands_r13 */
static int hf_lte_rrc_mpdcch_NumRepetition_SC_MTCH_r14;  /* T_mpdcch_NumRepetition_SC_MTCH_r14 */
static int hf_lte_rrc_mpdcch_StartSF_SC_MTCH_r14;  /* T_mpdcch_StartSF_SC_MTCH_r14 */
static int hf_lte_rrc_fdd_r14_01;                 /* T_fdd_r14_01 */
static int hf_lte_rrc_tdd_r14_01;                 /* T_tdd_r14_01 */
static int hf_lte_rrc_mpdcch_PDSCH_HoppingConfig_SC_MTCH_r14;  /* T_mpdcch_PDSCH_HoppingConfig_SC_MTCH_r14 */
static int hf_lte_rrc_mpdcch_PDSCH_CEmodeConfig_SC_MTCH_r14;  /* T_mpdcch_PDSCH_CEmodeConfig_SC_MTCH_r14 */
static int hf_lte_rrc_mpdcch_PDSCH_MaxBandwidth_SC_MTCH_r14;  /* T_mpdcch_PDSCH_MaxBandwidth_SC_MTCH_r14 */
static int hf_lte_rrc_mpdcch_Offset_SC_MTCH_r14;  /* T_mpdcch_Offset_SC_MTCH_r14 */
static int hf_lte_rrc_p_a_r14;                    /* T_p_a_r14 */
static int hf_lte_rrc_onDurationTimerSCPTM_r14_01;  /* T_onDurationTimerSCPTM_r14_01 */
static int hf_lte_rrc_drx_InactivityTimerSCPTM_r14_01;  /* T_drx_InactivityTimerSCPTM_r14_01 */
static int hf_lte_rrc_schedulingPeriodStartOffsetSCPTM_r14_01;  /* T_schedulingPeriodStartOffsetSCPTM_r14_01 */
static int hf_lte_rrc_SCPTM_NeighbourCellList_r13_item;  /* PCI_ARFCN_r13 */
static int hf_lte_rrc_carrierFreq_r13_02;         /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_SL_AnchorCarrierFreqList_V2X_r14_item;  /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_cbr_RangeCommonConfigList_r14;  /* SEQUENCE_SIZE_1_maxSL_V2X_CBRConfig_r14_OF_SL_CBR_Levels_Config_r14 */
static int hf_lte_rrc_cbr_RangeCommonConfigList_r14_item;  /* SL_CBR_Levels_Config_r14 */
static int hf_lte_rrc_sl_CBR_PSSCH_TxConfigList_r14;  /* SEQUENCE_SIZE_1_maxSL_V2X_TxConfig_r14_OF_SL_CBR_PSSCH_TxConfig_r14 */
static int hf_lte_rrc_sl_CBR_PSSCH_TxConfigList_r14_item;  /* SL_CBR_PSSCH_TxConfig_r14 */
static int hf_lte_rrc_SL_CBR_Levels_Config_r14_item;  /* SL_CBR_r14 */
static int hf_lte_rrc_cr_Limit_r14;               /* INTEGER_0_10000 */
static int hf_lte_rrc_tx_Parameters_r14;          /* SL_PSSCH_TxParameters_r14 */
static int hf_lte_rrc_SL_CBR_PPPP_TxConfigList_r14_item;  /* SL_PPPP_TxConfigIndex_r14 */
static int hf_lte_rrc_priorityThreshold_r14;      /* SL_Priority_r13 */
static int hf_lte_rrc_defaultTxConfigIndex_r14;   /* INTEGER_0_maxCBR_Level_1_r14 */
static int hf_lte_rrc_cbr_ConfigIndex_r14;        /* INTEGER_0_maxSL_V2X_CBRConfig_1_r14 */
static int hf_lte_rrc_tx_ConfigIndexList_r14;     /* SEQUENCE_SIZE_1_maxCBR_Level_r14_OF_Tx_ConfigIndex_r14 */
static int hf_lte_rrc_tx_ConfigIndexList_r14_item;  /* Tx_ConfigIndex_r14 */
static int hf_lte_rrc_SL_CBR_PPPP_TxConfigList_v1530_item;  /* SL_PPPP_TxConfigIndex_v1530 */
static int hf_lte_rrc_mcs_PSSCH_RangeList_r15;    /* SEQUENCE_SIZE_1_maxCBR_Level_r14_OF_MCS_PSSCH_Range_r15 */
static int hf_lte_rrc_mcs_PSSCH_RangeList_r15_item;  /* MCS_PSSCH_Range_r15 */
static int hf_lte_rrc_minMCS_PSSCH_r15;           /* INTEGER_0_31 */
static int hf_lte_rrc_maxMCS_PSSCH_r15;           /* INTEGER_0_31 */
static int hf_lte_rrc_SL_CBR_PPPP_TxConfigList_r15_item;  /* SL_PPPP_TxConfigIndex_r15 */
static int hf_lte_rrc_priorityThreshold_r15;      /* SL_Priority_r13 */
static int hf_lte_rrc_defaultTxConfigIndex_r15;   /* INTEGER_0_maxCBR_Level_1_r14 */
static int hf_lte_rrc_cbr_ConfigIndex_r15;        /* INTEGER_0_maxSL_V2X_CBRConfig_1_r14 */
static int hf_lte_rrc_tx_ConfigIndexList_r15;     /* SEQUENCE_SIZE_1_maxCBR_Level_r14_OF_Tx_ConfigIndex_r14 */
static int hf_lte_rrc_tx_ConfigIndexList_r15_item;  /* Tx_ConfigIndex_r14 */
static int hf_lte_rrc_commTxResources_r12;        /* T_commTxResources_r12 */
static int hf_lte_rrc_sL_CommConfig_r12_commTxResources_r12_setup;  /* T_sL_CommConfig_r12_commTxResources_r12_setup */
static int hf_lte_rrc_scheduled_r12;              /* T_scheduled_r12 */
static int hf_lte_rrc_sl_RNTI_r12;                /* C_RNTI */
static int hf_lte_rrc_mac_MainConfig_r12;         /* MAC_MainConfigSL_r12 */
static int hf_lte_rrc_sc_CommTxConfig_r12;        /* SL_CommResourcePool_r12 */
static int hf_lte_rrc_mcs_r12;                    /* INTEGER_0_28 */
static int hf_lte_rrc_ue_Selected_r12;            /* T_ue_Selected_r12 */
static int hf_lte_rrc_commTxPoolNormalDedicated_r12;  /* T_commTxPoolNormalDedicated_r12 */
static int hf_lte_rrc_poolToReleaseList_r12;      /* SL_TxPoolToReleaseList_r12 */
static int hf_lte_rrc_poolToAddModList_r12;       /* SL_CommTxPoolToAddModList_r12 */
static int hf_lte_rrc_commTxResources_v1310;      /* T_commTxResources_v1310 */
static int hf_lte_rrc_sL_CommConfig_r12_eag_1_commTxResources_v1310_setup;  /* T_sL_CommConfig_r12_eag_1_commTxResources_v1310_setup */
static int hf_lte_rrc_scheduled_v1310;            /* T_scheduled_v1310 */
static int hf_lte_rrc_logicalChGroupInfoList_r13;  /* LogicalChGroupInfoList_r13 */
static int hf_lte_rrc_multipleTx_r13;             /* BOOLEAN */
static int hf_lte_rrc_ue_Selected_v1310;          /* T_ue_Selected_v1310 */
static int hf_lte_rrc_commTxPoolNormalDedicatedExt_r13;  /* T_commTxPoolNormalDedicatedExt_r13 */
static int hf_lte_rrc_poolToReleaseListExt_r13;   /* SL_TxPoolToReleaseListExt_r13 */
static int hf_lte_rrc_poolToAddModListExt_r13;    /* SL_CommTxPoolToAddModListExt_r13 */
static int hf_lte_rrc_commTxAllowRelayDedicated_r13;  /* BOOLEAN */
static int hf_lte_rrc_LogicalChGroupInfoList_r13_item;  /* SL_PriorityList_r13 */
static int hf_lte_rrc_SL_CommTxPoolToAddModList_r12_item;  /* SL_CommTxPoolToAddMod_r12 */
static int hf_lte_rrc_SL_CommTxPoolToAddModListExt_r13_item;  /* SL_CommTxPoolToAddModExt_r13 */
static int hf_lte_rrc_poolIdentity_r12;           /* SL_TxPoolIdentity_r12 */
static int hf_lte_rrc_pool_r12;                   /* SL_CommResourcePool_r12 */
static int hf_lte_rrc_poolIdentity_v1310;         /* SL_TxPoolIdentity_v1310 */
static int hf_lte_rrc_pool_r13;                   /* SL_CommResourcePool_r12 */
static int hf_lte_rrc_periodic_BSR_TimerSL;       /* PeriodicBSR_Timer_r12 */
static int hf_lte_rrc_retx_BSR_TimerSL;           /* RetxBSR_Timer_r12 */
static int hf_lte_rrc_SL_CommTxPoolList_r12_item;  /* SL_CommResourcePool_r12 */
static int hf_lte_rrc_SL_CommTxPoolListExt_r13_item;  /* SL_CommResourcePool_r12 */
static int hf_lte_rrc_SL_CommTxPoolListV2X_r14_item;  /* SL_CommResourcePoolV2X_r14 */
static int hf_lte_rrc_SL_CommRxPoolList_r12_item;  /* SL_CommResourcePool_r12 */
static int hf_lte_rrc_SL_CommRxPoolListV2X_r14_item;  /* SL_CommResourcePoolV2X_r14 */
static int hf_lte_rrc_sc_CP_Len_r12;              /* SL_CP_Len_r12 */
static int hf_lte_rrc_sc_Period_r12;              /* SL_PeriodComm_r12 */
static int hf_lte_rrc_sc_TF_ResourceConfig_r12;   /* SL_TF_ResourceConfig_r12 */
static int hf_lte_rrc_data_CP_Len_r12;            /* SL_CP_Len_r12 */
static int hf_lte_rrc_dataHoppingConfig_r12;      /* SL_HoppingConfigComm_r12 */
static int hf_lte_rrc_ue_SelectedResourceConfig_r12;  /* T_ue_SelectedResourceConfig_r12 */
static int hf_lte_rrc_data_TF_ResourceConfig_r12;  /* SL_TF_ResourceConfig_r12 */
static int hf_lte_rrc_trpt_Subset_r12;            /* SL_TRPT_Subset_r12 */
static int hf_lte_rrc_rxParametersNCell_r12;      /* T_rxParametersNCell_r12 */
static int hf_lte_rrc_tdd_Config_r12;             /* TDD_Config */
static int hf_lte_rrc_syncConfigIndex_r12;        /* INTEGER_0_15 */
static int hf_lte_rrc_txParameters_r12;           /* T_txParameters_r12 */
static int hf_lte_rrc_sc_TxParameters_r12;        /* SL_TxParameters_r12 */
static int hf_lte_rrc_dataTxParameters_r12;       /* SL_TxParameters_r12 */
static int hf_lte_rrc_priorityList_r13;           /* SL_PriorityList_r13 */
static int hf_lte_rrc_sl_OffsetIndicator_r14;     /* SL_OffsetIndicator_r12 */
static int hf_lte_rrc_sl_Subframe_r14;            /* SubframeBitmapSL_r14 */
static int hf_lte_rrc_adjacencyPSCCH_PSSCH_r14;   /* BOOLEAN */
static int hf_lte_rrc_sizeSubchannel_r14;         /* T_sizeSubchannel_r14 */
static int hf_lte_rrc_numSubchannel_r14;          /* T_numSubchannel_r14 */
static int hf_lte_rrc_startRB_Subchannel_r14;     /* INTEGER_0_99 */
static int hf_lte_rrc_startRB_PSCCH_Pool_r14;     /* INTEGER_0_99 */
static int hf_lte_rrc_rxParametersNCell_r14;      /* T_rxParametersNCell_r14 */
static int hf_lte_rrc_tdd_Config_r14;             /* TDD_Config */
static int hf_lte_rrc_syncConfigIndex_r14;        /* INTEGER_0_15 */
static int hf_lte_rrc_dataTxParameters_r14;       /* SL_TxParameters_r12 */
static int hf_lte_rrc_zoneID_r14;                 /* INTEGER_0_7 */
static int hf_lte_rrc_threshS_RSSI_CBR_r14;       /* INTEGER_0_45 */
static int hf_lte_rrc_poolReportId_r14;           /* SL_V2X_TxPoolReportIdentity_r14 */
static int hf_lte_rrc_cbr_pssch_TxConfigList_r14;  /* SL_CBR_PPPP_TxConfigList_r14 */
static int hf_lte_rrc_resourceSelectionConfigP2X_r14;  /* SL_P2X_ResourceSelectionConfig_r14 */
static int hf_lte_rrc_syncAllowed_r14;            /* SL_SyncAllowed_r14 */
static int hf_lte_rrc_restrictResourceReservationPeriod_r14;  /* SL_RestrictResourceReservationPeriodList_r14 */
static int hf_lte_rrc_sl_MinT2ValueList_r15;      /* SL_MinT2ValueList_r15 */
static int hf_lte_rrc_cbr_pssch_TxConfigList_v1530;  /* SL_CBR_PPPP_TxConfigList_v1530 */
static int hf_lte_rrc_sl_A2X_Service_r18_01;      /* T_sl_A2X_Service_r18_01 */
static int hf_lte_rrc_SL_MinT2ValueList_r15_item;  /* SL_MinT2Value_r15 */
static int hf_lte_rrc_priorityList_r15;           /* SL_PriorityList_r13 */
static int hf_lte_rrc_minT2Value_r15;             /* INTEGER_10_20 */
static int hf_lte_rrc_pssch_TxConfigList_r14;     /* SL_PSSCH_TxConfigList_r14 */
static int hf_lte_rrc_thresPSSCH_RSRP_List_r14;   /* SL_ThresPSSCH_RSRP_List_r14 */
static int hf_lte_rrc_probResourceKeep_r14;       /* T_probResourceKeep_r14 */
static int hf_lte_rrc_p2x_SensingConfig_r14;      /* T_p2x_SensingConfig_r14 */
static int hf_lte_rrc_minNumCandidateSF_r14;      /* INTEGER_1_13 */
static int hf_lte_rrc_gapCandidateSensing_r14;    /* BIT_STRING_SIZE_10 */
static int hf_lte_rrc_sl_ReselectAfter_r14;       /* T_sl_ReselectAfter_r14 */
static int hf_lte_rrc_discTxResources_r12;        /* T_discTxResources_r12 */
static int hf_lte_rrc_sL_DiscConfig_r12_discTxResources_r12_setup;  /* T_sL_DiscConfig_r12_discTxResources_r12_setup */
static int hf_lte_rrc_scheduled_r12_01;           /* T_scheduled_r12_01 */
static int hf_lte_rrc_discTxConfig_r12;           /* SL_DiscResourcePool_r12 */
static int hf_lte_rrc_discTF_IndexList_r12;       /* SL_TF_IndexPairList_r12 */
static int hf_lte_rrc_discHoppingConfig_r12;      /* SL_HoppingConfigDisc_r12 */
static int hf_lte_rrc_ue_Selected_r12_01;         /* T_ue_Selected_r12_01 */
static int hf_lte_rrc_discTxPoolDedicated_r12;    /* T_discTxPoolDedicated_r12 */
static int hf_lte_rrc_poolToAddModList_r12_01;    /* SL_DiscTxPoolToAddModList_r12 */
static int hf_lte_rrc_discTF_IndexList_v1260;     /* T_discTF_IndexList_v1260 */
static int hf_lte_rrc_sL_DiscConfig_r12_eag_1_discTF_IndexList_v1260_setup;  /* T_sL_DiscConfig_r12_eag_1_discTF_IndexList_v1260_setup */
static int hf_lte_rrc_discTF_IndexList_r12b;      /* SL_TF_IndexPairList_r12b */
static int hf_lte_rrc_discTxResourcesPS_r13;      /* T_discTxResourcesPS_r13 */
static int hf_lte_rrc_sL_DiscConfig_r12_eag_2_discTxResourcesPS_r13_setup;  /* T_sL_DiscConfig_r12_eag_2_discTxResourcesPS_r13_setup */
static int hf_lte_rrc_scheduled_r13;              /* SL_DiscTxConfigScheduled_r13 */
static int hf_lte_rrc_ue_Selected_r13;            /* T_ue_Selected_r13 */
static int hf_lte_rrc_discTxPoolPS_Dedicated_r13;  /* SL_DiscTxPoolDedicated_r13 */
static int hf_lte_rrc_discTxInterFreqInfo_r13;    /* T_discTxInterFreqInfo_r13 */
static int hf_lte_rrc_sL_DiscConfig_r12_eag_2_discTxInterFreqInfo_r13_setup;  /* T_sL_DiscConfig_r12_eag_2_discTxInterFreqInfo_r13_setup */
static int hf_lte_rrc_discTxCarrierFreq_r13;      /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_discTxRefCarrierDedicated_r13;  /* SL_DiscTxRefCarrierDedicated_r13 */
static int hf_lte_rrc_discTxInfoInterFreqListAdd_r13;  /* SL_DiscTxInfoInterFreqListAdd_r13 */
static int hf_lte_rrc_gapRequestsAllowedDedicated_r13;  /* BOOLEAN */
static int hf_lte_rrc_discRxGapConfig_r13;        /* T_discRxGapConfig_r13 */
static int hf_lte_rrc_sL_DiscConfig_r12_eag_2_discRxGapConfig_r13_setup;  /* SL_GapConfig_r13 */
static int hf_lte_rrc_discTxGapConfig_r13;        /* T_discTxGapConfig_r13 */
static int hf_lte_rrc_sL_DiscConfig_r12_eag_2_discTxGapConfig_r13_setup;  /* SL_GapConfig_r13 */
static int hf_lte_rrc_discSysInfoToReportConfig_r13;  /* T_discSysInfoToReportConfig_r13 */
static int hf_lte_rrc_sL_DiscConfig_r12_eag_2_discSysInfoToReportConfig_r13_setup;  /* SL_DiscSysInfoToReportFreqList_r13 */
static int hf_lte_rrc_SL_DiscSysInfoToReportFreqList_r13_item;  /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_discTxFreqToAddModList_r13;  /* SEQUENCE_SIZE_1_maxFreq_OF_SL_DiscTxResourceInfoPerFreq_r13 */
static int hf_lte_rrc_discTxFreqToAddModList_r13_item;  /* SL_DiscTxResourceInfoPerFreq_r13 */
static int hf_lte_rrc_discTxFreqToReleaseList_r13;  /* SEQUENCE_SIZE_1_maxFreq_OF_ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_discTxFreqToReleaseList_r13_item;  /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_discTxResources_r13;        /* SL_DiscTxResource_r13 */
static int hf_lte_rrc_discTxResourcesPS_r13_01;   /* SL_DiscTxResource_r13 */
static int hf_lte_rrc_sL_DiscTxResource_r13_setup;  /* T_sL_DiscTxResource_r13_setup */
static int hf_lte_rrc_ue_Selected_r13_01;         /* SL_DiscTxPoolDedicated_r13 */
static int hf_lte_rrc_SL_DiscTxPoolToAddModList_r12_item;  /* SL_DiscTxPoolToAddMod_r12 */
static int hf_lte_rrc_pool_r12_01;                /* SL_DiscResourcePool_r12 */
static int hf_lte_rrc_discTxConfig_r13;           /* SL_DiscResourcePool_r12 */
static int hf_lte_rrc_discTF_IndexList_r13;       /* SL_TF_IndexPairList_r12b */
static int hf_lte_rrc_discHoppingConfig_r13;      /* SL_HoppingConfigDisc_r12 */
static int hf_lte_rrc_poolToReleaseList_r13;      /* SL_TxPoolToReleaseList_r12 */
static int hf_lte_rrc_poolToAddModList_r13;       /* SL_DiscTxPoolToAddModList_r12 */
static int hf_lte_rrc_SL_TF_IndexPairList_r12_item;  /* SL_TF_IndexPair_r12 */
static int hf_lte_rrc_discSF_Index_r12;           /* INTEGER_1_200 */
static int hf_lte_rrc_discPRB_Index_r12;          /* INTEGER_1_50 */
static int hf_lte_rrc_SL_TF_IndexPairList_r12b_item;  /* SL_TF_IndexPair_r12b */
static int hf_lte_rrc_discSF_Index_r12b;          /* INTEGER_0_209 */
static int hf_lte_rrc_discPRB_Index_r12b;         /* INTEGER_0_49 */
static int hf_lte_rrc_pCell;                      /* NULL */
static int hf_lte_rrc_sCell;                      /* SCellIndex_r10 */
static int hf_lte_rrc_SL_DiscTxPoolList_r12_item;  /* SL_DiscResourcePool_r12 */
static int hf_lte_rrc_SL_DiscRxPoolList_r12_item;  /* SL_DiscResourcePool_r12 */
static int hf_lte_rrc_cp_Len_r12;                 /* SL_CP_Len_r12 */
static int hf_lte_rrc_discPeriod_r12;             /* T_discPeriod_r12 */
static int hf_lte_rrc_numRetx_r12;                /* INTEGER_0_3 */
static int hf_lte_rrc_numRepetition_r12;          /* INTEGER_1_50 */
static int hf_lte_rrc_tf_ResourceConfig_r12;      /* SL_TF_ResourceConfig_r12 */
static int hf_lte_rrc_txParameters_r12_01;        /* T_txParameters_r12_01 */
static int hf_lte_rrc_txParametersGeneral_r12;    /* SL_TxParameters_r12 */
static int hf_lte_rrc_ue_SelectedResourceConfig_r12_01;  /* T_ue_SelectedResourceConfig_r12_01 */
static int hf_lte_rrc_poolSelection_r12;          /* T_poolSelection_r12 */
static int hf_lte_rrc_rsrpBased_r12;              /* SL_PoolSelectionConfig_r12 */
static int hf_lte_rrc_random_r12;                 /* NULL */
static int hf_lte_rrc_txProbability_r12;          /* T_txProbability_r12 */
static int hf_lte_rrc_rxParameters_r12;           /* T_rxParameters_r12 */
static int hf_lte_rrc_discPeriod_v1310;           /* T_discPeriod_v1310 */
static int hf_lte_rrc_sL_DiscResourcePool_r12_eag_1_discPeriod_v1310_setup;  /* T_sL_DiscResourcePool_r12_eag_1_discPeriod_v1310_setup */
static int hf_lte_rrc_rxParamsAddNeighFreq_r13;   /* T_rxParamsAddNeighFreq_r13 */
static int hf_lte_rrc_sL_DiscResourcePool_r12_eag_1_rxParamsAddNeighFreq_r13_setup;  /* T_sL_DiscResourcePool_r12_eag_1_rxParamsAddNeighFreq_r13_setup */
static int hf_lte_rrc_physCellId_r13_01;          /* PhysCellIdList_r13 */
static int hf_lte_rrc_txParamsAddNeighFreq_r13;   /* T_txParamsAddNeighFreq_r13 */
static int hf_lte_rrc_sL_DiscResourcePool_r12_eag_1_txParamsAddNeighFreq_r13_setup;  /* T_sL_DiscResourcePool_r12_eag_1_txParamsAddNeighFreq_r13_setup */
static int hf_lte_rrc_tdd_Config_r13;             /* TDD_Config */
static int hf_lte_rrc_freqInfo_01;                /* T_freqInfo_01 */
static int hf_lte_rrc_ul_Bandwidth_02;            /* T_ul_Bandwidth_02 */
static int hf_lte_rrc_syncConfigIndex_r13;        /* INTEGER_0_15 */
static int hf_lte_rrc_txParamsAddNeighFreq_v1370;  /* T_txParamsAddNeighFreq_v1370 */
static int hf_lte_rrc_sL_DiscResourcePool_r12_eag_2_txParamsAddNeighFreq_v1370_setup;  /* T_sL_DiscResourcePool_r12_eag_2_txParamsAddNeighFreq_v1370_setup */
static int hf_lte_rrc_freqInfo_v1370;             /* T_freqInfo_v1370 */
static int hf_lte_rrc_additionalSpectrumEmission_v1370;  /* AdditionalSpectrumEmission_v10l0 */
static int hf_lte_rrc_PhysCellIdList_r13_item;    /* PhysCellId */
static int hf_lte_rrc_threshLow_r12;              /* RSRP_RangeSL2_r12 */
static int hf_lte_rrc_threshHigh_r12;             /* RSRP_RangeSL2_r12 */
static int hf_lte_rrc_plmn_IdentityList_r13;      /* PLMN_IdentityList */
static int hf_lte_rrc_cellIdentity_13;            /* CellIdentity */
static int hf_lte_rrc_carrierFreqInfo_13;         /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_discRxResources_r13;        /* SL_DiscRxPoolList_r12 */
static int hf_lte_rrc_discTxPowerInfo_r13;        /* SL_DiscTxPowerInfoList_r12 */
static int hf_lte_rrc_discSyncConfig_r13_01;      /* SL_SyncConfigNFreq_r13 */
static int hf_lte_rrc_discCellSelectionInfo_r13_01;  /* T_discCellSelectionInfo_r13 */
static int hf_lte_rrc_q_RxLevMinOffset_r13;       /* INTEGER_1_8 */
static int hf_lte_rrc_cellReselectionInfo_r13;    /* T_cellReselectionInfo_r13 */
static int hf_lte_rrc_q_Hyst_r13_01;              /* T_q_Hyst_r13_01 */
static int hf_lte_rrc_freqInfo_r13;               /* T_freqInfo_r13 */
static int hf_lte_rrc_ul_CarrierFreq_r13;         /* ARFCN_ValueEUTRA */
static int hf_lte_rrc_ul_Bandwidth_r13;           /* T_ul_Bandwidth_r13 */
static int hf_lte_rrc_additionalSpectrumEmission_r13;  /* AdditionalSpectrumEmission */
static int hf_lte_rrc_p_Max_r13;                  /* P_Max */
static int hf_lte_rrc_referenceSignalPower_r13;   /* INTEGER_M60_50 */
static int hf_lte_rrc_freqInfo_v1370_01;          /* T_freqInfo_v1370_01 */
static int hf_lte_rrc_SL_DiscTxPowerInfoList_r12_item;  /* SL_DiscTxPowerInfo_r12 */
static int hf_lte_rrc_discMaxTxPower_r12;         /* P_Max */
static int hf_lte_rrc_gapPatternList_r13;         /* SL_GapPatternList_r13 */
static int hf_lte_rrc_SL_GapPatternList_r13_item;  /* SL_GapPattern_r13 */
static int hf_lte_rrc_gapPeriod_r13;              /* T_gapPeriod_r13 */
static int hf_lte_rrc_gapOffset_r12;              /* SL_OffsetIndicator_r12 */
static int hf_lte_rrc_gapSubframeBitmap_r13;      /* BIT_STRING_SIZE_1_10240 */
static int hf_lte_rrc_SL_GapRequest_r13_item;     /* SL_GapFreqInfo_r13 */
static int hf_lte_rrc_hoppingParameter_r12;       /* INTEGER_0_504 */
static int hf_lte_rrc_numSubbands_r12;            /* T_numSubbands_r12 */
static int hf_lte_rrc_rb_Offset_r12;              /* INTEGER_0_110 */
static int hf_lte_rrc_a_r12;                      /* INTEGER_1_200 */
static int hf_lte_rrc_b_r12;                      /* INTEGER_1_10 */
static int hf_lte_rrc_c_r12;                      /* T_c_r12 */
static int hf_lte_rrc_SL_InterFreqInfoListV2X_r14_item;  /* SL_InterFreqInfoV2X_r14 */
static int hf_lte_rrc_v2x_CommCarrierFreq_r14;    /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_sl_MaxTxPower_r14;          /* P_Max */
static int hf_lte_rrc_sl_Bandwidth_r14;           /* T_sl_Bandwidth_r14 */
static int hf_lte_rrc_v2x_SchedulingPool_r14;     /* SL_CommResourcePoolV2X_r14 */
static int hf_lte_rrc_v2x_UE_ConfigList_r14;      /* SL_V2X_UE_ConfigList_r14 */
static int hf_lte_rrc_additionalSpectrumEmissionV2X_r14;  /* T_additionalSpectrumEmissionV2X_r14 */
static int hf_lte_rrc_additionalSpectrumEmission_r14;  /* AdditionalSpectrumEmission */
static int hf_lte_rrc_additionalSpectrumEmission_v1440;  /* AdditionalSpectrumEmission_v10l0 */
static int hf_lte_rrc_SL_NR_AnchorCarrierFreqList_r16_item;  /* ARFCN_ValueNR_r15 */
static int hf_lte_rrc_SL_V2X_UE_ConfigList_r14_item;  /* SL_V2X_InterFreqUE_Config_r14 */
static int hf_lte_rrc_physCellIdList_r14;         /* PhysCellIdList_r13 */
static int hf_lte_rrc_v2x_SyncConfig_r14_01;      /* SL_SyncConfigListNFreqV2X_r14 */
static int hf_lte_rrc_v2x_CommTxPoolNormal_r14;   /* SL_CommTxPoolListV2X_r14 */
static int hf_lte_rrc_p2x_CommTxPoolNormal_r14;   /* SL_CommTxPoolListV2X_r14 */
static int hf_lte_rrc_small_r12;                  /* INTEGER_0_319 */
static int hf_lte_rrc_large_r12;                  /* INTEGER_0_10239 */
static int hf_lte_rrc_partialSensing_r14;         /* T_partialSensing_r14 */
static int hf_lte_rrc_randomSelection_r14;        /* T_randomSelection_r14 */
static int hf_lte_rrc_SL_PriorityList_r13_item;   /* SL_Priority_r13 */
static int hf_lte_rrc_SL_PSSCH_TxConfigList_r14_item;  /* SL_PSSCH_TxConfig_r14 */
static int hf_lte_rrc_thresUE_Speed_r14;          /* T_thresUE_Speed_r14 */
static int hf_lte_rrc_parametersAboveThres_r14;   /* SL_PSSCH_TxParameters_r14 */
static int hf_lte_rrc_parametersBelowThres_r14;   /* SL_PSSCH_TxParameters_r14 */
static int hf_lte_rrc_parametersAboveThres_v1530;  /* SL_PSSCH_TxParameters_v1530 */
static int hf_lte_rrc_parametersBelowThres_v1530;  /* SL_PSSCH_TxParameters_v1530 */
static int hf_lte_rrc_minMCS_PSSCH_r14;           /* INTEGER_0_31 */
static int hf_lte_rrc_maxMCS_PSSCH_r14;           /* INTEGER_0_31 */
static int hf_lte_rrc_minSubChannel_NumberPSSCH_r14;  /* INTEGER_1_20 */
static int hf_lte_rrc_maxSubchannel_NumberPSSCH_r14;  /* INTEGER_1_20 */
static int hf_lte_rrc_allowedRetxNumberPSSCH_r14;  /* T_allowedRetxNumberPSSCH_r14 */
static int hf_lte_rrc_maxTxPower_r14;             /* SL_TxPower_r14 */
static int hf_lte_rrc_SL_ReliabilityList_r15_item;  /* SL_Reliability_r15 */
static int hf_lte_rrc_SL_RestrictResourceReservationPeriodList_r14_item;  /* SL_RestrictResourceReservationPeriod_r14 */
static int hf_lte_rrc_gnss_Sync_r14;              /* T_gnss_Sync_r14 */
static int hf_lte_rrc_enb_Sync_r14;               /* T_enb_Sync_r14 */
static int hf_lte_rrc_ue_Sync_r14;                /* T_ue_Sync_r14 */
static int hf_lte_rrc_SL_SyncConfigList_r12_item;  /* SL_SyncConfig_r12 */
static int hf_lte_rrc_SL_SyncConfigListV2X_r14_item;  /* SL_SyncConfig_r12 */
static int hf_lte_rrc_syncCP_Len_r12;             /* SL_CP_Len_r12 */
static int hf_lte_rrc_syncOffsetIndicator_r12;    /* SL_OffsetIndicatorSync_r12 */
static int hf_lte_rrc_slssid_r12;                 /* SLSSID_r12 */
static int hf_lte_rrc_txParameters_r12_02;        /* T_txParameters_r12_02 */
static int hf_lte_rrc_syncTxParameters_r12;       /* SL_TxParameters_r12 */
static int hf_lte_rrc_syncTxThreshIC_r12;         /* RSRP_RangeSL_r12 */
static int hf_lte_rrc_syncInfoReserved_r12;       /* BIT_STRING_SIZE_19 */
static int hf_lte_rrc_rxParamsNCell_r12;          /* T_rxParamsNCell_r12 */
static int hf_lte_rrc_discSyncWindow_r12;         /* T_discSyncWindow_r12 */
static int hf_lte_rrc_syncTxPeriodic_r13;         /* T_syncTxPeriodic_r13 */
static int hf_lte_rrc_syncOffsetIndicator_v1430;  /* SL_OffsetIndicatorSync_v1430 */
static int hf_lte_rrc_gnss_Sync_r14_01;           /* T_gnss_Sync_r14_01 */
static int hf_lte_rrc_syncOffsetIndicator2_r14;   /* SL_OffsetIndicatorSync_r14 */
static int hf_lte_rrc_syncOffsetIndicator3_r14;   /* SL_OffsetIndicatorSync_r14 */
static int hf_lte_rrc_slss_TxDisabled_r15;        /* T_slss_TxDisabled_r15 */
static int hf_lte_rrc_SL_SyncConfigListNFreq_r13_item;  /* SL_SyncConfigNFreq_r13 */
static int hf_lte_rrc_SL_SyncConfigListNFreqV2X_r14_item;  /* SL_SyncConfigNFreq_r13 */
static int hf_lte_rrc_asyncParameters_r13;        /* T_asyncParameters_r13 */
static int hf_lte_rrc_syncCP_Len_r13;             /* SL_CP_Len_r12 */
static int hf_lte_rrc_syncOffsetIndicator_r13;    /* SL_OffsetIndicatorSync_r12 */
static int hf_lte_rrc_slssid_r13;                 /* SLSSID_r12 */
static int hf_lte_rrc_txParameters_r13;           /* T_txParameters_r13 */
static int hf_lte_rrc_syncTxParameters_r13;       /* SL_TxParameters_r12 */
static int hf_lte_rrc_syncTxThreshIC_r13;         /* RSRP_RangeSL_r12 */
static int hf_lte_rrc_syncInfoReserved_r13;       /* BIT_STRING_SIZE_19 */
static int hf_lte_rrc_syncTxPeriodic_r13_01;      /* T_syncTxPeriodic_r13_01 */
static int hf_lte_rrc_rxParameters_r13;           /* T_rxParameters_r13 */
static int hf_lte_rrc_discSyncWindow_r13;         /* T_discSyncWindow_r13 */
static int hf_lte_rrc_gnss_Sync_r14_02;           /* T_gnss_Sync_r14_02 */
static int hf_lte_rrc_slss_TxDisabled_r15_01;     /* T_slss_TxDisabled_r15_01 */
static int hf_lte_rrc_prb_Num_r12;                /* INTEGER_1_100 */
static int hf_lte_rrc_prb_Start_r12;              /* INTEGER_0_99 */
static int hf_lte_rrc_prb_End_r12;                /* INTEGER_0_99 */
static int hf_lte_rrc_offsetIndicator_r12;        /* SL_OffsetIndicator_r12 */
static int hf_lte_rrc_subframeBitmap_r12;         /* SubframeBitmapSL_r12 */
static int hf_lte_rrc_bs4_r12;                    /* BIT_STRING_SIZE_4 */
static int hf_lte_rrc_bs8_r12;                    /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_bs12_r12;                   /* BIT_STRING_SIZE_12 */
static int hf_lte_rrc_bs16_r12;                   /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_bs30_r12;                   /* BIT_STRING_SIZE_30 */
static int hf_lte_rrc_bs40_r12;                   /* BIT_STRING_SIZE_40 */
static int hf_lte_rrc_bs42_r12;                   /* BIT_STRING_SIZE_42 */
static int hf_lte_rrc_bs10_r14;                   /* BIT_STRING_SIZE_10 */
static int hf_lte_rrc_bs16_r14;                   /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_bs20_r14;                   /* BIT_STRING_SIZE_20 */
static int hf_lte_rrc_bs30_r14;                   /* BIT_STRING_SIZE_30 */
static int hf_lte_rrc_bs40_r14;                   /* BIT_STRING_SIZE_40 */
static int hf_lte_rrc_bs50_r14;                   /* BIT_STRING_SIZE_50 */
static int hf_lte_rrc_bs60_r14;                   /* BIT_STRING_SIZE_60 */
static int hf_lte_rrc_bs100_r14;                  /* BIT_STRING_SIZE_100 */
static int hf_lte_rrc_minusinfinity_r14;          /* NULL */
static int hf_lte_rrc_txPower_r14;                /* INTEGER_M41_31 */
static int hf_lte_rrc_SL_ThresPSSCH_RSRP_List_r14_item;  /* SL_ThresPSSCH_RSRP_r14 */
static int hf_lte_rrc_alpha_r12;                  /* Alpha_r12 */
static int hf_lte_rrc_p0_r12;                     /* P0_SL_r12 */
static int hf_lte_rrc_SL_TxPoolToReleaseList_r12_item;  /* SL_TxPoolIdentity_r12 */
static int hf_lte_rrc_SL_TxPoolToReleaseListExt_r13_item;  /* SL_TxPoolIdentity_v1310 */
static int hf_lte_rrc_commTxResources_r14;        /* T_commTxResources_r14 */
static int hf_lte_rrc_sL_V2X_ConfigDedicated_r14_commTxResources_r14_setup;  /* T_sL_V2X_ConfigDedicated_r14_commTxResources_r14_setup */
static int hf_lte_rrc_scheduled_r14;              /* T_scheduled_r14 */
static int hf_lte_rrc_sl_V_RNTI_r14;              /* C_RNTI */
static int hf_lte_rrc_mac_MainConfig_r14;         /* MAC_MainConfigSL_r12 */
static int hf_lte_rrc_mcs_r14;                    /* INTEGER_0_31 */
static int hf_lte_rrc_logicalChGroupInfoList_r14;  /* LogicalChGroupInfoList_r13 */
static int hf_lte_rrc_ue_Selected_r14;            /* T_ue_Selected_r14 */
static int hf_lte_rrc_v2x_CommTxPoolNormalDedicated_r14;  /* T_v2x_CommTxPoolNormalDedicated_r14 */
static int hf_lte_rrc_poolToReleaseList_r14;      /* SL_TxPoolToReleaseListV2X_r14 */
static int hf_lte_rrc_poolToAddModList_r14;       /* SL_TxPoolToAddModListV2X_r14 */
static int hf_lte_rrc_v2x_CommTxPoolSensingConfig_r14;  /* SL_CommTxPoolSensingConfig_r14 */
static int hf_lte_rrc_cbr_DedicatedTxConfigList_r14;  /* SL_CBR_CommonTxConfigList_r14 */
static int hf_lte_rrc_commTxResources_v1530;      /* T_commTxResources_v1530 */
static int hf_lte_rrc_sL_V2X_ConfigDedicated_r14_eag_1_commTxResources_v1530_setup;  /* T_sL_V2X_ConfigDedicated_r14_eag_1_commTxResources_v1530_setup */
static int hf_lte_rrc_scheduled_v1530;            /* T_scheduled_v1530 */
static int hf_lte_rrc_logicalChGroupInfoList_v1530;  /* LogicalChGroupInfoList_v1530 */
static int hf_lte_rrc_mcs_r15;                    /* INTEGER_0_31 */
static int hf_lte_rrc_ue_Selected_v1530;          /* T_ue_Selected_v1530 */
static int hf_lte_rrc_slss_TxMultiFreq_r15_01;    /* T_slss_TxMultiFreq_r15_01 */
static int hf_lte_rrc_slss_TxDisabled_r15_02;     /* T_slss_TxDisabled_r15_02 */
static int hf_lte_rrc_LogicalChGroupInfoList_v1530_item;  /* SL_ReliabilityList_r15 */
static int hf_lte_rrc_SL_TxPoolToAddModListV2X_r14_item;  /* SL_TxPoolToAddMod_r14 */
static int hf_lte_rrc_poolIdentity_r14_01;        /* SL_V2X_TxPoolIdentity_r14 */
static int hf_lte_rrc_pool_r14;                   /* SL_CommResourcePoolV2X_r14 */
static int hf_lte_rrc_SL_TxPoolToReleaseListV2X_r14_item;  /* SL_V2X_TxPoolIdentity_r14 */
static int hf_lte_rrc_SL_V2X_FreqSelectionConfigList_r15_item;  /* SL_V2X_FreqSelectionConfig_r15 */
static int hf_lte_rrc_threshCBR_FreqReselection_r15;  /* SL_CBR_r14 */
static int hf_lte_rrc_threshCBR_FreqKeeping_r15;  /* SL_CBR_r14 */
static int hf_lte_rrc_threshSL_Reliability_r15;   /* SL_Reliability_r15 */
static int hf_lte_rrc_allowedCarrierFreqConfig_r15;  /* SL_PPPR_Dest_CarrierFreqList_r15 */
static int hf_lte_rrc_SL_PPPR_Dest_CarrierFreqList_r15_item;  /* SL_PPPR_Dest_CarrierFreq */
static int hf_lte_rrc_destinationInfoList_r15;    /* SL_DestinationInfoList_r12 */
static int hf_lte_rrc_allowedCarrierFreqList_r15;  /* SL_AllowedCarrierFreqList_r15 */
static int hf_lte_rrc_allowedCarrierFreqSet1;     /* SEQUENCE_SIZE_1_maxFreqV2X_r14_OF_ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_allowedCarrierFreqSet1_item;  /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_allowedCarrierFreqSet2;     /* SEQUENCE_SIZE_1_maxFreqV2X_r14_OF_ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_allowedCarrierFreqSet2_item;  /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_SL_V2X_SyncFreqList_r15_item;  /* ARFCN_ValueEUTRA_r9 */
static int hf_lte_rrc_zoneLength_r14;             /* T_zoneLength_r14 */
static int hf_lte_rrc_zoneWidth_r14;              /* T_zoneWidth_r14 */
static int hf_lte_rrc_zoneIdLongiMod_r14;         /* INTEGER_1_4 */
static int hf_lte_rrc_zoneIdLatiMod_r14;          /* INTEGER_1_4 */
static int hf_lte_rrc_sBCCH_SL_BCH_Message_message;  /* SBCCH_SL_BCH_MessageType */
static int hf_lte_rrc_sBCCH_SL_BCH_Message_V2X_r14_message;  /* SBCCH_SL_BCH_MessageType_V2X_r14 */
static int hf_lte_rrc_sl_Bandwidth_r12;           /* T_sl_Bandwidth_r12 */
static int hf_lte_rrc_tdd_ConfigSL_r12;           /* TDD_ConfigSL_r12 */
static int hf_lte_rrc_directFrameNumber_r12;      /* BIT_STRING_SIZE_10 */
static int hf_lte_rrc_directSubframeNumber_r12;   /* INTEGER_0_9 */
static int hf_lte_rrc_inCoverage_r12;             /* BOOLEAN */
static int hf_lte_rrc_reserved_r12;               /* BIT_STRING_SIZE_19 */
static int hf_lte_rrc_sl_Bandwidth_r14_01;        /* T_sl_Bandwidth_r14_01 */
static int hf_lte_rrc_tdd_ConfigSL_r14;           /* TDD_ConfigSL_r12 */
static int hf_lte_rrc_directFrameNumber_r14;      /* BIT_STRING_SIZE_10 */
static int hf_lte_rrc_directSubframeNumber_r14;   /* INTEGER_0_9 */
static int hf_lte_rrc_inCoverage_r14;             /* BOOLEAN */
static int hf_lte_rrc_reserved_r14;               /* BIT_STRING_SIZE_27 */
static int hf_lte_rrc_criticalExtensions_62;      /* T_criticalExtensions_62 */
static int hf_lte_rrc_c1_51;                      /* T_c1_51 */
static int hf_lte_rrc_handoverPreparationInformation_r13;  /* HandoverPreparationInformation_NB_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_60;  /* T_criticalExtensionsFuture_60 */
static int hf_lte_rrc_ue_RadioAccessCapabilityInfo_r13;  /* UE_Capability_NB_r13 */
static int hf_lte_rrc_as_Config_r13;              /* AS_Config_NB */
static int hf_lte_rrc_rrm_Config_r13;             /* RRM_Config_NB */
static int hf_lte_rrc_as_Context_r13;             /* AS_Context_NB */
static int hf_lte_rrc_nonCriticalExtension_369;   /* HandoverPreparationInformation_NB_v1380_IEs */
static int hf_lte_rrc_nonCriticalExtension_370;   /* HandoverPreparationInformation_NB_Ext_r14_IEs */
static int hf_lte_rrc_ue_RadioAccessCapabilityInfoExt_r14;  /* T_ue_RadioAccessCapabilityInfoExt_r14 */
static int hf_lte_rrc_nonCriticalExtension_371;   /* T_nonCriticalExtension_85 */
static int hf_lte_rrc_criticalExtensions_63;      /* T_criticalExtensions_63 */
static int hf_lte_rrc_c1_52;                      /* T_c1_52 */
static int hf_lte_rrc_uePagingCoverageInformation_r13_01;  /* UEPagingCoverageInformation_NB_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_61;  /* T_criticalExtensionsFuture_61 */
static int hf_lte_rrc_npdcch_NumRepetitionPaging_r13;  /* INTEGER_1_2048 */
static int hf_lte_rrc_nonCriticalExtension_372;   /* UEPagingCoverageInformation_NB_v1700_IEs */
static int hf_lte_rrc_cbp_Index_r17;              /* INTEGER_1_2 */
static int hf_lte_rrc_nonCriticalExtension_373;   /* T_nonCriticalExtension_86 */
static int hf_lte_rrc_criticalExtensions_64;      /* T_criticalExtensions_64 */
static int hf_lte_rrc_c1_53;                      /* T_c1_53 */
static int hf_lte_rrc_ueRadioAccessCapabilityInformation_r13;  /* UERadioAccessCapabilityInformation_NB_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_62;  /* T_criticalExtensionsFuture_62 */
static int hf_lte_rrc_ue_RadioAccessCapabilityInfo_r13_01;  /* T_ue_RadioAccessCapabilityInfo_r13 */
static int hf_lte_rrc_nonCriticalExtension_374;   /* UERadioAccessCapabilityInformation_NB_v1380_IEs */
static int hf_lte_rrc_nonCriticalExtension_375;   /* UERadioAccessCapabilityInformation_NB_r14_IEs */
static int hf_lte_rrc_ue_RadioAccessCapabilityInfo_r14;  /* T_ue_RadioAccessCapabilityInfo_r14 */
static int hf_lte_rrc_nonCriticalExtension_376;   /* T_nonCriticalExtension_87 */
static int hf_lte_rrc_criticalExtensions_65;      /* T_criticalExtensions_65 */
static int hf_lte_rrc_c1_54;                      /* T_c1_54 */
static int hf_lte_rrc_ueRadioPagingInformation_r13;  /* UERadioPagingInformation_NB_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_63;  /* T_criticalExtensionsFuture_63 */
static int hf_lte_rrc_ue_RadioPagingInfo_r13;     /* T_ue_RadioPagingInfo_r13 */
static int hf_lte_rrc_nonCriticalExtension_377;   /* T_nonCriticalExtension_88 */
static int hf_lte_rrc_sourceRadioResourceConfig_r13;  /* RadioResourceConfigDedicated_NB_r13 */
static int hf_lte_rrc_sourceSecurityAlgorithmConfig_r13;  /* SecurityAlgorithmConfig */
static int hf_lte_rrc_sourceUE_Identity_r13;      /* C_RNTI */
static int hf_lte_rrc_sourceDl_CarrierFreq_r13;   /* CarrierFreq_NB_r13 */
static int hf_lte_rrc_sourceDL_CarrierFreq_v1550;  /* CarrierFreq_NB_v1550 */
static int hf_lte_rrc_reestablishmentInfo_r13;    /* ReestablishmentInfo_NB */
static int hf_lte_rrc_sourcePhysCellId_r13;       /* PhysCellId */
static int hf_lte_rrc_targetCellShortMAC_I_r13;   /* ShortMAC_I */
static int hf_lte_rrc_additionalReestabInfoList_r13;  /* AdditionalReestabInfoList */
static int hf_lte_rrc_ue_InactiveTime_01;         /* T_ue_InactiveTime_01 */
static int hf_lte_rrc_bCCH_BCH_Message_NB_message;  /* BCCH_BCH_MessageType_NB */
static int hf_lte_rrc_bCCH_BCH_Message_TDD_NB_message;  /* BCCH_BCH_MessageType_TDD_NB_r15 */
static int hf_lte_rrc_bCCH_DL_SCH_Message_NB_message;  /* BCCH_DL_SCH_MessageType_NB */
static int hf_lte_rrc_c1_55;                      /* T_c1_55 */
static int hf_lte_rrc_systemInformation_r13;      /* SystemInformation_NB */
static int hf_lte_rrc_systemInformationBlockType1_r13;  /* SystemInformationBlockType1_NB */
static int hf_lte_rrc_messageClassExtension_10;   /* T_messageClassExtension_10 */
static int hf_lte_rrc_pCCH_Message_NB_message;    /* PCCH_MessageType_NB */
static int hf_lte_rrc_c1_56;                      /* T_c1_56 */
static int hf_lte_rrc_paging_r13;                 /* Paging_NB */
static int hf_lte_rrc_messageClassExtension_11;   /* T_messageClassExtension_11 */
static int hf_lte_rrc_dL_CCCH_Message_NB_message;  /* DL_CCCH_MessageType_NB */
static int hf_lte_rrc_c1_57;                      /* T_c1_57 */
static int hf_lte_rrc_rrcConnectionReestablishment_r13;  /* RRCConnectionReestablishment_NB */
static int hf_lte_rrc_rrcConnectionReestablishmentReject_r13;  /* RRCConnectionReestablishmentReject */
static int hf_lte_rrc_rrcConnectionReject_r13;    /* RRCConnectionReject_NB */
static int hf_lte_rrc_rrcConnectionSetup_r13;     /* RRCConnectionSetup_NB */
static int hf_lte_rrc_rrcEarlyDataComplete_r15_02;  /* RRCEarlyDataComplete_NB_r15 */
static int hf_lte_rrc_messageClassExtension_12;   /* T_messageClassExtension_12 */
static int hf_lte_rrc_dL_DCCH_Message_NB_message;  /* DL_DCCH_MessageType_NB */
static int hf_lte_rrc_c1_58;                      /* T_c1_58 */
static int hf_lte_rrc_dlInformationTransfer_r13;  /* DLInformationTransfer_NB */
static int hf_lte_rrc_rrcConnectionReconfiguration_r13;  /* RRCConnectionReconfiguration_NB */
static int hf_lte_rrc_rrcConnectionRelease_r13;   /* RRCConnectionRelease_NB */
static int hf_lte_rrc_securityModeCommand_r13;    /* SecurityModeCommand */
static int hf_lte_rrc_ueCapabilityEnquiry_r13;    /* UECapabilityEnquiry_NB */
static int hf_lte_rrc_rrcConnectionResume_r13_02;  /* RRCConnectionResume_NB */
static int hf_lte_rrc_ueInformationRequest_r16;   /* UEInformationRequest_NB_r16 */
static int hf_lte_rrc_messageClassExtension_13;   /* T_messageClassExtension_13 */
static int hf_lte_rrc_uL_CCCH_Message_NB_message;  /* UL_CCCH_MessageType_NB */
static int hf_lte_rrc_c1_59;                      /* T_c1_59 */
static int hf_lte_rrc_rrcConnectionReestablishmentRequest_r13;  /* RRCConnectionReestablishmentRequest_NB */
static int hf_lte_rrc_rrcConnectionRequest_r13;   /* RRCConnectionRequest_NB */
static int hf_lte_rrc_rrcConnectionResumeRequest_r13_02;  /* RRCConnectionResumeRequest_NB */
static int hf_lte_rrc_rrcEarlyDataRequest_r15_02;  /* RRCEarlyDataRequest_NB_r15 */
static int hf_lte_rrc_messageClassExtension_14;   /* T_messageClassExtension_14 */
static int hf_lte_rrc_sC_MCCH_Message_NB_message;  /* SC_MCCH_MessageType_NB */
static int hf_lte_rrc_c1_60;                      /* T_c1_60 */
static int hf_lte_rrc_scptmConfiguration_r14;     /* SCPTMConfiguration_NB_r14 */
static int hf_lte_rrc_messageClassExtension_15;   /* T_messageClassExtension_15 */
static int hf_lte_rrc_uL_DCCH_Message_NB_message;  /* UL_DCCH_MessageType_NB */
static int hf_lte_rrc_c1_61;                      /* T_c1_61 */
static int hf_lte_rrc_rrcConnectionReconfigurationComplete_r13;  /* RRCConnectionReconfigurationComplete_NB */
static int hf_lte_rrc_rrcConnectionReestablishmentComplete_r13;  /* RRCConnectionReestablishmentComplete_NB */
static int hf_lte_rrc_rrcConnectionSetupComplete_r13;  /* RRCConnectionSetupComplete_NB */
static int hf_lte_rrc_securityModeComplete_r13;   /* SecurityModeComplete */
static int hf_lte_rrc_securityModeFailure_r13;    /* SecurityModeFailure */
static int hf_lte_rrc_ueCapabilityInformation_r13;  /* UECapabilityInformation_NB */
static int hf_lte_rrc_ulInformationTransfer_r13;  /* ULInformationTransfer_NB */
static int hf_lte_rrc_rrcConnectionResumeComplete_r13_02;  /* RRCConnectionResumeComplete_NB */
static int hf_lte_rrc_ueInformationResponse_r16;  /* UEInformationResponse_NB_r16 */
static int hf_lte_rrc_purConfigurationRequest_r16_01;  /* PURConfigurationRequest_NB_r16 */
static int hf_lte_rrc_messageClassExtension_16;   /* T_messageClassExtension_16 */
static int hf_lte_rrc_criticalExtensions_66;      /* T_criticalExtensions_66 */
static int hf_lte_rrc_c1_62;                      /* T_c1_62 */
static int hf_lte_rrc_dlInformationTransfer_r13_01;  /* DLInformationTransfer_NB_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_64;  /* T_criticalExtensionsFuture_64 */
static int hf_lte_rrc_nonCriticalExtension_378;   /* T_nonCriticalExtension_89 */
static int hf_lte_rrc_systemFrameNumber_MSB_r13;  /* BIT_STRING_SIZE_4 */
static int hf_lte_rrc_hyperSFN_LSB_r13;           /* BIT_STRING_SIZE_2 */
static int hf_lte_rrc_schedulingInfoSIB1_r13;     /* INTEGER_0_15 */
static int hf_lte_rrc_systemInfoValueTag_r13;     /* INTEGER_0_31 */
static int hf_lte_rrc_ab_Enabled_r13;             /* BOOLEAN */
static int hf_lte_rrc_operationModeInfo_r13;      /* T_operationModeInfo_r13 */
static int hf_lte_rrc_inband_SamePCI_r13;         /* Inband_SamePCI_NB_r13 */
static int hf_lte_rrc_inband_DifferentPCI_r13;    /* Inband_DifferentPCI_NB_r13 */
static int hf_lte_rrc_guardband_r13;              /* Guardband_NB_r13 */
static int hf_lte_rrc_standalone_r13;             /* Standalone_NB_r13 */
static int hf_lte_rrc_masterInformationBlock_NB_additionalTransmissionSIB1_r15;  /* BOOLEAN */
static int hf_lte_rrc_ab_Enabled_5GC_r16;         /* BOOLEAN */
static int hf_lte_rrc_partEARFCN_r17_01;          /* T_partEARFCN_r17_01 */
static int hf_lte_rrc_spare_04;                   /* BIT_STRING_SIZE_6 */
static int hf_lte_rrc_rasterOffset_r13;           /* ChannelRasterOffset_NB_r13 */
static int hf_lte_rrc_spare_05;                   /* BIT_STRING_SIZE_3 */
static int hf_lte_rrc_eutra_CRS_SequenceInfo_r13;  /* INTEGER_0_31 */
static int hf_lte_rrc_eutra_NumCRS_Ports_r13;     /* T_eutra_NumCRS_Ports_r13 */
static int hf_lte_rrc_spare_06;                   /* BIT_STRING_SIZE_5 */
static int hf_lte_rrc_systemFrameNumber_MSB_r15;  /* BIT_STRING_SIZE_4 */
static int hf_lte_rrc_hyperSFN_LSB_r15;           /* BIT_STRING_SIZE_2 */
static int hf_lte_rrc_schedulingInfoSIB1_r15;     /* INTEGER_0_15 */
static int hf_lte_rrc_systemInfoValueTag_r15;     /* INTEGER_0_31 */
static int hf_lte_rrc_ab_Enabled_r15;             /* BOOLEAN */
static int hf_lte_rrc_operationModeInfo_r15;      /* T_operationModeInfo_r15 */
static int hf_lte_rrc_inband_SamePCI_r15;         /* Inband_SamePCI_TDD_NB_r15 */
static int hf_lte_rrc_inband_DifferentPCI_r15;    /* Inband_DifferentPCI_TDD_NB_r15 */
static int hf_lte_rrc_guardband_r15;              /* GuardbandTDD_NB_r15 */
static int hf_lte_rrc_standalone_r15;             /* StandaloneTDD_NB_r15 */
static int hf_lte_rrc_sib1_CarrierInfo_r15;       /* T_sib1_CarrierInfo_r15 */
static int hf_lte_rrc_spare_07;                   /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_rasterOffset_r15;           /* ChannelRasterOffset_NB_r13 */
static int hf_lte_rrc_sib_GuardbandInfo_r15;      /* T_sib_GuardbandInfo_r15 */
static int hf_lte_rrc_sib_GuardbandAnchor_r15;    /* SIB_GuardbandAnchorTDD_NB_r15 */
static int hf_lte_rrc_sib_GuardbandGuardband_r15;  /* SIB_GuardbandGuardbandTDD_NB_r15 */
static int hf_lte_rrc_sib_GuardbandInbandSamePCI_r15;  /* SIB_GuardbandInbandSamePCI_TDD_NB_r15 */
static int hf_lte_rrc_sib_GuardbandinbandDiffPCI_r15;  /* SIB_GuardbandInbandDiffPCI_TDD_NB_r15 */
static int hf_lte_rrc_eutra_Bandwitdh_r15;        /* T_eutra_Bandwitdh_r15 */
static int hf_lte_rrc_eutra_CRS_SequenceInfo_r15;  /* INTEGER_0_31 */
static int hf_lte_rrc_sib_InbandLocation_r15;     /* T_sib_InbandLocation_r15 */
static int hf_lte_rrc_eutra_NumCRS_Ports_r15;     /* T_eutra_NumCRS_Ports_r15 */
static int hf_lte_rrc_sib_InbandLocation_r15_01;  /* T_sib_InbandLocation_r15_01 */
static int hf_lte_rrc_sib_StandaloneLocation_r15;  /* T_sib_StandaloneLocation_r15 */
static int hf_lte_rrc_sib_GuardbandGuardbandLocation_r15;  /* T_sib_GuardbandGuardbandLocation_r15 */
static int hf_lte_rrc_sib_EUTRA_NumCRS_Ports_r15;  /* T_sib_EUTRA_NumCRS_Ports_r15 */
static int hf_lte_rrc_pagingRecordList_r13;       /* PagingRecordList_NB_r13 */
static int hf_lte_rrc_systemInfoModification_r13;  /* T_systemInfoModification_r13 */
static int hf_lte_rrc_systemInfoModification_eDRX_r13_01;  /* T_systemInfoModification_eDRX_r13_01 */
static int hf_lte_rrc_nonCriticalExtension_379;   /* Paging_NB_v1610_IEs */
static int hf_lte_rrc_pagingRecordList_v1610_01;  /* PagingRecordList_NB_v1610 */
static int hf_lte_rrc_nonCriticalExtension_380;   /* T_nonCriticalExtension_90 */
static int hf_lte_rrc_PagingRecordList_NB_r13_item;  /* PagingRecord_NB_r13 */
static int hf_lte_rrc_PagingRecordList_NB_v1610_item;  /* PagingRecord_NB_v1610 */
static int hf_lte_rrc_ue_Identity_r13;            /* PagingUE_Identity */
static int hf_lte_rrc_mt_EDT_r16_01;              /* T_mt_EDT_r16_01 */
static int hf_lte_rrc_criticalExtensions_67;      /* T_criticalExtensions_67 */
static int hf_lte_rrc_purConfigurationRequest_r16_02;  /* PURConfigurationRequest_NB_r16_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_65;  /* T_criticalExtensionsFuture_65 */
static int hf_lte_rrc_pur_ConfigRequest_r16_01;   /* PUR_ConfigRequest_NB_r16 */
static int hf_lte_rrc_nonCriticalExtension_381;   /* T_nonCriticalExtension_91 */
static int hf_lte_rrc_pur_SetupRequest_01;        /* T_pur_SetupRequest_01 */
static int hf_lte_rrc_requestedNumOccasions_r16_01;  /* T_requestedNumOccasions_r16_01 */
static int hf_lte_rrc_requestedPeriodicityAndOffset_r16_01;  /* PUR_PeriodicityAndOffset_NB_r16 */
static int hf_lte_rrc_requestedTBS_r16_01;        /* T_requestedTBS_r16_01 */
static int hf_lte_rrc_rrc_ACK_r16_01;             /* T_rrc_ACK_r16_01 */
static int hf_lte_rrc_criticalExtensions_68;      /* T_criticalExtensions_68 */
static int hf_lte_rrc_c1_63;                      /* T_c1_63 */
static int hf_lte_rrc_rrcConnectionReconfiguration_r13_01;  /* RRCConnectionReconfiguration_NB_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_66;  /* T_criticalExtensionsFuture_66 */
static int hf_lte_rrc_dedicatedInfoNASList_r13;   /* SEQUENCE_SIZE_1_maxDRB_NB_r13_OF_DedicatedInfoNAS */
static int hf_lte_rrc_dedicatedInfoNASList_r13_item;  /* DedicatedInfoNAS */
static int hf_lte_rrc_radioResourceConfigDedicated_r13_01;  /* RadioResourceConfigDedicated_NB_r13 */
static int hf_lte_rrc_fullConfig_r13;             /* T_fullConfig_r13 */
static int hf_lte_rrc_nonCriticalExtension_382;   /* RRCConnectionReconfiguration_NB_v16f0_IEs */
static int hf_lte_rrc_obtainLocationNB_r16;       /* T_obtainLocationNB_r16 */
static int hf_lte_rrc_nonCriticalExtension_383;   /* T_nonCriticalExtension_92 */
static int hf_lte_rrc_criticalExtensions_69;      /* T_criticalExtensions_69 */
static int hf_lte_rrc_rrcConnectionReconfigurationComplete_r13_01;  /* RRCConnectionReconfigurationComplete_NB_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_67;  /* T_criticalExtensionsFuture_67 */
static int hf_lte_rrc_nonCriticalExtension_384;   /* T_nonCriticalExtension_93 */
static int hf_lte_rrc_criticalExtensions_70;      /* T_criticalExtensions_70 */
static int hf_lte_rrc_c1_64;                      /* T_c1_64 */
static int hf_lte_rrc_rrcConnectionReestablishment_r13_01;  /* RRCConnectionReestablishment_NB_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_68;  /* T_criticalExtensionsFuture_68 */
static int hf_lte_rrc_nonCriticalExtension_385;   /* RRCConnectionReestablishment_NB_v1430_IEs */
static int hf_lte_rrc_dl_NAS_MAC;                 /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_nonCriticalExtension_386;   /* T_nonCriticalExtension_94 */
static int hf_lte_rrc_criticalExtensions_71;      /* T_criticalExtensions_71 */
static int hf_lte_rrc_rrcConnectionReestablishmentComplete_r13_01;  /* RRCConnectionReestablishmentComplete_NB_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_69;  /* T_criticalExtensionsFuture_69 */
static int hf_lte_rrc_nonCriticalExtension_387;   /* RRCConnectionReestablishmentComplete_NB_v1470_IEs */
static int hf_lte_rrc_measResultServCell_r14;     /* MeasResultServCell_NB_r14 */
static int hf_lte_rrc_nonCriticalExtension_388;   /* RRCConnectionReestablishmentComplete_NB_v1610_IEs */
static int hf_lte_rrc_rlf_InfoAvailable_r16;      /* T_rlf_InfoAvailable_r16 */
static int hf_lte_rrc_rRCConnectionReestablishmentComplete_NB_v1610_IEs_anr_InfoAvailable_r16;  /* T_rRCConnectionReestablishmentComplete_NB_v1610_IEs_anr_InfoAvailable_r16 */
static int hf_lte_rrc_nonCriticalExtension_389;   /* RRCConnectionReestablishmentComplete_NB_v1710_IEs */
static int hf_lte_rrc_nonCriticalExtension_390;   /* RRCConnectionReestablishmentComplete_NB_v1800_IEs */
static int hf_lte_rrc_nonCriticalExtension_391;   /* T_nonCriticalExtension_95 */
static int hf_lte_rrc_criticalExtensions_72;      /* T_criticalExtensions_72 */
static int hf_lte_rrc_rrcConnectionReestablishmentRequest_r13_01;  /* RRCConnectionReestablishmentRequest_NB_r13_IEs */
static int hf_lte_rrc_later_01;                   /* T_later_01 */
static int hf_lte_rrc_rrcConnectionReestablishmentRequest_r14;  /* RRCConnectionReestablishmentRequest_NB_r14_IEs */
static int hf_lte_rrc_later_02;                   /* T_later_02 */
static int hf_lte_rrc_rrcConnectionReestablishmentRequest_r16;  /* RRCConnectionReestablishmentRequest_5GC_NB_r16_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_70;  /* T_criticalExtensionsFuture_70 */
static int hf_lte_rrc_ue_Identity_r13_01;         /* ReestabUE_Identity */
static int hf_lte_rrc_reestablishmentCause_r13;   /* ReestablishmentCause_NB_r13 */
static int hf_lte_rrc_cqi_NPDCCH_r14;             /* CQI_NPDCCH_NB_r14 */
static int hf_lte_rrc_earlyContentionResolution_r14;  /* BOOLEAN */
static int hf_lte_rrc_spare_08;                   /* BIT_STRING_SIZE_20 */
static int hf_lte_rrc_ue_Identity_r14;            /* ReestabUE_Identity_CP_NB_r14 */
static int hf_lte_rrc_reestablishmentCause_r14;   /* ReestablishmentCause_NB_r13 */
static int hf_lte_rrc_cqi_NPDCCH_r14_01;          /* CQI_NPDCCH_Short_NB_r14 */
static int hf_lte_rrc_ue_Identity_r16;            /* ReestabUE_Identity_CP_5GC_NB_r16 */
static int hf_lte_rrc_reestablishmentCause_r16;   /* ReestablishmentCause_NB_r13 */
static int hf_lte_rrc_cqi_NPDCCH_r16;             /* CQI_NPDCCH_Short_NB_r14 */
static int hf_lte_rrc_s_TMSI_r14;                 /* S_TMSI */
static int hf_lte_rrc_ul_NAS_MAC_r14;             /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_ul_NAS_Count_r14;           /* BIT_STRING_SIZE_5 */
static int hf_lte_rrc_truncated5G_S_TMSI_r16;     /* BIT_STRING_SIZE_40 */
static int hf_lte_rrc_ul_NAS_MAC_r16;             /* BIT_STRING_SIZE_16 */
static int hf_lte_rrc_ul_NAS_Count_r16;           /* BIT_STRING_SIZE_5 */
static int hf_lte_rrc_criticalExtensions_73;      /* T_criticalExtensions_73 */
static int hf_lte_rrc_c1_65;                      /* T_c1_65 */
static int hf_lte_rrc_rrcConnectionReject_r13_01;  /* RRCConnectionReject_NB_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_71;  /* T_criticalExtensionsFuture_71 */
static int hf_lte_rrc_extendedWaitTime_r13;       /* INTEGER_1_1800 */
static int hf_lte_rrc_rrc_SuspendIndication_r13_01;  /* T_rrc_SuspendIndication_r13_01 */
static int hf_lte_rrc_nonCriticalExtension_392;   /* T_nonCriticalExtension_96 */
static int hf_lte_rrc_criticalExtensions_74;      /* T_criticalExtensions_74 */
static int hf_lte_rrc_c1_66;                      /* T_c1_66 */
static int hf_lte_rrc_rrcConnectionRelease_r13_01;  /* RRCConnectionRelease_NB_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_72;  /* T_criticalExtensionsFuture_72 */
static int hf_lte_rrc_releaseCause_r13;           /* ReleaseCause_NB_r13 */
static int hf_lte_rrc_redirectedCarrierInfo_r13;  /* RedirectedCarrierInfo_NB_r13 */
static int hf_lte_rrc_nonCriticalExtension_393;   /* RRCConnectionRelease_NB_v1430_IEs */
static int hf_lte_rrc_redirectedCarrierInfo_v1430;  /* RedirectedCarrierInfo_NB_v1430 */
static int hf_lte_rrc_extendedWaitTime_CPdata_r14;  /* INTEGER_1_1800 */
static int hf_lte_rrc_nonCriticalExtension_394;   /* RRCConnectionRelease_NB_v1530_IEs */
static int hf_lte_rrc_drb_ContinueROHC_r15_01;    /* T_drb_ContinueROHC_r15_01 */
static int hf_lte_rrc_nonCriticalExtension_395;   /* RRCConnectionRelease_NB_v1550_IEs */
static int hf_lte_rrc_redirectedCarrierInfo_v1550;  /* RedirectedCarrierInfo_NB_v1550 */
static int hf_lte_rrc_nonCriticalExtension_396;   /* RRCConnectionRelease_NB_v15b0_IEs */
static int hf_lte_rrc_noLastCellUpdate_r15_01;    /* T_noLastCellUpdate_r15_01 */
static int hf_lte_rrc_nonCriticalExtension_397;   /* RRCConnectionRelease_NB_v1610_IEs */
static int hf_lte_rrc_resumeIdentity_r16;         /* I_RNTI_r15 */
static int hf_lte_rrc_anr_MeasConfig_r16;         /* ANR_MeasConfig_NB_r16 */
static int hf_lte_rrc_pur_Config_r16_01;          /* T_pur_Config_r16_01 */
static int hf_lte_rrc_rRCConnectionRelease_NB_v1610_IEs_pur_Config_r16_setup;  /* PUR_Config_NB_r16 */
static int hf_lte_rrc_nonCriticalExtension_398;   /* RRCConnectionRelease_NB_v1700_IEs */
static int hf_lte_rrc_nonCriticalExtension_399;   /* T_nonCriticalExtension_97 */
static int hf_lte_rrc_redirectedCarrierOffsetDedicated_r14;  /* T_redirectedCarrierOffsetDedicated_r14 */
static int hf_lte_rrc_t322_r14;                   /* T_t322_r14 */
static int hf_lte_rrc_criticalExtensions_75;      /* T_criticalExtensions_75 */
static int hf_lte_rrc_rrcConnectionRequest_r13_01;  /* RRCConnectionRequest_NB_r13_IEs */
static int hf_lte_rrc_later_03;                   /* T_later_03 */
static int hf_lte_rrc_rrcConnectionRequest_r16;   /* RRCConnectionRequest_5GC_NB_r16_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_73;  /* T_criticalExtensionsFuture_73 */
static int hf_lte_rrc_ue_Identity_r13_02;         /* InitialUE_Identity */
static int hf_lte_rrc_establishmentCause_r13;     /* EstablishmentCause_NB_r13 */
static int hf_lte_rrc_multiToneSupport_r13;       /* T_multiToneSupport_r13 */
static int hf_lte_rrc_multiCarrierSupport_r13;    /* T_multiCarrierSupport_r13 */
static int hf_lte_rrc_spare_09;                   /* BIT_STRING_SIZE_17 */
static int hf_lte_rrc_ue_Identity_r16_01;         /* InitialUE_Identity_5GC_NB_r16 */
static int hf_lte_rrc_establishmentCause_r16_01;  /* T_establishmentCause_r16_01 */
static int hf_lte_rrc_cqi_NPDCCH_r16_01;          /* CQI_NPDCCH_NB_r14 */
static int hf_lte_rrc_randomValue_01;             /* BIT_STRING_SIZE_48 */
static int hf_lte_rrc_criticalExtensions_76;      /* T_criticalExtensions_76 */
static int hf_lte_rrc_c1_67;                      /* T_c1_67 */
static int hf_lte_rrc_rrcConnectionResume_r13_03;  /* RRCConnectionResume_NB_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_74;  /* T_criticalExtensionsFuture_74 */
static int hf_lte_rrc_drb_ContinueROHC_r13_01;    /* T_drb_ContinueROHC_r13_01 */
static int hf_lte_rrc_nonCriticalExtension_400;   /* RRCConnectionResume_NB_v1610_IEs */
static int hf_lte_rrc_fullConfig_r16;             /* T_fullConfig_r16 */
static int hf_lte_rrc_nonCriticalExtension_401;   /* RRCConnectionResume_NB_v16f0_IEs */
static int hf_lte_rrc_obtainLocationNB_r16_01;    /* T_obtainLocationNB_r16_01 */
static int hf_lte_rrc_nonCriticalExtension_402;   /* T_nonCriticalExtension_98 */
static int hf_lte_rrc_criticalExtensions_77;      /* T_criticalExtensions_77 */
static int hf_lte_rrc_rrcConnectionResumeComplete_r13_03;  /* RRCConnectionResumeComplete_NB_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_75;  /* T_criticalExtensionsFuture_75 */
static int hf_lte_rrc_nonCriticalExtension_403;   /* RRCConnectionResumeComplete_NB_v1470_IEs */
static int hf_lte_rrc_nonCriticalExtension_404;   /* RRCConnectionResumeComplete_NB_v1610_IEs */
static int hf_lte_rrc_rlf_InfoAvailable_r16_01;   /* T_rlf_InfoAvailable_r16_01 */
static int hf_lte_rrc_rRCConnectionResumeComplete_NB_v1610_IEs_anr_InfoAvailable_r16;  /* T_rRCConnectionResumeComplete_NB_v1610_IEs_anr_InfoAvailable_r16 */
static int hf_lte_rrc_nonCriticalExtension_405;   /* RRCConnectionResumeComplete_NB_v1710_IEs */
static int hf_lte_rrc_nonCriticalExtension_406;   /* RRCConnectionResumeComplete_NB_v1800_IEs */
static int hf_lte_rrc_nonCriticalExtension_407;   /* T_nonCriticalExtension_99 */
static int hf_lte_rrc_criticalExtensions_78;      /* T_criticalExtensions_78 */
static int hf_lte_rrc_rrcConnectionResumeRequest_r13_03;  /* RRCConnectionResumeRequest_NB_r13_IEs */
static int hf_lte_rrc_later_04;                   /* T_later_04 */
static int hf_lte_rrc_rrcConnectionResumeRequest_r16;  /* RRCConnectionResumeRequest_5GC_NB_r16_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_76;  /* T_criticalExtensionsFuture_76 */
static int hf_lte_rrc_shortResumeMAC_I_r13_01;    /* ShortMAC_I */
static int hf_lte_rrc_resumeCause_r13_01;         /* EstablishmentCause_NB_r13 */
static int hf_lte_rrc_rRCConnectionResumeRequest_NB_r13_IEs_anr_InfoAvailable_r16;  /* BOOLEAN */
static int hf_lte_rrc_resumeID_r16;               /* I_RNTI_r15 */
static int hf_lte_rrc_shortResumeMAC_I_r16;       /* ShortMAC_I */
static int hf_lte_rrc_resumeCause_r16;            /* EstablishmentCause_NB_r13 */
static int hf_lte_rrc_spare_10;                   /* BIT_STRING_SIZE_4 */
static int hf_lte_rrc_criticalExtensions_79;      /* T_criticalExtensions_79 */
static int hf_lte_rrc_c1_68;                      /* T_c1_68 */
static int hf_lte_rrc_rrcConnectionSetup_r13_01;  /* RRCConnectionSetup_NB_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_77;  /* T_criticalExtensionsFuture_77 */
static int hf_lte_rrc_nonCriticalExtension_408;   /* RRCConnectionSetup_NB_v1610_IEs */
static int hf_lte_rrc_nonCriticalExtension_409;   /* T_nonCriticalExtension_100 */
static int hf_lte_rrc_criticalExtensions_80;      /* T_criticalExtensions_80 */
static int hf_lte_rrc_rrcConnectionSetupComplete_r13_01;  /* RRCConnectionSetupComplete_NB_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_78;  /* T_criticalExtensionsFuture_78 */
static int hf_lte_rrc_registeredMME_r13;          /* RegisteredMME */
static int hf_lte_rrc_attachWithoutPDN_Connectivity_r13_02;  /* T_attachWithoutPDN_Connectivity_r13_02 */
static int hf_lte_rrc_up_CIoT_EPS_Optimisation_r13_02;  /* T_up_CIoT_EPS_Optimisation_r13_02 */
static int hf_lte_rrc_nonCriticalExtension_410;   /* RRCConnectionSetupComplete_NB_v1430_IEs */
static int hf_lte_rrc_gummei_Type_r14;            /* T_gummei_Type_r14 */
static int hf_lte_rrc_nonCriticalExtension_411;   /* RRCConnectionSetupComplete_NB_v1470_IEs */
static int hf_lte_rrc_nonCriticalExtension_412;   /* RRCConnectionSetupComplete_NB_v1610_IEs */
static int hf_lte_rrc_registeredAMF_r16;          /* RegisteredAMF_r15 */
static int hf_lte_rrc_gummei_Type_v1610;          /* T_gummei_Type_v1610 */
static int hf_lte_rrc_guami_Type_r16;             /* T_guami_Type_r16 */
static int hf_lte_rrc_s_NSSAI_list_r16;           /* SEQUENCE_SIZE_1_maxNrofS_NSSAI_r15_OF_S_NSSAI_r15 */
static int hf_lte_rrc_s_NSSAI_list_r16_item;      /* S_NSSAI_r15 */
static int hf_lte_rrc_ng_U_DataTransfer_r16;      /* T_ng_U_DataTransfer_r16 */
static int hf_lte_rrc_up_CIoT_5GS_Optimisation_r16_02;  /* T_up_CIoT_5GS_Optimisation_r16_02 */
static int hf_lte_rrc_rlf_InfoAvailable_r16_02;   /* T_rlf_InfoAvailable_r16_02 */
static int hf_lte_rrc_anr_InfoAvailable_r16;      /* T_anr_InfoAvailable_r16 */
static int hf_lte_rrc_pur_ConfigID_r16_01;        /* PUR_ConfigID_NB_r16 */
static int hf_lte_rrc_nonCriticalExtension_413;   /* RRCConnectionSetupComplete_NB_v1710_IEs */
static int hf_lte_rrc_nonCriticalExtension_414;   /* RRCConnectionSetupComplete_NB_v1800_IEs */
static int hf_lte_rrc_nonCriticalExtension_415;   /* T_nonCriticalExtension_101 */
static int hf_lte_rrc_criticalExtensions_81;      /* T_criticalExtensions_81 */
static int hf_lte_rrc_rrcEarlyDataComplete_r15_03;  /* RRCEarlyDataComplete_NB_r15_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_79;  /* T_criticalExtensionsFuture_79 */
static int hf_lte_rrc_redirectedCarrierInfo_r15_01;  /* RedirectedCarrierInfo_NB_r13 */
static int hf_lte_rrc_redirectedCarrierInfoExt_r15;  /* RedirectedCarrierInfo_NB_v1430 */
static int hf_lte_rrc_nonCriticalExtension_416;   /* RRCEarlyDataComplete_NB_v1590_IEs */
static int hf_lte_rrc_nonCriticalExtension_417;   /* RRCEarlyDataComplete_NB_v1700_IEs */
static int hf_lte_rrc_nonCriticalExtension_418;   /* T_nonCriticalExtension_102 */
static int hf_lte_rrc_criticalExtensions_82;      /* T_criticalExtensions_82 */
static int hf_lte_rrc_rrcEarlyDataRequest_r15_03;  /* RRCEarlyDataRequest_NB_r15_IEs */
static int hf_lte_rrc_later_05;                   /* T_later_05 */
static int hf_lte_rrc_rrcEarlyDataRequest_r16;    /* RRCEarlyDataRequest_5GC_NB_r16_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_80;  /* T_criticalExtensionsFuture_80 */
static int hf_lte_rrc_establishmentCause_r15_02;  /* T_establishmentCause_r15_01 */
static int hf_lte_rrc_cqi_NPDCCH_r15;             /* CQI_NPDCCH_NB_r14 */
static int hf_lte_rrc_nonCriticalExtension_419;   /* RRCEarlyDataRequest_NB_v1590_IEs */
static int hf_lte_rrc_nonCriticalExtension_420;   /* T_nonCriticalExtension_103 */
static int hf_lte_rrc_establishmentCause_r16_02;  /* T_establishmentCause_r16_02 */
static int hf_lte_rrc_nonCriticalExtension_421;   /* T_nonCriticalExtension_104 */
static int hf_lte_rrc_sc_mtch_InfoList_r14_01;    /* SC_MTCH_InfoList_NB_r14 */
static int hf_lte_rrc_scptm_NeighbourCellList_r14_01;  /* SCPTM_NeighbourCellList_NB_r14 */
static int hf_lte_rrc_nonCriticalExtension_422;   /* SCPTMConfiguration_NB_v1610 */
static int hf_lte_rrc_sc_mtch_InfoListMultiTB_r16;  /* SC_MTCH_InfoList_NB_r14 */
static int hf_lte_rrc_multiTB_Gap_r16_01;         /* T_multiTB_Gap_r16_01 */
static int hf_lte_rrc_nonCriticalExtension_423;   /* T_nonCriticalExtension_105 */
static int hf_lte_rrc_criticalExtensions_83;      /* T_criticalExtensions_83 */
static int hf_lte_rrc_systemInformation_r13_01;   /* SystemInformation_NB_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_81;  /* T_criticalExtensionsFuture_81 */
static int hf_lte_rrc_sib_TypeAndInfo_r13;        /* T_sib_TypeAndInfo_r13 */
static int hf_lte_rrc_sib_TypeAndInfo_r13_item;   /* T_sib_TypeAndInfo_r13_item */
static int hf_lte_rrc_sib2_r13;                   /* SystemInformationBlockType2_NB_r13 */
static int hf_lte_rrc_sib3_r13;                   /* SystemInformationBlockType3_NB_r13 */
static int hf_lte_rrc_sib4_r13;                   /* SystemInformationBlockType4_NB_r13 */
static int hf_lte_rrc_sib5_r13;                   /* SystemInformationBlockType5_NB_r13 */
static int hf_lte_rrc_sib14_r13;                  /* SystemInformationBlockType14_NB_r13 */
static int hf_lte_rrc_sib16_r13;                  /* SystemInformationBlockType16_NB_r13 */
static int hf_lte_rrc_sib15_v1430;                /* SystemInformationBlockType15_NB_r14 */
static int hf_lte_rrc_sib20_v1430;                /* SystemInformationBlockType20_NB_r14 */
static int hf_lte_rrc_sib22_v1430;                /* SystemInformationBlockType22_NB_r14 */
static int hf_lte_rrc_sib23_v1530;                /* SystemInformationBlockType23_NB_r15 */
static int hf_lte_rrc_sib27_v1610_01;             /* SystemInformationBlockType27_NB_r16 */
static int hf_lte_rrc_sib31_v1700_01;             /* SystemInformationBlockType31_NB_r17 */
static int hf_lte_rrc_sib32_v1700_01;             /* SystemInformationBlockType32_NB_r17 */
static int hf_lte_rrc_sib33_v1800_01;             /* SystemInformationBlockType33_NB_r18 */
static int hf_lte_rrc_nonCriticalExtension_424;   /* T_nonCriticalExtension_106 */
static int hf_lte_rrc_hyperSFN_MSB_r13;           /* BIT_STRING_SIZE_8 */
static int hf_lte_rrc_cellAccessRelatedInfo_r13;  /* T_cellAccessRelatedInfo_r13 */
static int hf_lte_rrc_plmn_IdentityList_r13_01;   /* PLMN_IdentityList_NB_r13 */
static int hf_lte_rrc_trackingAreaCode_r13;       /* TrackingAreaCode */
static int hf_lte_rrc_cellIdentity_r13;           /* CellIdentity */
static int hf_lte_rrc_cellBarred_r13;             /* T_cellBarred_r13 */
static int hf_lte_rrc_intraFreqReselection_r13;   /* T_intraFreqReselection_r13 */
static int hf_lte_rrc_cellSelectionInfo_r13;      /* T_cellSelectionInfo_r13 */
static int hf_lte_rrc_q_QualMin_r13;              /* Q_QualMin_r9 */
static int hf_lte_rrc_freqBandIndicator_r13_01;   /* FreqBandIndicator_NB_r13 */
static int hf_lte_rrc_freqBandInfo_r13;           /* NS_PmaxList_NB_r13 */
static int hf_lte_rrc_multiBandInfoList_r13_01;   /* MultiBandInfoList_NB_r13 */
static int hf_lte_rrc_downlinkBitmap_r13;         /* DL_Bitmap_NB_r13 */
static int hf_lte_rrc_eutraControlRegionSize_r13;  /* T_eutraControlRegionSize_r13 */
static int hf_lte_rrc_nrs_CRS_PowerOffset_r13;    /* T_nrs_CRS_PowerOffset_r13 */
static int hf_lte_rrc_schedulingInfoList_r13;     /* SchedulingInfoList_NB_r13 */
static int hf_lte_rrc_si_WindowLength_r13;        /* T_si_WindowLength_r13 */
static int hf_lte_rrc_si_RadioFrameOffset_r13;    /* INTEGER_1_15 */
static int hf_lte_rrc_systemInfoValueTagList_r13_01;  /* SystemInfoValueTagList_NB_r13 */
static int hf_lte_rrc_nonCriticalExtension_425;   /* SystemInformationBlockType1_NB_v1350 */
static int hf_lte_rrc_cellSelectionInfo_v1350;    /* CellSelectionInfo_NB_v1350 */
static int hf_lte_rrc_nonCriticalExtension_426;   /* SystemInformationBlockType1_NB_v1430 */
static int hf_lte_rrc_cellSelectionInfo_v1430;    /* CellSelectionInfo_NB_v1430 */
static int hf_lte_rrc_nonCriticalExtension_427;   /* SystemInformationBlockType1_NB_v1450 */
static int hf_lte_rrc_nrs_CRS_PowerOffset_v1450;  /* T_nrs_CRS_PowerOffset_v1450 */
static int hf_lte_rrc_nonCriticalExtension_428;   /* SystemInformationBlockType1_NB_v1530 */
static int hf_lte_rrc_tdd_Parameters_r15;         /* T_tdd_Parameters_r15 */
static int hf_lte_rrc_tdd_Config_r15;             /* TDD_Config_NB_r15 */
static int hf_lte_rrc_tdd_SI_CarrierInfo_r15;     /* T_tdd_SI_CarrierInfo_r15 */
static int hf_lte_rrc_tdd_SI_SubframesBitmap_r15;  /* DL_Bitmap_NB_r13 */
static int hf_lte_rrc_schedulingInfoList_v1530;   /* SchedulingInfoList_NB_v1530 */
static int hf_lte_rrc_nonCriticalExtension_429;   /* SystemInformationBlockType1_NB_v1610 */
static int hf_lte_rrc_cellAccessRelatedInfo_5GC_r16;  /* T_cellAccessRelatedInfo_5GC_r16 */
static int hf_lte_rrc_plmn_IdentityList_r16;      /* PLMN_IdentityList_5GC_NB_r16 */
static int hf_lte_rrc_cellIdentity_r16_01;        /* CellIdentity */
static int hf_lte_rrc_cellBarred_5GC_r16;         /* T_cellBarred_5GC_r16 */
static int hf_lte_rrc_nonCriticalExtension_430;   /* SystemInformationBlockType1_NB_v1700 */
static int hf_lte_rrc_cellAccessRelatedInfo_NTN_r17_01;  /* T_cellAccessRelatedInfo_NTN_r17_01 */
static int hf_lte_rrc_cellBarred_NTN_r17_01;      /* T_cellBarred_NTN_r17_01 */
static int hf_lte_rrc_plmn_IdentityList_v1700_01;  /* PLMN_IdentityList_NB_v1700 */
static int hf_lte_rrc_nonCriticalExtension_431;   /* T_nonCriticalExtension_107 */
static int hf_lte_rrc_PLMN_IdentityList_NB_r13_item;  /* PLMN_IdentityInfo_NB_r13 */
static int hf_lte_rrc_PLMN_IdentityList_5GC_NB_r16_item;  /* PLMN_IdentityInfo_5GC_NB_r16 */
static int hf_lte_rrc_PLMN_IdentityList_NB_v1700_item;  /* PLMN_IdentityInfo_NB_v1700 */
static int hf_lte_rrc_plmn_Identity_r13;          /* PLMN_Identity */
static int hf_lte_rrc_cellReservedForOperatorUse_r13;  /* T_cellReservedForOperatorUse_r13 */
static int hf_lte_rrc_attachWithoutPDN_Connectivity_r13_03;  /* T_attachWithoutPDN_Connectivity_r13_03 */
static int hf_lte_rrc_plmn_Identity_5GC_r16;      /* T_plmn_Identity_5GC_r16 */
static int hf_lte_rrc_plmn_Index_r16;             /* INTEGER_1_maxPLMN_r11 */
static int hf_lte_rrc_cellReservedForOperatorUse_r16;  /* T_cellReservedForOperatorUse_r16 */
static int hf_lte_rrc_ng_U_DataTransfer_r16_01;   /* T_ng_U_DataTransfer_r16_01 */
static int hf_lte_rrc_up_CIoT_5GS_Optimisation_r16_03;  /* T_up_CIoT_5GS_Optimisation_r16_03 */
static int hf_lte_rrc_trackingAreaList_r17_01;    /* TrackingAreaList_NB_r17 */
static int hf_lte_rrc_TrackingAreaList_NB_r17_item;  /* TrackingAreaCode */
static int hf_lte_rrc_SchedulingInfoList_NB_r13_item;  /* SchedulingInfo_NB_r13 */
static int hf_lte_rrc_SchedulingInfoList_NB_v1530_item;  /* SchedulingInfo_NB_v1530 */
static int hf_lte_rrc_si_Periodicity_r13;         /* T_si_Periodicity_r13 */
static int hf_lte_rrc_si_RepetitionPattern_r13_01;  /* T_si_RepetitionPattern_r13_01 */
static int hf_lte_rrc_sib_MappingInfo_r13;        /* SIB_MappingInfo_NB_r13 */
static int hf_lte_rrc_si_TB_r13;                  /* T_si_TB_r13 */
static int hf_lte_rrc_sib_MappingInfo_v1530;      /* SIB_MappingInfo_NB_v1530 */
static int hf_lte_rrc_SystemInfoValueTagList_NB_r13_item;  /* SystemInfoValueTagSI_r13 */
static int hf_lte_rrc_SIB_MappingInfo_NB_r13_item;  /* SIB_Type_NB_r13 */
static int hf_lte_rrc_SIB_MappingInfo_NB_v1530_item;  /* SIB_Type_NB_v1530 */
static int hf_lte_rrc_delta_RxLevMin_v1350;       /* INTEGER_M8_M1 */
static int hf_lte_rrc_powerClass14dBm_Offset_r14;  /* T_powerClass14dBm_Offset_r14 */
static int hf_lte_rrc_ce_authorisationOffset_r14;  /* T_ce_authorisationOffset_r14 */
static int hf_lte_rrc_criticalExtensions_84;      /* T_criticalExtensions_84 */
static int hf_lte_rrc_c1_69;                      /* T_c1_69 */
static int hf_lte_rrc_ueCapabilityEnquiry_r13_01;  /* UECapabilityEnquiry_NB_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_82;  /* T_criticalExtensionsFuture_82 */
static int hf_lte_rrc_nonCriticalExtension_432;   /* T_nonCriticalExtension_108 */
static int hf_lte_rrc_criticalExtensions_85;      /* T_criticalExtensions_85 */
static int hf_lte_rrc_ueCapabilityInformation_r13_01;  /* UECapabilityInformation_NB_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_83;  /* T_criticalExtensionsFuture_83 */
static int hf_lte_rrc_ue_Capability_r13;          /* UE_Capability_NB_r13 */
static int hf_lte_rrc_ue_RadioPagingInfo_r13_01;  /* UE_RadioPagingInfo_NB_r13 */
static int hf_lte_rrc_nonCriticalExtension_433;   /* UECapabilityInformation_NB_Ext_r14_IEs */
static int hf_lte_rrc_ue_Capability_ContainerExt_r14;  /* T_ue_Capability_ContainerExt_r14 */
static int hf_lte_rrc_nonCriticalExtension_434;   /* T_nonCriticalExtension_109 */
static int hf_lte_rrc_criticalExtensions_86;      /* T_criticalExtensions_86 */
static int hf_lte_rrc_ueInformationRequest_r16_01;  /* UEInformationRequest_NB_r16_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_84;  /* T_criticalExtensionsFuture_84 */
static int hf_lte_rrc_rach_ReportReq_r16;         /* BOOLEAN */
static int hf_lte_rrc_rlf_ReportReq_r16;          /* BOOLEAN */
static int hf_lte_rrc_anr_ReportReq_r16;          /* BOOLEAN */
static int hf_lte_rrc_nonCriticalExtension_435;   /* T_nonCriticalExtension_110 */
static int hf_lte_rrc_criticalExtensions_87;      /* T_criticalExtensions_87 */
static int hf_lte_rrc_ueInformationResponse_r16_01;  /* UEInformationResponse_NB_r16_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_85;  /* T_criticalExtensionsFuture_85 */
static int hf_lte_rrc_rach_Report_r16;            /* RACH_Report_NB_r16 */
static int hf_lte_rrc_rlf_Report_r16;             /* RLF_Report_NB_r16 */
static int hf_lte_rrc_anr_MeasReport_r16;         /* ANR_MeasReport_NB_r16 */
static int hf_lte_rrc_nonCriticalExtension_436;   /* T_nonCriticalExtension_111 */
static int hf_lte_rrc_numberOfPreamblesSent_r16_01;  /* INTEGER_1_64 */
static int hf_lte_rrc_initialNRSRP_Level_r16;     /* INTEGER_0_2 */
static int hf_lte_rrc_failedPCellId_r16;          /* CellGlobalIdEUTRA */
static int hf_lte_rrc_reestablishmentCellId_r16;  /* CellGlobalIdEUTRA */
static int hf_lte_rrc_measResultLastServCell_r16;  /* T_measResultLastServCell_r16 */
static int hf_lte_rrc_nrsrpResult_r16;            /* NRSRP_Range_NB_r14 */
static int hf_lte_rrc_nrsrqResult_r16;            /* NRSRQ_Range_NB_r14 */
static int hf_lte_rrc_timeSinceFailure_r16;       /* TimeSinceFailure_r11 */
static int hf_lte_rrc_criticalExtensions_88;      /* T_criticalExtensions_88 */
static int hf_lte_rrc_ulInformationTransfer_r13_01;  /* ULInformationTransfer_NB_r13_IEs */
static int hf_lte_rrc_criticalExtensionsFuture_86;  /* T_criticalExtensionsFuture_86 */
static int hf_lte_rrc_nonCriticalExtension_437;   /* T_nonCriticalExtension_112 */
static int hf_lte_rrc_radioResourceConfigCommon_r13;  /* RadioResourceConfigCommonSIB_NB_r13 */
static int hf_lte_rrc_ue_TimersAndConstants_r13;  /* UE_TimersAndConstants_NB_r13 */
static int hf_lte_rrc_freqInfo_r13_01;            /* T_freqInfo_r13_01 */
static int hf_lte_rrc_ul_CarrierFreq_r13_01;      /* CarrierFreq_NB_r13 */
static int hf_lte_rrc_timeAlignmentTimerCommon_r13;  /* TimeAlignmentTimer */
static int hf_lte_rrc_multiBandInfoList_r13_02;   /* AdditionalSpectrumEmission_r13 */
static int hf_lte_rrc_multiBandInfoList_r13_item;  /* AdditionalSpectrumEmission */
static int hf_lte_rrc_cp_Reestablishment_r14;     /* T_cp_Reestablishment_r14 */
static int hf_lte_rrc_servingCellMeasInfo_r14;    /* T_servingCellMeasInfo_r14 */
static int hf_lte_rrc_cqi_Reporting_r14;          /* T_cqi_Reporting_r14 */
static int hf_lte_rrc_enhancedPHR_r15;            /* T_enhancedPHR_r15 */
static int hf_lte_rrc_freqInfo_v1530;             /* T_freqInfo_v1530 */
static int hf_lte_rrc_tdd_UL_DL_AlignmentOffset_r15;  /* TDD_UL_DL_AlignmentOffset_NB_r15 */
static int hf_lte_rrc_cp_EDT_r15_01;              /* T_cp_EDT_r15_01 */
static int hf_lte_rrc_up_EDT_r15_01;              /* T_up_EDT_r15_01 */
static int hf_lte_rrc_earlySecurityReactivation_r16_02;  /* T_earlySecurityReactivation_r16_02 */
static int hf_lte_rrc_cp_EDT_5GC_r16_01;          /* T_cp_EDT_5GC_r16_01 */
static int hf_lte_rrc_up_EDT_5GC_r16_01;          /* T_up_EDT_5GC_r16_01 */
static int hf_lte_rrc_cp_PUR_EPC_r16_01;          /* T_cp_PUR_EPC_r16_01 */
static int hf_lte_rrc_up_PUR_EPC_r16_01;          /* T_up_PUR_EPC_r16_01 */
static int hf_lte_rrc_cp_PUR_5GC_r16_01;          /* T_cp_PUR_5GC_r16_01 */
static int hf_lte_rrc_up_PUR_5GC_r16_01;          /* T_up_PUR_5GC_r16_01 */
static int hf_lte_rrc_rai_ActivationEnh_r16_01;   /* T_rai_ActivationEnh_r16_01 */
static int hf_lte_rrc_gnss_PositionFixDurationReporting_r18_02;  /* T_gnss_PositionFixDurationReporting_r18_02 */
static int hf_lte_rrc_cellReselectionInfoCommon_r13;  /* T_cellReselectionInfoCommon_r13 */
static int hf_lte_rrc_q_Hyst_r13_02;              /* T_q_Hyst_r13_02 */
static int hf_lte_rrc_cellReselectionServingFreqInfo_r13;  /* T_cellReselectionServingFreqInfo_r13 */
static int hf_lte_rrc_s_NonIntraSearch_r13;       /* ReselectionThreshold */
static int hf_lte_rrc_intraFreqCellReselectionInfo_r13;  /* T_intraFreqCellReselectionInfo_r13 */
static int hf_lte_rrc_s_IntraSearchP_r13;         /* ReselectionThreshold */
static int hf_lte_rrc_t_Reselection_r13;          /* T_Reselection_NB_r13 */
static int hf_lte_rrc_multiBandInfoList_r13_03;   /* SEQUENCE_SIZE_1_maxMultiBands_OF_NS_PmaxList_NB_r13 */
static int hf_lte_rrc_multiBandInfoList_r13_item_01;  /* NS_PmaxList_NB_r13 */
static int hf_lte_rrc_intraFreqCellReselectionInfo_v1350;  /* IntraFreqCellReselectionInfo_NB_v1350 */
static int hf_lte_rrc_intraFreqCellReselectionInfo_v1360;  /* IntraFreqCellReselectionInfo_NB_v1360 */
static int hf_lte_rrc_intraFreqCellReselectionInfo_v1430;  /* IntraFreqCellReselectionInfo_NB_v1430 */
static int hf_lte_rrc_cellReselectionInfoCommon_v1450;  /* CellReselectionInfoCommon_NB_v1450 */
static int hf_lte_rrc_nsss_RRM_Config_r15;        /* NSSS_RRM_Config_NB_r15 */
static int hf_lte_rrc_npbch_RRM_Config_r15;       /* T_npbch_RRM_Config_r15 */
static int hf_lte_rrc_connMeasConfig_r17;         /* ConnMeasConfig_NB_r17 */
static int hf_lte_rrc_satelliteAssistanceInfo_r18;  /* SEQUENCE_SIZE_1_maxSat_r17_OF_SatelliteId_r18 */
static int hf_lte_rrc_satelliteAssistanceInfo_r18_item;  /* SatelliteId_r18 */
static int hf_lte_rrc_s_IntraSearchP_v1360;       /* ReselectionThreshold_NB_v1360 */
static int hf_lte_rrc_powerClass14dBm_Offset_r14_01;  /* T_powerClass14dBm_Offset_r14_01 */
static int hf_lte_rrc_ce_AuthorisationOffset_r14;  /* T_ce_AuthorisationOffset_r14 */
static int hf_lte_rrc_s_SearchDeltaP_r14_01;      /* T_s_SearchDeltaP_r14_01 */
static int hf_lte_rrc_s_MeasureIntra_r17;         /* NRSRP_Range_NB_r14 */
static int hf_lte_rrc_s_MeasureInter_r17;         /* NRSRP_Range_NB_r14 */
static int hf_lte_rrc_neighCellMeasCriteria_r17;  /* T_neighCellMeasCriteria_r17 */
static int hf_lte_rrc_s_MeasureDeltaP_r17;        /* T_s_MeasureDeltaP_r17 */
static int hf_lte_rrc_t_MeasureDeltaP_r17;        /* T_t_MeasureDeltaP_r17 */
static int hf_lte_rrc_intraFreqNeighCellList_r13;  /* IntraFreqNeighCellList */
static int hf_lte_rrc_intraFreqExcludedCellList_r13;  /* IntraFreqExcludedCellList */
static int hf_lte_rrc_intraFreqNeighCellList_v1530;  /* IntraFreqNeighCellList_NB_v1530 */
static int hf_lte_rrc_IntraFreqNeighCellList_NB_v1530_item;  /* IntraFreqNeighCellInfo_NB_v1530 */
static int hf_lte_rrc_interFreqCarrierFreqList_r13;  /* InterFreqCarrierFreqList_NB_r13 */
static int hf_lte_rrc_interFreqCarrierFreqList_v1820;  /* InterFreqCarrierFreqList_NB_v1820 */
static int hf_lte_rrc_InterFreqCarrierFreqList_NB_r13_item;  /* InterFreqCarrierFreqInfo_NB_r13 */
static int hf_lte_rrc_InterFreqCarrierFreqList_NB_v1820_item;  /* InterFreqCarrierFreqInfo_NB_v1820 */
static int hf_lte_rrc_dl_CarrierFreq_r13_01;      /* CarrierFreq_NB_r13 */
static int hf_lte_rrc_q_OffsetFreq_r13;           /* Q_OffsetRange */
static int hf_lte_rrc_interFreqNeighCellList_r13;  /* InterFreqNeighCellList_NB_r13 */
static int hf_lte_rrc_interFreqExcludedCellList_r13;  /* InterFreqExcludedCellList_NB_r13 */
static int hf_lte_rrc_powerClass14dBm_Offset_r14_02;  /* T_powerClass14dBm_Offset_r14_02 */
static int hf_lte_rrc_ce_AuthorisationOffset_r14_01;  /* T_ce_AuthorisationOffset_r14_01 */
static int hf_lte_rrc_interFreqNeighCellList_v1530;  /* InterFreqNeighCellList_NB_v1530 */
static int hf_lte_rrc_dl_CarrierFreq_v1550;       /* CarrierFreq_NB_v1550 */
static int hf_lte_rrc_InterFreqNeighCellList_NB_r13_item;  /* PhysCellId */
static int hf_lte_rrc_InterFreqNeighCellList_NB_v1530_item;  /* InterFreqNeighCellInfo_NB_v1530 */
static int hf_lte_rrc_InterFreqExcludedCellList_NB_r13_item;  /* PhysCellId */
static int hf_lte_rrc_ab_Param_r13;               /* T_ab_Param_r13 */
static int hf_lte_rrc_ab_Common_r13;              /* AB_Config_NB_r13 */
static int hf_lte_rrc_ab_PerPLMN_List_r13;        /* SEQUENCE_SIZE_1_maxPLMN_r11_OF_AB_ConfigPLMN_NB_r13 */
static int hf_lte_rrc_ab_PerPLMN_List_r13_item;   /* AB_ConfigPLMN_NB_r13 */
static int hf_lte_rrc_ab_PerNRSRP_r15;            /* T_ab_PerNRSRP_r15 */
static int hf_lte_rrc_uac_Param_r16;              /* UAC_Param_NB_r16 */
static int hf_lte_rrc_ab_Config_r13;              /* AB_Config_NB_r13 */
static int hf_lte_rrc_ab_Category_r13;            /* T_ab_Category_r13 */
static int hf_lte_rrc_ab_BarringBitmap_r13;       /* BIT_STRING_SIZE_10 */
static int hf_lte_rrc_ab_BarringForExceptionData_r13;  /* T_ab_BarringForExceptionData_r13 */
static int hf_lte_rrc_ab_BarringForSpecialAC_r13;  /* BIT_STRING_SIZE_5 */
static int hf_lte_rrc_uac_BarringCommon;          /* UAC_Barring_NB_r16 */
static int hf_lte_rrc_uac_BarringPerPLMN_List;    /* SEQUENCE_SIZE_1_maxPLMN_r11_OF_UAC_Barring_NB_r16 */
static int hf_lte_rrc_uac_BarringPerPLMN_List_item;  /* UAC_Barring_NB_r16 */
static int hf_lte_rrc_uac_BarringPerCatList_r16;  /* UAC_BarringPerCatList_NB_r16 */
static int hf_lte_rrc_uac_AC1_SelectAssistInfo_r16_01;  /* UAC_AC1_SelectAssistInfo_r15 */
static int hf_lte_rrc_uac_BarringForAccessIdentity_r16;  /* BIT_STRING_SIZE_7 */
static int hf_lte_rrc_UAC_BarringPerCatList_NB_r16_item;  /* UAC_BarringPerCat_NB_r16 */
static int hf_lte_rrc_uac_accessCategory_r16;     /* INTEGER_1_maxAccessCat_1_r15 */
static int hf_lte_rrc_uac_BarringFactor_r16;      /* T_uac_BarringFactor_r16 */
static int hf_lte_rrc_uac_BarringTime_r16;        /* T_uac_BarringTime_r16 */
static int hf_lte_rrc_mbms_SAI_IntraFreq_r14;     /* MBMS_SAI_List_r11 */
static int hf_lte_rrc_mbms_SAI_InterFreqList_r14;  /* MBMS_SAI_InterFreqList_NB_r14 */
static int hf_lte_rrc_MBMS_SAI_InterFreqList_NB_r14_item;  /* MBMS_SAI_InterFreq_NB_r14 */
static int hf_lte_rrc_dl_CarrierFreq_r14;         /* CarrierFreq_NB_r13 */
static int hf_lte_rrc_mbms_SAI_List_r14;          /* MBMS_SAI_List_r11 */
static int hf_lte_rrc_multiBandInfoList_r14_01;   /* AdditionalBandInfoList_NB_r14 */
static int hf_lte_rrc_npdcch_SC_MCCH_Config_r14;  /* NPDCCH_SC_MCCH_Config_NB_r14 */
static int hf_lte_rrc_sc_mcch_CarrierConfig_r14;  /* T_sc_mcch_CarrierConfig_r14 */
static int hf_lte_rrc_dl_CarrierConfig_r14;       /* DL_CarrierConfigCommon_NB_r14 */
static int hf_lte_rrc_dl_CarrierIndex_r14;        /* INTEGER_0_maxNonAnchorCarriers_NB_r14 */
static int hf_lte_rrc_sc_mcch_RepetitionPeriod_r14;  /* T_sc_mcch_RepetitionPeriod_r14 */
static int hf_lte_rrc_sc_mcch_Offset_r14;         /* INTEGER_0_10 */
static int hf_lte_rrc_sc_mcch_ModificationPeriod_r14;  /* T_sc_mcch_ModificationPeriod_r14 */
static int hf_lte_rrc_sc_mcch_SchedulingInfo_r14_01;  /* SC_MCCH_SchedulingInfo_NB_r14 */
static int hf_lte_rrc_npdcch_NumRepetitions_SC_MCCH_r14;  /* T_npdcch_NumRepetitions_SC_MCCH_r14 */
static int hf_lte_rrc_npdcch_StartSF_SC_MCCH_r14;  /* T_npdcch_StartSF_SC_MCCH_r14 */
static int hf_lte_rrc_npdcch_Offset_SC_MCCH_r14;  /* T_npdcch_Offset_SC_MCCH_r14 */
static int hf_lte_rrc_onDurationTimerSCPTM_r14_02;  /* T_onDurationTimerSCPTM_r14_02 */
static int hf_lte_rrc_drx_InactivityTimerSCPTM_r14_02;  /* T_drx_InactivityTimerSCPTM_r14_02 */
static int hf_lte_rrc_schedulingPeriodStartOffsetSCPTM_r14_02;  /* T_schedulingPeriodStartOffsetSCPTM_r14_02 */
static int hf_lte_rrc_dl_ConfigList_r14;          /* DL_ConfigCommonList_NB_r14 */
static int hf_lte_rrc_ul_ConfigList_r14;          /* UL_ConfigCommonList_NB_r14 */
static int hf_lte_rrc_pagingWeightAnchor_r14;     /* PagingWeight_NB_r14 */
static int hf_lte_rrc_nprach_ProbabilityAnchorList_r14;  /* NPRACH_ProbabilityAnchorList_NB_r14 */
static int hf_lte_rrc_mixedOperationModeConfig_r15;  /* T_mixedOperationModeConfig_r15 */
static int hf_lte_rrc_dl_ConfigListMixed_r15;     /* DL_ConfigCommonList_NB_r14 */
static int hf_lte_rrc_ul_ConfigListMixed_r15;     /* UL_ConfigCommonList_NB_r14 */
static int hf_lte_rrc_pagingDistribution_r15;     /* T_pagingDistribution_r15 */
static int hf_lte_rrc_nprach_Distribution_r15;    /* T_nprach_Distribution_r15 */
static int hf_lte_rrc_ul_ConfigList_r15;          /* UL_ConfigCommonListTDD_NB_r15 */
static int hf_lte_rrc_coverageBasedPagingConfig_r17;  /* CoverageBasedPagingConfig_NB_r17 */
static int hf_lte_rrc_DL_ConfigCommonList_NB_r14_item;  /* DL_ConfigCommon_NB_r14 */
static int hf_lte_rrc_UL_ConfigCommonList_NB_r14_item;  /* UL_ConfigCommon_NB_r14 */
static int hf_lte_rrc_UL_ConfigCommonListTDD_NB_r15_item;  /* UL_ConfigCommonTDD_NB_r15 */
static int hf_lte_rrc_cbp_HystTimer_r17;          /* T_cbp_HystTimer_r17 */
static int hf_lte_rrc_cbp_ConfigList_r17;         /* SEQUENCE_SIZE_1_2_OF_CBP_Config_NB_r17 */
static int hf_lte_rrc_cbp_ConfigList_r17_item;    /* CBP_Config_NB_r17 */
static int hf_lte_rrc_nrsrpMin_r17;               /* RSRP_Range */
static int hf_lte_rrc_nB_r17;                     /* T_nB_r17 */
static int hf_lte_rrc_ue_SpecificDRX_CycleMin_r17;  /* T_ue_SpecificDRX_CycleMin_r17 */
static int hf_lte_rrc_pcch_Config_r14;            /* PCCH_Config_NB_r14 */
static int hf_lte_rrc_wus_Config_r15_01;          /* WUS_ConfigPerCarrier_NB_r15 */
static int hf_lte_rrc_gwus_Config_r16_01;         /* WUS_ConfigPerCarrier_NB_r15 */
static int hf_lte_rrc_pcch_Config_r17;            /* PCCH_Config_NB_r17 */
static int hf_lte_rrc_npdcch_NumRepetitionPaging_r14;  /* T_npdcch_NumRepetitionPaging_r14 */
static int hf_lte_rrc_pagingWeight_r14;           /* PagingWeight_NB_r14 */
static int hf_lte_rrc_npdcch_NumRepetitionPaging_r17;  /* T_npdcch_NumRepetitionPaging_r17 */
static int hf_lte_rrc_pagingWeight_r17;           /* PagingWeight_NB_r14 */
static int hf_lte_rrc_ul_CarrierFreq_r14_01;      /* CarrierFreq_NB_r13 */
static int hf_lte_rrc_nprach_ParametersList_r14;  /* NPRACH_ParametersList_NB_r14 */
static int hf_lte_rrc_nprach_ParametersListEDT_r15;  /* NPRACH_ParametersList_NB_r14 */
static int hf_lte_rrc_rsrp_ThresholdsPrachInfoList_r16;  /* RSRP_ThresholdsNPRACH_InfoList_NB_r13 */
static int hf_lte_rrc_nprach_ParametersListTDD_r15;  /* NPRACH_ParametersListTDD_NB_r15 */
static int hf_lte_rrc_NPRACH_ProbabilityAnchorList_NB_r14_item;  /* NPRACH_ProbabilityAnchor_NB_r14 */
static int hf_lte_rrc_nprach_ProbabilityAnchor_r14;  /* T_nprach_ProbabilityAnchor_r14 */
static int hf_lte_rrc_ul_ConfigList_v1530;        /* UL_ConfigCommonList_NB_v1530 */
static int hf_lte_rrc_ul_ConfigListMixed_v1530;   /* UL_ConfigCommonList_NB_v1530 */
static int hf_lte_rrc_UL_ConfigCommonList_NB_v1530_item;  /* UL_ConfigCommon_NB_v1530 */
static int hf_lte_rrc_nprach_ParametersListFmt2_r15;  /* NPRACH_ParametersListFmt2_NB_r15 */
static int hf_lte_rrc_nprach_ParametersListFmt2EDT_r15;  /* NPRACH_ParametersListFmt2_NB_r15 */
static int hf_lte_rrc_carrierFreqListEUTRA_r16;   /* CarrierFreqListEUTRA_NB_r16 */
static int hf_lte_rrc_carrierFreqsListGERAN_r16;  /* CarrierFreqsListGERAN_NB_r16 */
static int hf_lte_rrc_CarrierFreqListEUTRA_NB_r16_item;  /* CarrierFreqEUTRA_NB_r16 */
static int hf_lte_rrc_CarrierFreqsListGERAN_NB_r16_item;  /* CarrierFreqsGERAN_NB_r16 */
static int hf_lte_rrc_sib1_r16;                   /* T_sib1_r16 */
static int hf_lte_rrc_sib1_BR_r16;                /* T_sib1_BR_r16 */
static int hf_lte_rrc_carrierFreqs_r16;           /* CarrierFreqsGERAN */
static int hf_lte_rrc_ec_GSM_IOT_r16;             /* T_ec_GSM_IOT_r16 */
static int hf_lte_rrc_peo_r16;                    /* T_peo_r16 */
static int hf_lte_rrc_neighValidityDuration_r18_01;  /* T_neighValidityDuration_r18_01 */
static int hf_lte_rrc_dl_CarrierConfig_r13;       /* DL_CarrierConfigDedicated_NB_r13 */
static int hf_lte_rrc_ul_CarrierConfig_r13;       /* UL_CarrierConfigDedicated_NB_r13 */
static int hf_lte_rrc_downlinkBitmapNonAnchor_r13;  /* T_downlinkBitmapNonAnchor_r13 */
static int hf_lte_rrc_useNoBitmap_r13;            /* NULL */
static int hf_lte_rrc_useAnchorBitmap_r13;        /* NULL */
static int hf_lte_rrc_explicitBitmapConfiguration_r13;  /* DL_Bitmap_NB_r13 */
static int hf_lte_rrc_dl_GapNonAnchor_r13;        /* T_dl_GapNonAnchor_r13 */
static int hf_lte_rrc_useNoGap_r13;               /* NULL */
static int hf_lte_rrc_useAnchorGapConfig_r13;     /* NULL */
static int hf_lte_rrc_explicitGapConfiguration_r13;  /* DL_GapConfig_NB_r13 */
static int hf_lte_rrc_inbandCarrierInfo_r13;      /* T_inbandCarrierInfo_r13 */
static int hf_lte_rrc_samePCI_Indicator_r13;      /* T_samePCI_Indicator_r13 */
static int hf_lte_rrc_samePCI_r13;                /* T_samePCI_r13 */
static int hf_lte_rrc_indexToMidPRB_r13;          /* INTEGER_M55_54 */
static int hf_lte_rrc_differentPCI_r13;           /* T_differentPCI_r13 */
static int hf_lte_rrc_eutra_NumCRS_Ports_r13_01;  /* T_eutra_NumCRS_Ports_r13_01 */
static int hf_lte_rrc_eutraControlRegionSize_r13_01;  /* T_eutraControlRegionSize_r13_01 */
static int hf_lte_rrc_nrs_PowerOffsetNonAnchor_v1330;  /* T_nrs_PowerOffsetNonAnchor_v1330 */
static int hf_lte_rrc_dl_GapNonAnchor_v1530;      /* DL_GapConfig_NB_v1530 */
static int hf_lte_rrc_carrierFreqOffset_r13;      /* T_carrierFreqOffset_r13 */
static int hf_lte_rrc_carrierFreqOffset_v1550;    /* T_carrierFreqOffset_v1550 */
static int hf_lte_rrc_downlinkBitmapNonAnchor_r14;  /* T_downlinkBitmapNonAnchor_r14 */
static int hf_lte_rrc_useNoBitmap_r14;            /* NULL */
static int hf_lte_rrc_useAnchorBitmap_r14;        /* NULL */
static int hf_lte_rrc_explicitBitmapConfiguration_r14;  /* DL_Bitmap_NB_r13 */
static int hf_lte_rrc_dl_GapNonAnchor_r14;        /* T_dl_GapNonAnchor_r14 */
static int hf_lte_rrc_useNoGap_r14;               /* NULL */
static int hf_lte_rrc_useAnchorGapConfig_r14;     /* NULL */
static int hf_lte_rrc_explicitGapConfiguration_r14;  /* DL_GapConfig_NB_r13 */
static int hf_lte_rrc_inbandCarrierInfo_r14;      /* T_inbandCarrierInfo_r14 */
static int hf_lte_rrc_samePCI_Indicator_r14;      /* T_samePCI_Indicator_r14 */
static int hf_lte_rrc_samePCI_r14;                /* T_samePCI_r14 */
static int hf_lte_rrc_indexToMidPRB_r14;          /* INTEGER_M55_54 */
static int hf_lte_rrc_differentPCI_r14;           /* T_differentPCI_r14 */
static int hf_lte_rrc_eutra_NumCRS_Ports_r14;     /* T_eutra_NumCRS_Ports_r14 */
static int hf_lte_rrc_eutraControlRegionSize_r14;  /* T_eutraControlRegionSize_r14 */
static int hf_lte_rrc_nrs_PowerOffsetNonAnchor_r14;  /* T_nrs_PowerOffsetNonAnchor_r14 */
static int hf_lte_rrc_dl_GapThreshold_r13;        /* T_dl_GapThreshold_r13 */
static int hf_lte_rrc_dl_GapPeriodicity_r13;      /* T_dl_GapPeriodicity_r13 */
static int hf_lte_rrc_dl_GapDurationCoeff_r13;    /* T_dl_GapDurationCoeff_r13 */
static int hf_lte_rrc_dl_GapPeriodicity_v1530;    /* T_dl_GapPeriodicity_v1530 */
static int hf_lte_rrc_groupAlternation_r16_01;    /* T_groupAlternation_r16_01 */
static int hf_lte_rrc_commonSequence_r16_01;      /* T_commonSequence_r16_01 */
static int hf_lte_rrc_timeParameters_r16_01;      /* WUS_Config_NB_r15 */
static int hf_lte_rrc_resourceConfigDRX_r16_01;   /* GWUS_ResourceConfig_NB_r16 */
static int hf_lte_rrc_resourceConfig_eDRX_Short_r16_01;  /* GWUS_ResourceConfig_NB_r16 */
static int hf_lte_rrc_resourceConfig_eDRX_Long_r16_01;  /* GWUS_ResourceConfig_NB_r16 */
static int hf_lte_rrc_probThreshList_r16_01;      /* GWUS_ProbThreshList_NB_r16 */
static int hf_lte_rrc_resourcePosition_r16;       /* T_resourcePosition_r16 */
static int hf_lte_rrc_numGroupsList_r16_01;       /* GWUS_NumGroupsList_NB_r16 */
static int hf_lte_rrc_groupsForServiceList_r16_01;  /* GWUS_GroupsForServiceList_NB_r16 */
static int hf_lte_rrc_GWUS_ProbThreshList_NB_r16_item;  /* GWUS_Paging_ProbThresh_NB_r16 */
static int hf_lte_rrc_GWUS_NumGroupsList_NB_r16_item;  /* GWUS_NumGroups_NB_r16 */
static int hf_lte_rrc_GWUS_GroupsForServiceList_NB_r16_item;  /* INTEGER_1_maxGWUS_Groups_1_NB_r16 */
static int hf_lte_rrc_priority_r13;               /* T_priority_r13 */
static int hf_lte_rrc_logicalChannelSR_Prohibit_r13;  /* BOOLEAN */
static int hf_lte_rrc_ul_SCH_Config_r13;          /* T_ul_SCH_Config_r13 */
static int hf_lte_rrc_periodicBSR_Timer_r13;      /* PeriodicBSR_Timer_NB_r13 */
static int hf_lte_rrc_retxBSR_Timer_r13;          /* RetxBSR_Timer_NB_r13 */
static int hf_lte_rrc_drx_Config_r13_01;          /* DRX_Config_NB_r13 */
static int hf_lte_rrc_timeAlignmentTimerDedicated_r13;  /* TimeAlignmentTimer */
static int hf_lte_rrc_logicalChannelSR_Config_r13;  /* T_logicalChannelSR_Config_r13 */
static int hf_lte_rrc_mAC_MainConfig_NB_r13_logicalChannelSR_Config_r13_setup;  /* T_mAC_MainConfig_NB_r13_logicalChannelSR_Config_r13_setup */
static int hf_lte_rrc_logicalChannelSR_ProhibitTimer_r13;  /* T_logicalChannelSR_ProhibitTimer_r13 */
static int hf_lte_rrc_rai_Activation_r14_01;      /* T_rai_Activation_r14_01 */
static int hf_lte_rrc_dataInactivityTimerConfig_r14_01;  /* T_dataInactivityTimerConfig_r14_01 */
static int hf_lte_rrc_mAC_MainConfig_NB_r13_eag_1_dataInactivityTimerConfig_r14_setup;  /* T_mAC_MainConfig_NB_r13_eag_1_dataInactivityTimerConfig_r14_setup */
static int hf_lte_rrc_drx_Cycle_v1430;            /* T_drx_Cycle_v1430 */
static int hf_lte_rrc_ra_CFRA_Config_r14;         /* T_ra_CFRA_Config_r14 */
static int hf_lte_rrc_offsetThresholdTA_r17_01;   /* T_offsetThresholdTA_r17_01 */
static int hf_lte_rrc_setup_13;                   /* OffsetThresholdTA_NB_r17 */
static int hf_lte_rrc_dRX_Config_NB_r13_setup;    /* T_dRX_Config_NB_r13_setup */
static int hf_lte_rrc_onDurationTimer_r13;        /* T_onDurationTimer_r13 */
static int hf_lte_rrc_drx_InactivityTimer_r13;    /* T_drx_InactivityTimer_r13 */
static int hf_lte_rrc_drx_RetransmissionTimer_r13;  /* T_drx_RetransmissionTimer_r13 */
static int hf_lte_rrc_drx_Cycle_r13;              /* T_drx_Cycle_r13 */
static int hf_lte_rrc_drx_StartOffset_r13;        /* INTEGER_0_255 */
static int hf_lte_rrc_drx_ULRetransmissionTimer_r13_01;  /* T_drx_ULRetransmissionTimer_r13_01 */
static int hf_lte_rrc_npdcch_NumRepetitions_r13;  /* T_npdcch_NumRepetitions_r13 */
static int hf_lte_rrc_npdcch_StartSF_USS_r13;     /* T_npdcch_StartSF_USS_r13 */
static int hf_lte_rrc_npdcch_Offset_USS_r13;      /* T_npdcch_Offset_USS_r13 */
static int hf_lte_rrc_npdcch_StartSF_USS_v1530;   /* T_npdcch_StartSF_USS_v1530 */
static int hf_lte_rrc_nrs_Power_r13;              /* INTEGER_M60_50 */
static int hf_lte_rrc_npdsch_MultiTB_Config_r16;  /* NPDSCH_MultiTB_Config_NB_r16 */
static int hf_lte_rrc_multiTB_Config_r16;         /* T_multiTB_Config_r16 */
static int hf_lte_rrc_harq_AckBundling_r16_01;    /* T_harq_AckBundling_r16_01 */
static int hf_lte_rrc_npdsch_16QAM_Config_r17;    /* T_npdsch_16QAM_Config_r17 */
static int hf_lte_rrc_setup_14;                   /* NPDSCH_16QAM_Config_NB_r17 */
static int hf_lte_rrc_downlinkHARQ_FeedbackDisabledBitmap_NB_r18;  /* T_downlinkHARQ_FeedbackDisabledBitmap_NB_r18 */
static int hf_lte_rrc_setup_15;                   /* DownlinkHARQ_FeedbackDisabledBitmap_NB_r18 */
static int hf_lte_rrc_downlinkHARQ_FeedbackDisabledDCI_NB_r18;  /* T_downlinkHARQ_FeedbackDisabledDCI_NB_r18 */
static int hf_lte_rrc_nrs_PowerRatio_r17;         /* T_nrs_PowerRatio_r17 */
static int hf_lte_rrc_nrs_PowerRatioWithCRS_r17;  /* T_nrs_PowerRatioWithCRS_r17 */
static int hf_lte_rrc_nprach_CP_Length_r13;       /* T_nprach_CP_Length_r13 */
static int hf_lte_rrc_rsrp_ThresholdsPrachInfoList_r13_01;  /* RSRP_ThresholdsNPRACH_InfoList_NB_r13 */
static int hf_lte_rrc_nprach_ParametersList_r13;  /* NPRACH_ParametersList_NB_r13 */
static int hf_lte_rrc_nprach_ParametersList_v1330;  /* NPRACH_ParametersList_NB_v1330 */
static int hf_lte_rrc_maxNumPreambleAttemptCE_r14;  /* T_maxNumPreambleAttemptCE_r14 */
static int hf_lte_rrc_tdd_Parameters_r15_01;      /* T_tdd_Parameters_r15_01 */
static int hf_lte_rrc_nprach_PreambleFormat_r15;  /* T_nprach_PreambleFormat_r15 */
static int hf_lte_rrc_nPRACH_ConfigSIB_NB_v1530_tdd_Parameters_r15_dummy;  /* T_nPRACH_ConfigSIB_NB_v1530_tdd_Parameters_r15_dummy */
static int hf_lte_rrc_fmt2_Parameters_r15;        /* T_fmt2_Parameters_r15 */
static int hf_lte_rrc_edt_Parameters_r15_01;      /* T_edt_Parameters_r15_01 */
static int hf_lte_rrc_edt_SmallTBS_Subset_r15_01;  /* T_edt_SmallTBS_Subset_r15_01 */
static int hf_lte_rrc_edt_TBS_InfoList_r15;       /* EDT_TBS_InfoList_NB_r15 */
static int hf_lte_rrc_tdd_Parameters_v1550;       /* T_tdd_Parameters_v1550 */
static int hf_lte_rrc_nprach_ParametersListTDD_v1550;  /* NPRACH_ParametersListTDD_NB_v1550 */
static int hf_lte_rrc_NPRACH_ParametersList_NB_r13_item;  /* NPRACH_Parameters_NB_r13 */
static int hf_lte_rrc_NPRACH_ParametersList_NB_v1330_item;  /* NPRACH_Parameters_NB_v1330 */
static int hf_lte_rrc_nprach_Periodicity_r13;     /* T_nprach_Periodicity_r13 */
static int hf_lte_rrc_nprach_StartTime_r13;       /* T_nprach_StartTime_r13 */
static int hf_lte_rrc_nprach_SubcarrierOffset_r13;  /* T_nprach_SubcarrierOffset_r13 */
static int hf_lte_rrc_nprach_NumSubcarriers_r13;  /* T_nprach_NumSubcarriers_r13 */
static int hf_lte_rrc_nprach_SubcarrierMSG3_RangeStart_r13;  /* T_nprach_SubcarrierMSG3_RangeStart_r13 */
static int hf_lte_rrc_maxNumPreambleAttemptCE_r13_01;  /* T_maxNumPreambleAttemptCE_r13_01 */
static int hf_lte_rrc_numRepetitionsPerPreambleAttempt_r13;  /* T_numRepetitionsPerPreambleAttempt_r13 */
static int hf_lte_rrc_npdcch_NumRepetitions_RA_r13;  /* T_npdcch_NumRepetitions_RA_r13 */
static int hf_lte_rrc_npdcch_StartSF_CSS_RA_r13;  /* T_npdcch_StartSF_CSS_RA_r13 */
static int hf_lte_rrc_npdcch_Offset_RA_r13;       /* T_npdcch_Offset_RA_r13 */
static int hf_lte_rrc_nprach_NumCBRA_StartSubcarriers_r13;  /* T_nprach_NumCBRA_StartSubcarriers_r13 */
static int hf_lte_rrc_NPRACH_ParametersList_NB_r14_item;  /* NPRACH_Parameters_NB_r14 */
static int hf_lte_rrc_nprach_Parameters_r14;      /* T_nprach_Parameters_r14 */
static int hf_lte_rrc_nprach_Periodicity_r14;     /* T_nprach_Periodicity_r14 */
static int hf_lte_rrc_nprach_StartTime_r14;       /* T_nprach_StartTime_r14 */
static int hf_lte_rrc_nprach_SubcarrierOffset_r14;  /* T_nprach_SubcarrierOffset_r14 */
static int hf_lte_rrc_nprach_NumSubcarriers_r14;  /* T_nprach_NumSubcarriers_r14 */
static int hf_lte_rrc_nprach_SubcarrierMSG3_RangeStart_r14;  /* T_nprach_SubcarrierMSG3_RangeStart_r14 */
static int hf_lte_rrc_npdcch_NumRepetitions_RA_r14;  /* T_npdcch_NumRepetitions_RA_r14 */
static int hf_lte_rrc_npdcch_StartSF_CSS_RA_r14;  /* T_npdcch_StartSF_CSS_RA_r14 */
static int hf_lte_rrc_npdcch_Offset_RA_r14;       /* T_npdcch_Offset_RA_r14 */
static int hf_lte_rrc_nprach_NumCBRA_StartSubcarriers_r14;  /* T_nprach_NumCBRA_StartSubcarriers_r14 */
static int hf_lte_rrc_npdcch_CarrierIndex_r14;    /* INTEGER_1_maxNonAnchorCarriers_NB_r14 */
static int hf_lte_rrc_NPRACH_ParametersListTDD_NB_r15_item;  /* NPRACH_ParametersTDD_NB_r15 */
static int hf_lte_rrc_nprach_Parameters_r15;      /* T_nprach_Parameters_r15 */
static int hf_lte_rrc_nprach_Periodicity_r15;     /* T_nprach_Periodicity_r15 */
static int hf_lte_rrc_nprach_StartTime_r15;       /* T_nprach_StartTime_r15 */
static int hf_lte_rrc_nprach_SubcarrierOffset_r15;  /* T_nprach_SubcarrierOffset_r15 */
static int hf_lte_rrc_nprach_NumSubcarriers_r15;  /* T_nprach_NumSubcarriers_r15 */
static int hf_lte_rrc_nprach_SubcarrierMSG3_RangeStart_r15;  /* T_nprach_SubcarrierMSG3_RangeStart_r15 */
static int hf_lte_rrc_npdcch_NumRepetitions_RA_r15;  /* T_npdcch_NumRepetitions_RA_r15 */
static int hf_lte_rrc_npdcch_StartSF_CSS_RA_r15;  /* T_npdcch_StartSF_CSS_RA_r15 */
static int hf_lte_rrc_npdcch_Offset_RA_r15;       /* T_npdcch_Offset_RA_r15 */
static int hf_lte_rrc_nprach_NumCBRA_StartSubcarriers_r15;  /* T_nprach_NumCBRA_StartSubcarriers_r15 */
static int hf_lte_rrc_NPRACH_ParametersListTDD_NB_v1550_item;  /* NPRACH_ParametersTDD_NB_v1550 */
static int hf_lte_rrc_maxNumPreambleAttemptCE_v1550;  /* T_maxNumPreambleAttemptCE_v1550 */
static int hf_lte_rrc_numRepetitionsPerPreambleAttempt_v1550;  /* T_numRepetitionsPerPreambleAttempt_v1550 */
static int hf_lte_rrc_NPRACH_ParametersListFmt2_NB_r15_item;  /* NPRACH_ParametersFmt2_NB_r15 */
static int hf_lte_rrc_nprach_Parameters_r15_01;   /* T_nprach_Parameters_r15_01 */
static int hf_lte_rrc_nprach_Periodicity_r15_01;  /* T_nprach_Periodicity_r15_01 */
static int hf_lte_rrc_nprach_StartTime_r15_01;    /* T_nprach_StartTime_r15_01 */
static int hf_lte_rrc_nprach_SubcarrierOffset_r15_01;  /* T_nprach_SubcarrierOffset_r15_01 */
static int hf_lte_rrc_nprach_NumSubcarriers_r15_01;  /* T_nprach_NumSubcarriers_r15_01 */
static int hf_lte_rrc_nprach_SubcarrierMSG3_RangeStart_r15_01;  /* T_nprach_SubcarrierMSG3_RangeStart_r15_01 */
static int hf_lte_rrc_npdcch_NumRepetitions_RA_r15_01;  /* T_npdcch_NumRepetitions_RA_r15_01 */
static int hf_lte_rrc_npdcch_StartSF_CSS_RA_r15_01;  /* T_npdcch_StartSF_CSS_RA_r15_01 */
static int hf_lte_rrc_npdcch_Offset_RA_r15_01;    /* T_npdcch_Offset_RA_r15_01 */
static int hf_lte_rrc_nprach_NumCBRA_StartSubcarriers_r15_01;  /* T_nprach_NumCBRA_StartSubcarriers_r15_01 */
static int hf_lte_rrc_npdcch_CarrierIndex_r15;    /* INTEGER_1_maxNonAnchorCarriers_NB_r14 */
static int hf_lte_rrc_nprach_TxDurationFmt01_r17;  /* T_nprach_TxDurationFmt01_r17 */
static int hf_lte_rrc_nprach_TxDurationFmt2_r17;  /* T_nprach_TxDurationFmt2_r17 */
static int hf_lte_rrc_RSRP_ThresholdsNPRACH_InfoList_NB_r13_item;  /* RSRP_Range */
static int hf_lte_rrc_EDT_TBS_InfoList_NB_r15_item;  /* EDT_TBS_NB_r15 */
static int hf_lte_rrc_edt_TBS_r15_01;             /* T_edt_TBS_r15_01 */
static int hf_lte_rrc_ack_NACK_NumRepetitions_Msg4_r13;  /* SEQUENCE_SIZE_1_maxNPRACH_Resources_NB_r13_OF_ACK_NACK_NumRepetitions_NB_r13 */
static int hf_lte_rrc_ack_NACK_NumRepetitions_Msg4_r13_item;  /* ACK_NACK_NumRepetitions_NB_r13 */
static int hf_lte_rrc_srs_SubframeConfig_r13;     /* T_srs_SubframeConfig_r13 */
static int hf_lte_rrc_dmrs_Config_r13;            /* T_dmrs_Config_r13 */
static int hf_lte_rrc_threeTone_BaseSequence_r13;  /* INTEGER_0_12 */
static int hf_lte_rrc_threeTone_CyclicShift_r13;  /* INTEGER_0_2 */
static int hf_lte_rrc_sixTone_BaseSequence_r13;   /* INTEGER_0_14 */
static int hf_lte_rrc_sixTone_CyclicShift_r13;    /* INTEGER_0_3 */
static int hf_lte_rrc_twelveTone_BaseSequence_r13;  /* INTEGER_0_30 */
static int hf_lte_rrc_ul_ReferenceSignalsNPUSCH_r13;  /* UL_ReferenceSignalsNPUSCH_NB_r13 */
static int hf_lte_rrc_groupHoppingEnabled_r13;    /* BOOLEAN */
static int hf_lte_rrc_groupAssignmentNPUSCH_r13;  /* INTEGER_0_29 */
static int hf_lte_rrc_ack_NACK_NumRepetitions_r13;  /* ACK_NACK_NumRepetitions_NB_r13 */
static int hf_lte_rrc_npusch_AllSymbols_r13;      /* BOOLEAN */
static int hf_lte_rrc_groupHoppingDisabled_r13_01;  /* T_groupHoppingDisabled_r13_01 */
static int hf_lte_rrc_npusch_MultiTB_Config_r16;  /* T_npusch_MultiTB_Config_r16 */
static int hf_lte_rrc_npusch_16QAM_Config_r17;    /* T_npusch_16QAM_Config_r17 */
static int hf_lte_rrc_uplinkHARQ_Mode_r18_01;     /* T_uplinkHARQ_Mode_r18_01 */
static int hf_lte_rrc_setup_16;                   /* UplinkHARQ_Mode_NB_r18 */
static int hf_lte_rrc_npusch_TxDuration_r17;      /* T_npusch_TxDuration_r17 */
static int hf_lte_rrc_discardTimer_r13;           /* T_discardTimer_r13 */
static int hf_lte_rrc_headerCompression_r13;      /* T_headerCompression_r13 */
static int hf_lte_rrc_rohc_01;                    /* T_rohc_01 */
static int hf_lte_rrc_maxCID_r13;                 /* INTEGER_1_16383 */
static int hf_lte_rrc_profiles_r13;               /* T_profiles_r13 */
static int hf_lte_rrc_cipheringDisabled_r16;      /* T_cipheringDisabled_r16 */
static int hf_lte_rrc_carrierConfigDedicated_r13;  /* CarrierConfigDedicated_NB_r13 */
static int hf_lte_rrc_npdcch_ConfigDedicated_r13;  /* NPDCCH_ConfigDedicated_NB_r13 */
static int hf_lte_rrc_npusch_ConfigDedicated_r13;  /* NPUSCH_ConfigDedicated_NB_r13 */
static int hf_lte_rrc_uplinkPowerControlDedicated_r13_01;  /* UplinkPowerControlDedicated_NB_r13 */
static int hf_lte_rrc_twoHARQ_ProcessesConfig_r14;  /* T_twoHARQ_ProcessesConfig_r14 */
static int hf_lte_rrc_interferenceRandomisationConfig_r14;  /* T_interferenceRandomisationConfig_r14 */
static int hf_lte_rrc_npdcch_ConfigDedicated_v1530;  /* NPDCCH_ConfigDedicated_NB_v1530 */
static int hf_lte_rrc_additionalTxSIB1_Config_v1540;  /* T_additionalTxSIB1_Config_v1540 */
static int hf_lte_rrc_npusch_ConfigDedicated_v1610;  /* NPUSCH_ConfigDedicated_NB_v1610 */
static int hf_lte_rrc_npdsch_ConfigDedicated_r16;  /* NPDSCH_ConfigDedicated_NB_r16 */
static int hf_lte_rrc_resourceReservationConfigDL_r16;  /* T_resourceReservationConfigDL_r16 */
static int hf_lte_rrc_physicalConfigDedicated_NB_r13_eag_5_resourceReservationConfigDL_r16_setup;  /* ResourceReservationConfig_NB_r16 */
static int hf_lte_rrc_resourceReservationConfigUL_r16;  /* T_resourceReservationConfigUL_r16 */
static int hf_lte_rrc_physicalConfigDedicated_NB_r13_eag_5_resourceReservationConfigUL_r16_setup;  /* ResourceReservationConfig_NB_r16 */
static int hf_lte_rrc_ntn_ConfigDedicated_r17_01;  /* T_ntn_ConfigDedicated_r17_01 */
static int hf_lte_rrc_npusch_TxDuration_r17_01;   /* T_npusch_TxDuration_r17_01 */
static int hf_lte_rrc_setup_17;                   /* NPUSCH_TxDuration_NB_r17 */
static int hf_lte_rrc_npdsch_ConfigDedicated_v1700;  /* NPDSCH_ConfigDedicated_NB_v1710 */
static int hf_lte_rrc_uplinkPowerControlDedicated_v1700;  /* UplinkPowerControlDedicated_NB_v1700 */
static int hf_lte_rrc_uplinkSegmentedPrecompensationGap_r17_01;  /* T_uplinkSegmentedPrecompensationGap_r17_01 */
static int hf_lte_rrc_npusch_ConfigDedicated_v1740;  /* NPUSCH_ConfigDedicated_NB_v1700 */
static int hf_lte_rrc_npdsch_ConfigDedicated_v1800;  /* NPDSCH_ConfigDedicated_NB_v1800 */
static int hf_lte_rrc_npusch_ConfigDedicated_v1800;  /* NPUSCH_ConfigDedicated_NB_v1800 */
static int hf_lte_rrc_pur_NRSRP_ChangeThreshold_r16;  /* T_pur_NRSRP_ChangeThreshold_r16 */
static int hf_lte_rrc_pUR_Config_NB_r16_pur_NRSRP_ChangeThreshold_r16_setup;  /* PUR_NRSRP_ChangeThreshold_NB_r16 */
static int hf_lte_rrc_pur_ImplicitReleaseAfter_r16_01;  /* T_pur_ImplicitReleaseAfter_r16_01 */
static int hf_lte_rrc_pur_ResponseWindowTimer_r16_01;  /* T_pur_ResponseWindowTimer_r16_01 */
static int hf_lte_rrc_pur_StartTimeParameters_r16_01;  /* T_pur_StartTimeParameters_r16_01 */
static int hf_lte_rrc_periodicityAndOffset_r16_01;  /* PUR_PeriodicityAndOffset_NB_r16 */
static int hf_lte_rrc_startSubframe_r16;          /* INTEGER_0_9 */
static int hf_lte_rrc_pur_NumOccasions_r16_01;    /* T_pur_NumOccasions_r16_01 */
static int hf_lte_rrc_pur_PhysicalConfig_r16;     /* T_pur_PhysicalConfig_r16 */
static int hf_lte_rrc_carrierConfig_r16;          /* CarrierConfigDedicated_NB_r13 */
static int hf_lte_rrc_npusch_NumRUsIndex_r16;     /* INTEGER_0_7 */
static int hf_lte_rrc_npusch_NumRepetitionsIndex_r16;  /* INTEGER_0_7 */
static int hf_lte_rrc_npusch_SubCarrierSetIndex_r16;  /* T_npusch_SubCarrierSetIndex_r16 */
static int hf_lte_rrc_khz15;                      /* INTEGER_0_18 */
static int hf_lte_rrc_khz3dot75;                  /* INTEGER_0_47 */
static int hf_lte_rrc_npusch_MCS_r16;             /* T_npusch_MCS_r16 */
static int hf_lte_rrc_singleTone;                 /* INTEGER_0_10 */
static int hf_lte_rrc_multiTone;                  /* INTEGER_0_13 */
static int hf_lte_rrc_p0_UE_NPUSCH_r16;           /* INTEGER_M8_7 */
static int hf_lte_rrc_alpha_r16_01;               /* T_alpha_r16 */
static int hf_lte_rrc_npusch_CyclicShift_r16;     /* T_npusch_CyclicShift_r16 */
static int hf_lte_rrc_npdcch_Config_r16;          /* NPDCCH_ConfigDedicated_NB_r13 */
static int hf_lte_rrc_pur_PhysicalConfig_v1650;   /* T_pur_PhysicalConfig_v1650 */
static int hf_lte_rrc_ack_NACK_NumRepetitions_r16;  /* ACK_NACK_NumRepetitions_NB_r13 */
static int hf_lte_rrc_pur_PhysicalConfig_v1700;   /* T_pur_PhysicalConfig_v1700 */
static int hf_lte_rrc_pur_UL_16QAM_Config_r17;    /* T_pur_UL_16QAM_Config_r17 */
static int hf_lte_rrc_setup_18;                   /* PUR_UL_16QAM_Config_NB_r17 */
static int hf_lte_rrc_pur_DL_16QAM_Config_r17;    /* T_pur_DL_16QAM_Config_r17 */
static int hf_lte_rrc_increaseThresh_r16_01;      /* NRSRP_ChangeThresh_NB_r16 */
static int hf_lte_rrc_decreaseThresh_r16_01;      /* NRSRP_ChangeThresh_NB_r16 */
static int hf_lte_rrc_uplinkPowerControlDedicated_r17;  /* UplinkPowerControlDedicated_NB_v1700 */
static int hf_lte_rrc_periodicity256_01;          /* INTEGER_1_257 */
static int hf_lte_rrc_powerRampingParameters_r13;  /* PowerRampingParameters */
static int hf_lte_rrc_rach_InfoList_r13;          /* RACH_InfoList_NB_r13 */
static int hf_lte_rrc_connEstFailOffset_r13;      /* INTEGER_0_15 */
static int hf_lte_rrc_powerRampingParameters_v1450;  /* PowerRampingParameters_NB_v1450 */
static int hf_lte_rrc_rach_InfoList_v1530;        /* RACH_InfoList_NB_v1530 */
static int hf_lte_rrc_RACH_InfoList_NB_r13_item;  /* RACH_Info_NB_r13 */
static int hf_lte_rrc_RACH_InfoList_NB_v1530_item;  /* RACH_Info_NB_v1530 */
static int hf_lte_rrc_ra_ResponseWindowSize_r13_01;  /* T_ra_ResponseWindowSize_r13_01 */
static int hf_lte_rrc_mac_ContentionResolutionTimer_r13_01;  /* T_mac_ContentionResolutionTimer_r13_01 */
static int hf_lte_rrc_mac_ContentionResolutionTimer_r15_01;  /* T_mac_ContentionResolutionTimer_r15_01 */
static int hf_lte_rrc_preambleInitialReceivedTargetPower_v1450;  /* T_preambleInitialReceivedTargetPower_v1450 */
static int hf_lte_rrc_powerRampingParametersCE1_r14;  /* T_powerRampingParametersCE1_r14 */
static int hf_lte_rrc_powerRampingStepCE1_r14;    /* T_powerRampingStepCE1_r14 */
static int hf_lte_rrc_preambleInitialReceivedTargetPowerCE1_r14;  /* T_preambleInitialReceivedTargetPowerCE1_r14 */
static int hf_lte_rrc_rach_ConfigCommon_r13;      /* RACH_ConfigCommon_NB_r13 */
static int hf_lte_rrc_bcch_Config_r13;            /* BCCH_Config_NB_r13 */
static int hf_lte_rrc_pcch_Config_r13;            /* PCCH_Config_NB_r13 */
static int hf_lte_rrc_nprach_Config_r13;          /* NPRACH_ConfigSIB_NB_r13 */
static int hf_lte_rrc_npdsch_ConfigCommon_r13;    /* NPDSCH_ConfigCommon_NB_r13 */
static int hf_lte_rrc_npusch_ConfigCommon_r13;    /* NPUSCH_ConfigCommon_NB_r13 */
static int hf_lte_rrc_dl_Gap_r13;                 /* DL_GapConfig_NB_r13 */
static int hf_lte_rrc_uplinkPowerControlCommon_r13;  /* UplinkPowerControlCommon_NB_r13 */
static int hf_lte_rrc_nprach_Config_v1330;        /* NPRACH_ConfigSIB_NB_v1330 */
static int hf_lte_rrc_nprach_Config_v1450;        /* NPRACH_ConfigSIB_NB_v1450 */
static int hf_lte_rrc_nprach_Config_v1530;        /* NPRACH_ConfigSIB_NB_v1530 */
static int hf_lte_rrc_dl_Gap_v1530;               /* DL_GapConfig_NB_v1530 */
static int hf_lte_rrc_wus_Config_r15_02;          /* WUS_Config_NB_r15 */
static int hf_lte_rrc_nprach_Config_v1550;        /* NPRACH_ConfigSIB_NB_v1550 */
static int hf_lte_rrc_gwus_Config_r16_02;         /* GWUS_Config_NB_r16 */
static int hf_lte_rrc_nrs_NonAnchorConfig_r16;    /* T_nrs_NonAnchorConfig_r16 */
static int hf_lte_rrc_ue_SpecificDRX_CycleMin_r16;  /* T_ue_SpecificDRX_CycleMin_r16 */
static int hf_lte_rrc_ntn_ConfigCommon_r17_02;    /* T_ntn_ConfigCommon_r17_02 */
static int hf_lte_rrc_ta_Report_r17_02;           /* T_ta_Report_r17_02 */
static int hf_lte_rrc_t318_r17_02;                /* T_t318_r17_02 */
static int hf_lte_rrc_nprach_TxDurationFmt01_r17_01;  /* NPRACH_TxDurationFmt01_NB_r17 */
static int hf_lte_rrc_nprach_TxDurationFmt2_r17_01;  /* NPRACH_TxDurationFmt2_NB_r17 */
static int hf_lte_rrc_npusch_TxDuration_r17_02;   /* NPUSCH_TxDuration_NB_r17 */
static int hf_lte_rrc_modificationPeriodCoeff_r13;  /* T_modificationPeriodCoeff_r13 */
static int hf_lte_rrc_defaultPagingCycle_r13;     /* T_defaultPagingCycle_r13 */
static int hf_lte_rrc_nB_r13;                     /* T_nB_r13 */
static int hf_lte_rrc_npdcch_NumRepetitionPaging_r13_01;  /* T_npdcch_NumRepetitionPaging_r13 */
static int hf_lte_rrc_srb_ToAddModList_r13;       /* SRB_ToAddModList_NB_r13 */
static int hf_lte_rrc_drb_ToAddModList_r13;       /* DRB_ToAddModList_NB_r13 */
static int hf_lte_rrc_drb_ToReleaseList_r13;      /* DRB_ToReleaseList_NB_r13 */
static int hf_lte_rrc_mac_MainConfig_r13;         /* T_mac_MainConfig_r13 */
static int hf_lte_rrc_explicitValue_r13;          /* MAC_MainConfig_NB_r13 */
static int hf_lte_rrc_defaultValue_r13;           /* NULL */
static int hf_lte_rrc_physicalConfigDedicated_r13;  /* PhysicalConfigDedicated_NB_r13 */
static int hf_lte_rrc_rlf_TimersAndConstants_r13_01;  /* RLF_TimersAndConstants_NB_r13 */
static int hf_lte_rrc_schedulingRequestConfig_r15;  /* SchedulingRequestConfig_NB_r15 */
static int hf_lte_rrc_gnss_AutonomousEnabled_r18_01;  /* T_gnss_AutonomousEnabled_r18_01 */
static int hf_lte_rrc_ul_TransmissionExtensionEnabled_r18_01;  /* T_ul_TransmissionExtensionEnabled_r18_01 */
static int hf_lte_rrc_ul_TransmissionExtensionValue_r18_01;  /* T_ul_TransmissionExtensionValue_r18_01 */
static int hf_lte_rrc_SRB_ToAddModList_NB_r13_item;  /* SRB_ToAddMod_NB_r13 */
static int hf_lte_rrc_rlc_Config_r13;             /* T_rlc_Config_r13 */
static int hf_lte_rrc_explicitValue_07;           /* RLC_Config_NB_r13 */
static int hf_lte_rrc_logicalChannelConfig_r13;   /* T_logicalChannelConfig_r13 */
static int hf_lte_rrc_explicitValue_08;           /* LogicalChannelConfig_NB_r13 */
static int hf_lte_rrc_rlc_Config_v1430_01;        /* RLC_Config_NB_v1430 */
static int hf_lte_rrc_rlc_Config_v1700_01;        /* RLC_Config_NB_v1700 */
static int hf_lte_rrc_DRB_ToAddModList_NB_r13_item;  /* DRB_ToAddMod_NB_r13 */
static int hf_lte_rrc_eps_BearerIdentity_r13;     /* INTEGER_0_15 */
static int hf_lte_rrc_drb_Identity_r13;           /* DRB_Identity */
static int hf_lte_rrc_pdcp_Config_r13;            /* PDCP_Config_NB_r13 */
static int hf_lte_rrc_rlc_Config_r13_01;          /* RLC_Config_NB_r13 */
static int hf_lte_rrc_logicalChannelIdentity_r13;  /* T_logicalChannelIdentity_r13 */
static int hf_lte_rrc_logicalChannelConfig_r13_01;  /* LogicalChannelConfig_NB_r13 */
static int hf_lte_rrc_pdu_Session_r16;            /* PDU_SessionID_NB_r16 */
static int hf_lte_rrc_DRB_ToReleaseList_NB_r13_item;  /* DRB_Identity */
static int hf_lte_rrc_periodicity_r16_01;         /* T_periodicity_r16_01 */
static int hf_lte_rrc_startPosition_r16;          /* INTEGER_0_15 */
static int hf_lte_rrc_resourceReservation_r16;    /* T_resourceReservation_r16 */
static int hf_lte_rrc_subframeBitmap_r16;         /* T_subframeBitmap_r16 */
static int hf_lte_rrc_subframePattern10ms;        /* BIT_STRING_SIZE_10 */
static int hf_lte_rrc_subframePattern40ms;        /* BIT_STRING_SIZE_40 */
static int hf_lte_rrc_slotConfig_r16;             /* T_slotConfig_r16 */
static int hf_lte_rrc_slotBitmap_r16_02;          /* T_slotBitmap_r16_02 */
static int hf_lte_rrc_symbolBitmap_r16;           /* T_symbolBitmap_r16 */
static int hf_lte_rrc_symbolBitmapFddDl;          /* T_symbolBitmapFddDl */
static int hf_lte_rrc_symbolBitmap1_r16_01;       /* BIT_STRING_SIZE_5 */
static int hf_lte_rrc_symbolBitmap2_r16_01;       /* BIT_STRING_SIZE_5 */
static int hf_lte_rrc_symbolBitmapFddUlOrTdd;     /* T_symbolBitmapFddUlOrTdd */
static int hf_lte_rrc_am_01;                      /* T_am_01 */
static int hf_lte_rrc_ul_AM_RLC_r13;              /* UL_AM_RLC_NB_r13 */
static int hf_lte_rrc_dl_AM_RLC_r13;              /* DL_AM_RLC_NB_r13 */
static int hf_lte_rrc_um_Bi_Directional_r15_01;   /* T_um_Bi_Directional_r15_01 */
static int hf_lte_rrc_um_Uni_Directional_UL_r15_01;  /* T_um_Uni_Directional_UL_r15_01 */
static int hf_lte_rrc_um_Uni_Directional_DL_r15_01;  /* T_um_Uni_Directional_DL_r15_01 */
static int hf_lte_rrc_t_Reordering_r14;           /* T_Reordering */
static int hf_lte_rrc_t_ReorderingExt_r17_01;     /* T_t_ReorderingExt_r17_01 */
static int hf_lte_rrc_t_PollRetransmit_r13;       /* T_PollRetransmit_NB_r13 */
static int hf_lte_rrc_maxRetxThreshold_r13;       /* T_maxRetxThreshold_r13 */
static int hf_lte_rrc_enableStatusReportSN_Gap_r13;  /* T_enableStatusReportSN_Gap_r13 */
static int hf_lte_rrc_rLF_TimersAndConstants_NB_r13_setup;  /* T_rLF_TimersAndConstants_NB_r13_setup */
static int hf_lte_rrc_t301_r13;                   /* T_t301_r13 */
static int hf_lte_rrc_t310_r13;                   /* T_t310_r13 */
static int hf_lte_rrc_n310_r13;                   /* T_n310_r13 */
static int hf_lte_rrc_t311_r13;                   /* T_t311_r13 */
static int hf_lte_rrc_n311_r13;                   /* T_n311_r13 */
static int hf_lte_rrc_t311_v1350;                 /* T_t311_v1350 */
static int hf_lte_rrc_t301_v1530;                 /* T_t301_v1530 */
static int hf_lte_rrc_t311_v1530;                 /* T_t311_v1530 */
static int hf_lte_rrc_sr_WithHARQ_ACK_Config_r15;  /* T_sr_WithHARQ_ACK_Config_r15 */
static int hf_lte_rrc_sr_WithoutHARQ_ACK_Config_r15;  /* SR_WithoutHARQ_ACK_Config_NB_r15 */
static int hf_lte_rrc_sr_SPS_BSR_Config_r15;      /* SR_SPS_BSR_Config_NB_r15 */
static int hf_lte_rrc_sr_WithoutHARQ_ACK_Config_v1700;  /* SR_WithoutHARQ_ACK_Config_NB_v1700 */
static int hf_lte_rrc_sR_WithoutHARQ_ACK_Config_NB_r15_setup;  /* T_sR_WithoutHARQ_ACK_Config_NB_r15_setup */
static int hf_lte_rrc_sr_ProhibitTimer_r15;       /* INTEGER_0_7 */
static int hf_lte_rrc_sr_NPRACH_Resource_r15;     /* SR_NPRACH_Resource_NB_r15 */
static int hf_lte_rrc_sr_ProhibitTimerOffset_r17_01;  /* T_sr_ProhibitTimerOffset_r17_01 */
static int hf_lte_rrc_setup_19;                   /* SR_ProhibitTimerOffset_NB_r17 */
static int hf_lte_rrc_nprach_CarrierIndex_r15;    /* INTEGER_0_maxNonAnchorCarriers_NB_r14 */
static int hf_lte_rrc_nprach_ResourceIndex_r15;   /* INTEGER_1_maxNPRACH_Resources_NB_r13 */
static int hf_lte_rrc_nprach_SubCarrierIndex_r15;  /* T_nprach_SubCarrierIndex_r15 */
static int hf_lte_rrc_nprach_Fmt0Fmt1_r15;        /* INTEGER_0_47 */
static int hf_lte_rrc_nprach_Fmt2_r15;            /* INTEGER_0_143 */
static int hf_lte_rrc_p0_SR_r15;                  /* INTEGER_M126_24 */
static int hf_lte_rrc_alpha_r15;                  /* T_alpha_r15 */
static int hf_lte_rrc_sR_SPS_BSR_Config_NB_r15_setup;  /* T_sR_SPS_BSR_Config_NB_r15_setup */
static int hf_lte_rrc_semiPersistSchedIntervalUL_r15;  /* T_semiPersistSchedIntervalUL_r15 */
static int hf_lte_rrc_subframeAssignment_r15_01;  /* T_subframeAssignment_r15 */
static int hf_lte_rrc_specialSubframePatterns_r15;  /* T_specialSubframePatterns_r15 */
static int hf_lte_rrc_p0_NominalNPUSCH_r13;       /* INTEGER_M126_24 */
static int hf_lte_rrc_alpha_r13;                  /* T_alpha_r13 */
static int hf_lte_rrc_deltaPreambleMsg3_r13;      /* INTEGER_M1_6 */
static int hf_lte_rrc_p0_UE_NPUSCH_r13;           /* INTEGER_M8_7 */
static int hf_lte_rrc_deltaMCS_Enabled_r17;       /* T_deltaMCS_Enabled_r17 */
static int hf_lte_rrc_maxDurationFactor_r15_01;   /* WUS_MaxDurationFactor_NB_r15 */
static int hf_lte_rrc_numPOs_r15_01;              /* T_numPOs_r15_01 */
static int hf_lte_rrc_numDRX_CyclesRelaxed_r15;   /* T_numDRX_CyclesRelaxed_r15 */
static int hf_lte_rrc_timeOffsetDRX_r15_01;       /* T_timeOffsetDRX_r15_01 */
static int hf_lte_rrc_timeOffset_eDRX_Short_r15_01;  /* T_timeOffset_eDRX_Short_r15_01 */
static int hf_lte_rrc_timeOffset_eDRX_Long_r15_01;  /* T_timeOffset_eDRX_Long_r15_01 */
static int hf_lte_rrc_AdditionalBandInfoList_NB_r14_item;  /* FreqBandIndicator_NB_r13 */
static int hf_lte_rrc_MultiBandInfoList_NB_r13_item;  /* MultiBandInfo_NB_r13 */
static int hf_lte_rrc_NS_PmaxList_NB_r13_item;    /* NS_PmaxValue_NB_r13 */
static int hf_lte_rrc_additionalPmax_r13;         /* P_Max */
static int hf_lte_rrc_anr_QualityThreshold_r16;   /* NRSRP_Range_NB_r14 */
static int hf_lte_rrc_anr_CarrierList_r16;        /* ANR_CarrierList_NB_r16 */
static int hf_lte_rrc_ANR_CarrierList_NB_r16_item;  /* ANR_Carrier_NB_r16 */
static int hf_lte_rrc_carrierFreqIndex_r16;       /* INTEGER_1_maxFreq */
static int hf_lte_rrc_excludedCellList_r16;       /* ANR_ExcludedCellList_NB_r16 */
static int hf_lte_rrc_ANR_ExcludedCellList_NB_r16_item;  /* PhysCellId */
static int hf_lte_rrc_servCellIdentity_r16;       /* CellGlobalIdEUTRA */
static int hf_lte_rrc_measResultServCell_r16;     /* MeasResultServCell_NB_r14 */
static int hf_lte_rrc_relativeTimeStamp_r16;      /* INTEGER_0_95 */
static int hf_lte_rrc_measResultList_r16;         /* SEQUENCE_SIZE_1_maxFreqANR_NB_r16_OF_ANR_MeasResult_NB_r16 */
static int hf_lte_rrc_measResultList_r16_item;    /* ANR_MeasResult_NB_r16 */
static int hf_lte_rrc_carrierFreq_r16_02;         /* CarrierFreq_NB_r13 */
static int hf_lte_rrc_measResultLastServCell_r16_01;  /* MeasResultServCell_NB_r14 */
static int hf_lte_rrc_measResult_r16;             /* NRSRP_Range_NB_r14 */
static int hf_lte_rrc_cgi_Info_r16;               /* T_cgi_Info_r16 */
static int hf_lte_rrc_trackingAreaCode_r16_01;    /* TrackingAreaCode */
static int hf_lte_rrc_plmn_IdentityList_r16_01;   /* PLMN_IdentityList2 */
static int hf_lte_rrc_nrsrpResult_r14;            /* NRSRP_Range_NB_r14 */
static int hf_lte_rrc_nrsrqResult_r14;            /* NRSRQ_Range_NB_r14 */
static int hf_lte_rrc_nsss_RRM_PowerOffset_r15;   /* T_nsss_RRM_PowerOffset_r15 */
static int hf_lte_rrc_nsss_NumOccDiffPrecoders_r15;  /* T_nsss_NumOccDiffPrecoders_r15 */
static int hf_lte_rrc_accessStratumRelease_r13;   /* AccessStratumRelease_NB_r13 */
static int hf_lte_rrc_ue_Category_NB_r13;         /* T_ue_Category_NB_r13 */
static int hf_lte_rrc_multipleDRB_r13;            /* T_multipleDRB_r13 */
static int hf_lte_rrc_pdcp_Parameters_r13;        /* PDCP_Parameters_NB_r13 */
static int hf_lte_rrc_phyLayerParameters_r13;     /* PhyLayerParameters_NB_r13 */
static int hf_lte_rrc_rf_Parameters_r13;          /* RF_Parameters_NB_r13 */
static int hf_lte_rrc_uE_Capability_NB_r13_dummy;  /* T_uE_Capability_NB_r13_dummy */
static int hf_lte_rrc_ue_Category_NB_r14;         /* T_ue_Category_NB_r14 */
static int hf_lte_rrc_mac_Parameters_r14;         /* MAC_Parameters_NB_r14 */
static int hf_lte_rrc_phyLayerParameters_v1430_01;  /* PhyLayerParameters_NB_v1430 */
static int hf_lte_rrc_rf_Parameters_v1430_01;     /* RF_Parameters_NB_v1430 */
static int hf_lte_rrc_nonCriticalExtension_438;   /* UE_Capability_NB_v1440_IEs */
static int hf_lte_rrc_phyLayerParameters_v1440;   /* PhyLayerParameters_NB_v1440 */
static int hf_lte_rrc_nonCriticalExtension_439;   /* UE_Capability_NB_v14x0_IEs */
static int hf_lte_rrc_nonCriticalExtension_440;   /* UE_Capability_NB_v1530_IEs */
static int hf_lte_rrc_earlyData_UP_r15_01;        /* T_earlyData_UP_r15_01 */
static int hf_lte_rrc_rlc_Parameters_r15;         /* RLC_Parameters_NB_r15 */
static int hf_lte_rrc_mac_Parameters_v1530_01;    /* MAC_Parameters_NB_v1530 */
static int hf_lte_rrc_phyLayerParameters_v1530_01;  /* PhyLayerParameters_NB_v1530 */
static int hf_lte_rrc_tdd_UE_Capability_r15;      /* TDD_UE_Capability_NB_r15 */
static int hf_lte_rrc_nonCriticalExtension_441;   /* UE_Capability_NB_v15x0_IEs */
static int hf_lte_rrc_nonCriticalExtension_442;   /* UE_Capability_NB_v1610_IEs */
static int hf_lte_rrc_earlySecurityReactivation_r16_03;  /* T_earlySecurityReactivation_r16_03 */
static int hf_lte_rrc_earlyData_UP_5GC_r16_01;    /* T_earlyData_UP_5GC_r16_01 */
static int hf_lte_rrc_pur_Parameters_r16_01;      /* PUR_Parameters_NB_r16 */
static int hf_lte_rrc_mac_Parameters_v1610_01;    /* MAC_Parameters_NB_v1610 */
static int hf_lte_rrc_phyLayerParameters_v1610_01;  /* PhyLayerParameters_NB_v1610 */
static int hf_lte_rrc_son_Parameters_r16;         /* SON_Parameters_NB_r16 */
static int hf_lte_rrc_measParameters_r16;         /* MeasParameters_NB_r16 */
static int hf_lte_rrc_tdd_UE_Capability_v1610;    /* TDD_UE_Capability_NB_v1610 */
static int hf_lte_rrc_nonCriticalExtension_443;   /* UE_Capability_NB_v16x0_IEs */
static int hf_lte_rrc_lateNonCriticalExtension_15;  /* T_lateNonCriticalExtension_14 */
static int hf_lte_rrc_nonCriticalExtension_444;   /* UE_Capability_NB_v1700_IEs */
static int hf_lte_rrc_son_Parameters_v16f0;       /* SON_Parameters_NB_v16f0 */
static int hf_lte_rrc_nonCriticalExtension_445;   /* T_nonCriticalExtension_113 */
static int hf_lte_rrc_coverageBasedPaging_r17;    /* T_coverageBasedPaging_r17 */
static int hf_lte_rrc_phyLayerParameters_v1700_01;  /* PhyLayerParameters_NB_v1700 */
static int hf_lte_rrc_ntn_Parameters_r17_01;      /* NTN_Parameters_NB_r17 */
static int hf_lte_rrc_nonCriticalExtension_446;   /* UE_Capability_NB_v1710_IEs */
static int hf_lte_rrc_measParameters_v1710;       /* MeasParameters_NB_v1710 */
static int hf_lte_rrc_rf_Parameters_v1710;        /* RF_Parameters_NB_v1710 */
static int hf_lte_rrc_tdd_UE_Capability_v1710;    /* TDD_UE_Capability_NB_v1710 */
static int hf_lte_rrc_nonCriticalExtension_447;   /* UE_Capability_NB_v1720_IEs */
static int hf_lte_rrc_ntn_Parameters_v1720_01;    /* NTN_Parameters_NB_v1720 */
static int hf_lte_rrc_nonCriticalExtension_448;   /* UE_Capability_NB_v1800_IEs */
static int hf_lte_rrc_ntn_Parameters_v1800_01;    /* NTN_Parameters_NB_v1800 */
static int hf_lte_rrc_nonCriticalExtension_449;   /* T_nonCriticalExtension_114 */
static int hf_lte_rrc_ue_Category_NB_r15;         /* T_ue_Category_NB_r15 */
static int hf_lte_rrc_phyLayerParametersRel13_r15;  /* PhyLayerParameters_NB_r13 */
static int hf_lte_rrc_phyLayerParametersRel14_r15;  /* PhyLayerParameters_NB_v1430 */
static int hf_lte_rrc_slotSymbolResourceResvDL_r16;  /* T_slotSymbolResourceResvDL_r16 */
static int hf_lte_rrc_slotSymbolResourceResvUL_r16;  /* T_slotSymbolResourceResvUL_r16 */
static int hf_lte_rrc_subframeResourceResvDL_r16;  /* T_subframeResourceResvDL_r16 */
static int hf_lte_rrc_subframeResourceResvUL_r16;  /* T_subframeResourceResvUL_r16 */
static int hf_lte_rrc_phyLayerParameters_v1710;   /* PhyLayerParameters_NB_v1700 */
static int hf_lte_rrc_supportedROHC_Profiles_r13;  /* T_supportedROHC_Profiles_r13 */
static int hf_lte_rrc_maxNumberROHC_ContextSessions_r13;  /* T_maxNumberROHC_ContextSessions_r13 */
static int hf_lte_rrc_rlc_UM_r15;                 /* T_rlc_UM_r15 */
static int hf_lte_rrc_dataInactMon_r14_01;        /* T_dataInactMon_r14_01 */
static int hf_lte_rrc_rai_Support_r14_01;         /* T_rai_Support_r14_01 */
static int hf_lte_rrc_sr_SPS_BSR_r15;             /* T_sr_SPS_BSR_r15 */
static int hf_lte_rrc_rai_SupportEnh_r16_01;      /* T_rai_SupportEnh_r16_01 */
static int hf_lte_rrc_ntn_Connectivity_EPC_r17_01;  /* T_ntn_Connectivity_EPC_r17_01 */
static int hf_lte_rrc_ntn_TA_Report_r17_01;       /* T_ntn_TA_Report_r17_01 */
static int hf_lte_rrc_ntn_PUR_TimerDelay_r17_01;  /* T_ntn_PUR_TimerDelay_r17_01 */
static int hf_lte_rrc_ntn_OffsetTimingEnh_r17_01;  /* T_ntn_OffsetTimingEnh_r17_01 */
static int hf_lte_rrc_ntn_ScenarioSupport_r17_01;  /* T_ntn_ScenarioSupport_r17_01 */
static int hf_lte_rrc_ntn_SegmentedPrecompensationGaps_r17_01;  /* T_ntn_SegmentedPrecompensationGaps_r17_01 */
static int hf_lte_rrc_ntn_LocationBasedMeasTrigger_EFC_r18_01;  /* T_ntn_LocationBasedMeasTrigger_EFC_r18_01 */
static int hf_lte_rrc_ntn_LocationBasedMeasTrigger_EMC_r18_01;  /* T_ntn_LocationBasedMeasTrigger_EMC_r18_01 */
static int hf_lte_rrc_ntn_TimeBasedMeasTrigger_r18_01;  /* T_ntn_TimeBasedMeasTrigger_r18_01 */
static int hf_lte_rrc_ntn_RRC_HarqDisableSingleTB_r18;  /* T_ntn_RRC_HarqDisableSingleTB_r18 */
static int hf_lte_rrc_ntn_OverriddenHarqDisableSingleTB_r18;  /* T_ntn_OverriddenHarqDisableSingleTB_r18 */
static int hf_lte_rrc_ntn_DCI_HarqDisableSingleTB_r18;  /* T_ntn_DCI_HarqDisableSingleTB_r18 */
static int hf_lte_rrc_ntn_RRC_HarqDisableMultiTB_r18;  /* T_ntn_RRC_HarqDisableMultiTB_r18 */
static int hf_lte_rrc_ntn_OverriddenHarqDisableMultiTB_r18;  /* T_ntn_OverriddenHarqDisableMultiTB_r18 */
static int hf_lte_rrc_ntn_DCI_HarqDisableMultiTB_r18;  /* T_ntn_DCI_HarqDisableMultiTB_r18 */
static int hf_lte_rrc_ntn_UplinkHarq_ModeB_SingleTB_r18_01;  /* T_ntn_UplinkHarq_ModeB_SingleTB_r18_01 */
static int hf_lte_rrc_ntn_UplinkHarq_ModeB_MultiTB_r18_01;  /* T_ntn_UplinkHarq_ModeB_MultiTB_r18_01 */
static int hf_lte_rrc_ntn_HarqEnhScenarioSupport_r18_01;  /* T_ntn_HarqEnhScenarioSupport_r18_01 */
static int hf_lte_rrc_ntn_Triggered_GNSS_Fix_r18_01;  /* T_ntn_Triggered_GNSS_Fix_r18_01 */
static int hf_lte_rrc_ntn_Autonomous_GNSS_Fix_r18_01;  /* T_ntn_Autonomous_GNSS_Fix_r18_01 */
static int hf_lte_rrc_ntn_UplinkTxExtension_r18_01;  /* T_ntn_UplinkTxExtension_r18_01 */
static int hf_lte_rrc_ntn_GNSS_EnhScenarioSupport_r18_01;  /* T_ntn_GNSS_EnhScenarioSupport_r18_01 */
static int hf_lte_rrc_dl_ChannelQualityReporting_r16;  /* T_dl_ChannelQualityReporting_r16 */
static int hf_lte_rrc_connModeMeasIntraFreq_r17;  /* T_connModeMeasIntraFreq_r17 */
static int hf_lte_rrc_connModeMeasInterFreq_r17;  /* T_connModeMeasInterFreq_r17 */
static int hf_lte_rrc_multiTone_r13;              /* T_multiTone_r13 */
static int hf_lte_rrc_multiCarrier_r13;           /* T_multiCarrier_r13 */
static int hf_lte_rrc_multiCarrier_NPRACH_r14;    /* T_multiCarrier_NPRACH_r14 */
static int hf_lte_rrc_twoHARQ_Processes_r14;      /* T_twoHARQ_Processes_r14 */
static int hf_lte_rrc_interferenceRandomisation_r14;  /* T_interferenceRandomisation_r14 */
static int hf_lte_rrc_mixedOperationMode_r15;     /* T_mixedOperationMode_r15 */
static int hf_lte_rrc_sr_WithHARQ_ACK_r15;        /* T_sr_WithHARQ_ACK_r15 */
static int hf_lte_rrc_sr_WithoutHARQ_ACK_r15;     /* T_sr_WithoutHARQ_ACK_r15 */
static int hf_lte_rrc_nprach_Format2_r15;         /* T_nprach_Format2_r15 */
static int hf_lte_rrc_phyLayerParameters_NB_v1530_additionalTransmissionSIB1_r15;  /* T_phyLayerParameters_NB_v1530_additionalTransmissionSIB1_r15 */
static int hf_lte_rrc_npusch_3dot75kHz_SCS_TDD_r15;  /* T_npusch_3dot75kHz_SCS_TDD_r15 */
static int hf_lte_rrc_npdsch_MultiTB_r16;         /* T_npdsch_MultiTB_r16 */
static int hf_lte_rrc_npdsch_MultiTB_Interleaving_r16;  /* T_npdsch_MultiTB_Interleaving_r16 */
static int hf_lte_rrc_npusch_MultiTB_r16;         /* T_npusch_MultiTB_r16 */
static int hf_lte_rrc_npusch_MultiTB_Interleaving_r16;  /* T_npusch_MultiTB_Interleaving_r16 */
static int hf_lte_rrc_multiTB_HARQ_AckBundling_r16;  /* T_multiTB_HARQ_AckBundling_r16 */
static int hf_lte_rrc_slotSymbolResourceResvDL_r16_01;  /* T_slotSymbolResourceResvDL_r16_01 */
static int hf_lte_rrc_slotSymbolResourceResvUL_r16_01;  /* T_slotSymbolResourceResvUL_r16_01 */
static int hf_lte_rrc_subframeResourceResvDL_r16_01;  /* T_subframeResourceResvDL_r16_01 */
static int hf_lte_rrc_subframeResourceResvUL_r16_01;  /* T_subframeResourceResvUL_r16_01 */
static int hf_lte_rrc_pur_CP_EPC_r16;             /* T_pur_CP_EPC_r16 */
static int hf_lte_rrc_pur_CP_5GC_r16;             /* T_pur_CP_5GC_r16 */
static int hf_lte_rrc_pur_UP_EPC_r16;             /* T_pur_UP_EPC_r16 */
static int hf_lte_rrc_pur_UP_5GC_r16;             /* T_pur_UP_5GC_r16 */
static int hf_lte_rrc_pur_NRSRP_Validation_r16;   /* T_pur_NRSRP_Validation_r16 */
static int hf_lte_rrc_pur_CP_L1Ack_r16_01;        /* T_pur_CP_L1Ack_r16_01 */
static int hf_lte_rrc_npdsch_16QAM_r17;           /* T_npdsch_16QAM_r17 */
static int hf_lte_rrc_supportedBandList_r13;      /* SupportedBandList_NB_r13 */
static int hf_lte_rrc_multiNS_Pmax_r13;           /* T_multiNS_Pmax_r13 */
static int hf_lte_rrc_powerClassNB_14dBm_r14;     /* T_powerClassNB_14dBm_r14 */
static int hf_lte_rrc_supportedBandList_v1710;    /* SupportedBandList_NB_v1710 */
static int hf_lte_rrc_SupportedBandList_NB_r13_item;  /* SupportedBand_NB_r13 */
static int hf_lte_rrc_SupportedBandList_NB_v1710_item;  /* SupportedBand_NB_v1710 */
static int hf_lte_rrc_band_r13;                   /* FreqBandIndicator_NB_r13 */
static int hf_lte_rrc_powerClassNB_20dBm_r13;     /* T_powerClassNB_20dBm_r13 */
static int hf_lte_rrc_npusch_16QAM_r17;           /* T_npusch_16QAM_r17 */
static int hf_lte_rrc_anr_Report_r16;             /* T_anr_Report_r16 */
static int hf_lte_rrc_rach_Report_r16_01;         /* T_rach_Report_r16 */
static int hf_lte_rrc_locationInfo_r16_01;        /* T_locationInfo_r16 */
static int hf_lte_rrc_ue_Category_NB_r13_01;      /* T_ue_Category_NB_r13_01 */
static int hf_lte_rrc_multiCarrierPaging_r14;     /* T_multiCarrierPaging_r14 */
static int hf_lte_rrc_mixedOperationMode_r15_01;  /* T_mixedOperationMode_r15_01 */
static int hf_lte_rrc_wakeUpSignal_r15_01;        /* T_wakeUpSignal_r15_01 */
static int hf_lte_rrc_wakeUpSignalMinGap_eDRX_r15_01;  /* T_wakeUpSignalMinGap_eDRX_r15_01 */
static int hf_lte_rrc_multiCarrierPagingTDD_r15;  /* T_multiCarrierPagingTDD_r15 */
static int hf_lte_rrc_ue_Category_NB_r16;         /* T_ue_Category_NB_r16 */
static int hf_lte_rrc_groupWakeUpSignal_r16_01;   /* T_groupWakeUpSignal_r16_01 */
static int hf_lte_rrc_groupWakeUpSignalAlternation_r16_01;  /* T_groupWakeUpSignalAlternation_r16_01 */
static int hf_lte_rrc_t300_r13;                   /* T_t300_r13 */
static int hf_lte_rrc_t301_r13_01;                /* T_t301_r13_01 */
static int hf_lte_rrc_t310_r13_01;                /* T_t310_r13_01 */
static int hf_lte_rrc_n310_r13_01;                /* T_n310_r13_01 */
static int hf_lte_rrc_t311_r13_01;                /* T_t311_r13_01 */
static int hf_lte_rrc_n311_r13_01;                /* T_n311_r13_01 */
static int hf_lte_rrc_t311_v1350_01;              /* T_t311_v1350_01 */
static int hf_lte_rrc_t300_v1530;                 /* T_t300_v1530 */
static int hf_lte_rrc_t301_v1530_01;              /* T_t301_v1530_01 */
static int hf_lte_rrc_t311_v1530_01;              /* T_t311_v1530_01 */
static int hf_lte_rrc_t300_r15_01;                /* T_t300_r15_01 */
static int hf_lte_rrc_SC_MTCH_InfoList_NB_r14_item;  /* SC_MTCH_Info_NB_r14 */
static int hf_lte_rrc_sc_mtch_CarrierConfig_r14;  /* T_sc_mtch_CarrierConfig_r14 */
static int hf_lte_rrc_sc_mtch_SchedulingInfo_r14;  /* SC_MTCH_SchedulingInfo_NB_r14 */
static int hf_lte_rrc_sc_mtch_NeighbourCell_r14;  /* BIT_STRING_SIZE_maxNeighCell_SCPTM_NB_r14 */
static int hf_lte_rrc_npdcch_NPDSCH_MaxTBS_SC_MTCH_r14;  /* T_npdcch_NPDSCH_MaxTBS_SC_MTCH_r14 */
static int hf_lte_rrc_npdcch_NumRepetitions_SC_MTCH_r14;  /* T_npdcch_NumRepetitions_SC_MTCH_r14 */
static int hf_lte_rrc_npdcch_StartSF_SC_MTCH_r14;  /* T_npdcch_StartSF_SC_MTCH_r14 */
static int hf_lte_rrc_npdcch_Offset_SC_MTCH_r14;  /* T_npdcch_Offset_SC_MTCH_r14 */
static int hf_lte_rrc_onDurationTimerSCPTM_r14_03;  /* T_onDurationTimerSCPTM_r14_03 */
static int hf_lte_rrc_drx_InactivityTimerSCPTM_r14_03;  /* T_drx_InactivityTimerSCPTM_r14_03 */
static int hf_lte_rrc_schedulingPeriodStartOffsetSCPTM_r14_03;  /* T_schedulingPeriodStartOffsetSCPTM_r14_03 */
static int hf_lte_rrc_SCPTM_NeighbourCellList_NB_r14_item;  /* PCI_ARFCN_NB_r14 */
static int hf_lte_rrc_physCellId_r14;             /* PhysCellId */
static int hf_lte_rrc_carrierFreq_r14;            /* CarrierFreq_NB_r13 */
static int dummy_hf_lte_rrc_eag_field; /* never registered */

static int hf_lte_rrc_eutra_cap_feat_group_ind_1;
static int hf_lte_rrc_eutra_cap_feat_group_ind_2;
static int hf_lte_rrc_eutra_cap_feat_group_ind_3;
static int hf_lte_rrc_eutra_cap_feat_group_ind_4;
static int hf_lte_rrc_eutra_cap_feat_group_ind_5;
static int hf_lte_rrc_eutra_cap_feat_group_ind_6;
static int hf_lte_rrc_eutra_cap_feat_group_ind_7;
static int hf_lte_rrc_eutra_cap_feat_group_ind_8;
static int hf_lte_rrc_eutra_cap_feat_group_ind_9;
static int hf_lte_rrc_eutra_cap_feat_group_ind_10;
static int hf_lte_rrc_eutra_cap_feat_group_ind_11;
static int hf_lte_rrc_eutra_cap_feat_group_ind_12;
static int hf_lte_rrc_eutra_cap_feat_group_ind_13;
static int hf_lte_rrc_eutra_cap_feat_group_ind_14;
static int hf_lte_rrc_eutra_cap_feat_group_ind_15;
static int hf_lte_rrc_eutra_cap_feat_group_ind_16;
static int hf_lte_rrc_eutra_cap_feat_group_ind_17;
static int hf_lte_rrc_eutra_cap_feat_group_ind_18;
static int hf_lte_rrc_eutra_cap_feat_group_ind_19;
static int hf_lte_rrc_eutra_cap_feat_group_ind_20;
static int hf_lte_rrc_eutra_cap_feat_group_ind_21;
static int hf_lte_rrc_eutra_cap_feat_group_ind_22;
static int hf_lte_rrc_eutra_cap_feat_group_ind_23;
static int hf_lte_rrc_eutra_cap_feat_group_ind_24;
static int hf_lte_rrc_eutra_cap_feat_group_ind_25;
static int hf_lte_rrc_eutra_cap_feat_group_ind_26;
static int hf_lte_rrc_eutra_cap_feat_group_ind_27;
static int hf_lte_rrc_eutra_cap_feat_group_ind_28;
static int hf_lte_rrc_eutra_cap_feat_group_ind_29;
static int hf_lte_rrc_eutra_cap_feat_group_ind_30;
static int hf_lte_rrc_eutra_cap_feat_group_ind_31;
static int hf_lte_rrc_eutra_cap_feat_group_ind_32;
static int hf_lte_rrc_eutra_cap_feat_group_ind_33;
static int hf_lte_rrc_eutra_cap_feat_group_ind_34;
static int hf_lte_rrc_eutra_cap_feat_group_ind_35;
static int hf_lte_rrc_eutra_cap_feat_group_ind_36;
static int hf_lte_rrc_eutra_cap_feat_group_ind_37;
static int hf_lte_rrc_eutra_cap_feat_group_ind_38;
static int hf_lte_rrc_eutra_cap_feat_group_ind_39;
static int hf_lte_rrc_eutra_cap_feat_group_ind_40;
static int hf_lte_rrc_eutra_cap_feat_group_ind_41;
static int hf_lte_rrc_eutra_cap_feat_group_ind_42;
static int hf_lte_rrc_eutra_cap_feat_group_ind_43;
static int hf_lte_rrc_eutra_cap_feat_group_ind_44;
static int hf_lte_rrc_eutra_cap_feat_group_ind_45;
static int hf_lte_rrc_eutra_cap_feat_group_ind_46;
static int hf_lte_rrc_eutra_cap_feat_group_ind_47;
static int hf_lte_rrc_eutra_cap_feat_group_ind_48;
static int hf_lte_rrc_eutra_cap_feat_group_ind_49;
static int hf_lte_rrc_eutra_cap_feat_group_ind_50;
static int hf_lte_rrc_eutra_cap_feat_group_ind_51;
static int hf_lte_rrc_eutra_cap_feat_group_ind_52;
static int hf_lte_rrc_eutra_cap_feat_group_ind_53;
static int hf_lte_rrc_eutra_cap_feat_group_ind_54;
static int hf_lte_rrc_eutra_cap_feat_group_ind_55;
static int hf_lte_rrc_eutra_cap_feat_group_ind_56;
static int hf_lte_rrc_eutra_cap_feat_group_ind_57;
static int hf_lte_rrc_eutra_cap_feat_group_ind_58;
static int hf_lte_rrc_eutra_cap_feat_group_ind_59;
static int hf_lte_rrc_eutra_cap_feat_group_ind_60;
static int hf_lte_rrc_eutra_cap_feat_group_ind_61;
static int hf_lte_rrc_eutra_cap_feat_group_ind_62;
static int hf_lte_rrc_eutra_cap_feat_group_ind_63;
static int hf_lte_rrc_eutra_cap_feat_group_ind_64;
static int hf_lte_rrc_eutra_cap_feat_group_ind_101;
static int hf_lte_rrc_eutra_cap_feat_group_ind_102;
static int hf_lte_rrc_eutra_cap_feat_group_ind_103;
static int hf_lte_rrc_eutra_cap_feat_group_ind_104;
static int hf_lte_rrc_eutra_cap_feat_group_ind_105;
static int hf_lte_rrc_eutra_cap_feat_group_ind_106;
static int hf_lte_rrc_eutra_cap_feat_group_ind_107;
static int hf_lte_rrc_eutra_cap_feat_group_ind_108;
static int hf_lte_rrc_eutra_cap_feat_group_ind_109;
static int hf_lte_rrc_eutra_cap_feat_group_ind_110;
static int hf_lte_rrc_eutra_cap_feat_group_ind_111;
static int hf_lte_rrc_eutra_cap_feat_group_ind_112;
static int hf_lte_rrc_eutra_cap_feat_group_ind_113;
static int hf_lte_rrc_eutra_cap_feat_group_ind_114;
static int hf_lte_rrc_eutra_cap_feat_group_ind_115;
static int hf_lte_rrc_eutra_cap_feat_group_ind_116;
static int hf_lte_rrc_eutra_cap_feat_group_ind_117;
static int hf_lte_rrc_eutra_cap_feat_group_ind_118;
static int hf_lte_rrc_eutra_cap_feat_group_ind_119;
static int hf_lte_rrc_eutra_cap_feat_group_ind_120;
static int hf_lte_rrc_eutra_cap_feat_group_ind_121;
static int hf_lte_rrc_eutra_cap_feat_group_ind_122;
static int hf_lte_rrc_eutra_cap_feat_group_ind_123;
static int hf_lte_rrc_eutra_cap_feat_group_ind_124;
static int hf_lte_rrc_eutra_cap_feat_group_ind_125;
static int hf_lte_rrc_eutra_cap_feat_group_ind_126;
static int hf_lte_rrc_eutra_cap_feat_group_ind_127;
static int hf_lte_rrc_eutra_cap_feat_group_ind_128;
static int hf_lte_rrc_eutra_cap_feat_group_ind_129;
static int hf_lte_rrc_eutra_cap_feat_group_ind_130;
static int hf_lte_rrc_eutra_cap_feat_group_ind_131;
static int hf_lte_rrc_eutra_cap_feat_group_ind_132;
static int hf_lte_rrc_serialNumber_gs;
static int hf_lte_rrc_serialNumber_msg_code;
static int hf_lte_rrc_serialNumber_upd_nb;
static int hf_lte_rrc_warningType_value;
static int hf_lte_rrc_warningType_emergency_user_alert;
static int hf_lte_rrc_warningType_popup;
static int hf_lte_rrc_warningMessageSegment_nb_pages;
static int hf_lte_rrc_warningMessageSegment_decoded_page;
static int hf_lte_rrc_interBandTDD_CA_WithDifferentConfig_bit1;
static int hf_lte_rrc_interBandTDD_CA_WithDifferentConfig_bit2;
static int hf_lte_rrc_tdd_FDD_CA_PCellDuplex_r12_bit1;
static int hf_lte_rrc_tdd_FDD_CA_PCellDuplex_r12_bit2;
static int hf_lte_rrc_aperiodicCSI_Reporting_r13_bit1;
static int hf_lte_rrc_aperiodicCSI_Reporting_r13_bit2;
static int hf_lte_rrc_codebook_HARQ_ACK_r13_bit1;
static int hf_lte_rrc_codebook_HARQ_ACK_r13_bit2;
static int hf_lte_rrc_sr_config_periodicity;
static int hf_lte_rrc_sr_config_subframe_offset;
static int hf_lte_rrc_cdma_time;
static int hf_lte_rrc_utc_time;
static int hf_lte_rrc_local_time;
static int hf_lte_rrc_absolute_time;
static int hf_lte_rrc_transmissionModeList_r12_tm1;
static int hf_lte_rrc_transmissionModeList_r12_tm2;
static int hf_lte_rrc_transmissionModeList_r12_tm3;
static int hf_lte_rrc_transmissionModeList_r12_tm4;
static int hf_lte_rrc_transmissionModeList_r12_tm6;
static int hf_lte_rrc_transmissionModeList_r12_tm8;
static int hf_lte_rrc_transmissionModeList_r12_tm9;
static int hf_lte_rrc_transmissionModeList_r12_tm10;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_0;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_1;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_2;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_3;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_4;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_5;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_6;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_7;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_8;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_9;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_10;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_11;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_12;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_13;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_14;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_15;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_16;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_17;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_18;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_19;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_20;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_21;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_22;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_23;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_24;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_25;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_26;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_27;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_28;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_29;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_30;
static int hf_lte_rrc_modifiedMPR_Behavior_r10_mpr_ampr_31;
static int hf_lte_rrc_sib11_fragments;
static int hf_lte_rrc_sib11_fragment;
static int hf_lte_rrc_sib11_fragment_overlap;
static int hf_lte_rrc_sib11_fragment_overlap_conflict;
static int hf_lte_rrc_sib11_fragment_multiple_tails;
static int hf_lte_rrc_sib11_fragment_too_long_fragment;
static int hf_lte_rrc_sib11_fragment_error;
static int hf_lte_rrc_sib11_fragment_count;
static int hf_lte_rrc_sib11_reassembled_in;
static int hf_lte_rrc_sib11_reassembled_length;
static int hf_lte_rrc_sib11_reassembled_data;
static int hf_lte_rrc_sib12_fragments;
static int hf_lte_rrc_sib12_fragment;
static int hf_lte_rrc_sib12_fragment_overlap;
static int hf_lte_rrc_sib12_fragment_overlap_conflict;
static int hf_lte_rrc_sib12_fragment_multiple_tails;
static int hf_lte_rrc_sib12_fragment_too_long_fragment;
static int hf_lte_rrc_sib12_fragment_error;
static int hf_lte_rrc_sib12_fragment_count;
static int hf_lte_rrc_sib12_reassembled_in;
static int hf_lte_rrc_sib12_reassembled_length;
static int hf_lte_rrc_sib12_reassembled_data;
static int hf_lte_rrc_dcch_segment_fragments;
static int hf_lte_rrc_dcch_segment_fragment;
static int hf_lte_rrc_dcch_segment_fragment_overlap;
static int hf_lte_rrc_dcch_segment_fragment_overlap_conflict;
static int hf_lte_rrc_dcch_segment_fragment_multiple_tails;
static int hf_lte_rrc_dcch_segment_fragment_too_long_fragment;
static int hf_lte_rrc_dcch_segment_fragment_error;
static int hf_lte_rrc_dcch_segment_fragment_count;
static int hf_lte_rrc_dcch_segment_reassembled_in;
static int hf_lte_rrc_dcch_segment_reassembled_length;
static int hf_lte_rrc_dcch_segment_reassembled_data;
static int hf_lte_rrc_measGapPatterns_r15_bit1;
static int hf_lte_rrc_measGapPatterns_r15_bit2;
static int hf_lte_rrc_measGapPatterns_r15_bit3;
static int hf_lte_rrc_measGapPatterns_r15_bit4;
static int hf_lte_rrc_measGapPatterns_r15_bit5;
static int hf_lte_rrc_measGapPatterns_r15_bit6;
static int hf_lte_rrc_measGapPatterns_r15_bit7;
static int hf_lte_rrc_measGapPatterns_r15_bit8;

/* Initialize the subtree pointers */
static int ett_lte_rrc;

static int ett_lte_rrc_HandoverCommand;
static int ett_lte_rrc_T_criticalExtensions;
static int ett_lte_rrc_T_c1;
static int ett_lte_rrc_T_criticalExtensionsFuture;
static int ett_lte_rrc_HandoverCommand_r8_IEs;
static int ett_lte_rrc_T_nonCriticalExtension;
static int ett_lte_rrc_HandoverPreparationInformation;
static int ett_lte_rrc_T_criticalExtensions_01;
static int ett_lte_rrc_T_c1_01;
static int ett_lte_rrc_T_criticalExtensionsFuture_01;
static int ett_lte_rrc_HandoverPreparationInformation_r8_IEs;
static int ett_lte_rrc_HandoverPreparationInformation_v920_IEs;
static int ett_lte_rrc_HandoverPreparationInformation_v9d0_IEs;
static int ett_lte_rrc_HandoverPreparationInformation_v9j0_IEs;
static int ett_lte_rrc_HandoverPreparationInformation_v10j0_IEs;
static int ett_lte_rrc_HandoverPreparationInformation_v10x0_IEs;
static int ett_lte_rrc_HandoverPreparationInformation_v13c0_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_01;
static int ett_lte_rrc_HandoverPreparationInformation_v9e0_IEs;
static int ett_lte_rrc_HandoverPreparationInformation_v1130_IEs;
static int ett_lte_rrc_HandoverPreparationInformation_v1250_IEs;
static int ett_lte_rrc_HandoverPreparationInformation_v1320_IEs;
static int ett_lte_rrc_HandoverPreparationInformation_v1430_IEs;
static int ett_lte_rrc_HandoverPreparationInformation_v1530_IEs;
static int ett_lte_rrc_HandoverPreparationInformation_v1540_IEs;
static int ett_lte_rrc_HandoverPreparationInformation_v1610_IEs;
static int ett_lte_rrc_HandoverPreparationInformation_v1620_IEs;
static int ett_lte_rrc_HandoverPreparationInformation_v1630_IEs;
static int ett_lte_rrc_HandoverPreparationInformation_v1700_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_02;
static int ett_lte_rrc_SCG_Config_r12;
static int ett_lte_rrc_T_criticalExtensions_02;
static int ett_lte_rrc_T_c1_02;
static int ett_lte_rrc_T_criticalExtensionsFuture_02;
static int ett_lte_rrc_SCG_Config_r12_IEs;
static int ett_lte_rrc_SCG_Config_v12i0a_IEs;
static int ett_lte_rrc_SCG_Config_v12i0b_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_03;
static int ett_lte_rrc_SCG_Config_v13c0_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_04;
static int ett_lte_rrc_SCG_ConfigInfo_r12;
static int ett_lte_rrc_T_criticalExtensions_03;
static int ett_lte_rrc_T_c1_03;
static int ett_lte_rrc_T_criticalExtensionsFuture_03;
static int ett_lte_rrc_SCG_ConfigInfo_r12_IEs;
static int ett_lte_rrc_SCG_ConfigInfo_v1310_IEs;
static int ett_lte_rrc_SCG_ConfigInfo_v1330_IEs;
static int ett_lte_rrc_SCG_ConfigInfo_v1430_IEs;
static int ett_lte_rrc_SCG_ConfigInfo_v1530_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_05;
static int ett_lte_rrc_DRB_InfoListSCG_r12;
static int ett_lte_rrc_DRB_InfoListSCG_r15;
static int ett_lte_rrc_DRB_InfoSCG_r12;
static int ett_lte_rrc_SCellToAddModListSCG_r12;
static int ett_lte_rrc_SCellToAddModListSCG_Ext_r13;
static int ett_lte_rrc_Cell_ToAddMod_r12;
static int ett_lte_rrc_T_cellIdentification_r12;
static int ett_lte_rrc_T_measResultCellToAdd_r12;
static int ett_lte_rrc_T_measResultCellToAdd_v1310;
static int ett_lte_rrc_MeasResultServCellListSCG_r12;
static int ett_lte_rrc_MeasResultServCellListSCG_Ext_r13;
static int ett_lte_rrc_MeasResultServCellSCG_r12;
static int ett_lte_rrc_T_measResultSCell_r12;
static int ett_lte_rrc_T_measResultSCell_v1310;
static int ett_lte_rrc_MeasResultListRSSI_SCG_r13;
static int ett_lte_rrc_MeasResultRSSI_SCG_r13;
static int ett_lte_rrc_SCG_ConfigRestrictInfo_r12;
static int ett_lte_rrc_UEPagingCoverageInformation;
static int ett_lte_rrc_T_criticalExtensions_04;
static int ett_lte_rrc_T_c1_04;
static int ett_lte_rrc_T_criticalExtensionsFuture_04;
static int ett_lte_rrc_UEPagingCoverageInformation_r13_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_06;
static int ett_lte_rrc_UERadioAccessCapabilityInformation;
static int ett_lte_rrc_T_criticalExtensions_05;
static int ett_lte_rrc_T_c1_05;
static int ett_lte_rrc_T_criticalExtensionsFuture_05;
static int ett_lte_rrc_UERadioAccessCapabilityInformation_r8_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_07;
static int ett_lte_rrc_UERadioPagingInformation;
static int ett_lte_rrc_T_criticalExtensions_06;
static int ett_lte_rrc_T_c1_06;
static int ett_lte_rrc_T_criticalExtensionsFuture_06;
static int ett_lte_rrc_UERadioPagingInformation_r12_IEs;
static int ett_lte_rrc_UERadioPagingInformation_v1310_IEs;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxBands_OF_FreqBandIndicator_r11;
static int ett_lte_rrc_UERadioPagingInformation_v1610_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_08;
static int ett_lte_rrc_AS_Config;
static int ett_lte_rrc_AS_Config_v9e0;
static int ett_lte_rrc_AS_Config_v10j0;
static int ett_lte_rrc_AS_Config_v1250;
static int ett_lte_rrc_AS_Config_v1320;
static int ett_lte_rrc_AS_Config_v13c0;
static int ett_lte_rrc_AS_Config_v1430;
static int ett_lte_rrc_AS_ConfigNR_r15;
static int ett_lte_rrc_AS_ConfigNR_v1570;
static int ett_lte_rrc_AS_Config_v1550;
static int ett_lte_rrc_T_tdm_PatternConfig_r15;
static int ett_lte_rrc_AS_ConfigNR_v1620;
static int ett_lte_rrc_AS_Config_v1700;
static int ett_lte_rrc_AS_Context;
static int ett_lte_rrc_AS_Context_v1130;
static int ett_lte_rrc_AS_Context_v1320;
static int ett_lte_rrc_AS_Context_v1610;
static int ett_lte_rrc_AS_Context_v1620;
static int ett_lte_rrc_AS_Context_v1630;
static int ett_lte_rrc_ConfigRestrictInfoDAPS_r16;
static int ett_lte_rrc_ConfigRestrictInfoDAPS_v1630;
static int ett_lte_rrc_ReestablishmentInfo;
static int ett_lte_rrc_AdditionalReestabInfoList;
static int ett_lte_rrc_AdditionalReestabInfo;
static int ett_lte_rrc_RRM_Config;
static int ett_lte_rrc_CandidateCellInfoList_r10;
static int ett_lte_rrc_CandidateCellInfo_r10;
static int ett_lte_rrc_BCCH_BCH_Message;
static int ett_lte_rrc_BCCH_BCH_Message_MBMS;
static int ett_lte_rrc_BCCH_DL_SCH_Message;
static int ett_lte_rrc_BCCH_DL_SCH_MessageType;
static int ett_lte_rrc_T_c1_07;
static int ett_lte_rrc_T_messageClassExtension;
static int ett_lte_rrc_BCCH_DL_SCH_Message_BR;
static int ett_lte_rrc_BCCH_DL_SCH_MessageType_BR_r13;
static int ett_lte_rrc_T_c1_08;
static int ett_lte_rrc_T_messageClassExtension_01;
static int ett_lte_rrc_BCCH_DL_SCH_Message_MBMS;
static int ett_lte_rrc_BCCH_DL_SCH_MessageType_MBMS_r14;
static int ett_lte_rrc_T_c1_09;
static int ett_lte_rrc_T_messageClassExtension_02;
static int ett_lte_rrc_MCCH_Message;
static int ett_lte_rrc_MCCH_MessageType;
static int ett_lte_rrc_T_c1_10;
static int ett_lte_rrc_T_later;
static int ett_lte_rrc_T_c2;
static int ett_lte_rrc_T_messageClassExtension_03;
static int ett_lte_rrc_PCCH_Message;
static int ett_lte_rrc_PCCH_MessageType;
static int ett_lte_rrc_T_c1_11;
static int ett_lte_rrc_T_messageClassExtension_04;
static int ett_lte_rrc_DL_CCCH_Message;
static int ett_lte_rrc_DL_CCCH_MessageType;
static int ett_lte_rrc_T_c1_12;
static int ett_lte_rrc_T_messageClassExtension_05;
static int ett_lte_rrc_T_c2_01;
static int ett_lte_rrc_T_messageClassExtensionFuture_r15;
static int ett_lte_rrc_DL_DCCH_Message;
static int ett_lte_rrc_DL_DCCH_MessageType;
static int ett_lte_rrc_T_c1_13;
static int ett_lte_rrc_T_messageClassExtension_06;
static int ett_lte_rrc_UL_CCCH_Message;
static int ett_lte_rrc_UL_CCCH_MessageType;
static int ett_lte_rrc_T_c1_14;
static int ett_lte_rrc_T_messageClassExtension_07;
static int ett_lte_rrc_T_c2_02;
static int ett_lte_rrc_T_messageClassExtensionFuture_r13;
static int ett_lte_rrc_T_c3;
static int ett_lte_rrc_T_messageClassExtensionFuture_r15_01;
static int ett_lte_rrc_UL_DCCH_Message;
static int ett_lte_rrc_UL_DCCH_MessageType;
static int ett_lte_rrc_T_c1_15;
static int ett_lte_rrc_T_messageClassExtension_08;
static int ett_lte_rrc_T_c2_03;
static int ett_lte_rrc_T_messageClassExtensionFuture_r11;
static int ett_lte_rrc_SC_MCCH_Message_r13;
static int ett_lte_rrc_SC_MCCH_MessageType_r13;
static int ett_lte_rrc_T_c1_16;
static int ett_lte_rrc_T_messageClassExtension_09;
static int ett_lte_rrc_T_c2_04;
static int ett_lte_rrc_T_messageClassExtensionFuture_r14;
static int ett_lte_rrc_CounterCheck;
static int ett_lte_rrc_T_criticalExtensions_07;
static int ett_lte_rrc_T_c1_17;
static int ett_lte_rrc_T_criticalExtensionsFuture_07;
static int ett_lte_rrc_CounterCheck_r8_IEs;
static int ett_lte_rrc_CounterCheck_v8a0_IEs;
static int ett_lte_rrc_CounterCheck_v1530_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_09;
static int ett_lte_rrc_DRB_CountMSB_InfoList;
static int ett_lte_rrc_DRB_CountMSB_InfoListExt_r15;
static int ett_lte_rrc_DRB_CountMSB_Info;
static int ett_lte_rrc_CounterCheckResponse;
static int ett_lte_rrc_T_criticalExtensions_08;
static int ett_lte_rrc_T_criticalExtensionsFuture_08;
static int ett_lte_rrc_CounterCheckResponse_r8_IEs;
static int ett_lte_rrc_CounterCheckResponse_v8a0_IEs;
static int ett_lte_rrc_CounterCheckResponse_v1530_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_10;
static int ett_lte_rrc_DRB_CountInfoList;
static int ett_lte_rrc_DRB_CountInfoListExt_r15;
static int ett_lte_rrc_DRB_CountInfo;
static int ett_lte_rrc_CSFBParametersRequestCDMA2000;
static int ett_lte_rrc_T_criticalExtensions_09;
static int ett_lte_rrc_T_criticalExtensionsFuture_09;
static int ett_lte_rrc_CSFBParametersRequestCDMA2000_r8_IEs;
static int ett_lte_rrc_CSFBParametersRequestCDMA2000_v8a0_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_11;
static int ett_lte_rrc_CSFBParametersResponseCDMA2000;
static int ett_lte_rrc_T_criticalExtensions_10;
static int ett_lte_rrc_T_criticalExtensionsFuture_10;
static int ett_lte_rrc_CSFBParametersResponseCDMA2000_r8_IEs;
static int ett_lte_rrc_CSFBParametersResponseCDMA2000_v8a0_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_12;
static int ett_lte_rrc_DLDedicatedMessageSegment_r16;
static int ett_lte_rrc_T_criticalExtensions_11;
static int ett_lte_rrc_T_criticalExtensionsFuture_11;
static int ett_lte_rrc_DLDedicatedMessageSegment_r16_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_13;
static int ett_lte_rrc_DLInformationTransfer;
static int ett_lte_rrc_T_criticalExtensions_12;
static int ett_lte_rrc_T_c1_18;
static int ett_lte_rrc_T_criticalExtensionsFuture_12;
static int ett_lte_rrc_DLInformationTransfer_r8_IEs;
static int ett_lte_rrc_T_dedicatedInfoType;
static int ett_lte_rrc_DLInformationTransfer_v8a0_IEs;
static int ett_lte_rrc_DLInformationTransfer_r15_IEs;
static int ett_lte_rrc_T_dedicatedInfoType_r15;
static int ett_lte_rrc_DLInformationTransfer_v1610_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_14;
static int ett_lte_rrc_FailureInformation_r15;
static int ett_lte_rrc_FailureInformation_r16;
static int ett_lte_rrc_T_criticalExtensions_13;
static int ett_lte_rrc_T_criticalExtensionsFuture_13;
static int ett_lte_rrc_FailedLogicalChannelInfo_r15;
static int ett_lte_rrc_T_failedLogicalChannelIdentity_r15;
static int ett_lte_rrc_FailureInformation_r16_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_15;
static int ett_lte_rrc_FailedLogicalChannelIdentity_r16;
static int ett_lte_rrc_HandoverFromEUTRAPreparationRequest;
static int ett_lte_rrc_T_criticalExtensions_14;
static int ett_lte_rrc_T_c1_19;
static int ett_lte_rrc_T_criticalExtensionsFuture_14;
static int ett_lte_rrc_HandoverFromEUTRAPreparationRequest_r8_IEs;
static int ett_lte_rrc_HandoverFromEUTRAPreparationRequest_v890_IEs;
static int ett_lte_rrc_HandoverFromEUTRAPreparationRequest_v920_IEs;
static int ett_lte_rrc_HandoverFromEUTRAPreparationRequest_v1020_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_16;
static int ett_lte_rrc_InDeviceCoexIndication_r11;
static int ett_lte_rrc_T_criticalExtensions_15;
static int ett_lte_rrc_T_c1_20;
static int ett_lte_rrc_T_criticalExtensionsFuture_15;
static int ett_lte_rrc_InDeviceCoexIndication_r11_IEs;
static int ett_lte_rrc_InDeviceCoexIndication_v11d0_IEs;
static int ett_lte_rrc_T_ul_CA_AssistanceInfo_r11;
static int ett_lte_rrc_InDeviceCoexIndication_v1310_IEs;
static int ett_lte_rrc_InDeviceCoexIndication_v1360_IEs;
static int ett_lte_rrc_InDeviceCoexIndication_v1530_IEs;
static int ett_lte_rrc_InDeviceCoexIndication_v1610_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_17;
static int ett_lte_rrc_AffectedCarrierFreqList_r11;
static int ett_lte_rrc_AffectedCarrierFreqList_v1310;
static int ett_lte_rrc_AffectedCarrierFreq_r11;
static int ett_lte_rrc_AffectedCarrierFreq_v1310;
static int ett_lte_rrc_AffectedCarrierFreqCombList_r11;
static int ett_lte_rrc_AffectedCarrierFreqCombList_r13;
static int ett_lte_rrc_AffectedCarrierFreqComb_r11;
static int ett_lte_rrc_AffectedCarrierFreqComb_r13;
static int ett_lte_rrc_TDM_AssistanceInfo_r11;
static int ett_lte_rrc_T_drx_AssistanceInfo_r11;
static int ett_lte_rrc_IDC_SubframePatternList_r11;
static int ett_lte_rrc_IDC_SubframePattern_r11;
static int ett_lte_rrc_T_subframePatternTDD_r11;
static int ett_lte_rrc_VictimSystemType_r11;
static int ett_lte_rrc_VictimSystemType_v1610;
static int ett_lte_rrc_MRDC_AssistanceInfo_r15;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxCombIDC_r11_OF_AffectedCarrierFreqCombInfoMRDC_r15;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxCombIDC_r11_OF_VictimSystemType_v1610;
static int ett_lte_rrc_AffectedCarrierFreqCombInfoMRDC_r15;
static int ett_lte_rrc_T_affectedCarrierFreqCombMRDC_r15;
static int ett_lte_rrc_AffectedCarrierFreqComb_r15;
static int ett_lte_rrc_AffectedCarrierFreqCombNR_r15;
static int ett_lte_rrc_InterFreqRSTDMeasurementIndication_r10;
static int ett_lte_rrc_T_criticalExtensions_16;
static int ett_lte_rrc_T_c1_21;
static int ett_lte_rrc_T_criticalExtensionsFuture_16;
static int ett_lte_rrc_InterFreqRSTDMeasurementIndication_r10_IEs;
static int ett_lte_rrc_T_rstd_InterFreqIndication_r10;
static int ett_lte_rrc_T_start;
static int ett_lte_rrc_T_nonCriticalExtension_18;
static int ett_lte_rrc_RSTD_InterFreqInfoList_r10;
static int ett_lte_rrc_RSTD_InterFreqInfo_r10;
static int ett_lte_rrc_T_measPRS_Offset_r15;
static int ett_lte_rrc_LoggedMeasurementConfiguration_r10;
static int ett_lte_rrc_T_criticalExtensions_17;
static int ett_lte_rrc_T_c1_22;
static int ett_lte_rrc_T_criticalExtensionsFuture_17;
static int ett_lte_rrc_LoggedMeasurementConfiguration_r10_IEs;
static int ett_lte_rrc_LoggedMeasurementConfiguration_v1080_IEs;
static int ett_lte_rrc_LoggedMeasurementConfiguration_v1130_IEs;
static int ett_lte_rrc_LoggedMeasurementConfiguration_v1250_IEs;
static int ett_lte_rrc_LoggedMeasurementConfiguration_v1530_IEs;
static int ett_lte_rrc_LoggedMeasurementConfiguration_v1700_IEs;
static int ett_lte_rrc_LoggedMeasurementConfiguration_v1800_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_19;
static int ett_lte_rrc_TargetMBSFN_AreaList_r12;
static int ett_lte_rrc_TargetMBSFN_Area_r12;
static int ett_lte_rrc_LoggedEventTriggerConfig_r17;
static int ett_lte_rrc_EventType_r17;
static int ett_lte_rrc_T_eventL1;
static int ett_lte_rrc_MasterInformationBlock;
static int ett_lte_rrc_T_partEARFCN_r17;
static int ett_lte_rrc_MasterInformationBlock_MBMS_r14;
static int ett_lte_rrc_MBMSCountingRequest_r10;
static int ett_lte_rrc_T_nonCriticalExtension_20;
static int ett_lte_rrc_CountingRequestList_r10;
static int ett_lte_rrc_CountingRequestInfo_r10;
static int ett_lte_rrc_MBMSCountingResponse_r10;
static int ett_lte_rrc_T_criticalExtensions_18;
static int ett_lte_rrc_T_c1_23;
static int ett_lte_rrc_T_criticalExtensionsFuture_18;
static int ett_lte_rrc_MBMSCountingResponse_r10_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_21;
static int ett_lte_rrc_CountingResponseList_r10;
static int ett_lte_rrc_CountingResponseInfo_r10;
static int ett_lte_rrc_MBMSInterestIndication_r11;
static int ett_lte_rrc_T_criticalExtensions_19;
static int ett_lte_rrc_T_c1_24;
static int ett_lte_rrc_T_criticalExtensionsFuture_19;
static int ett_lte_rrc_MBMSInterestIndication_r11_IEs;
static int ett_lte_rrc_MBMSInterestIndication_v1310_IEs;
static int ett_lte_rrc_MBMSInterestIndication_v1540_IEs;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxMBMS_ServiceListPerUE_r13_OF_MBMS_ROM_Info_r15;
static int ett_lte_rrc_MBMSInterestIndication_v1610_IEs;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxMBMS_ServiceListPerUE_r13_OF_MBMS_ROM_Info_r16;
static int ett_lte_rrc_T_nonCriticalExtension_22;
static int ett_lte_rrc_MBMS_ROM_Info_r15;
static int ett_lte_rrc_MBMS_ROM_Info_r16;
static int ett_lte_rrc_MBSFNAreaConfiguration_r9;
static int ett_lte_rrc_MBSFNAreaConfiguration_v930_IEs;
static int ett_lte_rrc_MBSFNAreaConfiguration_v1250_IEs;
static int ett_lte_rrc_MBSFNAreaConfiguration_v1430_IEs;
static int ett_lte_rrc_MBSFNAreaConfiguration_v1610_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_23;
static int ett_lte_rrc_CommonSF_AllocPatternList_r9;
static int ett_lte_rrc_CommonSF_AllocPatternList_v1430;
static int ett_lte_rrc_CommonSF_AllocPatternList_v1610;
static int ett_lte_rrc_MCGFailureInformation_r16;
static int ett_lte_rrc_T_criticalExtensions_20;
static int ett_lte_rrc_T_criticalExtensionsFuture_20;
static int ett_lte_rrc_MCGFailureInformation_r16_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_24;
static int ett_lte_rrc_FailureReportMCG_r16;
static int ett_lte_rrc_MeasReportAppLayer_r15;
static int ett_lte_rrc_T_criticalExtensions_21;
static int ett_lte_rrc_T_criticalExtensionsFuture_21;
static int ett_lte_rrc_MeasReportAppLayer_r15_IEs;
static int ett_lte_rrc_MeasReportAppLayer_v1590_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_25;
static int ett_lte_rrc_MeasurementReport;
static int ett_lte_rrc_T_criticalExtensions_22;
static int ett_lte_rrc_T_c1_25;
static int ett_lte_rrc_T_criticalExtensionsFuture_22;
static int ett_lte_rrc_MeasurementReport_r8_IEs;
static int ett_lte_rrc_MeasurementReport_v8a0_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_26;
static int ett_lte_rrc_MobilityFromEUTRACommand;
static int ett_lte_rrc_T_criticalExtensions_23;
static int ett_lte_rrc_T_c1_26;
static int ett_lte_rrc_T_criticalExtensionsFuture_23;
static int ett_lte_rrc_MobilityFromEUTRACommand_r8_IEs;
static int ett_lte_rrc_T_purpose;
static int ett_lte_rrc_MobilityFromEUTRACommand_v8a0_IEs;
static int ett_lte_rrc_MobilityFromEUTRACommand_v8d0_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_27;
static int ett_lte_rrc_MobilityFromEUTRACommand_r9_IEs;
static int ett_lte_rrc_T_purpose_01;
static int ett_lte_rrc_MobilityFromEUTRACommand_v930_IEs;
static int ett_lte_rrc_MobilityFromEUTRACommand_v960_IEs;
static int ett_lte_rrc_MobilityFromEUTRACommand_v1530_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_28;
static int ett_lte_rrc_Handover;
static int ett_lte_rrc_CellChangeOrder;
static int ett_lte_rrc_T_targetRAT_Type_01;
static int ett_lte_rrc_T_geran;
static int ett_lte_rrc_SI_OrPSI_GERAN;
static int ett_lte_rrc_E_CSFB_r9;
static int ett_lte_rrc_Paging;
static int ett_lte_rrc_Paging_v890_IEs;
static int ett_lte_rrc_Paging_v920_IEs;
static int ett_lte_rrc_Paging_v1130_IEs;
static int ett_lte_rrc_Paging_v1310_IEs;
static int ett_lte_rrc_Paging_v1530_IEs;
static int ett_lte_rrc_Paging_v1610_IEs;
static int ett_lte_rrc_Paging_v1700_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_29;
static int ett_lte_rrc_PagingRecordList;
static int ett_lte_rrc_PagingRecordList_v1610;
static int ett_lte_rrc_PagingRecordList_v1700;
static int ett_lte_rrc_PagingRecord;
static int ett_lte_rrc_PagingRecord_v1610;
static int ett_lte_rrc_PagingRecord_v1700;
static int ett_lte_rrc_PagingUE_Identity;
static int ett_lte_rrc_IMSI;
static int ett_lte_rrc_ProximityIndication_r9;
static int ett_lte_rrc_T_criticalExtensions_24;
static int ett_lte_rrc_T_c1_27;
static int ett_lte_rrc_T_criticalExtensionsFuture_24;
static int ett_lte_rrc_ProximityIndication_r9_IEs;
static int ett_lte_rrc_T_carrierFreq_r9;
static int ett_lte_rrc_ProximityIndication_v930_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_30;
static int ett_lte_rrc_PURConfigurationRequest_r16;
static int ett_lte_rrc_T_criticalExtensions_25;
static int ett_lte_rrc_T_criticalExtensionsFuture_25;
static int ett_lte_rrc_PURConfigurationRequest_r16_IEs;
static int ett_lte_rrc_T_pur_ConfigRequest_r16;
static int ett_lte_rrc_T_pur_SetupRequest;
static int ett_lte_rrc_T_nonCriticalExtension_31;
static int ett_lte_rrc_RNReconfiguration_r10;
static int ett_lte_rrc_T_criticalExtensions_26;
static int ett_lte_rrc_T_c1_28;
static int ett_lte_rrc_T_criticalExtensionsFuture_26;
static int ett_lte_rrc_RNReconfiguration_r10_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_32;
static int ett_lte_rrc_RN_SystemInfo_r10;
static int ett_lte_rrc_RNReconfigurationComplete_r10;
static int ett_lte_rrc_T_criticalExtensions_27;
static int ett_lte_rrc_T_c1_29;
static int ett_lte_rrc_T_criticalExtensionsFuture_27;
static int ett_lte_rrc_RNReconfigurationComplete_r10_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_33;
static int ett_lte_rrc_RRCConnectionReconfiguration;
static int ett_lte_rrc_T_criticalExtensions_28;
static int ett_lte_rrc_T_c1_30;
static int ett_lte_rrc_T_criticalExtensionsFuture_28;
static int ett_lte_rrc_RRCConnectionReconfiguration_r8_IEs;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxDRB_OF_DedicatedInfoNAS;
static int ett_lte_rrc_RRCConnectionReconfiguration_v890_IEs;
static int ett_lte_rrc_RRCConnectionReconfiguration_v8m0_IEs;
static int ett_lte_rrc_RRCConnectionReconfiguration_v10i0_IEs;
static int ett_lte_rrc_RRCConnectionReconfiguration_v10l0_IEs;
static int ett_lte_rrc_RRCConnectionReconfiguration_v12f0_IEs;
static int ett_lte_rrc_RRCConnectionReconfiguration_v1370_IEs;
static int ett_lte_rrc_RRCConnectionReconfiguration_v13c0_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_34;
static int ett_lte_rrc_RRCConnectionReconfiguration_v920_IEs;
static int ett_lte_rrc_RRCConnectionReconfiguration_v1020_IEs;
static int ett_lte_rrc_RRCConnectionReconfiguration_v1130_IEs;
static int ett_lte_rrc_RRCConnectionReconfiguration_v1250_IEs;
static int ett_lte_rrc_T_wlan_OffloadInfo_r12;
static int ett_lte_rrc_T_rRCConnectionReconfiguration_v1250_IEs_wlan_OffloadInfo_r12_setup;
static int ett_lte_rrc_RRCConnectionReconfiguration_v1310_IEs;
static int ett_lte_rrc_RRCConnectionReconfiguration_v1430_IEs;
static int ett_lte_rrc_RRCConnectionReconfiguration_v1510_IEs;
static int ett_lte_rrc_T_nr_Config_r15;
static int ett_lte_rrc_T_rRCConnectionReconfiguration_v1510_IEs_nr_Config_r15_setup;
static int ett_lte_rrc_RRCConnectionReconfiguration_v1530_IEs;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxDRB_r15_OF_DedicatedInfoNAS;
static int ett_lte_rrc_RRCConnectionReconfiguration_v1610_IEs;
static int ett_lte_rrc_RRCConnectionReconfiguration_v1700_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_35;
static int ett_lte_rrc_SL_SyncTxControl_r12;
static int ett_lte_rrc_PSCellToAddMod_r12;
static int ett_lte_rrc_T_cellIdentification_r12_01;
static int ett_lte_rrc_PSCellToAddMod_v12f0;
static int ett_lte_rrc_PSCellToAddMod_v1440;
static int ett_lte_rrc_PowerCoordinationInfo_r12;
static int ett_lte_rrc_SCellToAddModList_r10;
static int ett_lte_rrc_SCellToAddModList_v10l0;
static int ett_lte_rrc_SCellToAddModList_v13c0;
static int ett_lte_rrc_SCellToAddModList_r16;
static int ett_lte_rrc_SCellToAddModListExt_r13;
static int ett_lte_rrc_SCellToAddModListExt_v1370;
static int ett_lte_rrc_SCellToAddModListExt_v13c0;
static int ett_lte_rrc_SCellToAddModListExt_v1430;
static int ett_lte_rrc_SCellGroupToAddModList_r15;
static int ett_lte_rrc_SCellToAddMod_r10;
static int ett_lte_rrc_T_cellIdentification_r10;
static int ett_lte_rrc_SCellToAddMod_v10l0;
static int ett_lte_rrc_SCellToAddMod_v13c0;
static int ett_lte_rrc_SCellToAddMod_r16;
static int ett_lte_rrc_T_cellIdentification_r16;
static int ett_lte_rrc_SCellToAddModExt_r13;
static int ett_lte_rrc_T_cellIdentification_r13;
static int ett_lte_rrc_SCellToAddModExt_v1370;
static int ett_lte_rrc_SCellToAddModExt_v1430;
static int ett_lte_rrc_SCellGroupToAddMod_r15;
static int ett_lte_rrc_SCellToReleaseList_r10;
static int ett_lte_rrc_SCellToReleaseListExt_r13;
static int ett_lte_rrc_SCellGroupToReleaseList_r15;
static int ett_lte_rrc_SCellConfigCommon_r15;
static int ett_lte_rrc_SCG_Configuration_r12;
static int ett_lte_rrc_T_sCG_Configuration_r12_setup;
static int ett_lte_rrc_T_scg_ConfigPartMCG_r12;
static int ett_lte_rrc_SCG_Configuration_v12f0;
static int ett_lte_rrc_T_sCG_Configuration_v12f0_setup;
static int ett_lte_rrc_SCG_Configuration_v13c0;
static int ett_lte_rrc_T_sCG_Configuration_v13c0_setup;
static int ett_lte_rrc_SCG_ConfigPartSCG_r12;
static int ett_lte_rrc_SCG_ConfigPartSCG_v12f0;
static int ett_lte_rrc_SCG_ConfigPartSCG_v13c0;
static int ett_lte_rrc_SecurityConfigHO;
static int ett_lte_rrc_T_handoverType;
static int ett_lte_rrc_T_intraLTE;
static int ett_lte_rrc_T_interRAT;
static int ett_lte_rrc_SecurityConfigHO_v1530;
static int ett_lte_rrc_T_handoverType_v1530;
static int ett_lte_rrc_T_intra5GC;
static int ett_lte_rrc_T_fivegc_ToEPC;
static int ett_lte_rrc_T_epc_To5GC;
static int ett_lte_rrc_RRCConnectionReconfigurationComplete;
static int ett_lte_rrc_T_criticalExtensions_29;
static int ett_lte_rrc_T_criticalExtensionsFuture_29;
static int ett_lte_rrc_RRCConnectionReconfigurationComplete_r8_IEs;
static int ett_lte_rrc_RRCConnectionReconfigurationComplete_v8a0_IEs;
static int ett_lte_rrc_RRCConnectionReconfigurationComplete_v1020_IEs;
static int ett_lte_rrc_RRCConnectionReconfigurationComplete_v1130_IEs;
static int ett_lte_rrc_RRCConnectionReconfigurationComplete_v1250_IEs;
static int ett_lte_rrc_RRCConnectionReconfigurationComplete_v1430_IEs;
static int ett_lte_rrc_RRCConnectionReconfigurationComplete_v1510_IEs;
static int ett_lte_rrc_RRCConnectionReconfigurationComplete_v1530_IEs;
static int ett_lte_rrc_RRCConnectionReconfigurationComplete_v1700_IEs;
static int ett_lte_rrc_RRCConnectionReconfigurationComplete_v1710_IEs;
static int ett_lte_rrc_RRCConnectionReconfigurationComplete_v1800_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_36;
static int ett_lte_rrc_RRCConnectionReestablishment;
static int ett_lte_rrc_T_criticalExtensions_30;
static int ett_lte_rrc_T_c1_31;
static int ett_lte_rrc_T_criticalExtensionsFuture_30;
static int ett_lte_rrc_RRCConnectionReestablishment_r8_IEs;
static int ett_lte_rrc_RRCConnectionReestablishment_v8a0_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_37;
static int ett_lte_rrc_RRCConnectionReestablishmentComplete;
static int ett_lte_rrc_T_criticalExtensions_31;
static int ett_lte_rrc_T_criticalExtensionsFuture_31;
static int ett_lte_rrc_RRCConnectionReestablishmentComplete_r8_IEs;
static int ett_lte_rrc_RRCConnectionReestablishmentComplete_v920_IEs;
static int ett_lte_rrc_RRCConnectionReestablishmentComplete_v8a0_IEs;
static int ett_lte_rrc_RRCConnectionReestablishmentComplete_v1020_IEs;
static int ett_lte_rrc_RRCConnectionReestablishmentComplete_v1130_IEs;
static int ett_lte_rrc_RRCConnectionReestablishmentComplete_v1250_IEs;
static int ett_lte_rrc_RRCConnectionReestablishmentComplete_v1530_IEs;
static int ett_lte_rrc_RRCConnectionReestablishmentComplete_v1710_IEs;
static int ett_lte_rrc_RRCConnectionReestablishmentComplete_v1800_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_38;
static int ett_lte_rrc_RRCConnectionReestablishmentReject;
static int ett_lte_rrc_T_criticalExtensions_32;
static int ett_lte_rrc_T_criticalExtensionsFuture_32;
static int ett_lte_rrc_RRCConnectionReestablishmentReject_r8_IEs;
static int ett_lte_rrc_RRCConnectionReestablishmentReject_v8a0_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_39;
static int ett_lte_rrc_RRCConnectionReestablishmentRequest;
static int ett_lte_rrc_T_criticalExtensions_33;
static int ett_lte_rrc_T_criticalExtensionsFuture_33;
static int ett_lte_rrc_RRCConnectionReestablishmentRequest_r8_IEs;
static int ett_lte_rrc_ReestabUE_Identity;
static int ett_lte_rrc_RRCConnectionReject;
static int ett_lte_rrc_T_criticalExtensions_34;
static int ett_lte_rrc_T_c1_32;
static int ett_lte_rrc_T_criticalExtensionsFuture_34;
static int ett_lte_rrc_RRCConnectionReject_r8_IEs;
static int ett_lte_rrc_RRCConnectionReject_v8a0_IEs;
static int ett_lte_rrc_RRCConnectionReject_v1020_IEs;
static int ett_lte_rrc_RRCConnectionReject_v1130_IEs;
static int ett_lte_rrc_T_deprioritisationReq_r11;
static int ett_lte_rrc_RRCConnectionReject_v1320_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_40;
static int ett_lte_rrc_RRCConnectionRelease;
static int ett_lte_rrc_T_criticalExtensions_35;
static int ett_lte_rrc_T_c1_33;
static int ett_lte_rrc_T_criticalExtensionsFuture_35;
static int ett_lte_rrc_RRCConnectionRelease_r8_IEs;
static int ett_lte_rrc_RRCConnectionRelease_v890_IEs;
static int ett_lte_rrc_RRCConnectionRelease_v9e0_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_41;
static int ett_lte_rrc_RRCConnectionRelease_v920_IEs;
static int ett_lte_rrc_T_cellInfoList_r9;
static int ett_lte_rrc_RRCConnectionRelease_v1020_IEs;
static int ett_lte_rrc_RRCConnectionRelease_v1320_IEs;
static int ett_lte_rrc_RRCConnectionRelease_v1530_IEs;
static int ett_lte_rrc_RRCConnectionRelease_v1540_IEs;
static int ett_lte_rrc_RRCConnectionRelease_v15b0_IEs;
static int ett_lte_rrc_RRCConnectionRelease_v1610_IEs;
static int ett_lte_rrc_T_pur_Config_r16;
static int ett_lte_rrc_RRCConnectionRelease_v1650_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_42;
static int ett_lte_rrc_RedirectedCarrierInfo;
static int ett_lte_rrc_RedirectedCarrierInfo_v9e0;
static int ett_lte_rrc_RRC_InactiveConfig_r15;
static int ett_lte_rrc_T_rRC_InactiveConfig_r15_dummy;
static int ett_lte_rrc_RRC_InactiveConfig_v1610;
static int ett_lte_rrc_RAN_NotificationAreaInfo_r15;
static int ett_lte_rrc_PLMN_RAN_AreaCellList_r15;
static int ett_lte_rrc_PLMN_RAN_AreaCell_r15;
static int ett_lte_rrc_SEQUENCE_SIZE_1_32_OF_CellIdentity;
static int ett_lte_rrc_PLMN_RAN_AreaConfigList_r15;
static int ett_lte_rrc_PLMN_RAN_AreaConfig_r15;
static int ett_lte_rrc_SEQUENCE_SIZE_1_16_OF_RAN_AreaConfig_r15;
static int ett_lte_rrc_RAN_AreaConfig_r15;
static int ett_lte_rrc_SEQUENCE_SIZE_1_32_OF_RAN_AreaCode_r15;
static int ett_lte_rrc_CarrierFreqListUTRA_TDD_r10;
static int ett_lte_rrc_IdleModeMobilityControlInfo;
static int ett_lte_rrc_IdleModeMobilityControlInfo_v9e0;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxFreq_OF_FreqPriorityEUTRA_v9e0;
static int ett_lte_rrc_FreqPriorityListEUTRA;
static int ett_lte_rrc_FreqPriorityListExtEUTRA_r12;
static int ett_lte_rrc_FreqPriorityListEUTRA_v1310;
static int ett_lte_rrc_FreqPriorityListExtEUTRA_v1310;
static int ett_lte_rrc_FreqPriorityEUTRA;
static int ett_lte_rrc_FreqPriorityEUTRA_v9e0;
static int ett_lte_rrc_FreqPriorityEUTRA_r12;
static int ett_lte_rrc_FreqPriorityEUTRA_v1310;
static int ett_lte_rrc_FreqPriorityListNR_r15;
static int ett_lte_rrc_FreqPriorityNR_r15;
static int ett_lte_rrc_FreqsPriorityListGERAN;
static int ett_lte_rrc_FreqsPriorityGERAN;
static int ett_lte_rrc_FreqPriorityListUTRA_FDD;
static int ett_lte_rrc_FreqPriorityUTRA_FDD;
static int ett_lte_rrc_FreqPriorityListUTRA_TDD;
static int ett_lte_rrc_FreqPriorityUTRA_TDD;
static int ett_lte_rrc_BandClassPriorityListHRPD;
static int ett_lte_rrc_BandClassPriorityHRPD;
static int ett_lte_rrc_BandClassPriorityList1XRTT;
static int ett_lte_rrc_BandClassPriority1XRTT;
static int ett_lte_rrc_CellInfoListGERAN_r9;
static int ett_lte_rrc_CellInfoGERAN_r9;
static int ett_lte_rrc_CarrierInfoNR_r15;
static int ett_lte_rrc_CarrierInfoNR_r17;
static int ett_lte_rrc_CellInfoListUTRA_FDD_r9;
static int ett_lte_rrc_CellInfoUTRA_FDD_r9;
static int ett_lte_rrc_CellInfoListUTRA_TDD_r9;
static int ett_lte_rrc_CellInfoUTRA_TDD_r9;
static int ett_lte_rrc_CellInfoListUTRA_TDD_r10;
static int ett_lte_rrc_CellInfoUTRA_TDD_r10;
static int ett_lte_rrc_RRCConnectionRequest;
static int ett_lte_rrc_T_criticalExtensions_36;
static int ett_lte_rrc_RRCConnectionRequest_r8_IEs;
static int ett_lte_rrc_RRCConnectionRequest_5GC_r15_IEs;
static int ett_lte_rrc_InitialUE_Identity;
static int ett_lte_rrc_InitialUE_Identity_5GC_r15;
static int ett_lte_rrc_RRCConnectionResume_r13;
static int ett_lte_rrc_T_criticalExtensions_37;
static int ett_lte_rrc_T_c1_34;
static int ett_lte_rrc_T_criticalExtensionsFuture_36;
static int ett_lte_rrc_RRCConnectionResume_r13_IEs;
static int ett_lte_rrc_RRCConnectionResume_v1430_IEs;
static int ett_lte_rrc_RRCConnectionResume_v1510_IEs;
static int ett_lte_rrc_RRCConnectionResume_v1530_IEs;
static int ett_lte_rrc_RRCConnectionResume_v1610_IEs;
static int ett_lte_rrc_RRCConnectionResume_v1700_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_43;
static int ett_lte_rrc_RRCConnectionResumeComplete_r13;
static int ett_lte_rrc_T_criticalExtensions_38;
static int ett_lte_rrc_T_criticalExtensionsFuture_37;
static int ett_lte_rrc_RRCConnectionResumeComplete_r13_IEs;
static int ett_lte_rrc_RRCConnectionResumeComplete_v1530_IEs;
static int ett_lte_rrc_RRCConnectionResumeComplete_v1610_IEs;
static int ett_lte_rrc_RRCConnectionResumeComplete_v1710_IEs;
static int ett_lte_rrc_RRCConnectionResumeComplete_v1800_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_44;
static int ett_lte_rrc_RRCConnectionResumeRequest_r13;
static int ett_lte_rrc_T_criticalExtensions_39;
static int ett_lte_rrc_RRCConnectionResumeRequest_r13_IEs;
static int ett_lte_rrc_T_rRCConnectionResumeRequest_r13_IEs_resumeIdentity_r13;
static int ett_lte_rrc_RRCConnectionResumeRequest_5GC_r15_IEs;
static int ett_lte_rrc_T_resumeIdentity_r15;
static int ett_lte_rrc_RRCConnectionSetup;
static int ett_lte_rrc_T_criticalExtensions_40;
static int ett_lte_rrc_T_c1_35;
static int ett_lte_rrc_T_criticalExtensionsFuture_38;
static int ett_lte_rrc_RRCConnectionSetup_r8_IEs;
static int ett_lte_rrc_RRCConnectionSetup_v8a0_IEs;
static int ett_lte_rrc_RRCConnectionSetup_v1610_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_45;
static int ett_lte_rrc_RRCConnectionSetupComplete;
static int ett_lte_rrc_T_criticalExtensions_41;
static int ett_lte_rrc_T_c1_36;
static int ett_lte_rrc_T_criticalExtensionsFuture_39;
static int ett_lte_rrc_RRCConnectionSetupComplete_r8_IEs;
static int ett_lte_rrc_RRCConnectionSetupComplete_v8a0_IEs;
static int ett_lte_rrc_RRCConnectionSetupComplete_v1020_IEs;
static int ett_lte_rrc_RRCConnectionSetupComplete_v1130_IEs;
static int ett_lte_rrc_RRCConnectionSetupComplete_v1250_IEs;
static int ett_lte_rrc_RRCConnectionSetupComplete_v1320_IEs;
static int ett_lte_rrc_RRCConnectionSetupComplete_v1330_IEs;
static int ett_lte_rrc_RRCConnectionSetupComplete_v1430_IEs;
static int ett_lte_rrc_RRCConnectionSetupComplete_v1530_IEs;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxNrofS_NSSAI_r15_OF_S_NSSAI_r15;
static int ett_lte_rrc_T_ng_5G_S_TMSI_Bits_r15;
static int ett_lte_rrc_RRCConnectionSetupComplete_v1540_IEs;
static int ett_lte_rrc_RRCConnectionSetupComplete_v1610_IEs;
static int ett_lte_rrc_RRCConnectionSetupComplete_v1690_IEs;
static int ett_lte_rrc_RRCConnectionSetupComplete_v1710_IEs;
static int ett_lte_rrc_RRCConnectionSetupComplete_v1800_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_46;
static int ett_lte_rrc_RegisteredMME;
static int ett_lte_rrc_RegisteredAMF_r15;
static int ett_lte_rrc_RRCEarlyDataComplete_r15;
static int ett_lte_rrc_T_criticalExtensions_42;
static int ett_lte_rrc_T_criticalExtensionsFuture_40;
static int ett_lte_rrc_RRCEarlyDataComplete_r15_IEs;
static int ett_lte_rrc_RRCEarlyDataComplete_v1590_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_47;
static int ett_lte_rrc_RedirectedCarrierInfo_r15_IEs;
static int ett_lte_rrc_RRCEarlyDataRequest_r15;
static int ett_lte_rrc_T_criticalExtensions_43;
static int ett_lte_rrc_T_criticalExtensionsFuture_41;
static int ett_lte_rrc_T_criticalExtensionsFuture_r16;
static int ett_lte_rrc_RRCEarlyDataRequest_r15_IEs;
static int ett_lte_rrc_RRCEarlyDataRequest_v1590_IEs;
static int ett_lte_rrc_RRCEarlyDataRequest_v1610_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_48;
static int ett_lte_rrc_RRCEarlyDataRequest_5GC_r16_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_49;
static int ett_lte_rrc_SCGFailureInformation_r12;
static int ett_lte_rrc_T_criticalExtensions_44;
static int ett_lte_rrc_T_c1_37;
static int ett_lte_rrc_T_criticalExtensionsFuture_42;
static int ett_lte_rrc_SCGFailureInformation_r12_IEs;
static int ett_lte_rrc_SCGFailureInformation_v12d0a_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_50;
static int ett_lte_rrc_SCGFailureInformation_v12d0b_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_51;
static int ett_lte_rrc_FailureReportSCG_r12;
static int ett_lte_rrc_FailureReportSCG_v12d0;
static int ett_lte_rrc_SCGFailureInformationNR_r15;
static int ett_lte_rrc_T_criticalExtensions_45;
static int ett_lte_rrc_T_c1_38;
static int ett_lte_rrc_T_criticalExtensionsFuture_43;
static int ett_lte_rrc_SCGFailureInformationNR_r15_IEs;
static int ett_lte_rrc_SCGFailureInformationNR_v1590_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_52;
static int ett_lte_rrc_FailureReportSCG_NR_r15;
static int ett_lte_rrc_MeasResultFreqListFailNR_r15;
static int ett_lte_rrc_MeasResultFreqFailNR_r15;
static int ett_lte_rrc_SCPTMConfiguration_r13;
static int ett_lte_rrc_SCPTMConfiguration_v1340;
static int ett_lte_rrc_T_nonCriticalExtension_53;
static int ett_lte_rrc_SCPTMConfiguration_BR_r14;
static int ett_lte_rrc_SCPTMConfiguration_BR_v1610;
static int ett_lte_rrc_T_nonCriticalExtension_54;
static int ett_lte_rrc_SecurityModeCommand;
static int ett_lte_rrc_T_criticalExtensions_46;
static int ett_lte_rrc_T_c1_39;
static int ett_lte_rrc_T_criticalExtensionsFuture_44;
static int ett_lte_rrc_SecurityModeCommand_r8_IEs;
static int ett_lte_rrc_SecurityModeCommand_v8a0_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_55;
static int ett_lte_rrc_SecurityConfigSMC;
static int ett_lte_rrc_SecurityModeComplete;
static int ett_lte_rrc_T_criticalExtensions_47;
static int ett_lte_rrc_T_criticalExtensionsFuture_45;
static int ett_lte_rrc_SecurityModeComplete_r8_IEs;
static int ett_lte_rrc_SecurityModeComplete_v8a0_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_56;
static int ett_lte_rrc_SecurityModeFailure;
static int ett_lte_rrc_T_criticalExtensions_48;
static int ett_lte_rrc_T_criticalExtensionsFuture_46;
static int ett_lte_rrc_SecurityModeFailure_r8_IEs;
static int ett_lte_rrc_SecurityModeFailure_v8a0_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_57;
static int ett_lte_rrc_SidelinkUEInformation_r12;
static int ett_lte_rrc_T_criticalExtensions_49;
static int ett_lte_rrc_T_c1_40;
static int ett_lte_rrc_T_criticalExtensionsFuture_47;
static int ett_lte_rrc_SidelinkUEInformation_r12_IEs;
static int ett_lte_rrc_SidelinkUEInformation_v1310_IEs;
static int ett_lte_rrc_T_commTxResourceInfoReqRelay_r13;
static int ett_lte_rrc_T_discTxResourceReq_v1310;
static int ett_lte_rrc_SidelinkUEInformation_v1430_IEs;
static int ett_lte_rrc_SidelinkUEInformation_v1530_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_58;
static int ett_lte_rrc_SL_CommTxResourceReq_r12;
static int ett_lte_rrc_SL_DiscTxResourceReqPerFreqList_r13;
static int ett_lte_rrc_SL_DiscTxResourceReq_r13;
static int ett_lte_rrc_SL_DestinationInfoList_r12;
static int ett_lte_rrc_SL_DiscSysInfoReportFreqList_r13;
static int ett_lte_rrc_SL_V2X_CommFreqList_r14;
static int ett_lte_rrc_SL_V2X_CommTxFreqList_r14;
static int ett_lte_rrc_SL_V2X_CommTxResourceReq_r14;
static int ett_lte_rrc_SystemInformation;
static int ett_lte_rrc_T_criticalExtensions_50;
static int ett_lte_rrc_T_criticalExtensionsFuture_r15;
static int ett_lte_rrc_T_criticalExtensionsFuture_48;
static int ett_lte_rrc_SystemInformation_r8_IEs;
static int ett_lte_rrc_T_sib_TypeAndInfo;
static int ett_lte_rrc_T_sib_TypeAndInfo_item;
static int ett_lte_rrc_SystemInformation_v8a0_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_59;
static int ett_lte_rrc_PosSystemInformation_r15_IEs;
static int ett_lte_rrc_T_posSIB_TypeAndInfo_r15;
static int ett_lte_rrc_T_posSIB_TypeAndInfo_r15_item;
static int ett_lte_rrc_T_nonCriticalExtension_60;
static int ett_lte_rrc_SystemInformationBlockType1;
static int ett_lte_rrc_T_cellAccessRelatedInfo;
static int ett_lte_rrc_T_cellSelectionInfo;
static int ett_lte_rrc_SystemInformationBlockType1_v890_IEs;
static int ett_lte_rrc_SystemInformationBlockType1_v8h0_IEs;
static int ett_lte_rrc_SystemInformationBlockType1_v9e0_IEs;
static int ett_lte_rrc_SystemInformationBlockType1_v10j0_IEs;
static int ett_lte_rrc_SystemInformationBlockType1_v10l0_IEs;
static int ett_lte_rrc_SystemInformationBlockType1_v10x0_IEs;
static int ett_lte_rrc_SystemInformationBlockType1_v12j0_IEs;
static int ett_lte_rrc_SystemInformationBlockType1_v15g0_IEs;
static int ett_lte_rrc_T_bandwidthReducedAccessRelatedInfo_v15g0;
static int ett_lte_rrc_T_nonCriticalExtension_61;
static int ett_lte_rrc_SystemInformationBlockType1_v920_IEs;
static int ett_lte_rrc_SystemInformationBlockType1_v1130_IEs;
static int ett_lte_rrc_SystemInformationBlockType1_v1250_IEs;
static int ett_lte_rrc_T_cellAccessRelatedInfo_v1250;
static int ett_lte_rrc_SystemInformationBlockType1_v1310_IEs;
static int ett_lte_rrc_T_bandwidthReducedAccessRelatedInfo_r13;
static int ett_lte_rrc_T_fdd_DownlinkOrTddSubframeBitmapBR_r13;
static int ett_lte_rrc_SystemInformationBlockType1_v1320_IEs;
static int ett_lte_rrc_T_freqHoppingParametersDL_r13;
static int ett_lte_rrc_T_interval_DLHoppingConfigCommonModeA_r13;
static int ett_lte_rrc_T_interval_DLHoppingConfigCommonModeB_r13;
static int ett_lte_rrc_SystemInformationBlockType1_v1350_IEs;
static int ett_lte_rrc_SystemInformationBlockType1_v1360_IEs;
static int ett_lte_rrc_SystemInformationBlockType1_v1430_IEs;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxPLMN_1_r14_OF_CellAccessRelatedInfo_r14;
static int ett_lte_rrc_SystemInformationBlockType1_v1450_IEs;
static int ett_lte_rrc_SystemInformationBlockType1_v1530_IEs;
static int ett_lte_rrc_T_crs_IntfMitigConfig_r15;
static int ett_lte_rrc_T_cellAccessRelatedInfo_5GC_r15;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxPLMN_r11_OF_CellAccessRelatedInfo_5GC_r15;
static int ett_lte_rrc_SystemInformationBlockType1_v1540_IEs;
static int ett_lte_rrc_SystemInformationBlockType1_v1610_IEs;
static int ett_lte_rrc_SystemInformationBlockType1_v1700_IEs;
static int ett_lte_rrc_T_cellAccessRelatedInfo_NTN_r17;
static int ett_lte_rrc_SystemInformationBlockType1_v1800_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_62;
static int ett_lte_rrc_PLMN_IdentityList;
static int ett_lte_rrc_PLMN_IdentityInfo;
static int ett_lte_rrc_PLMN_IdentityList_v1530;
static int ett_lte_rrc_PLMN_IdentityInfo_v1530;
static int ett_lte_rrc_PLMN_IdentityList_r15;
static int ett_lte_rrc_PLMN_IdentityList_v1610;
static int ett_lte_rrc_PLMN_IdentityList_v1700;
static int ett_lte_rrc_PLMN_IdentityInfo_r15;
static int ett_lte_rrc_T_plmn_Identity_5GC_r15;
static int ett_lte_rrc_PLMN_IdentityInfo_v1610;
static int ett_lte_rrc_PLMN_IdentityInfo_v1700;
static int ett_lte_rrc_SchedulingInfoList;
static int ett_lte_rrc_SchedulingInfoList_v12j0;
static int ett_lte_rrc_SchedulingInfoListExt_r12;
static int ett_lte_rrc_SchedulingInfo;
static int ett_lte_rrc_SchedulingInfo_v12j0;
static int ett_lte_rrc_SchedulingInfoExt_r12;
static int ett_lte_rrc_SchedulingInfoList_BR_r13;
static int ett_lte_rrc_SchedulingInfo_BR_r13;
static int ett_lte_rrc_SIB_MappingInfo;
static int ett_lte_rrc_SIB_MappingInfo_v12j0;
static int ett_lte_rrc_SystemInfoValueTagList_r13;
static int ett_lte_rrc_CellSelectionInfo_v920;
static int ett_lte_rrc_CellSelectionInfo_v1130;
static int ett_lte_rrc_CellSelectionInfo_v1250;
static int ett_lte_rrc_CellAccessRelatedInfo_r14;
static int ett_lte_rrc_CellAccessRelatedInfo_5GC_r15;
static int ett_lte_rrc_CellIdentity_5GC_r15;
static int ett_lte_rrc_TrackingAreaList_r17;
static int ett_lte_rrc_PosSchedulingInfoList_r15;
static int ett_lte_rrc_PosSchedulingInfo_r15;
static int ett_lte_rrc_PosSIB_MappingInfo_r15;
static int ett_lte_rrc_PosSIB_Type_r15;
static int ett_lte_rrc_SystemInformationBlockType1_MBMS_r14;
static int ett_lte_rrc_T_cellAccessRelatedInfo_r14;
static int ett_lte_rrc_T_nonCriticalExtension_63;
static int ett_lte_rrc_PLMN_IdentityList_MBMS_r14;
static int ett_lte_rrc_SchedulingInfoList_MBMS_r14;
static int ett_lte_rrc_SchedulingInfo_MBMS_r14;
static int ett_lte_rrc_SIB_MappingInfo_MBMS_r14;
static int ett_lte_rrc_NonMBSFN_SubframeConfig_r14;
static int ett_lte_rrc_UEAssistanceInformation_r11;
static int ett_lte_rrc_T_criticalExtensions_51;
static int ett_lte_rrc_T_c1_41;
static int ett_lte_rrc_T_criticalExtensionsFuture_49;
static int ett_lte_rrc_UEAssistanceInformation_r11_IEs;
static int ett_lte_rrc_UEAssistanceInformation_v1430_IEs;
static int ett_lte_rrc_T_sps_AssistanceInformation_r14;
static int ett_lte_rrc_T_rlm_Report_r14;
static int ett_lte_rrc_UEAssistanceInformation_v1450_IEs;
static int ett_lte_rrc_UEAssistanceInformation_v1530_IEs;
static int ett_lte_rrc_T_sps_AssistanceInformation_v1530;
static int ett_lte_rrc_UEAssistanceInformation_v1610_IEs;
static int ett_lte_rrc_UEAssistanceInformation_v1700_IEs;
static int ett_lte_rrc_UEAssistanceInformation_v1710_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_64;
static int ett_lte_rrc_BW_Preference_r14;
static int ett_lte_rrc_TrafficPatternInfoList_r14;
static int ett_lte_rrc_TrafficPatternInfo_r14;
static int ett_lte_rrc_TrafficPatternInfoList_v1530;
static int ett_lte_rrc_TrafficPatternInfo_v1530;
static int ett_lte_rrc_DelayBudgetReport_r14;
static int ett_lte_rrc_OverheatingAssistance_r14;
static int ett_lte_rrc_T_reducedUE_Category;
static int ett_lte_rrc_T_reducedMaxCCs;
static int ett_lte_rrc_OverheatingAssistance_v1610;
static int ett_lte_rrc_OverheatingAssistance_v1710;
static int ett_lte_rrc_UECapabilityEnquiry;
static int ett_lte_rrc_T_criticalExtensions_52;
static int ett_lte_rrc_T_c1_42;
static int ett_lte_rrc_T_criticalExtensionsFuture_50;
static int ett_lte_rrc_UECapabilityEnquiry_r8_IEs;
static int ett_lte_rrc_UECapabilityEnquiry_v8a0_IEs;
static int ett_lte_rrc_UECapabilityEnquiry_v1180_IEs;
static int ett_lte_rrc_SEQUENCE_SIZE_1_16_OF_FreqBandIndicator_r11;
static int ett_lte_rrc_UECapabilityEnquiry_v1310_IEs;
static int ett_lte_rrc_UECapabilityEnquiry_v1430_IEs;
static int ett_lte_rrc_UECapabilityEnquiry_v1510_IEs;
static int ett_lte_rrc_UECapabilityEnquiry_v1530_IEs;
static int ett_lte_rrc_UECapabilityEnquiry_v1550_IEs;
static int ett_lte_rrc_UECapabilityEnquiry_v1560_IEs;
static int ett_lte_rrc_UECapabilityEnquiry_v1610_IEs;
static int ett_lte_rrc_UECapabilityEnquiry_v1710_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_65;
static int ett_lte_rrc_UE_CapabilityRequest;
static int ett_lte_rrc_UECapabilityInformation;
static int ett_lte_rrc_T_criticalExtensions_53;
static int ett_lte_rrc_T_c1_43;
static int ett_lte_rrc_T_criticalExtensionsFuture_51;
static int ett_lte_rrc_UECapabilityInformation_r8_IEs;
static int ett_lte_rrc_UECapabilityInformation_v8a0_IEs;
static int ett_lte_rrc_UECapabilityInformation_v1250_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_66;
static int ett_lte_rrc_ULDedicatedMessageSegment_r16;
static int ett_lte_rrc_T_criticalExtensions_54;
static int ett_lte_rrc_T_criticalExtensionsFuture_52;
static int ett_lte_rrc_ULDedicatedMessageSegment_r16_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_67;
static int ett_lte_rrc_UEInformationRequest_r9;
static int ett_lte_rrc_T_criticalExtensions_55;
static int ett_lte_rrc_T_c1_44;
static int ett_lte_rrc_T_criticalExtensionsFuture_53;
static int ett_lte_rrc_UEInformationRequest_r9_IEs;
static int ett_lte_rrc_UEInformationRequest_v930_IEs;
static int ett_lte_rrc_UEInformationRequest_v1020_IEs;
static int ett_lte_rrc_UEInformationRequest_v1130_IEs;
static int ett_lte_rrc_UEInformationRequest_v1250_IEs;
static int ett_lte_rrc_UEInformationRequest_v1530_IEs;
static int ett_lte_rrc_UEInformationRequest_v1710_IEs;
static int ett_lte_rrc_UEInformationRequest_v1800_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_68;
static int ett_lte_rrc_UEInformationResponse_r9;
static int ett_lte_rrc_T_criticalExtensions_56;
static int ett_lte_rrc_T_c1_45;
static int ett_lte_rrc_T_criticalExtensionsFuture_54;
static int ett_lte_rrc_UEInformationResponse_r9_IEs;
static int ett_lte_rrc_UEInformationResponse_v9e0_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_69;
static int ett_lte_rrc_UEInformationResponse_v930_IEs;
static int ett_lte_rrc_UEInformationResponse_v1020_IEs;
static int ett_lte_rrc_UEInformationResponse_v1130_IEs;
static int ett_lte_rrc_UEInformationResponse_v1250_IEs;
static int ett_lte_rrc_UEInformationResponse_v1530_IEs;
static int ett_lte_rrc_UEInformationResponse_v1610_IEs;
static int ett_lte_rrc_UEInformationResponse_v1710_IEs;
static int ett_lte_rrc_UEInformationResponse_v1800_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_70;
static int ett_lte_rrc_RACH_Report_r16;
static int ett_lte_rrc_RACH_Report_v1610;
static int ett_lte_rrc_RACH_ReportNR_r18;
static int ett_lte_rrc_CellIdListNR_r18;
static int ett_lte_rrc_CellIdNR_r18;
static int ett_lte_rrc_T_pci_arfcn_r18;
static int ett_lte_rrc_RLF_Report_r9;
static int ett_lte_rrc_T_measResultLastServCell_r9;
static int ett_lte_rrc_T_measResultNeighCells_r9;
static int ett_lte_rrc_T_failedPCellId_r10;
static int ett_lte_rrc_T_pci_arfcn_r10;
static int ett_lte_rrc_T_failedPCellId_v1090;
static int ett_lte_rrc_T_basicFields_r11;
static int ett_lte_rrc_T_previousUTRA_CellId_r11;
static int ett_lte_rrc_T_physCellId_r11;
static int ett_lte_rrc_T_selectedUTRA_CellId_r11;
static int ett_lte_rrc_T_physCellId_r11_01;
static int ett_lte_rrc_T_failedPCellId_v1250;
static int ett_lte_rrc_T_failedNR_PCellId_r16;
static int ett_lte_rrc_T_pci_arfcn;
static int ett_lte_rrc_T_reconnectCellId_r16;
static int ett_lte_rrc_T_eutraReconnectCellId;
static int ett_lte_rrc_T_measResultListNR_v1640;
static int ett_lte_rrc_RLF_Report_v9e0;
static int ett_lte_rrc_MeasResultList2EUTRA_r9;
static int ett_lte_rrc_MeasResultList2EUTRA_v9e0;
static int ett_lte_rrc_MeasResultList2EUTRA_v1250;
static int ett_lte_rrc_MeasResult2EUTRA_r9;
static int ett_lte_rrc_MeasResult2EUTRA_v9e0;
static int ett_lte_rrc_MeasResult2EUTRA_v1250;
static int ett_lte_rrc_MeasResultList2UTRA_r9;
static int ett_lte_rrc_MeasResult2UTRA_r9;
static int ett_lte_rrc_MeasResultList2CDMA2000_r9;
static int ett_lte_rrc_MeasResult2CDMA2000_r9;
static int ett_lte_rrc_LogMeasReport_r10;
static int ett_lte_rrc_LogMeasInfoList_r10;
static int ett_lte_rrc_LogMeasInfo_r10;
static int ett_lte_rrc_T_measResultServCell_r10;
static int ett_lte_rrc_T_measResultNeighCells_r10;
static int ett_lte_rrc_T_measResultListNR_v1640_01;
static int ett_lte_rrc_MeasResultListMBSFN_r12;
static int ett_lte_rrc_MeasResultMBSFN_r12;
static int ett_lte_rrc_T_mbsfn_Area_r12;
static int ett_lte_rrc_DataBLER_MCH_ResultList_r12;
static int ett_lte_rrc_DataBLER_MCH_Result_r12;
static int ett_lte_rrc_BLER_Result_r12;
static int ett_lte_rrc_T_blocksReceived_r12;
static int ett_lte_rrc_MeasResultList2GERAN_r10;
static int ett_lte_rrc_MeasResultFreqListNR_r16;
static int ett_lte_rrc_ConnEstFailReport_r11;
static int ett_lte_rrc_T_measResultFailedCell_r11;
static int ett_lte_rrc_T_measResultNeighCells_r11;
static int ett_lte_rrc_T_measResultListNR_v1640_02;
static int ett_lte_rrc_FlightPathInfoReport_r15;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxWayPoint_r15_OF_WayPointLocation_r15;
static int ett_lte_rrc_T_dummy;
static int ett_lte_rrc_WayPointLocation_r15;
static int ett_lte_rrc_ULHandoverPreparationTransfer;
static int ett_lte_rrc_T_criticalExtensions_57;
static int ett_lte_rrc_T_c1_46;
static int ett_lte_rrc_T_criticalExtensionsFuture_55;
static int ett_lte_rrc_ULHandoverPreparationTransfer_r8_IEs;
static int ett_lte_rrc_ULHandoverPreparationTransfer_v8a0_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_71;
static int ett_lte_rrc_ULInformationTransfer;
static int ett_lte_rrc_T_criticalExtensions_58;
static int ett_lte_rrc_T_c1_47;
static int ett_lte_rrc_T_criticalExtensionsFuture_56;
static int ett_lte_rrc_ULInformationTransfer_r8_IEs;
static int ett_lte_rrc_T_dedicatedInfoType_01;
static int ett_lte_rrc_ULInformationTransfer_v8a0_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_72;
static int ett_lte_rrc_ULInformationTransfer_r16_IEs;
static int ett_lte_rrc_T_dedicatedInfoType_r16;
static int ett_lte_rrc_ULInformationTransferIRAT_r16;
static int ett_lte_rrc_T_criticalExtensions_59;
static int ett_lte_rrc_T_c1_48;
static int ett_lte_rrc_T_criticalExtensionsFuture_57;
static int ett_lte_rrc_ULInformationTransferIRAT_r16_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_73;
static int ett_lte_rrc_ULInformationTransferMRDC_r15;
static int ett_lte_rrc_T_criticalExtensions_60;
static int ett_lte_rrc_T_c1_49;
static int ett_lte_rrc_T_criticalExtensionsFuture_58;
static int ett_lte_rrc_ULInformationTransferMRDC_r15_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_74;
static int ett_lte_rrc_WLANConnectionStatusReport_r13;
static int ett_lte_rrc_T_criticalExtensions_61;
static int ett_lte_rrc_T_c1_50;
static int ett_lte_rrc_T_criticalExtensionsFuture_59;
static int ett_lte_rrc_WLANConnectionStatusReport_r13_IEs;
static int ett_lte_rrc_WLANConnectionStatusReport_v1430_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_75;
static int ett_lte_rrc_SystemInformationBlockPos_r15;
static int ett_lte_rrc_SystemInformationBlockType2;
static int ett_lte_rrc_T_ac_BarringInfo;
static int ett_lte_rrc_T_freqInfo;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxMultiBands_OF_AdditionalSpectrumEmission_r18;
static int ett_lte_rrc_SystemInformationBlockType2_v8h0_IEs;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxMultiBands_OF_AdditionalSpectrumEmission;
static int ett_lte_rrc_SystemInformationBlockType2_v9e0_IEs;
static int ett_lte_rrc_SystemInformationBlockType2_v9i0_IEs;
static int ett_lte_rrc_T_systemInformationBlockType2_v9i0_IEs_dummy;
static int ett_lte_rrc_SystemInformationBlockType2_v10m0_IEs;
static int ett_lte_rrc_T_freqInfo_v10l0;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxMultiBands_OF_AdditionalSpectrumEmission_v10l0;
static int ett_lte_rrc_SystemInformationBlockType2_v10n0_IEs;
static int ett_lte_rrc_SystemInformationBlockType2_v13c0_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_77;
static int ett_lte_rrc_AC_BarringConfig;
static int ett_lte_rrc_MBSFN_SubframeConfigList;
static int ett_lte_rrc_MBSFN_SubframeConfigList_v1430;
static int ett_lte_rrc_AC_BarringPerPLMN_List_r12;
static int ett_lte_rrc_AC_BarringPerPLMN_r12;
static int ett_lte_rrc_T_ac_BarringInfo_r12;
static int ett_lte_rrc_ACDC_BarringForCommon_r13;
static int ett_lte_rrc_ACDC_BarringPerPLMN_List_r13;
static int ett_lte_rrc_ACDC_BarringPerPLMN_r13;
static int ett_lte_rrc_BarringPerACDC_CategoryList_r13;
static int ett_lte_rrc_BarringPerACDC_Category_r13;
static int ett_lte_rrc_T_acdc_BarringConfig_r13;
static int ett_lte_rrc_UDT_Restricting_r13;
static int ett_lte_rrc_UDT_RestrictingPerPLMN_List_r13;
static int ett_lte_rrc_UDT_RestrictingPerPLMN_r13;
static int ett_lte_rrc_CIOT_EPS_OptimisationInfo_r13;
static int ett_lte_rrc_CIOT_OptimisationPLMN_r13;
static int ett_lte_rrc_PLMN_InfoList_r15;
static int ett_lte_rrc_PLMN_Info_r15;
static int ett_lte_rrc_SystemInformationBlockType3;
static int ett_lte_rrc_T_cellReselectionInfoCommon;
static int ett_lte_rrc_T_speedStateReselectionPars;
static int ett_lte_rrc_T_q_HystSF;
static int ett_lte_rrc_T_cellReselectionServingFreqInfo;
static int ett_lte_rrc_T_intraFreqCellReselectionInfo;
static int ett_lte_rrc_T_s_IntraSearch_v920;
static int ett_lte_rrc_T_s_NonIntraSearch_v920;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxSat_r17_OF_SatelliteId_r18;
static int ett_lte_rrc_RedistributionServingInfo_r13;
static int ett_lte_rrc_CellReselectionServingFreqInfo_v1310;
static int ett_lte_rrc_CellReselectionServingFreqInfo_v1610;
static int ett_lte_rrc_SystemInformationBlockType3_v10j0_IEs;
static int ett_lte_rrc_SystemInformationBlockType3_v10l0_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_78;
static int ett_lte_rrc_CellReselectionInfoCommon_v1460;
static int ett_lte_rrc_CellReselectionInfoHSDN_r15;
static int ett_lte_rrc_SystemInformationBlockType4;
static int ett_lte_rrc_IntraFreqNeighCellList;
static int ett_lte_rrc_IntraFreqNeighCellList_v1610;
static int ett_lte_rrc_IntraFreqNeighHSDN_CellList_r15;
static int ett_lte_rrc_IntraFreqNeighCellInfo;
static int ett_lte_rrc_IntraFreqNeighCellInfo_v1610;
static int ett_lte_rrc_IntraFreqExcludedCellList;
static int ett_lte_rrc_SystemInformationBlockType5;
static int ett_lte_rrc_SystemInformationBlockType5_v8h0_IEs;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxFreq_OF_InterFreqCarrierFreqInfo_v8h0;
static int ett_lte_rrc_SystemInformationBlockType5_v9e0_IEs;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxFreq_OF_InterFreqCarrierFreqInfo_v9e0;
static int ett_lte_rrc_SystemInformationBlockType5_v10j0_IEs;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxFreq_OF_InterFreqCarrierFreqInfo_v10j0;
static int ett_lte_rrc_SystemInformationBlockType5_v10l0_IEs;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxFreq_OF_InterFreqCarrierFreqInfo_v10l0;
static int ett_lte_rrc_SystemInformationBlockType5_v13a0_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_79;
static int ett_lte_rrc_InterFreqCarrierFreqList;
static int ett_lte_rrc_InterFreqCarrierFreqList_v1250;
static int ett_lte_rrc_InterFreqCarrierFreqList_v1310;
static int ett_lte_rrc_InterFreqCarrierFreqList_v1350;
static int ett_lte_rrc_InterFreqCarrierFreqList_v13a0;
static int ett_lte_rrc_InterFreqCarrierFreqList_v1530;
static int ett_lte_rrc_InterFreqCarrierFreqList_v1610;
static int ett_lte_rrc_InterFreqCarrierFreqList_v1800;
static int ett_lte_rrc_InterFreqCarrierFreqListExt_r12;
static int ett_lte_rrc_InterFreqCarrierFreqListExt_v1280;
static int ett_lte_rrc_InterFreqCarrierFreqListExt_v1310;
static int ett_lte_rrc_InterFreqCarrierFreqListExt_v1350;
static int ett_lte_rrc_InterFreqCarrierFreqListExt_v1360;
static int ett_lte_rrc_InterFreqCarrierFreqListExt_v1530;
static int ett_lte_rrc_InterFreqCarrierFreqListExt_v1610;
static int ett_lte_rrc_InterFreqCarrierFreqListExt_v1800;
static int ett_lte_rrc_InterFreqCarrierFreqInfo;
static int ett_lte_rrc_T_threshX_Q_r9;
static int ett_lte_rrc_InterFreqCarrierFreqInfo_v8h0;
static int ett_lte_rrc_InterFreqCarrierFreqInfo_v9e0;
static int ett_lte_rrc_InterFreqCarrierFreqInfo_v10j0;
static int ett_lte_rrc_InterFreqCarrierFreqInfo_v10l0;
static int ett_lte_rrc_InterFreqCarrierFreqInfo_v1250;
static int ett_lte_rrc_InterFreqCarrierFreqInfo_r12;
static int ett_lte_rrc_T_threshX_Q_r12;
static int ett_lte_rrc_InterFreqCarrierFreqInfo_v1310;
static int ett_lte_rrc_InterFreqCarrierFreqInfo_v1350;
static int ett_lte_rrc_InterFreqCarrierFreqInfo_v1360;
static int ett_lte_rrc_InterFreqCarrierFreqInfo_v1530;
static int ett_lte_rrc_InterFreqCarrierFreqInfo_v1610;
static int ett_lte_rrc_InterFreqCarrierFreqInfo_v1800;
static int ett_lte_rrc_InterFreqNeighCellList;
static int ett_lte_rrc_InterFreqNeighCellList_v1610;
static int ett_lte_rrc_InterFreqNeighHSDN_CellList_r15;
static int ett_lte_rrc_InterFreqNeighCellInfo;
static int ett_lte_rrc_InterFreqNeighCellInfo_v1610;
static int ett_lte_rrc_InterFreqExcludedCellList;
static int ett_lte_rrc_RedistributionInterFreqInfo_r13;
static int ett_lte_rrc_RedistributionNeighCellList_r13;
static int ett_lte_rrc_RedistributionNeighCell_r13;
static int ett_lte_rrc_SystemInformationBlockType6;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxUTRA_FDD_Carrier_OF_CarrierFreqInfoUTRA_v1250;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxUTRA_TDD_Carrier_OF_CarrierFreqInfoUTRA_v1250;
static int ett_lte_rrc_SystemInformationBlockType6_v8h0_IEs;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxUTRA_FDD_Carrier_OF_CarrierFreqInfoUTRA_FDD_v8h0;
static int ett_lte_rrc_T_nonCriticalExtension_80;
static int ett_lte_rrc_CarrierFreqInfoUTRA_v1250;
static int ett_lte_rrc_CarrierFreqListUTRA_FDD;
static int ett_lte_rrc_CarrierFreqUTRA_FDD;
static int ett_lte_rrc_T_threshX_Q_r9_01;
static int ett_lte_rrc_CarrierFreqInfoUTRA_FDD_v8h0;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxMultiBands_OF_FreqBandIndicator_UTRA_FDD;
static int ett_lte_rrc_CarrierFreqListUTRA_FDD_Ext_r12;
static int ett_lte_rrc_CarrierFreqUTRA_FDD_Ext_r12;
static int ett_lte_rrc_T_threshX_Q_r12_01;
static int ett_lte_rrc_FreqBandIndicator_UTRA_FDD_r12;
static int ett_lte_rrc_CarrierFreqListUTRA_TDD;
static int ett_lte_rrc_CarrierFreqUTRA_TDD;
static int ett_lte_rrc_CarrierFreqListUTRA_TDD_Ext_r12;
static int ett_lte_rrc_CarrierFreqUTRA_TDD_r12;
static int ett_lte_rrc_SystemInformationBlockType7;
static int ett_lte_rrc_CarrierFreqsInfoListGERAN;
static int ett_lte_rrc_CarrierFreqsInfoGERAN;
static int ett_lte_rrc_T_commonInfo;
static int ett_lte_rrc_SystemInformationBlockType8;
static int ett_lte_rrc_T_parametersHRPD;
static int ett_lte_rrc_T_parameters1XRTT;
static int ett_lte_rrc_CellReselectionParametersCDMA2000;
static int ett_lte_rrc_CellReselectionParametersCDMA2000_r11;
static int ett_lte_rrc_SEQUENCE_SIZE_1_16_OF_NeighCellCDMA2000_r11;
static int ett_lte_rrc_CellReselectionParametersCDMA2000_v920;
static int ett_lte_rrc_NeighCellListCDMA2000;
static int ett_lte_rrc_NeighCellCDMA2000;
static int ett_lte_rrc_NeighCellCDMA2000_r11;
static int ett_lte_rrc_SEQUENCE_SIZE_1_16_OF_NeighCellsPerBandclassCDMA2000_r11;
static int ett_lte_rrc_NeighCellsPerBandclassListCDMA2000;
static int ett_lte_rrc_NeighCellsPerBandclassCDMA2000;
static int ett_lte_rrc_NeighCellsPerBandclassCDMA2000_r11;
static int ett_lte_rrc_SEQUENCE_SIZE_1_40_OF_PhysCellIdCDMA2000;
static int ett_lte_rrc_NeighCellListCDMA2000_v920;
static int ett_lte_rrc_NeighCellCDMA2000_v920;
static int ett_lte_rrc_NeighCellsPerBandclassListCDMA2000_v920;
static int ett_lte_rrc_NeighCellsPerBandclassCDMA2000_v920;
static int ett_lte_rrc_PhysCellIdListCDMA2000;
static int ett_lte_rrc_PhysCellIdListCDMA2000_v920;
static int ett_lte_rrc_BandClassListCDMA2000;
static int ett_lte_rrc_BandClassInfoCDMA2000;
static int ett_lte_rrc_AC_BarringConfig1XRTT_r9;
static int ett_lte_rrc_SIB8_PerPLMN_List_r11;
static int ett_lte_rrc_SIB8_PerPLMN_r11;
static int ett_lte_rrc_T_parametersCDMA2000_r11;
static int ett_lte_rrc_ParametersCDMA2000_r11;
static int ett_lte_rrc_T_systemTimeInfo_r11;
static int ett_lte_rrc_T_parametersHRPD_r11;
static int ett_lte_rrc_T_parameters1XRTT_r11;
static int ett_lte_rrc_SystemInformationBlockType9;
static int ett_lte_rrc_SystemInformationBlockType10;
static int ett_lte_rrc_SystemInformationBlockType11;
static int ett_lte_rrc_SystemInformationBlockType12_r9;
static int ett_lte_rrc_SystemInformationBlockType13_r9;
static int ett_lte_rrc_SystemInformationBlockType14_r11;
static int ett_lte_rrc_T_eab_Param_r11;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxPLMN_r11_OF_EAB_ConfigPLMN_r11;
static int ett_lte_rrc_EAB_ConfigPLMN_r11;
static int ett_lte_rrc_EAB_Config_r11;
static int ett_lte_rrc_SystemInformationBlockType15_r11;
static int ett_lte_rrc_MBMS_SAI_List_r11;
static int ett_lte_rrc_MBMS_SAI_InterFreqList_r11;
static int ett_lte_rrc_MBMS_SAI_InterFreqList_v1140;
static int ett_lte_rrc_MBMS_SAI_InterFreq_r11;
static int ett_lte_rrc_MBMS_SAI_InterFreq_v1140;
static int ett_lte_rrc_MBMS_InterFreqCarrierTypeList_r14;
static int ett_lte_rrc_MBMS_CarrierType_r14;
static int ett_lte_rrc_SystemInformationBlockType16_r11;
static int ett_lte_rrc_T_timeInfo_r11;
static int ett_lte_rrc_SystemInformationBlockType17_r12;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxPLMN_r11_OF_WLAN_OffloadInfoPerPLMN_r12;
static int ett_lte_rrc_WLAN_OffloadInfoPerPLMN_r12;
static int ett_lte_rrc_WLAN_Id_List_r12;
static int ett_lte_rrc_WLAN_Identifiers_r12;
static int ett_lte_rrc_SystemInformationBlockType18_r12;
static int ett_lte_rrc_T_commConfig_r12;
static int ett_lte_rrc_SystemInformationBlockType19_r12;
static int ett_lte_rrc_T_discConfig_r12;
static int ett_lte_rrc_T_discConfig_v1310;
static int ett_lte_rrc_T_discConfigRelay_r13;
static int ett_lte_rrc_T_discConfigPS_13;
static int ett_lte_rrc_SL_CarrierFreqInfoList_r12;
static int ett_lte_rrc_SL_CarrierFreqInfoList_v1310;
static int ett_lte_rrc_SL_CarrierFreqInfo_r12;
static int ett_lte_rrc_SL_DiscConfigRelayUE_r13;
static int ett_lte_rrc_SL_DiscConfigRemoteUE_r13;
static int ett_lte_rrc_ReselectionInfoRelay_r13;
static int ett_lte_rrc_SL_CarrierFreqInfo_v1310;
static int ett_lte_rrc_PLMN_IdentityList4_r12;
static int ett_lte_rrc_PLMN_IdentityInfo2_r12;
static int ett_lte_rrc_SL_DiscTxResourcesInterFreq_r13;
static int ett_lte_rrc_SL_DiscConfigOtherInterFreq_r13;
static int ett_lte_rrc_SL_ResourcesInterFreq_r13;
static int ett_lte_rrc_SystemInformationBlockType20_r13;
static int ett_lte_rrc_T_br_BCCH_Config_r14;
static int ett_lte_rrc_T_mpdcch_StartSF_SC_MCCH_r14;
static int ett_lte_rrc_SC_MCCH_SchedulingInfo_r14;
static int ett_lte_rrc_T_schedulingPeriodStartOffsetSCPTM_r14;
static int ett_lte_rrc_SystemInformationBlockType21_r14;
static int ett_lte_rrc_SL_V2X_ConfigCommon_r14;
static int ett_lte_rrc_SL_A2X_ConfigCommon_r18;
static int ett_lte_rrc_SystemInformationBlockType24_r15;
static int ett_lte_rrc_CarrierFreqListNR_r15;
static int ett_lte_rrc_CarrierFreqListNR_v1610;
static int ett_lte_rrc_CarrierFreqListNR_v1700;
static int ett_lte_rrc_CarrierFreqListNR_v1720;
static int ett_lte_rrc_CarrierFreqListNR_v1810;
static int ett_lte_rrc_CarrierFreqNR_r15;
static int ett_lte_rrc_T_threshX_Q_r15;
static int ett_lte_rrc_CarrierFreqNR_v1610;
static int ett_lte_rrc_CarrierFreqNR_v1700;
static int ett_lte_rrc_CarrierFreqNR_v1720;
static int ett_lte_rrc_CarrierFreqNR_v1810;
static int ett_lte_rrc_MultiBandNsPmaxListNR_1_v1550;
static int ett_lte_rrc_MultiBandNsPmaxListNR_v1550;
static int ett_lte_rrc_MultiBandNsPmaxListNR_1_v1760;
static int ett_lte_rrc_MultiBandNsPmaxListNR_v1760;
static int ett_lte_rrc_MultiBandNsPmaxListNR_Aerial_1_r18;
static int ett_lte_rrc_AllowedCellListNR_r16;
static int ett_lte_rrc_NR_FreqNeighHSDN_CellList_r17;
static int ett_lte_rrc_SystemInformationBlockType25_r15;
static int ett_lte_rrc_T_uac_AC1_SelectAssistInfo_r15;
static int ett_lte_rrc_SEQUENCE_SIZE_2_maxPLMN_r11_OF_UAC_AC1_SelectAssistInfo_r15;
static int ett_lte_rrc_SEQUENCE_SIZE_2_maxPLMN_r11_OF_UAC_AC1_SelectAssistInfo_r16;
static int ett_lte_rrc_UAC_BarringPerPLMN_List_r15;
static int ett_lte_rrc_UAC_BarringPerPLMN_r15;
static int ett_lte_rrc_T_uac_AC_BarringListType_r15;
static int ett_lte_rrc_SEQUENCE_SIZE_maxAccessCat_1_r15_OF_UAC_BarringInfoSetIndex_r15;
static int ett_lte_rrc_UAC_BarringPerCatList_r15;
static int ett_lte_rrc_UAC_BarringPerCat_r15;
static int ett_lte_rrc_UAC_BarringInfoSetList_r15;
static int ett_lte_rrc_UAC_BarringInfoSetList_v1700;
static int ett_lte_rrc_UAC_BarringInfoSet_r15;
static int ett_lte_rrc_UAC_BarringInfoSet_v1700;
static int ett_lte_rrc_SystemInformationBlockType26_r15;
static int ett_lte_rrc_SystemInformationBlockType26a_r16;
static int ett_lte_rrc_BandListENDC_r16;
static int ett_lte_rrc_PLMN_InfoList_r16;
static int ett_lte_rrc_PLMN_Info_r16;
static int ett_lte_rrc_SystemInformationBlockType27_r16;
static int ett_lte_rrc_CarrierFreqListNBIOT_r16;
static int ett_lte_rrc_CarrierFreqNBIOT_r16;
static int ett_lte_rrc_SystemInformationBlockType28_r16;
static int ett_lte_rrc_SystemInformationBlockType29_r16;
static int ett_lte_rrc_SystemInformationBlockType30_r17;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxPLMN_r11_OF_PLMN_Identity;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxPLMN_r11_OF_ApplicableDisasterInfo_r17;
static int ett_lte_rrc_ApplicableDisasterInfo_r17;
static int ett_lte_rrc_SystemInformationBlockType31_r17;
static int ett_lte_rrc_ServingSatelliteInfo_r17;
static int ett_lte_rrc_T_ephemerisInfo_r17;
static int ett_lte_rrc_T_nta_CommonParameters_r17;
static int ett_lte_rrc_T_epochTime_r17;
static int ett_lte_rrc_ServingSatelliteInfo_v1820;
static int ett_lte_rrc_T_referenceLocation_r18;
static int ett_lte_rrc_SystemInformationBlockType32_r17;
static int ett_lte_rrc_SatelliteInfoList_r17;
static int ett_lte_rrc_SatelliteInfoList_v1800;
static int ett_lte_rrc_SatelliteInfo_r17;
static int ett_lte_rrc_T_serviceInfo_r17;
static int ett_lte_rrc_T_footprintInfo_r17;
static int ett_lte_rrc_T_referencePoint_r17;
static int ett_lte_rrc_T_elevationAngles_r17;
static int ett_lte_rrc_CarrierFreqList_v1800;
static int ett_lte_rrc_SystemInformationBlockType33_r18;
static int ett_lte_rrc_NeighSatelliteInfoList_r18;
static int ett_lte_rrc_NeighSatelliteInfo_r18;
static int ett_lte_rrc_T_ephemerisInfo_r18;
static int ett_lte_rrc_T_nta_CommonParameters_r18;
static int ett_lte_rrc_T_epochTime_r18;
static int ett_lte_rrc_AntennaInfoCommon;
static int ett_lte_rrc_AntennaInfoDedicated;
static int ett_lte_rrc_T_codebookSubsetRestriction;
static int ett_lte_rrc_T_ue_TransmitAntennaSelection;
static int ett_lte_rrc_AntennaInfoDedicated_v920;
static int ett_lte_rrc_T_codebookSubsetRestriction_v920;
static int ett_lte_rrc_AntennaInfoDedicated_r10;
static int ett_lte_rrc_T_ue_TransmitAntennaSelection_01;
static int ett_lte_rrc_AntennaInfoDedicated_v10i0;
static int ett_lte_rrc_AntennaInfoDedicated_v1250;
static int ett_lte_rrc_AntennaInfoDedicated_v1430;
static int ett_lte_rrc_AntennaInfoDedicatedSTTI_r15;
static int ett_lte_rrc_T_antennaInfoDedicatedSTTI_r15_setup;
static int ett_lte_rrc_T_codebookSubsetRestriction_01;
static int ett_lte_rrc_AntennaInfoDedicated_v1530;
static int ett_lte_rrc_T_antennaInfoDedicated_v1530_setup;
static int ett_lte_rrc_AntennaInfoUL_r10;
static int ett_lte_rrc_AntennaInfoUL_STTI_r15;
static int ett_lte_rrc_AUL_Config_r15;
static int ett_lte_rrc_T_aUL_Config_r15_setup;
static int ett_lte_rrc_CQI_ReportAperiodic_r10;
static int ett_lte_rrc_T_cQI_ReportAperiodic_r10_setup;
static int ett_lte_rrc_T_aperiodicCSI_Trigger_r10;
static int ett_lte_rrc_CQI_ReportAperiodic_v1250;
static int ett_lte_rrc_T_cQI_ReportAperiodic_v1250_setup;
static int ett_lte_rrc_T_aperiodicCSI_Trigger_v1250;
static int ett_lte_rrc_CQI_ReportAperiodic_v1310;
static int ett_lte_rrc_T_cQI_ReportAperiodic_v1310_setup;
static int ett_lte_rrc_T_aperiodicCSI_Trigger_v1310;
static int ett_lte_rrc_T_aperiodicCSI_Trigger2_r13;
static int ett_lte_rrc_T_cQI_ReportAperiodic_v1310_setup_aperiodicCSI_Trigger2_r13_setup;
static int ett_lte_rrc_CQI_ReportAperiodicProc_r11;
static int ett_lte_rrc_CQI_ReportAperiodicProc_v1310;
static int ett_lte_rrc_CQI_ReportAperiodicHybrid_r14;
static int ett_lte_rrc_T_triggers_r14;
static int ett_lte_rrc_T_oneBit_r14;
static int ett_lte_rrc_T_twoBit_r14;
static int ett_lte_rrc_T_threeBit_r14;
static int ett_lte_rrc_CQI_ReportBoth_r11;
static int ett_lte_rrc_CQI_ReportBoth_v1250;
static int ett_lte_rrc_CQI_ReportBoth_v1310;
static int ett_lte_rrc_CSI_IM_ConfigToAddModList_r11;
static int ett_lte_rrc_CSI_IM_ConfigToAddModListExt_r13;
static int ett_lte_rrc_CSI_IM_ConfigToReleaseList_r11;
static int ett_lte_rrc_CSI_IM_ConfigToReleaseListExt_r13;
static int ett_lte_rrc_CSI_ProcessToAddModList_r11;
static int ett_lte_rrc_CSI_ProcessToReleaseList_r11;
static int ett_lte_rrc_CQI_ReportBothProc_r11;
static int ett_lte_rrc_CQI_ReportConfig;
static int ett_lte_rrc_CQI_ReportConfig_v920;
static int ett_lte_rrc_CQI_ReportConfig_r10;
static int ett_lte_rrc_T_csi_SubframePatternConfig_r10;
static int ett_lte_rrc_T_cQI_ReportConfig_r10_csi_SubframePatternConfig_r10_setup;
static int ett_lte_rrc_CQI_ReportConfig_v1130;
static int ett_lte_rrc_CQI_ReportConfig_v1250;
static int ett_lte_rrc_T_csi_SubframePatternConfig_r12;
static int ett_lte_rrc_T_cQI_ReportConfig_v1250_csi_SubframePatternConfig_r12_setup;
static int ett_lte_rrc_CQI_ReportConfig_v1310;
static int ett_lte_rrc_CQI_ReportConfig_v1320;
static int ett_lte_rrc_CQI_ReportConfig_v1430;
static int ett_lte_rrc_CQI_ReportConfig_v1530;
static int ett_lte_rrc_CQI_ReportConfig_r15;
static int ett_lte_rrc_T_cQI_ReportConfig_r15_setup;
static int ett_lte_rrc_CQI_ReportConfigSCell_r10;
static int ett_lte_rrc_CQI_ReportConfigSCell_r15;
static int ett_lte_rrc_CQI_ReportPeriodic;
static int ett_lte_rrc_T_cQI_ReportPeriodic_setup;
static int ett_lte_rrc_T_cqi_FormatIndicatorPeriodic;
static int ett_lte_rrc_T_subbandCQI;
static int ett_lte_rrc_CQI_ReportPeriodic_r10;
static int ett_lte_rrc_T_cQI_ReportPeriodic_r10_setup;
static int ett_lte_rrc_T_cqi_FormatIndicatorPeriodic_r10;
static int ett_lte_rrc_T_widebandCQI_r10;
static int ett_lte_rrc_T_subbandCQI_r10;
static int ett_lte_rrc_T_csi_ConfigIndex_r10;
static int ett_lte_rrc_T_cQI_ReportPeriodic_r10_setup_csi_ConfigIndex_r10_setup;
static int ett_lte_rrc_CQI_ReportPeriodic_v1130;
static int ett_lte_rrc_CQI_ReportPeriodic_v1310;
static int ett_lte_rrc_CQI_ReportPeriodic_v1320;
static int ett_lte_rrc_CQI_ReportPeriodicSCell_r15;
static int ett_lte_rrc_T_cQI_ReportPeriodicSCell_r15_setup;
static int ett_lte_rrc_T_csi_SubframePatternDormant_r15;
static int ett_lte_rrc_T_cQI_ReportPeriodicSCell_r15_setup_csi_SubframePatternDormant_r15_setup;
static int ett_lte_rrc_T_cqi_FormatIndicatorDormant_r15;
static int ett_lte_rrc_T_widebandCQI_r15;
static int ett_lte_rrc_T_subbandCQI_r15;
static int ett_lte_rrc_CQI_ReportPeriodicProcExtToAddModList_r11;
static int ett_lte_rrc_CQI_ReportPeriodicProcExtToReleaseList_r11;
static int ett_lte_rrc_CQI_ReportPeriodicProcExt_r11;
static int ett_lte_rrc_T_cqi_FormatIndicatorPeriodic_r11;
static int ett_lte_rrc_T_widebandCQI_r11;
static int ett_lte_rrc_T_subbandCQI_r11;
static int ett_lte_rrc_T_csi_ConfigIndex_r11;
static int ett_lte_rrc_T_cQI_ReportPeriodicProcExt_r11_csi_ConfigIndex_r11_setup;
static int ett_lte_rrc_CQI_ShortConfigSCell_r15;
static int ett_lte_rrc_T_cQI_ShortConfigSCell_r15_setup;
static int ett_lte_rrc_T_cqi_FormatIndicatorShort_r15;
static int ett_lte_rrc_T_widebandCQI_Short_r15;
static int ett_lte_rrc_T_subbandCQI_Short_r15;
static int ett_lte_rrc_CQI_ReportPeriodicSCell_v1730;
static int ett_lte_rrc_CRI_ReportConfig_r13;
static int ett_lte_rrc_T_cRI_ReportConfig_r13_setup;
static int ett_lte_rrc_CrossCarrierSchedulingConfig_r10;
static int ett_lte_rrc_T_schedulingCellInfo_r10;
static int ett_lte_rrc_T_own_r10;
static int ett_lte_rrc_T_other_r10;
static int ett_lte_rrc_CrossCarrierSchedulingConfig_r13;
static int ett_lte_rrc_T_schedulingCellInfo_r13;
static int ett_lte_rrc_T_own_r13;
static int ett_lte_rrc_T_other_r13;
static int ett_lte_rrc_CrossCarrierSchedulingConfigLAA_UL_r14;
static int ett_lte_rrc_CRS_ChEstMPDCCH_ConfigCommon_r16;
static int ett_lte_rrc_CRS_ChEstMPDCCH_ConfigDedicated_r16;
static int ett_lte_rrc_CSI_IM_Config_r11;
static int ett_lte_rrc_CSI_IM_ConfigExt_r12;
static int ett_lte_rrc_CSI_Process_r11;
static int ett_lte_rrc_T_csi_IM_ConfigIdList_r12;
static int ett_lte_rrc_SEQUENCE_SIZE_1_2_OF_CSI_IM_ConfigId_r12;
static int ett_lte_rrc_T_cqi_ReportAperiodicProc2_r12;
static int ett_lte_rrc_T_cqi_ReportAperiodicProc_v1310;
static int ett_lte_rrc_T_cqi_ReportAperiodicProc2_v1310;
static int ett_lte_rrc_CSI_RS_Config_r10;
static int ett_lte_rrc_T_csi_RS_r10;
static int ett_lte_rrc_T_cSI_RS_Config_r10_csi_RS_r10_setup;
static int ett_lte_rrc_CSI_RS_Config_v1250;
static int ett_lte_rrc_T_ds_ZeroTxPowerCSI_RS_r12;
static int ett_lte_rrc_T_cSI_RS_Config_v1250_ds_ZeroTxPowerCSI_RS_r12_setup;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxDS_ZTP_CSI_RS_r12_OF_ZeroTxPowerCSI_RS_r12;
static int ett_lte_rrc_CSI_RS_Config_v1310;
static int ett_lte_rrc_CSI_RS_Config_v1430;
static int ett_lte_rrc_CSI_RS_Config_v1480;
static int ett_lte_rrc_CSI_RS_Config_v1530;
static int ett_lte_rrc_CSI_RS_Config_r15;
static int ett_lte_rrc_T_cSI_RS_Config_r15_setup;
static int ett_lte_rrc_ZeroTxPowerCSI_RS_Conf_r12;
static int ett_lte_rrc_ZeroTxPowerCSI_RS_r12;
static int ett_lte_rrc_CSI_RS_ConfigBeamformed_r13;
static int ett_lte_rrc_SEQUENCE_SIZE_1_7_OF_CSI_RS_ConfigNZPId_r13;
static int ett_lte_rrc_SEQUENCE_SIZE_1_8_OF_CSI_IM_ConfigId_r13;
static int ett_lte_rrc_SEQUENCE_SIZE_1_8_OF_P_C_AndCBSR_Pair_r13;
static int ett_lte_rrc_T_ace_For4Tx_PerResourceConfigList_r13;
static int ett_lte_rrc_CSI_RS_ConfigBeamformed_r14;
static int ett_lte_rrc_T_ace_For4Tx_PerResourceConfigList_r14;
static int ett_lte_rrc_SEQUENCE_SIZE_1_8_OF_CSI_RS_ConfigNZP_r11;
static int ett_lte_rrc_CSI_RS_ConfigBeamformed_v1430;
static int ett_lte_rrc_CSI_RS_Config_NZP_v1430;
static int ett_lte_rrc_CSI_RS_ConfigNZP_Activation_r14;
static int ett_lte_rrc_CSI_RS_ConfigEMIMO_r13;
static int ett_lte_rrc_T_cSI_RS_ConfigEMIMO_r13_setup;
static int ett_lte_rrc_CSI_RS_ConfigEMIMO_v1430;
static int ett_lte_rrc_T_cSI_RS_ConfigEMIMO_v1430_setup;
static int ett_lte_rrc_CSI_RS_ConfigEMIMO_v1480;
static int ett_lte_rrc_T_cSI_RS_ConfigEMIMO_v1480_setup;
static int ett_lte_rrc_CSI_RS_ConfigEMIMO_v1530;
static int ett_lte_rrc_T_cSI_RS_ConfigEMIMO_v1530_setup;
static int ett_lte_rrc_CSI_RS_ConfigEMIMO2_r14;
static int ett_lte_rrc_CSI_RS_ConfigEMIMO_Hybrid_r14;
static int ett_lte_rrc_T_cSI_RS_ConfigEMIMO_Hybrid_r14_setup;
static int ett_lte_rrc_CSI_RS_ConfigNonPrecoded_r13;
static int ett_lte_rrc_SEQUENCE_SIZE_1_2_OF_CSI_IM_ConfigId_r13;
static int ett_lte_rrc_CSI_RS_ConfigNonPrecoded_v1430;
static int ett_lte_rrc_CSI_RS_ConfigNonPrecoded_v1480;
static int ett_lte_rrc_CSI_RS_ConfigNonPrecoded_v1530;
static int ett_lte_rrc_CSI_RS_ConfigNZP_r11;
static int ett_lte_rrc_T_qcl_CRS_Info_r11;
static int ett_lte_rrc_T_mbsfn_SubframeConfigList_r11;
static int ett_lte_rrc_T_cSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_setup;
static int ett_lte_rrc_T_mbsfn_SubframeConfigList_v1430;
static int ett_lte_rrc_T_cSI_RS_ConfigNZP_r11_eag_3_mbsfn_SubframeConfigList_v1430_setup;
static int ett_lte_rrc_CSI_RS_ConfigNZP_EMIMO_r13;
static int ett_lte_rrc_T_cSI_RS_ConfigNZP_EMIMO_r13_setup;
static int ett_lte_rrc_SEQUENCE_SIZE_1_2_OF_NZP_ResourceConfig_r13;
static int ett_lte_rrc_CSI_RS_ConfigNZP_EMIMO_v1430;
static int ett_lte_rrc_SEQUENCE_SIZE_0_4_OF_NZP_ResourceConfig_r13;
static int ett_lte_rrc_NZP_ResourceConfig_r13;
static int ett_lte_rrc_CSI_RS_ConfigZP_r11;
static int ett_lte_rrc_CSI_RS_ConfigZP_ApList_r14;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxCSI_RS_ZP_r11_OF_CSI_RS_ConfigZP_r11;
static int ett_lte_rrc_DMRS_Config_r11;
static int ett_lte_rrc_T_dMRS_Config_r11_setup;
static int ett_lte_rrc_DMRS_Config_v1310;
static int ett_lte_rrc_EPDCCH_Config_r11;
static int ett_lte_rrc_T_config_r11;
static int ett_lte_rrc_T_ePDCCH_Config_r11_config_r11_setup;
static int ett_lte_rrc_T_subframePatternConfig_r11;
static int ett_lte_rrc_T_ePDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_setup;
static int ett_lte_rrc_EPDCCH_SetConfigToAddModList_r11;
static int ett_lte_rrc_EPDCCH_SetConfigToReleaseList_r11;
static int ett_lte_rrc_EPDCCH_SetConfig_r11;
static int ett_lte_rrc_T_resourceBlockAssignment_r11;
static int ett_lte_rrc_T_csi_RS_ConfigZPId2_r12;
static int ett_lte_rrc_T_numberPRB_Pairs_v1310;
static int ett_lte_rrc_T_mpdcch_config_r13;
static int ett_lte_rrc_T_ePDCCH_SetConfig_r11_eag_2_mpdcch_config_r13_setup;
static int ett_lte_rrc_T_mpdcch_StartSF_UESS_r13;
static int ett_lte_rrc_EIMTA_MainConfig_r12;
static int ett_lte_rrc_T_eIMTA_MainConfig_r12_setup;
static int ett_lte_rrc_EIMTA_MainConfigServCell_r12;
static int ett_lte_rrc_T_eIMTA_MainConfigServCell_r12_setup;
static int ett_lte_rrc_T_mbsfn_SubframeConfigList_v1250;
static int ett_lte_rrc_T_eIMTA_MainConfigServCell_r12_setup_mbsfn_SubframeConfigList_v1250_setup;
static int ett_lte_rrc_GWUS_Config_r16;
static int ett_lte_rrc_GWUS_TimeParameters_r16;
static int ett_lte_rrc_GWUS_ResourceConfig_r16;
static int ett_lte_rrc_T_resourceMappingPattern_r16;
static int ett_lte_rrc_GWUS_GroupsForServiceList_r16;
static int ett_lte_rrc_GWUS_GroupNarrowBandList_r16;
static int ett_lte_rrc_GWUS_NumGroupsList_r16;
static int ett_lte_rrc_GWUS_ProbThreshList_r16;
static int ett_lte_rrc_LogicalChannelConfig;
static int ett_lte_rrc_T_ul_SpecificParameters;
static int ett_lte_rrc_T_allowedTTI_Lengths_r15;
static int ett_lte_rrc_T_logicalChannelConfig_eag_4_allowedTTI_Lengths_r15_setup;
static int ett_lte_rrc_T_logicalChannelSR_Restriction_r15;
static int ett_lte_rrc_T_channelAccessPriority_r15;
static int ett_lte_rrc_LWA_Configuration_r13;
static int ett_lte_rrc_T_lWA_Configuration_r13_setup;
static int ett_lte_rrc_LWA_Config_r13;
static int ett_lte_rrc_LWIP_Configuration_r13;
static int ett_lte_rrc_T_lWIP_Configuration_r13_setup;
static int ett_lte_rrc_LWIP_Config_r13;
static int ett_lte_rrc_MAC_MainConfig;
static int ett_lte_rrc_T_ul_SCH_Config;
static int ett_lte_rrc_T_phr_Config;
static int ett_lte_rrc_T_mAC_MainConfig_phr_Config_setup;
static int ett_lte_rrc_T_mac_MainConfig_v1020;
static int ett_lte_rrc_T_dualConnectivityPHR;
static int ett_lte_rrc_T_mAC_MainConfig_eag_4_dualConnectivityPHR_setup;
static int ett_lte_rrc_T_logicalChannelSR_Config_r12;
static int ett_lte_rrc_T_mAC_MainConfig_eag_4_logicalChannelSR_Config_r12_setup;
static int ett_lte_rrc_T_eDRX_Config_CycleStartOffset_r13;
static int ett_lte_rrc_T_mAC_MainConfig_eag_5_eDRX_Config_CycleStartOffset_r13_setup;
static int ett_lte_rrc_T_drx_Config_r13;
static int ett_lte_rrc_T_skipUplinkTx_r14;
static int ett_lte_rrc_T_mAC_MainConfig_eag_7_skipUplinkTx_r14_setup;
static int ett_lte_rrc_T_dataInactivityTimerConfig_r14;
static int ett_lte_rrc_T_mAC_MainConfig_eag_7_dataInactivityTimerConfig_r14_setup;
static int ett_lte_rrc_T_shortTTI_AndSPT_r15;
static int ett_lte_rrc_T_mAC_MainConfig_eag_9_shortTTI_AndSPT_r15_setup;
static int ett_lte_rrc_T_dormantStateTimers_r15;
static int ett_lte_rrc_T_mAC_MainConfig_eag_9_dormantStateTimers_r15_setup;
static int ett_lte_rrc_T_offsetThresholdTA_r17;
static int ett_lte_rrc_T_sr_ProhibitTimerOffset_r17;
static int ett_lte_rrc_MAC_MainConfigSCell_r11;
static int ett_lte_rrc_DRX_Config;
static int ett_lte_rrc_T_dRX_Config_setup;
static int ett_lte_rrc_T_longDRX_CycleStartOffset;
static int ett_lte_rrc_T_shortDRX;
static int ett_lte_rrc_DRX_Config_v1130;
static int ett_lte_rrc_T_longDRX_CycleStartOffset_v1130;
static int ett_lte_rrc_DRX_Config_v1310;
static int ett_lte_rrc_T_longDRX_CycleStartOffset_v1310;
static int ett_lte_rrc_DRX_Config_r13;
static int ett_lte_rrc_DRX_Config_r15;
static int ett_lte_rrc_STAG_ToReleaseList_r11;
static int ett_lte_rrc_STAG_ToAddModList_r11;
static int ett_lte_rrc_STAG_ToAddMod_r11;
static int ett_lte_rrc_P_C_AndCBSR_r11;
static int ett_lte_rrc_P_C_AndCBSR_r13;
static int ett_lte_rrc_T_cbsr_Selection_r13;
static int ett_lte_rrc_T_nonPrecoded_r13;
static int ett_lte_rrc_T_beamformedK1a_r13;
static int ett_lte_rrc_T_beamformedKN_r13;
static int ett_lte_rrc_P_C_AndCBSR_r15;
static int ett_lte_rrc_P_C_AndCBSR_Pair_r13a;
static int ett_lte_rrc_P_C_AndCBSR_Pair_r13;
static int ett_lte_rrc_P_C_AndCBSR_Pair_r15;
static int ett_lte_rrc_PDCCH_ConfigSCell_r13;
static int ett_lte_rrc_PDCCH_ConfigLAA_r14;
static int ett_lte_rrc_PDCCH_CandidateReductions_r13;
static int ett_lte_rrc_T_pDCCH_CandidateReductions_r13_setup;
static int ett_lte_rrc_PDCCH_CandidateReductionsLAA_UL_r14;
static int ett_lte_rrc_T_pDCCH_CandidateReductionsLAA_UL_r14_setup;
static int ett_lte_rrc_PDCP_Config;
static int ett_lte_rrc_T_rlc_AM;
static int ett_lte_rrc_T_rlc_UM;
static int ett_lte_rrc_T_headerCompression;
static int ett_lte_rrc_T_rohc;
static int ett_lte_rrc_T_profiles;
static int ett_lte_rrc_T_ul_DataSplitThreshold_r13;
static int ett_lte_rrc_T_statusFeedback_r13;
static int ett_lte_rrc_T_pDCP_Config_eag_4_statusFeedback_r13_setup;
static int ett_lte_rrc_T_ul_LWA_Config_r14;
static int ett_lte_rrc_T_pDCP_Config_eag_5_ul_LWA_Config_r14_setup;
static int ett_lte_rrc_T_uplinkOnlyHeaderCompression_r14;
static int ett_lte_rrc_T_rohc_r14;
static int ett_lte_rrc_T_profiles_r14;
static int ett_lte_rrc_T_uplinkDataCompression_r15;
static int ett_lte_rrc_T_pdcp_DuplicationConfig_r15;
static int ett_lte_rrc_T_pDCP_Config_eag_6_pdcp_DuplicationConfig_r15_setup;
static int ett_lte_rrc_T_ethernetHeaderCompression_r16;
static int ett_lte_rrc_T_discardTimerExt_r17;
static int ett_lte_rrc_EthernetHeaderCompression_r16;
static int ett_lte_rrc_T_ehc_Common_r16;
static int ett_lte_rrc_T_ehc_Downlink_r16;
static int ett_lte_rrc_T_ehc_Uplink_r16;
static int ett_lte_rrc_PDSCH_ConfigCommon;
static int ett_lte_rrc_PDSCH_ConfigCommon_v1310;
static int ett_lte_rrc_PDSCH_ConfigDedicated;
static int ett_lte_rrc_PDSCH_ConfigDedicated_v1130;
static int ett_lte_rrc_PDSCH_ConfigDedicated_v1280;
static int ett_lte_rrc_PDSCH_ConfigDedicated_v1310;
static int ett_lte_rrc_PDSCH_ConfigDedicated_v1430;
static int ett_lte_rrc_PDSCH_ConfigDedicated_v1530;
static int ett_lte_rrc_PDSCH_ConfigDedicated_v1610;
static int ett_lte_rrc_T_ce_PDSCH_MultiTB_Config_r16;
static int ett_lte_rrc_PDSCH_ConfigDedicated_v1700;
static int ett_lte_rrc_T_ce_PDSCH_14HARQ_Config_r17;
static int ett_lte_rrc_PDSCH_ConfigDedicated_v1800;
static int ett_lte_rrc_T_downlinkHARQ_FeedbackDisabledBitmap_r18;
static int ett_lte_rrc_PDSCH_ConfigDedicatedSCell_v1430;
static int ett_lte_rrc_CE_PDSCH_MultiTB_Config_r16;
static int ett_lte_rrc_CE_PDSCH_14HARQ_Config_r17;
static int ett_lte_rrc_RE_MappingQCLConfigToAddModList_r11;
static int ett_lte_rrc_RE_MappingQCLConfigToReleaseList_r11;
static int ett_lte_rrc_PDSCH_RE_MappingQCL_Config_r11;
static int ett_lte_rrc_T_optionalSetOfFields_r11;
static int ett_lte_rrc_T_mbsfn_SubframeConfigList_r11_01;
static int ett_lte_rrc_T_pDSCH_RE_MappingQCL_Config_r11_optionalSetOfFields_r11_mbsfn_SubframeConfigList_r11_setup;
static int ett_lte_rrc_T_mbsfn_SubframeConfigList_v1430_01;
static int ett_lte_rrc_T_pDSCH_RE_MappingQCL_Config_r11_eag_1_mbsfn_SubframeConfigList_v1430_setup;
static int ett_lte_rrc_T_codewordOneConfig_v1530;
static int ett_lte_rrc_T_pDSCH_RE_MappingQCL_Config_r11_eag_2_codewordOneConfig_v1530_setup;
static int ett_lte_rrc_PerCC_GapIndicationList_r14;
static int ett_lte_rrc_PerCC_GapIndication_r14;
static int ett_lte_rrc_PHICH_Config;
static int ett_lte_rrc_PhysicalConfigDedicated;
static int ett_lte_rrc_T_antennaInfo;
static int ett_lte_rrc_T_antennaInfo_r10;
static int ett_lte_rrc_T_additionalSpectrumEmissionCA_r10;
static int ett_lte_rrc_T_physicalConfigDedicated_eag_3_additionalSpectrumEmissionCA_r10_setup;
static int ett_lte_rrc_T_ce_Mode_r13;
static int ett_lte_rrc_T_typeA_SRS_TPC_PDCCH_Group_r14;
static int ett_lte_rrc_SEQUENCE_SIZE_1_32_OF_SRS_TPC_PDCCH_Config_r14;
static int ett_lte_rrc_T_must_Config_r14;
static int ett_lte_rrc_T_physicalConfigDedicated_eag_9_must_Config_r14_setup;
static int ett_lte_rrc_SEQUENCE_SIZE_1_2_OF_SoundingRS_UL_ConfigDedicated;
static int ett_lte_rrc_SEQUENCE_SIZE_1_4_OF_SoundingRS_UL_ConfigDedicatedUpPTsExt_r13;
static int ett_lte_rrc_SEQUENCE_SIZE_1_2_OF_SoundingRS_UL_ConfigDedicatedAperiodic_r10;
static int ett_lte_rrc_SEQUENCE_SIZE_1_4_OF_SoundingRS_UL_ConfigDedicatedAperiodicUpPTsExt_r13;
static int ett_lte_rrc_T_semiStaticCFI_Config_r15;
static int ett_lte_rrc_T_physicalConfigDedicated_eag_11_semiStaticCFI_Config_r15_setup;
static int ett_lte_rrc_T_blindPDSCH_Repetition_Config_r15;
static int ett_lte_rrc_T_physicalConfigDedicated_eag_11_blindPDSCH_Repetition_Config_r15_setup;
static int ett_lte_rrc_T_resourceReservationConfigDedicatedDL_r16;
static int ett_lte_rrc_T_resourceReservationConfigDedicatedUL_r16;
static int ett_lte_rrc_T_soundingRS_UL_ConfigDedicatedAdd_r16;
static int ett_lte_rrc_T_uplinkPowerControlAddSRS_r16;
static int ett_lte_rrc_T_soundingRS_VirtualCellID_r16;
static int ett_lte_rrc_T_widebandPRG_r16;
static int ett_lte_rrc_T_ntn_ConfigDedicated_r17;
static int ett_lte_rrc_T_pucch_TxDuration_r17;
static int ett_lte_rrc_T_pusch_TxDuration_r17;
static int ett_lte_rrc_PhysicalConfigDedicated_v1370;
static int ett_lte_rrc_PhysicalConfigDedicated_v13c0;
static int ett_lte_rrc_PhysicalConfigDedicatedSCell_r10;
static int ett_lte_rrc_T_nonUL_Configuration_r10;
static int ett_lte_rrc_T_ul_Configuration_r10;
static int ett_lte_rrc_T_pucch_SCell;
static int ett_lte_rrc_T_physicalConfigDedicatedSCell_r10_eag_4_pucch_SCell_setup;
static int ett_lte_rrc_SEQUENCE_SIZE_1_2_OF_SoundingRS_AperiodicSet_r14;
static int ett_lte_rrc_SEQUENCE_SIZE_1_4_OF_SoundingRS_AperiodicSetUpPTsExt_r14;
static int ett_lte_rrc_T_must_Config_r14_01;
static int ett_lte_rrc_T_physicalConfigDedicatedSCell_r10_eag_6_must_Config_r14_setup;
static int ett_lte_rrc_T_semiStaticCFI_Config_r15_01;
static int ett_lte_rrc_T_physicalConfigDedicatedSCell_r10_eag_8_semiStaticCFI_Config_r15_setup;
static int ett_lte_rrc_T_blindPDSCH_Repetition_Config_r15_01;
static int ett_lte_rrc_T_physicalConfigDedicatedSCell_r10_eag_8_blindPDSCH_Repetition_Config_r15_setup;
static int ett_lte_rrc_T_soundingRS_UL_ConfigDedicatedAdd_r16_01;
static int ett_lte_rrc_T_uplinkPowerControlAddSRS_r16_01;
static int ett_lte_rrc_T_soundingRS_VirtualCellID_r16_01;
static int ett_lte_rrc_T_widebandPRG_r16_01;
static int ett_lte_rrc_PhysicalConfigDedicatedSCell_v1370;
static int ett_lte_rrc_T_pucch_SCell_v1370;
static int ett_lte_rrc_T_physicalConfigDedicatedSCell_v1370_pucch_SCell_v1370_setup;
static int ett_lte_rrc_PhysicalConfigDedicatedSCell_v13c0;
static int ett_lte_rrc_T_pucch_SCell_v13c0;
static int ett_lte_rrc_T_physicalConfigDedicatedSCell_v13c0_pucch_SCell_v13c0_setup;
static int ett_lte_rrc_PhysicalConfigDedicatedSCell_v1730;
static int ett_lte_rrc_T_cqi_ReportPeriodicSCell_v1730;
static int ett_lte_rrc_CFI_Config_r15;
static int ett_lte_rrc_CFI_PatternConfig_r15;
static int ett_lte_rrc_T_cfi_PatternSubframe_r15;
static int ett_lte_rrc_T_cfi_PatternSlotSubslot_r15;
static int ett_lte_rrc_LAA_SCellConfiguration_r13;
static int ett_lte_rrc_LAA_SCellConfiguration_v1430;
static int ett_lte_rrc_T_crossCarrierSchedulingConfig_UL_r14;
static int ett_lte_rrc_T_lAA_SCellConfiguration_v1430_crossCarrierSchedulingConfig_UL_r14_setup;
static int ett_lte_rrc_LAA_SCellConfiguration_v1530;
static int ett_lte_rrc_PUSCH_ModeConfigLAA_r15;
static int ett_lte_rrc_LBT_Config_r14;
static int ett_lte_rrc_CSI_RS_ConfigNZPToAddModList_r11;
static int ett_lte_rrc_CSI_RS_ConfigNZPToAddModListExt_r13;
static int ett_lte_rrc_CSI_RS_ConfigNZPToAddModList_r15;
static int ett_lte_rrc_CSI_RS_ConfigNZPToReleaseList_r11;
static int ett_lte_rrc_CSI_RS_ConfigNZPToReleaseListExt_r13;
static int ett_lte_rrc_CSI_RS_ConfigNZPToReleaseList_r15;
static int ett_lte_rrc_CSI_RS_ConfigZPToAddModList_r11;
static int ett_lte_rrc_CSI_RS_ConfigZPToReleaseList_r11;
static int ett_lte_rrc_PhysicalConfigDedicatedSTTI_r15;
static int ett_lte_rrc_T_physicalConfigDedicatedSTTI_r15_setup;
static int ett_lte_rrc_SoundingRS_AperiodicSet_r14;
static int ett_lte_rrc_SEQUENCE_SIZE_1_4_OF_SRS_CC_SetIndex_r14;
static int ett_lte_rrc_SoundingRS_AperiodicSetUpPTsExt_r14;
static int ett_lte_rrc_ShortTTI_r15;
static int ett_lte_rrc_SoundingRS_VirtualCellID_r16;
static int ett_lte_rrc_WidebandPRG_r16;
static int ett_lte_rrc_ResourceReservationConfigDedicatedDL_r16;
static int ett_lte_rrc_ResourceReservationConfigDedicatedUL_r16;
static int ett_lte_rrc_PRACH_ConfigSIB;
static int ett_lte_rrc_PRACH_ConfigSIB_v1310;
static int ett_lte_rrc_T_mpdcch_startSF_CSS_RA_r13;
static int ett_lte_rrc_PRACH_ConfigSIB_v1530;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxCE_Level_r13_OF_EDT_PRACH_ParametersCE_r15;
static int ett_lte_rrc_PRACH_Config;
static int ett_lte_rrc_PRACH_Config_v1310;
static int ett_lte_rrc_T_mpdcch_startSF_CSS_RA_r13_01;
static int ett_lte_rrc_PRACH_Config_v1430;
static int ett_lte_rrc_PRACH_ConfigSCell_r10;
static int ett_lte_rrc_PRACH_ConfigInfo;
static int ett_lte_rrc_PRACH_ParametersListCE_r13;
static int ett_lte_rrc_PRACH_ParametersCE_r13;
static int ett_lte_rrc_T_mpdcch_NarrowbandsToMonitor_r13;
static int ett_lte_rrc_EDT_PRACH_ParametersCE_r15;
static int ett_lte_rrc_T_edt_PRACH_ParametersCE_r15;
static int ett_lte_rrc_T_mpdcch_NarrowbandsToMonitor_r15;
static int ett_lte_rrc_RSRP_ThresholdsPrachInfoList_r13;
static int ett_lte_rrc_PRACH_TxDuration_r17;
static int ett_lte_rrc_PUCCH_ConfigCommon;
static int ett_lte_rrc_PUCCH_ConfigCommon_v1310;
static int ett_lte_rrc_PUCCH_ConfigCommon_v1430;
static int ett_lte_rrc_PUCCH_ConfigDedicated;
static int ett_lte_rrc_T_ackNackRepetition;
static int ett_lte_rrc_T_pUCCH_ConfigDedicated_ackNackRepetition_setup;
static int ett_lte_rrc_PUCCH_ConfigDedicated_v1020;
static int ett_lte_rrc_T_pucch_Format_r10;
static int ett_lte_rrc_T_channelSelection_r10;
static int ett_lte_rrc_T_n1PUCCH_AN_CS_r10;
static int ett_lte_rrc_T_pUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10_n1PUCCH_AN_CS_r10_setup;
static int ett_lte_rrc_SEQUENCE_SIZE_1_2_OF_N1PUCCH_AN_CS_r10;
static int ett_lte_rrc_PUCCH_ConfigDedicated_v1130;
static int ett_lte_rrc_T_n1PUCCH_AN_CS_v1130;
static int ett_lte_rrc_T_pUCCH_ConfigDedicated_v1130_n1PUCCH_AN_CS_v1130_setup;
static int ett_lte_rrc_T_n1PUCCH_AN_CS_ListP1_r11;
static int ett_lte_rrc_T_nPUCCH_Param_r11;
static int ett_lte_rrc_T_pUCCH_ConfigDedicated_v1130_nPUCCH_Param_r11_setup;
static int ett_lte_rrc_PUCCH_ConfigDedicated_v1250;
static int ett_lte_rrc_T_nkaPUCCH_Param_r12;
static int ett_lte_rrc_T_pUCCH_ConfigDedicated_v1250_nkaPUCCH_Param_r12_setup;
static int ett_lte_rrc_PUCCH_ConfigDedicated_r13;
static int ett_lte_rrc_T_ackNackRepetition_r13;
static int ett_lte_rrc_T_pUCCH_ConfigDedicated_r13_ackNackRepetition_r13_setup;
static int ett_lte_rrc_T_pucch_Format_r13;
static int ett_lte_rrc_T_format3_r13;
static int ett_lte_rrc_T_n3PUCCH_AN_List_r13;
static int ett_lte_rrc_T_twoAntennaPortActivatedPUCCH_Format3_r13;
static int ett_lte_rrc_T_pUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_setup;
static int ett_lte_rrc_T_n3PUCCH_AN_ListP1_r13;
static int ett_lte_rrc_T_channelSelection_r13;
static int ett_lte_rrc_T_n1PUCCH_AN_CS_r13;
static int ett_lte_rrc_T_pUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13_n1PUCCH_AN_CS_r13_setup;
static int ett_lte_rrc_N1PUCCH_AN_CS_List_r13;
static int ett_lte_rrc_T_dummy1;
static int ett_lte_rrc_T_format4_r13;
static int ett_lte_rrc_SEQUENCE_SIZE_4_OF_Format4_resource_r13;
static int ett_lte_rrc_SEQUENCE_SIZE_1_2_OF_Format4_resource_r13;
static int ett_lte_rrc_T_format5_r13;
static int ett_lte_rrc_SEQUENCE_SIZE_4_OF_Format5_resource_r13;
static int ett_lte_rrc_T_nPUCCH_Param_r13;
static int ett_lte_rrc_T_pUCCH_ConfigDedicated_r13_nPUCCH_Param_r13_setup;
static int ett_lte_rrc_T_nkaPUCCH_Param_r13;
static int ett_lte_rrc_T_pUCCH_ConfigDedicated_r13_nkaPUCCH_Param_r13_setup;
static int ett_lte_rrc_T_pucch_NumRepetitionCE_r13;
static int ett_lte_rrc_T_pUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup;
static int ett_lte_rrc_T_modeA;
static int ett_lte_rrc_T_modeB;
static int ett_lte_rrc_PUCCH_ConfigDedicated_v1370;
static int ett_lte_rrc_T_pucch_Format_v1370;
static int ett_lte_rrc_PUCCH_ConfigDedicated_v13c0;
static int ett_lte_rrc_T_channelSelection_v13c0;
static int ett_lte_rrc_T_n1PUCCH_AN_CS_v13c0;
static int ett_lte_rrc_T_pUCCH_ConfigDedicated_v13c0_channelSelection_v13c0_n1PUCCH_AN_CS_v13c0_setup;
static int ett_lte_rrc_T_n1PUCCH_AN_CS_ListP1_v13c0;
static int ett_lte_rrc_PUCCH_Format3_Conf_r13;
static int ett_lte_rrc_T_n3PUCCH_AN_List_r13_01;
static int ett_lte_rrc_T_twoAntennaPortActivatedPUCCH_Format3_r13_01;
static int ett_lte_rrc_T_pUCCH_Format3_Conf_r13_twoAntennaPortActivatedPUCCH_Format3_r13_setup;
static int ett_lte_rrc_T_n3PUCCH_AN_ListP1_r13_01;
static int ett_lte_rrc_PUCCH_ConfigDedicated_v1430;
static int ett_lte_rrc_PUCCH_ConfigDedicated_v1530;
static int ett_lte_rrc_Format4_resource_r13;
static int ett_lte_rrc_Format5_resource_r13;
static int ett_lte_rrc_N1PUCCH_AN_CS_r10;
static int ett_lte_rrc_N1PUCCH_AN_InfoList_r13;
static int ett_lte_rrc_PUCCH_TxDuration_r17;
static int ett_lte_rrc_PUR_Config_r16;
static int ett_lte_rrc_T_pur_StartTimeParameters_r16;
static int ett_lte_rrc_T_pur_RSRP_ChangeThreshold_r16;
static int ett_lte_rrc_PUR_MPDCCH_Config_r16;
static int ett_lte_rrc_T_mpdcch_PRB_PairsConfig_r16;
static int ett_lte_rrc_T_mpdcch_StartSF_UESS_r16;
static int ett_lte_rrc_PUR_PUCCH_Config_r16;
static int ett_lte_rrc_PUR_PUSCH_Config_r16;
static int ett_lte_rrc_T_pur_GrantInfo_r16;
static int ett_lte_rrc_T_ce_ModeA;
static int ett_lte_rrc_T_ce_ModeB;
static int ett_lte_rrc_PUR_RSRP_ChangeThreshold_r16;
static int ett_lte_rrc_PUR_PeriodicityAndOffset_r16;
static int ett_lte_rrc_PUSCH_ConfigCommon;
static int ett_lte_rrc_T_pusch_ConfigBasic;
static int ett_lte_rrc_PUSCH_ConfigCommon_v1270;
static int ett_lte_rrc_PUSCH_ConfigCommon_v1310;
static int ett_lte_rrc_PUSCH_ConfigDedicated;
static int ett_lte_rrc_PUSCH_ConfigDedicated_v1020;
static int ett_lte_rrc_T_betaOffsetMC_r10;
static int ett_lte_rrc_PUSCH_ConfigDedicated_v1130;
static int ett_lte_rrc_T_pusch_DMRS_r11;
static int ett_lte_rrc_T_pUSCH_ConfigDedicated_v1130_pusch_DMRS_r11_setup;
static int ett_lte_rrc_PUSCH_ConfigDedicated_v1250;
static int ett_lte_rrc_T_uciOnPUSCH;
static int ett_lte_rrc_T_pUSCH_ConfigDedicated_v1250_uciOnPUSCH_setup;
static int ett_lte_rrc_T_betaOffsetMC_r12;
static int ett_lte_rrc_PUSCH_ConfigDedicated_r13;
static int ett_lte_rrc_T_betaOffsetMC_r13;
static int ett_lte_rrc_T_pusch_DMRS_r11_01;
static int ett_lte_rrc_T_pUSCH_ConfigDedicated_r13_pusch_DMRS_r11_setup;
static int ett_lte_rrc_T_uciOnPUSCH_01;
static int ett_lte_rrc_T_pUSCH_ConfigDedicated_r13_uciOnPUSCH_setup;
static int ett_lte_rrc_T_betaOffsetMC_r12_01;
static int ett_lte_rrc_PUSCH_ConfigDedicated_v1430;
static int ett_lte_rrc_PUSCH_ConfigDedicated_v1530;
static int ett_lte_rrc_T_ce_PUSCH_FlexibleStartPRB_AllocConfig_r15;
static int ett_lte_rrc_T_pUSCH_ConfigDedicated_v1530_ce_PUSCH_FlexibleStartPRB_AllocConfig_r15_setup;
static int ett_lte_rrc_T_ce_PUSCH_SubPRB_Config_r15;
static int ett_lte_rrc_T_pUSCH_ConfigDedicated_v1530_ce_PUSCH_SubPRB_Config_r15_setup;
static int ett_lte_rrc_PUSCH_ConfigDedicated_v1610;
static int ett_lte_rrc_T_ce_PUSCH_MultiTB_Config_r16;
static int ett_lte_rrc_PUSCH_ConfigDedicated_v1800;
static int ett_lte_rrc_T_uplinkHARQ_Mode_r18;
static int ett_lte_rrc_PUSCH_ConfigDedicatedSCell_r10;
static int ett_lte_rrc_PUSCH_ConfigDedicatedSCell_v1430;
static int ett_lte_rrc_PUSCH_ConfigDedicatedScell_v1530;
static int ett_lte_rrc_T_uci_OnPUSCH_r15;
static int ett_lte_rrc_T_pUSCH_ConfigDedicatedScell_v1530_uci_OnPUSCH_r15_setup;
static int ett_lte_rrc_TDD_PUSCH_UpPTS_r14;
static int ett_lte_rrc_T_tDD_PUSCH_UpPTS_r14_setup;
static int ett_lte_rrc_CE_PUSCH_MultiTB_Config_r16;
static int ett_lte_rrc_PUSCH_TxDuration_r17;
static int ett_lte_rrc_Enable256QAM_r14;
static int ett_lte_rrc_T_enable256QAM_r14_setup;
static int ett_lte_rrc_T_tpc_SubframeSet_Configured_r14;
static int ett_lte_rrc_T_tpc_SubframeSet_NotConfigured_r14;
static int ett_lte_rrc_PUSCH_EnhancementsConfig_r14;
static int ett_lte_rrc_T_pUSCH_EnhancementsConfig_r14_setup;
static int ett_lte_rrc_T_interval_ULHoppingPUSCH_Enh_r14;
static int ett_lte_rrc_UL_ReferenceSignalsPUSCH;
static int ett_lte_rrc_RACH_ConfigCommon;
static int ett_lte_rrc_T_preambleInfo;
static int ett_lte_rrc_T_preamblesGroupAConfig;
static int ett_lte_rrc_T_ra_SupervisionInfo;
static int ett_lte_rrc_RACH_ConfigCommon_v1250;
static int ett_lte_rrc_T_txFailParams_r12;
static int ett_lte_rrc_RACH_ConfigCommonSCell_r11;
static int ett_lte_rrc_T_ra_SupervisionInfo_r11;
static int ett_lte_rrc_RACH_CE_LevelInfoList_r13;
static int ett_lte_rrc_RACH_CE_LevelInfo_r13;
static int ett_lte_rrc_T_preambleMappingInfo_r13;
static int ett_lte_rrc_T_edt_Parameters_r15;
static int ett_lte_rrc_PowerRampingParameters;
static int ett_lte_rrc_RACH_ConfigDedicated;
static int ett_lte_rrc_RadioResourceConfigCommonSIB;
static int ett_lte_rrc_T_ntn_ConfigCommon_r17;
static int ett_lte_rrc_RadioResourceConfigCommon;
static int ett_lte_rrc_T_ntn_ConfigCommon_r17_01;
static int ett_lte_rrc_RadioResourceConfigCommonPSCell_r12;
static int ett_lte_rrc_RadioResourceConfigCommonPSCell_v12f0;
static int ett_lte_rrc_RadioResourceConfigCommonPSCell_v1440;
static int ett_lte_rrc_RadioResourceConfigCommonSCell_r10;
static int ett_lte_rrc_T_nonUL_Configuration_r10_01;
static int ett_lte_rrc_T_ul_Configuration_r10_01;
static int ett_lte_rrc_T_ul_FreqInfo_r10;
static int ett_lte_rrc_T_ul_Configuration_r14;
static int ett_lte_rrc_T_ul_FreqInfo_r14;
static int ett_lte_rrc_RadioResourceConfigCommonSCell_v10l0;
static int ett_lte_rrc_T_ul_Configuration_v10l0;
static int ett_lte_rrc_RadioResourceConfigCommonSCell_v1440;
static int ett_lte_rrc_T_ul_Configuration_v1440;
static int ett_lte_rrc_T_ul_FreqInfo_v1440;
static int ett_lte_rrc_BCCH_Config;
static int ett_lte_rrc_BCCH_Config_v1310;
static int ett_lte_rrc_FreqHoppingParameters_r13;
static int ett_lte_rrc_T_dummy2_01;
static int ett_lte_rrc_T_dummy3;
static int ett_lte_rrc_T_interval_ULHoppingConfigCommonModeA_r13;
static int ett_lte_rrc_T_interval_ULHoppingConfigCommonModeB_r13;
static int ett_lte_rrc_PCCH_Config;
static int ett_lte_rrc_PCCH_Config_v1310;
static int ett_lte_rrc_PCCH_Config_v1700;
static int ett_lte_rrc_HighSpeedConfig_r14;
static int ett_lte_rrc_HighSpeedConfig_v1530;
static int ett_lte_rrc_HighSpeedConfigSCell_r14;
static int ett_lte_rrc_HighSpeedConfig_v1610;
static int ett_lte_rrc_RadioResourceConfigDedicated;
static int ett_lte_rrc_T_mac_MainConfig;
static int ett_lte_rrc_T_crs_IntfMitigConfig_r15_01;
static int ett_lte_rrc_T_radioResourceConfigDedicated_eag_7_crs_IntfMitigConfig_r15_setup;
static int ett_lte_rrc_T_radioResourceConfigDedicated_eag_7_dummy;
static int ett_lte_rrc_T_crs_ChEstMPDCCH_ConfigDedicated_r16;
static int ett_lte_rrc_RadioResourceConfigDedicated_v1370;
static int ett_lte_rrc_RadioResourceConfigDedicated_v13c0;
static int ett_lte_rrc_RadioResourceConfigDedicatedPSCell_r12;
static int ett_lte_rrc_RadioResourceConfigDedicatedPSCell_v1370;
static int ett_lte_rrc_RadioResourceConfigDedicatedPSCell_v13c0;
static int ett_lte_rrc_RadioResourceConfigDedicatedSCG_r12;
static int ett_lte_rrc_RadioResourceConfigDedicatedSCell_r10;
static int ett_lte_rrc_RadioResourceConfigDedicatedSCell_v13c0;
static int ett_lte_rrc_SRB_ToAddModList;
static int ett_lte_rrc_SRB_ToAddModListExt_r15;
static int ett_lte_rrc_SRB_ToAddMod;
static int ett_lte_rrc_T_rlc_Config;
static int ett_lte_rrc_T_logicalChannelConfig;
static int ett_lte_rrc_DRB_ToAddModList;
static int ett_lte_rrc_DRB_ToAddModList_r15;
static int ett_lte_rrc_DRB_ToAddModListSCG_r12;
static int ett_lte_rrc_DRB_ToAddModListSCG_r15;
static int ett_lte_rrc_DRB_ToAddMod;
static int ett_lte_rrc_DRB_ToAddModSCG_r12;
static int ett_lte_rrc_T_drb_Type_r12_01;
static int ett_lte_rrc_T_scg_r12;
static int ett_lte_rrc_DRB_ToReleaseList;
static int ett_lte_rrc_DRB_ToReleaseList_r15;
static int ett_lte_rrc_SRB_ToReleaseList_r15;
static int ett_lte_rrc_MeasSubframePatternPCell_r10;
static int ett_lte_rrc_NeighCellsCRS_Info_r11;
static int ett_lte_rrc_CRS_AssistanceInfoList_r11;
static int ett_lte_rrc_CRS_AssistanceInfo_r11;
static int ett_lte_rrc_NeighCellsCRS_Info_r13;
static int ett_lte_rrc_CRS_AssistanceInfoList_r13;
static int ett_lte_rrc_CRS_AssistanceInfo_r13;
static int ett_lte_rrc_NeighCellsCRS_Info_r15;
static int ett_lte_rrc_CRS_AssistanceInfoList_r15;
static int ett_lte_rrc_CRS_AssistanceInfo_r15;
static int ett_lte_rrc_NAICS_AssistanceInfo_r12;
static int ett_lte_rrc_T_nAICS_AssistanceInfo_r12_setup;
static int ett_lte_rrc_NeighCellsToReleaseList_r12;
static int ett_lte_rrc_NeighCellsToAddModList_r12;
static int ett_lte_rrc_NeighCellsInfo_r12;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxP_a_PerNeighCell_r12_OF_P_a;
static int ett_lte_rrc_RLC_BearerConfig_r15;
static int ett_lte_rrc_T_rLC_BearerConfig_r15_setup;
static int ett_lte_rrc_T_logicalChannelIdentityConfig_r15;
static int ett_lte_rrc_RCLWI_Configuration_r13;
static int ett_lte_rrc_T_rCLWI_Configuration_r13_setup;
static int ett_lte_rrc_RCLWI_Config_r13;
static int ett_lte_rrc_T_command;
static int ett_lte_rrc_T_steerToWLAN_r13;
static int ett_lte_rrc_ResourceReservationConfigDL_r16;
static int ett_lte_rrc_T_resourceReservationFreq_r16;
static int ett_lte_rrc_T_slotBitmap_r16;
static int ett_lte_rrc_ResourceReservationConfigUL_r16;
static int ett_lte_rrc_T_slotBitmap_r16_01;
static int ett_lte_rrc_PeriodicityStartPos_r16;
static int ett_lte_rrc_RLC_Config;
static int ett_lte_rrc_T_am;
static int ett_lte_rrc_T_um_Bi_Directional;
static int ett_lte_rrc_T_um_Uni_Directional_UL;
static int ett_lte_rrc_T_um_Uni_Directional_DL;
static int ett_lte_rrc_RLC_Config_v1250;
static int ett_lte_rrc_RLC_Config_v1310;
static int ett_lte_rrc_RLC_Config_v1430;
static int ett_lte_rrc_T_rLC_Config_v1430_setup;
static int ett_lte_rrc_RLC_Config_v1510;
static int ett_lte_rrc_RLC_Config_v1530;
static int ett_lte_rrc_T_rLC_Config_v1530_setup;
static int ett_lte_rrc_RLC_Config_v1700;
static int ett_lte_rrc_T_t_ReorderingExt_r17;
static int ett_lte_rrc_RLC_Config_r15;
static int ett_lte_rrc_T_mode_r15;
static int ett_lte_rrc_T_am_r15;
static int ett_lte_rrc_T_um_Bi_Directional_r15;
static int ett_lte_rrc_T_um_Uni_Directional_UL_r15;
static int ett_lte_rrc_T_um_Uni_Directional_DL_r15;
static int ett_lte_rrc_UL_AM_RLC;
static int ett_lte_rrc_UL_AM_RLC_r15;
static int ett_lte_rrc_DL_AM_RLC;
static int ett_lte_rrc_DL_AM_RLC_r15;
static int ett_lte_rrc_UL_UM_RLC;
static int ett_lte_rrc_DL_UM_RLC;
static int ett_lte_rrc_DL_UM_RLC_r15;
static int ett_lte_rrc_RLF_TimersAndConstants_r9;
static int ett_lte_rrc_T_rLF_TimersAndConstants_r9_setup;
static int ett_lte_rrc_RLF_TimersAndConstants_r13;
static int ett_lte_rrc_T_rLF_TimersAndConstants_r13_setup;
static int ett_lte_rrc_RLF_TimersAndConstantsSCG_r12;
static int ett_lte_rrc_T_rLF_TimersAndConstantsSCG_r12_setup;
static int ett_lte_rrc_RLF_TimersAndConstantsMCG_Failure_r16;
static int ett_lte_rrc_T_rLF_TimersAndConstantsMCG_Failure_r16_setup;
static int ett_lte_rrc_RN_SubframeConfig_r10;
static int ett_lte_rrc_T_subframeConfigPattern_r10;
static int ett_lte_rrc_T_rpdcch_Config_r10;
static int ett_lte_rrc_T_resourceBlockAssignment_r10;
static int ett_lte_rrc_T_type01_r10;
static int ett_lte_rrc_T_type2_r10;
static int ett_lte_rrc_T_demodulationRS_r10;
static int ett_lte_rrc_T_pucch_Config_r10;
static int ett_lte_rrc_T_tdd_01;
static int ett_lte_rrc_T_channelSelectionMultiplexingBundling;
static int ett_lte_rrc_T_n1PUCCH_AN_List_r10;
static int ett_lte_rrc_T_fallbackForFormat3;
static int ett_lte_rrc_T_fdd_01;
static int ett_lte_rrc_RSS_Config_r15;
static int ett_lte_rrc_SchedulingRequestConfig;
static int ett_lte_rrc_T_schedulingRequestConfig_setup;
static int ett_lte_rrc_SchedulingRequestConfig_v1020;
static int ett_lte_rrc_SchedulingRequestConfigSCell_r13;
static int ett_lte_rrc_T_schedulingRequestConfigSCell_r13_setup;
static int ett_lte_rrc_SchedulingRequestConfig_v1530;
static int ett_lte_rrc_T_schedulingRequestConfig_v1530_setup;
static int ett_lte_rrc_SR_SubslotSPUCCH_ResourceList_r15;
static int ett_lte_rrc_SlotOrSubslotPDSCH_Config_r15;
static int ett_lte_rrc_T_slotOrSubslotPDSCH_Config_r15_setup;
static int ett_lte_rrc_SlotOrSubslotPUSCH_Config_r15;
static int ett_lte_rrc_T_slotOrSubslotPUSCH_Config_r15_setup;
static int ett_lte_rrc_T_betaOffsetSubslot_ACK_Index_r15;
static int ett_lte_rrc_T_betaOffset2Subslot_ACK_Index_r15;
static int ett_lte_rrc_T_betaOffsetSubslot_RI_Index_r15;
static int ett_lte_rrc_SoundingRS_UL_ConfigCommon;
static int ett_lte_rrc_T_soundingRS_UL_ConfigCommon_setup;
static int ett_lte_rrc_SoundingRS_UL_ConfigDedicated;
static int ett_lte_rrc_T_soundingRS_UL_ConfigDedicated_setup;
static int ett_lte_rrc_SoundingRS_UL_ConfigDedicated_v1020;
static int ett_lte_rrc_SoundingRS_UL_ConfigDedicated_v1310;
static int ett_lte_rrc_T_soundingRS_UL_ConfigDedicated_v1310_setup;
static int ett_lte_rrc_SoundingRS_UL_ConfigDedicatedUpPTsExt_r13;
static int ett_lte_rrc_T_soundingRS_UL_ConfigDedicatedUpPTsExt_r13_setup;
static int ett_lte_rrc_SoundingRS_UL_ConfigDedicatedAperiodic_r10;
static int ett_lte_rrc_T_soundingRS_UL_ConfigDedicatedAperiodic_r10_setup;
static int ett_lte_rrc_SEQUENCE_SIZE_1_3_OF_SRS_ConfigAp_r10;
static int ett_lte_rrc_T_srs_ActivateAp_r10;
static int ett_lte_rrc_T_setup;
static int ett_lte_rrc_SoundingRS_UL_ConfigDedicatedAperiodic_v1310;
static int ett_lte_rrc_T_soundingRS_UL_ConfigDedicatedAperiodic_v1310_setup;
static int ett_lte_rrc_SEQUENCE_SIZE_1_3_OF_SRS_ConfigAp_v1310;
static int ett_lte_rrc_T_srs_ActivateAp_v1310;
static int ett_lte_rrc_T_soundingRS_UL_ConfigDedicatedAperiodic_v1310_setup_srs_ActivateAp_v1310_setup;
static int ett_lte_rrc_SoundingRS_UL_ConfigDedicatedAperiodicUpPTsExt_r13;
static int ett_lte_rrc_T_soundingRS_UL_ConfigDedicatedAperiodicUpPTsExt_r13_setup;
static int ett_lte_rrc_SEQUENCE_SIZE_1_3_OF_SRS_ConfigAp_r13;
static int ett_lte_rrc_T_srs_ActivateAp_r13;
static int ett_lte_rrc_T_soundingRS_UL_ConfigDedicatedAperiodicUpPTsExt_r13_setup_srs_ActivateAp_r13_setup;
static int ett_lte_rrc_SoundingRS_UL_ConfigDedicatedAperiodic_v1430;
static int ett_lte_rrc_T_soundingRS_UL_ConfigDedicatedAperiodic_v1430_setup;
static int ett_lte_rrc_SoundingRS_UL_ConfigDedicatedAdd_r16;
static int ett_lte_rrc_SEQUENCE_SIZE_1_3_OF_SRS_ConfigAdd_r16;
static int ett_lte_rrc_T_srs_ActivateAp_r13_01;
static int ett_lte_rrc_T_soundingRS_UL_ConfigDedicatedAdd_r16_srs_ActivateAp_r13_setup;
static int ett_lte_rrc_SRS_ConfigAp_r10;
static int ett_lte_rrc_SRS_ConfigAp_v1310;
static int ett_lte_rrc_SRS_ConfigAp_r13;
static int ett_lte_rrc_SRS_ConfigAdd_r16;
static int ett_lte_rrc_SPDCCH_Config_r15;
static int ett_lte_rrc_T_sPDCCH_Config_r15_setup;
static int ett_lte_rrc_SPDCCH_Set_r15;
static int ett_lte_rrc_SPDCCH_Elements_r15;
static int ett_lte_rrc_T_sPDCCH_Elements_r15_setup;
static int ett_lte_rrc_SEQUENCE_SIZE_1_4_OF_DCI7_Candidates_r15;
static int ett_lte_rrc_SEQUENCE_SIZE_1_2_OF_DCI7_CandidatesPerAL_SPDCCH_r15;
static int ett_lte_rrc_T_resourceBlockAssignment_r15;
static int ett_lte_rrc_T_al_StartingPointSPDCCH_r15;
static int ett_lte_rrc_DCI7_CandidatesPerAL_SPDCCH_r15;
static int ett_lte_rrc_SPS_Config;
static int ett_lte_rrc_SPS_Config_v1430;
static int ett_lte_rrc_SPS_ConfigUL_ToAddModList_r14;
static int ett_lte_rrc_SPS_ConfigUL_ToReleaseList_r14;
static int ett_lte_rrc_SPS_ConfigSL_ToAddModList_r14;
static int ett_lte_rrc_SPS_ConfigSL_ToReleaseList_r14;
static int ett_lte_rrc_SPS_Config_v1530;
static int ett_lte_rrc_SPS_Config_v1540;
static int ett_lte_rrc_SPS_ConfigUL_STTI_ToAddModList_r15;
static int ett_lte_rrc_SPS_ConfigUL_STTI_ToReleaseList_r15;
static int ett_lte_rrc_SPS_ConfigUL_ToAddModList_r15;
static int ett_lte_rrc_SPS_ConfigUL_ToReleaseList_r15;
static int ett_lte_rrc_SPS_ConfigDL;
static int ett_lte_rrc_T_sPS_ConfigDL_setup;
static int ett_lte_rrc_T_twoAntennaPortActivated_r10;
static int ett_lte_rrc_T_sPS_ConfigDL_setup_eag_1_twoAntennaPortActivated_r10_setup;
static int ett_lte_rrc_SPS_ConfigUL;
static int ett_lte_rrc_T_sPS_ConfigUL_setup;
static int ett_lte_rrc_T_p0_Persistent;
static int ett_lte_rrc_T_p0_PersistentSubframeSet2_r12;
static int ett_lte_rrc_T_sPS_ConfigUL_setup_eag_1_p0_PersistentSubframeSet2_r12_setup;
static int ett_lte_rrc_SPS_ConfigSL_r14;
static int ett_lte_rrc_N1PUCCH_AN_PersistentList;
static int ett_lte_rrc_N1SPUCCH_AN_PersistentList_r15;
static int ett_lte_rrc_SPS_ConfigDL_STTI_r15;
static int ett_lte_rrc_T_sPS_ConfigDL_STTI_r15_setup;
static int ett_lte_rrc_T_twoAntennaPortActivated_r15;
static int ett_lte_rrc_T_sPS_ConfigDL_STTI_r15_setup_twoAntennaPortActivated_r15_setup;
static int ett_lte_rrc_SPS_ConfigUL_STTI_r15;
static int ett_lte_rrc_T_sPS_ConfigUL_STTI_r15_setup;
static int ett_lte_rrc_T_p0_Persistent_r15;
static int ett_lte_rrc_T_p0_PersistentSubframeSet2_r15;
static int ett_lte_rrc_T_sPS_ConfigUL_STTI_r15_setup_p0_PersistentSubframeSet2_r15_setup;
static int ett_lte_rrc_SPUCCH_Config_r15;
static int ett_lte_rrc_T_sPUCCH_Config_r15_setup;
static int ett_lte_rrc_T_sPUCCH_Config_r15_setup_dummy;
static int ett_lte_rrc_T_n3SPUCCH_AN_List_r15;
static int ett_lte_rrc_SPUCCH_Config_v1550;
static int ett_lte_rrc_T_sPUCCH_Config_v1550_setup;
static int ett_lte_rrc_T_twoAntennaPortActivatedSPUCCH_Format3_v1550;
static int ett_lte_rrc_T_n3SPUCCH_AN_List_v1550;
static int ett_lte_rrc_SPUCCH_Set_r15;
static int ett_lte_rrc_SPUCCH_Elements_r15;
static int ett_lte_rrc_T_sPUCCH_Elements_r15_setup;
static int ett_lte_rrc_T_n1SubslotSPUCCH_AN_List_r15;
static int ett_lte_rrc_SEQUENCE_SIZE_1_2_OF_N4SPUCCH_Resource_r15;
static int ett_lte_rrc_N4SPUCCH_Resource_r15;
static int ett_lte_rrc_SRS_TPC_PDCCH_Config_r14;
static int ett_lte_rrc_T_sRS_TPC_PDCCH_Config_r14_setup;
static int ett_lte_rrc_SRS_CC_SetIndex_r14;
static int ett_lte_rrc_TDD_Config;
static int ett_lte_rrc_TDD_Config_v1130;
static int ett_lte_rrc_TDD_Config_v1430;
static int ett_lte_rrc_TDD_Config_v1450;
static int ett_lte_rrc_TDD_ConfigSL_r12;
static int ett_lte_rrc_TDM_PatternConfig_r15;
static int ett_lte_rrc_T_tDM_PatternConfig_r15_setup;
static int ett_lte_rrc_TimeReferenceInfo_r15;
static int ett_lte_rrc_ReferenceTime_r15;
static int ett_lte_rrc_TPC_PDCCH_Config;
static int ett_lte_rrc_T_tPC_PDCCH_Config_setup;
static int ett_lte_rrc_TPC_PDCCH_ConfigSCell_r13;
static int ett_lte_rrc_T_tPC_PDCCH_ConfigSCell_r13_setup;
static int ett_lte_rrc_TPC_Index;
static int ett_lte_rrc_TunnelConfigLWIP_r13;
static int ett_lte_rrc_IKE_Identity_r13;
static int ett_lte_rrc_IP_Address_r13;
static int ett_lte_rrc_UplinkPowerControlCommon;
static int ett_lte_rrc_UplinkPowerControlCommon_v1020;
static int ett_lte_rrc_UplinkPowerControlCommon_v1310;
static int ett_lte_rrc_UplinkPowerControlCommon_v1530;
static int ett_lte_rrc_UplinkPowerControlCommon_v1610;
static int ett_lte_rrc_UplinkPowerControlCommonPSCell_r12;
static int ett_lte_rrc_UplinkPowerControlCommonSCell_r10;
static int ett_lte_rrc_UplinkPowerControlCommonSCell_v1130;
static int ett_lte_rrc_UplinkPowerControlCommonSCell_v1310;
static int ett_lte_rrc_UplinkPowerControlCommonPUSCH_LessCell_v1430;
static int ett_lte_rrc_UplinkPowerControlDedicated;
static int ett_lte_rrc_UplinkPowerControlDedicated_v1020;
static int ett_lte_rrc_UplinkPowerControlDedicated_v1130;
static int ett_lte_rrc_UplinkPowerControlDedicated_v1250;
static int ett_lte_rrc_T_set2PowerControlParameter;
static int ett_lte_rrc_T_uplinkPowerControlDedicated_v1250_set2PowerControlParameter_setup;
static int ett_lte_rrc_UplinkPowerControlDedicated_v1530;
static int ett_lte_rrc_UplinkPowerControlDedicatedSTTI_r15;
static int ett_lte_rrc_UplinkPUSCH_LessPowerControlDedicated_v1430;
static int ett_lte_rrc_UplinkPowerControlAddSRS_r16;
static int ett_lte_rrc_UplinkPowerControlDedicatedSCell_r10;
static int ett_lte_rrc_UplinkPowerControlDedicatedSCell_v1310;
static int ett_lte_rrc_DeltaFList_PUCCH;
static int ett_lte_rrc_DeltaFList_SPUCCH_r15;
static int ett_lte_rrc_T_deltaFList_SPUCCH_r15_setup;
static int ett_lte_rrc_DeltaTxD_OffsetListPUCCH_r10;
static int ett_lte_rrc_DeltaTxD_OffsetListPUCCH_v1130;
static int ett_lte_rrc_DeltaTxD_OffsetListSPUCCH_r15;
static int ett_lte_rrc_WLAN_Id_List_r13;
static int ett_lte_rrc_WLAN_MobilityConfig_r13;
static int ett_lte_rrc_WUS_Config_r15;
static int ett_lte_rrc_WUS_Config_v1560;
static int ett_lte_rrc_WUS_Config_v1610;
static int ett_lte_rrc_SecurityAlgorithmConfig;
static int ett_lte_rrc_CarrierFreqCDMA2000;
static int ett_lte_rrc_CarrierFreqGERAN;
static int ett_lte_rrc_CarrierFreqsGERAN;
static int ett_lte_rrc_T_followingARFCNs;
static int ett_lte_rrc_T_equallySpacedARFCNs;
static int ett_lte_rrc_ExplicitListOfARFCNs;
static int ett_lte_rrc_CarrierFreqListMBMS_r11;
static int ett_lte_rrc_CellGlobalIdNR_r16;
static int ett_lte_rrc_CellIndexList;
static int ett_lte_rrc_CellSelectionInfoCE_r13;
static int ett_lte_rrc_CellSelectionInfoCE_v1530;
static int ett_lte_rrc_CellSelectionInfoCE1_r13;
static int ett_lte_rrc_CellSelectionInfoCE1_v1360;
static int ett_lte_rrc_CSFB_RegistrationParam1XRTT;
static int ett_lte_rrc_CSFB_RegistrationParam1XRTT_v920;
static int ett_lte_rrc_CellGlobalIdEUTRA;
static int ett_lte_rrc_CellGlobalIdUTRA;
static int ett_lte_rrc_CellGlobalIdGERAN;
static int ett_lte_rrc_CellGlobalIdCDMA2000;
static int ett_lte_rrc_CellSelectionInfoNFreq_r13;
static int ett_lte_rrc_ConditionalReconfiguration_r16;
static int ett_lte_rrc_CondReconfigurationToRemoveList_r16;
static int ett_lte_rrc_CondReconfigurationToAddModList_r16;
static int ett_lte_rrc_CondReconfigurationAddMod_r16;
static int ett_lte_rrc_SEQUENCE_SIZE_1_2_OF_MeasId;
static int ett_lte_rrc_EphemerisOrbitalParameters_r17;
static int ett_lte_rrc_EphemerisStateVectors_r17;
static int ett_lte_rrc_MobilityControlInfo;
static int ett_lte_rrc_MobilityControlInfo_v10l0;
static int ett_lte_rrc_MobilityControlInfoSCG_r12;
static int ett_lte_rrc_MobilityControlInfoV2X_r14;
static int ett_lte_rrc_CarrierBandwidthEUTRA;
static int ett_lte_rrc_CarrierFreqEUTRA;
static int ett_lte_rrc_CarrierFreqEUTRA_v9e0;
static int ett_lte_rrc_DAPS_Config_r16;
static int ett_lte_rrc_DAPS_PowerCoordinationInfo_r16;
static int ett_lte_rrc_RACH_Skip_r14;
static int ett_lte_rrc_T_targetTA_r14;
static int ett_lte_rrc_T_ul_ConfigInfo_r14;
static int ett_lte_rrc_MobilityStateParameters;
static int ett_lte_rrc_MultiBandInfoList;
static int ett_lte_rrc_MultiBandInfoList_v9e0;
static int ett_lte_rrc_MultiBandInfoList_v10j0;
static int ett_lte_rrc_MultiBandInfoList_v10l0;
static int ett_lte_rrc_MultiBandInfoList_r11;
static int ett_lte_rrc_MultiBandInfo_v9e0;
static int ett_lte_rrc_MultiBandInfoListAerial_r18;
static int ett_lte_rrc_MultiBandInfoAerial_r18;
static int ett_lte_rrc_MultiFrequencyBandListNR_r15;
static int ett_lte_rrc_NS_PmaxList_r10;
static int ett_lte_rrc_NS_PmaxList_v10l0;
static int ett_lte_rrc_NS_PmaxListAerial_r18;
static int ett_lte_rrc_NS_PmaxValue_r10;
static int ett_lte_rrc_NS_PmaxValue_v10l0;
static int ett_lte_rrc_NS_PmaxValueAerial_r18;
static int ett_lte_rrc_NS_PmaxListNR_r15;
static int ett_lte_rrc_NS_PmaxValueNR_r15;
static int ett_lte_rrc_NS_PmaxListNR_v1760;
static int ett_lte_rrc_NS_PmaxValueNR_v1760;
static int ett_lte_rrc_NS_PmaxListNR_Aerial_r18;
static int ett_lte_rrc_NS_PmaxValueNR_Aerial_r18;
static int ett_lte_rrc_PhysCellIdGERAN;
static int ett_lte_rrc_PhysCellIdRange;
static int ett_lte_rrc_PhysCellIdRangeNR_r16;
static int ett_lte_rrc_PhysCellIdRangeUTRA_FDDList_r9;
static int ett_lte_rrc_PhysCellIdRangeUTRA_FDD_r9;
static int ett_lte_rrc_PLMN_Identity;
static int ett_lte_rrc_MCC;
static int ett_lte_rrc_MNC;
static int ett_lte_rrc_PLMN_IdentityList3_r11;
static int ett_lte_rrc_PreRegistrationInfoHRPD;
static int ett_lte_rrc_SecondaryPreRegistrationZoneIdListHRPD;
static int ett_lte_rrc_RSS_ConfigCarrierInfo_r16;
static int ett_lte_rrc_SpeedStateScaleFactors;
static int ett_lte_rrc_SystemInfoListGERAN;
static int ett_lte_rrc_SystemTimeInfoCDMA2000;
static int ett_lte_rrc_T_cdma_SystemTime;
static int ett_lte_rrc_ThresholdNR_r15;
static int ett_lte_rrc_ThresholdListNR_r15;
static int ett_lte_rrc_TLE_EphemerisParameters_r17;
static int ett_lte_rrc_BT_NameListConfig_r15;
static int ett_lte_rrc_BT_NameList_r15;
static int ett_lte_rrc_LocationInfo_r10;
static int ett_lte_rrc_T_locationCoordinates_r10;
static int ett_lte_rrc_T_verticalVelocityInfo_r15;
static int ett_lte_rrc_LogMeasResultListBT_r15;
static int ett_lte_rrc_LogMeasResultBT_r15;
static int ett_lte_rrc_LogMeasResultListWLAN_r15;
static int ett_lte_rrc_LogMeasResultWLAN_r15;
static int ett_lte_rrc_MeasConfig;
static int ett_lte_rrc_T_speedStatePars;
static int ett_lte_rrc_T_measConfig_speedStatePars_setup;
static int ett_lte_rrc_T_measScaleFactor_r12;
static int ett_lte_rrc_T_heightThreshRef_r15;
static int ett_lte_rrc_MeasIdToRemoveList;
static int ett_lte_rrc_MeasIdToRemoveListExt_r12;
static int ett_lte_rrc_MeasObjectToRemoveList;
static int ett_lte_rrc_MeasObjectToRemoveListExt_r13;
static int ett_lte_rrc_ReportConfigToRemoveList;
static int ett_lte_rrc_MeasDS_Config_r12;
static int ett_lte_rrc_T_measDS_Config_r12_setup;
static int ett_lte_rrc_T_dmtc_PeriodOffset_r12;
static int ett_lte_rrc_T_ds_OccasionDuration_r12;
static int ett_lte_rrc_MeasCSI_RS_ToRemoveList_r12;
static int ett_lte_rrc_MeasCSI_RS_ToAddModList_r12;
static int ett_lte_rrc_MeasCSI_RS_Config_r12;
static int ett_lte_rrc_MeasGapConfig;
static int ett_lte_rrc_T_measGapConfig_setup;
static int ett_lte_rrc_T_gapOffset;
static int ett_lte_rrc_MeasGapConfigDensePRS_r15;
static int ett_lte_rrc_T_measGapConfigDensePRS_r15_setup;
static int ett_lte_rrc_T_gapOffsetDensePRS_r15;
static int ett_lte_rrc_MeasGapConfigPerCC_List_r14;
static int ett_lte_rrc_T_measGapConfigPerCC_List_r14_setup;
static int ett_lte_rrc_MeasGapConfigToRemoveList_r14;
static int ett_lte_rrc_MeasGapConfigToAddModList_r14;
static int ett_lte_rrc_MeasGapConfigPerCC_r14;
static int ett_lte_rrc_MeasGapSharingConfig_r14;
static int ett_lte_rrc_T_measGapSharingConfig_r14_setup;
static int ett_lte_rrc_MeasIdleConfigSIB_r15;
static int ett_lte_rrc_MeasIdleConfigSIB_NR_r16;
static int ett_lte_rrc_MeasIdleConfigDedicated_r15;
static int ett_lte_rrc_EUTRA_CarrierList_r15;
static int ett_lte_rrc_NR_CarrierList_r16;
static int ett_lte_rrc_MeasIdleCarrierEUTRA_r15;
static int ett_lte_rrc_T_qualityThreshold_r15;
static int ett_lte_rrc_ValidityAreaList_r16;
static int ett_lte_rrc_ValidityArea_r16;
static int ett_lte_rrc_ValidityCellList_r16;
static int ett_lte_rrc_MeasIdleCarrierNR_r16;
static int ett_lte_rrc_T_qualityThresholdNR_r16;
static int ett_lte_rrc_T_ssb_MeasConfig_r16;
static int ett_lte_rrc_CellList_r15;
static int ett_lte_rrc_CellListNR_r16;
static int ett_lte_rrc_BeamMeasConfigIdleNR_r16;
static int ett_lte_rrc_MeasIdToAddModList;
static int ett_lte_rrc_MeasIdToAddModList_v1310;
static int ett_lte_rrc_MeasIdToAddModListExt_r12;
static int ett_lte_rrc_MeasIdToAddModListExt_v1310;
static int ett_lte_rrc_MeasIdToAddMod;
static int ett_lte_rrc_MeasIdToAddModExt_r12;
static int ett_lte_rrc_MeasIdToAddMod_v1310;
static int ett_lte_rrc_MeasObjectCDMA2000;
static int ett_lte_rrc_CellsToAddModListCDMA2000;
static int ett_lte_rrc_CellsToAddModCDMA2000;
static int ett_lte_rrc_MeasObjectEUTRA;
static int ett_lte_rrc_T_t312_r12;
static int ett_lte_rrc_T_measRSS_DedicatedConfig_r16;
static int ett_lte_rrc_MeasObjectEUTRA_v9e0;
static int ett_lte_rrc_MeasRSS_DedicatedConfig_r16;
static int ett_lte_rrc_CellsToAddModList;
static int ett_lte_rrc_CellsToAddModList_v1610;
static int ett_lte_rrc_CellsToAddModList_v1810;
static int ett_lte_rrc_CellsToAddMod;
static int ett_lte_rrc_CellsToAddMod_v1610;
static int ett_lte_rrc_CellsToAddMod_v1810;
static int ett_lte_rrc_T_ephemerisInfo_r18_01;
static int ett_lte_rrc_T_epochTime_r18_01;
static int ett_lte_rrc_ExcludedCellsToAddModList;
static int ett_lte_rrc_ExcludedCellsToAddMod;
static int ett_lte_rrc_MeasSubframePatternConfigNeigh_r10;
static int ett_lte_rrc_T_measSubframePatternConfigNeigh_r10_setup;
static int ett_lte_rrc_MeasSubframeCellList_r10;
static int ett_lte_rrc_AltTTT_CellsToAddModList_r12;
static int ett_lte_rrc_AltTTT_CellsToAddMod_r12;
static int ett_lte_rrc_AllowedCellsToAddModList_r13;
static int ett_lte_rrc_AllowedCellsToAddMod_r13;
static int ett_lte_rrc_RMTC_Config_r13;
static int ett_lte_rrc_T_rMTC_Config_r13_setup;
static int ett_lte_rrc_Tx_ResourcePoolMeasList_r14;
static int ett_lte_rrc_MeasObjectGERAN;
static int ett_lte_rrc_MeasObjectNR_r15;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxCellSFTD_OF_PhysCellIdNR_r15;
static int ett_lte_rrc_T_bandNR_r15;
static int ett_lte_rrc_T_rmtc_ConfigNR_r16;
static int ett_lte_rrc_RS_ConfigSSB_NR_r15;
static int ett_lte_rrc_T_ssb_ToMeasure_r15;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxCellMeas_OF_PhysCellIdNR_r15;
static int ett_lte_rrc_CellsToAddModListNR_r15;
static int ett_lte_rrc_CellsToAddModListNR_r16;
static int ett_lte_rrc_CellsToAddModNR_r15;
static int ett_lte_rrc_CellsToAddModNR_r16;
static int ett_lte_rrc_SSB_PositionQCL_CellsToAddModListNR_r16;
static int ett_lte_rrc_SSB_PositionQCL_CellsToAddNR_r16;
static int ett_lte_rrc_RMTC_ConfigNR_r16;
static int ett_lte_rrc_SSB_PositionQCL_CellsToAddModListNR_r17;
static int ett_lte_rrc_SSB_PositionQCL_CellsToAddNR_r17;
static int ett_lte_rrc_MeasObjectToAddModList;
static int ett_lte_rrc_MeasObjectToAddModListExt_r13;
static int ett_lte_rrc_MeasObjectToAddModList_v9e0;
static int ett_lte_rrc_MeasObjectToAddMod;
static int ett_lte_rrc_T_measObject;
static int ett_lte_rrc_MeasObjectToAddModExt_r13;
static int ett_lte_rrc_T_measObject_r13;
static int ett_lte_rrc_MeasObjectToAddMod_v9e0;
static int ett_lte_rrc_MeasObjectUTRA;
static int ett_lte_rrc_T_cellsToAddModList;
static int ett_lte_rrc_T_cellForWhichToReportCGI;
static int ett_lte_rrc_CellsToAddModListUTRA_FDD;
static int ett_lte_rrc_CellsToAddModUTRA_FDD;
static int ett_lte_rrc_CellsToAddModListUTRA_TDD;
static int ett_lte_rrc_CellsToAddModUTRA_TDD;
static int ett_lte_rrc_CSG_AllowedReportingCells_r9;
static int ett_lte_rrc_MeasObjectWLAN_r13;
static int ett_lte_rrc_T_carrierFreq_r13;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxWLAN_Bands_r13_OF_WLAN_BandIndicator_r13;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxWLAN_CarrierInfo_r13_OF_WLAN_CarrierInfo_r13;
static int ett_lte_rrc_MeasResults;
static int ett_lte_rrc_T_measResultPCell;
static int ett_lte_rrc_T_measResultNeighCells;
static int ett_lte_rrc_T_measResultPCell_v1310;
static int ett_lte_rrc_MeasResultListEUTRA;
static int ett_lte_rrc_MeasResultEUTRA;
static int ett_lte_rrc_T_cgi_Info;
static int ett_lte_rrc_T_measResult;
static int ett_lte_rrc_T_cgi_Info_v1310;
static int ett_lte_rrc_MeasResultListIdle_r15;
static int ett_lte_rrc_MeasResultIdle_r15;
static int ett_lte_rrc_T_measResultServingCell_r15;
static int ett_lte_rrc_T_measResultNeighCells_r15;
static int ett_lte_rrc_MeasResultIdleListEUTRA_r15;
static int ett_lte_rrc_MeasResultIdleEUTRA_r15;
static int ett_lte_rrc_T_measResult_r15;
static int ett_lte_rrc_MeasResultListExtIdle_r16;
static int ett_lte_rrc_MeasResultListIdleNR_r16;
static int ett_lte_rrc_MeasResultIdleNR_r16;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxCellMeasIdle_r15_OF_MeasResultsPerCellIdleNR_r16;
static int ett_lte_rrc_MeasResultsPerCellIdleNR_r16;
static int ett_lte_rrc_T_measIdleResultNR_r16;
static int ett_lte_rrc_ResultsPerSSB_IndexList_r16;
static int ett_lte_rrc_ResultsPerSSB_IndexIdle_r16;
static int ett_lte_rrc_T_ssb_Results_r16;
static int ett_lte_rrc_MeasResultServFreqListNR_r15;
static int ett_lte_rrc_MeasResultServFreqNR_r15;
static int ett_lte_rrc_MeasResultCellListNR_r15;
static int ett_lte_rrc_MeasResultCellNR_r15;
static int ett_lte_rrc_MeasResultNR_r15;
static int ett_lte_rrc_MeasResultSSB_IndexList_r15;
static int ett_lte_rrc_MeasResultSSB_Index_r15;
static int ett_lte_rrc_MeasResultServFreqList_r10;
static int ett_lte_rrc_MeasResultServFreqListExt_r13;
static int ett_lte_rrc_MeasResultServFreq_r10;
static int ett_lte_rrc_T_measResultSCell_r10;
static int ett_lte_rrc_T_measResultBestNeighCell_r10;
static int ett_lte_rrc_T_measResultSCell_v1310_01;
static int ett_lte_rrc_T_measResultBestNeighCell_v1310;
static int ett_lte_rrc_MeasResultServFreq_r13;
static int ett_lte_rrc_T_measResultSCell_r13;
static int ett_lte_rrc_T_measResultBestNeighCell_r13;
static int ett_lte_rrc_T_measResultBestNeighCell_v1360;
static int ett_lte_rrc_MeasResultCSI_RS_List_r12;
static int ett_lte_rrc_MeasResultCSI_RS_r12;
static int ett_lte_rrc_MeasResultListUTRA;
static int ett_lte_rrc_MeasResultUTRA;
static int ett_lte_rrc_T_physCellId;
static int ett_lte_rrc_T_cgi_Info_01;
static int ett_lte_rrc_T_measResult_01;
static int ett_lte_rrc_MeasResultListGERAN;
static int ett_lte_rrc_MeasResultGERAN;
static int ett_lte_rrc_T_cgi_Info_02;
static int ett_lte_rrc_T_measResult_02;
static int ett_lte_rrc_MeasResultsCDMA2000;
static int ett_lte_rrc_MeasResultListCDMA2000;
static int ett_lte_rrc_MeasResultCDMA2000;
static int ett_lte_rrc_T_measResult_03;
static int ett_lte_rrc_MeasResultListWLAN_r13;
static int ett_lte_rrc_MeasResultListWLAN_r14;
static int ett_lte_rrc_MeasResultWLAN_r13;
static int ett_lte_rrc_MeasResultListCBR_r14;
static int ett_lte_rrc_MeasResultCBR_r14;
static int ett_lte_rrc_MeasResultSensing_r15;
static int ett_lte_rrc_SEQUENCE_SIZE_0_400_OF_SensingResult_r15;
static int ett_lte_rrc_SensingResult_r15;
static int ett_lte_rrc_MeasResultForECID_r9;
static int ett_lte_rrc_PLMN_IdentityList2;
static int ett_lte_rrc_AdditionalSI_Info_r9;
static int ett_lte_rrc_MeasResultForRSSI_r13;
static int ett_lte_rrc_MeasResultForRSSI_NR_r16;
static int ett_lte_rrc_UL_PDCP_DelayResultList_r13;
static int ett_lte_rrc_UL_PDCP_DelayResult_r13;
static int ett_lte_rrc_UL_PDCP_DelayValueResultList_r16;
static int ett_lte_rrc_UL_PDCP_DelayValueResult_r16;
static int ett_lte_rrc_CGI_InfoNR_r15;
static int ett_lte_rrc_T_noSIB1_r15;
static int ett_lte_rrc_PLMN_IdentityListNR_r15;
static int ett_lte_rrc_PLMN_IdentityInfoListNR_r15;
static int ett_lte_rrc_PLMN_IdentityInfoListNR_v1710;
static int ett_lte_rrc_PLMN_IdentityInfoNR_r15;
static int ett_lte_rrc_PLMN_IdentityInfoNR_v1710;
static int ett_lte_rrc_MeasResultCellListSFTD_r15;
static int ett_lte_rrc_MeasResultCellSFTD_r15;
static int ett_lte_rrc_MeasResultSCG_FailureMRDC_r15;
static int ett_lte_rrc_MeasResultList3EUTRA_r15;
static int ett_lte_rrc_MeasResult3EUTRA_r15;
static int ett_lte_rrc_MeasResultSSTD_r13;
static int ett_lte_rrc_MeasSensing_Config_r15;
static int ett_lte_rrc_MTC_SSB_NR_r15;
static int ett_lte_rrc_T_periodicityAndOffset_r15;
static int ett_lte_rrc_MTC_SSB2_LP_NR_r16;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxNrofPCI_PerSMTC_r16_OF_PhysCellIdNR_r15;
static int ett_lte_rrc_QuantityConfig;
static int ett_lte_rrc_QuantityConfigEUTRA;
static int ett_lte_rrc_QuantityConfigEUTRA_v1250;
static int ett_lte_rrc_QuantityConfigEUTRA_v1310;
static int ett_lte_rrc_QuantityConfigUTRA;
static int ett_lte_rrc_QuantityConfigUTRA_v1020;
static int ett_lte_rrc_QuantityConfigGERAN;
static int ett_lte_rrc_QuantityConfigCDMA2000;
static int ett_lte_rrc_QuantityConfigNRList_r15;
static int ett_lte_rrc_QuantityConfigNR_r15;
static int ett_lte_rrc_QuantityConfigRS_NR_r15;
static int ett_lte_rrc_QuantityConfigWLAN_r13;
static int ett_lte_rrc_ReportConfigEUTRA;
static int ett_lte_rrc_T_triggerType;
static int ett_lte_rrc_T_event;
static int ett_lte_rrc_T_eventId;
static int ett_lte_rrc_T_eventA1;
static int ett_lte_rrc_T_eventA2;
static int ett_lte_rrc_T_eventA3;
static int ett_lte_rrc_T_eventA4;
static int ett_lte_rrc_T_eventA5;
static int ett_lte_rrc_T_eventA6_r10;
static int ett_lte_rrc_T_eventC1_r12;
static int ett_lte_rrc_T_eventC2_r12;
static int ett_lte_rrc_T_eventV1_r14;
static int ett_lte_rrc_T_eventV2_r14;
static int ett_lte_rrc_T_eventH1_r15;
static int ett_lte_rrc_T_eventH2_r15;
static int ett_lte_rrc_T_eventD1_r18;
static int ett_lte_rrc_T_eventD2_r18;
static int ett_lte_rrc_T_periodical;
static int ett_lte_rrc_T_alternativeTimeToTrigger_r12;
static int ett_lte_rrc_T_rs_sinr_Config_r13;
static int ett_lte_rrc_T_reportConfigEUTRA_eag_4_rs_sinr_Config_r13_setup;
static int ett_lte_rrc_CondReconfigurationTriggerEUTRA_r16;
static int ett_lte_rrc_T_condEventId_r16;
static int ett_lte_rrc_T_condEventA3_r16;
static int ett_lte_rrc_T_condEventA5_r16;
static int ett_lte_rrc_T_condEventA4_r18;
static int ett_lte_rrc_T_condEventD1_r18;
static int ett_lte_rrc_T_condEventD2_r18;
static int ett_lte_rrc_T_condEventT1_r18;
static int ett_lte_rrc_RSRQ_RangeConfig_r12;
static int ett_lte_rrc_ThresholdEUTRA;
static int ett_lte_rrc_MeasRSSI_ReportConfig_r13;
static int ett_lte_rrc_ReportConfigInterRAT;
static int ett_lte_rrc_T_triggerType_01;
static int ett_lte_rrc_T_event_01;
static int ett_lte_rrc_T_eventId_01;
static int ett_lte_rrc_T_eventB1;
static int ett_lte_rrc_T_b1_Threshold;
static int ett_lte_rrc_T_eventB2;
static int ett_lte_rrc_T_b2_Threshold2;
static int ett_lte_rrc_T_eventW1_r13;
static int ett_lte_rrc_T_eventW2_r13;
static int ett_lte_rrc_T_eventW3_r13;
static int ett_lte_rrc_T_eventB1_NR_r15;
static int ett_lte_rrc_T_eventB2_NR_r15;
static int ett_lte_rrc_T_periodical_01;
static int ett_lte_rrc_T_b2_Threshold1_v1250;
static int ett_lte_rrc_CondReconfigurationTriggerNR_r17;
static int ett_lte_rrc_T_condEventId_r17;
static int ett_lte_rrc_T_condEventB1_NR_r17;
static int ett_lte_rrc_ThresholdUTRA;
static int ett_lte_rrc_ReportQuantityNR_r15;
static int ett_lte_rrc_ReportQuantityWLAN_r13;
static int ett_lte_rrc_ReportConfigToAddModList;
static int ett_lte_rrc_ReportConfigToAddMod;
static int ett_lte_rrc_T_reportConfig;
static int ett_lte_rrc_RSRQ_Type_r12;
static int ett_lte_rrc_SS_RSSI_Measurement_r15;
static int ett_lte_rrc_SSB_ToMeasure_r15;
static int ett_lte_rrc_UL_DelayConfig_r13;
static int ett_lte_rrc_T_uL_DelayConfig_r13_setup;
static int ett_lte_rrc_UL_DelayValueConfig_r16;
static int ett_lte_rrc_T_uL_DelayValueConfig_r16_setup;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxDRB_OF_DRB_Identity;
static int ett_lte_rrc_WLAN_CarrierInfo_r13;
static int ett_lte_rrc_WLAN_ChannelList_r13;
static int ett_lte_rrc_WLAN_NameListConfig_r15;
static int ett_lte_rrc_WLAN_NameList_r15;
static int ett_lte_rrc_WLAN_RTT_r15;
static int ett_lte_rrc_WLAN_SuspendConfig_r14;
static int ett_lte_rrc_AreaConfiguration_r10;
static int ett_lte_rrc_AreaConfiguration_v1130;
static int ett_lte_rrc_CellGlobalIdList_r10;
static int ett_lte_rrc_TrackingAreaCodeList_r10;
static int ett_lte_rrc_TrackingAreaCodeList_v1130;
static int ett_lte_rrc_SEQUENCE_SIZE_1_8_OF_PLMN_Identity;
static int ett_lte_rrc_BandCombinationList_r14;
static int ett_lte_rrc_BandCombination_r14;
static int ett_lte_rrc_BandIndication_r14;
static int ett_lte_rrc_FlightPathInfoReportConfig_r15;
static int ett_lte_rrc_GNSS_ID_r15;
static int ett_lte_rrc_MeasSubframePattern_r10;
static int ett_lte_rrc_T_subframePatternTDD_r10;
static int ett_lte_rrc_OtherConfig_r9;
static int ett_lte_rrc_T_delayBudgetReportingConfig_r14;
static int ett_lte_rrc_T_otherConfig_r9_eag_2_delayBudgetReportingConfig_r14_setup;
static int ett_lte_rrc_T_rlm_ReportConfig_r14;
static int ett_lte_rrc_T_otherConfig_r9_eag_2_rlm_ReportConfig_r14_setup;
static int ett_lte_rrc_T_overheatingAssistanceConfig_r14;
static int ett_lte_rrc_T_otherConfig_r9_eag_3_overheatingAssistanceConfig_r14_setup;
static int ett_lte_rrc_T_measConfigAppLayer_r15;
static int ett_lte_rrc_T_otherConfig_r9_eag_4_measConfigAppLayer_r15_setup;
static int ett_lte_rrc_T_scg_DeactivationPreferenceConfig_r17;
static int ett_lte_rrc_IDC_Config_r11;
static int ett_lte_rrc_T_autonomousDenialParameters_r11;
static int ett_lte_rrc_T_idc_Indication_MRDC_r15;
static int ett_lte_rrc_ObtainLocationConfig_r11;
static int ett_lte_rrc_PowerPrefIndicationConfig_r11;
static int ett_lte_rrc_T_powerPrefIndicationConfig_r11_setup;
static int ett_lte_rrc_ReportProximityConfig_r9;
static int ett_lte_rrc_CandidateServingFreqListNR_r15;
static int ett_lte_rrc_SCG_DeactivationPreferenceConfig_r17;
static int ett_lte_rrc_SBAS_ID_r15;
static int ett_lte_rrc_S_NSSAI_r15;
static int ett_lte_rrc_S_TMSI;
static int ett_lte_rrc_TraceReference_r10;
static int ett_lte_rrc_UE_CapabilityRAT_ContainerList;
static int ett_lte_rrc_UE_CapabilityRAT_Container;
static int ett_lte_rrc_UE_EUTRA_Capability;
static int ett_lte_rrc_T_interRAT_Parameters;
static int ett_lte_rrc_UE_EUTRA_Capability_v9a0_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v9c0_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v9d0_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v9e0_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v9h0_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v10c0_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v10f0_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v10i0_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v10j0_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_81;
static int ett_lte_rrc_UE_EUTRA_Capability_v11d0_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v11x0_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v12b0_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v12x0_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1370_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1380_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1390_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v13e0a_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v13e0b_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_82;
static int ett_lte_rrc_UE_EUTRA_Capability_v1470_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v14a0_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v14b0_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v14x0_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v15x0_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v16c0_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_83;
static int ett_lte_rrc_UE_EUTRA_Capability_v920_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v940_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1020_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1060_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1090_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1130_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1170_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1180_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v11a0_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1250_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1260_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1270_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1280_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1310_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1320_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1330_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1340_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1350_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1360_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1430_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1440_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1450_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1460_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1510_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1520_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1530_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1540_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1550_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1560_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1570_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v15a0_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1610_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1630_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1650_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1660_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1690_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1700_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1710_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1720_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1730_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1770_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v1800_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_84;
static int ett_lte_rrc_UE_EUTRA_CapabilityAddXDD_Mode_r9;
static int ett_lte_rrc_UE_EUTRA_CapabilityAddXDD_Mode_v1060;
static int ett_lte_rrc_UE_EUTRA_CapabilityAddXDD_Mode_v1130;
static int ett_lte_rrc_UE_EUTRA_CapabilityAddXDD_Mode_v1180;
static int ett_lte_rrc_UE_EUTRA_CapabilityAddXDD_Mode_v1250;
static int ett_lte_rrc_UE_EUTRA_CapabilityAddXDD_Mode_v1310;
static int ett_lte_rrc_UE_EUTRA_CapabilityAddXDD_Mode_v1320;
static int ett_lte_rrc_UE_EUTRA_CapabilityAddXDD_Mode_v1370;
static int ett_lte_rrc_UE_EUTRA_CapabilityAddXDD_Mode_v1380;
static int ett_lte_rrc_UE_EUTRA_CapabilityAddXDD_Mode_v1430;
static int ett_lte_rrc_UE_EUTRA_CapabilityAddXDD_Mode_v1510;
static int ett_lte_rrc_UE_EUTRA_CapabilityAddXDD_Mode_v1530;
static int ett_lte_rrc_UE_EUTRA_CapabilityAddXDD_Mode_v1540;
static int ett_lte_rrc_UE_EUTRA_CapabilityAddXDD_Mode_v1550;
static int ett_lte_rrc_UE_EUTRA_CapabilityAddXDD_Mode_v1560;
static int ett_lte_rrc_UE_EUTRA_CapabilityAddXDD_Mode_v15a0;
static int ett_lte_rrc_UE_EUTRA_CapabilityAddXDD_Mode_v1610;
static int ett_lte_rrc_UE_EUTRA_CapabilityAddXDD_Mode_v1630;
static int ett_lte_rrc_FeatureSetsEUTRA_r15;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxFeatureSets_r15_OF_FeatureSetDL_r15;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxPerCC_FeatureSets_r15_OF_FeatureSetDL_PerCC_r15;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxFeatureSets_r15_OF_FeatureSetUL_r15;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxPerCC_FeatureSets_r15_OF_FeatureSetUL_PerCC_r15;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxFeatureSets_r15_OF_FeatureSetDL_v1550;
static int ett_lte_rrc_MobilityParameters_r14;
static int ett_lte_rrc_MobilityParameters_v1610;
static int ett_lte_rrc_DC_Parameters_r12;
static int ett_lte_rrc_DC_Parameters_v1310;
static int ett_lte_rrc_MAC_Parameters_r12;
static int ett_lte_rrc_MAC_Parameters_v1310;
static int ett_lte_rrc_MAC_Parameters_v1430;
static int ett_lte_rrc_MAC_Parameters_v1440;
static int ett_lte_rrc_MAC_Parameters_v1530;
static int ett_lte_rrc_SEQUENCE_SIZE_1_3_OF_ProcessingTimelineSet_r15;
static int ett_lte_rrc_MAC_Parameters_v1550;
static int ett_lte_rrc_MAC_Parameters_v1610;
static int ett_lte_rrc_MAC_Parameters_v1630;
static int ett_lte_rrc_NTN_Parameters_r17;
static int ett_lte_rrc_NTN_Parameters_v1720;
static int ett_lte_rrc_NTN_Parameters_v1800;
static int ett_lte_rrc_RLC_Parameters_r12;
static int ett_lte_rrc_RLC_Parameters_v1310;
static int ett_lte_rrc_RLC_Parameters_v1430;
static int ett_lte_rrc_RLC_Parameters_v1530;
static int ett_lte_rrc_PDCP_Parameters;
static int ett_lte_rrc_PDCP_Parameters_v1130;
static int ett_lte_rrc_PDCP_Parameters_v1310;
static int ett_lte_rrc_PDCP_Parameters_v1430;
static int ett_lte_rrc_T_supportedUplinkOnlyROHC_Profiles_r14;
static int ett_lte_rrc_PDCP_Parameters_v1530;
static int ett_lte_rrc_PDCP_Parameters_v1610;
static int ett_lte_rrc_SupportedUDC_r15;
static int ett_lte_rrc_SupportedOperatorDic_r15;
static int ett_lte_rrc_PhyLayerParameters;
static int ett_lte_rrc_PhyLayerParameters_v920;
static int ett_lte_rrc_PhyLayerParameters_v9d0;
static int ett_lte_rrc_PhyLayerParameters_v1020;
static int ett_lte_rrc_PhyLayerParameters_v1130;
static int ett_lte_rrc_PhyLayerParameters_v1170;
static int ett_lte_rrc_PhyLayerParameters_v1250;
static int ett_lte_rrc_PhyLayerParameters_v1280;
static int ett_lte_rrc_PhyLayerParameters_v1310;
static int ett_lte_rrc_T_supportedBlindDecoding_r13;
static int ett_lte_rrc_PhyLayerParameters_v1320;
static int ett_lte_rrc_PhyLayerParameters_v1330;
static int ett_lte_rrc_PhyLayerParameters_v13e0;
static int ett_lte_rrc_PhyLayerParameters_v1430;
static int ett_lte_rrc_PhyLayerParameters_v1450;
static int ett_lte_rrc_PhyLayerParameters_v1470;
static int ett_lte_rrc_PhyLayerParameters_v14a0;
static int ett_lte_rrc_PhyLayerParameters_v1530;
static int ett_lte_rrc_T_stti_SPT_Capabilities_r15;
static int ett_lte_rrc_T_ce_Capabilities_r15;
static int ett_lte_rrc_T_urllc_Capabilities_r15;
static int ett_lte_rrc_PhyLayerParameters_v1540;
static int ett_lte_rrc_T_stti_SPT_Capabilities_v1540;
static int ett_lte_rrc_PhyLayerParameters_v1550;
static int ett_lte_rrc_PhyLayerParameters_v1610;
static int ett_lte_rrc_T_ce_Capabilities_v1610;
static int ett_lte_rrc_T_addSRS_r16;
static int ett_lte_rrc_PhyLayerParameters_v1700;
static int ett_lte_rrc_T_ce_Capabilities_v1700;
static int ett_lte_rrc_PhyLayerParameters_v1730;
static int ett_lte_rrc_MIMO_UE_Parameters_r13;
static int ett_lte_rrc_MIMO_UE_Parameters_v13e0;
static int ett_lte_rrc_MIMO_UE_Parameters_v1430;
static int ett_lte_rrc_MIMO_UE_Parameters_v1470;
static int ett_lte_rrc_MIMO_UE_ParametersPerTM_r13;
static int ett_lte_rrc_MIMO_UE_ParametersPerTM_v1430;
static int ett_lte_rrc_T_nzp_CSI_RS_AperiodicInfo_r14;
static int ett_lte_rrc_T_nzp_CSI_RS_PeriodicInfo_r14;
static int ett_lte_rrc_MIMO_UE_ParametersPerTM_v1470;
static int ett_lte_rrc_MIMO_CA_ParametersPerBoBC_r13;
static int ett_lte_rrc_MIMO_CA_ParametersPerBoBC_r15;
static int ett_lte_rrc_MIMO_CA_ParametersPerBoBC_v1430;
static int ett_lte_rrc_MIMO_CA_ParametersPerBoBC_v1470;
static int ett_lte_rrc_MIMO_CA_ParametersPerBoBCPerTM_r13;
static int ett_lte_rrc_MIMO_CA_ParametersPerBoBCPerTM_v1430;
static int ett_lte_rrc_MIMO_CA_ParametersPerBoBCPerTM_v1470;
static int ett_lte_rrc_MIMO_CA_ParametersPerBoBCPerTM_r15;
static int ett_lte_rrc_MIMO_NonPrecodedCapabilities_r13;
static int ett_lte_rrc_MIMO_UE_BeamformedCapabilities_r13;
static int ett_lte_rrc_MIMO_BeamformedCapabilityList_r13;
static int ett_lte_rrc_MIMO_BeamformedCapabilities_r13;
static int ett_lte_rrc_MIMO_WeightedLayersCapabilities_r13;
static int ett_lte_rrc_NonContiguousUL_RA_WithinCC_List_r10;
static int ett_lte_rrc_NonContiguousUL_RA_WithinCC_r10;
static int ett_lte_rrc_RF_Parameters;
static int ett_lte_rrc_RF_Parameters_v9e0;
static int ett_lte_rrc_RF_Parameters_v1020;
static int ett_lte_rrc_RF_Parameters_v1060;
static int ett_lte_rrc_RF_Parameters_v1090;
static int ett_lte_rrc_RF_Parameters_v10f0;
static int ett_lte_rrc_RF_Parameters_v10i0;
static int ett_lte_rrc_RF_Parameters_v10j0;
static int ett_lte_rrc_RF_Parameters_v1130;
static int ett_lte_rrc_RF_Parameters_v1180;
static int ett_lte_rrc_RF_Parameters_v11d0;
static int ett_lte_rrc_RF_Parameters_v1250;
static int ett_lte_rrc_RF_Parameters_v1270;
static int ett_lte_rrc_RF_Parameters_v1310;
static int ett_lte_rrc_T_eNB_RequestedParameters_r13;
static int ett_lte_rrc_RF_Parameters_v1320;
static int ett_lte_rrc_RF_Parameters_v1380;
static int ett_lte_rrc_RF_Parameters_v1390;
static int ett_lte_rrc_RF_Parameters_v12b0;
static int ett_lte_rrc_RF_Parameters_v1430;
static int ett_lte_rrc_T_eNB_RequestedParameters_v1430;
static int ett_lte_rrc_RF_Parameters_v1450;
static int ett_lte_rrc_RF_Parameters_v1470;
static int ett_lte_rrc_RF_Parameters_v14b0;
static int ett_lte_rrc_RF_Parameters_v1530;
static int ett_lte_rrc_RF_Parameters_v1570;
static int ett_lte_rrc_RF_Parameters_v1610;
static int ett_lte_rrc_RF_Parameters_v1630;
static int ett_lte_rrc_RF_Parameters_v1800;
static int ett_lte_rrc_SkipSubframeProcessing_r15;
static int ett_lte_rrc_SPT_Parameters_r15;
static int ett_lte_rrc_STTI_SPT_BandParameters_r15;
static int ett_lte_rrc_STTI_SupportedCombinations_r15;
static int ett_lte_rrc_SEQUENCE_SIZE_1_2_OF_DL_UL_CCs_r15;
static int ett_lte_rrc_DL_UL_CCs_r15;
static int ett_lte_rrc_SupportedBandCombination_r10;
static int ett_lte_rrc_SupportedBandCombinationExt_r10;
static int ett_lte_rrc_SupportedBandCombination_v1090;
static int ett_lte_rrc_SupportedBandCombination_v10i0;
static int ett_lte_rrc_SupportedBandCombination_v1130;
static int ett_lte_rrc_SupportedBandCombination_v1250;
static int ett_lte_rrc_SupportedBandCombination_v1270;
static int ett_lte_rrc_SupportedBandCombination_v1320;
static int ett_lte_rrc_SupportedBandCombination_v1380;
static int ett_lte_rrc_SupportedBandCombination_v1390;
static int ett_lte_rrc_SupportedBandCombination_v1430;
static int ett_lte_rrc_SupportedBandCombination_v1450;
static int ett_lte_rrc_SupportedBandCombination_v1470;
static int ett_lte_rrc_SupportedBandCombination_v14b0;
static int ett_lte_rrc_SupportedBandCombination_v1530;
static int ett_lte_rrc_SupportedBandCombination_v1610;
static int ett_lte_rrc_SupportedBandCombination_v1630;
static int ett_lte_rrc_SupportedBandCombination_v1800;
static int ett_lte_rrc_SupportedBandCombinationAdd_r11;
static int ett_lte_rrc_SupportedBandCombinationAdd_v11d0;
static int ett_lte_rrc_SupportedBandCombinationAdd_v1250;
static int ett_lte_rrc_SupportedBandCombinationAdd_v1270;
static int ett_lte_rrc_SupportedBandCombinationAdd_v1320;
static int ett_lte_rrc_SupportedBandCombinationAdd_v1380;
static int ett_lte_rrc_SupportedBandCombinationAdd_v1390;
static int ett_lte_rrc_SupportedBandCombinationAdd_v1430;
static int ett_lte_rrc_SupportedBandCombinationAdd_v1450;
static int ett_lte_rrc_SupportedBandCombinationAdd_v1470;
static int ett_lte_rrc_SupportedBandCombinationAdd_v14b0;
static int ett_lte_rrc_SupportedBandCombinationAdd_v1530;
static int ett_lte_rrc_SupportedBandCombinationAdd_v1610;
static int ett_lte_rrc_SupportedBandCombinationAdd_v1630;
static int ett_lte_rrc_SupportedBandCombinationAdd_v1800;
static int ett_lte_rrc_SupportedBandCombinationReduced_r13;
static int ett_lte_rrc_SupportedBandCombinationReduced_v1320;
static int ett_lte_rrc_SupportedBandCombinationReduced_v1380;
static int ett_lte_rrc_SupportedBandCombinationReduced_v1390;
static int ett_lte_rrc_SupportedBandCombinationReduced_v1430;
static int ett_lte_rrc_SupportedBandCombinationReduced_v1450;
static int ett_lte_rrc_SupportedBandCombinationReduced_v1470;
static int ett_lte_rrc_SupportedBandCombinationReduced_v14b0;
static int ett_lte_rrc_SupportedBandCombinationReduced_v1530;
static int ett_lte_rrc_SupportedBandCombinationReduced_v1610;
static int ett_lte_rrc_SupportedBandCombinationReduced_v1630;
static int ett_lte_rrc_SupportedBandCombinationReduced_v1800;
static int ett_lte_rrc_BandCombinationParameters_r10;
static int ett_lte_rrc_BandCombinationParametersExt_r10;
static int ett_lte_rrc_BandCombinationParameters_v1090;
static int ett_lte_rrc_BandCombinationParameters_v10i0;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v10i0;
static int ett_lte_rrc_BandCombinationParameters_v1130;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v1130;
static int ett_lte_rrc_BandCombinationParameters_r11;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_r11;
static int ett_lte_rrc_BandCombinationParameters_v1250;
static int ett_lte_rrc_T_dc_Support_r12;
static int ett_lte_rrc_T_supportedCellGrouping_r12;
static int ett_lte_rrc_BandCombinationParameters_v1270;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v1270;
static int ett_lte_rrc_BandCombinationParameters_r13;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_r13;
static int ett_lte_rrc_T_dc_Support_r13;
static int ett_lte_rrc_T_supportedCellGrouping_r13;
static int ett_lte_rrc_BandCombinationParameters_v1320;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v1320;
static int ett_lte_rrc_BandCombinationParameters_v1380;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v1380;
static int ett_lte_rrc_BandCombinationParameters_v1390;
static int ett_lte_rrc_BandCombinationParameters_v1430;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v1430;
static int ett_lte_rrc_BandCombinationParameters_v1450;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v1450;
static int ett_lte_rrc_BandCombinationParameters_v1470;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v1470;
static int ett_lte_rrc_BandCombinationParameters_v14b0;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v14b0;
static int ett_lte_rrc_BandCombinationParameters_v1530;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v1530;
static int ett_lte_rrc_BandCombinationParameters_v1610;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_BandParameters_v1610;
static int ett_lte_rrc_T_interFreqDAPS_r16;
static int ett_lte_rrc_BandCombinationParameters_v1630;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxBandCombSidelinkNR_r16_OF_ScalingFactorSidelink_r16;
static int ett_lte_rrc_BandCombinationParameters_v1800;
static int ett_lte_rrc_BandParameters_r10;
static int ett_lte_rrc_BandParameters_v1090;
static int ett_lte_rrc_BandParameters_v10i0;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxBandwidthClass_r10_OF_CA_MIMO_ParametersDL_v10i0;
static int ett_lte_rrc_BandParameters_v1130;
static int ett_lte_rrc_BandParameters_r11;
static int ett_lte_rrc_BandParameters_v1270;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxBandwidthClass_r10_OF_CA_MIMO_ParametersDL_v1270;
static int ett_lte_rrc_BandParameters_r13;
static int ett_lte_rrc_BandParameters_v1320;
static int ett_lte_rrc_BandParameters_v1380;
static int ett_lte_rrc_BandParameters_v1430;
static int ett_lte_rrc_SEQUENCE_SIZE_2_maxServCell_r13_OF_UL_256QAM_perCC_Info_r14;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_SRS_CapabilityPerBandPair_r14;
static int ett_lte_rrc_BandParameters_v1450;
static int ett_lte_rrc_BandParameters_v1470;
static int ett_lte_rrc_BandParameters_v14b0;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_SRS_CapabilityPerBandPair_v14b0;
static int ett_lte_rrc_BandParameters_v1530;
static int ett_lte_rrc_BandParameters_v1610;
static int ett_lte_rrc_T_intraFreqDAPS_r16;
static int ett_lte_rrc_T_addSRS_AntennaSwitching_r16_01;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_SRS_CapabilityPerBandPair_v1610;
static int ett_lte_rrc_V2X_BandParameters_r14;
static int ett_lte_rrc_V2X_BandParameters_v1530;
static int ett_lte_rrc_BandParametersTxSL_r14;
static int ett_lte_rrc_BandParametersRxSL_r14;
static int ett_lte_rrc_V2X_BandwidthClassSL_r14;
static int ett_lte_rrc_UL_256QAM_perCC_Info_r14;
static int ett_lte_rrc_FeatureSetDL_r15;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxServCell_r13_OF_FeatureSetDL_PerCC_Id_r15;
static int ett_lte_rrc_FeatureSetDL_v1550;
static int ett_lte_rrc_FeatureSetDL_PerCC_r15;
static int ett_lte_rrc_FeatureSetUL_r15;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxServCell_r13_OF_FeatureSetUL_PerCC_Id_r15;
static int ett_lte_rrc_FeatureSetUL_PerCC_r15;
static int ett_lte_rrc_BandParametersUL_r10;
static int ett_lte_rrc_CA_MIMO_ParametersUL_r10;
static int ett_lte_rrc_CA_MIMO_ParametersUL_r15;
static int ett_lte_rrc_BandParametersDL_r10;
static int ett_lte_rrc_CA_MIMO_ParametersDL_r10;
static int ett_lte_rrc_CA_MIMO_ParametersDL_v10i0;
static int ett_lte_rrc_CA_MIMO_ParametersDL_v1270;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxServCell_r10_OF_IntraBandContiguousCC_Info_r12;
static int ett_lte_rrc_CA_MIMO_ParametersDL_r13;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxServCell_r13_OF_IntraBandContiguousCC_Info_r12;
static int ett_lte_rrc_CA_MIMO_ParametersDL_r15;
static int ett_lte_rrc_IntraBandContiguousCC_Info_r12;
static int ett_lte_rrc_MUST_Parameters_r14;
static int ett_lte_rrc_SupportedBandListEUTRA;
static int ett_lte_rrc_SupportedBandListEUTRA_v9e0;
static int ett_lte_rrc_SupportedBandListEUTRA_v1250;
static int ett_lte_rrc_SupportedBandListEUTRA_v1310;
static int ett_lte_rrc_SupportedBandListEUTRA_v1320;
static int ett_lte_rrc_SupportedBandListEUTRA_v1800;
static int ett_lte_rrc_SupportedBandEUTRA;
static int ett_lte_rrc_SupportedBandEUTRA_v9e0;
static int ett_lte_rrc_SupportedBandEUTRA_v1250;
static int ett_lte_rrc_SupportedBandEUTRA_v1310;
static int ett_lte_rrc_SupportedBandEUTRA_v1320;
static int ett_lte_rrc_SupportedBandEUTRA_v1800;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxLowerMSD_r18_OF_LowerMSD_MRDC_r18;
static int ett_lte_rrc_MeasParameters;
static int ett_lte_rrc_MeasParameters_v1020;
static int ett_lte_rrc_MeasParameters_v1130;
static int ett_lte_rrc_MeasParameters_v11a0;
static int ett_lte_rrc_MeasParameters_v1250;
static int ett_lte_rrc_MeasParameters_v1310;
static int ett_lte_rrc_MeasParameters_v1430;
static int ett_lte_rrc_MeasParameters_v1520;
static int ett_lte_rrc_MeasParameters_v1530;
static int ett_lte_rrc_MeasParameters_v1610;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxBands_OF_MeasGapInfoNR_r16;
static int ett_lte_rrc_MeasParameters_v1630;
static int ett_lte_rrc_MeasParameters_v16c0;
static int ett_lte_rrc_MeasParameters_v1700;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxBandsNR_r15_OF_SharedSpectrumMeasNR_r17;
static int ett_lte_rrc_MeasParameters_v1770;
static int ett_lte_rrc_MeasParameters_v1800;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxBands_OF_MeasGapInfoNR_r18;
static int ett_lte_rrc_SharedSpectrumMeasNR_r17;
static int ett_lte_rrc_MeasGapInfoNR_r16;
static int ett_lte_rrc_MeasGapInfoNR_r18;
static int ett_lte_rrc_BandListEUTRA;
static int ett_lte_rrc_BandCombinationListEUTRA_r10;
static int ett_lte_rrc_BandInfoEUTRA;
static int ett_lte_rrc_InterFreqBandList;
static int ett_lte_rrc_InterFreqBandInfo;
static int ett_lte_rrc_InterRAT_BandList;
static int ett_lte_rrc_InterRAT_BandListNR_r16;
static int ett_lte_rrc_InterRAT_BandListNR_r18;
static int ett_lte_rrc_InterRAT_BandInfo;
static int ett_lte_rrc_InterRAT_BandInfoNR_r16;
static int ett_lte_rrc_InterRAT_BandInfoNR_r18;
static int ett_lte_rrc_IRAT_ParametersNR_r15;
static int ett_lte_rrc_IRAT_ParametersNR_v1540;
static int ett_lte_rrc_IRAT_ParametersNR_v1560;
static int ett_lte_rrc_IRAT_ParametersNR_v1570;
static int ett_lte_rrc_IRAT_ParametersNR_v1610;
static int ett_lte_rrc_IRAT_ParametersNR_v1660;
static int ett_lte_rrc_IRAT_ParametersNR_v1700;
static int ett_lte_rrc_IRAT_ParametersNR_v1710;
static int ett_lte_rrc_LowerMSD_MRDC_r18;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxLowerMSD_Info_r18_OF_MSD_Information_r18;
static int ett_lte_rrc_MSD_Information_r18;
static int ett_lte_rrc_EUTRA_5GC_Parameters_r15;
static int ett_lte_rrc_EUTRA_5GC_Parameters_v1610;
static int ett_lte_rrc_PDCP_ParametersNR_r15;
static int ett_lte_rrc_T_rohc_ProfilesUL_Only_r15;
static int ett_lte_rrc_PDCP_ParametersNR_v1560;
static int ett_lte_rrc_ROHC_ProfileSupportList_r15;
static int ett_lte_rrc_SupportedBandListNR_r15;
static int ett_lte_rrc_SupportedBandNR_r15;
static int ett_lte_rrc_IRAT_ParametersUTRA_FDD;
static int ett_lte_rrc_IRAT_ParametersUTRA_v920;
static int ett_lte_rrc_IRAT_ParametersUTRA_v9c0;
static int ett_lte_rrc_IRAT_ParametersUTRA_v9h0;
static int ett_lte_rrc_SupportedBandListUTRA_FDD;
static int ett_lte_rrc_IRAT_ParametersUTRA_TDD128;
static int ett_lte_rrc_SupportedBandListUTRA_TDD128;
static int ett_lte_rrc_IRAT_ParametersUTRA_TDD384;
static int ett_lte_rrc_SupportedBandListUTRA_TDD384;
static int ett_lte_rrc_IRAT_ParametersUTRA_TDD768;
static int ett_lte_rrc_SupportedBandListUTRA_TDD768;
static int ett_lte_rrc_IRAT_ParametersUTRA_TDD_v1020;
static int ett_lte_rrc_IRAT_ParametersGERAN;
static int ett_lte_rrc_IRAT_ParametersGERAN_v920;
static int ett_lte_rrc_SupportedBandListGERAN;
static int ett_lte_rrc_IRAT_ParametersCDMA2000_HRPD;
static int ett_lte_rrc_SupportedBandListHRPD;
static int ett_lte_rrc_IRAT_ParametersCDMA2000_1XRTT;
static int ett_lte_rrc_IRAT_ParametersCDMA2000_1XRTT_v920;
static int ett_lte_rrc_IRAT_ParametersCDMA2000_1XRTT_v1020;
static int ett_lte_rrc_IRAT_ParametersCDMA2000_v1130;
static int ett_lte_rrc_SupportedBandList1XRTT;
static int ett_lte_rrc_IRAT_ParametersWLAN_r13;
static int ett_lte_rrc_SupportedBandListWLAN_r13;
static int ett_lte_rrc_CSG_ProximityIndicationParameters_r9;
static int ett_lte_rrc_NeighCellSI_AcquisitionParameters_r9;
static int ett_lte_rrc_NeighCellSI_AcquisitionParameters_v1530;
static int ett_lte_rrc_NeighCellSI_AcquisitionParameters_v1550;
static int ett_lte_rrc_NeighCellSI_AcquisitionParameters_v15a0;
static int ett_lte_rrc_NeighCellSI_AcquisitionParameters_v1610;
static int ett_lte_rrc_NeighCellSI_AcquisitionParameters_v1710;
static int ett_lte_rrc_SON_Parameters_r9;
static int ett_lte_rrc_SON_Parameters_v1800;
static int ett_lte_rrc_PUR_Parameters_r16;
static int ett_lte_rrc_UE_BasedNetwPerfMeasParameters_r10;
static int ett_lte_rrc_UE_BasedNetwPerfMeasParameters_v1250;
static int ett_lte_rrc_UE_BasedNetwPerfMeasParameters_v1430;
static int ett_lte_rrc_UE_BasedNetwPerfMeasParameters_v1530;
static int ett_lte_rrc_UE_BasedNetwPerfMeasParameters_v1610;
static int ett_lte_rrc_UE_BasedNetwPerfMeasParameters_v1700;
static int ett_lte_rrc_UE_BasedNetwPerfMeasParameters_v1800;
static int ett_lte_rrc_OTDOA_PositioningCapabilities_r10;
static int ett_lte_rrc_Other_Parameters_r11;
static int ett_lte_rrc_Other_Parameters_v11d0;
static int ett_lte_rrc_Other_Parameters_v1360;
static int ett_lte_rrc_Other_Parameters_v1430;
static int ett_lte_rrc_OtherParameters_v1450;
static int ett_lte_rrc_Other_Parameters_v1460;
static int ett_lte_rrc_Other_Parameters_v1530;
static int ett_lte_rrc_Other_Parameters_v1540;
static int ett_lte_rrc_Other_Parameters_v1610;
static int ett_lte_rrc_Other_Parameters_v1650;
static int ett_lte_rrc_Other_Parameters_v1690;
static int ett_lte_rrc_MBMS_Parameters_r11;
static int ett_lte_rrc_MBMS_Parameters_v1250;
static int ett_lte_rrc_MBMS_Parameters_v1430;
static int ett_lte_rrc_MBMS_Parameters_v1470;
static int ett_lte_rrc_T_mbms_MaxBW_r14;
static int ett_lte_rrc_MBMS_Parameters_v1610;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxBands_OF_MBMS_SupportedBandInfo_r16;
static int ett_lte_rrc_MBMS_Parameters_v1700;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxBands_OF_MBMS_SupportedBandInfo_v1700;
static int ett_lte_rrc_MBMS_SupportedBandInfo_r16;
static int ett_lte_rrc_T_subcarrierSpacingMBMS_khz0dot37_r16;
static int ett_lte_rrc_MBMS_SupportedBandInfo_v1700;
static int ett_lte_rrc_FeMBMS_Unicast_Parameters_r14;
static int ett_lte_rrc_SCPTM_Parameters_r13;
static int ett_lte_rrc_CE_Parameters_r13;
static int ett_lte_rrc_CE_Parameters_v1320;
static int ett_lte_rrc_CE_Parameters_v1350;
static int ett_lte_rrc_CE_Parameters_v1370;
static int ett_lte_rrc_CE_Parameters_v1380;
static int ett_lte_rrc_CE_Parameters_v1430;
static int ett_lte_rrc_CE_MultiTB_Parameters_r16;
static int ett_lte_rrc_CE_ResourceResvParameters_r16;
static int ett_lte_rrc_LAA_Parameters_r13;
static int ett_lte_rrc_LAA_Parameters_v1430;
static int ett_lte_rrc_LAA_Parameters_v1530;
static int ett_lte_rrc_WLAN_IW_Parameters_r12;
static int ett_lte_rrc_LWA_Parameters_r13;
static int ett_lte_rrc_LWA_Parameters_v1430;
static int ett_lte_rrc_LWA_Parameters_v1440;
static int ett_lte_rrc_WLAN_IW_Parameters_v1310;
static int ett_lte_rrc_LWIP_Parameters_r13;
static int ett_lte_rrc_LWIP_Parameters_v1430;
static int ett_lte_rrc_NAICS_Capability_List_r12;
static int ett_lte_rrc_NAICS_Capability_Entry_r12;
static int ett_lte_rrc_SL_Parameters_r12;
static int ett_lte_rrc_SL_Parameters_v1310;
static int ett_lte_rrc_SL_Parameters_v1430;
static int ett_lte_rrc_SL_Parameters_v1530;
static int ett_lte_rrc_SL_Parameters_v1540;
static int ett_lte_rrc_SL_Parameters_v1610;
static int ett_lte_rrc_SL_Parameters_v1630;
static int ett_lte_rrc_SL_Parameters_v1710;
static int ett_lte_rrc_SL_Parameters_v1800;
static int ett_lte_rrc_UE_CategorySL_r15;
static int ett_lte_rrc_V2X_SupportedBandCombination_r14;
static int ett_lte_rrc_V2X_SupportedBandCombination_v1530;
static int ett_lte_rrc_V2X_BandCombinationParameters_r14;
static int ett_lte_rrc_V2X_BandCombinationParameters_v1530;
static int ett_lte_rrc_V2X_SupportedBandCombinationEUTRA_NR_r16;
static int ett_lte_rrc_V2X_SupportedBandCombinationEUTRA_NR_v1630;
static int ett_lte_rrc_V2X_SupportedBandCombinationEUTRA_NR_v1710;
static int ett_lte_rrc_V2X_BandCombinationParametersEUTRA_NR_v1630;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_V2X_BandParametersEUTRA_NR_r16;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxSimultaneousBands_r10_OF_V2X_BandParametersEUTRA_NR_v1630;
static int ett_lte_rrc_V2X_BandCombinationParametersEUTRA_NR_v1710;
static int ett_lte_rrc_V2X_BandParametersEUTRA_NR_r16;
static int ett_lte_rrc_T_eutra;
static int ett_lte_rrc_T_nr;
static int ett_lte_rrc_V2X_BandParametersEUTRA_NR_v1630;
static int ett_lte_rrc_T_nr_01;
static int ett_lte_rrc_V2X_BandParametersEUTRA_NR_v1710;
static int ett_lte_rrc_SL_A2X_SupportedBandCombination_r18;
static int ett_lte_rrc_SL_A2X_BandCombinationParameters_r18;
static int ett_lte_rrc_SL_A2X_BandParameters_r18;
static int ett_lte_rrc_BandParametersTxA2X_r18;
static int ett_lte_rrc_BandParametersRxA2X_r18;
static int ett_lte_rrc_SupportedBandInfoList_r12;
static int ett_lte_rrc_SupportedBandInfo_r12;
static int ett_lte_rrc_FreqBandIndicatorListEUTRA_r12;
static int ett_lte_rrc_MMTEL_Parameters_r14;
static int ett_lte_rrc_MMTEL_Parameters_v1610;
static int ett_lte_rrc_SRS_CapabilityPerBandPair_r14;
static int ett_lte_rrc_T_retuningInfo;
static int ett_lte_rrc_SRS_CapabilityPerBandPair_v14b0;
static int ett_lte_rrc_SRS_CapabilityPerBandPair_v1610;
static int ett_lte_rrc_HighSpeedEnhParameters_r14;
static int ett_lte_rrc_HighSpeedEnhParameters_v1610;
static int ett_lte_rrc_UE_RadioPagingInfo_r12;
static int ett_lte_rrc_UE_TimersAndConstants;
static int ett_lte_rrc_VisitedCellInfoList_r12;
static int ett_lte_rrc_VisitedCellInfo_r12;
static int ett_lte_rrc_T_visitedCellId_r12;
static int ett_lte_rrc_T_pci_arfcn_r12;
static int ett_lte_rrc_WLAN_OffloadConfig_r12;
static int ett_lte_rrc_T_thresholdRSRP_r12;
static int ett_lte_rrc_T_thresholdRSRQ_r12;
static int ett_lte_rrc_T_thresholdRSRQ_OnAllSymbolsWithWB_r12;
static int ett_lte_rrc_T_thresholdRSRQ_OnAllSymbols_r12;
static int ett_lte_rrc_T_thresholdRSRQ_WB_r12;
static int ett_lte_rrc_T_thresholdChannelUtilization_r12;
static int ett_lte_rrc_T_thresholdBackhaul_Bandwidth_r12;
static int ett_lte_rrc_T_thresholdWLAN_RSSI_r12;
static int ett_lte_rrc_MBMS_NotificationConfig_r9;
static int ett_lte_rrc_MBMS_NotificationConfig_v1430;
static int ett_lte_rrc_MBMS_ServiceList_r13;
static int ett_lte_rrc_MBMS_ServiceInfo_r13;
static int ett_lte_rrc_MBSFN_AreaInfoList_r9;
static int ett_lte_rrc_MBSFN_AreaInfo_r9;
static int ett_lte_rrc_T_mcch_Config_r9;
static int ett_lte_rrc_T_mcch_Config_r14;
static int ett_lte_rrc_MBSFN_AreaInfoList_r16;
static int ett_lte_rrc_MBSFN_AreaInfo_r16;
static int ett_lte_rrc_T_mcch_Config_r16;
static int ett_lte_rrc_MBSFN_AreaInfoList_r17;
static int ett_lte_rrc_MBSFN_AreaInfo_r17;
static int ett_lte_rrc_MBSFN_SubframeConfig;
static int ett_lte_rrc_T_subframeAllocation;
static int ett_lte_rrc_MBSFN_SubframeConfig_v1430;
static int ett_lte_rrc_T_subframeAllocation_v1430;
static int ett_lte_rrc_MBSFN_SubframeConfig_v1610;
static int ett_lte_rrc_T_subframeAllocation_v1610;
static int ett_lte_rrc_PMCH_InfoList_r9;
static int ett_lte_rrc_PMCH_InfoListExt_r12;
static int ett_lte_rrc_PMCH_Info_r9;
static int ett_lte_rrc_PMCH_InfoExt_r12;
static int ett_lte_rrc_MBMS_SessionInfoList_r9;
static int ett_lte_rrc_MBMS_SessionInfo_r9;
static int ett_lte_rrc_PMCH_Config_r9;
static int ett_lte_rrc_PMCH_Config_r12;
static int ett_lte_rrc_T_dataMCS_r12;
static int ett_lte_rrc_TMGI_r9;
static int ett_lte_rrc_T_plmn_Id_r9;
static int ett_lte_rrc_SC_MTCH_InfoList_r13;
static int ett_lte_rrc_SC_MTCH_Info_r13;
static int ett_lte_rrc_MBMSSessionInfo_r13;
static int ett_lte_rrc_SC_MTCH_SchedulingInfo_r13;
static int ett_lte_rrc_T_schedulingPeriodStartOffsetSCPTM_r13;
static int ett_lte_rrc_SC_MTCH_InfoList_BR_r14;
static int ett_lte_rrc_SC_MTCH_Info_BR_r14;
static int ett_lte_rrc_T_mpdcch_StartSF_SC_MTCH_r14;
static int ett_lte_rrc_SC_MTCH_SchedulingInfo_BR_r14;
static int ett_lte_rrc_T_schedulingPeriodStartOffsetSCPTM_r14_01;
static int ett_lte_rrc_SCPTM_NeighbourCellList_r13;
static int ett_lte_rrc_PCI_ARFCN_r13;
static int ett_lte_rrc_SL_AnchorCarrierFreqList_V2X_r14;
static int ett_lte_rrc_SL_CBR_CommonTxConfigList_r14;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxSL_V2X_CBRConfig_r14_OF_SL_CBR_Levels_Config_r14;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxSL_V2X_TxConfig_r14_OF_SL_CBR_PSSCH_TxConfig_r14;
static int ett_lte_rrc_SL_CBR_Levels_Config_r14;
static int ett_lte_rrc_SL_CBR_PSSCH_TxConfig_r14;
static int ett_lte_rrc_SL_CBR_PPPP_TxConfigList_r14;
static int ett_lte_rrc_SL_PPPP_TxConfigIndex_r14;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxCBR_Level_r14_OF_Tx_ConfigIndex_r14;
static int ett_lte_rrc_SL_CBR_PPPP_TxConfigList_v1530;
static int ett_lte_rrc_SL_PPPP_TxConfigIndex_v1530;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxCBR_Level_r14_OF_MCS_PSSCH_Range_r15;
static int ett_lte_rrc_MCS_PSSCH_Range_r15;
static int ett_lte_rrc_SL_CBR_PPPP_TxConfigList_r15;
static int ett_lte_rrc_SL_PPPP_TxConfigIndex_r15;
static int ett_lte_rrc_SL_CommConfig_r12;
static int ett_lte_rrc_T_commTxResources_r12;
static int ett_lte_rrc_T_sL_CommConfig_r12_commTxResources_r12_setup;
static int ett_lte_rrc_T_scheduled_r12;
static int ett_lte_rrc_T_ue_Selected_r12;
static int ett_lte_rrc_T_commTxPoolNormalDedicated_r12;
static int ett_lte_rrc_T_commTxResources_v1310;
static int ett_lte_rrc_T_sL_CommConfig_r12_eag_1_commTxResources_v1310_setup;
static int ett_lte_rrc_T_scheduled_v1310;
static int ett_lte_rrc_T_ue_Selected_v1310;
static int ett_lte_rrc_T_commTxPoolNormalDedicatedExt_r13;
static int ett_lte_rrc_LogicalChGroupInfoList_r13;
static int ett_lte_rrc_SL_CommTxPoolToAddModList_r12;
static int ett_lte_rrc_SL_CommTxPoolToAddModListExt_r13;
static int ett_lte_rrc_SL_CommTxPoolToAddMod_r12;
static int ett_lte_rrc_SL_CommTxPoolToAddModExt_r13;
static int ett_lte_rrc_MAC_MainConfigSL_r12;
static int ett_lte_rrc_SL_CommTxPoolList_r12;
static int ett_lte_rrc_SL_CommTxPoolListExt_r13;
static int ett_lte_rrc_SL_CommTxPoolListV2X_r14;
static int ett_lte_rrc_SL_CommRxPoolList_r12;
static int ett_lte_rrc_SL_CommRxPoolListV2X_r14;
static int ett_lte_rrc_SL_CommResourcePool_r12;
static int ett_lte_rrc_T_ue_SelectedResourceConfig_r12;
static int ett_lte_rrc_T_rxParametersNCell_r12;
static int ett_lte_rrc_T_txParameters_r12;
static int ett_lte_rrc_SL_CommResourcePoolV2X_r14;
static int ett_lte_rrc_T_rxParametersNCell_r14;
static int ett_lte_rrc_SL_MinT2ValueList_r15;
static int ett_lte_rrc_SL_MinT2Value_r15;
static int ett_lte_rrc_SL_CommTxPoolSensingConfig_r14;
static int ett_lte_rrc_T_p2x_SensingConfig_r14;
static int ett_lte_rrc_SL_DiscConfig_r12;
static int ett_lte_rrc_T_discTxResources_r12;
static int ett_lte_rrc_T_sL_DiscConfig_r12_discTxResources_r12_setup;
static int ett_lte_rrc_T_scheduled_r12_01;
static int ett_lte_rrc_T_ue_Selected_r12_01;
static int ett_lte_rrc_T_discTxPoolDedicated_r12;
static int ett_lte_rrc_T_discTF_IndexList_v1260;
static int ett_lte_rrc_T_sL_DiscConfig_r12_eag_1_discTF_IndexList_v1260_setup;
static int ett_lte_rrc_T_discTxResourcesPS_r13;
static int ett_lte_rrc_T_sL_DiscConfig_r12_eag_2_discTxResourcesPS_r13_setup;
static int ett_lte_rrc_T_ue_Selected_r13;
static int ett_lte_rrc_T_discTxInterFreqInfo_r13;
static int ett_lte_rrc_T_sL_DiscConfig_r12_eag_2_discTxInterFreqInfo_r13_setup;
static int ett_lte_rrc_T_discRxGapConfig_r13;
static int ett_lte_rrc_T_discTxGapConfig_r13;
static int ett_lte_rrc_T_discSysInfoToReportConfig_r13;
static int ett_lte_rrc_SL_DiscSysInfoToReportFreqList_r13;
static int ett_lte_rrc_SL_DiscTxInfoInterFreqListAdd_r13;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxFreq_OF_SL_DiscTxResourceInfoPerFreq_r13;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxFreq_OF_ARFCN_ValueEUTRA_r9;
static int ett_lte_rrc_SL_DiscTxResourceInfoPerFreq_r13;
static int ett_lte_rrc_SL_DiscTxResource_r13;
static int ett_lte_rrc_T_sL_DiscTxResource_r13_setup;
static int ett_lte_rrc_SL_DiscTxPoolToAddModList_r12;
static int ett_lte_rrc_SL_DiscTxPoolToAddMod_r12;
static int ett_lte_rrc_SL_DiscTxConfigScheduled_r13;
static int ett_lte_rrc_SL_DiscTxPoolDedicated_r13;
static int ett_lte_rrc_SL_TF_IndexPairList_r12;
static int ett_lte_rrc_SL_TF_IndexPair_r12;
static int ett_lte_rrc_SL_TF_IndexPairList_r12b;
static int ett_lte_rrc_SL_TF_IndexPair_r12b;
static int ett_lte_rrc_SL_DiscTxRefCarrierDedicated_r13;
static int ett_lte_rrc_SL_DiscTxPoolList_r12;
static int ett_lte_rrc_SL_DiscRxPoolList_r12;
static int ett_lte_rrc_SL_DiscResourcePool_r12;
static int ett_lte_rrc_T_txParameters_r12_01;
static int ett_lte_rrc_T_ue_SelectedResourceConfig_r12_01;
static int ett_lte_rrc_T_poolSelection_r12;
static int ett_lte_rrc_T_rxParameters_r12;
static int ett_lte_rrc_T_discPeriod_v1310;
static int ett_lte_rrc_T_rxParamsAddNeighFreq_r13;
static int ett_lte_rrc_T_sL_DiscResourcePool_r12_eag_1_rxParamsAddNeighFreq_r13_setup;
static int ett_lte_rrc_T_txParamsAddNeighFreq_r13;
static int ett_lte_rrc_T_sL_DiscResourcePool_r12_eag_1_txParamsAddNeighFreq_r13_setup;
static int ett_lte_rrc_T_freqInfo_01;
static int ett_lte_rrc_T_txParamsAddNeighFreq_v1370;
static int ett_lte_rrc_T_sL_DiscResourcePool_r12_eag_2_txParamsAddNeighFreq_v1370_setup;
static int ett_lte_rrc_T_freqInfo_v1370;
static int ett_lte_rrc_PhysCellIdList_r13;
static int ett_lte_rrc_SL_PoolSelectionConfig_r12;
static int ett_lte_rrc_SL_DiscSysInfoReport_r13;
static int ett_lte_rrc_T_discCellSelectionInfo_r13;
static int ett_lte_rrc_T_cellReselectionInfo_r13;
static int ett_lte_rrc_T_freqInfo_r13;
static int ett_lte_rrc_T_freqInfo_v1370_01;
static int ett_lte_rrc_SL_DiscTxPowerInfoList_r12;
static int ett_lte_rrc_SL_DiscTxPowerInfo_r12;
static int ett_lte_rrc_SL_GapConfig_r13;
static int ett_lte_rrc_SL_GapPatternList_r13;
static int ett_lte_rrc_SL_GapPattern_r13;
static int ett_lte_rrc_SL_GapRequest_r13;
static int ett_lte_rrc_SL_GapFreqInfo_r13;
static int ett_lte_rrc_SL_HoppingConfigComm_r12;
static int ett_lte_rrc_SL_HoppingConfigDisc_r12;
static int ett_lte_rrc_SL_InterFreqInfoListV2X_r14;
static int ett_lte_rrc_SL_InterFreqInfoV2X_r14;
static int ett_lte_rrc_T_additionalSpectrumEmissionV2X_r14;
static int ett_lte_rrc_SL_NR_AnchorCarrierFreqList_r16;
static int ett_lte_rrc_SL_V2X_UE_ConfigList_r14;
static int ett_lte_rrc_SL_V2X_InterFreqUE_Config_r14;
static int ett_lte_rrc_SL_OffsetIndicator_r12;
static int ett_lte_rrc_SL_P2X_ResourceSelectionConfig_r14;
static int ett_lte_rrc_SL_PriorityList_r13;
static int ett_lte_rrc_SL_PSSCH_TxConfigList_r14;
static int ett_lte_rrc_SL_PSSCH_TxConfig_r14;
static int ett_lte_rrc_SL_PSSCH_TxParameters_r14;
static int ett_lte_rrc_SL_PSSCH_TxParameters_v1530;
static int ett_lte_rrc_SL_ReliabilityList_r15;
static int ett_lte_rrc_SL_RestrictResourceReservationPeriodList_r14;
static int ett_lte_rrc_SL_SyncAllowed_r14;
static int ett_lte_rrc_SL_SyncConfigList_r12;
static int ett_lte_rrc_SL_SyncConfigListV2X_r14;
static int ett_lte_rrc_SL_SyncConfig_r12;
static int ett_lte_rrc_T_txParameters_r12_02;
static int ett_lte_rrc_T_rxParamsNCell_r12;
static int ett_lte_rrc_SL_SyncConfigListNFreq_r13;
static int ett_lte_rrc_SL_SyncConfigListNFreqV2X_r14;
static int ett_lte_rrc_SL_SyncConfigNFreq_r13;
static int ett_lte_rrc_T_asyncParameters_r13;
static int ett_lte_rrc_T_txParameters_r13;
static int ett_lte_rrc_T_rxParameters_r13;
static int ett_lte_rrc_SL_TF_ResourceConfig_r12;
static int ett_lte_rrc_SubframeBitmapSL_r12;
static int ett_lte_rrc_SubframeBitmapSL_r14;
static int ett_lte_rrc_SL_TxPower_r14;
static int ett_lte_rrc_SL_ThresPSSCH_RSRP_List_r14;
static int ett_lte_rrc_SL_TxParameters_r12;
static int ett_lte_rrc_SL_TxPoolToReleaseList_r12;
static int ett_lte_rrc_SL_TxPoolToReleaseListExt_r13;
static int ett_lte_rrc_SL_V2X_ConfigDedicated_r14;
static int ett_lte_rrc_T_commTxResources_r14;
static int ett_lte_rrc_T_sL_V2X_ConfigDedicated_r14_commTxResources_r14_setup;
static int ett_lte_rrc_T_scheduled_r14;
static int ett_lte_rrc_T_ue_Selected_r14;
static int ett_lte_rrc_T_v2x_CommTxPoolNormalDedicated_r14;
static int ett_lte_rrc_T_commTxResources_v1530;
static int ett_lte_rrc_T_sL_V2X_ConfigDedicated_r14_eag_1_commTxResources_v1530_setup;
static int ett_lte_rrc_T_scheduled_v1530;
static int ett_lte_rrc_T_ue_Selected_v1530;
static int ett_lte_rrc_LogicalChGroupInfoList_v1530;
static int ett_lte_rrc_SL_TxPoolToAddModListV2X_r14;
static int ett_lte_rrc_SL_TxPoolToAddMod_r14;
static int ett_lte_rrc_SL_TxPoolToReleaseListV2X_r14;
static int ett_lte_rrc_SL_V2X_FreqSelectionConfigList_r15;
static int ett_lte_rrc_SL_V2X_FreqSelectionConfig_r15;
static int ett_lte_rrc_SL_V2X_PacketDuplicationConfig_r15;
static int ett_lte_rrc_SL_PPPR_Dest_CarrierFreqList_r15;
static int ett_lte_rrc_SL_PPPR_Dest_CarrierFreq;
static int ett_lte_rrc_SL_AllowedCarrierFreqList_r15;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxFreqV2X_r14_OF_ARFCN_ValueEUTRA_r9;
static int ett_lte_rrc_SL_V2X_SyncFreqList_r15;
static int ett_lte_rrc_SL_ZoneConfig_r14;
static int ett_lte_rrc_SBCCH_SL_BCH_Message;
static int ett_lte_rrc_SBCCH_SL_BCH_Message_V2X_r14;
static int ett_lte_rrc_MasterInformationBlock_SL;
static int ett_lte_rrc_MasterInformationBlock_SL_V2X_r14;
static int ett_lte_rrc_HandoverPreparationInformation_NB;
static int ett_lte_rrc_T_criticalExtensions_62;
static int ett_lte_rrc_T_c1_51;
static int ett_lte_rrc_T_criticalExtensionsFuture_60;
static int ett_lte_rrc_HandoverPreparationInformation_NB_IEs;
static int ett_lte_rrc_HandoverPreparationInformation_NB_v1380_IEs;
static int ett_lte_rrc_HandoverPreparationInformation_NB_Ext_r14_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_85;
static int ett_lte_rrc_UEPagingCoverageInformation_NB;
static int ett_lte_rrc_T_criticalExtensions_63;
static int ett_lte_rrc_T_c1_52;
static int ett_lte_rrc_T_criticalExtensionsFuture_61;
static int ett_lte_rrc_UEPagingCoverageInformation_NB_IEs;
static int ett_lte_rrc_UEPagingCoverageInformation_NB_v1700_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_86;
static int ett_lte_rrc_UERadioAccessCapabilityInformation_NB;
static int ett_lte_rrc_T_criticalExtensions_64;
static int ett_lte_rrc_T_c1_53;
static int ett_lte_rrc_T_criticalExtensionsFuture_62;
static int ett_lte_rrc_UERadioAccessCapabilityInformation_NB_IEs;
static int ett_lte_rrc_UERadioAccessCapabilityInformation_NB_v1380_IEs;
static int ett_lte_rrc_UERadioAccessCapabilityInformation_NB_r14_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_87;
static int ett_lte_rrc_UERadioPagingInformation_NB;
static int ett_lte_rrc_T_criticalExtensions_65;
static int ett_lte_rrc_T_c1_54;
static int ett_lte_rrc_T_criticalExtensionsFuture_63;
static int ett_lte_rrc_UERadioPagingInformation_NB_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_88;
static int ett_lte_rrc_AS_Config_NB;
static int ett_lte_rrc_AS_Context_NB;
static int ett_lte_rrc_ReestablishmentInfo_NB;
static int ett_lte_rrc_RRM_Config_NB;
static int ett_lte_rrc_BCCH_BCH_Message_NB;
static int ett_lte_rrc_BCCH_BCH_Message_TDD_NB;
static int ett_lte_rrc_BCCH_DL_SCH_Message_NB;
static int ett_lte_rrc_BCCH_DL_SCH_MessageType_NB;
static int ett_lte_rrc_T_c1_55;
static int ett_lte_rrc_T_messageClassExtension_10;
static int ett_lte_rrc_PCCH_Message_NB;
static int ett_lte_rrc_PCCH_MessageType_NB;
static int ett_lte_rrc_T_c1_56;
static int ett_lte_rrc_T_messageClassExtension_11;
static int ett_lte_rrc_DL_CCCH_Message_NB;
static int ett_lte_rrc_DL_CCCH_MessageType_NB;
static int ett_lte_rrc_T_c1_57;
static int ett_lte_rrc_T_messageClassExtension_12;
static int ett_lte_rrc_DL_DCCH_Message_NB;
static int ett_lte_rrc_DL_DCCH_MessageType_NB;
static int ett_lte_rrc_T_c1_58;
static int ett_lte_rrc_T_messageClassExtension_13;
static int ett_lte_rrc_UL_CCCH_Message_NB;
static int ett_lte_rrc_UL_CCCH_MessageType_NB;
static int ett_lte_rrc_T_c1_59;
static int ett_lte_rrc_T_messageClassExtension_14;
static int ett_lte_rrc_SC_MCCH_Message_NB;
static int ett_lte_rrc_SC_MCCH_MessageType_NB;
static int ett_lte_rrc_T_c1_60;
static int ett_lte_rrc_T_messageClassExtension_15;
static int ett_lte_rrc_UL_DCCH_Message_NB;
static int ett_lte_rrc_UL_DCCH_MessageType_NB;
static int ett_lte_rrc_T_c1_61;
static int ett_lte_rrc_T_messageClassExtension_16;
static int ett_lte_rrc_DLInformationTransfer_NB;
static int ett_lte_rrc_T_criticalExtensions_66;
static int ett_lte_rrc_T_c1_62;
static int ett_lte_rrc_T_criticalExtensionsFuture_64;
static int ett_lte_rrc_DLInformationTransfer_NB_r13_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_89;
static int ett_lte_rrc_MasterInformationBlock_NB;
static int ett_lte_rrc_T_operationModeInfo_r13;
static int ett_lte_rrc_T_partEARFCN_r17_01;
static int ett_lte_rrc_Guardband_NB_r13;
static int ett_lte_rrc_Inband_SamePCI_NB_r13;
static int ett_lte_rrc_Inband_DifferentPCI_NB_r13;
static int ett_lte_rrc_Standalone_NB_r13;
static int ett_lte_rrc_MasterInformationBlock_TDD_NB_r15;
static int ett_lte_rrc_T_operationModeInfo_r15;
static int ett_lte_rrc_GuardbandTDD_NB_r15;
static int ett_lte_rrc_T_sib_GuardbandInfo_r15;
static int ett_lte_rrc_Inband_SamePCI_TDD_NB_r15;
static int ett_lte_rrc_Inband_DifferentPCI_TDD_NB_r15;
static int ett_lte_rrc_StandaloneTDD_NB_r15;
static int ett_lte_rrc_SIB_GuardbandAnchorTDD_NB_r15;
static int ett_lte_rrc_SIB_GuardbandGuardbandTDD_NB_r15;
static int ett_lte_rrc_SIB_GuardbandInbandSamePCI_TDD_NB_r15;
static int ett_lte_rrc_SIB_GuardbandInbandDiffPCI_TDD_NB_r15;
static int ett_lte_rrc_Paging_NB;
static int ett_lte_rrc_Paging_NB_v1610_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_90;
static int ett_lte_rrc_PagingRecordList_NB_r13;
static int ett_lte_rrc_PagingRecordList_NB_v1610;
static int ett_lte_rrc_PagingRecord_NB_r13;
static int ett_lte_rrc_PagingRecord_NB_v1610;
static int ett_lte_rrc_PURConfigurationRequest_NB_r16;
static int ett_lte_rrc_T_criticalExtensions_67;
static int ett_lte_rrc_T_criticalExtensionsFuture_65;
static int ett_lte_rrc_PURConfigurationRequest_NB_r16_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_91;
static int ett_lte_rrc_PUR_ConfigRequest_NB_r16;
static int ett_lte_rrc_T_pur_SetupRequest_01;
static int ett_lte_rrc_RRCConnectionReconfiguration_NB;
static int ett_lte_rrc_T_criticalExtensions_68;
static int ett_lte_rrc_T_c1_63;
static int ett_lte_rrc_T_criticalExtensionsFuture_66;
static int ett_lte_rrc_RRCConnectionReconfiguration_NB_r13_IEs;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxDRB_NB_r13_OF_DedicatedInfoNAS;
static int ett_lte_rrc_RRCConnectionReconfiguration_NB_v16f0_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_92;
static int ett_lte_rrc_RRCConnectionReconfigurationComplete_NB;
static int ett_lte_rrc_T_criticalExtensions_69;
static int ett_lte_rrc_T_criticalExtensionsFuture_67;
static int ett_lte_rrc_RRCConnectionReconfigurationComplete_NB_r13_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_93;
static int ett_lte_rrc_RRCConnectionReestablishment_NB;
static int ett_lte_rrc_T_criticalExtensions_70;
static int ett_lte_rrc_T_c1_64;
static int ett_lte_rrc_T_criticalExtensionsFuture_68;
static int ett_lte_rrc_RRCConnectionReestablishment_NB_r13_IEs;
static int ett_lte_rrc_RRCConnectionReestablishment_NB_v1430_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_94;
static int ett_lte_rrc_RRCConnectionReestablishmentComplete_NB;
static int ett_lte_rrc_T_criticalExtensions_71;
static int ett_lte_rrc_T_criticalExtensionsFuture_69;
static int ett_lte_rrc_RRCConnectionReestablishmentComplete_NB_r13_IEs;
static int ett_lte_rrc_RRCConnectionReestablishmentComplete_NB_v1470_IEs;
static int ett_lte_rrc_RRCConnectionReestablishmentComplete_NB_v1610_IEs;
static int ett_lte_rrc_RRCConnectionReestablishmentComplete_NB_v1710_IEs;
static int ett_lte_rrc_RRCConnectionReestablishmentComplete_NB_v1800_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_95;
static int ett_lte_rrc_RRCConnectionReestablishmentRequest_NB;
static int ett_lte_rrc_T_criticalExtensions_72;
static int ett_lte_rrc_T_later_01;
static int ett_lte_rrc_T_later_02;
static int ett_lte_rrc_T_criticalExtensionsFuture_70;
static int ett_lte_rrc_RRCConnectionReestablishmentRequest_NB_r13_IEs;
static int ett_lte_rrc_RRCConnectionReestablishmentRequest_NB_r14_IEs;
static int ett_lte_rrc_RRCConnectionReestablishmentRequest_5GC_NB_r16_IEs;
static int ett_lte_rrc_ReestabUE_Identity_CP_NB_r14;
static int ett_lte_rrc_ReestabUE_Identity_CP_5GC_NB_r16;
static int ett_lte_rrc_RRCConnectionReject_NB;
static int ett_lte_rrc_T_criticalExtensions_73;
static int ett_lte_rrc_T_c1_65;
static int ett_lte_rrc_T_criticalExtensionsFuture_71;
static int ett_lte_rrc_RRCConnectionReject_NB_r13_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_96;
static int ett_lte_rrc_RRCConnectionRelease_NB;
static int ett_lte_rrc_T_criticalExtensions_74;
static int ett_lte_rrc_T_c1_66;
static int ett_lte_rrc_T_criticalExtensionsFuture_72;
static int ett_lte_rrc_RRCConnectionRelease_NB_r13_IEs;
static int ett_lte_rrc_RRCConnectionRelease_NB_v1430_IEs;
static int ett_lte_rrc_RRCConnectionRelease_NB_v1530_IEs;
static int ett_lte_rrc_RRCConnectionRelease_NB_v1550_IEs;
static int ett_lte_rrc_RRCConnectionRelease_NB_v15b0_IEs;
static int ett_lte_rrc_RRCConnectionRelease_NB_v1610_IEs;
static int ett_lte_rrc_T_pur_Config_r16_01;
static int ett_lte_rrc_RRCConnectionRelease_NB_v1700_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_97;
static int ett_lte_rrc_RedirectedCarrierInfo_NB_v1430;
static int ett_lte_rrc_RRCConnectionRequest_NB;
static int ett_lte_rrc_T_criticalExtensions_75;
static int ett_lte_rrc_T_later_03;
static int ett_lte_rrc_T_criticalExtensionsFuture_73;
static int ett_lte_rrc_RRCConnectionRequest_NB_r13_IEs;
static int ett_lte_rrc_RRCConnectionRequest_5GC_NB_r16_IEs;
static int ett_lte_rrc_InitialUE_Identity_5GC_NB_r16;
static int ett_lte_rrc_RRCConnectionResume_NB;
static int ett_lte_rrc_T_criticalExtensions_76;
static int ett_lte_rrc_T_c1_67;
static int ett_lte_rrc_T_criticalExtensionsFuture_74;
static int ett_lte_rrc_RRCConnectionResume_NB_r13_IEs;
static int ett_lte_rrc_RRCConnectionResume_NB_v1610_IEs;
static int ett_lte_rrc_RRCConnectionResume_NB_v16f0_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_98;
static int ett_lte_rrc_RRCConnectionResumeComplete_NB;
static int ett_lte_rrc_T_criticalExtensions_77;
static int ett_lte_rrc_T_criticalExtensionsFuture_75;
static int ett_lte_rrc_RRCConnectionResumeComplete_NB_r13_IEs;
static int ett_lte_rrc_RRCConnectionResumeComplete_NB_v1470_IEs;
static int ett_lte_rrc_RRCConnectionResumeComplete_NB_v1610_IEs;
static int ett_lte_rrc_RRCConnectionResumeComplete_NB_v1710_IEs;
static int ett_lte_rrc_RRCConnectionResumeComplete_NB_v1800_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_99;
static int ett_lte_rrc_RRCConnectionResumeRequest_NB;
static int ett_lte_rrc_T_criticalExtensions_78;
static int ett_lte_rrc_T_later_04;
static int ett_lte_rrc_T_criticalExtensionsFuture_76;
static int ett_lte_rrc_RRCConnectionResumeRequest_NB_r13_IEs;
static int ett_lte_rrc_RRCConnectionResumeRequest_5GC_NB_r16_IEs;
static int ett_lte_rrc_RRCConnectionSetup_NB;
static int ett_lte_rrc_T_criticalExtensions_79;
static int ett_lte_rrc_T_c1_68;
static int ett_lte_rrc_T_criticalExtensionsFuture_77;
static int ett_lte_rrc_RRCConnectionSetup_NB_r13_IEs;
static int ett_lte_rrc_RRCConnectionSetup_NB_v1610_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_100;
static int ett_lte_rrc_RRCConnectionSetupComplete_NB;
static int ett_lte_rrc_T_criticalExtensions_80;
static int ett_lte_rrc_T_criticalExtensionsFuture_78;
static int ett_lte_rrc_RRCConnectionSetupComplete_NB_r13_IEs;
static int ett_lte_rrc_RRCConnectionSetupComplete_NB_v1430_IEs;
static int ett_lte_rrc_RRCConnectionSetupComplete_NB_v1470_IEs;
static int ett_lte_rrc_RRCConnectionSetupComplete_NB_v1610_IEs;
static int ett_lte_rrc_RRCConnectionSetupComplete_NB_v1710_IEs;
static int ett_lte_rrc_RRCConnectionSetupComplete_NB_v1800_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_101;
static int ett_lte_rrc_RRCEarlyDataComplete_NB_r15;
static int ett_lte_rrc_T_criticalExtensions_81;
static int ett_lte_rrc_T_criticalExtensionsFuture_79;
static int ett_lte_rrc_RRCEarlyDataComplete_NB_r15_IEs;
static int ett_lte_rrc_RRCEarlyDataComplete_NB_v1590_IEs;
static int ett_lte_rrc_RRCEarlyDataComplete_NB_v1700_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_102;
static int ett_lte_rrc_RRCEarlyDataRequest_NB_r15;
static int ett_lte_rrc_T_criticalExtensions_82;
static int ett_lte_rrc_T_later_05;
static int ett_lte_rrc_T_criticalExtensionsFuture_80;
static int ett_lte_rrc_RRCEarlyDataRequest_NB_r15_IEs;
static int ett_lte_rrc_RRCEarlyDataRequest_NB_v1590_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_103;
static int ett_lte_rrc_RRCEarlyDataRequest_5GC_NB_r16_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_104;
static int ett_lte_rrc_SCPTMConfiguration_NB_r14;
static int ett_lte_rrc_SCPTMConfiguration_NB_v1610;
static int ett_lte_rrc_T_nonCriticalExtension_105;
static int ett_lte_rrc_SystemInformation_NB;
static int ett_lte_rrc_T_criticalExtensions_83;
static int ett_lte_rrc_T_criticalExtensionsFuture_81;
static int ett_lte_rrc_SystemInformation_NB_r13_IEs;
static int ett_lte_rrc_T_sib_TypeAndInfo_r13;
static int ett_lte_rrc_T_sib_TypeAndInfo_r13_item;
static int ett_lte_rrc_T_nonCriticalExtension_106;
static int ett_lte_rrc_SystemInformationBlockType1_NB;
static int ett_lte_rrc_T_cellAccessRelatedInfo_r13;
static int ett_lte_rrc_T_cellSelectionInfo_r13;
static int ett_lte_rrc_SystemInformationBlockType1_NB_v1350;
static int ett_lte_rrc_SystemInformationBlockType1_NB_v1430;
static int ett_lte_rrc_SystemInformationBlockType1_NB_v1450;
static int ett_lte_rrc_SystemInformationBlockType1_NB_v1530;
static int ett_lte_rrc_T_tdd_Parameters_r15;
static int ett_lte_rrc_SystemInformationBlockType1_NB_v1610;
static int ett_lte_rrc_T_cellAccessRelatedInfo_5GC_r16;
static int ett_lte_rrc_SystemInformationBlockType1_NB_v1700;
static int ett_lte_rrc_T_cellAccessRelatedInfo_NTN_r17_01;
static int ett_lte_rrc_T_nonCriticalExtension_107;
static int ett_lte_rrc_PLMN_IdentityList_NB_r13;
static int ett_lte_rrc_PLMN_IdentityList_5GC_NB_r16;
static int ett_lte_rrc_PLMN_IdentityList_NB_v1700;
static int ett_lte_rrc_PLMN_IdentityInfo_NB_r13;
static int ett_lte_rrc_PLMN_IdentityInfo_5GC_NB_r16;
static int ett_lte_rrc_T_plmn_Identity_5GC_r16;
static int ett_lte_rrc_PLMN_IdentityInfo_NB_v1700;
static int ett_lte_rrc_TrackingAreaList_NB_r17;
static int ett_lte_rrc_SchedulingInfoList_NB_r13;
static int ett_lte_rrc_SchedulingInfoList_NB_v1530;
static int ett_lte_rrc_SchedulingInfo_NB_r13;
static int ett_lte_rrc_SchedulingInfo_NB_v1530;
static int ett_lte_rrc_SystemInfoValueTagList_NB_r13;
static int ett_lte_rrc_SIB_MappingInfo_NB_r13;
static int ett_lte_rrc_SIB_MappingInfo_NB_v1530;
static int ett_lte_rrc_CellSelectionInfo_NB_v1350;
static int ett_lte_rrc_CellSelectionInfo_NB_v1430;
static int ett_lte_rrc_UECapabilityEnquiry_NB;
static int ett_lte_rrc_T_criticalExtensions_84;
static int ett_lte_rrc_T_c1_69;
static int ett_lte_rrc_T_criticalExtensionsFuture_82;
static int ett_lte_rrc_UECapabilityEnquiry_NB_r13_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_108;
static int ett_lte_rrc_UECapabilityInformation_NB;
static int ett_lte_rrc_T_criticalExtensions_85;
static int ett_lte_rrc_T_criticalExtensionsFuture_83;
static int ett_lte_rrc_UECapabilityInformation_NB_r13_IEs;
static int ett_lte_rrc_UECapabilityInformation_NB_Ext_r14_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_109;
static int ett_lte_rrc_UEInformationRequest_NB_r16;
static int ett_lte_rrc_T_criticalExtensions_86;
static int ett_lte_rrc_T_criticalExtensionsFuture_84;
static int ett_lte_rrc_UEInformationRequest_NB_r16_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_110;
static int ett_lte_rrc_UEInformationResponse_NB_r16;
static int ett_lte_rrc_T_criticalExtensions_87;
static int ett_lte_rrc_T_criticalExtensionsFuture_85;
static int ett_lte_rrc_UEInformationResponse_NB_r16_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_111;
static int ett_lte_rrc_RACH_Report_NB_r16;
static int ett_lte_rrc_RLF_Report_NB_r16;
static int ett_lte_rrc_T_measResultLastServCell_r16;
static int ett_lte_rrc_ULInformationTransfer_NB;
static int ett_lte_rrc_T_criticalExtensions_88;
static int ett_lte_rrc_T_criticalExtensionsFuture_86;
static int ett_lte_rrc_ULInformationTransfer_NB_r13_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_112;
static int ett_lte_rrc_SystemInformationBlockType2_NB_r13;
static int ett_lte_rrc_T_freqInfo_r13_01;
static int ett_lte_rrc_AdditionalSpectrumEmission_r13;
static int ett_lte_rrc_T_freqInfo_v1530;
static int ett_lte_rrc_SystemInformationBlockType3_NB_r13;
static int ett_lte_rrc_T_cellReselectionInfoCommon_r13;
static int ett_lte_rrc_T_cellReselectionServingFreqInfo_r13;
static int ett_lte_rrc_T_intraFreqCellReselectionInfo_r13;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxMultiBands_OF_NS_PmaxList_NB_r13;
static int ett_lte_rrc_IntraFreqCellReselectionInfo_NB_v1350;
static int ett_lte_rrc_IntraFreqCellReselectionInfo_NB_v1360;
static int ett_lte_rrc_IntraFreqCellReselectionInfo_NB_v1430;
static int ett_lte_rrc_CellReselectionInfoCommon_NB_v1450;
static int ett_lte_rrc_ConnMeasConfig_NB_r17;
static int ett_lte_rrc_T_neighCellMeasCriteria_r17;
static int ett_lte_rrc_SystemInformationBlockType4_NB_r13;
static int ett_lte_rrc_IntraFreqNeighCellList_NB_v1530;
static int ett_lte_rrc_IntraFreqNeighCellInfo_NB_v1530;
static int ett_lte_rrc_SystemInformationBlockType5_NB_r13;
static int ett_lte_rrc_InterFreqCarrierFreqList_NB_r13;
static int ett_lte_rrc_InterFreqCarrierFreqList_NB_v1820;
static int ett_lte_rrc_InterFreqCarrierFreqInfo_NB_r13;
static int ett_lte_rrc_InterFreqCarrierFreqInfo_NB_v1820;
static int ett_lte_rrc_InterFreqNeighCellList_NB_r13;
static int ett_lte_rrc_InterFreqNeighCellList_NB_v1530;
static int ett_lte_rrc_InterFreqNeighCellInfo_NB_v1530;
static int ett_lte_rrc_InterFreqExcludedCellList_NB_r13;
static int ett_lte_rrc_SystemInformationBlockType14_NB_r13;
static int ett_lte_rrc_T_ab_Param_r13;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxPLMN_r11_OF_AB_ConfigPLMN_NB_r13;
static int ett_lte_rrc_AB_ConfigPLMN_NB_r13;
static int ett_lte_rrc_AB_Config_NB_r13;
static int ett_lte_rrc_UAC_Param_NB_r16;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxPLMN_r11_OF_UAC_Barring_NB_r16;
static int ett_lte_rrc_UAC_Barring_NB_r16;
static int ett_lte_rrc_UAC_BarringPerCatList_NB_r16;
static int ett_lte_rrc_UAC_BarringPerCat_NB_r16;
static int ett_lte_rrc_SystemInformationBlockType15_NB_r14;
static int ett_lte_rrc_MBMS_SAI_InterFreqList_NB_r14;
static int ett_lte_rrc_MBMS_SAI_InterFreq_NB_r14;
static int ett_lte_rrc_SystemInformationBlockType20_NB_r14;
static int ett_lte_rrc_T_sc_mcch_CarrierConfig_r14;
static int ett_lte_rrc_NPDCCH_SC_MCCH_Config_NB_r14;
static int ett_lte_rrc_SC_MCCH_SchedulingInfo_NB_r14;
static int ett_lte_rrc_T_schedulingPeriodStartOffsetSCPTM_r14_02;
static int ett_lte_rrc_SystemInformationBlockType22_NB_r14;
static int ett_lte_rrc_T_mixedOperationModeConfig_r15;
static int ett_lte_rrc_DL_ConfigCommonList_NB_r14;
static int ett_lte_rrc_UL_ConfigCommonList_NB_r14;
static int ett_lte_rrc_UL_ConfigCommonListTDD_NB_r15;
static int ett_lte_rrc_CoverageBasedPagingConfig_NB_r17;
static int ett_lte_rrc_SEQUENCE_SIZE_1_2_OF_CBP_Config_NB_r17;
static int ett_lte_rrc_CBP_Config_NB_r17;
static int ett_lte_rrc_DL_ConfigCommon_NB_r14;
static int ett_lte_rrc_PCCH_Config_NB_r14;
static int ett_lte_rrc_PCCH_Config_NB_r17;
static int ett_lte_rrc_UL_ConfigCommon_NB_r14;
static int ett_lte_rrc_UL_ConfigCommonTDD_NB_r15;
static int ett_lte_rrc_NPRACH_ProbabilityAnchorList_NB_r14;
static int ett_lte_rrc_NPRACH_ProbabilityAnchor_NB_r14;
static int ett_lte_rrc_SystemInformationBlockType23_NB_r15;
static int ett_lte_rrc_UL_ConfigCommonList_NB_v1530;
static int ett_lte_rrc_UL_ConfigCommon_NB_v1530;
static int ett_lte_rrc_SystemInformationBlockType27_NB_r16;
static int ett_lte_rrc_CarrierFreqListEUTRA_NB_r16;
static int ett_lte_rrc_CarrierFreqsListGERAN_NB_r16;
static int ett_lte_rrc_CarrierFreqEUTRA_NB_r16;
static int ett_lte_rrc_CarrierFreqsGERAN_NB_r16;
static int ett_lte_rrc_SystemInformationBlockType31_NB_r17;
static int ett_lte_rrc_SystemInformationBlockType32_NB_r17;
static int ett_lte_rrc_SystemInformationBlockType33_NB_r18;
static int ett_lte_rrc_CarrierConfigDedicated_NB_r13;
static int ett_lte_rrc_DL_CarrierConfigDedicated_NB_r13;
static int ett_lte_rrc_T_downlinkBitmapNonAnchor_r13;
static int ett_lte_rrc_T_dl_GapNonAnchor_r13;
static int ett_lte_rrc_T_inbandCarrierInfo_r13;
static int ett_lte_rrc_T_samePCI_Indicator_r13;
static int ett_lte_rrc_T_samePCI_r13;
static int ett_lte_rrc_T_differentPCI_r13;
static int ett_lte_rrc_UL_CarrierConfigDedicated_NB_r13;
static int ett_lte_rrc_CarrierFreq_NB_r13;
static int ett_lte_rrc_CarrierFreq_NB_v1550;
static int ett_lte_rrc_DL_Bitmap_NB_r13;
static int ett_lte_rrc_DL_CarrierConfigCommon_NB_r14;
static int ett_lte_rrc_T_downlinkBitmapNonAnchor_r14;
static int ett_lte_rrc_T_dl_GapNonAnchor_r14;
static int ett_lte_rrc_T_inbandCarrierInfo_r14;
static int ett_lte_rrc_T_samePCI_Indicator_r14;
static int ett_lte_rrc_T_samePCI_r14;
static int ett_lte_rrc_T_differentPCI_r14;
static int ett_lte_rrc_DL_GapConfig_NB_r13;
static int ett_lte_rrc_DL_GapConfig_NB_v1530;
static int ett_lte_rrc_GWUS_Config_NB_r16;
static int ett_lte_rrc_GWUS_ResourceConfig_NB_r16;
static int ett_lte_rrc_GWUS_ProbThreshList_NB_r16;
static int ett_lte_rrc_GWUS_NumGroupsList_NB_r16;
static int ett_lte_rrc_GWUS_GroupsForServiceList_NB_r16;
static int ett_lte_rrc_LogicalChannelConfig_NB_r13;
static int ett_lte_rrc_MAC_MainConfig_NB_r13;
static int ett_lte_rrc_T_ul_SCH_Config_r13;
static int ett_lte_rrc_T_logicalChannelSR_Config_r13;
static int ett_lte_rrc_T_mAC_MainConfig_NB_r13_logicalChannelSR_Config_r13_setup;
static int ett_lte_rrc_T_dataInactivityTimerConfig_r14_01;
static int ett_lte_rrc_T_mAC_MainConfig_NB_r13_eag_1_dataInactivityTimerConfig_r14_setup;
static int ett_lte_rrc_T_offsetThresholdTA_r17_01;
static int ett_lte_rrc_DRX_Config_NB_r13;
static int ett_lte_rrc_T_dRX_Config_NB_r13_setup;
static int ett_lte_rrc_NPDCCH_ConfigDedicated_NB_r13;
static int ett_lte_rrc_NPDCCH_ConfigDedicated_NB_v1530;
static int ett_lte_rrc_NPDSCH_ConfigCommon_NB_r13;
static int ett_lte_rrc_NPDSCH_ConfigDedicated_NB_r16;
static int ett_lte_rrc_NPDSCH_MultiTB_Config_NB_r16;
static int ett_lte_rrc_NPDSCH_ConfigDedicated_NB_v1710;
static int ett_lte_rrc_T_npdsch_16QAM_Config_r17;
static int ett_lte_rrc_NPDSCH_ConfigDedicated_NB_v1800;
static int ett_lte_rrc_T_downlinkHARQ_FeedbackDisabledBitmap_NB_r18;
static int ett_lte_rrc_NPDSCH_16QAM_Config_NB_r17;
static int ett_lte_rrc_NPRACH_ConfigSIB_NB_r13;
static int ett_lte_rrc_NPRACH_ConfigSIB_NB_v1330;
static int ett_lte_rrc_NPRACH_ConfigSIB_NB_v1450;
static int ett_lte_rrc_NPRACH_ConfigSIB_NB_v1530;
static int ett_lte_rrc_T_tdd_Parameters_r15_01;
static int ett_lte_rrc_T_fmt2_Parameters_r15;
static int ett_lte_rrc_T_edt_Parameters_r15_01;
static int ett_lte_rrc_NPRACH_ConfigSIB_NB_v1550;
static int ett_lte_rrc_T_tdd_Parameters_v1550;
static int ett_lte_rrc_NPRACH_ParametersList_NB_r13;
static int ett_lte_rrc_NPRACH_ParametersList_NB_v1330;
static int ett_lte_rrc_NPRACH_Parameters_NB_r13;
static int ett_lte_rrc_NPRACH_Parameters_NB_v1330;
static int ett_lte_rrc_NPRACH_ParametersList_NB_r14;
static int ett_lte_rrc_NPRACH_Parameters_NB_r14;
static int ett_lte_rrc_T_nprach_Parameters_r14;
static int ett_lte_rrc_NPRACH_ParametersListTDD_NB_r15;
static int ett_lte_rrc_NPRACH_ParametersTDD_NB_r15;
static int ett_lte_rrc_T_nprach_Parameters_r15;
static int ett_lte_rrc_NPRACH_ParametersListTDD_NB_v1550;
static int ett_lte_rrc_NPRACH_ParametersTDD_NB_v1550;
static int ett_lte_rrc_NPRACH_ParametersListFmt2_NB_r15;
static int ett_lte_rrc_NPRACH_ParametersFmt2_NB_r15;
static int ett_lte_rrc_T_nprach_Parameters_r15_01;
static int ett_lte_rrc_NPRACH_TxDurationFmt01_NB_r17;
static int ett_lte_rrc_NPRACH_TxDurationFmt2_NB_r17;
static int ett_lte_rrc_RSRP_ThresholdsNPRACH_InfoList_NB_r13;
static int ett_lte_rrc_EDT_TBS_InfoList_NB_r15;
static int ett_lte_rrc_EDT_TBS_NB_r15;
static int ett_lte_rrc_NPUSCH_ConfigCommon_NB_r13;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxNPRACH_Resources_NB_r13_OF_ACK_NACK_NumRepetitions_NB_r13;
static int ett_lte_rrc_T_dmrs_Config_r13;
static int ett_lte_rrc_UL_ReferenceSignalsNPUSCH_NB_r13;
static int ett_lte_rrc_NPUSCH_ConfigDedicated_NB_r13;
static int ett_lte_rrc_NPUSCH_ConfigDedicated_NB_v1610;
static int ett_lte_rrc_NPUSCH_ConfigDedicated_NB_v1700;
static int ett_lte_rrc_NPUSCH_ConfigDedicated_NB_v1800;
static int ett_lte_rrc_T_uplinkHARQ_Mode_r18_01;
static int ett_lte_rrc_NPUSCH_TxDuration_NB_r17;
static int ett_lte_rrc_PDCP_Config_NB_r13;
static int ett_lte_rrc_T_headerCompression_r13;
static int ett_lte_rrc_T_rohc_01;
static int ett_lte_rrc_T_profiles_r13;
static int ett_lte_rrc_PhysicalConfigDedicated_NB_r13;
static int ett_lte_rrc_T_resourceReservationConfigDL_r16;
static int ett_lte_rrc_T_resourceReservationConfigUL_r16;
static int ett_lte_rrc_T_ntn_ConfigDedicated_r17_01;
static int ett_lte_rrc_T_npusch_TxDuration_r17_01;
static int ett_lte_rrc_PUR_Config_NB_r16;
static int ett_lte_rrc_T_pur_NRSRP_ChangeThreshold_r16;
static int ett_lte_rrc_T_pur_StartTimeParameters_r16_01;
static int ett_lte_rrc_T_pur_PhysicalConfig_r16;
static int ett_lte_rrc_T_npusch_SubCarrierSetIndex_r16;
static int ett_lte_rrc_T_npusch_MCS_r16;
static int ett_lte_rrc_T_pur_PhysicalConfig_v1650;
static int ett_lte_rrc_T_pur_PhysicalConfig_v1700;
static int ett_lte_rrc_T_pur_UL_16QAM_Config_r17;
static int ett_lte_rrc_T_pur_DL_16QAM_Config_r17;
static int ett_lte_rrc_PUR_NRSRP_ChangeThreshold_NB_r16;
static int ett_lte_rrc_PUR_UL_16QAM_Config_NB_r17;
static int ett_lte_rrc_PUR_PeriodicityAndOffset_NB_r16;
static int ett_lte_rrc_RACH_ConfigCommon_NB_r13;
static int ett_lte_rrc_RACH_InfoList_NB_r13;
static int ett_lte_rrc_RACH_InfoList_NB_v1530;
static int ett_lte_rrc_RACH_Info_NB_r13;
static int ett_lte_rrc_RACH_Info_NB_v1530;
static int ett_lte_rrc_PowerRampingParameters_NB_v1450;
static int ett_lte_rrc_T_powerRampingParametersCE1_r14;
static int ett_lte_rrc_RadioResourceConfigCommonSIB_NB_r13;
static int ett_lte_rrc_T_ntn_ConfigCommon_r17_02;
static int ett_lte_rrc_BCCH_Config_NB_r13;
static int ett_lte_rrc_PCCH_Config_NB_r13;
static int ett_lte_rrc_RadioResourceConfigDedicated_NB_r13;
static int ett_lte_rrc_T_mac_MainConfig_r13;
static int ett_lte_rrc_SRB_ToAddModList_NB_r13;
static int ett_lte_rrc_SRB_ToAddMod_NB_r13;
static int ett_lte_rrc_T_rlc_Config_r13;
static int ett_lte_rrc_T_logicalChannelConfig_r13;
static int ett_lte_rrc_DRB_ToAddModList_NB_r13;
static int ett_lte_rrc_DRB_ToAddMod_NB_r13;
static int ett_lte_rrc_DRB_ToReleaseList_NB_r13;
static int ett_lte_rrc_ResourceReservationConfig_NB_r16;
static int ett_lte_rrc_T_resourceReservation_r16;
static int ett_lte_rrc_T_subframeBitmap_r16;
static int ett_lte_rrc_T_slotConfig_r16;
static int ett_lte_rrc_T_slotBitmap_r16_02;
static int ett_lte_rrc_T_symbolBitmap_r16;
static int ett_lte_rrc_T_symbolBitmapFddDl;
static int ett_lte_rrc_T_symbolBitmapFddUlOrTdd;
static int ett_lte_rrc_RLC_Config_NB_r13;
static int ett_lte_rrc_T_am_01;
static int ett_lte_rrc_RLC_Config_NB_v1430;
static int ett_lte_rrc_RLC_Config_NB_v1700;
static int ett_lte_rrc_T_t_ReorderingExt_r17_01;
static int ett_lte_rrc_UL_AM_RLC_NB_r13;
static int ett_lte_rrc_DL_AM_RLC_NB_r13;
static int ett_lte_rrc_RLF_TimersAndConstants_NB_r13;
static int ett_lte_rrc_T_rLF_TimersAndConstants_NB_r13_setup;
static int ett_lte_rrc_SchedulingRequestConfig_NB_r15;
static int ett_lte_rrc_SR_WithoutHARQ_ACK_Config_NB_r15;
static int ett_lte_rrc_T_sR_WithoutHARQ_ACK_Config_NB_r15_setup;
static int ett_lte_rrc_SR_WithoutHARQ_ACK_Config_NB_v1700;
static int ett_lte_rrc_T_sr_ProhibitTimerOffset_r17_01;
static int ett_lte_rrc_SR_NPRACH_Resource_NB_r15;
static int ett_lte_rrc_T_nprach_SubCarrierIndex_r15;
static int ett_lte_rrc_SR_SPS_BSR_Config_NB_r15;
static int ett_lte_rrc_T_sR_SPS_BSR_Config_NB_r15_setup;
static int ett_lte_rrc_TDD_Config_NB_r15;
static int ett_lte_rrc_UplinkPowerControlCommon_NB_r13;
static int ett_lte_rrc_UplinkPowerControlDedicated_NB_r13;
static int ett_lte_rrc_UplinkPowerControlDedicated_NB_v1700;
static int ett_lte_rrc_WUS_Config_NB_r15;
static int ett_lte_rrc_WUS_ConfigPerCarrier_NB_r15;
static int ett_lte_rrc_AdditionalBandInfoList_NB_r14;
static int ett_lte_rrc_MultiBandInfoList_NB_r13;
static int ett_lte_rrc_MultiBandInfo_NB_r13;
static int ett_lte_rrc_NS_PmaxList_NB_r13;
static int ett_lte_rrc_NS_PmaxValue_NB_r13;
static int ett_lte_rrc_ANR_MeasConfig_NB_r16;
static int ett_lte_rrc_ANR_CarrierList_NB_r16;
static int ett_lte_rrc_ANR_Carrier_NB_r16;
static int ett_lte_rrc_ANR_ExcludedCellList_NB_r16;
static int ett_lte_rrc_ANR_MeasReport_NB_r16;
static int ett_lte_rrc_SEQUENCE_SIZE_1_maxFreqANR_NB_r16_OF_ANR_MeasResult_NB_r16;
static int ett_lte_rrc_ANR_MeasResult_NB_r16;
static int ett_lte_rrc_T_cgi_Info_r16;
static int ett_lte_rrc_MeasResultServCell_NB_r14;
static int ett_lte_rrc_NSSS_RRM_Config_NB_r15;
static int ett_lte_rrc_UE_Capability_NB_r13;
static int ett_lte_rrc_T_uE_Capability_NB_r13_dummy;
static int ett_lte_rrc_UE_Capability_NB_Ext_r14_IEs;
static int ett_lte_rrc_UE_Capability_NB_v1440_IEs;
static int ett_lte_rrc_UE_Capability_NB_v14x0_IEs;
static int ett_lte_rrc_UE_Capability_NB_v1530_IEs;
static int ett_lte_rrc_UE_Capability_NB_v15x0_IEs;
static int ett_lte_rrc_UE_Capability_NB_v1610_IEs;
static int ett_lte_rrc_UE_Capability_NB_v16x0_IEs;
static int ett_lte_rrc_UE_EUTRA_Capability_v16f0_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_113;
static int ett_lte_rrc_UE_Capability_NB_v1700_IEs;
static int ett_lte_rrc_UE_Capability_NB_v1710_IEs;
static int ett_lte_rrc_UE_Capability_NB_v1720_IEs;
static int ett_lte_rrc_UE_Capability_NB_v1800_IEs;
static int ett_lte_rrc_T_nonCriticalExtension_114;
static int ett_lte_rrc_TDD_UE_Capability_NB_r15;
static int ett_lte_rrc_TDD_UE_Capability_NB_v1610;
static int ett_lte_rrc_TDD_UE_Capability_NB_v1710;
static int ett_lte_rrc_PDCP_Parameters_NB_r13;
static int ett_lte_rrc_T_supportedROHC_Profiles_r13;
static int ett_lte_rrc_RLC_Parameters_NB_r15;
static int ett_lte_rrc_MAC_Parameters_NB_r14;
static int ett_lte_rrc_MAC_Parameters_NB_v1530;
static int ett_lte_rrc_MAC_Parameters_NB_v1610;
static int ett_lte_rrc_NTN_Parameters_NB_r17;
static int ett_lte_rrc_NTN_Parameters_NB_v1720;
static int ett_lte_rrc_NTN_Parameters_NB_v1800;
static int ett_lte_rrc_MeasParameters_NB_r16;
static int ett_lte_rrc_MeasParameters_NB_v1710;
static int ett_lte_rrc_PhyLayerParameters_NB_r13;
static int ett_lte_rrc_PhyLayerParameters_NB_v1430;
static int ett_lte_rrc_PhyLayerParameters_NB_v1440;
static int ett_lte_rrc_PhyLayerParameters_NB_v1530;
static int ett_lte_rrc_PhyLayerParameters_NB_v1610;
static int ett_lte_rrc_PUR_Parameters_NB_r16;
static int ett_lte_rrc_PhyLayerParameters_NB_v1700;
static int ett_lte_rrc_RF_Parameters_NB_r13;
static int ett_lte_rrc_RF_Parameters_NB_v1430;
static int ett_lte_rrc_RF_Parameters_NB_v1710;
static int ett_lte_rrc_SupportedBandList_NB_r13;
static int ett_lte_rrc_SupportedBandList_NB_v1710;
static int ett_lte_rrc_SupportedBand_NB_r13;
static int ett_lte_rrc_SupportedBand_NB_v1710;
static int ett_lte_rrc_SON_Parameters_NB_r16;
static int ett_lte_rrc_SON_Parameters_NB_v16f0;
static int ett_lte_rrc_UE_RadioPagingInfo_NB_r13;
static int ett_lte_rrc_UE_TimersAndConstants_NB_r13;
static int ett_lte_rrc_SC_MTCH_InfoList_NB_r14;
static int ett_lte_rrc_SC_MTCH_Info_NB_r14;
static int ett_lte_rrc_T_sc_mtch_CarrierConfig_r14;
static int ett_lte_rrc_SC_MTCH_SchedulingInfo_NB_r14;
static int ett_lte_rrc_T_schedulingPeriodStartOffsetSCPTM_r14_03;
static int ett_lte_rrc_SCPTM_NeighbourCellList_NB_r14;
static int ett_lte_rrc_PCI_ARFCN_NB_r14;

static int ett_lte_rrc_featureGroupIndicators;
static int ett_lte_rrc_featureGroupIndRel9Add;
static int ett_lte_rrc_featureGroupIndRel10;
static int ett_lte_rrc_absTimeInfo;
static int ett_lte_rrc_nas_SecurityParam;
static int ett_lte_rrc_targetRAT_MessageContainer;
static int ett_lte_rrc_siPsiSibContainer;
static int ett_lte_rrc_dedicatedInfoNAS;
static int ett_lte_rrc_timeInfo;
static int ett_lte_rrc_serialNumber;
static int ett_lte_rrc_warningType;
static int ett_lte_rrc_dataCodingScheme;
static int ett_lte_rrc_warningMessageSegment;
static int ett_lte_rrc_interBandTDD_CA_WithDifferentConfig;
static int ett_lte_rrc_tdd_FDD_CA_PCellDuplex_r12;
static int ett_lte_rrc_aperiodicCSI_Reporting_r13;
static int ett_lte_rrc_codebook_HARQ_ACK_r13;
static int ett_lte_rrc_sr_ConfigIndex;
static int ett_lte_rrc_transmissionModeList_r12;
static int ett_lte_rrc_modifiedMPR_Behavior_r10;
static int ett_lte_rrc_sib11_fragment;
static int ett_lte_rrc_sib11_fragments;
static int ett_lte_rrc_sib12_fragment;
static int ett_lte_rrc_sib12_fragments;
static int ett_lte_rrc_dcch_segment_fragment;
static int ett_lte_rrc_dcch_segment_fragments;
static int ett_lte_rrc_nr_SecondaryCellGroupConfig_r15;
static int ett_lte_rrc_nr_RadioBearerConfig_r15;
static int ett_lte_rrc_nr_RadioBearerConfigS_r15;
static int ett_lte_rrc_sl_ConfigDedicatedForNR_r16;
static int ett_lte_rrc_nr_SecondaryCellGroupConfig;
static int ett_lte_rrc_scg_ConfigResponseNR_r15;
static int ett_lte_rrc_scg_ConfigResponseNR_r16;
static int ett_lte_rrc_measResultSCG_r15;
static int ett_lte_rrc_measResultSCG_r16;
static int ett_lte_rrc_ul_DCCH_MessageNR_r15;
static int ett_lte_rrc_ul_DCCH_MessageNR_r16;
static int ett_lte_rrc_sourceRB_ConfigNR_r15;
static int ett_lte_rrc_sourceRB_ConfigSN_NR_r15;
static int ett_lte_rrc_sourceOtherConfigSN_NR_r15;
static int ett_lte_rrc_sourceContextEN_DC_r15;
static int ett_lte_rrc_requestedFreqBandsNR_MRDC_r15;
static int ett_lte_rrc_measGapPatterns_r15;
static int ett_lte_rrc_nas_Container_r15;
static int ett_lte_rrc_sourceRB_ConfigIntra5GC_r15;
static int ett_lte_rrc_selectedbandCombinationInfoEN_DC_v1540;
static int ett_lte_rrc_requestedCapabilityCommon_r15;
static int ett_lte_rrc_sidelinkUEInformationNR_r16;
static int ett_lte_rrc_ueAssistanceInformationNR_r16;
static int ett_lte_rrc_sl_ParameterNR_r16;
static int ett_lte_rrc_v2x_BandParametersNR_r16;
static int ett_lte_rrc_ueAssistanceInformationNR_SCG_r16;
static int ett_lte_rrc_assistanceDataSIB_Element_r15;
static int ett_lte_rrc_overheatingAssistanceForSCG_r16;
static int ett_lte_rrc_overheatingAssistanceForSCG_FR2_2_r17;
static int ett_lte_rrc_triggerConditionSN_r17;

static expert_field ei_lte_rrc_number_pages_le15;
static expert_field ei_lte_rrc_si_info_value_changed;
static expert_field ei_lte_rrc_sibs_changing;
static expert_field ei_lte_rrc_sibs_changing_edrx;
static expert_field ei_lte_rrc_earthquake_warning_sys;
static expert_field ei_lte_rrc_commercial_mobile_alert_sys;
static expert_field ei_lte_rrc_unexpected_type_value;
static expert_field ei_lte_rrc_unexpected_length_value;
static expert_field ei_lte_rrc_too_many_group_a_rapids;
static expert_field ei_lte_rrc_invalid_drx_config;

static const unit_name_string units_sr_periods = { " SR period", " SR periods" };
static const unit_name_string units_short_drx_cycles = { " shortDRX-Cycle", " shortDRX-Cycles" };

static reassembly_table lte_rrc_sib11_reassembly_table;
static reassembly_table lte_rrc_sib12_reassembly_table;
static reassembly_table lte_rrc_dcch_segment_reassembly_table;

static const fragment_items lte_rrc_sib11_frag_items = {
    &ett_lte_rrc_sib11_fragment,
    &ett_lte_rrc_sib11_fragments,
    &hf_lte_rrc_sib11_fragments,
    &hf_lte_rrc_sib11_fragment,
    &hf_lte_rrc_sib11_fragment_overlap,
    &hf_lte_rrc_sib11_fragment_overlap_conflict,
    &hf_lte_rrc_sib11_fragment_multiple_tails,
    &hf_lte_rrc_sib11_fragment_too_long_fragment,
    &hf_lte_rrc_sib11_fragment_error,
    &hf_lte_rrc_sib11_fragment_count,
    &hf_lte_rrc_sib11_reassembled_in,
    &hf_lte_rrc_sib11_reassembled_length,
    &hf_lte_rrc_sib11_reassembled_data,
    "SIB11 warning message segments"
};

static const fragment_items lte_rrc_sib12_frag_items = {
    &ett_lte_rrc_sib12_fragment,
    &ett_lte_rrc_sib12_fragments,
    &hf_lte_rrc_sib12_fragments,
    &hf_lte_rrc_sib12_fragment,
    &hf_lte_rrc_sib12_fragment_overlap,
    &hf_lte_rrc_sib12_fragment_overlap_conflict,
    &hf_lte_rrc_sib12_fragment_multiple_tails,
    &hf_lte_rrc_sib12_fragment_too_long_fragment,
    &hf_lte_rrc_sib12_fragment_error,
    &hf_lte_rrc_sib12_fragment_count,
    &hf_lte_rrc_sib12_reassembled_in,
    &hf_lte_rrc_sib12_reassembled_length,
    &hf_lte_rrc_sib12_reassembled_data,
    "SIB12 warning message segments"
};

static const fragment_items lte_rrc_dcch_segment_frag_items = {
    &ett_lte_rrc_dcch_segment_fragment,
    &ett_lte_rrc_dcch_segment_fragments,
    &hf_lte_rrc_dcch_segment_fragments,
    &hf_lte_rrc_dcch_segment_fragment,
    &hf_lte_rrc_dcch_segment_fragment_overlap,
    &hf_lte_rrc_dcch_segment_fragment_overlap_conflict,
    &hf_lte_rrc_dcch_segment_fragment_multiple_tails,
    &hf_lte_rrc_dcch_segment_fragment_too_long_fragment,
    &hf_lte_rrc_dcch_segment_fragment_error,
    &hf_lte_rrc_dcch_segment_fragment_count,
    &hf_lte_rrc_dcch_segment_reassembled_in,
    &hf_lte_rrc_dcch_segment_reassembled_length,
    &hf_lte_rrc_dcch_segment_reassembled_data,
    "DCCH message segments"
};

/* Forward declarations */
static int dissect_UECapabilityInformation_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_RRCConnectionReconfiguration_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);

static const true_false_string lte_rrc_eutra_cap_feat_group_ind_1_val = {
  "Intra-subframe freq hopping for PUSCH scheduled by UL grant; DCI format 3a; Aperiodic CQI/PMI/RI report on PUSCH: Mode 2-0 & 2-2 - Supported",
  "Intra-subframe freq hopping for PUSCH scheduled by UL grant; DCI format 3a; Aperiodic CQI/PMI/RI report on PUSCH: Mode 2-0 & 2-2 - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_2_val = {
  "Simultaneous CQI & ACK/NACK on PUCCH (format 2a/2b); Absolute TPC command for PUSCH; Resource alloc type 1 for PDSCH; Periodic CQI/PMI/RI report on PUCCH: Mode 2-0 & 2-1 - Supported",
  "Simultaneous CQI & ACK/NACK on PUCCH (format 2a/2b); Absolute TPC command for PUSCH; Resource alloc type 1 for PDSCH; Periodic CQI/PMI/RI report on PUCCH: Mode 2-0 & 2-1 - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_3_val = {
  "5bit RLC UM SN; 7bit PDCP SN - Supported",
  "5bit RLC UM SN; 7bit PDCP SN - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_4_val = {
  "Short DRX cycle - Supported",
  "Short DRX cycle - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_5_val = {
  "Long DRX cycle; DRX command MAC control element - Supported",
  "Long DRX cycle; DRX command MAC control element - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_6_val = {
  "Prioritised bit rate - Supported",
  "Prioritised bit rate - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_7_val = {
  "RLC UM - Supported",
  "RLC UM - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_8_val = {
  "EUTRA RRC_CONNECTED to UTRA CELL_DCH PS handover - Supported",
  "EUTRA RRC_CONNECTED to UTRA CELL_DCH PS handover - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_9_val = {
  "EUTRA RRC_CONNECTED to GERAN GSM_Dedicated handover - Supported",
  "EUTRA RRC_CONNECTED to GERAN GSM_Dedicated handover - Not Supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_10_val = {
  "EUTRA RRC_CONNECTED to GERAN (Packet_) Idle by Cell Change Order; EUTRA RRC_CONNECTED to GERAN (Packet_) Idle by Cell Change Order with NACC - Supported",
  "EUTRA RRC_CONNECTED to GERAN (Packet_) Idle by Cell Change Order; EUTRA RRC_CONNECTED to GERAN (Packet_) Idle by Cell Change Order with NACC - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_11_val = {
  "EUTRA RRC_CONNECTED to CDMA2000 1xRTT CS Active handover - Supported",
  "EUTRA RRC_CONNECTED to CDMA2000 1xRTT CS Active handover - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_12_val = {
  "EUTRA RRC_CONNECTED to CDMA2000 HRPD Active handover - Supported",
  "EUTRA RRC_CONNECTED to CDMA2000 HRPD Active handover - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_13_val = {
  "Inter-frequency handover (within FDD or TDD) - Supported",
  "Inter-frequency handover (within FDD or TDD) - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_14_val = {
  "Measurement reporting event: Event A4 - Neighbour > threshold; Measurement reporting event: Event A5 - Serving < threshold1 & Neighbour > threshold2 - Supported",
  "Measurement reporting event: Event A4 - Neighbour > threshold; Measurement reporting event: Event A5 - Serving < threshold1 & Neighbour > threshold2 - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_15_val = {
  "Measurement reporting event: Event B1 - Neighbour > threshold - Supported",
  "Measurement reporting event: Event B1 - Neighbour > threshold - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_16_val = {
  "non-ANR related periodical measurement reporting - Supported",
  "non-ANR related periodical measurement reporting - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_17_val = {
  "ANR related intra-frequency measurement reporting events - Supported",
  "ANR related intra-frequency measurement reporting events - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_18_val = {
  "ANR related inter-frequency measurement reporting events - Supported",
  "ANR related inter-frequency measurement reporting events - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_19_val = {
  "ANR related inter-RAT measurement reporting events - Supported",
  "ANR related inter-RAT measurement reporting events - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_20_val = {
  "SRB1 and SRB2 for DCCH + 8x AM DRB; SRB1 and SRB2 for DCCH + 5x AM DRB + 3x UM DRB (if indicator 7 is supported) - Supported",
  "SRB1 and SRB2 for DCCH + 8x AM DRB; SRB1 and SRB2 for DCCH + 5x AM DRB + 3x UM DRB (if indicator 7 is supported) - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_21_val = {
  "Predefined intra- and inter-subframe frequency hopping for PUSCH with N_sb > 1; Predefined inter-subframe frequency hopping for PUSCH with N_sb > 1 - Supported",
  "Predefined intra- and inter-subframe frequency hopping for PUSCH with N_sb > 1; Predefined inter-subframe frequency hopping for PUSCH with N_sb > 1 - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_22_val = {
  "UTRAN measurements, reporting and measurement reporting event B2 in E-UTRA connected mode - Supported",
  "UTRAN measurements, reporting and measurement reporting event B2 in E-UTRA connected mode - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_23_val = {
  "GERAN measurements, reporting and measurement reporting event B2 in E-UTRA connected mode - Supported",
  "GERAN measurements, reporting and measurement reporting event B2 in E-UTRA connected mode - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_24_val = {
  "1xRTT measurements, reporting and measurement reporting event B2 in E-UTRA connected mode - Supported",
  "1xRTT measurements, reporting and measurement reporting event B2 in E-UTRA connected mode - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_25_val = {
  "Inter-frequency measurements and reporting in E-UTRA connected mode - Supported",
  "Inter-frequency measurements and reporting in E-UTRA connected mode - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_26_val = {
  "HRPD measurements, reporting and measurement reporting event B2 in E-UTRA connected mode - Supported",
  "HRPD measurements, reporting and measurement reporting event B2 in E-UTRA connected mode - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_27_val = {
  "EUTRA RRC_CONNECTED to UTRA CELL_DCH CS handover - Supported",
  "EUTRA RRC_CONNECTED to UTRA CELL_DCH CS handover - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_28_val = {
  "TTI bundling - Supported",
  "TTI bundling - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_29_val = {
  "Semi-Persistent Scheduling - Supported",
  "Semi-Persistent Scheduling - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_30_val = {
  "Handover between FDD and TDD - Supported",
  "Handover between FDD and TDD - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_31_val = {
  "Mechanisms defined for cells broadcasting multi band information - Supported",
  "Mechanisms defined for cells broadcasting multi band information - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_32_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_33_val = {
  "Inter-RAT ANR features for UTRAN FDD - Supported",
  "Inter-RAT ANR features for UTRAN FDD - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_34_val = {
  "Inter-RAT ANR features for GERAN - Supported",
  "Inter-RAT ANR features for GERAN - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_35_val = {
  "Inter-RAT ANR features for 1xRTT - Supported",
  "Inter-RAT ANR features for 1xRTT - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_36_val = {
  "Inter-RAT ANR features for HRPD - Supported",
  "Inter-RAT ANR features for HRPD - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_37_val = {
  "Inter-RAT ANR features for UTRAN TDD - Supported",
  "Inter-RAT ANR features for UTRAN TDD - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_38_val = {
  "EUTRA RRC_CONNECTED to UTRA TDD CELL_DCH PS handover - Supported",
  "EUTRA RRC_CONNECTED to UTRA TDD CELL_DCH PS handover - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_39_val = {
  "UTRAN TDD measurements, reporting and measurement reporting event B2 in E-UTRA connected mode - Supported",
  "UTRAN TDD measurements, reporting and measurement reporting event B2 in E-UTRA connected mode - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_40_val = {
  "EUTRA RRC_CONNECTED to UTRA TDD CELL_DCH CS handover - Supported",
  "EUTRA RRC_CONNECTED to UTRA TDD CELL_DCH CS handover - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_41_val = {
  "Measurement reporting event: Event B1 - Neighbour > threshold for UTRAN FDD - Supported",
  "Measurement reporting event: Event B1 - Neighbour > threshold for UTRAN FDD - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_42_val = {
  "DCI format 3a - Supported",
  "DCI format 3a - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_43_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_44_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_45_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_46_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_47_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_48_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_49_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_50_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_51_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_52_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_53_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_54_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_55_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_56_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_57_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_58_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_59_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_60_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_61_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_62_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_63_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_64_val = {
  "Undefined - Supported",
  "Undefined - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_101_val = {
  "DMRS with OCC (orthogonal cover code) and SGH (sequence group hopping) disabling - Supported",
  "DMRS with OCC (orthogonal cover code) and SGH (sequence group hopping) disabling - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_102_val = {
  "Trigger type 1 SRS (aperiodic SRS) transmission (Up to X ports) - Supported",
  "Trigger type 1 SRS (aperiodic SRS) transmission (Up to X ports) - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_103_val = {
  "PDSCH TM9 when up to 4 CSI reference signal ports are configured - Supported",
  "PDSCH TM9 when up to 4 CSI reference signal ports are configured - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_104_val = {
  "PDSCH TM9 for TDD when 8 CSI reference signal ports are configured - Supported",
  "PDSCH TM9 for TDD when 8 CSI reference signal ports are configured - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_105_val = {
  "PUCCH RM2-0 when PDSCH TM9 is configured and RM2-1 when PDSCH TM9 and up to 4 CSI reference signal ports are configured - Supported",
  "PUCCH RM2-0 when PDSCH TM9 is configured and RM2-1 when PDSCH TM9 and up to 4 CSI reference signal ports are configured - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_106_val = {
  "PUCCH RM2-1 when PDSCH TM9 and 8 CSI reference signal ports are configured - Supported",
  "PUCCH RM2-1 when PDSCH TM9 and 8 CSI reference signal ports are configured - Not supported"
};
static const true_false_string lte_rrc_eutra_cap_feat_group_ind_107_val = {
  "PUSCH RM2-0 when PDSCH TM9 is configured and RM2-2 when PDSCH TM9 and up to 4 CSI reference signal ports are configured - Supported",
  "PUSCH RM2-0 when PDSCH TM9 is configured and RM2-2 when PDSCH TM9 and up to 4 CSI reference signal ports are configured - Not supported"
};
static const true_false_string lte_