/*
 * Declarations for MultiMedia-REGistration
 *
 * Copyright (C) 1999 Eric Pouech
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __WIDL__

#ifndef __WINE_MMREG_H
#define __WINE_MMREG_H

#include "wine/winheader_enter.h"

#include <pshpack1.h>

/***********************************************************************
 * Defines/Enums
 */

#ifndef _ACM_WAVEFILTER
#define _ACM_WAVEFILTER

#define WAVE_FILTER_UNKNOWN     0x0000
#define WAVE_FILTER_DEVELOPMENT 0xFFFF

typedef struct _WAVEFILTER {
  DWORD   cbStruct;
  DWORD   dwFilterTag;
  DWORD   fdwFilter;
  DWORD   dwReserved[5];
} WAVEFILTER, *PWAVEFILTER, *NPWAVEFILTER, *LPWAVEFILTER;
#endif /* _ACM_WAVEFILTER */

#ifndef WAVE_FILTER_VOLUME
#define WAVE_FILTER_VOLUME      0x0001

typedef struct _WAVEFILTER_VOLUME {
   WAVEFILTER      wfltr;
   DWORD           dwVolume;
} VOLUMEWAVEFILTER, *PVOLUMEWAVEFILTER, *NPVOLUMEWAVEFILTER, *LPVOLUMEWAVEFILTER;
#endif  /* WAVE_FILTER_VOLUME */

#ifndef WAVE_FILTER_ECHO
#define WAVE_FILTER_ECHO        0x0002

typedef struct WAVEFILTER_ECHO {
   WAVEFILTER      wfltr;
   DWORD           dwVolume;
   DWORD           dwDelay;
} ECHOWAVEFILTER, *PECHOWAVEFILTER, *NPECHOWAVEFILTER, *LPECHOWAVEFILTER;
#endif  /* WAVEFILTER_ECHO */

#ifndef _WAVEFORMATEX_
#define _WAVEFORMATEX_
typedef struct _WAVEFORMATEX {
  WORD   wFormatTag;
  WORD   nChannels;
  DWORD  nSamplesPerSec;
  DWORD  nAvgBytesPerSec;
  WORD   nBlockAlign;
  WORD   wBitsPerSample;
  WORD   cbSize;
} WAVEFORMATEX, *PWAVEFORMATEX, *NPWAVEFORMATEX, *LPWAVEFORMATEX;
#endif /* _WAVEFORMATEX_ */

#ifndef  WAVE_FORMAT_PCM
typedef struct waveformat_tag {
  WORD    wFormatTag;
  WORD    nChannels;
  DWORD   nSamplesPerSec;
  DWORD   nAvgBytesPerSec;
  WORD    nBlockAlign;
} WAVEFORMAT, *PWAVEFORMAT, *NPWAVEFORMAT, *LPWAVEFORMAT;

typedef struct pcmwaveformat_tag {
  WAVEFORMAT  wf;
  WORD        wBitsPerSample;
} PCMWAVEFORMAT, *PPCMWAVEFORMAT, *NPPCMWAVEFORMAT, *LPPCMWAVEFORMAT;
#endif /* WAVE_FORMAT_PCM */

/* WAVE form wFormatTag IDs */
#define  WAVE_FORMAT_UNKNOWN			0x0000	/*  Microsoft Corporation  */
#ifndef  WAVE_FORMAT_PCM
#define  WAVE_FORMAT_PCM			0x0001
#endif
#define  WAVE_FORMAT_ADPCM			0x0002	/*  Microsoft Corporation  */
#define  WAVE_FORMAT_IEEE_FLOAT			0x0003	/*  Microsoft Corporation  */
#define  WAVE_FORMAT_VSELP			0x0004
#define  WAVE_FORMAT_IBM_CVSD			0x0005	/*  IBM Corporation  */
#define  WAVE_FORMAT_ALAW			0x0006	/*  Microsoft Corporation  */
#define  WAVE_FORMAT_MULAW			0x0007	/*  Microsoft Corporation  */
#define  WAVE_FORMAT_DTS			0x0008
#define  WAVE_FORMAT_DRM			0x0009
#define  WAVE_FORMAT_WMAVOICE9			0x000a
#define  WAVE_FORMAT_OKI_ADPCM			0x0010	/*  OKI  */
#define  WAVE_FORMAT_DVI_ADPCM			0x0011	/*  Intel Corporation  */
#define  WAVE_FORMAT_IMA_ADPCM			(WAVE_FORMAT_DVI_ADPCM)	/*  Intel Corporation  */
#define  WAVE_FORMAT_MEDIASPACE_ADPCM		0x0012	/*  Videologic  */
#define  WAVE_FORMAT_SIERRA_ADPCM		0x0013	/*  Sierra Semiconductor Corp  */
#define  WAVE_FORMAT_G723_ADPCM			0x0014	/*  Antex Electronics Corporation  */
#define  WAVE_FORMAT_DIGISTD			0x0015	/*  DSP Solutions, Inc.  */
#define  WAVE_FORMAT_DIGIFIX			0x0016	/*  DSP Solutions, Inc.  */
#define  WAVE_FORMAT_DIALOGIC_OKI_ADPCM		0x0017	/*  Dialogic Corporation  */
#define  WAVE_FORMAT_MEDIAVISION_ADPCM		0x0018
#define  WAVE_FORMAT_CU_CODEC			0x0019
#define  WAVE_FORMAT_HP_DYN_VOICE		0x001a
#define  WAVE_FORMAT_YAMAHA_ADPCM		0x0020	/*  Yamaha Corporation of America  */
#define  WAVE_FORMAT_SONARC			0x0021	/*  Speech Compression  */
#define  WAVE_FORMAT_DSPGROUP_TRUESPEECH	0x0022	/*  DSP Group, Inc  */
#define  WAVE_FORMAT_ECHOSC1			0x0023	/*  Echo Speech Corporation  */
#define  WAVE_FORMAT_AUDIOFILE_AF36		0x0024	/*    */
#define  WAVE_FORMAT_APTX			0x0025	/*  Audio Processing Technology  */
#define  WAVE_FORMAT_AUDIOFILE_AF10		0x0026	/*    */
#define  WAVE_FORMAT_PROSODY_1612		0x0027
#define  WAVE_FORMAT_LRC			0x0028
#define  WAVE_FORMAT_DOLBY_AC2			0x0030	/*  Dolby Laboratories  */
#define  WAVE_FORMAT_GSM610			0x0031	/*  Microsoft Corporation  */
#define  WAVE_FORMAT_MSNAUDIO			0x0032
#define  WAVE_FORMAT_ANTEX_ADPCME		0x0033	/*  Antex Electronics Corporation  */
#define  WAVE_FORMAT_CONTROL_RES_VQLPC		0x0034	/*  Control Resources Limited  */
#define  WAVE_FORMAT_DIGIREAL			0x0035	/*  DSP Solutions, Inc.  */
#define  WAVE_FORMAT_DIGIADPCM			0x0036	/*  DSP Solutions, Inc.  */
#define  WAVE_FORMAT_CONTROL_RES_CR10		0x0037	/*  Control Resources Limited  */
#define  WAVE_FORMAT_NMS_VBXADPCM		0x0038	/*  Natural MicroSystems  */
#define  WAVE_FORMAT_CS_IMAADPCM		0x0039
#define  WAVE_FORMAT_ECHOSC3			0x003a
#define  WAVE_FORMAT_ROCKWELL_ADPCM		0x003b
#define  WAVE_FORMAT_ROCKWELL_DIGITALK		0x003c
#define  WAVE_FORMAT_XEBEC			0x003d
#define  WAVE_FORMAT_G721_ADPCM			0x0040	/*  Antex Electronics Corporation  */
#define  WAVE_FORMAT_G728_CELP			0x0041
#define  WAVE_FORMAT_MSG723			0x0042
#define  WAVE_FORMAT_INTEL_G723_1		0x0043
#define  WAVE_FORMAT_INTEL_G729			0x0044
#define  WAVE_FORMAT_SHARP_G726			0x0045
#define  WAVE_FORMAT_MPEG			0x0050	/*  Microsoft Corporation  */
#define  WAVE_FORMAT_RT24			0x0052
#define  WAVE_FORMAT_PAC			0x0053
#define  WAVE_FORMAT_MPEGLAYER3			0x0055
#define  WAVE_FORMAT_LUCENT_G723		0x0059
#define  WAVE_FORMAT_CIRRUS			0x0060
#define  WAVE_FORMAT_ESPCM			0x0061
#define  WAVE_FORMAT_VOXWARE			0x0062
#define  WAVE_FORMAT_CANOPUS_ATRAC		0x0063
#define  WAVE_FORMAT_G726_ADPCM			0x0064
#define  WAVE_FORMAT_G722_ADPCM			0x0065
#define  WAVE_FORMAT_DSAT			0x0066
#define  WAVE_FORMAT_DSAT_DISPLAY		0x0067
#define  WAVE_FORMAT_VOXWARE_BYTE_ALIGNED	0x0069
#define  WAVE_FORMAT_VOXWARE_AC8		0x0070
#define  WAVE_FORMAT_VOXWARE_AC10		0x0071
#define  WAVE_FORMAT_VOXWARE_AC16		0x0072
#define  WAVE_FORMAT_VOXWARE_AC20		0x0073
#define  WAVE_FORMAT_VOXWARE_RT24		0x0074
#define  WAVE_FORMAT_VOXWARE_RT29		0x0075
#define  WAVE_FORMAT_VOXWARE_RT29HW		0x0076
#define  WAVE_FORMAT_VOXWARE_VR12		0x0077
#define  WAVE_FORMAT_VOXWARE_VR18		0x0078
#define  WAVE_FORMAT_VOXWARE_TQ40		0x0079
#define  WAVE_FORMAT_VOXWARE_SC3		0x007a
#define  WAVE_FORMAT_VOXWARE_SC3_1		0x007b
#define  WAVE_FORMAT_SOFTSOUND			0x0080
#define  WAVE_FORMAT_VOXWARE_TQ60		0x0081
#define  WAVE_FORMAT_MSRT24			0x0082  /*  Microsoft Corporation */
#define  WAVE_FORMAT_G729A			0x0083
#define  WAVE_FORMAT_MVI_MVI2			0x0084
#define  WAVE_FORMAT_DF_G726			0x0085
#define  WAVE_FORMAT_DF_GSM610			0x0086
#define  WAVE_FORMAT_ISIAUDIO			0x0088
#define  WAVE_FORMAT_ONLIVE			0x0089
#define  WAVE_FORMAT_MULTITUDE_FT_SX20		0x008a
#define  WAVE_FORMAT_INFOCOM_ITS_G721_ADPCM	0x008b
#define  WAVE_FORMAT_CONVEDIA_G729		0x008c
#define  WAVE_FORMAT_CONGRUENCY			0x008d
#define  WAVE_FORMAT_SBC24			0x0091
#define  WAVE_FORMAT_DOLBY_AC3_SPDIF		0x0092
#define  WAVE_FORMAT_MEDIASONIC_G723		0x0093
#define  WAVE_FORMAT_PROSODY_8KBPS		0x0094
#define  WAVE_FORMAT_ZYXEL_ADPCM		0x0097
#define  WAVE_FORMAT_PHILIPS_LPCBB		0x0098
#define  WAVE_FORMAT_PACKED			0x0099
#define  WAVE_FORMAT_MALDEN_PHONYTALK		0x00a0
#define  WAVE_FORMAT_RACAL_RECORDER_GSM		0x00a1
#define  WAVE_FORMAT_RACAL_RECORDER_G720_A	0x00a2
#define  WAVE_FORMAT_RACAL_RECORDER_G723_1	0x00a3
#define  WAVE_FORMAT_RACAL_RECORDER_TETRA_ACELP	0x00a4
#define  WAVE_FORMAT_NEC_AAC			0x00b0
#define  WAVE_FORMAT_RAW_AAC1			0x00ff
#define  WAVE_FORMAT_RHETOREX_ADPCM		0x0100
#define  WAVE_FORMAT_IRAT			0x0101
#define  WAVE_FORMAT_VIVO_G723			0x0111
#define  WAVE_FORMAT_VIVO_SIREN			0x0112
#define  WAVE_FORMAT_PHILIPS_CELP		0x0120
#define  WAVE_FORMAT_PHILIPS_GRUNDIG		0x0121
#define  WAVE_FORMAT_DIGITAL_G723		0x0123
#define  WAVE_FORMAT_SANYO_LD_ADPCM		0x0125
#define  WAVE_FORMAT_SIPROLAB_ACEPLNET		0x0130
#define  WAVE_FORMAT_SIPROLAB_ACELP4800		0x0131
#define  WAVE_FORMAT_SIPROLAB_ACELP8V3		0x0132
#define  WAVE_FORMAT_SIPROLAB_G729		0x0133
#define  WAVE_FORMAT_SIPROLAB_G729A		0x0134
#define  WAVE_FORMAT_SIPROLAB_KELVIN		0x0135
#define  WAVE_FORMAT_VOICEAGE_AMR		0x0136
#define  WAVE_FORMAT_G726ADPCM			0x0140
#define  WAVE_FORMAT_DICTAPHONE_CELP68		0x0141
#define  WAVE_FORMAT_DICTAPHONE_CELP54		0x0142
#define  WAVE_FORMAT_QUALCOMM_PUREVOICE		0x0150
#define  WAVE_FORMAT_QUALCOMM_HALFRATE		0x0151
#define  WAVE_FORMAT_TUBGSM			0x0155
#define  WAVE_FORMAT_MSAUDIO1			0x0160
#define  WAVE_FORMAT_WMAUDIO2			0x0161
#define  WAVE_FORMAT_WMAUDIO3			0x0162
#define  WAVE_FORMAT_WMAUDIO_LOSSLESS		0x0163
#define  WAVE_FORMAT_WMASPDIF			0x0164
#define  WAVE_FORMAT_UNISYS_NAP_ADPCM		0x0170
#define  WAVE_FORMAT_UNISYS_NAP_ULAW		0x0171
#define  WAVE_FORMAT_UNISYS_NAP_ALAW		0x0172
#define  WAVE_FORMAT_UNISYS_NAP_16K		0x0173
#define  WAVE_FORMAT_SYCOM_ACM_SYC008		0x0174
#define  WAVE_FORMAT_SYCOM_ACM_SYC701_G726L	0x0175
#define  WAVE_FORMAT_SYCOM_ACM_SYC701_CELP54	0x0176
#define  WAVE_FORMAT_SYCOM_ACM_SYC701_CELP68	0x0177
#define  WAVE_FORMAT_KNOWLEDGE_ADVENTURE_ADPCM	0x0178
#define  WAVE_FORMAT_FRAUNHOFER_IIS_MPEG2_AAC	0x0180
#define  WAVE_FORMAT_DTS_DS			0x0190
#define  WAVE_FORMAT_CREATIVE_ADPCM		0x0200	/*  Creative Labs, Inc  */
#define  WAVE_FORMAT_CREATIVE_FASTSPEECH8	0x0202	/*  Creative Labs, Inc  */
#define  WAVE_FORMAT_CREATIVE_FASTSPEECH10	0x0203	/*  Creative Labs, Inc  */
#define  WAVE_FORMAT_UHER_ADPCM			0x0210
#define  WAVE_FORMAT_ULEAD_DV_AUDIO		0x0215
#define  WAVE_FORMAT_ULEAD_DV_AUDIO_1		0x0216
#define  WAVE_FORMAT_QUARTERDECK		0x0220
#define  WAVE_FORMAT_ILINK_VC			0x0230
#define  WAVE_FORMAT_RAW_SPORT			0x0240
#define  WAVE_FORMAT_ESST_AC3			0x0241
#define  WAVE_FORMAT_GENERIC_PASSTHRU		0x0249
#define  WAVE_FORMAT_IPI_HSX			0x0250
#define  WAVE_FORMAT_IPI_RPELP			0x0251
#define  WAVE_FORMAT_CS2			0x0260
#define  WAVE_FORMAT_SONY_SCX			0x0270
#define  WAVE_FORMAT_SONY_SCY			0x0271
#define  WAVE_FORMAT_SONY_ATRAC3		0x0272
#define  WAVE_FORMAT_SONY_SPC			0x0273
#define  WAVE_FORMAT_TELUM_AUDIO		0x0280
#define  WAVE_FORMAT_TELUM_IA_AUDIO		0x0281
#define  WAVE_FORMAT_NORCOM_VOICE_SYSTEMS_ADPCM	0x0285
#define  WAVE_FORMAT_FM_TOWNS_SND		0x0300	/*  Fujitsu Corp.  */
#define  WAVE_FORMAT_MICRONAS			0x0350
#define  WAVE_FORMAT_MICRONAS_CELP833		0x0351
#define  WAVE_FORMAT_BTV_DIGITAL		0x0400
#define  WAVE_FORMAT_INTEL_MUSIC_CODER		0x0401
#define  WAVE_FORMAT_INDEO_AUDIO		0x0402
#define  WAVE_FORMAT_QDESIGN_MUSIC		0x0450
#define  WAVE_FORMAT_ON2_VP7_AUDIO		0x0500
#define  WAVE_FORMAT_ON2_VP6_AUDIO		0x0501
#define  WAVE_FORMAT_VME_VMPCM			0x0680
#define  WAVE_FORMAT_TPC			0x0681
#define  WAVE_FORMAT_LIGHTWAVE_LOSSLESS		0x08ae
#define  WAVE_FORMAT_OLIGSM			0x1000	/*  Ing C. Olivetti & C., S.p.A.  */
#define  WAVE_FORMAT_OLIADPCM			0x1001	/*  Ing C. Olivetti & C., S.p.A.  */
#define  WAVE_FORMAT_OLICELP			0x1002	/*  Ing C. Olivetti & C., S.p.A.  */
#define  WAVE_FORMAT_OLISBC			0x1003	/*  Ing C. Olivetti & C., S.p.A.  */
#define  WAVE_FORMAT_OLIOPR			0x1004	/*  Ing C. Olivetti & C., S.p.A.  */
#define  WAVE_FORMAT_LH_CODEC			0x1100
#define  WAVE_FORMAT_LH_CODEC_CELP		0x1101
#define  WAVE_FORMAT_LH_CODEC_SBC8		0x1102
#define  WAVE_FORMAT_LH_CODEC_SBC12		0x1103
#define  WAVE_FORMAT_LH_CODEC_SBC16		0x1104
#define  WAVE_FORMAT_NORRIS			0x1400
#define  WAVE_FORMAT_ISIAUDIO_2			0x1401
#define  WAVE_FORMAT_SOUNDSPACE_MUSICOMPRESS	0x1500
#define  WAVE_FORMAT_MPEG_ADTS_AAC		0x1600
#define  WAVE_FORMAT_MPEG_RAW_AAC		0x1601
#define  WAVE_FORMAT_MPEG_LOAS			0x1602
#define  WAVE_FORMAT_NOKIA_MPEG_ADTS_AAC	0x1608
#define  WAVE_FORMAT_NOKIA_MPEG_RAW_AAC		0x1609
#define  WAVE_FORMAT_VODAFONE_MPEG_ADTS_AAC	0x160a
#define  WAVE_FORMAT_VODAFONE_MPEG_RAW_AAC	0x160b
#define  WAVE_FORMAT_MPEG_HEAAC			0x1610
#define  WAVE_FORMAT_VOXWARE_RT24_SPEECH	0x181c
#define  WAVE_FORMAT_SONICFOUNDRY_LOSSLESS	0x1971
#define  WAVE_FORMAT_INNINGS_TELECOM_ADPCM	0x1979
#define  WAVE_FORMAT_LUCENT_SX8300P		0x1c07
#define  WAVE_FORMAT_LUCENT_SX5363S		0x1c0c
#define  WAVE_FORMAT_CUSEEME			0x1f03
#define  WAVE_FORMAT_NTCSOFT_ALF2CM_ACM		0x1fc4
#define  WAVE_FORMAT_DVM			0x2000
#define  WAVE_FORMAT_DTS2			0x2001
#define  WAVE_FORMAT_MAKEAVIS			0x3313
#define  WAVE_FORMAT_DIVIO_MPEG4_AAC		0x4143
#define  WAVE_FORMAT_NOKIA_ADAPTIVE_MULTIRATE	0x4201
#define  WAVE_FORMAT_DIVIO_G726			0x4243
#define  WAVE_FORMAT_LEAD_SPEECH		0x434c
#define  WAVE_FORMAT_LEAD_VORBIS		0x564c
#define  WAVE_FORMAT_WAVPACK_AUDIO		0x5756
#define  WAVE_FORMAT_ALAC			0x6c61
#define  WAVE_FORMAT_OGG_VORBIS_MODE_1		0x674f
#define  WAVE_FORMAT_OGG_VORBIS_MODE_2		0x6750
#define  WAVE_FORMAT_OGG_VORBIS_MODE_3		0x6751
#define  WAVE_FORMAT_OGG_VORBIS_MODE_1_PLUS	0x676f
#define  WAVE_FORMAT_OGG_VORBIS_MODE_2_PLUS	0x6770
#define  WAVE_FORMAT_OGG_VORBIS_MODE_3_PLUS	0x6771
#define  WAVE_FORMAT_3COM_NBX			0x7000
#define  WAVE_FORMAT_OPUS			0x704f
#define  WAVE_FORMAT_FAAD_AAC			0x706d
#define  WAVE_FORMAT_AMR_NB			0x7361
#define  WAVE_FORMAT_AMR_WB			0x7362
#define  WAVE_FORMAT_AMR_WP			0x7363
#define  WAVE_FORMAT_GSM_AMR_CBR		0x7a21
#define  WAVE_FORMAT_GSM_AMR_VBR_SID		0x7a22
#define  WAVE_FORMAT_COMVERSE_INFOSYS_G723_1	0xa100
#define  WAVE_FORMAT_COMVERSE_INFOSYS_AVQSBC	0xa101
#define  WAVE_FORMAT_COMVERSE_INFOSYS_SBC	0xa102
#define  WAVE_FORMAT_SYMBOL_G729_A		0xa103
#define  WAVE_FORMAT_VOICEAGE_AMR_WB		0xa104
#define  WAVE_FORMAT_INGENIENT_G726		0xa105
#define  WAVE_FORMAT_MPEG4_AAC			0xa106
#define  WAVE_FORMAT_ENCORE_G726		0xa107
#define  WAVE_FORMAT_ZOLL_ASAO			0xa108
#define  WAVE_FORMAT_SPEEX_VOICE		0xa109
#define  WAVE_FORMAT_VIANIX_MASC		0xa10a
#define  WAVE_FORMAT_WM9_SPECTRUM_ANALYZER	0xa10b
#define  WAVE_FORMAT_WMF_SPECTRUM_ANAYZER	0xa10c
#define  WAVE_FORMAT_GSM_610			0xa10d
#define  WAVE_FORMAT_GSM_620			0xa10e
#define  WAVE_FORMAT_GSM_660			0xa10f
#define  WAVE_FORMAT_GSM_690			0xa110
#define  WAVE_FORMAT_GSM_ADAPTIVE_MULTIRATE_WB	0xa111
#define  WAVE_FORMAT_POLYCOM_G722		0xa112
#define  WAVE_FORMAT_POLYCOM_G728		0xa113
#define  WAVE_FORMAT_POLYCOM_G729_A		0xa114
#define  WAVE_FORMAT_POLYCOM_SIREN		0xa115
#define  WAVE_FORMAT_GLOBAL_IP_ILBC		0xa116
#define  WAVE_FORMAT_RADIOTIME_TIME_SHIFT_RADIO	0xa117
#define  WAVE_FORMAT_NICE_ACA			0xa118
#define  WAVE_FORMAT_NICE_ADPCM			0xa119
#define  WAVE_FORMAT_VOCORD_G721		0xa11a
#define  WAVE_FORMAT_VOCORD_G726		0xa11b
#define  WAVE_FORMAT_VOCORD_G722_1		0xa11c
#define  WAVE_FORMAT_VOCORD_G728		0xa11d
#define  WAVE_FORMAT_VOCORD_G729		0xa11e
#define  WAVE_FORMAT_VOCORD_G729_A		0xa11f
#define  WAVE_FORMAT_VOCORD_G723_1		0xa120
#define  WAVE_FORMAT_VOCORD_LBC			0xa121
#define  WAVE_FORMAT_NICE_G728			0xa122
#define  WAVE_FORMAT_FRACE_TELECOM_G729		0xa123
#define  WAVE_FORMAT_CODIAN			0xa124
#define  WAVE_FORMAT_FLAC			0xf1ac
#if !defined(WAVE_FORMAT_EXTENSIBLE)
#define  WAVE_FORMAT_EXTENSIBLE			0xfffe  /* Microsoft */
#endif
#define WAVE_FORMAT_DEVELOPMENT			(0xffff)


#ifndef MM_MICROSOFT
#define MM_MICROSOFT 0x01
#endif
#define MM_MSFT_ACM_MSADPCM 0x21
#define MM_MSFT_ACM_IMAADPCM 0x22
#define MM_MSFT_ACM_GSM610 0x24
#define MM_MSFT_ACM_G711 0x25
#define MM_MSFT_ACM_PCM 0x26
#define MM_MSFT_ACM_WMAUDIO 39
#define MM_MSFT_ACM_MSAUDIO1 39
#define MM_MSFT_ACM_WMAUDIO2 101

#define MM_FRAUNHOFER_IIS 0xAC
#define MM_FHGIIS_MPEGLAYER3_DECODE 0x09
#define MM_FHGIIS_MPEGLAYER3_PROFESSIONAL 0x0d

typedef struct adpcmcoef_tag {
	short   iCoef1;
	short   iCoef2;
} ADPCMCOEFSET;
typedef ADPCMCOEFSET *PADPCMCOEFSET,
	*NPADPCMCOEFSET, *LPADPCMCOEFSET;

typedef struct adpcmwaveformat_tag {
	WAVEFORMATEX    wfx;
	WORD            wSamplesPerBlock;
	WORD            wNumCoef;
	/* FIXME: this should be aCoef[0] */
	ADPCMCOEFSET    aCoef[1];
} ADPCMWAVEFORMAT;
typedef ADPCMWAVEFORMAT *PADPCMWAVEFORMAT,
	*NPADPCMWAVEFORMAT, *LPADPCMWAVEFORMAT;

typedef struct drmwaveformat_tag {
	WAVEFORMATEX    wfx;
	WORD            wReserved;
	ULONG           ulContentId;
	WAVEFORMATEX    wfxSecure;
} DRMWAVEFORMAT;
typedef DRMWAVEFORMAT *PDRMWAVEFORMAT, *NPDRMWAVEFORMAT,
	*LPDRMWAVEFORMAT;

typedef struct dvi_adpcmwaveformat_tag {
	WAVEFORMATEX    wfx;
	WORD            wSamplesPerBlock;
} DVIADPCMWAVEFORMAT;
typedef DVIADPCMWAVEFORMAT *PDVIADPCMWAVEFORMAT,
	*NPDVIADPCMWAVEFORMAT, *LPDVIADPCMWAVEFORMAT;

typedef struct ima_adpcmwaveformat_tag {
	WAVEFORMATEX    wfx;
	WORD            wSamplesPerBlock;
} IMAADPCMWAVEFORMAT;
typedef IMAADPCMWAVEFORMAT *PIMAADPCMWAVEFORMAT, *NPIMAADPCMWAVEFORMAT,
	*LPIMAADPCMWAVEFORMAT;

typedef struct mediaspace_adpcmwaveformat_tag {
	WAVEFORMATEX    wfx;
	WORD            wRevision;
} MEDIASPACEADPCMWAVEFORMAT;
typedef MEDIASPACEADPCMWAVEFORMAT *PMEDIASPACEADPCMWAVEFORMAT,
	*NPMEDIASPACEADPCMWAVEFORMAT, *LPMEDIASPACEADPCMWAVEFORMAT;

typedef struct sierra_adpcmwaveformat_tag {
	WAVEFORMATEX    wfx;
	WORD            wRevision;
} SIERRAADPCMWAVEFORMAT;
typedef SIERRAADPCMWAVEFORMAT *PSIERRAADPCMWAVEFORMAT,
	*NPSIERRAADPCMWAVEFORMAT, *LPSIERRAADPCMWAVEFORMAT;

typedef struct g723_adpcmwaveformat_tag {
	WAVEFORMATEX    wfx;
	WORD            cbExtraSize;
	WORD            nAuxBlockSize;
} G723_ADPCMWAVEFORMAT;
typedef G723_ADPCMWAVEFORMAT *PG723_ADPCMWAVEFORMAT,
	*NPG723_ADPCMWAVEFORMAT, *LPG723_ADPCMWAVEFORMAT;

typedef struct digistdwaveformat_tag {
	WAVEFORMATEX    wfx;
} DIGISTDWAVEFORMAT;
typedef DIGISTDWAVEFORMAT *PDIGISTDWAVEFORMAT,
	*NPDIGISTDWAVEFORMAT, *LPDIGISTDWAVEFORMAT;

typedef struct digifixwaveformat_tag {
	WAVEFORMATEX    wfx;
} DIGIFIXWAVEFORMAT;
typedef DIGIFIXWAVEFORMAT *PDIGIFIXWAVEFORMAT,
	*NPDIGIFIXWAVEFORMAT, *LPDIGIFIXWAVEFORMAT;

typedef struct creative_fastspeechformat_tag {
	WAVEFORMATEX    ewf;
} DIALOGICOKIADPCMWAVEFORMAT;
typedef DIALOGICOKIADPCMWAVEFORMAT *PDIALOGICOKIADPCMWAVEFORMAT,
	*NPDIALOGICOKIADPCMWAVEFORMAT, *LPDIALOGICOKIADPCMWAVEFORMAT;

typedef struct yamaha_adpmcwaveformat_tag {
	WAVEFORMATEX    wfx;
} YAMAHA_ADPCMWAVEFORMAT;
typedef YAMAHA_ADPCMWAVEFORMAT *PYAMAHA_ADPCMWAVEFORMAT,
	*NPYAMAHA_ADPCMWAVEFORMAT, *LPYAMAHA_ADPCMWAVEFORMAT;

typedef struct sonarcwaveformat_tag {
	WAVEFORMATEX    wfx;
	WORD            wCompType;
} SONARCWAVEFORMAT;
typedef SONARCWAVEFORMAT *PSONARCWAVEFORMAT,
	*NPSONARCWAVEFORMAT,*LPSONARCWAVEFORMAT;

typedef struct truespeechwaveformat_tag {
	WAVEFORMATEX    wfx;
	WORD            wRevision;
	WORD            nSamplesPerBlock;
	BYTE            abReserved[28];
} TRUESPEECHWAVEFORMAT;
typedef TRUESPEECHWAVEFORMAT *PTRUESPEECHWAVEFORMAT,
	*NPTRUESPEECHWAVEFORMAT, *LPTRUESPEECHWAVEFORMAT;

typedef struct echosc1waveformat_tag {
	WAVEFORMATEX    wfx;
} ECHOSC1WAVEFORMAT;
typedef ECHOSC1WAVEFORMAT *PECHOSC1WAVEFORMAT,
	*NPECHOSC1WAVEFORMAT, *LPECHOSC1WAVEFORMAT;

typedef struct audiofile_af36waveformat_tag {
	WAVEFORMATEX    wfx;
} AUDIOFILE_AF36WAVEFORMAT;
typedef AUDIOFILE_AF36WAVEFORMAT *PAUDIOFILE_AF36WAVEFORMAT,
	*NPAUDIOFILE_AF36WAVEFORMAT, *LPAUDIOFILE_AF36WAVEFORMAT;

typedef struct aptxwaveformat_tag {
	WAVEFORMATEX    wfx;
} APTXWAVEFORMAT;
typedef APTXWAVEFORMAT *PAPTXWAVEFORMAT,
	*NPAPTXWAVEFORMAT, *LPAPTXWAVEFORMAT;

typedef struct audiofile_af10waveformat_tag {
	WAVEFORMATEX    wfx;
} AUDIOFILE_AF10WAVEFORMAT;
typedef AUDIOFILE_AF10WAVEFORMAT *PAUDIOFILE_AF10WAVEFORMAT,
	*NPAUDIOFILE_AF10WAVEFORMAT,  *LPAUDIOFILE_AF10WAVEFORMAT;

typedef struct dolbyac2waveformat_tag {
	WAVEFORMATEX    wfx;
	WORD            nAuxBitsCode;
} DOLBYAC2WAVEFORMAT;

typedef struct gsm610waveformat_tag {
	WAVEFORMATEX    wfx;
	WORD            wSamplesPerBlock;
} GSM610WAVEFORMAT;
typedef GSM610WAVEFORMAT *PGSM610WAVEFORMAT,
	*NPGSM610WAVEFORMAT, *LPGSM610WAVEFORMAT;

typedef struct adpcmewaveformat_tag {
	WAVEFORMATEX    wfx;
	WORD            wSamplesPerBlock;
} ADPCMEWAVEFORMAT;
typedef ADPCMEWAVEFORMAT *PADPCMEWAVEFORMAT,
	*NPADPCMEWAVEFORMAT, *LPADPCMEWAVEFORMAT;

typedef struct contres_vqlpcwaveformat_tag {
	WAVEFORMATEX    wfx;
	WORD            wSamplesPerBlock;
} CONTRESVQLPCWAVEFORMAT;
typedef CONTRESVQLPCWAVEFORMAT *PCONTRESVQLPCWAVEFORMAT,
	*NPCONTRESVQLPCWAVEFORMAT, *LPCONTRESVQLPCWAVEFORMAT;

typedef struct digirealwaveformat_tag {
	WAVEFORMATEX    wfx;
	WORD            wSamplesPerBlock;
} DIGIREALWAVEFORMAT;
typedef DIGIREALWAVEFORMAT *PDIGIREALWAVEFORMAT,
	*NPDIGIREALWAVEFORMAT, *LPDIGIREALWAVEFORMAT;

typedef struct digiadpcmmwaveformat_tag {
	WAVEFORMATEX    wfx;
	WORD            wSamplesPerBlock;
} DIGIADPCMWAVEFORMAT;
typedef DIGIADPCMWAVEFORMAT *PDIGIADPCMWAVEFORMAT,
	*NPDIGIADPCMWAVEFORMAT, *LPDIGIADPCMWAVEFORMAT;

typedef struct contres_cr10waveformat_tag {
	WAVEFORMATEX    wfx;
	WORD            wSamplesPerBlock;
} CONTRESCR10WAVEFORMAT;
typedef CONTRESCR10WAVEFORMAT *PCONTRESCR10WAVEFORMAT,
	*NPCONTRESCR10WAVEFORMAT, *LPCONTRESCR10WAVEFORMAT;

typedef struct nms_vbxadpcmmwaveformat_tag {
	WAVEFORMATEX    wfx;
	WORD            wSamplesPerBlock;
} NMS_VBXADPCMWAVEFORMAT;
typedef NMS_VBXADPCMWAVEFORMAT *PNMS_VBXADPCMWAVEFORMAT,
	*NPNMS_VBXADPCMWAVEFORMAT, *LPNMS_VBXADPCMWAVEFORMAT;

typedef struct g721_adpcmwaveformat_tag {
	WAVEFORMATEX    wfx;
	WORD            nAuxBlockSize;
} G721_ADPCMWAVEFORMAT;
typedef G721_ADPCMWAVEFORMAT *PG721_ADPCMWAVEFORMAT,
	*NG721_ADPCMWAVEFORMAT, *LPG721_ADPCMWAVEFORMAT;

typedef struct creative_adpcmwaveformat_tag {
	WAVEFORMATEX    wfx;
	WORD            wRevision;
} CREATIVEADPCMWAVEFORMAT;
typedef CREATIVEADPCMWAVEFORMAT *PCREATIVEADPCMWAVEFORMAT,
	*NPCREATIVEADPCMWAVEFORMAT, *LPCREATIVEADPCMWAVEFORMAT;

typedef struct creative_fastspeech8format_tag {
	WAVEFORMATEX    wfx;
	WORD wRevision;
} CREATIVEFASTSPEECH8WAVEFORMAT;
typedef CREATIVEFASTSPEECH8WAVEFORMAT *PCREATIVEFASTSPEECH8WAVEFORMAT,
	*NPCREATIVEFASTSPEECH8WAVEFORMAT, *LPCREATIVEFASTSPEECH8WAVEFORMAT;

typedef struct creative_fastspeech10format_tag {
	WAVEFORMATEX    wfx;
	WORD wRevision;
} CREATIVEFASTSPEECH10WAVEFORMAT;
typedef CREATIVEFASTSPEECH10WAVEFORMAT *PCREATIVEFASTSPEECH10WAVEFORMAT,
	*NPCREATIVEFASTSPEECH10WAVEFORMAT, *LPCREATIVEFASTSPEECH10WAVEFORMAT;

typedef struct fmtowns_snd_waveformat_tag {
	WAVEFORMATEX    wfx;
	WORD            wRevision;
} FMTOWNS_SND_WAVEFORMAT;
typedef FMTOWNS_SND_WAVEFORMAT *PFMTOWNS_SND_WAVEFORMAT,
	*NPFMTOWNS_SND_WAVEFORMAT, *LPFMTOWNS_SND_WAVEFORMAT;

typedef struct oligsmwaveformat_tag {
	WAVEFORMATEX    wfx;
} OLIGSMWAVEFORMAT;
typedef OLIGSMWAVEFORMAT *POLIGSMWAVEFORMAT,
	*NPOLIGSMWAVEFORMAT, *LPOLIGSMWAVEFORMAT;

typedef struct oliadpcmwaveformat_tag {
	WAVEFORMATEX    wfx;
} OLIADPCMWAVEFORMAT;
typedef OLIADPCMWAVEFORMAT *POLIADPCMWAVEFORMAT,
	*NPOLIADPCMWAVEFORMAT, *LPOLIADPCMWAVEFORMAT;

typedef struct olicelpwaveformat_tag {
	WAVEFORMATEX    wfx;
} OLICELPWAVEFORMAT;
typedef OLICELPWAVEFORMAT *POLICELPWAVEFORMAT,
	*NPOLICELPWAVEFORMAT, *LPOLICELPWAVEFORMAT;

typedef struct olisbcwaveformat_tag {
	WAVEFORMATEX    wfx;
} OLISBCWAVEFORMAT;
typedef OLISBCWAVEFORMAT *POLISBCWAVEFORMAT,
	*NPOLISBCWAVEFORMAT, *LPOLISBCWAVEFORMAT;

typedef struct olioprwaveformat_tag {
	WAVEFORMATEX    wfx;
} OLIOPRWAVEFORMAT;
typedef OLIOPRWAVEFORMAT *POLIOPRWAVEFORMAT,
	*NPOLIOPRWAVEFORMAT, *LPOLIOPRWAVEFORMAT;

typedef struct csimaadpcmwaveformat_tag {
	WAVEFORMATEX    wfx;
} CSIMAADPCMWAVEFORMAT;
typedef CSIMAADPCMWAVEFORMAT *PCSIMAADPCMWAVEFORMAT,
	*NPCSIMAADPCMWAVEFORMAT, *LPCSIMAADPCMWAVEFORMAT;

typedef struct mpeg1waveformat_tag {
	WAVEFORMATEX	wfx;
	WORD		fwHeadLayer;
	DWORD		dwHeadBitrate;
	WORD		fwHeadMode;
	WORD		fwHeadModeExt;
	WORD		wHeadEmphasis;
	WORD		fwHeadFlags;
	DWORD		dwPTSLow;
	DWORD		dwPTSHigh;
} MPEG1WAVEFORMAT;
typedef MPEG1WAVEFORMAT *PMPEG1WAVEFORMAT,
	*NPMPEG1WAVEFORMAT, *LPMPEG1WAVEFORMAT;

#define	ACM_MPEG_LAYER1		0x0001
#define	ACM_MPEG_LAYER2		0x0002
#define	ACM_MPEG_LAYER3		0x0004

#define	ACM_MPEG_STEREO		0x0001
#define	ACM_MPEG_JOINTSTEREO	0x0002
#define	ACM_MPEG_DUALCHANNEL	0x0004
#define	ACM_MPEG_SINGLECHANNEL	0x0008
#define	ACM_MPEG_PRIVATEBIT	0x0001
#define	ACM_MPEG_COPYRIGHT	0x0002
#define	ACM_MPEG_ORIGINALHOME	0x0004
#define	ACM_MPEG_PROTECTIONBIT	0x0008
#define	ACM_MPEG_ID_MPEG1	0x0010

typedef struct mpeglayer3waveformat_tag {
	WAVEFORMATEX	wfx;
	WORD		wID;
	DWORD		fdwFlags;
	WORD		nBlockSize;
	WORD		nFramesPerBlock;
	WORD		nCodecDelay;
} MPEGLAYER3WAVEFORMAT;
typedef MPEGLAYER3WAVEFORMAT *PMPEGLAYER3WAVEFORMAT,
	*NPMPEGLAYER3WAVEFORMAT, *LPMPEGLAYER3WAVEFORMAT;

#define MPEGLAYER3_WFX_EXTRA_BYTES   12

#define MPEGLAYER3_ID_UNKNOWN           0
#define MPEGLAYER3_ID_MPEG		1
#define MPEGLAYER3_ID_CONSTANTFRAMESIZE	2

#define MPEGLAYER3_FLAG_PADDING_ISO	0x00000000
#define MPEGLAYER3_FLAG_PADDING_ON	0x00000001
#define MPEGLAYER3_FLAG_PADDING_OFF	0x00000002

typedef struct msaudio1waveformat_tag {
	WAVEFORMATEX wfx;
	WORD         wSamplesPerBlock;
	WORD         wEncodeOptions;
} MSAUDIO1WAVEFORMAT, *LPMSAUDIO1WAVEFORMAT;

#define WMAUDIO_BITS_PER_SAMPLE 16
#define WMAUDIO_MAX_CHANNELS     2

#define MSAUDIO1_BITS_PER_SAMPLE     WMAUDIO_BITS_PER_SAMPLE
#define MSAUDIO1_MAX_CHANNELS        WMAUDIO_MAX_CHANNELS
#define MSAUDIO1_WFX_EXTRA_BYTES     (sizeof(MSAUDIO1WAVEFORMAT) - sizeof(WAVEFORMATEX))

typedef struct wmaudio2waveformat_tag {
	WAVEFORMATEX wfx;
	DWORD        dwSamplesPerBlock;
	WORD         wEncodeOptions;
	DWORD        dwSuperBlockAlign;
} WMAUDIO2WAVEFORMAT, *LPWMAUDIO2WAVEFORMAT;

#define WMAUDIO2_BITS_PER_SAMPLE     WMAUDIO_BITS_PER_SAMPLE
#define WMAUDIO2_MAX_CHANNELS        WMAUDIO_MAX_CHANNELS
#define WMAUDIO2_WFX_EXTRA_BYTES     (sizeof(WMAUDIO2WAVEFORMAT) - sizeof(WAVEFORMATEX))

typedef struct wmaudio3waveformat_tag {
	WAVEFORMATEX wfx;
	WORD         wValidBitsPerSample;
	DWORD        dwChannelMask;
	DWORD        dwReserved1;
	DWORD        dwReserved2;
	WORD         wEncodeOptions;
	WORD         wReserved3;
} WMAUDIO3WAVEFORMAT, *LPWMAUDIO3WAVEFORMAT;

#define WMAUDIO3_WFX_EXTRA_BYTES     (sizeof(WMAUDIO3WAVEFORMAT) - sizeof(WAVEFORMATEX))

#ifdef GUID_DEFINED

#ifndef _WAVEFORMATEXTENSIBLE_
#define _WAVEFORMATEXTENSIBLE_
typedef struct {
    WAVEFORMATEX    Format;
    union {
        WORD        wValidBitsPerSample;
        WORD        wSamplesPerBlock;
        WORD        wReserved;
    } Samples;
    DWORD           dwChannelMask;
    GUID            SubFormat;
} WAVEFORMATEXTENSIBLE, *PWAVEFORMATEXTENSIBLE;
#endif /* _WAVEFORMATEXTENSIBLE_ */

#endif /* GUID_DEFINED */

typedef WAVEFORMATEXTENSIBLE    WAVEFORMATPCMEX;
typedef WAVEFORMATPCMEX*        PWAVEFORMATPCMEX;
typedef WAVEFORMATPCMEX*        NPWAVEFORMATPCMEX;
typedef WAVEFORMATPCMEX*        LPWAVEFORMATPCMEX;

typedef WAVEFORMATEXTENSIBLE    WAVEFORMATIEEEFLOATEX;
typedef WAVEFORMATIEEEFLOATEX*  PWAVEFORMATIEEEFLOATEX;
typedef WAVEFORMATIEEEFLOATEX*  NPWAVEFORMATIEEEFLOATEX;
typedef WAVEFORMATIEEEFLOATEX*  LPWAVEFORMATIEEEFLOATEX;

#ifndef _SPEAKER_POSITIONS_
#define _SPEAKER_POSITIONS_

#define SPEAKER_FRONT_LEFT              0x00000001
#define SPEAKER_FRONT_RIGHT             0x00000002
#define SPEAKER_FRONT_CENTER            0x00000004
#define SPEAKER_LOW_FREQUENCY           0x00000008
#define SPEAKER_BACK_LEFT               0x00000010
#define SPEAKER_BACK_RIGHT              0x00000020
#define SPEAKER_FRONT_LEFT_OF_CENTER    0x00000040
#define SPEAKER_FRONT_RIGHT_OF_CENTER   0x00000080
#define SPEAKER_BACK_CENTER             0x00000100
#define SPEAKER_SIDE_LEFT               0x00000200
#define SPEAKER_SIDE_RIGHT              0x00000400
#define SPEAKER_TOP_CENTER              0x00000800
#define SPEAKER_TOP_FRONT_LEFT          0x00001000
#define SPEAKER_TOP_FRONT_CENTER        0x00002000
#define SPEAKER_TOP_FRONT_RIGHT         0x00004000
#define SPEAKER_TOP_BACK_LEFT           0x00008000
#define SPEAKER_TOP_BACK_CENTER         0x00010000
#define SPEAKER_TOP_BACK_RIGHT          0x00020000
#define SPEAKER_RESERVED                0x7FFC0000
#define SPEAKER_ALL                     0x80000000

#endif /* _SPEAKER_POSITIONS_ */

/* DIB stuff */

#ifndef BI_BITFIELDS
#define BI_BITFIELDS     3
#endif

#ifndef QUERYDIBSUPPORT
#define	QUERYDIBSUPPORT		3073
#define	QDI_SETDIBITS		1
#define	QDI_GETDIBITS		2
#define	QDI_DIBTOSCREEN		4
#define	QDI_STRETCHDIB		8
#endif

#ifndef NOBITMAP
typedef struct tagEXBMINFOHEADER {
    BITMAPINFOHEADER bmi;
    DWORD biExtDataOffset;
} EXBMINFOHEADER;
#endif


/* Video stuff */

#ifndef NONEWIC

#ifndef ICTYPE_VIDEO
#define ICTYPE_VIDEO		mmioFOURCC('v', 'i', 'd', 'c')
#define ICTYPE_AUDIO		mmioFOURCC('a', 'u', 'd', 'c')
#endif

#endif

#include <poppack.h>

#endif /* __WINE_MMREG_H */

#else /* __WIDL__ */

cpp_quote("#if 0")
#pragma pack(push, 1)

typedef struct tWAVEFORMATEX {
    WORD wFormatTag;
    WORD nChannels;
    DWORD nSamplesPerSec;
    DWORD nAvgBytesPerSec;
    WORD nBlockAlign;
    WORD wBitsPerSample;
    WORD cbSize;
    [size_is(cbSize)] BYTE pExtraBytes[];
} WAVEFORMATEX, *PWAVEFORMATEX, *NPWAVEFORMATEX, *LPWAVEFORMATEX;

typedef struct {
    WORD wFormatTag;
    WORD nChannels;
    DWORD nSamplesPerSec;
    DWORD nAvgBytesPerSec;
    WORD nBlockAlign;
    WORD wBitsPerSample;
    WORD cbSize;
    WORD wValidBitsPerSample;
    DWORD dwChannelMask;
    GUID SubFormat;
} WAVEFORMATEXTENSIBLE, *PWAVEFORMATEXTENSIBLE;

#pragma pack(pop)
cpp_quote("#endif")

#include "wine/winheader_exit.h"

#endif /* __WIDL__ */
