//
//  ITSwitch.h
//  ITSwitch-Demo
//
//  Created by Ilija Tovilo on 01/02/14.
//  Copyright (c) 2014 Ilija Tovilo. All rights reserved.
//

// Modifications for CodeWeavers:
// - add disabledTintColor
// - add -setChecked:animated:

#import <Cocoa/Cocoa.h>

NS_ASSUME_NONNULL_BEGIN

extern NSBindingName NSBindingNameChecked;

/**
 *  ITSwitch is a replica of UISwitch for Mac OS X
 */
IB_DESIGNABLE
@interface ITSwitch : NSControl

/**
 *  @property checked - Gets or sets the switch's state. Changes to this value are
 *  animated by default; use -setChecked:animated: for control over that behavior.
 */
@property (nonatomic, assign) IBInspectable BOOL checked;

/**
 *  Sets the @p checked property, optionally animating the change.
 */
- (void)setChecked:(BOOL)checked animated:(BOOL)animate;

/**
 *  @property tintColor - Gets or sets the switch's tint
 */
@property (nonatomic, strong, null_resettable) IBInspectable NSColor *tintColor;

/**
 *  @property tintColor - Gets or sets the tint of the disabled state.
 */
@property (nonatomic, strong, null_resettable) IBInspectable NSColor *disabledTintColor;

/**
 *  @property disabledBorderColor - Define the switch's border color for disabled state.
 */
@property (nonatomic, strong, null_resettable) IBInspectable NSColor *disabledBorderColor;

@end

NS_ASSUME_NONNULL_END
