<?php
$str = <<<EOD
=====Wikka Table Markup Guide=====
>>==See also:==
~-For earlier Wikka versions, check the [[Docs:TableActionInfo | table]] action
~-Updated versions of this page can be found on the [[Docs:TableMarkup | Wikka documentation server]] 
~-For a more formal description, check the document server [[Docs:TableMarkupReference TableMarkupReference]] page.
>>
As of ##1.2##, Wikka introduces a flexible markup for data tables. Any kind of tables allowed by XHTML can be created using this markup, from the most basic examples (e.g. simple rows of cells) to complex tables with full support for accessibility options.::c::

====1. Table basics: cells, rows, columns====

The most basic element of a table is a **cell**. Single cells can be created using the standard delimiter ##""||""##, e.g.:

##""||Hello||""##

||Hello||

Note that a cell must always be open and closed by delimiters. 

**Rows** can be created by adding on the same line multiple cells:

##""||Cell 1||Cell 2||Cell 3||""##

||Cell 1||Cell 2||Cell 3||

**Columns** can be created by adding rows on separate lines:

##""||Cell 1||""##
##""||Cell 2||""##
##""||Cell 3||""##

||Cell 1||
||Cell 2||
||Cell 3||

By now you should be able to create simple tables with **multiple rows and columns**.

##""||Cell 1||Cell 2||Cell 3||""##
##""||Cell 4||Cell 5||Cell 6||""##
##""||Cell 7||Cell 8||Cell 9||""##

||Cell 1||Cell 2||Cell 3||
||Cell 4||Cell 5||Cell 6||
||Cell 7||Cell 8||Cell 9||

====2. Headings====

As soon as you create slightly more complex data tables, you will need to specify column and row **headings**. Headings are special cells that specify what kind of data rows and columns contain. The most basic way of creating a heading is by using ##""|=|""## as a delimiter.

The following is an example of a simple table with **column headings**:

##""|=|Apples|=|Pears|=|""##
##""||300Kg||480Kg||""##

|=|Apples|=|Pears|=|
||300Kg||480Kg||

**Row headings** are created in the same way. Since they are usually followed by normal cells, they must be terminated with the ##""||""## standard delimiter if the next element in the row is a simple cell:

##""|=|Apples||300Kg||""##
##""|=|Pears||480Kg||""##

|=|Apples||300Kg||
|=|Pears||480Kg||

You should be able by now to create simple tables with row and column headings:

##""|=|       |=|Apples|=|Pears|=|""##
##""|=|Mary||300Kg||320Kg||""##
##""|=|John||400Kg||630Kg||""##

|=| |=|Apples|=|Pears|=|
|=|Mary||300Kg||320Kg||
|=|John||400Kg||630Kg||

We will describe later how to add accessibility parameters for row and column headings.

====3. Captions====

Usually tables are introduced with a caption that describes what the table contains. A caption element is introduced with a ##""|?|""## delimiter and terminated with a standard delimiter ##""||""##.

##""|?|Fruit production in 2006||""##
##""|=|       |=|Apples|=|Pears|=|""##
##""|=|Mary||300Kg||320Kg||""##
##""|=|John||400Kg||630Kg||""##

|?|Fruit production in 2006||
|=| |=|Apples|=|Pears|=|
|=|Mary||300Kg||320Kg||
|=|John||400Kg||630Kg||

====4. Spans====

**Spans** are used to combine multiple cells or multiple headings
vertically or horizontally and are created using the following
[[TableMarkupReference | attribute parameters]]:

##""||""(''span options'')Element content""||""##

A **cell spanning multiple columns** is generated by prefixing the cell content with a ##(x:''n'')## parameter, where ##''n''## is the number of columns to be spanned. The following example shows how to create a cell spanning two columns:

##""||(x:2)Cell spanning 2 columns||Cell 3||""##
##""||Cell 4||Cell 5||Cell 6||""##
##""||Cell 7||Cell 8||Cell 9||""##

||(x:2)Cell spanning 2 columns||Cell 3||
||Cell 4||Cell 5||Cell 6||
||Cell 7||Cell 8||Cell 9||

Spans can also be applied to rows. A **cell spanning multiple rows** is generated by prefixing the cell content with a ##(y:''n'')## parameter, where  ##''n''##  is the number of rows to be spanned. The following example shows how to create a cell spanning two rows:

##""||(y:2)Cell spanning 2 rows||Cell 2||Cell 3||""##
##""||Cell 5||Cell 6||""##
##""||Cell 7||Cell 8||Cell 9||""##

||(y:2)Cell spanning 2 rows||Cell 2||Cell 3||
||Cell 5||Cell 6||
||Cell 7||Cell 8||Cell 9||

Note that you must account for cells that are "pushed down" when using row spans:

##""|=|     |=|Mon|=|Tue|=|Wed|=|Thu|=|Fri|=|""##
##""|=|8-9  || ||(y:9) Outreach|| ||(y:9) Outreach|| ||""##
##""|=|9-10 || || || ||""## <-- reduced by two columns
##""|=|10-11|| || || ||""##
##""|=|11-12|| || || ||""##
##""|=|12-1 || || || ||""##
##""|=|1-2  || || || ||""##
##""|=|2-3  ||(y:3) CSCI 102 ||CSCI 101||CSCI 101||""##
##""|=|3-4  || || ||""## <-- reduced by one column
##""|=|4-5  || || ||""##

|=|     |=|Mon|=|Tue|=|Wed|=|Thu|=|Fri|=|
|=|8-9  || ||(y:9) Outreach|| ||(y:9) Outreach|| ||
|=|9-10 || || || ||
|=|10-11|| || || ||
|=|11-12|| || || ||
|=|12-1 || || || ||
|=|1-2  || || || ||
|=|2-3  ||(y:3) CSCI 102 ||CSCI 101||CSCI 101||
|=|3-4  || || ||
|=|4-5  || || ||


Spans are particularly useful to create **subheadings**:

##""|?|Fruit production in the last two years||""##
##""|=|       |=|(x:2)Apples|=|(x:2)Pears|=|""##
##""|=|       |=|2005|=|2006|=|2005|=|2006|=|""##
##""|=|Mary||300Kg||320Kg||400kg||280Kg||""##
##""|=|John||400Kg||630Kg||210Kg||300Kg||""##

|?|Fruit production in the last two years||
|=|       |=|(x:2)Apples|=|(x:2)Pears|=|
|=|       |=|2005|=|2006|=|2005|=|2006|=|
|=|Mary||300Kg||320Kg||400kg||280Kg||
|=|John||400Kg||630Kg||210Kg||300Kg||

Column and row spans can be combined to created funky table layouts:

##""||(x:2;y:2)2x2||(x:2)2x1||(y:2)1x2||""##
##""||(y:2)1x2||1x1||""##
##""||1x1||1x1||(x:2)2x1||""##

||(x:2;y:2)2x2||(x:2)2x1||(y:2)1x2||
||(y:2)1x2||1x1||
||1x1||1x1||(x:2)2x1||


====5. Formatting text within tables====

You can use any kind of basic [[Docs:TextFormatting | Wikka markup]] to render text within tables.
The following example adds basic formatting to cell content:

##""|?|Using text formatting within tables||""##
##""||##Monospaced##||//Italics//||**Bold**||__Underlined__||""##
##""||''Highlighted''||++Strikethrough++||(x:2)**//Bold italics//**||""##

|?|Using text formatting within tables||
||##Monospaced##||//Italics//||**Bold**||__Underlined__||
||''Highlighted''||++Strikethrough++||(x:2)**//Bold italics//**||

====6. Adding actions and images within tables====

Simple, content-generating [[Docs:UsingActions | actions]] (including
[[Docs:AddingImages | images]]) can be added within table cells and headings.

##""|?|Using actions within tables||""##
##""||This wiki contains {{countpages}} pages||""##
##""||{{image url="images/wikka_logo.jpg" class="center" alt="a w" title="w image"}}||""##
##""||{{color c="red" text="some colored text"}}||""##

|?|Using actions within tables||
||This wiki contains {{countpages}} pages||
||{{image url="images/wikka_logo.jpg" class="center" alt="a w" title="w image"}}||
||{{color c="red" text="some colored text"}}||

====7. Adding links within tables====

All the available options to create [[Docs:AddingLinks | links]] can be used within table cells or headings:

##""|?|Adding links within tables||""##
##""||Camelcase links: SandBox||""##
##""||Escaped camelcase links: &quot;&quot;SandBox&quot;&quot; escaped||""##
##""||Forced links: [[HomePage | main]]||""##
##""||Interwiki links: Wikipedia:Wikka||""##
##""||Forced interwiki links: [[Wikipedia:Wikka | Wikka article on Wikipedia]]||""##
##""||External links: http://www.example.com ||""##
##""||Forced external links: [[http://www.example.com | Example.com]]||""##
##""||Image links: {{image url="images/wizard.gif" alt="wizard" title="Display an index of pages on this wiki" link="PageIndex"}}||""##

|?|Adding links within tables||
||Camelcase links: SandBox||
||Escaped camelcase links: ""SandBox escaped""||
||Forced links: [[HomePage | main]]||
||Interwiki links: Wikipedia:Wikka||
||Forced interwiki links: [[Wikipedia:Wikka | Wikka article on Wikipedia]]||
||External links: http://www.example.com ||
||Forced external links: [[http://www.example.com | Example.com]]||
||Image links: {{image url="images/wizard.gif" alt="wizard" title="Display an index of pages on this wiki" link="PageIndex"}}||

====8. Adding HTML within tables====

You can also use [[Docs:UsingHTML | embedded HTML]] in table elements:

##""|?|Embedding HTML within tables||""##
##""||Here's some superscript: &quot;&quot;a&lt;sup&gt;2+1&lt;/sup&gt;&quot;&quot;||""##
##""||And here's some subscript too: &quot;&quot;a&lt;sub&gt;2k&lt;/sub&gt;&quot;&quot;||""##
##""||I love acronyms: &quot;&quot;&lt;acronym title="What You See Is What You Get"&gt;WYSIWYG&lt;/acronym&gt;&quot;&quot;||""##

|?|Embedding HTML within tables||
||Here's some superscript: ""a<sup>2+1</sup>""||
||And here's some subscript too: ""a<sub>2k</sub>""||
||I love acronyms: ""<acronym title="What You See Is What You Get">WYSIWYG</acronym>""||

====9. Adding a touch of style====

The table markup introduces a new [[TableMarkupReference | style selector]]. CSS style options can be added to any element by enclosing them within **single braces**, right before the element content, e.g.:
##""||""{''style options''}Element content""||""##

For example, to render a cell with **red background** and **white text color**, you can do the following:

##""||{background-color:red; color:white}Hello||""##

||{background-color:red; color:white}Hello||

You can play with **font size** and **text alignment**:

##""|?|Adding some more style||""##
##""||{font-size:190%; text-align:right}Please scale me!||""##
##""||{font-size:170%; text-align:right}Please scale me!||""##
##""||{font-size:150%; text-align:right}Please scale me!||""##
##""||{font-size:130%; text-align:right}Please scale me!||""##
##""||{font-size:110%; text-align:right}Please scale me!||""##
##""||{font-size:90%; text-align:right}Please scale me!||""##
##""||{font-size:70%; text-align:right}Please scale me!||""##

|?|Adding some more style||
||{font-size:190%; text-align:right}Please scale me!||
||{font-size:170%; text-align:right}Please scale me!||
||{font-size:150%; text-align:right}Please scale me!||
||{font-size:130%; text-align:right}Please scale me!||
||{font-size:110%; text-align:right}Please scale me!||
||{font-size:90%; text-align:right}Please scale me!||
||{font-size:70%; text-align:right}Please scale me!||

You can also apply style to **headings** and **captions**:

##""|?|{border:1px dotted red; color:red}Style can be applied anywhere||""##
##""|=|{color:#000; font-size:150%; font-style:italic; font-family:Georgia, Hoefler Text, Georgia, serif; font-weight:normal; line-height:150%}Emphemeral Quibus|=|""##
##""||Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Duis auctor auctor pede.||""##

|?|{border:1px dotted red; color:red}Style can be applied anywhere||
|=|{color:#000; font-size:150%; font-style:italic; font-family:Georgia, Hoefler Text, Georgia, serif; font-weight:normal; line-height:150%}Emphemeral Quibus|=|
||Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Duis auctor auctor pede.||

Please note that **style parameters should always follow attribute
parameters**, when both are specified for an element (see the
[[TableMarkupReference | table markup reference]]):

##""|?|Give priority||""##
##""||(x:2;y:2){background-color:pink}2x2||(x:2){background-color:lightblue}2x1||(y:2){background-color:lightyellow}1x2||""##
##""||(y:2){background-color:lightyellow}1x2||{background-color:#333;color:white}1x1||""##
##""||{background-color:lightblue}1x1||{background-color:#333;color:white}1x1||(x:2){background-color:pink}2x1||""##

|?|Give priority||
||(x:2;y:2){background-color:pink}2x2||(x:2){background-color:lightblue}2x1||(y:2){background-color:lightyellow}1x2||
||(y:2){background-color:lightyellow}1x2||{background-color:#333;color:white}1x1||
||{background-color:lightblue}1x1||{background-color:#333;color:white}1x1||(x:2){background-color:pink}2x1||

====10. Adding style through classes====

You can apply existing classes from your stylesheet to any element using the class parameter ##(c:''class'')##. Note that custom style declarations specified through braced markup override class attributes.

The following example applies to table cells two class selectors defined in the stylesheet. The third row shows how to override a class selector with custom style attributes:

##""|?|Using class selectors to add style to table elements||""##
##""||(c:highlight)This cell uses the ##.highlight## class||""##
##""||(c:smaller)This cell uses the ##.smaller## class||""##
##""||(c:smaller){font-size:150%}This cell uses the ##.smaller## class overridden by custom style settings||""##

|?|Using class selectors to add style to table elements||
||(c:highlight)This cell uses the ##.highlight## class||
||(c:smaller)This cell uses the ##.smaller## class||
||(c:smaller){font-size:150%}This cell uses a ##.smaller## class overridden by custom style settings||

====11. Global table attributes====

Table-level attributes can be specified by adding at the beginning of the table the following element: ##""|!|   ||""##, which is used as a container for global table attributes. For example, you can specify **global style options** for a table by adding them to this element:

##""|!|{border:3px solid blue; background-color: black; color: white; width: 300px; text-align: center}||""##
##""||Cell 1||""##
##""||Cell 2||""##
##""||Cell 3||""##

|!|{border:3px solid blue; background-color: black; color: white; width: 300px; text-align: center}||
||Cell 1||
||Cell 2||
||Cell 3||

====12. Referring to elements: the ##id## attribute====

##id## attributes are used to refer to unique elements in a page and to provide an anchor for styling and linking. You can specify an ##id## for any table element by using the ##(i:''id'')## parameter.

For example, the following markup creates a table with the ##id## "main_table" containing two cells with ##id##'s "cell_1" and "cell_2"

##""|!|(i:main_table)||""##
##""|?|Using id to refer to table elements||""##
##""||(i:cell_1)This cell can be referred to by using the ##cell_1## id||""##
##""||(i:cell_2)This cell can be referred to by using the ##cell_2## id||""##

|!|(i:main_table)||
|?|Using id to refer to table elements||
||(i:cell_1)This cell can be referred to by using the ##cell_1## id||
||(i:cell_2)This cell can be referred to by using the ##cell_2## id||

====13. Accessibility options: adding titles====

Any table element can be given a ##title## attribute to enhance its accessibility. Titles are typically displayed in graphical browsers by hovering over the corresponding element and are useful to display unobtrusive descriptions about specific elements. You can specify a ##title## for any table element by using the ##(t:''title'')## parameter.

The following example adds titles to several table elements (you can hover over the table to display them):

##""|!|(t:Comparative figures for fruit production in the last year){width: 350px}||""##
##""|?|Fruit production in 2006||""##
##""|=|       |=|(t:yearly production of apples)Apples|=|(t:yearly production of pears)Pears|=|""##
##""|=|(t:Mary's contribution to 2006 production)Mary||(t:Mary's production of apples in 2006){text-align:center}300Kg||(t:Mary's production of pears in 2006){text-align:center}320Kg||""##
##""|=|(t:John's contribution to 2006 production)John||(t:John's production of apples in 2006){text-align:center}400Kg||(t:John's production of pears in 2006){text-align:center}630Kg||""##

|!|(t:Comparative figures for fruit production in the last year){width: 350px}||
|?|Fruit production in 2006||
|=|       |=|(t:yearly production of apples)Apples|=|(t:yearly production of pears)Pears|=|
|=|(t:Mary's contribution to 2006 production)Mary||(t:Mary's production of apples in 2006){text-align:center}300Kg||(t:Mary's production of pears in 2006){text-align:center}320Kg||
|=|(t:John's contribution to 2006 production)John||(t:John's production of apples in 2006){text-align:center}400Kg||(t:John's production of pears in 2006){text-align:center}630Kg||

====14. Accessibility options: adding a summary====

Tables can take an optional ##summary## attribute to describe the purpose and/or structure of the table. The description provided by the summary attribute is particularly helpful to users of non-visual browsers. You can specify a summary by adding a ##(u:''Summary'')## parameter in the table global attributes.

For example, the following line:
##""|!|(u:This is a summary)||""##
will add to the table a ##summary## attribute with the value ##This is a summary##.

====15. Accessibility options: table head, table body and table foot====

Rows in a table can be grouped in a table head, table body and table foot. This division enables browsers to support scrolling of table bodies independently of the table head and foot. When long tables are printed, the table head and foot information may be repeated on each page that contains table data. The table head and table foot should contain information about the table's columns. The table body should contain rows of table data.

Wikka allows you to create groups of rows with special markers:
~- The ##""|[|""## marker groups the rows it precedes as a **table head** block;
~- The ##""|]|""## marker groups the rows it precedes as a **table foot** block;
~- The ##""|#|""## marker groups the rows it precedes as a **table body**;

The following example shows how to use these elements to create row groups. Note that Wikka uses different backgrounds to differentiate column headings in the table head and foot from row headings in the table body:

##""|!|(u:A table with summary, caption, head, foot and body){width: 400px}||""##
##""|?|Here's how you can group rows||""##
##""|[|""##
##""|=|Name|=|Place|=|Telephone||""##
##""|]|""##
##""|=|Name|=|Place|=|Telephone||""##
##""|#|""##
##""|=|John Smith||New York||555-1234||""##
##""|=|Jane Smith||Los Angeles||555-2345||""##
##""|=|John Doe||Unknown||Unknown||""##
##""|=|Jane Doe||Unknown||Unknown||""##

|!|(u:A table with summary, caption, head, foot and body){width: 400px}||
|?|Here's how you can group rows||
|[|
|=|Name|=|Place|=|Telephone||
|]|
|=|Name|=|Place|=|Telephone||
|#|
|=|John Smith||New York||555-1234||
|=|Jane Smith||Los Angeles||555-2345||
|=|John Doe||Unknown||Unknown||
|=|Jane Doe||Unknown||Unknown||

====16. Accessibility options: heading scope====

To be semantically correct and accessible to users with non-visual browsers, headings should contain scope attributes describing the cell range they refer to. 
~-Column heading scopes can be specified using the ##(o:col)## parameter in the corresponding column heading;
~-Row heading scopes can be specified using the ##(o:row)## parameter in the corresponding row heading;

The following example shows how to correctly add column and row scopes to a table to make it accessible:

##""|!|(u:The number of employees and the foundation year of some imaginary companies.)||""##
##""|?|Table 1: Company data||""##
##""|[|""##
##""|||=|(o:col)Employees|=|(o:col)Founded||""##
##""|#|""##
##""|=|(o:row)ACME Inc||1000||1947||""##
##""|=|(o:row)XYZ Corp||2000||1973||""##

|!|(u:The number of employees and the foundation year of some imaginary companies.)||
|?|Table 1: Company data||
|[|
|||=|(o:col)Employees|=|(o:col)Founded||
|#|
|=|(o:row)ACME Inc||1000||1947||
|=|(o:row)XYZ Corp||2000||1973||


----
CategoryWiki
EOD;
echo($str);
?>
