! WHIZARD 2.8.2 Oct 24 2019
!
! Copyright (C) 1999-2019 by
!     Wolfgang Kilian <kilian@physik.uni-siegen.de>
!     Thorsten Ohl <ohl@physik.uni-wuerzburg.de>
!     Juergen Reuter <juergen.reuter@desy.de>
!
!     with contributions from
!     cf. main AUTHORS file
!
! WHIZARD is free software; you can redistribute it and/or modify it
! under the terms of the GNU General Public License as published by
! the Free Software Foundation; either version 2, or (at your option)
! any later version.
!
! WHIZARD is distributed in the hope that it will be useful, but
! WITHOUT ANY WARRANTY; without even the implied warranty of
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
! GNU General Public License for more details.
!
! You should have received a copy of the GNU General Public License
! along with this program; if not, write to the Free Software
! Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! This file has been stripped of most comments.  For documentation, refer
! to the source 'whizard.nw'

module slha_interface_uti

  use iso_varying_string, string_t => varying_string
  use io_units
  use os_interface
  use parser
  use model_data
  use variables
  use models

  use slha_interface

  implicit none
  private

  public :: slha_1
  public :: slha_2

contains

  subroutine slha_1 (u)
    integer, intent(in) :: u
    type(os_data_t), pointer :: os_data => null ()
    type(parse_tree_t), pointer :: parse_tree => null ()
    integer :: u_file, iostat
    character(80) :: buffer
    character(*), parameter :: file_slha = "slha_test.dat"
    type(model_list_t) :: model_list
    type(model_t), pointer :: model => null ()

    write (u, "(A)")  "* Test output: SLHA Interface"
    write (u, "(A)")  "*   Purpose: test SLHA file reading and writing"
    write (u, "(A)")

    write (u, "(A)")  "* Initializing"
    write (u, "(A)")

    allocate (os_data)
    allocate (parse_tree)
    call os_data%init ()
    call syntax_model_file_init ()
    call model_list%read_model &
         (var_str("MSSM"), var_str("MSSM.mdl"), os_data, model)
    call syntax_slha_init ()

    write (u, "(A)")  "* Reading SLHA file sps1ap_decays.slha"
    write (u, "(A)")

    call slha_parse_file (var_str ("sps1ap_decays.slha"), os_data, parse_tree)

    write (u, "(A)")  "* Writing the parse tree:"
    write (u, "(A)")

    call parse_tree_write (parse_tree, u)

    write (u, "(A)")  "* Interpreting the parse tree"
    write (u, "(A)")

    call slha_interpret_parse_tree (parse_tree, model, &
         input=.true., spectrum=.true., decays=.true.)
    call parse_tree_final (parse_tree)

    write (u, "(A)")  "* Writing out the list of variables (reals only):"
    write (u, "(A)")

    call var_list_write (model%get_var_list_ptr (), &
         only_type = V_REAL, unit = u)

    write (u, "(A)")
    write (u, "(A)")  "* Writing SLHA output to '" // file_slha // "'"
    write (u, "(A)")

    call slha_write_file (var_str (file_slha), model, input=.true., &
         spectrum=.false., decays=.false.)
    u_file = free_unit ()
    open (u_file, file = file_slha, action = "read", status = "old")
    do
       read (u_file, "(A)", iostat = iostat)  buffer
       if (buffer(1:37) == "# Output generated by WHIZARD version") then
          buffer = "[...]"
       end if
       if (iostat /= 0)  exit
       write (u, "(A)") trim (buffer)
    end do
    close (u_file)

    write (u, "(A)")
    write (u, "(A)")  "* Cleanup"
    write (u, "(A)")

    call parse_tree_final (parse_tree)
    deallocate (parse_tree)
    deallocate (os_data)

    write (u, "(A)")  "* Test output end: slha_1"
    write (u, "(A)")

  end subroutine slha_1

  subroutine slha_2 (u)
    integer, intent(in) :: u
    type(var_list_t) :: var_list
    logical :: input, spectrum, decays

    write (u, "(A)")  "* Test output: slha_2"
    write (u, "(A)")  "*   Purpose: SLHA interface settings"
    write (u, "(A)")

    write (u, "(A)")  "* Default settings"
    write (u, "(A)")

    call var_list%init_defaults (0)
    call dispatch_slha (var_list, &
         input = input, spectrum = spectrum, decays = decays)

    write (u, "(A,1x,L1)")  " slha_read_input     =", input
    write (u, "(A,1x,L1)")  " slha_read_spectrum  =", spectrum
    write (u, "(A,1x,L1)")  " slha_read_decays    =", decays

    call var_list%final ()
    call var_list%init_defaults (0)

    write (u, "(A)")
    write (u, "(A)")  "* Set all entries to [false]"
    write (u, "(A)")

    call var_list%set_log (var_str ("?slha_read_input"), &
         .false., is_known = .true.)
    call var_list%set_log (var_str ("?slha_read_spectrum"), &
         .false., is_known = .true.)
    call var_list%set_log (var_str ("?slha_read_decays"), &
         .false., is_known = .true.)

    call dispatch_slha (var_list, &
         input = input, spectrum = spectrum, decays = decays)

    write (u, "(A,1x,L1)")  " slha_read_input     =", input
    write (u, "(A,1x,L1)")  " slha_read_spectrum  =", spectrum
    write (u, "(A,1x,L1)")  " slha_read_decays    =", decays

    call var_list%final ()

    write (u, "(A)")
    write (u, "(A)")  "* Test output end: slha_2"

  end subroutine slha_2


end module slha_interface_uti
