C----
C---- $Id: figfile.f,v 1.2 1995/11/10 14:16:19 hooft Exp $
C----
      SUBROUTINE STARTGROUP (I)
      INCLUDE       'SCATTER.INC'
      INTEGER       LOX, LOY, HIX, HIY, I

      IF (I.EQ.1) THEN
         CALL TOFIG (0.,0.,LOX,LOY)
         CALL TOFIG (WI+2*XMARG,HI+2*YMARG,HIX,HIY)
      ELSE
         CALL TOFIG (XMARG,YMARG,LOX,LOY)
         CALL TOFIG (WI+XMARG,HI+YMARG,HIX,HIY)
      END IF
      WRITE (2,1000) LOX,HIY,HIX,LOY
 1000 FORMAT ('6',4i6)
      RETURN
      END

      SUBROUTINE ENDGROUP
      WRITE (2,1000)
 1000 FORMAT ('-6')
      RETURN
      END

      SUBROUTINE TOFIG (X,Y,FIGX,FIGY)
      INCLUDE       'SCATTER.INC'
      REAL          X, Y
      INTEGER       FIGX, FIGY

      FIGX=NINT(1200.0*(X+XOFF)/2.54)
      FIGY=NINT((HI+2*YMARG-(Y-YOFF))*1200.0/2.54)

      RETURN
      END
      SUBROUTINE CENSTR (X,Y,STR)
      INCLUDE       'SCATTER.INC'
      REAL          X, Y
      CHARACTER*(*) STR
      INTEGER       LENSTR, FIGX, FIGY

      CALL TOFIG (X,Y,FIGX,FIGY)
      FIGY=FIGY+NINT(200*POSH)
      WRITE (2,1000) NINT(64*POSH),FIGX,FIGY,STR(1:LENSTR(STR))

 1000 FORMAT ('4 1 -1 0 0 0 ',I4,' 0.0 2 0 0 ',2I8,1X,A,'\\001')
      RETURN
      END
      SUBROUTINE LEFTSTR (X,Y,STR)
      INCLUDE       'SCATTER.INC'
      REAL          X, Y
      CHARACTER*(*) STR
      INTEGER       LENSTR, FIGX, FIGY

      CALL TOFIG (X,Y,FIGX,FIGY)
      WRITE (2,1000) NINT(64*POSH),FIGX,FIGY,STR(1:LENSTR(STR))

 1000 FORMAT ('4 0 -1 0 0 0 ',I4,' 0.0 2 0 0 ',2I8,1X,A,'\\001')
      RETURN
      END
      SUBROUTINE LEFTSTF (X,Y,STR,F)
      INCLUDE       'SCATTER.INC'
      REAL          X, Y, F
      CHARACTER*(*) STR
      INTEGER       FIGX, FIGY, LENSTR

      CALL TOFIG (X,Y,FIGX,FIGY)
      WRITE (2,1000) NINT(64*POSH),FIGX,FIGY,STR(1:LENSTR(STR)),F

 1000 FORMAT ('4 0 -1 0 0 0 ',I4,' 0.0 2 0 0 ',2I8,1X,
     +     A,1X,G10.4,'\\001')
      RETURN
      END
      SUBROUTINE LEFTSTI (X,Y,STR,I)
      INCLUDE       'SCATTER.INC'
      REAL          X, Y
      CHARACTER*(*) STR
      INTEGER       FIGX, FIGY, LENSTR, I

      CALL TOFIG (X,Y,FIGX,FIGY)
      WRITE (2,1000) NINT(64*POSH),FIGX,FIGY,STR(1:LENSTR(STR)),I

 1000 FORMAT ('4 0 -1 0 0 0 ',I4,' 0.0 2 0 0 ',2I8,1X,
     +     A,1X,I6,'\\001')
      RETURN
      END
      SUBROUTINE LEFTSTG (X,Y,STR,F,STR2,F2)
      INCLUDE       'SCATTER.INC'
      REAL          X, Y, F, F2
      CHARACTER*(*) STR, STR2
      INTEGER       FIGX, FIGY, LENSTR

      CALL TOFIG (X,Y,FIGX,FIGY)
      WRITE (2,1000) NINT(64*POSH),FIGX,FIGY,STR(1:LENSTR(STR)),F,
     +               STR2(1:LENSTR(STR2)),F2

 1000 FORMAT ('4 0 -1 0 0 0 ',I4,' 0.0 2 0 0 ',2I8,1X,
     +     A,1X,G10.4,A,1X,G10.4,'\\001')
      RETURN
      END
      SUBROUTINE UPSTR (X,Y,STR)
      INCLUDE       'SCATTER.INC'
      REAL          X, Y
      CHARACTER*(*) STR
      INTEGER       LENSTR, FIGX, FIGY

      CALL TOFIG (X,Y,FIGX,FIGY)
      WRITE (2,1000) NINT(64*POSH),FIGX,FIGY,STR(1:LENSTR(STR))

 1000 FORMAT ('4 0 -1 0 0 0 ',I4,' 1.5708 2 0 0 ',2I8,1X,A,'\\001')
      RETURN
      END

      SUBROUTINE CREATE_POSFILE
      INCLUDE      'SCATTER.INC'
      REAL         XPOS, YPOS
      INTEGER      LT, I, L, IL, LU
      CHARACTER*80 S
      CHARACTER*15 USER
      CHARACTER*19 DATETIME, DATESTR
      INTEGER      LENGTH, LENSTR

      CALL GETLOG (USER)
      LU=LENGTH(USER)
      PRINT*,'IN CREATE_POSFILE:',FILENAME2
      CALL SYSTEM ('ls -aC')
      
      IF (APPEND) THEN
         OPEN (UNIT=2,FILE=FILENAME2,STATUS='OLD',ACCESS='APPEND',
     +        ERR=9876)
      ELSE
         OPEN (UNIT=2,FILE=FILENAME2,STATUS='UNKNOWN',
     +        ERR=9875)
C----
C---- Write the fig file header.
C----
         IF (POSHI.GT.POSWI) THEN
            WRITE (2,299) 
         ELSE
            WRITE (2,201)
         END IF
 201     FORMAT ('#FIG 3.1'/'Landscape'/'Center'/'Metric'/'1200 2')
 299     FORMAT ('#FIG 3.1'/'Portrait'/'Center'/'Metric'/'1200 2')
      ENDIF


      WRITE (2,202) IPL
 202  FORMAT ('### Scatter plot number :',I3)
      CALL STARTGROUP (1)
      IF (NOTEXT) GOTO 6666
C----
C---- Text for the Y-axis
C----
      IF (THOR) THEN
         L=LENGTH(YTEKST)
         CALL LEFTSTR (1.2*XMARG,HI*0.97+YMARG,YTEKST(1:L+1)//SSCALY)
         CALL LEFTSTR (0.1*XMARG,       YMARG,SMINY)
         CALL LEFTSTR (0.1*XMARG,HI    +YMARG,SMAXY)
      ELSE
         L=LENGTH(YTEKST)
         CALL UPSTR (   0.5*XMARG,HI*0.2+YMARG,YTEKST(1:L+1)//SSCALY)
         CALL UPSTR (   0.5*XMARG,       YMARG,SMINY)
         CALL UPSTR (   0.5*XMARG,HI    +YMARG,SMAXY)
      ENDIF
C----
C---- Extra text strings given as options.
C----
      DO I=1,NZ
         CALL LEFTSTR (XMARG+XZ(I)*WI,YMARG+YZ(I)*HI,ZTEKST(I))
      ENDDO
C----
C---- The top title
C----
      DATESTR=DATETIME(0)
      IF (TITLE) THEN
         WRITE(S,'(I5)') NDATA
         LT=LENGTH(TEKST)
         IL=1+INDEX(FILENAME,'/')
         IF (LT.GT.0) THEN
            CALL CENSTR (XMARG+WI/2.0,HI+YMARG*1.5,
     +           USER(1:LU)//' - scatter - '//DATESTR//' - File: '//
     +           FILENAME(IL:LENSTR(FILENAME))//
     +           ' - N='//S(1:5)//' - '//TEKST(1:LT))
         ELSE
            CALL CENSTR (XMARG+WI/2.0,HI+YMARG*1.5,
     +           USER(1:LU)//' - scatter - '//DATESTR//' - File: '//
     +           FILENAME(IL:LENSTR(FILENAME))//
     +           ' - N='//S(1:5))
         ENDIF
      ENDIF
C----
C---- Text for the X axis
C----
      L=LENGTH(XTEKST)
      CALL CENSTR (XMARG+WI*0.5,YMARG*0.5,XTEKST(1:L+1)//SSCALX)
      CALL CENSTR (XMARG       ,YMARG*0.5,SMINX)
      CALL CENSTR (XMARG+WI    ,YMARG*0.5,SMAXX)

      IF (LSQ.EQ.1) THEN
         IF (B.LT.0) THEN
            XPOS=0.5
         ELSE
            XPOS=0.1
         END IF
         IF (REVX) XPOS=0.6-XPOS
         IF (REVY) XPOS=0.6-XPOS
         XPOS=XMARG+WI*XPOS
      ELSE
         XPOS=XMARG+WI*0.1
      END IF
      YPOS=HI
      DO I=1,NXLINES
         CALL LEFTSTR (XPOS,YPOS,XLINES(I))
         YPOS=YPOS-2.0*POSH
      ENDDO
 6666 CONTINUE
      RETURN
 9876 PRINT*,'Offending file=',FILENAME2
      STOP 'Cannot append to FIG file.'
 9875 STOP 'Cannot create FIG file.'
      END

      SUBROUTINE POSTER_POSITIONING
      INCLUDE    'SCATTER.INC'
      INTEGER    XP,YP

      POSHI=HI
      POSWI=WI
      HI=POSHI*(1-WIT)/NPLY
      WI=POSWI*(1-WIT)/NPLX
      XP=MOD(IPL-1,NPLX)
      YP=(IPL-1)/NPLX
      XOFF=XP*(POSWI/NPLX)
      YOFF=YP*(POSHI/NPLY)
      POSH=MIN(HI*WIT/2.,WI*WIT/2.)/3.0
      IF (POSH.GT.HI/20.) POSH=HI/10.
      IF (POSH.GT.WI/20.) POSH=WI/10.
      XMARG=WI*WIT/2.
      YMARG=HI*WIT/2.

      RETURN
      END

      INTEGER FUNCTION FIX(AA)
      INCLUDE 'SCATTER.INC'
      REAL AA
      FIX=NINT(SCALX*(AA-RMINX))
      RETURN
      END      

      INTEGER FUNCTION FISX(AA)
      INCLUDE 'SCATTER.INC'
      REAL AA
      FISX=NINT(SCALX*AA)
      RETURN
      END      

      INTEGER FUNCTION FISY(AA)
      INCLUDE 'SCATTER.INC'
      REAL AA
      FISY=NINT(SCALY*AA)
      RETURN
      END      

      INTEGER FUNCTION FIY(AA)
      INCLUDE 'SCATTER.INC'
      REAL AA
      FIY=NINT(SCALY*(AA-RMINY))
      RETURN
      END      

      INTEGER FUNCTION FIR(AA)
      INCLUDE 'SCATTER.INC'
      REAL AA
      FIR=NINT(SCALR*(AA-DMINR))
      RETURN
      END      

      SUBROUTINE INITSCAL
      INCLUDE 'SCATTER.INC'
      REAL IWI,IHI,IRA
      IWI=WI*1200/2.54
      IHI=HI*1200/2.54
      IRA=RM*1200/2.54
      IF (RMAXX.EQ.RMINX) THEN
        SCALX=1
      ELSE
        SCALX=IWI/(RMAXX-RMINX)
      ENDIF
      IF (RMAXY.EQ.RMINY) THEN
        SCALY=1
      ELSE
        SCALY=IHI/(RMAXY-RMINY)
      ENDIF
      IF (DMAXR.EQ.DMINR) THEN
        SCALR=IRA/RM
        DMINR=0.0
      ELSE
        SCALR=IRA/(DMAXR-DMINR)
      ENDIF
      RETURN
      END

      SUBROUTINE FIG_MOVE (X,Y)
      IMPLICIT   NONE
      INTEGER    X, Y, XX, YY, NUMBUF
      COMMON     /FIG/ XX(1000),YY(1000), NUMBUF
      DATA       NUMBUF /0/
      CALL       FIG_FLUSH
      NUMBUF=1
      XX(NUMBUF)=X
      YY(NUMBUF)=Y
      RETURN
      END

      SUBROUTINE FIG_DRAW (X,Y)
      IMPLICIT   NONE
      INTEGER    X, Y, XX, YY, NUMBUF
      COMMON     /FIG/ XX(1000),YY(1000), NUMBUF
      IF (NUMBUF.EQ.1000) CALL FIG_FLUSH
      NUMBUF=NUMBUF+1
      XX(NUMBUF)=X
      YY(NUMBUF)=Y
      RETURN
      END

      SUBROUTINE FIG_FLUSH
      INCLUDE    'SCATTER.INC'
      INTEGER    I, XX, YY, NUMBUF, LW
      COMMON     /FIG/ XX(1000),YY(1000), NUMBUF
      IF (NUMBUF.LE.1) RETURN
      LW=2
      IF (HI.LT.10.0) LW=1
      WRITE (2,1000) LW,NUMBUF
 1000 FORMAT ('2 1 0 ',i1,' -1 -1 0 -1 -1 0.0 0 0 0 0 0 ',i4)
      WRITE (2,1010) (NINT((XMARG+XOFF)*1200/2.54)+XX(I),
     +                NINT((HI+YMARG+YOFF)*1200/2.54)-YY(I),I=1,NUMBUF)
 1010 FORMAT (12I6)
      XX(1)=XX(NUMBUF)
      YY(1)=YY(NUMBUF)
      NUMBUF=1
      RETURN
      END

      SUBROUTINE CREATE_FIG
      INCLUDE 'SCATTER.INC'
      INTEGER  IX, IY, IRX, IRY, I, J, IHI, IWI, I1, I2,
     +         FIX, FIY, FIR, FISX, FISY, LDOTSTYLE
      REAL     XSTART, YSTART, XEND, YEND, XI, YI, VALUE, STEP,
     +         POLYNOME_VAL, FAC

      IF (HI/WI.LT.1) THEN
        IWI=10000.
        IHI=10000.*(HI/WI)
      ELSE
        IHI=10000.
        IWI=10000.*(WI/HI)
      ENDIF
      CALL STARTGROUP (2)
C----
C---- Draw axes into the file.
C----
      IF (PUB) THEN
         CALL FIG_MOVE (FIX(RMINX),FIY(RMAXY))
         CALL FIG_DRAW (FIX(RMINX),FIY(RMINY))
         CALL FIG_DRAW (FIX(RMAXX),FIY(RMINY))
C-------
C------- Axis partitioning
C-------
         I1=IFIX(DMINX/PSCALX+1000.99)-1000
         I2=IFIX(DMAXX/PSCALX+1000.01)-1000
         VALUE=I1*PSCALX
         STEP=PSCALX
         IF (I2-I1.LT.10) THEN
            FAC=10.0
            IF (XSIXTY) FAC=6.0
            STEP=STEP/FAC
            I1=IFIX(FAC*DMINX/PSCALX+1000.99)-1000
            I2=IFIX(FAC*DMAXX/PSCALX+1000.01)-1000
            VALUE=(I1/FAC)*PSCALX
         END IF
         DO I=I1,I2
            IF (SAMELENGTH) THEN
               CALL FIG_MOVE (FIX(VALUE),0)
               CALL FIG_DRAW (FIX(VALUE),NINT(5*HI))
            ELSE IF (.NOT.XSIXTY.AND.I/10*10.EQ.I) THEN
               CALL FIG_MOVE (FIX(VALUE),0)
               CALL FIG_DRAW (FIX(VALUE),NINT(12.5*HI))
            ELSE IF (XSIXTY.AND.I/6*6.EQ.I) THEN
               CALL FIG_MOVE (FIX(VALUE),0)
               CALL FIG_DRAW (FIX(VALUE),NINT(12.5*HI))
            ELSE IF (.NOT.XSIXTY.AND.I/5*5.EQ.I) THEN
               CALL FIG_MOVE (FIX(VALUE),0)
               CALL FIG_DRAW (FIX(VALUE),NINT(7.5*HI))
            ELSE IF (I2-I1.LT.50) THEN
               CALL FIG_MOVE (FIX(VALUE),0)
               CALL FIG_DRAW (FIX(VALUE),NINT(5*HI))
            END IF
            VALUE=VALUE+STEP
         END DO
         I1=IFIX(DMINY/PSCALY+1000.99)-1000
         I2=IFIX(DMAXY/PSCALY+1000.01)-1000
         VALUE=I1*PSCALY
         STEP=PSCALY
         IF (I2-I1.LT.10) THEN
            FAC=10.0
            IF (YSIXTY) FAC=6.0
            STEP=STEP/FAC
            I1=IFIX(FAC*DMINY/PSCALY+1000.99)-1000
            I2=IFIX(FAC*DMAXY/PSCALY+1000.01)-1000
            VALUE=(I1/FAC)*PSCALY
         END IF
         DO I=I1,I2
            IF (SAMELENGTH) THEN
               CALL FIG_MOVE (0,FIY(VALUE))
               CALL FIG_DRAW (NINT(5*HI),FIY(VALUE))
            ELSE IF (.NOT.YSIXTY.AND.I/10*10.EQ.I) THEN
               CALL FIG_MOVE (0,FIY(VALUE))
               CALL FIG_DRAW (NINT(12.5*HI),FIY(VALUE))
            ELSE IF (YSIXTY.AND.I/6*6.EQ.I) THEN
               CALL FIG_MOVE (0,FIY(VALUE))
               CALL FIG_DRAW (NINT(12.5*HI),FIY(VALUE))
            ELSE IF (.NOT.YSIXTY.AND.I/5*5.EQ.I) THEN
               CALL FIG_MOVE (0,FIY(VALUE))
               CALL FIG_DRAW (NINT(7.5*HI),FIY(VALUE))
            ELSE IF (I2-I1.LT.50) THEN
               CALL FIG_MOVE (0,FIY(VALUE))
               CALL FIG_DRAW (NINT(5*HI),FIY(VALUE))
            END IF
            VALUE=VALUE+STEP
         ENDDO
      ENDIF
C----
C---- Draw dots of scattered data into the fig file.
C----
      IF (TORSR) THEN
         DO I=1,NDATA
C----------
C---------- Is the point within the predefined plot range?
C----------
            DOTSTYLE=0
C----------
C---------- Determine which figure to use with torsion angle
C----------
            IF (ABS(DATAR(I)-60).LE.30) DOTSTYLE=1
            IF (ABS(DATAR(I)+60).LE.30) DOTSTYLE=2
            IF (ABS(DATAR(I)-180).LE.30) DOTSTYLE=3
            IF (ABS(DATAR(I)+180).LE.30) DOTSTYLE=3
            IRY=100*RAD
            IRX=IRY                   
            IF (NSDX.GT.0) IRX=ABS(FISX(DATASDX(I)))
            IF (NSDY.GT.0) IRY=ABS(FISY(DATASDY(I)))
            IX=FIX(DATAX(I))
            IY=FIY(DATAY(I))
            IF (DOTSTYLE.EQ.1) THEN
               CALL FIG_MOVE (IX-IRX,IY)
               CALL FIG_DRAW (IX+IRX,IY)
               CALL FIG_MOVE (IX,IY-IRY)
               CALL FIG_DRAW (IX,IY+IRY)
            ELSE IF (DOTSTYLE.EQ.2) THEN
               CALL FIG_MOVE (IX-IRX,IY)
               CALL FIG_DRAW (IX+IRX,IY)
            ELSE IF (DOTSTYLE.EQ.3) THEN
               CALL FIG_MOVE (IX-IRX,IY-IRY)
               CALL FIG_DRAW (IX+IRX,IY-IRY)
               CALL FIG_DRAW (IX+IRX,IY+IRY)
               CALL FIG_DRAW (IX-IRX,IY+IRY)
               CALL FIG_DRAW (IX-IRX,IY-IRY)
            END IF
         END DO
C----
C---- Plot secondary structure?
C----
      ELSE IF (SECSTR) THEN
         LDOTSTYLE=0
         DO I=1,NDATA
C----------
C---------- Determine which figure to use
C----------
            DOTSTYLE=NINT(DATAR(I))
            IF (DOTSTYLE.LT.1.OR.DOTSTYLE.GT.3) DOTSTYLE=3
            IRY=100*RAD
C----------
C---------- Assume that the width of the symbol should be 1.0 units X
C----------
            IRX=FIX(DATAX(I))-FIX(DATAX(I)-0.5)
            IF (NSDX.GT.0) IRX=ABS(FISX(DATASDX(I)))
            IF (NSDY.GT.0) IRY=ABS(FISY(DATASDY(I)))
            IX=FIX(DATAX(I))
            IY=FIY(DATAY(I))
C----------
C---------- Helix
C----------
            IF (DOTSTYLE.EQ.1) THEN
               IF (LDOTSTYLE.NE.1) THEN
                  CALL FIG_MOVE (IX-IRX,IY-IRY)
                  CALL FIG_DRAW (IX-IRX,IY+IRY)
               END IF
               CALL FIG_MOVE (IX-IRX,IY-IRY)
               CALL FIG_DRAW (IX+IRX,IY-IRY)
               CALL FIG_MOVE (IX-IRX,IY+IRY)
               CALL FIG_DRAW (IX+IRX,IY+IRY)
C----------
C---------- Strand
C----------
            ELSE IF (DOTSTYLE.EQ.2) THEN
               IF (LDOTSTYLE.EQ.1) THEN
                  CALL FIG_MOVE (IX-IRX,IY-IRY)
                  CALL FIG_DRAW (IX-IRX,IY+IRY)
               END IF
               IF (I/2*2.EQ.I) THEN
                  CALL FIG_MOVE (IX-IRX,IY)
                  CALL FIG_DRAW (IX,IY+IRY)
                  CALL FIG_DRAW (IX+IRX,IY)
               ELSE
                  CALL FIG_MOVE (IX-IRX,IY)
                  CALL FIG_DRAW (IX,IY-IRY)
                  CALL FIG_DRAW (IX+IRX,IY)
               END IF
C----------
C---------- Turn, Coil
C----------
            ELSE IF (DOTSTYLE.EQ.3) THEN
               IF (LDOTSTYLE.EQ.1) THEN
                  CALL FIG_MOVE (IX-IRX,IY-IRY)
                  CALL FIG_DRAW (IX-IRX,IY+IRY)
               END IF
               CALL FIG_MOVE (IX-IRX,IY)
               CALL FIG_DRAW (IX+IRX,IY)
            END IF
            LDOTSTYLE=DOTSTYLE
         END DO
      ELSE IF (DOTSTYLE.EQ.0) THEN
         CONTINUE
      ELSE
         DO I=1,NDATA,INTERVAL
            IF (NDOT.GT.0) THEN
               DOTSTYLE=DATADOT(I)
            END IF
            IRX=FIR(DATAR(I))
            IRY=IRX
            IF (NSDX.GT.0) IRX=ABS(FISX(DATASDX(I)))
            IF (NSDY.GT.0) IRY=ABS(FISY(DATASDY(I)))
            IX=FIX(DATAX(I))
            IY=FIY(DATAY(I))
            IF (DOTSTYLE.EQ.1) THEN
C-------------
C------------- +-sign
C-------------
               CALL FIG_MOVE (IX-IRX,IY)
               CALL FIG_DRAW (IX+IRX,IY)
               CALL FIG_MOVE (IX,IY-IRY)
               CALL FIG_DRAW (IX,IY+IRY)
            ELSE IF (DOTSTYLE.EQ.2) THEN
C-------------
C------------- X-SIGN
C-------------
               CALL FIG_MOVE (IX-IRX,IY-IRY)
               CALL FIG_DRAW (IX+IRX,IY+IRY)
               CALL FIG_MOVE (IX+IRX,IY-IRY)
               CALL FIG_DRAW (IX-IRX,IY+IRY)
            ELSE IF (DOTSTYLE.EQ.3) THEN
C-------------
C------------- SQUARE
C-------------
               CALL FIG_MOVE (IX-IRX,IY-IRY)
               CALL FIG_DRAW (IX+IRX,IY-IRY)
               CALL FIG_DRAW (IX+IRX,IY+IRY)
               CALL FIG_DRAW (IX-IRX,IY+IRY)
               CALL FIG_DRAW (IX-IRX,IY-IRY)
            ELSE IF (DOTSTYLE.EQ.4) THEN
C-------------
C-------------  DIAMOND
C-------------
               CALL FIG_MOVE (IX,IY-IRY)
               CALL FIG_DRAW (IX-IRX,IY)
               CALL FIG_DRAW (IX,IY+IRY)
               CALL FIG_DRAW (IX+IRX,IY)
               CALL FIG_DRAW (IX,IY-IRY)
            ELSE IF (DOTSTYLE.EQ.5) THEN
C-------------
C------------- Upright triangle
C-------------
               CALL FIG_MOVE (IX-IRX,IY-IRY)
               CALL FIG_DRAW (IX+IRX,IY-IRY)
               CALL FIG_DRAW (IX,IY+IRY)
               CALL FIG_DRAW (IX-IRX,IY-IRY)
            ELSE IF (DOTSTYLE.EQ.6) THEN
C-------------
C------------- Upside down triangle
C-------------
               CALL FIG_MOVE (IX-IRX,IY+IRY)
               CALL FIG_DRAW (IX+IRX,IY+IRY)
               CALL FIG_DRAW (IX,IY-IRY)
               CALL FIG_DRAW (IX-IRX,IY+IRY)
            END IF
         END DO
      END IF
C----
C---- Check spline fit, dimensioned at 8192 !
C----
      IF (DO_SPLINE.AND.NDATA.GT.8192) THEN
         LINESTYLE=1
         DO_SPLINE=.FALSE.
         WRITE(*,*) 'Spline interpolation not possible, too much data'
      END IF
C----
C---- draw lines of scattered data into FIG file
C----
      IF (LINESTYLE.EQ.0) THEN
         CONTINUE
      ELSE IF (DO_SPLINE) THEN
         CALL SPLINE (DATAX,DATAY,NDATA,1E30,1E30,TEMP)
         CALL FIG_MOVE (FIX(DATAX(1)),FIY(DATAY(1)))
         DO I=2,NDATA
            DO J=1,NSPLIN
               XI=DATAX(I-1)*((10-J)/10.0) + DATAX(I)*(J/10.0)
               CALL SPLINT (DATAX,DATAY,TEMP,NDATA,XI,YI)
               CALL FIG_DRAW (FIX(XI),FIY(YI))
            END DO
         END DO
      ELSE IF (POLYGRADE.GT.0) THEN
         STEP=(DMAXX-DMINX)/250
         XI=DMINX
         YI=POLYNOME_VAL(XI)
         CALL FIG_MOVE (FIX(XI),FIY(YI))
         DO I=1,250        
            XI=XI+STEP
            YI=POLYNOME_VAL(XI)
            CALL FIG_DRAW (FIX(XI),FIY(YI))
         END DO
      ELSE IF (LINESTYLE.EQ.1) THEN
         CALL FIG_MOVE (FIX(DATAX(1)),FIY(DATAY(1)))
         DO I=2,NDATA
            IF (((XMOD.GT.0).AND.
     +           (ABS(DATAX(I)-DATAX(I-1)).GT.XMOD/2)).OR.
     +           ((YMOD.GT.0).AND.
     +           (ABS(DATAY(I)-DATAY(I-1)).GT.YMOD/2))) THEN
               CALL FIG_MOVE (FIX(DATAX(I)),FIY(DATAY(I)))
            ELSE
               CALL FIG_DRAW (FIX(DATAX(I)),FIY(DATAY(I)))
            END IF
         END DO
      ELSE IF (LINESTYLE.EQ.2) THEN
C-------
C------- Reserved for histogram
C-------
         CONTINUE
      ELSE IF (LINESTYLE.EQ.-1) THEN
C-------
C------- Reserved for fit.
C-------
         CONTINUE
      ENDIF
C----
C---- Draw the extra lines requested into the file
C----
      DO I=1,EXTRALINE1
C-------
C------- Vertical lines
C-------
         IF (LINE1VAL(I).LE.DMAXX.AND.LINE1VAL(I).GE.DMINX) THEN
            XSTART=LINE1VAL(I)
            YSTART=DMINY
            XEND=LINE1VAL(I)
            YEND=DMAXY
            CALL FIG_MOVE (FIX(XSTART),FIY(YSTART))
            CALL FIG_DRAW (FIX(XEND),FIY(YEND))
         ENDIF
      ENDDO
      DO I=1,EXTRALINE2
C-------
C------- Horizontal lines
C-------
         IF (LINE2VAL(I).LE.DMAXY.AND.LINE2VAL(I).GE.DMINY) THEN
            XSTART=DMINX
            YSTART=LINE2VAL(I)
            XEND=DMAXX
            YEND=LINE2VAL(I)
            CALL FIG_MOVE(FIX(XSTART),FIY(YSTART))
            CALL FIG_DRAW(FIX(XEND),FIY(YEND))
         ENDIF
      ENDDO
      IF (EXTRALINE3) THEN
C-------
C------- Y=X line
C-------
         XSTART=MAX(DMINX,DMINY)
         YSTART=XSTART
         XEND=MIN(DMAXX,DMAXY)
         YEND=XEND
         CALL FIG_MOVE (FIX(XSTART),FIY(YSTART))
         CALL FIG_DRAW (FIX(XEND),FIY(YEND))
      ENDIF
      IF (EXTRALINE4) THEN
C-------
C------- Y=-X line
C-------
         XSTART=MAX(DMINX,-DMAXY)
         YSTART=-XSTART
         XEND=MIN(DMAXX,-DMINY)
         YEND=-XEND
         CALL FIG_MOVE (FIX(XSTART),FIY(YSTART))
         CALL FIG_DRAW (FIX(XEND),FIY(YEND))
      ENDIF
      IF (LSQL) THEN
         XSTART=DMINX
         YSTART=B*XSTART+A
         IF (YSTART.GT.DMAXY) THEN
            YSTART=DMAXY
            XSTART=(YSTART-A)/B
         ELSE IF (YSTART.LT.DMINY) THEN
            YSTART=DMINY
            XSTART=(YSTART-A)/B
         END IF
         XEND=DMAXX
         YEND=B*XEND+A
         IF (YEND.GT.DMAXY) THEN
            YEND=DMAXY
            XEND=(YEND-A)/B
         ELSE IF (YEND.LT.DMINY) THEN
            YEND=DMINY
            XEND=(YEND-A)/B
         END IF
         CALL FIG_MOVE (FIX(XSTART),FIY(YSTART))
         CALL FIG_DRAW (FIX(XEND),FIY(YEND))
      ENDIF
      CALL FIG_FLUSH
      CALL ENDGROUP
      CALL ENDGROUP
      CLOSE (2)
      RETURN
      END
