C-----------------------------------------------------------------------
      SUBROUTINE GAUSSLAT(JMAX,SLAT,WLAT)
C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C
C SUBPROGRAM:  GAUSSLAT   COMPUTE GAUSSIAN LATITUDES
C   PRGMMR: IREDELL       ORG: W/NMC23       DATE: 92-04-16
C
C ABSTRACT: COMPUTES COSINES OF COLATITUDE AND GAUSSIAN WEIGHTS
C   ON THE GAUSSIAN LATITUDES.  THE GAUSSIAN LATITUDES ARE AT
C   THE ZEROES OF THE LEGENDRE POLYNOMIAL OF THE GIVEN ORDER.
C
C PROGRAM HISTORY LOG:
C   92-04-16  IREDELL
C   97-10-20  IREDELL  INCREASED PRECISION
C 1999-08-18  IREDELL  CALLED SPLAT
C
C USAGE:    CALL GAUSSLAT(JMAX,SLAT,WLAT)
C
C   INPUT ARGUMENT LIST:
C     JMAX     - INPUT NUMBER OF LATITUDES.
C
C   OUTPUT ARGUMENT LIST:
C     SLAT     - REAL (K) COSINES OF COLATITUDE.
C     WLAT     - REAL (K) GAUSSIAN WEIGHTS.
C
C SUBPROGRAMS CALLED:
C   SPLAT        COMPUTE LATITUDE FUNCTIONS
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 77
C
C$$$
      REAL SLAT(JMAX),WLAT(JMAX)
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      CALL SPLAT(4,JMAX,SLAT,WLAT)
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      RETURN
      END
