#include <incu/time.hh>
#include <sstream>

std::ostream& incu::operator << (std::ostream& out, const incu::Time& t) {
  char buffer[80];
  struct tm tdata;
  localtime_r(&t.value, &tdata);
  size_t len = strftime(buffer, 80, "%c", &tdata);
  if(len) out.write(buffer, len);
  else throw std::runtime_error("Buffer overflow in date/time conversion");

  return out;
}

std::string incu::Time::format() const {
  std::ostringstream out;
  out << *this << std::ends;
  return out.str();
}
