#include "incu/syslogstream.hh"
#include <algorithm>
#include <syslog.h>

const int incu::SyslogBuf::AUTH = LOG_AUTH;
#ifdef LOG_AUTHPRIV
const int incu::SyslogBuf::AUTHPRIV = LOG_AUTHPRIV;
#else
const int incu::SyslogBuf::AUTHPRIV = LOG_AUTH;
#endif
const int incu::SyslogBuf::CRON = LOG_CRON;
const int incu::SyslogBuf::DAEMON = LOG_DAEMON;
#ifdef LOG_FTP
const int incu::SyslogBuf::FTP = LOG_FTP;
#else
const int incu::SyslogBuf::FTP = LOG_DAEMON;
#endif
const int incu::SyslogBuf::KERN = LOG_KERN;
const int incu::SyslogBuf::LPR = LOG_LPR;
const int incu::SyslogBuf::MAIL = LOG_MAIL;
const int incu::SyslogBuf::NEWS = LOG_NEWS;
#ifdef LOG_SECURITY
const int incu::SyslogBuf::SECURITY = LOG_SECURITY;
#else
const int incu::SyslogBuf::SECURITY = LOG_DAEMON;
#endif
const int incu::SyslogBuf::SYSLOG = LOG_SYSLOG;
const int incu::SyslogBuf::USER = LOG_USER;
const int incu::SyslogBuf::UUCP = LOG_UUCP;
const int incu::SyslogBuf::LOCAL0 = LOG_LOCAL0;
const int incu::SyslogBuf::LOCAL1 = LOG_LOCAL1;
const int incu::SyslogBuf::LOCAL2 = LOG_LOCAL2;
const int incu::SyslogBuf::LOCAL3 = LOG_LOCAL3;
const int incu::SyslogBuf::LOCAL4 = LOG_LOCAL4;
const int incu::SyslogBuf::LOCAL5 = LOG_LOCAL5;
const int incu::SyslogBuf::LOCAL6 = LOG_LOCAL6;
const int incu::SyslogBuf::LOCAL7 = LOG_LOCAL7;

incu::SyslogBuf::SyslogBuf(const std::string& ident, int facility, int logopt)
  : bufsize(1024), buffer(new char[bufsize+1])
{
  // It seems openlog use the pointer of the first param, not the value.
  // This memory is never deallocated ...
  const char* buf = strdup(ident.c_str());
  openlog(buf, logopt, facility);
//   cerr << "setp(" << (void*)buffer << ", " << (void*)(buffer+bufsize) << ")"
//        << endl;
  setp(buffer, buffer+bufsize);
}

incu::SyslogBuf::~SyslogBuf() {
  overflow('\n');
}

int incu::SyslogBuf::sync() {
  overflow(EOF);
  return 0;
}

int incu::SyslogBuf::overflow (int c) {
  char *endpos = pptr();
  
  if (c != EOF) {
    if(endpos <= buffer+bufsize)
      *(endpos++) = static_cast<char>(c);
  }
  
  char * startline = buffer;
  char * endline = std::find(startline, endpos, '\n');
  while(startline != endpos) {
    // Note; This escapes the data to avoid the encoding done by 98% of
    // syslog() and then calls syslog() ...  Todo: Log "directly"?
    std::string msg;
    for(char* s = startline; s != endline; ++s) {
      if(*s == '%') msg += "%%";
      else msg += *s;
    }
    if(!msg.empty())
      syslog(LOG_WARNING, msg.c_str());
    
    if(endline && *endline == '\n') ++endline;
    startline = std::find(endline, endpos, '\n');
  }
  int keep_num = endpos - endline;
  // Note: Beware of overlap on some systems ...
  memcpy(buffer, endline, keep_num);
  
  setp(buffer+keep_num, buffer+bufsize);
  return c;
}
