#include "incu/log.hh"
#include <syslog.h>
#include <vector>

class incu::Log::DeviceMgr {
public:
  void add(LogDevice* dev) {
    devices.push_back(dev);
  }
  void write(const std::string& msg) {
    for(std::vector<LogDevice*>::const_iterator d = devices.begin(); 
	d != devices.end(); ++d)
      (*d)->write(msg);
  }
private:
  std::vector<LogDevice*> devices;
};

incu::Log::DeviceMgr incu::Log::mgr;
incu::LogGrade incu::Log::silence = l_info;

incu::Log::~Log() {
  if(*this) {
    mgr.write(str());
  }
}

void
incu::Log::addDevice(LogDevice* dev) {
  mgr.add(dev);
}

const int incu::SysLog::AUTH = LOG_AUTH;
#ifdef LOG_AUTHPRIV
const int incu::SysLog::AUTHPRIV = LOG_AUTHPRIV;
#else
const int incu::SysLog::AUTHPRIV = LOG_AUTH;
#endif
const int incu::SysLog::CRON = LOG_CRON;
const int incu::SysLog::DAEMON = LOG_DAEMON;
#ifdef LOG_FTP
const int incu::SysLog::FTP = LOG_FTP;
#else
const int incu::SysLog::FTP = LOG_DAEMON;
#endif
const int incu::SysLog::KERN = LOG_KERN;
const int incu::SysLog::LPR = LOG_LPR;
const int incu::SysLog::MAIL = LOG_MAIL;
const int incu::SysLog::NEWS = LOG_NEWS;
#ifdef LOG_SECURITY
const int incu::SysLog::SECURITY = LOG_SECURITY;
#else
const int incu::SysLog::SECURITY = LOG_DAEMON;
#endif
const int incu::SysLog::SYSLOG = LOG_SYSLOG;
const int incu::SysLog::USER = LOG_USER;
const int incu::SysLog::UUCP = LOG_UUCP;
const int incu::SysLog::LOCAL0 = LOG_LOCAL0;
const int incu::SysLog::LOCAL1 = LOG_LOCAL1;
const int incu::SysLog::LOCAL2 = LOG_LOCAL2;
const int incu::SysLog::LOCAL3 = LOG_LOCAL3;
const int incu::SysLog::LOCAL4 = LOG_LOCAL4;
const int incu::SysLog::LOCAL5 = LOG_LOCAL5;
const int incu::SysLog::LOCAL6 = LOG_LOCAL6;
const int incu::SysLog::LOCAL7 = LOG_LOCAL7;

incu::SysLog::SysLog(const std::string& ident, int facility, int logopt) {
  // It seems openlog use the pointer of the first param, not the value.
  const char* buf = strdup(ident.c_str());
  openlog(buf, logopt, facility);
}

void
incu::SysLog::write(const std::string& msg) {
  syslog(LOG_WARNING, "%s", msg.c_str());
}
