#ifndef INCU_SYSTEM
#define INCU_SYSTEM
#include <sstream>

namespace incu {

  /**
   * Use an ostrstream to build a command line and then run it. run() returns
   * when the command is done.  Nothing special is done with standard input /
   * output by default.
   *
   * Example:
   *
   * System decodegraphic;
   * decodegraphic << "anytopnm " << options << ' ' << source
   *               << " >" destination;
   * if(!decodegraphic.run())
   *    cerr << "The decoding command returned non-zero." << endl;
   *
   * Here, both source and destination are suppoesed to be filenames, and
   * options is just another string.
   */
  class System : public std::ostringstream {
  public:
    /**
     * Run the built-up command.
     * Return the exit status of the command.
     * throw a runtime_error if system() failed to fork / waitpit, faild to
     * execute the shell, or if the shell exited abnormally.
     */
    int run();
  };

};

#endif // INCU_SYSTEM
