#ifndef INCU_SYSLOG
#define INCU_SYSLOG
#include <iostream>
#include <string>

namespace incu {

  class SyslogBuf : public std::streambuf {
  public:
    SyslogBuf(const std::string& ident, int facility = USER, int logopt = 0);
    virtual ~SyslogBuf();

    // Symbols to use for facility
    const static int AUTH, AUTHPRIV, CRON, DAEMON, FTP, KERN, LPR, MAIL, NEWS,
      SECURITY, SYSLOG, USER, UUCP, 
      LOCAL0, LOCAL1, LOCAL2, LOCAL3, LOCAL4, LOCAL5, LOCAL6, LOCAL7;
  protected:
    virtual int sync();
    virtual int overflow(int c);
    
  private:
    int bufsize;
    char *buffer;
  };

}
#endif
