#ifndef INCU_SOCKET
#define INCU_SOCKET
#include <netdb.h>		// Needed by <sys/socket.h> on some systems
#include <sys/types.h>		// Needed by <sys/socket.h> on some systems
#include <sys/socket.h>
#include <netinet/in.h>
#include <incu/error.hh>
#include <iostream>

namespace incu {

  class SockaddrIn {
  public:
    SockaddrIn() {
      memset(&sin, 0, sizeof(sin));
      // Todo: This is only needed in special cases (not when using bind or
      // connect), and e.g. Solaris don't have sin_len.  But in some
      // occasions, maybe I should set sin_len?
      // sin.sin_len= sizeof(sin);
      sin.sin_family = AF_INET;
    }
    SockaddrIn& port(short p) {
      sin.sin_port = htons(p);
      return *this;
    }
    SockaddrIn& addr(long a) {
      sin.sin_addr.s_addr = htonl(a);
      return *this;
    }
    SockaddrIn& addr(const std::string& a);

    const struct sockaddr* data() const {
      return reinterpret_cast<const struct sockaddr*>(&sin);
    }
    int size() const { return sizeof(sin); }

    friend std::ostream& operator << (std::ostream&, const SockaddrIn&);
  private:
    struct sockaddr_in sin;
  };
  
  class Socket {
  public:
    Socket(int domain, int type, const char* protocol);
    ~Socket() { close(); }

    void close();

    void bind(const SockaddrIn& sa) {
      if(::bind(serv_sock, sa.data(), sa.size()) < 0)
	throw c_error("Cannot bind socket");
    }
    void listen(int backlog) {
      if(::listen(serv_sock, backlog) < 0)
	throw c_error("Cannot listen to socket");
    }
    void connect(const SockaddrIn& addr) {
      if(::connect(serv_sock, addr.data(), addr.size()) != 0)
	throw c_error("Failed to connect");
    }

    // deprecated - use the filebuffs to create streams instead
    int fd() const { return serv_sock; }

    // These buffers will be deleted when the Socket is closed!
    // Be sure to be rid of all streams using them before that!
    std::streambuf* getInBuf();
    std::streambuf* getOutBuf();
    std::streambuf* getIOBuf();
  private:
    int serv_sock;
    std::streambuf* iobuf;
    std::streambuf* inbuf;
    std::streambuf* outbuf;
  };
  
}

#endif // INCU_SOCKET
